<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit; 
}

$key = get_option('r3d_key');
?>
<div class="wrap">
    <h1><?php _e('License Settings', 'real3d-flipbook'); ?></h1>
    <p><?php _e("This page allows you to activate or deactivate your Real3D Flipbook license. Please enter your Envato purchase code to activate your license. If you don't know where to find your purchase code, see the instructions below.", 'real3d-flipbook'); ?></p>
    <table class="form-table">
        <tr valign="top">
            <th scope="row"><?php _e('Envato Purchase Code', 'real3d-flipbook'); ?></th>
            <td>
                <input type="text" id="envato_purchase_license" name="envato_purchase_license" value="<?php echo esc_attr( $key ); ?>" style="width: 300px;" />
                <input type="button" disabled id="verify-license" class="button button-primary" value="<?php _e('Activate', 'real3d-flipbook'); ?>" style="<?php echo empty($key) ? '' : 'display: none;'; ?>" />
                <input type="button" id="deactivate" class="button button-primary" value="<?php _e('Deactivate', 'real3d-flipbook'); ?>" style="<?php echo !empty($key) ? '' : 'display: none;'; ?>" />
            </td>
        </tr>
    </table>
    <div>
        <h2><?php _e('Where to Find Your Envato Purchase Code', 'real3d-flipbook'); ?></h2>
        <ol>
            <li><?php _e('Log in to your Envato Market account.', 'real3d-flipbook'); ?></li>
            <li><?php _e('Hover over your username at the top of the screen.', 'real3d-flipbook'); ?></li>
            <li><?php _e('Click \'Downloads\' from the drop-down menu.', 'real3d-flipbook'); ?></li>
            <li><?php _e('Find the Real3D Flipbook item and click \'License certificate & purchase code\' (available as PDF or text file).', 'real3d-flipbook'); ?></li>
        </ol>
    </div>
</div>
<?php
wp_enqueue_script("real3d-flipbook-license", $this->PLUGIN_DIR_URL."js/license.js", array('jquery'),$this->PLUGIN_VERSION);
$r3d_nonce = wp_create_nonce( "r3d_nonce");
wp_localize_script( 'real3d-flipbook-license', 'r3d_ajax', array($r3d_nonce, $key) );
?>
