(function (document, window, $) {
	if ( parent.wgextra )
		wgextra = parent.wgextra;
	if ( parent.wp )
		wp = parent.wp;

	// Simple $.escapeSelector polyfill (for jQuery prior v3)
	if ( !$.escapeSelector ) {
		$.escapeSelector = function( sel ) {
			var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;
			var fcssescape = function( ch, asCodePoint ) {
				if ( asCodePoint ) {
					// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
					if ( ch === "\0" ) {
						return "\uFFFD";
					}

					// Control characters and (dependent upon position) numbers get escaped as code points
					return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
				}

				// Other potentially-special ASCII characters get backslash-escaped
				return "\\" + ch;
			};

			return ( sel + "" ).replace( rcssescape, fcssescape );
		};
	}

	function isEmpty( val ) {
		if ( val === undefined )
			return true;

		if ( typeof val == 'function' || typeof val == 'number' || typeof val == 'boolean' || Object.prototype.toString.call( val ) === '[object Date]' )
			return false;

		// null or 0 length array
		if ( val == null || val.length === 0)
			return true;

		// empty object
		if ( typeof val == "object" && Object.keys( val ).length === 0 )
			return true;

		return false;
	}

	function cleanObject( obj ) {
		Object.keys( obj ).forEach( function( key ) {
			if ( Object.prototype.toString.call( obj[key] ) === '[object Object]' && !isEmpty( obj[key] ) ) cleanObject( obj[key] );
			if ( isEmpty( obj[key] ) ) delete obj[key];
		} );

		return obj;
	};

	// Find elements with cache feature
	var $FIND = (function($) {
		var DOMCACHESTORE = {};

		return function(selector, force) {
			if (DOMCACHESTORE[selector] === undefined || force)
				DOMCACHESTORE[selector] = $(selector);
			return DOMCACHESTORE[selector];
		}
	})($);

	var $doc = $(document),
		$win = $(window),
		$html = $(document.documentElement),
		$body = $(document.body);

	var hasDuplicate, sortInput;
	var origHash = location.hash;
	var currentHash = null;
	var scrollTop = null;
	var scrollLeft = null;
	var browser = {};
	var transform, gpuAcceleration;
	var lastDisp = 'desktop';
	var processedCrops = [];

	// Throtlling the history change
	var timerID = null;

	/* Video Sites */
	var videoSites = wp.hooks.applyFilters( 'wgextra-video-sites-support', {
		youtube : {
			matcher : /(youtube\.com|youtu\.be|youtube\-nocookie\.com)\/(watch\?(.*&)?v=|v\/|u\/|embed\/?)?(videoseries\?list=(.*)|[\w-]{11}|\?listType=(.*)&list=(.*))(.*)/i,
			params  : {
				autoplay : 1,
				autohide : 1,
				fs  : 1,
				rel : 0,
				hd  : 1,
				wmode : 'transparent',
				enablejsapi : 1,
				html5 : 1
			},
			paramPlace : 8,
			type  : 'iframe',
			url   : '//www.youtube.com/embed/$4',
			thumb : '//img.youtube.com/vi/$4/maxresdefault.jpg'
		},

		vimeo : {
			matcher : /^.+vimeo.com\/(.*\/)?([\d]+)(.*)?/,
			params  : {
				autoplay : 1,
				hd : 1,
				show_title    : 1,
				show_byline   : 1,
				show_portrait : 0,
				fullscreen    : 1,
				api : 1
			},
			paramPlace : 3,
			type : 'iframe',
			url : '//player.vimeo.com/video/$2'
		},

		metacafe : {
			matcher : /metacafe.com\/watch\/(\d+)\/(.*)?/,
			type    : 'iframe',
			url     : '//www.metacafe.com/embed/$1/?ap=1'
		},

		dailymotion : {
			matcher : /dailymotion.com\/video\/(.*)\/?(.*)/,
			params : {
				additionalInfos : 0,
				autoStart : 1
			},
			type : 'iframe',
			url  : '//www.dailymotion.com/embed/video/$1'
		},

		vine : {
			matcher : /vine.co\/v\/([a-zA-Z0-9\?\=\-]+)/,
			type    : 'iframe',
			url     : '//vine.co/v/$1/embed/simple'
		},

		instagram : {
			matcher : /(instagr\.am|instagram\.com)\/p\/([a-zA-Z0-9_\-]+)\/?/i,
			type    : 'image',
			url     : '//$1/p/$2/media/?size=l'
		},

		// Examples:
		// http://maps.google.com/?ll=48.857995,2.294297&spn=0.007666,0.021136&t=m&z=16
		// http://maps.google.com/?ll=48.857995,2.294297&spn=0.007666,0.021136&t=m&z=16
		// https://www.google.lv/maps/place/Googleplex/@37.4220041,-122.0833494,17z/data=!4m5!3m4!1s0x0:0x6c296c66619367e0!8m2!3d37.4219998!4d-122.0840572
		google_maps : {
			matcher : /(maps\.)?google\.([a-z]{2,3}(\.[a-z]{2})?)\/(((maps\/(place\/(.*)\/)?\@(.*),(\d+.?\d+?)z))|(\?ll=))(.*)?/i,
			type    : 'iframe',
			url     : function (rez) {
				return '//maps.google.' + rez[2] + '/?ll=' + ( rez[9] ? rez[9] + '&z=' + Math.floor(  rez[10]  ) + ( rez[12] ? rez[12].replace(/^\//, "&") : '' )  : rez[12] ) + '&output=' + ( rez[12] && rez[12].indexOf('layer=c') > 0 ? 'svembed' : 'embed' );
			}
		}
	} );

	/**
	 * Grid Loading Effects.
	 */
	var GridLoaderEffects = wp.hooks.applyFilters( 'wgextra-grid-loading-effects', {
		'hapi': {
			animeOpts: {
				duration: function (t, i) {
					return 600 + i * 75;
				},
				easing: 'easeOutExpo',
				delay: function (t, i) {
					return i * 50;
				},
				opacity: {
					value: [0, 1],
					easing: 'linear'
				},
				scale: [0, 1]
			}
		},
		'amun': {
			itemOverflowVisible: true,
			// Sort target elements function.
			sortTargetsFn: function (a, b) {
				var aBounds = a.getBoundingClientRect(),
					bBounds = b.getBoundingClientRect();

				return (aBounds.left - bBounds.left) || (aBounds.top - bBounds.top);
			},
			animeOpts: {
				duration: function (t, i) {
					return 500 + i * 50;
				},
				easing: 'easeOutExpo',
				delay: function (t, i) {
					return i * 20;
				},
				opacity: {
					value: [0, 1],
					duration: function (t, i) {
						return 250 + i * 50;
					},
					easing: 'linear'
				},
				translateY: [400, 0],
				rotateZ: [0.0001, 0.0001]
			}
		},
		'kuk': {
			itemOverflowVisible: true,
			sortTargetsFn: function (a, b) {
				return b.getBoundingClientRect()
					.left - a.getBoundingClientRect()
					.left;
			},
			animeOpts: {
				duration: 800,
				easing: [0.1, 1, 0.3, 1],
				delay: function (t, i) {
					return i * 50;
				},
				opacity: {
					value: [0, 1],
					duration: 600,
					easing: 'linear'
				},
				translateX: [-500, 0],
				rotateZ: [15, 0]
			}
		},
		'isis': {
			itemOverflowVisible: true,
			animeOpts: {
				duration: 900,
				elasticity: 500,
				delay: function (t, i) {
					return i * 15;
				},
				opacity: {
					value: [0, 1],
					duration: 300,
					easing: 'linear'
				},
				translateX: function () {
					return [anime.random(0, 1) === 0 ? 100 : -100, 0];
				},
				translateY: function () {
					return [anime.random(0, 1) === 0 ? 100 : -100, 0];
				},
				rotateZ: [0.0001, 0.0001]
			}
		},
		'montu': {
			itemOverflowVisible: true,
			perspective: 800,
			origin: '50% 0%',
			animeOpts: {
				duration: 1500,
				elasticity: 400,
				delay: function (t, i) {
					return i * 75;
				},
				opacity: {
					value: [0, 1],
					duration: 1000,
					easing: 'linear'
				},
				rotateX: [-90, 0]
			}
		},
		'osiris': {
			itemOverflowVisible: true,
			perspective: 3000,
			animeOpts: {
				duration: function () {
					return anime.random(500, 1000)
				},
				easing: [0.2, 1, 0.3, 1],
				delay: function (t, i) {
					return i * 50;
				},
				opacity: {
					value: [0, 1],
					duration: 700,
					easing: 'linear'
				},
				translateZ: {
					value: [-3000, 0],
					duration: 1000
				},
				rotateY: ['-1turns', 0]
			}
		},
		'satet': {
			itemOverflowVisible: true,
			animeOpts: {
				duration: 800,
				elasticity: 600,
				delay: function (t, i) {
					return i * 100;
				},
				opacity: {
					value: [0, 1],
					duration: 600,
					easing: 'linear'
				},
				scaleX: {
					value: [0.4, 1]
				},
				scaleY: {
					value: [0.6, 1],
					duration: 1000
				}
			}
		},
		'atum': {
			itemOverflowVisible: true,
			sortTargetsFn: function (a, b) {
				return b.getBoundingClientRect()
					.left - a.getBoundingClientRect()
					.left;
			},
			perspective: 1000,
			origin: '50% 0%',
			animeOpts: {
				duration: 800,
				easing: [0.1, 1, 0.3, 1],
				delay: function (t, i) {
					return i * 35;
				},
				opacity: {
					value: [0, 1],
					duration: 600,
					easing: 'linear'
				},
				translateX: [100, 0],
				translateY: [-100, 0],
				translateZ: [400, 0],
				rotateZ: [10, 0],
				rotateX: [75, 0]
			}
		},
		'ra': {
			itemOverflowVisible: true,
			origin: '50% 0%',
			animeOpts: {
				duration: 500,
				easing: 'easeOutBack',
				delay: function (t, i) {
					return i * 100;
				},
				opacity: {
					value: [0, 1],
					easing: 'linear'
				},
				translateY: [400, 0],
				scaleY: [{
					value: [3, 0.6],
					delay: function (t, i) {
						return i * 100 + 120;
					},
					duration: 300,
					easing: 'easeOutExpo'
				}, {
					value: [0.6, 1],
					duration: 1400,
					easing: 'easeOutElastic'
				}],
				scaleX: [{
					value: [0.9, 1.05],
					delay: function (t, i) {
						return i * 100 + 120;
					},
					duration: 300,
					easing: 'easeOutExpo'
				}, {
					value: [1.05, 1],
					duration: 1400,
					easing: 'easeOutElastic'
				}]
			}
		},
		'sobek': {
			itemOverflowVisible: true,
			animeOpts: {
				duration: 600,
				easing: 'easeOutExpo',
				delay: function (t, i) {
					return i * 100;
				},
				opacity: {
					value: [0, 1],
					duration: 100,
					easing: 'linear'
				},
				translateX: function (t, i) {
					var docScrolls = {
							left: document.body.scrollLeft + document.documentElement.scrollLeft
						},
						x1 = window.innerWidth / 2 + docScrolls.left,
						tBounds = t.getBoundingClientRect(),
						x2 = tBounds.left + docScrolls.left + tBounds.width / 2;

					return [x1 - x2, 0];
				},
				translateY: function (t, i) {
					var docScrolls = {
							top: document.body.scrollTop + document.documentElement.scrollTop
						},
						y1 = window.innerHeight + docScrolls.top,
						tBounds = t.getBoundingClientRect(),
						y2 = tBounds.top + docScrolls.top + tBounds.height / 2;

					return [y1 - y2, 0];
				},
				rotate: function (t, i) {
					var x1 = window.innerWidth / 2,
						tBounds = t.getBoundingClientRect(),
						x2 = tBounds.left + tBounds.width / 2;

					return [x2 < x1 ? 90 : -90, 0];
				},
				scale: [0, 1]
			}
		},
		'ptah': {
			sortTargetsFn: function (a, b) {
				return b.getBoundingClientRect()
					.left - a.getBoundingClientRect()
					.left;
			},
			origin: '100% 0%',
			animeOpts: {
				duration: 500,
				easing: 'easeOutExpo',
				delay: function (t, i) {
					return i * 20;
				},
				opacity: {
					value: [0, 1],
					duration: 400,
					easing: 'linear'
				},
				rotateZ: [45, 0]
			}
		},
		'bes': {
			revealer: true,
			revealerOrigin: '100% 50%',
			animeRevealerOpts: {
				duration: 800,
				delay: function (t, i) {
					return i * 75;
				},
				easing: 'easeInOutQuart',
				scaleX: [1, 0]
			},
			animeOpts: {
				duration: 800,
				easing: 'easeInOutQuart',
				delay: function (t, i) {
					return i * 75;
				},
				opacity: {
					value: [0, 1],
					easing: 'linear'
				},
				scale: [0.8, 1]
			}
		},
		'seker': {
			revealer: true,
			revealerOrigin: '50% 100%',
			animeRevealerOpts: {
				duration: 500,
				delay: function(t,i) {
					return i*50;
				},
				easing: [0.7,0,0.3,1],
				scaleY: [1,0]
			},
			animeOpts: {
				duration: 500,
				easing: [0.7,0,0.3,1],
				delay: function(t,i) {
					return i*50;
				},
				opacity: {
					value: [0,1],
					duration: 400,
					easing: 'linear'
				},
				translateY: [100,0],
				scale: [0.8,1]
			}
		},
		'nut': {
			revealer: true,
			revealerColor: '#1d1d1d',
			animeRevealerOpts: {
				easing: 'easeOutCubic',
				delay: function (t, i) {
					return i * 100;
				},
				translateX: [{
					value: ['101%', '0%'],
					duration: 400
				}, {
					value: ['0%', '-101%'],
					duration: 400
				}]
			},
			animeOpts: {
				duration: 400,
				easing: 'easeOutCubic',
				delay: function (t, i) {
					return 400 + i * 100;
				},
				opacity: {
					value: 1,
					duration: 1,
					easing: 'linear'
				},
				scale: [0.8, 1]
			}
		},
		'shu': {
			lineDrawing: true,
			animeLineDrawingOpts: {
				duration: 800,
				delay: function (t, i) {
					return i * 150;
				},
				easing: 'easeInOutSine',
				strokeDashoffset: [anime.setDashoffset, 0],
				opacity: [{
					value: [0, 1]
				}, {
					value: [1, 0],
					duration: 200,
					easing: 'linear',
					delay: 500
				}]
			},
			animeOpts: {
				duration: 800,
				easing: [0.2, 1, 0.3, 1],
				delay: function (t, i) {
					return i * 150 + 800;
				},
				opacity: {
					value: [0, 1],
					easing: 'linear'
				},
				scale: [0.5, 1]
			}
		},
		'apis': {
			revealer: true,
			revealerColor: '#1d1d1d',
			animeRevealerOpts: {
				easing: 'easeOutCubic',
				delay: function (t, i) {
					return i * 100;
				},
				translateY: [{
					value: ['-101%', '0%'],
					duration: 400
				}, {
					value: ['0%', '101%'],
					duration: 400
				}]
			},
			animeOpts: {
				duration: 400,
				easing: 'easeOutCubic',
				delay: function (t, i) {
					return 400 + i * 100;
				},
				opacity: {
					value: 1,
					duration: 1,
					easing: 'linear'
				},
				scale: [0.8, 1]
			}
		}
	} );

	/**
	 * Arrows Styles.
	 */
	var arrowsStyles = wp.hooks.applyFilters( 'wgextra-slider-arrows-skins', {
		'slide': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-20"></span>' +
				 '<span class="wgextra-arrow-info">' +
				 	'<span class="wgextra-arrow-title"><%= itemData.details.title %><span>By <%= itemData.details.author %></span></span>' +
				 	'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>' +
				 '</span>',

		'image-bar': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-3"></span><span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.thumb %>\');"></span>',

		'circle-pop': '<span></span>',

		'round-slide': '<span class="wgextra-arrow-icon"><svg width="32" height="32" viewBox="0 0 64 64"><path d="M48.058 48l-0.003-10.33-47.414 0.003v-11.37h47.418l-0.003-10.304 15.306 16z"></path></svg></span><span class="wgextra-arrow-title"><%= itemData.details.title %></span>',

		'split': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-20"></span>' +
				 '<span class="wgextra-arrow-info">' +
				 	'<span class="wgextra-arrow-title"><%= itemData.details.title %></span>' +
				 	'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>' +
				 '</span>',

		'reveal': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-20"></span>' +
				  '<span class="wgextra-arrow-info">' +
				  	'<span class="wgextra-arrow-title"><%= itemData.details.title %><span>By <%= itemData.details.author %></span></span>' +
				  	'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>' +
				  '</span>',

		'thumb-flip': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-21"></span><span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>',

		'thumb-double-flip': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-21"></span>' +
							 '<span class="wgextra-arrow-title"><span><%= itemData.details.title %></span></span>' +
							 '<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>',

		'circle-slide': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-20"></span>' +
						'<span class="wgextra-arrow-info">' +
							'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>' +
						'</span>',

		'grow-pop': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-3"></span>' +
					'<span class="wgextra-arrow-info">' +
						'<span class="wgextra-arrow-headline"><% if (button === \'prev\') { print(\'Previous Story\'); } else { print(\'Next Story\'); } %></span>' +
						'<span class="wgextra-arrow-title"><%= itemData.details.title %><span>By <%= itemData.details.author %></span></span>' +
						'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>'+
					'</span>',

		'diamond':  '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-20"></span>' +
					'<span class="wgextra-arrow-info">' +
						'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>' +
					'</span>',

		'fill-slide': '<span class="wgextra-arrow-icon wgextra-icon wgextra-icon-right-arrow-4"></span>' +
					'<span class="wgextra-arrow-info">' +
						'<span class="wgextra-arrow-title"><%= itemData.details.title %></span>' +
						'<span class="wgextra-arrow-footline">By <%= itemData.details.author %></span>' +
						'<span class="wgextra-arrow-thumb" style="background-image: url(\'<%= itemData.medium %>\');"></span>'+
					'</span>',

		'fill-path': '<span class="wgextra-arrow-icon"></span>' +
					 "<span class=\"wgextra-arrow-title\"><% var title = itemData.details.title, split = title.split(' '); print('<strong>' + split.shift() + '</strong> '); print(split.join(' ')); %></span>",
	} );

	/**
	 * Thumbnails Styles.
	 */
	var thumbnailsStyles = wp.hooks.applyFilters( 'wgextra-slider-thumbnails-skins', {
		'default': {
			html: '<li><div class="wgextra-slider-thumb" style="background-image: url(\'<%= thumbnail %>\');"><% if (slideData.icon) { %><span class="wgextra-slider-thumb-icon-<%= slideData.icon %>"></span><% } %><% if (slideData.itemData.details.title) { %><span class="wgextra-slider-thumb-title"><%= slideData.itemData.details.title %></span><% } %></div></li>'
		},
		'coverflow': {
			thumbnailNav: 'forceCentered',
			html: '<li><div class="wgextra-slider-thumb" style="background-image: url(\'<%= thumbnail %>\');"><% if (slideData.icon) { %><span class="wgextra-slider-thumb-icon-<%= slideData.icon %>"></span><% } %><% if (slideData.itemData.details.title) { %><span class="wgextra-slider-thumb-title"><%= slideData.itemData.details.title %></span><% } %></div></li>'
		},
		'small': {
			html: '<li><div class="wgextra-slider-thumb" style="background-image: url(\'<%= thumbnail %>\');"><% if (slideData.icon) { %><span class="wgextra-slider-thumb-icon-<%= slideData.icon %>"></span><% } %></div></li>'
		},
		'circle': {
			thumbnailNav: 'forceCentered',
			html: '<li><div class="wgextra-slider-thumb" style="background-image: url(\'<%= thumbnail %>\');"><% if (slideData.icon) { %><span class="wgextra-slider-thumb-icon-<%= slideData.icon %>"></span><% } %></div></li>'
		},
		'featured-dark': {
			thumbnailNav: 'basic',
			html: '<li><div class="wgextra-slider-thumb" style="background-image: url(\'<%= thumbnail %>\');"><% if (slideData.icon) { %><span class="wgextra-slider-thumb-icon-<%= slideData.icon %>"></span><% } %></div><% if (slideData.itemData.details.title) { %><span class="wgextra-slider-thumb-title"><%= slideData.itemData.details.title %></span><% } %><% if (slideData.itemData.details.description) { %><span class="wgextra-slider-thumb-description"><%= slideData.itemData.details.description %></span><% } %></li>'
		},
		'featured-light': {
			thumbnailNav: 'basic',
			html: '<li><div class="wgextra-slider-thumb" style="background-image: url(\'<%= thumbnail %>\');"><% if (slideData.icon) { %><span class="wgextra-slider-thumb-icon-<%= slideData.icon %>"></span><% } %></div><% if (slideData.itemData.details.title) { %><span class="wgextra-slider-thumb-title"><%= slideData.itemData.details.title %></span><% } %><% if (slideData.itemData.details.description) { %><span class="wgextra-slider-thumb-description"><%= slideData.itemData.details.description %></span><% } %></li>'
		}
	});

	/**
	 * Bullets Styles.
	 */
	var bulletsStyles = wp.hooks.applyFilters( 'wgextra-slider-bullets-skins', {
		'default': {
			html: '<li></li>'
		},
		'draw-circle': {
			html: '<li><svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 16 16" preserveAspectRatio="none"><circle cx="8" cy="8" r="6"></circle></svg></li>'
		}
	});

	/**
	 * Time loader skins.
	 */
	var timeLoaderSkins = wp.hooks.applyFilters( 'wgextra-slider-time-loader-skins', {
		'default': {
			scaleLength: 0,
			size: 30,
			mode: 'donut',
			barColor: '#FFF',
			trackColor: 'rgba(255, 255, 255, 0.2)',
			position: 'bottom left',
			lineWidth: 2,
			rotate: 180,
			offset: 20
		},
		'pie-1': {
			mode: 'pie',
			barColor: '#fff',
			trackColor: 'rgba(255, 255, 255, 0.2)',
			size: 100,
			offset: 20,
			position: 'bottom left'
		},
		'pie-2': {
			mode: 'pie',
			scaleLength: 0,
			barColor: '#FFF',
			trackColor: 'rgba(255,255,255,0.2)',
			rotate: 180,
			offset: 20,
			position: 'bottom left'
		},
		'pie-3': {
			mode: 'pie',
			trackSpace: 0,
			barColor: { type: 'gradient', gradient: { start_color: 'rgba(255, 255, 255, 0.05)', stop_color: 'rgba(255, 255, 255, 1)', orientation: 'radial' } },
			trackColor: 'rgba(0, 0, 0, 0.2)',
			scaleLength: 1,
			size: 40,
			offset: 30,
			position: 'bottom left'
		},
		'donut-1': {
			mode: 'donut',
			barColor: '#fff',
			trackColor: 'rgba(0, 0, 0, 0.2)',
			size: 100,
			offset: 20,
			position: 'bottom left'
		},
		'donut-2': {
			mode: 'donut',
			size: 100,
			scaleLength: 0,
			lineWidth: 5,
			barColor: '#32CC9A',
			trackColor: 'rgba(0, 0, 0, 0.2)',
			txtColor: '#fff',
			fontSize: '16px',
			fontWeight: '300',
			offset: 20,
			position: 'bottom left'
		},
		'donut-3': {
			mode: 'donut',
			size: 120,
			scaleLength: 0,
			trackSpace: 2,
			lineWidth: 7,
			barColor: { type: 'gradient', gradient: { start_color: 'rgba(255, 255, 255, 1)', stop_color: 'rgba(255, 255, 255, 0.3)', orientation: 'linear' } },
			trackColor: 'rgba(0, 0, 0, 0.2)',
			txtColor: '#fff',
			lineCap: 'round',
			reverse: true,
			txtTemp: function(percent) {
				var seconds = ((this.options.cycling.pauseTime / 100) * percent) / 1000;
				var microseconds = Math.floor((seconds - Math.floor(seconds)) * 100);

				return ('0' + Math.floor(seconds)).slice(-2) + '.' + ('0' + Math.floor(microseconds)).slice(-2);
			},
			fontSize: '30px',
			fontWeight: '300',
			offset: 20,
			position: 'bottom left'
		}
	});

	// Browser detect
	(function () {
		function uaMatch( ua ) {
			ua = ua.toLowerCase();

			var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
				/(webkit)[ \/]([\w.]+)/.exec( ua ) ||
				/(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
				/(msie) ([\w.]+)/.exec( ua ) ||
				ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
				[];

			return {
				browser: match[ 1 ] || "",
				version: match[ 2 ] || "0"
			};
		}

		var matched = uaMatch( navigator.userAgent );

		if ( matched.browser ) {
			browser[ matched.browser ] = true;
			browser.version = matched.version;
		}

		// Chrome is Webkit, but Webkit is also Safari.
		if ( browser.chrome ) {
			browser.webkit = true;
		}
		else if ( browser.webkit ) {
			browser.safari = true;
		}
	}());

	// Feature detects
	(function () {
		var prefixes = ['', 'webkit', 'moz', 'ms', 'o'];
		var el = document.createElement('div');

		function testProp(prop) {
			for (var p = 0, pl = prefixes.length; p < pl; p++) {
				var prefixedProp = prefixes[p] ? prefixes[p] + prop.charAt(0).toUpperCase() + prop.slice(1) : prop;
				if (el.style[prefixedProp] != null) {
					return prefixedProp;
				}
			}
		}

		// Global support indicators
		transform = testProp('transform');
		gpuAcceleration = testProp('perspective') ? 'translateZ(0) ' : '';

		// Hardware acceleration for mozilla
		if (browser.mozilla && gpuAcceleration) {
			gpuAcceleration += 'rotate(0.0001deg) ';
		}
	}());

	/**
	 * Group multiple sequential calls in a single one.
	 *
	 * @param {Function} func
	 * @param {Number} wait
	 * @param {Boolean} immediate
	 *
	 * @return {Function}
	 */
	var debounce = _.debounce;

	/**
	 * Make sure that a function will fire just once.
	 *
	 * @param {Function} fb
	 * @param {Object} context
	 *
	 * @return {Function}
	 */
	var once = _.once;

	/**
	 * Make sure that number is within the limits.
	 *
	 * @param {Number} number
	 * @param {Number} min
	 * @param {Number} max
	 *
	 * @return {Number}
	 */
	function within( number, min, max ) {
		return number < min ? min : number > max ? max : number;
	}


	function sortOrder( a, b ) {

		// Flag for duplicate removal
		if (a === b) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if (compare) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		compare = (a.ownerDocument || a) === (b.ownerDocument || b) ?
			a.compareDocumentPosition(b) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if (compare & 1) {

			// Choose the first element that is related to our preferred document
			if (a === document || a.ownerDocument === document &&
				jQuery.contains(document, a)) {
				return -1;
			}
			if (b === document || b.ownerDocument === document &&
				jQuery.contains(document, b)) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				(indexOf.call(sortInput, a) - indexOf.call(sortInput, b)) :
				0;
		}

		return compare & 4 ? -1 : 1;
	}

	function GridLoaderRender(effect) {

		var self = this,
			effectSettings = GridLoaderEffects[effect],
			animeOpts = effectSettings.animeOpts;

		// Reset styles.
		GridLoaderResetStyles.call(self);

		if (effectSettings.perspective != undefined) {
			[].slice.call(self.items)
				.forEach(function (item) {
					item.parentNode.style.WebkitPerspective = item.parentNode.style.perspective = effectSettings.perspective + 'px';
				});
		}

		if (effectSettings.origin != undefined) {
			[].slice.call(self.items)
				.forEach(function (item) {
					item.style.WebkitTransformOrigin = item.style.transformOrigin = effectSettings.origin;
				});
		}

		if (effectSettings.lineDrawing != undefined) {
			var paths = [];

			[].slice.call(self.items)
				.forEach(function (item) {
					// Create SVG.
					var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
						path = document.createElementNS('http://www.w3.org/2000/svg', 'path'),
						itemOffset = item.getBoundingClientRect(),
						itemW = itemOffset.width,
						itemH = itemOffset.height,
						paddingTop = parseInt(window.getComputedStyle(item.parentNode, null)
							.getPropertyValue('padding-top')),
						paddingLeft = parseInt(window.getComputedStyle(item.parentNode, null)
							.getPropertyValue('padding-left'));

					svg.setAttribute('width', itemW + 'px');
					svg.setAttribute('height', itemH + 'px');
					svg.setAttribute('viewBox', '0 0 ' + itemW + ' ' + itemH);
					svg.setAttribute('class', 'wgextra_deco');
					//svg.setAttribute('style', 'top: ' + paddingTop + 'px; left: ' + paddingLeft + 'px;');
					path.setAttribute('d', 'M0,0 l' + itemW + ',0 0,' + itemH + ' -' + itemW + ',0 0,-' + itemH);
					path.setAttribute('stroke-dashoffset', anime.setDashoffset(path));
					svg.appendChild(path);
					item.parentNode.appendChild(svg);
					paths.push(path);
				});

			var animeLineDrawingOpts = effectSettings.animeLineDrawingOpts;
			animeLineDrawingOpts.targets = paths;
			anime.remove(animeLineDrawingOpts.targets);
			anime(animeLineDrawingOpts);
		}

		if (effectSettings.revealer != undefined) {
			var revealers = [];
			[].slice.call(self.items)
				.forEach(function (item) {
					var revealer = document.createElement('div'),
						//revealerParent = document.createElement('div'),
						itemW = item.offsetWidth,
						itemH = item.offsetHeight,
						paddingTop = parseInt(window.getComputedStyle(item.parentNode, null)
							.getPropertyValue('padding-top')),
						paddingLeft = parseInt(window.getComputedStyle(item.parentNode, null)
							.getPropertyValue('padding-left'));

					/*revealerParent.className = 'wgextra_reveal_parent';
					revealerParent.style.width = itemW + 'px';
					revealerParent.style.height = itemH + 'px';
					revealerParent.style.top = paddingTop + 'px';
					revealerParent.style.left = paddingLeft + 'px';*/

					revealer.className = 'wgextra_reveal';

					if (effectSettings.revealerOrigin != undefined) {
						revealer.style.transformOrigin = effectSettings.revealerOrigin;
					}
					if (effectSettings.revealerColor != undefined) {
						revealer.style.backgroundColor = effectSettings.revealerColor;
					}

					item.parentNode.appendChild(revealer);
					//item.parentNode.appendChild(revealerParent);
					//revealerParent.appendChild(revealer);
					revealers.push(revealer);
				});

			var animeRevealerOpts = effectSettings.animeRevealerOpts;
			animeRevealerOpts.targets = revealers;
			animeRevealerOpts.begin = function (obj) {
				for (var i = 0, len = obj.animatables.length; i < len; ++i) {
					obj.animatables[i].target.style.opacity = 1;
				}
			};
			anime.remove(animeRevealerOpts.targets);
			anime(animeRevealerOpts);
		}

		if (effectSettings.itemOverflowVisible) {
			[].slice.call(self.items)
				.forEach(function (item) {
					item.parentNode.style.overflow = 'visible';
				});
		}

		animeOpts.targets = effectSettings.sortTargetsFn && typeof effectSettings.sortTargetsFn === 'function' ? [].slice.call(self.items)
			.sort(effectSettings.sortTargetsFn) : self.items;
		anime.remove(animeOpts.targets);
		animeOpts.complete = function (anim) {
			if (anim.completed) {
				// Reset transitions.
				GridLoaderRemoveStyles.call(self);
			}
		}
		anime(animeOpts);
	}

	function GridLoaderResetStyles() {
		this.el.style.WebkitPerspective = this.el.style.perspective = 'none';
		[].slice.call(this.items)
			.forEach(function (item) {
				var gItem = item.parentNode;
				item.style.opacity = 0;
				item.style.WebkitTransformOrigin = item.style.transformOrigin = '50% 50%';
				item.style.transform = 'none';
				item.style.WebkitTransitionDuration = item.style.transitionDuration = '0s';

				var svg = item.parentNode.querySelector('svg.wgextra_deco');
				if (svg) {
					gItem.removeChild(svg);
				}

				var revealer = item.parentNode.querySelector('.wgextra_reveal');
				if (revealer) {
					gItem.removeChild(revealer);
				}

				gItem.style.overflow = '';
			});
	}

	function GridLoaderRemoveStyles() {
		[].slice.call(this.items)
			.forEach(function (item) {
				item.style.WebkitTransformOrigin = item.style.transformOrigin = null;
				item.style.transform = null;
				item.style.WebkitTransitionDuration = item.style.transitionDuration = null;
			});
	}

	function formatVideoURL(url, rez, params) {
		if ( !url ) {
			return;
		}

		params = params || '';

		if ( $.type(params) === "object" ) {
			params = $.param(params, true);
		}

		$.each(rez, function (key, value) {
			url = url.replace('$' + key, value || '');
		});

		if (params.length) {
			url += (url.indexOf('?') > 0 ? '&' : '?') + params;
		}

		return url;
	}

	function getEmbedDetails(url) {
		var item = false,
			type = false,
			media,
			thumb,
			rez,
			params,
			urlParams,
			o,
			provider;

		media = $.extend( true, {}, videoSites );

		// Look for any matching media type
		$.each(media, function ( n, el ) {
			rez = url.match(el.matcher);
			o   = {};
			provider = n;

			if (!rez) {
				return;
			}

			type = el.type;

			if ( el.paramPlace && rez[ el.paramPlace ] ) {
				urlParams = rez[ el.paramPlace ];

				if ( urlParams[ 0 ] == '?' ) {
					urlParams = urlParams.substring(1);
				}

				urlParams = urlParams.split('&');

				for ( var m = 0; m < urlParams.length; ++m ) {
					var p = urlParams[ m ].split('=', 2);

					if ( p.length == 2 ) {
						o[ p[0] ] = decodeURIComponent( p[1].replace(/\+/g, " ") );
					}
				}
			}

			params = $.extend( true, {}, el.params, o );

			url   = $.type(el.url) === "function" ? el.url.call(this, rez, params, item) : formatVideoURL(el.url, rez, params);
			thumb = $.type(el.thumb) === "function" ? el.thumb.call(this, rez, params, item) : formatVideoURL(el.thumb, rez);

			if ( provider === 'vimeo' ) {
				url = url.replace('&%23', '#');
			}

			return false;
		});

		// If it is found, then change content type and update the url
		if ( type ) {
			item = {
				src: url,
				type: type,
				thumb: thumb
			};
		}

		return item;
	}

	// Get info about gallery id and current index from url
	function lightboxParseUrl() {
		var hash    = window.location.hash.substr( 1 );
		var rez     = hash.split( '-' );
		var index   = rez.length > 1 && /^\+?\d+$/.test( rez[ rez.length - 1 ] ) ? parseInt( rez[ rez.length - 1 ] ) : 0;
		var galleryId = rez.length > 1 && /^\+?\d+$/.test( rez[ 1 ] ) ? parseInt( rez[ 1 ] ) : 0;

		return {
			hash    : hash,
			index   : index,
			galleryId : galleryId
		};
	}

	// Open lightbox from hash url
	function lightboxTriggerFromUrl( url ) {
		if ( url.galleryId !== '' ) {

			// If we can find element matching 'data-fancybox' atribute, then trigger click event for that ..
			var $gallery = $FIND( "#wgextra-gallery-" + $.escapeSelector( url.galleryId ) ),
				data = $gallery.data('gallery');

			if ( $gallery.length ) {
				if ( data.lightbox_type === 'magnific' ) {
					openMagnific( url.index, url.galleryId, data.items, data.lightbox_options );
				}
				else if ( data.lightbox_type === 'photoswipe' ) {
					openPhotoSwipe( url.index, data.items, data.lightbox_options, url.galleryId, true );
				}
				else if ( data.lightbox_type === 'fancybox' ) {
					openFancybox( url.index, data.items, data.lightbox_options, url.galleryId );
				}
				else if ( data.lightbox_type === 'ilightbox' ) {
					openiLightBox( url.index, data.items, data.lightbox_options, url.galleryId );
				}
			}

		}
	}

	// Small delay is used to allow other scripts to process "dom ready" event
	setTimeout(function() {

		// Update hash when opening/closing fancyBox
		$doc.on({
			'lightboxBeforeShow.wgextra' : debounce( function( e, index, galleryId, firstRun ) {
				if ( firstRun ) {
					origHash = location.hash;
					scrollTop = $win.scrollTop();
					scrollLeft = $win.scrollLeft();
				}

				if ( galleryId ) {

					currentHash = 'wgextra-' + galleryId + '-' + index;

					if ( 'replaceState' in window.history ) {
						window.history[ firstRun ? 'pushState' : 'replaceState' ]( {} , document.title, window.location.pathname + window.location.search + '#' +  currentHash );
					} else {
						window.location.hash = currentHash;
					}

				}

			}, 300 ),

			'lightboxBeforeClose.wgextra' : debounce( function( e, galleryId ) {
				// Remove hash from location bar
				if ( galleryId ) {

					if ( 'replaceState' in history ) {
						window.history.replaceState( {} , document.title, window.location.pathname + window.location.search + ( origHash.indexOf( '#wgextra-' ) === 0 ? '' : origHash ) );
					} else {
						window.location.hash = origHash.indexOf( '#wgextra-' ) === 0 ? '' : origHash;

						// Keep original scroll position
						$win.scrollTop( scrollTop ).scrollLeft( scrollLeft );
					}

				}

				currentHash = null;
			}, 300 )
		});

		// Check if need to close after url has changed
		$win.on('hashchange.wgextra', function() {
			var url = lightboxParseUrl();

			if ( $.wgextraLightbox ) {
				if ( currentHash && currentHash !== 'wgextra-' + url.galleryId + '-' + url.index ) {
					currentHash = null;

					$.wgextraLightbox.close.call($.wgextraLightbox.instance);
				}

			} else if ( url.gallery !== '' ) {
				lightboxTriggerFromUrl( url );
			}
		});

		// If navigating away from current page
		$win.one('unload.wgextra popstate.wgextra', function() {
			if( $.wgextraLightbox )
				$.wgextraLightbox.close.call($.wgextraLightbox.instance);
		});

		// Check current hash and trigger click event on matching element to start fancyBox, if needed
		lightboxTriggerFromUrl( lightboxParseUrl() );

	}, 50);

	function getLightBoxItems( $gallery ) {
		var galleryData = $gallery.data('gallery'),
			items = [];

		$gallery.find('.wgextra-item:not(.wgextra-is-group)')
			.each(function (i) {
				var $this = $(this),
					data = $this.data(),
					isHidden = $this.is(':hidden'),
					$linkEl = $this.find('a[href$=".jpg"],a[href$=".jpeg"],a[href$=".jpe"],a[href$=".jfif"],a[href$=".gif"],a[href$=".png"],a[href$=".tif"],a[href$=".tiff"],a[target="_lightbox"],a[target="_video"],a[target="_audio"]').not(isHidden ? '[target="_gallery"]' : ':hidden,[target="_gallery"]').eq(0);

				/*if (!$linkEl[0])
					return true;*/

				var $caption = $this.find('.wgextra-caption'),
					href = $linkEl[0] && $linkEl[0].href || data.details.link,
					target = $linkEl[0] && $linkEl.attr('target') || data.details.link_target,
					isVideo = target === '_video',
					isAudio = target === '_audio',
					isIframe = target === '_lightbox',
					title, caption, item = {}, embedDetails;

				$linkEl
					.addClass('open-in-lightbox')
					.attr('lightbox-index', i);

				if ($caption[0]) {
					var $captionTitle = $caption.find('.caption-title, .title').first(),
						$captionDesc = $caption.find('.caption-description, .description').first();

					if ($captionTitle.length)
						title = $captionTitle.html();

					if ($captionDesc.length)
						caption = $captionDesc.html();
					else
						caption = $caption.html();
				}

				if (galleryData.lightbox_type === 'magnific') {
					item.el = $linkEl;
					item.src = href;
					item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
					item.loading = false;
					item.loaded = false;
					item.preloaded = false;
					item.parsed = false;

					if (isAudio || isVideo || isIframe) {
						embedDetails = getEmbedDetails(item.src);

						if (embedDetails) {
							item.src = embedDetails.src;
							item.type = embedDetails.type;
						} else if ( isVideo ) {
							item.src = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
						} else if ( isAudio ) {
							item.src = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(data.image) + "&player_type=" + wgextra.audio_player_type;
						}
					}

					if (title == caption || (title && !caption))
						item.title = title;
					else if (!title && caption)
						item.title = caption;
					else if (title && caption)
						item.title = title + '<small>' + caption + '</small>';
				} else if (galleryData.lightbox_type === 'photoswipe') {
					item.src = href;
					item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
					item.w = data.imageWidth;
					item.h = data.imageHeight;

					item.msrc = data.medium;

					if (isAudio || isVideo || isIframe) {
						embedDetails = getEmbedDetails(item.src);

						if (embedDetails) {
							item.src = embedDetails.src;
							item.type = embedDetails.type;
						} else if ( isVideo ) {
							item.src = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
						} else if ( isAudio ) {
							item.src = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(data.image) + "&player_type=" + wgextra.audio_player_type;
						}
					}

					if (title == caption || (title && !caption))
						item.title = title;
					else if (!title && caption)
						item.title = caption;
					else if (title && caption)
						item.title = title + '<br><small>' + caption + '</small>';

					if (data.thumbCropped === 'no' && !$gallery.hasClass('wgextra-mosaic'))
						item.el = $this.find('.wgextra-thumb')[0];
				} else if (galleryData.lightbox_type === 'fancybox') {
					item.src = href;
					item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
					item.opts = {
						$orig: $linkEl,
						width: data.imageWidth,
						height: data.imageHeight,
						thumb: data.medium
					};

					if (isAudio || isVideo || isIframe) {
						embedDetails = getEmbedDetails(item.src);

						if (embedDetails) {
							item.src = embedDetails.src;
							item.type = embedDetails.type;
						} else if ( isVideo ) {
							item.src = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
						} else if ( isAudio ) {
							item.src = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(data.image) + "&player_type=" + wgextra.audio_player_type;
						}

						item.opts.iframe = {
							preload : false
						};
					}

					if (title == caption || (title && !caption))
						item.opts.caption = title;
					else if (!title && caption)
						item.opts.caption = caption;
					else if (title && caption)
						item.opts.caption = title + '<br><small>' + caption + '</small>';

					if (data.thumbCropped === 'no' && !$gallery.hasClass('wgextra-mosaic')) {
						item.opts.$thumb = $this.find('.wgextra-thumb img');
					}
				} else if (galleryData.lightbox_type === 'ilightbox') {
					item.URL = href;
					item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
					item.options = {
						width: data.imageWidth,
						height: data.imageHeight,
						thumbnail: data.medium
					};

					if (isAudio || isVideo || isIframe) {
						embedDetails = getEmbedDetails(item.URL);

						if ( embedDetails ) {
							item.URL = embedDetails.src;
							item.type = embedDetails.type;
						} else if ( isVideo ) {
							item.URL = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
						} else if ( isAudio ) {
							item.URL = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(data.image) + "&player_type=" + wgextra.audio_player_type;
						}
					}

					if (title == caption || (title && !caption))
						item.caption = title;
					else if (!title && caption)
						item.caption = caption;
					else if (title && caption) {
						item.title = title;
						item.caption = caption;
					}
				} else {
					item.$orig = $linkEl;
					item.$thumb = $this.find('.wgextra-thumb img');
					item.data = data;
					item.src = href;
					item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
					item.options = {
						width: data.imageWidth,
						height: data.imageHeight,
						thumbnail: data.medium
					};

					if (isAudio || isVideo || isIframe) {
						embedDetails = getEmbedDetails(item.src);

						if ( embedDetails ) {
							item.src = embedDetails.src;
							item.type = embedDetails.type;
						} else if ( isVideo ) {
							item.src = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
						} else if ( isAudio ) {
							item.src = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(data.image) + "&player_type=" + wgextra.audio_player_type;
						}
					}

					if (title == caption)
						item.options.caption = title;
					else if (!title && caption)
						item.options.caption = caption;
					else if (title && caption)
						item.options.caption = title + '<br><small>' + caption + '</small>';
				}

				items.push(item);
			});

		return items;
	}

	function getLightBoxGroupItems($linkEl, galleryData, groupItems) {
		var items = [];

		$.each(groupItems, function (i, element) {;
			if (!element)
				return true;

			var href     = element.href,
				target   = element.target,
				isVideo  = target === '_video',
				isAudio  = target === '_audio',
				isIframe = target === '_lightbox',
				title    = element.title,
				caption  = element.caption,
				item     = {},
				embedDetails;

			if (galleryData.lightbox_type === 'magnific') {
				item.el = $linkEl;
				item.src = href;
				item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
				item.loading = false;
				item.loaded = false;
				item.preloaded = false;
				item.parsed = false;

				if (isAudio || isVideo || isIframe) {
					embedDetails = getEmbedDetails(item.src);

					if (embedDetails) {
						item.src = embedDetails.src;
						item.type = embedDetails.type;
					} else if ( isVideo ) {
						item.src = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
					} else if ( isAudio ) {
						item.src = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(element.image[0]) + "&player_type=" + wgextra.audio_player_type;
					}
				}

				if (title == caption || (title && !caption))
					item.title = title;
				else if (!title && caption)
					item.title = caption;
				else if (title && caption)
					item.title = title + '<small>' + caption + '</small>';
			} else if (galleryData.lightbox_type === 'photoswipe') {
				if (isAudio || isVideo || isIframe) {
					return true;
				}

				item.src = href;
				item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
				item.w = element.image[1];
				item.h = element.image[2];

				item.msrc = element.medium[0];

				if (title == caption || (title && !caption))
					item.title = title;
				else if (!title && caption)
					item.title = caption;
				else if (title && caption)
					item.title = title + '<br><small>' + caption + '</small>';
			} else if (galleryData.lightbox_type === 'fancybox') {
				item.src = href;
				item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
				item.opts = {
					$orig: $linkEl,
					width: element.image[1],
					height: element.image[2],
					thumb: element.medium[0]
				};

				if (isAudio || isVideo || isIframe) {
					embedDetails = getEmbedDetails(item.src);

					if (embedDetails) {
						item.src = embedDetails.src;
						item.type = embedDetails.type;
					} else if ( isVideo ) {
						item.src = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
					} else if ( isAudio ) {
						item.src = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(element.image[0]) + "&player_type=" + wgextra.audio_player_type;
					}

					item.opts.iframe = {
						preload : false
					};
				}

				if (title == caption || (title && !caption))
					item.opts.caption = title;
				else if (!title && caption)
					item.opts.caption = caption;
				else if (title && caption)
					item.opts.caption = title + '<br><small>' + caption + '</small>';
			} else if (galleryData.lightbox_type === 'ilightbox') {
				item.URL = href;
				item.type = isAudio || isVideo || isIframe ? "iframe" : "image";
				item.options = {
					width: element.image[1],
					height: element.image[2],
					thumbnail: element.medium[0]
				};

				if (isAudio || isVideo || isIframe) {
					embedDetails = getEmbedDetails(item.URL);

					if ( embedDetails ) {
						item.URL = embedDetails.src;
						item.type = embedDetails.type;
					} else if ( isVideo ) {
						item.URL = wgextra.dir_url + "video-player.php?video=" + encodeURIComponent(href);
					} else if ( isAudio ) {
						item.URL = wgextra.dir_url + "audio-player.php?audio=" + encodeURIComponent(href) + "&cover=" + encodeURIComponent(element.image[0]) + "&player_type=" + wgextra.audio_player_type;
					}
				}

				if (title == caption || (title && !caption))
					item.caption = title;
				else if (!title && caption)
					item.caption = caption;
				else if (title && caption) {
					item.title = title;
					item.caption = caption;
				}
			}

			items.push(item);
		});

		return items;
	}

	function openMagnific(index, gid, items, options) {
		$.magnificPopup.open({
			items: items,
			type: 'image',
			gallery: {
				enabled: true
			},
			removalDelay: options.animation === 'mfp-none' ? 0 : 500,
			preloader: options.preload === 'yes',
			closeOnContentClick: true,
			closeBtnInside: false,
			fixedContentPos: true,
			enableEscapeKey: true,
			callbacks: {
				beforeOpen: function () {
					// just a hack that adds mfp-anim class to markup 
					if (options.animation === 'mfp-none') {
						this.st.mainClass = options.animation;
					} else {
						this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
						this.st.mainClass = 'mfp-with-zoom ' + options.animation;
					}
				},
				open: function () {
					if (options.deeplink === 'yes')
						$doc.trigger( 'lightboxBeforeShow.wgextra', [this.index, gid, true] );
					$.wgextraLightbox = {
						instance: this,
						close: this.close,
						next: this.next,
						prev: this.prev
					};
				},
				close: function () {
					if (options.deeplink === 'yes')
						$doc.trigger( 'lightboxBeforeClose.wgextra', [gid] );
					$.wgextraLightbox = null;
				},
				change: function () {
					if (options.deeplink === 'yes')
						$doc.trigger( 'lightboxBeforeShow.wgextra', [this.index, gid, false] );
				}
			},
			image: {
				verticalFit: options.vertical_fit === 'yes'
			},
			iframe: {
				patterns: {
					youtube: false,
					vimeo: false,
					gmaps: false
				},
				markup: '<div class="mfp-iframe-scaler">'+
							'<div class="mfp-close"></div>'+
							'<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
							'<div class="mfp-bottom-bar">'+
								'<div class="mfp-title"></div>'+
								'<div class="mfp-counter"></div>'+
							'</div>'+
						'</div>'
			}
		}, parseInt(index));
	}

	function openPhotoSwipe(index, items, lightboxOptions, gid, disableAnimation) {
		var $pswpElement = $FIND('.wgextra-pswp'),
			gallery, options, shareButtons = [];

		if (lightboxOptions.share_buttons === 'yes') {
			shareButtons.push({
				id: 'facebook',
				label: 'Share on Facebook',
				url: 'https://www.facebook.com/sharer/sharer.php?u={{url}}'
			});
			shareButtons.push({
				id: 'twitter',
				label: 'Tweet',
				url: 'https://twitter.com/intent/tweet?text={{text}}&url={{url}}'
			});
			shareButtons.push({
				id: 'pinterest',
				label: 'Pin it',
				url: 'http://www.pinterest.com/pin/create/button/?url={{url}}&media={{image_url}}&description={{text}}'
			});
		}
		if (lightboxOptions.download === 'yes') {
			shareButtons.push({
				id: 'download',
				label: 'Download image',
				url: '{{raw_image_url}}',
				download: true
			});
		}

		$pswpElement[lightboxOptions.skin === 'black' ? 'removeClass' : 'addClass']('pswp--white-skin');

		// define options (if needed)
		options = {
			loop: lightboxOptions.loop === 'yes',

			// define gallery index (for URL)
			galleryUID: gid,
			history: false,

			getThumbBoundsFn: function (index) {
				if (items[index].el) {
					// See Options -> getThumbBoundsFn section of documentation for more info
					var thumbnail = items[index].el.getElementsByTagName('img')[0], // find thumbnail
						pageYScroll = window.pageYOffset || document.documentElement.scrollTop,
						rect = thumbnail.getBoundingClientRect();

					return {
						x: rect.left,
						y: rect.top + pageYScroll,
						w: rect.width
					};
				} else {
					return false;
				}
			},

			shareButtons: shareButtons,
			shareEl: shareButtons.length

		};

		// PhotoSwipe opened from URL
		options.index = parseInt(index, 10);

		// exit if index not found
		if (isNaN(options.index)) {
			return;
		}

		if (disableAnimation) {
			options.showAnimationDuration = 0;
		}

		// Pass data to PhotoSwipe and initialize it
		pswp = new PhotoSwipe($pswpElement[0], PhotoSwipeUI_WGExtra, items, options);
		pswp.init();

		$.wgextraLightbox = {
			instance: pswp,
			close: pswp.close,
			next: pswp.next,
			prev: pswp.prev
		};

		if (lightboxOptions.deeplink === 'yes') {
			$doc.trigger( 'lightboxBeforeShow.wgextra', [index, gid, true] );

			pswp.listen('afterChange', function() {
				$doc.trigger( 'lightboxBeforeShow.wgextra', [pswp.getCurrentIndex(), gid, false] );
			});
			pswp.listen('close', function() {
				$doc.trigger( 'lightboxBeforeClose.wgextra', [gid] );
				$.wgextraLightbox = null;
			});
		}
	};

	function openFancybox(index, items, options, gid) {
		var fancyBoxOptions = {
				animationEffect: options.animation || false,
				transitionEffect: options.transition || false,
				loop: options.loop === 'yes',
				protect: options.download === 'yes',
				hash: false,

				image: {
					preload: options.preload === 'yes' ? 'auto' : false
				},
				iframe: {
					preload: options.preload === 'yes'
				}
			};

		if (options.deeplink === 'yes') {
			fancyBoxOptions.beforeShow = function( instance, current, firstRun ) {
				$doc.trigger( 'lightboxBeforeShow.wgextra', [instance.currIndex, gid, firstRun] );
			};
			fancyBoxOptions.beforeClose = function() {
				$doc.trigger( 'lightboxBeforeClose.wgextra', [gid] );
				$.wgextraLightbox = null;
			};
		}

		var fancyboxInstance = $.fancybox.open(items, fancyBoxOptions, parseInt(index));
		$.wgextraLightbox = {
			instance: fancyboxInstance,
			close: fancyboxInstance.close,
			next: fancyboxInstance.next,
			prev: fancyboxInstance.previous
		};
	}

	function openiLightBox(index, items, options, gid) {
		if ( !$.iLightBox )
			return false;

		var ilightboxOptions = {
				path: options.direction,
				skin: options.skin,
				infinite: options.loop === 'yes',
				startFrom: index,
				minScale: 0.01,
				fullAlone: false,
				overlay: {
					opacity: parseFloat( options.overlay_opacity )
				},
				controls: {
					arrows: options.carousel_mode === 'no',
					thumbnail: options.thumbnails === 'yes'
				},
				styles: {},
				social: {},
				thumbnails: {
					normalOpacity: .3,
					activeOpacity: 1
				},
				callback: {}
			};

		if ( options.deeplink === 'yes' ) {
			ilightboxOptions.callback.onOpen = function( api ) {
				$doc.trigger( 'lightboxBeforeShow.wgextra', [index, gid, true] );
			};
			ilightboxOptions.callback.onAfterChange = function( api ) {
				$doc.trigger( 'lightboxBeforeShow.wgextra', [api.currentItem, gid, false] );
			};
			ilightboxOptions.callback.onHide = function() {
				$doc.trigger( 'lightboxBeforeClose.wgextra', [gid] );
				$.wgextraLightbox = null;
			};
		}

		if ( options.share_buttons === 'yes' )
			ilightboxOptions.social.buttons = {
				facebook: true,
				twitter: true,
				googleplus: true
			};

		if ( options.carousel_mode === 'yes' )
			ilightboxOptions.styles = {
				nextOffsetX: 85,
				nextOpacity: 0.5,
				nextScale: 0.8,

				prevOffsetX: 85,
				prevOpacity: 0.5,
				prevScale: 0.8
			};
		else
			ilightboxOptions.styles = {
				nextOffsetX: 0,
				nextOpacity: 0,
				prevOffsetX: 0,
				prevOpacity: 0
			};

		var iLightBoxInstance = $.iLightBox(items, ilightboxOptions);
		$.wgextraLightbox = {
			instance: iLightBoxInstance,
			close: iLightBoxInstance.close,
			next: iLightBoxInstance.moveNext,
			prev: iLightBoxInstance.movePrev
		};
	}

	function initializeLightbox($gallery) {
		var galleryData = $gallery.data('gallery'),
			galleryID = parseInt($gallery[0].id.replace('wgextra-gallery-', ''));

		galleryData.items = getLightBoxItems($gallery);

		if (galleryData.lightbox_type === 'photoswipe') {
			if (!$body.find('.wgextra-pswp')
				.length)
				$body.append('<div aria-hidden="true" class="pswp wgextra-pswp" role="dialog" tabindex="-1">' +
								'<div class="pswp__bg"></div>' +
								'<div class="pswp__scroll-wrap">' +
								'<div class="pswp__container">' +
								'<div class="pswp__item"></div>' +
								'<div class="pswp__item"></div>' +
								'<div class="pswp__item"></div>' +
								'</div>' +
								'<div class="pswp__ui pswp__ui--hidden">' +
								'<div class="pswp__top-bar">' +
								'<div class="pswp__counter"></div><button class="pswp__button pswp__button--close" title="Close (Esc)"></button> <button class="pswp__button pswp__button--share" title="Share"></button> <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button> <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>' +
								'<div class="pswp__preloader">' +
								'<div class="pswp__preloader__icn">' +
								'<div class="pswp__preloader__cut">' +
								'<div class="pswp__preloader__donut"></div>' +
								'</div>' +
								'</div>' +
								'</div>' +
								'</div><!-- <div class="pswp__loading-indicator"><div class="pswp__loading-indicator__line"></div></div> -->' +
								'<div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">' +
								'<div class="pswp__share-tooltip">' +
								'<!-- <a href="#" class="pswp__share==facebook"></a>' +
								'<a href="#" class="pswp__share==twitter"></a>' +
								'<a href="#" class="pswp__share==pinterest"></a>' +
								'<a href="#" download class="pswp__share==download"></a> -->' +
								'</div>' +
								'</div><button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"></button> <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"></button>' +
								'<div class="pswp__caption">' +
								'<div class="pswp__caption__center"></div>' +
								'</div>' +
								'</div>' +
								'</div>' +
							'</div>');
		} else if (galleryData.lightbox_type === 'custom' && galleryData.lightbox) {
			var galleryidentifier = "\"#" + $gallery[0].getAttribute('id'),
				selector = galleryidentifier + " .wgextra-thumb > a\"",
				lightbox = galleryData.lightbox;

			try {
				//eval(lightbox);
				new Function("SELECTOR", "GALID", "DATA", lightbox).call(this, selector, galleryidentifier, galleryData);
			} catch (err) {
				if (console)
					console[console.warn ? 'warn' : 'log']('%c' + wgextra.lightbox_error_message + err.message, 'background: #ffeb3b; color: #000; font-size: 16px; padding: 5px 10px; line-height: 2');
			}
		}

		if (galleryData.lightbox_type != 'custom') {
			$gallery.on('msclick', '.open-in-lightbox', function (event) {
				event.preventDefault();

				var $this = $( this ),
					index = parseInt( $this[0].getAttribute( 'lightbox-index' ) );

				try {
					// open Magnific Popup if valid index found
					if ( galleryData.lightbox_type === 'magnific' )
						openMagnific( index, galleryID, galleryData.items, galleryData.lightbox_options );
					// open PhotoSwipe if valid index found
					else if ( galleryData.lightbox_type === 'photoswipe' ) {
						if ( galleryData.items[index].type === 'image' )
							openPhotoSwipe(index, galleryData.items, galleryData.lightbox_options, galleryID );
						else {
							var width = Math.min( 1280, screen.availWidth ),
								height = Math.min( 720, screen.availHeight ),
								top = ( screen.availHeight / 2 ) - ( height / 2 ),
								left = ( screen.availWidth / 2 ) - ( width / 2 );
							window.open( galleryData.items[index].src, 'photoswipe', 'width=' + width + ', height=' + height + ', top=' + top + ', left=' + left + '' );
						}
					}
					// open fancyBox if valid index found
					else if ( galleryData.lightbox_type === 'fancybox' )
						openFancybox( index, galleryData.items, galleryData.lightbox_options, galleryID );
					// open ilightbox if valid index found
					else if ( galleryData.lightbox_type === 'ilightbox' )
						openiLightBox( index, galleryData.items, galleryData.lightbox_options, galleryID );
				} catch (e) {
					console.warn(e);
				}
			}).on('msclick', 'a[target="_gallery"]', function (event) {
				event.preventDefault();

				var $this = $( this ),
					$item = $this.parents('.wgextra-item').eq(0),
					groupItems = $item.data('details').items,
					groupData = $item.data('group-data'),
					index = 0;

				if ( !groupData ) {
					groupData = getLightBoxGroupItems($this, galleryData, groupItems);
					$item.data('group-data', groupData);
				}

				galleryData.lightbox_options.deeplink = "no";

				// open Magnific Popup if valid index found
				if ( galleryData.lightbox_type === 'magnific' )
					openMagnific( index, galleryID, groupData, galleryData.lightbox_options );
				// open PhotoSwipe if valid index found
				else if ( galleryData.lightbox_type === 'photoswipe' )
					openPhotoSwipe(index, groupData, galleryData.lightbox_options, galleryID );
				// open fancyBox if valid index found
				else if ( galleryData.lightbox_type === 'fancybox' )
					openFancybox( index, groupData, galleryData.lightbox_options, galleryID );
				// open ilightbox if valid index found
				else if ( galleryData.lightbox_type === 'ilightbox' )
					openiLightBox( index, groupData, galleryData.lightbox_options, galleryID );
			});
		}
	};

	function lazyLoadItem($gallery) {
		var galleryData = $gallery.data('gallery'),
			$items = $(this);

		var loadedItems = [],
			loadedItemsTime = null;

		if (!$items.eq(0).is('.wgextra-thumb')) {
			$items = $items.find('.wgextra-thumb');
		}

		if (!$items.eq(0).is('> a, > img')) {
			$items = $items.find('> a, > img');
		}

		$items.filter(':not(.lazyload-handled)')
			.each(function (i, item) {
				var $item = $(item),
					rect = item.getBoundingClientRect();

				$item.addClass('lazyload-handled');

				var $img = $item.is('img') ? $item : $item.find('img.lazy');

				if (!$img[0]) {
					return;
				}

				var data = $img.data(),
					img = new Image(rect.width, rect.height),
					src = data.src,
					srcset = data.srcset,
					sizes = $img.attr('sizes') | "";

				$img[0].removeAttribute('data-src');

				if (rect.width >= 30)
					sizes = "(max-width: " + Math.round(rect.width + 50) + "px) 100vw, " + Math.round(rect.width + 50) + "px";

				img.src = src;
				if (srcset) {
					img.srcset = srcset;
					$img[0].srcset = srcset;
					$img[0].removeAttribute('data-srcset');
				}
				if (sizes) {
					img.sizes = sizes;
					$img[0].sizes = sizes;
				}
				img.onload = once(function () {
					src = ('currentSrc' in img) ? img.currentSrc : img.src;
					$img[0].src = src;
					$img.removeClass('lazy-hidden').addClass('lazy-visible');
					if (galleryData.loading_grid_animation) {
						clearTimeout(loadedItemsTime);

						loadedItems.push(item);

						loadedItemsTime = setTimeout(function () {
							GridLoaderRender.call({
								el: $gallery[0],
								items: loadedItems.sort(sortOrder)
							}, galleryData.loading_grid_animation);

							loadedItems = [];
						}, 50);
					}

					if (galleryData.detect_focus_point === 'yes' && data.focusTop && data.focusTop == 0.5 && data.focusRight == 0.5 && data.focusBottom == 0.5 && data.focusLeft == 0.5) {
						var imgWidth = img.naturalWidth,
							imgHeight = img.naturalHeight;

						smartcrop.crop(img, { width: imgWidth, height: imgWidth }, function(result) {
							var crop = result.topCrop;
							$img.data({
								focusLeft: crop.x / imgWidth,
								focusRight: (crop.x + crop.width) / imgWidth,
								focusTop: crop.y / imgHeight,
								focusBottom: (crop.y + crop.height) / imgHeight
							}).responsify();
						});
					}

					if ( galleryData.grouped_items_mode === 'slider' ) {
						setTimeout(
							function(){
								createGroupsSliders( $item.parents('.wgextra-item') );
							},
							(
								GridLoaderEffects[galleryData.loading_grid_animation]
								&&
								(
									typeof GridLoaderEffects[galleryData.loading_grid_animation].animeOpts.duration === "number"
									&&
									GridLoaderEffects[galleryData.loading_grid_animation].animeOpts.duration
								)
								||
								(
									typeof GridLoaderEffects[galleryData.loading_grid_animation].animeOpts.duration === "function"
									&&
									GridLoaderEffects[galleryData.loading_grid_animation].animeOpts.duration(item, loadedItems.length)
								)
							)
							||
							16
						);
					}

					img = null;
				});
			});
	}

	function initializeLazyLoad($gallery) {
		var data = $gallery.data('gallery'),
			lazyLoadTime = null,
			lazyLoadItems = [];

		$gallery.find('.wgextra-thumb')
			.on('wgextrain', {
				distance: -100
			}, function (event) {
				if ($(this).hasClass("lazyload-handled"))
					return;

				clearTimeout(lazyLoadTime);

				lazyLoadItems.push(this);

				lazyLoadTime = setTimeout(function () {
					lazyLoadItem.call(lazyLoadItems, $gallery);
					lazyLoadItems = [];
				}, 16);
			});
	}

	/**
	 * Get slides between a rane.
	 *
	 * @param {Number}   start
	 * @param {Number}   end
	 *
	 * @return {Array}
	 */
	function slidesInRange(items, start, end) {
		var slides = [],
			len = items.length, slide, slideStart, slideEnd;

		for (var i = 0; i < len; i++) {
			slide = items[i],
			slideStart = slide.start,
			slideEnd = slideStart + slide.size;

			if ((slideStart >= start && slideEnd <= end) || (slideEnd >= start && slideStart <= start) || (slideStart <= end && slideEnd >= end)) {
				slides.push(slide.element);
			}
		}
		
		return slides;
	}

	function createGallery($gallery) {
		var data = $gallery.data('gallery');

		// Normalize Responsive Values
		var responsive = cleanObject( $.extend( {}, data.responsive ) );

		data.lastDisp = 'desktop';

		responsive.desktop.columns = data.atts.columns;
		responsive.desktop.row_height = data.row_height;
		responsive.desktop.spacing = data.margin;

		responsive.laptop_large = $.extend( {}, responsive.desktop, responsive.laptop_large );
		responsive.laptop       = $.extend( {}, responsive.laptop_large, responsive.laptop );
		responsive.tablet       = $.extend( {}, responsive.laptop, responsive.tablet );
		responsive.tablet_small = $.extend( {}, responsive.tablet, responsive.tablet_small );
		responsive.mobile       = $.extend( {}, responsive.tablet_small, responsive.mobile );

		data.responsive = responsive;

		if (data.template === 'justified') {
			$gallery.find('.wgextra-item')
				.addClass('entry-visible');

			$gallery.justifiedGallery({
					selector: '.wgextra-item',
					rowHeight: data.row_height || 150,
					maxRowHeight: data.max_row_height || '200%',
					lastRow: data.last_row || 'nojustify',
					margins: data.margin || 0,
					captions: false,
					waitThumbnailsLoad: false
				})
				.on('jg.complete', function () {
					if (data.loading_type === 'indicator' && data.loading_grid_animation) {
						GridLoaderRender.call({
							el: $gallery[0],
							items: $gallery.find('.wgextra-thumb > a, .wgextra-thumb > img').toArray()
						}, data.loading_grid_animation);
					}
					// Initialize lazy loader
					else if (data.loading_type === 'lazyload') {
						initializeLazyLoad($gallery);
					}
				});
		} else if (data.template === 'masonry') {
			$gallery.masonry({
				itemSelector: '.wgextra-item',
				columnWidth: '.wgextra-grid-size',
				percentPosition: true,
				/*horizontalOrder: true,*/
				transitionDuration: 0,
				resize: false
			});

			$gallery.addClass('wgextra-masonry-initialized');

			if (data.loading_type !== 'indicator') {
				$gallery.imagesLoaded()
					.progress(debounce(function () {
						$gallery.masonry('layout');
						refreshTilt($gallery);
					}, 100));
			}
		} else if (data.template === 'mosaic') {
			$gallery.masonry({
				itemSelector: '.wgextra-item',
				columnWidth: '.wgextra-grid-size',
				percentPosition: true,
				transitionDuration: 0,
				resize: false
			});

			$gallery.addClass('wgextra-mosaic-initialized');

			if (data.loading_type !== 'indicator') {
				$gallery.imagesLoaded()
					.progress(debounce(function () {
						$gallery.masonry('layout');
						refreshTilt($gallery);
					}, 100));
			}
		} else if (data.template === 'slider') {
			var $frame = $gallery.find('.wgextra-frame'),
				$items = $frame.find('.wgextra-item'),
				frameSize = $frame.width(),
				sliderSettings = data.slider_settings,
				sliderStyles = data.slider_styles,
				lightboxData = getLightBoxItems( $gallery ),
				thumbnailsOptions = {},
				pagesOptions = {};

			$items.each(function (i) {
				var $this = $(this),
					itemData = $this.data(),
					mSData = {};

				mSData.thumbnail = itemData.medium;

				if (data.lightbox_type === 'none') {
					var itemLightData = lightboxData[i];

					if(itemLightData && ['_video', '_audio', '_lightbox'].indexOf(itemData.details.link_target) !== -1) {
						mSData.type = 'iframe';
						mSData.source = itemLightData.src;
					}
				}

				if (itemData.details.link_target === '_video')
					mSData.icon = 'video';
				else if (itemData.details.link_target === '_audio')
					mSData.icon = 'audio';
				else if (itemData.details.link_target === '_lightbox')
					mSData.icon = 'iframe';

				mSData.itemData = itemData;

				var mSDataStringify = JSON.stringify(mSData);
				$this.data('mightyslider', mSDataStringify.substr(1, mSDataStringify.length - 2) );
			});

			if (data.lightbox_type === 'none') {
				$gallery.on('msclick', 'a.open-in-lightbox', function (event) {
					event.preventDefault();
					$(this).parents('.wgextra-item').find('.mSIcon').trigger('msclick');
				});
			}

			if (['boxed', 'fullwidth'].indexOf(sliderSettings.sizing_method) !== -1) {
				$frame.attr('data-mightyslider', "width: " + (sliderSettings.width || $frame.outerWidth()) + ", height: " + (sliderSettings.height || $frame.outerHeight()) );
			}

			if (data.atts.columns == '1' && sliderSettings.slides_sizing_method === 'equal_columns') {
				sliderSettings.type = 'forceCentered';
			}

			if (sliderSettings.thumbnails === 'yes' && thumbnailsStyles[sliderStyles.thumbnails.skin]) {
				thumbnailsOptions = $.extend({
					thumbnailsBar: $gallery.find('[rel="wgextra-thumbnails-bar"]'),
					horizontal: ['top', 'bottom'].indexOf(sliderStyles.thumbnails.position) !== -1,
					thumbnailNav: 'centered',
					watchCSS: true,
					preloadThumbnails: false,
					activateOn: 'click',
					scrollBy: 1,
					mouseDragging: true,
					touchDragging: true
				}, thumbnailsStyles[sliderStyles.thumbnails.skin]);

				var thumbnailsTemplateCompile = _.template(thumbnailsOptions.html),
					thumbnailsTemplateObject = { galleryData: data };

				thumbnailsOptions.thumbnailBuilder = function (index, thumbnail) {
					var slide = this.slides[index];

					thumbnailsTemplateObject.index = index;
					thumbnailsTemplateObject.thumbnail = thumbnail;
					thumbnailsTemplateObject.slideData = slide.options;
					return thumbnailsTemplateCompile(thumbnailsTemplateObject);
				};
			}

			if (sliderSettings.bullets === 'yes') {
				pagesOptions = $.extend({
					pagesBar: $gallery.find('[rel="wgextra-bullets"]'),
					activateOn: 'click',
				}, bulletsStyles[sliderStyles.bullets.skin] || bulletsStyles.default);

				var bulletsTemplateCompile = _.template(pagesOptions.html),
					bulletsTemplateObject = { galleryData: data };

				pagesOptions.pageBuilder = function (index) {
					var slide = this.slides[index];

					bulletsTemplateObject.index = index;
					bulletsTemplateObject.slideData = slide.options;
					return bulletsTemplateCompile(bulletsTemplateObject);
				};
			}

			var slider = new mightySlider($frame, {
				// Mixed options
				speed:       sliderSettings.speed,
				easing:      sliderSettings.easing,
				startAt:     sliderSettings.start_at,
				startRandom: sliderSettings.start_random === 'yes',
				autoScale:   sliderSettings.auto_scale === 'yes',
				watchCSS:    sliderSettings.slides_sizing_method === 'equal_columns',

				// Navigation
				navigation: {
					horizontal:     sliderSettings.mode === 'horizontal',
					navigationType: sliderSettings.type,
					slideSelector:  '.wgextra-item',
					smart:          true,
					activateOn:     'click',
					activateMiddle: true,
					keyboardNavBy:  sliderSettings.keyboard_navigation,
					loop:           sliderSettings.loop === 'yes',
					freeScroll:     sliderSettings.free_scroll === 'yes'
				},

				// Scrolling
				scrolling: {
					scrollBy: sliderSettings.scrolling
				},

				// Dragging
				dragging: {
					mouseDragging: sliderSettings.mouse_dragging === 'yes',
					touchDragging: sliderSettings.touch_dragging === 'yes',
					releaseSwing: sliderSettings.release_swing === 'yes',
					elasticBounds: sliderSettings.elastic_bounds === 'yes',
					onePage: sliderSettings.one_page_drag === 'yes'
				},

				// Automated cycling
				cycling: {
					cycleBy:       sliderSettings.cycle_by,
					pauseTime:     sliderSettings.pause_time,
					loop:          sliderSettings.repeat_cycling === 'yes',
					pauseOnHover:  sliderSettings.pause_on_hover === 'yes',
					startPaused:   sliderSettings.start_paused === 'yes'
				},

				// Scrollbar
				scrollBar: {
					scrollBarSource: $gallery.find('[rel="wgextra-scrollbar"]'),
					dragHandle: sliderSettings.scrollbar_drag_handle === 'yes',
					dynamicHandle: sliderSettings.scrollbar_dynamic_handle === 'yes',
					clickBar: sliderSettings.scrollbar_clickable === 'yes',
					minHandleSize: sliderSettings.scrollbar_min_handle_size
				},

				// Pages
				pages: pagesOptions,

				// Thumbnails
				thumbnails: thumbnailsOptions,

				// Navigation buttons
				buttons: {
					forward: $gallery.find('[rel="wgextra-forward"]'),
					backward: $gallery.find('[rel="wgextra-backward"]'),
					prev: $gallery.find('[rel="wgextra-prev"]'),
					next: $gallery.find('[rel="wgextra-next"]'),
					prevPage: $gallery.find('[rel="wgextra-prev-page"]'),
					nextPage: $gallery.find('[rel="wgextra-next-page"]'),
					fullScreen: $gallery.find('[rel="wgextra-fullscreen"]')
				}
			});

			// Initialize lazy loader
			if (data.loading_type === 'lazyload')
				slider.on('load moveEnd', function (eventName) {
					if (eventName === 'load') {
						frameSize = $frame.width();
					}

					var pos = slider.position,
						start, end;

					/*
					*/

					if ( data.loading_grid_animation ) {
						start = within(pos.current + 5, pos.start, pos.end),
						end = within(pos.current + frameSize - 5, pos.start, pos.end + frameSize);
					} else {
						start = within(pos.current - frameSize, pos.start, pos.end),
						end = within(pos.current + (frameSize * 2) - 5, pos.start, pos.end + (frameSize * 2));
					}

					lazyLoadItem.call(slidesInRange(slider.slides, start, end), $gallery);
				});

			// Initialize grid loading animation
			if (data.loading_type === 'indicator' && data.loading_grid_animation) {
				slider.one('load', function (eventName) {
					GridLoaderRender.call({
						el: $gallery[0],
						items: $gallery.find('.wgextra-thumb > a, .wgextra-thumb > img').toArray()
					}, data.loading_grid_animation);
				});
			}

			if (sliderSettings.arrows === 'yes' && arrowsStyles[sliderStyles.arrows.skin]) {
				var $arrows = $gallery.find('.wgextra-arrows'),
					$prevArrow = $arrows.filter('.wgextra-prev'),
					$nextArrow = $arrows.filter('.wgextra-next'),
					arrowsTemplateCompile = _.template(arrowsStyles[sliderStyles.arrows.skin]);

				slider.on('load active', function (eventName) {
					var slides = this.slides,
						currentIndex = this.relative.activeSlide,
						prevIndex = currentIndex <= 0 ? slides.length - 1 : currentIndex - 1,
						nextIndex = currentIndex >= slides.length - 1 ? 0 : currentIndex + 1,
						prevSlide = slides[prevIndex],
						nextSlide = slides[nextIndex];

					$prevArrow.html( arrowsTemplateCompile({ itemData: prevSlide.options.itemData, galleryData: data, button: 'prev' }) );
					$nextArrow.html( arrowsTemplateCompile({ itemData: nextSlide.options.itemData, galleryData: data, button: 'next' }) );
				});
			}

			// Time Loader Add-on
			if (sliderSettings.cycle_by && sliderStyles.time_loader.appearance !== 'none') {
				if (sliderStyles.time_loader.appearance === 'line') {
					var $lineLoader = $('<div/>', {
						class: 'timeLoader'
					}).append('<div><div></div></div>');

					$lineLoader.appendTo($frame);

					var $firstDiv = $lineLoader.find("> div"),
						$secondDiv = $firstDiv.find("> div"),
						isHorizontal = sliderStyles.time_loader.position.indexOf('top') !== -1 || sliderStyles.time_loader.position.indexOf('bottom') !== -1 || sliderStyles.time_loader.position.indexOf('middle-center') !== -1;

					// Set loader track styles
					var lineLoaderCss = {
						'padding': sliderStyles.time_loader.track_space || '',
						'background': sliderStyles.time_loader.track_color || ''
					};
					lineLoaderCss[isHorizontal ? 'height' : 'width'] = sliderStyles.time_loader.stroke_size;
					if (sliderStyles.time_loader.position.indexOf('top') !== -1)
						lineLoaderCss.top = sliderStyles.time_loader.offset;
					if (sliderStyles.time_loader.position.indexOf('bottom') !== -1)
						lineLoaderCss.bottom = sliderStyles.time_loader.offset;
					if (sliderStyles.time_loader.position.indexOf('left') !== -1)
						lineLoaderCss.left = sliderStyles.time_loader.offset;
					if (sliderStyles.time_loader.position.indexOf('right') !== -1)
						lineLoaderCss.right = sliderStyles.time_loader.offset;
					if (sliderStyles.time_loader.line_cap === 'round')
						lineLoaderCss.borderRadius = '100px';
					$lineLoader.css(lineLoaderCss);

					// Set loader color
					if(sliderStyles.time_loader.loader_color.type === 'solid')
						$secondDiv.css('background', sliderStyles.time_loader.loader_color.solid.color);
					if(sliderStyles.time_loader.line_cap === 'round')
						$secondDiv.css('border-radius', '100px');

					slider.on('progress', function (eventName, percent) {
						if (transform) {
							$secondDiv[0].style[transform] = gpuAcceleration + (isHorizontal ? 'translateX' : 'translateY') + '(' + (-(1 - percent) * 100) + '%)';
						} else {
							$secondDiv[0].style[isHorizontal ? 'left' : 'top'] = (-(1 - percent) * 100) + '%';
						}
					});
					$lineLoader.on('click', slider.toggleCycling);
				} else {
					var UISettings = _.pick({
						mode: sliderStyles.time_loader.skin === 'default' ? sliderStyles.time_loader.appearance : false,
						barColor: sliderStyles.time_loader.loader_color.type !== 'none' ? sliderStyles.time_loader.loader_color : false,
						trackColor: sliderStyles.time_loader.track_color,
						scaleColor: sliderStyles.time_loader.scale_color,
						scaleLength: sliderStyles.time_loader.scale_length,
						txtColor: sliderStyles.time_loader.counter === 'default' ? false : (sliderStyles.time_loader.counter === 'yes' ? sliderStyles.time_loader.counter_color : 0),
						lineCap: sliderStyles.time_loader.line_cap,
						lineWidth: sliderStyles.time_loader.stroke_size,
						trackSpace: sliderStyles.time_loader.track_space,
						size: sliderStyles.time_loader.circle_diameter,
						rotate: sliderStyles.time_loader.rotate,
						position: sliderStyles.time_loader.position,
						offset: sliderStyles.time_loader.offset,
						reverse: sliderStyles.time_loader.reverse === 'default' ? false : (sliderStyles.time_loader.reverse === 'yes' ? 1 : 0)
					}, function(value, key, object) {
						//return _.isNumber(value);
						if (value === false)
							return false;
						else if (_.isString(value) && $.trim(value).length <= 0)
							return false;

						return true;
					});

					var timeLoaderSettings = $.extend(
						{},
						mightySlider.timeLoader.defaults,
						timeLoaderSkins[sliderStyles.time_loader.skin],
						UISettings
					);

					if (_.isObject(timeLoaderSettings.barColor)) {
						if (timeLoaderSettings.barColor.type === 'solid') {
							timeLoaderSettings.barColor = timeLoaderSettings.barColor.solid.color;
						} else if (timeLoaderSettings.barColor.type === 'gradient') {
							var startColor = timeLoaderSettings.barColor.gradient.start_color,
								stopColor = timeLoaderSettings.barColor.gradient.stop_color,
								orientation = timeLoaderSettings.barColor.gradient.orientation;

							timeLoaderSettings.barColor = function () {
								var ctx = this.ctx,
									canvas = this.canvas, gradient,
									width_half = canvas.width / 2;

								if (orientation === 'radial') {
									gradient = ctx.createRadialGradient(0, 0, width_half, 0, 0, 0);
								} else {
									gradient = ctx.createLinearGradient(-width_half, 0, width_half, 0);
								}

								gradient.addColorStop(0, startColor);
								gradient.addColorStop(1, stopColor);

								return gradient;
							};
						}
					}

					new mightySlider.timeLoader(slider, timeLoaderSettings);
				}
			}

			// Animate.css Add-on
			if (data.atts.columns == '1' && sliderSettings.slides_sizing_method === 'equal_columns' && (sliderSettings.animation_out.length || sliderSettings.animation_in.length)) {
				mightySlider.animateCSS(slider, {
					animateEasing: sliderSettings.easing,
					animateIn: sliderSettings.animation_in,
					animateOut: sliderSettings.animation_out
				});
			}

			// Ken Burns Add-on
			if (sliderSettings.kenburns_mode && sliderSettings.type === 'forceCentered') {
				mightySlider.kenBurns(slider, {
					duration: sliderSettings.kenburns_duration,
					transitions: sliderSettings.kenburns_mode === 'both' ? ['In', 'Out'] : [sliderSettings.kenburns_mode],
					reverse: sliderSettings.kenburns_reverse === 'yes'
				});
			}

			slider.init();

			$gallery.data('mightySlider', slider);

			$gallery.addClass('wgextra-slider-initialized');

			if (data.loading_type !== 'indicator' && data.loading_type !== 'lazyload') {
				$gallery.imagesLoaded()
					.progress(debounce(function(){
						$frame.mightySlider('reload');
						refreshTilt($gallery);
					}, 100));
			}

			if (sliderSettings.mode === 'vertical' && sliderSettings.sizing_method === 'fullscreen') {
				$win.on('load', function(){
					slider.reload();
				});
			}

			var numberPattern = /\d+/g;
			$gallery.on('click', '[rel^="wgextra-to-start"], [rel^="wgextra-to-center"], [rel^="wgextra-to-end"]', function(){
				var rel = $(this).attr('rel'),
					action = rel.replace('wgextra-', '').replace('to-start', 'toStart').replace('to-center', 'toCenter').replace('to-end', 'toEnd'),
					index = rel.match( numberPattern );

				if(index)
					slider[action](index[0]);
				else
					slider[action]();
			}).on('click', '[rel^="wgextra-go-to-"]', function(){
				var index = $(this).attr('rel').match( numberPattern );
				if(index)
					slider.activate(index[0]);
			}).on('click', '[rel^="wgextra-slide-to-"]', function(){
				var position = $(this).attr('rel').match( numberPattern );
				if(position)
					slider.slideTo(position[0]);
			}).on('click', '[rel="wgextra-pause"], [rel="wgextra-resume"], [rel="wgextra-toggle-cycling"]', function(){
				var action = $(this).attr('rel').replace('wgextra-', '').replace('toggle-cycling', 'toggleCycling');
				slider[action]();
			});
		}

		if (data.tilt) {
			if (data.tilt.mode === 'item') {
				var tiltSelector = '.wgextra-item';
				data.tilt.glareHolder = '.wgextra-thumb';
			} else {
				var tiltSelector = '.wgextra-thumb';
			}

			var tiltInstance = $gallery.find(tiltSelector)
				.WGExtraTilt(data.tilt);
			$gallery.data('tiltInstance', tiltInstance);
		}

		// Initialize Lightbox
		if (data.lightbox_type !== 'none') {
			initializeLightbox($gallery);
		}

		if (data.template !== 'justified' && data.template !== 'slider') {
			// Initialize grid loading animation
			if (data.loading_type === 'indicator' && data.loading_grid_animation) {
				GridLoaderRender.call({
					el: $gallery[0],
					items: $gallery.find('.wgextra-thumb > a, .wgextra-thumb > img').toArray()
				}, data.loading_grid_animation);
			}
			// Initialize lazy loader
			else if (data.loading_type === 'lazyload') {
				initializeLazyLoad($gallery);
			}
		}

		$gallery.addClass('wgextra-ready');

		$gallery.find('[data-focus-point][data-thumb-cropped="no"]').each(function () {
			var $item = $(this),
				$img = $item.find('img'),
				focusPoint = $item.data( 'focus-point' );

			if (focusPoint) {
				$img
				.data( 'focus-left', focusPoint[0] )
				.data( 'focus-top', focusPoint[1] )
				.data( 'focus-right', focusPoint[2] )
				.data( 'focus-bottom', focusPoint[3] )
				;
			}
		});

		// Refresh Gallery
		setTimeout(function(){
			refreshGallery($gallery, 'resize');
		}, 50);

		if ( data.grouped_items_mode === 'slider' && data.loading_type !== 'lazyload' )
			createGroupsSliders($gallery.find('.wgextra-item'));
	}

	function getResponsiveDisplay(responsive, windowWidth) {
		var display = 'desktop';

		if ( !windowWidth )
			windowWidth = $win.innerWidth();

		var desktopWidth = parseInt( responsive.desktop.size ),
			laptopLargeWidth = parseInt( responsive.laptop_large.size ),
			laptopWidth = parseInt( responsive.laptop.size ),
			tabletWidth = parseInt( responsive.tablet.size ),
			tabletSmallWidth = parseInt( responsive.tablet_small.size ),
			mobileWidth = parseInt( responsive.mobile.size );

		if ( windowWidth >= laptopLargeWidth && windowWidth <= desktopWidth - 1 )
			display = 'laptop_large';
		else if ( windowWidth >= laptopWidth && windowWidth <= laptopLargeWidth - 1 )
			display = 'laptop';
		else if ( windowWidth >= tabletWidth && windowWidth <= laptopWidth - 1 )
			display = 'tablet';
		else if ( windowWidth >= tabletSmallWidth && windowWidth <= tabletWidth - 1 )
			display = 'tablet_small';
		else if ( windowWidth >= mobileWidth && windowWidth <= tabletSmallWidth - 1 )
			display = 'mobile';

		return display;
	}

	function refreshGallery($gallery, refreshType) {
		var data = $gallery.data('gallery');

		$doc.trigger('scroll');

		if (refreshType === 'resize') {
			var windowWidth = $win.innerWidth(),
				responsive = data.responsive,
				currentDisp = getResponsiveDisplay( responsive, windowWidth );

			if ( data.lastDisp !== currentDisp ) {
				if ( ['columns', 'masonry', 'slider'].indexOf(data.template) !== -1 ) {
					var columns = responsive[currentDisp].columns;

					$gallery.removeClass( function() {
						var toReturn = '',
							classes = this.className.split(' ');

						for( var i = 0; i < classes.length; i++ ) {
							if( /wgextra-columns-\d{1,2}/.test( classes[i] ) ) {
								toReturn += classes[i] +' ';
							}
						}

						return toReturn;
					} );
					$gallery.addClass( 'wgextra-columns-' + columns );
				} else if (data.template === 'justified') {
					var rowHeight = responsive[currentDisp].row_height;
					$gallery.justifiedGallery( { rowHeight: rowHeight } );
				}

				data.lastDisp = currentDisp;
			}

			if (data.template === 'mosaic') {
				var galleryWidth = $gallery.outerWidth();

				$gallery.find('.wgextra-item')
					.each(function () {
						var $this = $(this),
							className = this.className,
							rows_regex = /rows-(\d+\-\d+)/g,
							rows = rows_regex.exec(className);

						if (rows) {
							if (windowWidth <= 1199 && windowWidth >= 768)
								rows[1] = '4-12';
							else if (windowWidth <= 767 && windowWidth >= 480)
								rows[1] = '6-12';
							else if (windowWidth <= 479)
								rows[1] = '12-12';

							$this.css('height', galleryWidth * eval(rows[1].replace('-', '/')));
						}
					});
			}

			setImageSizes($gallery);

			if ($gallery.is('.wgextra-mosaic-initialized, .wgextra-masonry-initialized')) {
				$gallery.masonry('layout');
			} else if ($gallery.is('.wgextra-slider-initialized')) {
				$gallery.data('mightySlider').reload();
			}

			refreshTilt($gallery);
		} else if (refreshType === 'dom') {
			// Refresh lightbox items
			data.items = getLightBoxItems($gallery);
		}
	}

	function setImageSizes($gallery) {
		var data = $gallery.data('gallery');
		var $imgs = $gallery.find('img');

		if ($gallery.is('.wgextra-columns, .wgextra-masonry')) {
			$imgs.each(function (i, img) {
				var $img = $(img),
					$parent = $img.parent(),
					parentWidth = $parent.width(),
					imgWidth = parseFloat(img.getAttribute('width')),
					imgHeight = parseFloat(img.getAttribute('height')),
					factor, height;

				factor = parentWidth / imgWidth;
				height = factor > 0 ? imgHeight * factor : '';

				$img.css({
					'height': height
				});
			});

			if ( data.thumbnail_ratio && data.thumbnail_ratio.type !== 'default' ) {
				var $thumbnails = $gallery.find('.wgextra-thumb');
				$thumbnails.each(function () {
					var $thumbnail = $(this),
						width = $thumbnail.width(),
						factor, height;

						var thumbnailRatio = $thumbnail.parents('.wgextra-item').eq(0).data('thumb-ratio'),
							ratio = data.thumbnail_ratio.size;

						if ( data.thumbnail_ratio.force === "no" && thumbnailRatio ) {
							ratio = $.trim( thumbnailRatio ).split( ':' );
						}

						factor = Number( ratio[0] ) / Number( ratio[1] );
						height = factor > 0 ? width / factor : '';

					$thumbnail.css({
						'height': height,
						'overflow': 'hidden'
					});
				});
			}
		} else if ($gallery.is('.wgextra-slider')) {
			$imgs.each(function (i, img) {
				var $img = $(img),
					$parent = $img.parent(),
					parentHeight = $parent.height(),
					imgWidth = parseFloat(img.getAttribute('width')),
					imgHeight = parseFloat(img.getAttribute('height')),
					factor = parentHeight / imgHeight;

				if(factor > 0)
					$img.css({
						'width': imgWidth * factor
					});
				else
					$img.css({
						'width': ''
					});
			});
		}

		$gallery.find('[data-focus-point][data-thumb-cropped="no"] img').responsify();
	}

	function refreshTilt($gallery) {
		var tiltInstance = $gallery.data('tiltInstance');
		if (tiltInstance) {
			tiltInstance.WGExtraTilt.reset.call(tiltInstance);
		}
	}

	function createGroupsSliders($items) {
		$items.find('.wgextra-inline-slider').each(function(){
			var content = this.getAttribute('data-content'),
				iframeEl = document.createElement("iframe"),
				iframe;

			this.removeAttribute('data-content');

			iframeEl.setAttribute('scrolling', 'no');
			iframeEl.setAttribute('allowtransparency', 'true');
			iframeEl.setAttribute('frameborder', '0');
			iframeEl.style.visibility = 'hidden';

			this.appendChild(iframeEl);

			iframe = iframeEl.contentWindow || iframeEl.contentDocument;
			iframe.document.open();
			iframe.document.write(content);
			iframe.document.close();
			var loadFn = function(e) {
				iframeEl.style.visibility = null;
				// remove this handler
				iframeEl.removeEventListener(e.type, arguments.callee);
			};
			iframeEl.addEventListener("load", loadFn);
		});
	}

	var $visibleGalleries = $FIND('.wgextra-gallery:visible'),
		$hiddenGalleries = $FIND('.wgextra-gallery:hidden'),
		galleriesLoopFn = function () {
			var $gallery = $(this);

			if ($gallery.hasClass('wgextra-initialized')) {
				return true;
			}

			if ($gallery.hasClass('wgextra-loading-indicator')) {
				$gallery.imagesLoaded().always(function () {
					$gallery.removeClass('wgextra-loading-indicator');
					//setImageSizes($gallery);
					createGallery($gallery);
				});
			} else {
				//setImageSizes($gallery);
				createGallery($gallery);
			}

			$gallery.addClass('wgextra-initialized');
		};

	$visibleGalleries.each(galleriesLoopFn);

	$hiddenGalleries.one('visible', galleriesLoopFn);

	$doc
	.on('mouseenter.wgextra mouseleave.wgextra', '.wgextra-thumb', function(event) {
		if (event.type === 'mouseenter') {
			$(this).addClass('mouseentered').removeClass('mouseleaved');
		} else {
			$(this).addClass('mouseleaved').removeClass('mouseentered');
		}
	});

	$win.on('resize load', debounce(function (event) {
		$FIND('.wgextra-frame').mightySlider('reload');

		$FIND('.wgextra-gallery').each(function () {
			// Regresh Gallery
			refreshGallery($(this), 'resize');
		});
	}, wgextra.debounce_resize === 'yes' ? 200 : 16));
}(document, this, window.jQuery));