/**
 * http://github.com/Valums-File-Uploader/file-uploader
 *
 * Multiple file upload component with progress-bar, drag-and-drop, support for all modern browsers.
 *
 * Original version: 1.0  2010 Andrew Valums ( andrew(at)valums.com )
 * Current Maintainer (2.0+):  2012, Ray Nicholus ( fineuploader(at)garstasio.com )
 *
 * Licensed under MIT license, GNU GPL 2 or later, GNU LGPL 2 or later, see license.txt.
 */
/*globals window, navigator, document, FormData, File, HTMLInputElement, XMLHttpRequest*/
var qq=function(a){return{hide:function(){a.style.display="none";return this},attach:function(b,c){a.addEventListener?a.addEventListener(b,c,!1):a.attachEvent&&a.attachEvent("on"+b,c);return function(){qq(a).detach(b,c)}},detach:function(b,c){a.removeEventListener?a.removeEventListener(b,c,!1):a.attachEvent&&a.detachEvent("on"+b,c);return this},contains:function(b){return a===b?!0:a.contains?a.contains(b):!!(b.compareDocumentPosition(a)&8)},insertBefore:function(b){b.parentNode.insertBefore(a,b);
return this},remove:function(){a.parentNode.removeChild(a);return this},css:function(b){null!==b.opacity&&("string"!==typeof a.style.opacity&&"undefined"!==typeof a.filters)&&(b.filter="alpha(opacity="+Math.round(100*b.opacity)+")");qq.extend(a.style,b);return this},hasClass:function(b){return RegExp("(^| )"+b+"( |$)").test(a.className)},addClass:function(b){qq(a).hasClass(b)||(a.className+=" "+b);return this},removeClass:function(b){a.className=a.className.replace(RegExp("(^| )"+b+"( |$)")," ").replace(/^\s+|\s+$/g,
"");return this},getByClass:function(b){var c,e=[];if(a.querySelectorAll)return a.querySelectorAll("."+b);c=a.getElementsByTagName("*");qq.each(c,function(a,c){qq(c).hasClass(b)&&e.push(c)});return e},children:function(){for(var b=[],c=a.firstChild;c;)1===c.nodeType&&b.push(c),c=c.nextSibling;return b},setText:function(b){a.innerText=b;a.textContent=b;return this},clearText:function(){return qq(a).setText("")}}};
qq.log=function(a,b){if(window.console)if(!b||"info"===b)window.console.log(a);else if(window.console[b])window.console[b](a);else window.console.log("<"+b+"> "+a)};qq.isObject=function(a){return null!==a&&a&&"object"===typeof a&&a.constructor===Object};qq.isFunction=function(a){return"function"===typeof a};
qq.isFileOrInput=function(a){if(window.File&&a instanceof File)return!0;if(window.HTMLInputElement){if(a instanceof HTMLInputElement&&a.type&&"file"===a.type.toLowerCase())return!0}else if(a.tagName&&"input"===a.tagName.toLowerCase()&&a.type&&"file"===a.type.toLowerCase())return!0;return!1};qq.isXhrUploadSupported=function(){var a=document.createElement("input");a.type="file";return void 0!==a.multiple&&"undefined"!==typeof File&&"undefined"!==typeof FormData&&"undefined"!==typeof(new XMLHttpRequest).upload};
qq.isFolderDropSupported=function(a){return a.items&&a.items[0].webkitGetAsEntry};qq.isFileChunkingSupported=function(){return!qq.android()&&qq.isXhrUploadSupported()&&(File.prototype.slice||File.prototype.webkitSlice||File.prototype.mozSlice)};qq.extend=function(a,b,c){qq.each(b,function(b,d){c&&qq.isObject(d)?(void 0===a[b]&&(a[b]={}),qq.extend(a[b],d,!0)):a[b]=d})};
qq.indexOf=function(a,b,c){if(a.indexOf)return a.indexOf(b,c);c=c||0;var e=a.length;for(0>c&&(c+=e);c<e;c+=1)if(a.hasOwnProperty(c)&&a[c]===b)return c;return-1};qq.getUniqueId=function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=16*Math.random()|0;return("x"==a?b:b&3|8).toString(16)})};qq.ie=function(){return-1!==navigator.userAgent.indexOf("MSIE")};qq.ie10=function(){return-1!==navigator.userAgent.indexOf("MSIE 10")};
qq.safari=function(){return void 0!==navigator.vendor&&-1!==navigator.vendor.indexOf("Apple")};qq.chrome=function(){return void 0!==navigator.vendor&&-1!==navigator.vendor.indexOf("Google")};qq.firefox=function(){return-1!==navigator.userAgent.indexOf("Mozilla")&&void 0!==navigator.vendor&&""===navigator.vendor};qq.windows=function(){return"Win32"===navigator.platform};qq.android=function(){return-1!==navigator.userAgent.toLowerCase().indexOf("android")};
qq.preventDefault=function(a){a.preventDefault?a.preventDefault():a.returnValue=!1};qq.toElement=function(){var a=document.createElement("div");return function(b){a.innerHTML=b;b=a.firstChild;a.removeChild(b);return b}}();qq.each=function(a,b){var c,e;if(a)for(c in a)if(Object.prototype.hasOwnProperty.call(a,c)&&(e=b(c,a[c]),!1===e))break};
qq.obj2url=function(a,b,c){var e,d=[],f="&",l=function(a,c){var e=b?/\[\]$/.test(b)?b:b+"["+c+"]":c;"undefined"!==e&&"undefined"!==c&&d.push("object"===typeof a?qq.obj2url(a,e,!0):"[object Function]"===Object.prototype.toString.call(a)?encodeURIComponent(e)+"="+encodeURIComponent(a()):encodeURIComponent(e)+"="+encodeURIComponent(a))};if(!c&&b)f=/\?/.test(b)?/\?$/.test(b)?"":"&":"?",d.push(b),d.push(qq.obj2url(a));else if("[object Array]"===Object.prototype.toString.call(a)&&"undefined"!==typeof a){e=
-1;for(c=a.length;e<c;e+=1)l(a[e],e)}else if("undefined"!==typeof a&&null!==a&&"object"===typeof a)for(e in a)a.hasOwnProperty(e)&&l(a[e],e);else d.push(encodeURIComponent(b)+"="+encodeURIComponent(a));return b?d.join(f):d.join(f).replace(/^&/,"").replace(/%20/g,"+")};
qq.obj2FormData=function(a,b,c){b||(b=new FormData);qq.each(a,function(a,d){a=c?c+"["+a+"]":a;qq.isObject(d)?qq.obj2FormData(d,b,a):qq.isFunction(d)?b.append(encodeURIComponent(a),encodeURIComponent(d())):b.append(encodeURIComponent(a),encodeURIComponent(d))});return b};qq.obj2Inputs=function(a,b){var c;b||(b=document.createElement("form"));qq.obj2FormData(a,{append:function(a,d){c=document.createElement("input");c.setAttribute("name",a);c.setAttribute("value",d);b.appendChild(c)}});return b};
qq.setCookie=function(a,b,c){var e=new Date,d="";c&&(e.setTime(e.getTime()+864E5*c),d="; expires="+e.toGMTString());document.cookie=a+"="+b+d+"; path=/"};qq.getCookie=function(a){a+="=";for(var b=document.cookie.split(";"),c,e=0;e<b.length;e++){for(c=b[e];" "==c.charAt(0);)c=c.substring(1,c.length);if(0===c.indexOf(a))return c.substring(a.length,c.length)}};
qq.getCookieNames=function(a){var b=document.cookie.split(";"),c=[];qq.each(b,function(b,d){d=d.trim();var f=d.indexOf("=");d.match(a)&&c.push(d.substr(0,f))});return c};qq.deleteCookie=function(a){qq.setCookie(a,"",-1)};qq.areCookiesEnabled=function(){var a="qqCookieTest:"+1E5*Math.random();qq.setCookie(a,1);return qq.getCookie(a)?(qq.deleteCookie(a),!0):!1};qq.parseJson=function(a){return"function"===typeof JSON.parse?JSON.parse(a):eval("("+a+")")};
qq.DisposeSupport=function(){var a=[];return{dispose:function(){var b;do(b=a.shift())&&b();while(b)},attach:function(){this.addDisposer(qq(arguments[0]).attach.apply(this,Array.prototype.slice.call(arguments,1)))},addDisposer:function(b){a.push(b)}}};
qq.UploadButton=function(a){this._options={element:null,multiple:!1,acceptFiles:null,name:"file",onChange:function(){},hoverClass:"qq-upload-button-hover",focusClass:"qq-upload-button-focus"};qq.extend(this._options,a);this._disposeSupport=new qq.DisposeSupport;this._element=this._options.element;qq(this._element).css({position:"relative",overflow:"hidden",direction:"ltr"});this._input=this._createInput()};
qq.UploadButton.prototype={getInput:function(){return this._input},reset:function(){this._input.parentNode&&qq(this._input).remove();qq(this._element).removeClass(this._options.focusClass);this._input=this._createInput()},_createInput:function(){var a=document.createElement("input");this._options.multiple&&a.setAttribute("multiple","multiple");this._options.acceptFiles&&a.setAttribute("accept",this._options.acceptFiles);a.setAttribute("type","file");a.setAttribute("name",this._options.name);qq(a).css({position:"absolute",
right:0,top:0,fontFamily:"Arial",fontSize:"118px",margin:0,padding:0,cursor:"pointer",opacity:0});this._element.appendChild(a);var b=this;this._disposeSupport.attach(a,"change",function(){b._options.onChange(a)});this._disposeSupport.attach(a,"mouseover",function(){qq(b._element).addClass(b._options.hoverClass)});this._disposeSupport.attach(a,"mouseout",function(){qq(b._element).removeClass(b._options.hoverClass)});this._disposeSupport.attach(a,"focus",function(){qq(b._element).addClass(b._options.focusClass)});
this._disposeSupport.attach(a,"blur",function(){qq(b._element).removeClass(b._options.focusClass)});window.attachEvent&&a.setAttribute("tabIndex","-1");return a}};
qq.UploadHandler=function(a){var b=[],c,e,d,f;c={debug:!1,forceMultipart:!0,paramsInBody:!1,paramsStore:{},endpointStore:{},maxConnections:3,uuidParamName:"qquuid",totalFileSizeParamName:"qqtotalfilesize",chunking:{enabled:!1,partSize:2E6,paramNames:{partIndex:"qqpartindex",partByteOffset:"qqpartbyteoffset",chunkSize:"qqchunksize",totalParts:"qqtotalparts",filename:"qqfilename"}},resume:{enabled:!1,id:null,cookiesExpireIn:7,paramNames:{resuming:"qqresume"}},log:function(){},onProgress:function(){},
onComplete:function(){},onCancel:function(){},onUpload:function(){},onUploadChunk:function(){},onAutoRetry:function(){},onResume:function(){}};qq.extend(c,a);e=c.log;d=function(a){a=qq.indexOf(b,a);var d=c.maxConnections;b.splice(a,1);b.length>=d&&a<d&&(a=b[d-1],f.upload(a))};f=qq.isXhrUploadSupported()?new qq.UploadHandlerXhr(c,d,e):new qq.UploadHandlerForm(c,d,e);return{add:function(a){return f.add(a)},upload:function(a){if(b.push(a)<=c.maxConnections)return f.upload(a)},retry:function(a){return 0<=
qq.indexOf(b,a)?f.upload(a,!0):this.upload(a)},cancel:function(a){e("Cancelling "+a);c.paramsStore.remove(a);f.cancel(a);d(a)},cancelAll:function(){qq.each(b,function(a,b){this.cancel(b)});b=[]},getName:function(a){return f.getName(a)},getSize:function(a){if(f.getSize)return f.getSize(a)},getFile:function(a){if(f.getFile)return f.getFile(a)},getQueue:function(){return b},reset:function(){e("Resetting upload handler");b=[];f.reset()},getUuid:function(a){return f.getUuid(a)},isValid:function(a){return f.isValid(a)},
getResumableFilesData:function(){return f.getResumableFilesData?f.getResumableFilesData():[]}}};
qq.UploadHandlerForm=function(a,b,c){function e(a){var b;try{var c=a.contentDocument||a.contentWindow.document,d=c.body.innerHTML;m("converting iframe's innerHTML to JSON");m("innerHTML = "+d);d&&d.match(/^<pre/i)&&(d=c.body.firstChild.firstChild.nodeValue);b=eval("("+d+")")}catch(e){m("Error when attempting to parse form upload response ("+e+")","error"),b={success:!1}}return b}var d=[],f=[],l={},m=c,h;return h={add:function(b){b.setAttribute("name",a.inputName);var c=d.push(b)-1;f[c]=qq.getUniqueId();
b.parentNode&&qq(b).remove();return c},getName:function(a){return d[a].value.replace(/.*(\/|\\)/,"")},isValid:function(a){return void 0!==d[a]},reset:function(){qq.UploadHandler.prototype.reset.apply(this,arguments);d=[];f=[];l={}},getUuid:function(a){return f[a]},cancel:function(b){a.onCancel(b,this.getName(b));delete d[b];delete f[b];delete l[b];if(b=document.getElementById(b))b.setAttribute("src","java"+String.fromCharCode(115)+"cript:false;"),qq(b).remove()},upload:function(c){var u=d[c],n=h.getName(c),
k=qq.toElement('<iframe src="javascript:false;" name="'+c+'" />');k.setAttribute("id",c);k.style.display="none";document.body.appendChild(k);var s=a.paramsStore.getParams(c),g=qq.toElement('<form method="'+(a.demoMode?"GET":"POST")+'" enctype="multipart/form-data"></form>'),q=a.endpointStore.getEndpoint(c),v=q;s[a.uuidParamName]=f[c];a.paramsInBody?qq.obj2Inputs(s,g):v=qq.obj2url(s,q);g.setAttribute("action",v);g.setAttribute("target",k.name);g.style.display="none";document.body.appendChild(g);if(!u)throw Error("file with passed id was not added, or already uploaded or cancelled");
a.onUpload(c,this.getName(c));g.appendChild(u);l[k.id]=qq(k).attach("load",function(){m("Received response for "+k.id);if(k.parentNode){try{if(k.contentDocument&&k.contentDocument.body&&"false"==k.contentDocument.body.innerHTML)return}catch(d){m("Error when attempting to access iframe during handling of upload response ("+d+")","error")}m("iframe loaded");var g=e(k);setTimeout(function(){l[c]();delete l[c];qq(k).remove()},1);if(g.success||!a.onAutoRetry(c,n,g))a.onComplete(c,n,g),b(c)}});m("Sending upload request for "+
c);g.submit();qq(g).remove();return c}}};
qq.UploadHandlerXhr=function(a,b,c){function e(a,b){var c=g.chunking.partSize,e=p.getSize(a),n=j[a].file,k=c*b,c=k+c>=e?e:k+c,e=d(a);n=n.slice?n.slice(k,c):n.mozSlice?n.mozSlice(k,c):n.webkitSlice?n.webkitSlice(k,c):void 0;return{part:b,start:k,end:c,count:e,blob:n}}function d(a){a=p.getSize(a);return Math.ceil(a/g.chunking.partSize)}function f(a){j[a].xhr=new XMLHttpRequest;return j[a].xhr}function l(a,b,c,d){var e=new FormData,n=g.demoMode?"GET":"POST",k=g.endpointStore.getEndpoint(d),f=k,s=p.getName(d),
h=p.getSize(d);a[g.uuidParamName]=j[d].uuid;x&&(a[g.totalFileSizeParamName]=h);g.paramsInBody||(a[g.inputName]=s,f=qq.obj2url(a,k));b.open(n,f,!0);return x?(g.paramsInBody&&qq.obj2FormData(a,e),e.append(g.inputName,c),e):c}function m(a,b){var c=g.customHeaders;p.getName(a);var d=j[a].file;b.setRequestHeader("X-Requested-With","XMLHttpRequest");b.setRequestHeader("Cache-Control","no-cache");x||(b.setRequestHeader("Content-Type","application/octet-stream"),b.setRequestHeader("X-Mime-Type",d.type));
qq.each(c,function(a,c){b.setRequestHeader(a,c)})}function h(a,b,c){var d=p.getName(a),e=p.getSize(a);j[a].attemptingResume=!1;g.onProgress(a,d,e,e);g.onComplete(a,d,b,c);delete j[a].xhr;q(a)}function r(a){var b=e(a,j[a].remainingChunkIdxs[0]),c=f(a),d=p.getSize(a),k=p.getName(a),h;void 0===j[a].loaded&&(j[a].loaded=0);h=p.getUuid(a);var r=s(a);qq.setCookie(r,h+t+b.part,g.resume.cookiesExpireIn);c.onreadystatechange=n(a,c);c.upload.onprogress=function(b){if(b.lengthComputable&&j[a].loaded<d)g.onProgress(a,
k,b.loaded+j[a].loaded,d)};g.onUploadChunk(a,k,u(b));h=g.paramsStore.getParams(a);var r=p.getSize(a),q=p.getName(a);h[g.chunking.paramNames.partIndex]=b.part;h[g.chunking.paramNames.partByteOffset]=b.start;h[g.chunking.paramNames.chunkSize]=b.end-b.start;h[g.chunking.paramNames.totalParts]=b.count;h[g.totalFileSizeParamName]=r;x&&(h[g.chunking.paramNames.filename]=q);j[a].attemptingResume&&(h[g.resume.paramNames.resuming]=!0);h=l(h,c,b.blob,a);m(a,c);v("Sending chunked upload request for "+a+": bytes "+
(b.start+1)+"-"+b.end+" of "+d);c.send(h)}function u(a){return{partIndex:a.part,startByte:a.start+1,endByte:a.end,totalParts:a.count}}function n(a,b){return function(){if(4===b.readyState){var c;if(j[a]){v("xhr - server response received for "+a);v("responseText = "+b.responseText);try{c=qq.parseJson(b.responseText)}catch(d){v("Error when attempting to parse xhr response text ("+d+")","error"),c={}}if(200!==b.status||!c.success||c.reset)if(c.reset&&(v("Server has ordered chunking effort to be restarted on next attempt for file ID "+
a,"error"),y&&k(a),j[a].remainingChunkIdxs=[],delete j[a].loaded),j[a].attemptingResume&&c.reset)j[a].attemptingResume=!1,v("Server has declared that it cannot handle resume for file ID "+a+" - starting from the first chunk","error"),p.upload(a,!0);else{var n=p.getName(a);g.onAutoRetry(a,n,c,b)||h(a,c,b)}else z?(n=j[a].remainingChunkIdxs.shift(),n=e(a,n),j[a].attemptingResume=!1,j[a].loaded+=n.end-n.start,0<j[a].remainingChunkIdxs.length?r(a):(k(a),h(a,c,b))):h(a,c,b)}}}}function k(a){a=s(a);qq.deleteCookie(a)}
function s(a){var b=p.getName(a);a=p.getSize(a);var c=g.chunking.partSize,b="qqfilechunk"+t+encodeURIComponent(b)+t+a+t+c;void 0!==w&&(b+=t+w);return b}var g=a,q=b,v=c,j=[],t="|",z=g.chunking.enabled&&qq.isFileChunkingSupported(),y=g.resume.enabled&&z&&qq.areCookiesEnabled(),w;w=null!==g.resume.id&&void 0!==g.resume.id&&!qq.isFunction(g.resume.id)&&!qq.isObject(g.resume.id)?g.resume.id:void 0;var x=g.forceMultipart||g.paramsInBody,p;return p={add:function(a){if(!(a instanceof File))throw Error("Passed obj in not a File (in qq.UploadHandlerXhr)");
a=j.push({file:a})-1;j[a].uuid=qq.getUniqueId();return a},getName:function(a){a=j[a].file;return null!==a.fileName&&void 0!==a.fileName?a.fileName:a.name},getSize:function(a){a=j[a].file;return null!=a.fileSize?a.fileSize:a.size},getFile:function(a){if(j[a])return j[a].file},getLoaded:function(a){return j[a].loaded||0},isValid:function(a){return void 0!==j[a]},reset:function(){j=[]},getUuid:function(a){return j[a].uuid},upload:function(a,b){var c=this.getName(a);g.onUpload(a,c);if(z){var k=p.getName(a),
c=0,h,q;if(!j[a].remainingChunkIdxs||0===j[a].remainingChunkIdxs.length){j[a].remainingChunkIdxs=[];if(y&&!b){q=qq.getCookie(s(a));var w;q?(w=q.indexOf(t),h=q.substr(0,w),q=parseInt(q.substr(w+1,q.length-w),10),h={uuid:h,part:q}):h=void 0;h&&(q=e(a,h.part),!1!==g.onResume(a,k,u(q))&&(c=h.part,j[a].uuid=h.uuid,j[a].loaded=q.start,j[a].attemptingResume=!0,v("Resuming "+k+" at partition index "+c)))}for(k=d(a)-1;k>=c;k-=1)j[a].remainingChunkIdxs.unshift(k)}r(a)}else{var k=j[a].file,x=p.getName(a);j[a].loaded=
0;c=f(a);c.upload.onprogress=function(b){b.lengthComputable&&(j[a].loaded=b.loaded,g.onProgress(a,x,b.loaded,b.total))};c.onreadystatechange=n(a,c);h=g.paramsStore.getParams(a);k=l(h,c,k,a);m(a,c);v("Sending upload request for "+a);c.send(k)}},cancel:function(a){g.onCancel(a,this.getName(a));j[a].xhr&&j[a].xhr.abort();y&&k(a);delete j[a]},getResumableFilesData:function(){var a=[],b=[];return z&&y?(a=void 0===w?qq.getCookieNames(RegExp("^qqfilechunk\\"+t+".+\\"+t+"\\d+\\"+t+g.chunking.partSize+"=")):
qq.getCookieNames(RegExp("^qqfilechunk\\"+t+".+\\"+t+"\\d+\\"+t+g.chunking.partSize+"\\"+t+w+"=")),qq.each(a,function(a,c){var d=c.split(t),e=qq.getCookie(c).split(t);b.push({name:decodeURIComponent(d[1]),size:d[2],uuid:e[0],partIdx:e[1]})}),b):[]}}};
qq.FineUploaderBasic=function(a){this._options={debug:!1,button:null,multiple:!0,maxConnections:3,disableCancelForFormUploads:!1,autoUpload:!0,request:{endpoint:"/server/upload",params:{},paramsInBody:!1,customHeaders:{},forceMultipart:!0,inputName:"qqfile",uuidName:"qquuid",totalFileSizeName:"qqtotalfilesize"},validation:{allowedExtensions:[],sizeLimit:0,minSizeLimit:0,stopOnFirstInvalidFile:!0},callbacks:{onSubmit:function(){},onComplete:function(){},onCancel:function(){},onUpload:function(){},
onUploadChunk:function(){},onResume:function(){},onProgress:function(){},onError:function(){},onAutoRetry:function(){},onManualRetry:function(){},onValidateBatch:function(){},onValidate:function(){}},messages:{typeError:"{file} has an invalid extension. Valid extension(s): {extensions}.",sizeError:"{file} is too large, maximum file size is {sizeLimit}.",minSizeError:"{file} is too small, minimum file size is {minSizeLimit}.",emptyError:"{file} is empty, please select files again without it.",noFilesError:"No files to upload.",
onLeave:"The files are being uploaded, if you leave now the upload will be cancelled."},retry:{enableAuto:!1,maxAutoAttempts:3,autoAttemptDelay:5,preventRetryResponseProperty:"preventRetry"},classes:{buttonHover:"qq-upload-button-hover",buttonFocus:"qq-upload-button-focus"},chunking:{enabled:!1,partSize:2E6,paramNames:{partIndex:"qqpartindex",partByteOffset:"qqpartbyteoffset",chunkSize:"qqchunksize",totalFileSize:"qqtotalfilesize",totalParts:"qqtotalparts",filename:"qqfilename"}},resume:{enabled:!1,
id:null,cookiesExpireIn:7,paramNames:{resuming:"qqresume"}},formatFileName:function(a){33<a.length&&(a=a.slice(0,19)+"..."+a.slice(-14));return a},text:{sizeSymbols:"kB MB GB TB PB EB".split(" ")}};qq.extend(this._options,a,!0);this._wrapCallbacks();this._disposeSupport=new qq.DisposeSupport;this._filesInProgress=[];this._storedFileIds=[];this._autoRetries=[];this._retryTimeouts=[];this._preventRetries=[];this._paramsStore=this._createParamsStore();this._endpointStore=this._createEndpointStore();
this._handler=this._createUploadHandler();this._options.button&&(this._button=this._createUploadButton(this._options.button));this._preventLeaveInProgress()};
qq.FineUploaderBasic.prototype={log:function(a,b){this._options.debug&&(!b||"info"===b)?qq.log("[FineUploader] "+a):b&&"info"!==b&&qq.log("[FineUploader] "+a,b)},setParams:function(a,b){null==b?this._options.request.params=a:this._paramsStore.setParams(a,b)},setEndpoint:function(a,b){null==b?this._options.request.endpoint=a:this._endpointStore.setEndpoint(a,b)},getInProgress:function(){return this._filesInProgress.length},uploadStoredFiles:function(){for(var a;this._storedFileIds.length;)a=this._storedFileIds.shift(),
this._filesInProgress.push(a),this._handler.upload(a)},clearStoredFiles:function(){this._storedFileIds=[]},retry:function(a){return this._onBeforeManualRetry(a)?(this._handler.retry(a),!0):!1},cancel:function(a){this._handler.cancel(a)},reset:function(){this.log("Resetting uploader...");this._handler.reset();this._filesInProgress=[];this._storedFileIds=[];this._autoRetries=[];this._retryTimeouts=[];this._preventRetries=[];this._button.reset();this._paramsStore.reset();this._endpointStore.reset()},
addFiles:function(a){var b=[],c,e;if(a){if(!window.FileList||!(a instanceof FileList))a=[].concat(a);for(c=0;c<a.length;c+=1)e=a[c],qq.isFileOrInput(e)?b.push(e):this.log(e+" is not a File or INPUT element!  Ignoring!","warn");this.log("Processing "+b.length+" files or inputs...");this._uploadFileList(b)}},getUuid:function(a){return this._handler.getUuid(a)},getResumableFilesData:function(){return this._handler.getResumableFilesData()},getSize:function(a){return this._handler.getSize(a)},getFile:function(a){return this._handler.getFile(a)},
_createUploadButton:function(a){var b=this,c=new qq.UploadButton({element:a,multiple:this._options.multiple&&qq.isXhrUploadSupported(),acceptFiles:this._options.validation.acceptFiles,onChange:function(a){b._onInputChange(a)},hoverClass:this._options.classes.buttonHover,focusClass:this._options.classes.buttonFocus});this._disposeSupport.addDisposer(function(){c.dispose()});return c},_createUploadHandler:function(){var a=this;return new qq.UploadHandler({debug:this._options.debug,forceMultipart:this._options.request.forceMultipart,
maxConnections:this._options.maxConnections,customHeaders:this._options.request.customHeaders,inputName:this._options.request.inputName,uuidParamName:this._options.request.uuidName,totalFileSizeParamName:this._options.request.totalFileSizeName,demoMode:this._options.demoMode,paramsInBody:this._options.request.paramsInBody,paramsStore:this._paramsStore,endpointStore:this._endpointStore,chunking:this._options.chunking,resume:this._options.resume,log:function(b,c){a.log(b,c)},onProgress:function(b,c,
e,d){a._onProgress(b,c,e,d);a._options.callbacks.onProgress(b,c,e,d)},onComplete:function(b,c,e,d){a._onComplete(b,c,e,d);a._options.callbacks.onComplete(b,c,e)},onCancel:function(b,c){a._onCancel(b,c);a._options.callbacks.onCancel(b,c)},onUpload:function(b,c){a._onUpload(b,c);a._options.callbacks.onUpload(b,c)},onUploadChunk:function(b,c,e){a._options.callbacks.onUploadChunk(b,c,e)},onResume:function(b,c,e){return a._options.callbacks.onResume(b,c,e)},onAutoRetry:function(b,c,e,d){a._preventRetries[b]=
e[a._options.retry.preventRetryResponseProperty];return a._shouldAutoRetry(b,c,e)?(a._maybeParseAndSendUploadError(b,c,e,d),a._options.callbacks.onAutoRetry(b,c,a._autoRetries[b]+1),a._onBeforeAutoRetry(b,c),a._retryTimeouts[b]=setTimeout(function(){a._onAutoRetry(b,c,e)},1E3*a._options.retry.autoAttemptDelay),!0):!1}})},_preventLeaveInProgress:function(){var a=this;this._disposeSupport.attach(window,"beforeunload",function(b){if(a._filesInProgress.length)return b=b||window.event,b.returnValue=a._options.messages.onLeave})},
_onSubmit:function(a){this._options.autoUpload&&this._filesInProgress.push(a)},_onProgress:function(){},_onComplete:function(a,b,c,e){this._removeFromFilesInProgress(a);this._maybeParseAndSendUploadError(a,b,c,e)},_onCancel:function(a){this._removeFromFilesInProgress(a);clearTimeout(this._retryTimeouts[a]);a=qq.indexOf(this._storedFileIds,a);!this._options.autoUpload&&0<=a&&this._storedFileIds.splice(a,1)},_removeFromFilesInProgress:function(a){a=qq.indexOf(this._filesInProgress,a);0<=a&&this._filesInProgress.splice(a,
1)},_onUpload:function(){},_onInputChange:function(a){qq.isXhrUploadSupported()?this.addFiles(a.files):this.addFiles(a);this._button.reset()},_onBeforeAutoRetry:function(a,b){this.log("Waiting "+this._options.retry.autoAttemptDelay+" seconds before retrying "+b+"...")},_onAutoRetry:function(a,b){this.log("Retrying "+b+"...");this._autoRetries[a]++;this._handler.retry(a)},_shouldAutoRetry:function(a){return!this._preventRetries[a]&&this._options.retry.enableAuto?(void 0===this._autoRetries[a]&&(this._autoRetries[a]=
0),this._autoRetries[a]<this._options.retry.maxAutoAttempts):!1},_onBeforeManualRetry:function(a){if(this._preventRetries[a])return this.log("Retries are forbidden for id "+a,"warn"),!1;if(this._handler.isValid(a)){var b=this._handler.getName(a);if(!1===this._options.callbacks.onManualRetry(a,b))return!1;this.log("Retrying upload for '"+b+"' (id: "+a+")...");this._filesInProgress.push(a);return!0}this.log("'"+a+"' is not a valid file ID","error");return!1},_maybeParseAndSendUploadError:function(a,
b,c,e){if(!c.success)if(e&&200!==e.status&&!c.error)this._options.callbacks.onError(a,b,"XHR returned response code "+e.status);else this._options.callbacks.onError(a,b,c.error?c.error:"Upload failure reason unknown")},_uploadFileList:function(a){var b;b=this._getValidationDescriptors(a);if(!1!==this._options.callbacks.onValidateBatch(b))if(0<a.length)for(b=0;b<a.length;b++)if(this._validateFile(a[b]))this._uploadFile(a[b]);else{if(this._options.validation.stopOnFirstInvalidFile)break}else this._error("noFilesError",
"")},_uploadFile:function(a){a=this._handler.add(a);var b=this._handler.getName(a);!1!==this._options.callbacks.onSubmit(a,b)&&(this._onSubmit(a,b),this._options.autoUpload?this._handler.upload(a):this._storeFileForLater(a))},_storeFileForLater:function(a){this._storedFileIds.push(a)},_validateFile:function(a){var b,c;a=this._getValidationDescriptor(a);b=a.name;c=a.size;if(!1===this._options.callbacks.onValidate(a))return!1;if(this._isAllowedExtension(b)){if(0===c)return this._error("emptyError",
b),!1;if(c&&this._options.validation.sizeLimit&&c>this._options.validation.sizeLimit)return this._error("sizeError",b),!1;if(c&&c<this._options.validation.minSizeLimit)return this._error("minSizeError",b),!1}else return this._error("typeError",b),!1;return!0},_error:function(a,b){var c=this._options.messages[a],e=this._options.validation.allowedExtensions.join(", ").toLowerCase(),d=this._options.formatFileName(b),c=c.replace("{file}",d),c=c.replace("{extensions}",e),e=this._formatSize(this._options.validation.sizeLimit),
c=c.replace("{sizeLimit}",e),e=this._formatSize(this._options.validation.minSizeLimit),c=c.replace("{minSizeLimit}",e);this._options.callbacks.onError(null,b,c);return c},_isAllowedExtension:function(a){var b=this._options.validation.allowedExtensions,c=!1;if(!b.length)return!0;qq.each(b,function(b,d){if(null!=a.match(RegExp("\\."+d+"$","i")))return c=!0,!1});return c},_formatSize:function(a){var b=-1;do a/=1024,b++;while(99<a);return Math.max(a,0.1).toFixed(1)+this._options.text.sizeSymbols[b]},
_wrapCallbacks:function(){var a,b;a=this;b=function(b,c,f){try{return c.apply(a,f)}catch(l){a.log("Caught exception in '"+b+"' callback - "+l.message,"error")}};for(var c in this._options.callbacks)(function(){var e,d;e=c;d=a._options.callbacks[e];a._options.callbacks[e]=function(){return b(e,d,arguments)}})()},_parseFileName:function(a){return a.value?a.value.replace(/.*(\/|\\)/,""):null!==a.fileName&&void 0!==a.fileName?a.fileName:a.name},_parseFileSize:function(a){var b;a.value||(b=null!==a.fileSize&&
void 0!==a.fileSize?a.fileSize:a.size);return b},_getValidationDescriptor:function(a){var b,c;c={};b=this._parseFileName(a);a=this._parseFileSize(a);c.name=b;a&&(c.size=a);return c},_getValidationDescriptors:function(a){var b=this,c=[];qq.each(a,function(a,d){c.push(b._getValidationDescriptor(d))});return c},_createParamsStore:function(){var a={},b=this;return{setParams:function(b,e){var d={};qq.extend(d,b);a[e]=d},getParams:function(c){var e={};null!=c&&a[c]?qq.extend(e,a[c]):qq.extend(e,b._options.request.params);
return e},remove:function(b){return delete a[b]},reset:function(){a={}}}},_createEndpointStore:function(){var a={},b=this;return{setEndpoint:function(b,e){a[e]=b},getEndpoint:function(c){return null!=c&&a[c]?a[c]:b._options.request.endpoint},remove:function(b){return delete a[b]},reset:function(){a={}}}}};
qq.DragAndDrop=function(a){function b(){h===r&&!l&&(d.callbacks.log("Grabbed "+m.length+" files after tree traversal."),f.dropDisabled(!1),d.callbacks.dropProcessing(!1,m))}function c(a){var d;h+=1;a.isFile?a.file(function(a){m.push(a);r+=1;b()}):a.isDirectory&&(l=!0,a=a.createReader(),a.readEntries(function(a){r+=1;for(d=0;d<a.length;d+=1)c(a[d]);l=!1;a.length||b()}))}function e(a){f=new qq.UploadDropZone({element:a,onEnter:function(b){qq(a).addClass(d.classes.dropActive);b.stopPropagation()},onLeaveNotDescendants:function(){qq(a).removeClass(d.classes.dropActive)},
onDrop:function(e){d.hideDropzones&&qq(a).hide();qq(a).removeClass(d.classes.dropActive);e=e.dataTransfer;var s,g;d.callbacks.dropProcessing(!0);f.dropDisabled(!0);if(1<e.files.length&&!d.multiple)d.callbacks.dropProcessing(!1),d.callbacks.error("tooManyFilesError",""),f.dropDisabled(!1);else if(m=[],r=h=0,qq.isFolderDropSupported(e)){s=e.items;for(e=0;e<s.length;e+=1)if(g=s[e].webkitGetAsEntry())g.isFile?(m.push(s[e].getAsFile()),e===s.length-1&&b()):c(g)}else d.callbacks.dropProcessing(!1,e.files),
f.dropDisabled(!1)}});u.addDisposer(function(){f.dispose()});d.hideDropzones&&qq(a).hide()}var d,f,l,m=[],h=0,r=0,u=new qq.DisposeSupport;d={dropArea:null,extraDropzones:[],hideDropzones:!0,multiple:!0,classes:{dropActive:null},callbacks:{dropProcessing:function(){},error:function(){},log:function(){}}};qq.extend(d,a);return{setup:function(){d.dropArea&&d.extraDropzones.push(d.dropArea);var a,b=d.extraDropzones;for(a=0;a<b.length;a+=1)e(b[a]);d.dropArea&&(!qq.ie()||qq.ie10())&&u.attach(document,"dragenter",
function(c){var e;if(e=!f.dropDisabled()){var h;qq.each(c.dataTransfer.types,function(a,b){if("Files"===b)return h=!0,!1});e=h}if(e&&!qq(d.dropArea).hasClass(d.classes.dropDisabled)){d.dropArea.style.display="block";for(a=0;a<b.length;a+=1)b[a].style.display="block"}});u.attach(document,"dragleave",function(c){if(d.hideDropzones&&qq.FineUploader.prototype._leaving_document_out(c))for(a=0;a<b.length;a+=1)qq(b[a]).hide()});u.attach(document,"drop",function(c){if(d.hideDropzones)for(a=0;a<b.length;a+=
1)qq(b[a]).hide();c.preventDefault()})},setupExtraDropzone:function(a){d.extraDropzones.push(a);e(a)},removeExtraDropzone:function(a){var b,c=d.extraDropzones;for(b in c)if(c[b]===a)return c.splice(b,1)},dispose:function(){u.dispose();f.dispose()}}};
qq.UploadDropZone=function(a){function b(){return qq.safari()||qq.firefox()&&qq.windows()}function c(a){if(qq.ie()&&!qq.ie10())return!1;var b=a.dataTransfer,c=qq.safari();a=qq.ie10()?!0:"none"!==b.effectAllowed;return b&&a&&(b.files||!c&&b.types.contains&&b.types.contains("Files"))}function e(a){void 0!==a&&(f=a);return f}var d,f,l,m=new qq.DisposeSupport;d={element:null,onEnter:function(){},onLeave:function(){},onLeaveNotDescendants:function(){},onDrop:function(){}};qq.extend(d,a);a=d.element;l||
(b?m.attach(document,"dragover",function(a){a.preventDefault()}):m.attach(document,"dragover",function(a){a.dataTransfer&&(a.dataTransfer.dropEffect="none",a.preventDefault())}),l=!0);m.attach(a,"dragover",function(a){if(c(a)){var b=qq.ie()?null:a.dataTransfer.effectAllowed;a.dataTransfer.dropEffect="move"===b||"linkMove"===b?"move":"copy";a.stopPropagation();a.preventDefault()}});m.attach(a,"dragenter",function(a){if(!e()&&c(a))d.onEnter(a)});m.attach(a,"dragleave",function(a){if(c(a)){d.onLeave(a);
var b=document.elementFromPoint(a.clientX,a.clientY);if(!qq(this).contains(b))d.onLeaveNotDescendants(a)}});m.attach(a,"drop",function(a){!e()&&c(a)&&(a.preventDefault(),d.onDrop(a))});return{dropDisabled:function(a){return e(a)},dispose:function(){m.dispose()}}};
qq.FineUploader=function(a){qq.FineUploaderBasic.apply(this,arguments);qq.extend(this._options,{element:null,listElement:null,dragAndDrop:{extraDropzones:[],hideDropzones:!0,disableDefaultDropzone:!1},text:{uploadButton:"Upload a file",cancelButton:"Cancel",retryButton:"Retry",failUpload:"Upload failed",dragZone:"Drop files here to upload",dropProcessing:"Processing dropped files...",formatProgress:"{percent}% of {total_size}",waitingForResponse:"Processing..."},template:'<div class="qq-uploader">'+
(!this._options.dragAndDrop||!this._options.dragAndDrop.disableDefaultDropzone?'<div class="qq-upload-drop-area"><span>{dragZoneText}</span></div>':"")+(!this._options.button?'<div class="qq-upload-button"><div>{uploadButtonText}</div></div>':"")+'<span class="qq-drop-processing"><span>{dropProcessingText}</span><span class="qq-drop-processing-spinner"></span></span>'+(!this._options.listElement?'<ul class="qq-upload-list"></ul>':"")+"</div>",fileTemplate:'<li><div class="qq-progress-bar"></div><span class="qq-upload-spinner"></span><span class="qq-upload-finished"></span><span class="qq-upload-file"></span><span class="qq-upload-size"></span><a class="qq-upload-cancel" href="#">{cancelButtonText}</a><a class="qq-upload-retry" href="#">{retryButtonText}</a><span class="qq-upload-status-text">{statusText}</span></li>',
classes:{button:"qq-upload-button",drop:"qq-upload-drop-area",dropActive:"qq-upload-drop-area-active",dropDisabled:"qq-upload-drop-area-disabled",list:"qq-upload-list",progressBar:"qq-progress-bar",file:"qq-upload-file",spinner:"qq-upload-spinner",finished:"qq-upload-finished",retrying:"qq-upload-retrying",retryable:"qq-upload-retryable",size:"qq-upload-size",cancel:"qq-upload-cancel",retry:"qq-upload-retry",statusText:"qq-upload-status-text",success:"qq-upload-success",fail:"qq-upload-fail",successIcon:null,
failIcon:null,dropProcessing:"qq-drop-processing",dropProcessingSpinner:"qq-drop-processing-spinner"},failedUploadTextDisplay:{mode:"default",maxChars:50,responseProperty:"error",enableTooltip:!0},messages:{tooManyFilesError:"You may only drop one file"},retry:{showAutoRetryNote:!0,autoRetryNote:"Retrying {retryNum}/{maxAuto}...",showButton:!1},showMessage:function(a){setTimeout(function(){alert(a)},0)}},!0);qq.extend(this._options,a,!0);this._wrapCallbacks();this._options.template=this._options.template.replace(/\{dragZoneText\}/g,
this._options.text.dragZone);this._options.template=this._options.template.replace(/\{uploadButtonText\}/g,this._options.text.uploadButton);this._options.template=this._options.template.replace(/\{dropProcessingText\}/g,this._options.text.dropProcessing);this._options.fileTemplate=this._options.fileTemplate.replace(/\{cancelButtonText\}/g,this._options.text.cancelButton);this._options.fileTemplate=this._options.fileTemplate.replace(/\{retryButtonText\}/g,this._options.text.retryButton);this._options.fileTemplate=
this._options.fileTemplate.replace(/\{statusText\}/g,"");this._element=this._options.element;this._element.innerHTML=this._options.template;this._listElement=this._options.listElement||this._find(this._element,"list");this._classes=this._options.classes;this._button||(this._button=this._createUploadButton(this._find(this._element,"button")));this._bindCancelAndRetryEvents();this._dnd=this._setupDragAndDrop()};qq.extend(qq.FineUploader.prototype,qq.FineUploaderBasic.prototype);
qq.extend(qq.FineUploader.prototype,{clearStoredFiles:function(){qq.FineUploaderBasic.prototype.clearStoredFiles.apply(this,arguments);this._listElement.innerHTML=""},addExtraDropzone:function(a){this._dnd.setupExtraDropzone(a)},removeExtraDropzone:function(a){return this._dnd.removeExtraDropzone(a)},getItemByFileId:function(a){for(var b=this._listElement.firstChild;b;){if(b.qqFileId==a)return b;b=b.nextSibling}},cancel:function(a){qq.FineUploaderBasic.prototype.cancel.apply(this,arguments);var b=
this.getItemByFileId(a);qq(b).remove()},reset:function(){qq.FineUploaderBasic.prototype.reset.apply(this,arguments);this._element.innerHTML=this._options.template;this._listElement=this._options.listElement||this._find(this._element,"list");this._options.button||(this._button=this._createUploadButton(this._find(this._element,"button")));this._bindCancelAndRetryEvents();this._dnd.dispose();this._dnd=this._setupDragAndDrop()},_setupDragAndDrop:function(){var a=this,b=this._find(this._element,"dropProcessing"),
c,e;e=function(a){a.preventDefault()};this._options.dragAndDrop.disableDefaultDropzone||(c=this._find(this._options.element,"drop"));c=new qq.DragAndDrop({dropArea:c,extraDropzones:this._options.dragAndDrop.extraDropzones,hideDropzones:this._options.dragAndDrop.hideDropzones,multiple:this._options.multiple,classes:{dropActive:this._options.classes.dropActive},callbacks:{dropProcessing:function(c,f){var l=a._button.getInput();c?(qq(b).css({display:"block"}),qq(l).attach("click",e)):(qq(b).hide(),qq(l).detach("click",
e));f&&a.addFiles(f)},error:function(b,c){a._error(b,c)},log:function(b,c){a.log(b,c)}}});c.setup();return c},_leaving_document_out:function(a){return(qq.chrome()||qq.safari()&&qq.windows())&&0==a.clientX&&0==a.clientY||qq.firefox()&&!a.relatedTarget},_storeFileForLater:function(a){qq.FineUploaderBasic.prototype._storeFileForLater.apply(this,arguments);var b=this.getItemByFileId(a);qq(this._find(b,"spinner")).hide()},_find:function(a,b){var c=qq(a).getByClass(this._options.classes[b])[0];if(!c)throw Error("element not found "+
b);return c},_onSubmit:function(a,b){qq.FineUploaderBasic.prototype._onSubmit.apply(this,arguments);this._addToList(a,b)},_onProgress:function(a,b,c,e){qq.FineUploaderBasic.prototype._onProgress.apply(this,arguments);var d,f,l,m;d=this.getItemByFileId(a);f=this._find(d,"progressBar");m=Math.round(100*(c/e));c===e?(l=this._find(d,"cancel"),qq(l).hide(),qq(f).hide(),qq(this._find(d,"statusText")).setText(this._options.text.waitingForResponse),l=this._formatSize(e)):(l=this._formatProgress(c,e),qq(f).css({display:"block"}));
qq(f).css({width:m+"%"});d=this._find(d,"size");qq(d).css({display:"inline"});qq(d).setText(l)},_onComplete:function(a,b,c,e){qq.FineUploaderBasic.prototype._onComplete.apply(this,arguments);var d=this.getItemByFileId(a);qq(this._find(d,"statusText")).clearText();qq(d).removeClass(this._classes.retrying);qq(this._find(d,"progressBar")).hide();(!this._options.disableCancelForFormUploads||qq.isXhrUploadSupported())&&qq(this._find(d,"cancel")).hide();qq(this._find(d,"spinner")).hide();c.success?(qq(d).addClass(this._classes.success),
this._classes.successIcon&&(this._find(d,"finished").style.display="inline-block",qq(d).addClass(this._classes.successIcon))):(qq(d).addClass(this._classes.fail),this._classes.failIcon&&(this._find(d,"finished").style.display="inline-block",qq(d).addClass(this._classes.failIcon)),this._options.retry.showButton&&!this._preventRetries[a]&&qq(d).addClass(this._classes.retryable),this._controlFailureTextDisplay(d,c))},_onUpload:function(a,b){qq.FineUploaderBasic.prototype._onUpload.apply(this,arguments);
var c=this.getItemByFileId(a);this._showSpinner(c)},_onBeforeAutoRetry:function(a){var b,c,e,d,f;qq.FineUploaderBasic.prototype._onBeforeAutoRetry.apply(this,arguments);b=this.getItemByFileId(a);c=this._find(b,"progressBar");this._showCancelLink(b);c.style.width=0;qq(c).hide();this._options.retry.showAutoRetryNote&&(c=this._find(b,"statusText"),e=this._autoRetries[a]+1,d=this._options.retry.maxAutoAttempts,f=this._options.retry.autoRetryNote.replace(/\{retryNum\}/g,e),f=f.replace(/\{maxAuto\}/g,d),
qq(c).setText(f),1===e&&qq(b).addClass(this._classes.retrying))},_onBeforeManualRetry:function(a){if(qq.FineUploaderBasic.prototype._onBeforeManualRetry.apply(this,arguments)){var b=this.getItemByFileId(a);this._find(b,"progressBar").style.width=0;qq(b).removeClass(this._classes.fail);qq(this._find(b,"statusText")).clearText();this._showSpinner(b);this._showCancelLink(b);return!0}return!1},_addToList:function(a,b){var c=qq.toElement(this._options.fileTemplate);if(this._options.disableCancelForFormUploads&&
!qq.isXhrUploadSupported()){var e=this._find(c,"cancel");qq(e).remove()}c.qqFileId=a;e=this._find(c,"file");qq(e).setText(this._options.formatFileName(b));qq(this._find(c,"size")).hide();this._options.multiple||this._clearList();this._listElement.appendChild(c)},_clearList:function(){this._listElement.innerHTML="";this.clearStoredFiles()},_bindCancelAndRetryEvents:function(){var a=this;this._disposeSupport.attach(this._listElement,"click",function(b){b=b||window.event;var c=b.target||b.srcElement;
if(qq(c).hasClass(a._classes.cancel)||qq(c).hasClass(a._classes.retry)){qq.preventDefault(b);for(b=c.parentNode;void 0==b.qqFileId;)b=c=c.parentNode;qq(c).hasClass(a._classes.cancel)?a.cancel(b.qqFileId):(qq(b).removeClass(a._classes.retryable),a.retry(b.qqFileId))}})},_formatProgress:function(a,b){var c=this._options.text.formatProgress,e=Math.round(100*(a/b)),c=c.replace("{percent}",e),e=this._formatSize(b);return c=c.replace("{total_size}",e)},_controlFailureTextDisplay:function(a,b){var c,e,d,
f;c=this._options.failedUploadTextDisplay.mode;e=this._options.failedUploadTextDisplay.maxChars;d=this._options.failedUploadTextDisplay.responseProperty;"custom"===c?((c=b[d])?c.length>e&&(f=c.substring(0,e)+"..."):(c=this._options.text.failUpload,this.log("'"+d+"' is not a valid property on the server response.","warn")),qq(this._find(a,"statusText")).setText(f||c),this._options.failedUploadTextDisplay.enableTooltip&&this._showTooltip(a,c)):"default"===c?qq(this._find(a,"statusText")).setText(this._options.text.failUpload):
"none"!==c&&this.log("failedUploadTextDisplay.mode value of '"+c+"' is not valid","warn")},_showTooltip:function(a,b){a.title=b},_showSpinner:function(a){this._find(a,"spinner").style.display="inline-block"},_showCancelLink:function(a){if(!this._options.disableCancelForFormUploads||qq.isXhrUploadSupported())this._find(a,"cancel").style.display="inline"},_error:function(a,b){var c=qq.FineUploaderBasic.prototype._error.apply(this,arguments);this._options.showMessage(c)}});
(function(a){var b,c,e,d,f,l,m,h,r,u;l=["uploaderType"];e=function(a){a&&(a=h(a),m(a),"basic"===f("uploaderType")?b(new qq.FineUploaderBasic(a)):b(new qq.FineUploader(a)));return c};d=function(a,b){var d=c.data("fineuploader");if(b)void 0===d&&(d={}),d[a]=b,c.data("fineuploader",d);else return void 0===d?null:d[a]};b=function(a){return d("uploader",a)};f=function(a,b){return d(a,b)};m=function(b){var d=b.callbacks={};a.each((new qq.FineUploaderBasic)._options.callbacks,function(a){var b,e;b=/^on(\w+)/.exec(a)[1];
b=b.substring(0,1).toLowerCase()+b.substring(1);e=c;d[a]=function(){var a=Array.prototype.slice.call(arguments);return e.triggerHandler(b,a)}})};h=function(b,d){var e,g;e=void 0===d?"basic"!==b.uploaderType?{element:c[0]}:{}:d;a.each(b,function(b,c){0<=a.inArray(b,l)?f(b,c):c instanceof a?e[b]=c[0]:a.isPlainObject(c)?(e[b]={},h(c,e[b])):a.isArray(c)?(g=[],a.each(c,function(b,c){c instanceof a?a.merge(g,c):g.push(c)}),e[b]=g):e[b]=c});if(void 0===d)return e};r=function(c){return"string"===a.type(c)&&
!c.match(/^_/)&&void 0!==b()[c]};u=function(a){var c=[],d=Array.prototype.slice.call(arguments,1);h(d,c);return b()[a].apply(b(),c)};a.fn.fineUploader=function(d){var f=this,h=arguments,g=[];this.each(function(l,m){c=a(m);if(b()&&r(d)){if(g.push(u.apply(f,h)),1===f.length)return!1}else"object"===typeof d||!d?e.apply(f,h):a.error("Method "+d+" does not exist on jQuery.fineUploader")});return 1===g.length?g[0]:1<g.length?g:this}})(jQuery);