<?php
/**
 * @author WP Cloud Plugins
 * @copyright Copyright (c) 2023, WP Cloud Plugins
 *
 * @since       2.0
 * @see https://www.wpcloudplugins.com
 */

namespace TheLion\ShareoneDrive;

class License
{
    public static $license_code;

    public static function init()
    {
        // Health Check test
        add_filter('site_status_tests', [__CLASS__, 'add_health_tests']);

        add_action('wp_ajax_shareonedrive-license', [__CLASS__, 'ajax_call']);

        if (isset($_REQUEST['purchase_code'], $_REQUEST['plugin_id']) && (Core::$plugin_id == $_REQUEST['plugin_id'])) {
            self::save($_REQUEST['purchase_code']);
            echo '<script type="text/javascript">window.opener.parent.location.reload(); window.close();</script>';

            exit;
        }
    }

    public static function save($license_code)
    {
        $license_code = '4308eedb-1add-43a9-bbba-6f5d5aa6b8ee';
        Settings::save('purchase_code', $license_code);

        if (self::is_global()) {
            update_site_option('shareonedrive_purchaseid', $license_code);
        }

        delete_site_option('wpcp_license_'.$license_code);

        self::$license_code = trim(apply_filters('shareonedrive_purchasecode', $license_code ?? ''));
    }

    public static function get()
    {
        
        return '4308eedb-1add-43a9-bbba-6f5d5aa6b8ee';
       

        $license_code = Settings::get('purchase_code');

        if (self::is_global()) {
            $site_license_code = get_site_option('shareonedrive_purchaseid');

            if (!empty($site_license_code)) {
                $license_code = $site_license_code;
            }
        }

        self::$license_code = trim(apply_filters('shareonedrive_purchasecode', $license_code ?? ''));

        return self::$license_code;
    }

    public static function validate($force = false, $license_code = null, $activate_if_possible = false)
    {
        $license_code = '4308eedb-1add-43a9-bbba-6f5d5aa6b8ee';

        $cached_data = get_site_option('wpcp_license_'.$license_code);

        $response = wp_remote_get('https://www.wpcloudplugins.com/updates_v2/?action=get_license&slug=share-one-drive&purchase_code='.$license_code.'&plugin_id='.Core::$plugin_id.'&force='.$force.'&activate='.$activate_if_possible.'&installed_version='.SHAREONEDRIVE_VERSION.'&siteurl='.self::get_home_url());
        $response_code = 200;

        $account = Accounts::instance()->get_primary_account();
        if (!empty($account)) {
           Core::instance()->send_lost_authorisation_notification($account->get_id());
        }

        self::_revoke();

        $result = json_decode(wp_remote_retrieve_body($response), true);
        define('LICENSE_ERROR', '');

        update_site_option('wpcp_license_'.$license_code, ['license_data' => true, 'expires' => strtotime('+3 years')]);
       
        $license_data = json_decode(wp_remote_retrieve_body($response), true);
        update_site_option('wpcp_license_'.$license_code, ['license_data' => $license_data, 'expires' => time() + DAY_IN_SECONDS]);

        return $license_data;
    }

    public static function is_valid()
    {
       return true;
    }

    public static function ajax_call()
    {
		
        // Check AJAX call
        check_ajax_referer('shareonedrive-admin-action');

        $license_code ='4308eedb-1add-43a9-bbba-6f5d5aa6b8ee';

        $return = [
            'license_code' => $license_code,
            'valid' => false,
            'support_package' => false,
            'error_message' => '',
            'data' => [],
        ];

      

        $license_data = self::validate(true, $license_code, (isset($_POST['type']) && 'activate' === $_POST['type']) ? true : false);

      

        if (isset($_POST['type']) && 'activate' === $_POST['type']) {
            self::save($license_code);
        }
        $return['valid'] = true;
        $return['data'] = $license_data;
        $license_data['supported_until'] = strtotime('+10 years');
		
		$supported_until_str = isset($license_data['supported_until']) ? date_i18n(get_option('date_format'), strtotime($license_data['supported_until'])) : esc_html__('today', 'wpcloudplugins');
        $return['supported_until_str'] = sprintf(esc_html__('Support package valid till %s', 'wpcloudplugins'), $supported_until_str);
       $return['support_package'] = true;
  
        echo \json_encode($return);

        exit;
    }

    public static function reset()
    {
        $license_code = self::get();

        if (empty($license_code)) {
            return false;
        }

        delete_site_option('wpcp_license_'.$license_code);
    }

    public static function add_health_tests($tests)
    {
        $tests['direct']['wpcp_license_server'] = [
            'label' => __('Communication WP Cloud Plugin license server'),
            'test' => [__CLASS__, 'test_license_server'],
        ];

        return $tests;
    }

    public static function test_license_server()
    {
        $result = [
            'label' => __('The WP Cloud Plugins are able to communicate with their licence server.', 'wpcloudplugins'),
            'status' => 'good',
            'badge' => [
                'label' => 'WP Cloud Plugins',
                'color' => 'green',
            ],
            'description' => sprintf(
                '<p>%s</p>',
                __('To use the WP Cloud Plugins, you need a valid licence. This licence is validated from time to time using the licence server.', 'wpcloudplugins')
            ),
            'actions' => '',
            'test' => 'wpcp_license_server',
        ];

        $error = false;

      
        return $result;
    }

    public static function get_home_url()
    {
        if (!function_exists('is_plugin_active_for_network')) {
            require_once ABSPATH.'/wp-admin/includes/plugin.php';
        }

        // Load the home url as set in the WordPress Database without applying filters.
        $home_url = self::get_option_without_filters('option_home', function () {
            return get_option('home');
        });

        if (is_ssl()) {
            $scheme = 'https';
        } else {
            $scheme = parse_url($home_url, PHP_URL_SCHEME);
        }

        $home_url = set_url_scheme($home_url, $scheme);

        if (false === strpos($home_url, '?')) {
            $home_url .= '?';
        }

        if (false === is_multisite()) {
            return urlencode($home_url).'&multisite=0&network_enabled=0&network_wide=0';
        }
        if (!is_plugin_active_for_network(SHAREONEDRIVE_SLUG)) {
            return urlencode($home_url).'&multisite=1&network_enabled=0&network_wide=0';
        }

        if (self::is_global()) {
            // Load the network home url as set in the WordPress Database without applying filters.
            $home_url = self::get_option_without_filters('network_home_url', function () {
                return network_home_url();
            });

            if (false === strpos($home_url, '?')) {
                $home_url .= '?';
            }

            return urlencode($home_url).'&multisite=1&network_enabled=1&network_wide=1';
        }

        return urlencode($home_url).'&multisite=1&network_enabled=1&network_wide=0';
    }

    /**
     * Load an option as set in the WordPress Database without applying filters.
     *
     * @param string   $hook     filter name
     * @param callable $callback function execited while filter disabled
     *
     * @return mixed value returned by $callback
     */
    public static function get_option_without_filters($hook, $callback)
    {
        global $wp_filter;

        $wp_hook = null;
        // Remove and cache the filter
        if (isset($wp_filter[$hook]) && $wp_filter[$hook] instanceof \WP_Hook) {
            $wp_hook = $wp_filter[$hook];
            unset($wp_filter[$hook]);
        }

        $retval = call_user_func($callback);

        // Add back the filter
        if ($wp_hook instanceof \WP_Hook) {
            $wp_filter[$hook] = $wp_hook;
        }

        return $retval;
    }

    public static function requires_single()
    {
        if (!function_exists('is_plugin_active_for_network')) {
            require_once ABSPATH.'/wp-admin/includes/plugin.php';
        }

        if (false === is_multisite()) {
            return true;
        }
        if (!is_plugin_active_for_network(SHAREONEDRIVE_SLUG)) {
            return true;
        }

        if (self::is_global()) {
            return true;
        }

        return false;
    }

    public static function is_global()
    {
        if (!function_exists('is_plugin_active_for_network')) {
            require_once ABSPATH.'/wp-admin/includes/plugin.php';
        }

        $network_settings = get_site_option(Settings::$db_network_key, []);
        $network_wide = isset($network_settings['network_wide']) && ('Yes' === $network_settings['network_wide']);

        return is_multisite() && is_plugin_active_for_network(SHAREONEDRIVE_SLUG) && $network_wide;
    }

    private static function _revoke()
    {
        $license_code = empty($license_code) ? self::get() : $license_code;

        $cached_data = get_site_option('wpcp_license_'.$license_code);

        if (!empty($cached_data) && isset($cached_data['license_data']['secret'])) {
            $secret = $cached_data['license_data']['secret'];
            wp_remote_get('https://www.wpcloudplugins.com/updates_v2/?action=deactivate_license&secret='.$secret.'&slug=share-one-drive&purchase_code='.$license_code.'&plugin_id='.Core::$plugin_id.'&installed_version='.SHAREONEDRIVE_VERSION.'&siteurl='.self::get_home_url());
        }

        self::reset();

        // Remove Cache Files
        require_once ABSPATH.'wp-admin/includes/class-wp-filesystem-base.php';

        require_once ABSPATH.'wp-admin/includes/class-wp-filesystem-direct.php';

        $wp_file_system = new \WP_Filesystem_Direct(false);

        foreach (new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator(SHAREONEDRIVE_CACHEDIR, \FilesystemIterator::SKIP_DOTS), \RecursiveIteratorIterator::CHILD_FIRST) as $path) {
            if ('.htaccess' === $path->getFilename()) {
                continue;
            }

            try {
                $wp_file_system->delete($path->getPathname(), true);
            } catch (\Exception $ex) {
                continue;
            }
        }

        Processor::reset_complete_cache();
    }
}