<?php

namespace TheLion\ShareoneDrive\Integrations;

use TheLion\ShareoneDrive\Helpers;
use TheLion\ShareoneDrive\Settings;

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Tiny MCE buttons.
 */
class TinyMCE
{
    public function __construct()
    {
        $this->hooks();
    }

    /**
     * Integration hooks.
     */
    public function hooks()
    {
        // add TinyMCE button
        // Depends on the theme were to load....
        add_action('init', [$this, 'load_shortcode_buttons']);
        add_action('admin_head', [$this, 'load_shortcode_buttons']);
        add_filter('mce_css', [$this, 'enqueue_tinymce_css_frontend']);
    }

    // Add MCE buttons and script
    public function load_shortcode_buttons()
    {
        // Abort early if the user will never see TinyMCE
        if (
            !Helpers::check_user_role(Settings::get('permissions_add_shortcodes'))
            && !Helpers::check_user_role(Settings::get('permissions_add_links'))
            && !Helpers::check_user_role(Settings::get('permissions_add_embedded'))
        ) {
            return;
        }

        if ('true' !== get_user_option('rich_editing')) {
            return;
        }

        // Add a callback to regiser our tinymce plugin
        add_filter('mce_external_plugins', [$this, 'register_tinymce_plugin'], 999);

        // Add a callback to add our button to the TinyMCE toolbar
        add_filter('mce_buttons', [$this, 'register_tinymce_plugin_buttons'], 999);

        // Add custom CSS for placeholders
        add_editor_style(SHAREONEDRIVE_ROOTPATH.'/css/tinymce_editor.css');
    }

    // This callback registers our plug-in

    public static function register_tinymce_plugin($plugin_array)
    {
        $plugin_array['shareonedrive'] = SHAREONEDRIVE_ROOTPATH.'/includes/js/ShortcodeBuilder_Tinymce.js';

        return $plugin_array;
    }

    // This callback adds our button to the toolbar

    public static function register_tinymce_plugin_buttons($buttons)
    {
        // Add the button ID to the $button array

        if (Helpers::check_user_role(Settings::get('permissions_add_shortcodes'))) {
            $buttons[] = 'shareonedrive';
        }
        if (Helpers::check_user_role(Settings::get('permissions_add_links'))) {
            $buttons[] = 'shareonedrive_links';
        }
        if (Helpers::check_user_role(Settings::get('permissions_add_embedded'))) {
            $buttons[] = 'shareonedrive_embed';
        }

        return $buttons;
    }

    public function enqueue_tinymce_css_frontend($mce_css)
    {
        if (!empty($mce_css)) {
            $mce_css .= ',';
        }

        $mce_css .= SHAREONEDRIVE_ROOTPATH.'/css/tinymce_editor.css';

        return $mce_css;
    }
}

new TinyMCE();
