<?php
/*
Plugin Name: Social Gallery Pro
Plugin URI: http://www.socialgalleryplugin.com
Description: <a href="http://www.socialgalleryplugin.com">Social Gallery</a> is the <strong>ultimate</strong> Social Lightbox for WordPress.
Version: 5.0.1
Author: epicplugins
http://www.epicplugins.com
*/

/*
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#} Check's blog capacity to run Social Gallery
$socialGalleryProof = true;
#} PHP 5 
if (strtok(phpversion(),'.') < 5){
	$socialGalleryProof = false;
	add_action('admin_notices','socialGallery__php5req');function socialGallery__php5req(){echo '<div class="error"><p>Social Gallery Cannot run without PHP5!</p></div>';}
} 

#} TOTAL on/off switch
if ($socialGalleryProof){
	

#} Hooks

    #} Install/uninstall
    register_activation_hook(__FILE__,'socialGallery__install');
    register_deactivation_hook(__FILE__,'socialGallery__uninstall');
    
    #} General
	add_action('init', 'socialGallery__init');
    add_action('admin_menu', 'socialGallery__admin_menu'); 
    add_action('admin_head', 'socialGallery__adminheader_includes'); 
    add_action('wp_head', 'socialGallery__publicheader_includes'); 


add_filter( 'post_gallery', 'sg_post_gallery', 10, 2 );
#=======================================================================================================================
					# SET THE GALLERY ATTRIBUTE TO BE LINK = FILE 
#=======================================================================================================================
function sg_post_gallery( $output, $attr) 
{
	global $post;

	static $instance = 0;
	$instance++;


	// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}

	extract(shortcode_atts(array(
		'order'      => 'ASC',
		'orderby'    => 'menu_order ID',
		'id'         => $post->ID,
		'itemtag'    => 'dl',
		'icontag'    => 'dt',
		'captiontag' => 'dd',
		'columns'    => 3,
		'size'       => 'thumbnail',
		'include'    => '',
		'exclude'    => '',
		'link' 		 => 'file'
	), $attr));
	
	$attr['link'] = 'file';

	$id = intval($id);
	if ( 'RAND' == $order )
		$orderby = 'none';

	if ( !empty($include) ) {
		$include = preg_replace( '/[^0-9,]+/', '', $include );
		$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

		$attachments = array();
		foreach ( $_attachments as $key => $val ) {
			$attachments[$val->ID] = $_attachments[$key];
		}
	} elseif ( !empty($exclude) ) {
		$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
		$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	} else {
		$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	}

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
		return $output;
	}

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
	$float = is_rtl() ? 'right' : 'left';

	$selector = "gallery-{$instance}";

	$gallery_style = $gallery_div = '';
	if ( apply_filters( 'use_default_gallery_style', true ) )
		$gallery_style = "
		<style type='text/css'>
			#{$selector} {
				margin: auto;
			}
			#{$selector} .gallery-item {
				float: {$float};
				margin-top: 10px;
				text-align: center;
				width: {$itemwidth}%;
			}
			#{$selector} img {
				border: 2px solid #cfcfcf;
			}
			#{$selector} .gallery-caption {
				margin-left: 0;
			}
		</style>
		<!-- see gallery_shortcode() in wp-includes/media.php -->";
	$size_class = sanitize_html_class( $size );
	$gallery_div = "<div id='$selector' class='gallery galleryid-{$id} gallery-columns-{$columns} gallery-size-{$size_class}'>";
	$output = apply_filters( 'gallery_style', $gallery_style . "\n\t\t" . $gallery_div );

	$i = 0;
	foreach ( $attachments as $id => $attachment ) {
		$link = isset($attr['link']) && 'file' == $attr['link'] ? wp_get_attachment_link($id, $size, false, false) : wp_get_attachment_link($id, $size, true, false);

		$output .= "<{$itemtag} class='gallery-item'>";
		$output .= "
			<{$icontag} class='gallery-icon'>
				$link
			</{$icontag}>";
		if ( $captiontag && trim($attachment->post_excerpt) ) {
			$output .= "
				<{$captiontag} class='wp-caption-text gallery-caption'>
				" . wptexturize($attachment->post_excerpt) . "
				</{$captiontag}>";
		}
		$output .= "</{$itemtag}>";
		if ( $columns > 0 && ++$i % $columns == 0 )
			$output .= '<br style="clear: both" />';
	}

	$output .= "
			<br style='clear: both;' />
		</div>\n";

	return $output;
}
	
    
#=======================================================================================================================
					# GLOBALS
#=======================================================================================================================

#} Globals 

	#} Initial Vars
	global $socialGallery_db_version;
	$socialGallery_db_version 				= "2.0";
	$socialGallery_version 					= "4.2";
	
	#} Urls
	global $socialGallery_urls;
	$socialGallery_urls['home'] 			= 'http://www.socialgalleryplugin.com';
	$socialGallery_urls['support']			= 'http://epicplugins.com/help';
	$socialGallery_urls['forum'] 			= "http://epicplugins.com/help/forums/forums/social-gallery-plugin/";
	$socialGallery_urls['faq'] 				= "http://www.socialgalleryplugin.com/frequently-asked-questions/";
	$socialGallery_urls['docs'] 			= "http://epicplugins.com/documentation/";
	$socialGallery_urls['showcase']			= 'http://www.socialgalleryplugin.com/showcase/';
	$socialGallery_urls['updateCheck']		= 'http://www.socialgalleryplugin.com/updateEngine/';
	$socialGallery_urls['regCheck']			= 'http://www.socialgalleryplugin.com/updateEngine/registration/';
	$socialGallery_urls['comCheck']			= 'http://www.socialgalleryplugin.com/updateEngine/compat/';
	$socialGallery_urls['newsFeed'] 		= 'http://www.socialgalleryplugin.com/feed/';
	$socialGallery_urls['addons'] 			= 'http://www.socialgalleryplugin.com/addons/';
	$socialGallery_urls['updateEpic']		= 'http://www.epicplugins.com/api/';
	$socialGallery_urls['licenseEpic']		= 'http://www.epicplugins.com/api/license/';
	
		
	#} Table names
	global $wpdb;
	global $socialGallery_t;
	$socialGallery_t['images'] 				= $wpdb->prefix . "socialgallery_images";
	$socialGallery_t['imagelinks'] 			= $wpdb->prefix . "socialgallery_imagelinks";
	$socialGallery_t['postupdates'] 		= $wpdb->prefix . "socialgallery_postupdates";
	$socialGallery_t['otherupdates'] 		= $wpdb->prefix . "socialgallery_otherupdates";
	$socialGallery_t['tags'] 				= $wpdb->prefix . "socialgallery_tags";
	$socialGallery_t['tags_JSON'] 			= $wpdb->prefix . "socialgallery_tags_json";

	
	#} Page slugs
	global $socialGallery_slugs;
	$socialGallery_slugs['welcome'] 		= "sgp-plugin-welcome";
	$socialGallery_slugs['home'] 			= "sgp-plugin-config";
	$socialGallery_slugs['settings'] 		= "sgp-plugin-settings";
	$socialGallery_slugs['imagelibrary']	= "sgp-plugin-library"; 
	$socialGallery_slugs['updateengine']	= "sgp-plugin-update-engine";
	$socialGallery_slugs['analytics']		= "sgp-plugin-analytics";
	$socialGallery_slugs['smart']			= "sgp-plugin-smart";
	$socialGallery_slugs['about']			= "sgp-plugin-about";
	$socialGallery_slugs['license']			= "sgp-plugin-license";
	$socialGallery_slugs['socialanalytics'] = "sgp-plugin-analytics";
	
    global $sgs_slugs;
    $sgs_slugs['home']           = "sgs-plugin-home";
    $sgs_slugs['settings']       = "sgs-plugin-settings";
	$sgs_slugs['users']			=  "sgs-user-favourites";
	
	
	#} Addons
	$socialGallery_slugs['socialcomments']	= "sgp-plugin-socialcomments";
	
	
	#} extras
	global $socialGallery_acceptableThemes;
	$socialGallery_acceptableThemes = array('classic','clean','drawn','blue');
	define( 'SOCIALGALLERYPLUGIN_PATH', plugin_dir_path(__FILE__) );
	define( 'SOCIALGALLERYPLUGIN_URL', plugin_dir_url(__FILE__) );
	
	#} Set up the ultimately returned var's
	global $socialGalleryImages,$socialGalleryImagesU; $socialGalleryImages = array(); $socialGalleryImagesU = array();
	
	#} Settings Model. Total req. > v2.0 
	if(!class_exists('SocialGallerySettings')) 
		require_once(SOCIALGALLERYPLUGIN_PATH . 'includes/SocialGallery.Options.php');

		#} Init settings model
		global $socialGallery_Settings; $socialGallery_Settings = new SocialGallerySettings();	
		#} Add-ons init firing
		if (function_exists('socialGalleryAddon_SS_postInit')) socialGalleryAddon_SS_postInit();


#=======================================================================================================================
					# INSTALL/UNINSTALL
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================



#} Install function
function socialGallery__install(){
	
	global $socialGallery_Settings, $socialGallery_version, $socialGallery_db_version;	#} Req

	#} Initialising settings no happens via Settings Class
	#} As of V2.1
	if (!is_array($socialGallery_Settings->getAll())){
		
		add_action('admin_notices','socialGallery__settingsfail');function socialGallery__settingsfail(){echo '<div class="error"><p>Social Gallery Could not create its options object!</p></div>';}
		
	}
	
	#} Database
	socialGallery_checkTablesExist();
	

}

function sgMailchimp(){}
function sgFireHit($data){}

#} Initial Database Create
function socialGallery_createTables(){
	
	global $wpdb,$socialGallery_t;
	
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	
    #} Create tables
		
		#} Images
		$sql = "CREATE TABLE IF NOT EXISTS ". $socialGallery_t['images']." (
				  `sg_iid` INT NOT NULL AUTO_INCREMENT ,
				  `sg_ititle` VARCHAR(200) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL ,
				  `sg_idesc` VARCHAR(500) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL ,
				  `sg_iurl` VARCHAR(300) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NOT NULL ,
				  `sg_isurl` VARCHAR(300) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL ,
				  `sg_iperma` VARCHAR(200) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NOT NULL ,
				  `sg_idim` VARCHAR(30) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL ,
				  `sg_isrc` INT(1) NULL ,
				  `sg_istatus` TINYINT NULL ,
				  `sg_fbs` INT NULL DEFAULT NULL ,
				  `sg_fbl` INT NULL DEFAULT NULL ,
				  `sg_fbc` INT NULL DEFAULT NULL ,
				  `sg_tw` INT NULL DEFAULT NULL ,
				  `sg_pins` INT NULL DEFAULT NULL ,
				  `sg_lastsc` INT NULL DEFAULT NULL ,
				  `sg_iadded` INT(14) NULL ,
				  `sg_iviewcount` INT NULL ,
				  PRIMARY KEY (`sg_iid`) );";
		dbDelta($sql);
      
		#} Image Links
		$sql = "CREATE TABLE IF NOT EXISTS ". $socialGallery_t['imagelinks']." (
				  `sg_ilid` INT NOT NULL AUTO_INCREMENT ,
				  `sg_iid` VARCHAR(45) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NOT NULL ,
				  `wp_postid` INT NOT NULL ,
				  PRIMARY KEY (`sg_ilid`) );";
		dbDelta($sql);
		
		#} v3.0 Social Tags
		
		$sql = "CREATE TABLE IF NOT EXISTS ". $socialGallery_t['tags']." (
				  `sg_tid` INT NOT NULL AUTO_INCREMENT ,
				  `sg_tagger_id` BIGINT NOT NULL ,
				  `sg_taggee_id` BIGINT NOT NULL ,
				  `sg_tagger_name` TEXT NOT NULL ,
				  `sg_taggee_name` TEXT NOT NULL ,
				  `sg_relx` DECIMAL(11,10) NOT NULL ,
				  `sg_rely` DECIMAL(11,10) NOT NULL ,	
				  `sg_relh` DECIMAL(11,10) NOT NULL ,
				  `sg_relw` DECIMAL(11,10) NOT NULL ,	
				  `sg_url`  TEXT NOT NULL ,					  			  
				  PRIMARY KEY (`sg_tid`) );";
		dbDelta($sql);

		#}Face detection
		$sql = "CREATE TABLE IF NOT EXISTS ". $socialGallery_t['tags_JSON']." (
				  `sg_tid` INT NOT NULL AUTO_INCREMENT ,
				  `sg_url`  TEXT NOT NULL ,		
				  `sg_json`  TEXT NOT NULL ,				  			  			  
				  PRIMARY KEY (`sg_tid`) );";
		dbDelta($sql);

		
		#} Posts
		$sql = "CREATE TABLE IF NOT EXISTS ". $socialGallery_t['postupdates']." (
				  `sg_puid` INT NOT NULL AUTO_INCREMENT ,
				  `sg_postid` INT NOT NULL ,
				  `sg_lastupdateddate` DATETIME NOT NULL ,
				  `sg_lastupdatedfulldate` DATETIME NULL ,
				  `sg_sged` INT(14) NOT NULL ,
				  PRIMARY KEY (`sg_puid`) );";
		dbDelta($sql);
		
		#} Other Image Sources
		$sql = "CREATE TABLE IF NOT EXISTS ". $socialGallery_t['otherupdates']." (
				  `sg_ouid` INT NOT NULL AUTO_INCREMENT ,
				  `sg_source` INT NOT NULL ,
				  `sg_iid` VARCHAR(32) NULL ,
				  `sg_oid` VARCHAR(32) NOT NULL ,
				  `sg_dated` INT(14) NOT NULL ,
				  PRIMARY KEY (`sg_ouid`) );";
		dbDelta($sql);
		
		$table_name = $wpdb->prefix . "social_short_faves";      
  		 $sql = "CREATE TABLE $table_name (
	  	id mediumint(9) NOT NULL AUTO_INCREMENT,
		  f_id mediumint(9) NOT NULL,
		  p_id text NOT NULL,
		  g_id mediumint(9) NOT NULL,
		  UNIQUE KEY id (id)
		    );";
	   	dbDelta($sql);
	
}

#} Check existence & Create func
function socialGallery_checkTablesExist(){
	global $socialGallery_t,$wpdb;
	$tablesExist = $wpdb->get_results("SHOW TABLES LIKE '".$socialGallery_t['images']."'");
	if (count($tablesExist) < 1) socialGallery_createTables();
}

#} Uninstall
function socialGallery__uninstall(){
	
	global $socialGallery_Settings;	#$socialGallery_Settings->uninstall(); 
	
    
}

#=======================================================================================================================
function sg_________INIT(){}				# INIT + MENUS
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================


#} For addons:
add_filter( 'socialgallery-installed', '__return_true' );

if (isset($_GET['ppp'])) { print_r(get_option('active_plugins')); exit(); }

#} Initialisation - enqueueing scripts/styles
function socialGallery__init(){
  
	global $socialGallery_Settings, $socialGallery_slugs; #} Req
	
	
	#} Check Existence
	if (is_admin()) socialGallery_checkTablesExist();
	
	#} Admin & Public
	wp_enqueue_script("jquery");

	
	#} Public 	
	wp_enqueue_style('socialGalleryPluginCSS', plugins_url('/css/socialGalleryPlugin.css',__FILE__) );
	#} Any css3 animations for seperate inclusion?
	$cssIn = $socialGallery_Settings->get('inEffect'); $cssOut = $socialGallery_Settings->get('outEffect');
	if ($cssIn != "1") wp_enqueue_style('socialGalleryPluginCSSAni1', plugins_url('/css/ani/'.$cssIn.'.css',__FILE__) ); 	
	if ($cssOut != "1" && $cssOut != $cssIn) wp_enqueue_style('socialGalleryPluginCSSAni2', plugins_url('/css/ani/'.$cssOut.'.css',__FILE__) ); 	
	
	#} Admin only
	if (is_admin() && socialGallery_isASGAdminPage()) {
		
		#} Admin CSS
		wp_enqueue_style('socialGalleryPluginCSSADM', plugins_url('/css/socialGalleryPluginAdmin.css',__FILE__) );
		
		#} For File Upload
		wp_enqueue_script('media-upload');
		wp_enqueue_script('thickbox');
		wp_register_script('socialGalleryPluginJSADM', plugins_url('/js/socialGalleryPluginAdmin.js',__FILE__), array('jquery','media-upload','thickbox') );
		wp_enqueue_script('socialGalleryPluginJSADM');
		wp_enqueue_style('thickbox');
	}	

	if(!is_admin()){
		#}additional clean javascript for image overlay functionality and other additions.
		wp_register_script('socialGalleryPluginEpic', plugins_url('/js/socialGalleryEpic.js',__FILE__), array('jquery') );
		wp_enqueue_script('socialGalleryPluginEpic');	
		wp_localize_script( 'socialGalleryPluginEpic', 'EpicAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	}
	
	#} Custom Post Types & URLS	
	socialGallery_setupCustoms();

	#} Include Library.
	if(!class_exists('SocialGallery_List_table')) require_once(SOCIALGALLERYPLUGIN_PATH . 'includes/SocialGallery.Library.php');

}



add_action('init', 's_gallery_scripts');
function s_gallery_scripts(){
	if(!is_admin()){
	wp_enqueue_script('sgp-gestures',plugins_url('/js/jgestures.min.js',__FILE__),array('jquery'));
	wp_enqueue_script('jquery-ui-core',array('jquery'));
	}
}



#} Setup Social Gallery Custom's
function socialGallery_setupCustoms(){
	
	global $socialGallery_Settings;
	
	#} If we are using pages... 
	if ($socialGallery_Settings->get('useSGPages') == 1){		
		
		#} Register Re-write Rules
		add_rewrite_rule('^social-gallery/(.+)$','index.php?social-gallery-image=$matches[1]','top');
		
		#} Register Query Var
		add_filter('query_vars','socialGallery_query_vars');
	
		# If isn't set already set!
		if ($socialGallery_Settings->get('rulesFlushed') == 0){
		
			global $wp_rewrite;
			$wp_rewrite->flush_rules();
			
			# Add this 
			$socialGallery_Settings->update('rulesFlushed',1);
		
		}
		
	}	
	
}

#} Register Query Vars
function socialGallery_query_vars($vars){
	
	global $socialGallery_Settings;
	
	#} If we are using pages... 
	if ($socialGallery_Settings->get('useSGPages') == 1)
		array_push($vars, 'social-gallery-image'); 

	#} For dls		
	if ($socialGallery_Settings->get('useHeaderDownloads') == 1)
		array_push($vars, 'sgdl'); 
		
	#} Always...		
	array_push($vars, 'socialGalleryRequestVar','socialgallerysilentcrawl'); 
	
	return $vars;
}

#} Request Parser
add_filter('parse_request', 'socialGallery_parse_request' );
function socialGallery_parse_request( $wp )
{
	
	global $socialGallery_Settings;

	#} If we are using pages... 
	if ($socialGallery_Settings->get('useSGPages') == 1){	
	
		# Brutal take over
		if (array_key_exists('social-gallery-image', $wp->query_vars)) {
			$queryVal = $wp->query_vars['social-gallery-image'];
			if (!empty($queryVal)){
				# Validate
				global $thisSocialGalleryImage,$wpdb,$socialGallery_t;
				$thisSocialGalleryImage = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $socialGallery_t['images'] . " WHERE sg_iperma = '%s' LIMIT 0,1",$queryVal));
				if (count($thisSocialGalleryImage) == 1){
					#} Try and use custom first
					if (file_exists(dirname( __FILE__ ) . '/templates/custom-single-social-gallery-image.php'))
						require(dirname( __FILE__ ) . '/templates/custom-single-social-gallery-image.php');
					else
						require(dirname( __FILE__ ) . '/templates/single-social-gallery-image.php');

					exit();
				} # Else let it 404.
			}
		}
		if (array_key_exists('sgdl', $wp->query_vars)) {
			$queryVal = $wp->query_vars['sgdl'];
			if (!empty($queryVal)){
				# Validate
				global $wpdb,$socialGallery_t;
				$i = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $socialGallery_t['images'] . " WHERE sg_iperma = '%s' LIMIT 0,1",$queryVal));
				if (count($i) == 1){
					
					#} Image Url: 
					$imageUrl = $i[0]->sg_iurl;					
					$filename = basename($imageUrl);
					$file_extension = strtolower(substr(strrchr($filename,"."),1));
					
					#} Content type
					$ctype = '';
					switch( $file_extension ) {
						case "gif": $ctype="image/gif"; break;
						case "png": $ctype="image/png"; break;
						case "jpeg":
						case "jpg": $ctype="image/jpg"; break;
						default:
					}
					
					#} Requires fopen
					if (!empty($ctype)){
					
						header('Content-type:'.$ctype);
						header('Content-Disposition: attachment; filename="'.$filename.'"');
						readfile($imageUrl);
						exit();
					
					}
					
				} # Else let it 404.
			}	
		}
				
	
	}
	
	
	
	

}

#} Wrapper function which calls parsepost on a just published/edited post :)
add_action('publish_post', 'socialGallery_parsePostJustPublished');
function socialGallery_parsePostJustPublished($postid){

	socialGallery_parsePost(get_post($postid),false,'post','full');

}

#} Add action to build output required array.
add_action('the_post', 'socialGallery_addOutputPostArr');
function socialGallery_addOutputPostArr($post){
	
	global $socialGalleryImages,$wpdb,$socialGallery_t,$socialGalleryImagesU;
	
	#} Don't bother if meta says no!	
	if (!defined('SGDISABLED')){
		#} Retrieve the associated images.
		#$sgsql = $wpdb->prepare("SELECT sg_iurl,sg_iperma,sg_idim FROM " . $socialGallery_t['images'] . " where sg_iid IN (SELECT sg_iid FROM ". $socialGallery_t['imagelinks']." WHERE wp_postid = %d)",(int)$post->ID);
		$sgsql = $wpdb->prepare("SELECT i.sg_iurl,i.sg_iperma,i.sg_idim FROM " . $socialGallery_t['images'] . " i INNER JOIN ". $socialGallery_t['imagelinks']." il on i.sg_iid = il.sg_iid WHERE il.wp_postid = %d",(int)$post->ID);

		$sgi = $wpdb->get_results($sgsql);
	
		#} Any Images?	
		if ($sgi){
			
			#} Cycle through
			foreach ($sgi as $i) { 
		
				#} Smart Inclusion
				if (!in_array($i->sg_iurl,$socialGalleryImagesU)){
					
					# Determine Dimensions if present
					$dimensions = ''; if (isset($i->sg_idim)) if (!empty($i->sg_idim) && $i->sg_idim != 'NULL') {
					
						try {
							
							$dimensions = json_decode($i->sg_idim);
							
						} catch (Exception $e){
							
						}
						
					}
					
					$socialGalleryImage = array($i->sg_iurl,$i->sg_iperma); 
					if (is_array($dimensions)) $socialGalleryImage[2] = $dimensions;
					$socialGalleryImages[] = $socialGalleryImage;
					$socialGalleryImagesU[] = $i->sg_iurl;
					
				} 
					
			}
			
		}
	}
	
}

#} Actual output of array as json
add_action('wp_footer', 'socialGallery_spitOutputPostArr');
function socialGallery_spitOutputPostArr(){
	
	#} Don't show if it's disabled on this page!
	if (!defined('SGDISABLED')){
		global $socialGalleryImages;
		echo '<script type="text/javascript">var sgi = '.json_encode($socialGalleryImages).';</script>';

	#} Image Preloading - use the CSS background technique, populated via jQuery on page load.
		echo "<div id='sgp-preloaded-images'></div>";

	} 
}

#} Add le admin menu
function socialGallery__admin_menu() {
	global $socialGallery_slugs,$sgs_slugs, $sga_scripts_page; #} Req
	add_menu_page( 'Social Gallery', 'Social Gallery', 'manage_options', $socialGallery_slugs['home'], 'socialGallery_pages_home', plugins_url('i/icon.png',__FILE__));
    add_submenu_page( $socialGallery_slugs['home'], 'Settings', 'Settings', 'manage_options', $socialGallery_slugs['settings'], 'socialGallery_pages_settings' );
    add_submenu_page( $socialGallery_slugs['home'], 'Update Engine', 'Update Engine', 'manage_options', $socialGallery_slugs['updateengine'], 'socialGallery_pages_updateEngine' );
    add_submenu_page( $socialGallery_slugs['home'], 'Image Library', 'Image Library', 'manage_options', $socialGallery_slugs['imagelibrary'], 'socialGallery_render_list_page' );
  	add_submenu_page( $socialGallery_slugs['home'], 'Add Ons', 'Add Ons', 'manage_options', $socialGallery_slugs['about'], 'socialGallery_addons' );	
	#} Social Stats
	if (function_exists('sga_install')){
		$sga_scripts_page = add_submenu_page( $socialGallery_slugs['home'], 'Social Analytics', 'Social Analytics', 'manage_options', $socialGallery_slugs['socialanalytics'], 'sga_pages_home', plugins_url('i/icon.png',__FILE__));
		add_action( 'load-' . $sga_scripts_page, 'load_sga_admin_js' );
	}

}

// Add settings link on plugin page
function sgp_settings_link($links) {
  global $socialGallery_slugs; 
  $link = $socialGallery_slugs['settings'];
  $settings_link = "<a href='admin.php?page=$link'>Settings</a>"; 
  array_unshift($links, $settings_link); 
  return $links; 
}
 
$plugin = plugin_basename(__FILE__); 
add_filter("plugin_action_links_$plugin", 'sgp_settings_link' );





function SG_socialsmart(){
	global $socialGallery_t,$wpdb;
	extract( shortcode_atts( array(
		'slide' => 'true',
	), $args ) );
    $content = null;   
    ob_start();
	$sql = "SELECT * FROM ".$socialGallery_t['images']." ORDER BY 'sg_fbl' ASC LIMIT 25";
	$photos = $wpdb->get_results($sql);
			echo "<div id = 'sg-holder'><div class = 'social-gallery-shortcode' id = 'sg-mason'>";
			$i = 0;
			foreach($photos as $photo){	
				echo "<div class = 'sg-item social-gallery-item'>";
				echo "<a href = '$photo->sg_iurl' class = 'social-gallery-image'><img src = '$photo->sg_isurl' class = 'sgs-image'></a>";
				echo "</div>";
			}
			?>
			</div>
	</div> 
	<?php
    $content = ob_get_contents();
    ob_end_clean();
    return $content;
}
add_shortcode("socialSMART", "SG_socialsmart");

function socialGallery_addons(){
	SGPv3header();
	?>
	<h3>Social Gallery Add ons</h3>
	<style>
	.sgpboximg img{
		width:100%;
		height:175px;
	}
	.sgpbox {
		width:28%;
		background:#FFF;
		margin:10px auto;
		float:left;
		padding:10px;
		margin-right:2%;
		height:340px;
	}

	.effect1{
		-webkit-box-shadow: 0 10px 6px -6px #777;
		   -moz-box-shadow: 0 10px 6px -6px #777;
		        box-shadow: 0 10px 6px -6px #777;
	}
	</style>
	<p>Boost the power of your Social Gallery Plugin by adding additonal features to your Social Gallery Plugin</p>
	<div class='sgpbox effect1'>
		<div class='sgpboxtitle'><h4>Mobile Add On</h4></div>
		<div class='sgpboximg'><img src='https://epicplugins.com/wp-content/uploads/2015/11/sgmobileaddon1.png'/></div>
		<p>Social Gallery Mobile creates a whole new mobile experience for your visitors. Get 50% off with coupon code: <b>sgaddons50</b>.</p>
		<div class='buynow'><a href='https://epicplugins.com/product/social-gallery-mobile-add/' target='_blank' class='btn btn-primary button button-primary'>Buy Now</a></div>
	</div>

	<div class='sgpbox effect1'>
		<div class='sgpboxtitle'><h4>Image Grid Add on</h4></div>
		<div class='sgpboximg'><img src='https://0.s3.envato.com/files/63710078/social-gallery-shortcodes.jpg'/></div>
		<p>Social Gallery [shortcodes] allows you to create an amazing Image Grid with on hover share statistics and perfect masonry.</p>
		<div class='buynow'><a href='http://codecanyon.net/item/social-gallery-shortcodes-wordpress-plugin/5351799?ref=epicplugins' class='btn btn-primary button button-primary'>Buy Now</a></div>
	</div>

	<div class='sgpbox effect1'>
		<div class='sgpboxtitle'><h4>Social Gallery Video</h4></div>
		<div class='sgpboximg'><img src='https://0.s3.envato.com/files/60945214/social-gallery-video-viewer-wordpress.jpg'/></div>
		<p>Social Gallery for your Videos. Collect shares, Likes, Comments. All for your videos. Embed from YouTube and Vimeo. Next Generation Sharing</p>
		<div class='buynow'><a href='http://codecanyon.net/item/social-gallery-wordpress-video-viewer-plugin/5117217?ref=epicplugins' class='btn btn-primary button button-primary'>Buy Now</a></div>
	</div>

	<div class='sgpbox effect1'>
		<div class='sgpboxtitle'><h4>Social Gallery Analytics</h4></div>
		<div class='sgpboximg'><img src='https://0.s3.envato.com/files/142028848/social-gallery-analytics-main.jpg'/></div>
		<p>Social Gallery Analytics. See which images are viewed the most, shared the most and have the most engagement. Analytics tracked over time.</p>
		<div class='buynow'><a href='https://codecanyon.net/item/social-gallery-analytics-add-on/12169533?ref=epicplugins' class='btn btn-primary button button-primary'>Buy Now</a></div>
	</div>	



	<?php
	
}


function sg_settings_page() {
	global $sgs_slugs;
?>
	<?php SGPv3header(); ?>
	<h3>Social Gallery Shortcodes</h3>
	<p>This page details the shortcodes that are included with the Social Gallery Photo Viewer Plugin</p>
	<ul>
		<li><code>[socialgallery ids = "1,2,3,4,5"]</code></li>
		<p>This shortcode displays a gallery of images similar to the standard WordPress "in post" gallery. The easiest way to set this up is to create and insert a WordPress gallery the usual way
			and then add <i>social</i> to the start of the shortcode.</p>
		<li><code>[nggsocial id = "1"]</code></li>
		<p>This shortcode displays your nextgen gallery in the cool social lightbox. The ID to use is the ID of your NextGen albumn.
	</ul>
	
	Note: for both the above shortcodes, images are faded in upon load of all the images and then positioned using a modification to the isotope.js. If your theme or another plugin is running isotope your images
	will not appear. Please not that very large images or a very large gallery will mean the page appears blank while they load. We recommend using the WordPress "in post" version of this shortcode (e.g. <code>[socialgallery ids = "1,2,3,4"]</code>
	as this generally performs the best.
	<br/>
	<br/>
	<a href = "http://goo.gl/EfCGj8" target = "_blank" class = "SocialGalleryOB">Buy the Social Shortcodes Plugin to use the above shortcodes</a>
	<br/>
	<br/>
	If you are using the nextgen version, please make sure you are using large enough thumbnails otherwise your gallery may look blocky. We recommend setting up special galleries using your images with 400x400 thumbnails as this is the optimum setting for Social Gallery.
	<br/>
	<ul>
		<li><code>[socialSMART]</code></li>
	</ul>

<?php } 


#}the welcome page HTML with embedded vidoes and tutorial etc
function socialGallery_pages_welcome(){
	SGPv3header();
	?>
<h1>Tutorials and Guides</h1>
<div style = "width:45%;float:left">
<h3>Style Features</h3>
<ul>
<li><a href="http://www.socialgalleryplugin.com/guide-css3-animations-in-social-gallery/" target = "_blank">CSS3 Animations in Social Gallery</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-custom-css-in-social-gallery/" target = "_blank">Custom CSS in Social Gallery</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-social-gallery-pages-customisation-custom-page-templates/" target = "_blank">Social Gallery Pages Customisation – Custom Page Templates</a></li>
<li><a href="http://www.socialgalleryplugin.com/social-gallery-wordpress-plugin-and-css-selectors/" target = "_blank">Social Gallery Plugin and CSS Selectors</a></li>
</ul>
<h3>Social Features</h3>
<ul>
<li><a href="http://www.socialgalleryplugin.com/guide-setting-up-tweet-via-twitter-social-gallery/" target = "_blank">Setting up Tweet Via – Twitter &amp; Social Gallery</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-finding-your-facebook-id-for-facebook-comments-admin/" target = "_blank">Finding your Facebook ID for Facebook Comments Admin</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-facebook-app-id-for-use-with-social-gallery-for-fb-comments-likesend-buttons/" target = "_blank">Facebook App ID for use with Social Gallery (For FB Comments &amp; Like/Send Buttons)&nbsp;</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-social-gallery-plugin-with-disqus-comments/" target = "_blank">Social Gallery Plugin with Disqus Comments</a></li>
</ul>
<h3>Integration with other Galleries</h3>
<ul>
<li><a href="http://www.socialgalleryplugin.com/guide-using-social-gallery-with-justified-image-grid/" target = "_blank">Using Social Gallery with Justified Image Grid</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-setting-up-social-gallery-and-nextgen-gallery/" target = "_blank">Using Social Gallery with NextGen Gallery</a></li>
</ul>
<h3>General Features</h3>
<ul>
<li><a href="http://www.socialgalleryplugin.com/social-gallery-pages/" target = "_blank">Social Gallery Pages</a></li>
<li><a href="http://www.socialgalleryplugin.com/social-gallery-adsense-setup/" target = "_blank">Social Gallery Adsense Setup</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-social-gallery-and-mobile-devices-including-tablets/" target = "_blank">Social Gallery and Mobile Devices (Including Tablets)</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-prompt-to-save-as-social-gallery-download-link/" target = "_blank">“Prompt to Save As” – Social Gallery Download Link</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-using-encoded-html-in-social-gallery-sidebar/" target = "_blank">Using Encoded HTML in Social Gallery SideBar</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-social-gallery-add-ons/" target = "_blank">Social Gallery Add-ons</a></li>
<li><a href="http://www.socialgalleryplugin.com/guide-enabledisable-social-gallery-per-postpage/" target = "_blank">Enable/disable Social Gallery per post/page</a></li>
</ul>
<h3>Admin/Developer only tools &amp; features</h3>
<ul>
<li><a href="http://www.socialgalleryplugin.com/guide-admin-tools-web-developers-only/" target = "_blank">Admin Tools – Web Developer’s Only</a></li>
</ul>
</div>
	<div style = "width:45%;float:right">
		<h3>Setup tutorial videos</h3>
		<iframe width="300" height="169" src="//www.youtube.com/embed/vCD9ZzpgQfE" frameborder="0" allowfullscreen></iframe>
		<br/><br/>
		<iframe width="300" height="169" src="//www.youtube.com/embed/aLc6fNoPlho" frameborder="0" allowfullscreen></iframe>
		<br/><br/>
		<h3>Need More Help?</h3>
		<a href = "http://forum.socialgalleryplugin.com/" target = "_blank"><img src = '<?php echo plugins_url('i/support.png',__FILE__); ?>' /></a>
	</div>
<div style = "clear:both"></div>

<?php
}

function SGPv3header(){
	?>
	<style>
	.updated{
		display:none !important;
	}
	#wpcontent{
		margin-left: 145px;
		}
	#wpfooter{
		background:white;
		margin-right:0px;
		padding-right:20px;
		padding-left:20px;
	}
	#wpcontent{

	}
	#wpbody-content {
	width:90%;	
	padding-left:15px;
	}
	#socialGallerySettingsPage{
		background:white;
	}
	.sglogo{
		margin-top:15px;
		padding-bottom:10px;
	}
	#sgpDesc{
		background:white;
		width: 73%;
		margin-left: 8px;
		padding: 10px;
	}
	.sgshare{
		margin-bottom:10px;
	}
	.sgLHS{
		float:left;
		width:45%;
	}
	.sgRHS{
		float:right;
		width:45%;
		padding-left:5%;
		padding-right:5%;
		margin-top:45px;
	}
	.sgv3wrap{
		min-height:900px;
	}
	.sgPara{
		background:white;
		padding:10px;
	}
</style>
<div class = 'sgLHS'>
	<div class = 'sglogo'>
		<img src = '<?php echo plugins_url('i/social-gallery.png',__FILE__); ?>' />
	</div>
	<div class = 'sgshare'>
<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_GB/all.js#xfbml=1&appId=386163348104417";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>
<div class="fb-like" data-href="http://www.socialgalleryplugin.com/" data-layout="standard" data-action="like" data-show-faces="true" data-share="true"></div>
	</div>
</div>
<div style = "clear:both"></div>
<?php
}


#} JS Script includes/Config links
function socialGallery__adminheader_includes() {
    
		echo '<script type="text/javascript" src="https://platform.twitter.com/widgets.js"></script>';
	
		echo "<div id=\"fb-root\"></div><script>(function(d, s, id) { var js, fjs = d.getElementsByTagName(s)[0]; if (d.getElementById(id)) return; js = d.createElement(s); js.id = id; js.src = \"//connect.facebook.net/en_GB/all.js#xfbml=1&appId=630966486943508\"; fjs.parentNode.insertBefore(js, fjs); }(document, 'script', 'facebook-jssdk'));</script>";

		echo '<script type="text/javascript" id="pinterestSrc" src="//assets.pinterest.com/js/pinit.js"></script>';
	
}

#} Filters out disabled pages
add_action('get_header','socialGallery_filterDisabled');
function socialGallery_filterDisabled(){
	global $socialGallery_Settings;
	if ($socialGallery_Settings->get('enablemeta') == "1"){
		global $wp_query; if (isset($wp_query->post)) $postID = $wp_query->post->ID;
		if (!empty($postID)){
			$postMeta = get_post_meta( $postID, 'socialGalleryDisabled');
			if (is_array($postMeta)) if (isset($postMeta[0])) if ($postMeta[0] == 1) define('SGDISABLED',1);
		}
	}	
}


#} JS Script includes/Config links
function socialGallery__publicheader_includes() {
	
	#} Don't bother if meta says no!	
	if (!defined('SGDISABLED')){
		
		global $socialGallery_Settings;
		
		#} Social Includes JS.
		
		$sgConfig = $socialGallery_Settings->getAll();
		
		#} Detect mobiles + tablets ignore if req.
		if ($sgConfig['mob'] != 1 || $sgConfig['tablet'] != 1 || $sgConfig['addonMob'] == 1){
			
			#} Detect
			$sgMobile = socialGallery_isMobile();
			$sgTablet = socialGallery_isTablet();
					
			#} allow Mobile addon to override
			if ($sgConfig['addonMob'] == 1 && ($sgMobile || $sgTablet)){
				
				#echo 'switched on and detected mob/tablet';
				socialGallery_setMOBL();
				#socialGallery_setDNL();
				
			} else {
				
				#} If it's a tablet
				if ($sgTablet){
					#echo 'detected tablet';
					#} If don't show on tablets:
					if ($sgConfig['tablet'] != 1) socialGallery_setDNL();
					
				}
				#} If it's a mobile
				if ($sgMobile){
					#echo 'detected mobile';
					
					#} If don't show on mobs:
					if ($sgConfig['mob'] != 1) socialGallery_setDNL();
					
				}
			
			}
			
		}
		
		#} If OK, proceed
		if (!defined('SOCIALGALLERY_DNL')) {
					
				# Check margin bounds
				$marginBounds = 10;	if ((float)$sgConfig['marginBounds'] > 0) { $marginBounds = (float)$sgConfig['marginBounds']*100; if ($marginBounds > 50) $marginBounds = 50; }
				
				# Check legitimacy of themes 
				global $socialGallery_acceptableThemes;	if (in_array($sgConfig['theme'],$socialGallery_acceptableThemes)) $theme = $sgConfig['theme']; else $theme = 'classic';
				
				if ($sgConfig['incTwitSRC'] == 1)
					echo '<script type="text/javascript" src="https://platform.twitter.com/widgets.js"></script>';
				
				if (empty($sgConfig['incFBAppID'])) $fbAppID = '386163348104417'; else $fbAppID = $sgConfig['incFBAppID']; #} Social Gallery App ID Defaults.
				
				if ($sgConfig['incFBSRC'] == 1)
					echo "<div id=\"fb-root\"></div><script>(function(d, s, id) { var js, fjs = d.getElementsByTagName(s)[0]; if (d.getElementById(id)) return; js = d.createElement(s); js.id = id; js.src = \"//connect.facebook.net/en_GB/all.js#xfbml=1&appId=".$fbAppID."\"; fjs.parentNode.insertBefore(js, fjs); }(document, 'script', 'facebook-jssdk'));</script>";
			
				
				if ($sgConfig['incPinSRC'] == 1)
					echo '<script type="text/javascript" id="pinterestSrc" src="//assets.pinterest.com/js/pinit.js"></script>';

				#} Check permalinks viability
				$permalinks = false;
				if ( get_option('permalink_structure') && $socialGallery_Settings->get('rulesFlushed') == 1) $permalinks = true; 
				#} Rather than letting js devise urls, just pass an appropriate slug/stem:
				if ($permalinks) 
					$sgpslug = home_url().'/social-gallery/';
				else
					$sgpslug = home_url().'?social-gallery-image=';
					
				$sgpdlslug = home_url().'?sgdl=';
			
					
				#} JS Config feed.
				echo '<script type="text/javascript">var sgp_config = {"sgp_FBS":"'.$sgConfig['FBshare'].'","sgp_JiG":"'.$sgConfig['jigOverlay'].'","sgp_Faces": "'.$sgConfig['sgFaceDetect'].'","sgp_selT": "'.$sgConfig['selectorType'].'","sgp_sel": "'.$sgConfig['selector'].'","sgp_bT": "'.get_bloginfo('name').'","sgp_bL": "'.get_bloginfo('description').'","sgp_bU": "'.home_url().'","sgp_bg": "'.$sgConfig['bgColor'].'","sgp_bgo": "'.$sgConfig['bgOpacity'].'","sgp_bb": "'.$sgConfig['bottomBar'].'","sgp_bbt": "'.$sgConfig['bottomBarTitleSource'].'","sgp_hb": "'.$sgConfig['headerBox'].'","sgp_hbt": "'.$sgConfig['headerBoxType'].'","sgp_ch": "'.$sgConfig['headerBoxHTML'].'","sgp_hbi": "'.$sgConfig['headerImg'].'","sgp_desc": "'.$sgConfig['incDesc'].'","sgp_tw": "'.$sgConfig['incTwit'].'","sgp_fb": "'.$sgConfig['incFB'].'","sgp_fbf": "'.$sgConfig['incFBFaces'].'","sgp_pin": "'.$sgConfig['incPin'].'","sgp_fbc": "'.$sgConfig['incFBComments'].'","sgp_nav": "'.$sgConfig['backAndForth'].'","sgp_hon": "'.$sgConfig['incHomeCall'].'","sgp_swi": "'.$sgConfig['incSwipe'].'","sgp_twvia": "'.$sgConfig['twvia'].'","sgp_dc": "'.$sgConfig['incDisqusComments'].'","sgp_dcn": "'.$sgConfig['disqusShortName'].'","sgp_dll": "'.$sgConfig['incDLLink'].'","sgp_fsm":"'.$sgConfig['incFullScreen'].'","sgp_ffsm":"'.$sgConfig['alwaysFullScreen'].'","sgp_usf":"'.$sgConfig['upscaleFactor'].'","sgp_mb":"'.$marginBounds.'","sgp_dcsss":"'.$sgConfig['discludeSelectors'].'","sgp_slug":"'.$sgpslug.'","sgp_iFullScr": "'.plugins_url('/themes/classic/fullscreen.png',__FILE__).'","sgp_theme":"'.$theme.'","sgp_theme_root":"'.SOCIALGALLERYPLUGIN_URL.'themes/","sgp_affU":"'.$sgConfig['affUser'].'","sgp_fallback":"'.$sgConfig['fallbackUrlOption'].'","sgp_inE":"'.$sgConfig['inEffect'].'","sgp_outE":"'.$sgConfig['outEffect'].'","sgp_inET":"'.$sgConfig['inEffectTime'].'","sgp_outET":"'.$sgConfig['outEffectTime'].'","sgp_useAds":"'.$sgConfig['useDFP'].'","sgp_dfpInline":"'.urlencode(stripslashes(html_entity_decode($sgConfig['dfpInline'],ENT_QUOTES))).'","sgp_sgpages":"'.$sgConfig['useSGPages'].'","sgp_shTU": "'.$sgConfig['shareTumblr'].'","sgp_shLI": "'.$sgConfig['shareLinkedIn'].'","sgp_shGP": "'.$sgConfig['shareGooglePlus'].'","sgp_shSU": "'.$sgConfig['shareStumbleUpon'].'","sgp_perm":"'.$permalinks.'","sgp_mob":"'.$sgConfig['mob'].'","sgp_iRoot": "'.SOCIALGALLERYPLUGIN_URL.'","sgp_dlh":"'.$sgConfig['useHeaderDownloads'].'","sgp_dlslug":"'.$sgpdlslug.'"};  var disqus_shortname = \''.$sgConfig['disqusShortName'].'\'; </script>';
				#} the iLoadR line is fixed via theme post v2.0 - problem taking it out?
				#,"sgp_iLoadR": "'.plugins_url('/i/loading.gif',__FILE__).'","sgp_iR": "'.plugins_url('/i/r.png',__FILE__).'","sgp_iL": "'.plugins_url('/i/l.png',__FILE__).'"
							
							
				#} For mobile fallback to addon
				if (!defined('SOCIALGALLERY_MOBL')) echo '<script type="text/javascript" src="'.plugins_url('/js/socialGalleryPlugin.js',__FILE__).'"></script>'; 
	
			
			   
				#} Dealing with IE.
				echo '<script type="text/javascript">var sgp_ie = false;var sgp_ie7 = false;</script><!--[if IE]><script type="text/javascript">var sgp_ie = true;</script><![endif]--><!--[if lte IE 7]><script type="text/javascript">var sgp_ie7 = true;</script><![endif]-->';
				
				#} Theme CSS
				echo "<link rel='stylesheet' id='sgcustomthemecss'  href='".plugins_url("/themes/".$theme."/".$theme.".css",__FILE__)."' type='text/css' media='all' />";
				
				#} Ad code
				if (isset($sgConfig['dfpHead'])) if (!empty($sgConfig['dfpHead'])) echo stripslashes(html_entity_decode($sgConfig['dfpHead'],ENT_QUOTES));
		
		
				#} Custom CSS?
				if (isset($sgConfig['customcss'])) if (!empty($sgConfig['customcss'])) echo '<style type="text/css">'.$sgConfig['customcss'].'</style>';

				#}Admin Meta
				#} <meta property="fb:app_id" content="{YOUR_APP_ID}" />
				echo '<meta property="fb:app_id" content="'.  $sgConfig['incFBAppID'] . '"/>';
		
		} else {
		
			#} Mobile device + Mobile SocGal disabled!	
			#} Don't even need this! : - > echo '<script type="text/javascript">var sgp_config = {"sgp_disabled":true}</ script>';
		}
	} # End of blocked by meta
}

#} Run at all page points of load in admin.
add_action('admin_notices','socialGallery_adminGeneralCheck');
function socialGallery_adminGeneralCheck(){

	if (is_admin()){
		
		socialGallery_checkForUpgrade();
		
		global $socialGallery_slugs, $socialGallery_Settings;
		#} Just installed?
		$stage = 0;$wizardObj = $socialGallery_Settings->get('wizardObject');
		if (is_array($wizardObj))
			if (isset($wizardObj['stage'])) 
				 $stage = (int)$wizardObj['stage'];	
		
		if ($stage == 0 && !socialGallery_isASGAdminPage()) echo '<div class="updated"><p>Welcome to Social Gallery! Please <a href="admin.php?page='.$socialGallery_slugs['home'].'">Click Here</a> to finish the installation.</p></div>';
			
		#} Check for msgs to hide
		if (isset($_GET['hidemsg'])){
		
			$msgtohide = (int)$_GET['hidemsg'];
			$existingHidden = $socialGallery_Settings->get('hiddenMsgs'); if (!is_array($existingHidden)) $existingHidden = array();
			$existingHidden[] = $msgtohide;
			$socialGallery_Settings->update('hiddenMsgs',$existingHidden);		
			
			global $socialGalleryMessagehidden; $socialGalleryMessagehidden = true;
			
		}	
		
		#} Check for updates
		socialGallery_checkForUpdatesHeader();	
	
	}
}

#} Check for version upgrades
function socialGallery_checkForUpgrade(){
	
}


#} function to log the FB tags, can use the same code as from Facebook Social Polling with a few additions namely image SRC and tager / tagee.
add_action('wp_ajax_nopriv_sgLogTag', 'sgLogTag');   //people from the outside can post to this, not just from admin... 
add_action('wp_ajax_sgLogTag', 'sgLogTag');
function sgLogTag(){
	global $wpdb;
	global $socialGallery_t;
	//information logged
	$tagger 		= (int)$_POST['tagger'];
	$tagee 			= (int)$_POST['tagee'];
	$tagger_name 	= $_POST['tagger_name'];
	$tagee_name		= $_POST['tagee_name'];
	$relx 			= $_POST['relx'];
	$rely			= $_POST['rely'];
	$relh			= $_POST['relh'];
	$relw			= $_POST['relw'];
	$url 			= $_POST['url'];
	$tagst 			= $socialGallery_t['tags'];

	$query = $wpdb->prepare( "SELECT sg_tid FROM $tagst WHERE sg_taggee_id = %d AND sg_url = '%s'", $tagee, $url );
	$al = $wpdb->get_var($query);
    
	if($al == NULL){
		$query = $wpdb->prepare( "INSERT INTO $tagst ( sg_tagger_id , sg_taggee_id, sg_tagger_name, sg_taggee_name, sg_relx, sg_rely, sg_relh, sg_relw, sg_url ) VALUES ( %d, %d , '%s', '%s', '%s', '%s', '%s', '%s', '%s' )", $tagger, $tagee, $tagger_name, $tagee_name ,$relx, $rely, $relh, $relw, $url );
		$wpdb->query($query);
	}else{
		$query = $wpdb->prepare( "UPDATE $tagst SET sg_relx = %s, sg_rely = %s, sg_relh = %s, sg_relw = %s, sg_tagger_id = %d WHERE sg_taggee_id = %d AND sg_url = %s", $relx, $rely, $relh, $relw, $tagger, $tagee, $url );
		$wpdb->query($query);
	}
	exit();	
}


add_action('wp_ajax_nopriv_get_sg_tags_ajax', 'get_sg_tags_ajax');   //people from the outside can post to this, not just from admin... 
add_action('wp_ajax_get_sg_tags_ajax', 'get_sg_tags_ajax');
function get_sg_tags_ajax(){
	global 			$wpdb, $socialGallery_t;
	$url 			= 		$_POST['img'];
	$tagst 			= 		$socialGallery_t['tags'];
	$query 			= 		$wpdb->prepare("SELECT * FROM $tagst WHERE sg_url = '%s'", $url);
	$tags 			= 		(array)$wpdb->get_results($query);
	echo  json_encode($tags);
	die();
}



function get_sg_tags($url){
	global 			$wpdb, $socialGallery_t;
	$tagst 			= $socialGallery_t['tags'];
	$query 			= $wpdb->prepare("SELECT * FROM $tagst WHERE sg_url = '%s'", $url);
	$tags 			= (array)$wpdb->get_results($query);
	
	echo json_encode($tags);
	
	return $tags;
}

#} Custom AJAX Handler 
add_action('wp_ajax_SocialGallery', 'socialGallery_XML_Response');
function socialGallery_XML_Response(){
	global $wpdb;
	if (is_admin()){
	
		if (isset($_POST['socialGalleryRequestVar']['t'])){
				
				$acceptable = array('init','stats','init2','stats2','totLikeCount',	'initFull','statsFull'); #,'go'
				if (in_array($_POST['socialGalleryRequestVar']['t'],$acceptable)){
					
					switch ($_POST['socialGalleryRequestVar']['t']){
						
						case 'init':
								
							$postsAndPagesLeft = socialGallery_retrieveToUpdateCounts();
							#} Make str
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts, ' .  socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] == 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] == 0) $str = 'No posts or pages to process.';
							
							$last = get_user_meta(1,'sgplast',true);
							
							echo json_encode(array('s'=>true,'t'=>$str,'p'=>0,'l'=>$last));
							break;	
						
						
						
						case 'stats':
						
							$postsAndPagesLeft = socialGallery_retrieveToUpdateCounts();
							#} Make str
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts, ' .  socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] == 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] == 0) $str = 'No posts or pages to process.';
								
							#} Calc perc
							$count_posts = wp_count_posts();
							$published_posts = $count_posts->publish;
							$count_pages = wp_count_posts('page');
							$published_pages = $count_pages->publish;
							$totalPosts = (int)$published_pages + (int)$published_posts;
							$totalTodo = (int)$postsAndPagesLeft[0] + (int)$postsAndPagesLeft[1];
							$totalDonePosts = $totalPosts - $totalTodo;
							if ($totalPosts > 0 && $totalDonePosts > 0) $p = ($totalDonePosts/$totalPosts)*100; else $p = 0;
							$str2 = 'Processed '.$totalDonePosts.' out of '.$totalPosts;
							$existingCount = socialGallery_getLibraryCount();					
							echo json_encode(array('s'=>true,'t'=>$str,'p'=>round($p,2),'i'=>socialGallery_prettifyLongInts($existingCount),'t2'=>$str2));
		
							break;
						case 'initFull':
								
							$postsAndPagesLeft = socialGallery_retrieveToUpdateCountsFull();
							#} Make str
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts, ' .  socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] == 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] == 0) $str = 'No posts or pages to process.';
							
							echo json_encode(array('s'=>true,'t'=>$str,'p'=>0));
							break;	
						case 'statsFull':
						
							$postsAndPagesLeft = socialGallery_retrieveToUpdateCountsFull();
							#} Make str
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts, ' .  socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] > 0 && (int)$postsAndPagesLeft[1] == 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] > 0) $str = socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
							if ((int)$postsAndPagesLeft[0] == 0 && (int)$postsAndPagesLeft[1] == 0) $str = 'No posts or pages to process.';
								
							#} Calc perc
							//$count_posts = wp_count_posts();
							
							$published_posts = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type <> 'page' AND post_type <> 'nav_menu_item' AND post_status = 'publish'");
							
							$count_pages = wp_count_posts('page');
							$published_pages = $count_pages->publish;
							
							$totalPosts = (int)$published_pages + (int)$published_posts;
							
							$totalTodo = (int)$postsAndPagesLeft[0] + (int)$postsAndPagesLeft[1];
							$totalDonePosts = $totalPosts - $totalTodo;
							if ($totalPosts > 0 && $totalDonePosts > 0) $p = ($totalDonePosts/$totalPosts)*100; else $p = 0;
							$str2 = 'Processed '.$totalDonePosts.' out of '.$totalPosts;
							$existingCount = socialGallery_getLibraryCount();		
							$last = get_user_meta(1,'sgplast',true);			
							echo json_encode(array('s'=>true,'t'=>$str,'p'=>round($p,2),'i'=>socialGallery_prettifyLongInts($existingCount),'t2'=>$str2 , 'l'=>$last));
		
							break;
							
						
						
						case 'init2':
					
							$imagesLeft = socialGallery_retrieveISocialToUpdateCount();
							#} Make str
							if ((int)$imagesLeft > 0) $str = socialGallery_prettifyLongInts($imagesLeft).' images left to process.';
							if ((int)$imagesLeft == 0) $str = 'No images to process.';
							
							echo json_encode(array('s'=>true,'t'=>$str,'p'=>0));
							break;	
						case 'stats2':
						
							$imagesLeft = socialGallery_retrieveISocialToUpdateCount();
							#} Make str
							if ((int)$imagesLeft > 0) $str = socialGallery_prettifyLongInts($imagesLeft).' images left to process.';
							if ((int)$imagesLeft == 0) $str = 'No images to process.';
								
							#} Calc perc
							$existingCount = socialGallery_getLibraryCount();
							$socialprocessed = $existingCount-$imagesLeft;
							if ($existingCount > 0 && $socialprocessed > 0) $p = ($socialprocessed/$existingCount)*100; else $p = 0;
							$str2 = 'Processed '.$socialprocessed.' out of '.$existingCount;					
							echo json_encode(array('s'=>true,'t'=>$str,'p'=>round($p,2),'i'=>socialGallery_prettifyLongInts($existingCount),'t2'=>$str2));
		
							break;
						case 'totLikeCount':
						
							echo json_encode(array('s'=>true,'r'=>socialGallery_retrieveTotalLikeTweetPinCount()));
		
							break;
					}
					
				}
				
				
			}
		
		} # End if is admin

	exit();	
	
}

#} Load Intercepter
add_filter('wp_loaded', 'socialGallery_wp_loaded_intercept' );
function socialGallery_wp_loaded_intercept(){
	
	# Even more brutal.	
	if (isset($_GET['sgSilentCrawl']) && is_admin() && current_user_can('manage_options')){
		
		if (isset($_GET['sgGo'])) if ($_GET['sgGo'] == "3"){
			
				global $wpdb,$socialGallery_t,$socialGallery_version;
				
				#} Is included within the function, but include here for good measure
				#} Require the simple_html_dom # REQUIRES PHP 5!
			//
			
			
			//	require_once(SOCIALGALLERYPLUGIN_PATH.'includes/simple_html_dom.php');
				
				$crawlMode = 'quick'; if (isset($_GET['sgFull'])) $crawlMode = 'full';
				
				if ($crawlMode == 'full')
					$posts = socialGallery_retrieveToUpdateFull(2); # Direct call, will only get not updated.
				else
					$posts = socialGallery_retrieveToUpdate(5); # Direct call, will only get not updated.
				
				#} If posts exist
				if ($posts){
					
					#} Cycle through posts - why specific to post or page?? could parse all items in the directory including the author pages... MJS
					foreach ($posts as $targetPost){												
						if ($targetPost->post_type == 'page'){
							socialGallery_parsePageFromID($targetPost->ID,$crawlMode);
						}else{
							socialGallery_parsePostFromID($targetPost->ID,$crawlMode);
						} 
					}
			
				}
				
				if ($crawlMode == 'full')
					$remaining = socialGallery_retrieveToUpdateTotalCountFull();
				else
					$remaining = socialGallery_retrieveToUpdateTotalCount();
				
				if ($remaining > 0) echo '<script type="text/javascript">setTimeout(function(){document.location.reload(true)},5000)</script>'; else echo 'Fini';
			} 
			exit();
		}	
	
		#} Social Stats Crawler Slot
		if (function_exists('socialGalleryAddon_SS_StatsCrawler')) socialGalleryAddon_SS_StatsCrawler();
}

#} Nextgen Off Catcher
function socialGallery_autoDisable(){
	
	global $socialGallery_Settings;

	#} NGG Compatability fixes.
	if ((int)$socialGallery_Settings->get('autoDisableNextGen') == 1 && in_array($socialGallery_Settings->get('selectorType'),array("6","7","8","9"))){
		
				# Brutal
				socialGallery_forceOffNextgen(); 
    			socialGallery_html_msg(0,"Successfully disabled NextGen Effects");
		
		
	}	
	
}


#=======================================================================================================================
function sg__________PAGES(){}					# Pages
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#} Overriding Wizard
function socialGallery_pages_wizard(){
	
	global $socialGallery_slugs,$socialGallery_version, $socialGallery_Settings,$socialGallery_urls;
	
	# Load wizard obj
	$wizardObj = $socialGallery_Settings->get('wizardObject'); if (!is_array($wizardObj)) $wizardObj = array();
	
	# Identify stage
	$stage = 0; 
	if (isset($wizardObj['stage'])) {
		 $stage = $wizardObj['stage'];
	}
	if (isset($_POST['stage'])) {
		$stage = (int)$_POST['stage'];
	}
		
	#} 4 is last stage.
	if ($stage > 4 || $stage < 0) $stage = 0;
		
	#} Process any data save.
	switch ($stage){
		
		case 1: 	
				
			#} Backup any existing options.
			$socialGallery_Settings->createBackup('Pre Wizard Install');
			/*
			$previousOptions = array('s1'=>get_option('socialGallery_selectorType'),'s2'=>urlencode(get_option('socialGallery_selector')),'s3'=>get_option('socialGallery_bottomBar'),'s4'=>get_option('socialGallery_bottomBarTitleSource'),'v'=>$socialGallery_version,'s5'=>get_option('socialGallery_headerBoxType'),'s6'=>get_option('socialGallery_incDesc'),'s7'=>get_option('socialGallery_incTwit'),'s8'=>get_option('socialGallery_incFB'),'s9'=>get_option('socialGallery_incFBFaces'),'s10'=>get_option('socialGallery_incPin'),'s11'=>get_option('socialGallery_incFBComments'),'s12'=>get_option('socialGallery_incDisqusComments'),'s13'=>get_option('socialGallery_incTwitSRC'),'s14'=>get_option('socialGallery_incFBSRC'),'s15'=>get_option('socialGallery_incPinSRC'),'s16'=>get_option('socialGallery_incHomeCall'),'s17'=>get_option('autoDisableNextGen'),'s18'=>get_option('socialGallery_incDLLink')); 
			if (!get_option('socialGallery_upbk')) add_option('socialGallery_upbk',array(time()=>$previousOptions)); else { $obk = get_option('socialGallery_upbk'); $obk[time()] = $previousOptions; update_option('socialGallery_upbk',$obk); } */
		
			#} Retrieve & Save
			$userEmail = ''; $ccUser = ''; $subscribeflag = '';
			if (isset($_POST['ccUser'])) { $ccUser = sanitize_text_field($_POST['ccUser']); $wizardObj['ccUser'] = $ccUser; }
			if (isset($_POST['email'])) { $userEmail = sanitize_text_field($_POST['email']); $wizardObj['userEmail'] = $userEmail; }
			if (isset($_POST['updateme'])) { $subscribeflag = sanitize_text_field($_POST['updateme']); $wizardObj['subscribeflag'] = $subscribeflag; }
			
			#} Fire Reg
			$p = wp_count_posts(); $p = (int)$p->publish;
			$pa = wp_count_posts('page'); $pa = (int)$pa->publish;
			$n = 0; if (class_exists('nggdb')) $n = 1;
			$j = 0; if (class_exists('JustifiedImageGrid')) $j = 1;
			socialGallery_sendReg($userEmail,$subscribeflag,$ccUser,$p,$pa,$n,$j);
			
			#} Save to option
			if (!empty($ccUser)) $socialGallery_Settings->update('affUser',$ccUser);
			
			$wizardObj['stage'] = 1;			
			$socialGallery_Settings->update('wizardObject',$wizardObj);
			
			#} Also force of nextgen 
			socialGallery_forceOffNextgen(); 
			
			break;
		case 2:
		
			#} Selector Saving
			$postedSelectorType = ''; $postedSelector = '';
			if (isset($_POST['socialGallery_selectorType'])) $postedSelectorType = (int)$_POST['socialGallery_selectorType'];
			if (isset($_POST['socialGallery_selector'])) $postedSelector = sanitize_text_field($_POST['socialGallery_selector']);
	
			#} Validate?
	
			#} Update
			$socialGallery_Settings->update('selectorType',$postedSelectorType);
			$socialGallery_Settings->update('selector',$postedSelector);	
			
			$wizardObj['stage'] = 2;			
			$socialGallery_Settings->update('wizardObject',$wizardObj);
			break;
			
		case 3:
			#} Pages setting Saving
			$socialGalleryPagesOption = 1;
			if (isset($_POST['socialGalleryPagesOption'])) $socialGalleryPagesOption = (int)$_POST['socialGalleryPagesOption'];
			switch($socialGalleryPagesOption){
			
				case 1:
					#} Update options - SG pages
					$socialGallery_Settings->update('useSGPages',1);
					$socialGallery_Settings->update('fallbackUrlOption',1); # Default fallback = image url
					#} Crawl required
					$wizardObj['stage'] = 3;
					break;
				case 2:
					#} Update options - imageurl
					$socialGallery_Settings->update('useSGPages',0);
					$socialGallery_Settings->update('fallbackUrlOption',1); 
					#} Crawl not required
					$wizardObj['stage'] = 4;
					#} Needs to skip stage 3
					$skipped3 = true;
					$stage = 4;
					break;
				case 3:
					#} Update options - hash index
					$socialGallery_Settings->update('useSGPages',0);
					$socialGallery_Settings->update('fallbackUrlOption',2); 
					#} Crawl not required
					$wizardObj['stage'] = 4;
					#} Needs to skip stage 3
					$skipped3 = true;
					$stage = 4;
					break;
				case 4:
					#} Update options - page url
					$socialGallery_Settings->update('useSGPages',0);
					$socialGallery_Settings->update('fallbackUrlOption',3); 
					#} Crawl not required
					$wizardObj['stage'] = 4;
					#} Needs to skip stage 3
					$skipped3 = true;
					$stage = 4;
					break;	
				default:
					#} Update options - SG pages - Default
					$socialGallery_Settings->update('useSGPages',1);
					$socialGallery_Settings->update('fallbackUrlOption',1); # Default fallback = image url
					#} Crawl required
					$wizardObj['stage'] = 3;
					break;
				
				
			} 
			#} Wizard obj.
			$socialGallery_Settings->update('wizardObject',$wizardObj);
			break;
		case 4:
		
			#} Mark Library updated.			
			$wizardObj['stage'] = 4;			
			$socialGallery_Settings->update('wizardObject',$wizardObj);
			break;
			
		default:
			#} Do nothing.
			break;
	}
	
?>
<!--[if gte IE 9]><style type="text/css">.gradient {filter: none;}</style><![endif]-->
<div id="sgpBody">
    <div class="wrap"> 
	    <div id="icon-sg" class="icon32"><br /></div><h2>Social Gallery Plugin</h2> 
    	<div id="sgpSocial">
            <a href="http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fwww.socialgalleryplugin.com&media=http%3A%2F%2Fwww.socialgalleryplugin.com%2FsocialGallery.png&description=I%20use%20the%20Social%20Gallery%20Plugin%20for%20Wordpress%2C%20its%20awesome!%20http%3A%2F%2Fwww.socialgalleryplugin.com" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a>
            <a href="https://twitter.com/share" class="twitter-share-button" data-via="SocialGalleryWP" data-url="http://socialgalleryplugin.com">Tweet</a>
            <a href="<?php echo $socialGallery_urls['showcase']; ?>" title="Showcase your Social Gallery" target="_blank" id="showcase">Showcase your Social Gallery</a>
            <div class="fb-like" data-href="http://socialgalleryplugin.com" data-send="true" data-width="400" data-show-faces="false"></div>
        </div>
    </div>
    <h3>Welcome to Social Gallery!</h3>
    <p>You've successfully installed Social Gallery, now to get it working on your blog please follow this wizard.</p>
	<form method="post" id="postBox">
	<?php
	
	switch ($stage){
		
		case 0: ?><input type="hidden" name="stage" value="1" />
    <table cellpadding="0" cellspacing="1" class="sgwizard">
    <tr><td colspan="2"><div class="sgwizardHd">1. Your Social Gallery</div></td></tr>
    <tr><td class="sgwL">Your username:</td><td><input type="text" value="" name="ccUser" id="ccUser" style="width:120px" />*</td></tr>
    <tr style="display:none" id="ccShow"><td colspan="2"><div class="wError">This field is required!</div></td></tr>
    <tr><td class="sgwL">Your Email Address:</td><td><input type="text" value="<?php echo get_option('admin_email'); ?>" name="email" id="email" style="width:200px" /></td></tr>
    <tr><td class="sgwL">&nbsp;</td><td style="text-align:right"><button type="button" id="sgNextStep" class="SocialGalleryOB">Next Step</button></td></tr>
    </table>
	<script type="text/javascript">jQuery(document).ready(function(e) {
        jQuery('#sgNextStep').unbind('click').click(function(ev){
			if (jQuery('#ccUser').val() == ""){
				jQuery('#ccShow').show();
			} else jQuery('#postBox').submit();
		});
		jQuery('#ccUser').change(function(ev){
			if (jQuery(this).val().length > 0) jQuery('#ccShow').hide();			
		});
    });</script><?php 
			break;
	
		#} SELECTORS
		case 1: 
		
		#} Is there an existing?
		$selectorType = $socialGallery_Settings->get('selectorType');
		$selector = $socialGallery_Settings->get('selector');
		?><input type="hidden" name="stage" value="2" />
    <table cellpadding="0" cellspacing="1" class="sgwizard">
    <tr><td colspan="2"><div class="sgwizardHd">2. Social Gallery Selectors</div></td></tr>
    <tr><td colspan="2">
    		<p class="sgwizenth" style="text-align:center">Social Gallery needs to know which images you want it to work with.<br />Please choose a Preset Mode or type a Custom CSS Selector.</p>
            	<table style="width:420px;margin-left:auto;margin-right:auto;">
                <tr>	
                	<td class="sgwL">Preset Mode:</td>
                	<td><select name="socialGallery_selectorType" id="socialGallery_selectorType">
                                <option value="1"<?php if ($selectorType == "1") echo ' selected="selected"'; ?>>All Content Images</option>
                                <option value="10"<?php if ($selectorType == "10") echo ' selected="selected"'; ?>>Post Images</option>
                                <option value="3"<?php if ($selectorType == "3") echo ' selected="selected"'; ?>>Page Images</option>
                                <option value="4"<?php if ($selectorType == "4") echo ' selected="selected"'; ?>>Compatibility Mode</option>
                                <option value="5"<?php if ($selectorType == "5") echo ' selected="selected"'; ?>>Gallery Compatibility Mode</option>
                                <option value="11"<?php if ($selectorType == "11") echo ' selected="selected"'; ?>>Justified Image Grid</option>
                                <option value="6"<?php if ($selectorType == "6") echo ' selected="selected"'; ?>>NextGen Compatibility Mode</option>
                                <option value="7"<?php if ($selectorType == "7") echo ' selected="selected"'; ?>>NextGen Thumbnails</option>
                                <option value="8"<?php if ($selectorType == "8") echo ' selected="selected"'; ?>>NextGen Widget Only</option>
                                <option value="9"<?php if ($selectorType == "9") echo ' selected="selected"'; ?>>NextGen Gallery Overview</option>
                                <option value="12"<?php if ($selectorType == "12") echo ' selected="selected"'; ?>>Essential Grid Compatibility</option>
                                <option value="13"<?php if ($selectorType == "13") echo ' selected="selected"'; ?>>Final Tiles Grid Compatibility</option>
                                <option value="2"<?php if ($selectorType == "2") echo ' selected="selected"'; ?>>Specific Images</option>
	               </select></td>
               </tr>
               <tr>
               		<td class="sgwL">Custom CSS Selector:</td>
                    <td><input type="text" name="socialGallery_selector" id="socialGallery_selector" value="<?php echo $selector; ?>" /><br />e.g. '.entry-content a:has(img)'</td>
               </tr>
               </table>
               <!--<p style="margin-left:53px;margin-right:45px;margin-bottom:33px;">A Custom CSS Selector should be the class or ID of the HTML element which contains images to use with Social Gallery. <a href="http://www.socialgalleryplugin.com/social-gallery-wordpress-plugin-and-css-selectors/" target="_blank">Read More on Custom CSS Selectors</a></p>-->
            </td></tr>
   	<tr><td class="sgwL">&nbsp;</td><td style="text-align:right"><button type="button" id="sgNextStep" class="SocialGalleryOB">Next Step</button></td>
    </tr>
    </table>
            <div class="sgwizardtip"><span>Tip:</span><div>For most users one of the Preset Modes will work best.<br />Only very Customised themes require a Custom CSS Selector.<br /><br />
            <a href="http://www.socialgalleryplugin.com/preset-modes/" target="_blank">Read More About This Setting</a> or <a href="http://www.socialgalleryplugin.com/social-gallery-wordpress-plugin-and-css-selectors/" target="_blank">Read More on Custom CSS Selectors</a>
            </div></div>
	<script type="text/javascript">jQuery(document).ready(function(e) {
        jQuery('#sgNextStep').unbind('click').click(function(ev){
			jQuery('#postBox').submit();
		});
    });</script><?php
			break;
			
			
			#} PAGE OPTIONS
			case 2: ?><input type="hidden" name="stage" value="3" />
    <table cellpadding="0" cellspacing="1" class="sgwizard">
    <tr><td colspan="2"><div class="sgwizardHd">3. Social Gallery Pages</div></td></tr>
    <tr><td colspan="2">
    		<p class="sgwizenth" style="text-align:center"><strong>Social Gallery Pages</strong> is an added feature of Social Gallery v2 which creates a page for each image to enhance social sharing. This setting defines the URL that likes, tweets, comments etc. gets marked against.</p> 
    		<table style="width:438px;margin-left:auto;margin-right:auto;">
                <tr>	
                	<td class="sgwL">Social Gallery Pages:</td>
                	<td>
                    	<select name="socialGalleryPagesOption" id="socialGalleryPagesOption" style="padding:4px;">
                            <option value="1">Use Social Gallery Pages [recommended]</option>
                            <option value="2">Use Image URL</option>
                            <option value="3">Use Hash Index (#sg1 etc.)</option>
                            <option value="4">Use Blog Page URL</option>
	            		</select>
                    </td>
                </tr>
            </table>
            
            </td></tr>
   	<tr><td class="sgwL">&nbsp;</td><td style="text-align:right"><button type="button" id="sgNextStep" class="SocialGalleryOB">Next Step</button></td>
    </tr>
    </table>
     <div class="sgwizardtip"><span>Tip:</span><div>For most users "<strong>Use Social Gallery Pages</strong>" will work best<br />
            <a href="http://www.socialgalleryplugin.com/social-gallery-pages/" target="_blank">Read More About Social Gallery Pages</a>
            </div></div>
	<script type="text/javascript">jQuery(document).ready(function(e) {
        jQuery('#sgNextStep').unbind('click').click(function(ev){
			jQuery('#postBox').submit();
		});
    });</script><?php
			break;
				
	
		#} CRAWLER!
		case 3: ?>
		<!-- let the scanner be skipped -->
		<script type="text/javascript">jQuery(document).ready(function(e) {
        jQuery('#sgNextSkip').bind('click').click(function(ev){
			if(confirmSkip()){
				jQuery('#postBox').submit();
			}
		});
    });</script>
		<input type="hidden" name="stage" value="4" />
    <table cellpadding="0" cellspacing="1" class="sgwizard">
    <tr><td colspan="2"><div class="sgwizardHd">4. Build Social Gallery Library</div></td></tr>
    <tr><td colspan="2">
    		<p class="sgwizenth" style="text-align:center">Social Gallery needs to build a library of all of the images on your blog. By building this library ahead of time it means Social Gallery can better serve your images<br />(as well as enabling some other cool features.)</p>
    		<div id="wizardCrawl">Your Posts and Pages: <?php
	
	
				$postsAndPagesLeft = socialGallery_retrieveToUpdateCounts();
				$unprocessedTotal = (int)$postsAndPagesLeft[0] + (int)$postsAndPagesLeft[1];
				#} Make str
				$str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts, '
					.  socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages to process.';
				echo $str;
    
				if ($unprocessedTotal > 0){ 
				
					#} Identify if resume or fresh.
					
					
					#} Calc perc
					$count_posts = wp_count_posts();
					$published_posts = $count_posts->publish;
					$count_pages = wp_count_posts('page');
					$published_pages = $count_pages->publish;
					$totalPosts = (int)$published_pages + (int)$published_posts;
					$lastscan = get_user_meta(1,'sgplast',true);
					$totalTodo = (int)$postsAndPagesLeft[0] + (int)$postsAndPagesLeft[1];
					$totalDonePosts = $totalPosts - $totalTodo;
					if ($totalPosts > 0 && $totalDonePosts > 0) $p = ($totalDonePosts/$totalPosts)*100; else $p = 0;
					
		
					if ($totalDonePosts > 0) {
							$terminology = 'Resume'; 
							$str2 = 'Processed '.$totalDonePosts.' of '.$totalPosts . '<br/>Scanning: ' . $lastscan ;
					} else {
							$terminology = 'Start';
							$str2 = '';
					}
					
					
					?>
					<div align="center" style="text-align:center" id="processUpdate"></div>
					<div id="ubProgress" style="width:480px;margin-left:auto;margin-right:auto;<?php if ($p == 0) echo 'display:none'; ?>">
					
						<div id="progressText" style="text-align:center;margin:10px;padding:10px"><?php echo $str2; ?></div>
						<div class="meter orange" id="progressBar">
							<span style="width: <?php echo $p; ?>%" id="progMe"><span></span></span>
						</div>
					
					</div><script type="text/javascript">var libDone = false;</script>
					<iframe src="admin.php?page=<?php echo $socialGallery_slugs['updateengine']; ?>&sgSilentCrawl=true&sgGo=false" id="crawlerFull" style="width:600px;height:400px;display:none;"></iframe></div></td></tr>
    <tr><td class="sgwL">&nbsp;</td><td style="text-align:right"><button id="startUB" class="bButton">Build Library</button><button type="button" id="sgNextStep" class="sgwizardbutton" disabled="disabled" style="text-decoration:line-through;display:none;" title="You need to build the library to continue!">Next Step</button>
				<button type="button" id="sgNextSkip" class="SocialGalleryOB" style = "cursor:pointer">Skip</button></td>
				
				
				<?php } else { ?><script type="text/javascript">var libDone = true;</script>
				<div class="sgsuccess wrap sgM" style="width:382px">Library up to date :)</div></div></td></tr>
    <tr><td class="sgwL">&nbsp;</td><td style="text-align:right"><button type="button" id="sgNextStep" class="SocialGalleryOB">Next Step</button></td>
				<?php } 
				
	?></tr>
    </table>
     <div class="sgwizardtip"><span>Tip:</span><div>Social Gallery does some pretty nifty stuff with its image scanning.<br />
            <a href="http://www.socialgalleryplugin.com/social-gallery-image-library-scans/" target="_blank">Read More About Social Gallery's Scans</a>
            </div></div>
	<script type="text/javascript">function onStatCompletion(){		
		jQuery('#startUB').fadeOut(300,function(){
			jQuery('#sgNextStep').fadeIn(300).css('text-decoration','none').attr('title','').removeAttr('disabled');
			console.log("noted completion of crawl");
			window.libDone = true;
			
			jQuery('#processUpdate h4').html('Social Gallery has built your image library! From now on you should\'t need to update it, but if you do you can do so via Update Engine from the menu.');
		});			
	}jQuery(document).ready(function(e) {
        jQuery('#sgNextStep').unbind('click').click(function(ev){
			if (libDone) jQuery('#postBox').submit();
		});
    });</script><?php
			break;
			
		case 4:
		
			if (isset($skipped3)) $pageNo = 4; else $pageNo = 5;
			
			#} Catch first installs.
			
		?>
    <table cellpadding="0" cellspacing="1" class="sgwizard">
    <tr><td colspan="2"><div class="sgwizardHd"><?php echo $pageNo; ?>. Complete</div></td></tr>
    <tr><td colspan="2" id="socialGalleryBL">
    	<div style="text-align:center">
        	<img src="<?php echo plugins_url('/i/thanks-for-using-social-gallery.png',__FILE__); ?>" width="450" alt="Thanks For Using Social Gallery" style="margin:8px" />
        </div>
    <p>Social Gallery has finished the basic install and is now live with the default settings!<br />Thanks again for using Social Gallery, please do <a href="https://www.facebook.com/socialgalleryplugin" target="_blank">Follow us on Facebook</a> and <a href="http://twitter.com/socialgallerywp" target="_blank">Tweet to us on Twitter</a>!</p>
    <!--
    <p style="text-align:center">To make sure Social Gallery has all of your images, you can also run a Full Scan (you can do this later from "Update Engine" on the menu bar):</p>
    <p style="text-align:center"><button type="button" id="sgRunFull" class="SocialGalleryOB">Run a Full Scan Now</button></p>
    <p style="text-align:center">...or go straight to the settings:</p> -->
    <p style="text-align:center"><button type="button" id="sgNextStep" class="SocialGalleryOB">Go to Settings</button></p>
    </tr>
    </table>
	<script type="text/javascript">jQuery(document).ready(function(e) {
        jQuery('#sgNextStep').unbind('click').click(function(ev){
			window.location = 'admin.php?page=<?php echo $socialGallery_slugs['settings']; ?>';
		});
        jQuery('#sgRunFull').unbind('click').click(function(ev){
			window.location = 'admin.php?page=<?php echo $socialGallery_slugs['updateengine']; ?>&commencefull=1';
		});
    });</script><?php 
			break;
	
	
	}
	
?></form></div><?php
}

#} Settings Page Catcher
function socialGallery_pages_settings(){
	
		$toSave = false; if (isset($_GET['save'])) if ($_GET['save'] == "1") $toSave = true; 
		
		if ($toSave){
		
			socialGallery_save_settings(); 
		
		} else { 
		
			global $socialGalleryWizardPrompt;
    
			# Check for Wizard Status
			socialGallery_checkWizardStatus();
			
			if ($socialGalleryWizardPrompt){
				
				socialGallery_pages_wizard();
				
			} else {
		
				socialGallery_pages_settings_html(); 
			
			}
		
		}	
				
}

#} Settings Page Proper
function socialGallery_pages_settings_html(){
	
	global $wpdb, $socialGallery_db_version, $socialGallery_version, $socialGallery_t, $socialGallery_urls, $socialGallery_slugs, $socialGallery_Settings;	#} Req
    

	#} Lazy retrieval of all
	$sgConfig = $socialGallery_Settings->getAll();	
	$nextGenOptions = array("6","7","8","9");
	
	SGPv3header();

    global $socialGallerySavedSettingsFlag; if (isset($socialGallerySavedSettingsFlag)) if ($socialGallerySavedSettingsFlag) socialGallery_html_msg(0,"Saved options");
	
	
	$tabToShow = 'General';
	if (isset($_POST['loadTab'])) $tabToShow = sanitize_text_field($_POST['loadTab']);
	
		?>
        <p id="sgpDesc">Here you can set the configuration options for your Social Gallery Plugin. Before changing anything please read our <a href="<?php echo $socialGallery_urls['docs']; ?>" title="View Documentation" target="_blank">setup guide</a>.</p>
        <form action="?page=<?php echo $socialGallery_slugs['settings']; ?>&save=1" id="settingsForm" method="post">
        <input type="hidden" value="<?php echo $tabToShow ?>" name="loadTab" id="loadTab" />
        <div id="socialGallerySettings">
            <div id="socialGalleryMenu">
                <div<?php if ($tabToShow == "General") echo ' class="socialGalleryPageActive"'; ?> id="General">General</div>
                <div<?php if ($tabToShow == "Style") echo ' class="socialGalleryPageActive"'; ?> id="Style">Style</div>
                <div<?php if ($tabToShow == "Social") echo ' class="socialGalleryPageActive"'; ?> id="Social">Social</div>
                <div<?php if ($tabToShow == "Comments") echo ' class="socialGalleryPageActive"'; ?> id="Comments">Comments</div>
                <div<?php if ($tabToShow == "Adverts") echo ' class="socialGalleryPageActive"'; ?> id="Adverts">Adverts</div>
                <div<?php if ($tabToShow == "Devices") echo ' class="socialGalleryPageActive"'; ?> id="Devices">Devices</div>
                <div<?php if ($tabToShow == "Addons") echo ' class="socialGalleryPageActive"'; ?> id="Addons">Add-ons</div>
                <div<?php if ($tabToShow == "AdminTools") echo ' class="socialGalleryPageActive"'; ?> id="AdminTools">Admin Tools</div>
            </div>
            <div id="socialGallerySettingsPage">
            
            
                <div id="socialGalleryPageGeneral" class="socialGalleryPage<?php if ($tabToShow == "General") echo ' socialGalleryPageActive'; ?>">
           			<h3>General Settings</h3>
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
                    
                    <?php socialGallery_trhd('Social Gallery Mode',0); ?>
                    
                    <tr>
                    <td class="sgFieldLabel">Social Gallery Mode:</td>
                        <td class="sgField">
                            <select name="socialGallery_selectorType" id="socialGallery_selectorType">
                                <option value="1"<?php if ($sgConfig['selectorType'] == "1") echo ' selected="selected"'; ?>>All Content Images</option>
                                <option value="10"<?php if ($sgConfig['selectorType'] == "10") echo ' selected="selected"'; ?>>Post Images</option>
                                <option value="3"<?php if ($sgConfig['selectorType'] == "3") echo ' selected="selected"'; ?>>Page Images</option>
                                <option value="4"<?php if ($sgConfig['selectorType'] == "4") echo ' selected="selected"'; ?>>Compatibility Mode</option>
                                <option value="5"<?php if ($sgConfig['selectorType'] == "5") echo ' selected="selected"'; ?>>Gallery Compatibility Mode</option>
                                <option value="11"<?php if ($sgConfig['selectorType'] == "11") echo ' selected="selected"'; ?>>Justified Image Grid</option>
                                <option value="6"<?php if ($sgConfig['selectorType'] == "6") echo ' selected="selected"'; ?>>NextGen Compatibility Mode</option>
                                <option value="7"<?php if ($sgConfig['selectorType'] == "7") echo ' selected="selected"'; ?>>NextGen Thumbnails</option>
                                <option value="8"<?php if ($sgConfig['selectorType'] == "8") echo ' selected="selected"'; ?>>NextGen Widget Only</option>
                                <option value="9"<?php if ($sgConfig['selectorType'] == "9") echo ' selected="selected"'; ?>>NextGen Gallery Overview</option>
                        		<option value="12"<?php if ($sgConfig['selectorType'] == "12") echo ' selected="selected"'; ?>>Essential Grid Compatibility</option>
                        		<option value="13"<?php if ($sgConfig['selectorType'] == "13") echo ' selected="selected"'; ?>>Final Tiles Grid Compatibility</option>
                                <option value="2"<?php if ($sgConfig['selectorType'] == "2") echo ' selected="selected"'; ?>>Specific Images</option>
                            </select>
                        </td>
                    </tr>
                    <tr id="sgpCustomCSS"<?php if ($sgConfig['selectorType'] != "2") echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel" width="240" valign="top" style="padding-top:10px;">Include images within webpage elements with class(es) or ID(s)::</td>
                        <td class="sgField">
                            <input type="text" name="socialGallery_selector" id="socialGallery_selector" value="<?php echo $sgConfig['selector']; ?>" />
                            <br />* This should be the css class or id of the link around the image (e.g. '.socialGallery') <a href="http://www.socialgalleryplugin.com/social-gallery-wordpress-plugin-and-css-selectors/" target="_blank">Read more about how to tell Social Gallery what images to open</a>
                        </td>
                    </tr>
                    <tr id="sgpNextGenAutoSwitch"<?php if (!in_array($sgConfig['selectorType'],$nextGenOptions)) echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel sgFieldLabelCB" width="240" valign="top" style="padding-top:10px;">Automatically disable NextGen Effect:</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['autoDisableNextGen'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                            	<input type="checkbox" name="socialGallery_autoDisableNextGen" id="socialGallery_autoDisableNextGen" value="1" <?php if ($sgConfig['autoDisableNextGen'] == "1") echo ' checked="checked"'; ?> />
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="sgFieldLabel" width="240" valign="top" style="padding-top:10px;">Exclude images within webpage elements with class(es) or ID(s):</td>
                        <td class="sgField">
                            <input type="text" name="socialGallery_discludeSelectors" id="socialGallery_discludeSelectors" value="<?php echo $sgConfig['discludeSelectors']; ?>" />
                            <br />* This is for any additional to the already existing .noLightBox and .noSocialGallery
                        </td>
                    </tr>
                    
					<?php socialGallery_trhd('General:'); ?>
                    <tr>
                        <td class="sgFieldLabel">Facebook Admin ID's CSV</td>
                        <td class="sgField">
                            <input type="text" name="socialGallery_FBAdmins" id="socialGallery_FBAdmins" value="<?php if (!empty($sgConfig['FBAdmins'])) echo $sgConfig['FBAdmins']; ?>"  />
                            <br />E.g. 5324234232,12345678
                        </td>
                    </tr>
                    <?php if (isset($sgpNotDeprecated)){ ?>
                    <tr>
                        <td class="sgFieldLabel sgFieldLabelCB">Include Swipe Gestures<br />(iPad, iPhone and Mobile.)</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['incSwipe'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_incSwipe" id="socialGallery_incSwipe" value="1" <?php if ($sgConfig['incSwipe'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                            *Note: This is an experimental feature, device support is not guaranteed.
                        </td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td class="sgFieldLabel sgFieldLabelCB hide">Face Detection</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['sgFaceDetect'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_sgFaceDetect" id="socialGallery_sgFaceDetect" value="1" <?php if ($sgConfig['sgFaceDetect'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                            *Note: This is an experimental feature, requires PHP 5.3+ your php version is <b><?php echo phpversion(); ?></b>.
                        </td>
                    </tr>
                    <tr>
                        <td class="sgFieldLabel sgFieldLabelCB">FullScreen Mode</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['incFullScreen'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_incFullScreen" id="socialGallery_incFullScreen" value="1" <?php if ($sgConfig['incFullScreen'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                            *Note: This is an experimental feature, device support is not guaranteed.
                        </td>
                    </tr>
                    <tr>
                        <td class="sgFieldLabel sgFieldLabelCB">Always Fullscreen Mode</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['alwaysFullScreen'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_alwaysFullScreen" id="socialGallery_alwaysFullScreen" value="1" <?php if ($sgConfig['alwaysFullScreen'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                        </td>
                    </tr>
                    <tr>
                        <td class="sgFieldLabel">Enlarge Images By:</td>
                        <td class="sgField">
                            <select name="socialGallery_upscaleFactor" id="socialGallery_upscaleFactor">
                            <?php 
                                    for ($i = 0; $i <= 20; $i++){
                                        echo '<option value="'.(1+($i*0.1)).'"';
                                        if ((1+($i*0.1)) == $sgConfig['upscaleFactor']) echo ' selected="selected"';
                                        echo '>'.(100*(1+($i*0.1))).'%</option>';
                                    }
                            ?>
                            </select>
                            <br />*This represents the amount you want to allow your images to "upscale" (default: 120%)
                        </td>
                    </tr> 
                    <tr>
                        <td class="sgFieldLabel">Fallback URL Type</td>
                        <td class="sgField">
                            <select name="socialGallery_fallbackUrlOption" id="socialGallery_fallbackUrlOption">
                                <option value="1"<?php if ($sgConfig['fallbackUrlOption'] == "1") echo ' selected="selected"'; ?>>Image URL</option>
                                <option value="2"<?php if ($sgConfig['fallbackUrlOption'] == "2") echo ' selected="selected"'; ?>>Hash Index (#sg1 etc.)</option>
                                <option value="3"<?php if ($sgConfig['fallbackUrlOption'] == "3") echo ' selected="selected"'; ?>>Page URL</option>
                            </select>
                            <br />* All images added as WordPress attachments or those found via a <a href="admin.php?page=<?php echo $socialGallery_slugs['updateengine']; ?>">Full Scan</a> will make use of <a href="http://www.socialgalleryplugin.com#explanationhere">Social Gallery Pages</a>, this setting acts as a fallback for all other images.
                        </td>
                    </tr>  
                    <tr>
                    	<td class="sgFieldLabel sgFieldLabelCB">Share my options</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['shareWithDevs'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_shareWithDevs" id="socialGallery_shareWithDevs" value="1" <?php if ($sgConfig['shareWithDevs'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                            * This helps me improve Social Gallery for you in the future.
                        </td>
                    </tr>
                    <tr>
                    	<td class="sgFieldLabel sgFieldLabelCB">Enable On/Off per Post/Page</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['enablemeta'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_enablemeta" id="socialGallery_enablemeta" value="1" <?php if ($sgConfig['enablemeta'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                            * Enabling this option lets you turn Social Gallery On/Off at the post/page level
                        </td>
                    </tr>
          
                    
					<?php socialGallery_trhd('Social Gallery Pages:'); ?>
                      <tr>
                        <td class="sgFieldLabel sgFieldLabelCB">Use Social Gallery Pages</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['useSGPages'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_useSGPages" id="socialGallery_useSGPages" value="1" <?php if ($sgConfig['useSGPages'] == "1") echo ' checked="checked"'; ?> />
                            </div>   
                        </td>
                      </tr>      
                      <tr class="socialGalleryPagesHide"<?php if ($sgConfig['useSGPages'] != "1") echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel ">Social Gallery Page Width</td>
                        <td class="sgField">
                            <input type="text" name="socialGallery_sgPageWidth" id="socialGallery_sgPageWidth" value="<?php if (!empty($sgConfig['sgPageWidth'])) echo $sgConfig['sgPageWidth']; ?>" style="width:56px;" /> px
                            <br />* This should be your usual content page width.
                            <br />Minimum width: 480 px, leaving empty will auto size.
                        </td>
                      </tr>
                      <tr class="socialGalleryPagesHide"<?php if ($sgConfig['useSGPages'] != "1") echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel sgFieldLabelCB">Include WordPress Sidebar</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['sgPageSidebar'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_sgPageSidebar" id="socialGallery_sgPageSidebar" value="1" <?php if ($sgConfig['sgPageSidebar'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                        </td>
                      </tr>
                      <tr class="socialGalleryPagesHide"<?php if ($sgConfig['useSGPages'] != "1") echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel sgFieldLabelCB">Mark Social Gallery Pages NoIndex</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['sgPageNoIndex'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_sgPageNoIndex" id="socialGallery_sgPageNoIndex" value="1" <?php if ($sgConfig['sgPageNoIndex'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                            * Checking this will ask search engines not to index your Social Gallery Pages.
                        </td>
                      </tr>
                      <tr class="socialGalleryPagesHide"<?php if ($sgConfig['useSGPages'] != "1") echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel sgFieldLabelCB">Show Share Links</td>
                        <td class="sgField">
                            <div class="sgFieldCB<?php if ($sgConfig['sgPageShareDeck'] == "1") echo ' on'; ?>">
                                <span class="thumb"></span>
                                 <input type="checkbox" name="socialGallery_sgPageShareDeck" id="socialGallery_sgPageShareDeck" value="1" <?php if ($sgConfig['sgPageShareDeck'] == "1") echo ' checked="checked"'; ?> />
                            </div>    
                        </td>
                      </tr>
                      <tr class="socialGalleryPagesHide"<?php if ($sgConfig['useSGPages'] != "1") echo ' style="display:none"'; ?>>
                        <td class="sgFieldLabel">Show Comments</td>
                        <td class="sgField">
                            <select name="socialGallery_sgPageComments" id="socialGallery_sgPageComments">
                                <option value="1"<?php if ($sgConfig['sgPageComments'] == "1") echo ' selected="selected"'; ?>>Facebook Comments</option>
                                <!-- This can't work without disqus selected above, to be added post v2.0
                                <option value="2"<?php if ($sgConfig['sgPageComments'] == "2") echo ' selected="selected"'; ?>>Disqus Comments</option>
                                -->
                                <option value="0"<?php if ($sgConfig['sgPageComments'] == "0") echo ' selected="selected"'; ?>>No Comments</option>
                            </select>
                        </td>
                      </tr>  
           			</table>
                </div>
                <div id="socialGalleryPageStyle" class="socialGalleryPage<?php if ($tabToShow == "Style") echo ' socialGalleryPageActive'; ?>">
           			<h3>Style Settings</h3>
           
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">

                        <?php socialGallery_trhd('Social Gallery Theme:',0); ?>
                            <tr>
                            <td class="sgFieldLabel">Social Gallery Theme:</td>
                            <td class="sgField">
                                <select name="socialGallery_theme" id="socialGallery_theme">
                
                                    <option value="classic"<?php if ($sgConfig['theme'] == "classic") echo ' selected="selected"'; ?>>Classic</option>
                                    <option value="clean"<?php if ($sgConfig['theme'] == "clean") echo ' selected="selected"'; ?>>Clean</option>
                                    <option value="blue"<?php if ($sgConfig['theme'] == "blue") echo ' selected="selected"'; ?>>Blue</option>
                                    <option value="drawn"<?php if ($sgConfig['theme'] == "drawn") echo ' selected="selected"'; ?>>Hand Drawn</option>
                                </select>
                            </td>
                          </tr>
                            
                        <?php socialGallery_trhd('Margins and Navigation:'); ?>
                          <tr>
                            <td class="sgFieldLabel">Gallery Margin</td>
                            <td class="sgField">
                                <select name="socialGallery_marginBounds" id="socialGallery_marginBounds">
                                		<option value="0.05">5%</option>
                                <?php 
                                        for ($i = 1; $i <= 5; $i++){
                                            echo '<option value="'.($i*0.1).'"';
                                            if (($i*0.1) == $sgConfig['marginBounds']) echo ' selected="selected"';
                                            echo '>'.(100*($i*0.1)).'%</option>';
                                        }
                                ?>
                                </select>
                                *This represents the amount you margin around your images
                            </td>
                          </tr> 
                          <tr>
                            <td class="sgFieldLabel">Show Previous/Next Navigation</td>
                            <td class="sgField">
                                <div class="sgFieldCB<?php if ($sgConfig['backAndForth'] == "1") echo ' on'; ?>">
                                    <span class="thumb"></span>
                                     <input type="checkbox" name="socialGallery_backAndForth" id="socialGallery_backAndForth" value="1" <?php if ($sgConfig['backAndForth'] == "1") echo ' checked="checked"'; ?> />
                                </div>    
                            </td>
                          </tr>
                          </tr><tr><td class="sgFieldLabelHD" colspan="2">Social Header</td></tr>
                            
                          <tr>
                            <td class="sgFieldLabel">Show Social Header</td>
                            <td class="sgField">
                                <div class="sgFieldCB<?php if ($sgConfig['headerBox'] == "1") echo ' on'; ?>">
                                    <span class="thumb"></span>
                                    <input type="checkbox" name="socialGallery_headerBox" id="socialGallery_headerBox" value="1" <?php if ($sgConfig['headerBox'] == "1") echo ' checked="checked"'; ?> />
                                </div>
                            </td>
                          </tr>
                          <tr id="sgWhatHeader"<?php if ($sgConfig['headerBox'] != 1) echo ' style="display:none"'; ?>>
                            <td class="sgFieldLabel">Social Header Type</td>
                            <td class="sgField">
                                <select name="socialGallery_headerBoxType" id="socialGallery_headerBoxType">
                                    <option value="1"<?php if ($sgConfig['headerBoxType'] == "1") echo ' selected="selected"'; ?>>Site Img & Link</option>
                                    <option value="2"<?php if ($sgConfig['headerBoxType'] == "2") echo ' selected="selected"'; ?>>Site Link</option>
                                    <option value="3"<?php if ($sgConfig['headerBoxType'] == "3") echo ' selected="selected"'; ?>>Custom HTML</option>
                                </select>
                            </td>
                          </tr>
                          <tr id="sgpCustomHtml"<?php if ($sgConfig['headerBoxType'] != "3" || $sgConfig['headerBox'] != 1) echo ' style="display:none"'; ?>>
                            <td class="sgFieldLabel" valign="top">HTML to show as Side Header</td>
                            <td class="sgField">
                                <textarea name="socialGallery_headerBoxHTML" id="socialGallery_headerBoxHTML"><?php echo stripslashes(html_entity_decode($sgConfig['headerBoxHTML'])); ?></textarea>
                            </td>
                          </tr>            
                           <tr id="sgpCustomLogo"<?php if ($sgConfig['headerBoxType'] != "1" || $sgConfig['headerBox'] != 1) echo ' style="display:none"'; ?>>
                            <td class="sgFieldLabel" width="240">Social Header Image:</td>
                            <td class="sgField">
                                <input type="text" name="socialGallery_headerImg" id="socialGallery_headerImg" value="<?php echo $sgConfig['headerImg']; ?>" />
                                <input id="upload_image_button" type="button" value="Upload Image" />
                                <span>(50x50px)</span>
                            </td>
                          </tr>
                          </tr><tr><td class="sgFieldLabelHD" colspan="2">Show Image Title as Description</td></tr>
                                  <tr>
                                    <td class="sgFieldLabel">Show Image Title as Description</td>
                                    <td class="sgField">
                                        <div class="sgFieldCB<?php if ($sgConfig['incDesc'] == "1") echo ' on'; ?>">
                                            <span class="thumb"></span>
                                            <input type="checkbox" name="socialGallery_incDesc" id="socialGallery_incDesc" value="1" <?php if ($sgConfig['incDesc'] == "1") echo ' checked="checked"'; ?> />
                                        </div>
                                    </td>
                                  </tr> 
                          
                            <tr><td class="sgFieldLabelHD" colspan="2">Picture Bar</td></tr>
                            
                          <tr>
                            <td class="sgFieldLabel">Show Picture Bar</td>
                            <td class="sgField">
                                <div class="sgFieldCB<?php if ($sgConfig['bottomBar'] == "1") echo ' on'; ?>">
                                    <span class="thumb"></span>
                                     <input type="checkbox" name="socialGallery_bottomBar" id="socialGallery_bottomBar" value="1" <?php if ($sgConfig['bottomBar'] == "1") echo ' checked="checked"'; ?> />
                                </div>    
                            </td>
                          </tr>
                          <tr id="sgWhatPictureBar"<?php if ($sgConfig['bottomBar'] != 1) echo ' style="display:none"'; ?>>
                            <td class="sgFieldLabel">Picture Bar Title</td>
                            <td class="sgField">
                                <select name="socialGallery_bottomBarTitleSource" id="socialGallery_bottomBarTitleSource">
                                    <option value="1"<?php if ($sgConfig['bottomBarTitleSource'] == "1") echo ' selected="selected"'; ?>>Image Title</option>
                                    <option value="2"<?php if ($sgConfig['bottomBarTitleSource'] == "2") echo ' selected="selected"'; ?>>Page Title</option>
                                    <option value="3"<?php if ($sgConfig['bottomBarTitleSource'] == "3") echo ' selected="selected"'; ?>>Blog Title</option>
                                </select>
                            </td>
                          </tr>
                          <tr>
                            <td class="sgFieldLabel">Show Image Download Link</td>
                            <td class="sgField">
                                <div class="sgFieldCB<?php if ($sgConfig['incDLLink'] == "1") echo ' on'; ?>">
                                    <span class="thumb"></span>
                                    <input type="checkbox" name="socialGallery_incDLLink" id="socialGallery_incDLLink" value="1" <?php if ($sgConfig['incDLLink'] == "1") echo ' checked="checked"'; ?> />
                                </div>
                            </td>
                          </tr>
                            <tr class="imageDownloadLinkShow"<?php if ($sgConfig['incDLLink'] != "1") echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel sgFieldLabelCB">Use "Prompt Save As.."<br />for Download Links</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['useHeaderDownloads'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_useHeaderDownloads" id="socialGallery_useHeaderDownloads" value="1" <?php if ($sgConfig['useHeaderDownloads'] == "1") echo ' checked="checked"'; ?> />
                                    </div>    
                                </td>
                            </tr>
                          
                            <tr><td class="sgFieldLabelHD" colspan="2">Lightbox Background</td></tr>
                            
                           <tr>
                            <td class="sgFieldLabel" width="240">Lightbox Background Color:</td>
                            <td class="sgField">
                                #<input type="text" name="socialGallery_bgColor" id="socialGallery_bgColor" value="<?php echo $sgConfig['bgColor']; ?>" /> <span>(e.g. 000000)</span>
                            </td>
                          </tr>
                           <tr>
                            <td class="sgFieldLabel">Lightbox Background Opacity:</td>
                            <td class="sgField">
                                <input type="text" name="socialGallery_bgOpacity" id="socialGallery_bgOpacity" value="<?php echo $sgConfig['bgOpacity']; ?>" /> <span>(e.g. 0.8)</span>
                            </td>
                          </tr>
                          
                            <tr><td class="sgFieldLabelHD" colspan="2">CSS 3 Animation Effects</td></tr>
                          <tr>
                            <td class="sgFieldLabel">Gallery Effects (IN)</td>
                            <td class="sgField">
                                <select name="socialGallery_inEffect" id="socialGallery_inEffect">
                                    <option value="1">Standard Fade In</option>
                                <?php $effectsarray = array('flip' => 'Flip','flipInX' => 'Flip In Horizontal','flipOutX' => 'Flip Out Horizontal','flipInY' => 'Flip In Vertical','flipOutY' => 'Flip Out Vertical','fadeIn' => '','fadeInUp' => '','fadeInDown' => '','fadeInLeft' => '','fadeInRight' => '','fadeInUpBig' => '','fadeInDownBig' => '','fadeInLeftBig' => '','fadeInRightBig' => '','fadeOut' => '','fadeOutUp' => '','fadeOutDown' => '','fadeOutLeft' => '','fadeOutRight' => '','fadeOutUpBig' => '','fadeOutDownBig' => '','fadeOutLeftBig' => '','fadeOutRightBig' => '','bounceIn' => '','bounceInDown' => '','bounceInUp' => '','bounceInLeft' => '','bounceInRight' => '','bounceOut' => '','bounceOutDown' => '','bounceOutUp' => '','bounceOutLeft' => '','bounceOutRight' => '','rotateIn' => '','rotateInDownLeft' => '','rotateInDownRight' => '','rotateInUpLeft' => '','rotateInUpRight' => '','rotateOut' => '','rotateOutDownLeft' => '','rotateOutDownRight' => '','rotateOutUpLeft' => '','rotateOutUpRight' => '','lightSpeedIn' => '','lightSpeedOut' => '','hinge' => '','rollIn' => '','rollOut' => '');
                                        $i = 1; 
                                        foreach ($effectsarray as $effect => $effectN){
                                            if ($effect == 'flip')
                                                echo '<option disabled="disabled" value="-1">Flippers (currently Webkit, Firefox, & IE10 only):</option>';
                                            if ($effect == 'fadeIn')
                                                echo '<option disabled="disabled" value="-1">Fading In:</option>';
                                            if ($effect == 'fadeOut')
                                                echo '<option disabled="disabled" value="-1">Fading Out:</option>';
                                            if ($effect == 'bounceIn')
                                                echo '<option disabled="disabled" value="-1">Extra:</option>';
												
                                            if (!empty($effectN)) $effectName = $effectN; else $effectName = $effect;
                                            echo '<option value="'.$effect.'"';
                                            if ($effect == $sgConfig['inEffect']) echo ' selected="selected"';
                                            echo '>'.$effectName.'</option>';
                                        }
                                ?>
                                </select>
                            </td>
                          </tr>
                            
                           <tr>
                            <td class="sgFieldLabel" width="240">Opening Effect Duration:</td>
                            <td class="sgField">
                                <input type="text" name="socialGallery_inEffectTime" id="socialGallery_inEffectTime" value="<?php echo $sgConfig['inEffectTime']; ?>" /> milliseconds <span>(e.g. 1000 = 1 second)</span>
                            </td>
                          </tr>
                          <tr>
                            <td class="sgFieldLabel">Gallery Effects (OUT)</td>
                            <td class="sgField">
                                <select name="socialGallery_outEffect" id="socialGallery_outEffect">
                                    <option value="1">Standard Fade Out</option>
                                <?php 
                
                                        $i = 1; 
                                        foreach ($effectsarray as $effect => $effectN){
                                            if ($effect == 'flip')
                                                echo '<option disabled="disabled" value="-1">Flippers (currently Webkit, Firefox, & IE10 only):</option>';
                                            if ($effect == 'fadeIn')
                                                echo '<option disabled="disabled" value="-1">Fading In:</option>';
                                            if ($effect == 'fadeOut')
                                                echo '<option disabled="disabled" value="-1">Fading Out:</option>';
                                            if ($effect == 'bounceIn')
                                                echo '<option disabled="disabled" value="-1">OTHER:</option>';
                                            # other headers...
                                            
                                            if (!empty($effectN)) $effectName = $effectN; else $effectName = $effect;
                                            echo '<option value="'.$effect.'"';
                                            if ($effect == $sgConfig['outEffect']) echo ' selected="selected"';
                                            echo '>'.$effectName.'</option>';
                                        }
                                ?>
                                </select>
                            </td>
                          </tr>                              
                           <tr>
                            <td class="sgFieldLabel" width="240">Closing Effect Duration:</td>
                            <td class="sgField">
                                <input type="text" name="socialGallery_outEffectTime" id="socialGallery_outEffectTime" value="<?php echo $sgConfig['outEffectTime']; ?>" /> milliseconds <span>(e.g. 1000 = 1 second)</span>
                            </td>
                          </tr>

                          <tr><td class="sgFieldLabelHD" colspan="2">Custom CSS</td></tr>
                           <tr>
                            <td class="sgFieldLabel">Custom CSS:</td>
                            <td class="sgField">
                                <textarea name="socialGallery_customcss" id="socialGallery_customcss" style="width:300px;height:200px;"><?php echo $sgConfig['customcss']; ?></textarea><br />
                                <span>Any custom CSS you want to use to override Social Gallery's defaulr styles</span>
                            </td>
                          </tr>
                	</table>                    
                </div>
                <div id="socialGalleryPageSocial" class="socialGalleryPage<?php if ($tabToShow == "Social") echo ' socialGalleryPageActive'; ?>">
           			<h3>Social Settings</h3>
           
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
                    
                        <?php socialGallery_trhd('Tweet Via:',0); ?>
                              <tr>
                                <td class="sgFieldLabel">Tweet Via</td>
                                <td class="sgField">
                               		 @<input type="text" name="socialGallery_twvia" id="socialGallery_twvia" value="<?php echo $sgConfig['twvia']; ?>" /><br />
                                    <span>Note: Leaving blank will remove tweet via functionality</span>
                                </td>
                              </tr>  
                        
                        
                        <?php socialGallery_trhd('Social Overlay:',0); ?>
                        
                              <tr>
                                <td class="sgFieldLabel">Show Social Stats overlay on JiG</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['jigOverlay'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_jigOverlay" id="socialGallery_jigOverlay" value="1" <?php if ($sgConfig['jigOverlay'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr> 
                        
                        
                        <?php socialGallery_trhd('Share Buttons:',0); ?>
                                        
                              <tr>
                                <td class="sgFieldLabel">Show Tumblr Share button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['shareTumblr'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_shareTumblr" id="socialGallery_shareTumblr" value="1" <?php if ($sgConfig['shareTumblr'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>  
                              <tr>
                                <td class="sgFieldLabel">Show Linked In Share button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['shareLinkedIn'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_shareLinkedIn" id="socialGallery_shareLinkedIn" value="1" <?php if ($sgConfig['shareLinkedIn'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>  
                              <tr>
                                <td class="sgFieldLabel">Show Google Plus Share button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['shareGooglePlus'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_shareGooglePlus" id="socialGallery_shareGooglePlus" value="1" <?php if ($sgConfig['shareGooglePlus'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>      
                              <tr>
                                <td class="sgFieldLabel">Show Tweet button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incTwit'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_incTwit" id="socialGallery_incTwit" value="1" <?php if ($sgConfig['incTwit'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>
                              <tr>
                                <td class="sgFieldLabel">Show Pinterest button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incPin'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_incPin" id="socialGallery_incPin" value="1" <?php if ($sgConfig['incPin'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr> 
                              <tr>
                                <td class="sgFieldLabel">Show Stumble Upon button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['shareStumbleUpon'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_shareStumbleUpon" id="socialGallery_shareStumbleUpon" value="1" <?php if ($sgConfig['shareStumbleUpon'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr> 
                              <tr>
                                <td class="sgFieldLabel">Show Facebook Like button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incFB'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_incFB" id="socialGallery_incFB" value="1" <?php if ($sgConfig['incFB'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>             
                              <tr id="facebookFaces"<?php if ($sgConfig['incFB'] != 1) echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel">Show fan faces (below Facebook like button)</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incFBFaces'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_incFBFaces" id="socialGallery_incFBFaces" value="1" <?php if ($sgConfig['incFBFaces'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>
                              <tr>
                                <td class="sgFieldLabel">Show Facebook Share button</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['FBshare'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_FBshare" id="socialGallery_FBshare" value="1" <?php if ($sgConfig['FBshare'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>   
                                    
                              
                               <tr><td class="sgFieldLabelHD" colspan="2">Include Scripts</td></tr>
                              
                              <tr>
                                <td class="sgFieldLabel">Include Facebook Javascript *</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incFBSRC'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_incFBSRC" id="socialGallery_incFBSRC" value="1" <?php if ($sgConfig['incFBSRC'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>
                             <tr id="facebookAppID"<?php if ($sgConfig['incFBSRC'] != "1") echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel">Facebook App ID</td>
                                <td class="sgField">
                                    <input type="text" name="socialGallery_incFBAppID" id="socialGallery_incFBAppID" value="<?php echo $sgConfig['incFBAppID']; ?>" />
                                </td>
                              </tr>
                             <tr id="facebookAppIDInfo"<?php if ($sgConfig['incFBSRC'] != "1") echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel">&nbsp;</td>
                                <td class="sgField">
                                    By default Social Gallery uses its own Facebook App for dealing with likes & comments. It's highly recommended you add your own App ID: <a href="http://www.socialgalleryplugin.com/guide-facebook-app-id-for-use-with-social-gallery-for-fb-comments-likesend-buttons/" target="_blank">Read more on using your own Facebook App ID</a>
                                </td>
                              </tr>
                              <tr>
                                <td class="sgFieldLabel">Include Twitter Javascript *</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incTwitSRC'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_incTwitSRC" id="socialGallery_incTwitSRC" value="1" <?php if ($sgConfig['incTwitSRC'] == "1") echo ' checked="checked"'; ?> />
                                    </div>    
                                </td>
                              </tr>
                              <tr>
                                <td class="sgFieldLabel">Include Pinterest Javascript *</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incPinSRC'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_incPinSRC" id="socialGallery_incPinSRC" value="1" <?php if ($sgConfig['incPinSRC'] == "1") echo ' checked="checked"'; ?> />
                                    </div>    
                                </td>
                              </tr>
                              <tr>
                                <td></td>
                                <td><span>* If you know that you have included Facebook, Twitter or Pinterest javascript calls elsewhere on your blog (e.g. if you have working facebook like buttons already) you can disable the inclusion of the corresponding script here, this allows you to avoid calling them more than once.</span></td>
                              </tr>
                                        
                	</table>
                    
                </div>
                <div id="socialGalleryPageComments" class="socialGalleryPage<?php if ($tabToShow == "Comments") echo ' socialGalleryPageActive'; ?>">
           			<h3>Comment Settings</h3>
           
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
                    
                        <?php socialGallery_trhd('Comment Settings:',0); ?>
                    
                    
                              <tr>
                                <td class="sgFieldLabel">Show Facebook Comments</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incFBComments'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_incFBComments" id="socialGallery_incFBComments" value="1" <?php if ($sgConfig['incFBComments'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>
                              <tr>
                                <td class="sgFieldLabel">Show Disqus Comments</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['incDisqusComments'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                        <input type="checkbox" name="socialGallery_incDisqusComments" id="socialGallery_incDisqusComments" value="1" <?php if ($sgConfig['incDisqusComments'] == "1") echo ' checked="checked"'; ?> />
                                    </div>                
                                </td>
                              </tr>
                              <tr id="disqusDisclaim"<?php if ($sgConfig['incDisqusComments'] != "1") echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel">Disqus Note:</td>
                                <td class="sgField">
                                    Disqus comments may experience a comment "lag" - that is a comment posted my not appear for 10+ minutes after it's posted. This is a bug with Disqus and not Social Gallery. By ticking this box and using Disqus Comments with Social Gallery you accept and understand that this feature can lag and that this is not the fault of Social Gallery. Hopefully Disqus will fix this. <a href="http://www.socialgalleryplugin.com/social-gallery-with-disqus-comments-experimental/" target="_blank">Read more</a>.
                                </td>
                              </tr>
                              <tr id="disqusShort"<?php if ($sgConfig['incDisqusComments'] != "1" || $sgConfig['incDisqusComments'] != 1) echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel">Disqus Shortname</td>
                                <td class="sgField">
                                    <input type="text" name="socialGallery_disqusShortName" id="socialGallery_disqusShortName" value="<?php echo $sgConfig['disqusShortName']; ?>" /><br />
                                    <span>* To use Disqus comments you will need to register on <a href="http://www.disqus.com" target="_blank">Disqus.com</a> (if you haven't already.) During the registration process you pick a shortname, that goes here. <a href="http://www.socialgalleryplugin.com/guide-social-gallery-plugin-with-disqus-comments/" target="_blank">Read more about Social Gallery and Disqus</a></span>
                                </td>
                              </tr>
                    
                	</table>
                    
                </div>
                <div id="socialGalleryPageAdverts" class="socialGalleryPage<?php if ($tabToShow == "Adverts") echo ' socialGalleryPageActive'; ?>">
           			<h3>Advertisement Settings</h3>
           
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
                    
                        <?php socialGallery_trhd('Adsense (Requires Google DFP):',0); ?>
          
                              <tr>
                                <td class="sgFieldLabel">Use Adsense</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['useDFP'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_useDFP" id="socialGallery_useDFP" value="1" <?php if ($sgConfig['useDFP'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                              </tr>
                              <tr>
                                <td class="sgFieldLabel">&nbsp;</td>
                                <td class="sgField">* Note this will disable all comments</td>                              	
                              </tr>
                              <tr id="socialGallery_dfpHeadTR"<?php if ($sgConfig['useDFP'] != "1") echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel" valign="top">Tags Header</td>
                                <td class="sgField">
                                    <textarea name="socialGallery_dfpHead" id="socialGallery_dfpHead"><?php echo stripslashes(html_entity_decode($sgConfig['dfpHead'])); ?></textarea><br />
                                    * If you are including this yourself in your blog header, leave this blank
                                </td>
                              </tr>    
                              <tr id="socialGallery_dfpInlineTR"<?php if ($sgConfig['useDFP'] != "1") echo ' style="display:none"'; ?>>
                                <td class="sgFieldLabel" valign="top">Tags Ad Body</td>
                                <td class="sgField">
                                    <textarea name="socialGallery_dfpInline" id="socialGallery_dfpInline"><?php echo stripslashes(html_entity_decode($sgConfig['dfpInline'])); ?></textarea>
                                    * Ad code.
                                </td>
                              </tr>    
                	</table>
                    
                </div>
                
                
                
                <div id="socialGalleryPageDevices" class="socialGalleryPage<?php if ($tabToShow == "Devices") echo ' socialGalleryPageActive'; ?>">
           			<h3>Social Gallery Device Settings</h3>
           
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
                    
          				<?php socialGallery_trhd('Device Settings:',0); ?>
                        	<tr>
                                <td class="sgFieldLabel" style="width:300px">Show Social Gallery on Mobile Devices</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['mob'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_mob" id="socialGallery_mob" value="1" <?php if ($sgConfig['mob'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                            </tr>   
                        	<tr>
                                <td class="sgFieldLabel" style="width:300px">Show Social Gallery on Tablets</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['tablet'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_tablet" id="socialGallery_tablet" value="1" <?php if ($sgConfig['tablet'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                </td>
                            </tr>                              
                	</table>
                </div>
                
                
                <div id="socialGalleryPageAddons" class="socialGalleryPage<?php if ($tabToShow == "Addons") echo ' socialGalleryPageActive'; ?>">
           			<h3>Social Gallery Add-ons Settings</h3>
           
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
          				<?php socialGallery_trhd('Installed Add-ons:',0);
							?><tr>
                                <td class="sgFieldLabel">Social Gallery Mobile</td>
                                <td class="sgField" style="padding-top:12px;">
                                         <?php 
										 if (socialGallery_addonInstalled('mobile')) 
										 	echo '<span class="sgsuccess wrap sgM" style="width:140px;color:#000;padding:5px 18px">Installed [Beta]</span>'; 
										 else 
										 	echo '<span style="color:red">Not Installed</span> <span class="sgsuccess wrap sgM" style="width:140px;color:#000;padding:5px 18px"><a href="'.$socialGallery_urls['addons'].'" target="_blank">Get Add-on</a></span>'; ?>
                                </td>
                              </tr>
                              
                        <?php if (socialGallery_addonInstalled('mobile')) {
										socialGallery_trhd('Mobiles:',0); ?>
                        	<tr>
                                <td class="sgFieldLabel" style="width:300px">Enable Mobile Addon</td>
                                <td class="sgField">
                                    <div class="sgFieldCB<?php if ($sgConfig['addonMob'] == "1") echo ' on'; ?>">
                                        <span class="thumb"></span>
                                         <input type="checkbox" name="socialGallery_addonMob" id="socialGallery_addonMob" value="1" <?php if ($sgConfig['addonMob'] == "1") echo ' checked="checked"'; ?> />
                                    </div>
                                    <br />* will show for whatever is enabled/disabled in Device settings
                                </td>
                            </tr>                                          
                        <?php } ?>
                       
                       
                	</table>
                    
                </div>
                
                
                
                
                
                <div id="socialGalleryPageAdminTools" class="socialGalleryPage<?php if ($tabToShow == "AdminTools") echo ' socialGalleryPageActive'; ?>">
           			<h3>Social Gallery Admin Tools</h3>
                    
                    <?php $loadNormalAdminTools = true;
						#} Anything to do...?
						$remLib = false; if (isset($_GET['removelibrary'])) $remLib = true;
						$remScan = false; if (isset($_GET['removescanhistory'])) $remScan = true;
           
		   			if ($remLib){
						
						if (!isset($_GET['sure'])){
						
						#} Show are you sure?
						?><div style="text-align:center;width:600px;"><h3 style="text-align:center">Clear Image Library</h3>
						<h4 style="text-align:center">Are you sure you want to clear the image library?</h4>
						<button type="button" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['settings']; ?>#settings_AdminTools';">Cancel</button>&nbsp;&nbsp;&nbsp;<button type="button" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['settings']; ?>&removelibrary=1&sure=yes#settings_AdminTools';">Yes, Clear the Library</button><br /><br />
						<strong>Note</strong>: Clearing the Social Gallery library will remove all stored references to images that Social Gallery has found via Scanning. Emptying the library is not advisable unless you intend to re-scan or a member of Social Gallery Support has advised you to.</p></div>
						<?php $loadNormalAdminTools = false;
						} else {
							
							#} Delete all - pretty brutal?
							$wpdb->query("DELETE FROM ".$socialGallery_t['imagelinks']);
							$wpdb->query("DELETE FROM ".$socialGallery_t['images']);
							
							#} Show "deleted"
						?><div style="text-align:center;width:600px;"><h3 style="text-align:center">Image Library Cleared</h3>
						<p style="text-align:center;width:600px;">Your image library has been emptied :( <br /><button type="submit" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['settings']; ?>#settings_AdminTools';">Back to Admin Tools</button></p>				
						</div>
						<?php $loadNormalAdminTools = false;
						}
						
						
					}
		   			if ($remScan){
						
						if (!isset($_GET['sure'])){
						
						#} Show are you sure?
						?><div style="text-align:center;width:600px;"><h3 style="text-align:center">Clear Scan History</h3>
						<h4 style="text-align:center">Are you sure you want to clear the scan history?</h4>
						<button type="button" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['settings']; ?>#settings_AdminTools';">Cancel</button>&nbsp;&nbsp;&nbsp;<button type="button" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['settings']; ?>&removescanhistory=1&sure=yes#settings_AdminTools';">Yes, Clear Scan History</button><br /><br />
						<strong>Note</strong>: Clearing the Social Gallery Scanning History will remove all records of what posts &amp; pages Social Gallery has scanned. This is not advisable unless you intend to re-scan or a member of Social Gallery Support has advised you to.</p></div>
						<?php $loadNormalAdminTools = false;
						} else {
							
							#} Delete all - pretty brutal?
							$wpdb->query("DELETE FROM ".$socialGallery_t['postupdates']);
							$wpdb->query("DELETE FROM ".$socialGallery_t['otherupdates']);
							
							#} Show "deleted"
						?><div style="text-align:center;width:600px;"><h3 style="text-align:center">Image Library Cleared</h3>
						<p style="text-align:center;width:600px;">Social Gallery's scanning history has been emptied :( <br /><button type="submit" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['settings']; ?>#settings_AdminTools';">Back to Admin Tools</button>&nbsp;&nbsp;&nbsp;<button type="button" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['updateengine'].'&commencefull=1'; ?>';">Start a Full Scan</button></p>				
						</div>
						<?php $loadNormalAdminTools = false;
						}
						
						
					}
		   
		   			if ($loadNormalAdminTools){ ?>
                    <table width="715" border="0" cellpadding="0" cellspacing="0" class="sgpSettingsTable">
                    
          				<?php socialGallery_trhd('Admin Tools:',0);?>
                        
                        <tr>
                                <td class="sgField" style="padding-top:12px;" colspan="2"><h2 style="text-align:center">Disclaimer</h2><p style="text-align:center;width:440px;margin-left:auto;margin-right:auto;">
                                	<strong>Please note in using the tools on this tab is not recommended for every user.</strong><br />These tools are provided for users who understand fully the Social Gallery setup and who want to make large scale library changes.<br /><br />By using tools in this section of the settings you agree to accept all liability for the removal of your Social Gallery library data and all other outcomes.<br />If you have any questions please do ask in the forums.</p>
                                </td>
                        </tr>
                        <tr>
                                <td class="sgFieldLabel" style="width:300px"><strong>Clear Image Library:</strong></td>
                                <td class="sgField" style="padding-top:12px;">
                                	<button type="button" onclick="javascript:window.location='admin.php?page=<?php echo $socialGallery_slugs['settings'].'&removelibrary=1#settings_AdminTools'; ?>';">Clear Image Library</button><br />
                                    This removes all of the records of images stored in your Image Library.
                                </td>
                        </tr>
                        <tr>
                                <td class="sgFieldLabel" style="width:300px"><strong>Clear Scan History:</strong></td>
                          <td class="sgField" style="padding-top:12px;">
                                	<button type="button" onclick="javascript:window.location='admin.php?page=<?php echo $socialGallery_slugs['settings'].'&removescanhistory=1#settings_AdminTools'; ?>';">Clear Scan History</button><br />
                              This removes all of the records of scans. To continue to use <a href="http://www.socialgalleryplugin.com/social-gallery-pages/" target="_blank">Social Gallery Pages</a> after clearing scan history you will need to re-scan. </td>
                        </tr>
                	</table>
                    <?php } ?>
                </div>
                <?php if ($loadNormalAdminTools){ ?><div id="socialGallerySaveButton"><input type="submit" value="Save All Settings" class="bButton" /></div><?php } ?>
            </div>
        </div>
        </form>
        <script type="text/javascript">jQuery(document).ready(function(ex) {            	
				jQuery('#socialGalleryMenu div').unbind('click').click(function(e) {
						var page = jQuery(this).attr('id');
						jQuery(this).removeClass('socialGalleryPageActive');
						jQuery('.socialGalleryPageActive').removeClass('socialGalleryPageActive');
						jQuery('#socialGalleryPage' + page).addClass('socialGalleryPageActive').slideDown(400);
						jQuery('#' + page).addClass('socialGalleryPageActive');	
						jQuery('#loadTab').val(page);					
						window.location.hash = '#settings_' + page;
						e.preventDefault();				
            	});   				
				
				if (typeof window.location.hash != "undefined")
					jQuery('#' + window.location.hash.substr(10)).click();
									
            });</script><?php
		
}

#} Home page Catcher
function socialGallery_pages_home() {
	
	global $socialGalleryWizardPrompt, $wpdb, $socialGallery_urls, $socialGallery_version, $socialGallery_Settings;	#} Req
	
	if (!current_user_can('manage_options'))  {
		wp_die( __('You do not have sufficient permissions to access this page.') );
	}
    
	#} Check for Wizard Status
	socialGallery_checkWizardStatus();
    
	if ($socialGalleryWizardPrompt){
		
		socialGallery_pages_wizard();
		
	} else {
		
		#} Normal Load
		
		// socialGallery_pagecomponents_header();
		
		SGPv3header();
		?>
		<div class = "sgv3wrap">
		<?php
		#} Identify what's to do
		$toSave = false; if (isset($_GET['save'])) if ($_GET['save'] == "1") $toSave = true; 
	
		#} Continue usual...
		socialGallery_checkForUpgrade(); 
		# Check for this too
		if ($socialGallery_Settings->get('permasflushed') == 1) {
			socialGallery_html_msg(2,'Please note permalinks have been updated, please check all works?!?, too scary?');
			$socialGallery_Settings->delete('permasflushed');
		}

		 if ($toSave && !$toCrawl){
		 
				socialGallery_save_settings(); 
		 
		} else { 
		
				socialGallery_pages_home_html(); 
			
		}	
		
	?>
	</div>

	<?php 
	
	}
}


#} ROOT page
function socialGallery_pages_home_html(){
	global $wpdb, $socialGallery_db_version, $socialGallery_version, $socialGallery_t, $socialGallery_urls, $socialGallery_slugs, $socialGallery_Settings;	#} Req
	socialGallery_autoDisable();
    ?>
    <div class="postbox-container" id="main-container" style="width:75%;">
            <div class="postbox">
                <h3 style="text-align:center"><label><img src="<?php echo plugins_url('/i/thanks-for-using-social-gallery.png',__FILE__); ?>" alt="Thanks For Using Social Gallery" style="margin:8px" /></label></h3>
                <div class="inside">
                    <p style="text-align:center"><strong>Welcome to Social Gallery</strong>, the Ultimate Social Lightbox Plugin for WordPress. Social Gallery has lots of bells and whistles, you can dive right in below by changing a setting, running a full scan or just by seeing the images in your image library! Alternatively you can just go right ahead and enjoy all of the extra social interaction your blog will now have! If you want to vote on future features or find out more about Social Gallery, check out the <a href="<?php echo $socialGallery_urls['forum']; ?>" target="_blank">forums</a>!</p>
                    <div id="SocialGalleryOptions">
                        <div><a href="admin.php?page=<?php echo $socialGallery_slugs['settings']; ?>" class="SocialGalleryOB">Settings</a></div>
                        <div><a href="admin.php?page=<?php echo $socialGallery_slugs['updateengine']; ?>" class="SocialGalleryOB">Update Engine</a></div>
                        <div><a href="admin.php?page=<?php echo $socialGallery_slugs['imagelibrary']; ?>" class="SocialGalleryOB">Image Library</a></div>
                    </div>
                    <div style="clear:both"></div>
                </div>
            </div>
            <script src="https://app.convertkit.com/landing_pages/1620.js"></script>
            <div class="postbox">
                <h3 style="padding:8px;"><label><?php _e('Social Gallery News'); ?></label></h3>
                <div class="inside">
                	<?php socialGallery_pagecomponents_retrieveNews(); ?>
                </div>
            </div>  
   </div>
   <?php 
   
   
   	#} Check out
	$subscribed = false; $wizardObj = $socialGallery_Settings->get('wizardObject'); if (isset($wizardObj['subscribeflag'])) if ($wizardObj['subscribeflag'] == 1) $subscribed = true;
	$socGalAff = false; $ccUser = $socialGallery_Settings->get('affUser'); if (!empty($ccUser)) { $socGalAff = true; $socGalAffUrl = 'http://codecanyon.net/item/social-gallery-wordpress-photo-viewer-plugin/2665332?ref='.$ccUser; } 
   
   if (!$subscribed){ ?>
   <div class="postbox-container" id="side-container" style="width:24%;margin-left:1%">

   </div>
   <?php } ?>
   <?php if ($socGalAff){ ?>
   <div class="postbox-container" id="side-container" style="width:24%;margin-left:1%;">
            <div class="postbox">
                <h3 style="padding:8px;"><label><?php _e('Earn $$$ by sharing'); ?></label></h3>
                <div class="inside" style="text-align:center">
                	Share Social Gallery with your network, when they buy it you'll earn 30%!<br />
                    
                    <div class="socialGalleryShareBox">
                    <a href="http://www.facebook.com/sharer.php?s= 100&amp;p[title]=Social Gallery - The Ultimate WordPress Lightbox&amp;p[url]=<?php echo $socGalAffUrl; ?>&amp;p[summary]=Social Gallery adds Social Sharing to all of the images on your blog, making it easier for your blog visitors to share your content. A Must Have plugin for all WordPress users."target="_blank"><img src="<?php echo plugins_url('/i/fbshare.png',__FILE__); ?>" alt="" title="Share on Facebook to Earn" /></a>
			   
               <a href="http://twitter.com/home?status=I Recommend You Get Social Gallery for WordPress!! <?php echo $socGalAffUrl; ?>" target="_blank"><img src="<?php echo plugins_url('/i/tweet.png',__FILE__); ?>" alt="" title="Share this on Twitter to earn a Commision" /></a><br />
			   
		 <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo $socGalAffUrl; ?>&title=Social Gallery for WordPress&source=Social Gallery Pros" target="_blank"><img src="<?php echo plugins_url('/i/linkedin.png',__FILE__); ?>" alt="" title="Share this on LinkedIn" /></a>
			   
		 <a href="https://plus.google.com/share?url=<?php echo $socGalAffUrl; ?>" target="_blank"><img src="<?php echo plugins_url('/i/gp.png',__FILE__); ?>" alt="" title="Share this on Google+1" /></a>
        			</div>
                    All of these buttons are set up to share with your affiliate code (<?php echo $ccUser; ?>) - by sharing with these you'll earn 30%! <a href="http://codecanyon.net/make_money/affiliate_program" target="_blank">Read More</a>.
                </div>
            </div>
   </div>
   <?php } else { ?>
    <div class="postbox-container" id="side-container" style="width:24%;margin-left:1%">
            <div class="postbox">
                <h3 style="padding:8px;"><label><?php _e('Share the love'); ?></label></h3>
                <div class="inside">
                	<p>This plugin has been developed with love & effort, it's a work in progress and I really appreciate all of the contribution you guys make to it. Thank you!</p>
                    <a href="codecanyon.net/item/social-gallery-wordpress-photo-viewer-plugin/2665332?ref=stormgate" target="_blank">Rate it 5 stars on Code Canyon</a><br />
                    <a href="<?php echo $socialGallery_urls['forum']; ?>" target="_blank">Join the Forum</a><br />
                    <div  style="text-align:center;margin-top:12px"><strong>Share Social Gallery:</strong></div>
                    <div class="socialGalleryShareBox">
                    <a href="http://www.facebook.com/sharer.php?s= 100&amp;p[title]=Social Gallery - The Ultimate WordPress Lightbox&amp;p[url]=http://www.socialgalleryplugin.com&amp;p[summary]=Social Gallery adds Social Sharing to all of the images on your blog, making it easier for your blog visitors to share your content. A Must Have plugin for all WordPress users."target="_blank"><img src="<?php echo plugins_url('/i/fbshare.png',__FILE__); ?>" alt="" title="Share on Facebook to Earn" /></a>
			   
               <a href="http://twitter.com/home?status=I Recommend You Get Social Gallery for WordPress!! http://www.socialgalleryplugin.com" target="_blank"><img src="<?php echo plugins_url('/i/tweet.png',__FILE__); ?>" alt="" title="Share this on Twitter to earn a Commision" /></a>
			   
		 <a href="http://www.linkedin.com/shareArticle?mini=true&url=http://www.socialgalleryplugin.com&title=Social Gallery for WordPress&source=Social Gallery Pros" target="_blank"><img src="<?php echo plugins_url('/i/linkedin.png',__FILE__); ?>" alt="" title="Share this on LinkedIn" /></a>
			   
		 <a href="https://plus.google.com/share?url=http://www.socialgalleryplugin.com" target="_blank"><img src="<?php echo plugins_url('/i/gp.png',__FILE__); ?>" alt="" title="Share this on Google+1" /></a>
         			</div>
                </div>
            </div>
   </div>
   <?php }
   
   ?>    <div class="postbox-container" id="side-container" style="width:24%;margin-left:1%">
            <div class="postbox">
                <h3 style="padding:8px;"><label><?php _e('Compatible Themes & Plugins'); ?></label></h3>
                <div class="inside">
					<ul><?php
   $lastCompatCheck = $socialGallery_Settings->get('LastComCheck');
   if (!$lastCompatCheck || $lastCompatCheck < time()-172800) { #} 2 days
	   try { 
				$compatibleOthersCode = socialGallery_retrieve($socialGallery_urls['comCheck']);
				$compatibleOthers = json_decode($compatibleOthersCode);
				if (isset($compatibleOthers->lu)){
				
					if (isset($compatibleOthers->r)) 
						if (count($compatibleOthers->r) > 0)
							foreach ($compatibleOthers->r as $id => $r){
								
								?><li>
                                        <a href='<?php echo $r->u; ?>' target = '_blank' title='<?php echo $r->n; ?>'><?php echo $r->n; ?></a><br/>
                                        <?php echo  $r->d ; ?>
                   				</li><?php
																
							}
						else 
							echo '<li>None Today</li>';
					
					#} Store.
					$socialGallery_Settings->update('CompatibleOthers',$compatibleOthers);
					
				}
				
				#} Update
				$socialGallery_Settings->update('LastComCheck',time());
				
	   } catch (Exception $e){
			# Do Nothing.   
	   }
	} else {
			
   		$compatibleOthers = $socialGallery_Settings->get('CompatibleOthers');
		if (isset($compatibleOthers->r)) 
				if (count($compatibleOthers->r) > 0)
					foreach ($compatibleOthers->r as $id => $r){
						
						?><li>
								<a href='<?php echo $r->u; ?>' target = '_blank' title='<?php echo $r->n; ?>'><?php echo $r->n; ?></a><br/>
								<?php echo  $r->d ; ?>
						</li><?php
														
					}
				else 
					echo '<li>None Today</li>';	
		
	} ?>
   					</ul>
                </div>
            </div>
	   </div>
   <?php
}

#} Would be lovely to do this via ajax but plugins don't allow it so have to iframe hack it.
function socialGallery_pages_updateEngine(){
	
	global $socialGalleryWizardPrompt,$wpdb,$socialGallery_t,$socialGallery_slugs,$socialGallery_urls, $socialGallery_Settings;

    
	# Check for Wizard Status
	socialGallery_checkWizardStatus();
    
	if ($socialGalleryWizardPrompt){
		
		socialGallery_pages_wizard();
		
	} else {
		
		# Normal Load
		
		// socialGallery_pagecomponents_header();
		SGPv3header();

		
		$lastUpdateStarted = $socialGallery_Settings->get('lastLibraryUpdateS');
		$lastUpdateFinished = $socialGallery_Settings->get('lastLibraryUpdateF');
		
		$lastUpdateStarted2 = $socialGallery_Settings->get('lastLibraryUpdateSF');
		$lastUpdateFinished2 = $socialGallery_Settings->get('lastLibraryUpdateFF');
		
		# Just overwrite for now
		if ($lastUpdateStarted2 > $lastUpdateStarted) $lastUpdateStarted = $lastUpdateStarted2;
		if ($lastUpdateFinished2 > $lastUpdateFinished) $lastUpdateFinished = $lastUpdateFinished2;
		
		if ($lastUpdateStarted > 0) $lastUpdateStartedStr = date('F jS g:i a',$lastUpdateStarted); else $lastUpdateStartedStr = '';
		if ($lastUpdateFinished > 0) $lastUpdateFinishedStr = date('F jS g:i a',$lastUpdateFinished); else $lastUpdateFinishedStr = '';
	
		?>
		<h2>Social Gallery Library: Update Engine</h2>
		<p style="width:700px" class = 'sgPara'>From this page you can manage maintenance tasks for the Social Gallery library. Using Social Gallery's unique <strong>Update Engine</strong> you can build and maintain a strong index of all of the images within your posts and pages, even if they are external images. By maintaining a proper index (library) of your images Social Gallery can do all sorts of fancy things.</p>
		
		<noscript><div class="sgwarn wrap sgM"><strong>PLEASE NOTE!</strong> You will NEED javascript to run this page, please enable this in your browser settings!</div></noscript>
        
            <p style="width:700px" class = 'sgPara'><strong>Below you can start a library update.</strong><br />The more posts you have the longer this will take, but don't worry - you can leave this running in your browser or come back later and this will resume from where it left off! You should only need to update the library once, when you first install Social Gallery. After that Social Gallery will automatically maintain the library for you!</p>
            
<div id="wTabbed">
	<div id="wTabBar">
    	<div class="wTabChoice" data-tabchoice="0">Image Library</div>
        <div data-tabchoice="1">Addon: Social Statistics</div>
    </div>
    <div class="wTabpage wTabActive">
            <div class="sgwizardHd" style="margin-bottom:14px">Image Library Updater</div>
            <table border="0" style="width:500px;">
                <tr>
                    <td>Last Update:</td><td id="lastUpdated"><?php 
                    
                        if (empty($lastUpdateFinishedStr) && empty($lastUpdateStartedStr)) echo 'Not yet updated';
                        if (!empty($lastUpdateFinishedStr)) echo 'Completed '.$lastUpdateFinishedStr;
                        if (empty($lastUpdateFinishedStr) && !empty($lastUpdateStartedStr)) echo 'Started '.$lastUpdateStartedStr.' (not complete)';			
                    
                    ?></td>
                </tr>
                <tr>
                    <td>Library Size:</td><td id="imageLib"><?php 
                    
                        $existingCount = socialGallery_getLibraryCount();
                        echo socialGallery_prettifyLongInts($existingCount);
                    
                    ?> images</td>
                </tr>
                <!--
                <tr>
                    <td>Unprocessed Posts & Pages (Quick Scan):</td><td id="unProcessed"><?php 
                    
                            $postsAndPagesLeft = socialGallery_retrieveToUpdateCounts();
                            $unprocessedTotal = (int)$postsAndPagesLeft[0] + (int)$postsAndPagesLeft[1];
                            #} Make str
                            $str = socialGallery_prettifyLongInts($postsAndPagesLeft[0]).' posts, '
                                .  socialGallery_prettifyLongInts($postsAndPagesLeft[1]).' pages left to process.';
                            if ($unprocessedTotal > 0) echo '<span style="color:red">';
                            if ($unprocessedTotal == 0) echo '<span style="color:green">';
							echo $str.'</span>';
                    
                    ?></td>
                </tr>
                -->
                <tr>
                    <td>Unprocessed Posts & Pages:</td><td id="unProcessed2"><?php 
                    
                            $postsAndPagesLeft2 = socialGallery_retrieveToUpdateCountsFull();
                            $unprocessedTotal2 = (int)$postsAndPagesLeft2[0] + (int)$postsAndPagesLeft2[1];
                            #} Make str
                            $str = socialGallery_prettifyLongInts($postsAndPagesLeft2[0]).' posts, '
                                .  socialGallery_prettifyLongInts($postsAndPagesLeft2[1]).' pages left to process.';
                            if ($unprocessedTotal2 > 0) echo '<span style="color:red">';
                            if ($unprocessedTotal2 == 0) echo '<span style="color:green">';
							echo $str.'</span>';
                    		
							$unprocessedTotals = $unprocessedTotal + $unprocessedTotal2;
                    ?></td>
                </tr>
                <tr>
                    <td colspan="2">
                    <?php if ($unprocessedTotals > 0){ 
                    
                    # Identify if resume or fresh.
                    if ($unprocessedTotal > 0){
						
						#------------ QUICK
							
							# Calc perc
							$count_posts = wp_count_posts();
							$published_posts = $count_posts->publish;
							
							$published_posts = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type <> 'nav_menu_item' AND post_type <> 'page' AND post_status = 'publish'");
							
							$count_pages = wp_count_posts('page');
							$published_pages = $count_pages->publish;
							$totalPosts = (int)$published_pages + (int)$published_posts;
							$totalTodo = (int)$postsAndPagesLeft[0] + (int)$postsAndPagesLeft[1];
							$totalDonePosts = $totalPosts - $totalTodo;
							if ($totalPosts > 0 && $totalDonePosts > 0) $p = ($totalDonePosts/$totalPosts)*100; else $p = 0;
							
				
							if ($totalDonePosts > 0) {
									$terminology = 'Resume'; 
									$str2 = 'Processed '.$totalDonePosts.' of '.$totalPosts . '<br/>Scanning: ' . $lastscan;
							} else {
									$terminology = 'Start';
									$str2 = '';
							}
							
						
						?>
						<!--
						<div align="center" style="text-align:center" id="processUpdate"><button id="startUB" class="bButton"><?php echo $terminology; ?> Quick Scan</button></div>
						<div id="ubProgress" style="width:480px;margin-left:auto;margin-right:auto;<?php if ($p == 0) echo 'display:none'; ?>">
						
							<div id="progressText" style="text-align:center;margin:10px;padding:10px"><?php echo $str2; ?></div>
							<div class="meter orange" id="progressBar">
								<span style="width: <?php echo $p; ?>%" id="progMe"><span></span></span>
							</div>
						
						</div>
						<iframe src="admin.php?page=<?php echo $socialGallery_slugs['updateengine']; ?>&sgSilentCrawl=true&sgGo=false" id="crawler" style="width:600px;height:400px;display:none;"></iframe>
						-->
						<?php 
						
					
					}
                    if ($unprocessedTotal2 > 0){
						
						#------------ FULL
							
							# Calc perc
							$count_posts = wp_count_posts();
							$published_posts = $count_posts->publish;
							$count_pages = wp_count_posts('page');
							$published_pages = $count_pages->publish;
							$totalPosts = (int)$published_pages + (int)$published_posts;
							$totalTodo = (int)$postsAndPagesLeft2[0] + (int)$postsAndPagesLeft2[1];
							$totalDonePosts = $totalPosts - $totalTodo;
							$lastscan = get_user_meta(1,'sgplast',true);
							if ($totalPosts > 0 && $totalDonePosts > 0) $p = ($totalDonePosts/$totalPosts)*100; else $p = 0;
							
				
							if ($totalDonePosts > 0) {
									$terminology = 'Resume'; 
									$str2 = 'Processed '.$totalDonePosts.' of '.$totalPosts . '<br/>Scanning: ' . $lastscan;
							} else {
									$terminology = 'Start';
									$str2 = '';
							}
							
						
						?>
						<div align="center" style="text-align:center" id="processUpdate"><button id="startUBFull" class="bButton"><?php echo $terminology; ?> Scan</button></div>
						<div id="ubProgress" style="width:480px;margin-left:auto;margin-right:auto;<?php if ($p == 0) echo 'display:none'; ?>">
						
							<div id="progressText" style="text-align:center;margin:10px;padding:10px"><?php echo $str2; ?><br/>								
							</div>
							<div class="meter orange" id="progressBar">
								<span style="width: <?php echo $p; ?>%" id="progMe"><span></span></span>
							</div>
						
						</div>
						<iframe src="admin.php?page=<?php echo $socialGallery_slugs['updateengine']; ?>&sgSilentCrawl=true&sgGo=false&sgFull=true" id="crawlerFull" style="width:600px;height:400px;display:none;"></iframe>
						<?php 
					}			
					} else { ?>
                    <div class="sgsuccess wrap sgM" style="width:382px">Everything seems to be up to date :)</div>
                    <?php } ?>
                    </td>
                </tr>
            </table>
    </div>
    <div class="wTabpage">
            		<!-- Social Stats upgrade slot -->
                    <?php  if (!function_exists('socialGalleryAddon_SS_pagecomponents_updateEnginePage')){ ?>
            		<div class="sgwizardHd" style="margin-bottom:14px">Coming Soon: Next Level Stats</div>
                <div style="width:460px;margin-left:20px;margin-right:20px;" id="socialGalleryBL">
                    <p>Social Statistics is a future module of Social Gallery, it will provide:</p>
                    <ul style="margin-left:40px;color:#000;">
                    	<li>Like, Tweet, Pin &amp; Share counts for your images</li>
                        <li>Comment counts for your images</li>
                        <li>"Most popular" (in likes) functionalities</li>
                        <li>Comment Moderation Queues</li>
                    </ul>
                    <p>This is a beta/experimental upgrade and is <a href="<?php echo $socialGallery_urls['addons']; ?>" target="_blank">available here</a>.</p>
                    <p style="text-align:center;" class="sgpWL"><a href="<?php echo $socialGallery_urls['addons']; ?>" target="_blank" class="sgplBtn sgplBtn-primary">Get "Social Stats" Addon</a></p>
                    <?php } else socialGalleryAddon_SS_pagecomponents_updateEnginePage(); ?>
                </div>                
    
</div>


<script type="text/javascript">
	jQuery('#wTabbed #wTabBar div').click(function(e){
			//indexc
			var i = jQuery(this).attr('data-tabchoice'); if (typeof i == "undefined" || i == "") i = 0;
			jQuery('#wTabbed #wTabBar div').removeClass('wTabChoice');
			jQuery('#wTabbed .wTabpage').removeClass('wTabActive');
			jQuery(jQuery('#wTabbed #wTabBar div').get(i)).addClass('wTabChoice');
			jQuery(jQuery('#wTabbed .wTabpage').get(i)).addClass('wTabActive');	
	});
	
	<?php if (isset($_GET['commencefull'])) { ?>
	jQuery(document).ready(function(e) {
        jQuery('#startUBFull').click();
    });
	<?php } ?>

</script>
		<?php
	}
}
#=======================================================================================================================
function sg________PAGECOMPONENTS(){}					# Page Components
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#} Global page header
function socialGallery_pagecomponents_header(){

	
	global $wpdb, $socialGallery_urls, $socialGallery_version, $socialGallery_Settings,$socialGallery_slugs;	#} Req
	
	if (!current_user_can('manage_options'))  {
		wp_die( __('You do not have sufficient permissions to access this page.') );
	}
	
    
?>
<div id="sgpBody">
    <div class="wrap"> 
	    <h2 id="socialGalleryLogo" style="background:url(<?php echo plugins_url('/i/social-gallery.png',__FILE__); ?>)"><span style="display:none">Social Gallery Plugin</span></h2> 
    	<div id="sgpSocial">
            <a href="http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fwww.socialgalleryplugin.com&media=http%3A%2F%2Fwww.socialgalleryplugin.com%2FsocialGallery.png&description=I%20use%20the%20Social%20Gallery%20Plugin%20for%20Wordpress%2C%20its%20awesome!%20http%3A%2F%2Fwww.socialgalleryplugin.com" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a>
            <a href="https://twitter.com/share" class="twitter-share-button" data-via="SocialGalleryWP" data-url="http://codecanyon.net/item/social-gallery-wordpress-photo-viewer-plugin/2665332">Tweet</a>
            <div class="fb-like" data-href="http://codecanyon.net/item/social-gallery-wordpress-photo-viewer-plugin/2665332" data-send="true" data-width="400" data-show-faces="false"></div>
        </div>
    </div>
    <div id="sgpHeader">
		<a href="<?php echo $socialGallery_urls['home']; ?>" title="Social Gallery Plugin Homepage" target="_blank">Social Gallery Plugin.com</a> | 
		<a href="<?php echo $socialGallery_urls['forum']; ?>" title="Social Gallery Plugin Forum" target="_blank">Forum</a> | 
		<a href="<?php echo $socialGallery_urls['faq']; ?>" title="Frequently Asked Questions" target="_blank">FAQ</a> | 
		<a href="<?php echo $socialGallery_urls['docs']; ?>" title="View Documentation" target="_blank">Documentation</a> | 
		<a href="<?php echo $socialGallery_urls['subscribe']; ?>" title="Join the Updates Newsletter List" target="_blank">Join Update List</a> | Version <?php echo $socialGallery_version; ?>
    </div>
    <?php 	
	
	
	#} Deal with any hide msgs
	global $socialGalleryMessagehidden;
	if ($socialGalleryMessagehidden)			
		socialGallery_html_msg(0,'Message hidden');
		
	#} Check for crawl required flag.
	$crawlRequiredFlag = $socialGallery_Settings->get('crawlRequiredFlag');
	if ($crawlRequiredFlag == 1)
		socialGallery_html_msg(1,'You have recently enabled Social Gallery Pages, for this feature to be fully enabled please <a href="admin.php?page='.$socialGallery_slugs['updateengine'].'&commencefull=1">Run a Scan Now</a>');
		
	
	
}
#} Global mini page header
function socialGallery_pagecomponents_miniheader(){

	
	global $wpdb, $socialGallery_urls, $socialGallery_version, $socialGallery_Settings;	#} Req
	
	if (!current_user_can('manage_options'))  {
		wp_die( __('You do not have sufficient permissions to access this page.') );
	}
	
    
?>
<div id="sgpBody">
    <div class="wrap"> 
	    <h2 id="socialGalleryLogo" style="background:url(<?php echo plugins_url('/i/social-gallery.png',__FILE__); ?>)"><span style="display:none">Social Gallery Plugin</span></h2> 
    	<div id="sgpSocial">
            <a href="http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fwww.socialgalleryplugin.com&media=http%3A%2F%2Fwww.socialgalleryplugin.com%2FsocialGallery.png&description=I%20use%20the%20Social%20Gallery%20Plugin%20for%20Wordpress%2C%20its%20awesome!%20http%3A%2F%2Fwww.socialgalleryplugin.com" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a>
            <a href="https://twitter.com/share" class="twitter-share-button" data-via="SocialGalleryWP" data-url="http://codecanyon.net/item/social-gallery-wordpress-photo-viewer-plugin/2665332">Tweet</a>
            <div class="fb-like" data-href="http://codecanyon.net/item/social-gallery-wordpress-photo-viewer-plugin/2665332" data-send="true" data-width="400" data-show-faces="false"></div>
        </div>
    </div>
    <?php 	
	
	
	#} Deal with any hide msgs
	global $socialGalleryMessagehidden;
	if ($socialGalleryMessagehidden)			
		socialGallery_html_msg(0,'Message hidden');
		
	#} Check for crawl required flag.
	$crawlRequiredFlag = $socialGallery_Settings->get('crawlRequiredFlag');
	if ($crawlRequiredFlag == 1)
		socialGallery_html_msg(1,'You have recently enabled Social Gallery Pages, for this feature to be fully enabled please <a href="admin.php?page='.$socialGallery_slugs['updateengine'].'&commencefull=1">Run a Scan Now</a>');
		
	
	
}

#} Social Gallery Template - Custom page headers
function socialGallery_pagecomponents_customHeaders() {
	
	global $socialGalleryImage,$wp,$sgtitleOverride, $socialGallery_Settings;
	
		$blogName = get_bloginfo('name');
	
	$sgConfig['incFBAppID'] = $socialGallery_Settings->get('incFBAppID');	
    echo '<meta property="fb:app_id" content="'. $sgConfig['incFBAppID'] .'" />';
	$sgConfig['FBAdmins'] = $socialGallery_Settings->get('FBAdmins');				#Default: ''
	echo '<meta property="og:title" content="'.$sgtitleOverride.'" />'."\r\n";
	if (!empty($socialGalleryImage->sg_idesc)) echo '<meta property="og:description" content="'.$socialGalleryImage->sg_idesc.'"/>'."\r\n";
	echo '<meta property="og:url" content="'.socialGallery_permalinkedUrl($socialGalleryImage->sg_iperma,$socialGalleryImage->sg_iurl).'"/>
<meta property="og:image" content="'.$socialGalleryImage->sg_iurl.'"/>
<meta property="og:type" content="article"/>
<meta property="og:site_name" content="'.$blogName.'"/>'."\r\n";
	$sgConfig['sgPageNoIndex'] = $socialGallery_Settings->get('sgPageNoIndex');				#Default: 0
	if ($sgConfig['sgPageNoIndex']) echo '<meta name="ROBOTS" content="NOINDEX, NOFOLLOW" />'."\r\n";


	#}twitter cards

	echo '<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:site" content="@spinranker">
<meta name="twitter:creator" content="@spinranker">
<meta name="twitter:title" content="SPINRANKER - '.$sgtitleOverride.'">
<meta name="twitter:description" content="'.$socialGalleryImage->sg_idesc.'">
<meta name="twitter:image" content="'.$socialGalleryImage->sg_iurl.'">'."\r\n";


}

#} Social Gallery Template - Custom page title
function socialGallery_pagecomponents_customTitle($title, $sep, $seplocation){
	
	global $sgtitleOverride;
	$returnTitle = '';
	if (empty($sep)) $seperator = '&#124;'; else $seperator = $sep;
	if (!empty($sgtitleOverride)) $returnTitle = $sgtitleOverride.' '.$seperator.' '; 
	if (!empty($title) && !empty($returnTitle)) $returnTitle = $returnTitle  . $title;
	if (empty($returnTitle)) $returnTitle = $title;
	$returnTitle = str_replace('  ',' ',$returnTitle);
	$rep = array($seperator.' '.'&#124;',$seperator.' '.$seperator);
	$returnTitle = str_replace($rep,$seperator,$returnTitle);
	return $returnTitle;
	
}

#} Retrieves updated news.
function socialGallery_pagecomponents_retrieveNews(){

				global $socialGallery_urls;
                include_once(ABSPATH . WPINC . '/feed.php');
                add_filter( 'wp_feed_cache_transient_lifetime' , 'socialGallery_feedCache' );
                $rss = fetch_feed($socialGallery_urls['newsFeed']);
                remove_filter( 'wp_feed_cache_transient_lifetime' , 'socialGallery_feedCache' );
                
                if (!is_wp_error( $rss ) ) {
					
					$maxitems = $rss->get_item_quantity(5); 
                    $rss_items = $rss->get_items(0, $maxitems); 
					
				} ?>
                
                <ul>
                    <?php 
					if ($maxitems == 0) 
						echo '<li>No News (is this good news?)</li>';
                    else 
						foreach ( $rss_items as $item ) : ?>
                    <li>
                        <a href='<?php echo esc_url( $item->get_permalink() ); ?>' target = '_blank'
                        title='<?php echo 'Posted '.$item->get_date('j F Y | g:i a'); ?>'>
                        <?php echo  $item->get_title() ; ?></a><br/>
                        <?php echo  $item->get_description() ; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                
                <?php
	
}


#} Retrieves email sub
function socialGallery_pagecomponents_subForm(){

?>
<div id="socialGallerySubscribe">
<style type="text/css">
#af-form-1780578012 .af-body .af-textWrap{width:98%;display:block;float:none;}
#af-form-1780578012 .af-body .privacyPolicy{color:#000000;font-size:11px;font-family:Trebuchet MS, sans-serif;}
#af-form-1780578012 .af-body a{color:#758751;text-decoration:underline;font-style:normal;font-weight:normal;}
#af-form-1780578012 .af-body input.text, #af-form-1780578012 .af-body textarea{background-color:#FFFFFF;border-color:#919191;border-width:1px;border-style:solid;color:#000000;text-decoration:none;font-style:normal;font-weight:normal;font-size:12px;font-family:Trebuchet MS, sans-serif;}
#af-form-1780578012 .af-body input.text:focus, #af-form-1780578012 .af-body textarea:focus{background-color:#FFFAD6;border-color:#000000;border-width:1px;border-style:solid;}
#af-form-1780578012 .af-body label.previewLabel{display:block;float:none;text-align:left;width:auto;color:#000000;text-decoration:none;font-style:normal;font-weight:normal;font-size:14px;font-family:Trebuchet MS, sans-serif;}
#af-form-1780578012 .af-body{padding-bottom:15px;padding-top:15px;background-repeat:no-repeat;background-position:inherit;background-image:none;color:#000000;font-size:11px;font-family:Trebuchet MS, sans-serif;}
#af-form-1780578012 .af-header{padding-bottom:1px;padding-top:1px;padding-right:10px;padding-left:60px;background-color:#0B98D0;background-repeat:no-repeat;background-position:inherit;background-image:url("http://forms.aweber.com/images/forms/mail-icon/green/header.png");border-width:1px;border-bottom-style:none;border-left-style:none;border-right-style:none;border-top-style:none;color:#FFFFFF;font-size:14px;font-family:Trebuchet MS, sans-serif;}
#af-form-1780578012 .af-quirksMode .bodyText{padding-top:2px;padding-bottom:2px;}
#af-form-1780578012 .af-quirksMode{padding-right:10px;padding-left:10px;}
#af-form-1780578012 .af-standards .af-element{padding-right:10px;padding-left:10px;}
#af-form-1780578012 .bodyText p{margin:1em 0;}
#af-form-1780578012 .buttonContainer input.submit{background-color:#1b5489;background-image:url("http://forms.aweber.com/images/forms/mail-icon/green/button.png");color:#FFFFFF;text-decoration:none;font-style:normal;font-weight:normal;font-size:14px;font-family:Verdana, sans-serif;}
#af-form-1780578012 .buttonContainer input.submit{width:auto;}
#af-form-1780578012 .buttonContainer{text-align:right;}
#af-form-1780578012 body,#af-form-1780578012 dl,#af-form-1780578012 dt,#af-form-1780578012 dd,#af-form-1780578012 h1,#af-form-1780578012 h2,#af-form-1780578012 h3,#af-form-1780578012 h4,#af-form-1780578012 h5,#af-form-1780578012 h6,#af-form-1780578012 pre,#af-form-1780578012 code,#af-form-1780578012 fieldset,#af-form-1780578012 legend,#af-form-1780578012 blockquote,#af-form-1780578012 th,#af-form-1780578012 td{float:none;color:inherit;position:static;margin:0;padding:0;}
#af-form-1780578012 button,#af-form-1780578012 input,#af-form-1780578012 submit,#af-form-1780578012 textarea,#af-form-1780578012 select,#af-form-1780578012 label,#af-form-1780578012 optgroup,#af-form-1780578012 option{float:none;position:static;margin:0;}
#af-form-1780578012 div{margin:0;}
#af-form-1780578012 fieldset{border:0;}
#af-form-1780578012 form,#af-form-1780578012 textarea,.af-form-wrapper,.af-form-close-button,#af-form-1780578012 img{float:none;color:inherit;position:static;background-color:none;border:none;margin:0;padding:0;}
#af-form-1780578012 input,#af-form-1780578012 button,#af-form-1780578012 textarea,#af-form-1780578012 select{font-size:100%;}
#af-form-1780578012 p{color:inherit;}
#af-form-1780578012 select,#af-form-1780578012 label,#af-form-1780578012 optgroup,#af-form-1780578012 option{padding:0;}
#af-form-1780578012 table{border-collapse:collapse;border-spacing:0;}
#af-form-1780578012 ul,#af-form-1780578012 ol{list-style-image:none;list-style-position:outside;list-style-type:disc;padding-left:40px;}
#af-form-1780578012,#af-form-1780578012 .quirksMode{width:210px;}
#af-form-1780578012.af-quirksMode{overflow-x:hidden;}
#af-form-1780578012{background-color:#FFFFFF;border-color:#1B5489;border-width:1px;border-style:solid;}
#af-form-1780578012{display:block;}
#af-form-1780578012{overflow:hidden;}
.af-body .af-textWrap{text-align:left;}
.af-body input.image{border:none!important;}
.af-body input.submit,.af-body input.image,.af-form .af-element input.button{float:none!important;}
.af-body input.text{width:100%;float:none;padding:2px!important;}
.af-body.af-standards input.submit{padding:4px 12px;}
.af-clear{clear:both;}
.af-element label{text-align:left;display:block;float:left;}
.af-element{padding:5px 0;}
.af-form-wrapper{text-indent:0;}
.af-form{text-align:left;margin:auto;}
.af-header{margin-bottom:0;margin-top:0;padding:10px;}
.af-quirksMode .af-element{padding-left:0!important;padding-right:0!important;}
.lbl-right .af-element label{text-align:right;}
body {
}
</style>
<form method="post" class="af-form-wrapper" action="http://www.aweber.com/scripts/addlead.pl"  >
<div style="display: none;">
<input type="hidden" name="meta_web_form_id" value="1780578012" />
<input type="hidden" name="meta_split_id" value="" />
<input type="hidden" name="listname" value="socialgallery" />
<input type="hidden" name="redirect" value="http://www.aweber.com/thankyou-coi.htm?m=text" id="redirect_a277f96d29c5d9922124a3e9286b2d3e" />

<input type="hidden" name="meta_adtracking" value="Social_Gallery_In_Plugin" />
<input type="hidden" name="meta_message" value="1" />
<input type="hidden" name="meta_required" value="name,email" />

<input type="hidden" name="meta_tooltip" value="" />
</div>
<div id="af-form-1780578012" class="af-form"><div id="af-header-1780578012" class="af-header"><div class="bodyText"><p>&nbsp;Get Update Emails..</p></div></div>
<div id="af-body-1780578012"  class="af-body af-standards">
<div class="af-element">
<label class="previewLabel" for="awf_field-43145771">Your Name: </label>
<div class="af-textWrap">
<input id="awf_field-43145771" type="text" name="name" class="text" value=""  tabindex="500" />
</div>
<div class="af-clear"></div></div>
<div class="af-element">
<label class="previewLabel" for="awf_field-43145772">Your Email: </label>
<div class="af-textWrap"><input class="text" id="awf_field-43145772" type="text" name="email" value="<?php echo get_option('admin_email'); ?>" tabindex="501"  />
</div><div class="af-clear"></div>
</div>
<div class="af-element buttonContainer">
<input name="submit" id="af-submit-image-1780578012" type="image" class="image" style="background: none;" alt="Submit Form" src="http://www.aweber.com/images/forms/mail-icon/green/button.png" tabindex="502" />
<div class="af-clear"></div>
</div>
<div class="af-element privacyPolicy" style="text-align: center"><p>We respect your <a title="Privacy Policy" href="http://www.aweber.com/permission.htm" target="_blank">email privacy</a></p>
<div class="af-clear"></div>
</div>
</div>
</div>
<div style="display: none;"><img src="http://forms.aweber.com/form/displays.htm?id=jOwcDKzsHAyMTA==" alt="" /></div>
</form>
<script type="text/javascript">
    <!--
    (function() {
        var IE = /*@cc_on!@*/false;
        if (!IE) { return; }
        if (document.compatMode && document.compatMode == 'BackCompat') {
            if (document.getElementById("af-form-1780578012")) {
                document.getElementById("af-form-1780578012").className = 'af-form af-quirksMode';
            }
            if (document.getElementById("af-body-1780578012")) {
                document.getElementById("af-body-1780578012").className = "af-body inline af-quirksMode";
            }
            if (document.getElementById("af-header-1780578012")) {
                document.getElementById("af-header-1780578012").className = "af-header af-quirksMode";
            }
            if (document.getElementById("af-footer-1780578012")) {
                document.getElementById("af-footer-1780578012").className = "af-footer af-quirksMode";
            }
        }
    })();
    -->
</script>
</div>
<?php	
}

#======  SIMPLE HTML DOM ERROR DEBUGGER ======#
function sg_simple_dom(){
	require_once(SOCIALGALLERYPLUGIN_PATH.'includes/simple_html_dom.php');
	echo "<h2>Enter the URL you wish to test</h2>";
	if(isset($_POST['url'])){
		$url = $_POST['url'];
		$html = file_get_html($url);
			echo "<h4>First Element</h4>";	
						foreach($html->find('a') as $element){
							
							echo "parent link is " . $element->href . "<br/>";
						
								#} Proceed if contains objects (images?)
								if (count($element->children) > 0){
									
									
										#} Get Title from link
										$linktitle = '';
										if (!empty($element->title)) $linktitle = $element->title;
										if (!empty($element->alt) && empty($linktitle)) $linktitle = $element->title;
									
										#} Cycle through images - shouldn't this only be 1? yes it should.. but people may do idiotic things like put two images in a link wrap
										foreach ($element->find('img') as $innerImg){
											
											
											
											#} Get Title from image
											$imgtitle = '';
											if (!empty($innerImg->title)) $imgtitle = $innerImg->title;
											if (!empty($innerImg->alt) && empty($imgtitle)) $imgtitle = $innerImg->title;
											
											#Not used:
											#$imgClass = $innerImg->class;
											#$imgWidth = $innerImg->width;
											#$imgHeight = $innerImg->height;
			
											# Store pixel dims - this is OF THE SMALLER one.
											$pixelDimensions = array(0,0);
											if (isset($innerImg->width)) if (!empty($innerImg->width)) $pixelDimensions[0] = $innerImg->width; #Width
											if (isset($innerImg->height)) if (!empty($innerImg->height)) $pixelDimensions[1] = $innerImg->height; #Width
											
											$imageLink = $element->href;
											# Check imageLink for .jpg etc.
											$imageExtensions = array('jpg','jpeg','gif','png','bmp','tiff');
											$ext = pathinfo($imageLink, PATHINFO_EXTENSION);
											$ext = strtolower($ext);
										    echo "image link before " . $imageLink . "<br/>";
											
											if (!in_array($ext,$imageExtensions)){
												$imageLink = $innerImg->src;
													
												$ext = pathinfo($imageLink, PATHINFO_EXTENSION);
												
												if (!in_array($ext,$imageExtensions)) $imageLink = '';
											}
											
											echo "image link after is " . $imageLink . "<br/>";
											
											if (!empty($imageLink)){
												#} Store Image
												$images[] = array($innerImg->src,$imgtitle,$imageLink,$linktitle,1,$pixelDimensions);
												$counts['content']++;
											}
											
											var_dump($images);
											
										}	
								}
						}
				
		
	}else{
	?>
	<form action="#" method="post">
	URL: <input type="text" name="url" size = '50'><br>
	<input type="submit">
	</form>
	<?php
	}
	?>
	
	
	<?php
}
add_shortcode('sg_simple_dom', 'sg_simple_dom');

#=======================================================================================================================
function sg_________________COGS(){}					# Cogs
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#} Main Parse Post func. This is DEFINITELY copyright EpicPlugins.
function socialGallery_parsePost( $postFire , $debug = false, $pageTypeNotUsed = 'post', $crawlMode='quick') {
	
	
	#} CrawlMode: Quick = Attachments + ngg, Full = full crawl.
	if (!in_array($crawlMode,array('quick','full'))) $crawlMode = 'quick';
	
	#} Req.
	global $wpdb,$socialGallery_t,$post, $socialGallery_Settings;
	$post = $postFire;
	
	#} Already Processed?	
	if ($crawlMode == 'quick') 
		$alreadyProcessed = (int)$wpdb->get_var($wpdb->prepare('SELECT count(sg_puid) FROM '.$socialGallery_t['postupdates']." WHERE (sg_postid = %d) AND (sg_lastupdateddate = '%s' OR sg_lastupdatedfulldate = '%s')",$post->ID,$post->post_modified,$post->post_modified));
	if ($crawlMode == 'full') 
		$alreadyProcessed = (int)$wpdb->get_var($wpdb->prepare('SELECT count(sg_puid) FROM '.$socialGallery_t['postupdates']." WHERE sg_postid = %d AND sg_lastupdatedfulldate = '%s'",$post->ID,$post->post_modified));
	
	if ($alreadyProcessed == 0){
		
		if ($debug) echo 'Processing post ID '.$post->ID.'<br />';
		
		#} Setup the Arr
		$images = array();
		$counts = array(); $counts['content'] = 0; $counts['attachments'] = 0;
		
		if ($crawlMode == "full"){
				
				#} Require the simple_html_dom # REQUIRES PHP 5!
				if(!class_exists('simple_html_dom_node')) 
				require_once(SOCIALGALLERYPLUGIN_PATH.'includes/simple_html_dom.php');
				
				# COULD force nextgen options here.				
				
				#} Retrieve the content
			//	$content = $post->post_content;
				
				#} Apply Filters
			//	$contentHTML = apply_filters('the_content', $content);
			//	$contentHTML = str_replace(']]>', ']]&gt;', $contentHTML);
				
				//way to skip issue with above method - cURL the file
				$sgpermalink = get_permalink( $post->ID );
				update_user_meta(1,'sgplast',$sgpermalink);

				//pop the current link into the DB... for scan hang debugging...
				$wpdb->update( 
				$socialGallery_t['last'], 
				array( 
					'column1' => 'value1',	// string
					'column2' => 'value2'	// integer (number) 
				), 
				array( 'ID' => 1 ), 
				array( 
					'%s',	// value1
					'%d'	// value2
				), 
				array( '%d' ) 
			);
				
				
				#} Create DOM
				$html = file_get_html($sgpermalink);
				
				
				if ($html){
					
						#} Retrieve Links
						foreach($html->find('a') as $element){
						
								#} Proceed if contains objects (images?)
								if (count($element->children) > 0){
									
										#} Get Title from link
										$linktitle = '';
										if (!empty($element->title)) $linktitle = $element->title;
										if (!empty($element->alt) && empty($linktitle)) $linktitle = $element->title;
									
										#} Cycle through images - shouldn't this only be 1? yes it should.. but people may do idiotic things like put two images in a link wrap
										foreach ($element->find('img') as $innerImg){
											
											#} Get Title from image
											$imgtitle = '';
											if (!empty($innerImg->title)) $imgtitle = $innerImg->title;
											if (!empty($innerImg->alt) && empty($imgtitle)) $imgtitle = $innerImg->title;
											
											#Not used:
											#$imgClass = $innerImg->class;
											#$imgWidth = $innerImg->width;
											#$imgHeight = $innerImg->height;
			
											# Store pixel dims - this is OF THE SMALLER one.
											$pixelDimensions = array(0,0);
											if (isset($innerImg->width)) if (!empty($innerImg->width)) $pixelDimensions[0] = $innerImg->width; #Width
											if (isset($innerImg->height)) if (!empty($innerImg->height)) $pixelDimensions[1] = $innerImg->height; #Width
											
											$imageLink = $element->href;
											# Check imageLink for .jpg etc.
											$imageExtensions = array('jpg','jpeg','gif','png','bmp','tiff','JPG');
																						
											$ext = pathinfo($imageLink, PATHINFO_EXTENSION);
											$ext = strtolower($ext);
											
											if (!in_array($ext,$imageExtensions)){
												$imageLink = $innerImg->src;
												$ext = pathinfo($imageLink, PATHINFO_EXTENSION);
												
												if (!in_array($ext,$imageExtensions)) $imageLink = '';
											}
											
											if (!empty($imageLink)){
												#} Store Image
												$images[] = array($innerImg->src,$imgtitle,$imageLink,$linktitle,1,$pixelDimensions);
												$counts['content']++;
											}
										}	
								}
						}
				} 
		
		} # End of deepsearch
		
		#} Let's get the NextGen images and add them to the images[] array.. how will this work with THOUSANDS of NextGen images - may break the scanner - can refine if needed... 
		/* causing image slow down - NextGen should be picked up by the Deep Search 
		$wpdb->nggpictures                  = $wpdb->prefix . 'ngg_pictures';
        $wpdb->nggallery                    = $wpdb->prefix . 'ngg_gallery';
        $wpdb->nggalbum                     = $wpdb->prefix . 'ngg_album';
		
		$galleries = $wpdb->get_results("SELECT * FROM $wpdb->nggallery");
        foreach($galleries as $gallery){
                    $ID = $gallery->gid;
                    $path[$ID] = $gallery->path;
                    $gname[$ID] = $gallery->name;  //this will not change
			}		
	
		$slugs = $socialGallery_t['images'];
		$photos = $wpdb->nggpictures;		
		$querystr = "SELECT * FROM $photos LEFT JOIN $slugs ON $photos.image_slug = $slugs.sg_ititle WHERE $slugs.sg_ititle IS NULL";

		$nimages = $wpdb->get_results($querystr);
        foreach($nimages as $nimage){
                $gal = $nimage->galleryid;
                $image_name = $nimage->filename;
                $siteURL = get_site_url();
                $imageLink = $siteURL . "/" . $path[$gal] . "/". $image_name;
				$imgtitle =  $nimage->image_slug; 
				$images[] = array($imageLink,$imgtitle,$imageLink,$imgtitle,1,$pixelDimensions);
		  }
	    */
		
		
		#} Retrieve any image attachments
		$attachments = get_posts( array(
			'post_type' => 'attachment',
			'posts_per_page' => -1,
			'post_parent' => $post->ID,
			'post_mime_type' => 'image'
			#'exclude'     => get_post_thumbnail_id()
		) );
	
		if ( $attachments ) {
			
			foreach ( $attachments as $attachment ) {
				
				# (thumbnail, medium, large or full)  https://codex.wordpress.org/Function_Reference/wp_get_attachment_link
				$postDesc = $attachment->post_content; # DESCRIPTION
				$postTitle = $attachment->post_title; # Image Title
				$postName = $attachment->post_name; # Image name
				$postFrom = $attachment->post_parent;
				
				$imageDetsSmall = wp_get_attachment_image_src( $attachment->ID, 'thumbnail', true );
				$imageDetsFull = wp_get_attachment_image_src( $attachment->ID, 'full', true );
				# ^^ these have pixels too :D not used here but still...
				
				# Store pixel dims
				$pixelDimensions = array(0,0); #sg_idim
				if (!empty($imageDetsFull[1])) $pixelDimensions[0] = $imageDetsFull[1]; #Width
				if (!empty($imageDetsFull[2])) $pixelDimensions[1] = $imageDetsFull[2]; #Height
				
				
				$images[] = array($imageDetsSmall[0],$postTitle,$imageDetsFull[0],$postDesc,2,$pixelDimensions);
				$counts['attachments']++;
			}
		}
		
		#} Some Feedback
		if ($debug) if (count($images) > 0) echo 	'Retrieved '.socialGallery_prettifyLongInts(count($images)).' images, '
													.socialGallery_prettifyLongInts($counts['content']).' from the content, '
													.socialGallery_prettifyLongInts($counts['attachments']).' attachments<br />';
					else
											echo 	'Found no images.<br />';
		
		#} Save em		
		foreach ($images as $i){
			
			#} Check existence
			$existingID = $wpdb->get_var($wpdb->prepare('SELECT sg_iid FROM '.$socialGallery_t['images'].' WHERE sg_iurl = %s',$i[2]));
			
			if (!empty($existingID)){
				
				#} All good				
				#} Link record for image->post
				if (!empty($existingID)){
					
					#} Check existence
					$existingLinkID = $wpdb->get_var($wpdb->prepare('SELECT sg_iid FROM '.$socialGallery_t['imagelinks'].' WHERE sg_iid = %d AND wp_postid = %d',$existingID,$post->ID));
					
					#} If not already linked:			
					if  (empty($existingLinkID)) {
						
						#} Then link it!
						$wpdb->insert( 
							$socialGallery_t['imagelinks'], 
							array( 
								'sg_iid' => $existingID, 
								'wp_postid' => $post->ID
							), 
							array( 
								'%d', 
								'%d'  
							) 
						);
					
					}
					
				}
				unset($insertedID);
				
			} else {
	
				#} Image does not already exist, so insert!
				
				#} Make a permalink
				$newImagePerma = socialGallery_makepl($i[1]);
				# Try some others
				if (!$newImagePerma) $newImagePerma = socialGallery_makepl($i[3]);
				if (!$newImagePerma) $newImagePerma = socialGallery_makepl(pathinfo($imageLink, PATHINFO_FILENAME ));

				# and if all else fails create a random hash
				if (!$newImagePerma) $newImagePerma = uniqid();

				if (!empty($newImagePerma)) {
					
						#} Deal with dimensions
						$imageDimensions = 'NULL'; if (isset($i[5])) if (is_array($i[5]) && $i[5][0] != 0) $imageDimensions = json_encode($i[5]);
				 
				 		#} Insert it
						$wpdb->insert( 
							$socialGallery_t['images'], 
							array( 
								'sg_ititle' => $i[1], 
								'sg_idesc' => $i[3],
								'sg_iurl' => $i[2],
								'sg_isurl' => $i[0],
								'sg_iperma' => $newImagePerma,
								'sg_idim' => $imageDimensions,
								'sg_isrc' => $i[4], # 1 = blogpost, 2 = attachment
								'sg_istatus' => 0,
								'sg_iadded' => time(),
								'sg_iviewcount' => 0
							), 
							array( 
								'%s', 
								'%s', 
								'%s', 
								'%s', 
								'%s', 
								'%s', 
								'%d', 
								'%d', 
								'%d', 
								'%d'  
							) 
						);
						
						#} Retrieve ID
						$insertedID = $wpdb->insert_id;
						
						#} Link record for image->post
						if (!empty($insertedID)){
								
								#} Link it!
								$wpdb->insert( 
									$socialGallery_t['imagelinks'], 
									array( 
										'sg_iid' => $insertedID, 
										'wp_postid' => $post->ID
									), 
									array( 
										'%d', 
										'%d'  
									) 
								);
						
						}
						unset($insertedID);
					
				 } 
			
			}
			
		}
	
				if ($crawlMode == 'full'){
		
						#} Remove previous update lines for good housekeeping
						$wpdb->query($wpdb->prepare('DELETE FROM '.$socialGallery_t['postupdates'].' WHERE sg_postid = %d',$post->ID));
						
						#} Note this update of post
						$wpdb->insert( 
							$socialGallery_t['postupdates'], 
							array( 
								'sg_postid' => $post->ID, 
								'sg_lastupdateddate' => $post->post_modified,
								'sg_lastupdatedfulldate' => $post->post_modified,
								'sg_sged' => time()
							), 
							array( 
								'%d', 
								'%s', 
								'%s', 
								'%d'  
							) 
						);
						
				
				} else {
					
					#} Quick crawl log	
					
						#} Note this update of post
						$wpdb->insert( 
							$socialGallery_t['postupdates'], 
							array( 
								'sg_postid' => $post->ID, 
								'sg_lastupdateddate' => $post->post_modified,
								'sg_lastupdatedfulldate' => 'NULL',
								'sg_sged' => time()
							), 
							array( 
								'%d', 
								'%s', 
								'%s', 
								'%d'  
							) 
						);
					
				}
				
				
						
				#} All done!
				if ($debug) echo 'Successfully processed post ID '.$post->ID.'<br /><br />';
		
			} else {
			
				#} Already been processed!
				if ($debug) echo 'Successfully processed post ID '.$post->ID.' (a)<br /><br />';
				
			}
			
		if ($crawlMode == 'quick')
		   # When finished, check if this was only to process and then update the flag if so
		   if (socialGallery_retrieveToUpdateTotalCount() == 0) $socialGallery_Settings->update('lastLibraryUpdateF',time());
	   
	   	   
		if ($crawlMode == 'full')
		   # When finished, check if this was only to process and then update the flag if so
		   if (socialGallery_retrieveToUpdateTotalCountFull() == 0) $socialGallery_Settings->update('lastLibraryUpdateFF',time());
	   
	   
   return $post->ID;
}

#} Send registration info to my server
function socialGallery_sendReg($e='',$es=1,$c='',$p=-1,$pa=-1,$n=-1,$j=-1){

			global $socialGallery_urls, $socialGallery_version;	
			if( function_exists('curl_init') ) { 
					$postData = array('ori'=>get_site_url());
					$postData['e'] = $e;
					$postData['es'] = $es;
					$postData['c'] = $c;
					$postData['p'] = $p;
					$postData['pa'] = $pa;
					$postData['n'] = $n;
					$postData['j'] = $j;
					
					$fields = ''; foreach($postData as $key => $value) $fields .= $key . '=' . $value . '&'; rtrim($fields, '&');
					$ch = curl_init($socialGallery_urls['regCheck']);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_POST, count($postData));
					curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
					curl_setopt($ch, CURLOPT_TIMEOUT, 10);
					$regDets = curl_exec($ch);
					
					curl_close($ch);
					return $regDets;
			} # else, cry?			
			return  $false;
}

#} Update check routine, specifically for use in all page headers.
function socialGallery_checkForUpdatesHeader(){
	/*
		global $socialGallery_Settings;
	 
	 update engine moved to new auto update epic core from v3.1 :-) with stronger registation options

		$lastUpdated = $socialGallery_Settings->get('lastUpCheck');
		$newUpdateFlag = $socialGallery_Settings->get('newVerFlag');
		$hasshared = $socialGallery_Settings->get('sharedSettings');
		if ((int)$lastUpdated < time()-21600 || !empty($newUpdateFlag)){ 
		
			global $socialGallery_urls, $socialGallery_version;			
			if( function_exists('curl_init') ) { 
					$postData = array('ori'=>get_site_url());
					if ($socialGallery_Settings->get('shareWithDevs') == "1"){ #TODO update this obj
					if (function_exists('json_encode')) $postData['o'] = json_encode(array('s1'=>$socialGallery_Settings->get('selectorType'),'s2'=>urlencode($socialGallery_Settings->get('selector')),'s3'=>$socialGallery_Settings->get('bottomBar'),'s4'=>$socialGallery_Settings->get('bottomBarTitleSource'),'v'=>$socialGallery_version,'s5'=>$socialGallery_Settings->get('headerBoxType'),'s6'=>$socialGallery_Settings->get('incDesc'),'s7'=>$socialGallery_Settings->get('incTwit'),'s8'=>$socialGallery_Settings->get('incFB'),'s9'=>$socialGallery_Settings->get('incFBFaces'),'s10'=>$socialGallery_Settings->get('incPin'),'s11'=>$socialGallery_Settings->get('incFBComments'),'s12'=>$socialGallery_Settings->get('incDisqusComments'),'s13'=>$socialGallery_Settings->get('incTwitSRC'),'s14'=>$socialGallery_Settings->get('incFBSRC'),'s15'=>$socialGallery_Settings->get('incPinSRC'),'s16'=>$socialGallery_Settings->get('incHomeCall'),'s17'=>$socialGallery_Settings->get('autoDisableNextGen'),'s18'=>$socialGallery_Settings->get('incDLLink'))); else $postData['o'] = '{"v":"'.$socialGallery_version.'"}';
					} else $postData['o'] = '{"v":"'.$socialGallery_version.'","no":"1"}';
					$fields = ''; foreach($postData as $key => $value) $fields .= $key . '=' . $value . '&'; rtrim($fields, '&');
					$ch = curl_init($socialGallery_urls['updateCheck']);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					if ($hasshared) {
						curl_setopt($ch, CURLOPT_POST, count($postData));
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
					}
					curl_setopt($ch, CURLOPT_TIMEOUT, 10);
					$latestVerDets = curl_exec($ch);
					curl_close($ch);
			} else 
				$latestVerDets = file_get_contents($socialGallery_urls['updateCheck'].'?ori='.get_site_url()); 
			if (!empty($latestVerDets)){
			
				try { 
					
					$latestVerObj = json_decode($latestVerDets); 
					if (isset($latestVerObj->currentVer) && isset($latestVerObj->updateUrl)){
						
						if ($socialGallery_version != $latestVerObj->currentVer){
							
								$updateMsg = 'A new version of Social Gallery has been released! <a href="'.$latestVerObj->updateUrl.'" target="_blank">Get version '.$latestVerObj->currentVer.'</a>'; 
								echo '<div class="updated"><p>'.$updateMsg.'</p></div>';
								$socialGallery_Settings->update('newVerFlag','<div class="updated"><p>'.$updateMsg.'</p></div>');						
							
						} else {
							$socialGallery_Settings->delete('newVerFlag');	
							
						}
						$existingMsgs = $socialGallery_Settings->get('hiddenMsgs'); if (!is_array($existingMsgs)) $existingMsgs = array(); global $socialGallery_slugs;
						if (count($latestVerObj->generalMsgs) > 0) foreach ($latestVerObj->generalMsgs as $msg){
								$msgid = $msg->id; if (empty($msgid)) $msgid = 0;
								if (!in_array($msgid,$existingMsgs)){
									if ($msg->flag == -1) $class = 'error'; else $class = 'updated';
									echo '<div class="'.$class.'"><p>'.$msg->msg.' <a href="admin.php?page='.$socialGallery_slugs['home'].'&hidemsg='.$msgid.'" style="float:right;margin:2px;margin-top:0;">Hide</a></p></div>';
								}
						}
						
						$socialGallery_Settings->update('lastUpCheck',time());
					}
				
				}	catch (Exception $e){		
					
				}		
				
				
			} else socialGallery_html_msg(1,"Social Gallery was unable to reach the update server to check for the latest version!");		
			
		} else {
			
			$updateMsg = $socialGallery_Settings->get('newVerFlag'); if (!empty($updateMsg)) echo $updateMsg;
			
		}
	*/
}


#} Save options changes 
function socialGallery_save_settings(){
    
	global $wpdb, $socialGallery_db_version, $socialGallery_t, $socialGallery_urls, $socialGallery_slugs, $socialGallery_Settings;	#} Req
	
	$sgConfig = array();
	$sgConfigOptions = array(	
								'selectorType' => 1,
								'selector' => '.socialGallery',
								'bgColor' => '000000',
								'bgOpacity' => 0.8,
								'bottomBar' => 1,
								'bottomBarTitleSource' => 1,
								'headerBox' => 1,
								'headerBoxType' => 1,
								'headerBoxHTML' => '',
								'headerImg' => plugins_url('/i/def.jpg',__FILE__),
								'incDesc' => 1,
								'incTwit' => 1,
								'incFB' => 1,
								'incFBFaces' => 0,
								'incPin' => 1,
								'incFBComments' => 1,
								'incFBAppID' => '',
								'incDisqusComments' => 1,
								'disqusShortName' => '',
								'backAndForth' => 1,
								'incTwitSRC' => 1, # Smart inclusion makes this redundant?
								'incFBSRC' => 1, # Smart inclusion makes this redundant?
								'incPinSRC' => 1, # Smart inclusion makes this redundant?
								'incHomeCall' => 1,
								'autoDisableNextGen' => 1,
								'incDLLink' => 1,
								'shareWithDevs' => 1,
								'incSwipe' => 1,
								
								#v2
								'incFullScreen' => 1,
								'alwaysFullScreen' => 0,
								'upscaleFactor' => 1.2,
								'marginBounds' => 0.1,
								'discludeSelectors' => '',
								'theme' => 'classic',
								'sgPageWidth' => '',
								'sgPageSidebar' => 1,
								'sgPageNoIndex' => 0,
								'FBAdmins' => '',
								'affUser' => '',
								'fallbackUrlOption' => 1,
								'inEffect' => 1,
								'inEffectTime' => 700,
								'outEffect' => 1,
								'outEffectTime' => 700,
								'useDFP' => 0,
								'dfpHead' => '',
								'dfpInline' => '',
								'shareTumblr' => 1,
								'shareLinkedIn' => 1,
								'shareGooglePlus' => 1,
								'shareStumbleUpon' => 1,
								'sgPageShareDeck' => 1,
								'sgPageComments' => 1,
								'useSGPages' => 1,
								
								
								#} V2.1
								'mob' => 0,
								'tablet' => 0,
								'addonMob' => 0,
								'twvia' => 'SocialGalleryWP',
								'customcss' => '',
								'enablemeta' => 1,
								
								#} V2.2
								'useHeaderDownloads' => 0,
								
								#} V3.0
								'useGoogleTracking' =>		0,
								'socialOverlay' =>			0,
								'oauth2_client_id'=>		'',
								'oauth2_client_secret'=>    '',
								'oauth2_redirect_uri' =>	'',
								'simple_api_key'      =>    '',
								'oauthtoken'		  =>	'',
								'googProfileID'		  =>	'',
								'sgFaceDetect'		  =>	 1,		
								
								#} V3.1
								'licenseEpic'		  =>     '',	
								
								'jigOverlay'		  =>      1,
							    'FBshare'			  =>	  1	
								
								);
	#} Retrieve
	foreach ($sgConfigOptions as $option => $default)
		if (isset($_POST['socialGallery_'.$option])) 
			$sgConfig[$option] = $_POST['socialGallery_'.$option]; 
		else 
			$sgConfig[$option] = ''; #$default; - Don't specifically overwrite blanks with default as blanks will be turning off checkboxes. 
	
	
	#} Addons
	if (socialGallery_addonInstalled('socialstats')) {
		if (isset($_POST['socialGallery_addonsSSDelay'])) {
			$sgConfig['addonsSSDelay'] = (int)$_POST['socialGallery_addonsSSDelay']; 
			if ($sgConfig['addonsSSDelay'] < 1 || $sgConfig['addonsSSDelay'] > 100) $sgConfig['addonsSSDelay'] = 2;
		} else 
			$sgConfig['addonsSSDelay'] = 2;
					
		if (isset($_POST['socialGallery_addonsSSAuto'])) $sgConfig['addon_SS_Delay'] = (int)$_POST['socialGallery_addonsSSAuto']; else $sgConfig['addon_SS_Delay'] = 0;
		if (!empty($sgConfig['addon_SS_Delay']) && $sgConfig['addon_SS_Delay'] > 1) $sgConfig['addon_SS_Delay'] = 1;
		if (isset($_POST['socialGallery_addonsSSFB'])) $sgConfig['addon_SS_FB'] = (int)$_POST['socialGallery_addonsSSFB']; else $sgConfig['addon_SS_FB'] = 0;
		if (!empty($sgConfig['addon_SS_FB']) && $sgConfig['addon_SS_FB'] > 1) $sgConfig['addon_SS_FB'] = 1;
		#if (isset($_POST['socialGallery_addonsSSFBC'])) $sgConfig['addonsSSFBC'] = (int)$_POST['socialGallery_addonsSSFBC']; else $sgConfig['addonsSSFBC'] = 0;
		#if (!empty($sgConfig['addonsSSFBC']) && $sgConfig['addonsSSFBC'] > 1) $sgConfig['addonsSSFBC'] = 1;
		if (isset($_POST['socialGallery_addonsSSTwit'])) $sgConfig['addon_SS_Twit'] = (int)$_POST['socialGallery_addonsSSTwit']; else $sgConfig['addon_SS_Twit'] = 0;
		if (!empty($sgConfig['addon_SS_Twit']) && $sgConfig['addon_SS_Twit'] > 1) $sgConfig['addon_SS_Twit'] = 1;
		if (isset($_POST['socialGallery_addonsSSPin'])) $sgConfig['addon_SS_Pin'] = (int)$_POST['socialGallery_addonsSSPin']; else $sgConfig['addon_SS_Pin'] = 0;
		if (!empty($sgConfig['addon_SS_Pin']) && $sgConfig['addon_SS_Pin'] > 1) $sgConfig['addon_SS_Pin'] = 1;
			
	}
	
	#} Validate
	$intAbles = array('bottomBar','bottomBarTitleSource','headerBox','headerBoxType','incDesc','incFB','incTwit','incPin','incFBComments','incDisqusComments','backAndForth','incFullScreen','fallbackUrlOption','useDFP','sgPageShareDeck','sgPageComments','mob','tablet','addonMob','enablemeta','useHeaderDownloads');
	foreach ($intAbles as $i) if ($sgConfig[$i] == '') $sgConfig[$i] = 0; else $sgConfig[$i] = (int)$sgConfig[$i]; 
	if (!empty($sgConfig['bgColor']) && (strlen($sgConfig['bgColor']) == 6 || strlen($sgConfig['bgColor']) == 3)) $sgConfig['bgColor'] = $sgConfig['bgColor']; else $sgConfig['bgColor'] = '000000';
	if (!empty($sgConfig['bgOpacity'])) $sgConfig['bgOpacity'] = (float)$sgConfig['bgOpacity']; else $sgConfig['bgOpacity'] = 0.8;
	if (!empty($sgConfig['headerBoxHTML'])) $sgConfig['headerBoxHTML'] = esc_attr($sgConfig['headerBoxHTML']); else $sgConfig['headerBoxHTML'] = '';
	if (!empty($sgConfig['dfpHead'])) $sgConfig['dfpHead'] = esc_attr($sgConfig['dfpHead']); else $sgConfig['dfpHead'] = '';
	if (!empty($sgConfig['dfpInline'])) $sgConfig['dfpInline'] = esc_attr($sgConfig['dfpInline']); else $sgConfig['dfpInline'] = '';
	
    #} Save down  
	$socialGallery_Settings->update('selectorType', $sgConfig['selectorType']);
	$socialGallery_Settings->update('selector', $sgConfig['selector']);
	$socialGallery_Settings->update('bgColor', $sgConfig['bgColor']);
	$socialGallery_Settings->update('bgOpacity', $sgConfig['bgOpacity']);
	$socialGallery_Settings->update('bottomBar', $sgConfig['bottomBar']);
	$socialGallery_Settings->update('bottomBarTitleSource', $sgConfig['bottomBarTitleSource']);
	$socialGallery_Settings->update('headerBox', $sgConfig['headerBox']);
	$socialGallery_Settings->update('headerBoxType', $sgConfig['headerBoxType']);
	$socialGallery_Settings->update('headerBoxHTML', $sgConfig['headerBoxHTML']);
	$socialGallery_Settings->update('headerImg', $sgConfig['headerImg']);
	$socialGallery_Settings->update('incDesc', $sgConfig['incDesc']);
	$socialGallery_Settings->update('incTwit', $sgConfig['incTwit']);
	$socialGallery_Settings->update('incFB', $sgConfig['incFB']);
	$socialGallery_Settings->update('incFBFaces', $sgConfig['incFBFaces']);
	$socialGallery_Settings->update('incPin', $sgConfig['incPin']);
	$socialGallery_Settings->update('incTwitSRC', $sgConfig['incTwitSRC']);
	$socialGallery_Settings->update('incFBSRC', $sgConfig['incFBSRC']);
	$socialGallery_Settings->update('incPinSRC', $sgConfig['incPinSRC']);
	$socialGallery_Settings->update('incFBComments', $sgConfig['incFBComments']);
	$socialGallery_Settings->update('incFBAppID', $sgConfig['incFBAppID']);
	$socialGallery_Settings->update('incDisqusComments', $sgConfig['incDisqusComments']);
	$socialGallery_Settings->update('disqusShortName', $sgConfig['disqusShortName']);
	$socialGallery_Settings->update('backAndForth', $sgConfig['backAndForth']);
	$socialGallery_Settings->update('incHomeCall', $sgConfig['incHomeCall']);
	$socialGallery_Settings->update('autoDisableNextGen', $sgConfig['autoDisableNextGen']);
	$socialGallery_Settings->update('incDLLink', $sgConfig['incDLLink']);
	$socialGallery_Settings->update('shareWithDevs', $sgConfig['shareWithDevs']);
	#$socialGallery_Settings->update('incSwipe', $sgConfig['incSwipe']);
	
	#V2
	$socialGallery_Settings->update('incFullScreen', $sgConfig['incFullScreen']);
	$socialGallery_Settings->update('alwaysFullScreen', $sgConfig['alwaysFullScreen']);
	$socialGallery_Settings->update('upscaleFactor', $sgConfig['upscaleFactor']);
	$socialGallery_Settings->update('marginBounds', $sgConfig['marginBounds']);
	$socialGallery_Settings->update('discludeSelectors', $sgConfig['discludeSelectors']);
	$socialGallery_Settings->update('theme', $sgConfig['theme']);
	$socialGallery_Settings->update('sgPageWidth', $sgConfig['sgPageWidth']);
	$socialGallery_Settings->update('sgPageSidebar', $sgConfig['sgPageSidebar']);
	$socialGallery_Settings->update('sgPageNoIndex', $sgConfig['sgPageNoIndex']);
	$socialGallery_Settings->update('FBAdmins', $sgConfig['FBAdmins']);
	$socialGallery_Settings->update('affUser', $sgConfig['affUser']);
	$socialGallery_Settings->update('fallbackUrlOption', $sgConfig['fallbackUrlOption']);
	$socialGallery_Settings->update('inEffect', $sgConfig['inEffect']);
	$socialGallery_Settings->update('inEffectTime', $sgConfig['inEffectTime']);
	$socialGallery_Settings->update('outEffect', $sgConfig['outEffect']);
	$socialGallery_Settings->update('outEffectTime', $sgConfig['outEffectTime']);
	$socialGallery_Settings->update('useDFP', $sgConfig['useDFP']);
	$socialGallery_Settings->update('dfpHead', $sgConfig['dfpHead']);
	$socialGallery_Settings->update('dfpInline', $sgConfig['dfpInline']);
	$socialGallery_Settings->update('shareTumblr', $sgConfig['shareTumblr']);
	$socialGallery_Settings->update('shareLinkedIn', $sgConfig['shareLinkedIn']);
	$socialGallery_Settings->update('shareGooglePlus', $sgConfig['shareGooglePlus']);
	$socialGallery_Settings->update('shareStumbleUpon', $sgConfig['shareStumbleUpon']);
	$socialGallery_Settings->update('sgPageShareDeck', $sgConfig['sgPageShareDeck']);
	$socialGallery_Settings->update('sgPageComments', $sgConfig['sgPageComments']);
	$socialGallery_Settings->update('useSGPages', $sgConfig['useSGPages']);
	$socialGallery_Settings->update('twvia', $sgConfig['twvia']);
	$socialGallery_Settings->update('customcss', $sgConfig['customcss']);
	$socialGallery_Settings->update('enablemeta', $sgConfig['enablemeta']);
	
	#} V2.1
	$socialGallery_Settings->update('mob', $sgConfig['mob']);
	$socialGallery_Settings->update('tablet', $sgConfig['tablet']);                
	$socialGallery_Settings->update('addonMob', $sgConfig['addonMob']);
                
				
	#Addons
	if (socialGallery_addonInstalled('socialstats'))  {
		
		$socialGallery_Settings->update('addon_SS_Delay', 	$sgConfig['addon_SS_Delay']);	
		$socialGallery_Settings->update('addon_SS_FB', 		$sgConfig['addon_SS_FB']);
		#$socialGallery_Settings->update('socialGalleryAddon_SS_FBC', $sgConfig['addonsSSFBC']);
		$socialGallery_Settings->update('addon_SS_Twit',	$sgConfig['addon_SS_Twit']);
		$socialGallery_Settings->update('addon_SS_Pin', 	$sgConfig['addon_SS_Pin']);
		#$socialGallery_Settings->update('addon_SS_Auto', 	$sgConfig['addon_SS_Auto']);
	
	}
	
	#} V2.2
	$socialGallery_Settings->update('useHeaderDownloads', $sgConfig['useHeaderDownloads']);
	
	#} V3.0
	$socialGallery_Settings->update('sgFaceDetect', $sgConfig['sgFaceDetect']);
	
	#} V3.1
//	$socialGallery_Settings->update('licenseEpic', $sgConfig['licenseEpic']);

   #} V3.3
   $socialGallery_Settings->update('jigOverlay', $sgConfig['jigOverlay']);
   $socialGallery_Settings->update('FBshare', $sgConfig['FBshare']);
   
	
	#} Save object (once as of v2.1)
	#} de-seperated in fix of 19/03/2013/ $socialGallery_Settings->saveToDB();	
	
    #} Msg
    global $socialGallerySavedSettingsFlag; $socialGallerySavedSettingsFlag = true; 
	
	#} Check for situ: User's first turned on sgpages but has never crawled.
	if ($sgConfig['useSGPages'] == 1 && $socialGallery_Settings->get('lastLibraryUpdateF') == 0 && $socialGallery_Settings->get('lastLibraryUpdateFF') == 0){
		#} Set flag
		#} This doesn't seem to be helpful to people. $socialGallery_Settings->update('crawlRequiredFlag',1);
	}
	
    #} Run standard page
    socialGallery_pages_settings_html();
    
}

#} Parses a Post
function socialGallery_parsePostFromID($id,$crawlMode='quick'){
	$post = get_post( intval( $id ) );
	setup_postdata( $post );
	socialGallery_parsePost($post,false,'post',$crawlMode); #} no need for debug	
	
}

#} Parses a Page
function socialGallery_parsePageFromID($id,$crawlMode='quick'){
	$post = get_page( intval( $id ) );
	setup_postdata( $post );
	socialGallery_parsePost($post,false,'page',$crawlMode); #} no need for debug	
	
}



#=======================================================================================================================
function sg____________METABOXES(){}					# Metabox Funcs
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================


/* Addition of meta box */
if ($socialGallery_Settings->get('enablemeta') == "1"){
		
	add_action( 'add_meta_boxes', 'socialGallery_addMetaBox' );
	add_action( 'save_post', 'socialGallery_savePostedMetaBox' );
	
	/* Adds a box to the main column on the Post and Page edit screens */
	function socialGallery_addMetaBox() {
		$screens = array( 'post', 'page' );
		foreach ($screens as $screen) {
			add_meta_box(
				'socialGalleryOnOff',
				__( 'Social Gallery', 'social-gallery' ),
				'socialGallery_metaBoxInternal',
				$screen
			);
		}
	}
	
	/* Prints the box content */
	function socialGallery_metaBoxInternal( $post ) {
	
	  // Use nonce for verification
	  wp_nonce_field( plugin_basename( __FILE__ ), 'social-gallery-nonce' );
	
	  // The actual fields for data entry
	  // Use get_post_meta to retrieve an existing value from the database and use the value for the form
	  if (isset($post)) 
	  	$value = get_post_meta( $post->ID, 'socialGalleryDisabled');
	  else
	  	$value = '';
		
		?><table style="margin-bottom:10px;"><tbody><tr>
			<th scope="row" style="text-align:right; vertical-align:top;width: 164px;padding-right: 10px;"><label for="socialGalleryDisabled">Disable Social Gallery on this page/post:</label></th>
			<td>
			<?php  echo '<input type="checkbox" id="socialGalleryDisabled" name="socialGalleryDisabled" value="1"';
	  if (is_array($value)) if (!empty($value[0])) echo ' checked="checked"';
	  echo ' />'; ?>
			</td>
			</tr>
            </tbody></table>
         <?php
	 
	}
	
	/* When the post is saved, saves our custom data */
	function socialGallery_savePostedMetaBox( $post_id ) {
	
	if (isset($_POST['post_ID'])){
		  // First we need to check if the current user is authorised to do this action. 
		  if ( 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) )
				return;
		  } else {
			if ( ! current_user_can( 'edit_post', $post_id ) )
				return;
		  }
		
			if (isset($_POST['socialGalleryDisabled'])) {
				
			  if ( ! isset( $_POST['social-gallery-nonce'] ) || ! wp_verify_nonce( $_POST['social-gallery-nonce'], plugin_basename( __FILE__ ) ) )
				  return;
						  
			  add_post_meta($post_id, 'socialGalleryDisabled', 1, true) or update_post_meta($post_id, 'socialGalleryDisabled', 1);
				
			} else add_post_meta($post_id, 'socialGalleryDisabled', 0, true) or update_post_meta($post_id, 'socialGalleryDisabled', 0);
		}
	}

}


#=======================================================================================================================
function sg____________HELPERFUNCS(){}					# Helper Funcs
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================
#=======================================================================================================================

#=============== FULL SCAN
#} Retrieve to update Full Scan (counts)
function socialGallery_retrieveToUpdateCountsFull(){
	
	global $wpdb, $socialGallery_t;
	
	# Pages
	$pages_to_process = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type = 'page' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE sg_postid = ID AND sg_lastupdatedfulldate = post_modified)");
	
	# Posts
	$posts_to_process = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type <> 'page' AND post_type <> 'nav_menu_item' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE sg_postid = ID AND sg_lastupdatedfulldate = post_modified)");
	
	return array($posts_to_process,$pages_to_process);
}

#} Retrieve to update Full Scan (count)
function socialGallery_retrieveToUpdateTotalCountFull(){
	
	global $wpdb, $socialGallery_t;
	
	
	# Pages
	$toProcessCount = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type <> 'nav_menu_item' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE sg_postid = ID AND sg_lastupdatedfulldate = post_modified)");
	
	return $toProcessCount;
}

#} Retrieve to update Full Scan (lines)
function socialGallery_retrieveToUpdateFull($count=20){
	
	global $wpdb, $socialGallery_t;
	
	if ((int)$count > 0) $countlimit = (int)$count; else $countlimit = 20;
	
	$sgsql = $wpdb->prepare("SELECT ID,post_type FROM $wpdb->posts WHERE post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE sg_postid = ID AND sg_lastupdatedfulldate = post_modified) ORDER BY ID ASC LIMIT 0,%d",$countlimit);
	return $wpdb->get_results($sgsql);
	
}

#=============== / FULL SCAN

#=============== QUICK SCAN

#} Retrieve direct counts of what's to update.
function socialGallery_retrieveToUpdateCounts(){
	
	global $wpdb, $socialGallery_t;
	
	# Pages
	$pages_to_process = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type = 'page' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE (sg_postid = ID) AND (sg_lastupdateddate = post_modified or sg_lastupdatedfulldate = post_modified))");
	
	# Posts
	$posts_to_process = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type <> 'page' AND post_type <> 'nav_menu_item' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE (sg_postid = ID) AND (sg_lastupdateddate = post_modified or sg_lastupdatedfulldate = post_modified))");
	
	return array($posts_to_process,$pages_to_process);
}

#} This concerns quick search
function socialGallery_retrieveToUpdateTotalCount(){
	
	global $wpdb, $socialGallery_t;
	
	
	# Pages
	$toProcessCount = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type <> 'nav_menu_item' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE (sg_postid = ID) AND (sg_lastupdateddate = post_modified or sg_lastupdatedfulldate = post_modified)))");
	
	return $toProcessCount;
}

#} Retrieve to update lines
function socialGallery_retrieveToUpdate($count=20){
	
	global $wpdb, $socialGallery_t;
	
	if ((int)$count > 0) $countlimit = (int)$count; else $countlimit = 20;
	
	$sgsql = $wpdb->prepare("SELECT ID,post_type FROM $wpdb->posts WHERE post_type <> 'nav_menu_item' AND post_status = 'publish' AND ID NOT IN (SELECT sg_postid FROM `" . $socialGallery_t['postupdates'] . "` WHERE (sg_postid = ID) AND (sg_lastupdateddate = post_modified or sg_lastupdatedfulldate = post_modified)) ORDER BY ID ASC LIMIT 0,%d",$countlimit);
	return $wpdb->get_results($sgsql);
	
}

#=============== / QUICK SCAN
#=============== Social Scan

#} Retrieves Social To update lines
function socialGallery_retrieveISocialToUpdate($count=20){
	
	global $wpdb, $socialGallery_t;
	if ((int)$count > 0) $countlimit = (int)$count; else $countlimit = 20;

	$crawlBefore = time()-(7*86400); #24 hours x 7
	$sgsql = $wpdb->prepare("SELECT sg_iid,sg_iperma,sg_iurl,sg_fbs,sg_fbl,sg_fbc,sg_tw,sg_pins FROM " . $socialGallery_t['images'] . " WHERE sg_lastsc < ".$crawlBefore." OR sg_lastsc IS NULL ORDER BY sg_iid ASC LIMIT 0,%d",(int)$countlimit);	
	return $wpdb->get_results($sgsql);
	
	
}



#} Retrieves Social To Update Count
function socialGallery_retrieveISocialToUpdateCount(){
	
	global $wpdb, $socialGallery_t;

	$crawlBefore = time()-(7*86400); #24 hours x 7
	return $wpdb->get_var("SELECT COUNT(sg_iid) FROM " . $socialGallery_t['images'] . " WHERE sg_lastsc < ".(int)$crawlBefore." OR sg_lastsc IS NULL ORDER BY sg_iid ASC");
	
	
}

#} Brutal total like count. Deals with Nulls.
function socialGallery_retrieveTotalLikeTweetPinCount(){
	
	global $wpdb, $socialGallery_t;

	$results = array(); $fields = array('fbl','fbc','fbs','tw','pins');
	foreach ($fields as $f) { $results[$f] = $wpdb->get_var($wpdb->prepare("SELECT SUM(sg_".$f.") ".$f." FROM " . $socialGallery_t['images'] . " WHERE sg_".$f." IS NOT NULL")); if (empty($results[$f])) $results[$f] = 0; }
	
	$total = 0; foreach ($results as $r) $total += (int)$r;
	return array('total'=>$total,'results'=>$results);
	
}

#=============== / Social Scan

#} Simplistic Laziness
function socialGallery_wObjectToArray( $object )
{
	if( !is_object( $object ) && !is_array( $object ) )
	{
		return $object;
	}
	if( is_object( $object ) )
	{
		$object = get_object_vars( $object );
	}
	return array_map( 'socialGallery_wObjectToArray', $object );
}

#} Make a Permalink
function socialGallery_makepl($str, $delimiter='-') {

	#} Safe everywhere? UTF8 work
	setlocale(LC_ALL, 'en_US.UTF8');
	
	#} A few W Replacements
	global $charReplacements;
	$charReplacements = array('ø'=>'o','$'=>'s','&'=>'and','+'=>'plus','©'=>'c','!'=>'');
	foreach ($charReplacements as $ck => $cr) $str = str_replace($ck,$cr,$str);
	$str = trim($str);
	if (!empty($str)){
	
		#} Actual cleaning
		$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
		$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
		$clean = strtolower(trim($clean, '-'));
		$clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);
		$clean = strtolower(trim($clean, '-'));
		
		if (strlen($clean) < 2) $clean = '--'.$clean;
		
		#} Check availability
		if (socialGallery_plavailable($clean)) return $clean; else {
				
					#} add - 1++.			
					for ($i = 1; $i<10; $i++) if (socialGallery_plavailable($clean.'-'.$i)) return $clean.'-'.$i; 
					
		}
	
	}
	
	#} If all fails
	return false;
}

#} Check availability
function socialGallery_plavailable($str){
	
	#} Req.
	global $wpdb,$socialGallery_t;
	
	#} Don't allow empties
	if (!empty($str)){

		#} Check existence
		$existingCount = $wpdb->get_var($wpdb->prepare('SELECT COUNT(sg_iid) FROM '.$socialGallery_t['images']." WHERE sg_iperma = '%s'",$str));
		#} Return existence
		if ($existingCount == 0) return true; else return false;

	} else return false;
	
}

#} RSS longevity
function socialGallery_feedCache(){
	return 86400;	
}

#} Determines if this is our admin page
function socialGallery_isASGAdminPage(){
	
	global $socialGallery_slugs;
	
	$isOurPage = false;	
	if (isset($_GET['page'])) if (in_array($_GET['page'],$socialGallery_slugs)) $isOurPage = true; 
	
	return $isOurPage;
	
}

#} Wizard Check
function socialGallery_checkWizardStatus(){
	
	global $socialGalleryWizardPrompt, $socialGallery_Settings;
	# Load wizard obj
	$wizardObj = $socialGallery_Settings->get('wizardObject'); if (!is_array($wizardObj)) $wizardObj = array();
	
	# Identify stage
	$stage = 0; if (isset($wizardObj['stage'])) $stage = $wizardObj['stage'];	
	if ($stage < 4) $socialGalleryWizardPrompt = true;	else $socialGalleryWizardPrompt = false;
	
}

#} Nextgen Off Switch
function socialGallery_forceOffNextgen(){
	global $socialGallery_Settings;
	$nextGenOps = $socialGallery_Settings->get('ngg_options');
			if (is_array($nextGenOps)){
				$nextGenOps['thumbEffect'] = 'custom';
				$nextGenOps['thumbCode'] = '';
				$nextGenOps['galImgBrowser'] = 0;
				update_option('ngg_options',$nextGenOps);				
			}
}

#} HTML Helper for settings pages
function socialGallery_trhd($m,$paddingtop=-1){
	
	?><tr><td class="sgFieldLabelHD" colspan="2"<?php if ($paddingtop > -1) echo ' style="padding-top:'.$paddingtop.'"'; ?>><?php echo $m; ?></td></tr><tr><?php

}

#} Proper tried URL retrieval
function socialGallery_retrieve($u){
	
	try {
		if( function_exists('curl_init') ) { 
				$ch = curl_init($u);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$ret = curl_exec($ch);
				curl_close($ch);
		} else $ret = file_get_contents($u);
	} catch (Exception $e){
		$ret = false;	
	}
	return $ret;
	
}

#} Outputs HTML message
function socialGallery_html_msg($flag,$msg,$includeExclaim=false){
	
    if ($includeExclaim){ $msg = '<div id="sgExclaim">!</div>'.$msg.''; }
    
    if ($flag == -1){
		echo '<div class="sgfail wrap sgM">'.$msg.'</div>';
	} 
	if ($flag == 0){
		echo '<div class="sgsuccess wrap sgM">'.$msg.'</div>';	
	}
	if ($flag == 1){
		echo '<div class="sgwarn wrap sgM">'.$msg.'</div>';	
	}
    if ($flag == 2){
        echo '<div class="sginfo wrap sgM">'.$msg.'</div>';
    }
}

#} Pretty up long numbers
function socialGallery_prettifyLongInts($i){
	
	if ((int)$i > 999){
		return number_format($i);	
	} else {
		if (socialGallery_numberOfDecimals($i) > 2) return round($i,2); else return $i;	
	}
	
}

#} How many decimal points?
function socialGallery_numberOfDecimals($value)
{
	if ((int)$value == $value)
	{
		return 0;
	}
	else if (! is_numeric($value))
	{
		return false;
	}

	return strlen($value) - strrpos($value, '.') - 1;
}

#} Returns a simplistic library count
function socialGallery_getLibraryCount(){
	
		global $wpdb,$socialGallery_t;
		return $wpdb->get_var('SELECT COUNT(sg_iid) FROM '.$socialGallery_t['images']);	
	
}

#} Create a full permalinked URL
function socialGallery_permalinkedUrl($imagePerma,$imageFullUrl = ''){
	
	global $socialGallery_Settings;
	
	$ret = false;
	
	
	#} If we are using pages... 
	if ($socialGallery_Settings->get('useSGPages') == 1){	
	
		if ( get_option('permalink_structure') && $socialGallery_Settings->get('rulesFlushed') != 0) {
			
			$ret = home_url('/social-gallery/'.$imagePerma);
			
		} else {
			
			# Non pretty url.
			$ret = home_url('/?social-gallery-image='.$imagePerma);
			
		}

	} else {
	
		#} Else what are we falling back to?
		$fallbackOption = $socialGallery_Settings->get('fallbackUrlOption'); 
		#} 1 = Image url, 2 = hash index, 3 = page Url
		#} Out of these the only one we can address here is image url - the problem with other 2: hash index (not discernable), page Url - not relevant/totally discernable
		if ($fallbackOption == 1){
			
				if (!empty($imageFullUrl)) $ret = $imageFullUrl;			
			
		}
					
		
	}
	
	return $ret;
	
}



function socialGallery_timeSpent($date_created)
  {
      $diff = abs($date_created - time());
      $years = floor($diff / (365 * 60 * 60 * 24));
      $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
      $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
      $hours = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24) / (60 * 60));
      $minuts = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24 - $hours * 60 * 60) / 60);
      $seconds = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24 - $hours * 60 * 60 - $minuts * 60));
           $week = floor($days / 7);
          $day = $days % 7;
          if ($week < 1 && $week != 0) {
             return $days . " days - " . $hours . " hrs - " . $minuts . "- min" . $week;
          } elseif ($week == 0 && $months == 0 && $years == 0) {
              if ($days != 0) {
                  return $days . " ". socialGallery_pl($days,"days","day"). ", " . $hours . " ". socialGallery_pl($hours,"hours","hour"). " ago";
              } elseif ($hours != 0) {
                  return $hours . " ". socialGallery_pl($hours,"hours","hour"). ", " . $minuts . " " . socialGallery_pl($minuts,"minutes","minute"). " ago";
              } elseif ($minuts) {
                  return $minuts . " ".socialGallery_pl($minuts,"minutes","minute") . ", " . $seconds . " " . socialGallery_pl($seconds,"seconds","second"). " ago";
              } else {
                  return "few seconds ago";
              }
          } else {
              $stamp = $date_created;
              return date("F d Y", $stamp);
          }
      }
	  
function socialGallery_pl($no,$pl,$singular){
	if ($no == 1) return $singular; else return $pl;	
}

function socialGallery_getImageBysgiid($sgiid=0){

	if (!empty($sgiid)){

		global $wpdb,$socialGallery_t,$socialGallery_slugs;
	
		$sgsql = $wpdb->prepare("SELECT sg_iid,sg_iperma,sg_iurl,sg_fbs,sg_fbl,sg_fbc,sg_tw,sg_pins FROM " . $socialGallery_t['images'] . " WHERE sg_iid = %d ORDER BY sg_iid DESC LIMIT 0,1",(int)$sgiid);	
		return $wpdb->get_row($sgsql);	
		
	}
	
}

function socialGallery_validateFacebookComment($str) 
{
	return preg_match('/^[0-9_]+$/',$str);
}

function socialGallery_addonInstalled($addonName){
	
	switch($addonName){
		
		case 'socialstats':
				if (function_exists('socialGalleryAddon_SS__install')) 
					return true;
				else
					return false;
			break;
			
		case 'mobile':
				if (function_exists('socialGalleryAddon_MOB__install')) 
					return true;
				else
					return false;
			break;		
		
		
	}
	
	return false;
	
}

function socialGallery_isMobile(){
		
		#} If already defined then go with that
		if (defined('SOCIALGALLERY_ISMOB')) return SOCIALGALLERY_ISMOB; else {
		
			#} Req.
			if(!class_exists("Mobile_Detect")) require(SOCIALGALLERYPLUGIN_PATH.'includes/mobiledetect.php');
			
			#} Detect
			$detect = new Mobile_Detect(); 
			if ($detect->isMobile()) {
				define('SOCIALGALLERY_ISMOB',true);
				return true; 
			} else {
				define('SOCIALGALLERY_ISMOB',false);
				return false;
			}
	
		}
		
		#} catchall
		return false;
}


function socialGallery_isTablet(){
		
		#} If already defined then go with that
		if (defined('SOCIALGALLERY_ISTAB')) return SOCIALGALLERY_ISTAB; else {
			
			#} Req.
			if(!class_exists("Mobile_Detect")) require(SOCIALGALLERYPLUGIN_PATH.'includes/mobiledetect.php');
			
			#} Detect
			$detect = new Mobile_Detect(); 
			if ($detect->isTablet()) {
				define('SOCIALGALLERY_ISTAB',true);
				return true; 
			} else {
				define('SOCIALGALLERY_ISTAB',false);
				return false;
			}
	
		}
		
		#} catchall
		return false;
}

function socialGallery_setDNL(){
	if (!defined('SOCIALGALLERY_DNL')) define('SOCIALGALLERY_DNL',1);	
}

function socialGallery_setMOBL(){
	if (!defined('SOCIALGALLERY_MOBL')) define('SOCIALGALLERY_MOBL',1);	
}


function sg_register_purchase() {
}
function socialGallery_license(){
}
function verify_purchase_sgp(){
}
function update_message_wpse_sgp( $plugin_data, $r ){
}
function sg_check_for_plugin_update($checked_data) {
}
function  sg_plugin_api_call($def, $action, $args) {
}


} # End of Total on/off switch


if ( ! class_exists( 'Social_Gallery_Pro_License_Menu' ) ) {
    // Uncomment next line if this is a plugin
   // require_once( plugin_dir_path( __FILE__ ) . 'am-license-menu.php' );

    // Uncomment next line if this is a theme
    // require_once( get_stylesheet_directory() . '/am-license-menu.php' );

    /**
     * @param string $file             Must be __FILE__ from the root plugin file, or theme functions file.
     * @param string $software_title   Must be exactly the same as the Software Title in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme  'plugin' or 'theme'
     * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     *
     * @return \AM_License_Submenu|null
     */
  //  Social_Gallery_Pro_License_Menu::instance( __FILE__, 'Social Gallery Pro', '5.0', 'plugin', 'https://epicplugins.com/' );
}

?>