<?php

if(!class_exists('WP_List_Table')){
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class SocialGallery_List_table extends WP_List_Table {
	
    function __construct(){
        global $status, $page;
                
        //Set parent defaults
        parent::__construct( array(
            'singular'  => 'Social Gallery Image',     //singular name of the listed records
            'plural'    => 'Socail Gallery Images',    //plural name of the listed records
            'ajax'      => false        //does this table support ajax?
        ) );
        
    }
    
    function column_default($item, $column_name){
		
		global $socialGallery_slugs;
		
        switch($column_name){
            case 'sg_fbc':
				if (function_exists('socialGalleryAddon_SS_pages_facebookmessages'))
	                return '<strong><a href="?page='.$socialGallery_slugs['socialcomments'].'&sgiid='.$item['sg_iid'].'" title="View Comments">'.$item[$column_name].'</a></strong>';
				else 
					return $item[$column_name];
				break;
            default:
                return $item[$column_name];
                #return print_r($item,true); //Show the whole array for troubleshooting purposes
        }
    }
    
    function column_sg_idesc($item){
        
		global $socialGallery_slugs;
        $actions = array(
			'viewpage' => sprintf('<a href="%1$s" target="_blank">View Page</a>',socialGallery_permalinkedUrl($item['sg_iperma'],$item['sg_iurl'])),
			'delimg' => sprintf('<a href="%1$s">Delete Image</a>','?page='.$socialGallery_slugs['imagelibrary'].'&del='.$item['sg_iid'])
        );
		
		#} addon
		if (function_exists('socialGalleryAddon_SS_pages_facebookmessages'))
			$actions['viewcomments'] = sprintf('<a href="%1$s" target="_blank">View Comments</a>','?page='.$socialGallery_slugs['socialcomments'].'&sgiid='.$item['sg_iid']);
        
        return sprintf('%1$s %2$s %3$s',
            /*$1%s*/ $item['sg_idesc'],
            /*$2%s*/ $this->row_actions($actions),
			/*$3%s*/ '<input type="hidden" id="sgPerma'.$item['sg_iid'].'" value="'.$item['sg_iperma'].'" />'
					.'<input type="hidden" id="sgSrc'.$item['sg_iid'].'" value="'.$item['sg_isurl'].'" />' # Hidden data store. Lazy
        );
    }
	
    function column_sg_isurl($item){
                
        return sprintf('%1$s',
            /*$1%s*/ '<img src="'.$item['sg_isurl'].'" style="max-width:100px" alt="" align="left" />'
        );
    }
    
    function get_columns(){
        $columns = array(
            'sg_isurl'     => 'Image',
            'sg_idesc'     => 'Title',
            'sg_fbl'    => 'Facebook Likes',
            'sg_fbs'    => 'Facebook Shares',
            'sg_fbc'    => 'Facebook Comments',
            'sg_tw'    => 'Tweets',
            'sg_pins'    => 'Pins'
        );
        return $columns;
    }
    
    function get_sortable_columns() {
        $sortable_columns = array(
            'sg_fbl'     => array('sg_fbl',true),
            'sg_fbs'    => array('sg_fbs',false),
            'sg_fbc'  => array('sg_fbc',false),
            'sg_tw'  => array('sg_tw',false),
            'sg_pins'  => array('sg_pins',false)
        );
        return $sortable_columns;
    }
    
    function get_bulk_actions() {
        $actions = array(
            #'delete'    => 'Delete'
        );
        return $actions;
    }
	
    function process_bulk_action() {
        
        if( 'delete'===$this->current_action() ) {
            wp_die('Images deleted (or they would be if we had Images to delete)!');
        }
        
    }
	
    function prepare_items() {
		
        $per_page = 20;
		
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        
        $this->_column_headers = array($columns, $hidden, $sortable);
        
        $this->process_bulk_action();
        
        
        global $wpdb,$socialGallery_t;
		$sgsql = "SELECT * FROM " . $socialGallery_t['images']; 
		$data = $wpdb->get_results($sgsql);
		
		if (count($data) > 0){

			$data = socialGallery_wObjectToArray($data);
			
			function usort_reorder($a,$b){
				$orderby = (!empty($_REQUEST['orderby'])) ? $_REQUEST['orderby'] : 'sg_iid'; 
				$order = (!empty($_REQUEST['order'])) ? $_REQUEST['order'] : 'asc'; 
				$result = strcmp($a[$orderby], $b[$orderby]); 
				return ($order==='asc') ? $result : -$result; 
			}
			usort($data, 'usort_reorder');
			
		} else $data = array();
		
        $current_page = $this->get_pagenum();
		
        $total_items = count($data);
		
        $data = array_slice($data,(($current_page-1)*$per_page),$per_page);
		
        $this->items = $data;
		
        $this->set_pagination_args( array(
            'total_items' => $total_items,                 
            'per_page'    => $per_page,                     
            'total_pages' => ceil($total_items/$per_page) 
        ) );
    }
	
        function single_row( $item ) {
				global $iii;
                static $row_class = '';
                $row_class = ( $row_class == ' class="sgTr"' ? ' class="alternate sgTr"' : '' );
                echo '<tr' . $row_class . ' id="sgLine'.$iii.'">'; $iii++;
                echo $this->single_row_columns( $item );
                echo '</tr>';
        }
		
		
} global $iii;  $iii = 1;

function socialGallery_render_list_page(){
	
	global $socialGallery_slugs,$socialGallery_Settings,$wpdb,$socialGallery_t;
    $libraryListTable = new SocialGallery_List_table();
    $libraryListTable->prepare_items();
   
   		#} Normal Header.
		socialGallery_pagecomponents_header();
		
		#} Load Library?
		$normalLoad = true;
		
		#} Delete?	
		$delID = -1; if (isset($_GET['del'])) $delID = (int)$_GET['del']; if (isset($_POST['del'])) $delID = (int)$_POST['del'];
		if ($delID > 0){
			
			$image = $wpdb->get_row($wpdb->prepare("SELECT * FROM ".$socialGallery_t['images']." WHERE sg_iid = %d",$delID));
			
			if (isset($image->sg_iid)){
				
				if (!isset($_POST['sure'])){
				
				#} Show are you sure?
				?><div style="text-align:center;width:600px;"><h3 style="text-align:center">Delete Image</h3>
				<p style="text-align:center;width:600px;"><img src="<?php echo $image->sg_iurl; ?>" alt="Delete this image?" style="max-width:400px;margin-left:auto;margin-right:auto;" /><br/>
				<h4 style="text-align:center">Are you sure you want to delete this image?</h4>
				<button type="submit" onclick="javascript:window.location='<?php echo 'admin.php?page='.$socialGallery_slugs['imagelibrary']; ?>';">Cancel</button>&nbsp;&nbsp;&nbsp;<form method="post" style="display:inline"><input type="hidden" name="del" value="<?php echo $delID; ?>" /><input type="hidden" name="sure" value="yes" /><button type="submit">Yes, Delete it</button></form><br /><br />
				<strong>Note</strong>: Deleting images here just removes them from the Social Gallery Library, it doesn't remove them from the posts/galleries you have them in. This function is purely for removing images from the Social Gallery Library.</p></div>
				<?php $normalLoad = false;
				} else {
					
					#} Delete it
					$wpdb->query($wpdb->prepare("DELETE FROM ".$socialGallery_t['images']." WHERE sg_iid = %d",$delID));
					
					#} Show "deleted"
				?><div style="text-align:center;width:600px;"><h3 style="text-align:center">Image Deleted</h3>
				<p style="text-align:center;width:600px;">Your image has been removed from Social Gallery's library.<br /><a href="<?php echo 'admin.php?page='.$socialGallery_slugs['imagelibrary']; ?>">Back to Image Library</a></p>				
                </div>
				<?php $normalLoad = false;
				}
			}
			
		} 
		
		
		if ($normalLoad){
    
    ?>
   
        <p>Here you can see all of the images contained within the Social Gallery Image Library. Images you add to posts in the future will be automatically added to this library. You can manually check if this library is up to date on the Social Gallery <a href="?page=<?php echo $socialGallery_slugs['updateengine']; ?>">Update Engine</a> page.</p>
        <?php if ($socialGallery_Settings->get('useSGPages') != 1) echo socialGallery_html_msg(2,'<strong>Note:</strong> With Social Gallery Pages disabled the full benefits of the Image Library will not be available.'); ?>
        
        <form id="socialgallery-filter" method="get">        
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />        
            <?php $libraryListTable->display() ?>
        </form>
        
    <?php
	
		}
}

?>