<?php /*!
 * Social Gallery - The Ultimate WordPress Social Lightbox
 * http://www.socialgalleryplugin.com
 * V2.1
 *
 * Copyright 2012, Epic Plugins
 *
 * Date: 14/03/2012
 */	
	class SocialGallerySettings {
		
		#} Main settings storage
		private $settings;
		private $settingsKey = 'sgpsettings';
		private $settingsVer = 'v2.1//14.03.12';
		private $settingsDefault = array( #} Defaults
		
										'reg' => 					'1',	
										'selectorType' => 			1,	
										'selector' => 				'.socialGallery',	
										'bgColor' => 				'000000',	
										'bgOpacity' => 				0.8,	
										'bottomBar',				1,	
										'bottomBarTitleSource' => 	1,	
										'headerBox' => 				1,	
										'headerBoxType' => 			1,	
										'headerBoxHTML' => 			'',	
										'incDesc' => 				1,	
										'incTwit' => 				1,	
										'incFB' => 					1,	
										'incPin' => 				1,	
										'incFBComments' => 			1,	
										'incFBAppID',				'', 
										'incFBFaces',				1, 
										'incDisqusComments',		0,	
										'disqusShortName',			'',	
										'backAndForth' => 			1,	
										'incTwitSRC' => 			1,	
										'incFBSRC' => 				1,	
										'incPinSRC' => 				1,	
										'incHomeCall' => 			1,	
										'autoDisableNextGen',		1,	
										'incDLLink',				1,	
										'shareWithDevs',			1,	
										'incSwipe' => 				1,	
										
										#v2
										'incFullScreen' => 			1,	
										'socialSceneID' => 			0,	
										'lastSocialCrawl' =>		0,	
										'lastLibraryUpdateS' =>		0,	
										'lastLibraryUpdateF' =>		0,	
										'lastLibraryUpdateSF' =>	0,	
										'lastLibraryUpdateFF' =>	0,	
										'alwaysFullScreen' => 		0,	
										'upscaleFactor' =>	 		1.2,	
										'marginBounds' =>	 		0.1,	
										'discludeSelectors' => 		'',	
										'theme' => 					'classic',	
										'sgPageWidth' => 			0,	
										'sgPageSidebar' => 			1,	
										'sgPageNoIndex' => 			0,	
										'FBAdmins' => 				'',	
										'affUser' => 				'',	
										'fallbackUrlOption' => 		1,	
										'inEffect' => 				1,	
										'inEffectTime' => 			700,	
										'outEffect' => 				1,	
										'outEffectTime' => 			700,	
										'useDFP' => 				0,	
										'dfpHead' => 				'',	
										'dfpInline' => 				'',	
										'shareTumblr' =>			1,	
										'shareLinkedIn' =>			1,	
										'shareGooglePlus' =>		1,	
										'shareStumbleUpon' =>		1,	
										'sharedSettings' =>			0,	
										'hiddenMsgs' =>				array(),	
										'sgPageShareDeck' =>		1,	
										'sgPageComments' =>			1,	
										'useSGPages' =>				1,	
										'LastComCheck' =>			0,	
										'wizardStage' => 			0,	
										'wizardObject' => 			array(),	
										
										#} General moved in here
										'permasflushed' => 			0,
										
										#} V2.1
										'mob' => 					1,
										'tablet' => 				1,
										'addonMob' => 				0,
										'twvia' =>					'SocialGalleryWP',
										'customcss' => 				'',
										'enablemeta' => 			1,
										
										#} Add-ons
										'addon_SS_Delay' =>			2,
										'addon_SS_FB' => 			1,
										'addon_SS_Twit' => 			1,
										'addon_SS_Pin' => 			1,
										'addon_SS_Auto' => 			1,
										
										#} V2.2
										'useHeaderDownloads' => 	0,
										
										#} V3.0
										'useGoogleTracking' =>		0,
										'socialOverlay' =>			0,
										'oauth2_client_id'=>		'',
										'oauth2_client_secret'=>    '',
										'oauth2_redirect_uri' =>	'',
										'simple_api_key'      =>    '',
										'oauthtoken'		  =>	'',
										'googProfileID'		  =>	'',
										'sgFaceDetect'		  =>	 1,
										
										#} V3.1
										'licenseEpic'		  =>     '',
										'licenseVerified'	  =>     0,
										
										#} V3.3
										'jigOverlay'		  =>      1,
										'FBshare'			  =>	  1,

										#} V4.0
										'overrideGallery'	  =>	  1,
										'preloading'		  =>	  1
		);
		
		
		#} Constructor
		function SocialGallerySettings() {
			
			#} Load direct
			$this->loadFromDB();
			
			#} Fill any missing vars
			$this->validateAndUpdate();
			
			#} If empty it's first run so init from defaults
			if (empty($this->settings)) $this->initCreate();
			
		}
		
		#} Checks through defaults + existing and adds defaults where unset
		function validateAndUpdate(){
			$defaultsAdded = 0;
			foreach ($this->settingsDefault as $key => $val) 
				if (!isset($this->settings[$key])) {
					$this->settings[$key] = $val;
					$defaultsAdded++;
				}
			
			if ($defaultsAdded > 0) $this->saveToDB();
		}
		
		#} Initial Create
		function initCreate(){
			
			global $socialGallery_db_version, $socialGallery_version;
			
			#} Create + save initial from default
			$defaultOptions = $this->settingsDefault;
			$defaultOptions['headerImg'] = plugins_url('/i/def.jpg',__FILE__); #} Has to be set out of props
			$defaultOptions['settingsID'] = $this->settingsVer; #} Has to be set out of props
			$defaultOptions['db_version'] = $socialGallery_db_version; #} Has to be set out of props
			$defaultOptions['version'] = $socialGallery_version; #} Has to be set out of props
			$this->settings = $defaultOptions;
			$this->saveToDB();
			
		}
		
		#} Get all options as object
		function getAll(){
			
			return $this->settings;
			
		}
		
		#} Get single option
		function get($key){
			
			if (empty($key) === true) return false;
			
			if (isset($this->settings[$key]))
				return $this->settings[$key];
			else
				return false;
			
		}
		
		#} Add/Update *brutally
		function update($key,$val=''){
			
			if (empty($key) === true) return false;
			
			#} Don't even check existence as I guess it doesn't matter?
			$this->settings[$key] = $val;		
			
			#} Save down
			$this->saveToDB();
		}		
		
		#} Delete option
		function delete($key){
			
			if (empty($key) === true) return false;
			
			$newSettings = array();
			foreach($this->settings as $k => $v)
				if ($k != $key) $newSettings[$k] = $v;
				
			#} Brutal
			$this->settings = $newSettings;
						
		}
		
		#} Save back to db
		function saveToDB(){
		
			return update_option($this->settingsKey, $this->settings);				
			
		}
		
		#} Load/Reload from db 
		function loadFromDB(){
			
			$this->settings = get_option($this->settingsKey);
			return $this->settings;
			
		}		
		
		#} Uninstall func - effectively creates a bk then removes its main setting
		function uninstall(){
			
			#} Set uninstall flag
			$this->settings['uninstall'] = time();
			
			#} Backup
			$this->createBackup('Pre-UnInstall Backup');
			
			#} Blank it out
			$this->settings = NULL;
			
			#} Return the delete
			return delete_option($this->settingsKey);
			
		}
		
		#} Backup existing settings obj (ripped from sgv2.0)
		function createBackup($backupLabel=''){
			
			$existingBK = get_option($this->settingsKey.'_bk'); if (!is_array($existingBK)) $existingBK = array();
			$existingBK[time()] = $this->settings; 
			if (!empty($backupLabel)) $existingBK[time()]['backupLabel'] = sanitize_text_field($backupLabel); #} For named settings bk
			update_option($this->settingsKey.'_bk',$existingBK);
			return $existingBK[time()];
			
		}
		
		#} Kills all bks
		function killBackups(){
		
			return delete_option($this->settingsKey.'_bk');
			
		}
		
		#} Retrieve BKs
		function getBKs(){
			
			$x = get_option($this->settingsKey.'_bk');
			
			if (is_array($x)) return $x; else return array();
			
		}
		
		#} Reload from BK (bkkey will be a timestamp, use getBKs to list these keys)
		function reloadFromBK($bkkey){
		
			$backups = get_option($this->settingsKey.'_bk');
			
			if (isset($backups[$bkkey])) if (is_array($backups[$bkkey])) {
				
				#} kill existing settings and use backed up ones
				$this->settings = $backups[$bkkey];
				
				#} Save 
				$this->saveToDB();
			
				return true;	
				
			} 
			
			return false;
				
			
		}
		
		
		
	}
	
?>