<?php
/**
 * Social Gallery Image Template
 *
 * This template is used to display Social Gallery images singularly.
 * Depending on your theme it may be required that you edit this file
 * You may want to seek assistance for this on the Forums @ http://forum.socialgalleryplugin.com
 *
 * Note on Customisation: 
 *		
 *		If you want to edit this file please make a copy named "custom-single-social-gallery-image.php" and save it within this directory
 *
 * Copyright StormGate Ltd. 2012-2013
 */
 
 	global $thisSocialGalleryImage,$wpdb,$socialGallery_t,$socialGallery_Settings;
	
	if (count($thisSocialGalleryImage) == 1){
	
		#} Retrieve Image
		global $socialGalleryImage,$sgtitleOverride; $socialGalleryImage = $thisSocialGalleryImage[0];
		
		#} Retrieve Options
		$sgPageSidebar = $socialGallery_Settings->get('sgPageSidebar');	
		$sgPageWidth = $socialGallery_Settings->get('sgPageWidth');	
		
		#} Build Title
		$imageTitle = trim($socialGalleryImage->sg_ititle); if (empty($imageTitle) && !empty($socialGalleryImage->sg_idesc)) $imageTitle = $socialGalleryImage->sg_idesc;
		$blogName = get_bloginfo('name'); $sgtitleOverride = $imageTitle; # .' | '. $blogName;
		
		#} Discern URL
		$pageURL = socialGallery_permalinkedUrl($socialGalleryImage->sg_iperma);
		
		#} Headers
		add_action('wp_head', 'socialGallery_pagecomponents_customHeaders');

		#} Set Title
		add_filter( 'wp_title', 'socialGallery_pagecomponents_customTitle', 10, 3 );
	
		#} Calculate Appropriate Sizes
		if (isset($sgPageWidth)) $likeWidth = $sgPageWidth; else $likeWidth = 600;
		if (isset($sgPageWidth)) $imgMaxWidth = $sgPageWidth; else $imgMaxWidth = 600;
		if ($imgMaxWidth == 0) $imgMaxWidth = 600; if ($likeWidth == 0) $likeWidth = 600; $captionWidth = $imgMaxWidth; #defaults
			
		#} Image shortcode (for caption use) - only use if description and sizes present.
		// $imageStr = '<img src="'.$socialGalleryImage->sg_iurl.'" alt="" title="'.$socialGalleryImage->sg_idesc.'" style="max-width:'.$imgMaxWidth.'px" />';
		$src = $socialGalleryImage->sg_iurl;
?>
	


<?php

		#} Discern proper description
		if (isset($socialGalleryImage->sg_idesc)) 
			if ($socialGalleryImage->sg_idesc != $sgtitleOverride){ # Don't repeat the caption otherwise.
				if (!empty($socialGalleryImage->sg_idesc) && $socialGalleryImage->sg_idim != 'NULL')
				if (isset($sgPageWidth)) $captionWidth = $sgPageWidth-20;
					// $imageStr = do_shortcode('[caption width="'.$captionWidth.'" caption="'.$socialGalleryImage->sg_idesc.'"]'.$imageStr.'[/caption]');
			}
	

		#} Enhance the Appears in
		$tableA = $wpdb->posts;
		$imageID = $socialGalleryImage->sg_iid;
		$tableB = $socialGallery_t['imagelinks'];	
		$sql = "SELECT ID FROM $tableA LEFT OUTER JOIN $tableB ON ID = wp_postid WHERE sg_iid = $imageID AND post_status = 'publish' GROUP BY ID";
		$appearsIn = $wpdb->get_results($sql);
	
		# Required for any social gallery image page!
		global $socialGalleryCurrentPerma;	$socialGalleryCurrentPerma = $socialGalleryImage->sg_iperma;
		function socialGallery_define_currentPerm($socperma) {
			global $socialGalleryCurrentPerma;
			?><script type="text/javascript">var sgpcurrperm = '<?php echo $socialGalleryCurrentPerma; ?>';</script><?php
		}
		add_action('wp_head', 'socialGallery_define_currentPerm');
	
	
	
		#} Continue with page load.
		get_header(); ?>
                        
        
        	<div id="container">
        	   <div class="container">
        	   	<div class = "row">
        	   		<div class = "span8">
            
            <div id="primary" class="site-content">
            
				<div id="content" role="main">
                
					<div class="socialGalleryItem"<?php if (isset($sgPageWidth)) if (!empty($sgPageWidth)) echo ' style="width:'.$sgPageWidth.'px"'; ?>>
                        
                        <!-- Social Gallery Page Header -->
                        <header class="socialGallery-header">
                            <h1 class="socialGallery-title"><?php echo $sgtitleOverride; ?></h1>
                        </header>
    				
                        <!-- Social Gallery Page Image -->
                    	<div id="socialGalleryItemImage">
                        	<script>
		sgTaglink = '<?php echo get_permalink(); ?>';
	</script>


	<img class="alignnone size-full wp-image-157" src="<?php echo $src; ?>" title = "<?php echo $title; ?>" height = "<?php echo $height; ?>" width = "<?php echo $width; ?>"/>
         
         </div>                  
         
                                 <!-- Social Gallery Page "Appears In" -->
                    	<?php if (count($appearsIn) > 0){ ?>
                        <div id="socialGalleryItemAppearsIn">Appears in<?php if (count($appearsIn) > 1) echo 's'; ?>: <?php 
						
								$i = 0;						
								foreach ($appearsIn as $post){
									$title = get_the_title($post->ID);
									
									if ($i > 0) echo ', ';					
									echo '<a href="'.get_permalink($post->ID).'" title="'.$title.'">'.$title.'</a>';	
									
									$i++;
									
								}
	
						 ?></div>
                         <?php } ?>
                             
                        <!-- Social Gallery Page Share Options -->
                        <?php if ($socialGallery_Settings->get('sgPageShareDeck') == 1){ ?>
                        <div id="socialGalleryItemShareDeck">
                        
                            <div id="socialGalleryItemShareRows">
                            	<p><strong>Share This</strong></p>
                                <div id="stTopRow">
                                    <div id="sgTum"><a href="http://www.tumblr.com/share/photo?source=<?php echo urlencode(get_bloginfo('wpurl')) ?>&caption=<?php echo urlencode($sgtitleOverride) ?>&clickthru=<?php echo urlencode($pageURL) ?>" title="Share on Tumblr" target="_blank" style="display:inline-block; text-indent:-9999px; overflow:hidden; width:81px; height:20px; background:url('http://platform.tumblr.com/v1/share_1.png') top left no-repeat transparent;">Share on Tumblr</a></div>
                                    <div id="sgIN"><script type="IN/Share" data-url="<?php echo urlencode($pageURL) ?>" data-counter="right"></script></div>
                                    <div id="sgGoog"><div class="g-plusone" data-size="medium" data-annotation="bubble" href="<?php echo urlencode($pageURL) ?>"></div></div>
                                </div>
                                <div id="stBottomRow">
                                    <div id="sgTwi"><a href="https://twitter.com/share" class="twitter-share-button" data-via="SocialGalleryWP">Tweet</a></div>
                                    <div id="sgPin"><a href="http://pinterest.com/pin/create/button/?url=<?php echo $pageURL; ?>&media<?php echo $socialGalleryImage->sg_iurl; ?>=&description=<?php echo $sgtitleOverride; ?>" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a></div>
                                    <div id="sgSU"><div class="sbutton"><su:badge layout="1" location="<?php echo $pageURL; ?>"></su:badge></div></div>
                                </div>
	                            <div class="fb-like" data-send="true" data-width="200px" href="<?php echo $pageURL; ?>" data-show-faces="true" notify="true"></div>
                                
                            </div>
                            
                        </div>
                        <script type="text/javascript">if (typeof socialGallery_LoadSocial != "undefined") jQuery(document).ready(function(e) {socialGallery_LoadSocial()})</script>
                        <?php } ?>
                         
                        <!-- Social Gallery Page Comments -->
                        <?php if ($socialGallery_Settings->get('sgPageComments') == 1){ ?>
						 <div id="socialGalleryItemComments">
							 <div class="fb-comments fb_iframe_widget" data-num-posts="10" href="<?php echo $pageURL; ?>" data-width="<?php echo $likeWidth; ?>" fb-xfbml-state="rendered" notify="true"></div>
						 </div> 
                        <script type="text/javascript">if (typeof socialGallery_LoadComments != "undefined") jQuery(document).ready(function(e) {socialGallery_LoadComments('<?php echo $pageURL; ?>')})</script>
                        <?php } ?>
                        <?php if ($socialGallery_Settings->get('sgPageComments') == 2){ ?>
						 <div id="socialGalleryItemComments">
							 <div id="disqus_thread"></div>
						 </div> 
                        <script type="text/javascript">if (typeof socialGallery_LoadComments != "undefined") jQuery(document).ready(function(e) {socialGallery_LoadComments('<?php echo $pageURL; ?>','<?php echo $sgtitleOverride; ?>',1)})</script>
                        <?php } ?>
                         
                  </div><!-- #socialGalleryItem -->
			</div><!-- #content -->
		</div><!-- #container -->
		</div><!-- end span 9 -->
		<div class = "span4">
		<?php 	#} Close out the page
				if ($sgPageSidebar) get_sidebar();
		} ?>
		</div>
		</div>
		<?php 				get_footer(); ?>

