<?php
/*
  Plugin Name: Excel to LearnDash
  Description: This plugin will allow you to import quiz from MS Excel files.
  Version: 4.0
  Author: wppluginsforyou.com
  Author URI: https://www.wppluginsforyou.com/

 */
require_once "vendor/autoload.php";
include_once(dirname(dirname(__FILE__)) . "/sfwd-lms/includes/vendor/wp-pro-quiz/lib/helper/WpProQuiz_Helper_ImportXml.php");
include_once('Wpquizmodelmapper.php');
include_once('Wpquizmodelquestion.php');

/**  Define a Read Filter class implementing PHPExcel_Reader_IReadFilter  */
class MyReadFilter implements PHPExcel_Reader_IReadFilter {

    public function readCell($column, $row, $worksheetName = '') {
        //  Read rows 1 to 7 and columns A to E only
        if ($row >= 1 && $row <= 2100) {
            /* if (in_array($column,range('A','Z'))) {
              return true;
              } */
            if (in_array($column, createColumnsArray('BZ'))) {
                return true;
            }
        }
        return false;
    }

}

function createColumnsArray($end_column, $first_letters = '') {
    $columns = array();
    $length = strlen($end_column);
    $letters = range('A', 'Z');

    // Iterate over 26 letters.
    foreach ($letters as $letter) {
        // Paste the $first_letters before the next.
        $column = $first_letters . $letter;

        // Add the column to the final array.
        $columns[] = $column;

        // If it was the end column that was added, return the columns.
        if ($column == $end_column)
            return $columns;
    }

    // Add the column children.
    foreach ($columns as $column) {
        // Don't itterate if the $end_column was already set in a previous itteration.
        // Stop iterating if you've reached the maximum character length.
        if (!in_array($end_column, $columns) && strlen($column) < $length) {
            $new_columns = createColumnsArray($end_column, $column);
            // Merge the new columns which were created with the final columns array.
            $columns = array_merge($columns, $new_columns);
        }
    }

    return $columns;
}

function trimCharacters($str, $length = 175) {
    if(strlen($str) > $length){
        return (substr($str, 0, $length) . '...');
    }else{
        return $str;
    }
}

function my_var_export($str, $bool) {
    return trim(var_export($str, $bool), "'");
}

function getVideoIframeFromURL($string) {
    //This only return if URL is of Youtube
    $return = preg_replace(
            "/\s*[a-zA-Z\/\/:\.]*youtu(be.com\/watch\?v=|.be\/)([a-zA-Z0-9\-_]+)([a-zA-Z0-9\/\*\-\_\?\&\;\%\=\.]*)/i", "<iframe src=\"//www.youtube.com/embed/$2\" allowfullscreen></iframe>", $string
    );

    if ($return == $string) {
        return false;
    } else {
        return $return;
    }
}


class MT_WpProQuiz_ImportXls extends WpProQuiz_Helper_ImportXml {

    /**
     * @param SimpleXMLElement $xml
     * @return null|WpProQuiz_Model_Quiz
     */
    private function createQuizModelXls($xml) {
		
		 //print_r($xml);
		 print_r($xml->attributes()->answerType);
        $model = new WpProQuiz_Model_Quiz();
        $model->setName(trim($xml->title));
        $model->setText(trim($xml->text));
        $model->setTitleHidden($xml->title->attributes()->titleHidden == 'true');
        $model->setQuestionRandom($xml->questionRandom == 'true');
        $model->setAnswerRandom($xml->answerRandom == 'true');
        $model->setTimeLimit($xml->timeLimit);
        $model->setResultText($xml->resultText);
        $model->setResultGradeEnabled($xml->resultText);
        $model->setCategoryName(trim($xml->category));
		 
        if (isset($xml->resultText)) {
            $attr = $xml->resultText->attributes();

            if ($attr !== null) {
                $model->setResultGradeEnabled($attr->gradeEnabled == 'true');

                if ($model->isResultGradeEnabled()) {
                    $resultArray = array('text' => array(), 'prozent' => array());

                    foreach ($xml->resultText->text as $result) {
                        $resultArray['text'][] = trim((string) $result);
                        $resultArray['prozent'][] = $result->attributes() === null ? 0 : (int) $result->attributes()->prozent;
                    }

                    $model->setResultText($resultArray);
                } else {
                    $model->setResultText(trim((string) $xml->resultText));
                }
            }
        }

        $model->setShowPoints($xml->showPoints == 'true');
        $model->setBtnRestartQuizHidden($xml->btnRestartQuizHidden == 'true');
        $model->setBtnViewQuestionHidden($xml->btnViewQuestionHidden == 'true');
        $model->setNumberedAnswer($xml->numberedAnswer == 'true');
        $model->setHideAnswerMessageBox($xml->hideAnswerMessageBox == 'true');
        $model->setDisabledAnswerMark($xml->disabledAnswerMark == 'true');

        if (isset($xml->statistic)) {
            $attr = $xml->statistic->attributes();

            if ($attr !== null) {
                $model->setStatisticsOn($attr->activated == 'true');
                $model->setStatisticsIpLock($attr->ipLock);
            }
        }

        if (isset($xml->quizRunOnce)) {
            $model->setQuizRunOnce($xml->quizRunOnce == 'true');
            $attr = $xml->quizRunOnce->attributes();

            if ($attr !== null) {
                $model->setQuizRunOnceCookie($attr->cookie == 'true');
                $model->setQuizRunOnceType($attr->type);
                $model->setQuizRunOnceTime($attr->time);
            }
        }

        if (isset($xml->showMaxQuestion)) {
            $model->setShowMaxQuestion($xml->showMaxQuestion == 'true');
            $attr = $xml->showMaxQuestion->attributes();

            if ($attr !== null) {
                $model->setShowMaxQuestionValue($attr->showMaxQuestionValue);
                $model->setShowMaxQuestionPercent($attr->showMaxQuestionPercent == 'true');
            }
        }

        if (isset($xml->toplist)) {
			
            $model->setToplistActivated($xml->toplist->attributes()->activated == 'true');
            $model->setToplistDataAddPermissions($xml->toplist->toplistDataAddPermissions);
            $model->setToplistDataSort($xml->toplist->toplistDataSort);
            $model->setToplistDataAddMultiple($xml->toplist->toplistDataAddMultiple == 'true');
            $model->setToplistDataAddBlock($xml->toplist->toplistDataAddBlock);
            $model->setToplistDataShowLimit($xml->toplist->toplistDataShowLimit);
            $model->setToplistDataShowIn($xml->toplist->toplistDataShowIn);
            $model->setToplistDataCaptcha($xml->toplist->toplistDataCaptcha == 'true');
            $model->setToplistDataAddAutomatic($xml->toplist->toplistDataAddAutomatic == 'true');
        } 

        $model->setShowAverageResult($xml->showAverageResult == 'true');
        $model->setPrerequisite($xml->prerequisite == 'true');
        $model->setQuizModus($xml->quizModus);
        $model->setShowReviewQuestion($xml->showReviewQuestion == 'true');
        $model->setQuizSummaryHide($xml->quizSummaryHide == 'true');
        $model->setSkipQuestionDisabled($xml->skipQuestionDisabled == 'true');
        $model->setEmailNotification($xml->emailNotification);
        $model->setUserEmailNotification($xml->userEmailNotification == 'true');
        $model->setShowCategoryScore($xml->showCategoryScore == 'true');
        $model->setHideResultCorrectQuestion($xml->hideResultCorrectQuestion == 'true');
        $model->setHideResultQuizTime($xml->hideResultQuizTime == 'true');
        $model->setHideResultPoints($xml->hideResultPoints == 'true');
        $model->setAutostart($xml->autostart == 'true');
        $model->setForcingQuestionSolve($xml->forcingQuestionSolve == 'true');
        $model->setHideQuestionPositionOverview($xml->hideQuestionPositionOverview == 'true');
        $model->setHideQuestionNumbering($xml->hideQuestionNumbering == 'true');

        //0.27
        $model->setStartOnlyRegisteredUser($xml->startOnlyRegisteredUser == 'true');
        $model->setSortCategories($xml->sortCategories == 'true');
        $model->setShowCategory($xml->showCategory == 'true');

        if (isset($xml->quizModus)) {
            $attr = $xml->quizModus->attributes();

            if ($attr !== null) {
                $model->setQuestionsPerPage($attr->questionsPerPage);
            }
        }

        if (isset($xml->forms)) {
            $attr = $xml->forms->attributes();

            $model->setFormActivated($attr->activated == 'true');
            $model->setFormShowPosition($attr->position);
        }

        //0.29
        /* if (isset($xml->adminEmail)) {
          $adminEmail = new WpProQuiz_Model_Email();
          $adminEmail->setTo($xml->adminEmail->to);
          $adminEmail->setFrom($xml->adminEmail->form);
          $adminEmail->setSubject($xml->adminEmail->subject);
          $adminEmail->setHtml($xml->adminEmail->html == 'true');
          $adminEmail->setMessage($xml->adminEmail->message);

          $model->setAdminEmail($adminEmail);
          }

          if (isset($xml->userEmail)) {
          $userEmail = new WpProQuiz_Model_Email();
          $userEmail->setTo($xml->userEmail->to);
          $userEmail->setToUser($xml->userEmail->toUser == 'true');
          $userEmail->setToForm($xml->userEmail->toForm == 'true');
          $userEmail->setFrom($xml->userEmail->form);
          $userEmail->setSubject($xml->userEmail->subject);
          $userEmail->setHtml($xml->userEmail->html == 'true');
          $userEmail->setMessage($xml->userEmail->message);

          $model->setUserEmail($userEmail);
          } */

        //Check
        if ($model->getName() == '') {
            return null;
        }

        if ($model->getText() == '') {
            return null;
        }

        return $model;
    }

    /**
     *
     * @param DOMDocument $xml
     * @return NULL|WpProQuiz_Model_Question
     */
    private function createQuestionModelXml($xml) {
        $model = new WpProQuiz_Model_Question();
        $model->setTitle(trim($xml->title));
        $model->setQuestion(trim($xml->questionText));
        $model->setCorrectMsg(trim($xml->correctMsg));
        $model->setIncorrectMsg(trim($xml->incorrectMsg));
        $model->setAnswerType(trim($xml->attributes()->answerType));
        $model->setCorrectSameText($xml->correctSameText == 'true');

        $model->setTipMsg(trim($xml->tipMsg));

        if (isset($xml->tipMsg) && $xml->tipMsg->attributes() !== null) {
            $model->setTipEnabled($xml->tipMsg->attributes()->enabled == 'true');
        }

        $model->setPoints($xml->points);
        $model->setShowPointsInBox($xml->showPointsInBox == 'true');
        $model->setAnswerPointsActivated($xml->answerPointsActivated == 'true');
        $model->setAnswerPointsDiffModusActivated($xml->answerPointsDiffModusActivated == 'true');
        $model->setDisableCorrect($xml->disableCorrect == 'true');
        $model->setCategoryName(trim($xml->category));

        $answerData = array();

        if (isset($xml->answers)) {
            foreach ($xml->answers->answer as $answer) {
                $answerModel = new WpProQuiz_Model_AnswerTypes();

                $attr = $answer->attributes();

                if ($attr !== null) {
                    $answerModel->setCorrect($attr->correct == 'true');
                    $answerModel->setPoints($attr->points);
                }

                $answerModel->setAnswer(trim($answer->answerText));

                if ($answer->answerText->attributes() !== null) {
                    $answerModel->setHtml($answer->answerText->attributes()->html);
                }

                $answerModel->setSortString(trim($answer->stortText));

                if ($answer->stortText->attributes() !== null) {
                    $answerModel->setSortStringHtml($answer->stortText->attributes()->html);
                }

                $answerData[] = $answerModel;
            }
        }

        $model->setAnswerData($answerData);

        //Check
        if (trim($model->getAnswerType()) == '') {
            return null;
        }

        if (trim($model->getQuestion()) == '') {
            return null;
        }

        if (trim($model->getTitle()) == '') {
            return null;
        }

        if (count($model->getAnswerData()) == 0) {
            return null;
        }

        return $model;
    }

    /**
     * @param SimpleXMLElement $xml
     * @return WpProQuiz_Model_Form
     */
    private function createFormModelXls($xml) {
        $form = new WpProQuiz_Model_Form();

        $attr = $xml->attributes();

        if ($attr !== null) {
            $form->setType($attr->type);
            $form->setRequired($attr->required == 'true');
            $form->setFieldname($attr->fieldname);
        }

        if (isset($xml->formData)) {
            $d = array();

            foreach ($xml->formData as $data) {
                $v = trim((string) $data);

                if ($v !== '')
                    $d[] = $v;
            }

            $form->setData($d);
        }

        return $form;
    }

    public function getImportDataXls($quiz_xml) {
        $xml = @simplexml_load_string($quiz_xml, 'SimpleXMLElement', LIBXML_NOCDATA);
        $a = array('master' => array(), 'question' => array(), 'forms' => array());
        $i = 0;

        if ($xml === false) {
            $this->_error = __('XML could not be loaded.', 'wp-pro-quiz');
            return false;
        }

        if (isset($xml->data) && isset($xml->data->quiz)) {
            foreach ($xml->data->quiz as $quiz) {
                $quizModel = $this->createQuizModelXls($quiz);

                if ($quizModel !== null) {
                    $quizModel->setId($i++);

                    $a['master'][] = $quizModel;

                    if ($quiz->forms->form) {
                        foreach ($quiz->forms->form as $form) {
                            $a['forms'][$quizModel->getId()][] = $this->createFormModel($form);
                        }
                    }

                    if (isset($quiz->questions)) {
                        foreach ($quiz->questions->question as $question) {
                            $questionModel = $this->createQuestionModelXml($question);

                            if ($questionModel !== null)
                                $a['question'][$quizModel->getId()][] = $questionModel;
                        }
                    }
                }
            }
        }

        return $a;
    }

    public function saveImportXls($ids, $quiz_xml) {
		
		
		
		//return 'haai';
        $quizMapper = new Wpquizmodelmapper();
        $questionMapper = new Wpquizmodelquestion();
        $categoryMapper = new WpProQuiz_Model_CategoryMapper();
        $formMapper = new WpProQuiz_Model_FormMapper();

        $data = $this->getImportDataXls($quiz_xml);
        $categoryArray = $categoryMapper->getCategoryArrayForImport();
        //print_r($data);
        foreach ($data['master'] as $quiz) {
            if (get_class($quiz) !== 'WpProQuiz_Model_Quiz')
                continue;

            $oldId = $quiz->getId();

            if ($ids !== false && !in_array($oldId, $ids))
                continue;

            $quiz->setId(0);
			/* foreach ($data['question'][$oldId] as $question) {
			$title=$question->getTitle();
			} */
            $quizMapper->save_model_quiz($quiz);
           $name=$quiz->getName();
		   //print_r($quiz);
		   
            $user_id = get_current_user_id();
			global $wpdb;
			
		
		
		  $datum =  $wpdb->get_results("SELECT * FROM ". $wpdb->prefix ."posts WHERE post_title = '".$name."'");
		    if(count($datum)  == 0) {
            $quiz_post_id = wp_insert_post(array('post_title' =>$name /* $quiz->getName() */, 'post_type' => 'sfwd-quiz', 'post_status' => 'publish', 'post_author' => $user_id));
            learndash_update_setting($quiz_post_id, "quiz_pro", $quiz->getId()); 
			}
			  else{
				 $chk =  $wpdb->get_results("SELECT * FROM ". $wpdb->prefix ."posts WHERE post_title = '".$name."' AND post_status ='publish' order by ID asc limit 1",ARRAY_A);
				 
				 if(!$chk){
					$wpdb->query("UPDATE ". $wpdb->prefix ."posts SET post_status='publish' WHERE post_title = '".$name."' AND post_status !='publish' order by id asc limit 1"); 
				 } 
				 
			} 
            if (isset($data['forms']) && isset($data['forms'][$oldId])) {
                $sort = 0;

                foreach ($data['forms'][$oldId] as $form) {
                    $form->setQuizId($quiz->getId());
                    $form->setSort($sort++);
                }

                $formMapper->update($data['forms'][$oldId]);
            }

            $sort = 0;
            if (is_array($data['question'][$oldId]) && count($data['question'][$oldId]) > 0) {
                foreach ($data['question'][$oldId] as $question) {

                    if (get_class($question) !== 'WpProQuiz_Model_Question')
                        continue;

                    $question->setQuizId($quiz->getId());
                    $question->setId(0);
                    $question->setSort($sort++);
                    $question->setCategoryId(0);
                    if (trim($question->getCategoryName()) != '') {
                        if (isset($categoryArray[strtolower($question->getCategoryName())])) {
                            $question->setCategoryId($categoryArray[strtolower($question->getCategoryName())]);
                        } else {
                            $categoryModel = new WpProQuiz_Model_Category();
                            $categoryModel->setCategoryName($question->getCategoryName());
                            $categoryMapper->save($categoryModel);

                            $question->setCategoryId($categoryModel->getCategoryId());

                            $categoryArray[strtolower($question->getCategoryName())] = $categoryModel->getCategoryId();
                        }
                    }
                        
                    $questionMapper->save($question,$auto=false,$name);
					
					
					
                }
            }
        }

        return true;
    } 

}

class MT_WP_Pro_Quiz_Import {

    public function __construct() {
        add_action('admin_menu', array($this, 'mtpqi_menu'));
    }

    function mtpqi_quiz_import_page() {
        ?>
        <div class="wrap">
            <?php echo "<h2>" . __('Import LearnDash', 'mtpqi_import_options') . "</h2>"; ?>
            <h4><i>Please choose MS Excel or CSV file to import.</i></h4>
            <?php
            if ($_POST['mtpqi_import_hidden'] == 'Y') {
				$file_info = pathinfo($_FILES['mtpqi_import']['name']);
                if (strtolower($file_info['extension']) == 'csv') {
                    $csv_file = $_FILES["mtpqi_import"]["tmp_name"];
                    include_once(dirname(__FILE__) . '/PHPExcel/IOFactory.php');
                    $objReader = PHPExcel_IOFactory::createReader('CSV');
                    // If the files uses a delimiter other than a comma (e.g. a tab), then tell the reader
                    $objReader->setDelimiter(",");
                    // If the files uses an encoding other than UTF-8 or ASCII, then tell the reader
                    $objReader->setInputEncoding('ASCII');

                    $inputFileName = dirname(__FILE__) . "/temp/" . $file_info['filename'] . '.xlsx';
                    $objPHPExcel = $objReader->load($csv_file);
                    $objPHPExcel->getActiveSheet()->setTitle("Sheet1");
                    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                    $objWriter->save($inputFileName);
                    $_FILES["mtpqi_import"]["name"] = $file_info['filename'] . '.xlsx';
                } else {
                    $inputFileName = dirname(__FILE__) . "/temp/" . $_FILES["mtpqi_import"]["name"];
                    move_uploaded_file($_FILES["mtpqi_import"]["tmp_name"], $inputFileName);
                }
                /** automatically detect the correct reader to load for this file type */
                $objReader = PHPExcel_IOFactory::createReaderForFile($inputFileName);
                $sheetnames = array('Sheet1');
                $objReader->setLoadSheetsOnly($sheetnames);
                $objPHPExcel = $objReader->load($inputFileName);
                $objReader->setReadDataOnly();
                /**  Create an Instance of our Read Filter  * */
                $filterSubset = new MyReadFilter();
                /**  Tell the Reader that we want to use the Read Filter  * */
                $objReader->setReadFilter($filterSubset);
                /**  Load only the rows and columns that match our filter to PHPExcel  * */
                $objPHPExcel = $objReader->load($inputFileName);
                $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);

                //get all sheet names from the file
                $worksheetNames = $objPHPExcel->getSheetNames($inputFileName);

                $return = array();
                foreach ($worksheetNames as $key => $sheetName) {
                    //set the current active worksheet by name
                    $objPHPExcel->setActiveSheetIndexByName($sheetName);

                    //echo "<pre>";print_r($objPHPExcel->getActiveSheet());exit;
                    $objPHPExcel->getActiveSheet();
                    //create an assoc array with the sheet name as key and the sheet contents array as value
                    $return[$sheetName] = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                }
                $quiz_array = array();
                //echo "<pre>";print_r($return["Sheet1"]);exit;
                foreach ($return["Sheet1"] as $key => $value) {
                    if ($key != 1) {
                        if ($value['A'] == 'matrix_sort_answer') {
                            
                            if ($value["A"]) {
							    $answer_option_type = $value['A'];
                                $quiz_array[$key]["ans_type"] .= $value["A"];
                            }
                            if ($value["B"]) {
                                $img_url = $value["B"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["B"] . "'>";
                                } else {
                                    $quiz_array[$key]["ques"] .= $value["B"];
                                }
                            }
                            if ($value["C"]) {
                                $img_url = $value["C"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["C"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt1"] .= $value["C"];
                                }
                            }
                            if ($value["D"]) {
                                $img_url = $value["D"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort1"] .= "<img src='" . $value["D"] . "'>";
                                } else {
                                    $quiz_array[$key]["sort1"] .= $value["D"];
                                }
                            }
                            if ($value["E"]) {
                                $img_url = $value["E"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt2"] .= "<img src='" . $value["E"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt2"] .= $value["E"];
                                }
                            }
                            if ($value["F"]) {
                                $img_url = $value["F"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort2"] .= "<img src='" . $value["F"] . "'>";
                                } else {
                                    $quiz_array[$key]["sort2"] .= $value["F"];
                                }
                            }
                            if ($value["G"]) {
                                $img_url = $value["G"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt3"] .= "<img src='" . $value["G"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt3"] .= $value["G"];
                                }
                            }
                            if ($value["H"]) {
                                $img_url = $value["H"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort3"] .= "<img src='" . $value["H"] . "'>";
                                } else {
                                    $quiz_array[$key]["sort3"] .= $value["H"];
                                }
                            }
                            if ($value["I"]) {
                                $img_url = $value["I"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt4"] .= "<img src='" . $value["I"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt4"] .= $value["I"];
                                }
                            }
                            if ($value["J"]) {
                                $img_url = $value["J"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort4"] .= "<img src='" . $value["J"] . "'>";
                                } else {
                                    $quiz_array[$key]["sort4"] .= $value["J"];
                                }
                            }
                            if ($value["K"]) {
                                $img_url = $value["K"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt5"] .= "<img src='" . $value["K"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt5"] .= $value["K"];
                                }
                            }
                            if ($value["L"]) {
                                $img_url = $value["L"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort5"] .= "<img src='" . $value["L"] . "'>";
                                } else {
                                    $quiz_array[$key]["sort5"] .= $value["L"];
                                }
                            }
                            if ($value["M"]) {
                                $img_url = $value["M"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["M"] . "'>";
                                } else {
                                    $quiz_array[$key]["ans"] .= $value["M"];
                                }
                            }
                            if ($value["N"]) {
                                $img_url = $value["N"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["detail"] .= "<img src='" . $value["N"] . "'>";
                                } else {
                                    $quiz_array[$key]["detail"] .= $value["N"];
                                }
                            }
                            if ($value["O"]) {
                                $img_url = $value["O"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["incorrectD"] .= "<img src='" . $value["O"] . "'>";
                                } else {
                                    $quiz_array[$key]["incorrectD"] .= $value["O"];
                                }
                            }
                            if ($value["P"]) {
                                $img_url = $value["P"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["Hint"] .= "<img src='" . $value["P"] . "'>";
                                } else {
                                    $quiz_array[$key]["Hint"] .= $value["P"];
                                }
                            }
                            if ($value["Q"]) {
                                $img_url = $value["Q"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["Q"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["Q"]);
                                    $quiz_array[$key]["ques"] .= ($video_iframe) ? $video_iframe : $value["Q"];
                                    //$quiz_array[$key]["ques"] .= $value["Q"];
                                }
                            }
                            if ($value["R"]) {
                                $img_url = $value["R"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["R"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["R"]);
                                    $quiz_array[$key]["opt1"] .= ($video_iframe) ? $video_iframe : $value["R"];
                                    //$quiz_array[$key]["opt1"] .= $value["R"];
                                }
                            }
                            if ($value["S"]) {
                                $img_url = $value["S"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort1"] .= "<img src='" . $value["S"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["S"]);
                                    $quiz_array[$key]["sort1"] .= ($video_iframe) ? $video_iframe : $value["S"];
                                    //$quiz_array[$key]["sort1"] .= $value["S"];
                                }
                            }
                            if ($value["T"]) {
                                $img_url = $value["T"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt2"] .= "<img src='" . $value["T"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["T"]);
                                    $quiz_array[$key]["opt2"] .= ($video_iframe) ? $video_iframe : $value["T"];
                                    //$quiz_array[$key]["opt2"] .= $value["T"];
                                }
                            }
                            if ($value["U"]) {
                                $img_url = $value["U"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort2"] .= "<img src='" . $value["U"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["U"]);
                                    $quiz_array[$key]["sort2"] .= ($video_iframe) ? $video_iframe : $value["U"];
                                    //$quiz_array[$key]["sort2"] .= $value["U"];
                                }
                            }
                            if ($value["V"]) {
                                $img_url = $value["V"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt3"] .= "<img src='" . $value["V"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["V"]);
                                    $quiz_array[$key]["opt3"] .= ($video_iframe) ? $video_iframe : $value["V"];
                                    //$quiz_array[$key]["opt3"] .= $value["V"];
                                }
                            }
                            if ($value["W"]) {
                                $img_url = $value["W"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort3"] .= "<img src='" . $value["W"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["W"]);
                                    $quiz_array[$key]["sort3"] .= ($video_iframe) ? $video_iframe : $value["W"];
                                    //$quiz_array[$key]["sort3"] .= $value["W"];
                                }
                            }
                            if ($value["X"]) {
                                $img_url = $value["X"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt4"] .= "<img src='" . $value["X"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["X"]);
                                    $quiz_array[$key]["opt4"] .= ($video_iframe) ? $video_iframe : $value["X"];
                                    //$quiz_array[$key]["opt4"] .= $value["X"];
                                }
                            }
                            if ($value["Y"]) {
                                $img_url = $value["Y"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort4"] .= "<img src='" . $value["Y"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["Y"]);
                                    $quiz_array[$key]["sort4"] .= ($video_iframe) ? $video_iframe : $value["Y"];
                                    //$quiz_array[$key]["sort4"] .= $value["Y"];
                                }
                            }
                            if ($value["Z"]) {
                                $img_url = $value["Z"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt5"] .= "<img src='" . $value["Z"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["Z"]);
                                    $quiz_array[$key]["opt5"] .= ($video_iframe) ? $video_iframe : $value["Z"];
                                    //$quiz_array[$key]["opt5"] .= $value["Z"];
                                }
                            }
                            if ($value["AA"]) {
                                $img_url = $value["AA"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["sort5"] .= "<img src='" . $value["AA"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["AA"]);
                                    $quiz_array[$key]["sort5"] .= ($video_iframe) ? $video_iframe : $value["AA"];
                                    //$quiz_array[$key]["sort5"] .= $value["AA"];
                                }
                            }
                            if ($value["AB"]) {
                                $img_url = $value["AB"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["AB"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["AB"]);
                                    $quiz_array[$key]["ans"] .= ($video_iframe) ? $video_iframe : $value["AB"];
                                    //$quiz_array[$key]["ans"] .= $value["AB"];
                                }
                            }
                            if ($value["AC"]) {
                                $quiz_array[$key]["cat"] .= $value["AC"];
                            }
                            if ($value["AD"]) {
                                $quiz_array[$key]["title"] .= $value["AD"];
                            }
                            if ($value["AE"]) {
                                $quiz_array[$key]["quiz_name"] .= $value["AE"];
                            }
                        } else if ($value["A"] == 'free_answer') {
                            
                            if ($value["A"]) {
								$answer_option_type = $value['A'];
                                $quiz_array[$key]["ans_type"] .= $value["A"];
                            }
                            if ($value["B"]) {
                                $img_url = $value["B"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["B"] . "'>";
                                } else {
                                    $quiz_array[$key]["ques"] .= $value["B"];
                                }
                            }
                            if ($value["C"]) {
                                $img_url = $value["C"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["C"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt1"] .= $value["C"];
                                }
                            }
                            if ($value["D"]) {
                                $img_url = $value["D"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["D"] . "'>";
                                } else {
                                    $quiz_array[$key]["ans"] .= $value["D"];
                                }
                            }
                            if ($value["E"]) {
                                $img_url = $value["E"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["detail"] .= "<img src='" . $value["E"] . "'>";
                                } else {
                                    $quiz_array[$key]["detail"] .= $value["E"];
                                }
                            }
                            if ($value["F"]) {
                                $img_url = $value["F"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["incorrectD"] .= "<img src='" . $value["F"] . "'>";
                                } else {
                                    $quiz_array[$key]["incorrectD"] .= $value["F"];
                                }
                            }
                            if ($value["G"]) {
                                $img_url = $value["G"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["Hint"] .= "<img src='" . $value["G"] . "'>";
                                } else {
                                    $quiz_array[$key]["Hint"] .= $value["G"];
                                }
                            }
                            if ($value["H"]) {
                                $img_url = $value["H"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["H"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["H"]);
                                    $quiz_array[$key]["ques"] .= ($video_iframe) ? $video_iframe : $value["H"];
                                    //$quiz_array[$key]["ques"] .= $value["H"];
                                }
                            }
                            /* if($value["I"])
                              {
                              $img_url = $value["I"];
                              $img_formats = array("png", "jpg", "jpeg", "gif", "tiff");//Etc. . .
                              $path_info = pathinfo($img_url);
                              if (in_array(strtolower($path_info['extension']), $img_formats)) {
                              $quiz_array[$key]["opt1"] .= "<img src='".$value["I"]."'>";
                              }
                              else
                              {
                              $quiz_array[$key]["opt1"] .= $value["I"];
                              }
                              } */
                            if ($value["I"]) {
                                $img_url = $value["I"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["I"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["I"]);
                                    $quiz_array[$key]["ans"] .= ($video_iframe) ? $video_iframe : $value["I"];
                                    //$quiz_array[$key]["ans"] .= $value["I"];
                                }
                            }
                            if ($value["J"]) {
                                $quiz_array[$key]["cat"] .= $value["J"];
                            }
                            if ($value["K"]) {
                                $quiz_array[$key]["title"] .= $value["K"];
                            }
                            if ($value["L"]) {
                                $quiz_array[$key]["points"] .= $value["L"];
                            }
                            if ($value["M"]) {
                                $quiz_array[$key]["quiz_name"] .= $value["M"];
                            }
                        } else if ($value["A"] == 'cloze_answer' || $value["A"] == 'assessment_answer') {
                            
                            if ($value["A"]) {
								$answer_option_type = $value['A'];
                                $quiz_array[$key]["ans_type"] .= $value["A"];
                            }
                            if ($value["B"]) {
                                $img_url = $value["B"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["B"] . "'>";
                                } else {
                                    $quiz_array[$key]["ques"] .= $value["B"];
                                }
                            }
                            if ($value["C"]) {
                                $img_url = $value["C"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["C"] . "'>";
                                } else {
                                    $quiz_array[$key]["opt1"] .= $value["C"];
                                }
                            }
                            if ($value["D"]) {
                                $img_url = $value["D"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["D"] . "'>";
                                } else {
                                    $quiz_array[$key]["ans"] .= $value["D"];
                                }
                            }
                            if ($value["E"]) {
                                $img_url = $value["E"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["detail"] .= "<img src='" . $value["E"] . "'>";
                                } else {
                                    $quiz_array[$key]["detail"] .= $value["E"];
                                }
                            }
                            if ($value["F"]) {
                                $img_url = $value["F"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["incorrectD"] .= "<img src='" . $value["F"] . "'>";
                                } else {
                                    $quiz_array[$key]["incorrectD"] .= $value["F"];
                                }
                            }
                            if ($value["G"]) {
                                $img_url = $value["G"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["Hint"] .= "<img src='" . $value["G"] . "'>";
                                } else {
                                    $quiz_array[$key]["Hint"] .= $value["G"];
                                }
                            }
                            if ($value["H"]) {
                                $img_url = $value["H"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["H"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["H"]);
                                    $quiz_array[$key]["ques"] .= ($video_iframe) ? $video_iframe : $value["H"];
                                    //$quiz_array[$key]["ques"] .= $value["H"];
                                }
                            }
                            if ($value["I"]) {
                                $img_url = $value["I"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["I"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["I"]);
                                    $quiz_array[$key]["opt1"] .= ($video_iframe) ? $video_iframe : $value["I"];
                                    //$quiz_array[$key]["opt1"] .= $value["I"];
                                }
                            }
                            if ($value["J"]) {
                                $img_url = $value["J"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["J"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["J"]);
                                    $quiz_array[$key]["ans"] .= ($video_iframe) ? $video_iframe : $value["J"];
                                    //$quiz_array[$key]["ans"] .= $value["J"];
                                }
                            }
                            if ($value["K"]) {
                                $quiz_array[$key]["cat"] .= $value["K"];
                            }
                            if ($value["L"]) {
                                $quiz_array[$key]["answerpointsactivatedval"] .= $value["L"];
                            }
                            if ($value["M"]) {
                                $quiz_array[$key]["showpointinboxval"] .= $value["M"];
                            }
                            if ($value["N"]) {
                                $quiz_array[$key]["title"] .= $value["N"];
                            }
                            if ($value["O"]) {
                                $quiz_array[$key]["quiz_name"] .= $value["O"];
                            }
                        } else {
                            
                            if ($value["A"]) {
								$answer_option_type = $value['A'];
                                $quiz_array[$key]["ans_type"] .= $value["A"];
                            }
                            if ($value["B"]) {
                                $img_url = $value["B"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["B"] . "'>";
                                } else {
                                    $quiz_array[$key]["ques"] .= $value["B"];
                                }
                            }
                            if ($value["C"]) {
                                $img_url = $value["C"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["C"] . "'>";
                                } else {
                                    $string = my_var_export($value["C"], true);
                                    $quiz_array[$key]["opt1"] .= $string;
                                }
                            }
                            if ($value["D"]) {
                                $img_url = $value["D"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt2"] .= "<img src='" . $value["D"] . "'>";
                                } else {
                                    $string = my_var_export($value["D"], true);
                                    $quiz_array[$key]["opt2"] .= $string;
                                }
                            }
                            if ($value["E"]) {
                                $img_url = $value["E"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt3"] .= "<img src='" . $value["E"] . "'>";
                                } else {
                                    $string = my_var_export($value["E"], true);
                                    $quiz_array[$key]["opt3"] .= $string;
                                }
                            }
                            if ($value["F"]) {
                                $img_url = $value["F"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt4"] .= "<img src='" . $value["F"] . "'>";
                                } else {
                                    $string = my_var_export($value["F"], true);
                                    $quiz_array[$key]["opt4"] .= $string;
                                }
                            }
                            if ($value["G"]) {
                                $img_url = $value["G"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt5"] .= "<img src='" . $value["G"] . "'>";
                                } else {
                                    $string = my_var_export($value["G"], true);
                                    $quiz_array[$key]["opt5"] .= $string;
                                }
                            }
                            if ($value["H"]) {
                                $img_url = $value["H"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ans"] .= "<img src='" . $value["H"] . "'>";
                                } else {
                                    $quiz_array[$key]["ans"] .= $value["H"];
                                }
                            }
                            if ($value["I"]) {
                                $img_url = $value["I"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["detail"] .= "<img src='" . $value["I"] . "'>";
                                } else {
                                    $quiz_array[$key]["detail"] .= $value["I"];
                                }
                            }
                            if ($value["J"]) {
                                $img_url = $value["J"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["incorrectD"] .= "<img src='" . $value["J"] . "'>";
                                } else {
                                    $quiz_array[$key]["incorrectD"] .= $value["J"];
                                }
                            }
                            if ($value["K"]) {
                                $img_url = $value["K"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["Hint"] .= "<img src='" . $value["K"] . "'>";
                                } else {
                                    $quiz_array[$key]["Hint"] .= $value["K"];
                                }
                            }
                            if ($value["L"]) {
                                $img_url = $value["L"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["ques"] .= "<img src='" . $value["L"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["L"]);
                                    $quiz_array[$key]["ques"] .= ($video_iframe) ? $video_iframe : $value["L"];
                                    //$quiz_array[$key]["ques"] .= $value["L"];
                                }
                            }
                            if ($value["M"]) {
                                $img_url = $value["M"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt1"] .= "<img src='" . $value["M"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["M"]);
                                    $quiz_array[$key]["opt1"] .= ($video_iframe) ? $video_iframe : $value["M"];
                                    //$quiz_array[$key]["opt1"] .= $value["M"];
                                }
                            }
                            if ($value["N"]) {
                                $img_url = $value["N"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt2"] .= "<img src='" . $value["N"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["N"]);
                                    $quiz_array[$key]["opt2"] .= ($video_iframe) ? $video_iframe : $value["N"];
                                    //$quiz_array[$key]["opt2"] .= $value["N"];
                                }
                            }
                            if ($value["O"]) {
                                $img_url = $value["O"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt3"] .= "<img src='" . $value["O"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["O"]);
                                    $quiz_array[$key]["opt3"] .= ($video_iframe) ? $video_iframe : $value["O"];
                                    //$quiz_array[$key]["opt3"] .= $value["O"];
                                }
                            }
                            if ($value["P"]) {
                                $img_url = $value["P"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt4"] .= "<img src='" . $value["P"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["P"]);
                                    $quiz_array[$key]["opt4"] .= ($video_iframe) ? $video_iframe : $value["P"];
                                    //$quiz_array[$key]["opt4"] .= $value["P"];
                                }
                            }
                            if ($value["Q"]) {
                                $img_url = $value["Q"];
                                $img_formats = array("png", "jpg", "jpeg", "gif", "tiff"); //Etc. . . 
                                $path_info = pathinfo($img_url);
                                if (in_array(strtolower($path_info['extension']), $img_formats)) {
                                    $quiz_array[$key]["opt5"] .= "<img src='" . $value["Q"] . "'>";
                                } else {
                                    $video_iframe = getVideoIframeFromURL($value["Q"]);
                                    $quiz_array[$key]["opt5"] .= ($video_iframe) ? $video_iframe : $value["Q"];
                                    //$quiz_array[$key]["opt5"] .= $value["Q"];
                                }
                            }
                            if ($value["R"]) {
                                $quiz_array[$key]["points"] .= $value["R"];
                            }
                            if ($value["S"]) {
                                $quiz_array[$key]["cat"] .= $value["S"];
                            }
                            if ($value["T"]) {
                                $quiz_array[$key]["title"] .= $value["T"];
                            }
                            if ($value["U"]) {
                                $quiz_array[$key]["quiz_name"] .= $value["U"];
                            }
                        }
                    }
                }
                      
                //echo "<pre>";print_r($quiz_array);exit;
                if ($answer_option_type == 'single' || $answer_option_type == 'multiple'  || $answer_option_type == 'free_answer' || $answer_option_type == 'cloze_answer'|| $answer_option_type == 'assessment_answer' || $answer_option_type == 'sort_answer' ) {
                    $result = array();
                    foreach ($quiz_array as $row) {
                        $index = $row['quiz_name'];
                        $result[$index][] = $row;
                    }
                    //echo "<pre>";print_r($result);exit;

                    foreach ($result as $row) {
                        //echo "<pre>";print_r($row[0][quiz_name]);
                        //echo "<pre>";print_r($row);exit;
                        $quiz_array = $row;
						//$xml = simplexml_load_file(dirname(__FILE__) . '/WpProQuiz_sample.xml');
                        $xmlString = file_get_contents(dirname(__FILE__) . '/WpProQuiz_sample.xml');
                        $xml = simplexml_load_string($xmlString);
						$quiz_title = pathinfo($_FILES["mtpqi_import"]["name"], PATHINFO_FILENAME);
                        $xml->data[0]->quiz[0]->title = trimCharacters($row[0]['quiz_name']);
                        $questions = $xml->data->quiz->questions;




                        $options_match = array(1 => 'a', 2 => 'b', 3 => 'c', 4 => 'd', 5 => 'e');
                        foreach ($quiz_array as $key => $ques_array) {
                            /* foreach($ques_array as $ques_array)
                              {

                              } */



                            //if($answer_option_type =='multiple')
                            if ($ques_array['ans_type'] == 'multiple') {



                                $someArray = explode("|", $ques_array['ans']);
                                $tempArray = array();

                                foreach ($someArray as $key => $value) {
                                    $tempArray[$key + 1] = $value;
                                }
                                $multi_ans_val = $tempArray;
                            }
                            $new_question = $questions->addChild('question');
                            //$new_question->addAttribute('answerType', 'single');
                            //$new_question->addAttribute('answerType', 'multiple');
                            //$new_question->addAttribute('answerType', 'free_answer');
                            //$new_question->addAttribute('answerType', 'sort_answer');
                            //$new_question->addAttribute('answerType', 'matrix_sort_answer');
                            $new_question->addAttribute('answerType', $ques_array['ans_type']);
                            //$new_question->addAttribute('answerType', 'cloze_answer');
                            //$new_question->addAttribute('answerType', 'assessment_answer');
							$new_question->addChild('title', trimCharacters($ques_array['title']));

                            $new_question->addChild('showPointsInBox', 'false');
                            $new_question->addChild('answerPointsActivated', 'false');
                            if ($ques_array['points'] != "") {
                                $new_question->addChild('points', $ques_array['points']);
                            } else {
                                $new_question->addChild('points', 1);
                            }




                            //$new_question->addChild('points', 1);
                            $new_question->addChild('questionText', $ques_array['ques']);
                            $new_question->addChild('correctMsg', $ques_array['detail']);
                            $new_question->addChild('incorrectMsg', $ques_array['incorrectD']);
                            $tipMsg = $new_question->addChild('tipMsg', $ques_array['Hint']);
                            if ($ques_array['Hint']) {
                                $tipMsg->addAttribute('enabled', 'true');
                            } else {
                                $tipMsg->addAttribute('enabled', 'false');
                            }
                            $new_question->addChild('category', $ques_array['cat']);
                            $new_question->addChild('correctSameText', 'false');

                            $new_question->addChild('answerPointsDiffModusActivated', 'false');
                            $new_question->addChild('disableCorrect', 'false');
                            $answers = $new_question->addChild('answers');
                            for ($opt = 1; $opt <= 5; $opt++) {
                                //echo $ques_array['ans_type'][$opt];

                                $answer = $answers->addChild('answer');
                                if ($ques_array['points'] != "") {

                                    $answer->addAttribute('points', $ques_array['points']);
                                } else {
                                    $answer->addAttribute('points', 1);
                                }


                                if ($ques_array['ans_type'] == 'multiple') {
                                    if ($options_match[$opt] == strtolower($multi_ans_val[$opt])) {
                                        $answer->addAttribute('correct', 'true');
                                    } else {
                                        $answer->addAttribute('correct', 'false');
                                    }
                                } else {
                                    if ($options_match[$opt] == strtolower($ques_array['ans'])) {
                                        $answer->addAttribute('correct', 'true');
                                    } else {
                                        $answer->addAttribute('correct', 'false');
                                    }
                                }
                                $answerText = $answer->addChild('answerText', $ques_array['opt' . $opt]);
                                $answerText->addAttribute('html', 'false');

                                $stortText = $answer->addChild('stortText');


                                $stortText->addAttribute('html', 'false');
                            }
                        }
                        //exit;
                        $quiz_xml = $xml->asXML();
                        $ids = array(0 => 0);
                        $quizMapperXls = new MT_WpProQuiz_ImportXls($quiz_xml);
                        $success = $quizMapperXls->saveImportXls($ids, $quiz_xml);
                    }
                } else {
					//$xml = simplexml_load_file(dirname(__FILE__) . '/WpProQuiz_sample.xml');
					$xmlString = file_get_contents(dirname(__FILE__) . '/WpProQuiz_sample.xml');
					$xml = simplexml_load_string($xmlString);
                    $quiz_title = pathinfo($_FILES["mtpqi_import"]["name"], PATHINFO_FILENAME);
					//$xml->data[0]->quiz[0]->title = trimCharacters($quiz_title);
					$xml->data[0]->quiz[0]->title = trimCharacters($quiz_array[2]["quiz_name"]);
                    $questions = $xml->data->quiz->questions;




                    $options_match = array(1 => 'a', 2 => 'b', 3 => 'c', 4 => 'd', 5 => 'e');
                    foreach ($quiz_array as $key => $ques_array) {

                        if ($answer_option_type == 'multiple') {



                            $someArray = explode("|", $ques_array['ans']);
                            $tempArray = array();

                            foreach ($someArray as $key => $value) {
                                $tempArray[$key + 1] = $value;
                            }
                            $multi_ans_val = $tempArray;
                        }
                        $new_question = $questions->addChild('question');
                        //$new_question->addAttribute('answerType', 'single');
                        //$new_question->addAttribute('answerType', 'multiple');
                        //$new_question->addAttribute('answerType', 'free_answer');
                        //$new_question->addAttribute('answerType', 'sort_answer');
                        //$new_question->addAttribute('answerType', 'matrix_sort_answer');
                        $new_question->addAttribute('answerType', $answer_option_type);
                        //$new_question->addAttribute('answerType', 'cloze_answer');
                        //$new_question->addAttribute('answerType', 'assessment_answer');
						$new_question->addChild('title', trimCharacters($ques_array['title']));
                        if ($answer_option_type == 'cloze_answer') {


                            if ($ques_array['showpointinboxval'] == "no" || $ques_array['showpointinboxval'] == "") {
                                $ques_array['showpointinboxval'] = "false";
                            } else {
                                $ques_array['showpointinboxval'] = "true";
                            }
                            if ($ques_array['answerpointsactivatedval'] == 'no' || $ques_array['answerpointsactivatedval'] == "") {
                                $ques_array['answerpointsactivatedval'] = "false";
                            } else {
                                $ques_array['answerpointsactivatedval'] = "true";
                            }
                            preg_match_all('#\{(.*?)(?:\|(\d+))?(?:[\s]+)?\}#im', $ques_array["opt1"], $matches);

                            $points = 0;
                            $maxPoints = 0;

                            foreach ($matches[2] as $match) {
                                if (empty($match)) {
                                    $match = 1;
                                }

                                $points += $match;
                                $maxPoints = max($maxPoints, $match);
                            }

                            if ($ques_array['answerpointsactivatedval'] == 'true') {
                                $new_question->addChild('points', $points);
                                $new_question->addChild('maxPoints', $maxPoints);
                            } else {
                                //echo "<pre>";print_r($ques_array);exit;
                                if ($ques_array['points'] != "") {
                                    $new_question->addChild('points', $ques_array['points']);
                                } else {
                                    $new_question->addChild('points', 1);
                                }
                            }
                            $new_question->addChild('showPointsInBox', $ques_array['showpointinboxval']);
                            $new_question->addChild('answerPointsActivated', $ques_array['answerpointsactivatedval']);
                        } else {
                            $new_question->addChild('showPointsInBox', 'false');
                            $new_question->addChild('answerPointsActivated', 'false');
                            if ($ques_array['points'] != "") {
                                $new_question->addChild('points', $ques_array['points']);
                            } else {
                                $new_question->addChild('points', 1);
                            }
                        }


                        //$new_question->addChild('points', 1);
                        $new_question->addChild('questionText', $ques_array['ques']);
                        $new_question->addChild('correctMsg', $ques_array['detail']);
                        $new_question->addChild('incorrectMsg', $ques_array['incorrectD']);
                        $tipMsg = $new_question->addChild('tipMsg', $ques_array['Hint']);
                        if ($ques_array['Hint']) {
                            $tipMsg->addAttribute('enabled', 'true');
                        } else {
                            $tipMsg->addAttribute('enabled', 'false');
                        }
                        $new_question->addChild('category', $ques_array['cat']);
                        $new_question->addChild('correctSameText', 'false');

                        $new_question->addChild('answerPointsDiffModusActivated', 'false');
                        $new_question->addChild('disableCorrect', 'false');
                        $answers = $new_question->addChild('answers');
                        for ($opt = 1; $opt <= 5; $opt++) {
                            if ($answer_option_type == 'cloze_answer') {
                                $answer = $answers->addChild('answer');
                                //$answer->addAttribute('points', 4);

                                if ($ques_array['points'] != "") {

                                    $answer->addAttribute('points', $ques_array['points']);
                                } else {
                                    $answer->addAttribute('points', 1);
                                }
                            } else {
                                $answer = $answers->addChild('answer');
                                if ($ques_array['points'] != "") {

                                    $answer->addAttribute('points', $ques_array['points']);
                                } else {
                                    $answer->addAttribute('points', 1);
                                }
                            }

                            if ($answer_option_type == 'multiple') {
                                if ($options_match[$opt] == strtolower($multi_ans_val[$opt])) {
                                    $answer->addAttribute('correct', 'true');
                                } else {
                                    $answer->addAttribute('correct', 'false');
                                }
                            } else {
                                if ($options_match[$opt] == strtolower($ques_array['ans'])) {
                                    $answer->addAttribute('correct', 'true');
                                } else {
                                    $answer->addAttribute('correct', 'false');
                                }
                            }
                            $answerText = $answer->addChild('answerText', $ques_array['opt' . $opt]);
                            $answerText->addAttribute('html', 'false');
                            if ($answer_option_type == 'matrix_sort_answer') {
                                $stortText = $answer->addChild('stortText', $ques_array['sort' . $opt]);
                            } else {
                                $stortText = $answer->addChild('stortText');
                            }

                            $stortText->addAttribute('html', 'false');
                        }
                    }
                    $quiz_xml = $xml->asXML();
                    $ids = array(0 => 0);
                    $quizMapperXls = new MT_WpProQuiz_ImportXls($quiz_xml);
                    $success = $quizMapperXls->saveImportXls($ids, $quiz_xml);
                }

//exit;

                unlink($inputFileName);
                if ($success) {
                    echo "<b style='font-size: 18px;'>LearnDash imported successfully!</b>";
                }
            }
            ?>
            <form enctype="multipart/form-data" name="mtpqi_import_form" method="post" action="<?php echo str_replace('%7E', '~', $_SERVER['REQUEST_URI']); ?>">
                <input type="hidden" name="mtpqi_import_hidden" value="Y">
                <?php echo "<h4>" . __('Import LearnDash', 'mtpqi_import_options') . "</h4>"; ?>
                <p><?php _e("Choose file: "); ?>
                    <input type="file" name="mtpqi_import" id="mtpqi_import" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel"  />
                </p>
                <p class="submit">
                    <input type="submit" name="Submit" value="<?php _e('Import Quiz', 'mtpqi_import_options') ?>" />
                </p>
                <hr />
            </form>
        </div>
        <?php
    }

    function mtpqi_menu() {
        add_menu_page("Excel to LearnDash", "Excel to LearnDash", "administrator", "mtpqi-quiz-import", array($this, 'mtpqi_quiz_import_page'));
    }

}

new MT_WP_Pro_Quiz_Import();

add_action('wp_trash_post','del_all_qstns');

function del_all_qstns(){
	
	global $wpdb;
	$post = get_post( $post_id );
	$del=$wpdb->query("DELETE  FROM ". $wpdb->prefix ."wp_pro_quiz_question WHERE name = '". $post->post_title ."' ");
	
	
}

