jQuery(document).ready(function($){
      jQuery("#image_preview_holder").on("click", "#achievement_image_remove", function(event){
        event.preventDefault();
        jQuery("#achievement_image #image_preview_holder").empty();
        jQuery("#achievement_image #no-image-links").show();
        jQuery("#upload_image").val("");
      });

      if(jQuery("#image_preview_holder").is(':empty') && 
          jQuery("#achievement_image #no-image-links").is(':hidden') ) {
            jQuery("#achievement_image #no-image-links").show();
      }
    
      jQuery("span").on("click", "#achievement_image_pick", function(event){
        event.preventDefault();
        jQuery("#image_preview_holder").hide();
        jQuery("#default-image-selection").show();
      });
    
      jQuery("#default-image-selection").on("click", ".radio_btn", function (event){
        jQuery("#selected_btn").attr("id","");
        jQuery(this).attr("id","selected_btn");
        jQuery("input[name=achievement_badge]:checked").attr("checked",false);
        jQuery(this).parent().find("input[name=achievement_badge]").attr("checked",true);
        jQuery("#image_preview_holder #image_preview_inner").empty();
        jQuery("#upload_image").val( jQuery(this).attr("src") );
      });
    
      var custom_uploader;
      jQuery("span").on("click", "#upload_image_button", function (event){
        event.preventDefault();
        jQuery("#default-image-selection").hide();
        jQuery("#default-image-selection input[name=achievement_badge]:checked").attr("checked", false);
        jQuery("#default-image-selection input[type=\"radio\"]:checked").prop("checked", false);
        jQuery("#selected_btn").attr("id","");
        if(custom_uploader){
          custom_uploader.open();
          return;
        }
        custom_uploader = wp.media.frames.file_frame = wp.media({
          title: "Choose Image",
          button: {
            text: "Choose Image"
          },
          multiple: false
        });
        custom_uploader.on("select", function(){
          var attachment = custom_uploader.state().get("selection").first().toJSON();
          jQuery("#upload_image").val(attachment.url);
    
          jQuery("#image_preview_holder").empty();
          jQuery("#image_preview_holder").append("<img src=\""+attachment.url+"\" alt=\"Uploaded Achievement Image\" /><br/><a href=\"#\" id=\"achievement_image_remove\">Remove</a>");
    
          jQuery("#achievement_image #no-image-links").hide();
          jQuery("#achievement_image #image_preview_holder").fadeIn();
    
        });
        custom_uploader.open();
      });
    });

// Show the first tab and hide the rest
jQuery('#tabs-nav li:first-child').addClass('active');
jQuery('.tab-content').hide();
jQuery('.tab-content:first').show();

// Click function
jQuery('#tabs-nav li').click(function(){
  jQuery('#tabs-nav li').removeClass('active');
  jQuery(this).addClass('active');
  jQuery('.tab-content').hide();
  
  var activeTab = jQuery(this).find('a').attr('href');
  jQuery(activeTab).fadeIn();
  return false;
});