<?php

/**
 * Reports Dashboard Achievement Top Users
 *
 * @since 4.9.0
 */

global $wpdb, $wpcwdb;
$leaderboard = $wpdb->get_results(
        "SELECT u.id, u.display_name, SUM(ua.points) as total_points 
        FROM $wpcwdb->user_achievements ua 
        INNER JOIN $wpdb->users u 
        ON ua.user_id = u.ID 
        GROUP BY u.ID 
        ORDER BY total_points 
        DESC LIMIT 10" 
    );
?>
<div class="wpcw-reports-dashboard widget-top-users">
    <table class="widefat striped">
        <thead>
            <tr>
                <td class="heading"><?php esc_html_e('Student', 'wp-courseware') ?></td>
                <td class="heading"><?php esc_html_e('Points', 'wp-courseware') ?></td>
            </tr>
        </thead>
        <tbody>
        <?php if (count($leaderboard) > 0) : ?>
            <?php foreach ($leaderboard as $key => $item) { ?>
                <tr>
                    <td><?= $item->display_name ?></td>
                    <td><?= $item->total_points ?></td>
                </tr>
            <?php } ?>
            <?php else : ?>
                <?php wpcw_print_notice(__("No results found.", 'wp-courseware'), 'info'); ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>