<?php
/**
 * WP Courseware Database Table User Achievements.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_User_Achievements.
 *
 * @since 4.3.0
 */
final class DB_Table_User_Achievements extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_user_achievements';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 450;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						 achievement_id int(11) unsigned NOT NULL,
			             user_id int(11) unsigned NOT NULL,
						 points int(11) NOT NULL DEFAULT '0',
						 is_notified tinyint(1) NOT NULL DEFAULT '0',
						 notification_enabled tinyint(1) NOT NULL DEFAULT '0',
						 notification_text VARCHAR(500)  DEFAULT NULL,
						 type VARCHAR(255)  DEFAULT NULL,
						 type_id int(11) unsigned NOT NULL,
			             created_at datetime DEFAULT NULL,
			             PRIMARY KEY  (id)";
	}
}
