<?php
/**
 * WP Courseware Course Notes Functions.
 *
 * @package WPCW
 * @subpackage Functions
 * @since 4.9.4
 */

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Get all of the associated parent data for the specified course unit.
 *
 * @since 4.9.4
 *
 * @param integer $post_id The ID of the course unit
 *
 * @return object The details of the parent objects, or false if there is no parent.
 */
function get_wpcw_units_associated_course( $post_id ) {
	global $wpcwdb, $wpdb;
	$wpdb->show_errors();

	$SQL = $wpdb->prepare(
		"
		SELECT *
		FROM $wpcwdb->units_meta um
		LEFT JOIN $wpcwdb->modules m ON m.module_id = um.parent_module_id
		LEFT JOIN $wpcwdb->courses c ON c.course_id = m.parent_course_id
		WHERE um.unit_id = %d AND course_title IS NOT NULL
	",
		$post_id
	);
	return $wpdb->get_row( $SQL );
}

/**
 * Get Notes.
 *
 * @since 4.9.4
 *
 * @param int|bool $parant_post_id The course post Id.
 * @param int|bool $post_author The course author Id.
 * @param string   $order_by.
 *
 * @return object|bool notes object or false.
 */
function get_wpcw_course_notes( $parant_post_id = '', $post_author = '', $order_by = 'DESC', $course_id = '' ) {
	global $wpcwdb, $wpdb;
	$where  = '1';
	$where .= ' AND post.post_type = ' . '"wpcw_course_note"';
	if ( $parant_post_id ) {
		$where .= ' AND post.post_parent = ' . $parant_post_id;
	}
	if ( $post_author ) {
		$where .= ' AND post.post_author = ' . $post_author;
	}
	if ( $course_id ) {
		$where .= ' AND um.parent_course_id =' . $course_id;
	}
	$sql          = "SELECT *
	FROM $wpdb->posts AS post
	JOIN $wpdb->wpcw_units_meta um ON `um`.`unit_id` = `post`.`post_parent`
	WHERE " . $where . '
	ORDER BY post.ID ' . $order_by;
	$course_notes = $wpdb->get_results( $sql );
	/*
	$args   = array(
		'post_status'  => 'publish',
		'post_type'    => 'wpcw_course_note',
		'order'        => $order_by,
		//'posts_per_page' => 5,
		'numberposts'  => - 1
	);
	if($post_author){
		$args['post_author'] = $post_author;
	}
	if($parant_post_id){
		$args['post_parent'] = $parant_post_id;
	}
	$course_notes = new WP_Query( $args );
	$course_notes = get_posts($args);*/
	if ( $course_notes ) {
		return $course_notes;
	}
	return false;
}

/**
 * Get wp editor.
 *
 * @since 4.9.4
 *
 * @param int|bool $parant_post_id The course post Id.
 * @param string   $note_content.
 *
 * @return \WPCW\Models\Course|bool An course object or false.
 */
function create_course_note_editor_html( $course_note_id = '', $note_content = '' ) {
	$editor_id = 'new_wpcw_note_content';

	if ( $course_note_id ) {
		$editor_id = 'new_wpcw_note_content_' . $course_note_id;
	}
	$editor_setting = array(
		'quicktags'     => false,
		'tinymce'       => true,
		'textarea_rows' => 8,
		'media_buttons' => false,
		'class'         => 'regular-text',
		'textarea_name' => 'new_wpcw_note_content',
//		'teeny'         => true,
	);
	?>
	<div class="wpcw-notes-inputs">
		<?php
			wp_editor( $note_content, $editor_id, $editor_setting );
		?>
		<div class="wpcw-button-group">
			<button type="reset" class="wpcw-cancel-note"><?php echo __( 'Cancel', 'wp-courseware' ); ?></button>
			<button type="submit" class="wpcw-submit-note" 
			<?php
			if ( $course_note_id ) :
				echo 'data-note-id=' . $course_note_id;
				?>
					
				<?php endif ?> >
				<?php echo __( 'Save note', 'wp-courseware' ); ?>
				<span v-if="saving" class="wpcw-spinner spinner note-spinner"></span>
			</button>
		</div>
	</div>
	<?php
}

/**
 * Check note checked.
 *
 * @since 4.9.4
 *
 * @param int|bool $post_id The course post Id.
 *
 * @return bool course true or false.
 */
function wpcw_is_allow_show_note( $post_id ) {
	if ( ! $post_id ) {
		return false;
	}
	$parent_data = get_wpcw_units_associated_course( $post_id );
	if ( $parent_data ) {
		$course_id = $parent_data->parent_course_id;
		$course    = wpcw_get_course( $course_id );
		if ( $course ) {
			$show_note = $course->course_opt_user_note;
			if ( $show_note == 'show_notes' ) {
				return true;
			}
		}
	}
	return false;
}

/**
 * Get editor html.
 *
 * @since 4.9.4
 *
 * @param object $course_notes The course note object.
 *
 * @return html.
 */
function get_editor_code( $course_note_id = '', $note_content = '' ) {
	$editor_id = 'new_wpcw_note_content';
	$data_att  = '';
	if ( $course_note_id ) {
		$editor_id = 'new_wpcw_note_content_' . $course_note_id;
		$data_att  = 'data-note-id=' . $course_note_id;
	}
	$editor_setting = array(
		'quicktags'     => false,
		'tinymce'       => true,
		'textarea_rows' => 8,
		'media_buttons' => false,
		'class'         => 'regular-text',
		'textarea_name' => 'new_wpcw_note_content',
		'teeny'         => true,
	);
	$html_editor    = '';
	$html_editor    = '<div class="wpcw-notes-inputs">' .
		'<textarea class="regular-text wp-editor-area wpcw-editor-area" name="new_wpcw_note_content" id="' . $editor_id . '" rows="8" cols="40">' . $note_content . '</textarea>';
			// wp_editor( $note_content, $editor_id, $editor_setting );
	$html_editor .= '<div class="wpcw-button-group">
				<button type="reset" class="wpcw-cancel-note">' . __( 'Cancel', 'wp-courseware' ) . '</button>
				<button type="submit" class="wpcw-submit-note"';
	$html_editor .= $data_att . '> ' . __( 'Save note', 'wp-courseware' ) . '<span v-if="saving" class="wpcw-spinner spinner  note-spinner"></span></button>
				</div></div>';
	return $html_editor;
}
