<?php
/**
 * WP Courseware Quiz Upload Question Type.
 *
 * @package WPCW
 * @since 1.0.0
 */

if ( ! class_exists( 'WPCW_quiz_FillBlanks' ) ) {
	/**
	 * Class WPCW_quiz_FillBlanks.
	 *
	 * The class that represents a question where you can upload a file.
	 *
	 * @since 1.0.0
	 */
	class WPCW_quiz_FillBlanks extends WPCW_quiz_base {

		/**
		 * Default constructor
		 *
		 * @param Object $quizItem The quiz item details.
		 */
		public function __construct( $quizItem ) {
			parent::__construct( $quizItem );
			$this->questionType = 'fillblanks';
			$this->cssClasses   = 'wpcw_question_type_fillblank';

			$this->hint = __( '(Optional) Use this to guide the user how they should fill the blanks.', 'wp-courseware' );

			if ( $this->disabled ) {
				$this->cssClasses .= ' wpcw_question_disabled';
			}
		}

		/**
		 * Output the form that allows questions to be configured.
		 */
		public function editForm_toString() {
			// Keep track to see if this question has any errors
			$this->gotError = false;

			$html = false;

			// Extra CSS for errors
			$errorClass_Question = false;
			$errorClass_FileType = false;

			// Error Check - Have we got an issue with a lack of question or answer?
			if ( $this->showErrors ) {
				if ( ! $this->quizItem->question_question ) {
					$errorClass_Question = 'wpcw_quiz_missing';
					$this->gotError      = true;
				}

				// Check that there's an input size field in the list.
				if ( ! $this->quizItem->question_correct_answer ) {
					$errorClass_FileType = 'wpcw_quiz_missing';
					$this->gotError      = true;
				}
			}

			// Track columns needed to show question details
			$columnCount = 2;

			$html .= sprintf( '<li id="wpcw_quiz_details_%s" class="%s"><table class="wpcw_quiz_details_questions_wrap" cellspacing="0">', $this->quizItem->question_id, $this->cssClasses );

			// Details of the question - top of the question details.
			$html .= $this->getSection_processHeader( $columnCount );

			// Check for being disabled.
			if ( $this->disabled ) {
				$html .= $this->getSection_disabledQuestionNotice( $columnCount );
			}

			// Main question details here...
			$html .= sprintf( '<tr class="wpcw_quiz_row_question %s">', $errorClass_Question );

			$html .= sprintf( '<th>%s</th>', __( 'Question', 'wp-courseware' ) );

			// Fill in the blank Questions
			$html .= '<td>';
			$html .= sprintf( '<textarea name="question_question_%s">%s</textarea>', $this->quizItem->question_id, htmlspecialchars( $this->quizItem->question_question ) );

			// Field storing order of question among other questions
			$html .= sprintf( '<input type="hidden" name="question_type_%s" value="fillblanks" />', $this->quizItem->question_id );
			$html .= sprintf( '<input type="hidden" name="question_order_%s" value="%s" class="wpcw_question_hidden_order" />',
				$this->quizItem->question_id,
				absint( $this->quizItem->question_order )
			);

			$html .= '</td>';

			$html .= '</tr>';

			// Show a bit of the form that allows the user to determine what kind of size
			// the answer box should be.
			$html .= sprintf( '<tr class="alternate %s">', $errorClass_FileType );
			$html .= sprintf( '<th>%s</th>', __( 'Correct Answer?', 'wp-courseware' ) );

			$html .= sprintf( '<td class="wpcw_quiz_row_question">' );
			
			$html .= sprintf( '<textarea name="question_answer_sel_%s">%s</textarea>', $this->quizItem->question_id, htmlspecialchars( $this->quizItem->question_correct_answer ) );

			$html .= sprintf( '<span>%s</span>',
				__( 'Enclose the searched words with { } e.g. I {play} soccer. Capital and small letters will be ignored. You can specify multiple options for a search word. Enclose the word with [ ] e.g. I {[play],[love],[hate]} soccer. In this case answers "play", "love" OR "hate" are correct.', 'wp-courseware' ),
				
			);

			// Render the section that allows an image to be shown.
			$html .= $this->getSection_showImageField( $columnCount );
			$html .= '</td>';
			$html .= '</tr>';

			// Extra fields at the bottom of a question.
			$html .= $this->getSection_processFooter( $columnCount );

			// All done
			$html .= '</table></li>';

			return $html;
		}

		/**
		 * Render Form.
		 *
		 * @see WPCW_quiz_base::renderForm_toString()
		 */
		public function renderForm_toString( $parentQuiz, $questionNum, $selectedAnswer, $showAsError, $errorToShow = false ) {

			$fieldID = sprintf( 'question_%d_%s_%d', $parentQuiz->quiz_id, $this->questionType, $this->quizItem->question_id );

			if( $selectedAnswer) {
				
				$queAnswe = $this->quizItem->question_correct_answer;

				$count = 0;
				
				$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_fillblank_wrapper" id="%s">', $fieldID );
				
				$this->extraQuizHTML .= preg_replace_callback( "/\{[^}]*\}/", function( $match ) use ( &$count, $selectedAnswer, $fieldID ) {

					if( !empty( $selectedAnswer[ $count ] ) ) {
				    	$return = sprintf( '<input autocomplete="off" class="wpcw_fillblank_intput"  type="text" value="%s" name="%s[]" />', $selectedAnswer[$count],  $fieldID );
				    } else {
				     	$return =  sprintf( '<input autocomplete="off" class="wpcw_fillblank_intput"  type="text" name="%s[]" />', $fieldID );
					}
				    $count++;
				    return $return;
				}, $queAnswe );
				
				$this->extraQuizHTML .= '</div>';
			
			} else {

				if ( $this->quizItem->question_correct_answer ) {
					
					$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_fillblank_wrapper" id="%s">', $fieldID );
						$queAnswe = $this->quizItem->question_correct_answer;
					
						$this->extraQuizHTML  .= preg_replace("/\{[^}]*\}/", sprintf( '<input autocomplete="off" class="wpcw_fillblank_intput"  type="text" name="%s[]" >', $fieldID ), $queAnswe);
					
					
					$this->extraQuizHTML .= '</div>';
				}
			}

			// Add the hint if there is one
			if ( $this->quizItem->question_answer_hint ) {
				$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_hint">%s</div>', nl2br( htmlspecialchars( $this->quizItem->question_answer_hint ) ) );
			}

			return parent::renderForm_toString_withClass( $parentQuiz, $questionNum, $selectedAnswer, $showAsError, 'wpcw_fe_quiz_q_fillblanks', $errorToShow );
		}
		
		/**
		 * Clean the answer data and return it to the user. Check for true or false answer.
		 *
		 * @param String $rawData The data that's being cleaned.
		 *
		 * @return String The cleaned data.
		 */
		public static function sanitizeAnswerData( $rawData ) {
			return $rawData;
		}

		/**
		 * Extract the correct answer for a Multiple Choice question, using the specified answer key to check $_POST.
		 *
		 * @param String $correctAnswerKey The key to use to extract a correct answer.
		 * @param Array The list of questions to check that the correct answer falls into.
		 *
		 * @return String The correct answer, if it was found.
		 */
		public static function editSave_extractCorrectAnswer(  $correctAnswerKey ) {
			if( isset( $_POST[ $correctAnswerKey ] ) ) {
				return $_POST[ $correctAnswerKey ] ;
			}
			return false;
		}
	}
}