<?php
/**
 * WP Courseware Quiz Upload Question Type.
 *
 * @package WPCW
 * @since 1.0.0
 */

if ( ! class_exists( 'WPCW_quiz_MatrixSorting' ) ) {
	/**
	 * Class WPCW_quiz_MatrixSorting.
	 *
	 * The class that represents a question where you can upload a file.
	 *
	 * @since 1.0.0
	 */
	class WPCW_quiz_MatrixSorting extends WPCW_quiz_base {

		public $answerListRaw;

		/**
		 * Default constructor.
		 *
		 * @param Object $quizItem The quiz item details.
		 */
		public function __construct( $quizItem ) {
			parent::__construct( $quizItem );
			$this->questionType = 'matrixsorting';
			$this->cssClasses   = 'wpcw_question_type_matrixsorting';

			$this->hint = __( '(Optional) Use this to guide the user that they should make a selection.', 'wp-courseware' );

			if ( $this->disabled ) {
				$this->cssClasses .= ' wpcw_question_disabled';
			}
		}

		/**
		 * Output the form that allows questions to be configured.
		 */
		public function editForm_toString() {
			$answerList = false;

			if ( $this->quizItem->question_data_answers ) {
				$answerList = WPCW_quizzes_decodeAnswers( $this->quizItem->question_data_answers );
			}

			$html = false;

			// Extra CSS for errors
			$errorClass_Question  = false;
			$errorClass_CorAnswer = false;

			// Error Check - Have we got an issue with a lack of question?
			if ( $this->showErrors ) {
				if ( ! $this->quizItem->question_question ) {
					$errorClass_Question = 'wpcw_quiz_missing';
					$this->gotError      = true;
				}
				if ( $this->needCorrectAnswers && ! $this->quizItem->question_correct_answer ) {
					$errorClass_CorAnswer = 'wpcw_quiz_missing';
					$this->gotError       = true;
				}
			}

			// Track columns needed to show question details
			$columnCount = 4;

			// Render just the question area
			$html .= sprintf( '<li id="wpcw_quiz_details_%s" class="%s"><table class="wpcw_quiz_details_questions_wrap" cellspacing="0">', $this->quizItem->question_id, $this->cssClasses );

			// Details of the question - top of the question details.
			$html .= $this->getSection_processHeader( $columnCount );

			// Check for being disabled.
			if ( $this->disabled ) {
				$html .= $this->getSection_disabledQuestionNotice( $columnCount );
			}

			// Main question details here...
			$html .= sprintf( '<tr class="wpcw_quiz_row_question %s">', $errorClass_Question );

			$html .= sprintf( '<th>%s</th>', __( 'Question', 'wp-courseware' ) );

			$html .= sprintf( '<td>' );
			$html .= sprintf( '<textarea name="question_question_%s">%s</textarea>', $this->quizItem->question_id, htmlspecialchars( $this->quizItem->question_question ) );
			$html .= sprintf( '<input type="hidden" name="question_type_%s" value="matrixsorting" />', $this->quizItem->question_id );

			// Field storing order of question among other questions
			$html .= sprintf(
				'<input type="hidden" name="question_order_%s" value="%s" class="wpcw_question_hidden_order" />', $this->quizItem->question_id, absint( $this->quizItem->question_order )
			);

			$html .= sprintf( '</td>' );

			// Column for add/remove buttons
			$html .= '<td>&nbsp;</td>';

			$html .= sprintf( '</tr>' );

			// Render the section that allows an image to be shown.
			$html .= $this->getSection_showImageField( $columnCount );

			
			// Render the list of answers if we have any.
			if ( $answerList ) {
				$count = 0;
				$odd   = true;
				foreach ( $answerList as $answerItem ) {
					// Extract image if available
					$answerItemImageVal = WPCW_arrays_getValue( $answerItem, 'image' );

					$answerItemCriterion = WPCW_arrays_getValue( $answerItem, 'criterion' );

					// Exract the answer if available
					$answerItemVal = trim( $answerItem['answer'] );
					++ $count;
					/*
					 * Store the selected result.
					 * @var string
					 */
					$result          = $this->quizItem->question_correct_answer;
					$correct_answers = @unserialize( $result );
					/**
					 * check is the serialised array or not if not set $correct_answers to result value for the single answer quiz.
					 */
					if ( ! $correct_answers ) {
						$correct_answers = array( $result );
					}

					// Show an error if the field is still blank.
					$errorClass_Answer = false;
					if ( $this->showErrors ) {
						// Check that answer contains some characters.
						if ( strlen( $answerItemVal ) == 0 ) {
							$errorClass_Answer = 'wpcw_quiz_missing';
							$this->gotError    = true;
						}
					}

					// Add 'data-answer-id' field to store the ID of this row, and other rows that match this.
					$html .= sprintf(
						'<tr class="wpcw_quiz_row_answer %s %s" data-answer-id="%d">',
						$errorClass_Answer,
						( $odd ? 'alternate' : '' ),
						$count
					);
						$html .= sprintf( '<th>%s <span>%d</span></th>', __( 'Criterion', 'wp-courseware' ), $count );
						$html .= '<td>';



						$thisAnswerFieldName = 'question_answer_' . $this->quizItem->question_id . '_' . $count;

						$html .= sprintf(
						'<input type="text" name="question_criterion_%s[%d]" id="%s" value="%s" />', $this->quizItem->question_id, $count, $thisAnswerFieldName, $answerItemCriterion
						);

				
						$html .= '</td>';

						// Buttons for add/remove questions
						$html .= sprintf(
							'
						<td class="wpcw_quiz_add_rem">
							<a href="#" title="%s" class="wpcw_question_add"><img src="%sicon_add_32.png" /></a>
							<a href="#" title="%s" class="wpcw_question_remove"><img src="%sicon_remove_32.png" /></a>
						</td>', __( 'Add a new answer...', 'wp-courseware' ), WPCW_IMG_URL, __( 'Remove this answer...', 'wp-courseware' ), WPCW_IMG_URL
						);

					$html .= sprintf( '</tr>' );

					// Add the image URL for this answer - added as a new row.
					$html .= sprintf( '<tr class="wpcw_quiz_row_answer_image wpcw_quiz_row_answer_image_%d %s %s">', $count, $errorClass_Answer, ( $odd ? 'alternate' : '' ) );
						$html .= sprintf(
							'<th>%s <span class="wpcw_inner_hint">%s</span></th>', __( 'Answer Image URL', 'wp-courseware' ), __( '(Optional) ', 'wp-courseware' )
						);

						$html .= '<td>';
						// Field name - needs to use underscore, as square brackets break the jQuery to find the target.
						$thisAnswerFieldName = 'question_answer_image_' . $this->quizItem->question_id . '_' . $count;

						// The URL field.
						$html .= sprintf(
							'<input type="text" name="question_answer_image_%s[%d]" id="%s" value="%s" />', $this->quizItem->question_id, $count, $thisAnswerFieldName, $answerItemImageVal
						);
							

						// The insert button.
						$html .= sprintf(
							'<span class="wpcw_insert_image_wrap"><a href="#" class="button wpcw_insert_image" data-uploader_title="%s" data-uploader_btn_text="%s" data-target="%s" title="%s"><span class="wpcw_insert_image_img"></span> %s</a></span>', __( 'Choose an image for this answer...', 'wp-courseware' ), __( 'Select Image...', 'wp-courseware' ), $thisAnswerFieldName, __( 'Select Image', 'wp-courseware' ), __( 'Select Image', 'wp-courseware' )
						);

						$html .= '</td>';

						// Filler for the remaining space
						$html .= '<td colspan="2"></td>';

					$html .= sprintf( '</tr>' );

					// Add the image URL for this answer - added as a new row.
					$html .= sprintf( '<tr class="wpcw_quiz_row_answer_main wpcw_quiz_row_answer_main_%d %s %s">', $count, $errorClass_Answer, ( $odd ? 'alternate' : '' ) );
						$html .= sprintf(
							'<th>%s </th>', __( 'Sorting Element', 'wp-courseware' )
						);

						$html .= '<td>';
						// Field name - needs to use underscore, as square brackets break the jQuery to find the target.
						$thisAnswerFieldName = 'question_answer_answer_' . $this->quizItem->question_id . '_' . $count;


							// The URL field.
						$html .= sprintf(
							'<input type="text" name="question_answer_%s[%d]" id="%s" value="%s" />', $this->quizItem->question_id, $count, $thisAnswerFieldName, $answerItemVal
						);

						$html .= '</td>';

						// Filler for the remaining space
						$html .= '<td colspan="2"></td>';

					$html .= sprintf( '</tr>' );

					$odd = ! $odd;
				}
			}

			// Extra fields at the bottom of a question.
			$html .= $this->getSection_processFooter( $columnCount );

			// All done
			$html .= sprintf( '</table></li>' );

			return $html;
		}

		/**
		 * Determine if the answers need to be randomized.
		 */
		public function processAnswersWithRandomOption( $unit_id, $quiz_id ) {
			global $wpcwdb, $wpdb;
			$wpdb->show_errors();

			// Randomization is not needed.
			if ( ! $this->quizItem->question_matrixsorting_random_enable ) {
				return;
			}

			// Get current user ID
			$currentUserID = get_current_user_id();
			// Get Quiz Details
			$unitQuizProgress = WPCW_quizzes_getUserResultsForQuiz( $currentUserID, $unit_id, $quiz_id );

			$possibleAnswers = false;
			// Do we have progress yet?
			if ( $unitQuizProgress && $unitQuizProgress->quiz_grade < 0 ) {
				$possibleAnswers = $unitQuizProgress->quiz_data[ $this->quizItem->question_id ]['possible_answers'];
			}

			// Force the possible answers to be retrieved instead of providing a new random set
			if ( $possibleAnswers ) {
				$possibleAnswers = maybe_unserialize( $possibleAnswers );
				//Need list copy to manipulate, as we don't want to modify the raw list just yet.
				$listCopy   = $this->answerListRaw;
				$newRawList = array();
				foreach ( $possibleAnswers as $key => $value ) {
					if ( isset( $listCopy[ $value ] ) ) {
						$newRawList[ $value ] = $listCopy[ $value ];
						unset( $listCopy[ $value ] );
					}
				}
				$this->answerListRaw = $newRawList;
			} else {
				// Need list copy to manipulate, as we don't want to modify the raw list just yet.
				$listCopy   = $this->answerListRaw;
				$newRawList = array();
				// Extract the correct answer from the serialised array of the answers
				$correctAnswerIndexArray = @unserialize( $this->quizItem->question_correct_answer );
				if ( ! $correctAnswerIndexArray ) {
					$correctAnswerIndexArray = array( $this->quizItem->question_correct_answer );
				}
				foreach ( $correctAnswerIndexArray as $key => $value ) {
					if ( isset( $listCopy[ $value ] ) ) {
						// Copy the right answer, and then remove from the source list
						$newRawList[ $value ] = $listCopy[ $value ];
						unset( $listCopy[ $value ] );
					}
				}

				// Set seed to the current user ID so that sequence is predictable. Don't really need a
				// lock for this.
				//srand(time() + get_current_user_id());

				srand( time() );

				// Now we need to copy all the answers that the user wants.
				while ( count( $newRawList ) < $this->quizItem->question_matrixsorting_random_count && ! empty( $listCopy ) ) {
					// Get a random item from the copy
					$randomKey = array_rand( $listCopy, 1 );

					// Copy the right answer, and then remove from the source list
					$newRawList[ $randomKey ] = $listCopy[ $randomKey ];
					unset( $listCopy[ $randomKey ] );
				}

				// Randomize the ordering (reset the seed to something new)
				//srand(time());

				srand();
				$newRawList = WPCW_arrays_shuffle_assoc( $newRawList );

				// And update the raw list for rendering.
				$this->answerListRaw = $newRawList;
			}
		}

		/**
		 * Render Form.
		 *
		 * @see WPCW_quiz_base::renderForm_toString()
		 */
		public function renderForm_toString( $parentQuiz, $questionNum, $selectedAnswer, $showAsError, $errorToShow = false ) {
			// Generate the ID of the field, also used for the CSS ID

		
			$fieldID = sprintf( 'question_%d_%s_%d', $parentQuiz->quiz_id, $this->questionType, $this->quizItem->question_id );
			$fieldUserData = sprintf( 'question_user_data%d_%s_%d', $parentQuiz->quiz_id, $this->questionType, $this->quizItem->question_id );

			// Have they already uploaded a file? If so, tell them with a link to open the file.
			if ( $selectedAnswer ) {

				$sorted_element_def= isset( $selectedAnswer['sorted_element'][0] ) ?  $selectedAnswer['sorted_element'][0] : "";

				$sorted_element = json_decode( stripslashes( $sorted_element_def ), true );

				// To start index from the 1 to match the index of answer.
				array_unshift( $sorted_element, "" );
				unset($sorted_element[0]);

				$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_matrixsorting_wrapper" id="%s">', $fieldID );

				if ( $this->quizItem->question_data_answers ) {
					
					$wpcwSortingQue = WPCW_quizzes_decodeAnswers( $this->quizItem->question_data_answers );

					
					$this->extraQuizHTML .= sprintf('<ul id="%s" class="wpcw_ans_matrix_sorting_ul">', $fieldID );	
						
						if( is_array($wpcwSortingQue) && !empty( $wpcwSortingQue ) ) {

							if( $sortEleAns = array_column( $wpcwSortingQue , "answer") ) {
								
								$sortEleAns = $sortEleAns;

								// Validate answer (In case updated from the backend)
								$validAns = $found = 0;
								foreach( $sorted_element as $var ) {
									if( !empty( $var ) ){
										$validAns++;
										if( in_array($var, $sortEleAns) ){
											$found++;
										}
									}
								}

								if( $validAns != $found ) {
									$sorted_element = array();
									$sorted_element_def = "";
								}

							
								shuffle( $sortEleAns );
							
								foreach ( $sortEleAns as $key => $sortQue ) {

									if( ! in_array( $sortQue, $sorted_element ) ) {

						         		$this->extraQuizHTML .= sprintf("<li id='%s_{$key}' class='wpcw_que_sorting_list %s_item'>",$fieldID, $fieldID);

						         		$this->extraQuizHTML .= sprintf("<input type='hidden' value='{$sortQue}' name='%s[%s][]' class='wpcw_que_sorting_list %s_item'>",$fieldID, 'sort_elements', $fieldID);
										$this->extraQuizHTML .=  sprintf("<div class='wpcw_sorting_ans'>%s</div>", $sortQue);
						         		$this->extraQuizHTML .= "</li>";
									}
					        	} 
				        	}
						}
			      	$this->extraQuizHTML .=  '</ul>';


			      	if( is_array( $wpcwSortingQue ) && !empty( $wpcwSortingQue ) ) {
						
						$this->extraQuizHTML .= sprintf('<table id="%s" class="wpcw_matrixsorting_table %s"><tbody>', $fieldID,  $fieldID );

						foreach ($wpcwSortingQue as $key => $sortQue ) {
							
							$this->extraQuizHTML .= sprintf('<tr class="wpProQuiz_mextrixTr_%s">',$key);	
			      			$this->extraQuizHTML .= sprintf('<th width="%s">', '20%');
								$this->extraQuizHTML .= sprintf( '<div class="%s">%s</div>',"test", $sortQue['criterion'] );	
		      					if( isset( $sortQue['image'] ) ){
		      						$this->extraQuizHTML .= sprintf( '<img src="%s" class="wpcw_sorting_img %s_img"/>', $sortQue['image'],$fieldID );	
	      						}
							$this->extraQuizHTML .= sprintf('</th>');

							$this->extraQuizHTML .= sprintf('<td width="%s">', '80%');
								$this->extraQuizHTML .= sprintf( '<ul class="wpcw_matrix_sorting_ans_ul" style="height: 25px;">' );	

								if( !empty($sorted_element[$key] ) ){

									$this->extraQuizHTML .= sprintf("<li id='%s_{$key}' class='wpcw_que_sorting_list %s_item'>",$fieldID, $fieldID);

					         			$this->extraQuizHTML .= sprintf("<input type='hidden' value='{$sorted_element[$key]}' name='%s[%s][]' class='wpcw_que_sorting_list %s_item'>",$fieldID, 'sort_elements', $fieldID);
										$this->extraQuizHTML .=  sprintf("<div class='wpcw_sorting_ans'>%s</div>", $sorted_element[$key] );
					         		$this->extraQuizHTML .= "</li>";
								}	


								$this->extraQuizHTML .= sprintf( '</ul>' );	
			      			$this->extraQuizHTML .= sprintf('</td>');	

			      			$this->extraQuizHTML .= sprintf('</tr>');
			      		}
			      		$this->extraQuizHTML .=  '</tbody></table>';
					}					
					$this->extraQuizHTML .= sprintf("<input type='hidden' value='%s' name='%s[%s][]' class='wpcw_que_user_given_ans wpcw_ms_ans_submited %s_item'>",$sorted_element_def, $fieldID, 'sorted_element', $fieldID);
			    }
				$this->extraQuizHTML .= '</div>';

			} // Only show the file upload if we don't have it.
			else {
				
				$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_matrixsorting_wrapper" id="%s">', $fieldID );

				$sorted_element_def= isset( $selectedAnswer['sorted_element'][0] ) ?  $selectedAnswer['sorted_element'][0] : "";

				if ( $this->quizItem->question_data_answers ) {
					
					$wpcwSortingQue = WPCW_quizzes_decodeAnswers( $this->quizItem->question_data_answers );

					$this->extraQuizHTML .= sprintf('<ul id="%s" class="wpcw_ans_matrix_sorting_ul">', $fieldID );	
						
						if( is_array($wpcwSortingQue) && !empty( $wpcwSortingQue ) ) {
							
							if( $sortEleAns = array_column( $wpcwSortingQue , "answer") ) {
								$sortEleAns = $sortEleAns;
							
								shuffle( $sortEleAns);
							
								foreach ($sortEleAns as $key => $sortQue ) {
					         		$this->extraQuizHTML .= sprintf("<li id='%s_{$key}' class='wpcw_que_sorting_list %s_item'>",$fieldID, $fieldID);

					         		$this->extraQuizHTML .= sprintf("<input type='hidden' value='{$sortQue}' name='%s[%s][]' class='wpcw_que_sorting_list %s_item'>",$fieldID, 'sort_elements', $fieldID);
									$this->extraQuizHTML .=  sprintf("<div class='wpcw_sorting_ans'>%s</div>", $sortQue);
					         		$this->extraQuizHTML .= "</li>";
					        	} 
				        	}
						}
			      	$this->extraQuizHTML .=  '</ul>';


			      	if( is_array( $wpcwSortingQue ) && !empty( $wpcwSortingQue ) ) {
						
						$this->extraQuizHTML .= sprintf('<table id="%s" class="wpcw_matrixsorting_table %s"><tbody>', $fieldID,  $fieldID );	
			      		
			      		foreach ($wpcwSortingQue as $key => $sortQue ) {

			      			$this->extraQuizHTML .= sprintf('<tr class="wpProQuiz_mextrixTr_%s">',$key);	
			      			$this->extraQuizHTML .= sprintf('<th width="%s">', '20%');
								$this->extraQuizHTML .= sprintf( '<div class="%s">%s</div>',"test", $sortQue['criterion'] );	
		      					if( isset( $sortQue['image'] ) ){
		      						$this->extraQuizHTML .= sprintf( '<img src="%s" class="wpcw_sorting_img %s_img"/>', $sortQue['image'],$fieldID );	
	      						}
							$this->extraQuizHTML .= sprintf('</th>');

							$this->extraQuizHTML .= sprintf('<td width="%s">', '80%');
								$this->extraQuizHTML .= sprintf( '<ul class="wpcw_matrix_sorting_ans_ul" style="height: 25px;"></ul>' );	
			      			$this->extraQuizHTML .= sprintf('</td>');	

			      			$this->extraQuizHTML .= sprintf('</tr>');	
			      		}
			      		$this->extraQuizHTML .=  '</tbody></table>';
					}					
			    }
				
				$this->extraQuizHTML .= sprintf("<input type='hidden' value='%s' name='%s[%s][]' class='wpcw_que_user_given_ans %s_item'>",$sorted_element_def, $fieldID, 'sorted_element', $fieldID);
				$this->extraQuizHTML .= '</div>';
			}

			// Work out what file types are permitted
			$fileTypes      = WPCW_files_cleanFileExtensionList( $this->quizItem->question_answer_file_types );
			$permittedFiles = false;
			if ( ! empty( $fileTypes ) ) {
				// Show message about permitted file types, which can be customised if needed.
				$permittedFiles = apply_filters( 'wpcw_front_quiz_upload_permitted_files', __( 'Allowed file types: ', 'wp-courseware' ) . implode( ', ', $fileTypes ) . '. ', $fileTypes );
			}

			// Add the hint if there is one
			if ( $this->quizItem->question_answer_hint ) {
				$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_hint">%s</div>', nl2br( htmlspecialchars( $this->quizItem->question_answer_hint ) ) );
			}

			// Add the file type list if there are any
			if ( $permittedFiles ) {
				$this->extraQuizHTML .= sprintf( '<div class="wpcw_fe_quiz_q_hint wpcw_fe_quiz_q_upload_permitted_files">%s</div>', $permittedFiles );
			}

			return parent::renderForm_toString_withClass( $parentQuiz, $questionNum, $selectedAnswer, $showAsError, 'wpcw_fe_quiz_q_upload', $errorToShow );
		}

		/**
		 * Extract the list of correct answers for a Multiple Choice question when saving changes to a question,
		 * using the specified answer key to check $_POST.
		 *
		 * @param String $answerListKey The key to use to extract the list of answers.
		 * @param String $answerImageListKey The key to use to extract the list of answer images.
		 *
		 * @return String The list of answers, if found.
		 */
		public static function editSave_extractAnswerList( $answerListKey, $answerImageListKey, $fieldName_criterion ) {
			$qAns = array();

			// ### 1 - Get the list of answers if we have them
			if ( isset( $_POST[ $answerListKey ] ) && is_array( $_POST[ $answerListKey ] ) ) {
				// Validate each of the answers actually contain something, removing them if not.
				$answersToCheck = $_POST[ $answerListKey ];
				
				foreach ( $answersToCheck as $idx => $answer ) {
					// 2013-06-10 - Changed from (!trim($answer)) to if (strlen(trim($answer)) == 0) { to allow for
					// answers that are literally the number '0'.
					if ( strlen( trim( $answer ) ) == 0 ) {
						// Do nothing
					} // Clean up each answer if slashes used for escape characters.
					else {
						$qAns[ $idx ] = array( 'answer' => stripslashes( $answer ) );
					}
				} // end foreach
			} // end if answers are in an array
			// How many items are there in the list? None? Then make it false.

			if ( count( $qAns ) == 0 ) {
				return false;
			} // Got answers, so see if there are any matching images for these answers.
			else {
				// Detected some images to check to see if they're valid.
				if ( isset( $_POST[ $answerImageListKey ] ) && is_array( $_POST[ $answerImageListKey ] ) ) {
					$imagesToCheck = $_POST[ $answerImageListKey ];

					// Only interested in images if we have an answer set up.
					foreach ( $qAns as $idx => $answerDetails ) {
						// See if there's an image for an answer we've validated.
						if ( isset( $imagesToCheck[ $idx ] ) ) {
							// Yep, now just check it's sound and safe.
							$ansImage = trim( substr( strip_tags( $imagesToCheck[ $idx ] ), 0, 300 ) );
							if ( $ansImage ) {
								// All is sound, so store the image.
								$qAns[ $idx ]['image'] = $ansImage;
							}
						} // end if (isset($imagesToCheck[$idx]))
					}
				} // end if
			} // end else.


			if ( count( $qAns ) == 0 ) {
				return false;
			} // Got answers, so see if there are any matching images for these answers.
			else {
				// Detected some images to check to see if they're valid.
				if ( isset( $_POST[ $fieldName_criterion ] ) && is_array( $_POST[ $fieldName_criterion ] ) ) {
					$criterionToCheck = $_POST[ $fieldName_criterion ];

					// Only interested in images if we have an answer set up.
					foreach ( $qAns as $idx => $answerDetails ) {
						// See if there's an image for an answer we've validated.
						if ( isset( $criterionToCheck[ $idx ] ) ) {
							// Yep, now just check it's sound and safe.
							$ansCriterion = trim( substr( strip_tags( $criterionToCheck[ $idx ] ), 0, 300 ) );
							if ( $ansCriterion ) {
								// All is sound, so store the image.
								$qAns[ $idx ]['criterion'] = $ansCriterion;
							}
						} // end if (isset($imagesToCheck[$idx]))
					}
				} // end if
			} // end else.

			return $qAns;
		}

		/**
		 * Extract the correct answer for a Multiple Choice question, using the specified answer key to check $_POST.
		 *
		 * @param String $correctAnswerKey The key to use to extract a correct answer.
		 * @param Array The list of questions to check that the correct answer falls into.
		 *
		 * @return String The correct answer, if it was found.
		 */
		public static function editSave_extractCorrectAnswer( $qAns, $correctAnswerKey ) {
			/*
			 * To store the  correct answers into the array of correct answers.
			 * @var array
			 */			

			$qAnsCor = array();
			if ( isset( $_POST[ $correctAnswerKey ] ) ) {
				foreach ( $_POST[ $correctAnswerKey ] as $key => $value ) {
					// ### See if we have a correct answer, and it matches one of the items in the list.
					if ( isset( $_POST[ $correctAnswerKey ] ) && preg_match( '/^([0-9]+)$/', $value, $matches ) ) {
						$qAnsCor[] = $matches[1];
					}
				}
			}

			//No correct answer if no answers is specified.
			if ( count( $qAnsCor ) <= 0 ) {
				$qAnsCor = false;
			}
			
			return $qAnsCor;
		}

		/**
		 * Clean the answer data and return it to the user. Check for true or false answer.
		 *
		 * @param String $rawData The data that's being cleaned.
		 *
		 * @return String The cleaned data.
		 */
		public static function sanitizeAnswerData( $rawData ) {
			return $rawData;
		}


		/**
		 * Shows the field where the instructor can determine if answers are randomly presented
		 * to the user on the page.
		 *
		 * @param Integer $columnCount The number of columns that are being rendered to sh
		 *
		 * @return String The HTML for rendering the randomize answers field.
		 */
		protected function getSection_showRandomizeAnswersField( $columnCount ) {
			$html = '<tr>';
			$html .= sprintf(
				'<th>%s<span class="wpcw_inner_hint">%s</span></th>',
				__( 'Randomize Answers?', 'wp-courseware' ),
				__( '(Optional)', 'wp-courseware' )
			);

			$html .= '<td class="wpcw_quiz_details_randomize_answers">';

			// The checkbox to enable the feature
			$html .= sprintf(
				'<input name="question_matrixsorting_random_enable_%s" class="wpcw_quiz_details_enable" type="checkbox" %s />',
				$this->quizItem->question_id,
				( $this->quizItem->question_matrixsorting_random_enable > 0 ? 'checked="checked"' : '' ),
				__( 'Yes, randomize the order of these answers.', 'wp-courseware' )
			);

			// The count of the items that will be randomized. Always include, but hide if not enabled.
			$html .= sprintf(
				'<span class="wpcw_quiz_details_count_wrap" %s>
					 <label>%s</label>
					 <input name="question_matrixsorting_random_count_%s" class="wpcw_quiz_details_count" type="text" value="%s" size="10" maxlength="10" />
					 <span class="wpcw_quiz_details_count_doc">%s</span>
				 </span>',
				( $this->quizItem->question_matrixsorting_random_enable ? '' : 'style="display: none;"' ),
				__( 'Number of answers to display:', 'wp-courseware' ),
				$this->quizItem->question_id,
				$this->quizItem->question_matrixsorting_random_count,
				__( 'The correct answers will always appear in the selection of answers.', 'wp-courseware' )
			);

			$html .= '</td>';

			// Works out the space after the text area.
			$columnCount -= 2;
			if ( $columnCount > 0 ) {
				$html .= sprintf( '<td colspan="%d">&nbsp;</td>', $columnCount );
			}

			$html .= '</tr>';

			return $html;
		}

		/**
		 * Shows the field where the instructor can determine if answers are displayed
		 * as checkboxes or radio buttons. Always displays, but is hidden when they select
		 * more than one answer.
		 *
		 * @param Integer    $columnCount The number of columns that are being rendered to sh
		 * @param bool|array $answerList The answer list.
		 *
		 * @return String The HTML for rendering the checkbox or radio field.
		 */
		protected function getSection_showAnswersAsCheckboxesField( $columnCount ) {
			$correct_answers = maybe_unserialize( $this->quizItem->question_correct_answer );

			$hidden = ( ! empty( $correct_answers ) && count( $correct_answers ) > 1 ) ? 'style="display: none;"' : '';

			$html = '<tr class="wpcw_quiz_row_checkboxes_enable"' . $hidden . '>';
			$html .= sprintf(
				'<th>%s<span class="wpcw_inner_hint">%s</span></th>', __( 'Force Checkboxes?', 'wp-courseware' ), __( '(Optional)', 'wp-courseware' )
			);

			$html .= '<td class="wpcw_quiz_details_checkboxes_enable">';

			// The checkbox to enable the feature
			$html .= sprintf(
				'<input name="question_matrixsorting_checkboxes_enable_%s" class="wpcw_quiz_matrixsorting_checkboxes_enable" type="checkbox" %s /> %s',
				$this->quizItem->question_id,
				( $this->quizItem->question_matrixsorting_checkboxes_enable > 0 ? 'checked="checked"' : '' ),
				__( 'Yes, force the answers to display as checkboxes.', 'wp-courseware' )
			);

			$html .= '</td>';

			// Works out the space after the text area.
			$columnCount -= 2;
			if ( $columnCount > 0 ) {
				$html .= sprintf( '<td colspan="%d">&nbsp;</td>', $columnCount );
			}

			$html .= '</tr>';

			return $html;
		}
	}
}
