<?php

/**
 * Student Account - View Achievemtns.
 *
 * This template can be overridden by copying it to yourtheme/wp-courseware/account/account-achievements.php.
 *
 * @package WPCW
 * @subpackage Templates\Account
 * @version 4.9.0
 *
 * Variables available in this template:
 * ---------------------------------------------------
 * @var array $achievements The array of student achievements.
 */

// Exit if accessed directly
defined('ABSPATH') || exit;

if (count($achievements) > 0) { 
	$points = 0;
	foreach ($achievements as $key => $item){
		$points += $item['points'];
	}
?>
	<div id="achievements-container">
		<h2><?= __("Total Points: ", 'wp-courseware') ?><?= $points ?></h2>
		<?php foreach ($achievements as $key => $item) { ?>
		<div class="achievement-container">
			<div class="achievement-badge-container">
				<div class="achievement-badge"><img class="achievement-badge-image" src="<?= $item['badge'] ?>" alt="achievement badge" /><p class="achievement-points">+<?= $item['points'] ?> Points</p></div>
			</div>
			<div class="achievement-text-container col">
				<div class="achievement-description"><p><?= $item['notification_text'] ?></p></div>
			</div>
		</div>
		<?php } ?>
	</div>
<?php } else {
	wpcw_print_notice(__("You haven't got any achievements yet.", 'wp-courseware'), 'info');
}