<?php

/**
 * Main Menu - Leaderboard Page.
 *
 * This template can be overridden by copying it to yourtheme/wp-courseware/account/account-leaderboard.php.
 *
 * @package WPCW
 * @subpackage Templates\Account
 * @version 4.6.4
 *
 * Variables available in this template:
 * ---------------------------------------------------
 * @var array $leaderboard The array of users achievements.
 */

// Exit if accessed directly
defined('ABSPATH') || exit;
if (count($leaderboard) > 0) : ?>
  <table class="wpcw_fe_table_leaderboard">
    <tbody>
      <tr>
          <th><?php _e("No.", "wp-courseware");?></th>
          <th><?php _e("Name", "wp-courseware");?></th>
          <th><?php _e("Points", "wp-courseware");?></th>
        </tr>
      <?php foreach ($leaderboard as $key => $item) { ?>
        <tr>
          <td><?= $key + 1 ?></td>
          <td><?= $item->display_name ?></td>
          <td><?= $item->total_points ?></td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
<?php else : ?>
  <?php wpcw_print_notice(__("No results found.", 'wp-courseware'), 'info'); ?>
<?php endif; ?>
