<?php
/**
 * Unit Single Conent.
 *
 * This template can be overridden by copying it to yourtheme/wp-courseware/unit/single-content.php.
 *
 * @package WPCW
 * @subpackage Templates
 * @version 4.9.0
 */

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

global $post;
$flag             = false;
$wpcw_divi_layout = '';

$fe = new WPCW_UnitFrontend( $post );

// Check if user is admin or teacher.
$is_admin_or_teacher = $fe->check_is_admin_or_teacher();
$user_id             = get_current_user_id();
$is_admin            = user_can( $user_id, apply_filters( 'wpcw_units_accessible_admin_capability', 'manage_wpcw_settings' ) );

if ( $is_admin_or_teacher === true ) {
	$has_access = true;
	$flag       = true;
} else {
	$has_access = false;
}

if ( function_exists( 'et_get_theme_version' ) || class_exists( 'FLThemeBuilder' ) ) {
	$wpcw_divi_layout = 'wpcw_divi_layout';
}

?>
<div class="wpcw-unit-wrapper <?php echo $wpcw_divi_layout; ?>">
	
<?php


// Ensure we're only showing a course unit, a single item.
if ( ! is_single() || 'course_unit' != get_post_type() || ! WPCW_units_getAssociatedParentData( $post->ID ) ) {
	return the_content();
}

// Divi Builder Check.
if ( function_exists( 'et_core_is_fb_enabled' ) && et_core_is_fb_enabled() ) {
	return the_content();
}

if ( post_password_required() && $has_access === false ) {
	echo get_the_password_form();
	return;
}

	// Run completed quiz/incomplete unit check
	WPCW_quiz_complete_unit_incomplete_fix();

	/**
	 * Hook: Before Unit Single Content
	 *
	 * @since 4.9.0
	 */
	do_action( 'wpcw_unit_before_single_content' );

if ( WPCW_check_course_expiration( get_the_ID() ) && $has_access === false ) {
	?>
		<p class="wpcw_expired_notification"><?php echo __( 'This course is expired.', 'wp-courseware' ); ?></p>
		<?php
} else {
	?>
		<div class="wpcw-unit-single-content">
			<div class="wpcw-unit-desc">
			<?php

			// If user is not logged in and is unit teaser.
			if ( ! $fe->check_user_isUserLoggedIn() && $fe->check_is_unit_teaser() ) {
				$flag = true;
				$has_access === true;
				the_content();
				$fe->render_detailsForContent( $content = '', $justGetCompletionAndQuizData = false );
				return;
			}

			// Ensure we're logged in
			if ( ! $fe->check_user_isUserLoggedIn() ) {
				echo $fe->message_user_notLoggedIn();
				return;
			}

			// If user is not logged in and is unit teaser.
			if ( ! $fe->check_user_canUserAccessCourse() && $fe->check_is_unit_teaser() ) {
				$flag = true;
				$has_access === true;
				the_content();
				$fe->render_detailsForContent( $content = '', $justGetCompletionAndQuizData = false );
				return;
			}

			// User not allowed access to content, so certainly can't say they've done this unit.
			if ( ! $fe->check_user_canUserAccessCourse() && $has_access === false ) {
				echo $fe->message_user_cannotAccessCourse();
				return;
			}

			// Is user allowed to access this unit yet?
			if ( ! $fe->check_user_canUserAccessUnit() && $has_access === false ) {
				$navigationBox = $fe->render_navigation_getNavigationBox();
				// Show the navigation box AFTErR the cannot progress message.
				echo $fe->message_user_cannotAccessUnit() . $navigationBox;
				return;
			}

			// Has user completed course prerequisites.
			if ( ! $fe->check_user_hasCompletedCoursePrerequisites() && $has_access === false ) {
				// on a unit that we're not able to complete just yet.
				$navigationBox = $fe->render_detailsForNvigationBox( $content = '', $justGetCompletionAndQuizData = false );

				// Show navigation box after the cannot process message.
				echo $fe->message_user_hasNotCompletedCoursePrerequisites() . $navigationBox;
				return;
			}
			$lockDetails = array(
				'content_locked' => false,
				'unlock_date'    => false,
			);

			$lockDetails = $fe->render_completionBox_contentLockedDueToDripfeed( $content = '', $justGetCompletionAndQuizData = false );
			if ( $lockDetails['content_locked'] === false || ( $flag === true && $has_access == true ) ) {
				   the_content();
			}

			$fe->render_detailsForContent( $content = '', $justGetCompletionAndQuizData = false );
			?>
			</div>
			<div class="wpcw-unit-completebox">
			<?php echo $fe->render_detailsForCompletebox( $content = '', $justGetCompletionAndQuizData = false ); ?>
			</div>
			<div class="wpcw-unit-navigation">
				<?php echo $fe->render_detailsForNvigationBox( $content = '', $justGetCompletionAndQuizData = false ); ?>
			</div>		
			<?php
			if ( wpcw_is_allow_show_note( get_the_ID() ) ) {
				?>
				  <div class="wpcw-toaster ets-collapse">
					<button id="wpcw-beg-btn" class="ets-toggle">
						<i class="beg-icon wpcw-fas wpcw-fa-angle-up"></i>
					</button>
					<div class="main-note-section">
						<div class="wpcw-notes-body">
							<div class="wpcw-success"></div>
							<div class="wpcw-tab">
							  <button class="tablinks" data-event="notes"><?php echo __( 'Notes', 'wp-courseware' ); ?></button>
							</div>
							<div id="notes" class="tabcontent">
							  <button class="wpcw-create-note"><?php echo __( 'Create a new note', 'wp-courseware' ); ?><span class="wpcw-plus-icon">+</span></button>
								<?php create_course_note_editor_html(); ?>
								  <input type="hidden" value="<?php echo get_the_ID(); ?>" name="unit_post_id" id="wpcw_parent_unit_post_id">
								<div class="wpcw-select-div">
									<select name="sort_by_unit" id="wpcw-unit-filter" class="wpcw-filter-select">
										<?php
											$unit_label = wpcw_get_unit_label();
											$unit_label_plural = wpcw_get_unit_label( true );
										?>
										<option value="single_unit"><?php echo sprintf( __( 'Current %s', 'wp-courseware' ), $unit_label ); ?></option>
										<option value="all_unit"><?php echo sprintf( __( 'All %s', 'wp-courseware' ), $unit_label_plural ); ?></option>
									</select>
									<select name="sort_by_asc_decs" id="wpcw-asc-desc-filter" class="wpcw-filter-select">
										<option value="desc"><?php echo __( 'Sort by most recent', 'wp-courseware' ); ?></option>
										<option value="asc"><?php echo __( 'Sort by oldest', 'wp-courseware' ); ?></option>
									</select>
								</div>
								<div class="wpcw-course-note-content">
										<?php
										$course_notes = get_wpcw_course_notes( get_the_ID(), get_current_user_id() );
										if ( $course_notes ) {

											foreach ( $course_notes as $key => $note_post ) {
												$note_id      = $note_post->ID;
												$post_date    = $note_post->post_date;
												$post_content = $note_post->post_content;
												?>
											 <div class="wpcw-content-div">
												<div class="wpcw-content-img">
													<span>
														<?php echo sprintf( __( 'Posted on %s', 'wp-courseware' ), date( 'm/d/Y', strtotime( $post_date ) ) ); ?>
														<br>
														
													</span>
													<i class="wpcw-edit-note wpcw-fa wpcw-fa-edit" data-note-id="<?php echo $note_id; ?>"></i>
													<i class="wpcw-delete-note wpcw-fa wpcw-fa-trash" data-note-id="<?php echo $note_id; ?>"></i>
												</div>
												<div class="note-content">
													<?php echo $post_content; ?>
											</div>
												<div class="edit-note-editor">
													<?php create_course_note_editor_html( $note_id, $post_content ); ?>
												</div>
											</div>
												<?php
											}
										} /*
										else{
										?>
										<div class="wpcw-no-result">
											<?php
											echo esc_html__('No notes found.', 'wp-courseware');
											?>
										</div>
										<?php
										} */
										?>
								</div>
							</div>					
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
		<?php
		/**
		 * Hook: After unit content
		 *
		 * @since 4.9.0
		 */
		do_action( 'wpcw_unit_after_single_content' );
}
?>
</div>
