/**
 * Library dependencies
 */
import { Checkbox, Input } from '../../../../lib/components'

/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n'
import classnames from 'classnames'

export function TimeForm({ video, setVideo, modalID }) {
	const { start_enabled, end_enabled, end_time, start_time } = video ?? {}

	const setEnabled = ({ type = 'start', value }) => {
		const finalValue = value ? 1 : 0

		if (type === 'start') {
			setVideo({
				...video,
				start_enabled: finalValue,
			})
		}

		if (type === 'end') {
			setVideo({
				...video,
				end_enabled: finalValue,
			})
		}
	}

	const setTime = ({ type = 'start', value }) => {
		if (type === 'start') {
			setVideo({
				...video,
				start_time: value,
			})
		}

		if (type === 'end') {
			setVideo({
				...video,
				end_time: value,
			})
		}
	}

	return (
		<>
			<div className="sui-form-field">
				<span className="sui-field-prefix">
					<Checkbox
						checked={!!start_enabled}
						label={__('Start at:', 'wpmudev_vids')}
						id={`${modalID}-video-start`}
						onChange={(value) =>
							setEnabled({ type: 'start', value })
						}
					/>
					<Input
						placeholder="00:00"
						value={start_time}
						checked={end_enabled}
						disabled={!start_enabled}
						onChange={(value) => setTime({ type: 'start', value })}
						className={classnames(
							'sui-input-sm',
							'sui-field-has-prefix'
						)}
					/>
				</span>
			</div>
			{typeof video.host !== 'undefined' && video.host === 'youtube' && (
			<div className="sui-form-field">
				<span className="sui-field-prefix">
					<Checkbox
						label={__('End at:', 'wpmudev_vids')}
						id={`${modalID}-video-end`}
						checked={!!end_enabled}
						onChange={(value) => setEnabled({ type: 'end', value })}
					/>
					<Input
						placeholder="00:00"
						value={end_time}
						disabled={!end_enabled}
						onChange={(value) => setTime({ type: 'end', value })}
						className={classnames(
							'sui-input-sm',
							'sui-field-has-prefix'
						)}
					/>
				</span>
			</div>
			)}
		</>
	)
}

export default TimeForm
