(function($) {
    "use strict";

    $(document).ready(function() {

        var fc_plugin_form = $( ".fc_plugin_form" );

        fc_plugin_form.on( "submit",function (e) {

                e.preventDefault();

                $( '#verification_mode' ).val( 'live' );

                $( ".fc-error-msg" ).remove();

                var formerror = false;

                $( "#customer_purchase_key" ).removeClass( "plugin-licence-error" );
                
                if ($( "#customer_purchase_key" ).val() == "") {
                        formerror = true;
                        $( "#customer_purchase_key" ).addClass( "plugin-licence-error" );
                }

                if (formerror)
                return false;

                // Validations passed, proceed request now.
                if ( ! formerror) {

                        $( ".fc-backend-loader" ).show();
                        var ajaxurl = 'https://www.wpmapspro.com/wp-admin/admin-ajax.php';
                        jQuery
                        .ajax(
                            {
                                type: "post",
                                dataType: "json",
                                url: ajaxurl,
                                data: fc_plugin_form.serialize(),
                            }
                        )

                        .done( function (data) { $( ".fc-backend-loader" ).hide(); } )

                        .fail( function (reason) {  $( ".fc-backend-loader" ).hide(); } )

                        .then(
                            function (data) {

                                if (typeof data.verified !== undefined && data.verified == true) {

                                    if (typeof data.codecanyon_api_call_result) {
                                        
                                        var purchase_data = data.codecanyon_api_call_result;
                                        var verification_mode = data.verification_mode;
                                        var platform          = data.platform;
                                        jQuery.ajax(
                                            {
                                                url: settings_obj.ajax_url,
                                                type: "post",
                                                dataType: "json",
                                                data: {

                                                    action: "wpdfenabledebug",
                                                    nonce: settings_obj.nonce,
                                                    purcahse_data : purchase_data,
                                                    platform : platform,
                                                    verification_mode : verification_mode

                                                },
                                            }
                                        )

                                        .done( function (data)   {  window.location.reload();  } )
                                        .fail( function (reason) {  $( ".fc-backend-loader" ).hide();  } );

                                    } 

                                } else {

                                    $( ".fc-backend-loader" ).eq( 0 ).after( '<div class="fc-12 fc-msg fc-danger fade in py-2 fc-error-msg">' + data.msg + "</div>" );
                                    $(window).scrollTop(0);  

                                }

                            }
                        );
                }

                return false;
            }
        );
        
        if($('#search_id-search-input').length > 0){ 
            $('#search_id-search-input').attr('placeholder','Please enter keywords and hit search button..');
        }

        var checked_chkboxes = [];

        $('.wp-list-table').find(':checkbox').change(function() {
        
            var temp = [];
            
            var checked_boxes = $('.wp-list-table').find(':checkbox').not('#cb-select-all-1');
            
            checked_boxes.each(function(){
                
                if($(this).is(":checked")){
                    temp.push(this.value);
                }
                
            });
            checked_chkboxes = temp;
          
        });
        
        $(document).on('click', '#doaction', function( e ) {
                
                e.preventDefault();

                if($('#bulk-action-selector-top').val() == '-1'){

                     $(".wpgmp_listing_form").submit();

                }else{

                    if($('#bulk-action-selector-top').val() == 'delete'){
                    
                        if(checked_chkboxes.length == 0){
                            alert(settings_obj.no_record_for_bulk_delete);
                            return;                           
                        }else{
                            
                            var result = confirm(settings_obj.confirm_bulk_delete);
                            if (result) {
                                $(".wpgmp_listing_form").submit();
                            }

                            
                        }
                        
                        return false;
                                
                    }else if($('#bulk-action-selector-top').val() == 'export_location_csv'){

                        $(".wpgmp_listing_form").submit();
                    }
                    
                    else{
                        
                        $('.modal-footer.delete').show();
                        $('.modal-footer.select-some').show();
                    }


                }
                  
         });

        jQuery(document).on('click', '.bulk-delete-btn', function( e ) {
      
          e.preventDefault();
          $(".wpgmp_listing_form").submit();
          
        });

        $('.delete_fc_record').click( function (event) {
            event.preventDefault();
            var triggerElement = jQuery(this); // Button that triggered the modal
            var current_id = triggerElement.data('item-id'); 
            var current_page = triggerElement.data('page-slug');
            var record_type = triggerElement.data('record-type');
            var _wpnonce = $('#_wpnonce').val();
            if(record_type == 'location_id'){
                var result = confirm(settings_obj.confirm_location_delete);
            }else if(record_type == 'map_id'){
                var result = confirm(settings_obj.confirm_map_delete);
            }else if(record_type == 'group_map_id'){
                var result = confirm(settings_obj.confirm_category_delete);
            }else{
                var result = confirm(settings_obj.confirm_record_delete);
            }
            if (result) {
                var delete_url = '?page='+current_page+'&doaction=delete&'+record_type+'='+current_id+'&_wpnonce='+_wpnonce;
                window.location.href = delete_url;
            }
            
        });


        $(document).on('click', '.add_more_custom_control_setting', function() {

            if($(this).closest('section').length > 0){
                $($(this).closest('section')).clone().insertAfter($(this).closest('section'));    
            }
        });


        $(".referrer_to_copy.copy_to_clipboard").click(function () { 

            var referrer_to_copy  = $(this).parent('.tooltip').prev('.referrer_to_create').val();
            navigator.clipboard.writeText(referrer_to_copy);
            $('span.tooltiptext').html(wpgmp_local.do_referrer_copy);
            $(this).find('span.tooltiptext').html(wpgmp_local.referrer_copied);
            
        });

        $('.wp-list-table .copy_to_clipboard').on('click', function(){

          $('.fc-tooltip').removeClass('active');

          var value = $(this).data('clipboard-text'); 

          var $temp = $("<input>");

          $("body").append($temp);

          $temp.val(value).select();

          document.execCommand("copy");

          $temp.remove();

          $(this).closest('.fc-tooltip').addClass('active');
          
          setTimeout(
            function() { 
             $('.fc-tooltip').removeClass('active');
             $('tr').removeClass('active');
          }, 1000);
    

        });

        if(typeof google_customizer_fonts !== 'undefined'){

            var result = Object.keys(google_customizer_fonts).map(function(key) {
              return google_customizer_fonts[key];
            });

            if (result && result.length > 0) {
                for (var i in result ) {
                    var font = result[i];

                    if (font.indexOf(',') >= 0) {
                        font = font.split(",");
                        font = font[0];
                    }
                    if (font.indexOf('"') >= 0) {
                        font = font.replace('"', '');
                        font = font.replace('"', '');
                    }
                    WebFont.load({
                        google: {
                            families: [font]
                        }
                    });

                }
            }
        }

        var wpgmp_timeouts = [];
        $('body').on('click', 'input[name="fc-geocoding-abort"]', function(e) {

            $(this).hide();
            var new_locations = $(this).parent().parent().find('.fc-location-new-set');
            var progress = $(this).parent().parent().find('.fc-geocoding-progress');
            var geocode_instructions = settings_obj.geocode_success;
            var geocode_stats = settings_obj.geocode_stats;
            for (var i = 0; i < wpgmp_timeouts.length; i++) {
                clearTimeout(wpgmp_timeouts[i]);
            }

            $('.fcdoc-loader').hide();
            $('.fc-geocoding').hide();
            $(progress).hide();
            if ($(new_locations).val() != '') {
                var final_records = JSON.parse($(new_locations).val());
                $('.wpgmp-status').html('<div class="fc-msg fc-success">' + final_records.length + " " + geocode_stats + '. ' + geocode_instructions + ".</div>").show();
                $('.fc-geocoding-updates').show();
            } else {
                $('.wpgmp-status').html('<div class="fc-msg fc-danger"> 0 ' + geocode_stats + '.</div>').show();
            }

        });
        $('body').on('click', 'input[name="fc-geocoding"]', function(e) {
            e.preventDefault();
            $(this).hide();
            $(".wpgmp_geo_adv").hide();
            $(this).parent().parent().find('.fcdoc-loader').show();
            $(this).parent().parent().find('.fc-geocoding-abort').show();
            var progress = $(this).parent().parent().find('.fc-geocoding-progress');
            var is_advanced = $("input[name='wpgmp_geo_adv']").is(":checked");
            var new_locations = $(this).parent().parent().find('.fc-location-new-set');
            var geocode_instructions = settings_obj.geocode_success;
            var geocode_stats = settings_obj.geocode_stats;
            /* Start Geocoding */
            var source_csv_records = JSON.parse($(this).parent().parent().find('.fc-location-data-set').val());
            var final_records = [];
            var delay = 1000; //0.5 second
            var geocoder = new google.maps.Geocoder();
            var object_count = 0;
            $.each(source_csv_records, function(id, csv_record) {
                object_count++;
            });

            var new_object_count = 0;
            $.each(source_csv_records, function(id, csv_record) {

                wpgmp_timeouts[new_object_count] = setTimeout(function() {

                    var geocode_options = {
                        'address': csv_record.address
                    };

                    if (is_advanced === true) {

                        var componentRestrictions = {};

                        if (csv_record.country) {
                            componentRestrictions["country"] = csv_record.country;
                        }

                        if (csv_record.postal_code) {
                            componentRestrictions["postalCode"] = csv_record.postal_code;
                        }

                        if (componentRestrictions.country || componentRestrictions.postalCode) {
                            geocode_options["componentRestrictions"] = componentRestrictions;
                        }

                        if (csv_record.state) {
                            geocode_options["region"] = csv_record.state;
                        }

                    }

                    geocoder.geocode(geocode_options, function(results, status) {

                        if (results != null && results.length > 0) {
                            var lat = results[0].geometry.location.lat() ? results[0].geometry.location.lat() : '';
                            var lng = results[0].geometry.location.lng() ? results[0].geometry.location.lng() : '';
                            var current_record_output = '{"id":"' + id + '","latitude": "' + lat + '", "longitude": "' + lng + '"}';
                            var current_record_output_obj = JSON.parse(current_record_output);
                            final_records.push(current_record_output_obj);
                            $(new_locations).val(JSON.stringify(final_records));
                            $(progress).html(final_records.length + ' ' + geocode_stats + '.');
                        }

                        if (new_object_count == object_count) {

                        }
                    });
                }, delay);
                new_object_count++;
                delay += 500;
            });

            setTimeout(function() {
                $('.fcdoc-loader').hide();
                $('.fc-geocoding').hide();
                $('.fc-geocoding-abort').hide();
                $('.fc-geocoding-progress').hide();

                if ($(new_locations).val() != '') {
                    var final_records = JSON.parse($(new_locations).val());
                    $('.wpgmp-status').html('<div class="fc-msg fc-success">' + final_records.length + " " + geocode_stats + '. ' + geocode_instructions + ".</div>").show();
                    $('.fc-geocoding-updates').show();
                } else {
                    $('.wpgmp-status').html('<div class="fc-msg fc-danger"> 0 ' + geocode_stats + '.</div>').show();
                }

            }, delay + 2000);

        });
        if($('.wpgmp_datepicker').length > 0 ) {

            $('.wpgmp_datepicker').datepicker({
                dateFormat: 'dd-mm-yy'
            });
        }
        

        var wpgmp_image_id = '';
        //intialize add more...

        
        $(".wpgmp_check_key").click(function() {
            $('.wpgmp_apitest').html("...");
            var wpgmp_maps_key = $("input[name='wpgmp_api_key']").val();
            var address = 'london';
            $.get("https://maps.googleapis.com/maps/api/geocode/json?address=1600+Amphitheatre+Parkway,+Mountain+View,+CA&key=" + wpgmp_maps_key, function(data) {
            console.log(data);
            if (data.status == 'OK') { 
                     $('.wpgmp_apitest').html("<div class='fc-msg fc-success'>Congratulation, the API key you created is perfect. You can now <a class='create_location_link' target='_blank' href='https://www.wpmapspro.com/docs/create-a-location-using-simple-method/'>start</a> creating maps!</div>");
                } else {
                     $('.wpgmp_apitest').html("<div class='fc-msg fc-danger'>"+data.error_message+"</div>");
                }

            });
        });

        $(".cancel_import").click(function() {
            var wpgmp_bid = confirm("Do you want to cancel import process?.");
            if (wpgmp_bid == true) {
                $(this).closest("form").find("input[name='operation']").val("cancel_import");
                $(this).closest("form").submit();
                return true;
            } else {
                return false;
            }
        });

        $("select[name='map_id']").change(function() {
            $(this).closest('form').submit();
        });
        $("select[name='filter_location']").change(function(event) {

            event.preventDefault();

            var what_value = $(this).val();

            if (what_value > 0) {
                $("tr[class^='filter_group_cat']").hide();
                $(".filter_group_cat" + $(this).val()).show("slow");
            } else {
                $("tr[class^='filter_group_cat']").show("slow");
            }

        });

        $(".wpgmp_search_input").keyup(function() {
            map_id = $(this).attr("rel");
            $(".wpgmp_locations_listing[rel='" + map_id + "']").addClass("wpgmp_loading");
            wpgmp_filter_locations(map_id, 1);
        });

        $(".wpgmp_toggle_container").click(function() {
            $(".wpgmp_toggle_main_container").toggle("slow");
            if ($(this).text() == "Hide") {
                $(this).text("Show");
            } else {
                $(this).text("Hide");
            }
        });

        $(".wpgmp_mcurrent_loction").click(function() {
            wpgmp_get_current_location();
        });

        $(".wpgmp-select-all").click(function() {
            var checkAll = $(".wpgmp-select-all").prop('checked');
            if (checkAll) {
                $(this).closest('table').find(".wpgmp-location-checkbox").prop("checked", true);
            } else {
                $(this).closest('table').find(".wpgmp-location-checkbox").prop("checked", false);
            }
        });

        $(".wpgmp-location-checkbox").click(function() {
            if ($(".wpgmp-location-checkbox").length == $(".wpgmp-location-checkbox:checked").length) {
                $(".wpgmp-select-all").prop("checked", true);
            } else {
                $(".wpgmp-select-all").prop("checked", false);
            }
        });


        var category_assign_table = $('#wpgmp_assign_category_tbl').dataTable({
            "lengthMenu": [
                [10, 25, 50, 100, 200, 500, -1],
                [10, 25, 50, 100, 200, 500, "All"]
            ],
            "order": [
                [2, "asc"]
            ],
            "columns": [
                { "width": "5%" },
                null,
                null,
                null
              ],
            "language": { "search":"", "searchPlaceholder": "Search..." }

        }); 

        var maptable = $('#wpgmp_google_map_data_table').dataTable({
            "lengthMenu": [
                [10, 25, 50, 100, 200, 500, -1],
                [10, 25, 50, 100, 200, 500, "All"]
            ],
            "order": [
                [1, "desc"]
            ],
            "aoColumns": [{
                sWidth: '5%',
                "bSortable": false
            }, {
                sWidth: '40%'
            }, {
                sWidth: '30%'
            }, {
                sWidth: '20%'
            }],
            "language": { "search":"", "searchPlaceholder": "Search..." }

        });

        var route_maptable = $('#wpgmp_google_map_route_data_table').dataTable({
            "lengthMenu": [
                [10, 25, 50, 100, 200, 500, -1],
                [10, 25, 50, 100, 200, 500, "All"]
            ],
            "aoColumns": [{
                sWidth: '10%'
            }, {
                sWidth: '35%'
            }, {
                sWidth: '35%'
            }, {
                sWidth: '20%'
            }]
        });

        $('input[name="save_entity_data"]').click(function() {
            var data = maptable.$('input[type="checkbox"]:checked');
            var selected_val = [];
            if (data.length > 0) {
                $.each(data, function(index, chk) {
                    selected_val.push($(chk).val());
                });
                $('input[name="map_locations"]').val(selected_val);
            }

            return true;
        });

         $('input[name="save_entity_data"]').click(function() {
            var data = category_assign_table.$('input[type="checkbox"]:checked');
            var selected_val = [];
            if (data.length > 0) {
                $.each(data, function(index, chk) {
                    selected_val.push($(chk).val());
                });
                $('input[name="location_group_map"]').val(selected_val);
            }

            return true;
        });

        $('select[name="select_all"]').change(function() {

            if ($(this).val() == 'select_all'){
                 
                $('input[name="map_locations[]"]').prop('checked',true);
                $('input[name="map_locations[]"]').attr('checked', true);
                $('input[name="select_route_way_points[]"]').prop('checked',true);
                $('input[name="select_route_way_points[]"]').attr('checked', true);

            }
            else if( $(this).val() == 'deselect_all') {
                $('input[name="map_locations[]"]').attr('checked', false);
                $('input[name="map_locations[]"]').removeAttr('checked');
                $('input[name="select_route_way_points[]"]').attr('checked', false);
                $('input[name="select_route_way_points[]"]').removeAttr('checked');

            }
            
        });

        $('input[name="save_route_data"]').click(function() {
            var data = maptable.$('input[type="checkbox"]:checked');
            var selected_val = [];
            if (data.length > 0) {
                $.each(data, function(index, chk) {
                    selected_val.push($(chk).val());
                });
                $('input[name="route_way_points"]').val(selected_val);
            }

            return true;
        });

        $('.switch_onoff').change(function() {
            var target = $(this).data('target');
            if ($(this).attr('type') == 'radio') {
                $(target).closest('.form-group').hide();
                target += '_' + $(this).val();
            }
            if ($(this).is(":checked")) {
                $(target).closest('.form-group').show();
            } else {
                $(target).closest('.form-group').hide();
                if ($(target).hasClass('switch_onoff')) {
                    $(target).attr('checked', false);
                    $(target).trigger("change");
                }
            }


        });

        $.each($('.switch_onoff'), function(index, element) {
            if (true == $(this).is(":checked")) {
                $(this).trigger("change");
            }

        });

        if($('.wpgmp-overview .color').length > 0 ) {
            $('.wpgmp-overview .color').wpColorPicker();
        }

    });

    var re = /([^&=]+)=?([^&]*)/g;
    var decodeRE = /\+/g; // Regex for replacing addition symbol with a space
    var decode = function(str) {
        return decodeURIComponent(str.replace(decodeRE, " "));
    };
    $.parseParams = function(query) {
        var params = {},
            e;
        while (e = re.exec(query)) {
            var k = decode(e[1]),
                v = decode(e[2]);
            if (k.substring(k.length - 2) === '[]') {
                k = k.substring(0, k.length - 2);
                (params[k] || (params[k] = [])).push(v);
            } else params[k] = v;
        }
        return params;
    };

    // Function to handle clicks on elements with the '.fc_tutorial_link' class
    function handleTutorialLinkClick(event) {
        // Prevent the default behavior of parent elements' click events
        event.stopPropagation();

        // Open the URL in a new tab
        const urlToOpen = $(this).attr('href');
        if (urlToOpen) {
            window.open(urlToOpen, '_blank');
        }
    }

    // Add the click event handler to all elements with the '.fc_tutorial_link' class
    $('.fc_tutorial_link').click(handleTutorialLinkClick);


})(jQuery);

function send_icon_to_map(imagesrc, target) {
        jQuery('#remove_image_' + target).show();
        jQuery('#image_' + target).attr('src', imagesrc).show();
        jQuery('#input_' + target).val(imagesrc);
        tb_remove();
}