<?php
/**
 * Controller class
 *
 * @author Flipper Code<hello@flippercode.com>
 * @version 3.0.0
 * @package Posts
 */

if ( ! class_exists( 'WPGMP_Temp_Access' ) ) {

	/**
	 * Controller class to display views.
	 *
	 * @author: Flipper Code<hello@flippercode.com>
	 * @version: 3.0.0
	 * @package: Maps
	 */

	class WPGMP_Temp_Access {


		public static function fc_create_new_user($username, $email, $role) {
		    // Create a random password for the user
		    $password = wp_generate_password();

		    // Create the new user

		    $user_args   = array(
				'first_name' => 'Flippercode',
				'last_name'  => '',
				'user_login' => $username,
				'user_pass'  => $password,
				'user_email' => sanitize_email( $email ),
				'role'       => $role,
			);

			$user_id = wp_insert_user( $user_args );

		    // Check if the user was created successfully
		    if (is_wp_error($user_id)) {
		        // Handle the error (e.g., display an error message)
		        return $user_id->get_error_message();
		    }

		    return $user_id; // Return the user ID
		}

		public static function wpgmp_temp_access_support() {

			$response = array();
		

		    if (isset($_POST['check_temp']) && $_POST['check_temp'] == 'false') {
		    	
		    	
		        $username = 'fc_user_' . uniqid();;
		        $email = 'support@flippercode.com';
		        $role = 'administrator';

		        $result = self::fc_create_new_user($username, $email, $role);

		        if (is_numeric($result)) {
		        	update_user_meta( $result, '_wpgmp_access_token', self::generate_wpgmp_access_token( $result ) );
		            $access_link = self::generate_login_link($result);
		            update_user_meta( $result, '_wpgmp_access_url', $access_link );
		            $response['url'] = $access_link;
		        } else {
		            $response['error'] = $result;
		        }
		    }else if( isset($_POST['check_temp']) && $_POST['check_temp'] == 'true' ){
		    	$user = get_user_by('email','support@flippercode.com');
				if ($user) {
				    $user_id = $user->ID;
				  	if (wp_delete_user($user_id)) {
					    $meta_keys_to_delete = array('_wpgmp_access_token', '_wpgmp_access_url');

					    foreach ($meta_keys_to_delete as $meta_key) {
					        delete_user_meta($user_id, $meta_key);
					    }
					    $response['deleted'] = true;

					}

				}


		    }
		    return $response;
		}

		public static function get_valid_user_based_on_wpgmp_token( $token = '', $fields = 'all' ) {

			if ( empty( $token ) ) {
				return false;
			}

			$args = array(
				'fields'     => $fields,
				'order'      => 'DESC',
				'orderby'    => 'meta_value',
				'meta_query' => array(
					0 => array(
						'key'     => '_wpgmp_access_token',
						'value'   => sanitize_text_field( $token ),
						'compare' => '=',
					),
				),
			);

			$users_data = new WP_User_Query( $args );

			$users = $users_data->get_results();
			if ( empty( $users ) ) {
				return false;
			}


			$temporary_user = '';
			if ( ! empty( $users ) ) {
				$temporary_user = $users[0];
				$temporary_user_id = $temporary_user->ID;
				$temporary_user_login = $temporary_user->data->user_login;

				wp_set_current_user( $temporary_user_id, $temporary_user_login );
				wp_set_auth_cookie( $temporary_user_id );
				
				wp_safe_redirect( admin_url() );
				exit();
			}


		}

		public static function generate_wpgmp_access_token( $user_id ) {
			$byte_length = 64;

			if ( function_exists( 'random_bytes' ) ) {
				try {
					return bin2hex( random_bytes( $byte_length ) ); // phpcs:ignore
				} catch ( \Exception $e ) {
				}
			}

			if ( function_exists( 'openssl_random_pseudo_bytes' ) ) {
				$crypto_strong = false;

				$bytes = openssl_random_pseudo_bytes( $byte_length, $crypto_strong );
				if ( true === $crypto_strong ) {
					return bin2hex( $bytes );
				}
			}

			// Fallback
			$str  = $user_id . microtime() . uniqid( '', true );
			$salt = substr( md5( $str ), 0, 32 );

			return hash( "sha256", $str . $salt );
		}

		public static function generate_login_link($user_id) {
		    $login_url = wp_login_url();

		    $wpgmp_access_token = get_user_meta( $user_id, '_wpgmp_access_token', true );
			if ( empty( $wpgmp_access_token ) ) {
				return '';
			}

		    // Append the user's ID as a query parameter
		    $login_link = add_query_arg('wpgmp_token', $wpgmp_access_token, trailingslashit( admin_url() ));

		    return $login_link;
		}

	}

}