<?php
/**
 *Marker Spiderfier Effect for overlapping markers in google maps.
 *
 * @package Maps
 * @author Flipper Code <hello@flippercode.com>
 */

//echo '<pre>'; print_r($data); exit;


$form->add_element(
	'group', 'map_marker_spidifier_group', array(
		'value'  => esc_html__( 'Overlapping Markers Spiderfier Settings', 'wpgmp-google-map' ),
		'before' => '<div class="fc-12">',
		'after'  => '</div>',
		'tutorial_link' => 'https://www.wpmapspro.com/docs/how-to-use-spiderfier-effect-for-overlapping-markers-on-map/'
	)
);

$form->add_element(
	'checkbox', 'map_marker_spiderfier_setting[marker_spiderfy]', array(
		'label'   => esc_html__( 'Display Marker Spiderfier Effect', 'wpgmp-google-map' ),
		'value'   => 'true',
		'id'      => 'wpgmp_marker_spider',
		'current' => isset( $data['map_all_control']['map_marker_spiderfier_setting']['marker_spiderfy'] ) ? $data['map_all_control']['map_marker_spiderfier_setting']['marker_spiderfy'] : '',
		'desc'    => esc_html__( 'Please check to enable the marker spiderfier effect on makers. This feature is used to let users easily view the content of those markers that share the same latitude & longitude. It handeles the overlapping of markers gracefully.', 'wpgmp-google-map' ),
		'class'   => 'chkbox_class switch_onoff',
		'data'    => array( 'target' => '.marker_spider_setting' ),
		'before' => '<div class="fc-8">',
		'after'  => '</div>',
	)
);

$form->add_element(
	'checkbox', 'map_marker_spiderfier_setting[marker_enable_spiral]', array(
		'label'   => esc_html__( 'Display Spiral Effect', 'wpgmp-google-map' ),
		'value'   => 'true',
		'id'      => 'marker_cluster_style',
		'current' => isset( $data['map_all_control']['map_marker_spiderfier_setting']['marker_enable_spiral'] ) ? $data['map_all_control']['map_marker_spiderfier_setting']['marker_enable_spiral'] : '',
		'desc'    => esc_html__( 'Apply spiral effect instead of circle effect when marker is clicked', 'wpgmp-google-map' ),
		'class'   => 'chkbox_class switch_onoff marker_spider_setting',
		'show'    => 'false',
		'data'    => array( 'target' => '.marker_minimum_spiral_number' ),
		'before' => '<div class="fc-8">',
		'after'  => '</div>',
	)
);

$form->add_element(
	'text', 'map_marker_spiderfier_setting[minimum_markers]', array(
		'label'         => esc_html__( 'For Spiral, Minimum No Of Markers', 'wpgmp-google-map' ),
		'value'         => isset( $data['map_all_control']['map_marker_spiderfier_setting']['minimum_markers'] ) ? $data['map_all_control']['map_marker_spiderfier_setting']['minimum_markers'] : '0',
		'default_value' => 'Infinity',
		'desc'          => esc_html__('This is the lowest number of markers that will be fanned out into a spiral instead of a circle. Set this to 0 to always get spirals, or Infinity for all circles.', 'wpgmp-google-map' ),
		'class'         => 'form-control marker_minimum_spiral_number',
		'before'        => '<div class="fc-5">',
		'after'         => '</div>',
		'show'          => 'false',
	)
);