<?php
wp_enqueue_style( 'corvid' );
wp_enqueue_script( 'corvid' );
$all_options = get_option( 'covid_options' );
?>

<div class="map_nCoV color-<?php echo esc_attr($params['color'] ? $params['color'] : 'red'); ?> <?php echo $all_options['cov_theme'];?> <?php if((isset($all_options['cov_rtl']) ? $all_options['cov_rtl'] : null)=='on') echo 'rtl_enable'; ?>" style="font-family:<?php echo $all_options['cov_font'];?>">
<script src="<?php echo plugin_dir_url( dirname( __FILE__ ) ) . 'assets/js/map-zoom.min.js?v=2.1.2'; ?>"></script><script src="<?php echo plugin_dir_url( dirname( __FILE__ ) ) . 'assets/js/map-zoom-cr.min.js?v=2.1.2'; ?>"></script>
	<div id="nycreatis-svgMap-wrap" class="nycreatis-svgMap-wrap">
	<svg id="nycreatis-nCoVsvgmapCa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="display: inline; width: inherit; min-width: inherit; max-width: inherit; height: inherit; min-height: inherit; max-height: inherit; " viewBox="-24500 -27050 55700 47100">
	<style type="text/css">
		path{
			stroke-linejoin:round;
			stroke-linecap:round;
		}
	</style>
	<defs id="defs1">
		<mask id="all">
			<g>
				<path fill="#fff" stroke="none" d="m-24500-27050h55700v47100h-55700z"/>
				<use id="LAKES" fill="#000" xlink:href="#Lakes"/>
				<g fill="none" stroke="#000" stroke-width="40">
					<path d="m17072 12065 28-30 64-131 127-130-1-96 54-71 63-32 25-62 28-33 19-59 73 5 56-12 285-249 16-46v-43"/>
				</g>
				<g fill="none" stroke="#000" stroke-width="96">
					<path d="m-13214-2631-2585 6234 21 34 36 19-38 54 64 42 16 107-32 22-80-70h-21l41 308 182 90 15 202 121 119 40-106 47 14 81 170-39 63 29 203 110 82-44 74 43 144-68 23 46 196-56 91 4 12 116 5 74-85 126 216-122 52 37 114 47 4 41 98 43-16 127 23-23 112 111 256-23 31 17 31 7 157 63 18 88-92 49 40 2 151 42 87-12 41 41 37 1 17-16 17 9 50 43 28-47 138 145 187-45 81 149 114 77 229-69 6 112 241 56-13 1 94-28 6 34 64-5 65 53-31 95 16 29 161 57 134-29 112 8 75-25 74 18 72-22 104-18-8-29 74 11 83-8 47-20 14 2 44-40 24-12 68-62-3 4 73 91 32-49 93-15 79 52 71 17 161 111 67 40 55-16 67 44 62-21 43 2 5"/>
					<path d="m-8064-955-1627 6771-240 997-947 3941"/>
					<path d="m-3793-208-459 4145h2l-41 378 24 3-41 378 24 3-41 378 24 3-41 379 23 3-41 379 24 2-41 380 25 3-40 380 23 3-41 381 23 2-40 381 19 2-40 382 22 2-40 382 19 2-40 382 22 2-36 344 5 1-40 387 21 2-40 388 21 2-40 390 23 2-40 389 21 3-21 201-19 189 21 2-39 390 18 2-40 393 22 2-19 197"/>
					<path d="m3578 3252L872 6807l-974 991-9 3817-1 429"/>
					<path d="m10559 8018 1045 4210-23 144 163 171 37 170 96 87 55 80 97 82 29 1 93 128 76 53 54 93 117 80 119 42 14 47 37 16 235-29 65 25 40-37 87-23 80 14 37-17 122 15 121-3 4-22 91 19 272 95 18 71 87 72 183 41 49-38-39-84 26-21 65-4 52 30 5 78 32 53 48-7 23 35-16 33 117 117 114-12 100 38 93-48-10-45 95-39 108 19 128 82 39-15 89-132 218-162 59-70 92-21 69-44 37-71 166-29 52-34 91 18 61-10-1 3 77 1 26 304 156 84-71 93-17 81-3-1-20 28-23 18-22 9-37 38-8 18"/>
					<path d="m15755-4173-90 42-53 69 7 32 92 19 70-15 32 46-72 45 43 57-106 27 89 74 125-23-4 72-40 5-2 80 86 95-36 77 23 108 109 6 79 43 31-41 42-111 66-2-50 132 92 189 81 118 75-26 81 53-78 78-158-30-69 38 55 161 70-73 109 19 31-44 138-34 36 96 65 10 15-86 93-139 137-14 83 55-94 107-157 98 7 112 84 58 29-82 42 2 56 46-5 78-59 16 18 81-73 36 29 152-66 93 54 114 116-21 216 218 5-51 69-26 53 78 125-10-20-65 28-31 42 72-46 133 76 118 68 64-63 73 30 86 75-28 47 179-46 9 122 203-65 48 38 80-30 110 198 105 66 73-29 65-116 33 144 136 61-58 75 39-78 108 73 71 57-98 51 53 54-42 49 18 112-63-5 48-153 186 157 92 31 126 47-18 60 147-33 49 87 27 195-92 25 30-123 99 30 34-58 67 52 15 116-66-44 149 122 245-163 20 85 124-37 60 188 83-179 131-142-70-193 13-10 88-130 48-33-89-160-35-102 12-26 176-144 42 75 52 23 55-127 23-4 51-157-87-43-74-122 55-73-27-50 32-353-197-9 39-121-69-7 58 109 44 8 116 127 89-39 36 154 146 12 109-199-23-285-120 7-37-73-13-66 68 218 159 185 98-68 154 47 104-179-36 39 96-115 118 170 233-67 83 48 121 272 102-43 60 20 32 54-19 230 151 149-49 135 84-37 98 52 34 82 232-206-33-57 82 172 223 107 6 28-66 88 99 118 38 84-145-51-189 69-172 186 147-79 37 206 222-123-22 187 286-72 46 74 101 109 64 45-44-88-149 191 87 24 79 96-4 38-84 120-36 62 69 36-136a43104 43104 0 0 0 6 0l8 1 23 48 126 48 60 143 37-71 121 70 151-37-3-52 100-37 37-13 175 128 37-131 47-31 5-79-101-82-66-132 59-40 4 4-66-89 11-106-89-98 2-161-129-141-43-165 208-170 14-141 71 105 173 33-230 176-77 94-8 122 93 84 166-14 209 202-112 42 62 67a43223 43223 0 0 0 3895-2352l121 177 133 196h-1l108 160"/>
					<path d="m19218 9964 154-127 124-149 72-186-165-371 179-80-38-86 357-162-3 17 35 57 40-8 26-3 106 8 22 16 3-58 39-21 57-8 34-56 46-49 84 19-30-57 9-47 38-47 51-12 4-11"/>
					<path d="m23343 9612 4 17-73 35-4 8 4 16-6 60-13 54 4 46"/>
					<path d="m-15092-14714-775 1016v11l-33 36-1 14 52 67-130 203-42 119-122 63-92 171a26929 26929 0 0 0 801 583l-103-46-29 68 42 50-44 160-111-13 53 227-63 6-1 2-184 156 67 69-47 135-118 34 29 71-66 50 50 74 209-8 26 76-80 52 28 50 124-58 70 13-20 65 78 22-22 41-145 22 37 154-33 174-179 118 2-2-93 15-70 63-112-10-30 86 94 9-62 100 67 43-17 50-108 10-42 87-87 16-3 71 76 24 32 134 41 42-30 182 66 60-152 89 124 71 93-20 74 95-27 292-69 14-6 115 49 27-57 35 70 126 23 134 104 9-55 105-120-7 3 70 74-3 11 300-61-21-55 105-80-37-65 33 64 125-23 125 74 91-168 128-38 333 75 189-108 38 23 48-95 71 15 80-70 45 172 178 129 2 29 274-17 102 64 15 6 65-67 43 115 381 110 45 45 84-88 299-84 14-33 110 72 23-103 281 98 42 67-2 63 67 54 37 45-77 56 30 32 76 117-61 17 131 35 28 47-10 34 78 80 37 55-26 178 56 65-96 120 71-62 192-93 36 1 285 84 60-56 82-22 329 1 10 53 113"/>
					<path d="m-3208-21147-2324 9668a23675 23675 0 0 1-900-235l-26 92-3 27 38-1 5 26-46 12-42-9-21-20-9 31-84-24 50-173a23675 23675 0 0 1-1498-488l-51 110 86 328-69-30-1389-451-663 1553 2397 3710a28552 28552 0 0 0 795 212l421 843 1906 706 1349 501-503 4551"/>
					<path clip-path="url(#nu_nl-clip)" d="m15741-4139 5-203"/>
					<path d="m-22032-7952a34499 34499 0 0 0 5051 3483 34499 34499 0 0 0 1885 991 34499 34499 0 0 0 1882 847A34499 34499 0 0 0-8064-955a34500 34500 0 0 0 4271 747 34500 34500 0 0 0 4 0A34500 34500 0 0 0 94 1"/>
				</g>
			</g>
		</mask>
		<clipPath id="nu_nl-clip">
			<use xlink:href="#killiniq"/>
		</clipPath>
		<clipPath id="nt_nu-clip">
			<use xlink:href="#victoria"/>
			<use xlink:href="#melville"/>
			<use xlink:href="#mackenzie_king"/>
			<use xlink:href="#borden"/>
		</clipPath>
	</defs>
	<g id="Lakes_and_Rivers" display="none">
		<g id="Islands">
			<g id="i-CA">
				<g id="i-CA-BC">
					<path id="anger" d="m-21681 917 22 17-9 21-48 37-14-6-20-65z"/>
					<path id="anvil" d="m-19782 6946 7 2 10 17-7 28-17 6-7-21 3-13 9-4z"/>
					<path id="aristazabal" d="m-21734 1827 21-8 20 42 7 45 18 48 6 72 12 27 12 92-32 36-21 43-28 37-33 18-10-16 27-78-32 9-16-58 4-42 19-12-19-15-11-43 14-56 11-15-13-25 3-19 10-3-5-37 14-15 17 2z"/>
					<path id="athlone" d="m-21554 2662 35 22-44 33 2 23-15 8-20-2-5-9-44-20z"/>
					<path id="baker1" d="m-21198 4722 2 7-15 10-9-11-32 2-22-26 27-5 24 16z"/>
					<path id="banks1" d="m-22014 704 45-72 48 18 84 140 47 101 27 94 12 86v125l-12 94-45 38-20-18 1-21-24-10-13 10-43-19 4-65-25-74 18-58-38-102-25-20-17-114 10-24 29-12 19 1-2-17-22 5-27-5-18-28 8-20z"/>
					<path id="barnard" d="m-21817 1450 29 45v31l6 20-16-12-27-69z"/>
					<path id="baron" d="m-21598-262 1 19-36 19-34-1 10-16z"/>
					<path id="bligh" d="m-21787 5782 19-8 13 37-34 13-13 18-22 9-5-8 27-15 12-15-19 13-17-19 22-16 5 4 10-3z"/>
					<path id="bonwick" d="m-21282 4732 2 10-14 13-12 2-3 7-18-1-9-18 4-11 8-6z"/>
					<path id="bowen" d="m-19872 7078 31 8 1 11-48 49-23 10-32-14-13-12 16-9-1-19 43-19z"/>
					<path id="bramham" d="m-21669 4057 32 20-24 25-40-9-7-39z"/>
					<path id="brougton" d="m-21248 4602 31 5 17 41-7 23 17 18-13 12-31-26-7-21-15 8-36-15-41 4-29-17-19-21-35-88 16-1 41 23 16 8 40 9 2 9 26 12 2-14 11-2z"/>
					<path id="burnaby" d="m-23143 1461 69 2 26 19-18 21-58 16 28 29-27 21-23-17-20 16-6-6z"/>
					<path id="calvert" d="m-21681 3335 77 54 9 51-10 46-27 28-26 94-35 18-14-17-15-78-19 12-27-46 32-98-4-31 30-63 27 10 11-14 17 1z"/>
					<path id="campania" d="m-21659 1394 31 11-4 37 6 46-7 38 20 73-32 76-24 1-22-58-11-158 17 1v-24l-17 4 4-25 17-19z"/>
					<path id="campbell" d="m-21396 2825-22-6-51 91-9-4-5 10-35 7 2 11-18 29-31-45 24-20 16-27-20-43 43-20 21-24 54 6 3-20z"/>
					<path id="chaatl" d="m-23339 402 53 31-11 24-11-4-73-51-16-39 23-21z"/>
					<path id="chatfield" d="m-21336 2724 45 1 16 15v20h-35l-16 18-26 11-27-11-26-34 47-10 28 18z"/>
					<path id="cortes" d="m-20531 5738 14-1 14 133-19 6-14 76-34-24-1 16-29-1-30 22-2-17 15-24 23-19-25-29-12-41 105-40-9-39z"/>
					<path id="coste" d="m-20833 1013 10 2-9 27-38 15v-21z"/>
					<path id="cox" d="m-22450 3961 6-4 12 23-7 9-17-8-12 9-7-7 2-28z"/>
					<path id="cunningham" d="m-21261 2752 14 4 6 23-6 6 1 38-26 58 5 10-25 16-15-9-22-26-12-9-13-3-21-30-2-21 34-12 27 8 8-12 20-17 15-9z"/>
					<path id="denman" d="m-20768 6462 35-49 18 63-3 78 16 23-2 17-19-22-8 3-12-19-2-24-20-47z"/>
					<path id="denny" d="m-21270 2898h8l-36 55-20-4-39 36-26-30-30-8-30-32 13-66 22-4 3 17 63 11 46 46z"/>
					<path id="dewdney" d="m-21829 1519 22-7 11 28 9 13 1 52h-23v-28l-9-9-10 20-22-11 15-42-10 8-4-27 18-10z"/>
					<path id="digby" d="m-21537 25 36-9 12 39-3 25-11 27-19 10-12-12z"/>
					<path id="dolphin" d="m-21829 510 22 5 9 12-3 15-20 15-23-3-7-27z"/>
					<path id="dowager" d="m-21375 2469 40 21-1 19-30 15-3 19-30-9-52 29-51-28 9-41 29 10 37-37z"/>
					<path id="dufferin" d="m-21464 2716 3 9-9 12-33 7-62 19 17-56 29-23z"/>
					<path id="dundas" d="m-21672-357 71-63 23 6 25 13-5 32 46-4-1 31-24 29-29 13-22-1-58 18-2-16-29 18-22 2 5-32z"/>
					<path id="dunira" d="m-21603-231 6 6-7 22 2 32-6 6-23-7 6-10-12-10 4-21 9-13z"/>
					<path id="e_cracroft" d="m-21160 4950 18-4 9 38 10 15 17 11-5 12-19 12-41-7 17-21 19-1-17-10-8-14z"/>
					<path id="e_redonda" d="m-20362 5761 42-8 17 25 11 30-6 49-27 33-56 15 4-49 30-38 27-9 9-23-13-23-14 42-19 5-25 34-25-42z"/>
					<path id="e_thurlow" d="m-20741 5394h96l24 35-23 29-26 12-14-16-2 23-14 10-57-6-42-60 7-7 42 6z"/>
					<path id="eden" d="m-21297 4664 23 28-2 8-26-1-24-11-10-19z"/>
					<path id="farrant" d="m-21479 1349-50-18 34-14-16-67 50-24 15 67zm5 29-64 29 21-51z"/>
					<path id="flores" d="m-21722 6189h51l15 40-18 49-13 16 3 48-32 2-3 8-31-28 7-4-6-18-31-1-16-34 17-10-5-23 41-73 21 9z"/>
					<path id="gabriola" d="m-20310 7135 35 10-6 10 19 34 40 34 3 22-10 11-41-18-55-59v-15z"/>
					<path id="galiano" d="m-20214 7408 9 4 9 47 7 26 46 62 3 12 34 34 10 35-10 19-39-18-5-30-4-30-52-76-13-39-3-34z"/>
					<path id="gambier" d="m-19869 6946 42 4 8 10 6 45-14 52h-47l36-35-48-12-24 25-9-5 10-41 16-10 3-19z"/>
					<path id="gil" d="m-21443 1350 15-2 19 30 11 44-32 84-14-3-29 45-1 45-19 12-18-20-60-7-9-57 20-56 22-29 83-30z"/>
					<path id="gilford" d="m-21015 4736 25 28-20 36 2 21 11 16 14 9-3 16-64-2-8 15-20 2-4 19-21 17-44-7-43-47-58-3-9-20-29-9-25-41 27-28 51-20 36 12 67-31 61 5 19-6z"/>
					<path id="goose" d="m-21688 2887 12 3v16l-38 42-31 2 2-27 25-7z"/>
					<path id="goschen" d="m-21915 430 64-11 19 51-43 13-26-17z"/>
					<path id="graham" d="m-23092-635 33-92 68-18-31-18 12-14 32 21 75 130 101 25 21 65-37 68-98 22v33l69-6 28-38 109-5 82 35-2 63-23 25 27 47-15 51-25 27 2 34-6 29-35 28h-58l-31 22-33 2-89-34-33 14-92-22-12-18-35-14-1 8 30 16 3 18-29 23 38-10 22 44 42-3 52 28-92 14-38 28-3 12 49-24 57 18 9 20 31-7-20-20 14-36 77 51 31-11 16-78 32-22 72-9 39-35 7-27v-28l21-32 14-53-7-44 8-2 27 44 64 42 48 17 1-1 62 6 85 5 83-41-154 168-220 129-27 60-90 60-22 48-46 29-33 102-52 61-109 85-47-54-100-19-24 28 34 6 36 25-10 21-65-4-11-5-9-10-25-27-25-7-7-9-12 5-19-4-48-31-22-84 2-19 33-9-20-41-48-39 22-25 47 23 9-24 43 18 16-8-133-60 67-38 95 78 3 58 37 25 7-21-31-82 14-14-101-143 36-1 8-15-70-11-38-21 22-26 19 13 22-16-58-34 29-23-25-34 17-36 31 8 4 28 46 33 7-8-35-36-15-127 45 40 19-10-28-36 15-26-45-68 17-26 36-6-6-59 24-52 41-16 28-47z"/>
					<path id="greaves" d="m-21473 3895 31 28-59-18-22-1-20-13-18-3-20-10 27-10-2-7-19 3-9-12v-9l18-2 28 15v11l12-11 28 28z"/>
					<path id="gribbell" d="m-21182 1241h15l-6 27-19 41 5 63-5 31-46 62-24 3-27-49-65-4-4-38 85-61 20 2 23-27 7-28z"/>
					<path id="gurd" d="m-21876 340 29-8 13 29-4 13-28 5z"/>
					<path id="hanson" d="m-21444 4817 29 26 2 17-11 6-42-33 11-21z"/>
					<path id="harbledown" d="m-21380 4852 45 13 37 41v13l-19 2-70-31-19-33 7-2 13 21z"/>
					<path id="hardwicke" d="m-20969 5225 67 18 14 70-44-1-25-12-21-25-37-13-18-40z"/>
					<path id="hawkesbury" d="m-20983 1118 16 20-18 16-47 15-10 55-44 35-28-45-56 4-75 33-7 44-62 14-9 15-16 8 20-54 109-180 83-14 5 9 75-2 10 24z"/>
					<path id="hecate" d="m-21613 3293h37l-20 87-75-46 45-42v10l7 1z"/>
					<path id="hernando" d="m-20583 6006 6 15-21 17h-10l-8-33 11-18 7 16z"/>
					<path id="hibben" d="m-23353 552 31 16 54 55 6 25-86-38 1-9h11l-1-20-10-4z"/>
					<path id="hope" d="m-21982 4087 33-6 31 32-14 15 3 15-37-1-6-21-22-3-28-27-2-15z"/>
					<path id="hornby" d="m-20691 6524 20-7 14 5 35 47 5 17-15-8-12-19-11 5 3 13-5 7-26 1-16-36z"/>
					<path id="horsfall" d="m-21454 2738 19 22-5 6-50 3-19 21-32 20-7-3 9-32 37-30 32-7-2 10 10 1 2-11z"/>
					<path id="hunter" d="m-21518 2960 49-25 20 3-4 20 67 7 16 30-23 30-3 23-69 78-25 8-55 71-16-12-27 22-26-13 19-19-20-5 5-15 45-47-34-11-4 7-41-21 13-35 33 5 25-60 43-21z"/>
					<path id="kaien" d="m-21471 71 54-8 2 34-3 13-14 9-12 22-48 2v31l-16 6 15-86z"/>
					<path id="kennedy" d="m-21542 340 30-9 10 27-13 52-27 25-19-11v-43z"/>
					<path id="king" d="m-20793 2873 26-17 14 34-30 28 3 24 12 11 1 12-18 6-7 18-17-3-33 19-10-9-32 17-19-13-24 8-22-16-44 18-23-9-20 6-12 13-28-16-14 5-7 24-48-7-87 76-16 36-32 28-26-16-102-12 3-10 27-19-5-16 16-34 57-76 39 19-11-38 33-37 70-30 17-19 42 15 36 1 14 18 73-15 67 6 29-44 38 7 15-12 15 18z"/>
					<path id="kunghit" d="m-23156 1800 36 29-4 56 38 35-11 14-43-2-5-18-10-1-7 14-7-10 2-30-14 7-5 32 21 33 8 24-14 1-5-23-14-21-8 4 4 56-10 3-9-8-10 8 6 27-12-2-13-86h26l14-24-14-6 9-39 18-7-5-23z"/>
					<path id="kuper" d="m-20285 7413 10 1 11 12-1 13-10 27-7 7-9-21z"/>
					<path id="lady_douglas" d="m-21478 2555 19 9-28 30-25-2-6-10 6-33z"/>
					<path id="langara" d="m-22944-833 30 35-5 29-17-1-4 18-12 14-19-19 22-15-37-40 19-19z"/>
					<path id="lasqueti" d="m-20495 6662 26-13 47 53 20 6 9 32 20 25-12 34-39-50-48-17z"/>
					<path id="loretta" d="m-20965 1075 15 6-13 41-15-13-27-3z"/>
					<path id="lotbiniere" d="m-21784 1515 29-12 10 41-17 14-7-6-11 5 3-16z"/>
					<path id="louise" d="m-23099 707 44-2 43 33 8 33 45 47 16 54-36 5 4 24-79 30-40-48-31 2 3-105 11-28-2-22z"/>
					<path id="lulu" d="m-19703 7424 16 10-22 7-12 1-7 4-62-2-35 14-37-2-14-6-14-22-15-11 23-51 29 15 13-2 13-13 13 1 15 12 20 2 17 9 18 20 11 22z"/>
					<path id="lyell" d="m-23050 1118 33 2 7 53-62 64-36-13-7-45-11-17-19 5 9 21 3 44-30 3-14-14 2-71 17-18-12-69 37-9 61 48-9 10-56-36-12 8 54 29 11 24z"/>
					<path id="maitland" d="m-20947 1064-20 1-24 6-1 18-36 10-19-22-68 11-6-21 12-7 60-3 10 4 40-2 28-7z"/>
					<path id="malcolm" d="m-21511 4692 29-4 22 68-9 5-9-11 2-10-27 1-27-14-13-18-39-11v-32l-39-2-43-25 1-13 53-13 12 18 17 3 12 26 20-1 21 12z"/>
					<path id="maude" d="m-23038 472 8 7-10 19-28-3-30-14 2-16z"/>
					<path id="maurelle" d="m-20625 5615 67-8 5 47-9 23-28 17-32 1z"/>
					<path id="mayne" d="m-20099 7646 15-6 14 37-2 44-59-52 2-27 25 20 6-6z"/>
					<path id="mccauley" d="m-21844 610 87-8v-33l18-14 32 28-5 36-27 31 8 27 24 12 11 27-4 20-14 2-24 48-8 66-39-29-77-121-4-67z"/>
					<path id="meares" d="m-21584 6430 52 40-11 43-19-15-35 77-34-33 17-57 25-14-25-20-4 22-18 17-15-7 15-56 23 10 7-15z"/>
					<path id="melville1" d="m-21638-163 30 8-8 40-20 8-27-8-5-34z"/>
					<path id="moresby" d="m-23218 446 35 38 63 16 20 28 144-23 37 32 34-8-17 69-22 27 31 40-12 41 24 21-31 62 12 11-16 11-65-74-13-28-49-28-41-5-31-35-15 5 33 33-17 23 1 28 2 22-11 28-6 8h-17l-10-12-3 12 22 16-3 14-79-9 27 19 32-4 11 7 7 49-39 8v6l20 11-1 19-8 6 6 22 24 8 19 22 25 10 24 1 2 9-8 8-13-7-19 1-27-24-29 3-51 35-1 20 11-12 23 50-10 31-4 50-5 3-26-41-5 6 26 49-7 24 8 18 8-2 10 18-41 13 21 26-8 14 30-8 17 24-14 3 6 9 20 8 11 31-10-1-7 19 17 26 4 13-37 41-23 8v10l31-12 7 14-12 30-26 3 3 8 13 2 24-10-8 28-21 57 17 4-3 17 7 38-2 20 22-11-7-9-1-31 73 1 15 25-17 34 27 3-21 43-35-17h-34l-2 5 33 6 4 14-6 10 23-2 1 15 39 2 7 30-29 25-26 7-43-30 16-25-6-21-38 63-14 7-22-4-6-21 8-27 10-6 4-47-4-47-17 94-12 5-5 22-23-2 4-35-12-3-1-12 12 2 2-58 16-40 6-37-37 79-9 8-14-52 12-51-11-25-2-38 13-13-1-7-10 2-14-22 29-10-26-10 8-45 25-15 26 11 8 28 8-8 1-16-10-6-8-13 14-15-51 2 9-74-43-73-17-99-9-7v-29l16-8-2-13-14-6 16-40-21 2-21-74v-59l88-6 2 43 17 8 7-48-31-24 8-67h-14v39l-15 23-23-10-19 23-16 13-14-12-2-66-18-24 8-45 22-11-24-61 10-6-11-41 18-14 111 46h18l22-12-40-21-14-40-52-37-2-16-26-12-1-19-42-8-14-36 21-15-15-9-5-30 16-5 59 43 40 17 13-24 23 10 7-9z"/>
					<path id="n_broughton" d="m-21346 4494 36 11 24 22 6 30-15 6-5-10-31-3-12 3-16-6-41-23-9-16z"/>
					<path id="n_pender" d="m-20111 7698 10 36-1 27-10-9-20 18-19-32 15-57z"/>
					<path id="nalu" d="m-21558 3233 12-7-2 14-24 27-21 2-7-6 2-18 16-14 18-1z"/>
					<path id="nelson" d="m-20119 6503 12 17-6 6-14-4-42 9-2 18-22 18-4-6-32 50-8 5-12-25-25-14-4-16-19-7 18-24 5-16 23 2 39-30 16 6-2 11 12 11 6-3v-18l9-5z"/>
					<path id="nigei" d="m-21938 4156 80 12 14 41-3 59-13 6-43-56-16-10-31-46z"/>
					<path id="nootka" d="m-21817 5547 38 12-22 61-16 77-14-3-8 71-12-2-27 70-45-8-28-49-50-42 10-48-23-33-15-99 84 27 29-6 8-21-40 7-51-58 34-27 13 14 121-3z"/>
					<path id="pearse" d="m-20996-546 32-7-13 64-11 17-121 65-29 14-103 12-1-82 24-2 62-20 21 2 88-30z"/>
					<path id="penrose" d="m-21537 3604 19 5-16 18-6 1 1-8-6 8 8 6-3 4-17 3-7-12 2-19-11-7 33-8z"/>
					<path id="pitt" d="m-21617 486 30 47 40 185 26 92 2 137 55 269-41 16-31 27-15 45-54 28-6 44-65-30 1-119-19-89-15-32 1-30 35-39-38-33 66-60-22-29 34-19-73-22-12-51 11-39 9-37h8l5-27-17-34-26-25 5-17 12-5 28-67-31-35 27-39z"/>
					<path id="pooley" d="m-21131 2208 73-27-13 26-32 43-37 37-31 23 5-24-4-2-14 37-63 56-33 2 26-46 32-32-1-41-3-34 30-48 15 13 42 14-3 11 13 10 6-9z"/>
					<path id="porcher" d="m-21657 246 31-10 26 61 5 117-14 26-17 12-8-6-28 22-43 3-31 45-39-14-7-23-40-31 14 1-3-31 16-7-9-28-16-4-4-77-15 13-25-14-35 34 28 60-10 11-21 1-27-31 3-28 23-21-5-18 24-27 25-3 39-29 12 16 44-29 21 14 20-19 8 19 8-20 25 14 15-6z"/>
					<path id="prescott1" d="m-21762 168 27-24 16 35-1 33-13 3z"/>
					<path id="price" d="m-21577 2339 16 5 17 44-64 119-62 39-18-58 40-120 30-42 32 20z"/>
					<path id="princess_royal" d="m-21280 1492 41 2-1 53 47 151 28 24 1 79-13 34-13 67-51 101-27 20-44 69-47 54-16 7-13 37-60 69-18-20-78-30 32-50 7 2 29-54 12-41 27-26 7 5 24-38 37-31 50-18 34-54-10-19-32 60-38 9-56 51-9-6-56 69-5 41-17 34-85-26-36-87-13-56 3-72 18-60 24-24 7 3 28 50 10-6-16-15-10-28 46 1 46-5 1-12 21-13 8-18 50-21 20 3-9-13-14 3-12 9-18 4-21 11-15 20-45 18-54 1-16-11 10-28-19 2v-50l39-62 35-20-1-19 69 10 46-92 40-12 17-84 46 1z"/>
					<path id="promise" d="m-21388 1279 27 4-11 34-17 18-12-21 6-31z"/>
					<path id="quadra" d="m-20744 5574 99 10 8 34-36 11 25 10 19 59-5 40-55 36-35 6 5 42h11l-23 66 1 26-16 8-19-4-2-10 11-23-7-54 20 6 4-15-26-30-11-52-19-19 36-35-4-36 11-44 31 18z"/>
					<path id="ramsay" d="m-23065 1312 23-6v31l-9 8-30-5 1-9-16-18 2-12z"/>
					<path id="raza" d="m-20481 5649 10 6 7 20-13 16-26 12-14-21 1-19 24-2z"/>
					<path id="read" d="m-20623 5729 73-53 5 21-13 59-21 20-21-34-3 32-57 31-9-23 40-28z"/>
					<path id="rennison" d="m-21774 1791 33-30 11 37-30 31z"/>
					<path id="roderick" d="m-21280 2164 60-27 12 30-4 18-14 13-3 18 5 45-5 32-30 34-35 69-9 29-13 14-75-75 44-80 31-41 37 26 5 11 13-14-26-16-17-21 27-34-12-9z"/>
					<path id="s_pender" d="m-20116 7766 3-7 37 36 6 13-14 6-13-4-9-20 3-7-8-6z"/>
					<path id="saltspring" d="m-20273 7520 20-46 29 51 40 105-7 2-34-35h-10l46 89 6 32-24 14-27-16-13-27 6 49-55 3-28-77 27-7-2-16 21 6-18-42 14-28 23-10-10-20z"/>
					<path id="sarah" d="m-21244 2024 3 54-18 47-39 27-27 56-48 47-13-9 17-62 52-71z"/>
					<path id="saturna" d="m-20046 7734 68 70 14 3-3 5-7-2-39-16 13 15-7 4-26-11-19-11-22-22v-25l12 3 16 10-15-21z"/>
					<path id="sea" d="m-19827 7366-13 10-12 3-14-8-16-19 7-12 10-10 19 6 6 5 4 13z"/>
					<path id="smith1" d="m-21467 220 15 60-20 16-19 1-21-6-9-11-4-30 2-24 39-22z"/>
					<path id="somerville" d="m-21119-349 8 5-22 16 4 3 7-4 12-2-27 33-28 19-60-13-12-11-24 4 2-9 16-15 35-10 55 4z"/>
					<path id="sonora" d="m-20597 5439 37 93 14 11-12 18 1 43-27-6-47 10-10-42-22 4-34-8-11 9-22-4-16-16 16-45 26-7 7 3 26 30v-22h17l3-14-12-2 4-11z"/>
					<path id="spicer" d="m-21772 559 6 25-16 9-15-1 6-10-16-7 4-19 17-12z"/>
					<path id="stephens" d="m-21761 4 37 96 2 28-22 18-24-11-57-81z"/>
					<path id="stirling" d="m-21596 3217-24 31-27-2-1-10 28-33 19 8z"/>
					<path id="stryker" d="m-21558 2792-13 45-8 7 1-20-6-5-7 15-6 1-7-10 2-12 5-5 31-6 3-7z"/>
					<path id="stuart" d="m-20514 5514 6 5-4 23 10 20-4 8h-11l-14 7-15-5-4-10 9-16 10-2 1-8-6-1 2-8 8-2 4-10z"/>
					<path id="susan" d="m-21392 2363 83 82-10 30h-27l-26-17-52-4z"/>
					<path id="swindle" d="m-21392 2210 11-5-37 115-25 106-47 35-33-51-43-92-15 19-27-21-23-59 31-28 21 72 19-17-5-39 21-33 73 29 28 29z"/>
					<path id="talunkwan" d="m-23092 912 11 19-6 19 15-1 27 19-4 14-66-13-11-15-26-18-9-12 3-25 12-4 17 15z"/>
					<path id="tanu" d="m-23079 1030 9 21-7 17-17-9-20-16-22-8-14-41 23 12 14 14 7-2z"/>
					<path id="tartus" d="m-21207 7004-33 25-34 1 2-15 20-18 38-12 10 9z"/>
					<path id="texada" d="m-20486 6295-3 22 9 34 14 12 9 14 4 19 15 8 31 27 26 29 5 10 1 56 15 76 31 80 4 27-4 48-15 2-14-28-12-37-9-4-13-31-13-5-7-32-5-1-54-91 8-19-11-24 5-26-16 1-4-9-2-20-47-63-6-18 10-19 16-9-2-18 8-5 1-13 6 1 2 10z"/>
					<path id="thetis" d="m-20292 7362 16 5 8 27v18l-29-4 1-22z"/>
					<path id="trutch" d="m-21768 1391 11 53v36l-28 9-10-22-22-20-16-22 7-29 16-29z"/>
					<path id="turnour" d="m-21165 4914-9 14-79-4 4-10-33 3-11-20-28-30 11-8 73 13 20 17 9-1 33 18z"/>
					<path id="union" d="m-22050 5173 14 34-58 27-10-49 20-19 15-2z"/>
					<path id="valdes" d="m-20234 7257 11 29-5 16 13 44 3 33-3 22-8 3-4-7-3-28-4-2-4-5-2-18 8-15-13-43v-17l2-1-2-14z"/>
					<path id="vancouver" d="m-22007 4136 16 11 15 18v14l43 43 141 173-20 20-7 24 19 9 2-9 11 1 3-11 22 5 6 6-2 6-12 14-12 3-8 23 24 7-2 14 68 114 3 25 21 8 12 12 7-1 15 11 13 15-24-6-14-10-4 9 49 30 13 15 16 5 12 14-6 22 41 21 26 27-7 3-15-3v14l3 6 15-3 7-8 13 1 21 22 81 102 9 27 18-4 87 62h14l48 31 20 27h16l86 69 35 51 25 49 47 49 29 12 11 16 11 22 25 16 97 39 25 49 13 5 10 21 24 9-24 56 10 14-4 29-34 126-6 1-5-15-7-3-2 15 3 15 16 4 14 11-2 52 9-2 5 9 1 39-6 31-10 45v13l5 28-5 14-8 11 8 27 13 12 5 8 1 10-9 19 7 19 9 9 14 40 28 114 8 5 18 56-46 20-27-20-13-18-6 5 1 19 10 23 9 6 3 64-8 7-8 60 9 42 8 2 7 11-18 37 13-2 9 13 1 12 23-5 1 11 15 19 9 33 7 8-2 19 10 10 14 32 22 18 16 20 14 4 11 24 29 7 33 26 12 42 26 1 11 15-4 13 3 12 12 1 11 24 23-13 7 30 15 9 7 29h-13l-13-7-13-14-13-2-4 7 10 15 58 22 67 58 4 33-25-1 8 17v41l-8 24 65 33-7 51 8 71-36 1 13 39-19 6-26-54h-6l13 56 49 134 9 42 14 15-9 30-7-6-11 2-4 18 13-2 12 17-5 20-20 5-3 20-4 10-6-22-11-3-8-17-20 14 31 30 11 29-4 9 7 20-9 27-13 10-8-9-1 16 5 20-1 20-14 24-4 23-10 6-20-5-9 5-5 44 17-35 23 3 24-17 8 7 13-13-7-13 7-12 20-13-11-5 10-11 25-5-1-14-11-3-6-19 15-3-6-8 2-4 30 6 23 25-3 16-13-6v10l7 1 3 8-7 17-21 12v24l-2 18 10 9-10 36-23 39 17 35 14 6-6 20 10 21 3 14-3 3-10-5-2-12-8 3 2 8-6 10-4-2-11 9 4 3-2 18-8-3-42-17-14-17 16-6-9-9-9 9-9-1-13-20 2-6 10 5-5-13 4-7-6-9-4 4-7 20-6-3-38 26 4 11-28-8-35 22 8 15-12 1-10-15 2 17 3 13-24 6v-5l-8-5-6 2-8-15 21-18-17 1-12-7-16 15-13-2-11-32-16-13 6-15 10-1 2-5-7-6 16-5 5 4 7 1 1 10 6 8 17 7 13-24-18-8-15-5-9 6-2-8-21 3-11 8 2 5-2 2-7 1-10-11-1-15-46-6-5-21-4-3-7-11-20-13-20-3-9-16-1-13-18-5-6-6 1-13-21-24-22-18-95-106-22-30 1-16-7-12-32-20-45-43-4-10 3-4 28-7 19 1 2-19-48-1-25 7-82-80-21-30-16-14-6-27-12-5-14-70h-10l-9-16 5-17h7l22 14 22-8 40-24 5 6 22-14 2-9 45-15 12-16 12-1-3-13-13 7-61 29-10 10-42 15-19 18-17 3-20-7-4 3-6 18-51-64-69-66h-13l-9-40 10-28 22-12-5-12-34 20-4-25-24-6-3-9 144-47 26 15 33-21-8-29 24-4 10 18 6-22 20-8 18 2 24 17 10-1 4-8 14-5 19-2 9-12 25-21 6-15 35-28-1-6 46-37 1-15-5-12 3-17 15-22 17-38-18-6-17 59-13 17 8 20-26 29-20 15-5 16-32 12-16-5 12 15-26 39-20 3-7 7-15 4-16-4-10-12-15-3-7-26-19-32-7 3 15 26 3 29-11 9-20-5 22-16-18-28-33 10-18-5-8-12 5-9-6-18h-11l-9 9-13-15 36-15 26-26 3-29-7-18-12-17-3 3 11 18 6 39-15-4-2 16-11 15-29 4-12 20 6 9-25 11-32 4-13-29-27-24 24 2 8-19-13-13 3-13 28 3-29-36-17 6v10l-19 17-61 19-18 10-7-3-16 11-12 1-17-10-16-79-13 9 18 33 3 28h-14l5-13-14-16-12-53 10-3-9-28-8-7-15 5-1-19 10-11-17-58-12-21-14-7-8 6-11-14-11 3-29-57 12 7 6-10-10-11 4-45 9-4 10 9-12 33 9 36 22 3-2-25 20 17 24 45v10l16-7-15-25 27 10 3-10 75-13 24-33 24 6-5-17h-32l-16 31-12-4 26-39-3-3-71 51-27-28 31-18 12-29 12-21 30-19-2-7-32 8-20-5-8-13 32-45 15-11 10-19-5-8 6-4 10-1 5-7 8 1 3-6-9-3-12 11-7-2-34 39-17 8-9 25-25-6 12-12-15-22-50 13 4 7-34 7-17-30 10-43 21-16 33 17 50-48 14-29 17 4 18-13-1-8-11-1-2 8-7 5-18-7-23 30-38 18-14 11-12-4-9-11-8-26 15-28 5-28-7-2 1-5 22-1v-17l21 5 7-5-3-16-9 11-14-6v-9l-12 2-20-10-2 7-23 6-11-6-10 3 9 5 6 6-31-12-18-18 1-20 16-11-7-12-8 6-2-11 14-79-3-4-8 43-10 24-8-6-21 19 4 5 7-8 21-2-1 28-9 16-11 6-14 35-10 17-14-13-16-46-2-29-30-28 11-15-9-28 27-15-6-11-19-1-22 19-8-4-19 14v10l7 4v14l-8 13-18 11-7-10-27-10-5-10 6-5-10-38 35-24-8-11v-11l19-15 18-24 8-4-5-25 9 1 17-44 18-3 12 6 31-8 33-28 8 6-4 13 3 8 8-7 29 12 11 18 28 6 36 18 7-3 29 14 8-3 30 7 6 14 20-2 25 17-5 22 9 17v18l4 9 6-18-9-19 6-26-5-31h-14l-20-13-45-11-12 3-20-2-58-23-15-21 10-2-2-5-28-11h-20l-20-53 79-42h15l12 13-1-22-37-5-4-12 29-16-16-1-15-27-5 37 4 29-32 11-9-28-6 4 9 29-8 7-18-4-25 2-25-14 2-53 12-30-2-12 10-37 29-53 30-57-6-3-16 22-22 35-20-16 1-12-16-2-10-12-4-36 8-26 4-32-21-22 12-18-6-8-15 27 19 22-9 45-19 8v6h-35l-28-9-7-7 10-38 15-17 17-52 5 3-2-20-5-2-22 55-34 54 5 8-14 8-15-3-8-11 11-24-10 8-8-24 11-35-4-6 4-21-6-3-7 56-5 14 8 27-6 9-17-3-39-42-22-3-20-13-3-28 6-52-7-3 6-46-13-4 2-5 12 2 33-12 29 2 9 14 7-21 13-2 16 16h16l9 6 1-10-23-5-23-14-24 1-4-12 25-9 4-27 27-4 30-7 20 6 8-5 1-10 6-4 8-24h-10l-5 20-28 8-58-14-8-16 8-15-25-72-16 34 11-5 10 28-6 15h-17l2 18-18 6 5 21-35-1-4-4-32 10-42-41 5-31-9-45 16-19 16-2 18 8 14-9h-11l-21-8-28 6-8-13 7-11 53-12 10-10 14 1 3-6-14-4-7 4h-19l-26 8-33 16-13-2-7-11-15 1-6 3 3 7-15-2v-5l13-6-19-5 4-34 17-13 15-7 12-12-3-4-12 11-11 5-10-6-10 13-10 4-4-6-113 24-13-7-1-7-21-21-8-19-14-20 7-17 68-13 54-18-3-14 60 5-6-19h-17l-18-11-12-33-3-32h5l5 7 33 1 6-11 8-1 10 16 8 14 17 19-25-51-15-7-17 9-10-4-10-12 8-36-28-3-4 4-28-1-14-16 6-35 12 9 45-48 27-6-6-17 17-24 15 5 8 16 21 9 11-6 6 3 15 24 36-12 58 23 37 33 23 1 9 63-4 48 1 29 15-4-4-21 8-12 2-26-12-95-5 4-9-25 17-2 8 12 6 2 51-29 32 11 36 15 6-17-13-3-8 3-18-7-10-19-26 3-9 5-11 1-5-32-36-30 2-9-67-38-19-8-25-29-22-18-5-12 2-5-54-52-6 2 21 29 27 23 13 20 5 2 30 35 27 27-9 5 58 36 18 15 14 6 21 45-18 16-13-19-12 6-19-14-116-12-3 8-16-3-12-15 6-22-23-3-2 12-20 3-14-17-17 2-36-8-8-9 3-38 23-7 4-10 31 1-2-5-23-6-37 22-5 9-10 2-8-11 8 45-14 11h-8l-6-51-6-2-4 9-6-2-2-47-11-10-1-20-13-11-4-19 11-4-10-38 16-3-1-11-29-39-2-32 18-11 15 7 10-5-1-5 14-5-9-12-19 7-32-31 7-21 14-2-7-57 11-3 9-21h-8l-7-9 8-16 5 4v13l28 1 5 8 16-7-3-10 22 7 5 18 10 4 6-7 32 15 34-15 26 3 17 10 2 7 16 2 4-9 18-6 36 8-4 10 21 12v11l16 6 19-3z"/>
					<path id="vargas" d="m-21692 6405 35 31 1 30-13-6-16 5-9 23-15-8-14-26 11-1 4-17-12-12 7-17z"/>
					<path id="w_cracroft" d="m-21269 4930 51 8 23 16 6-17 23 22v13l6 9 8 14-12 14-37 16-31-12-15-16-25 4-50-30-19-23-25-5-17-16-9-27-20-21 26 14 23 15 43 17 47 14z"/>
					<path id="w_redonda" d="m-20364 5759-36 29-6-3-11 34 12 36 9 7v13l-9 22-42 8-17 16-25-14 12-5-6-6-9-1 9-48-11-8 2-6 28 7 30 12-13-12 5-14-8-2-16 5-26-12-6-10-8-67 8-17 11 8 7-14 42-19 21 18 8 19z"/>
					<path id="w_thurlow" d="m-20745 5363 5 20-12 27-71-11-97-40-20-23 2-14 50 7 13 14 27 8 58-3z"/>
					<path id="walbran" d="m-21410 3591-6 20-12 22-37 12-2 15-6-7-7 8-6-7 5-6-7-4-8 2-23-17 13-12 17 8 30-21 22-10-2 9 25-19z"/>
					<path id="wales1" d="m-21246-461-2 63-9 20-51 37-7-13 4-12-13-7-2 12-12 2-20-42 2-16-7-37 20-5 9 37 5 1-3-12 4-10z"/>
					<path id="watson" d="m-21287 4448 1 11 6 3 10 14h-21l-24-9-10-8 10-22z"/>
					<path id="westham" d="m-19899 7439 6 8 16 30-3 7-12 4-9-5-10-18 1-21 5-8z"/>
					<path id="yeo" d="m-21261 2582 10 4-5 37-28 90h-55l-12 10-27-1-19-23 14-23 102-68z"/>
					<path id="zayas" d="m-21681-479 19 15-5 17-33 17-13-13z"/>
				</g>
				<g id="i-CA-ON">
					<path id="albany" d="m9045 7452 50 45-3 5-43-4-52 10-42 18-32-4-19-9 68-35 21-21 22-8z"/>
					<path id="olimisk" d="m10455 8383 5-12 21 1 29 44-4 3-15-2z"/>
					<path id="partridge" d="m4509 4072-6-20 9-25 32-19 36 16 5 19-52 18-17 9-7 19-4-3z"/>
					<path id="ship_sands" d="m9962 8320-17 7-1-21 15-26 8-8 16-7 5 11z"/>
				</g>
				<g id="i-CA-QC">
					<path id="anticosti" d="m21015 5902 13-22 90-80 39-30 50-31 59 1 15-14 61-9 42 10 116-45 93-18 15-12 33-5 45-23 71-23 220-44 26 4 26-14 16 17 40-21 23 18 49-21 9 11 40-10 32 11 37-22 58 15 28-11 71 2 67 12-6 15 71 28 23-23h81l18 27 68-1 10-16 53 6 7-21 68-9 16 20 43-35 17 17 43-1 17 24 22-1 8 24 41 5 48 19 39 36 19-3 11 10-10 44 18 14-8 7h-16l-23 16-23 45-63 15-24 28-30 7-128 80-21 24-120 11-29 11-54 3-52 23-132 43-67 5-55 22-34 3-91 15-113 1-66-21-16 13-91 2-98 16-7 7-14-1 10-12-10-17-37-18-14-13-3-18-60-40-99-17-62-24-66-1-64-9-72 20-141 18-46-7-18-21-45-7-7 6 30 30-32 6-41-25-38 7-20-9-6-19z"/>
					<path id="bayfield" d="m23972 2506 15-68 37 30-22 45z"/>
					<path id="brion" d="m24108 6868 3 4-7 9-7 3-2 13-6 9-7 8-10 3-2-2 7-22 11-2 6-18 7-4zm5 2-1-3 7-4 7 2-3 4z"/>
					<path id="chasse" d="m21690 5113 33 6-1 20-17 13-24 9-1 10-11-2-2-11-10-9 27-15z"/>
					<path id="coudres" d="m18278 10208-7 12-14 41-11 28-6 3-11 4-6-5-4 8h-2l-1-11-10-11 7-25 14-20 33-21 9-1 7-5z"/>
					<path id="cumberland" d="m24016 2413 29 8 5 6-4 23-43-14-12-21z"/>
					<path id="entree" d="m24231 7459 9 8-1 13-14 7-9-8z"/>
					<path id="esquimaux" d="m24235 2034 19-19 17 21-3 26-27-3z"/>
					<path id="genevriers" d="m23890 2486 52-46 30 15 3 20-32 44-64 20z"/>
					<path id="grande" d="m21223 5367 32 15 11 14-17 28-9-6-7 7-25-16-8-20 8-19z"/>
					<path id="grande_passe" d="m23964 2576 33-42 9 5-15 65-20 30-14-3-16 5 13-37 8-6z"/>
					<path id="gros_mecatina" d="m23953 3019 21 8 13 28-2 14-28-4 1-28-16-12z"/>
					<path id="grues" d="m18274 10596-1 19 9 11-4 28-7 16-15 12 12-48-9-14 10-26z"/>
					<path id="lievres" d="m18511 9530-1 29 5 18-9 21-1 27-10 39h-3l5-49 1-44z"/>
					<path id="madeleine" d="m24006 7429 34-43 39-152 61-168 32-7 37-39 28 3 8 17-12-1-18 21-6 19 8 23-14 6v31l-30 21-17-10-39 40-12 47 2 41-6 24 2 30 17 31-5 35-50 7 6 70-20 4-8 23 13 30 41 35 35 9 38-14 2-48 9-2 2 46-13 31-45 14-23 27-40 19-23-14 2-54-15-77-17-14-9-22z"/>
					<path id="monger" d="m23845 2784 23-50 23 14-6 23-12 12 20 39-21-6zm26-54 20-44 9 15 4 30-15 9z"/>
					<path id="oies" d="m18310 10502-3 19-13 32-11 17-9 26-5-2-5-11 6-20 29-48h6z"/>
					<path id="orleans" d="m18104 10762 4 3-1 24-6 32-14 47-1 19-7 17-33 41-9 27-12 20-35 25-49 26-11-2 5-32 11-29 19-41 22-25 17-54 15-34 52-50 15-2z"/>
					<path id="petit_mecatina" d="m23798 3417 8-22 32 22 21 21-17 57-19-10-10-63z"/>
					<path id="petit_rigolet" d="m23919 2598 11-4 12 24-18 54-30 2 18-62z"/>
					<path id="verte" d="m18648 9276-3 32-7 27-29 55-1-1 14-52 6-35 18-20z"/>
				</g>
				<g id="i-CA-NB">
					<path id="campobello" d="m21835 11672v2l-3 10 5 5 5-2 2 17 6-7 16 15 1 6-4 12 3 2 2 12-2 16-9 6v10l5 7 16 10-1 19h-3l-4-8-7 1-6 8-6-4v-4l-7-1 1 5h-6l-1-7-5-5-6 1-4-8v-10l4-1 6-6 1-11-8-2-6-13v-13l9-8 7 5-2 4 3 10-4 6 4 9 4-15 3-2-4-7 3-13-7-3-3-5-5 5-10-4 6-29z"/>
					<path id="deer" d="m21773 11612 11 12 8 47-1 35-6 16 6 12-22-16-14-13-8-12-2 2 4 9h-4l-5-10 9-46z"/>
					<path id="grand_manan" d="m21995 11794 9-4 5 2 19 20 7-14 15 14-3 7-10-1-2 15 25 25 9 2 7 8 1 14 10 5 2 11-13 6-4-6-8 11 18 12 2 11-7 7-6-4-18 7-7 18-16 3v26l-6 20-4 3 2 21-16 10-11-21 6-18-6-22-7-8-1-45-6-12-2-34 2-12 3-4-2-7-3-23z"/>
					<path id="lameque" d="m22045 7898 14 34v52l-5 54-9 19-3 22-13 27-15-11 3-3-7-5-17 10-14-5-2-7 13-18 7-14 9-9-3-3-12 3-8-9-6 2-4-1v9l5 1-8 18-7-3-1-17 6-18-9-3-3 11-10 8-4-14-5-2-3-8 2-15-3-15 8-3v-15l18-16-11 4v-6l11-13 44-12 5 12 27-9z"/>
					<path id="machias_seal" d="m21908 12206 1-2 1 2 1 2-1 2-2-1z"/>
					<path id="miscou" d="m21960 7769 27 1 15 13 35 45-4 25-8-1-1-9-7 4-8 16 1 9-6 8-7 2-2 3-2 17-7 10-8 3-10-8-9-13-2-20 8-36v-17l-4-11-8-13-4-8 1-11 3-5z"/>
					<path id="pokesudie" d="m21915 8052-8 11 10 6 3 10 11 2-3 8-14-3-12 5-16-12-1-15-7-1 2-8 18-8z"/>
				</g>
				<g id="i-CA-PE">
					<path id="cascumpec" d="m22920 8807 10 4 7 9 34 25-3 4-8-7-2-4-11-4-3-6-8-1-8-13-11-3z"/>
					<path id="conway" d="m22972 8847 62 21 74 22-2 3-8-5-8 1-27-10-18-5-14 1-4-7-12-3-2 3-10-8-33-9z"/>
					<path id="hog" d="m23129 8903-10-11 42 7 58 4 36 6v3l-13 3-29-7-15 21-6-20-53-12z"/>
					<path id="prince_edward" d="m24511 8379-12 36-35 80-16 29-14 9-8 14 3 6-5 11-13 2-3 11-19 14-55-15 16 9 7 12 10 4-1 14-8 5-26-7-33 17 25-1 4 33 19 1-26 17-24 5 28 5 20 10-9 9 5 18 5 6-10-5-23 3v11l-47 4-9 17 16-10 31 6 14-5 28 27-12 12-28 18h-17l-9 13-15-3-9 4-8-4-13 8-10 2-3 5-12-2-15 6 20 3 20-9 25-3 34 11 12 8v6l-11 6-10-4-7 7-34-7-15 7-4-3-11 4-9 17 12-13h16l12-5 16 5-34 26-3 9-4 6-7 4 9-1 10-18 24-13 6 2 11-11 23 5v14l-7 3 2 8 11-4 4 2 1 4-10 13 10 5 4-8 14-3 3 6 15-4-6-8 18-12-7-13-27 15-2-16 11-9 14-3 13 22 22 12 11 26-4 9 6 25-2 11-13 1-14 17h-8l-4-9-3 8 8 12-11 11-7-2 2 12-24 27 1 3v-1l7-7 6-3 17-21 16-11 2 6 8-4v6l8-7 4-1v9l20-20-1-3 19-6 5 15-15 41-31 32-39 23-36 29-24 14-15 2-12 13 6 8-5 3-4-9-58 25-21-1-42-9-1-11-57-14 2-15 14-7-6-7-9 9-66 49-8 1 10-19-4-6 9-7 6 1 28-37 1-13 14-6-1-14 13-16-13-19 5-9-2-9-7 9-5-8 8-14 15-3 3-8-8 6-11-3-6 10-2 12-4-9 2-5-2-11-5-2 3 12h-8l-7-7-3 4 16 11 8 26-14 19-14 12-10 2-15-25 2-24-5-7 13-6-16-8-12 1-8 10-4-14-8 13 11 18-27 14-9-15-17 14-23 3-13 10-14 4-13-11 5-45 7-9 17-5-3-7-6 4-6-3-1-12 13-4-4-14-5-2 4-8h5l5-3-7-5 6-15 8 3-2-18 14-7 7-19-3-2-15 18-13 11-8 17-12 13-6 32-7 5 7 9-6 13h-7l5 16-1 15-12 10-10-4-13-18v10l-15-1-3-6-17-6 21 20 7-1 14 5 7 10 3 12-17 3 1 8h-10l-4 4 10 7-5 3-3 6 5 3-14 10 14 12 13-26h6l1-13 18-19 20 11v14l-6 18-33 43v16l8 2-21 15h-41l-12 6-50 2-17 8-29-5 1-8-4-6-5 12-9 9-38-13 11-3-17-10 4 12-1 12-20 13-12-8-11-1 8 9-1 5-8 3-12-6-7 5v9l-13 3-10-5-4 8-17-4-8 10-7-12-24-5 1 8-19-3-5 4-7-21 1-4-10-3-7 6-41-15-15 4-13-6-14 13-17-22 7-8 10 1 10-8-40-17 2-6 27 8 12-5 15 3 5-10 5 1 15-14-12 7-16-3-5 5-7-5-12 2-4-12 4-6 4 1 2-13-17 13-16 7-11-2-17 18-28-2-7 17-21-9-23-1-11 21h13l-24 29-13 11-22 7-16-1-61 25-19-25 5-21 13 5-4-16-9-9v-16l-34-46 9-78-6-17 1 18-17 6 1-15-12-10-8-16 6-11-6-12-9-2 9 12-6 5v38l-5 21-23 2-37-7-5-8-13 5h-8l-12 12-16 9-28 8-3 9-20 17-28 17-41-32-22-47-2-23 7-19-4-6 29-88 6-42-10-78 9-43-2-7 7-25 17-27 14-33 17-31 9-77 14 12 52 106 26 23 17 28-6 12-4 26 1 33 11 26-6 2-9-31-11 2-2 4 13 7-1 38 9 5-1 6-4 1-8-7-3-12-6 4 5 4 5 11-5 6-9-1 8 8 10-6 6 4-17 3-4 8-6-7-2 8 10 4 3-7 14 2 12 18 2 14 3-2 6 11 7-2 3 6-13 20 2 9 13-7 2-13 29-9-21-3-9-10-10 4-5-4-5-10 5-4-1-5-5-2 5-3 29 10 3-17h30l5 8 20 10 42 9 24 17h17l11 8 19 31-19 6-13-9-3 3 16 9 13 12-3-13h12l6 5 7-6 29 3-1 8-10 6 8 15-5 14 10 9 3 15-9 27-18 14 2 18-4 13 4 6 3-11 6 1-2-14 8-15 11-5-2-9 5-4 5 2 17-11 2-17 34 19 6 20-4 6-8-2-5 5 4 7-7 3-2 6 16-7 11-3h12l9 6 20-19 6 1 5 9 3-9 11 1 9-5 3-9-10-3 2-11 9-2 6-6h-7l-12-12-21 6 3-11-12 1-1 5-8 3-5-10 9-24 11-12 9 5-11-17-27 7-1-22 3-16 17-3 1 2-9 5 8 3 4-3 8 1 6 6-5 10 10-9 7-12-12-11-13 1-2 6h-3l7-16 38-9 68-10 23-8 26 12-3 19 7 10v17l9-4-4-2 1-8-2-13 5-2 8 14 4-3 15 8 2 6 4-10-6-6 1-4 11 3-10-12 9-10-1-12-38 11-9-1 72-22 6-6 36-11 13-1 33 24-15 8 8 3 2 23 9-1-5-17 7-7 14 4 14 12 17-9 4 3-1 21 21-22-9-17-11 4-11-2-7 8-19-8 45-5 53-29 75-18 20 8 8-4h9l4 8-21 16 8 7 2-7 14-10 20 13h9l-18-34 1-14-8-11-41 27-4-3 25-15 57-51 32-22 14-5 4 18-6 10 1 8 25-24-23-13 57-45 24 4 6-5 20-1 6-10 20 5 1-10 11-6 5 5 8-7 17-3 6-5-30-4-29 15-8-2-15 1-8 9-12 6-13 4-1-5 17-21 38-35 56-34 48-35 65-27 110-83 39-22 60-16 58-25z"/>
				</g>
				<g id="i-CA-NS">
					<path id="brier" d="m22570 12161 5 6 2 25 11 3-11 36-19 1-6-13z"/>
					<path id="cape_breton" d="m25707 8716 1 8-13 6 4 17-10 27-54 43-1 20-28 19-7 19-59 61 11-36-23-4-32 22-32 53 14-1 7 15-38 7-54-24 3-7-26-17h-30l-75-47-47-59-23-11-54-93-51-32-32-58-35-27 29-74-13-3-13-115 45-80 12-49-11-50 19-85-9-99 14-7-15-78-12-15 4-38-3-30-14-22-22-1-4-51 10-2 11 51 3 1-7-64 16-33-11-17-12-144 39-61 4-40 17-72-20-73 9-92 49-12 33 15 31-23 7-47 23-3 10 15-10 84 8 19-17 47 14 4 10-19 16-5 20 10-15 14 7 14 13-6 15-16 35-17 6-21 50 14 60 159-1 15-28 21 11 27 15-3 14 28 26-16 8 17-1 79 9 32 13 83 17 27-12 76 18 23 6 86-20 34 17-3 7 39 19 8-3-71-7-28 28-90 24-11 27 47-20 51v49l-16 32 3 70-20 64-33 48-12-30-11 45-25 36-27 25-30-14-17 26 14 17v12l-14 11-4 49 10 6-10 29-40 61-22 11-10-7-6 12 12 9-8 18 6 7 91-83-18-34 38-62-9-22 14-25 37-6 31-61 13 1 3 13-4 57-6 25 11 30 14 7-1 22-28 23-12 26-55 45-6 16-43 23 13 19-21 21 12 17 30-19-4-19 34-22v-11l53-5 3 44-22 6-31 50-36 80 26 27-11 43 52-15 49-115 44-28 76-7 21 29-18 64zm435-427-56 30 10 72-17 41-29 9-3 47 1-2-31 65-92 76-78 122-38-25-82 29-18-26-2-11h17l-1-47 25-22-6-23 22 5-10-36-37 5-2-70 22-40 95-335-68 122-41 42-19 74-47 37-30-27-34 21-9-27 13-10 38-100 48-100 25-110 12-15-6-62 42-44-4-40-8-1-11 43-28-5-21 35-8 62-24 60-15 83-19 35-18 9 4-56 13-30-5-50 3-28 14-26 4-51 13-37-3-12 22-82 15-4 20-30 72 49 31-9 9 30-24 98 18 14 21-65 34 35 10 2-8-37-23-19-3-57 13-42 78-17 5 22 13 5 50-30 37 22 30-30 48-18 5 11-18 16-3 84 15 5 38-70 5-1-24 112-34 30 7 30 34 1 50-46 18-2-3 25 65 18-48 30-61 89 6 40-101 55 4 44 82-15z"/>
					<path id="cape_lahave" d="m24065 11507 14 15 1 16-32 2-4 19-6-8-6-25 4-7-6-9 11 5 8 21 7-27z"/>
					<path id="cape_sable" d="m23502 12684 35-1 16 11 4 12-10 32 7 10-7 50-10-5 1-17-37-7-8-9 9-23 19-12-19-13-5-17z"/>
					<path id="janvrin" d="m25545 8963 32-31 17 18-23 34z"/>
					<path id="long5" d="m22605 11996 12 12 3 11-4 81-15 95-20-23z"/>
					<path id="madame" d="m25640 8843 89-43 12 21-39 41 4 29 11 6 14-8-11 53 7 9-21 13-11-8 12-25-18-10-15 14-29 8-55-34z"/>
					<path id="mcnutts" d="m23677 12428 23 15-7 16-27-4-17-32z"/>
					<path id="morris" d="m23130 12511 23 18 14 7-9 2 22 13v13l-6-11-20-6 12 10 6 13-20-16-12-10-9 3-13-12 14 2-4-13 12 6-12-15z"/>
					<path id="pictou" d="m24491 9199 3 14-24 28-32 17-3-13 11-17 27-22z"/>
					<path id="sable" d="m27446 9902 33-103-15 55-7 45-12 29-29 41-34 28-39 23-49 25-33 10-35 5-56-4 55-1 32-5 39-15 22-16 71-48 25-23z"/>
					<path id="scatarie" d="m26256 7892 32-28-15 25 2 13 26 16-77 30 3-11 31-32z"/>
					<path id="st_paul" d="m25280 6950v-35l14 17 4 20-6 13-8-3z"/>
				</g>
				<g id="i-CA-NL">
					<path id="bar_haven" d="m28666 3926 27 2 8 10 5 8-6 43-9 3-25-52z"/>
					<path id="bell" d="m25951 1720 2 14-12 16 11 18 7-13 4 20h-8l-9 38 14-8-4 35h-8l3 13-13 9-19 2-3-13-12 17-12-2-13 9-5-24 3-13-5-12-9 1-2-11-5-1-4-8-4-17h6l7 10 9-12 12 24 11-28h7l4-3-3-7 9-12-7-12 9-23 8 15 4-23 17 7 3-8z"/>
					<path id="bell1" d="m29515 3404 9 4 5 10 2 10-15 60-12 15-19-5 4-53 6-20z"/>
					<path id="belle" d="m25260 552 9 7 5 14 5 19-2 14 18 44-2 31 11 19-12 18-12-4-16 10-10-3-12-32 2-16-13-30 10-17 9 3 2-65z"/>
					<path id="bois" d="m27653 4619h6l4 8-8 39 8-3-4 15-20 23-31 40-16 14-6-4 13-58 15-21 12-4z"/>
					<path id="brunette" d="m27923 5102 24-39 28 23 6-6 5-8 6-2v2l-10 8v5l8 8-12 11v-14l-5 1-1 11-12 10-6-11-19 16-10 5-8 14-7-5z"/>
					<path id="cartwright" d="m24574 318 5 18-18 29-9-8-22-1 4-15 29-14z"/>
					<path id="change" d="m27293 2271 29 14 8 48 15 16 5-5 13 11-14 21-17-21-19-5-14-53-18-3 2-10z"/>
					<path id="chapel" d="m27230 2561h23l11 11 13-6-7 28h-12l23 35-5 9 16 14 1 22-11-11-32 8-16-11-4 8-12-6 6-55 17-14-13-22z"/>
					<path id="coal_all" d="m27251 2673-1 7 16 17-13 5h-29l-9-19 20-10 11 6 2-7z"/>
					<path id="cod" d="m18375-2576 39-4 63 34 16 77-45 13-72-33 1 25-24 10-11-79z"/>
					<path id="cottel" d="m28242 2661 3 10 21-15 10 4-11 34-12 23-1 30-12-10-11 10-6 17-2-23z"/>
					<path id="cross" d="m20644-733 4-95 28-14 6 50-17 59z"/>
					<path id="david" d="m19228-1830 20 8 39 2 1 16-15-1-14 4 17 13-24 9-23 1z"/>
					<path id="denbigh" d="m24639 272 27 8-15 3 11 9 18-3-2 6-25 10h-29l-22 13-21-4 8-30z"/>
					<path id="dog" d="m19323-1678 12 1 40-6-16 16 25-2 11 11-5 13-10 13 10-4-10 15 9 6 8-37 7-4 11 9-14 26-1 11-24 5-21 20 13 3 2 16-16 9-22-5-11-15-2-13 1-38 19-22h10l4-10-19 10-9-3-6-14z"/>
					<path id="dunnage" d="m27269 2491 8 8 4 61-11-1-8-12 2-12-15-15 4-9 8 1 3-19z"/>
					<path id="earl" d="m23236-306 2 22-4 1-3 27 12 8 1 23-7 11-5-1-29 10-9-3-5-23 1-34 32-18 8-23z"/>
					<path id="eastern" d="m26168 2341 22 13-8 14-9-3-24 17-33-5-4-7 3-5 12 5 4-19 19-11z"/>
					<path id="fogo" d="m27370 2108 38-22 87 40 28-14 13 16-29 16-10 19 14 8-34 25 16 8-20 36-18-8v28l-21 9 5 14-12 47-31 1v-17l-17-5-8-26-41-34 1-10 26-9 2-7-28-10-4-38 18-16 24 11 22 24 4-19-25-22 12-33z"/>
					<path id="funk" d="m27923 1678 7-5 1 2-4 5z"/>
					<path id="george1" d="m22744-737 5 12-16 23 24 1 11 16-7 3h-30l-9-4-2-17 19-31z"/>
					<path id="granby" d="m24584 244 49-5 35-16 11 11-11 2 24 16-58 17-17-24-22 15h-14z"/>
					<path id="great_caribou" d="m24923 442 9 3 4 9-22 15-3 7 9 2 9-10 8 11-8 2-2 8-13 3-5-10h-5l-10-3v-5l-11-8 8-2 2 7 3-12z"/>
					<path id="great_colinet" d="m29492 4332 14-13 3 33 6 5 10 24-3 5-7-6v23l-8-4-15-47z"/>
					<path id="green" d="m28092 5540-3 8-3-1 3-8z"/>
					<path id="grimmington" d="m18208-2550 33-39 30 4-4 39 10 4 17-31 35 28 8 42-17 41-80-16-6 10 16 20-28 7-18-17 12-74z"/>
					<path id="groais" d="m25769 1584 15 4 14 16-9 50 29 17 3 17-8 5-11-9-9 2-6 7-3-9-15-3 2-14-14-4-22-27 13-6 8-34z"/>
					<path id="hawke" d="m24286-213 27-1 4 10 4-8 5 1 14 18-9 20 3 2 11-8 4 18-9 6-21-5 10 8 4 10-10 6v8l-9 2-4-11-3 22h-10l-11-5-18-14-10-51 13 1 7-19z"/>
					<path id="henrietta" d="m22281-193 4 12-4 9-9 4-11-3 6 6 11-3-6 12-5 3v4l-4 4 10-2-6 6h4v5l-5 13-29 29-6 2-7 12-7 5-13-5-6-7-4-12 14-32 4-14 22-29 13-2 6 4 11-14z"/>
					<path id="hillsbury" d="m19244-1494 19 14-3 10-79 31-11-5-3-14 2-9 11 1 17-8 22-6 14-12z"/>
					<path id="huntingdon" d="m23225-358-35-49 111-56-6 48-34 47z"/>
					<path id="iglusuaktalialuk" d="m18646-2143 15-12 14 5 20-2 8-8 14 10-6 7 21 3 2-6 11 20-2 4-14-2 1 22 9-5 1 17h-24l-21 23-34-13-16-40z"/>
					<path id="iluikoyak" d="m19850-1037 8 2-4 19 4 10 41-3 2 12h11l-2 13-10 7-30 1-11 7 3 9 20-10 27-6v3l-21 11-23 16-19 2-7-4 13-12-9-5-7 10-4-8-9 12-10-7-9-11 6-9-7-5-4 5-12-16v-8l13-7 19-2 6-11 12 11 10-6z"/>
					<path id="island_of_ponds" d="m24030-556h28l1-6h31l-12 8 1 10h-15l-12 20h14v4l-7 3 2 5 7-1 3 4-8 4 6 8 15-14 5 1-3 7 24-4-2 16-31 1-12-3-16 8 28 2 29 2-6 4-17 5-40 2-11 11-12-3-2 7h-19l-12 8-16-3-13-18-11-1 3-18 16-27 15-2 7-20 15 5 31-10z"/>
					<path id="kikkertavak" d="m19157-1212-2-15 147-47 3-32 62 11 2 29 32 16-84 45-104 15-19-20z"/>
					<path id="kikkertavak1" d="m21576-906 21 8 7 10-3 17-7 3 6 6 6-11 11 2 9 8-9 13 6 10 6-7 11 11 4 19-12 2-4 8-15-19 5-4-8-11-10 5 4 8-4 6-2 15 5 8-8 4-7-1-3-11 2-39-11-16-10-25 2-13 8 1z"/>
					<path id="kikkertavak2" d="m20578-725 9-40 13-3 34 67-23 40-19-12z"/>
					<path id="king1" d="m28781 4008 10 15 5 16 4 28-10-3 9 6-6 31-16-19 6-16 6-2-7-6 3-21-10-4z"/>
					<path id="lewis" d="m28142 2622-8 13-11 9 3 10-12 15-25-4 4-15 11-13 22-4 14-13z"/>
					<path id="long3" d="m27650 4720 20 6 2 18 8 14 6 9 15 6 19-2 28 5-12 31-15 4-9-1-11 9-11 1-26 20-9-10v12l-14 6-2-4 8-12-10 8-13 6-12 2-6-9-8 20-20-16v-15l30-31 1-12 20-22 19-11-4-11 10-8z"/>
					<path id="long4" d="m28790 3908 5-2 44 33 10 23-11 8 6 14 12-1 9 33 16-5 31 34 23 55-30-17-66-84z"/>
					<path id="long6" d="m26647 2847 5 9-6 13-66 69-13 2 4-29-13-9-7-8 9-26 11-11 12 9 1 19 8-22 11 4 5 15 26-13 2-10 6-9z"/>
					<path id="merasheen" d="m28776 3937 31 44 24 59-4 14 8-6 4 10h-7l13 26 6-6 3 32 11 27 3 45 14 28 8 29-4 19-27 19-46 16-6-9 14-17-5-22 14-48-18-82 2-26-10-23-5-29 8 1 9 12-2 13 8-11 5-3-12-3-24-43-20-59z"/>
					<path id="n_aulatsivik" d="m16176-3836 14-44 26 13 1 28 28 23-29 8-2 15 92-9-13 64-16-1-17 42-14 9h-17l-3-30-29-1-16-23 16-21z"/>
					<path id="narrow" d="m23821-469 7 3 16-6 21 8 15-14 10 3-8 8-15 11-10 1-7 5-17 4-7-3-13 5-8-6 3-10z"/>
					<path id="new_world" d="m27195 2396 19-33 31 32 11 35-14 62-41 36 2 10-26 23 22 16 4 29-20-4-21 31-33 27-13-34 7-13-30-17-10 14-35-33-2-16 34-12 24-36 11 37 32 18 30-86-14-14-4-18 7-33z"/>
					<path id="newfoundland" d="m25116 3403-2-84-16-43-20-134-47-186-16-8-32-136 13-84-24-32-12-33 24-39 47-3 51-38-20-35-41 63-113-52 104-174 4-151-120-72-7-14 82-12 2-51-52 1 35-35-20-63 23-37-1-23-35-16 12-55-37-8 5-158 70-130 23-6 23-70 47-118 43-57 55-169 14 20 24-28 13 80 39 42 82-56 58-8-9-6-83-28 8-71 41 10 16-6-4-24 42-50 46-4 10-18 93 239-52-12-3 20 35 16 3 56-95 46-20-14-114 94-50-17-19 21 5 64 49-15 51 30-7 42 80 38 19-102 57-30 67 10-22 36 36 5 27 57 14 150 21-13 16 47-38-21 12 52 22-17 9 61-32-39 8 241-10 8-48-86-8 1 34 73-26-3-22-42-54-100-15 19 13 55 6-27 39 55 28 67 33 43 39-24 19 56-15 51-43 11-4 11 34-4 30 87-29 14-5 21 31-20 3 187-41-1 4 23 40-3 11 23 24 130 2 133-50 18 5 6 42-6-15 130 45 105-3-51 20-2 48 133-38 132 57-35 30 1 25 27 46 170 12 1h1l-29-393 25-92 20-7-13-183 17-172 55 8-2 17 20 5 6-11 28 23-16 25 30 89 7 43-7 19 8 2 14-31-13-44 27-91 13 5 14 21v38l19-31-6-32-11-11 40-35 70 30 74 6 33-29-14-28 19-25 38-13 31-77 62 40-76 200-102 241-26 30 31-2-32 114 31 39-8-45 11-67 28-75 87-54 6 72-11 44 44-12-3-31 17-14 19 14 2 31-18 39-15 51-49 71 11 13-12 81 20-2 14-21 9-92 71-97 84 9-6 56 50-81 18 1-15 40 45 23 7 24 15-27-14-17-2-102 34-3 1 59 18 16 13 24 1 14 13-1-24-80 21-62-12-25 34-37 13 15 7-23 5 23-9 84 12-8 31-79 14 7-22 145 16 2 10-44 17 13 15 40 8-24-35-67 21-33 32 35-12 40 43 20-20-31 12-39-93-105-54-23 101-82 11 18 35 23 18 42 15 83-21 1 45 89 11 5 18 21 5 14-13 53-10 14 5 44-8 36 12 7 13-20 19 2-3 29 9 4 5-15 34 24-4 13 23 2 10-29-22-3-18-13-20-37 6-36h-10v28l-12 5-12-20-5-24 8-4 10 9 9-62 6-9-3-19 51-86-57-36v-23l32 22 26-8 39 26-1 59 16 16 5-14-9-9 10-41-10-12-4-20 4-22 16-10 19 22 7-2 10-22-19-35-2-18h-39l-6-64 11-5 40 61 26 18 4 18 22 13 8-2-4-18 7-14-4-12-16-9-14-32 3-11h19l26 34-6-39-10-1-6-13 11-8-10-13 19-4-14-72-13 12-5-16 8-2 4-17-5-119 29-63 22 18 3 19-10 9 1 29 11 9 5 60 10 10 2-49 27-37 9 19-11 13 29 25 9 29-7 11 15 26 39 19 25 80 9-8-15-29 5-31 11-18-43-62 2-48 25-45h8l16 27 2-28 12 1 7 22 16-8-4-21 6-9 6 13-2 13 15 26 8-4-15-35 4-14 21 3 13 24 5-20-30-43-9-29 10-3 17-28 5 5 13-13-8-8 4-19h7l9 9 26-27 8 16-8 16 7 4-10 16 5 6 10-12 6-19 8-5 3-25 54-7 39 6 54-22 32-8 60-7-6 22 21 11 84-22 19 10 29-26 27 17 17-15 3 61-10 36 30 37-11 19 11 15-16 23 51 47 8 19-144 123 10 9 55-44 17 1-12 10 4 18-54 62-21-9 7 25 28-20 12 2-2 11 31-14 13 8-12 36-30 31-24 12 1 15-24 18 15 9 34-45 14-5 8 3-7 15-22 23 7 19-16 14-3 14 22-4 5 24-14 11-4-22h-5v17l-30 26-8 27-13 7-10-6-9 12v27l-17 11 20 7-10 14 10 19 16-3 11-19-5-4 1-13 21-38 12-9 9-30 20-16 17-5 6-50 38-30-2 10h18v-19h32l13 14-27 44-32 17h24l1 24 14-8-2-11 12-22 6 4 3 31-6 30-41 8-17 11-28 31 19-1 17-23 10 18 5-13 16-4 7 8 2 17-25 15-1 32 10 3 30-47 10 26 54-9 21-34-8-8-28 32-37 14 1-32-5-13 13-24-6-6 4-53 9 4 6 54 31-19-1-9 11-21 19-16 18 15h29l-9 34 17 8 27-82 20-12 10 8-6 47-14 27-27 30-6 18-31 18 4 6 10-5 3 13-13 35-12 14-23 10-12 23 3 24 11 20 6-54h26l3-19 64-41 2 11 13-22 18-7-21 30-18 14-3 15 14 3 10-23 21 31-3 13-39 48-28 50 2 24-23 37 8 5 1 15-25 31-15 7-24-2-8 61-16 7 3 7 32 1 24 26 3-2-16-48 8-43 15-7 16-2 2-14 10-8 5 7 33-123 12-21 15-11 6 6 5 39 7 9-6 49 3 21 14-9 11 4 13-15 6 1-8-14-6 14-18-14 10-26-6-41 8-11-18-25 5-29 8-15-1-36 24-42 17-8-10 29 34 7-5 39-1 45-12 18 7 17 17-34 3-41 18 29 5-8-9-18-7-31-7-44 21 4 3 32 7 2 5-38 9 8-5 44 19 15-1 48-11 32 11-15 10-69-9-19v-23l5-6 18 29-8-28-14-25-9-34 17 12-1-21-11 2-4-33-10 4-25-31 5-17-9-42 50-11 4-20 7-2 49 20 11 42 10-7-3-18 13-8 17 21 22-9-7-41-10-9 15-49-12-12-2-22 17-28v-17l-13-3-9-58 12 7 1 18 51-9 62 38 7 19-6 13 29 13 1 14-15 21 5 14 26 54 12-6 5 34v45l-11 27-13 3 5 17-11 11 13 19-1 16-43 13-33-11-24 12 19 27-45-5 12 24 24-5 6 9-17 11 15 61 11-5 16 6 3 12-7 8-19-3 5 17-18-6-6 56-11-4 7 20-16 23-11-1 8 16 1 23-13 35-1 18-20 11-2 14-10 13-13 3-31-8-39 17-16 31-54-8-45 18 17 21 10 22-8 8 20-1 15 16 36 16 17 27 8 18 39-26 17-3 17-26 45-30 15-23 19-5 20 11-5 26-16 35-24 26h-7l1 13-11 9-49 28-10 2-8-4-5 1 4 7-12 8-2 8 16 1 63-34 24-6 26-45 7 1 3-10 7-6 18-34 13-44 8-3 1 26 17 22 17 61-7 6 18 34-1 23 9 2 2 7-15 8 11 30 15 10 14 74-2 33-42-9-32-17-35-13-1 6-34 15 3 8 31-14 38 17-8 12 19-5 18 17-4 5 43 21 21 18-8 7-12-1 18 21 6-10 11 2 19 9 8-4 29 22 11 2 24-13 2-20-16-38 1-20 30 12 13 31 13 55 17 21 5-1-2-18 2-25 8 5 3 15 17 5 3-16 27 61 9 3-10-60 21 7h51l-16-33-18-12-8 11-13-27 18-7-33-9-10-11-4-14 44 5 2-12-11 1-29-19 4-3 22 8-1-11-35-14-3-8 14 5 3-8-4-13 8-4-4-19-23 2-11-18-19-18 5-17-3-15 9-7-6-6-7 6-8-11-5-32 10-1-1-8-14-15-9-22-1-21 6-18 14 7 6-4 5 2 4-7-7-3-3-7-12 5-16-33 9 3-2-10 7 3-4-10h-11l-3-11 8-6-11-6-1-17-14-57 5-24 15-15 9-29 11 6 3-18-5-12 1-17 10-11 22 12 8-7 16 1-3-13 6-11 14-10-4-25 16-35-15-10 8-9-8-14 1-18-16-35 4-2 3-20h17l-1-5h11l7 8 13-9 14 18 20 10 9-8 17 8-2 12-12 6-4 6v8l6-1 5 5-6 6-16-9-8 8-6 42 10 1 1 18-5 3-1 11h7l18 10 9 37-4 29-6 1-2 9 5 8-6 25-9 10 18 9 6 14 5-1 5 8-3 20 5 2 12-14 4 6v14l-4 19 5 3 3 16 7-1-2 25-6 2-5 32 11 10-3 11 9-1-4 60-16 15 13 5 20-20-2 18 14-17-4 50-11 23v17l34-71 2 33 7-10 4 32-1 23-22 42 7 6-5 13 7 6 15-21 16-40 5 9-6 10-3 23-9 9-5 21 7-14 7-5-4 17h11l7-13 14-58 5 3 1 21-6 6-4 18-9 15-7 42 10 2 12-39 12 9 1-36h7l19 17-10 18 5 6 12-15 8 19-1 18 7 1 11 46 5 8 5-16-5-2v-7l7 2-13-40 4-10 10 9 8 15 7-2 4 18-9 38 6 3 2-14 17 17-7-32 6-7-3-14 16 33 4-6-5-20 21 11 5 14 2 28 7-7 12 11 5-3-18-33-11-32-1-36 18-72 9-8 5-34 15-23-13-34-12-61 5-4-45-66-23-66-17-29-8-26 8 2-3-9 5-2 35 15 10 15 32-19 12 12 4 12 17 2 7 21 6 1-1-11 6 14 7 44 7-13 5-3 15 8 1-9 6 2-4-19 20 12 25 20v12l10 6v9l25 63 48-21 12 37-14 43-12 4 7 8 46 5-6 32 3 37 40 85-15 5-12 15-18 4 8 7 31-10 10 9-35 34 21 4 24 11-6 6-25 10 11 2 12 11-2 25 31 26-9 22 21 6-2 12-6 2 12 11 3 28 15-3 2 9-17 4 1 12h-9l-5 13-6-1-13 10 3 4 74-30 13 24-41 16h32l8 6 3 29-41 35 5 4 40-28 21 15 4 16-37 12-6 6 52-12 14 11v29l-14 8 3 6 19-1 12 51 44 64-7 31 10 11-4 15-13-5-4 30 36 94-3 27-31 45-44 16-46-16-26-27-10 3-2 13-20-36-7 5 9 39-6 33-25-28-16 8-18-31-8 13 9 11 7 36-3 68-9 72-25 28-48-2-70-52-4-57-22-11-25-6-7 11-6-4-13-21-6-26-9-69-16-2 2-30 17-1 11-51-13-11-5-24-1 21 6 11-1 10-5 16-10 9-7-21-8 1-10-12-9-20-1 15 13 29v21l-9 8-17-19-14-34-7 1-6 27-7-8-5-16 1-75 2-17-9-4-8 14-4-2-2-31 8-28 21-27 4-19-3-19v-21l6-15-14 17 2 47-22 25-9 3-10-43-13-2-1 34-9-3 3-7-7-18-8-3-17-38-3 13v41l8 31 15 21 3 17-5 35-12-13-25-47-4 4 16 50 13 23 3 17-11-10-6 5 15 22 5 21-5 25-11-4 1 15-8-7-7 3 7 10 6 45 7 10 1 51-10 9 13 28-2 56-18 13 1 8 15 8-10 44-13 1-4 57-24 8-3 19-45-6-29 27-27-35-26-59-17-13-22-59-20-135-35-73 2-13-11-18-3-33-10-18 2-5 6 2 11-12 7-2-2-17-5 6-16 5-15-6-10-13 3-9-11-14-16-8 17-17 10 4-4 15 4 7-3 4 4 7 11-33 13-10 25-7 4-15 8-9-12 9-4 11-16-2-8 3-1-7 8-6-2-3-9 5-2-5-8 18h-6l6-15 8-6 1-17 10-23-9 5-6-23-4-4 3 14-4 28-15 5-1-10 6-7-12-8-6 3-6-7 16-40 24-31 9-46-4 3-12 31-25 17-3-26-8-3v25l-19 31-4-17-10 2-5-18-7 16-33-93-3 17-50-83-18 14-42-24-16-39-73-56-22 31-14-51-10 1-12-28-6 5 2 48h-31l-6-26-22-6-5-11-18-17 6 28 20 15 4 14-48 1-34-11-34 11 9 8 12-8 17 7 37 80-1 24 18 68-7 10 6 28-7-2 1 20 8 7 12 24-9 11 8 7 23 122-4 34-7 14 19 13-5-30 10 7 10 23 30 4-1 41-5 17-10-1-7-10-3-29-5-2-1 75 6 18 3-11 6 1-2-33 11 18-8 50-6-2-2-11-14-9 1 22-6 41-8 7-17-7-10-15 2-28 7 4 2-17-8-5 4-49-6-40-5-9-18-86-7-69-4-7 1 45v70l6 7 14 86v47l-7 51h-11l-5 29-26-11 12 37-11 22-11-16-46 40-25-70-3 16 12 35-1 20h-8l-16-54-7 2 10 70-6 6 8 39h-14l11 35 1 55-19 2 9 42-3 52 47 6-3 53-6 8-33-45-32 23 7 36 11-13 25-8 41 47 8-7 10 64-22 31-23 3-7-16-21-2 9 24 16 3 23 37 12 29 6 87-28 45-9-2-23-9-13 2 33 15 1 5-27 12 19 6 2 14-62 44-9-2-15-13-8-29-10 2-1 23-20 12-17-24-4 2 15 41-5 8-13-19-12 60-31 50-79 57-85 19-42-6-34-26-17-44 5-25 6-11 7-81 11-17 13-3 5-10 5-45 29-5 10-12 33-4-1-25 26-36 12-6 27-54 18-6-13-61 14-14-3-43 16 1 14-86-67-121 20-119 32-54 79-76-4-11-15-4 6-16 21-3 31-67-54-22 26-68 25-59-15-6-43 74-12 40-13 20-10 2 2 15-15 32-16-3-15 31-12-15-3 26-11 15h-12l-16-20-1-39-6-17 6-15-3-25-12-28 4-17-3-36 5-9-14-51-2 70 7 20-6 30 16 30-4 80 19 28 4 24-14 9-36-17v-28l-12-5 3-10-6-27-6-5 2 47-12 20-35 10v-17l-12 6 4 8-26 23h-32l-13-10 5 25-5 12-14 14-2-11 5-14-15 5-12-9 5-40-9-5-3 12-7-10 1-15-22 28 20 10 3 17-9 4-19-15-15 13 36 19 2 45-7 3 6 23 15 4 3-22 11-17 22 7v13l-10 36 10-1 4-17 12 11 1-20 11 1-3 27 12 4-3 22 9 13 12-3 6 3 19 40-3 6-8-10-6 5 15 13-5 13-16 11-13-11-3 3 15 17-12 28-11-8-23 24v23l12 17 4 16-13 15-10-1 4-24-7-16-13 5-8-14-9 2v26l-5 13-6-2-3 13-3-14 12-28-10-6-10-55 10-10-26-3 3-8-10-4-1 13-13-5 11-43-7-18 2 27-9 12-1 20-12-6 10 17-1 20h11l8 11v14l-9 22-11-17-21 10 21 17-23 63-23-46-2 11-8-4-13-69-3-26-8 17 7 23-5 6 7 40 10 19-3 8 12-1 7 15-3 14-20 9-22-2-10 25-8 9-2 29h-7l-2-15 5-16-6-20 30-60-7-2-6 9-9 1 5-31 7-21-5-3 5-45 7-14-7-13-1 10-15 28 4 22-1 27-12-6 4-31-16 20-3 45-18 10-21 29 7 22-13 22-35 27 5 16-27 33-1 12-8 4h-27l-15-5-6-8-9 11-5-10 5-18 13-18 35-38 68-89 28-81 6 2 24-57 16-46 21-24-1-10 12-11 7-20-50 60-22 60-15 26-18 23-9 3-14-10-10 4-20 3-19-9-9-20 1-39 24-55-17 3-6-24 12-10 18-68-6-2-39 41-9-5-16-26 4-38 23-29 10-23-2-34-17 58-10 12-25 4-5-8 1-21 12-13 3-22-41-18-1 4 22 16 4 9-3 16-12-2-1 27-9 15h8l7-9 16 19-19 4v6l23 10-7 15 8 14 1 14 29 19-6 9-6-6-34 2 10 9 24-2 1 5-22 41-44 39-3 10 13 6-10 38 7 19-34 38-30-29 1-17 7-10 2-50 13-45-7 7-6 24-8 15-9-7-4 3 14 12 1 16-7 28-20-7-26-26-3-13-4 5-8-3-2-10-13-3-37-32 6 17 34 25 14 18 7 2 28 25 8 15-19 48 21-20 29 38-1 6h-19l3 17 13-8 19 6-20 14 27 13-15 13-43-19 30 41-19-5-28 38-11 3-6-7-4-18-18-20-12-19 10-16-15 6-10-3-41-50-3 11 39 45 1 7-8 15 16-7 17 20 7 17 6 6 15 19-18 8-37 10 24-1 27-7-19 37-33 24-46 20-13 1-23-36-15-41-12 1-13-19-2 13 7 4v5l-18 1-5 10 25-2 14 3 10 24 10 8 4 15 13 12 1 6-8 9-34 17-3 7-12 7-3-5 1-11-19-16-15 2 11 2 16 15-1 9 7 7-12 10-14 2-14-19-1 12 11 9-23 9-6-9-14-10-6-9 4 17 16 9 5 16 17-14 23-2 17 14-4 16-9-5-10 8 7 4-24 7-26-2-7-7-1-10-14-4-11 5-22-15 21 23 16-4 2 14 14 9 31-2 7 8-11 11-11-8-4 3 7 8 12 4-15 28-10-12 5 23-8 17-17-9 1-23-19-18-3 2 15 20-6 14 9 11-12 18-13-6 3-16h-11l-24-26-13-27-9 8 16 25 29 25-5 17-53 11-3-4-54 11-28 45-23 19-16 5-38-3 13-23-30-30-9 6-13-21-8 1-17-23h-4l14 23 23 27 20 16-6 35-27 19-12-3-9 7 9 6-18 17 1 6-14 11-13 4 7-15-13 5-12-26-9-54-6-3-3-24-12-12 2-22-31-19 4-16 7-10-6 1-13 17 8 23 20 13-3 21 6 10 9 3 8 26 4 33-17 18v16l-13 5-3-8-17 8 3 6-21 9 1 10-14 8-6-10-15 10 5 14-23 5-5-10 6-25-8 7-6 14 3 13-14 14 7 16-12 12 7 7-28 34-1-11-52-8-28-10-17 13 5 21 8 1-2 19-8-9h-9l-2 13-21 7-30-14-35 35-11-36v-12l5-10-1-16-8-13 5 24-14 20-7-6-9-16-4 7 3 15 14 34-7 6 2 10-8 7-18-15-10 8 12 10-3 5-19-6v-8l-24 6-9-19-13 1 11 16-5 35-9 5-8-9 1-23-30 26v24l-20 5-21 22-5 25-41 3-15 12-7 17-2 25-12 4-1-34-4-2-10-51 3-33 11-15-5-11-18 33-9-8-5 21-12-51-14-2 25 73-1 13-10 4 23 33-8 12 9 7-16 20 18-7-4 37-8 6-11-4-19 4-16 10-12-7-2 19-9-1 1-5-30-8-15-11 1-40-5 3-6 31 23 24 18 6 14 20-16 11-22-7 17 15-21 42h-11l-2-68-5-2 1 35-7 23 6 6-2 10-20 5 12 9-2 18-80 57-18-1-87 84-17 34-40 11-13 25-24 16-50 8-26-20h-32l-11 18-11-2-46-66-14-43-20-21-18 3-37-57-77-22-18-19 1-18 36-61-3-58 31-101 55-128 23-21-1-72 62-233-22-33 106-185-22-32-28-15-40 43-56-19-98 47-22 46-84 80-59 20-117 154-17-100 27-113 41-72 23-80 16-1-10 87 29 23 41-11 14 37 22-28-11-44 46 24 61-33-5-78-48-51-44-303-35-70 12-21-29-131 11-29 14-2 15 18 16 63 28-2 30-46 74-34 47 34 65 9 84-32 9-20 24-2-26-22-26 34-69 22-24-17-42-6-12-22-28-3-34-45 20-25h54l13-40 50-15 12-64 3-15-16 7 5 10-14 52-40 12 3-30 12-37-21 31-22 58-19 12-1 1h-29-2l-3 1-15-23 48-16 29-32-12-3 11-61-11-4-24 55-31 19-76 16-18 19-68-33-29-85-18-15-8-35 5-77 34-131 19-18 47 3 26 21 3 26 36 16 2 8 14 6h1l7-7-15-4-1-13-33-14 4-34 18-17 59 17 18-8 19 5 1-29-38 9-45-8-33-33-4 4 11 31-17 17-71-34 9-16-37-4-47-65-22-98 11-38-25-46 16-22-9-19 22 1 32 33 67-50-1-13-81 21-3-18-51 16-4-17 13-42-2-36z"/>
					<path id="okak" d="m18449-2286 7-18 25-4 53 13 21 41-16 70-29 31-19 1-51-36-21-3-17-19 10-57 19-5-4 19 19 7 8-18zm112 37-8-39 55-22 19 19-24 19 7 7 25-4-5 37-50 21 3 13 53-21 63 4-15 38-32-3-70 33-60-5 21-26z"/>
					<path id="palungitak" d="m19235-1320 21 5 6 11 8-7 4 4-19 16-40 9-8-9-11 8-2-3 8-6v-11h15z"/>
					<path id="paul" d="m19176-1391-12-19 64-23 76-5 45-19 20 24 68-29 30 22-24 25-148 52-11 29-78 12-24-24 84-20 1-26-49 15z"/>
					<path id="pilley_s" d="m26575 2948 35-25 36 32-12 23 7 4-12 28-16 12v-20l-25-15z"/>
					<path id="pitt_sound" d="m28215 2666h6l1 21-5-1 1 26-10 19-22 5 3-15z"/>
					<path id="quirpon" d="m25421 945 13 1-8 13 6-1 2 10 9-3 11 9-9 7 7 11-2 13-25-18-6-22z"/>
					<path id="random" d="m28783 3205 18 16-17 7 3 16 16-1 20 13-17 13 25 24-9 6 1 9 19-4v5l-25 36-19 19-21 9-25-5-18 21-15-8 7 12-20 18-16 7-14 22-16 9h-37l-37-31-36-3-24-31 4-9 26-6 44 15 2 10 6 1 5-13 32-44 19-10 21 14 20-5 26-36 33-74-1-16z"/>
					<path id="red" d="m28917 4195 25-8 23 36-3 20-8 12-11 5-14-1-8-13z"/>
					<path id="rexons" d="m24503 284 23-13 16 2 9-7 11-2 8 6 20-4 2 2-15 10-1 33-85 25 8-18 20-21z"/>
					<path id="s_aulatsivik" d="m19189-1641 26 20 31 103-31 8-52-31-41 9-14-19-19 16-26 43-12-4 15-75-22 8-26-88-32-44v-33l30-34-19-32 12-37 28 17 39-31 20 3-13 59 44 14-41 106 81-27z"/>
					<path id="s_twillingate" d="m27075 2432 28-23 14 3 11 33 18-7 14 41-22 10-5-13-22 10z"/>
					<path id="sound" d="m28629 3808 35 1 11 7 6 19-5 24-10-5-9 13-18-24z"/>
					<path id="spotted" d="m24046-614 14 14 15 7-23 25-18-3-25 5-9-6 2-24 26-5 8 7 11 1-2-6-6-2 1-10z"/>
					<path id="square" d="m24493 83 7 13 5 36-21 6 1-14h-7l-3 8-10-2-15 5-13-28 15-8 23-10 2 5 10-10z"/>
					<path id="st_john" d="m24909 2377 27 7-14 46-11 7-6-3 8-15-16 10-11-4-3-24 7-10h13z"/>
					<path id="stony" d="m24347-146 12 7-4 12 4 4 7-12 7 3-6 8 4 14 3-3 13 35-3 5-29-5 7-9-15 4-1-3 5-7h-24l-14-17 28-33z"/>
					<path id="sunday_cove" d="m26529 2939 20 7v11l23 16-7 11 3 11-15 13-21 3-11 22-10 1-4 13h-6l12-32 10-4 4-13 11-11v-20l-11-23z"/>
					<path id="swale" d="m28402 2903 5 6-6 10 5 11-22 39-20 10 1-14z"/>
					<path id="thwart" d="m27043 2894 12 6 6-6 12 4 11 16 15 11-10-14 9 1 10 9-14 22 2 16-10 28-11-6-9-25-23-22-1-4 17 2-13-16z"/>
					<path id="triton" d="m26701 2888 2 16-34 59 3 6-16 26-11 7-3-15 17-37-8 5-5-5-5-17 4-9 8-1 8-10v11l12 6 1-9-8-2 12-17z"/>
					<path id="tunungayualok" d="m19626-1185 16-34 57 17 5 31 55-11v73l21 3 20-15 9 27-29 7-10 15-110 20-52-47 24-44z"/>
					<path id="ukasiksalik" d="m20003-1089-10 25 11-12 1 8-19 27 5 5-10 12-8-2 3 15-8 3-3-5-9 15-23 14-19 2 7-18 33-18-2-6-25 9-16-5-17-19-5-14 6-18 6-8 13-1 9 12 3-3-3-11 4-6 19 1 6-11h3l11 35 7 2 7-33 14-4z"/>
					<path id="willis" d="m28282 2721 6 16 13 8 1 15-10 2-7 15-22 13-4-4-3-26z"/>
				</g>
				<g id="i-CA-YT">
					<path id="herschel" d="m-15385-15992 39 75-9 48-35-36-73 17-13-54 3-32 35-17z"/>
				</g>
				<g id="i-CA-NT">
					<path id="baillie" d="m-11485-14490-68-21 73-79 26 74z"/>
					<path id="banks" d="m-8583-17251 7-37 12-49 24-54 9-47-3-9 6-20 10-9 5-8-2-29-7-40-22-35 5-19 23-3 207 36 154 53 21 1 72 10 4 1 6 8 9 6 20 6 52 9 33 21 44 15 82 21 43 1 83-10 16-1 32 3 66 16 19 11 38 33 18 16 23 25 2 3 2 19v36l10 57 81 146 15 23 32 45 34 44 62 59 16 12 11 3 8 5 3 3 2 9 1 24-14 23-27 27-33 17-9 8-7 10v6l5 3 8-1 41-4 30-21 21-17 6-8 3-14 5-9 9-7 16-7 58 29 22 14 11 13 1 11-7 13-17 55 3 24-24 37-3 3-14 1-5 3-24 43-1 7-3 11 3 5 38 15 9-1 7-4 67-57 23-39 2-9v-4l-3-4-9-6-4-21 8-16 19-14 27-8 45-10 152-1 22 4 169 127 15 27 34 63 37 101 34 85 17 40 132 409 27 18 19 33-10 12 44 139-16 62-32 5-35 33-164 63-198 17-64 17-54 29-73 30-94 12-12 24-58-10-248 101-16 5-39 2-68 18-14 11-14 2-8 4-10 12-6 15-21 8-56-12-76 22-88 32-11 4-19 13-19 33-48 74-38 49-25 37-16 27-12 32-33 17-25 4-21-3-11 2-41 18-40 23-18 13-11 6-12-4-51-31-36-24-2-13 22-17-1-8-3-4-28-11-4-1-4 1-19 30 2 19 4 10 2 60v6l-5 12-36 54-46 41-9 7-66 36-16 14-10 10-8 14-28 97-44 74-13 24-1 14 7 22 1 12-4 9-59 82-39 48-8 6-22 14-78 26-17 2-76-1-136 8-25-8-3-4-16-58 5-34-2-10-18-16-6-3-30 2-22 7-26 9-37 20-48 41-33 32-44 13-55 8-43-1-49 4-45 14-24 10-26 15-57 43-60-32-36-12-14-16-8-24-14-79-5-42-1-26 5-29 36-126 8-34 18-106-1-9-5-10-21-32-14-16v-1l7-21 9-55 4-29-4-44-12-53-25-58-17-28-32-41-48-42-38-77-47-109-26-82 10 3 5-2 6-12-2-6-10-7-34-17-47-15-81-17-12-5-53-41-7-13 7-8 12-4 5 2-1 3-11 4-3 4v6l8 9 26 19 3 1 24-16 33-17 5-2 25-28 26-36 3-26-3-8 103-126 44-7 26-35 72-76 60-46 119-43 20 6 8 4h4l4-4 4-82 46-20 34-66 3-14 17-83v-7l-6-12-4-3-5 3-1-4 2-14 3-7 12-10 10-4 12 3 94 47 4 3 14 2h26l57-14 4-9 2-37-4-26-22-49-6-2-6 4-3 5 2 7-2 3h-3l-14-36 5-52 3-12 7-11 5-3 14-2 60-36 77-55 6-6 13-18 2-6v-12l5-7 30-33 107-106 2-3 35-21 6 1 5 5 4 1 58-8 7-3 6-6 29-49 1-1 34-75 2-2 17 4 19-14 33-3 13-12 28-28 13-29 16-38-1-4-14-36-5-6-4-2h-6l-4-1-11-7-18-17-5-8-7-20-1-10 25-35 3-68-2-7v-61z"/>
					<path id="brock" d="m-4497-20373 77-36-6 42-15 3 16 35-21 15 63 26-13 20 20 74 35 24 3 35-17 27 26 28-62 59-49 25-96-6-41-89 9-19-49-109-22-116 31 2v22l96-68z"/>
					<path id="eglinton" d="m-5917-18618 48 59-96 135-87 65-8 40-56 40-6 40-191 152-49 13-26 23-30-26-7-32-40-16-1-32-52-31-39-38v-30l56-50 204-130 24-32 135-50 44 17 50-58 30 4 61-56z"/>
					<path id="eight_bears" d="m-4501-19324 18 12-6 36-32 1-26-22z"/>
					<path id="emerald" d="m-4740-19121 65 28 25 70 24 19-11 50-61 60-34-2-4-18-25-12-39-4-4 20-12-4-3-22-23-25-47-6-96-72 2-22 24-36 54-34 32-8 4 10 33 5 23-11z"/>
					<path id="fitzwilliam_owen" d="m-4574-19365 6 23-31 23-34-9-9-35 12-18 33-3z"/>
					<path id="garry" d="m-14505-15094 28-1 27 60-15 38-5-38z"/>
					<path id="george" d="m-6260-12065 48-2 124 104-76 2z"/>
					<path id="giants_causeway" d="m-6825-18752 40 5-9 50-98 128-34 22-50-50 9-18 85-14z"/>
					<path id="kendall" d="m-14362-14976 28-5 23 23-7 11-51-10v-20l-9-9 13-10z"/>
					<path id="nicholson" d="m-12132-13953-48-56 32-8 24-26 26-23 26-11 13 8-30 56-25-3-18 26z"/>
					<path id="pelly" d="m-14315-15137 29 15-61 38-30 2-3-34z"/>
					<path id="prince_patrick" d="m-4927-19724 2 26-16 29-26 21v14h-70l-16 20-33-2-42 19-50-24 9 46-27 23-24-25 4 50 22 12-26 66 76 93 13 52-29 28-40 4-57-77-33 4 13 101 17 8 25 51-27 136-32-4-31 58-133 24-64-30-20 29-33-28-20 8-16 39 5 34-24 59 6 42-24 40-43 30-39 14-22-6-17 26-46-29-32-41 17-9-17-38-23 5-7-24 14-11-32-86 35-70 53-49-6-31 54-123 65-42 30-58-7-34-18-5-51 62-30-15-35-40-19 25 7 30-30 28-12-42-28 45 20 48-35 101-21-10-32 15 2 16-34 12-24-38 3-22-16-30-10 10 14 32-35-21-29 46 33 25-5 18 30 17-20 138-50 41-69-10-23 50-1 52-43 44-20-16-16 42-18-4-27-64 15-61 3-124 29-54-14-14-20 38-17-13-22 51-21-6 12 89-20 37-30-19 24 47-6 22-54-33-16 9 45 52 8 41-12 44-32 51-5-15 4-28-52 28 11 29-30-6-9 44-65 15-39-7 6-68-9-6-53 77-29 3-27-41 53-107 25-28 7-46-26-5-13 33-15-40-4-39 43-97 22-5 9-15-36-45 5-29-59 42-44 89 5 41-25 83-27-2 32-64-74 9-47 65-14-121-59-67-1-18-67-9-21 35-95 38 8 40-19 38-35-31 3-24-46-36 48-16-21-60 29 5 23-24-32-22 65-20 45-51-68-26 49-15 14-43-152 61 81-98 10 11 42-56 30 8 63-92 104-35 55 14 44-8 45 44 69-2 51-48 22-69 14 11 59-45 36-67 22 39 57-16 44-34 42 10 86-35 3-70 16-13 20 9 52-21 2-21 30-8 10-42 53-8 23-33 27-5 22-43 30 6 26-25 63-14 92-116 31-8 47 24 39-29 115 39 38 25 17-22 19 16 35-7 36 79 39 11-6 22 51 48 26-6 16 18 14-7-34-63 14-18 41 39 10 40 84-59-58-11 14-24-40-5 9-24-20-47 18-20 46 23 45-42-35-17 8-13 45 19h77l59 97-29 27 59 46z"/>
					<path id="summer" d="m-13847-14771 14 9 6 35-9 14-17-14-24-5 2 23-27-16 5-32z"/>
					<path id="unnamed5" d="m-14877-14879 46-31 23 120-24 11-18-34-25 13z"/>
				</g>
				<g id="i-CA-NU">
					<path id="adams" d="m7344-13741 55-70 41 22-4 66-8 31 18 34 13-11-12-35 12-8 12-87 40 48 27 8 14 29-48 26-10 29 55 83-19 28-32-35-30 7-36-20-12-49-61-61z"/>
					<path id="admiralty1" d="m-2353-10450 35-10 28 24-6 24 40 47-21 28-18-18-23 34 10 11-14 22-43-5 5 30-8 6-9-16 1-45-13-7-4-19 33 11 8-44-16-32-19 10-28-51 20-47 26-3 11 15-4 23z"/>
					<path id="air_force" d="m8614-10108 81 134-8 94-124 33-82 10-130 69-130-13-101-97-45-72-11-88 115-27 1-132 74 28 4 86 65-28 141 41 20-33 52-24z"/>
					<path id="akimiski" d="m8587 6783-71-36 69-176 38-28 44 6 76-59 211-66 52 16 74-16 115 65 166 151 62 113 35 41 18 53-12 77-68-33-164-6-188-56-168 2-151-34z"/>
					<path id="akpatok" d="m13950-3644 36 39 51 26 28-4 25 31 6 47-1 43-11 5 2 44-6 14 12 21 1 24-21-1-26 13-18 47-18 11 2 31-51 65-26 13-27-7-32-45-45-360 50-42 54-1z"/>
					<path id="alexander" d="m-2006-17487 93-29 39 56-13 22-123 53-27 80-18 21-90 24-102-14-29-13 1-24 37-23-19-10 49-22 32-73 147-52z"/>
					<path id="allen" d="m13918-7160 16-50 50 15 100 120-8 14-53-20z"/>
					<path id="amund_ringnes" d="m-720-20547 32-36 122 19 121 78 25 50 81 18 39 73 28-19 14 20-30 93 72 65 62-45 33 12 117 97 46 69-5 21-97 108-40 19 11 20 33-7 82 132-14 84-39 95-61-27-114 78-111 44-24-17-14-37-40 41-23-14 11 35 23-11 16 16-49 8-19 47-23 10-51-27 6-75 25-37-68-49-39-58-46-19-21-25 28-20-11-40 53 8 115 19 24-7-12-42 17-18-67-46-40-43-55 11-39-27-39 1-2-29 40 9-21-58-39-19-6-20 15-2-24-97-46-49-8-69 20-26 48 7 21-13-20-54-31-24-17-51 11-69-18-11 17-30-13-24z"/>
					<path id="anderson" d="m10927 2405-1-32 23 33-3 28-34 36-11-7z"/>
					<path id="angijak" d="m13870-9783-15-46 51-29 33-5-6 37 52-29-3 44 23-29 21 43-21 10 14 29-8 18-45-56 14 44-6 33-23-45-55 21v-33z"/>
					<path id="astronomical_society" d="m1184-10686 14-22 38-14 27 29-74 37zm71 82-28-24 70-51 40 51-43 19zm57 44-55-35 80-17 1 13z"/>
					<path id="aulitivik" d="m9890-12632 18-23 36 19 56 9 2 20-25 46 12 95-34 11-82-17-26 10-20-6 28-28 11-84 30-22 33 12 11-21z"/>
					<path id="axel_heiberg" d="m2020-21403 68 75 41 87-59 54-15 56-213 155-26 34-2 75-34 39-41-77-4-35-15-3-1 37 29 117-9 56-54 81-31 171-22 24-66-63-25-71-14-104 3-67-17-50 38-55-9-21 17-66-15-4-19 89-56 24 10 201 47 152-18 25h37l46 82-25 120-33 32-24-11-83-155-44 7 21 104 42 61 15 65-19 91-2 139-13 52-15 10-44-35-60-93-28-78-121-180-39-119-25 11 6 75 31 109 41 32 109 275-28 24-38-85-45 8-39-99-52-33-68 29-44-9 56 47 52-3-11 29 22 74-11 50-28 10-122 1-51-32-22 11-86-24-46-53-38 46-20-18-19-63-27 3-10-21 42-25-20-15-37 28-21-6-27-30-2-26-74-64-14-71 35-33 44 27 49-41 84-8 32-25 48 21-1-51-35 15-20-20-67 4-81-15-57-44-24 33-77 31-48-80 29-26h-46l-62-112 54-17 66 46 58 4-4-29-73-57-53-17-52 14-104-181 81-62 61-31 43-68-12-14 26-33 44-2 72 34 7-37 153 12 193-72 91-21 49-7 27-31-35-2-39 20-31-9-67 3-39 27-196 32-87-51 33-63 121 7 52-37 100-26 14-56-141 72-63-1-97-25-5-21 78-60-4-17-39-11-24 3-66 60-40-60-2-25-14-1v39l37 71-86 60 1-31 23-87-17-14-34 120-35-16 7 64-48 49-44 9-21-61 2-37 32-34-79-66-15 21 13 47-24 10 1 25-41 6-13 31-62 45-35-25 12-75-22-2-5-55-25 46-70-52 8-148 20-13 48 2 175-91 41-43-10-53 17-50-46 24-15 48-49 42-27-7-52 30-79 9-62-22-22-68-37-38-3-57-20-31-33-11-30-75 54-27 6 36 15-24 27 10-6-31-79-37-10-65 34-19-29-10-21-56 12-69 78 17 60 77 74 35 89 9 61-21 90 84 5-10-88-111 25-44 50-50 63-5 2-14-65-8-29-45-31 83-76 38-47 9-75-65 33-27 53-4 18-29-4-22-16 27-51 3 1-32-27 36-44 25-92-97-21 8 15-55-33-19 8-39 77 45-14-48 45-18 63 19 50 47-8-36 9-20-56-46-11-36-51-44 37-23-25-84 165-9 29-18 37 48 44 12 97-2 26 43 21-4-16-50-35-33-93-8-17-93 50-22 30 11 29-19-17-19-22 14-12-19-58 12-75-58 35-46-89 35-35-37 32-55 45-11v-15l-66-4 1-25 22-19 15-44 3-50 69-67 65 33 16 29-14 23 21 31 15-55 24 6 17-30 32 12 1-21-44-20-45-46 20-23 25 29 54-17 65 47-12-19 73-15-12-20 19-10-17-22 24-26-50-61-108 17-54-14-30-46 4-56 26-22-14-27 47-25 84 60 13-11-20-67 81 25 81 73 99 62 60 93-8 27 20 60-22-8 1 23 28 14 43 104 11 46 36 47 5 43 25 18 1 53 45 53 36 6 35 88-32 92 50-20 5 17 66 8 78 81 9-10-33-54 57-25 58 17 53 81-40 67 38 5 2 73-24 31 27 95 80 92 59 31-6-56 73 64 5-5-47-55-27-49 21-20-32-4-51-83 13-48-15-28 5-55 39-55 144 22 40 206v63l-42 37-42 15 25 75 46-27 46 13 43-20 40 108 30 39-43 35-4 51-38 50 51-43 19-42 27-23 7 44-9 129 8 41-7 108-50 85 11 54 27 9 14-71 41-48 18 12 31-79 73 5 53 43 17 36 16 113-24 9 14 37 20-9 18-78-7-76 7-60 61 38 6 45z"/>
					<path id="baffin" d="m3747-11205-31 14-153-24-29 17-78 1-79 31 11 44 38-38 35-15 104 36 55 49-108-14-82 28-52-23-38-33-23 3-87-39-130-131 2-59-31-68 17-54 67-67 9-23-46-41 27 48-85 83-20 40 12 69-28-15-50 20-15-38 54-33-23-15-15 28-41-27 26-14-35 3-5-30 21-13-29-15-37 24-12 80 27-5 43 11 4 89-194-22h-94l-12 35 64 1-42 63-63 4-130-79 18-30 121 52-18-41-206-97-51-6-71-42-95-131v-41l-131-137-45-111 68-37v-56l-54-19-71-80 98 6 41 49 75-31 100-13 70 9 41 25 12 45 40 21 121-8 32-21 39-8 27 5 87-13 18-59 87 8 17-9-18-9-50-9-37 1-178-101-44-60 4-76-54 14-29 58-59-21-499-37-90-54-42-112 10-57-15-58-24-26 20-11-10-33 54-105v-41l-34-28-59-106-26-34 26-18 17-92-23-38 90-86 29 22 21-63-31-16-42 32-56-98-13-108 34-45-26-45 34-28 3-42 4-131 30-31 16 19 18-19-29-40 14-119 34 5 14 15 15-11 10 15 11-2-8-25 16-12-29-12-15 4-14-37 28-74-17-66-7-44 34-27-28-18 54-191 62-2 4-13-50-8-3-23 22-46 29-16 73 24 8-10-68-21-14-27 48-98 107-175 75-96 134-123 241-139 169-34 92-1 78 9 112-11 76 23 51 44-17 82-144 185-73 119-82 198-38 250-81 207 24 215 97 105 90 146-42 155 49 284 133 225 265 263 197 76 7 77 31 9 15 70-25 10-82-24-13 38-29 33-40-7-16 27 42 8-10 27-26 1-17 31-81-25-146 138 10 28-47 36-157 64-7 20 23 8 87-12 91-48 139-161 98-31-2-10 48-19 45 20 35-8 1-47 53-2 38 16 12 49 3 63-49-24-13 12 40 19-22 37 18-5 20 30-1 89 55-13 9-79-40-63-15-146 35-40-41-32-14-68-1-95 14-39 37-3 16-20-24-94-53-35 9-96-36-7-46 16 17 43-171-22-92-94-25-6 14-17 29 4 7-20-58-92-89-54-81-17-7-38 17-14 53 7 38-50 56-12 11-30-26-29 54-33-49-31 3-30-21-36 12-30 84-13 83 3 41 20 71 78 65 22 106 89 37 88-10-98-76-50-24-52-96-40-40-61-73-39 41-85 36-9 57 2 22-44-24 33-28-9-95 21-1-40 32-15-13-57-67 88 5 24-82-7-96-58-48-100 41-17 2-22-63-8-26-51-16-250-22-31 33-75 80-17 150 69 87 11 75 24 57 44 52 1 53 19-45-28-56-6-56-53-150-59-86-53-14-36h-15l-8-5-8 6 9 22-80-6-36 10-13-7 20-123 21-5 13 37 40 48 38 3-44-77 2-28 49 5 82 44 202 16 96-15 73 40 12-13-56-32-305-51-68-42-90-35-1-100 38-46 64-53 25 37 11 28 28 36 29 3 48 45 23 7 4-11-65-68-30-16-37-79 130-110 126 28 29 19-1 38 46 81 13-7-34-79 4-40-27-36-111-44 113-119 102-94 56-2 40-95 159-15 115-39 68-4 29-16 62 39 1 33 68 57 43 72 50 148 6 107 8 26 200 59 53 71-14 110 16 73 34 28 31 65 85 29 25 55-76 136 28 53-20 5-44 63-43 87-38 131-15 24 7 38-45 75 38-17 34-113 39-76 1-50 39-15 39-81 23-3 24 55 10 83-38 37-36 187-29 8 153 78 14 27-33 10-43-32-65 31-32 59 72-27 33 30 3 97-30 39-1 23 34-14 21-47-3-60 61-36 57-89-89-113 91-32-42-71 12-42 63 67 36 44 70 28 51 7 3-16-53-8-44-25-71-90-45-35 20-71 52-55-11-79 25-9 35 30-16 52 77 69v56l-24 37-7 40 28 16-9-32 30-43 24-1 17 16 8 21 4 27 13 16 8-3-13-46-19-36-29-14 22-14-14-40 29-31-8-49 19-2 150 100-5 40 24 43 10 132-18 96-19 28 14 19 23-3 9-23 146 27 44 45 17 3 6-19-33-20-13-35-103-25-27-34 2-68-29-107 152 60 69 111 2 37 99 99 113 41 4-9-97-44-98-98 12-23 43-23 4 26 20 7 71 75-1 13 70 32 22 52 10-15-11-49 9-9-4-7h-38l-40-20-44-53-50-32v-24l-14-11-47 23-40-37-44-96-94-25-78-34-18-23 23-17 9-42-39-40 62-63 35 10 15 87 12 32 53 60 5-12-54-87-4-74 147 21 79 19 70 33-3 40 27 23-3 39 8 2 4-48-21-22 9-24 51-10 34-20 113 31 5-9-108-38-24 3-58 26-138-69-105-19-91-31-64-46-18-77 19-91 111-166 54-12 51-81 209-42 62 8 45 38 8 39 180 1 12 56 38 53-20 20 17 6 17-22-32-68 18-52 52-19 89 6 23 16 122 16 2 37 157 192-18 75-40 99-84-15-71 32-53 52-37 64 1 83-29 58-8 72-16 35 17 7 12-38 4-47 32-63 12-47-10-40 67-102 37-26 44-11 104 18 3 24-13 24-72 50-11 47 22 72-16 45 16 34-13 54 3 59-29 42-43 17 2 12 31-17h23l21-19 11-39-3-36 17-74-14-34 16-45-24-62 9-37 82-46 14-48-3-66 27-27h94l144-29 35 15 62 88-11 63 21 21 1 68-58 56-16-4-15-19-13 15 16 19-25 23-12 55-38 14-13 47-62-6-74 55 4 16 75-49 65 16-5 27-62 75 5 28-39 51-9 26 10 6 62-71-1-23 43-48 28-32-4-27 12-31 28-34 33 32-7 89-35 56-46 17-18 44 11 9 16-29 54-19 18 19-4 37-16 16 11 11 20-11 47 15 19 48-15 20-12 37-5 72-15 19-3 46-17 21 13 15 19-22 25-74 16-96 21-38-17-53-19-22-43-21 6-24-25-33 43-87v-33l-12-28 53-55-2-48 56-45 19 102-24 17 6 53 49 51h19l-56-49-6-37 30-50-9-65 10-52 68-41 21 6 10 50h10l-5-67 9-3 14 56-38 82 10 40-20 13 2 70-8 14 14 73 19 15-49 18-40 53-3 17 9 5 40-56 29-10 8 63 27 54-36 30 29-1 5 71-18 47 12 11 20-54v-50l8-3 5-63-18-37-15-50 23-40-22-26-1-71 16-64 18-15 55 37-7 33 18 89 44 46-12 26 5 10 12-12 16-30-18-41 10-27 16 6 30 49-33 23 12 34-20 53v66l37 162-41 38 10 22 7-15 42-37 1-39-20-46-10-74 25-145 23-13 115 32 11 25-53 43-4 27 24 30 13 39-1 85-29 33-2 25 37 36 6-5-32-42 23-22 17-40-6-89-25-58 58-43-14-87-46-90 70-41-29-48-35-26 51-40-3-82-19-51 10-21 160 28 78-11 48 17 97 12 54 31 18 30 58 23 107 108-34 103-10 71 5 65-29 7-117-11-63 61-2 37 18 29-1 62-32 15-5 44 15 44-54 66-73 56 32-8 23-18 41-23 52-63 48 25-16 105 8 22-3 51-29 43-40 32 44 16 7-25 46-63 3-53-7-33 15-41 51-31 121-139 64-53 53 19 5-18-50-19-16-124 61-71 15-65 22-26 43 18 45 30 33 59 45 54-20 100-11 23 17 70-33 87-48 57 15 63-13 32-98 6-51 21 35 61-32 78 7 22 1 35-37 18-25 35 15 5 16-25 42-14 18 10 11 111 10 3 13-16 1-47-35-136 15-27 7-58-13-40 125 1 45 223v40l30 12 2 55-11 30 10 31-9 59 25-5-21 55 7 34-7 16 15 22 1-74 22-69-17-76 5-20-7-62-16-31 10-10-26-155-24-99-5-86 45-40 108-208 65-70 53-87 46 3-4 79-17 94-41 98-24 26-25 2-30 35 21 51 40 30 6 28-22 37 14 3 33-65-68-75 100-51 54-100 13-43 47 18-13-70 42-73 37 10 23-30 26 1 50 43 189 23 123 8 40 21 18 30-1 106-11 26 19 31-12 13-49-27-9-52-13-5-16 34 4 30 42 69-8 27-48 58-37 12-31 32-85 70-49 65-47 90-8 3-3 14 13 21-11 58-45 22-16 28-7 39 4 10 25-10 7-52 56-3 47 35 2 21-60 5-46 51-15 40 11 13-10 43-19 12 1 30-16 7-8 18 28-1 17-19 30-90 8-45 43-35 37-1 25-22-2-42-48-49-2-42 23-69 78-74 52-37 54 5 11-27-51-9 3-10 49 8 48-37 51-20 36 46-21 71 18 25-14 76-65 66-29 82-5 107-17 34-48-6-67 25-18 76 15 35-9 77 18 69 16-6-12-54 10-14 1-73-9-33 13-48 36-22 60 14 37-29 11-94 33-90 41-41 45-18h33l13-20-21-34 24-58-25-23 11-10 11 5 22-15-2-20 26-2 32-64-1-30-18-9-24 22-36-26-10-60 30-92-12-17 25-33 16 20 109 10 21 22 81 20 145 104 25 46 17-10 24 10 150 222-90 59-154-4-100 63-15 65-1 101-60 32-79 9-168 216-90 3-66 19-43 32-31 61 46-13 17-42 29-26 34-9 61 4 85-22 128-157 76-18 256 27 36-24 15-32 204-68 217 60 81 70 19 57-7 59-34 3-71-8-49 11-25 25 16 32-58-22-27 14-11 33-60 11-6 13-257-54-51 50-233 22-32 19-44 117 16 8 15-58 23-15 9-31 30-20 36 2 89-2 103-11 41-37 31 2 47 27-9 29-169 35-35 22-31 33-77 19 66 5 70-46 46-13-42 66 3 16-77 69-24 7-25 30 12 9 19-27 27-2 19 81 12 35-12 12 8 12 21-21-24-107 29-42 34-24 55-100 165 3 164 40-94 69 10 31-45 9-90-3-17 25-35 28 20 15 36-40 21-3 1 22 102-19 14 47 36-8 20 35-180 15-22 31 84-16 82 9 105-14-1 13 36-3-33 25-80 6-140 15-78 21-2 19 44 4 22 17-23 11-17-3 8 20-64-5-6 14-91 16-35-13-85 2-22 10 10 14 16-8 52 3-3 14-59 14-16 10 4 23 175-47-1 42 20 9 11-45 71-9 16 11 38-27 151-19 29 14 31-10-6 16-33 15 21 9 18-7 9 23-27 2-22-10-23 8-23 45-103 13-38 19-21 28 1 54 38-25-3-31 33-22 49-6 11 11-1 17-43 32-40 21 1 9 28-3 88-42-6-32 79-24 16 15 21-18 21 42 30-29 12 14v-30l9-10 14 6 48 115-6 30 12 6 5-34-5-29-37-89 47-12 10-48 38 14 16-22 25 9 3 32-35 16 7 24 35 51 18 51 11-35-39-77 54-33 12 16 1 1 1 1 10-4-10-18 7-17 20 5 20 33 8-6-8-25 6-2 34 41-42 24-2 20 70-25 18-29-42-45 16-13 62 20 18-28 17-7 7-28 34 7 7 8 27-7 3 12-48 27 12 21h-20l-30 7 13 48-20 32-55-6-64 12-38 23-10 33-32 19-13 30-26 5-25 25-20 54 15 18 2 17 15-6-10-29 19-44 60-19 7 21 16 21-35 47 5 7 40-38 3-18-16-21 28-97 35 2 12-23 111-3-66 63-15 74 24 52 22-2-19-44 14-53 45-47 22-7 23 11 47 3 31-7 11 98-16 12 4 18 23-10 6 11-23 78 26 57-19 21 6 13 26-26 2-16-17-46 31-103 22-24 10 33 25 49 12 59 1 25 18 46 6 3-11-47 5-29-10-64-36-85 30-23 87-17 5 38-22 26-12-6-16 15 3 8 42-5 31-47 71 60-30 29-8 39 29 122-25 22h-66l-35 9 4 13 26-5 59 5-18 35 10 7 20-32 42-32 31 59 13-7-55-135 11-37-14-17 5-21 17-28 23-2 14-50 26-35 8 26-8 56 80 68v59l57 141 25 77 17 4-17-80-35-97-22-34v-27l30-50 1-67-39-26 14-66 70-36 21 13 29 77 8 113-10 22 27 27 81 25 18 10 64 82 15-11-80-91-100-40 10-13-5-98-17-50 59-56 11-64-25-12 22-15-6-36 50-26 118 19-30 75-65 27 2 11 36-11v99l-28-4 14 68 14 3 4-23-7-19 24-14 19 28-3 42-24 26-5 28 25 84 22 13 5-7-15-16-14-75 31-40 8-60 38-22 15 17 30 63-11 17 6 12 21-31-38-89-11-41 69-40 65 21 4 19-22 9-4 13 25-6 25-28 20 6 3 17-4 37-25 15-37 41 7 6 41-40 39-20 3-38 13-8 25 9 32 28 6 54-14 12 8 6 28-12 21-27h25l21 69 27 9-9 58-21 17 2 22-29 16-63 9-1 5 75-4 26-16 6-18 48-33h21l40 32 39 63-15 45-219 84-88 3-3 21 63 3 53-22 35 4 54-20 34-24 4 16-26 55-93 47-60 89 20 8 59-79 70-31 28-19 38-65 63-40 16-2 4 23 11 17-10 30-62 27-41 67-70 63-22 66 34 88 10 52 34 9-18-36-4-45-20-47-3-39 16-26 112-121 65-32 17-52-2-32 24-17 37 23 1-24 49-41 49-17 34 118-7 44-36 57-15 60 59 97 5-4-45-98 16-56 38-44 9-112-30-39-10-99 6-40 38 4 1 26-16 35 17-1 23-57-34-21-9-15 39-23 53 19 47 57 9 63-68 79-3 41 105 102-48 66-43 43-5 42 26 40-42 62-44 18 22 9 60-32 31-40-5-42-19-18-3-32 18-8 64 91 20 57 8 40 27-11-26-58-4-51-56-72 51-23 5-69 41-9 20-21-7-25 40-20 41 78 44 47 31 97 31 56v27l14 4 5-29-35-84 13-38-47-66 3-16-52-65 15-26 31-7 14-26 104 92 27 2 22 29 32 13 23 28 8-8-20-38-30-13-12-17-31-10-43-49 23 4-33-31 49-59-6-22-32-22-16-37 87-67 26-2 9 17-17 40 27 36 12 38-17 14 16 7 17-13-2-54 15-27 28-17 1 35 16 11 12-33 30-2 6 48-27 3-53 39-2 22 13-2 4-15 69-33 9 10 9-20 41-19 20 4 2 3-11 54-30 16-6 12 7 7 9-12 50-14 1-18 33-11 45 19 8 23 109 34 38 71-30 78 14 10-35 27-31 4-46-39-38-17-32-6-39 22-52-9-20 82 21 20 4-46 15-25 71-8 66 29 26 24 58 13 23 27-53 74-41 9-13 15 2 19-28 26 32-5 22-34 65-26 38-36 58 24-1 49-34 2-2 34-49 15-4 42-18 34-97-7 1 19-31 25-58-66-4-26-28 8-3 14-134 46 32 22-50 6 1 16 51-9 16-27 20-11 7 21 104 42-71 143-26 25-18-23-19 10-35-42v-14l-52-18-6 14 48 25 33 48 31-1 23 21 32-14 34-61 33 35 45-31 11 19 104-30-8 30 14 28 63 23 42-17 14 17-10 21-17-16-8 18 5 20-24 19-36-4-26 67-41-14-23 11-29-8-24 6-16 21-44 2-18 22-53-14-26-31-43-31-3 14 32 27 32 42 58 17 83-39h77l34 23-2 21-19 5 25 21 5-15 17-3 8 36 70 37-79 65-16-12-65 26-93-39-8 10 52 38 70 16 30-10 34 21 12 43-86-10-10 11-39 1 49 35 54-18 49 25 22 74-6 21-12-38-26 9 9 34-43 2-15-18-22 3-29-52-7 1-17-31-13 7 43 74 18 67-18 1-36-27-73 5 18 30-30-5-13-30-62-31-98-105-37-21-31-32-22 1 28 55 88 64 49 57-4 13 50 31-50 8-55 34-1 13-32 12-17-6-8 11 24 13 47-25 36 2 57-23 39 31-8 8 23 49-39 35-44-21-9-19-24-9-1 12 12 7 13 31-39-2 22 18h47l36 36 9-24 86 9 18 15-35-8-34 37-63-15-11 13-37 8 112 22 41-3-51 42 46-18-15 26 68 9 19 31-36 15 5 26 43-25 18 22-50 26 20 12 51-23 19 33-13 7-21-9-4 21-24 13-26-3 6 13 38-1-20 33 36-12-4 17 43-41 9 9-29 66 41 19 10-6 11 10-51 24 46 1-1 22-40 4 39 27-4 16-23-12-27-33-19-7 96 154-61 9-26-42 12-24-21-38-28 80-56-14 13-52 33-35-35 6-42 47-15-25 9-15-28 4-11-30 11-19-16-72-21 6 13 35-19 27 14 47-37 1-38-23 34 75 3 23-17 4-60-44-7 25-14-9 1-38-19-22 42-51-62 13-2 74-21-25h-19l-48-62 12-30-28-52-2-50 10-20-3-21-27 14 5 62-15 7-1 55 60 103 1 58 11 25v39l-34-42-13 21-20-17 3-35-14-9-20 45-13-24 4-24-22 2-8-15 31-49-34 25-10-18 24-10-2-11-32 14-12 59-29-18-29 6-7-16 13-19-28 4-1-11 21-34 56-34-8-8-22 18-29 1-38 28 81-113 1-32 69-34-16-57-15 10 18 37-32 15 1-19-53 40 1 20-114 82 16 35-31 18-66-44-34-57 68-68 10-97-21-51 43-22-52 9-8 17 11 45-14 84-55 40-42-7 10-33-13-7-18 43 3 28-29-12 3-37-20-38 63-33 10-27-6-12 21-39v-22l49-22 21-27-11-9-73 52-25 53 4 26-134 56-19-55v-64l-14-4-9 22 5 39-13 6-21-99-1-105 124-169 62 10 4-15-55-25 5-82-42-88-3-43 29-67 4-43 29-19 5-34 20-14-51 1-3 33-26 18-41 120-1 56 46 83-131 178-12 40-153 96-30 45-49-13-38-72 9-61 61-118-12-23 26-67-24-31-6-42-15 7 8-45-19-38-12 4 18 46-12 21 30 87-15 77-78 128-70 7-50-28 4-17-50-13 10-20-90-18-14 13 62 28-27 46-67-31-6-42 23-9-40-50-96 17-14-52-67-17-2-42-29-32-21 8 28-62-8-17-33 29-69-18-81-13-23 14 97 8 75 28-54 81 10 43-54 4-10-27-64-15-30-25-51 62-80 21-31 21 51-4 68-18 56-34 71 31 1 21 70 11 32 71-17 10-59-18-19 31 81 3 49 33-47 63-43-14-12 30-82-87-160-19-63-26-22 13 66 37 92 77 53 52-8 41 187 60h75l30 51 39-13 23 22-32 49 64 63-93 22-12 54-112 12 18 27-30 32-86-12-42-58-37 18-34-41-30 8 4 36 57 3-18 27-76-36-10 20 84 36-55 16 15 48 66-60 22 85 53 4-11 41 54 2 38-75 24-1 18 38-10 45-24 1-1 64 39-15 43 57-16 76 32 4 24-100 106-100 83 1 47 88-4 20-34 4-3 39 33-13 2 24-55 6 5 15 75 8 61-46 48-6 24 115-68 16 20 26 52-4 18 63 23-34 23 37-33 20 32 30 70-49 42 127 33 16-15-58 3-44 24-41 16 14 6 85 19 49 59 26 8 52 29 13 38 93 51 58 17-23-54-63-18-97-73-85 81-10 18 55 208 8 21 97-46 20 10 26 40-18 34 56 25-5-22-60-13-116 13-2 29 55 10 60 29 34 11-9-30-38 5-37 19 3 8 28 54 56 51 18v-10l-81-72 3-32-58-29-39-67v-22l42-9 75 8 46 34-16 53 38 56 9 1-24-84 14-15 59 42-3 38 31 44-29 78 46 104 30-32 90-35-4-44 22-19 18 38 40 31-27-62 11-28 15 2 5 59 31-51 20 1-27 35 4 12 43-39 35 73-32 14v30l-29 1-2 32 36-4 26 17 2 45-51 30-95 6-29 23 10 17 28-16 45-10 12 40 56-14 63 30-33 17-5 47 20 2 7-46 113 46-28 40 12 8 33-39 38 18-64 64 13 18 198-123 62 28-59 92-19 141 39 20 92-4 24-33 22 25 89 16 20 25 14 69 74 92 28 31 4 50-19 18-30-16-15 13 54 22 26-16 37 55-22 46 36-10 10 19-44 60-54-26-75-69-41-62-26-16-64-82-40-6-49-60-41-6-128-80-57-13 7 22 25 13 70 21 32 19 26 34 58 5 32 31-6 28-26 33 24 34 51 48-39 53 10 8 40-31 7 7-32 37 7 6 61-26 77 71 18 26 6 41-79-51-3 14 45 37-40 25 9 13 39-22 28 11-17 39 117-6 47 34 14 71 40 64 35-20 65 42-47 30 20 57-36 24-199-76 5 98 48 43 50 17 94 60 40 56-8 55-18 70-49 24-70-60-59-22-16-83 24-18-8-19-38 26-16-42 42-33-5-11-41 20-17-56-14-1-10-15-11 7 15 16 8 52-52 73-55-10-19-38-74-25 12-34-2-29-28-32-15 19 30 26-23 49 17 28 22 7 5 26-89-10-26-8 23-119-14-3-41 85-58-31-39-2-17-33-45-17-13 11 41 16 23 42 77 22 13 54-44 11-91-43-15 38-75-27-63-75-32-17 4-38-59-37-32-5-31-26 16-33-16-68 36-46-3-9-46 49 15 71-13 33 27 34 43 16 38 25-2 38 40 26 24 70-14 10 29 14 23 12 6 8-3 12-60-10-32-10-50-25-31-39 7-45-57-53-15 4 40 39 14 45-19 18-125-76 35-44-12-8-93 62-97-52-57-60-5 32-93-53-27-48-19-2-102-89-21 42-25-28-21-9-21-31-8 11 26 34 38 35 7 49 123 108 27 16 8 25-15 40-59-20-46-50-87-45-24 17-31-10-19-34-26-23-5 8 15 13 5 25-12-1-20-27-24 26-19-26-35 7-47-9-45-52h-59l16 23-100-9 27 31-83 22-27-14-24 16 116 88 60 65 48 18 47 31 79 23 14-32 25 24-25 14 91 48 139 105-18 8 17 11 41-3 11 34 9-3 14-33 71-7 21 10-17 40 18 10 19-38 27 2 21 17 61-45 32 24-54 37-15 53 47 34-14 14 9 12 17-10 5-18-29-29 3-29 11-23h25l18-23 50 20-62 71 37 24 5-42 15 5 33-48 141 55-50 36 18 20 46-45 43 20-33 42 17 13 6-21 33-19 37 14-9 28 63 11-9 63 11 4 13-30 44-21-25 61 11 9 21-38h33l14-28 43-7-19 37 18 16 32-44 94 49 77 48-5 72 17 11 40-35 50 37-37 65 92 44 5-10-36-24-18-37 63-39 106 93 25-5 13-44 70 30-16 55-15 3-16 24 27 25 37 73-57-28-18 19 39 12 37 41 89 59 22 46-46 4 12 18-102 60-122 12-53-13-45-26-57-11-156 33-57 9-43-20-40 45-31-42-40-27-47 40-44-29-63 59-30 2-31-27h-15l-3 20-39 10-9-15-19 8-3 23-44-13-23 26-20-10-47 32-23-7-111 17-8 17-43-3-57-25-67-17-1-18-35-18 8 38-13 4-29-16-14 26-125-41-11 14-69-48-21-28-7-33 5-29-13-51-7 5-1 16 9 28-16 30 17 14 7 33-56-33-14-62-30 13 47 62 2 21-75-75-10 9-42-20 31-43h23l-5-41-48 40-5-33 20-33 33-16 1-13-113 28 19 33-28 7-1-38-23 19-24-13-18 8-42-26-13 10 26 29 23 10 41 34-13 4-30-28-25 9 9 15-69-26-6-66-9-1 1 71 28 25-12 21-21-6-45 47-100-20-103-48-107 18-50 14-44-10 29-17-4-27-39 20-3 20-47-3-1-18 31 4 6-25-22-4-9-24 21-9-3-11-38 14 9 30-17 22-40 15-33-50 40-5 23-10-6-26 25-12-9-55 31-19-3-33-11 32-18 4-23-26 19-18-11-9-25 27 2 21 17 22 7 45-86 36 19 70-20-2-18-21-31-1-50 7-17-21 14-11-8-33-18 1 4 18-23 11-19-2-3-14-62 6-31-28-39-45-26 10-8-20 51-25-9-24-19 26-38 9-13-36 14-24-47-19 33-17-6-24-26-1 1 12-61 6-39-15-11 4 12 19-39 3-45-29 87-42 151-20 40-95 30-6 7-22-23-24-11 17-29-7 11-30 43 11 43-27-8-48-19-6 12-21-20-1-8 33 13 6 4 18-17 8-27-7 8-28-41-1 22 35-67 21-9-58-24-19v-38l-52 10 42 34-9 15-47-21-4-46h-17l-7 20-42-16 11-23-40-25-53 7 1 37 54-25 20 140-33 2-9-24 16-11-25-50-16-3 10 42-13 23-22 4-35-32-40 7 27 57-29 22-76-81 9-26-30-34 21-56 8 15-6 30 30 11-3-86-20-7-8 28-26-9-3 52-17 36 41 28-108 35 39-52-93-40-34-55 22-31-43-75-12 37 22 23-30 37-31-46-64 8-57-29 7-42-11-16 14-25-24-41-16 17-67-30 5-14-64-31 15-27-15-8-18 25-23 1-12-49-20 45 19 13 8 29-54 10-17-32-10-41 9-29-5-36-17-10 6 46-14 12-53-30 4-82 8-39 29-9 13-38-5-21 5-19 22-14-6-34-15-15-3 35-29 5 3-28-30-37-16 25 68 92-11 15-42 45-45 21 24 24 11 54-17 27 37 29 3 52-46 21-61-132 20-18-6-37-35-5-21-40 10-8 9 6 26-26 43-24 28 16 12-25-45-15 10-7-15-22-16 12 10 17-37 29-11-40-16-18-20 12 19 20 5 60-29 14-13 27-73-47 12 47 38 41 29-2-13-24 68 14 11 32-14 17 2 32-34 17-18-45-19-15-10 30-14 3-14-23-14 11 13 58 29 27-18 4 16 73-62 14-1-22-35-8 24-18-1-71 22-1-31-51-35-19-46-55 17-28 27 8 13-22-33-20-21-103-29-29-24 18 32 23 13 44-43 43 21 26 4 60-50-48-7-36-6 5-5 34-39-28-6 10 61 53-18 33-40-45-38 9-21-32-55-20-38-42 25-118-27-38 9-21-42 3 25 26 1 19-31-8-12 38 35 28 6 30-15 23 19 42-45-24 18-24-36-23 3 35-50-11 2 25 29-1 44 48 77 15 120 74-2 45-32 11 32 8-1 20-45-8 41 36 26-3 9 17-11 15 52 41-20 16-54 12-4-21-20 4 19 56-148-14-38-23-45-8-35 52-19-24-48-28-59-17-146-17-33-24-23-1 5 31 27 19-21 8 24 33 109 54-34 17-60-14 15 62 65 20-16 19-40-12 2 20-39-9-16 16-4-26-29-1 10 35-38 25-19-20-25 18 6 29-46 16-28-1-9 12 30 22 67-12-52 63-28-21-27 8 32 18-69 18 1 8-35 1-1-18-16-2 2 20-43 7 14-13-12-13-19 22 19 35 44 30 9 19-1 9-92 4 10-24-33-10-4 12-42-14-1 16-60-9-18-12-50 22-46 60-18-20 6-16-13-19-24 13-54-34 10-26-48 3-45-25 31 47-15 34-49-14-16-31-20 1-6 28-33-38 1-12h20l6-16-30-17-22 42-44-20 28-27-8-24-57-17v-29l-71-26 21-27-46-52-11-27 17-13-7-23-49 20-5-10 38-25-6-39 27-37-5-77-43-31-17-59 7-33 24-45 22-8-7-32 81-64 39-70 20-20 26 4 82-66 5-23-131-99 9-80 61 17 17-27-65-34-24-18-3-19 29-24 39-9 65 12 28 33 67-18-6-18 48-19 32 24 44-22 327 68 52-31-32-13 2-48 104 1 18-49 35 54 142-8 68-36-39-136 57 10 36-46 38 15 22-27-9-24 9-18 30 8 18 31-14 21 25 31 25-9 30 1 52-113-3-69 54-38-27-32 24-20 35-9 35 22 9-37 39-17 54 12 50 49 26-33 34 14v-1l-6-53-39-49-54-47-17-48-39-10-5-50-33-43-76-24-31 8-28-9-262-193-27-35-16-39 9-52 128-190 50-111 16-57 50-66 35-83-10-62 17-57 74-100 68 3-2-27-46-11-17-44-8-85 13-101-13-72 45-88 88-40 24-37 1-51-23-100 23-36-41 5-60-23 6-28-85-122-28-7-8-61-52-78-22 13-60-51 13-73-37-38-43-17-42-56-17 52-76-85 10-31-30-19 11-40-65-80-59-127-19 6 15 36-83-5-4-43-33-5-10 24 14 16-36 11-28-17-44 11-13 45-41-53-85-20v-26l-62-35 18-31-9-72 26-6 20-30-14-26-42-11 23-21 7-43-38 4 18-44-36-20-54-10-28 19-13-19-79 17 182 140 3 46-20 30-28-5 11-27-49 21-13 19-84-10-82-55-5-36-109-60-9-33-79-17 19-59 42-41-31-59-104 76-19-5 80-59h-22l-69 47-4 36-20 14-89-46-70-58-23 53 45 34-17 63-42 54-77 64-19 71-43 41-30 52-36 31-42 22h-39l-32-32-5-49 24-67 3-62-15-16-30 17-39-61-2-100 79-52 101-5 15 20 34 1 64-115 61-11-13-87-30-74-80-57-66-9-26-29-116-36-64 39-20-38-117-67-11-23v-41l24-18 6-58 16-9 68 6 32 19 4 39 13 28v17l10-1-2-18-20-71-14-13-11-34-68 12-6-31-13 19-23 5-25-8-24 36 49-13-1 52-27 24-7 64-69-7 1-51-32 48-58-5-46-19 18-55 27 4 2-37 49-14-7 42 30-24v-73l-38 17-21-53 25-6 23-17-22-25 1 18-37 21-52 14 13-49-25 4-10 37-72 6 10-53 37-27 6-20 40-30-6-18-51 33-9 37-13 14-20 8-1 12-34 36-26-8-4 40 21 53-25 53-27-22-85-239-14-111-21-37 6-34-77-76-6 21-20-3 1-21-11-2-44 70-35-19-5 59-48-31-22 43-58-82-37-23 25-36 1-20-29-6-28 23 19 17-5 15-35-18-51-84-25-2-31-12-9 9 29 25 2 20-58-50-8 17-43-44 22-27-28-11 52-85 27-5 9 29 40 13-70-82-19 22-57-60-34 78 18 10 40-31-3 55-17 87 16 47 3 46h-67l-21-51-22 1 20 35-3 32-32-17-25 49 71 44 12-27 47 22 22 28 49 2-4-43 25-7 33 18 109 141 25 95 30 13 31 92-26 104-129 32-99 16-64 58-56-13-109-132-42 36-51-11-25 45-51-12-57-38-95 25-11-24-44 22-79-17-83 16-138-15 30 56 59 5 63 47 26-40 76 51 25 48 76 50 99 95-16 38-48 30-1-20-74-36-27-42-60-17-9-28-37-4-30-40-63-6 13-30-65 14-96-64-22-31-174-69-47-4-50-31-76-21-72-46 106 85 59 9 229 100 87 79 74 18-9 38-35 33 17 34-41 22-28-35-24 61 3 47-61 4-21-25 11-34-39-12-4 28-93-26 1-16-44-28-6 20-145-81-190 98-379 15-63-19z"/>
					<path id="baillie_hamilton" d="m80-17351 54-45 25 50-4 46 42 125-3 36-99 10-47-51 7-105-17-15 5-53z"/>
					<path id="barry" d="m-5389-8627-7-76 38-150 55 26v123l-23 5-1-13-37 9 6 37-23 39zm69-29 11 22-12 76-25 40-21 5 19 58-19 3-18-62 1-88 48-15-3-24zm-216-29v-98l52 43 14-28 21 16-26 87-24-9-11 25z"/>
					<path id="bathurst" d="m-1886-17756-2-35 31-3-6-43-27-3 43-29-9-26 10-21 14 11 14-1-21-40 44-57 43-4 63 21 49 34 15 56 36 36-24 109 32-1 28 24 65 106-31 47 68-24 22-2-69 35 56 15 25 22 32 108 22 22-22 22 46 1 11 46 23-33 34 4 32-42 40-8 1-9-79 9-37 17-47-113-5-82-28-25 35-27 70 15 39 27 77-31-36 1-42 18-68-79-48 12-72-32-14-52 10-21 39-7 78 22 53-5-40-22-40-84-138-10-66-147 116-91 96-58 96 47 21-21 57 11 4 43 56 106 38-6-29 27-3 48 37 53 6-17-13-59 49-19-4 41 31-19-46-90-6-49 20-31 117-5 17-16-84-26-12-18 28-17 73 7 23 26-6 49 65 36-27 15-25-27-6 26 44 38 15-19 11 33 73 15 32 32 3 88-19 12-23 96 21 8-5 40 59 82-1 75-32 60-20 137 21 91-31 83-76 53-5 11 49 8 43 27 60 18-16 110 2 157 33 59-12 15-48-55-2-78-28-18-27-56-32 41 23 70-34 5 1-53-25 1-7 56 41 31-5 25-62-11 2 27 49 15-3 27-34 3-14-21-20 93 21-8-1-27 39-10-37 51 28 23 7-54 8 48 79 126-19 46-67 6-24-52-28-20v-22l-29 8 35 74 12-7 10 68-10 40-104-6-44 27-29-12-25 20-43-10-21-24 3-42-24 17 8 42-129 3-2-50 44-82-8-17-28 63-12-7-18 60 14 20 2 13-20-9-20 23-160-25-73-51 2-159-39-35 41-31 134 13 1-13-82-26-12 12-25-22 57-39 2-15-96 15-68-72 35-24 58 21 11-25-33-40-50-18 212-10-3-9-86-19 120-16 8 25 55-32-107-3-60-12 2-16h81l47-12-65-4 3-13 118-51-66-12 63-76-367 65-113 24-16-34-184 46-3-12-88 4-40 25-2 13-36 3 10-43-29-17 12-37-31-33 2-30 27-1 9 25 21-25 2-40 42-10-17-21 71-20 53 36 16-12-39-32 46-42-74 1 10-61 56-44 91-22 59 92 38 14v71l33 6 108-45-4-13-35 11-23 20-57 5 13-52-16-42-41-2-11-81 76-56-2-19-84 24-39-53-14-107 49-65 91-41-6-14-15 7z"/>
					<path id="belanger" d="m10927 2589 4-24 50 46-41 48 4-35z"/>
					<path id="berens" d="m-7725-9770-2-12 77 8-8 14-19 5zm111 17 1-5 115 19-2 7-38 1zm-116 60-13-30 38 4 5 17 27 19 74 22v4z"/>
					<path id="bibby" d="m892-2028-11-50 116-21 31 87-59 16-29-44z"/>
					<path id="big" d="m11675-5327 154 13 102 32-31 7 91 38 77 64-14 38-65 54-166 32-21-39-27 3-68-106-42-18 69-36-120-9-33-18-65 9-40-7-15-26 47-15 156 1z"/>
					<path id="bjarnason" d="m-20-22702 29 28 2 54-45 19-86-52-27 7-59-26 36-29z"/>
					<path id="bradford" d="m-1784-17002 69 10-31 26-40 3-11-19z"/>
					<path id="bray" d="m6929-11172 7 78-58 135 29 51-71 65-71-11-67-98-7-96-36-71 84-68 68 37 85-50z"/>
					<path id="brevoort" d="m14148-7449 39 26 19 60 74 58 44 48-22 14 31 17 21 18 11-13 20 14-7 12 52 10 15 12-10 12 33 8 2 15-24 1-28-22-17 9 21 11-2 8-53-13-85-44-75-112-66-36-26-62 32-25-12-14z"/>
					<path id="broughton" d="m12303-11325 13-7 37 38 72 21 23 19 4 20-48 40-48 26-34-46-4-32 10-14z"/>
					<path id="broughton1" d="m10509 1278 53 34 47 101-16 7-94-137z"/>
					<path id="buckingham" d="m952-18833 56-1 53 46-3 42-33 43-38-5-69-70v-26z"/>
					<path id="byam_martin" d="m-2578-16978 50 13 72 89-8 29 16 61-11 63 23 6 12 69-92 102-112 32-56-22-121-118 14-44 35-29 35-86-15-6 96-137z"/>
					<path id="bylot" d="m4343-15386-24-20 103-43 65 7 78 52 3-56 153 43 25 28 170-45-2-30 239-72 110 45 140 17 30 26h47l33 57 55 50-3 30 69 36 50-24 14 16-15 24 77 59 7 30-12 23 47 43 98 14-15 28 42 65-19 25 24 32 73-12 26 80-49 62-62 30-68-4-189 36-64-17-250 53-80 52-165 176-53 30-84 7-164-86-100-181-11-112-47-109-23 20-163-5-48-51-31-152 21-44-34-36-24-63 21-71z"/>
					<path id="cameron" d="m-2390-18333 57 1 43 31-18 71 17 11 19-48 71 85-21 29 50 49 42-3-11 26 63 43-18 48-42 38-94 45-71-4-35-26-35 4-75-18v-25l77 17 9-14-80-19-2-38h-26l26-44-2-60h-37l10-55-23-34 10-42z"/>
					<path id="caribou" d="m6288-5224 26-28 38 5 13 12-25 38-39 6z"/>
					<path id="castle" d="m10752 3327 73-132 15 1-31 47 13 11-62 78z"/>
					<path id="chapman" d="m-5714-9243 2-33 39 39 72 2-12 105-40 21-44-66 20-15zm-115-122 32-69 49 88-18 70z"/>
					<path id="charles" d="m10257-4595 49 54-112 46-180-10-80-33 66-54 85 50 78-42z"/>
					<path id="charlton" d="m10507 7316 72 25-41 60 21 46-26 57-134 37-12 24-17 5-26-48-9-56 28 3 37-33 36-57 23-12z"/>
					<path id="christie" d="m10687 1647 30 2 22 28-24 36z"/>
					<path id="coats" d="m6257-3862 82 24 64-9 24 28-26 134 34 76-77 150-44 12-48 56-15 42 4 25-28 60-80 102-39 101-145 156-17-4-6-31-83-43-85 45-45 85-50 36-34-160-133-121-6-61 101-157-7-22 39-79 7-54-22-8 8-87 58-96 47-40 65 14 1 37 77 21 127-136 143-14 43-69z"/>
					<path id="coburg" d="m4245-18067 38 11-1 49-61 106 15 45 51 33 16-2 27 30-6 17-37 10 5-32-8-14-34 26-33-12-19 24-8 25 19 24-2 25-13-1-10-22-18 11-18-3 2-35-15-14-21 12-20 4-4-22 39-30-1-41 17-60 31-40 24-83-7-40z"/>
					<path id="cornwall" d="m424-19345 35 75-21 30-31-8-18 20 3 49-25 36 3 94-22 31-66-16-12 25-16-8 4-16-49 9-71-30-50 5-52-18-91 32-53-19-57 6-24-10-8 21-62-44-4-24-28-40-22-51 11-103 84-76 52-18 28 1v-27l32-13 11 81 84-29 15-24 102 7 52 29 12-26 95 46 48-56z"/>
					<path id="cornwallis" d="m134-15888-42-12-26-19-22-42-11 8 1 19-57-15-1-28 10-18-3-30-71-61-44 43 13 16-33 9-3-36 19-29-6-19-34 8-37-37 4 26-52-8 19-24-36-15-47-71-1-27 16-57 7-4-3-25-17 34-15 40v41l-12 17-26 2-22-20 6-90-39-9-15 26h-18l11-99 43-107-7-12 11-19 12 38 15-25-11-24 47-39 8 16 22-8 19 7 17-11v-14l-14 10-13 1-11-19 29-26-6-10-35 22 3-33 37-23 13-49 20-13 12 34 10-38-31-17-36 1 1 24-20 13-10-19 19-34 46-22 49 49 25-22-39-36-2-32 14-45 43-15 6-27 52-19 18 24 5-46 19-15 5 25 41-27 6-18 23 7 23-23 39 10 19 16 16-11 63 20 32 25 57 102 24 19 4 23 47 63 54 45 5 52 45 50-8 33-19 36 13 19 20 52-9 79-35 15 5 14 17-12 37 74 11 88-11 213-9 39-68 36-146 11-7-15z"/>
					<path id="crescent" d="m-618-18509 41-62 36 1 18 29-35 15-8 28z"/>
					<path id="crown_prince_frederik" d="m3078-11163 23 3 69 128-105 38-71-13-13-28h-9l-18 34-87-33-6-36-41-31 4-15 98-25-19-31 22-6 29 37 90 15z"/>
					<path id="davieau" d="m10644 1496 16 1 13 43 30 10-13 31 34 42-27 10-60-110z"/>
					<path id="devon" d="m2910-16145 3-37-20 37 25 125-16 50-37 16-37-8-15-65-25-43-29-85-14 3 41 164-25 45-153 38-1-90-42-39 10 72-19 53-40 19-60-37-39-41 2-17-19-17-3 50 76 79-108 19-13-25-38 30-55 1-22-54 22-16 2-14-43 22 2 67-79 19-20-62-22 54-70 1-25-20-9 25-107-19-12-85 34-182-35-44 4-61-29-74-8 14 17 64-50 54-6 133-21 25-25-91 4-43-58-61 3 19 32 45-20 72-38-24 6 28 31 28-8 96-31 30-42-9-2 31-47 23-114 18-9-62-15 3-7 42-40-14-58-44-13 12-52-22-34-40-21-83-16 16-12 44-36-24 14-52 26-27 26-86-4-39-30 11-2 38-62 117-19-17-12 34 47 117-60-5-10-41-13 27-68-7-34-25 32-33-10-22-47-3-77-47-11-26 11-111-21-40 14-24-38-35-23-47 8-48 47-16-38-60-33 23-69-97 10-121 24-45-9-13-18 15 1-63 60-155 53-40-30-27 29-50-39-62 5-102-17-79-28-11-93-93-31-40 13-19-13-105-31-38-7-53-31-14-17-21-37-85 15-18-17-31-64 3-57 78-33-4 19-29-29 10-8 37 42 32-140-5-18-20-112-1-11-38H69l-6 30-81 80-39-24-50 8 3-90 20 22 56-13 16-58-77-23-12 29-120-59-45-43-30-79 22-22 67 15 58-99-29 5-31 63-65-11 11-32-35 7-34-64h-31l-32-69-81-5-35-43 43-29-22-18 9-51 67 71 23-61-43-67-30 26-16-65 15-26 37-5 3-18-44-15 17-19 104 5 21-33-35-23 188-39 70 13 57 72 42-8 19 29 60-3 51 11 14 61 14-12 28 14-3 20 63-5 11-43 58 9 38 26v38l79 91 14 43 23-5 1 82-26 141-44 79-46 41 13 25 35-45 19 8 71-155-2-29 58-9 66 34 10-25 31-5 20 23 69-36 53-53 120-31 124 38 39 37 3 23 64 30 24 57-9 26 24 24-50 22-52-4-29-29-48 10-65-37-41 14 38 37 108 16 13 18 89 16 2 29 22-20 49 6 150 62 134 22 34 67-29 55-119 42-178-9 1 18 102 25-2 7-57-7-68-22-175-24-19-30-81-41-19 9 94 49 7 26-45 33 6 13 45-30 161 48-26 23 2 21-34 16 50 2 16-31 49-4 71 28-10 23-188 39h-56l2 13 40-5 11 16-33 6 9 18 25 2-3 43-42 28v97l13 1 9-97 36-6 28-99 33 16-14 23 14 12 23-38 41-1 4 23-18 28-5 31 42-50-1-29 39 4 11 42 16-13 5-79 44 6-11 11 89 111-30 69 22 42 13-51 26-12-23-14 18-5 46 21 29 36 44 19 7 39-10 126-83 40-28-14-2 31 31 9 7 22-43 6-2 13 56-4 7-43 72-6 37 116 43 6 1 42 52-7-1-56-60-134 38-26 2-59 39 13 55 78 83 70-35 37 16 23 95-111 41-20 22 15 8 41 45 35-30 42 10 9 26-22 13-36-45-75 31-23 2-28 27-24 60 35 19 51 79 56 65-2 64 50-61 57 16 18 94-81 181-9-87-13-100-71 14-25 55-33h22l60-76v36l65-1 1-45 26-8 1-28 26-2 6-41 65 2 49 17-12-64 88-32 19-71 52-12-3-62 41 12 16-22 27 5-2 25 51-1 45 42 65-4 46-25 72-85 101-51 97 14 105-13 123 15-9 45-35 48 11 44 73-6 11 23 138-72 29 23 32-18 121 90-72 70-56 28 18 24 140-67h84l-19 36 16 41 45-4 8 81-17 10 4 37 46-21-3 72-17 52-27 29-31-5-11 39-6 61-80 52-29 38 30 58 28 14 46-14 18-53 64-44 70 4 12 51 33 40 33 9-11 50-51 21-68 66-138-48-18-59-30 54 93 138 44 45-26 18 36 62-7 65-75 12-7 28-175 18-42 23-108 135-104-8-43-26-64 16 18-37-21-33-18 7 17 30-25 45-72 3-57-40-47-60-28-82-11-121-56 9-75-76-11 33 50 79 38 7 2 215-35 64-85 2-103 73-108 20-23-28-55 49z"/>
					<path id="dexterity" d="m7434-13838-7-65 1-1 68-57 24 12 26 50-4 74-45 8z"/>
					<path id="digges" d="m8436-3946 23 47-140 18 2-28zm110-26-56 77-38-53z"/>
					<path id="driftwood" d="m9649 1694-34-14 38-51 25-9 30 10z"/>
					<path id="duke_of_york" d="m-6614-9839-9-19 91-1v30l-40-5-28 24 2 21-34 21-17-8-9-26 3-32zm-519 17 21-24 24 26 24-2v21l-31 3z"/>
					<path id="dundas1" d="m26-17542 8-34 17 50-25 62-34 5-33-86 28 23z"/>
					<path id="easter" d="m4023-19926-51-62 81-51 19 11-9 21 9 15z"/>
					<path id="eddy" d="m7941-344 10-5 6 48v48l-6 3-10-49z"/>
					<path id="edgell" d="m14641-5590 32-17 184 58 52 47-46 67-118-19-102-69z"/>
					<path id="edinburgh" d="m-6324-9972 4-32 122-33 32 77-23 12-46-8-49 6-9-18z"/>
					<path id="edmund_walker" d="m-2281-18875 43 5 19 28-8 24-66 43-49-18 20-57z"/>
					<path id="elder" d="m4583-11117-4-25 61 7 44 38 12 37-55-10z"/>
					<path id="ellef_ringnes" d="m-1228-20598 58-36 15 75 28 11 55 78-49 64 11 12 39-16 15 16 5 42 22-18 30 32-39 39 19 27-25 50-56 45 27 42-16 117 39-8 24 27 13 90 27 14 52 136 29 15-50 99 1 73 17 13-49 63-86 24-66-12-10 35-21 9-3-26-22-4-12-23-30 11-59-60-24-8 4-34-51-146 11-45 17-5-1-29-17-3-9-37-19-21 2-54-14-11-25 29-31-8-26-45 9-15-162-90-98 53-45-42-6-42 51-61-27-18-36 15-49-16-188 81-9 29-26 7-18-24-71-19-48-84-42-138 6-63 57-74 90 14 40 65 142 40 26-32-10-24 30-64-139-24 49-45 70 11 10-44 47-46-24-42-42 9-35 35-9-12 31-55-37-13-1 33-35 19-43-24 8-29 91-120-45-51 2-31-35-3-8 38-23-16-59 116-41 37-49 9-7-28 100-175 5-53-47-33-43 34-63 2-40-31 23-163 70-122-13-10 16-36 48 42 268-41 40 17 61 89 27-10 37 33 69 256-24 88-32 30 15 20 19-20 12 12-14 71 21 7 37-71 7-86 47-8 43-51 39-3 44 34 72 126 20-25 35 53-43 70-27 77 37 6 19 47 26-41z"/>
					<path id="ellesmere" d="m1533-24887 46 16-37 45 119 56 27-13 62 13 72 82 22 64 55 42 23 54-1 39-15 45 39-43 23 6 96-8 24 23 18-6-17-30-33-13-85 8-40-92-47-43-11-74 54-10 63 48 18 36 316 177 116-7-43-51-88-3-68-35-14-32-1-42-48 17-105-63-30-32-129-89-23-45 4-129 140-14 21-17-55-16-16 7-67-48-26-36 1-68 17-14 107 16 62 39 64 83 2-31 34-15-61-87-56-55 2-10-59-66-19-3-23-38 34-33 99-5 48 17 46 49 2 45 15 20 39 25 15-7-42-33 9-30 56 6 53 19 52-23-62-6-106-42-33-61 47-29-50 5-30-5-34-27-12-35 63-83 71-37 66 83 16-78 44 24 9 37 44 17 35-92 129 56 48 74 58 58 30 60 108 34 23 22-12 78 59-126-141-49-36-77 49-46-59 28-34-28-51-77-100-51-36-37 11-45h-35l-2-21 61-64 82-3 75-31 11 34 22-11 70 7 30-37 70-1 47 22 44 37 66 99 114 82 111 41-2-45-106-37-55-46-23-48-45-29 34-192 49-52 128-51 12 108 64 63 117 27-28-37-55-20-37-46-23-1 5-59 65-92 130-55-15 19 30 21-9 24 13 21 33-17-9 72 70-95 32 65 35-22 5-41 67 3 7 38 21 15-4-29 50-30 74 3-9-36 36 9 23-19 65 2-9 26 25 8-25 114-106 215-34 14-21 81 17 3 22-42 118-57 3-36 36-69 20-19 7-60 67-140 46-2 14 62 14-20-6-62-27-41 40-56 34 5 34 89 41 14 32-17 5-72 60-25 38 28 20 41v55l-19-5-21 36 28-18 30 13 3 17 71 8 1 46 74-3 6 48 28 77 22 5-18-68 88-64-2 33 124-32 69 39 54 48 68 122 2 41-18 85-46 61 43 12-10 142h-33l22 36-35 123-31 68-21 108-32 20-23-23-5 18 44 34-5 17-23 24 10 22-60 22-40-26-93 129-31 3-19 22 11 17 11-16 49-11 40-47 8 25-66 94-16-24-19 7 14 32-42 27-23-3-172 124-32 46-40 30-69-44-95-41-58-9 137 62 84 50-12 31-31 10 32 11 28-41 39-18 37-46 99-57 49-1 46 23-123 224-121 198-35 30-39-5-14 21 35 12-19 40-57 75-40 6v9l52 1 43-54-33 116 14 19 63-186 156-165 77-133 98-109 91-140 105-122 49-36 50 69 10 103-66 232-35 43-23-11-21 169 18 58-27 118-40 83-44 24 37 20-15 57-18 21 16 25-9 45-28 25-36 207-26 23 25 11-15 102 22 115-15 78-64 58-49 22-17-18-10-73-118-88-50-17v12l51 24 92 92-1 57 26 33 113 32-3 100-120 32v17l-48 39-42 62-3 29-31 17-37-14-18-24-50-26-20 4-43-23-6 22 100 42 42 28-18 27-63 35 15 18 162-71 89-110 28-10 49 32 7 61-22 33 20 23-86 77-29 43 14 48 47-57 60 13 2 89-17 11 15 20-39 61-9 41-76 61-48 73-32-30-51 36-69-19-16-40-46-54 31-15-4-11-188 60 14-44-55-13-53 11-21 38-74 44 27 56 147-53 91 21 39-24 109 129-2 32 32 40-1 24-38 53-45 26-22-1-52-46-13 16 46 75-15 38-123 44-85-60-6 29 63 72-1 40-43 21-90-1-31-31-1 32-41-15-7 17-26-9-35-54-30-9-98 7-33 22-42-4-5-30-22 32 21 33 33-4 35 2 18-22 26 17 85-14 24 22-19 11 28 33 77 40-27 1-18 27-33-6-132 36-49-43-32-67-16 35h-34l26 18 61 94-21 12-50-12-55 17-39-12-24 23 50 20 55-9 82 42 101-57 33 3 101-30 22 30 55 2 22-29 210-65 39 6-13 36-46 30 6 23 51 4 74 93-25 48-116 19-149-7-12-28-21 8-20-63-31-23-69 10-152 63-38-10-56 21-70 6-15 23-18-2-39 45 11 9 59-42 179-28 14 9 69-25h104l38 16-15 40-97 7-117 71-43 65-47-14-18-22-29-4-46 21-37-11-113 49 52-6 73-30 30 15 54-21 49 38-36 66 6 25-19 55-12 146 28 6-10-53 15-103 42-105 90-43 87-70 168-13 10 20 48-8-9 55-92 64-6 64 35-64 22 7 169-69 136 36 29 74-8 19 29 33-25 13 20 64 34 6 36 33-55 20 12 19-35 57-43 6v22l-113 55-53-3-26-17-49 7-59 39 11 36 84-42 66 44 127-16 96 44 35 37-8 25-51 27-5 106-31 27-45-17-244 35 1 74 79 12 79-7 44 17 11-27 114-18 18 103-30 106-48-19-29-29-59 50-8 66-36 12-5 28 34 6-19 35-37-18 17-22-67 15-28-22-38 16-264 20-13 68 44 5 8 37 66 16-2 21 44 5 22 24 10 44-12 77 101 80-40 57 17 89-40 42-5 24 19 16-7 40-24 25h-19l-11 35-28 35-32 14 16-98-36 3-12 77-36 57-144 6-54 65-85-20-8 19-151-47-35-38-72-13-11-43-77-48-2-25-30-25 17-23-68-25-9-54-23 23 14 40 28 9 56 70-10 109 46 20 38 39 69-7 26 39-150 85-69-24-22 27 85 43 10 62 30 22 25-19 117-155 270 38-30 54v35l-23 63 17 2 31-52-2-34 35-89 56-55 94 7 52 25 19 57 34 29-65 214 45 16 94-43 7 89 61 18 27-57-24-69 37-63-9-26 68-42 62 65 42 63-10 28 48 25 38 179-22 42-36 7-18 86 20 12-6 42-28 14 3 58-46 4-40-85 2-35-34-9-6 31-20-5-2 178-43 24-12 118-63 18-111 118-28-14-33 52-158 123-18-12 24-54-46-23 40-241-71-56-65-7-11-51h-9l-29 96-92 18-89-31 10-81-105-53-84-131-19 11 75 135 109 57-23 66 47 79-26 54-128 48-106-81 11-34-56-127-53-47-7 41 56 61 34 81-17 42 34 35-65 25-84-5-21-42-78-57-23-88-63-37-14 13 48 28-6 80 41 67-10 35-107 35-106-136 7-27-82-69-14 22 60 70 48 162 171 90-7 27-208 58-9-27-54 10-89-46-18 14-69-12-77-14-14-95 39-38-5-41-56-45-10-21-44-35 1 24 37 26 5 19 52 31 3 26-63 53-21 8 15 22-15 124-58-24-54-5-17-20 17-16-12-25-84-13 15-25-12-45-24-12 5-57-32-30 11 105 25 24-11 47 39 41-17 42 31 26h-17l-30-21-1 40-32 1-23-17-13-30-14 7 6 29-122-17-31-16 14-126-25-30-9-57-21-14-7-24 10-35-34-85 14-22-8-70-14 66-26 53 43 87-14 38 29 10 14 32-4 37 14 35-23 14-5 41 13 60-33-3-3-147 6-29-17-45-15 11-8 114 17 36-29 58-34-3-13-45-12 40-92-83 12-32-25-46-5 40-47-35 8-52 46-71-48-192 132-135-6-34 57-15 41-88 22 12 7-69 189-42 16 40 30-9 18-87 80-7 56 63 7-8-24-41 60-24-68 8-61-24-10-31 56-43-76 4-8-36 35-46 58-11-4-20-68 5-48 48-98-21-23-70 27-69-24-49-36-25-39-55-45-16-19-34 11-74-9-84 4-27 53-15 137-93 110 5 96 35 63 45 70 103 32 72 39 130 24 32-15 64 59-60 45 77 59-13 63 14 43 52 75 14-51-92 16-24 45 13 83-31 69 27 71 5-19-42-38 6-52-53-3-21 30-6 31-23 32-39 9-41 18-30 41-153-9-16 19-20 9-71-9-18 20-26 14-154-39-115-33 60 29 72-3 36-33 52-1 46-24 56 2 82-17 63-10 66-31 66-25 42-43 42-134-12-29 20-26-11-24 7-23-20-6-39 36-49 14-39 17-24 5-34 4-34-6-23-16 3 9 16-6 53-29 55-50 58-98-67 8-36-21-39 23-18 1-57 26 6 19-45-9-21-67 72-29-18-5-28 30-54 37 1 49-32 16 8-18 52 6 14 40-90 13-9 53 9 13 11 6-12-26-15-43-10-89 42-65 4-40 58-63-80 127-156 67 27 48-64 55-9-1-10-58 4-53 54-68-36 4-96 51-8 23-35 80 13 26 16-19-37-62-16-49 3-30 46-25-29 16-133-17-44-5-156 17-104-32 99-5 158 12 38-71 283-53 15-100 65-36-12-8-106 33-10 9-51 18-30-3-34 9-101-14-20-2 43-28 46 2 63-34 64-51-23-4 56-37 65-78 27-98-12-12-25 23-48 73-32-61-13-40 19-29-217 6-43 32-84 41-54 52-7-4-19-43 11-15-17 35-182 39-74 20 3 208-99 56-71 29-10 109 55 104-16 89 6 200 127 28-13 61 78 66 47 31-26-81-68-26-51 25-32 51 11v-25l-53-4-20 20-60 13-100-63-15-49 52-22 118 3 72-43 89-20 2-39-31-17 14-171-55 60-28 122-93 50-111-33-111 30-137-7-127-49-24-54 44-95 81 18 47 69 115 9-146-137-66-15-78-243-98-72-51-140-94-71-183-36-38-40-17-201 20-14 139 19 50 36 24-28-31-11-10-19-215-41-41-115-4-223 137-33 83 54 273-41 65 36 110 123 274 235 51 142 46 35 23-12 3 38 24 36v38l13 5 7-68 61 4 122 39-1-36 112-84 25-7 16-63-114 45-43 49-70 15-17-30-72-19-39 5-2-40-33-7 4-60-49-104 46-25-6-26-111-24-53-36-261-300 207-124 20 5 175-100 44-35 61-12-21-34 20-38 336-130 53 2 21-31-29-18-57 13-14-8-127 19-84 47-80-2 197-236 187-126 187-57-23-28 54-79 49-31 89-106-17-7-128 107-82 93-203 45-187 105-40-135 61-134-3-101 36-114 133-204-16-72-181 250-7 57-29 76 9 75-17 33-77-39-48-43-7 15 103 97-29 33-2 84 40-12-17 145-213 292-118 104-255 119-14-112 91-107 46-9 49-83 18-45-44-19-89 116-130 111-51-59 37-27 31-82-26-10-22 50-58 93 42 109-5 87-92 55-113 27-168-3 21-80 17-13-7-16-25 20-38 98-146-57 18-143 108-303 492-273 59-64-88 26-157 98-83 27-155 75-78 17-78 117-51 163-69 131 10 34-24 72-57 13-85-41-1-14h-47l-93-88-129-85-28-54 1-20 41-37 101-54 97-38 96 24 60-14 21-20 59-9 61-73 48-37 46 7-32-28 58-113 130-128-47-28-163 125-52 115-195 107-55 13-56-8-113 36-91 44-76 19-31-9-51-39-34-106v-53l52-61 31-5 32 31 70-14 22-24 29-4-8-14-67 28-38-41-63-24-19-33 18-20 45-14 48-75 50-56 16-49 52-26 92-30 14 5-14 17 5 12 26-17 72 8 26 17-14-26-65-9-62-32-21 20-29-35-28 33-62 17-147 144-105 86-24-55-28-5-26-21 8-26 66-66 46-64 24 1 13-42 43-13 10-25h-54l-36 24 15-31-25-8-15-53-20-3 12 73-50-32-21 2-16 39-28 23 5 61-22 48-3-36-61 48-1-88-43-21-42-2-1-58 30-19 4-65 21 1 16-49 48 16 26-6-27-43 15-33 58-20 14-47 155-52 10 61 52 32 16-77-40-8v-33l16-14 42 32-12-85 37-67 112-66-6-23 78 12 38 17 47 74-18 40 13 23 48 20 25 27 15 9-7-30-28-23-51-17 30-42 26 2-35-37 15-37 102-6 54 48 110 127 5 28 11-10-7-25-26-24-55-84 2-23 86-8 14 32 23 41 22 32 17 5-48-83-4-25 21-4 25 19 20 92 38 12-6-17-16-7-17-91-38-35-149-19-49-33-109-26-22-21-30-85 157-45 40-2 8-48 32-10-49-67-2-84-25 8-29-21 4-33z"/>
					<path id="flaherty" d="m9342 2499 16-2-2 20 10 60 45-8 26 25 7-24 9 9 18 58 55 42 71-22 33 93-15 28h44l-25 39-18 10-19 221-5 208-10 49-4-2 5-35v-45l-4-7 5-153 23-192-14-113-22-1-8-15-23 25 16 155 31 14-17 32-1 126-8 65v85l-6 41-14 38h-2l14-93 5-92v-135l-23-102-24 3-21 87-7 115-19 108-39 109-11 25-31 6-59-33-27 92-28 58-8-2 102-376-18-33-34 16-110 356-23 15-10-47-24-3-5-27-47 15-11-19 70-133 57-190 41-56 30-65 5-123-6-75-24-129 49 124 1 261-33 51-5 97 52-124 43-25 14-36-4-195-25-218-9-19z"/>
					<path id="foley" d="m7732-10628 55 29 29 66 104 75 2 39-38 20 7 26 60-11 2 102-69 13-27-52-102-26-99-73-20-114 14-108 45 28z"/>
					<path id="gateshead" d="m-1970-11650 107 123-20 16-44-49-12 20 38 47-31 8 28 66-97-50-47-65 22-90-20-53 36 41z"/>
					<path id="gibson" d="m-151-12817 26-28 27 3 16 18-20 83 7 17-70 3 23-47z"/>
					<path id="gillies" d="m10852 2034-15-45 18 8 9 68 27 64-13 47v-42l-15-4z"/>
					<path id="gilmour" d="m8069-823 70 23-29 70-44 43h-40l6-71z"/>
					<path id="graham1" d="m905-19208 78-82 93 33 26-14 54 27-4 23 42 21 62 67 22 38 14 123 21-3v48l-13 10-42 86-53 44h-68l-4-24-30-6-129-92-50-74z"/>
					<path id="griffith" d="m-197-15914 56 6 46 54 30 95-76 10-110-93z"/>
					<path id="haig_thomas" d="m71-19944 29-17 28 24 39 84-23 36-34-31-21-54-17-20z"/>
					<path id="hans" d="m5053-24009 6 2 3 6-4 4h-7l-3-2v-4l2-4z"/>
					<path id="harrison" d="m1829-10291 30 68-35 131-31 29-68-104-4-46 79-73 12 31zm-192 98 30-13 43 38 43 75 2 46-60 32-15-58-17 32-10-56 14-34-18-8-26 44-9-60z"/>
					<path id="hat" d="m-2042-9041-33-43 54-46-1 80z"/>
					<path id="helen" d="m1972-9651 12-8 7 45 16 12 7-33 40 74-57 114-47-103z"/>
					<path id="helena" d="m-1466-18319 68 1 60 27-150 113-156 70-36-4-50-47 96-54 49-8 57-72z"/>
					<path id="hoved" d="m2320-19355h85l14 40 43 37-46 53-34 11-1-58-39-24-62-1z"/>
					<path id="igloolik" d="m4965-10707 6-14 134 4 2-27h24l8 24-19 9 31 54-54 14-40-9 17-23-68-33-4 6 35 30-17 4 16 33-30 8-34-15 26-5-34-32 27-1-1-7z"/>
					<path id="inetalling" d="m9651 3070 23-54 46 74-40 29-2 148-18 101-15 1 14-82z"/>
					<path id="jameson" d="m-6011-9482 72-36-3 33-31 24-34 1zm-111 35 104-33 1 21-36 18-66 5zm272-130 65-23-7 18-107 78-25-26z"/>
					<path id="jenny_lind" d="m-2699-9695 41 25 5 22 26-3 1 110-21 62-26-35-15 5 11 31-19 36 6 20-10 17-18-26-24-12-1-37-59 5-3-31-45-10-38-64 53-18 73-45 3-30 21-30z"/>
					<path id="jens_munk" d="m5781-11326 72 91-61 111-29 23-104 27-54-36-9 23 91 103-32 43-89-23-13-49-6-67-15 92-16-5-8-40-67-55-102 23-37-22 33-75 106 13-35-39 6-42 105-28 36 39 70 11 74-110z"/>
					<path id="johnson" d="m9157 2487-50-118 57 9 41 123-9 16-26-28 2 61-7 3-23-42z"/>
					<path id="jubilee" d="m9744-6373-8-8 21-30 55 86-5 25 14 2v29l-18-16-8 21-12-3 3-23-15-21-25 4-4-17 13-9-16-12z"/>
					<path id="kekertaluk" d="m11099-11396-16-31 31-28 19 3 22-23-4-29 33-10-8 48 30 56-19 31-130 22-15-24 30-23z"/>
					<path id="kekertelung" d="m11758-9565 11-15 51-2 27 18 64-6 51 19 3 27-19 13-100 4-13-37-25-16-6 14z"/>
					<path id="kilian" d="m-3878-15163 3 44-99 21-37-14-1-72h61z"/>
					<path id="king_christian" d="m-1665-19627 63 18 21-12 73 45 49 44 53 87 5 38-24-3-33 18-31-18-61-5-18 23-56 30-9-14-55-6-76-80 13-4-29-45 12-68 28-36z"/>
					<path id="king_william" d="m-1129-10732 26-19 108 74v37l92 45 10 66h27l-27 36-20-11-22 16 35 53-5 43 5 7 34-108 25-21 60 72v59l70 91 39-16 53 87 23-14 103 99 55 93-8 79-20 42 12 19-7 91 27 33 5-162 33-61 47 105-11 102 42 69-4 110h61l9 50 57-8 39-48 40-20 58 47-150 211-2-94-21-15-73 55-24 131-49-42-127 177-112 18-166-97-33-62-15 12 17 50-36 28-159-68-62-87-184-80-37-70 34-49-68-43-3 104-36 17-55-65-23 13-68-79 33-63-27-34-60-15 12 41-35 4 16 56-63 32-33-51-59-34 1-56-42-67 60-141 147 15 35-11 11-32 74 7 22-30 18-93 29-1 15 22 18-39 55 11-29-85-23-3-33-66 18-49 39 40 12-12-58-63 16-73 81 32 102 158 26-18-79-109 6-6-20-48-21 5-19-26 14-26 4-77 40-93 34-26 19 1z"/>
					<path id="koch" d="m6265-11399 80 41 34 63-33 72-73 58-61 88-52-24-54 86-21-15-2-51 73-157 28-20 23 8-11-62h41l-3 22 18 7 14-27-31-46z"/>
					<path id="kugong" d="m9200 2710 6-78 16 30-11 175-15 41-48 71-142 147-46-22 3-44 19-14 2-34-16-18 38-46 20 11 59-17-26-61 87 7 45-42z"/>
					<path id="laddie" d="m9000 2242v-18l14 6 54 89-8 8-16-13z"/>
					<path id="lambert" d="m-7464-10522 7-4 40 64 7 30-34-22zm113 140-52-30-1-12 32-5 45 30 5 17z"/>
					<path id="lawson" d="m15520-4403 2-93 30 11-17 84z"/>
					<path id="lemieux" d="m13883-7578 29-46 25 40 14-42 11 7-1 54 48-10-24 72 71 19v-53l53 39 16 47-18 36-45-38-100-27-26 37-40-9-22 17-33-23-4-33 19-47 59 33zm251 82-62-84 57 11 41 68zm23-71-110-43 84-61 40 81zm71 77-43-31 14-47 24-22 67 47-27 12-24-16zm15 34 15 1 83 63-22 46-59-54-21-33z"/>
					<path id="leybourne" d="m13557-7844-41-93 37-21 34 60 42-14 5 22-19 24 24 4-20 53-30-7zm0-143-11-49 46 49 13-1-12-26 16-7 32 37-5 53-46-29z"/>
					<path id="little_cornwallis" d="m-387-17015 26-19 59 59 24-7 30 47-62 121-34 1-5-38-42-36 10-32-11-3-28 31v47l16 29-27 30-24-4-13 25 26 12-72 53-7-38-17 8-9-17 17-9-29-67 1-47 70-34 19-29 14 11 51-32 25 1z"/>
					<path id="loks_land" d="m14523-6119-33-45 35-127 57 15 53-64 66-6 32 31-46 42 65-19-45 157z"/>
					<path id="long1" d="m9927 4248 21 17-195 134-146 73-66 71 38-59-33 9 35-42 122-82 30-7zl21 17z"/>
					<path id="lougheed" d="m-2592-19605 54 24 62 81 36 78 34 115v48l-24 26-2 66 68-7-1 49 32 41 4 28 22 5-14 34 16 14 6 51-16 55-36 51-37-9-29 22-27-6-13-52-44-27-19 17-24-19 13-42-46-104 5-92-16-5-1-69-16-35 31-51-43-45 26-72-10-55-40-77z"/>
					<path id="lower_savage" d="m14425-5347 24-28 66 77h-45zm-60 68 20-64 79 58-80 23zm20-64 9-32 15-8h19l-16 22 59 64-7 12z"/>
					<path id="lowther" d="m-708-15907 50 37-41 97-21-2-19 28-47 26-37-41 32-43 25-7 5-45z"/>
					<path id="maccoll" d="m15489-4419 11-79 16-5-2 39-8 47z"/>
					<path id="mansel" d="m7644-3543 90 30 1 23 120 90-11 24 23 47-11 71 9 47-17 125-11 16 15 22 6 57-26 78 15 23-13 96-19 15-10 43 10 25-3 26-36 45-35 10-39-37-67-97-59-24-10-39-46 16-28-30 8-17-30-8-29-72-19-109-6-136 23-97 31-52 15-107 48-48 68-10z"/>
					<path id="marble" d="m1859-2951-4-12 44-18 72 20 41 29-56 5z"/>
					<path id="marc" d="m-2388-17442 131 8 5 29-74 23-43-10-21-23z"/>
					<path id="massey" d="m-2032-17628h63l21 30 3 45-42 25-265 73-89 8-58-24 12-23-19-23 105-19 129-55z"/>
					<path id="matty" d="m-218-10406 98 111-23 119-44 73-26 14-64-12 3-44 41-51-15-25 3-104-24-34-27-14-12 19 38 101-22 11-36 111-49-10 19-6-5-161 23-88 57-34z"/>
					<path id="meighen" d="m-869-22056 75-28 45 73-9 25 18 49-7 143 12 21 1 108-16 20 3 20-31 77-12-7-12-54-79-53 23-86-65-73-27 17-56 3-24-27 17-179 79-102 42-1z"/>
					<path id="melbourne" d="m-3791-9553 37 38 24 67-21 55-24 20-45 1-54-31-66-61-44-107 62-39z"/>
					<path id="merry" d="m10729 3363 19-32 12 13-27 33-12 47-79 87-3-5 73-97z"/>
					<path id="mill" d="m8159-5492 10 36-34 101-128 3-18-66 26-25z"/>
					<path id="moodie" d="m13163-8053 28-63-10-48 24-4-10-104 28 59 18 86 8-24-16-88 4-29 41 26-23 25 10 25 35-20 31 29-31 30 3 18-52 27-1 21 40-16 5 14-27 25 11 46-83 34-9 23z"/>
					<path id="moore" d="m9222 2945 18-196 28-27 2 33-5 145z"/>
					<path id="n_kent" d="m1154-18344 117-51 37 33 42 65 11 54-29 45-12 57 20 75 43 35-39 33-26-39-1 55-34-8-42-43-35-88 1-15-21-14-59-104 3-57z"/>
					<path id="n_spicer" d="m6366-10199 107 19 5 66-25 28-43-10-12 51 50-2-29 72-30 26-69-23-8-53 41-51 35-1 6-48-104-45 18-17z"/>
					<path id="n_tweedsmuir" d="m7856-10651 52 5 12 54 68 17-1 19-79 25-38 3-32-25-11-32z"/>
					<path id="n_twin" d="m9736 6039 79 25-25 43 32 60-49 57-54-18-30-115z"/>
					<path id="nottingham" d="m8290-4846 125 141 10 35-16 10-3 28 26 7-135 152-44 15-9-24-26 6-276-200-17 2-47-62 164-109 13 20 55-24 121-6-16 39 38 6z"/>
					<path id="padloping" d="m13043-11169 69-37 16 19-10 49-36 65 14 47-26 30 1 44-79-32 36-11-9-46 22-29-9-37 34 7 2-8-30-23z"/>
					<path id="pandora" d="m-571-13996 29-5 4 91 21 36-42 65-40-18-27 9-17-38 35-91z"/>
					<path id="perley" d="m8055-645-42 96-36 27-8-40 38-92z"/>
					<path id="pim" d="m4401-21178-3-45 25-7 105 28-15 65-78-9z"/>
					<path id="prescott" d="m-568-14320 71 128 3 49-16 61-31 46-79 13-35-45-28-88 6-54 26-63 58-42z"/>
					<path id="prince_charles" d="m7721-10142 140-11 66 57 24 60 14 81-13 87 7 30 63 97 13 4 76 234 7 79-16 118-20 12-42 104-18-1-13 16-5 40-120 106-59 27-62 14-27-3-21 7-19 27-114 59-136 1-34-29-86-134-30-28-16-73-72-140-19-62-6-155 27-207-3-55 41-159 39-72 101-87 1-19 20 6 4 25 76-14 27-57 62-19 84 9z"/>
					<path id="prince_leopold" d="m1547-15306-18 50-83-8-11-26 14-22 71-19z"/>
					<path id="prince_of_wales" d="m-546-13794 18 9 12-50 19-5 12 46-30 26 37 32 60 273-43 6-15 44-74 64h-12l-20-16-33 1 26 11 20 14 24 8 1 25 33-11-1 33-23-7 22 34 8-24h6l11 149-14 39-123 30 82 24 18-18 35-1-8 89-31 17-8-17-38 22-15 22 10 15 53-35 20-7 10 8-23 114-29 20-42 18-2-35 24-16-4-12h-21l-7 38-30 18-19-14-53 109-95 77-64 26-77-27-12-19-34 4-44-19-43 23-24-7-55-114 55-135-33 18-63 102v23l33 27-9 23 71 118 18 56 29-3-20 61-130 168-44 32-40-5-7 21-42-29-41-98h-23l-23 35h-51l-44-214 9-43-62-47-9-89-19-34 1-37-47-48-2-48-14-9-22 5-44-30-20-66-45-43-11-29 4-34-34-32-18-67 11-11-68-90-56 8-24 26-74-200-59 40-11 55-37 7 17-26-52-53-19 26-65-88 15-30-20-91 11-26-146-128-71-123-4-138 61-93 36-121 98-65 10 18 35-6 45 48 15-11 19 58 15-13 13 52-10 7-27-23 65 113 8-8 26 23 13 89 36 28 10 33-40-12 27 40 138 40 20-16-9-44 53-12 17 17 37-3 23 23 47-70-45-165 16-68 36-41 17 45-43 27 21 46 24-17 12 42-32 20-5 28 83-9-8-38 25-9-44-61 23-61-29-8 21-46-42-2-5-12 22-11-11-17-23 4-29 50-23-1 8-53-28-17 31-64-2-31 89-53 25 60 46 52 74-1-3-23-19 3-32-16-48-64-37-105-28-36-9 4 9 34-14 1 16 51-64 6-12 24-78 15-45-12-19-27 5-32-10-9-23 2-48-38 3-44-42-24-50-87 57-56 61-6 6-41 19-12 98 20 51 148 45 34 4 31 24 7-20-52-34-50 35-78-8-22-105-48 26-32-44-33-19 10-16-70 40-14 10-26-20 1 10-27 28-21 74-6 43-33 50 28 28 43 36 2 29 40 22-5 22-45 26-21-6-17 15-16-5-16-40 20 1 22-55 15-33-16-11-32 16-48 68-31 49 4 37 18-24 32 34 63 71 32 75 119 10 3 17-35 110-3 59-28 73-4 126-54 11-50 47-19 6 17-27 36 19 8 43-42 47 39 81 14 71 135-6 107-70 52-10 35-71-36-14 30 11 35-26 9-30-30-17 72 29 27 11-31 43-11-2 20 33 19 12-25 27 40-17 22 27 45-229 114 2 32-127 158-2 22-75 57-2 68 13 20-18 46 7 37 7-37 29-45 29-49 131-60 172 94 20 31-16 73-49 4 47 21 77 115-2 34-56 61 28 60 67-81z"/>
					<path id="qikiqtaaluk" d="m4319-6816 33-59 20 20 46-5 54 63-20 19 41 26 32 67 22 9 5 44 29 16 33 102 34 36-24 90-40 26-46-42-23-66-42-34-45-15-34-26-22-37-17-87 2-49-27-43z"/>
					<path id="qikiqtaryuaq" d="m-5351-9134 59-47 31 33-38 80h-25z"/>
					<path id="qikirtajuaq" d="m15132-1464-9-101 46 12 1-42 22-4 19 75-17 59-30 12z"/>
					<path id="qimivvik" d="m5210-14120 25-33 102 58-49 19-12 32-38-16z"/>
					<path id="resolution" d="m14655-5243 110-111 44-21 30-24 49 9 1-16 113-24-17 51 67-28 13 16-16 76 7 7 24-17-16 44-10 15 38-36 17 49 4 48-13 20 12 49-14 45 11 28-83-12-28-44-61 1-27-27-26 14-20-27-105-2-42-30-24 8z"/>
					<path id="rowley" d="m6251-10985 78-1 48 79-30 115-38-26-9 16 20 43-29 36 20 62-45 98 8 31-27 97-119 82 10 13-24 18-54-14-26-65 19-51 3-145 95-42 26-55-18-46 24-89 56-10-52-30-13-40 39-58z"/>
					<path id="royal_geographical_society" d="m-2128-9883 45 9 20 16 8 24-7 33 34 61 25 10 10 14-28 7 17 28-7 18-11-8 6 72-29-21 4 58-31-26-32 83-17-9-17-69 16-14-19-21-44 44-16-8 20-175 13 15 5-33-19-58 29-14zm135-104 14-4 14 41 25 20 3 16-12 4 15 87 4 64-32 2-59-36-13-78 17-14v-32l34-36z"/>
					<path id="russell" d="m-817-15354 31 59-16 36-137 152-93 48-77 8-30-10-3 32-112-10-18-24 101 9-6-14-111-8-53-30-12-47 140-47-11-23 82-49 94-3 79-43 71-27z"/>
					<path id="s_spicer" d="m6364-9855 69 72-47 122-30 16-52-32-36-122 8-37z"/>
					<path id="s_tweedsmuir" d="m8097-10492 135 96-2 95-21 17-46-43 23-28-44-9-72-70 4-48z"/>
					<path id="s_twin" d="m9877 6252 46-2 39 79-85 47-20-59z"/>
					<path id="saglaarjuk" d="m4155-10991 26-14 87 13 22 10-2 7-26-3-4 26-37 1-3 18 40 16 2 21-65-20-47-29z"/>
					<path id="salikuit" d="m10192 2662v-33l65-35-3 27zm233-167-13-24 15-59 14 11 2 60z"/>
					<path id="salisbury" d="m8509-5187 202 74-5 24 52 19-22 55 33-11 34 9-46 110-82 2 9-15-58 14-163-100-99-35-8-21 8-13-15-2-11-12-1-28 21-32 36-19 10 18 22-24z"/>
					<path id="sherard_osborn" d="m-1240-18246-16-30 75-15 56 61-28 31-24 5-17-19 36-8z"/>
					<path id="sillem" d="m7968-13413 26-41 100 10 104-20 14 107-55 25-82 99-8 38-50 23-13-30-60-48 40-38 8-32z"/>
					<path id="simialuk" d="m4524-11025 2-27 120-7 13 18h28l12 41-15 29z"/>
					<path id="sleeper" d="m8776 1640 28-113 43 69-8 67-14-27zm29 2 19 98-9 20-36-77 19-41z"/>
					<path id="smith" d="m8749-2053-16 78-161 104-18-25 27-58 104-73z"/>
					<path id="somerset" d="m1431-15179 46 29-26 63-19-29-14 14 11 64-42 133-84 166-41-1-9 18 20 22-2 31-94 253-69 23 11 26 41 2-124 375-77 134-56 51-50 7-315-94-237 46-72-6-6 50 64-9 19 24 65 5 33-44-12 91 12 29 35 12 52 86 23 100-32 32-19 73-23 27-49 27-11 55-49 111-22 117-43 1-9 52-77-19-41 16-34-7-166 54v-11l38-25-47 7 6-121 37-21 2-14-29 4 3-41-12-11 12-203-25-86 37-20-13-29-17-44-25-4-22-125-27-14-10-32-23 8-25-58 27-5-5-52-32-2-8-30 14-154-15-29-2-38 20-9 1-49-14-14 10-50 50-7-25-27-8-177-18-7 19-61-22-82 21-101-13-44 27-18-14-29-29-5 19-114 23 1 17-30 39-12 18 22 11-6-6-15 7-3 38 47 12 38 94 58 66-20-16-19-59 4-85-139 4-13-52-64-16-53 21-81 137-77 18-29 81-4 17-27 155-21 28 63 28 2-9-73 80-36 140 25 97 35-10 34 19 3 24-37 104 97 4 76 39 4 11-45 52-33 116-18 208 27 20 21 30-7 113 66z"/>
					<path id="southampton" d="m4142-6702 45-18 17 41-8 39 27 62 27-10-8-23 19-19 72 9 48 87-25 9 83 94-3 50-67 49-26-12 16 50 94 46 44 59 12 78 55 92-2 17 57-10 16-70-17-59 55-169h20l51 28 3 36 24-1 9 26h37l72 38-29 77 109 69 56-19 11 19-17 14 91-20-5 13 98-22 8 15 41-1 58 81 9 55 33 15 44 44 101 24 1 13 62 21 37 46 60 31 44-3 23 29 72-50 60 44 24-2 7 32 45-14 36 50 121 74v25l43 24 13 31-13 27 5 21 13 3 24 81-6 23 19 37 39 45 35 26 20 33-2 57-43 43-71 27-40 93 15 20 88-33 65-48 77-25 10-16-19-32 27-18-4 28 53-27 62 40 48-7 78 40 10-22-45-47-8-20 26-26-30-37 21-10 94 46 38 67 41-17 35 11 20 37h-18l5 41 45 9-45 35-73-21 63 40 150 10 12 21 39-16 33 17-5 45-138 54-1 55-22 48-87 93-4 39-40 16-5 31 15 42-57 27-169-43-92-39-29 18-33-2 3-25-61-36-24 18-38 7-86-52-82 27-19 37-85-7-46-67 11-58 62-65-31-62-64-21-27-25-118 23-51-14-73 58-56-43 76-172-43-44-50 27-20 60-50-26-43 55-35-15-29 26-3 42-13 44-28 24 46 81-2 74 29 27-3 89-62-12-63 119-39 30-30 73-49-29-39 13-54 149 5 129-10 5-30 62-4 28h-27l-29 39-97 119-118 83-141 24-66-68-58-236 16-116-20-40-1-114-21-35-83-3-216 100-103-17-51 16-46 39-27 54-76 47-71 5-46-26-29-43-9-102 99-202 75-81 207-154 54-21-1-56-79-90 10-25-30-24-30-103-31-137-13-105 43-139-10-31 37-192-44-48-3-44 24-98-46-199 28-80-32-2v-152l14-220 41-106z"/>
					<path id="split" d="m8909 2331 51 25-9 59-14 12 6 41-19 4-29-30-15-61 17-55zm17-97 21-2 23 29 50 119-18 25-33-41-22-64-38 31-12-5-6-35 18-9-7-33 35 24z"/>
					<path id="stefansson" d="m-3199-15209 103 32 20 49 131 144 17 73-20 53-21 35 6 45-24 89-170 258-10 40-77 70-54 119-207-437 34 1-102-225-58-36-32-50-70-17 4-26 75-74 77-118 53-23 66-6 183 29z"/>
					<path id="stor" d="m1972-20993 116 2 21 25 6 27-23 29-84 65-111 69-53-1 29-78-1-56 30-6 29-44z"/>
					<path id="table" d="m-167-18796 62-6 58 49-5 40-34 6z"/>
					<path id="tennent" d="m-439-10385 39 108-5 47-18 3-1 105-74-62-31-59-36-8-24-21-57-114 20-5 12 37 90-21 33 56z"/>
					<path id="thor" d="m-1796-20062 14 25 1 50-31 18-51 70-40-7-11-26 10-36 79-96z"/>
					<path id="tukarak" d="m9701 2630 34-19 26 20 38 137 17 126-70 22 1 35-39 38-29 18v-107l26-80-25-3 5-82-17-3z"/>
					<path id="unnamed" d="m1835-9967 40-1 22 104-53-23zm18-94h25l18 66-14 3-43-37zm65 104 12 9 13 57-17 9-20-65zm32 154 36-10 2 71-51-19z"/>
					<path id="unnamed1" d="m12612-11131 9-7 71 22-7 43-150 63 13-87 30-38 33 57 10-12z"/>
					<path id="unnamed2" d="m-1463-17058 35 3 13 47-96 36-3-9 61-21-10-19-160 42-32-23 71-26 26 10 16-24z"/>
					<path id="unnamed3" d="m-5256-8219-13-109h27l48 108 39 22-2 30-78-5z"/>
					<path id="unnamed4" d="m10113-11660 6-21 44 5 37-13 64-11 67 6 39-8 65-4 3 13-65 31-84-11-25 6-88-1-43 17z"/>
					<path id="unnamed6" d="m-1577-19914 40-94 29 55-1 38-15 23z"/>
					<path id="vanier" d="m-2030-17888 20 29 2 45 25 53-23 20 9 40-42 40-98 39-101 22-3-10-138-10-27-16 44-2-127-51-20-46 1-39 58-68 61 5 264-57z"/>
					<path id="vansittart" d="m4973-6863 20 30 1 64-36 32-7 19 24-6 61 49 20-1 46 20 111-14 25 12-28 38 21 22-37 20 21 7-32 25-57-29h-41l-45 27-53-25-15 36-15-8 18-87 40-25-8-8-56 11 10-43-70 54 14 23-98-27 20-37-18-49-13-7-6-52-34-21 4-51-92-5-59-72-10-80 21-11 114 54 34-9 16 31 13-3 4-26 16 5 17 46z"/>
					<path id="wales" d="m3334-9209 94 61 23 49 44 231 19 29-1 119-15 71-43 67-98-39-50-70-27-95 38-52-23-60-58-40 1-42 31-9-8-68z"/>
					<path id="wiegand" d="m9342 2435 30-3 34 31 15 33-16 1-18-24-32-3-8 26-12 4-10-41z"/>
					<path id="winter" d="m5080-7239 3-93 87 46 19 35 45-31 28 3-21 28-22 66z"/>
				</g>
				<g id="i-CA-NT-NU">
					<path id="borden" d="m-3327-20873 39 62 33 94 53 49 27 132-78 172-100-2-10-40-116 33-64-36-76-135-41 8 5 63-41-19-5 43-19 23-80-32-2-80-50-43-103 1-44 37-104 12-11-85 28-12 18-60 246-92 88 2 10 25 81-37 19 7 90-100h78l30-34 70 6 4 44z"/>
					<path id="mackenzie_king" d="m-3432-20176 67 31 12 34-5 35-62 94-60 18-45-5-13 19-17-3-4-14-28-3-1 15-129-3 2 46 22 23 12 52 121 7 17 22-1 34-35 59 9 19-13 58-28 12 17 42-76 70-97 31-43-10-3 22-30 12-55-25 2-20-38-7-10 31-186 36-94-82v-99l-14-12-20 22-41-37 8-66-54-15 39-100h21l-30-60 20-13 21-70-16-22 25-92 39-44 5-28 61 22 117-56 37-3 21 16 72-28 9 21 42-27 12 37 64-38 72-4 47 9 1 20 37 25 22-43 94 14z"/>
					<path id="melville" d="m-4211-17417 302 101 83 63 1-63 54-75-15-73 25-8-59-86-88-78-46-13-7-17 24-5-3-66-68 23-22-60 43-25 92-15 31-38 35-7 19-69 31-22-44-95-71-90-18 45-44-98-58-50 32-134 79-6 47-39 69 8 12-34-36-12 45-58 20 23 71-142 64-71 54-17 59 22 26-18 24 4 9 29-32 33 16 22 33 8 19 47-44 67-54 3 8 70 26 29-32 76 22 35-39 23 2 20 71 49 6 90-27 74 35 14-21 25-67 23-40 75-16 60 127 3 41 19 39 75-60 64 15 17-45 12-59 92 34 18 57-89 113-14 80 41-35 48 20 215 10 4 21-122 29-26 49 7-70-48 22-58 9-95 69-58 6-25 30-6 63 22 89 65 88 106 18 90-10 163-54 169-48 12-33 46 27 26-3 38-31 23 10 55-41 61-20-5-46 87 18 42-22 43-39 1-34 45 31 25-10 26-147 27-87-7-5 44-138 24-105-94-8-53-80 6 5 56-132 13-32-31 14-79-11-49-54-33-40 16-18 41-66 33-51 3-79 84-105-32-49 33-72-39-25 35 24 22-110-6 7 81-247 98-32-11-103 59-76-4-31 20-74-2-50 12-137-22-91-32-84-49-58-64-66-106-50-138 4-56 130-61 166-16 29 11 37-15 23 26 20-12-34-31 76-46 82-22 99 6 122 23 61 25 8 11 28 10 65-25-8-40 34-7 8 20 49-24-24-26 119-46 20-53 20 7 16-15-49-47-39 13-40 55-91 41-35-11 8-53-53 44-57-26-18 14-73-18-8-38 19 3 44-42-13-46-27 25-1 38-41-7-7-27 6-28 23-23-16-40-44 76-7 79-62 15-55 1-4-62-31 62-218-28 4-41 31-56 90-21-85-11 88-156 72-19 51-30 43-5-61-19-45 18-66 6-4-117-35 56-3 52-58 106-33 41-26-31v-52l-47-45-25 32 41 12 9 27-5 62 11 37-79 98-147 53-51 1-30-47 22-85 29-44v-76l-28 52-42 30-46-75-13 133-27 34-36 19-127-158 73-26-68-15 7-33 57-74-33-7-50 17-12-19-65 66-69-68-108-80-39-93 72-95 113-88 48-7 203 72 24-4 9 21 54 16 145-69 74-12 16 24 15-6-11-23 96-63-22-5-93 28-52-12-144 19-11 16-70-12-222-95 37-74 129-118 37-1 192 58 47-8 20 5 26-22 15 25 66 19 28-11 35 18 22-6 28 19 66-23-13-18-112-5-128-55h-84l-93-39-69-53 38-74 58 18 6-60-42-6 18-55 69-64 91-25 43 6 124 58 29-1 60 34 45 48 86 23 2-9-81-38-28-61-130-55-44-42 14-49 29-16-14-33 126-71 160 8 25-27 47 16-25 13 50 18 38-8 4 21 48 37 8 73-24 60-26-2 1 56 23 44-30 55 12 28 65 13 145-40 14 28 42-5 36 27-9 40 24-7 1 34 71 37-1 18-29 9-16 62 17 44-9 17 89 74 24 66 28 8 3 43-21 13-59-5-63 24 6 30-34 4 23 16 29-6 26 25 46-28 39 31 32-21 23 9-9 29-43-10 43 66-23 32 26 14-26 47-4 53-16 9 19 62-10 64 42-7 27 13 37-21 52-9 14 18 55-5z"/>
					<path id="victoria" d="m-4883-14706 143 85 15 18-16 16 14 25 15 6 1-20 37 5 13 39-45 7 93 145-18 32 81-1 21 30-32 8 26 59 27-4 12 26-40 10-17 84 64-25 61 86v54l-27 29-42 145 11 14 6 162 32 19-45 162 35 41-2 31 32-36-20 84-19-6-18 43 11 37-25 25 1 27 32 37-16 57 48-15 12 76-11 23 39 19 3 29 45-17-26-60 10-51 33 3 5 27 25-8 5-21 45-47 45-12 31 15 19-27-26-16-32-37 4-31 59 16 11-29-44-29 13-44-55-55-1-61 14-12-30-80 11-142-11-1v-37h15l18 32 4-111-20-56 32 4 10-23-34-17-16-55h36l16-56-2-12-36-65 19 1-12-131 17-11-13-139 19 2-6-179 32 9-32-93 17-54 61-23 54 37 6-28-29-20-24-64 4-41 44 7-15-32 22-9 107 62 59 58 43 92 50 47 19-20-32-60 42-65 45-7 43 42 2 55 47 39-1-41 28 34 7 77 70 105 69 26 16 38-11 36 71 100 46 158v47l-49 19 38 57-23 113 24 16-2 114-31-14 38 132 24 194-21 38 37 186-20 91 82 172 39 164-30 58 13 98-12 104-25-26-31 4-16 20-1 61 13 27-28 79-64 64 55 154 75 38 32 62 1 165 56 24 59 88 19 82 50 26 41-16 42 60 22 56 70 18-13-50h-25l-25-38-1-98 13-24 31 11 35 77 17-3 10 26-28 95 32-5 162 152 126 152 81-41 46 55-45 30 17 99 68 14-5-41 34 3 34 40 55-69 27 17 7 123 15 83-13 53 18 85-25 144-24 3 9 63-24 24-17-22-19 26-25-40-26 29-41-15-36-132 2-60 21-21-1-60-50 102-16 79-40 43-56-24-25-32-14 22-26-95 4-31-5-16-44 33-18-108-19 2-1 79-40-8 14 42-28 55-21-26-20-27-19 45-32 17-25-44-7 26 18 53 44 6-20 144-36 28-26-21-56 27-12-39-27 10-76-79-51-107-31 18-3-35-24 13-5 46 27 87 61 4 6 117 12 5 23-78 15 57-1 104-24 14-10 142-86 60 7 25-17 57 20 13 14-64 65-56 5-40 29-50 25 2 21-87 44 22 28-31 69-9 10-59 109-17 78 58 15 66-35 20-11 39-19-7 11 92-30 33-30-62-17 33 41 91 46-84 33-16-3 36 58 75-1 28-38 94-21 10 22 56-82 24-32-38-32 57-22-14-42 22-24-27-18 7 13 24-40 61-56 2-43-50-13 30 18 21-37 36-1-17-22 1-29 36-42-9-27-22-16-36-94 15 17 38-35 3-32-32 1-21-18-7-24 16-102-47-6-26-82 3-84-78-2-29-32-5-13 42-34 38-70-10-154-60-34-74 132-62 24-24 2-28h-13l-41-30 12-19-16 9-9-3-8 10-12 2-9-11-22-6-4 2 29 22 25-4 21 35-18 15-119-76-28 12-22-71-67-44-65-3-27 30-70-35-12 22-51-61-29 8 6-69 38-9 32-38-16-42 11-82-76-114-35 11 1 32-45 10-6 55-99 22 8 109-193 204-88 37-184 9-221-47 3 43-67 56-169 86-69 11-84-9-138 38-43-19-26 9-58-8-48-38-76 57-68-72-70 24-107 14-33-15 7-16 19 10 8-35-55 7-87-38-27 20 68 29 5 46-134-66-191-15-11-23-70 2-9-17-39 22-30-14-13 6-53-29-13 14 8 13-71-3-33-32-131-4-26-16-2-23 75 3 18 18 16-12-15-46-85-84-18-73 19-34-56-157 10-27 16 9 12-25-9-41 51-45 27-74-18-3-4-20 20 6 15-2-29-43 22-3-4-11-17 1v-17l24-1 13 5-2-11-42-17 21-15 25 8 7-9-26-9-13-22 6-13 27-6 43 35 14-5-50-37-20-28-21-1-62-48 19-9-99-28 2-34-71-36-109-7-81-21 2-22-51-19-9 22-56-2-35-38-37 2-34-10-34-36-37-10-36-33-52-20v-28l-22-30-48-23-50-79-44-23 5-25-29-45 12-23 26 4 9-26-17-10 23-24-11-29-40-25 12 29-8 6-45-49-2-38 17 7 14-17-3-33-89-144 22-204-2-52 33-55 116-29 52-7 389 11 41 13 319 37 15 14 117 11 34-3 85 17 71 39 17 33 126 59 140 25 88 81h28l118 85 20-13-26-24 43-10 34 31 23 1-16-31 90-2 57 26 148 26 9-12-47-45 57 27 38-17-19-22-118-43-50-33v-119l-20-32-41-10-1-24-41 8v-32l-27 14-43-12-1-47-61-25-13 22-112-151-54-22-8-25-47 26-50-81-65-38-83 24-46-30-43 3-56 26-73-9-13-21-101 10-80-20-31-23-47-9-32 19-16-28-4-18-142-7-40-38 16-27 22 8 6-16-141-49-58 10-90-26-3-16-99-37-58-36-39 19-50-78 37-47-108-165-26-82-15-126 57-62 31 1 143-47 51-10 147 21 141-7 5 17 62-5 8-24 112-17 108-5 34 4 56 29 88 22 11-23-71-19-54-59 143-39 124 90 82-19-5-25-62 15-65-50 52-12-77-52-184 12-38-22-97 6-43-12-82 14-36-24-30 2-44 16-13-19-26-1-4 22-29-5-1-28 36-52-41-54-38 12 37 56-36 51-121-47-41-5-73-48 12-85 55-42 57-11 29 10 13 17 53 26 43-27-10-15-44-58-27 16-3-21 26-27 62-2-82-42-131 61-35-22 29-30-17-47-114-53-39 73-9-9-21-57-2-36 32-132 29-64 49-64 98-76 59-19 87-94 31-18 30 15 61-10 83 10 8-89-11-51-44-5-43-28-16-50 32-79 43-40 210-117 32 5 127-63 141-112 169-3 111-48 40 5 108-34 252-27 57-41 24 16 163-38 3-20 22-6 62 23 48 45 32 74 14 121-3 51-41 118-30 26-16 42-25 96 9 58-23 10-67-15-65 47 3 68-122 47 52 78 133-75 67 6-16 30 130-35-4 18-84 42 4 18 105-42 24-68-50-23-3-29 65-60 60-75 61-53 63-8 152 107 28 55 38 33 57 19 53 78 37 40 37 16 32 51-14 25 20 11 24-3-1 1 32 30-25 52 10 16-11 41-44 66-24-2-42 31 6 31-42 36-114 37-69 34-28 23-17 30 76-44 1 20 49-5 11-21 27 13-2 27-29 12h-24l10 31 47-21 31 2 32-21 2-8-8-3-9 2-8 6-14 2-20-6 2-36 21-19 39-12 31-31 49-16 17 11-14 16-54 29 20 3-4 25-39 17 2 30 29-27 54 46 5 15-3 35 3 15 7-2 3-30v-35l-5-25 12-25 49-42 4-40 15-14 58 35-14-46 56-62 22 14 40 49-49 21 14 45 28 16 31 51 11-9-61-99 42-5 20-40 17 5 62 151 41-31-24-43-55-61 2-17 29 28 22-8 13 43 36 63 26-17-12-115-45-80-48 9-10-40 50 5-14-43 51-6 56 91 10-52 35-6-39-10-56-54-56 23-2-16 43-21-16-72-52-13-42-46-28-94 5-49 55-17z"/>
				</g>
				<g id="i-CA-NU-NL">
					<path id="killiniq" d="m15589-4304 6-18 56 5 44 26 15 21h15l-3-21 29 1 10 19v53l56 12 4 18-50-1-46-8-121 3-75-22-19-38 20-38z"/>
				</g>
			</g>
		</g>
		<g id="Lakes">
			<path id="Amadjuak" d="m10462-7203 114-48 16-25-151-47 31-31-25-14 5-24 26 3 15-22-50-44-23-61-26-17-67-13 10-62-11-39-83-56-11-41 22-2 148 100 108 2-2 22 37-2 67 45 99 19 61-17 79 56 127 159 48 19 59 65 21 55-13 18 8 42 33 22 22-31 13 16-22 45-75-39-33-3-24 36-61 13 13-33 20 1 26-18-15-33 18-44-57-7-16-20-41 1 7-26-61 1-26 47-33 9 3 55 25 66-16 49-103 20-37 78-67 1-20-31-61 12-99-84 36-41-3-6-51 21-26-22 1-31 98 15 48-36z"/>
			<path id="Athabasca" d="m-8521-67 161-73 39-48 144-72 43 16-3-44 80-26-55-18 53-60 92-33 62-50 191 38 12 74 23 28-14 28 24 21 54-28 57 3 38 44-144 81 110 45 133-64 22 32 32-24 63 46 77-25 180 104 146 42 22 34 183 91 115 10 64-6 1 9-59 15 146 30 12 68-93-17 14-27-59 2-16-23-107-17-17-29-102-12-15-13-83-27-44 16 2-57-62-10-92 108-63-8-144 49-133-16-166-11-51 14-31-18-25-35-102 35-44-26-10-39-2-23-41-18-24 12-7 32-39 23-213-5-74 12-136 68-46-2-150 111-60 101-6 20v2 1l4 6 21-20 2-20 39 1 3 46-35 5 17 19-31 38-83-72-43 30-27-22-11-45-79-42-9 20-85-58-21 26-23-5v-37l-25-5 1-13 51-3 67-50 58-1 60-27 26-62 71-39 4-31 133-139z"/>
			<path id="Caniapiscau" d="m15296 3032 21-27 71-30 18 13 26-20-22-12 21-22 113 12-38-48 49-44-14-11-18 12-21-14 24-33-21-20-39 80-41 1-21-65-62-16-39-9 20-27-26-23 22-57 23-16 24 32 12-10-9-56 41 30 22-31-15-45 53-77 148-67-14-74 33 48 30-19 12 42 82-11 81 46-19-55h23l24 42 27-10 12-46 74-65 26 10-43 55 18 42 60 39 4 15-53 2 24 88 120 43 26-47 124 75 24-5 35 35-5 9-43-24-26 5-7-20-68-36-28 32 1 68-48-52h-40l37 106 21 55 56 19-11 45-24 9-20-43-26 3-14-64-58-49-75 98-29-47 15-31-40-31 36-51v-33l-39 13 3 27-31 1-9-26-22 1-11-38-53 13-191-20-60-31-65 29 102 80h-67l66 81 57-19 27 48 27-13 8-29 47-6 9 25-16 54 48 85-87 121 92 13 91-82 32 11-43 69-35 135 74-34 17-30 16 9-28 47 61 44 11-33 40-13 52 8 61-22-25 52-29 12 1-33-50 44-36-9 1 53-18 32 41 48-19 86-20-3 6-33-26-1-24 34-35-56-31 8 6 50-92-11 1-165-113 30-45-27-22 57 12 16-40 36-20-51 14-116-36-36-92-9-25 50-14-5 25-93-18-7-19 32-29-2-47 3-98-32 18-21-20-14 13-11 40 23 39-21 7-34z"/>
			<path id="Erie" d="m13370 17209 56 62-12 8 34 48-85 112-49 34 1 56-29 40-13 73-152 112-43 62-1 30-96 112-193 183-24 10-95 97-238 217-242 168-111 63-80 66-47 17-115 78-95 87-33 5-76 84-59 94-187 214h-50l-56 28-61 1-39-12-39 2-121 77-55 53-92 28-83 71-30 3-182-55-39 28-54-23-15 2 1 21-14 18-26 5-33 35-22-3-29-29-6 4-15 23-4-12-15-7-11 1 4-12 18-6 13 4 6-9 10-3 12-26 17-1 44-12 32-21 19 11 5-17 39-7 32-16 9-20-11-21-56 16-24-22-25-21-14 5-5 11 10 16-9 34-16 18-35 13-48-9-56-32-28-29-15-8-24-6-20 3-64-10-76-34-17 3-7-6 3-7-30-16-8 23-25 6-12-4-39 4 13-13-8-9-32 34-3-3 4-6-9-3 5-26 8-10v-13l-19 2-2-21 29-6-11-20-7 1h-2l-1-6 11-8-3-13 19-32 20-57 31-12 1-52 24-32 29 9 7-51 24-18 34-43-23-16-8-62 43-7 18-2 2 23 9 22 107 19 64 26 100-47 46-35 52-22 55-5 50 30 36 40 26 49-11-106 12-68 20-42 36-48 116-90 82-81 57-38 72-17 59-4 32-10-2-29-8-32-5-48 18-45 64-74 93-134 80-87 47-19 33-51 71-37 54-18 153-19 63-22 74-7 31 11 10-10 23 2 132 36 46-5 89-18 63-17 76-1 135-3 74-31-50 4-23-11-34 17-65 4-48-28-68 39-15-12-22 6 6 9h1l-10 9-24-30 9-21 35-49 27 11 23-7-6-52 60-115 142-51 121-52 140-86 63 14 35-34 37 12 13-20 40 5 18-45 88-1 9-21 167-31 32 23 6-3-6-22 66-29 58-35 4-20zm-2846 1987 23 39 3-14 35-24-14-24-3-30-16-33-6 17-8 9-12 3-11-5zm19 88 1 2 6-2 1-3z"/>
			<path id="Great_bear" d="m-12711-9425-13-259 81-117 60-25 35 70 79-11 62 94 120-83 84 113 134-31 272 9 24 41 65 18 44-60 141 61 17-25 84-2 18 31 80 18 332-6-11-37 83-1 82-49 48 15 12 26 158 14 74-29 85 25 243-5 3 46-29-5-5 30 108 51-15 26 125 57-22 22 95 57-5 22-170-12-2 28-264 29-288 82-5 34-49 12-20 68 76 46 62-14 55 59-32 24 100 85 102 37 28-25 79 57 165 79 100-12-9 21 107-3 150-61-14-12-66 24-3-9 62-59 91-61 217-13-1 4-29 11v17l-33 10-27 13 14 25-62 72-19-11-78 99 148-17 14 21 44-7-16 39-41-14-113 98 20 55-25 38-67 14 32 32-51 52-26-76-88 49 5 54-76 6 11 30-126 108 49 103 195-36 5 13-163 49 14 45 48-3 5 10-151 40-95-30-18-31-74-14-62 23 2-72-65-64 58 13-37-81-330-122-51 30 58 41 10 24-196 29-63-28 69 181 79 57 5 177-147-97-60 18-119 105-42-16-122 51-175 65-134-9-77 12-20 40-33-8-6 36-36 4-44-67-29-22 26-98 43-23 86 18 64 35 85-29 10-83 150-22 233-159 57-93-17-38 21-47-103-76-50-19-368 88-11-12-47 41 21 9-67 58-34 42 12 29-47 71-24-2 15 59-238 20 1 19v2l-25 13-82-133-101-45-264-221-51-82 13-41 149 20 83 40 157-71 15-59-2-83 70-71 220-8 150-115 1-57-118-124 21-41-19-25-77-31 3-8 74 29 97-1 57 36 137 157 130 52 114-7 60-82-24-66-78-8-31-34 17-23-20-76-57-98-413-188-55-9 32 71-19 32-38 11-25 32h-11l6-26h-25l-8 59-29-9 16-121-18-22-198-46-48 10-83-49-10-90-170-59-35 16 14 47-42 28 5 41-12 32-40-4-12-82-49 21-23 86zm2446 1345 31 25h78l108-42-54-78z"/>
			<path id="Great_slave" d="m-10182-4697 7 29 21 28 37 34-34 17 14 50 40 6 30 39 53 13 89 118-10 29 63 75 71 53 53 87 7 68 148 10 48-52 12-60 29-16-23 52-7 46 15 4 8 27-28 69 30 70 33-1 66 90v46l64 42-42 7 28 55 79 76-35 6 21 57 68-7 17 7-2 35 101 12 8-26 26 6 47 31 3-24 43-6 9 24 93-3 157 17 72-50 72-27 18-21 124-51 29-38 25 2 44-26 31 5 58-83-1-11 63-73 12 3 32-23 2-22 39-69 33-33 34 8 45-49 167-81 87-15 127 6 30-7 111 21 113 42 72-11 10 8-26 17 141 49 1 35 55 16 2 32 87 25 25-8 128 106-38 24-15-3-62 34 31 15 25-19 3-15 28-1 39-23 19 17-46 17-7 49-56 31-49 2-57 43-35 16-7-9 57-131-44-24-45-14-65-44-132-109-131-19-88-27-29-24-32 7-75-36-50 28 67 9 36 42-14 6-189-23-136 43-142 22-28 19-6 33-79 86-74 120 56-39 56-74 59-48 76-25 20-47 24 7 48-2 15 13 154-5 18 15 59 1 67 31 14-6-13-36 31-11 28-41-27-38 5-17 29 3 1 32 113 30 14-12 146 57-9 17 18 22 29 14-7 4-38-18-18-18-166-41-70-37-46 51 16 32 56 9 161 48 135 50-61 1 7 10-40 27-101 29-29-15-53 4 4-25-92-17-63 32-28-21-110-32-11 10 58 34-17 21 21 10 96-13 60-17 23 14-144 36-64-4-25 74-64-2-24-44-99 7-55 45h28l-3 17-92 7-42 42 61-23 10 9-159 85-67 11-32 57-37 2-42 34 58-8-14 27 54-11-10-18 61-7 19 21-40 23-79 60 10 9-145 46 17 16-51 33-16-9-202 153 6 28-248 82-50 25 13 10-49 34-3-13 21-26-75-19-5 39-43 9-30-15 26-30 22-4-80-79-62-2-82 9-206 107-30 50 28 120-37 66-73 50-128 8-59-34-54-53-117 33-68-11-26 16-77-9 1-24-24-12-167 16-34-12-54 17-101-20-90-40-25-37-34-12-56 5-71-34-35-53-83-63-54-94 6-47-26-15-33 2-91-65-121-57-72-44-19-61-15-41-1-38-32-45 9-29-55-52-2-32 16-8 7 30 24 29 95 140 91 81 58-36 54 5 40-5 31 21 16-13-32-101 28-27 56 35 23-3 13 18 26 3 10 47 40 31 68 15 98 142 24 7 7-19-25-47 38-12 50 10 20-38-54-87 61-9-44-20-30 13-13-11 39-19 32 17 1-33 37 8-19 29 23 12 4-13 75 1 13-20-28-6 19-21-5-53 32-6 89-122 53-1 12-24-30-12 35-40 64 5 75 20 26 28-15 27 29 2 26 25h32l6-20 58 18 14-18 15-4 22 8-15 14 32-3-5-19 9-5 38 13 52-25 1-10h-46-1l-5-12 41-13 9 15 27-3-8-22-28-3 1-15 52-32-8-23-37-9-21 7-5-14 17-14-9-40 15-15-23-29-24 2 9-41-28 2h-1l-8-15 8-9-34-44 12-7-2-10-10-5h-2l6-17 29 3 3-11-24-14 1-13 25-3-30-51-28-5 12-37-40-7-46 6 7-28h15l18-14 5-25 20 2 17-16-16-18-19-10 50-126 22-9-16-22-37-20-60 8-43-16 1-14h-39l-36-18 22-21-19-13 37-32-8-23 6-17h-19l-14 14-21-3 30-50-9-13-21 5-13-13 13-10-6-10-28-17 16-13-35-54-17-9 2-18 24-14 4-22 38-18zm1313 1540 137-61 274-86-528 85-93 41zm-6-235-47 7-23 51 87 10 156-38 53-49 63-14 59 10-8-36-155 16-48 28-164-18zm493-64 104-32 7-116-19-21-27 20 10 25-124 112zm-613 462-5 24 27 20 77-6 109-29-59-63 34-16h49l43-73zm3-122 21 29-31 24 45 32 76-37-3-16 52-34-80-33zm459-208 58-5-5 11-87 19-2 7 138-26 1-12 67-34 33-38-47 2-126 31zm442-231 35-52 73-43-7-22-139 88-35 48z"/>
			<path id="Huron_michigan" d="m10472 17756-80-111-49-113-61-236-67-126-34-109-41-134-40-82-26-28-82-115-49-24-70-14-36-15h-1l-38 4-48 34-20 54-38 5-13 14-101 45-24 64-53 19-26 1 1 9 50-5 13 21-41 57-7 35-7 4-44 126-18-25-31 59-76 126-53-32-92-14-4 5-3 1-51-22-49-76 13-31-5-161 35-89 63-14 26-17 41 8-11-39 15-34 34-17 34 6-17-36 13-37-10-53v-71l8-43 21-28 36-5 16 14 10-32 30-54 28-7-5-87-11-43-5-112-19-73 13-56-1-63-26-34v-22l-45-128-64-17-45-30-28-107 14-29 41-27 14 30 81 15-17-22-25-5-25-97-39-22-63-90 20-1 6-20-65-47-76-28-8 12-65-8-77-42-45 15-56-25-54-35-37-13-72 12-32 11-33-14-15-29-11-31-79-67-97-18-32 15-35-12-12 10 17 13-6 8-30-3-87-50-135-45-13-23-32 3-15 13 11 13-12 25-104 6-56 7 50 25 6 23-38 64-44 33-29 66 3 37 32 77 58 42 91 1 9 30-94 50-74-1-53 22-51 60-21-5-47 63-7 43 9 53 30 83 1 99 8 63-20 87-22 90-25 25 3 32 1 2-14 30-40-8 9-30-2-40 14-21 23-25 3-42-7-77h16l-16-37-12 5-20 22-1 45-22 45 10 12 2-16 19-1-3 24-12 16-16 56-5 57-32-6 1-24-19-43-5-45 11-51 16-5-6-73-7-2-18 31-14-6 11-34 20-22 6-43 9 13 8-2-53-90 38-37 20-24-1-17-8-20-13-2-13 32-18 12-19-6-29 79-16 55-31 26-18 51v37l-24 42-44 14-23-23-33 1-22 73-20 10-29-13-23 12 14 98 3 61-8 35-118 56-3 47 43 99-6 104 7 60-3 92-44 119-51 153-46 49-18 30 17 33 34 44 31 96 27 80-1 50-45 95-19 60 14 62 65 100 26 76 74 141 143 235 49 130 51 304-7 68 6 197-25 143-33 120-88 157-68 252-36 57-93 103-109 95-154 97-125 46-78 2-72-17 19-37-18-12-35 28-51-42-17-40-71-102-93-255-36-27-75-97-49-115v-74h10l-2-125-16-49-10-83-12-44 25-110-10-48 16-25-47-40-32-46-14-99-16-31-32-29-7-35 24-38-15-29-26-40 13-41-36-93 14-68 5-93 43-83 5-35-9-80 57-148-10-54 6-38-32-49-15-80 21-131 22-66 3-64 71-62 20-36 2-47-15-41-18-33-9-35 14-58 18-206 40-90 34-103 6-43 8-43 22-33 8-37 49-41-13-36 32-31-15-14-3-26 13-37 22-16 5-63 14-5 5 15 14-2-1-19-16-11 4-13 23 18 5-46-28-26 6-14 23 20 11-15-16-93 41 13 3-77-16-19-44 20-18-10-4 49-20-5-10 44 4 35-35 10-7 44-42-19-24 143-14-3-29 49-36 124 22 19 6 62-52-60-32 44-15-2-28 23-31-9-27 21-71 132 6 37-25 56-92 61-36 90-58-8-32-30 18-14 1-92 16-82 36-71 9-40 26-20 19-62-12-41 25-33 70-22 72-19-8-80 6-28 19-14-24-45 14-38 100-171 65-148 45-163 54-122 46-33 45-68-25-13 9-90 29-19-15-11 23-60 26 13 5 21-38 58 14 24 34 149 18-31 75-36 45-97-20-61 30-15 22 27 61-5 52-77 22 18-19 99 22 19-5 8-47-9-14 60-37 51-9 18 38 51 64 16-27-61 29-10 2-54 38-1-1-39 55-18 24-45 46-10 7-128 79-74 44 3 47-21 72 7 75 27-10-39 79-41 43 10 78-11 37-85 64-79 45 5 16-20 38 23 27-22 115 30 47-7 96 26 46 27 54 58 19-2 62 55 15-5 46 26 38-18-39-66 19-7-25-24v-27l34-12-13-61 14-31 44 18 57-1 16 54 1 1 15-4-4-25 21-3 3 13 15 9-3-36 23-4 66 26-4-23 70-8 57 9 54-21 47 10 56 14 8-21 55-15 6-16-4-26-33-21-20 3-5 14-91-79 30-41-75-25-49-8-31 26-26-12-13-37 36-24-3-19 20 3-13-31-27-20-6-48h73l11-10 17-19 31 24 91-32 34-10 15 33 59 4 21-12 70 21 61-28 36 29 15-7 329 20 20-18 32 9 4 17 178-46 79-33 64-28 2 4 1 1-35 25-1 29 38-5 64-22 38-26 23-23h10l7 23 67-22 39 8-41 10 68 24 10-14 40 2 64 28 56-19h79l68-18 119-38 10 14-24 24-24 20 23 35-3 15 22 7 7-52-20-9 86-23-16-16-13-32 36-7 28 14 36-2 1 17-18 12 5 10 22 3-66 43-23 1-39 30 4 6 25-11 32-21 34-18 58-23 6 9-30 19-22 6-69 30 4 3 83-14-56 57-36 25 21 2 35-26 57-61 17-18 9 2-1 14-19 34 12 23 48-57 224-64 10 21-26 63 45 8 11-32 116 3 45-18 6-18 16 5-7 16 96 6v-35l21 5 35 80 18 24 72 42-20 33 173 175 53-38 36 4 19 117 16 26 53 1 11 48 19 24 42-9 15 11 18-15 33 14 6-10-34-24 13-35 30-21 35-3 44 64-36 2-5 36h-59l-24 21 8 47 41 50 18-27 28 24 1 43 35-21 26 32 47 34-77 12 62 54 34-3 7 27 79 48 23 48 25-39 41 16 9 23-13 10 24 23 22 41h33l-11 30 48 19-3-15 15-1 10 14 3 26-13 33-18-30-9-2-17 40-18-33-25 15-6 18-16-9-12 7-5-16 17-20-20-28-40 16 5 13-7 8-9-20 27-43-17-21h-31l-55 29-10 43 9 14-21 9-9-23-33 24 12 66 84 9 57 58-5 76 16 14-5 67-28 53-36 30-72-26-84-14-11 16-36-10-41 7-99-40-27 9-23-7-49-26-36-91-84 18-50 49-27 81-26 15-14 47-9-30 10-173-16-32-19-13-23 12-25-10-31 8-47 43-35 49-2-38 66-94 8-42-23-13v-28l43-50-32-13-28 6-19 21 8 26 20 11-26 10 5 20-27 9 7-16-7-13-15-1-27 33-10-9 29-42-12-20-70 16-7-10 12-36-25-6-13 27-31-32 4-12-6-51-28-40-25-1-21-19-7-50 24-38 5-18-17-15-66 19-67 25-47-5-92 7 4-10-38 14-24 48 5 12 18-2v15l36-9 3 14 42-1 12-19 8 5-2 42 55 32 26 39 32 33 9-6 48 74 34-36 11 9-2 22 18 2-6 53 39 57 57 55-6 12 26 38-8 17 3 14 11 1 10 34-23 4 9 19 25 20 11 55-36 81-41 144-51 30-36 91-13-3-18 34 17 24 1 45-13 98-65 130 33 57 7 46 21 49 7 29 31 180 61 199 16 121 22 71-10 54-26 59-75 83-69 54-32-3-3 20 15 10-56 106-32 24v26l-44 41-129 57-29 21zm-1249-3167-20 49 11 49 103-11 22 25 19 2 3-16 28 16h35l2-14 43 34 36 7 16-31 25 20 16-15 28 22 18-13 22 6 14-16 49 25 89-8 38 41 46 2 6-14 53 12 10-6 18 4 6 16 18 7 9-13 13 3-2 16 40 8 56 27 60 5-20 18 34-3 1 24 51-13 47 7 13-28 12 6-3 13 69 20 36-36 28-77 53-118-23-7 48-66-3-59-91 37-14-14 39-46-9-75-32 4-47 157 3 23 14 21-12 16-13-26-26-6-17-42 11-81-81-7 7-73-22-26-52-3-98 104-9 107-62-95-4-29-19 5-15 41-23-14-12-70-111 62-6 42-22-26-19 1-5 47-35 1-18 38 44 24-5 41-19 1-7-28h-11l-11 32-21-1v-1l-18-42-66 53-18-54-22 4-43-21 19-85-9-15-52 51-25-2-26 18 6 13-38 28-6-22-50-9 2 49-33 2-9-32-20-9zm-609-11 32-12 7-76-10-13 18-15 45 23 6-68-7-12h1l13-18-11-19-20 14-34-42-29 14-52-61-37 14-31 27-25 6-17-21h-27l33 88 33 49 57 28 14 20-10 12 36 29zm416 32-2 28-18 14-13 48 19 21 3-3-6-18 8-8 93 40 34-30 26-48-9-57h-11l-3 9-7-1-7-9-7-1-7 8h-11l-15-26-11-9-42 20zm-264 89 11-26 23 15 69-22 49 21 54-3 25-90-56-19-52-79-47-7-55 12-10 22 51 8-14 41-18-2-58 74-38-39-14 67h3zm1389-349 52 10 38-21 93 10-4-20-63-23 9-20-26-28-104 44zm-580 219 83 19 46-46-12-51-88 23h-1zm1069-277 5-12 59 19 6-10 36-5-3-31 15-5 12-26-155 45-31 14zm-3222 850-24 63-6 100 14 20 58-6 32-37-4-52-22-80-21-26-37-4zm-1035 596 75 3 8-88-84 6zm1774-795 87 66 78 9 28-60-122-27h-59zm2245-724 36-7 12-10-4-10-23 4-15-6-24 9zm-36 705 32 32 51-59 12-66-57 26-32 37zm1402 417 33 32 44 17 5-8-28-25 23-24-28-48-28 24-28-19zm-4652 529 14 43 48 42 33-14-20-18v-47l-16-31-48-3zm-52 160 26 5 27-15 5-33-42-15z"/>
			<path id="Manitoba" d="m-3070 9021-4 44-35 20 24 12 2 34-14 31-20 15-19-154 40-20 1-22-30 4 19-69 70-83 23 35 61 4 28 90v-1l8 60 51 68 1-81 7 2 8 37h19l-11-71h-14l-8-85 31 23 6 46 42-2 17 97 33 240 13 7 6 47 17 40 10 4-3-45 9-44-9-130 10-87-11-5-18 21-5-36h-16l-20-57 11-3 7 11 3-47 14-7 41 32 43-34 33 133 14-1 23 33-45 42 15 70-29 15-12 72 10 4 9-16 36 112 28 14 74-1 15 13-22 34 24 37-41 36-31-13v22l-17 6-7 38 17 13 7 28-46 6-21-69-7 2 6 54-23 15 19 19-25 9-7 33 24 33-17 5 16 39-19 28 42 41 59 1 39 11 16 18 19-5 22 5 21 34 15 2 99 113-5 14 12 27 22 3 13 35 54 71 12 107 27-12 68 111 10 90-42 46-46 14-8 22-26 28-46 27-51 20-53 14h-53l-47-13-47-30-37-38-10-30 9-74 13-25 33-6 8-32-47-114-4-59-22-24-1-19 9-20-54-119-13-58-76-132-3-67 23-12-17-29h-17l8 32-39-9-17-117h-20l-19-71 15-32 17-1 29 87 30 2-17 82 28-6 31 20-12-68 50-30v-21l-26-9-32 40 6-62-10-38 25-25-3-96-67 61 12 43-16 2-6-23h-12l-35-92-26-3-23-93 6-186-44-14-21-32-20 39-24-7-7-113-10-6-25 44-3-25-40-22z"/>
			<path id="Nettilling" d="m10098-8795-33-61-52-42-23-55-23-18-129 30-5-36 104-22-32-125 11-7-4-32-19-67 35-13-33-158-60-8 3-36 56-34 53 3 15 28 25-33 18 2 14 14-11 37 38 21 22-11 52 4 23 63 53 53-12 38 21 12 20-37 40-9 66 19 96-50 56 13-1 19 93-21 17 31-24 53 15 21 71-78 17 6 22-15 68 19 17-43 33 18-97 123-56 54 64 15 28-20 24 4-5 18 19 17 27-33 49 13-2 52 2 5-57 57 22 62-43 45-8-49-38 72-67-43-16 40h-65l-50 107-80 8-12-47-87-30-26 22 36 29-10 137h-40l5 96-21 12-9 83-27 76-57 22-17-14 10-10-18-31 81-83-12-34-69 46-25-28 35-43-18-53 9-59-23-11-18-72 10-11-32-36z"/>
			<path id="Nipigon" d="m4307 10852 77-21 19-39-31-10-17-30 27-19-43-9-28-27 15-28 39 11 35-122-10-42 43-30 34-39 4-39 50-12 46 28 8 49 35-51 75 35 14 66 32-4 52 31-5-67-61-38-53-41-16-32 75-4 29 59 26 12 33-1 71 111 4 27-19 13-18-4-11-40-21-12-12 19 25 29 12 42-12 70 33-9-1-27 18-34 55 57 24-15 50 37-5 20-62 10 3 24-72 14 1 21 77-8 5 98-41 21 41 48 14 121-51 64 25 63-12 41 23 17 16 53-3 55-22-72-27-31-40 26-59-16-46 135-21-6-29-59 12-47-40 38 5-95-24-15-3-35-36 3 14 54 17 6-4 60-41 50-62-22-13 11-77-55 45-53 9-75 14 14 31-38 30 26 30 1 4-49-35-28-73 62-13-38-18 6 3 57-22 54-102 52-15 24-26-76-23 27-34-75 44 6 33 51 44-6-3-99-47-73 28-76-29-6-34 83h-14l-9-32-9-15-4 46h-8l-6-63-10-4-5 23-23-7 3-93 32-22 8 64 36 6 7 24 50-55-24-46-22 4zm191-26-36 37 53 24 17-11 79 51-26-62-37-33 16-21-7-2-37 8-17-29zm194 313 67-13v-99l-64 38zm-156-392 23 24 52-109-82-7z"/>
			<path id="Ontario" d="m15380 14696 6 2-16 36-6 49 29 23-36 56-110 204-103 95-69 85-32 45-18 36 12 13 8-7 7 6-10 18 58 2v36l17 19 5-6 18 8 4 12-7 26 8 7 14-13 16-27 7-41v-13l-12 5-47 33-2-30 13-31 15-10 18-20-4 23 10 2 22-17 29-3-17 35 12 3 10-16 16 2v11l-16 27-27 14-11 27 15 10 30 3 20-13 29-48 24 6-1 18-18 1-30 51 26 43-12 12-9 1-28 38 3 18-29-8 4-18-8-5-26 10-17 36 5 19 65 23 34 57 43 100 21 108-11 37-44 30-37 12-21-9-37 17-35 42-7 23-54 50-41 54-30 90-25 11-26 37-90 51-41 42-163 26-162 57-105 63-10 17-17 12-20 1-88-26-58-32-45-10-100 17-70-3-149 33-271 72-116 51-148 86-119 79-51 30 8 3-4 3-5 2-8-2-44 14-83 77-74 55-50-10-64 21-80 7-40-17-24 12-83-10-72-24-1 15-25-2-15 12-9-11 64-60 49-76 19-67 38-89-4-36 33-76 28-14 9-22 5-31 18-8 21 5 78-53 27-25 29-50 30-59 20-15 35-70 19 1 57-39 36-36 20 1 72-44 77-19 38-38 37-20 102-23 75-59 128-64 67-23 15-14 37-12 35-2 24-25 28 1 45-21 26-31 66-35 20 21 1 2-1 1 40-24-5-5-26 8-15-11 20-22 18 14 38-21 21 10 121 63 51-22 56-39 44 25 26 26 25-22 25 18-13 30 28-4 16-21 21 10 11 20 41-41 30-42h12l63-49 56-43-9-13-52 37-18-7-19 14-25-2-2 25-8 12-11-8-1-33 10-20 12-46 19-26 36-26-2-24 14-30 18-25-1-19-6-5-26 25-24 49-34 27-30 24-25 1-36 4-12 10-10 38-4-26 11-40 9-36-2-81-10-11-60 46-34 18-29 18-34 35 8 24 22-12 2 9-34 21-23-5 7-61-10-10-40 29-13-6-14 20-63 45-45 71-26-6 14-40 164-128 33 5 45-42 21 22 92-52 24-23 22-15 4 13-10 13-3 88 28-21 5-27 32-37v-11l21-15 33-2 10 15-40 17-48 34 2 12-1 23-42 41 44 1-20 23 9 3 59-34 14-44 99-127 57-59 6 9 38-27 3-22 8 1-1 18 43-1 55-31 84-70 60-72 42-26 22 4 4-13 66-60 30-6 77-60 52-144 40-87zm-474 602-3 21 25 1 10-16 14 4-5 21 32 17 50-113-19 5-15-14 121-58 15-25-62 21-16 25-7-4 6-15-10 2-4 15-26-11-43 22-32 33 14 7-31 28-27 34zm-204 128 66-34 35-89-23-4-108 94zm295-264 35-8 61-60-3-25-52 21-42 58zm156-40 35-39 12-35-14-11-42 36-11 22zm73-110-10 26 21 10 43-57 10-40-8-2-38 57-7-6 21-30-22 1-33 36zm32-42 17-19-11-7-31 28z"/>
			<path id="Reindeer" d="m-4386 2266 109-185 43-15 27 63 72-46 7-67 43-49-34-68 22-38 24 24 30-25-29-46 75-3-70 179 54 27 18 67 76-79 22 20-92 101 61 29 35-52 81-16 37 55-91 132-86 137-85 31-9 45-102-2-8 119-43 26 58 46 53-6-2 67 29-36 37 32-1 38-19-8-7 21-27-1 4-33-52 49-33 15v34l-18 20 7 58 24 22-10 19-28-19-20-51-48 28-6 131-61 34 8 48 26-38 65-42 13 10-38 31 19 19-27 52-32 11-54-34-64 93 42 9-5 27 30-26 12 9-25 47-47-21-43 35-34 55-15-13 4 37 46 12-9 19-43 10-28-28-27 19 3 49-54-15-38 13-17 28-52-12-30 41-48 4 26 46-14 48-39 22-40-13v-1-3l-20-96-102 111-16 6-10-32 107-173 56-197 30 12-39 100-33 150 114-45-4-35 24-10 11-68 23 45 60-36 32-65 43 5-18-37 51-27-15-29 20-19 27 45 20 2-9-126 49-27-28-38 14-21-1-56-26-2 24-61-12-13-23 9 9-27-13-26-55 36-5-25 52-40v-20l-60 1 73-63 5-41-54-10-10-31 26-31 28 10 3-46-43 6v-49l-87 39-8-44 30-29-17-41 139-59 39-83 13-57zm-159 257 97-54-25-42-84 31zm371-276 72-41-8-46-26 4 7-68-31 23zm-220 312 25-51 18 1 23-42-54-4-40 77z"/>
			<path id="Robert-bourassa" d="m11276 5444-24-58 40-8 36-19-5-23-25 19-31 5 27-34-53 3-19 20 34 20-40 3-87-48 155-175 54 14 116-27-6-30 104-47 127-159 27-75 31-38-73 14-131-26 37-53 76 34 79 3 33-56 61 3 2-84-70-31 61-59 141 16 40 35-81 26 24 25 22-4-9 22-32-5-44 27-3 37 52-26 18 8-14 43 74 10 5 17-72-3-32 36 31 2v23l-73 1-57 85 48 4 5 71-105 37-63 135 85-3 159-90 157-46 34-45 68 11-19 12-22-1-100 70-73 1-32 53-95 58 61-1 45 27 104-88 53 3 2 27-301 195-10-8-129 84-230 16 11 40-58 3 4-28-61-6zm459-556-30 49 14 6 50-61 23 5 79-144-10-6-44 55-5 31-58 4zm-159 463 18-24-8-9-29 22-1 1-23-10-14 27 14 14-40 11-9 18 66 5 120-13 86-84-27-12-50 30 3 20-21 26-1-42 36-40-37 1-80 69zm-151 47 11-45 33-19-40-6-88 58z"/>
			<path id="Smallwood" d="m18742 1364 105-25 75 47 67 108 37 14 21-35 207 103 80-53-10-61 41-48-53-6 8-33-46 4-5 31-35 8-14-33 57-36 127-235 31 4-17 79 59 60 51 22 44-21-13 90 10 33 38-13 13 26 44-7 24 66 38-14 27 28-26 58-79 43-21-39-189 115 56 17 137-33 5 19-174 50-19 54-57 14 16 41 41-16 7 28-43 17 10 35-113-1-82 76-130-171-195 55-49 51 94 31-58 57 45 26-154 102-146 138 82 6 8 43-125-17-59 45-91-28-28-73-50-50 9-45-52-58 94-85-38-46 39-10 121 49 105-31-77-42 20-17 69-52 84 12-1-22 57 2 4-23-165-51 12-107 55-45 24-7 70 119 21-27-38-55 37-7-50-95 45 1-80-76-34-210-44-18-2-24 90 8 7 37-25 13 29 45-19 14zm135 328 61-15 17 15 81-39-6-36-107-24-52 12zm167 85 50-24-31-58-83 36zm367-270 26-13 17-32 6-27-52 14-43 40zm88-16 56-60-40-6-51 46zm-94 101 45-25 3-33-83 20-23 32zm69-252 59-47-80-16-24 80zm-124 44 64-45 4-58-81 71zm-551 508 49-26 11-26-23-18-72 42z"/>
			<path id="St_clair" d="m10177 18583-5-12 16-4 28-46 5-58-16-37-5-48 26-66 46-8-20-38-27-13 12-42 31-11-1-10 40-35 24-3 22 11 22-3 7 25-15 25 2 2 11-4 15 6 14-5 39 3 10 9 5-5h12 3l-39 60v23l20 24-9 18h53l26-30 8 4-13 19 33 13 30-15 23 87v84l-22 36-30 11-51-2-39 27-98 26-167-19-23 2z"/>
			<path id="St-louis" d="m17056 12061 25 6-6 41 21 25-103 130-67 18-50 100-82 53-7 120 15 58-6 39-18 34-45 97-27 79 23 130-24 89 61 100-12 38-42 6-44 24-36-6-57 42-33 101-34 22-34 105-27 28-35 19-69 13 1 27-39 44-40 15-71 81-30 114-43 19-80 68-17 20-25-1-9 11-29 12 2-16-4-10 41-23 23-25 31-13 51-51 26-101 169-199 6-51 88-34 53-52-35-19-44-54-41-13-147-17-71 12 44-47 61-17 19 30 72 21 70-47 20-54 38-32-9-26 30-38-1-26 21-23v-31l22-52 18-8 10-17 27-5 37-13 32-25 18-6 20-22 18-3 41-149 21-22 25-94 16-95-9-61-2-86 17-36 65-56 44-86 34-68 31-6 51-58zm-438 848-29 24-39 13-26 4-9 18-19 8-20 49-1 32-20 24 1 24-31 40 11 24-4 14 100-19 49-76 6-86 49-97zm55-21-23 9-61 105-6 87-50 76-64 13-4 14 7 15-29 53-19-15v31l-20 24 33 28 98-86 143-14 36-93-18-20-6-36 9-59-10-25v-36l-13-42z"/>
			<path id="Superior" d="m8139 14203 10 1 1 16-13 17-16-11-51 43-61-76-139 69-163-10-26-45 25-28-27-77-8-102 39-81-211 52-198 124-268 21-165 65-55-14-231 174-119 165-64-59-46 5-10 46-48 6-104-96-87 51-180 18-230-295-243-107h-144l-94 43-45 78-4-2 26-74 56-53 7-33-78 48-72 83-70 129-28-7 17-213 45-67 66-164 143-187 83-55-13-59 179-32-5-44-61-27-86 2-98 10-135 45-148 106-104 152-59 30-164 157-19 74-44 50-104 9-55 79-85 67-82 49-60 2-83 32-38-12-46 9-80 37-138 158-90 34-114 58-17-4-78 58-57-31-25 16-147-83-140 99-29-17 24-67 40-43-25-67 55-77 37-81-65-67-34-5-34 32-36-9-58 69-95 49-25-22-127 89-152 51-174 83-47-1-77 18-62-50-44-62 210-168 108-100 71-92 77-51 141-170 80-122 188-195 158-125 97-70 332-135 193-109 99-77-10-14 23-11 14 14-9-28 23-22 4 18 37-12-7-11-5-12 89-44-22-9 121-103-8-17 19-26 8-25 8-81 33-50-13-57-13-73 40-54 142-59 130-85 18 19-51 114 9 7-20 54 6 7-13 30 8 7-4 7-20-5-24 71 3 3 14-19 15-1 109-51 25-87 34-92 1-125 57-23-12-55 27-21-35-41 4-44 34-42v-33l31-6 25 12 32 5 37 24-12 22 30 25-16 97-49 50-83 114-19 48 11 56 16 38 17-56 18-8-9-21 9-38 8 6 26-65 9 9-3 15 26 13 62-56-11-11-13-1-13-59 9-5 40 57 23-33-6 42 18 5 54-79 32-78-14-38 9-37-13-24-16-1-75-34-18-33 6-63-29-20-7-33 8-8 12 22 32-10 17 9 47-49 27 13 11-30 18-3 18 43 72 38 16-15 46 30 25-19 15 4 9 24 22-15 49 6 23 42 34-11 1-1 7-13 36 2v46l99-20 18 29 73 6-4 29 64 6 24-12v-23l13-4 14 21 108-24-12-33 20-1 34 32 32-1 30 27 106-78 68 15-13 53 70-1 27-43 48-19 42 41-9 12 47 78 28-10-16 46 29 10 21 25 149 351 60 85 86 96 83 71 100 44 131 3 155-26 49-43 336-55 22 40-68 125 47 27-70 103 25 19 4 18-34 82 77 37-6 20 137 54 82 76 2 25 25 14 16-8 63 77-76 127 18 17-29 32 28 40-46 73 4 65 65 32h-1l9-22 38 7 7 39 34 31 19-67 25-1 24 23 19-25 26 3 72 28 16 26-33 68-35-31-80 45 24 19-17 69 18 60 27-16 6-59 21-20 31 16-5 36 23 30-41 30-65 110 5 39 52 33 16 33zm-2998-2097 3-50 68-38 75 7-6-45 31 16-1-70-91-12-75 4-75 66 30 118zm1659 885 169-10 82-43 13-32-77-10-35-19-83 15-74 69zm-2450 95-15 36 54 30 187-101-3-5-72 22-3-20 135-97 57-17 41-25 69-66-11-33 109-114-3-5-79 46-160 97-11 24-55 28-233 146-31 54zm970-1135 27 39-21 21 44 16 65-22-83-95-33 11zm-979 768 42 5 51-42-22-37-71 29zm-1007 1533 15 14 50-23 21 10 25-48-17-15-79 35zm140-89 46-44 3-55-38 10zm-225 287 45-43 52-11-15-30 77-37-38-33-87 93-40 20zm3168-40 16 10 3 44 40-2 22-25-36-11 10-54-22-25-47 21z"/>
			<path id="Winnipeg" d="m-2807 7325 61-212 53-31 99-287 4-30-25-66 32-16 20-28-12-38 29-26 72-6 65 12 6 47 208-12 106 48 110 93 16 52 83 6 48-17 7 62-22 29 101 160-12 72 68 90-16 28 10 38 99 118-26 21 32 126 58 36-1 12-45-9-20 52-25-13 63 227 76 73 6 73 70 169-7 50 44 11 3 34-21 15 22 12 1 20h-17l-25 22 27 6 31 55-19 34-49 1 31 92 52 64-3 49 57 47 44 91-48 78 75-3 40 52-15 56-51 10 42 54v15l135 184-40 42 90 164 49 20 90 151-69 7-28 35 35 40-58 22-3 2-4 26 28 42 27 303-25 55 20 57 61 63-7 12-35-35-43 3-97-79 3-34-13-10-20 23 15 26-42 26 13 82-39 33 42 123-57 50-81 10-11 93-44-7-40 7-26-138-28-162 29-29-25-22 5-182 29-43-12-33-18-21-3-34 26-34 21-53-23-72 35-46 38 5 18-91 50-66 74-35-13-9 58-82-72 7-21 16-5-14-2-1 20-24-5-15-35 41 10 11-98 125-50 27-22-40h-2l67-106-22-23 138-211 20-79-66 10 29-82-40-9 6-69-21-8-99 86-72-8-23 144 11 13-5 30-64 63-40 7-11-22 1-39 11-43-19-56 4-76 22-18 35-190-74-239-57 3-39 30-30 52-8 60-31-1 9-66-26-7 25-43 16 4 49-121-54-22-39 44-1 1-39-3-8-60-44 32-16 40 42 26-44 101-29 101-54-5-22-26 8-17-68-19-13-22 3-128-60-67 8-102-55-91-93-28-35-39-25-62 13-82-105-98-2-38-99-91-30-66 11-59-34-39-30-57 6-37 34-22 41-2 34-20 67-1 93-24 53-30 18-17-50-27-51 8-54-16-49 4-50-19-11 36-31 5-27-27-100 3-22-82zm804 758-1 13-28 16 6 31-11 19 18 27-28 10-7-20-10 1 56 166 19 5 30-64-14-21 7-11-20-33 10-31-18-118zm805 1556-33 91-60 9-2 48 47 29 61-47 29-104 39-60-8-5 8-10-5-4-37 25-7-14h-20zm97 5 100-24 55-41 16-50-39-2-101 47-36 49zm11-122 68-49-15-20-39 13-34 47v1zm-506-1125 51 1 31-94-17-15-60 58z"/>
			<path id="Winnipegosis" d="m-3966 7661 33-46-19-19-23 5-26-28 41-49 3-51 34-59-80-14-30-50 26-64 61-12 51 28-29 25 59 37 66-17 38 19 94-52-4-47 56 13 27 20 25 62 225 86 18 49 68 40 73 6 40 16-20 30 69 32-70 105 37 23-27 53 33 52-2 192-91 220-74 43 23 111-20 90 14 48 37-9-10 156-43 19-17 130 11 48 54 9 37-147 26 2-17 125 3 74 21 71-72-15-57 50 1-31-99-93 16-140 18 20 19-77-25-53 3-83-11-84-35 13-16 41 15 34 10 144-9 141-36 5-44-205 2-430 42-120 71-42 17-212-32 30-10-71 37-94-7-55-65 1-32-23 22-36-48-59-35 38 29 226-11 22-46-14-22-24 17-50-56-29-8-55 32-55-38-27 18-77 28 2-12-48-66 24-31-37 27-20-8-16-39 23-21-25-67 35 45 42 36 53-20 43-45 9 21 34-19 63-98 10-30-41-32-22zm618 496 24 48-7 41 14 15 24-5 57-248-54 27-18-14z"/>
		</g>
	</g>
	<!-- ~~~~~~~~~~~~~~~~~ -->
	<g id="BC" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-22032-7952a34499 34499 0 0 0 8818 5321l-2585 6234 21 34 36 19-38 54 64 42 16 107-32 22-80-70h-21l41 308 182 90 15 202 121 119 40-106 47 14 81 170-39 63 29 203 110 82-44 74 43 144-68 23 46 196-56 91 4 12 116 5 74-85 126 216-122 52 37 114 47 4 41 98 43-16 127 23-23 112 111 256-23 31 17 31 7 157 63 18 88-92 49 40 2 151 42 87-12 41 41 37 1 17-16 17 9 50 43 28-47 138 145 187-45 81 149 114 77 229-69 6 112 241 56-13 1 94-28 6 34 64-5 65 53-31 95 16 29 161 57 134-29 112 8 75-25 74 18 72-22 104-18-8-29 74 11 83-8 47-20 14 2 44-40 24-12 68-62-3 4 73 91 32-49 93-15 79 52 71 17 161 111 67 40 55-16 67 44 62-21 43 2 5a46541 46541 0 0 1-5926-2289l-14-23-18-20-33-15v-22l4-15 10-4 1 8 9-3 7-10 2-16-14-11-10 2-37-2-49-8-32 8-12 12 7 14-5 19a46539 46539 0 0 1-37-18l4-26 11-14-13-21-18-26 20 3 15-11 19 5 23-21 29-5 11-8 13-1 39 9 11 8 25-8 22-19-12-16h-10l-12 2-11 5-9-2-8-20-16-18-15-10-10-8-14-3-11-6h-17l-9-13-3-10-9-8-11-13-9-22-12-20-3-24 23-6 44 31h22l2-32h14l1 27 37 23 12-1 40 18 15 13 27 10 31 16 9 14 11-1-12-23-35-11 2-12 40-23 32-30 22-31 17-52-14-1-5 26-14 23-13 27-29 23-38 9-13 24-7 1-16-14-12 2-22-7-33-34-16-4-50-60-27-10-14 4 8-40 56-42 27-108 85-84 6-36 27 5 27-15-27-16-45 2-23 62-21 15-37-13-32 19-20-19-93 16 5 34-20 42-43 43-34-5-11-30-62-70-20-13 1-37-83-41-15-30 6-26-23-3-10-16 15-138-21-23 76-89 53-5 35 67-15 25 5 28-23 171-7 12 2 41 5 8 12-16-5-31 11-5 16-76 31-7 153 6-3-11-65-6-10 9-16-11-92-18v-35l49-20 1-8-39-2-3-74-22-47 19-2 81-74 6-35-35-45 5-54 25-14 35 11 40-11 66 1-5-12 47-16-17-39-3-35-74-119-9 20 54 96-1 34 15 23-46 22-75 8-23-6-39 9-12 29-1 75 29 44-37 39-13-13-31 27-14-18 8-74 25-32-3-21-51 53 4 42-31-23-18 20 7 26-45 2-94-39-1 26-11 8-29-52-42-15-22-18-43-61 15-48-81-183-7-128h31l20 10h56l-3-35 83-10 37-42 22-84-38-60 84-49 73 38 121-10 20-22-5-14-33 14-100 7-70-49-118 59-49 13-66-75 31-33 10-62-12-24h-12l5 27-12 51-38 25-19-22-3 21-23 11-12-22 12-27 33-15 54-100 63 4 37-15 2-24 31 11 23-8 31-57 28-28 6-26 25-9 18-31-7-35-16-14 5-41 40-5 27-17 16-23 41-8-2-41-25-11-6 26-76 48-21-11-39 21 17 32-14 21 25 53-27 7-31 35 2 41-47 36-46 4-14 31-95-2-21 60-68 11-18-37 7-19-15-22 30-36-24-5-31 29-19-40 27-64-28 5-1 28-35 28-36 6-43-26-54-25 96-77 7-31 61-77 40 5 30-24-19-22-11 26-45-1-40 31-42 80-99 86-66-8-27-113 70 9-23-22-27-7-94 14-130-83-76-72 5-20 68 20 12-28 40-1 149 22-14-22-42 2-91-17-37 2-27-17-10-16-2-49 88 23 30 22 78 16 77 38 45 3 82 37 34-35 20-14 37 7 31-27-5-69 28-18 39 28 70-55 10-86 18-29 3-22-39-57-10 28 12 49-14 7-2 38-20 19 15 42-30 27-18-2-5-13-30-5 2 14-38-2-28 55 15 19-14 35-25-14-38 18-15 36-172-59-21-30-40 4-76-27-1-26 17-21 152-17-4-15-73-2-42-33 10-28 32-19 18-25-3-16-20 27-22 4-24-12-10-23-19-6-8-12-38 2-79-20-12-10 3-14-30-21-3-44 103-19 21 35 26 1 57 33 54 44 25-17-9-19-18 11-41-35-52-27-41-39 12-92-14-13-22 18-4 71-103 21-34 7-33-26-18-47-29-14-6-20 61 16-30-51-7 4-18-5-17 13-22 4 1 14-14 15-24 11-34 7-33-4-24 13-107-181-33-7-34-49-34-127 66-72-98-42 2-68-19-6-22-49 38-61 22-12 33 4 66 11 12 13 8-5 16 14-25 6 78 44 13-15 97 40-38-44-48-28-37-30 13-25-106-35-51-22 16-46 58-12 37 18-10 25 51-41 62-20 14-22 33 1 65-103 143 22 27 18 12-12-43-36 5-12-8-7-16 18-37-7-13 9-11-16 32-33 10-35 18-19 24 15 61-54 16-33-81 72-20-20-26 30-23 50-56-51-54-25 104 85-35 29-44-17-54 51-71 35-80-49 37-80 39 8 10-16-57-48 6-72 113-195 111-2 41 27 50-68 84-69 69-11 21 36-25 31-1 3-58-36-48 39 11 16 38-30 18 20 59 17 20-38 8-68 128 10 128-37 65 55 25 60-21 90 24 57 25 174 23-12-37-189-16-43 25-115 37-26 106 24 1-31-114-20-34 22-101-69 5-41-13-17 32-17 4-27-14-26 24-13 7-47 12-15 130-28 36-3 34 15 35-44 56-20 1-50 18-29-10-35 21-11-6-12-18-7-12-62-13 6 18 89-27 40-6 56-82 48-52-2-130 27-45 76-40 1-13 13-19 4-37-20-16-85 2-47-14-84h-8l8 69 3 85 9 57-20 2-20 21-14-2-2 23-18 12-80-18-11 20-22 2-5-15-17-9-35 8-24-17 28-35 41-23 9 11 4-8-12-15-15 5-30 20-37 38-95 40-1-28 20-40-5-26 17-37 21-29 50 11 9-16-14-71 9-38-11 13-7 22 1 70-44-5-19 32-16 1-36-26 31-124 18-26 29 12 3-23 36-15 2-28-36 10v-17l-19 1-5 18-59 39-15 20-171 106-33-33 7-31 38-23 21-41 34-18 33 11 62-56 31-91 79-38 30-40 77-60 15 2 57 64 9 20 43 1 4-10-41-2 1-13-13-11v-15l1-1 8-18-6-5-8 10-6 18-18-18-22-31-29-8 39-57-2-19 31-39 58 12 6-9-26-6-30-16-22 9-22 30-35 5-41 27-55-29-31-51-19-1 1-88 67-148 3-41 21-104-45-78-34-107 1-57 57-92-3-108 25-35-7-12 15-6 21 35 26 21 49-22-13 93 36 21 19 57 36 81 119 10 7-26 38 56 62 26 23 52-12 49-42 26 4 13 53-15 3 42 31 39 11-4-26-41-16-173-96-50-26-49-28 18 1 22-101-18-6-70-39-94-11-85 4-58 73-46 7-60 131-36 31 52 52 35 9-33-56-22-43-66 10-23 59-30 23-39-18-17-22 28-50 29-128 58-69 15-101-6-51 24-91 17-112 196-24 9-22-2-6 39-9-3-23-46-72-312 7-135-24-95-27-149 11-93 71-107 71-62 40 30 45-23 70 1 37 48 34 18 10-11-73-74-74-1-58 5-22-20-47 5-10-43-16-33-18-16-6-17 9-39 17 11 38 2 14-50-1-41 42-31-6-9-35 26-60-2-18-12-2-28-21-4 1-37 38-65 41-9 6 16 23 5-14-44 23-44 26-22 14 2 12 16-4-82 26-8 7 27 8 56-6 63 3 74 18 111 1 39-7 27 20 62 7-5-15-41 6-28V62l43-26-8-6-23 15-10 3-16-99v-104l9-5-19-88 33-33 26-11 36 13 41 7 36 34 4 58 5-13 9-5-8 53 8 30 6 1 8 30 16 19 2-8-15-26 1-10-15-46 6-45-11-7-7-37-22-21-9-4-3-7 15-7 22-26 12-9 12 4-2-8 18-23 20-5 24 6 61-32-3-12-64 27-27-11 33-21 93-41 42-9 11 10 12 27-48 17 3 14 36-8 35 13 39-22 96 65 18-16-21 1-46-52-49-26-34-1-28-48 30-38 50-32 75-29 35-39 60-38 29 3 85-60 16-44-108 33-13 44-82 47-26 34-132 58-24 32-48 20-21-3 30-117 33-19 24-26 177-68-4-65 58-122-2-54 15-70 84-106-7-43 18-33 40-32 33-7 45-30 27-10 32-32-5-8-14 13-5-4 62-84 14-139-89-21-35-63-32-37 37-107-35-27-31-45-24-143-133-135-18-68-90-191-20-90-136-72 49-103 10-59 46-38-85-144 142-130-132-148 131-69 24-165-1-193 21-143 4-101 31-167 2-210 45-170-6-166 14-137 66-12-28-140-14-128 11-147-110-253 3-80 35-27-32-45 49-45 13-115-38-26-12-91 26-56-97-113 11-80 44-23-24-71 26-14 37-4 56-78-2-81-16-15-3-53 15-33-7-8-22-69-14-92-296-36-119-60-97-19 24 73-23 30-68 30-38-8-37-51-116 159-17-1-8 16-104 48-111-77-101 2-206-21-135 19-35-24 65-58 127-257-81-795 10-49 51-94-27-50-58-144z"/>
		<use xlink:href="#i-CA-BC"/>
	</g>
	<g id="AB" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-13214-2631A34499 34499 0 0 0-8064-955l-2814 11709a46543 46543 0 0 1-2867-786l-2-5 21-43-44-62 16-67-40-55-111-67-17-161-52-71 15-79 49-93-91-32-4-73 62 3 12-68 40-24-2-44 20-14 8-47-11-83 29-74 18 8 22-104-18-72 25-74-8-75 29-112-57-134-29-161-95-16-53 31 5-65-34-64 28-6-1-94-56 13-112-241 69-6-77-229-149-114 45-81-145-187 47-138-43-28-9-50 16-17-1-17-41-37 12-41-42-87-2-151-49-40-88 92-63-18-7-157-17-31 23-31-111-256 23-112-127-23-43 16-41-98-47-4-37-114 122-52-126-216-74 85-116-5-4-12 56-91-46-196 68-23-43-144 44-74-110-82-29-203 39-63-81-170-47-14-40 106-121-119-15-202-182-90-41-308h21l80 70 32-22-16-107-64-42 38-54-36-19-21-34z"/>
	</g>
	<g id="SK" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-8064-955a34500 34500 0 0 0 4271 747l-459 4145h2l-41 378 24 3-41 378 24 3-41 378 24 3-41 379 23 3-41 379 24 2-41 380 25 3-40 380 23 3-41 381 23 2-40 381 19 2-40 382 22 2-40 382 19 2-40 382 22 2-36 344 5 1-40 387 21 2-40 388 21 2-40 390 23 2-40 389 21 3-21 201-19 189 21 2-39 390 18 2-40 393 22 2-19 197a46542 46542 0 0 1-6231-1057z"/>
	</g>
	<g id="MB" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-3793-208A34500 34500 0 0 0 94 1L81 36l43 194-16 51-9 146 30 43-14 6-10 18 10 40 10 9 20 53-5 16 19 53-6 43-15 22 7 15-19 16 1 19-14 15 6 22-8 4 8 37-11 18 16 41-17 52 7 26-32 5 7 12 31 7 8 42 34 29 11 32 42 13 8 11 2 85 73 81 5 61 33 28 40-10 27-69 9-2 2-11 7-3 4 5 14-8 5-16 3 3-3 7 1 4-10 11-2 11 3 62 20 36-6 9 22 3-12-65 8-17-6-19-13-17-1-5 2-1 2 3 8 6 6 6 50 12 63-8 37 5 9 14 10-2 2-14 15-5-2 6 5 3 4-13 4-6 5 4-1 6 2 2 6-4h7l5-7 12 10 10-3-9-24 43 7 13 16 16-7 24 14 30-18 35 18 19 35 16 4 35-41 78-9 25 48 14 42-5 33 32 191 58 156 23 23 1 33 62 129 42 124-1 43 18 67 11 54v1l10 34-10 8-17 22 3 7 25-12 13 6 4 29 15 44 90 183 12 37-5 14 26 12 38 102 21 109-7 96-58 165-27 54-67 114-103 37 2 13 105-23 30-21 24-40 95-78 59-19 39-3 45-14 9 6 2 4-17 15-36 39-23 37-9 7-20 15-25 8 6 13 20-5 22-13 11-7 9-12-1-6 26-22 25-26 16-11 39-18 9 3 29-3 62-10 464-238 156-29 123 42 31-14 60 37 44 23 46 12 121 62 10 15 111 49 13 26 36-4 241 60 64-3 18 8 11-5 60 23 54 15 110 20L872 6807l-974 991-9 3817-1 429a46543 46543 0 0 1-4535-233l19-197-22-2 40-393-18-2 39-390-21-2 19-189 21-201-21-3 40-389-23-2 40-390-21-2 40-388-21-2 40-387-5-1 36-344-22-2 40-382-19-2 40-382-22-2 40-382-19-2 40-381-23-2 41-381-23-3 40-380-25-3 41-380-24-2 41-379-23-3 41-379-24-3 41-378-24-3 41-378-24-3 41-378h-2z"/>
	</g>
	<g id="ON" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m3578 3252 44-5 13-14 20 4 9 13 16 1 8 21-15 12 17 22 70 31 20 27 5 24 35 25 40 16h24l47 48 67 47 93 37 60 12 74 24 22 35 7 28 33 37 62 49 23 60 33 36 13 36 14 25 48 72 43 25-5 9-6 6-7 5-15 19-2 7 4 11 8 7 5 8-5 12-18 18-15 6 1 8 20-9 14-6 12-14 4-15 15-8 21-3 35-7 37 19 47 20 76 24 196 7 119 48 220 70 66 44 242 31 77 51 53 5 78 54 90 86 82 50 77-3 73 43 15 45-19 19 19 9 38-24 25-4 159 13 130-19 39-6 29-31 52-13 23-16 22 7 44-22 71 17 1 1 79-60 41-9 124 52 17-15-21-16-1-13 15-6 35 16 54-3 57 28 180-15 100-54 48 6 30 51 39 26 67-21 1-26 28-13 79 29 44-11 81 50 42 11-30-48 14-6 14-17 20 3 14 53-15 21 31 106 6 46 38 17 18 37 10 48-25 160 10 167-20 277 63 124 121 113 115 198-18 273 99 211 41 104-61 90-8 129 30 123-7 18h11l22 30 68 14 151 108 55 92 77 42 155 140 36 22 21 6 8 12-1 20-4 14 9 46 25 20 11 12-9 19-3 7-20 10-34 14-7 28-38 18 5 11 31 17 33 1 13-15 31-5 33-8 48 20 56 85 132 31 59 10 19-20 80 32 39 41 33 48 125 50 77 49 71 72 7 47 92 138 50 48 26 84 19 20-15 7-9 10-17 27 2 23-41 27-29 32 44 11 22-30 40-31 33-48 22-6 85 26 61-1 17-6 35 13 34 10 21-2 63 48 40 20 66 1 12 13 30 19 20-4-35-50-17-10 24-104-41-46-8-55 12-16 23 24-16-38 32-23 27-46 4-31h23l14-9 1045 4210-23 144 163 171 37 170 96 87 55 80 97 82 29 1 93 128 76 53 54 93 117 80 119 42 14 47 37 16 235-29 65 25 40-37 87-23 80 14 37-17 122 15 121-3 4-22 91 19 272 95 18 71 87 72 183 41 49-38-39-84 26-21 65-4 52 30 5 78 32 53 48-7 23 35-16 33 117 117 114-12 100 38 93-48-10-45 95-39 108 19 128 82 39-15 89-132 218-162 59-70 92-21 69-44 37-71 166-29 52-34 91 18 61-10-1 3 77 1 26 304 156 84-71 93-17 81-3-1-20 28-23 18-22 9-37 38-8 18-61 31-67-3-55 49-125 131-79 90-39 38 4 20-116 185-112 219-22 40-16 57 2 47-71 119-11 11-29 2-32 34-75 76 17 45-17 42-82 44-69 140-132 588-1499 413-368 312 159 180 10 4 45 127-13 25 12 11-6 38 66 3-7 55 12 30 97 28 19 42 1 3-2 23-2 63-819 718-918 428-841 799-238 48-370-148-105-187 3-57 2-43-29-126 14-61 18-35 93-51 4-5 92-48 92-193 30-49 31 8 32-55 17-25 10-186-21-43-2-146 21-42-11-43 3-9 105-697-705-1878-942-375 91-218-128-101-67-6-77 36-55-9-47 75-41 11-24-48-26-13-6-35-63-32-11-24-23-31 6-18-16-11-12-51 9-10-4-5-55-90 25-115-84-20-44 67-83-9-59 63-4 12-64 1-189-164-120-272-2838-1221-221 89-464 350-117-36-55 18-3 5-36-11-56 9-34-13-58 12-47 38-46-27-43-12-7-37-23-28-87-23-119 20-46 13-70-6-76 17-7-32-139 45-28-49 5-28-42-23-7-69-93 33-37 32-67 35-91 93-114 45-56-9-76 24-1-54-92-10-27-89-186-41-70-137-47 16-128 12-12 29 34 76-76 37-86-163 13-49-43-37-146 3v-54l53-4-1-47-79 5-169-91-171-8-196 59v44l-133 37-128 6 13-60-28-68-306-21-17-49-107-13-23 20-100-28-78-64-9-54 17-55-52-247-23-47-31-164 1-38-97-54-73 19-71-36 9-3817 974-991z"/>
		<use xlink:href="#i-CA-ON"/>
	</g>
	<g id="QC" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m10559 8018-40-88 94-140 31-15 62 7 11 81 43 33 62-18 99 59 58 143 29 41 16-80 20-17h-32l-21-25 74-135-34 4-27-14-15-68-44-51-59-19-90-90 32-53 33 2 46-72-55-56 21-46 83-67-19-37 72-179-25-78 51-31-2-12-65 25-3-42 23-37-2-47-35-7-18-72 18-16-2-1-21-23-16 7-8-13 10-12-36-21-16 17-100-12 22-54-73-41 25-21-5-36-37 14-17-17 34-10-3-19-72-6 18-48 62-22-50-20 34-65-91 34-53-61 45-56-8-23-76 12-34-25 32-47-13-15-32 13v-221l-45-9-24-129-145-72 64-66-12-19 40-25-21-23-48 24-10-110-67 9-2-18 39-13-12-56 20-32-27 6-8-14 29-23 24-5 4-9 12 8 13-1 7-11 26 9 40 36 1-12-75-55-76 12-36-35 49-42-88-19 53-22-30-39 55-13-13-19-105-38-88 18 117-57-29-54-184 21 50-71-31-12-70 36 4-79-39 20-51-176-46-71-42-20 34-35-38-23-70 6-4-16-41 20-3-11 100-123 186-130 149-92 3-31 59-60 33-3 111-100 2-24 123-90 26-53 201-252 30-16 28-84 38-74 26-7 66-137 93-171 41-125-52 77-5-6 116-311 23-24-3-80 34-26 14-45-2-85-16-40 51-4 161 7 18-7-5-12-55-8 12-28 85-15-31 49 89-9 35-11 8-30 41-14 15 8 30-18-99-52-15-23-129-35-10-37-64-12-13-40 38-3 24-23-9-20-55 11-41-82-56-27-2 15 25 20-2 21 18 14-24 71 39 19-2 16-15 9 5 16 47 12-17 54-22 6 15 36-25 20 13 29-43 54 59-24 13 9-1 13-104 20-7-28 17-5-15-53 23-45-30-195-23-13-50-191-54-178-89-233-1-40-109-205-90-138-24-4-117-156 13-17-239-268-121-94-113-62-77-13 50-17-144-71-102-21-91-14-69-24 17-23-50-41-45 7-55-55-26 11-54-62-24-39-38 11 28 51 16-9 37 35-51-4-53-70-29-13-28 3 14-60 24-4-28-42-49-36 21-40-56-95 15-45 24 9 4 35 23-3-2-21 20 6 40-12-3-59 24-35-40-75 52-2-30-54h13l11 22 29-23-35-51 50-106 43-4-20-23 37-37 23 4 11-26-47-10 57-37 11-24-13 1-18-18 26-3 27-36 26-1-25-15-19 8-43-11-58 46-15-22 45-45-19-4-21-54 65-54-17-80-29-1-31-59 24-11-31-22 44-13 26 35 37-18-3 20 29-5-17-18 7-19 16 34 30 3 15 12 18-6-14-29-32 12-21-28h21l5-21-25 1-24-42 39-6-2-22 59-39 46-7-1-19-27 2-60-75-22 6-11-26 28-9-12-29 42-25-23-46 61-54-8-11-58 50-21 1-24-20-18 24-61 7-51-10 23-18-17-39 64-28-73-68 45-14-34-23 12-10-72-53v-28h-31l4-20-14-15-33 10-42-20 40-111 35-51-12-22 61-18-30-11-43 8-13 25-25 7-28-14-10-18-34-1-45-57 57-61-3-27 19-46-37-18 76-76-9-13-151 132-4-36-60 32-67-11-53 46-5-86 64-173 59-97-20-81 22-56h15v-36l-34-11 8-29-25-20-22-102-11 1-35-60-3-23 31-20 3 30 24 6-4-31 41-7 23-27-81-20-5-29 22-21h46l38 16-10-29-22-5-54 5-3-15 29 1-10-19-63 21-58-92-73 30-35-20-100-175 6-28-49-75-12-1-11-22 4-12-34-98-15-9-35-177 17-81 23 2 28-46 26 2-25-24 9-21 46-17 17-39 22-8-1-2 10-54 43-28 20-67 38-8 21 55 9-5 1-37 153-11 67-27 62-3 94 26-11 13 29 3 17 14 8-5-6-14 250 17 9 12-4 32 39-35 15 27 8-29 23-7 45 20 115-4 44 11-45 55-22 38-27 14-26 47 18 1 23-13v-22l26-10 74-99 20-65 25 38 11-4-16-40 38-26 31 15 83-7 10 35 2 21 6-4 4-25 1-27 66-7 126 60 5 19 5 4 4-14 61 25 23-15-41-10-48-37-25-12 8-53 141-38 48-59-1-34 30-42 9 19 68-80 36-118 82-45 92 80 15-21 46 16 19-14 50 29 59-1 14 46 57 25 12 15h24l6 17 104 21-13 30 25-1 46-58 78 13 66 139-34 20-1 19 19 19-1 28-14 30v23l-21 32 7 6 29-36 1-29 14-16 24 45 9-3-15-45-12-10-5-61 17-6 105 24 90-14 24 23 4 15 48 27-53 26 32 6-16 14 17 23 30-43 68 25 36 56-3 42-16 38-25 9-29-7-35 24 12 17 20-24 42 7 43-14 3-21 21-3-1-83-35-24 13-16 166 4 47 20 33 32-4 21-22-1-2 26-92 44 42 27-21 19 38 12-33 46 15 17 125-33-31 36 6 17-34 22-47-1 2 7 74 7 24 14-34 53 95 9-4 50 6 2 20-31 23 44-4 20 7 1 25-19-19-12-10-33 33-13 17 38 34 6-4 16h1 2l20 1 5-20 58-25 35 47-1-2-1-40 127-12 13 32 47-15 56 19-21-37 60 5 3 36 21-24 57 6-26-31 20-34 34 37 1-1 19-12-21-35 31 10 6-9-37-21 11-9 38 26-20-31 49-23 17 24 32-49 30 30 2 63 48 30 38 78 33 33 27-17 62 26-2-20-30-10 51-115 25 33 44-10-13-46-40-29-18-68 4-75 54-10 78 97 51 27 54 117-106 178 70 91-18 58-40 17-1 35 69 36-6 47 34 4 40 44-26 59 58 10 29 33 53 19-17 16 34 109 37 11-61 64-66-5 13 49 34-3 8 23-101 14-174 54 15 17-115 65-42 7-20-18-44 21-51 3-122-12-13 21-26 19 23 3 29-27 107 11 64 1 37-19v14l47 4 89-49 38-14 30-31 83 7 186-81 43 71 87-11-7 39 19 27-5 29 51 35-28 58 60-16 36 40-14 68-37 24-23 95 10 25 32-16 83 130-53 42 2 18 55-26 14 13 11-34 64-72 52-3 8 39 22-4 14-54 67 115-25 50-39-24 8 47-27 10-26-29-20 29 17 73 28-19 27 18 33-60 24-2 15-30 29 11 19-16 21 59 57 23-22 65-3 77-37-17-20 51-12-45-8-97-40-29-24 114 15 56 41 74-28 30 9 64-51 49-69-81-13-70-44 3-76-73-13 9 34 53-5 33h1l37-8 66 124-23 8-47-27 26 36-44 45-33-5-6 44-39 24 9 19 39-21 39 19 15-44 21-30 28 92 37-40 36-7v29l-23 58 55 45 13-159 26 23-11-83 69-80-2-67 54-63 144-69v32l73-40 19-55 16-3 30 14 49-42 126 58 37-13 7 28 17-15 10 28 5 48 17 19 33-1 26 98 13 9 16-23 12 4 20 58 23-47 17 9 9 28 8 54 22 15 25 116 1 66 26 142 25 39-34 64-2 62 33-17-5-42 26-58-37-93 8-76-17-28-17-138-37-71 5-55 48-8-7-71 55 37 35-4 18 91 92 110 4 76-26 19-23 133 22 43 31-48-15-113 34-35-2-69-50-80-23-107 75-2 13 75 29 75 61 30 8 92 21 58 25 23-18-155 49-107 42 11 57-166 52 5-13-64 27-117 73 55v-2l3-59 31-39 45 6 10-22-40-49-7-193 32-19-29-34-18-67 34-50 21 9 2 25 17 3 1-19 150 53 58 53 15-29 26 8-2 18 44 2 25 96-12 57 10-8 33-75-26-52h40l-50-39-39-5-25-33-49 14-27-66-32 12-22-55 20-67h16l22 28 6-22 38-11 36 32-18-35-3-39-79 22-43-18 64-87-47-48 38 15 48-5 56 13-17-33-59 1-20-15-9-28 40-40 31 4 32 22 16-13 33 7-29-23-26 2-13-16 44-44 22 13 54-17-19-11-27 8-22-9-21 7-33-13 22 24-46 40-32-36-62-35-3-38-45-16 21-18-35-14 10-30 52 6 51 57 4-6-41-65 17 2 24 19v-1l65 69 11-2-23-30-66-60-9-28 17-7-1-12-25 4-90-82 74-4 149 78 4-7-84-61-27-1-16-55 26-18-76 13-4-23 28-3-58-20 76-38 7-15 98-22 3 22 33 22 39 6 65-14-78-1-45-18-8-31-67 11-11-11-43 16-12 21-141-130-56-74 38-29-29-28 4-10 15 4 5-34 23-47-6-22 59-72-46-4 29-19-14-86-31-44 31-33-22-30 6-35 33 12 2-10-17-9-20-33 19-11-17-27 21-16-29-16-20-38 32-59-8-45-25-18-2-14 24-7 122 11v-4l-30-13-8-9 39-2 32 8 10 6-90 42-53 69 7 32 92 19 70-15 32 46-72 45 43 57-106 27 89 74 125-23-4 72-40 5-2 80 86 95-36 77 23 108 109 6 79 43 31-41 42-111 66-2-50 132 92 189 81 118 75-26 81 53-78 78-158-30-69 38 55 161 70-73 109 19 31-44 138-34 36 96 65 10 15-86 93-139 137-14 83 55-94 107-157 98 7 112 84 58 29-82 42 2 56 46-5 78-59 16 18 81-73 36 29 152-66 93 54 114 116-21 216 218 5-51 69-26 53 78 125-10-20-65 28-31 42 72-46 133 76 118 68 64-63 73 30 86 75-28 47 179-46 9 122 203-65 48 38 80-30 110 198 105 66 73-29 65-116 33 144 136 61-58 75 39-78 108 73 71 57-98 51 53 54-42 49 18 112-63-5 48-153 186 157 92 31 126 47-18 60 147-33 49 87 27 195-92 25 30-123 99 30 34-58 67 52 15 116-66-44 149 122 245-163 20 85 124-37 60 188 83-179 131-142-70-193 13-10 88-130 48-33-89-160-35-102 12-26 176-144 42 75 52 23 55-127 23-4 51-157-87-43-74-122 55-73-27-50 32-353-197-9 39-121-69-7 58 109 44 8 116 127 89-39 36 154 146 12 109-199-23-285-120 7-37-73-13-66 68 218 159 185 98-68 154 47 104-179-36 39 96-115 118 170 233-67 83 48 121 272 102-43 60 20 32 54-19 230 151 149-49 135 84-37 98 52 34 82 232-206-33-57 82 172 223 107 6 28-66 88 99 118 38 84-145-51-189 69-172 186 147-79 37 206 222-123-22 187 286-72 46 74 101 109 64 45-44-88-149 191 87 24 79 96-4 38-84 120-36 62 69 36-136a43104 43104 0 0 0 6 0l8 1 23 48 126 48 60 143 37-71 121 70 151-37-3-52 100-37 37-13 175 128 37-131 47-31 5-79-101-82-66-132 59-40 4 4-66-89 11-106-89-98 2-161-129-141-43-165 208-170 14-141 71 105 173 33-230 176-77 94-8 122 93 84 166-14 209 202-112 42 62 67a43223 43223 0 0 0 3895-2352l121 177 133 196h-1l108 160-18 1-9 6 2 11-5 15-24 10-8-5 1-7-6-6-23 1-15-9-15-36-7-8-81 88 5 16-9 4-11-15-10 5-3 21 29 4-1 14-14 16-12-13 2-13-8-3-11 7 13 29-7 10-37 20v22l-6 7-25-7-26 38-28-33-28 19 25 67-16 7-14-5-6-17-11 10 11 12-7 18-7 6-9 29 11 6-18 42-4-1-4 42-5 16-17 18-5-5-11 28-30 42-7-3-32 51-35-16-5-27-8-12-11-1-9 9-24-20-10 1-7-7 17-27-9-6-25 43 12 18 16-14 35 23 17 1-10 27 23 22-8 12-57-3-21 24-10-5-6-17h-12l-19 26-15 51-11 61-42-32-10 10 7 8 13 2 16 20-4 15 6 8 23 7-3 9 41-9-15 55-12 32-9 9 2 12-45 91-20-6 3 20 15 4 20 20-16 63 13 7 10 35-16 7-33-49 2-38-7-10-32 15 2 45 27 9 9 25-9 2 11 22 9-1 21 26-4 29 20-8 11 17-12 15v9l20 14 14-7 11 22h-10l4 52-6 26 20 11 1 8-43 2-20-4-16-17-5-19-10 2 2 23-7 24 6 5-21 36 13 13-5 18-22 2-13-23-17 21 31 27-16 34-18 2 18 58-58 24 32 27-29 18 25 57-19 36 13 22-19 16 15 52-69 79v19l-22 24-26 7 9 22-10 26 7 13-15 23 16 4 28-23 20 4 8 12-7 35-13 38-24 46 7 19-24-8-5 19 10 4-36 17-26 29 11 11-20 54-7 7-17 3 11-26-9-12-13 30-6-15 3-15-21-13 5-34-16 4-11 22 4 54-4 11-22 13-4-25-8-20-21-12v22l12 4 9 38-7 4-35 3 5 16 13 7-8 6-43-13-5 18-19 2-3 17-21-7-18 15 5 32-50 28-12-3-17 18-66 11 8 29-11 27-35-15-7 28-5-37-11 4 1 30-23 13 2 35-29-27 1 23-57-3-7 22 16 15 6 18-38-12-9 15 13 14-38 2 5 22-9 7-23-14-51 35-47 54-18 10-43 55-71 109-33 33-22 6-28-1 33-17-12-12-5-5-29 14-13-24-23-21-54-18-61 18-17 32-143 54-49-3-103 45-12 24-26-3-19 21-14-15-17 8 1 18-127 50 15-37-11-2-46 70-28 15-9-12-31 35-35 10-12-25-36 30h17l-5 26-67 20-17 24 40 15-80 70-42 8-16 21 8 27-35 14-31-34-42 6-25 18-1 1-8 23-13 5-14-13-21 1-2 21-17 7-23-30-46 15-110 47-52 45-38 12-27 62-124 32-74-5-38 23-22 48-119 79-83 57-33 4-17 16-54 7-108 47-54 5h-1l-23 26-26-1-90 72-16 22-117 77-52 18 5 16-20 3-61-6-41 22-5 94-50 5 28 32-38 14-50-3-62 41-18 30-52-21 9-14-24-26-30 9-32 63 30 53 20 7 48-27 1 46-59-3-26 15-56 61-11 51 12 49-105 95-8 37 15 40 10 86-11 56-10 3-9-20-27 9-8 57 2 38 17 46 31 54-8 18v78l56 112-6 75-11 4-2 8 9 27-13 98-79 27-65 34v13l-29 9-8 20-37 6-31 20-6 43-15 9-61 1-24 23-25-4 6 13-54 25-4 35-5 3-36-5 20 75-33 19-13 22-15 4-10 15-15-6-9 3-14 10v4l19-3 8-7 44 10 24-16 24 24 4 41-19 21-55 18-19 27-6 24-20 32-34 14-7-5 25-48 2-32-5 1-11 39-33 26-58 37-9 75 26 72-21 25 34-10 6-16 3 29-19 14-32 9-36 27-3-12-13 26 5 7-39 84-33 24 6 35-14 25-51 20-3 13 13 35 6 46 21 70-6 76-60 2-4 27 4 14-10 49 16 43-3 68-24 70 9 39-21 79-13 2-5 42-37 53-33 101-11 10-53 6-19-5-6 16-37-6-41-38-2-13-19 22 48 40 23 10 44-8 54-7-1 19 18 4-6 11-1 18-12 2 1 28 8 33 13 21 4 48-19 10 18 12 5 40-18 61 11 111-28 33-2 56-72 99-18 1 20 30-23 69 23 58-15 43-85 80-36 44-27-1-6 22 9 6 10 27-14 73 2 44 6 11-24 178-22 77-9 7-17 48-46 26-44 62-27 54-12 34 2 17-46 74-6 34-21 23 15 8v23h10l1-7 9-20 121-51 62-102 25 6 18-46 12 6 12-3 7-12-5-11 14-23 11 1 48-77 52-32 33-65-4-9 82-277-7-12 6-68 40-31 19-37 13-56-23-49 5-10 4-20-11-4 16-50 12 4 12-48 21-1 13-71 32-54 13-63 19-87 14-9 20-82-7-7 10-67-16-27 12-69-7 8-9-12 53-129 25-10 37-103 48-89 10-51h1l23-59 32-66 5-25 137-185 11-1 39-73 24-18 4-41 16-46-8 3 45-71 20-6 34-69 61-88 19 5 24-30 6-18-8-5 18-24 22 7 22-33 6-1 35-77 149-177 6-29 20-23 24-11 58-68 2-13 53-39 5-14 67-60 99-126 13-22v-8l90-105 3-14 42-36 9-19 29-15 27-33 18-2 35-30 11-31 54-54 93-81 125-86 39-19 8 4 41-35 11 7 13-7 3-19 22-12 13 6 8-8 4-12 22-24 15 4 8-20 47-28 3 3 148-72 7 8 85-27 109-46 74-19 84-7 76 10 106-17 181 32 90 30 10 10 24-2 67 31 18 13 4 44 19 20 11-1 47 24-2 6-43-12-38-16-4 4-44-6-9 7-52-4-27 6-12 17-6-9-45 10-44-1 6 13h30l41 9-2 16-34 20-3 12 34-18 9-14-3-4 25-12 26-2 30 5 1 14-13 9-7 22 34-12 37 1 66 20 24 21 26 10 38 5 24 15-5 6-52 20-54 41 41 12 2 12 22 19 70-3-2 18 6 13-32 34-12 24 5 42 14 11-2 12-37 17-71 66-84 105-4 14-8-2-20 12 17 11 11-12 9 24-15 38 14 87-28 16-21 33-62 36-5 14 6 16h22l-58 100-21 61-15 23-34 33-2 18-14-5-25 22-3 18-56 32-41 11-40-26-40-9-3 7-56 9-89 1-65 21-71-29-12 10-14-25-15 11-9-5-28 66-13 79-15 19-9-8-22 1-28 8-17 17-43 20 8 45-40 3-22-17h-18l-24 14-22-3-34 20-20 63 13 3v12l-27 16 6 9-24 13h-25l-9 20 1 29-10 13-14-5-5 4-6 12-6 2-7 4-2 12-3 5-4 11-51 12-38 47-9 47 30 57-84-19-46 49-34 56-57 8-39 21-3 58-22-16-106-8-26 3-40 8-35-57 3-17-357 162 38 86-179 80 165 371-72 186-124 149-154 127-35-74-1-37-18-19-138 18-212 1019 77 308-71 118 1 184 55 37 23 201 61 5 3 61-66 147 51 62-95 115-48 107-14 109 110 58 6 57-140-16 58 224-49 5-83-82-81 76-12 69-65 31-75-44-65 118 35 111-30 90 23 45-544 219-238 85-70 17-404 148-798 304-326 99-13-3 8-18 37-38 22-9 23-18 20-28 3 1 17-81 71-93-156-84-26-304-77-1 1-3-61 10-91-18-52 34-166 29-37 71-69 44-92 21-59 70-218 162-89 132-39 15-128-82-108-19-95 39 10 45-93 48-100-38-114 12-117-117 16-33-23-35-48 7-32-53-5-78-52-30-65 4-26 21 39 84-49 38-183-41-87-72-18-71-272-95-91-19-4 22-121 3-122-15-37 17-80-14-87 23-40 37-65-25-235 29-37-16-14-47-119-42-117-80-54-93-76-53-93-128-29-1-97-82-55-80-96-87-37-170-163-171 23-144z"/>
		<use xlink:href="#i-CA-QC"/>
	</g>
	<g id="NB" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m19218 9964 154-127 124-149 72-186-165-371 179-80-38-86 357-162-3 17 35 57 40-8 26-3 106 8 22 16 3-58 39-21 57-8 34-56 46-49 84 19-30-57 9-47 38-47 51-12 4-11 8-9 11 17 45-53 22-2 59-61 35-56 62-42 9 29 18 26 199-18 31 15 128-52 54-10 67 20 37 25 38 37 46 73 69 20-8 29-14 5 23 16 16-4 3-48 16-23 26-9 22-18 31-64 20-65 28-24 29-61 31-41 8 1 12-18 91-61 19-3 1 11-11 16-33 48 13 15 19-16 22-8 16-31 72-58 33-10 33 31-7 20-36 22 50-11 20 23 22 1-1-15-28-15-4-19 10-23 73 30-36 74-7 37 3 39-7 38-16 10-11 38 29 35-6 5 47 40 11 77-14 12 13 94 12 9 4 32-31 15-33 78 8 9-65 163-18 14-48 63h17l20-16 19-3 16 5 9-9v-18l17 3 30-30 11 21-1 27 41-22 23-53 19-6 23-30 15-5 26 23-2 18 32-41-9-14 40-28 57-23 7 6-12 10v17l46 52 6 19-12 40-13 32 9 61-24 53 42-10 36 53 11-7 13 10-7 26 22-6 50-3-14 52 9 44 12-2-5-51 59-22 22-18 24 25 18 39 5 27 22 36 35 20 31 35-17 30 28 9 4-18 43 17 32 33 28 63 34-12-16-24 3-17 26 4 39 33-27 57 14 6 4 16 25 31 15-38 75-32 23 2 73-49 36-10 89 11 53-14 14-19 44-22 68-1 44-22 45 1 26 20-16 35-50 59-77 47-22 23-6-5-11 9 5 7-6 23 51 14 3 1 4 17-73 35-4 8 4 16-6 60-13 54 4 46-53-8-14 24-13 60 3 27-26 46 1 23 10 3v18l-15 19-26 3-2-9 12-14-9-27 1-52-55-25-13-14-5-12-5 1-4 13-29-9-32-23-11-13-55-19-32-18 2 8 26 20 49 20 25 27 28 18 17 3 16 11 12 25-25 112 8 15-11 35 15 13-13 75-1 54-10 2-4-16-34-7-32 14-16 41-23 20-2 46-22 40-46 46-18 10-116 152 1 13-53 78 3 22-40 50 2 25 12 8-21 34-12 1-44 62-33 20-2 30-45 7-28 93-25 18-40-15-12 23-23-2-39-48-20 27 4 13-43 54-6 25 23 17-31 67-16 4-2-29-24-8-1 30 18 12-58 54-35 51 8 15-22 21 1 18-12-5-36-56-18 5 6-26-7-2-17 32-35 27 9 19-44 42 6 9-40 46-13-26-12 20 15 13-23 22-9-5-15 24-14-7 7-26 8-6 3-10-23-12-7 19 13 7-6 18-18-15-23 59-37-20-2-13-8-4-6-26 3-6 19 8 9-14-9-7-7 10-10-6 1-9-26 1-26-9-8-5-10-15h-7l13 31-12-1 3 10-13 8-22-14-12 2 10 14 13 28-3 1-5-4-10 6 6 5-12 2 8 11 5 12 26 14 8 12-6 3-17-3-13 8-38-36-11-2-17-10-15-17-7-14-16-7-24-27-20-8v19l15 5 6 14-10 9 30-1 5 8-14 9-21 2 1 4-9 12-54-10 10 46-25 44-67-26-110-87 5-120-115-87 54-44-38-73-38-17-27 34-133 16-39-29-92 14-49-122 18-39-55-37 20-61-34-17-530-1145-82-9-89-68-94-30-77-14-32-26-73-1-64 17-27 31 30 59-41 24-30-4-74 44v51l-78 43-91 117-145-36z"/>
		<use xlink:href="#i-CA-NB"/>
	</g>
	<g id="NS" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m23343 9612 2-18 137-19 14 28 104 20 29-7 7 9 40-14-19-17 144-83 45-3 9 11-54 26 50-5 7 14-73 32 21 9 72-40h31l34-17 23-28 38-8-47 71-32 24 20 13 52-13 14-36 8 14 24-50 23-10-13 32 12 6 52-68h24l-5-16-60-12 264-94 50 22 27-31 44 5 4 18-26 48-14 14-26 6-13 20 7 24 18-28 21 12 6-25 51 14 9-20-31 5-16-19 6-26 87-34 63-7 38-56 65-58 71-158 22-25 23-116 25-32 32 1-11 28 91 102 12 35 79 8 3 12 48-20 25 8 85-82-13-16 6-28 56-34 66 28 30-2 39 37 54 18 73-9 31 31-4 40-106 137-5 29 32 14 111-64 33-3 8-9-13-3 78-53 37-4 21-22 41-10 22-9 23 4-11 13 5 12 8-7 14 39-56 1-3 9 28 5 8 41-19 27-40 46-21-25 3-55-29 46 8 13-71 35-7-10-29 34-11 43 34 25-4 19-29 32-36-5 15 13-6 23-27 1-32 11-2 22-33 22-38-4-8 16-18 6-39-21-14-17-7 5 14 21 97 36-28 20 35 7 5 6-33 20-23-8-7 3 10 16-49 29h-39l-2 5 28 11 13 17-19 13 14 10-1 18-27 2-21-4-10-5-2 5 26 9 17 13-8 10-32 2-18-7 2 12 17 20-38 7 4 28-10-4v-12l-13 3 5 23-41 22 4 6 76-35 15 11-120 87-4 23-17 12h-41l15 19-60 97-17-11-22 25 29 23-38 39-18-14-9-21-36-6v5l-26-2-1 4 12 4 17-2 26 3 5 48-13 19-35-8 22 21-18 38-15-11-7 21 12 8-106 104-47-22-28 16 26-2 21 12 39 7-19 36 40 7-29 39-46-9-38 28-12 43-14-7v-17l-28-15-11-37-19 12 11 20-30-11-5 11 44 23 30 1-4 61-36-16 4-17-24 5-21-9-21-50-18 2 32 60 9 48-11 17-12-7-22 29-23-24-36-22 4 20 33 29 1 72-106 33 17 38-10 33-92-15-22-15-22 5-17-7-10 1-12-8 2-8h-46l-5 6 26 27 29 9 5-18 13-3 33 11 21 20 5 18 28 16 5 30 58 44-14 63-13 9-3-27-14 8-3 55-12 11-7-43-61 30 16 6-12 19-4-12-35 1-23-16 16 30-15 7-20-7-2-17-26 7-13 24-35 16-42-32-46-153-81 102 14 44 27 3 58 54-33 2 4 57-33 13-30-32-9-32-65-24-18 25 17 37-42 14-29-6-1 26 43 82-36 33 61 33 54-20 34-4 24 32-92 14-11 22 13 26 14-4 6-14 44-4 6 10-29 19 10 20 49-24-13 55-45 7-19-12 1-15-100-2 29 11 58 2 9 24-32 72 12 29-18 36 12 30-88 35-4 31 57-13 16 14v58l-42 6-7 45-45 7-1 11 49 5 17 33-20 6-23 56-51 30-10 44 59 8 21 27-14 7-9 40 14 22-27-3-19-28-38-8-8 10 39 13 13 15-6 18 17 14-12 24-48-37-10-13-26-12-5 11 12 10h15l45 36v74l-42-13-1 15 15 23 3 44-37 19-27-54-13 12 16 30-15 12 24 55-24-8-32-68-14 12 16 44-21-12-77-67 17 31-5 8 33 30 12 44-2 35-33-1-33-9-21-55-19-16-3 3 12 21v15h-37l72 48 15 32v29l17 7-6 26 21 11-5 19 21 24-3 5-38-28-1 31-21-1-11-13-20-10-33-3 26 15 3 12 50 17 29 46-7 16-12-10-16-31-22-20-15 4 16 17-2 32-21 2 41 18 5 39-24-5-5-21-60-11-15-24-31-19-6 61-25 31 13 23-16 2-13-14-30 30-15-20-28-49-12-11-5 5 11 18 13 13-2 8-43-15-22-79-19-40-10-12-13 8 13 46 12-1 19 41-5 12-15-8-26-45-66-92-7-1-11-20-19-19-13 11 30 33-8 1-71-46-13 35 20 14-8 21-37-25-18-47-18 7 9 31 76 57 8 21 4 35-19-34-11-5 3 40 10 23-20-5-19-41-16-8-12 7 22 29-1 13-31-25-16-35-16 49-42-50-11-63-12 7 7 26-44-33-15-71-36-43 3-23-72-85-19 9-13-24-10-84 9-57-46-135 5-54 13-7 2-65 24-86 8 9 22-62-1-10 13-48-22-14-13 8-9 26-28 1-35 90-15 54-41 158-20-30 26-129 10-11 18-74 33-83 11-17 9 4 51-122 9-11 19 8 17 16 29 54 40-37-3-12 28-56v-41l17-21 4-22 14-28-3-19-5 21-22 43-36 27-5 21-17 4-26 50h-22l-10-10v-30l21-47 127-236 223-400 61-92 37-44 86-87 89-98 26-57-19-28-15 2-36 12-20-2-7-4 79-26 20-3 34 3 16 17 4 21-9 13 11 26v20l-5 29 11-12 13 3 17 24-5 15-30 23 30-2-8 19 7 8 16-16 14 28 17-16-11-38 29-17 62 6 49 16 41 20 8-17-78-30-19-19-3-30 11-19-18-19 60-87 92-110 49-40-7-24 26-22 22 9 12-13-9-12 17-15 25-6 77-39 6-29 34-2 27-47 42-36-104 46-83 13-8 12-45 25-18 7-28 1-71 64 3 37-14 5-19-4-1-14-35-9-29 10v12l-27 22-20 4-32-6-95 87-54 12v26l-20-1-19 16 5 11-50 3-24-5-26 19-44 4-68 65-12 42 24 37-45 44-45-33-25-1-60 65-9-16-22-70-1-29 18-50 17-1 2-21-7-5-13 12 72-111 25-52-8-12 13-28 25-32 31-98 18-22-3-41-22-12 32-64-16-18 32-58 16-1 9 12-13 57 14 10 13-24 13-75-30-4-3-5-4-46 13-54 6-60-4-16 4-8 73-35z"/>
		<use xlink:href="#i-CA-NS"/>
	</g>
	<g id="PE" fill="#d3d3d3" >
		<use xlink:href="#i-CA-PE"/>
	</g>
	<g id="NL" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m15755-4173 67 3 33 12-1 13-105-8-23 4-18 13-32 45 18 14 17-43 32-19 86 11-15 48 10 7 57-42 10 51-27 51 27 32-31 14-13 25 14 7 4-17 46-18-12-61 19-13 23 44-25 3 12 27 29-4 1 60h-16l-17 19 49-5 24 46-17 1-19 54 12 8 22-48 20-11-16-32-4-45 30-21h-30l-23-42 86-17 33 52-29 15-28 49 12 11 30-28 70 20-2 54 36 70-10 19-36-9 20 35 52 22 23 24 64-27 46-31 10 7-15 30 3 7 30-36-2 41-38 4-12 24 8 37 14 38-4 45 12 4-1-22 13-33-24-64 5-14 36 6 28-26 10 6-4 20 17 1 22 15 64 3 33 29 6 67-10 47-31 8-56 27-19 31-2 14 12 1 24-33 55-20 73-2 27-25-1 33 23 74-4 21-15 19 11 7 18-18 6-22-15-74 8-46 51-5 32 11 26 63-9 48-19 18 2 6 26-8 20-54 8-54 38-10-4 98 10 16 5-40 38-9 6 117-34 30-17 48-28 9-48 44-97 11-28 22 7 47-12 22 3 6 19-23 2-23-6-29 41-1 22 56 33 35 6-7-24-25-23-46 11-20 69 12 33-53 61-22-1-37 43-63 41-17 58 11 43-21 8 23-21 19-43 12-36 25 7 8 53-23 23 11-22 65 12 11 14-50 25-31 24 31-25 16-5 18 20-20h16l7 34-8 46-37 23 7 12 66-34-7-25 13-2 11 66 11-13-3-28 9-4-16-52 31-20 29 7-29 30 7 10 19-17 74 4 40 92-58 49 5 22 83-51 26-7 18 57-17 35 22 15-80 162-72 57-63 18 3 20 65-17-6 115-28 37-3 54-12 20 11 17 18-32 2-37 31-51 17-127 66-55 30 6 8 45-11 53 12 11 26-63-15-45 20-12 24 26 13-72 127-107 53-1-16 74 8 31 41 18 27 67-23 15 10 41-85 41 5 76 13 1-8-61 43-28 31-6 16-40 58 18-9 81-76 29-49 52-64 35 11 12 23-8-7 43-42 46-18 43 19 6 16-25 22 45-18 15-25 10-47 63 12 10 35-49 34-18 29-27-18-71 38-42v-44l120-90 37 6 13-73 18 42h32l-39-59 52-16-4 81 72-39 12 8-19 14 28 41 28-40 28 33-25 58-61 22-31 33-5 40-17 14 10 22 26-38 6-28 32-22 40-9 49 75 18 10-41-83 5-35 28 17 18 32 13 1-8-46 49 12 9-69 39 10 40 52-15 70 57 32 28-29 80 42 9 34 15 8 11-15 46 51-76 87 14 49-27 39-26-10-31 20 5 105-112-5 4 28 125 10 60-98 131-27 114 7 3 24-59 22 72 53-24 65-55 9 36 21 62-12 46 26 24-49 14 44 12-1-1-48 25-74 10 14-11 93 126-75 47-14 49 33 55 112-50 25-31 62 19 13-2 34-20 10 1 46 33 53-65 68-62 10 1 20 58 84-13-66 51-28 64 9-18 63 80-2v33l-106 46-59 11 19-46-19 7-25 33-203 34-113 18v9l97 1 124-32 99 19 28-34 45 10-180 87 7 10 171-58 24-29 69-3 1-20 38-9 51 21 5 54-224 93 9 23 65-33 31 18-53 36-33-1-18 21-51 11 6 14 48-9 102-16v-31l16-10 15 19 55-21 33-1 4 11-46 20h59l5 10-74 41 5 8 103-60-8 23 50-21 61 10-9 21-77 20 54 5-42 43-29 17-20-10 22-8-3-25-36 21-31 2-13 34-48 1-22 4 6 35 42 9-13 14 77-14 11-28 20-9-3 19 46-36-6 29h21l24-52 69-32-1 21 35-6 17-33 37-45 26-27 16 10-16 21 35 24-8 14-17-2-11 43 19 29 10-49 24 5-16 21 40 2-31 30-17 49 24 16 44-80 49 13-42 29 3 15 29-15 5 8-56 40 30 37-15 17 5 11 80-72 22 13 37-48 60 28 25 38-63 36 2 13 73 4 25-18v-16l142-81h34l21 72-13 16 11 24 24 9 5-94-6-42h39l-1 37 65 65-2 25-15 18 1 21 39 8 1 49 7 30 8-7-4-29 8-18-36-157-14-34 6-41 43 21 26-36 25 24-2-31 7 2 17 31-16 16 14 53 22 9-50 47 6 76 12 3 1-52 50-5 19 22 14 64 9-53 26-35 22 97-21 79 3 31 29 18 1 44h17v-57l-20-13 1-111 19-3 18 54 23-11-22-18-17-49 21-5 41 20 32 43-25 12-12 26-21 6 10 23-23 3 7 49 37 83-34 18 5 39-19 26 15 35-17 51 32-29-8-35 9-43 44-56 14 8-2 36-22 47 17 91-35 65-2 38 28-9-2-40 31-65-16-14-6-52 47-20 5-155h13l1 26 18 6 5-51 21-9 17 116 17-31-11-6-2-43 12-9 14-48 14-1 14 99v65l-29 62 4 43 17 6 20-79 13-72-15-28 15-108 39 8-7-86 27-57 6 27 54 8 19 18 12 64-24 50-42 53-28-5 23 40 15-28 121-85 21 20 15-32-34-29-4-25 13-15 17 45 25-43-13-18 4-29 40 30 9 39 18-39 21 15 3 38-15 8 25 72-25 30-30 114v71l-27 44 2 31 32-12 13 64-20 60 12 11 35-75-21-32-21-66 49-125 30-133-1-43 42 35-16-70 4-71-11-1-1-71 20-26 11 44 16 6-10-38-5-34 16-13 33 49 7 67-31 28 10 104 16 14 16-57-20-25 22-43 23 17 4-7-17-20 10-36 24 17 2 30 12 4 1-33-22-43 23-35 36 36-2-30 9-6 31 54-10 89 121 12-16 33-20 10 14 18-24 27 19 7 25-24-10-23 30-21 30 79 48-1-4-48 39 1 12 29 12-2-8-43 22-17 23 31 50-18 14-29 29 1-10 38 12 8 17-34 39-25 9 23 26 5 7-22-38-20 37-40 59-38-51-76 3-6 42 19-5-28 11-22 30-18-4-13 30-63 18-11 22 42-21 21 55 81 6-8-2-64 20 22 27 1-27-33 24-7 13 18-2 26-46 42-7 41-37 25-55 25 5 14 40-16 56-37 8 19 11 1-2-30 12-22 60-22 23 18 17-11 19 19 47 2 14 16 46-10 37-73 62-27-2 28 17 10 9-14 7 3 5 20 21 12 4-6-5-23h49l31-27 6 29 37 22-9 31-40 26-18-22-9-40h-11v31l27 33-7 22-19 21-106 72-20 21 16 12 93-84 54-11-7 34-36-18-20 46 31-2-32 54v40l-34 36-34 3-46 48-34-12-69 81-25 10-46 49 26 36 46-41 7 12-30 49-18 6-20 36 36 9-83 77-19 4-17 48-42 35-6 58-31 48-44 44h-30l-175 197-58 106-34 23-25 7-32 14-2 27 41-18 4 19 9 1 23-31 42-21 66-93 69-74 26-14 92-126-1-17 18-20 8 1 33-18-23-3 18-23 14-32 4-24 15-24 34-32 9-15 3-30 27-14-1 77 10 15-39 63 23-1-12 37 10 44-17 33-32 29-37 20-65 21-17 16-38 19-21 31-17 18 8 6 11-16 54-29 12 12-3 53-30 47-24 4-45 53-62 109 7 4-11 26-21 19-15 38-40 42-168 66-14 30 22 9 30-15 20 8-17 20-32 12-48 39-12 34-35 36 68 12-33 55 24 30 1 34 64 49-21 34 32 31 34-29 53 56-10 5-28-7-38 12-35 80-10 5-6 39-19 1-2 29 10 26-11 12-17-2-2-11-11 7 16 16 20 3 9-19 34-16 49-59 24 35 14 2-10-19 61-42 8-31-10-9 14-60-7-29 8-31-16-13 16-33-42-7 28-47 51 5 25-9 6-34 35-7 39-32 28-72-2-47 23-48-10-26 18-1 5-19-11-25 2-11 38-2 19-29 27 14 49-58-20-21 6-13 30-8-23-43-17 10-27-25 6-49 44-109-29-56 11-17 16 5 47-46 47-78-3-30 28-13 31-45 28-12 5-34 10-17 59-50 5-38 27-33 108-24 26-34 54-14-10-27-70 23-9 19-19 9-19-6-80 27-60 65 5 28-35 27-20-21-51 10-21-64 8-22 69-51-14-2 31-44 28-2 30-36 84-26 60-47 28-11-4 20 46-44 34-15 13 10 31-26 16-1 8-20 52-19 57 38 15 19 107 61 78 16 10-10 40-7 2 8-41 17v28l22 26 70 20 27-13 17-1 14 12-33 54 53 27-48 110-52 79-19 33-11 45 8 2 24-45 10-5 8 57 10-9-6-25 29-22-3-16 51 24 5 27 15 8 10-21 21 58 19 28-24 33 8 18 36-42-17-22 10-58 13-3 15-79-9-18-17 25-4-2v-45l-17-1-11-20 32-35-15-35 9-34-14-16 19-42 57-19 9-43 23 8 23-9 13-28-20-1 18-29 24 6 27 15 38-4v-13l-33-6-8-32 33-9 18-13h-28l25-18 1-29 43-5 19 12-9 25 30-6 4 11-39 24-37 48 7 38-53 12 3 13 22-5 112-18 44-18 25-48 68-2-13 20-22 9-5 17 14-3 32-23 38-12-2-38 52 2 11-24 26 1 10-16 54 10 7 13-4 44-60-2-22 10-47 1-50 33 21 13 28-11 44 14 30-16h43l15-9 22 14-12 16 75 9-20 27 9 5-4 15 27-18-11-13 19-31 66 13-26 41 31-19 19-24h25l-49 76 46-29 31 8 5 27-22 11 56 1 1-11-16-2-2-32 42 14-14 41 19 7-15 15 10 14 11-19 23 8-12 28 33-1-24 70-50 14 39 1 10 53-8 50-29 17-32 2 11 19-14 35-2 25 9 5 10-41 60-51-5-10 32-21 27 8-2 10-33 3 16 21 29-6-1 24 34-5 26 25 25 3 33 44-23 2-1 22-38 5 15 24-47 27 21 20 24-28 8 25-43 34-74 13-52-5 22 23 38-3 19 16 22-25 48 4 75 40 31-48 9 12 32-38 23-7 11 8-9 42 15-28 27 5-10 13 26 32-20 22-40 2-23 24-55-2-23 19h-32l-49 37 6 9 36-27 77-15 7 23-31 47 46-15 7 13-47 22-5-9-35 36 4 13-16 23-42 29-63-5-33 29 4 12 35-30 27-1 20 11 72-43 11-28 47-26 61 7 63-65 96-10 3 15 20 5 1-20 40-6 25 34-12 10 43 25-12 28-54 6-42 19 29 15-42 23 2 6 56-24 2 9-22 12-60 20-50 3-168 36 19 11 22-11 37 1 31-14 77-8-12 15 114-33 22 11-6 29 10-5 6-21 17-4-1 14 10 1 8-40 22 6-25 70 34-38 77-9-1 34-23 12-22-9-1 18-10 10-17-12-4 22h70l10 38 16-3 24 50-55 28-2 11 30-2 12 46-19 10-4 34-19 23-37-8-15 6-1 12 65 5 16 12-16 79-20 41-9 57-22 17 7 14-7 48-15 5 15 18-14 23-21 27-37 16 27 20-34 56-15-3 2 17-6 10 2 5 11-9-15 65-17 10-3 28-18 33-40 36 25 51-13 42 5 28-4 18-15 3-4 12 29 26-7 45-26-12-14 17-18-5-4 16 25 29 1 20-33 40-15 7-6-12-6 3 1 18-19 10-108-160h1l-133-196-121-177a43223 43223 0 0 1-2907 1807 43223 43223 0 0 1-988 545l-62-67 112-42-209-202-166 14-93-84 8-122 77-94 230-176-173-33-71-105-14 141-208 170 43 165 129 141-2 161 89 98-11 106 66 89-4-4-59 40 66 132 101 82-5 79-47 31-37 131-175-128-37 13-100 37 3 52-151 37-121-70-37 71-60-143-126-48-23-48-8-1a43104 43104 0 0 1-6 0l-36 136-62-69-120 36-38 84-96 4-24-79-191-87 88 149-45 44-109-64-74-101 72-46-187-286 123 22-206-222 79-37-186-147-69 172 51 189-84 145-118-38-88-99-28 66-107-6-172-223 57-82 206 33-82-232-52-34 37-98-135-84-149 49-230-151-54 19-20-32 43-60-272-102-48-121 67-83-170-233 115-118-39-96 179 36-47-104 68-154-185-98-218-159 66-68 73 13-7 37 285 120 199 23-12-109-154-146 39-36-127-89-8-116-109-44 7-58 121 69 9-39 353 197 50-32 73 27 122-55 43 74 157 87 4-51 127-23-23-55-75-52 144-42 26-176 102-12 160 35 33 89 130-48 10-88 193-13 142 70 179-131-188-83 37-60-85-124 163-20-122-245 44-149-116 66-52-15 58-67-30-34 123-99-25-30-195 92-87-27 33-49-60-147-47 18-31-126-157-92 153-186 5-48-112 63-49-18-54 42-51-53-57 98-73-71 78-108-75-39-61 58-144-136 116-33 29-65-66-73-198-105 30-110-38-80 65-48-122-203 46-9-47-179-75 28-30-86 63-73-68-64-76-118 46-133-42-72-28 31 20 65-125 10-53-78-69 26-5 51-216-218-116 21-54-114 66-93-29-152 73-36-18-81 59-16 5-78-56-46-42-2-29 82-84-58-7-112 157-98 94-107-83-55-137 14-93 139-15 86-65-10-36-96-138 34-31 44-109-19-70 73-55-161 69-38 158 30 78-78-81-53-75 26-81-118-92-189 50-132-66 2-42 111-31 41-79-43-109-6-23-108 36-77-86-95 2-80 40-5 4-72-125 23-89-74 106-27-43-57 72-45-32-46-70 15-92-19-7-32 53-69z"/>
		<use xlink:href="#i-CA-NL"/>
		<path mask="url(#all)" clip-path="url(#nu_nl-clip)" d="m15741-4139 5-203h100v203z"/>
	</g>
	<g id="YT" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-15922-16462 24 42 12 12-12-2-11-3-5 9 7 4 12-6 1 19 21 9 14 28 65 83 61 46 35 11 51 35 36 47 11 50 19 31-4 23 41 27 19 40v45l34 23-4 77-4 58 20 106-5 75-20 38 37 22-14 13v17l45-23 29-24 2 15-6 27-26 65-2 75 24 79 57 179 27 37 35 124 56 23 12 30-3 27 22 89 46 21 8-14 19 8 6 15 19-17 19 33-775 1016v11l-33 36-1 14 52 67-130 203-42 119-122 63-92 171a26929 26929 0 0 0 801 583l-103-46-29 68 42 50-44 160-111-13 53 227-63 6-1 2-184 156 67 69-47 135-118 34 29 71-66 50 50 74 209-8 26 76-80 52 28 50 124-58 70 13-20 65 78 22-22 41-145 22 37 154-33 174-179 118 2-2-93 15-70 63-112-10-30 86 94 9-62 100 67 43-17 50-108 10-42 87-87 16-3 71 76 24 32 134 41 42-30 182 66 60-152 89 124 71 93-20 74 95-27 292-69 14-6 115 49 27-57 35 70 126 23 134 104 9-55 105-120-7 3 70 74-3 11 300-61-21-55 105-80-37-65 33 64 125-23 125 74 91-168 128-38 333 75 189-108 38 23 48-95 71 15 80-70 45 172 178 129 2 29 274-17 102 64 15 6 65-67 43 115 381 110 45 45 84-88 299-84 14-33 110 72 23-103 281 98 42 67-2 63 67 54 37 45-77 56 30 32 76 117-61 17 131 35 28 47-10 34 78 80 37 55-26 178 56 65-96 120 71-62 192-93 36 1 285 84 60-56 82-22 329 1 10 53 113a34499 34499 0 0 1-6936-4474l2-121 214-148 22-29-266-199-226 26-105-271-88 50-70-119-63-122z"/>
		<use xlink:href="#i-CA-YT"/>
	</g>
	<g id="NT" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-15092-14714 71 90 17-2 63 141-4 48 37 37 11 123 38 15 12-26 10-238-46-18-44-111 16-78 61 10 17 72 39 31 30-46-42-102 58-118 74-20 39-24 46 6 24 25 41 1 17-17 8-31 13-3 42 32 15 22 44-16 56 1 23 8 27 4 16 22 19-1 13 14 15-3 16 15 1 24 11 2 4-18 37 7 54-15 15 25 16-7 8-23 54-29 28-51-2-36 26-15 29 6 28 63 1 29-16 56-46 17-16 8-5 19 2 27 15 19 41 9-11 54 26 17 18-25 24 18-25 38-74 45-85 23-29 20-9 34 27 26 18-4 17-22 76 23 11-20 27-1v1l55 16 65 61 65 19 75-34 113-135 37-4 1-1 19 10v35h46l13 47 27 3 10 19 51-6 15-17-6-15-20 9-27-1 24-14-26-20-32 5-21-7 15-17 62-35 19 4 11 37 26-5 19 22-12 22 35 52 23-30 66 8 42-9 32 16 104-46v-1l72 17 34-54 17 1 36 66-9 46 19-1 2 22 151-143 97-8 122 62 81 129 65 7 70-86 57-30 34-1-16 98 19 101-79 70-335 10-35 18-23-20-111 32-25 30-40 4-60-8-66 63-24-4-47 42-36 75-37 38 14 21-37 49-79 50 18 18 46-41 23-6 8-25 64-27 63 3 58-69 91-38 31-41 77-45 90 33 131-5 30 14 60-11 158 53-82 149 143 6 32-28 48-7 39-37 113-19 45 22 28-153 32-37 109-6 195 49 30 19-5-27-136-126 18-98-15-33 83-106 79-43 75 219 19 119-1 192-38 223 24 39-9 42-38 18-34 157 15 276 81 252 50 13 3 32 25 1-20 27 27 36 50 6 3-44-20-37 86 61 20 21 34-61-15-31-26 7-44-42-41 12-45-14 85-64 82 27 46-58-63-50 79-63 44 29 82-42-51-37 6-63 64-15-34 64 57 5 106-108 55 3-21-37 25-7-26-26-22 16-13-31-69 51-37-12 37-70 114-36-34 65 40-22 87 19 1-55 36-22-1-43 84 18 5 25-84 4 7 25 47-7 2 28 39-4v26l-31 8 5 61-25 50-50 19-6 50-44 55 13 30-24-2-84 94 17 36 33 23 22 9 59-11 19 26-7 44-71 15-61 71-106 46-44 109 49 61 36 12 80-33 64 46 53 53 58-1 30-51 33-32h84l47-27 16-57 54-56 31-66-6-25 90-36 24 57 36 4 9-23 17 6 27 17 4 23 91 18 38 29 2 24 26 8 12-13 128 72 20 42 78 42 17 64 21 23 16 36 52 47 24 42 13 43v44l7 18-663 1553 2397 3710a28552 28552 0 0 0 795 212l421 843 1906 706 1349 501-503 4551a34499 34499 0 0 1-11307-3270l-53-113-1-10 22-329 56-82-84-60-1-285 93-36 62-192-120-71-65 96-178-56-55 26-80-37-34-78-47 10-35-28-17-131-117 61-32-76-56-30-45 77-54-37-63-67-67 2-98-42 103-281-72-23 33-110 84-14 88-299-45-84-110-45-115-381 67-43-6-65-64-15 17-102-29-274-129-2-172-178 70-45-15-80 95-71-23-48 108-38-75-189 38-333 168-128-74-91 23-125-64-125 65-33 80 37 55-105 61 21-11-300-74 3-3-70 120 7 55-105-104-9-23-134-70-126 57-35-49-27 6-115 69-14 27-292-74-95-93 20-124-71 152-89-66-60 30-182-41-42-32-134-76-24 3-71 87-16 42-87 108-10 17-50-67-43 62-100-94-9 30-86 112 10 70-63 93-15-2 2 179-118 33-174-37-154 145-22 22-41-78-22 20-65-70-13-124 58-28-50 80-52-26-76-209 8-50-74 66-50-29-71 118-34 47-135-67-69 184-156 1-2 63-6-53-227 111 13 44-160-42-50 29-68 103 46a26929 26929 0 0 1-801-583l92-171 122-63 42-119 130-203-52-67 1-14 33-36v-11z"/>
		<path mask="url(#all)" clip-path="url(#nt_nu-clip)" d="m-3208-21147-2324 9668a23675 23675 0 0 1-900-235l-26 92-3 27 38-1 5 26-46 12-42-9-21-20-9 31-84-24 50-173a23675 23675 0 0 1-1498-488l-51 110 86 328-69-30h-150v-9314z"/>
		<use xlink:href="#i-CA-NT"/>
	</g>
	<g id="NU" fill="#d3d3d3" >
		<path mask="url(#all)"  d="m-9491-12284 24 55 5 38 21 64 29 52 21 16 40 47 7 21 25 28 57 20 61 65 113 57 54 60 52 28 81 82 48 153 56 49 95 140 156 91 64 101 78-30 87 112 105 21 50 85 73 55 24-14-50-76 23-2-72-108 57-21 109 105 39-18-35-72 108 72 109 126 87 67 50 94-13 59 70 36 26 57v92l64 67 15 54-1 102-33 20 10 20 34 8-1-25 14-17 10 7 7 44-92 89 3 58-120-17-45-56h-79l-89-52 26 60 6 42-30-17-40 30-127-87 27 61-47 39-24 63 13 31 30-2-2 15-204 34 49 63 40 11-1 24 31 50 26 1 4 23 27 25 115 8 18 53 67 20 19 43 38 31 124 45 32 44 277 72 14 34 152 44 9 12 159 18-6-50 57 25h98l-10 64 26 10 9-67 46 1 89 66-7-23 32-13 23 14-17 22 18 16 51-69 69-29 32 14-51 34 66 18-12 31 112-30 55-48 190-67 42 7 27-41 42 13 19 82-28 63 30-6 44 38 2 46 33 35-34 23 40 47-45-14-2 18 54 56 25 1 22-59 39-16 12 15-15 14 39 37 26-20 71 39 8 114-12 81 19 19-53 41-2 57 33 13v83h24l109-289 36 45-13 40 9 86-15 43v119l56-104 121 210 20 135-17 133-50-63-25 35-30-38-16 46-10-19-5 55-42-37-60-81-31-74-14-10 13 149 20-9 4-39 34 47 16 56 57 31 20 59-21 77 51 11 8 58-16 46 12 80 12-3 12-89 54 159-29 1 51 123 28-14 18 91 27 30 34 114 31-19-38-107-46-63 10-24-47-69 14-44-20-36-7-51-30-25-12-29 38-9 11-64-8-145 23-74 39 74 6-2 5-123 13-5 36 69-3 114-15-1-3-15-28 10-10-37-24-19 8 66 35 11 9 32-27 26 30 24 3-33 7 1 12 46 15-6-15-40-19-21 7-19 25 17 28-22-22-80 11-4 39 43 45 73 11 74 24 11-23-58 14-16-17-47 2-45-82-115 94-7v-22l-15-15 46-14-3-6h-44l-9-32-8-3-3 29-9-2-52-96-37-223 36 5 11-59 31-40-36-55 16-14-112-226 67-120 13 25 56-34 29-2 40-63-38-24 46-77 51-4 62 37 51-12 54-62 17-4 11 10-19 14-9 32 55-22 29 28-7-30h63l20 37 18-32-12-112 40 20 8 44 17 1 2-53 20-27 47 76 5 32 36-18-23-36-28-13-3-17 47-101 52-2 42-45 25 31 44-28 14 21 28-32 20 18 46-51-6 67 37-37-4-13 22-31-24-76 26-27 28-54-10-8-38 27-31-43-68 15 4 23-143 38-79-2 25 71-48 16v26l42 21-54 53 9 64h-24l-17-73h-30l13-26-31-54-12 50-68-28-47 65-22 6-15 42-28-15-12 17-19-79-58-2-24-36-121-9-37 53 108 147-75-33-46 5-16 25-43-7 8-30-69-14-65 41-24 1-11-25 12-26 28 3 24-44-13-31-22 11-6 45-22-13 20-42 26-37 4-34-29-21-56 53-11-18-56 27-24-55 41-28 1-32 87-74 120-173 47-25 220 25 168-21 209-85 64 7 77-48 105-24 14-32 67 47 7 24 79 24 102 180-42 61 29 138-12 10 4 25 36 7v65l-31-36-76 69 91-3-16 58 40-3 11 39 38-1 20 41 51 12 10-51 26 58-65 59 31 19 28-25 97 29-61 110 35 3 14 140 77-19 50 41 94-26 22 41 73-18 16-45 27 38 38-14-1-39 41-57 23 11 20 66-20 7-4 84 58 73 36 6-4 74 66-35 12 64 27 53 56 33 92 23 38 69 34 12 44-48 24 36 40-18 8-39 22 18-9 41 53-9-14 54 13 7 8-29 22-4-3 37 22 9 10-21 21 12 15 33 27-11 27-21-2-26 20-7 9 33 23-24 22 16 19-62 24 39 34-48 3 60 69-19 6-36 36 5 2-25 39-27 48 9 16 34 47-31 85 2 40 19 4 16 77 20 4-18 20 3 15 21 24-2-3-25 12-3 11 26 31 2 12 30 16-19 63 11 41 31 42 68 47-39 8 28 48 4 11 25 34-70 23 37 43-35-5-42 16-6 18 42 118-8-23-45-8-38-22-14-18 14-37-60-10 3-33-51 10-2-3-122 41 9 25-40 33 79 105 139-6 34 17 33 27 89 215 197 84-28 42-42 16 12 4 30 10-4 10-55 46 15 3-13-28-31 29-53-6-4-51 62-12-4 5-25 46-54-6-6-13-63-21-14-15-70-9 38-49 13-94-128-9-40-11 6-11 58-32-1-19-20-50 61-11-6 3-21-7-39-20 53-15 13-3 104-19-11-20-42-7 4-8-21 6-30-78-113-15-67-43-63-8-26 16 8 24-42 18-1 9 39-13 23 17 41 42 4-3-91-44-29-30 1-5-25 15-17-70-105-13-41 35-15 44 60-2-102 40 67 22-7 57 73 70-16-34-35 104-27-13-73-40-78 42-33 112 64 114-1 114 159 51 117 89-31 19 52 96-85 3 5-29 35 4 23-35 103-27 3-12 52-20 34-38 1 7 79 24 2 50-65 19 39 25-71-24-3 33-59 201-115-1-18 19-15-1 23-19 18-12 46-43 61 29 53-85 304 15 233-41-19-20-81-11 4 11 74-8 43-20 42-20-4-23 101 28-42 16-2 6 28-15 34 23 6 18-16 36 35 45-60 6 47-14 35 10 50-36 9-39 105 59-22v57l120-98 43-85 21 70 42-64 25 36-24 58-104 139 9 7 27-28 80-34 30 26-4 62 32-26 24 6 43-68-3-51 38-6-62-62-38-145 39-44-12-59-40-48-28-49-19 3-11-15v-17l-45-18-10-52 75-87 7-117 42-85-28-53 105-20-29 57 29-8 53-61 29 53 46-19-1 26 67-10 59-111 41-15 23-37 106-94-19-97 78-98 59-20 99-88 32-51-47-30-35 21 20-120-13-27 50-103-23-35-17-112-71 17 6-53-98 146 31 46 27-32 10 8 43-41 4 2-112 148-52 16-9-15-54 25-16 17-12-23-20 12-10-28-16-6-24 13 39-155-25-90 64 25 47-100 38 13 28-45-15-5 13-42 32-18-5-9-65 24-30-49 18-79-10-8 15-35-18-20 6-28 77-34 70-17 12 24 67-82 47-25 10 11-124 186 7 54 19-11-21 49 7 14 112-158 34-23 27-59-55 39-26-17 44-112-3-39-37-34-63 28-16 36-13-18-18 18 5 24-37 22-128-3-84-126-25-103-16 22-11-54-43 8-11 25 23 45-32 47-26 6-38-43-153-78-124-131-20 58-165-140 53-32-28-23 23-34-36-21-20 8-91-145-25-166 21-130 43-64 25 11 11-95 31-81 15 47 15-4 9-45 19-15 45 45 56 18-3-17-89-53-5-54 57-56 7-13-82 53-20 50-78-73-20-75-55-44-1-67 26-55 26-152 34-22 12-32-10-23-17 43-45-65 49-51-21-116 66-11 39-107 52-30 67 36 10 55 32 26 25 34 21 1 12-14 18-32-25-35 38 2 8-32-39-36 41-80-136-19-32-65 28-16-21-21 27-29 33-3 87-107 73-10-8-22 21-78 17-2-16-37 19-95 208-50 23 10 4 35 38 15-12 35-27 14 18 9-7 46-36-6-12 112 20 5 23-83 8 3-2 45 11-9 13-31 17 8-1 19-14 9v122l27-59 21-23 2-47 21-16 13 41 16 1 10-17 19-13 6 40 24 12 20-4 31-29 27 8-3 45 8 6-38 76 37 30 14 37 50 40 61 25-8 19 60 54 21 83 40 8 21 27-8 24 54 174 8 130-18 156 30 45-37 20-22-37-16-2 31 55 67 16 37 43 22 88 117 52 8 34-18 16 19 26 2-17 6-20-7-28-8-16 41 31 18 37-45-2 28 76-34 16 63 9 4 47 28 18 30 69-13 80 26-3 9-29 21 3-24-57 63-8 15 16 4 42 6 74 62 58 4 47-156 37-47-6-6-34-65-35-35 15-48 118 121-32 64 32 18 51-118 173-91 67-5 60-27-6-77 71 114-22v12l-46 16-2 34 11-7 2-16 62-23 46 36 31-4 40 34-36 6 62 70 118 71 33-68 56-42-16-15 54-63h68l22 49-41 70-38 13-21-3-22 20 12 11 23-18 30-2 74-36 24 46 43-19 72 26 23-55 53 10 62 33 44 37-10 32-44 19-33-3-85 101 17 90-42 12-30-39-25 21-13-21 32-24 18-52-7-5-31 52-42 29-25-9-84-56 10 16 84 60 228 207-6 90 30-5 21 47-14 10 7 32 18-6 41 37-14 25 25 12-10 84-23 24 12 41 13-2-23 99 29 34-17 41 20 3-3 46-44 52 39 51 91 29-3 72 41 92 48-31 4-19-22-34 40-26-25-8 42-54-12-73 39-13-4-35 20-6 2-47-35-18-14-33-2-41 13-40 14-9 19-61 26 56v35l-9 9 14 11 4-53-8-32 8-16 7-62-8-22 7-31-21-16-25-150 40-98 44-52 37-102v-35l40-47 58-15 46 22 30 23-6 11 24 30 56 97 238 172 61 67 68 121 18 77 1 82 86 179-5 175-39 50-50-31h-51l-17-148-67 118 58 128 5 58-34 122 29 54 82 195 32 19-7 29 20 42 68 44 198 244 21-4 75 114 48 177 4-142 25-18 18 25 24-2-1-51 34 31 14-11-22-38-3-26-46-29 10-30 31 10 40-76 47-22 57 55v-49l13 6 15 62 29-31-22-46 9-108-8-51 12-19v-22l-19-11-25-79 4-27 74-209 18-8 24-87 83-84-27-160 47-35-37-17 1-40 22-31-24-26 29-86-44-266 29-110 27 3 37-18-40-34 46-8 36 22-16 21 47 4 37 15-47-38 26-17h81l90 4 13-35-36-40-24-12-51 29-33-13-28 8-1-22-17-13 7-23 60-9-7-46-46-12-20-25 34-8 26 5 74 7 12-28-68-15 50-64 53 12 45 18-3-34-81-3 3-45-48 16-42-5 15-17-11-11-29 4 20-28-14-15-7 12-30 36-12-6 8-52-32-2-4 51-58-30 30-25-62-25-59-116-9-101 34-7 10-16-22-13-30 11-22-50 12-89 28-12-66-70 34-92-42-27 50-76-91 11 4-46h67l126 61 23-27 53-27-17-37 70 1 50-33 50-6 125 35 3 27 225 70 89-9 9-35 254-17-32-24 52-2 25 37 91-1 19 9-61 40-30-33-53 3-1 42 42 15-7 53 18-4 37 52-195 12 131 21 174 54-45 26 100 77-47 43 19 22 74-16v-36l129-21 102 55 20-22 29 16 18 57 35 45-13 13-17-14-25 15 2 19-29 10 1 46-25 54-37-5 14 30-7 28-8-5-89 86 34-13 21-24 76-11 28 24 13 51 13-1 6-41 25-2-1-25 48 25 60 92-16 5 30 120-31 64-70 75-1 22-84 7 12 71-49 51-37-23-30-55-76-23 36 54-1 30-107-1-52-38-16 32 57 19 8 28-29 14-33-3 17 46 67-20 7 28 49-4 56 16-14-33 92 24-13 51-53-32-35 13-28-21 11 41-66 7 58 50 35-44 26 49-26 105 80 34 32-125 28 23-36 227 26 27 18 54 73 56 20 34 31 5 48 27-51-11 119 80 11 32 107 56 107 136-19 158 22 157-9 59 16 51-14 11 3 69-19 12-31-14-49 57-42-24-67 68-1 72-16 40 22 20-41 65 28 61-4 16-35-9-22 8-25-12-11 13 16 21-52 34 17 25-41 31-2 74-45 17-76 5-5 21-42 2 11 72-36 55-24 15-16 38-52 70 9-43-28 45-62 18-44-74 58 24-27-55-52-40-11-43-77-8-32-47-25 20-25-39-23-84 31-17-14-14-1-68 21-11-17-97-30-41 22 42-1 54 15 22-25 20 4 63-11 35h-14l5-32-20-2-14 49-72-4-19-20-4-27-37 50 26 13 110 4 8 43-11 34 10 53 45 24 86 78 36 94-8 11 23 42 23 2 19 18-2 21 48 48 3 12 3 23-58 52-8-20 15-51-64 29-93-58-8-32-18-17-37-3 8 15-34 9 15 22-12 11-44-40 4-14-58-74-46 75 18 26 30-3 26 42 60 47 11 41-5 18-34 8-59-56-4 17-41-17-6 23-27 1-50-48h-25l6 19-14 16-39-32-43-15-25 45-37-16-47-124-9-86-49-48-33-77-126 125-132 21-39-16-28 6-42-24 6 35-25-1-84-38 9 48-82-12 14 52 57 50-77-5 101 135 42-7 84 17 200 88-13 161-166 219-24 222-171 171-39 132-99 98-241 25-79-14-96-54-110-134-191-95 197-4-235-36-424-289 47 54-114-11 129 83-16 46-135-54-65 21-118-2 195 57 184 115 104 101 43 107 84 39 66 125 200-12 136 26 336-51 254 31 8 53 43 19-23 83 17 44-29 22-22 42 40 30-60 52-42 197-80 75 6 75-28 71-98 63-6 147-74 143 20 50-42 71-41-17-160 179-102 46-88-24-47-5-71-65 78 108-10 26-24 6-55-4-38-58-109-47 28 101-43-62-57-58 15 68-84-112-70-13 89 138 6 111-89 52-10-75-71-10 116 164-105 221-53-10-271 78 166 25-43 94-155-98 7-32-215-70-64-66-57 7-45-25-192 5-95-34-32 6-45-57-32-10-58 11-49-35 8-22-92-12-16-51-62 25-16-31-159-57-38 32-88-12 56 124 123 30-57-116 48-17 81 72 156 65 44 6 89 63 26-49 38 7 45 79 67-21 69 63-50 20v40l-63 30-46 61 50 1 16-27 12 11 33-15 1-34 76-38-1-28 63-57 59-7 92 60-16 68 66 18 70 88 50-19 134 38 163 105-31 46 76 261-40 116-44 57-42-23-57 7-184 171-221-20-130-39-6 17 38 38-13 16-36-19 16 26-19 7-75-69-59 43 43 80 106 70 135 27 9 61-70 60-129-29-96 34-69-51 70 149 187 21 6 44-113 24-19-42-122 10-12-96-81 21 51 77-32 24 89 46 6 90 58 109-79-5 10-60-39-33-44-70-128-27-17 13 94 34 58 60-26 53-50-41-82 16-51 46 97 57-65 79-22-23-24 13 38 71-60-18-38-59-18 51 77 62-35 12-36-18-18 13 40 41-23 28-149-88 73 86-78 14 202 100-23 57-119 49-227 245 11 65 77 49-45 53-81 7 19 114-28 18 2 65 55 15-7 11-58 12-37 50-29 159-47 24-61 127 5 47-51 76-17 108-200 30 129 43 25 93-50 149 17 158-35 19L94 1a34500 34500 0 0 1-3883-209l503-4551-1349-501-1906-706-421-843a28552 28552 0 0 1-795-212l-2397-3710z"/>
		<path  mask="url(#all)" clip-path="url(#nt_nu-clip)" d="m-8102-11833 69 30-86-328 51-110a23675 23675 0 0 0 1498 488l-50 173 84 24 9-31 21 20 42 9 46-12-5-26-38 1 3-27 26-92a23675 23675 0 0 0 900 235l2324-9668h1000v13000h-7000v-3686z"/>
		<path mask="url(#all)" clip-path="url(#nu_nl-clip)" d="m15741-4139 5-203h-300v203z"/>
		<use mask="url(#all)" xlink:href="#i-CA-NU"/>
	</g>
	</svg>

	<div class="footer_nCoV"><div class="controls_nCoV"><span id="zoom-in-nCoV-Ca" class="zoom-in-nCoV">Zoom in</span><span id="zoom-out-nCoV-Ca" class="zoom-out-nCoV">Zoom out</span></div><div class="legend_nCoV"><span>0</span><span>&gt;&nbsp;20000</span></div></div>
	</div>
	<script>!function(v){"use strict";v(document).ready(function(){a.ready()}),v(window).load(function(){a.load()});var a=window.$ncrts_frontend={ready:function(){this.mapIn()},load:function(){},mapIn:function(){for(var a=covidCa.province,t=0;t<a.length;t++){var s=v('.map_nCoV [title="'+a[t].state+'"]'),e=0;if(s.length){var n=a[t].cases,r=a[t].deaths,o=a[t].active;5<n&&(e=1),100<n&&(e=2),1e3<n&&(e=3),1e4<n&&(e=4),2e4<n&&(e=5),5e4<n&&(e=6),s.attr("data-level",e),s.attr("data-cases",n),s.attr("data-deaths",r),s.attr("data-active",o)}}var i=v(".map_nCoV .tooltip_nCoV-Ca"),d=i.attr("data-confirmed"),c=i.attr("data-deaths"),l=i.attr("data-active");v(".map_nCoV path").mouseenter(function(){var a=v(this).attr("data-cases")?v(this).attr("data-cases"):0,t=v(this).attr("data-deaths")?v(this).attr("data-deaths"):0,s=v(this).attr("data-active")?v(this).attr("data-active"):0;i.addClass("active"),i.html('<span class="val-title">'+v(this).attr("title")+'</span><br/><span class="val-number">'+d+": "+a+'</span><br/><span class="val-number">'+c+": "+t+'</span><br/><span class="val-number">'+l+": "+s+"</span>")}).mouseleave(function(){i.removeClass("active")}),v(".map_nCoV svg").on("mousemove",function(a){i.css({left:a.offsetX+40,top:a.offsetY+60})})}}}(jQuery);</script>
	
	<?php if((isset($all_options['cov_zoom']) ? $all_options['cov_zoom'] : null)==!'on') 
	echo '<script>jQuery(document).ready(function(t){var e;e={haltEventListeners:["touchstart","touchend","touchmove","touchleave","touchcancel"],init:function(t){var e=t.instance,n=1,o=0,a=0;this.nycreatis=Nycreatis(t.svgElement,{inputClass:Nycreatis.SUPPORT_POINTER_EVENTS?Nycreatis.PointerEventInput:Nycreatis.TouchInput}),this.nycreatis.get("pinch").set({enable:!0}),this.nycreatis.on("doubletap",function(t){e.zoomIn()}),this.nycreatis.on("panstart panmove",function(t){"panstart"===t.type&&(a=o=0),e.ncrtsBy({x:t.deltaX-o,y:t.deltaY-a}),o=t.deltaX,a=t.deltaY}),this.nycreatis.on("pinchstart pinchmove",function(t){"pinchstart"===t.type&&(n=e.getZoom(),e.zoomAtPoint(n*t.scale,{x:t.center.x,y:t.center.y})),e.zoomAtPoint(n*t.scale,{x:t.center.x,y:t.center.y})}),t.svgElement.addEventListener("touchmove",function(t){t.preventDefault()})},destroy:function(){this.nycreatis.destroy()}},window.ncrtsZin=PncrtsZ("#nycreatis-nCoVsvgmapIn",{zoomEnabled:!0,controlIconsEnabled:!1,fit:1,center:1,customEventsHandler:e}),document.getElementById("zoom-in-nCoV-Ca").addEventListener("click",function(t){t.preventDefault(),ncrtsZin.zoomIn()}),document.getElementById("zoom-out-nCoV-Ca").addEventListener("click",function(t){t.preventDefault(),ncrtsZin.zoomOut()})});</script><style>:root .controls_nCoV{display:-webkit-flex;display:-ms-flexbox;display:flex}</style>';
	 ?>
	 
     <div class="tooltip_nCoV-Ca mapCa" data-confirmed="<?php echo esc_html($params['confirmed_title']); ?>" data-active="<?php echo esc_html($params['active_title']); ?>" data-deaths="<?php echo esc_html($params['deaths_title']); ?>"></div>
</div>

	<script type='text/javascript'>
	/* <![CDATA[ */
	var covidCa = <?php $responseUs = wp_remote_get( 'https://nycreatis.com/code/corvid/api/v2/library/ca_map.json' ); $bodyUs = wp_remote_retrieve_body( $responseUs ); echo $bodyUs;?>
	/* ]]> */
	</script>