<?php
global 	$directory_url;
$directory_url=get_option('_iv_directory_url');
if($directory_url==""){$directory_url='directories';}

function dirpro_taxonomy_add_category_custom_field() {
    ?>	

	 <div class="form-field term-image-wrap">
        <label for="cat-marker"><?php esc_html_e('Map Marker','ivdirectories');?></label>
        <p><a href="#" class="aw_upload_image_button button button-secondary" id="upload_marker_btn"><?php esc_html_e('Upload Marker','ivdirectories');?></a></p>
        <input type="text" name="category_marker_url" id="category_marker_url"  value="" size="40" />
    </div>	
    <div class="form-field term-image-wrap">
        <label for="cat-image"><?php esc_html_e('Image','ivdirectories');?></label>		
        <p><a href="#" class="aw_upload_image_button button button-secondary" id="upload_image_btn"><?php esc_html_e('Upload Image','ivdirectories');?></a></p>
        <input type="text" name="category_image_url" id="category_image_url"  value="" size="40" />
    </div>	
 <?php
}
add_action( $directory_url.'-category_add_form_fields', 'dirpro_taxonomy_add_category_custom_field', 10, 2 );
 
function dirpro_taxonomy_edit_category_custom_field($term) {
    $image = get_term_meta($term->term_id, 'dirpro_term_image', true);
	$caticon= get_term_meta($term->term_id, 'dirpro_term_icon', true);
	$map_marker= get_term_meta($term->term_id, 'dirpro_term_mapmarker', true);
    ?>
	
	 <tr class="form-field term-image-wrap">
        <th scope="row"><label for="category_marker_url"><?php esc_html_e('Map Marker','ivdirectories');?></label></th>
        <td>
            <p><a href="#" class="aw_upload_image_button button button-secondary" id="upload_marker_btn"><?php esc_html_e('Upload Map Marker','ivdirectories');?> </a>				
				<img src="<?php echo esc_url($map_marker); ?>" id="dirpro_term_marker_dis" width="100px">
			</p>			
			<br/>
            <input type="text" name="category_marker_url"  id="category_marker_url" value="<?php echo esc_url($map_marker); ?>" size="40" />
        </td>
    </tr>
	
	 <tr class="form-field term-image-wrap">
        <th scope="row"><label for="category_image_url"><?php esc_html_e('Image','ivdirectories');?></label></th>
        <td>
            <p><a href="#" class="aw_upload_image_button button button-secondary" id="upload_image_btn"><?php esc_html_e('Upload Image','ivdirectories');?> </a>				
				<img src="<?php echo esc_url($image); ?>" id="dirpro_term_image_dis" width="100px">
			</p>			
			<br/>
            <input type="text" name="category_image_url"  id="category_image_url" value="<?php echo esc_url($image); ?>" size="40" />
        </td>
    </tr>
	
   
    <?php
}
add_action( $directory_url.'-category_edit_form_fields', 'dirpro_taxonomy_edit_category_custom_field', 10, 2 );

// Save data
add_action('created_'.$directory_url.'-category', 'dirpro_save_term_category_image', 10, 2);
function dirpro_save_term_category_image($term_id, $tt_id) {
    if (isset($_POST['category_image_url']) && '' !== $_POST['category_image_url']){
        $group = sanitize_url($_POST['category_image_url']);
        add_term_meta($term_id, 'dirpro_term_image', $group, true);
    }
	if (isset($_POST['category_marker_url']) && '' !== $_POST['category_marker_url']){
        $group = sanitize_url($_POST['category_marker_url']);
        add_term_meta($term_id, 'dirpro_term_mapmarker', $group, true);
    }
	
	if (isset($_POST['cat-icon']) && '' !== $_POST['cat-icon']){
        $caticon = sanitize_text_field($_POST['cat-icon']);
        add_term_meta($term_id, 'dirpro_term_icon', $caticon, true);
    }
	
}

///Now save the edited value
add_action('edited_'.$directory_url.'-category', 'dirpro_update_image_upload_category', 10, 2);
function dirpro_update_image_upload_category($term_id, $tt_id) {
    if (isset($_POST['category_image_url']) && '' !== $_POST['category_image_url']){
        $group = sanitize_url($_POST['category_image_url']);
        update_term_meta($term_id, 'dirpro_term_image', $group);
    }
	if (isset($_POST['category_marker_url']) && '' !== $_POST['category_marker_url']){
		 $group = sanitize_url($_POST['category_marker_url']);
        update_term_meta($term_id, 'dirpro_term_mapmarker', $group);
    }
	
	if (isset($_POST['cat-icon']) && '' !== $_POST['cat-icon']){	
         $caticon = sanitize_text_field($_POST['cat-icon']);
         update_term_meta($term_id, 'dirpro_term_icon', $caticon);
    }
}

// Js add
function dirpro_image_uploader_enqueue_category() {
    global $typenow,$directory_url;	
    if( ($typenow == $directory_url) ) { 
		wp_enqueue_media();
        wp_register_script( 'dirpro_meta-image', wp_iv_directories_URLPATH . 'admin/files/js/meta-media-uploader.js', array( 'jquery' ) );
        wp_localize_script( 'dirpro_meta-image', 'meta_image',
            array(
                'title' => 'Upload an Image',
                'button' => 'Use this Image',
            )
        );
        wp_enqueue_script( 'dirpro_meta-image' );
    }
}
add_action( 'admin_enqueue_scripts', 'dirpro_image_uploader_enqueue_category' );