<?php
wp_enqueue_script("jquery");
wp_enqueue_style('iv_directories-style-64', wp_iv_directories_URLPATH . 'assets/cube/css/cubeportfolio.css');
wp_enqueue_style('iv_directories-style-11222', wp_iv_directories_URLPATH . 'admin/files/css/listing_style_4.css');
wp_enqueue_style('iv-bootstrap-4', wp_iv_directories_URLPATH . 'admin/files/css/iv-bootstrap-4.css');
wp_enqueue_style('iv_property-style-111', wp_iv_directories_URLPATH . 'admin/files/css/styles.css');
$main_class = new wp_iv_directories;

$directory_url=get_option('_iv_directory_url');
if($directory_url==""){$directory_url='directories';}
$current_post_type=$directory_url;

$post_limit='9999';
if(isset($atts['post_limit']) and $atts['post_limit']!="" ){
 $post_limit=sanitize_text_field($atts['post_limit']);
}


	$args = array(
			'post_type' => $current_post_type, // enter your custom post type
			'post_status' => 'publish',			
			'posts_per_page'=> $post_limit,  // overrides posts per page in theme settings
			'orderby' => 'title',
			'order' => 'ASC',
			);
	if(isset($atts['category'] )){
		$postcats = get_query_var($current_post_type.'-'.$atts['category']);
		$args[$current_post_type.'-category']=esc_html($atts['category']);
		$selected=$postcats;
		$args['posts_per_page']='9999';
	}

	// Meta Query***********************
	$city_mq ='';
	if(isset($atts['city']) AND $atts['city']!=''){
			$city_mq = array(
			'relation' => 'AND',
				array(
					'key'     => 'city',
					'value'   => sanitize_text_field($atts['city']),
					'compare' => 'LIKE'
				),
			);
	}

	$zip_mq='';
	if(isset($atts['zipcode']) AND $atts['zipcode']!=''){
		$zip_mq = array(
			'relation' => 'AND',
				array(
					'key'     => 'postcode',
					'value'   => sanitize_text_field($atts['zipcode']),
					'compare' => 'LIKE'
				),
			);
	}

	$args['meta_query'] = array(
		$city_mq, $zip_mq,
	);
	$filter_query = new WP_Query( $args );

		$div_id=rand(1, 500);
?>


<div class="bootstrap-wrapper background-transparent">
	<div class="container ">
		<div class="row justify-content-center">
<?php
		if ( $filter_query->have_posts() ) : ?>

		

				<?php
				while ( $filter_query->have_posts() ) : $filter_query->the_post();
				$id = get_the_ID();
				$feature_img='';
				if(has_post_thumbnail()){
					$feature_image = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), 'medium' );
					if($feature_image[0]!=""){
						$feature_img =$feature_image[0];
					}
				}else{
					$feature_img= $this->get_dirpro_listing_default_image();

				}
				

				?>					
				<div class="col-xl-3 col-lg-3 col-md-3  col-sm-6 col-12  mt-4 mb-4" id="<?php echo esc_html($i); ?>" >
					<div class=" card-border-round-filter mb-2 " >	
							<div class="card-img-container-filter">
								<a href="<?php echo get_the_permalink($id);?>"><img src="<?php echo esc_attr($feature_img);?>" class="card-img-top-listing">					
									</a>
							</div>								
						<div class="card-body  ">
							<span class="cat_title"> <?php echo substr(get_the_title($id),0,1000); ?></span>
							<?php 
								$currentlocation = $main_class->eplisting_get_locations_caching($id,$directory_url);
								$locations='';
								if(isset($currentlocation[0]->slug)){										
									foreach($currentlocation as $c){
										$locations = $locations .' '.$c->name;
									}	
								}											
								if(trim($locations)!=''){?>
								<p class="card-text p-0 mt-2 address"><i class="fas fa-map-marker-alt mr-1"></i> 
									<?php 																				
											echo esc_html($locations);?>
									</p>
								<?php
								}
								?>	
						</div>
					</div>
				</div>
				
	<?php
				endwhile;
				?>
				
	<?php
		endif;
		
	wp_reset_query();	
	?>				</div>
			</div>
		</div>



