/* globals GravityKit, jQuery, window */
/**
 * Setups the main variable for this file.
 *
 * @since 3.1.3
 *
 * @type   {Object}
 */
GravityKit.GravityMaps.Controllers = GravityKit.GravityMaps.Controllers || {};
GravityKit.GravityMaps.Controllers.View = {};

( ( $, view ) => {
	"use strict";
	const { Marker, Map } = GravityKit.GravityMaps.Controllers;

	/**
	 * Creates a local alias for Utils.className() method.
	 */
	const { className } = GravityKit.GravityMaps.Utils;

	/**
	 * The selectors for the view.
	 *
	 * @since 3.1.3
	 *
	 * @type {object}
	 */
	view.selectors = {
		views: {
			map: '.gv-map-container',
			list: '.gv-list-container',
			table: '.gv-table-container',
		},

		wrapper: `[id^="gv-view-"]`,
		wrapperById: ( id ) => `[id^="gv-view-${id}-"]`,

		container: '.gv-container',
		containerById: ( id ) => `${view.selectors.viewContainer}-${id}`,

		paginationLink: '.gv-widget-page-links .page-numbers',

		header: '.gv-widgets-header',
		searchForm: '.gv-widget-search',

		footer: '.gv-widgets-footer',

		noResults: '.gv-no-results',
		noResultsFlag: '.gk-maps-no-results-flag',
	};

	/**
	 * Gets the wrapper for the given map canvas.
	 *
	 * @since 3.1.3
	 *
	 * @param {jQuery} $map The jQuery object of the map canvas.
	 *
	 * @return {jQuery}
	 */
	view.getWrapper = ( $map ) => {
		const data = Map.getData( $map );
		if ( ! data || ! data.view_id ) {
			return $map.closest( view.selectors.wrapper );
		}

		return $map.closest( view.selectors.wrapperById( data.view_id ) );
	};

	/**
	 * Gets the container for the given map canvas.
	 *
	 * @since 3.1.3
	 *
	 * @param {jQuery} $map The jQuery object of the map canvas.
	 *
	 * @return {jQuery}
	 */
	view.getContainer = ( $map ) => {
		const data = Map.getData( $map );
		const $wrapper = view.getWrapper( $map );
		if ( ! data || ! data.view_id ) {
			return $wrapper.find( view.selectors.container );
		}

		return $wrapper.find( view.selectors.containerById( data.view_id ) );
	};

	/**
	 * Get the type of view that is being used base on it's container.
	 *
	 * @since 3.1.3
	 *
	 * @param {jQuery} $element The jQuery object of the element to check.
	 *
	 * @return {string}
	 */
	view.getType = ( $element ) => {
		let $container = $element;
		if ( ! $element.is( view.selectors.container ) ) {
			$container = $element.closest( view.selectors.container );
		}

		const availableTypes =  [ 'map', 'list', 'table' ];

		for ( const type of availableTypes ) {
			if ( $container.hasClass( className( view.selectors.views[ type ] ) ) ) {
				return type;
			}
		}
		return 'other';
	};

} )( jQuery, GravityKit.GravityMaps.Controllers.View );