/* globals GravityKit, jQuery, ajaxurl, Qs */
/**
 * Setups the main variable for this file.
 *
 * @since 3.1.0
 *
 * @type {Object}
 */
GravityKit.GravityMaps.Utils = {};

( ( $, obj ) => {
    "use strict";

	/**
	 * Turns a HTML Class into a class name
	 *
	 * @since 3.1.0
	 *
	 * @param {string} value
	 * @return {string}
	 */
	obj.className = ( value ) => {
		// Prevent Non Strings to be included
		if (
			(
				'string' !== typeof value
				&& ! this instanceof String
			)
			|| 'function' !== typeof value.replace
		) {
			return value;
		}

		return value.replace( '.', '' );
	};

	/**
	 * Calculate KM from a miles numeric value.
	 *
	 * @since 3.1.0
	 *
	 * @param {number} miles
	 *
	 * @return {number}
	 */
	obj.mileToKm = ( miles ) => {
		return miles * 1.609344;
	};

	/**
	 * Log with Console.log if the debug mode is enabled.
	 *
	 * @since 3.1.3
	 *
	 * @param {*} args
	 *
	 * @return {void}
	 */
	obj.debug = {
		log: ( ...args ) => {
			if ( ! GravityKit.GravityMaps.isDebug ) {
				return;
			}
			console.log( ...args );
		},
		info: ( ...args ) => {
			if ( ! GravityKit.GravityMaps.isDebug ) {
				return;
			}
			console.info( ...args );
		},
	}
} )( jQuery, GravityKit.GravityMaps.Utils );