function MarkerClusterer(map,opt_markers,opt_options){this.extend(MarkerClusterer,google.maps.OverlayView),this.map_=map,this.markers_=[],this.clusters_=[],this.markersCluster_={},this.markersUniqueID=1,this.sizes=[53,56,66,78,90],this.styles_=[],this.cssClass_="",this.cssDefaultClass_="cluster",this.setIndex_=0,this.ready_=!1;var options=opt_options||{};this.gridSize_=void 0!==options.gridSize?options.gridSize:60,this.minClusterSize_=options.minimumClusterSize||2,this.ignoreHiddenMarkers_=options.ignoreHiddenMarkers||!1,this.maxZoom_=options.maxZoom||null,this.styles_=options.styles||[],this.cssClass_=options.cssClass||null,this.imagePath_=options.imagePath||this.MARKER_CLUSTER_IMAGE_PATH_,this.imageExtension_=options.imageExtension||this.MARKER_CLUSTER_IMAGE_EXTENSION_,this.zoomOnClick_=!0,null!=options.zoomOnClick&&(this.zoomOnClick_=options.zoomOnClick),this.averageCenter_=!1,null!=options.averageCenter&&(this.averageCenter_=options.averageCenter),this.onMouseoverCluster_=options.onMouseoverCluster,this.onMouseoutCluster_=options.onMouseoutCluster,this.drawCluster_=options.drawCluster,this.hideCluster_=options.hideCluster,this.showCluster_=options.showCluster,this.onAddCluster_=options.onAddCluster,this.onRemoveCluster_=options.onRemoveCluster,this.setupStyles_(),this.setMap(map),this.prevZoom_=this.map_.getZoom();var that=this;google.maps.event.addListener(this.map_,"zoom_changed",function(){var zoom=that.map_.getZoom();that.prevZoom_!=zoom&&(that.prevZoom_=zoom,that.resetViewport())}),google.maps.event.addListener(this.map_,"idle",function(){that.redraw()}),opt_markers&&opt_markers.length&&this.addMarkers(opt_markers,!1)}function Cluster(markerClusterer){this.markerClusterer_=markerClusterer,this.map_=markerClusterer.getMap(),this.gridSize_=markerClusterer.getGridSize(),this.minClusterSize_=markerClusterer.getMinClusterSize(),this.averageCenter_=markerClusterer.isAverageCenter(),this.center_=null,this.markers_=[],this.bounds_=null,this.clusterIcon_=new ClusterIcon(this,markerClusterer.getStyles(),markerClusterer.getGridSize())}function ClusterIcon(cluster,styles,opt_padding){cluster.getMarkerClusterer().extend(ClusterIcon,google.maps.OverlayView),this.styles_=styles,this.padding_=opt_padding||0,this.cluster_=cluster,this.center_=null,this.map_=cluster.getMap(),this.div_=null,this.sums_=null,this.visible_=!1,this.setMap(this.map_)}function defaultClusterOnAdd(clusterIcon){if(clusterIcon.div_=document.createElement("DIV"),clusterIcon.visible_){var pos=clusterIcon.getPosFromLatLng_(clusterIcon.center_);clusterIcon.div_.style.cssText=clusterIcon.createCss(pos),clusterIcon.div_.innerHTML=clusterIcon.sums_.text,clusterIcon.addClass()}clusterIcon.getPanes().overlayMouseTarget.appendChild(clusterIcon.div_);var isDragging=!1,isMouseDown=!1;google.maps.event.addDomListener(clusterIcon.div_,"click",function(event){isDragging||clusterIcon.triggerClusterClick(event)}),google.maps.event.addDomListener(clusterIcon.div_,"mousedown",function(){isMouseDown=!(isDragging=!1)}),google.maps.event.addDomListener(clusterIcon.div_,"mouseup",function(){isMouseDown=isDragging=!1}),google.maps.event.addDomListener(clusterIcon.div_,"mousemove",function(){isMouseDown&&(isDragging=!0)}),google.maps.event.addDomListener(clusterIcon.div_,"mouseover",function(event){clusterIcon.triggerClusterMouseover(event)}),google.maps.event.addDomListener(clusterIcon.div_,"mouseout",function(event){clusterIcon.triggerClusterMouseout(event)})}function defaultClusterDraw(clusterIcon){if(clusterIcon.visible_){var pos=clusterIcon.getPosFromLatLng_(clusterIcon.center_);clusterIcon.div_.style.top=pos.y+"px",clusterIcon.div_.style.left=pos.x+"px"}}function defaultClusterHide(clusterIcon){clusterIcon.div_&&(clusterIcon.div_.style.display="none",clusterIcon.div_.className=""),clusterIcon.visible_=!1}function defaultClusterShow(clusterIcon){if(clusterIcon.div_){var pos=clusterIcon.getPosFromLatLng_(clusterIcon.center_);clusterIcon.div_.style.cssText=clusterIcon.createCss(pos),clusterIcon.div_.style.display="",clusterIcon.addClass()}clusterIcon.visible_=!0}function defaultClusterOnRemove(clusterIcon){clusterIcon.div_&&clusterIcon.div_.parentNode&&(clusterIcon.hide(),clusterIcon.div_.parentNode.removeChild(clusterIcon.div_),clusterIcon.div_=null)}MarkerClusterer.prototype.MARKER_CLUSTER_IMAGE_PATH_="https://raw.githubusercontent.com/gmaps-marker-clusterer/gmaps-marker-clusterer/master/images/m",MarkerClusterer.prototype.MARKER_CLUSTER_IMAGE_EXTENSION_="png",MarkerClusterer.prototype.extend=function(obj1,obj2){return function(object){for(var property in object.prototype)this.prototype[property]=object.prototype[property];return this}.apply(obj1,[obj2])},MarkerClusterer.prototype.onAdd=function(){this.setReady_(!0)},MarkerClusterer.prototype.draw=function(){},MarkerClusterer.prototype.setupStyles_=function(){if(!this.styles_.length)for(var size,i=0;size=this.sizes[i];i++){var url="";url="function"==typeof this.imagePath_?this.imagePath_(i,size):this.imagePath_+(i+1)+"."+this.imageExtension_,this.styles_.push({url:url,height:size,width:size})}},MarkerClusterer.prototype.fitMapToMarkers=function(){for(var marker,markers=this.getMarkers(),bounds=new google.maps.LatLngBounds,i=0;marker=markers[i];i++)bounds.extend(marker.getPosition());this.map_.fitBounds(bounds)},MarkerClusterer.prototype.setStyles=function(styles){this.styles_=styles},MarkerClusterer.prototype.getStyles=function(){return this.styles_},MarkerClusterer.prototype.isZoomOnClick=function(){return this.zoomOnClick_},MarkerClusterer.prototype.isAverageCenter=function(){return this.averageCenter_},MarkerClusterer.prototype.getMarkers=function(){return this.markers_},MarkerClusterer.prototype.getTotalMarkers=function(){return this.markers_.length},MarkerClusterer.prototype.setMaxZoom=function(maxZoom){this.maxZoom_=maxZoom},MarkerClusterer.prototype.getMaxZoom=function(){return this.maxZoom_},MarkerClusterer.prototype.getMarkersCluster=function(marker){return this.clusters_[this.markersCluster_[marker.uniqueID]]},MarkerClusterer.prototype.calculator_=function(markers,numStyles){for(var index=0,count=markers.length,dv=count;0!==dv;)dv=parseInt(dv/10,10),index++;return{text:count,index:index=Math.min(index,numStyles)}},MarkerClusterer.prototype.setCalculator=function(calculator){this.calculator_=calculator},MarkerClusterer.prototype.getCalculator=function(){return this.calculator_},MarkerClusterer.prototype.addMarkers=function(markers,opt_nodraw){for(var marker,i=0;marker=markers[i];i++)this.pushMarkerTo_(marker);opt_nodraw||this.redraw()},MarkerClusterer.prototype.pushMarkerTo_=function(marker){if(marker.isAdded=!1,marker.draggable){var that=this;google.maps.event.addListener(marker,"dragend",function(){marker.isAdded=!1,that.repaint()})}marker.uniqueID=this.markersUniqueID,this.markersUniqueID++,this.markers_.push(marker)},MarkerClusterer.prototype.addMarker=function(marker,opt_nodraw){this.pushMarkerTo_(marker),opt_nodraw||this.redraw()},MarkerClusterer.prototype.removeMarker_=function(marker){var index=-1;if(this.markers_.indexOf)index=this.markers_.indexOf(marker);else for(var m,i=0;m=this.markers_[i];i++)if(m==marker){index=i;break}return-1!=index&&(marker.setMap(null),this.markers_.splice(index,1),delete this.markersCluster_[marker.uniqueID],!0)},MarkerClusterer.prototype.removeMarker=function(marker,opt_nodraw){var removed=this.removeMarker_(marker);return!(opt_nodraw||!removed)&&(this.resetViewport(),this.redraw(),!0)},MarkerClusterer.prototype.removeMarkers=function(markers,opt_nodraw){for(var removed=!1,i=markers.length;0<=i;i--){var marker=markers[i],r=this.removeMarker_(marker);removed=removed||r}if(!opt_nodraw&&removed)return this.resetViewport(),this.redraw(),!0},MarkerClusterer.prototype.setReady_=function(ready){this.ready_||(this.ready_=ready,this.createClusters_())},MarkerClusterer.prototype.getTotalClusters=function(){return this.clusters_.length},MarkerClusterer.prototype.getClusters=function(){return this.clusters_},MarkerClusterer.prototype.getMap=function(){return this.map_},MarkerClusterer.prototype.setMap=function(map){this.map_=map},MarkerClusterer.prototype.getGridSize=function(){return this.gridSize_},MarkerClusterer.prototype.setGridSize=function(size){this.gridSize_=size},MarkerClusterer.prototype.getMinClusterSize=function(){return this.minClusterSize_},MarkerClusterer.prototype.setMinClusterSize=function(size){this.minClusterSize_=size},MarkerClusterer.prototype.getExtendedBounds=function(bounds){var projection=this.getProjection(),tr=new google.maps.LatLng(bounds.getNorthEast().lat(),bounds.getNorthEast().lng()),bl=new google.maps.LatLng(bounds.getSouthWest().lat(),bounds.getSouthWest().lng()),trPix=projection.fromLatLngToDivPixel(tr);trPix.x+=this.gridSize_,trPix.y-=this.gridSize_;var blPix=projection.fromLatLngToDivPixel(bl);blPix.x-=this.gridSize_,blPix.y+=this.gridSize_;var ne=projection.fromDivPixelToLatLng(trPix),sw=projection.fromDivPixelToLatLng(blPix);return bounds.extend(ne),bounds.extend(sw),bounds},MarkerClusterer.prototype.isMarkerInBounds_=function(marker,bounds){return bounds.contains(marker.getPosition())},MarkerClusterer.prototype.clearMarkers=function(){this.resetViewport(!0),this.markers_=[],this.markersCluster_={},this.markersUniqueID=1},MarkerClusterer.prototype.resetViewport=function(opt_hide){for(var cluster,i=0;cluster=this.clusters_[i];i++)cluster.remove();var marker;for(i=0;marker=this.markers_[i];i++)marker.isAdded=!1,opt_hide&&marker.setMap(null);this.clusters_=[],this.markersCluster_={},this.markersUniqueID=1},MarkerClusterer.prototype.repaint=function(){var oldClusters=this.clusters_.slice();this.clusters_.length=0,this.resetViewport(),this.redraw(),window.setTimeout(function(){for(var cluster,i=0;cluster=oldClusters[i];i++)cluster.remove()},0)},MarkerClusterer.prototype.redraw=function(){this.createClusters_()},MarkerClusterer.prototype.distanceBetweenPoints_=function(p1,p2){if(!p1||!p2)return 0;var dLat=(p2.lat()-p1.lat())*Math.PI/180,dLon=(p2.lng()-p1.lng())*Math.PI/180,a=Math.sin(dLat/2)*Math.sin(dLat/2)+Math.cos(p1.lat()*Math.PI/180)*Math.cos(p2.lat()*Math.PI/180)*Math.sin(dLon/2)*Math.sin(dLon/2);return 6371*(2*Math.atan2(Math.sqrt(a),Math.sqrt(1-a)))},MarkerClusterer.prototype.addToClosestCluster_=function(marker){for(var cluster,distance=4e4,clusterToAddTo=null,clusterIndex=(marker.getPosition(),null),i=0;cluster=this.clusters_[i];i++){var center=cluster.getCenter();if(center){var d=this.distanceBetweenPoints_(center,marker.getPosition());d<distance&&(distance=d,clusterToAddTo=cluster,clusterIndex=i)}}clusterToAddTo&&clusterToAddTo.isMarkerInClusterBounds(marker)?clusterToAddTo.addMarker(marker):((cluster=new Cluster(this)).addMarker(marker),this.clusters_.push(cluster),clusterIndex=this.clusters_.length-1);marker.isAdded&&(this.markersCluster_[marker.uniqueID]=clusterIndex)},MarkerClusterer.prototype.createClusters_=function(){if(this.ready_)for(var marker,mapBounds=new google.maps.LatLngBounds(this.map_.getBounds().getSouthWest(),this.map_.getBounds().getNorthEast()),bounds=this.getExtendedBounds(mapBounds),i=0;marker=this.markers_[i];i++)marker.isAdded||!this.isMarkerInBounds_(marker,bounds)||this.ignoreHiddenMarkers_&&!marker.getVisible()||this.addToClosestCluster_(marker)},Cluster.prototype.isMarkerAlreadyAdded=function(marker){if(this.markers_.indexOf)return-1!=this.markers_.indexOf(marker);for(var m,i=0;m=this.markers_[i];i++)if(m==marker)return!0;return!1},Cluster.prototype.addMarker=function(marker){if(this.isMarkerAlreadyAdded(marker))return!1;if(this.center_){if(this.averageCenter_){var l=this.markers_.length+1,lat=(this.center_.lat()*(l-1)+marker.getPosition().lat())/l,lng=(this.center_.lng()*(l-1)+marker.getPosition().lng())/l;this.center_=new google.maps.LatLng(lat,lng),this.calculateBounds_()}}else this.center_=marker.getPosition(),this.calculateBounds_();marker.isAdded=!0,this.markers_.push(marker);var len=this.markers_.length;if(len<this.minClusterSize_&&marker.getMap()!=this.map_&&marker.setMap(this.map_),len==this.minClusterSize_)for(var i=0;i<len;i++)this.markers_[i].setMap(null);return len>=this.minClusterSize_&&marker.setMap(null),this.updateIcon(),!0},Cluster.prototype.getMarkerClusterer=function(){return this.markerClusterer_},Cluster.prototype.getBounds=function(){for(var marker,bounds=new google.maps.LatLngBounds(this.center_,this.center_),markers=this.getMarkers(),i=0;marker=markers[i];i++)bounds.extend(marker.getPosition());return bounds},Cluster.prototype.remove=function(){this.clusterIcon_.remove(),this.markers_.length=0,delete this.markers_},Cluster.prototype.getSize=function(){return this.markers_.length},Cluster.prototype.getMarkers=function(){return this.markers_},Cluster.prototype.getCenter=function(){return this.center_},Cluster.prototype.calculateBounds_=function(){var bounds=new google.maps.LatLngBounds(this.center_,this.center_);this.bounds_=this.markerClusterer_.getExtendedBounds(bounds)},Cluster.prototype.isMarkerInClusterBounds=function(marker){return this.bounds_.contains(marker.getPosition())},Cluster.prototype.getMap=function(){return this.map_},Cluster.prototype.updateIcon=function(){var zoom=this.map_.getZoom(),mz=this.markerClusterer_.getMaxZoom();if(mz&&mz<zoom)for(var marker,i=0;marker=this.markers_[i];i++)marker.setMap(this.map_);else if(this.markers_.length<this.minClusterSize_)this.clusterIcon_.hide();else{var numStyles=this.markerClusterer_.getStyles().length,sums=this.markerClusterer_.getCalculator()(this.markers_,numStyles);this.clusterIcon_.setCenter(this.center_),this.clusterIcon_.setSums(sums),this.clusterIcon_.show()}},ClusterIcon.prototype.triggerClusterClick=function(event){var markerClusterer=this.cluster_.getMarkerClusterer();google.maps.event.trigger(markerClusterer,"clusterclick",this.cluster_,event),markerClusterer.isZoomOnClick()&&this.map_.fitBounds(this.cluster_.getBounds())},ClusterIcon.prototype.triggerClusterMouseover=function(event){var markerClusterer=this.cluster_.getMarkerClusterer();google.maps.event.trigger(markerClusterer,"clustermouseover",this.cluster_,event),"function"==typeof this.cluster_.markerClusterer_.onMouseoverCluster_&&this.cluster_.markerClusterer_.onMouseoverCluster_(this,event)},ClusterIcon.prototype.triggerClusterMouseout=function(event){var markerClusterer=this.cluster_.getMarkerClusterer();google.maps.event.trigger(markerClusterer,"clustermouseout",this.cluster_,event),"function"==typeof this.cluster_.markerClusterer_.onMouseoutCluster_&&this.cluster_.markerClusterer_.onMouseoutCluster_(this,event)},ClusterIcon.prototype.onAdd=function(){"function"==typeof this.cluster_.markerClusterer_.onAddCluster_?this.cluster_.markerClusterer_.onAddCluster_(this):defaultClusterOnAdd(this)},ClusterIcon.prototype.getPosFromLatLng_=function(latlng){var pos=this.getProjection().fromLatLngToDivPixel(latlng);return"object"==typeof this.iconAnchor_&&2===this.iconAnchor_.length?(pos.x-=this.iconAnchor_[0],pos.y-=this.iconAnchor_[1]):(pos.x-=parseInt(this.width_/2,10),pos.y-=parseInt(this.height_/2,10)),pos},ClusterIcon.prototype.draw=function(){"function"==typeof this.cluster_.markerClusterer_.drawCluster_?this.cluster_.markerClusterer_.drawCluster_(this):defaultClusterDraw(this)},ClusterIcon.prototype.hide=function(){"function"==typeof this.cluster_.markerClusterer_.hideCluster_?this.cluster_.markerClusterer_.hideCluster_(this):defaultClusterHide(this)},ClusterIcon.prototype.show=function(){"function"==typeof this.cluster_.markerClusterer_.showCluster_?this.cluster_.markerClusterer_.showCluster_(this):defaultClusterShow(this)},ClusterIcon.prototype.remove=function(){this.setMap(null)},ClusterIcon.prototype.onRemove=function(){"function"==typeof this.cluster_.markerClusterer_.onRemoveCluster_?this.cluster_.markerClusterer_.onRemoveCluster_(this):defaultClusterOnRemove(this)},ClusterIcon.prototype.setSums=function(sums){this.sums_=sums,this.text_=sums.text,this.index_=sums.index,this.div_&&(this.div_.innerHTML=sums.text),this.useStyle()},ClusterIcon.prototype.useStyle=function(){var index=Math.max(0,this.sums_.index-1);index=Math.min(this.styles_.length-1,index);var style=this.styles_[index];this.url_=style.url,this.height_=style.height,this.width_=style.width,this.textColor_=style.textColor,this.anchor_=style.anchor,this.textSize_=style.textSize,this.backgroundPosition_=style.backgroundPosition,this.iconAnchor_=style.iconAnchor,this.setIndex_=index},ClusterIcon.prototype.setCenter=function(center){this.center_=center},ClusterIcon.prototype.createCss=function(pos){var style=[];if(this.cluster_.getMarkerClusterer().cssClass_)style.push("top:"+pos.y+"px; left:"+pos.x+"px;");else{style.push("background-image:url("+this.url_+");");var backgroundPosition=this.backgroundPosition_?this.backgroundPosition_:"0 0";style.push("background-position:"+backgroundPosition+";"),"object"==typeof this.anchor_?("number"==typeof this.anchor_[0]&&0<this.anchor_[0]&&this.anchor_[0]<this.height_?style.push("height:"+(this.height_-this.anchor_[0])+"px; padding-top:"+this.anchor_[0]+"px;"):"number"==typeof this.anchor_[0]&&this.anchor_[0]<0&&-this.anchor_[0]<this.height_?style.push("height:"+this.height_+"px; line-height:"+(this.height_+this.anchor_[0])+"px;"):style.push("height:"+this.height_+"px; line-height:"+this.height_+"px;"),"number"==typeof this.anchor_[1]&&0<this.anchor_[1]&&this.anchor_[1]<this.width_?style.push("width:"+(this.width_-this.anchor_[1])+"px; padding-left:"+this.anchor_[1]+"px;"):style.push("width:"+this.width_+"px; text-align:center;")):style.push("height:"+this.height_+"px; line-height:"+this.height_+"px; width:"+this.width_+"px; text-align:center;");var txtColor=this.textColor_?this.textColor_:"black",txtSize=this.textSize_?this.textSize_:11;style.push("cursor:pointer; top:"+pos.y+"px; left:"+pos.x+"px; color:"+txtColor+"; position:absolute; font-size:"+txtSize+"px; font-family:Arial,sans-serif; font-weight:bold")}return style.join("")},ClusterIcon.prototype.addClass=function(){var markerClusterer=this.cluster_.getMarkerClusterer();markerClusterer.cssClass_?this.div_.className=markerClusterer.cssClass_+" "+markerClusterer.cssDefaultClass_+this.setIndex_:this.div_.className=markerClusterer.cssDefaultClass_+this.setIndex_},(window.MarkerClusterer=MarkerClusterer).prototype.addMarker=MarkerClusterer.prototype.addMarker,MarkerClusterer.prototype.addMarkers=MarkerClusterer.prototype.addMarkers,MarkerClusterer.prototype.clearMarkers=MarkerClusterer.prototype.clearMarkers,MarkerClusterer.prototype.fitMapToMarkers=MarkerClusterer.prototype.fitMapToMarkers,MarkerClusterer.prototype.getCalculator=MarkerClusterer.prototype.getCalculator,MarkerClusterer.prototype.getGridSize=MarkerClusterer.prototype.getGridSize,MarkerClusterer.prototype.getExtendedBounds=MarkerClusterer.prototype.getExtendedBounds,MarkerClusterer.prototype.getMap=MarkerClusterer.prototype.getMap,MarkerClusterer.prototype.getMarkers=MarkerClusterer.prototype.getMarkers,MarkerClusterer.prototype.getMaxZoom=MarkerClusterer.prototype.getMaxZoom,MarkerClusterer.prototype.getMarkersCluster=MarkerClusterer.prototype.getMarkersCluster,MarkerClusterer.prototype.getStyles=MarkerClusterer.prototype.getStyles,MarkerClusterer.prototype.getTotalClusters=MarkerClusterer.prototype.getTotalClusters,MarkerClusterer.prototype.getTotalMarkers=MarkerClusterer.prototype.getTotalMarkers,MarkerClusterer.prototype.redraw=MarkerClusterer.prototype.redraw,MarkerClusterer.prototype.removeMarker=MarkerClusterer.prototype.removeMarker,MarkerClusterer.prototype.removeMarkers=MarkerClusterer.prototype.removeMarkers,MarkerClusterer.prototype.resetViewport=MarkerClusterer.prototype.resetViewport,MarkerClusterer.prototype.repaint=MarkerClusterer.prototype.repaint,MarkerClusterer.prototype.setCalculator=MarkerClusterer.prototype.setCalculator,MarkerClusterer.prototype.setGridSize=MarkerClusterer.prototype.setGridSize,MarkerClusterer.prototype.setMaxZoom=MarkerClusterer.prototype.setMaxZoom,MarkerClusterer.prototype.onAdd=MarkerClusterer.prototype.onAdd,MarkerClusterer.prototype.draw=MarkerClusterer.prototype.draw,Cluster.prototype.getCenter=Cluster.prototype.getCenter,Cluster.prototype.getSize=Cluster.prototype.getSize,Cluster.prototype.getMarkers=Cluster.prototype.getMarkers,ClusterIcon.prototype.onAdd=ClusterIcon.prototype.onAdd,ClusterIcon.prototype.draw=ClusterIcon.prototype.draw,ClusterIcon.prototype.onRemove=ClusterIcon.prototype.onRemove;