<?php
namespace GravityKit\GravityMaps\Geolocation;

use GravityKit\GravityMaps\AbstractSingleton;
use GravityKit\GravityMaps\Form_Fields;

/**
 * Class Factory
 *
 * @since   3.1.3
 *
 * @package GravityKit\GravityMaps\Maps
 */
class Fields extends AbstractSingleton {

	/**
	 * Boots the assets class.
	 *
	 * @since 3.1.3
	 *
	 */
	public function register(): void {

	}

	/**
	 * Allow the return of a set of callbacks to get the meta keys for a given field.
	 *
	 * @since 2.0
	 * @since 3.1.3 Moved here from Form_Fields.
	 *
	 * @param ?string $type Which type of field we are talking about.
	 *
	 * @return array
	 */
	public function get_meta_keys_callbacks( ?string $type = null ): array {
		$map = [
			'internal' => [
				'lat' => static function( $id ) {
					return Form_Fields::get_meta_key( 'lat', $id );
				},
				'long' => static function( $id ) {
					return Form_Fields::get_meta_key( 'long', $id );
				},
			],
			'gravityforms' => [
				'lat' => static function( $id ) {
					return sprintf( '%s.geolocation_latitude', $id );
				},
				'long' => static function( $id ) {
					return sprintf( '%s.geolocation_longitude', $id );
				},
			],
			'gravitywiz' => [
				'lat' => static function( $id ) {
					return sprintf( 'gpaa_lat_%s', $id );
				},
				'long' => static function( $id ) {
					return sprintf( 'gpaa_lng_%s', $id );
				},
			],
			'manual_coordinates' => [
				'lat' => static function( $fields ) {
					if ( ! is_object( $fields ) ) {
						return null;
					}

					return $fields->lat ?: null;
				},
				'long' => static function( $fields ) {
					if ( ! is_object( $fields ) ) {
						return null;
					}

					return $fields->long ?: null;
				},
			],
		];

		if ( null === $type ) {
			return $map;
		}

		return $map[ $type ] ?? [];
	}

	/**
	 * Given a field ID, returns the meta keys for the field.
	 *
	 * @since TBD
	 *
	 * @param int|string  $field_id The field ID.
	 * @param string|null $type     The type of field we are talking about.
	 *
	 * @return array
	 */
	public function get_meta_keys( $field_id, ?string $type = null ): array {
		if ( ! is_numeric( $field_id ) ) {
			return [];
		}

		$map = $this->get_meta_keys_callbacks( $type );
		$meta_keys = [];
		$fields = array_map( static function ( $callbacks ) use ( $field_id ) {
			$lat = $callbacks['lat']( $field_id );
			$long = $callbacks['long']( $field_id );

			if ( empty( $lat ) || empty( $long ) ) {
				return [];
			}

			return [ $lat, $long ];
		}, $map );

		foreach ( $fields as $coordinates_meta ) {
			if ( empty( $coordinates_meta ) ) {
				continue;
			}

			$meta_keys = array_merge( $meta_keys, $coordinates_meta );
		}

		return array_unique( array_filter( $meta_keys ) );
	}
}