<?php
namespace GravityKit\GravityMaps\Template\Modifiers;

use GravityKit\GravityMaps\AbstractSingleton;
use GravityKit\GravityMaps\Template\Utils;
use GV\Utils as GV_Utils;

/**
 * Class Widget
 *
 * @since   3.1.0
 *
 * @package GravityKit\GravityMaps\Template\Modifiers
 */
class Widget extends AbstractSingleton {
	/**
	 * @inheritDoc
	 *
	 * @since 3.1.0
	 */
	public function register(): void {
		add_filter( 'gravityview/widgets/wrapper_css_class', [ $this, 'modify_wrapper_search_css_class' ], 10, 2 );
	}

	/**
	 * Adds '.gv-widgets-is-search' CSS class to widget container when performing a search.
	 *
	 * This helps us to show the map in the widget area when performing a search, but not when there are simply no results.
	 *
	 * @param string $css_class
	 *
	 * @return string CSS class, with "gv-widgets-is-search" added if performing a search.
	 */
	public function modify_wrapper_search_css_class( $css_class = '' ): string {
		if ( Utils::is_search() && GV_Utils::_REQUEST( 'lat' ) && GV_Utils::_REQUEST( 'long' ) ) {
			$css_class .= ' gv-widgets-is-search';
		}

		return $css_class;
	}
}