<?php
namespace GravityKit\GravityMaps\Template;

use GV\Request;
use GV\Utils as GV_Utils;

/**
 * Class Utils, for template related utilities.
 *
 * @since   2.1.0
 *
 * @package GravityKit\GravityMaps\Template
 */
class Utils {
	/**
	 * Returns whether the requested page is a GravityView search result or not.
	 *
	 * @since 3.1.0
	 *
	 * @param Request|null $request The request.
	 *
	 * @return bool
	 */
	public static function is_search( ?Request $request = null ) : bool {

		if ( (int) GV_Utils::_REQUEST( 'is_current' ) === 1 ) {
			return true;
		}

		if ( GV_Utils::_REQUEST( 'address_search' ) ) {
			return true;
		}

		if ( null === $request ) {
			$request = gravityview()->request;
		}

		return function_exists( 'gravityview' ) ? $request->is_search() : \GravityView_frontend::getInstance()->is_searching();
	}
}