<?php

namespace GravityKit\GravityMaps\Templates\Modifiers;

use GravityKit\GravityMaps\AbstractSingleton;

/**
 * Class Rest Hide Before Search Modifier.
 *
 * @since   3.1.3
 *
 * @package GravityKit\GravityMaps\Templates\Modifiers
 */
class RestHideBeforeSearchModifier extends AbstractSingleton {
	/**
	 * @inheritDoc
	 */
	public function register(): void {
		add_filter( 'rest_dispatch_request', [ $this, 'filter_hook_when_rest' ], 15 );
	}

	/**
	 * Filters the hook when REST is being used.
	 *
	 * @since 3.1.3
	 *
	 * @param mixed $result
	 *
	 * @return mixed
	 */
	public function filter_hook_when_rest( $result ) {
		if ( ! defined( 'REST_REQUEST' ) ) {
			return $result;
		}

		if ( ! REST_REQUEST ) {
			return $result;
		}

		$this->hook();
		return $result;
	}

	/**
	 * Hooks the necessary actions to change the settings on REST requests.
	 *
	 * @since 3.1.3
	 */
	public function hook(): void {
		add_action( 'gravityview/view/get', [ $this, 'change_settings_on_rest' ], 25, 3 );
	}

	/**
	 * Unhooks the necessary actions to prevent the settings from being on REST requests.
	 *
	 * @since 3.1.3
	 */
	public function unhook(): void {
		remove_action( 'gravityview/view/get', [ $this, 'change_settings_on_rest' ], 25 );
	}

	/**
	 * Changes the settings on REST requests.
	 *
	 * @since 3.1.3
	 *
	 * @param \GV\View  $view  The View instance.
	 *
	 * @return void
	 */
	public function change_settings_on_rest( $view ): void {
		if ( ! defined( 'REST_REQUEST' ) ) {
			return;
		}

		if ( ! REST_REQUEST ) {
			return;
		}

		$view->settings->set( 'hide_until_searched', false );
	}
}