<?php
	namespace Elementor;
	class SingleListingMeta extends Widget_Base
	{
		public function get_name()
		{
			return "hotel_directory_single_meta";
		}
		public function get_title()
		{
			return "Listing Meta";
		}
		public function get_icon()
		{
			return "fas fa-home";
		}
		public function get_categories()
		{
			return ['hotel-listing'];
		}
		/******************** CONTENT PROCESSING ***********************/
		protected function _register_controls() {
			//Top Section Right Side Image
			$this->start_controls_section(
			'hotel_directory_meta_data',
			[
			'label' => __( 'Listing Data', 'ivdirectories' ),
			'tab' => Controls_Manager::TAB_CONTENT,
			]
			);
			$this->add_control(
			'hotel_listing_meta',
			[
			'label' => esc_html__( 'Select Meta', 'ivdirectories' ),
			'type' => Controls_Manager::SELECT,
			'block' => true,
			'default' => 'address',
			'options' => [
			'Specialities' => esc_html__( 'Specialities', 'ivdirectories' ),
			'latitude' => esc_html__( 'Latitude', 'ivdirectories' ),
			'longitude' => esc_html__( 'Longitude', 'ivdirectories' ),
			'postcode' => esc_html__( 'Post Code', 'ivdirectories' ),
			'address' => esc_html__('Address', 'ivdirectories'),
			'city' => esc_html__( 'City', 'ivdirectories' ),
			'country' => esc_html__( 'Country', 'ivdirectories' ),
			'vimeo' => esc_html__('Vimeo video ID', 'ivdirectories'),
			'youtube' => esc_html__('Youtube video ID', 'ivdirectories'),
			'fax' => esc_html__( 'Fax', 'ivdirectories' ),
			'contact-email' => esc_html__( 'Email', 'ivdirectories' ),
			'contact_web' => esc_html__( 'Website', 'ivdirectories' ),
			'facebook' => esc_html__('Facebook Profile', 'ivdirectories'),
			'twitter' => esc_html__('twitter Profile', 'ivdirectories'),
			'linkedin' => esc_html__('Linkedin Profile', 'ivdirectories'),
			'gplus' => esc_html__('G+', 'ivdirectories'),
			'pinterest' => esc_html__('Pinterest Profile', 'ivdirectories'),
			'instagram' => esc_html__('Instagram Profile', 'ivdirectories'),
			'_opening_time' => esc_html__('Opening Time', 'ivdirectories'),
			],
			]
			);
			$this->add_control(
			'size',
			[
			'label' => __( 'Size', 'ivdirectories' ),
			'type' => Controls_Manager::SELECT,
			'default' => 'default',
			'options' => [
			'default' => __( 'Default', 'ivdirectories' ),
			'small' => __( 'Small', 'ivdirectories' ),
			'medium' => __( 'Medium', 'ivdirectories' ),
			'large' => __( 'Large', 'ivdirectories' ),
			'xl' => __( 'XL', 'ivdirectories' ),
			'xxl' => __( 'XXL', 'ivdirectories' ),
			],
			]
			);
			$this->add_control(
			'header_size',
			[
			'label' => __( 'HTML Tag', 'ivdirectories' ),
			'type' => Controls_Manager::SELECT,
			'options' => [
			'h1' => __( 'H1', 'ivdirectories' ),
			'h2' => __( 'H2', 'ivdirectories' ),
			'h3' => __( 'H3', 'ivdirectories' ),
			'h4' => __( 'H4', 'ivdirectories' ),
			'h5' => __( 'H5', 'ivdirectories' ),
			'h6' => __( 'H6', 'ivdirectories' ),
			'div' => __( 'div', 'ivdirectories' ),
			'span' => __( 'span', 'ivdirectories' ),
			'p' => __( 'p', 'ivdirectories' ),
			],
			'default' => 'h2',
			]
			);
			$this->add_responsive_control(
				'align',
				[
					'label' => __( 'Alignment', 'ivdirectories' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
					'left' => [
					'title' => __( 'Left', 'ivdirectories' ),
					'icon' => 'fa fa-align-left',
					],
					'center' => [
					'title' => __( 'Center', 'ivdirectories' ),
					'icon' => 'fa fa-align-center',
					],
					'right' => [
					'title' => __( 'Right', 'ivdirectories' ),
					'icon' => 'fa fa-align-right',
					],
					'justify' => [
					'title' => __( 'Justified', 'ivdirectories' ),
					'icon' => 'fa fa-align-justify',
					],
					],
					'default' => '',
					'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'view',
				[
				'label' => __( 'View', 'ivdirectories' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'section_title_style',
				[
				'label' => __( 'Title', 'ivdirectories' ),
				'tab' => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => __( 'Text Color', 'ivdirectories' ),
					'type' => Controls_Manager::COLOR,
					'scheme' => [
						'type' => Scheme_Color::get_type(),
						'value' => Scheme_Color::COLOR_1,
					],
					'selectors' => [
						'{{WRAPPER}} .elementor-heading-title' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'typography',
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .elementor-heading-title',
				]
			);
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name' => 'text_shadow',
					'selector' => '{{WRAPPER}} .elementor-heading-title',
				]
			);
			$this->end_controls_section();
		}
		/**
			* Render heading widget output on the frontend.
			*
			* Written in PHP and used to generate the final HTML.
			*
			* @since 1.0.0
			* @access protected
		*/
		protected function render() {
			$settings = $this->get_settings_for_display();
			global $post;
			if ( empty( $settings['hotel_listing_meta'] ) ) {
				return;
			}
			$this->add_render_attribute( 'hotel_listing_meta', 'class', 'elementor-heading-title' );
			if ( ! empty( $settings['size'] ) ) {
				$this->add_render_attribute( 'hotel_listing_meta', 'class', 'elementor-size-' . $settings['size'] );
			}
			$this->add_inline_editing_attributes( 'hotel_listing_meta' );
			$title = get_post_meta($post->ID,$settings['hotel_listing_meta'],true) ;

			if( is_array($title) ){
				foreach($title as $day => $time) {
					$finalTime = str_replace('|','-',$time);
					echo sprintf( '<%1$s %2$s>%3$s</%1$s>', $settings['header_size'], $this->get_render_attribute_string( 'hotel_listing_meta' ), $day);
					if($settings['header_size']==='span'){
						echo " : ";
					}
					echo sprintf( '<%1$s %2$s>%3$s</%1$s>', $settings['header_size'], $this->get_render_attribute_string( 'hotel_listing_meta' ), $finalTime);
					echo "<br>";
				}
				return;
			}

			$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', $settings['header_size'], $this->get_render_attribute_string( 'hotel_listing_meta' ), $title );
			echo $title_html;
		}
		/**
			* Render heading widget output in the editor.
			*
			* Written as a Backbone JavaScript template and used to generate the live preview.
			*
			* @since 1.0.0
			* @access protected
		*/
		protected function _content_template() {
		?>
		<#
		var title = settings.hotel_listing_meta;
		view.addRenderAttribute( 'hotel_listing_meta', 'class', [ 'elementor-heading-title', 'elementor-size-' + settings.size ] );
		view.addInlineEditingAttributes( 'hotel_listing_meta' );
		var title_html = '<' + settings.header_size  + ' ' + view.getRenderAttributeString( 'hotel_listing_meta' ) + '>' + title + '</' + settings.header_size + '>';
		print( title_html );
		#>
        <?php
		}
	}
Plugin::instance()->widgets_manager->register_widget_type( new SingleListingMeta );
