<?php
	wp_enqueue_style('wp-iv_directories-style-11', wp_iv_directories_URLPATH . 'admin/files/css/iv-bootstrap.css');
	wp_enqueue_script('iv_directories-script-12', wp_iv_directories_URLPATH . 'admin/files/js/bootstrap.min.js');
	wp_enqueue_script('iv_directories-script-13', wp_iv_directories_URLPATH . 'admin/files/js/modernizr.custom.79639.js');
	wp_enqueue_style('directory_template1_inline_css', wp_iv_directories_URLPATH . 'admin/files/css/directory_template1.css');
	wp_enqueue_style('font-awesome', wp_iv_directories_URLPATH . 'admin/files/css/font-awesome/css/font-awesome.min.css');
	global $wpdb;
?>
<?php
	$package ='';
	if(isset($_REQUEST['package_sel'])){
		$package = $_REQUEST['package_sel'];
	}
	if($package==''){
		if(isset($_REQUEST['package'])){
			$package=$_REQUEST['package'];
		}
	}
	$search_user='';
	if(isset($_POST['search_user'])){
		$search_user = $_POST['search_user'];
	}
?>
<div id="directory-temp1" class="bootstrap-wrapper">
	<div class="main clearfix underline row">
		<form class="pull-right dd col-md-6"   action="<?php echo the_permalink(); ?>" method="post"  >
			<div class="row">
				<input type="text" name="search_user" id="search_user" class="search" placeholder="<?php esc_html_e('User Name', 'ivdirectories' ); ?>" value="<?php echo esc_html($search_user); ?>">
				<button class="submit"><i class="fa fa-search"></i></button>
				<input type="hidden" name="package_hidden" id="package_hidden" value="<?php echo esc_html($package); ?>">
			</div>
		</form>
		<form class="pull-right dd col-md-6"   action="<?php echo the_permalink(); ?>" method="post"  >
			<div class="row">
				<select id="package_sel" name="package_sel" class="btn-infu" >
					<?php
						$sql="SELECT * FROM $wpdb->posts WHERE post_type = 'iv_directories_pack'  and post_status='draft' ";
						$membership_pack = $wpdb->get_results($sql);
						echo'<option value="">All</option>';
						foreach ( $membership_pack as $row ){
							echo'<option value="'.esc_html($row->ID).'"  '.($package==$row->ID ? " selected" : " ") .' >'.esc_html($row->post_title).'</option>';
						}
					?>
				</select >
				<div class="arrow-user">
					<i class="fa fa-angle-down"></i>
				</div>
			</div>
		</form>
	</div>
	<section  class="main">
		<ul class="ch-grid">
			<?php
                if(isset($atts['per_page'])){
					$no=$atts['per_page'];
					}else{
					$no=12;
				}
				// total no of author to display
        		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        		if($paged==1){
					$offset=0;
					}else {
					$offset= ($paged-1)*$no;
				}
                $args = array();
                $args['number']=$no;
                $args['offset']=$offset;
                $args['orderby']='registered';
				$args['order']='DESC';
                if($package!=''){
        			$role_package= get_post_meta( $package,'iv_directories_package_user_role',true);
        			$args['role']=$role_package;
				}
				if($search_user!=''){
        			$args['search']='*'.$search_user.'*';
				}
        		$iv_redirect_user = get_option( '_iv_directories_profile_public_page');
        		$reg_page_user='';
                if($iv_redirect_user!='defult'){
        			$reg_page_user= get_permalink( $iv_redirect_user) ;
				}
                $user_query = new WP_User_Query( $args );
                // User Loop
                if ( ! empty( $user_query->results ) ) {
                	foreach ( $user_query->results as $user ) {
						if (isset($user->wp_capabilities['administrator'])!=1 ){
							$iv_profile_pic_url=get_user_meta($user->ID, 'iv_profile_pic_thum',true);
							$reg_page_u=$reg_page_user.'?&id='.$user->user_login;
						?>
						<li><a href="<?php echo esc_html($reg_page_u); ?>">
							<h3><?php echo esc_html($user->display_name); ?></h3>
							<p class="para0"><?php  if(get_user_meta($user->ID,'occupation',true)==!""){
								echo get_user_meta($user->ID,'occupation',true);
							}else{ echo "";} ?></p>
							<div class="ch-item">
								<?php
									if($iv_profile_pic_url!=''){ ?>
									<img src="<?php echo esc_html($iv_profile_pic_url); ?>" class="home-img wide tall">
									<?php
										}else{
										echo '<img src="'. wp_iv_directories_URLPATH.'assets/images/Blank-Profile.jpg" class="home-img wide tall">';
									}
								?>
								<div class="ch-info">
									<h3>
										<?php
											if(get_user_meta($user->ID,'twitter',true)!=''){
											?>
											<a href="www.twitter.com/<?php  echo get_user_meta($user->ID,'twitter',true);  ?>/">
												<i class="fa fa-twitter"></i>
											</a>
											<?php
											}
											if(get_user_meta($user->ID,'linkedin',true)!=''){
											?>
											<a href="www.linkedin.com/<?php  echo get_user_meta($user->ID,'linkedin',true);  ?>/">
												<i class="fa fa-linkedin"></i>
											</a>
											<?php
											}
											if(get_user_meta($user->ID,'facebook',true)!=''){
											?>
											<a href="www.facebook.com/<?php  echo get_user_meta($user->ID,'facebook',true);  ?>/">
												<i class="fa fa-facebook"></i>
											</a>
											<?php
											}
										?>
									</h3>
									<p class="text-center">
										<a href="<?php echo esc_html($reg_page_u); ?>">
											<i class="fa fa-link"></i>
										</a>
									</p>
								</div>
							</div>
						</a>
						</li>
						<?php
						}
					}
					} else {
					echo 'No users found.';
				}
			?>
		</ul>
	</section>
	<?php
		$total_user = $user_query->total_users;
		$total_pages=ceil($total_user/$no);
		echo '<div id="iv-pagination" class="iv-pagination">';
		echo paginate_links( array(
		'base' => '%_%'.'?&package='.$package, // the base URL, including query arg
		'format' => '?&paged=%#%', // this defines the query parameter that will be used, in this case "p"
		'prev_text' => esc_html__('&laquo; Previous','ivdirectories'), // text for previous page
		'next_text' => esc_html__('Next &raquo;','ivdirectories'), // text for next page
		'total' => $total_pages, // the total number of pages we have
		'current' => $paged, // the current page
		'end_size' => 1,
		'mid_size' => 5,
		));
		echo '</div>';
	?>
</div>
<?php
	wp_enqueue_script('iv_directories-script-12', wp_iv_directories_URLPATH . 'admin/files/js/user-directory.js');
?>
