if (typeof(jQuery) == "undefined") {
	window.jQuery = function (selector) { return parent.jQuery(selector, document); };
	jQuery = parent.jQuery.extend(jQuery, parent.jQuery);
}

if ( parent._ )
	var _ = parent._;
/*
 CSS Browser Selector 0.81
 Originally written by Rafael Lima (http://rafael.adm.br)
 http://rafael.adm.br/css_browser_selector
 License: http://creativecommons.org/licenses/by/2.5/

 Co-maintained by:
 https://github.com/ridjohansen/css_browser_selector
 https://github.com/delka/css_browser_selector
 https://github.com/verbatim/css_browser_selector
 */
(function() {
var uaInfo = {
	ua : '',
	is : function (t) {
		return RegExp(t, "i").test(uaInfo.ua);
	},
	version : function (p, n) {
		n = n.replace(".", "_");
		var i = n.indexOf('_'),
			ver = "";
		while (i > 0) {
			ver += " " + p + n.substring(0, i);
			i = n.indexOf('_', i + 1);
		}
		ver += " " + p + n;
		return ver;
	},
	getBrowser : function() {
		var g = 'gecko',
			w = 'webkit',
			c = 'chrome',
			f = 'firefox',
			s = 'safari',
			o = 'opera',

			ua = uaInfo.ua,
			is = uaInfo.is;

		return [
			(!(/opera|webtv/i.test(ua)) && /msie\s(\d+)/.test(ua)) ? ('ie ie' + (/trident\/4\.0/.test(ua) ? '8' : RegExp.$1))
				:is('edge\/') ? 'edge ie' + (/edge\/(\d+)\.(\d+)/.test(ua) ? RegExp.$1 + ' ie' + RegExp.$1 + '_' + RegExp.$2 : '') // IE Edge
				:is('trident\/') ? 'ie ie'+ (/trident\/.+rv:(\d+)/i.test(ua) ? RegExp.$1 : '') //ie11+
				:is('firefox/') ? g + " " + f + (/firefox\/((\d+)(\.(\d+))(\.\d+)*)/.test(ua) ? ' ' + f + RegExp.$2 + ' ' + f + RegExp.$2 + "_" + RegExp.$4 : '')
				:is('gecko/') ? g
				:is('opera') ? o + (/version\/((\d+)(\.(\d+))(\.\d+)*)/.test(ua) ? ' ' + o + RegExp.$2 + ' ' + o + RegExp.$2 + "_" + RegExp.$4 : (/opera(\s|\/)(\d+)\.(\d+)/.test(ua) ? ' ' + o + RegExp.$2 + " " + o + RegExp.$2 + "_" + RegExp.$3 : ''))
				:is('konqueror') ? 'konqueror'
				:is('chrome') ? w + ' ' + c + (/chrome\/((\d+)(\.(\d+))(\.\d+)*)/.test(ua) ? ' ' + c + RegExp.$2 + ((RegExp.$4 > 0) ? ' ' + c + RegExp.$2 + "_" + RegExp.$4 : '') : '')
				:is('iron') ? w + ' iron'
				:is('applewebkit/') ? (w + ' ' + s + (/version\/((\d+)(\.(\d+))(\.\d+)*)/.test(ua) ? ' ' + s + RegExp.$2 + " " + s + RegExp.$2 + RegExp.$3.replace('.', '_') : (/ Safari\/(\d+)/i.test(ua) ? ((RegExp.$1 == "419" || RegExp.$1 == "417" || RegExp.$1 == "416" || RegExp.$1 == "412") ? ' ' + s + '2_0' : RegExp.$1 == "312" ? ' ' + s + '1_3' : RegExp.$1 == "125" ? ' ' + s + '1_2' : RegExp.$1 == "85" ? ' ' + s + '1_0' : '') : ''))) //applewebkit
				:is('mozilla/') ? g : ''
		];
	},
	getPlatform : function() {
		var wp = 'winphone',
			a  = 'android',
			bb = 'blackberry',
			dv = 'device_',

			ua = uaInfo.ua,
			version = uaInfo.version,
			is = uaInfo.is;

		return [
			is('j2me') ? 'j2me'
			:is('windows phone') ? (wp + (/Windows Phone (\d+)(\.(\d+))+/i.test(ua) ? " " + wp + RegExp.$1 + " " + wp + RegExp.$1 + RegExp.$2.replace('.', '_') : (/Windows Phone OS (\d+)(\.(\d+))+/i.test(ua) ? " " + wp + RegExp.$1 + " " + wp + RegExp.$1 + RegExp.$2.replace('.', '_') : ''))) // Windows Phone
			:is('blackberry') ? (bb + (/Version\/(\d+)(\.(\d+)+)/i.test(ua) ? " " + bb + RegExp.$1 + " " + bb + RegExp.$1 + RegExp.$2.replace('.', '_') : (/Blackberry ?(([0-9]+)([a-z]?))[\/|;]/gi.test(ua) ? ' ' + bb + RegExp.$2 + (RegExp.$3 ? ' ' + bb + RegExp.$2 + RegExp.$3 : '') : ''))) // blackberry
			:is('android') ? (a + (/Version\/(\d+)(\.(\d+))+/i.test(ua) ? " " + a + RegExp.$1 + " " + a + RegExp.$1 + RegExp.$2.replace('.', '_') : '') + (/Android (.+); (.+) Build/i.test(ua) ? ' ' + dv + ((RegExp.$2).replace(/ /g, "_")).replace(/-/g, "_") : '')) //android
			:is('ipad|ipod|iphone') ? (
			(/CPU( iPhone)? OS (\d+[_|\.]\d+([_|\.]\d+)*)/i.test(ua) ? 'ios' + version('ios', RegExp.$2) : '') + ' ' + (/(ip(ad|od|hone))/gi.test(ua) ? RegExp.$1 : "")) //'iphone'
			//:is('ipod')?'ipod'
			//:is('ipad')?'ipad'
			:is('playbook') ? 'playbook'
			:is('kindle|silk') ? 'kindle'
			:is('playbook') ? 'playbook'
			:is('mac') ? 'mac' + (/mac os x ((\d+)[.|_](\d+))/.test(ua) ? (' mac' + (RegExp.$2) + ' mac' + (RegExp.$1).replace('.', "_")) : '')
			:is('win') ? 'win' + (is('windows nt 10.0') ? ' win10'
			:is('windows nt 6.3') ? ' win8_1'
			:is('windows nt 6.2') ? ' win8'
			:is('windows nt 6.1') ? ' win7'
			:is('windows nt 6.0') ? ' vista'
			:is('windows nt 5.2') || is('windows nt 5.1') ? ' win_xp'
			:is('windows nt 5.0') ? ' win_2k'
			:is('windows nt 4.0') || is('WinNT4.0') ? ' win_nt' : '')
			:is('freebsd') ? 'freebsd'
			:is('x11|linux') ? 'linux' : ''
		];
	},
	getMobile : function() {
		var is = uaInfo.is;
		return [
			is("android|mobi|mobile|j2me|iphone|ipod|ipad|blackberry|winphone|playbook|kindle|silk") ? 'mobile' : ''
		];
	},
	getIpadApp : function() {
		var is = uaInfo.is;
		return [
			(is('ipad|iphone|ipod') && !is('safari')) ? 'ipad_app' : ''
		];
	},
	getLang : function() {
		var ua = uaInfo.ua;

		return [
			/[; |\[](([a-z]{2})(\-[a-z]{2})?)[)|;|\]]/i.test(ua) ? ('lang_' + RegExp.$2).replace("-", "_") + (RegExp.$3 != '' ? (' ' + 'lang_' + RegExp.$1).replace("-", "_") : '') : ''
		];
	}
}

if (typeof html =='undefined') { 
	html=document.documentElement;
}

var screenInfo = {
	width : (window.outerWidth || html.clientWidth) - 15,
	height : window.outerHeight || html.clientHeight,
	screens : [0, 768, 980, 1200],
	
	screenSize : function () {
		screenInfo.width = (window.outerWidth || html.clientWidth) - 15;
		screenInfo.height = window.outerHeight || html.clientHeight;
			
		var screens = screenInfo.screens,
			i = screens.length,
			arr = [],
			maxw, 
			minw;
		
		while(i--) {
			if (screenInfo.width >= screens[i]) {
				if(i) {
					arr.push("minw_" + screens[(i)]);
				}
				if (i <= 2) {
					arr.push("maxw_" + (screens[(i) + 1] - 1));
				}
				break;
			}
		}
		return arr;
	},
	getOrientation : function() {
		return screenInfo.width < screenInfo.height ? ["orientation_portrait"] : ["orientation_landscape"];
	},
	getInfo : function() {
		var arr = [];
		arr = arr.concat(screenInfo.screenSize());
		arr = arr.concat(screenInfo.getOrientation());
		return  arr;
	},
	getPixelRatio : function() {
		var arr = [],
			pixelRatio = window.devicePixelRatio ? window.devicePixelRatio : 1;

		if(pixelRatio > 1) {
			arr.push('retina_' + parseInt(pixelRatio) + 'x');
			arr.push('hidpi');
		} else {
			arr.push('no-hidpi');
		}
		return arr;
	}
}

var dataUriInfo = {
	data : new Image(),
	div : document.createElement("div"),
	isIeLessThan9 : false,
	getImg : function() {

		dataUriInfo.data.src = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==";
		dataUriInfo.div.innerHTML = "<!--[if lt IE 9]><i></i><![endif]-->";
		dataUriInfo.isIeLessThan9 = dataUriInfo.div.getElementsByTagName("i").length == 1;

		return dataUriInfo.data;
	},
	checkSupport : function() {
		if(dataUriInfo.data.width != 1 || dataUriInfo.data.height != 1 || dataUriInfo.isIeLessThan9) {
			return ["no-datauri"];
		}
		else {
			return ["datauri"];
		}
	}

}

function css_browser_selector(u, ns) {
	var html = document.documentElement,
		b = []
		ns = ns ? ns : "";

	/* ua */
	uaInfo.ua = u.toLowerCase();
	b = b.concat(uaInfo.getBrowser());
	b = b.concat(uaInfo.getPlatform());
	b = b.concat(uaInfo.getMobile());
	b = b.concat(uaInfo.getIpadApp());
	b = b.concat(uaInfo.getLang());


	/* js */
	b = b.concat(['js']);

	/* pixel ratio */
	b = b.concat(screenInfo.getPixelRatio());

	/* screen */
	b = b.concat(screenInfo.getInfo());

	var updateScreen = function() {
		html.className = html.className.replace(/ ?orientation_\w+/g, "").replace(/ [min|max|cl]+[w|h]_\d+/g, "");
		html.className = html.className + ' ' + screenInfo.getInfo().join(' ');
	}

	if (window.addEventListener) {
		window.addEventListener('resize', updateScreen);
		window.addEventListener('orientationchange', updateScreen);
	} else if (window.attachEvent) {
		window.attachEvent('onresize', updateScreen);
	}

	/* dataURI */
	var data = dataUriInfo.getImg();
	data.onload = data.onerror = function(){
		html.className += ' ' + dataUriInfo.checkSupport().join(' ');
	}


	/* save & add existing html classes */
	var classes = html.className;
	var classesArray = classes.split(/ /);

	/* merge existing classes on html tag */
	b = b.concat(classesArray);

	/* removendo itens invalidos do array */
	/* add filter function polyfill for IE8 */
	if (!Array.prototype.filter) {
		Array.prototype.filter = function(fun/*, thisArg*/) {
			'use strict';

			if (this === void 0 || this === null) {
				throw new TypeError();
			}

			var t = Object(this);
			var len = t.length >>> 0;
			if (typeof fun !== 'function') {
				throw new TypeError();
			}

			var res = [];
			var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
			for (var i = 0; i < len; i++) {
				if (i in t) {
					var val = t[i];

					// NOTE: Technically this should Object.defineProperty at
					//			 the next index, as push can be affected by
					//			 properties on Object.prototype and Array.prototype.
					//			 But that method's new, and collisions should be
					//			 rare, so use the more-compatible alternative.
					if (fun.call(thisArg, val, i, t)) {
						res.push(val);
					}
				}
			}

			return res;
		};
	}

	b = b.filter(function(e){
		/* if no-js class exists, remove it */
		if (e === 'no-js') {
			return false;
        }
		return e;
	});

	/* prefixo do namespace */
	b[0] = ns ? ns + b[0] : b[0];
	html.className = b.join(' ' + ns);
	return html.className;
}

// Add css_browser_selector as a global object.
window.css_browser_selector = css_browser_selector;
})();

// define css_browser_selector_ns before loading this script to assign a namespace
var css_browser_selector_ns = css_browser_selector_ns || "";

// init
css_browser_selector(navigator.userAgent, css_browser_selector_ns);







/**
 * Justified Gallery - v3.6.3
 * http://miromannino.github.io/Justified-Gallery/
 *
 * Copyright (c) 2016 Miro Mannino
 * Licensed under the MIT license.
 */
(function($) {

	function hasScrollBar() {
		return $("body").height() > $(window).height();
	}
	/**
	 * Justified Gallery controller constructor
	 *
	 * @param $gallery the gallery to build
	 * @param settings the settings (the defaults are in $.fn.justifiedGallery.defaults)
	 * @constructor
	 */
	var JustifiedGallery = function($gallery, settings) {

		this.settings = settings;
		this.checkSettings();

		this.imgAnalyzerTimeout = null;
		this.entries = null;
		this.buildingRow = {
			entriesBuff: [],
			width: 0,
			height: 0,
			aspectRatio: 0
		};
		this.lastFetchedEntry = null;
		this.lastAnalyzedIndex = -1;
		this.yield = {
			every: 2, // do a flush every n flushes (must be greater than 1)
			flushed: 0 // flushed rows without a yield
		};
		this.border = settings.border >= 0 ? settings.border : settings.margins;
		this.maxRowHeight = this.retrieveMaxRowHeight();
		this.suffixRanges = this.retrieveSuffixRanges();
		this.offY = this.border;
		this.rows = 0;
		this.spinner = {
			phase: 0,
			timeSlot: 150,
			$el: $('<div class="spinner"><span></span><span></span><span></span></div>'),
			intervalId: null
		};
		this.checkWidthIntervalId = null;
		this.galleryWidth = $gallery.width();
		this.$gallery = $gallery;

	};

	/** @returns {String} the best suffix given the width and the height */
	JustifiedGallery.prototype.getSuffix = function(width, height) {
		var longestSide, i;
		longestSide = (width > height) ? width : height;
		for (i = 0; i < this.suffixRanges.length; i++) {
			if (longestSide <= this.suffixRanges[i]) {
				return this.settings.sizeRangeSuffixes[this.suffixRanges[i]];
			}
		}
		return this.settings.sizeRangeSuffixes[this.suffixRanges[i - 1]];
	};

	/**
	 * Remove the suffix from the string
	 *
	 * @returns {string} a new string without the suffix
	 */
	JustifiedGallery.prototype.removeSuffix = function(str, suffix) {
		return str.substring(0, str.length - suffix.length);
	};

	/**
	 * @returns {boolean} a boolean to say if the suffix is contained in the str or not
	 */
	JustifiedGallery.prototype.endsWith = function(str, suffix) {
		return str.indexOf(suffix, str.length - suffix.length) !== -1;
	};

	/**
	 * Get the used suffix of a particular url
	 *
	 * @param str
	 * @returns {String} return the used suffix
	 */
	JustifiedGallery.prototype.getUsedSuffix = function(str) {
		for (var si in this.settings.sizeRangeSuffixes) {
			if (this.settings.sizeRangeSuffixes.hasOwnProperty(si)) {
				if (this.settings.sizeRangeSuffixes[si].length === 0) continue;
				if (this.endsWith(str, this.settings.sizeRangeSuffixes[si])) return this.settings.sizeRangeSuffixes[si];
			}
		}
		return '';
	};

	/**
	 * Given an image src, with the width and the height, returns the new image src with the
	 * best suffix to show the best quality thumbnail.
	 *
	 * @returns {String} the suffix to use
	 */
	JustifiedGallery.prototype.newSrc = function(imageSrc, imgWidth, imgHeight, image) {
		var newImageSrc;

		if (this.settings.thumbnailPath) {
			newImageSrc = this.settings.thumbnailPath(imageSrc, imgWidth, imgHeight, image);
		} else {
			var matchRes = imageSrc.match(this.settings.extension);
			var ext = (matchRes !== null) ? matchRes[0] : '';
			newImageSrc = imageSrc.replace(this.settings.extension, '');
			newImageSrc = this.removeSuffix(newImageSrc, this.getUsedSuffix(newImageSrc));
			newImageSrc += this.getSuffix(imgWidth, imgHeight) + ext;
		}

		return newImageSrc;
	};

	/**
	 * Shows the images that is in the given entry
	 *
	 * @param $entry the entry
	 * @param callback the callback that is called when the show animation is finished
	 */
	JustifiedGallery.prototype.showImg = function($entry, callback) {
		if (this.settings.cssAnimation) {
			$entry.addClass('entry-visible');
			if (callback) callback();
		} else {
			$entry.stop().fadeTo(this.settings.imagesAnimationDuration, 1.0, callback);
			$entry.find('img').stop().fadeTo(this.settings.imagesAnimationDuration, 1.0, callback);
		}
	};

	/**
	 * Extract the image src form the image, looking from the 'safe-src', and if it can't be found, from the
	 * 'src' attribute. It saves in the image data the 'jg.originalSrc' field, with the extracted src.
	 *
	 * @param $image the image to analyze
	 * @returns {String} the extracted src
	 */
	JustifiedGallery.prototype.extractImgSrcFromImage = function($image) {
		var imageSrc = (typeof $image.data('safe-src') !== 'undefined') ? $image.data('safe-src') : $image.attr('src');
		$image.data('jg.originalSrc', imageSrc);
		return imageSrc;
	};

	/** @returns {jQuery} the image in the given entry */
	JustifiedGallery.prototype.imgFromEntry = function($entry) {
		var $img = $entry.find('img');
		if ($img.length === 0) $img = $entry.find('> a > img');
		return $img.length === 0 ? null : $img;
	};

	/** @returns {jQuery} the caption in the given entry */
	JustifiedGallery.prototype.captionFromEntry = function($entry) {
		var $caption = $entry.find('> .caption');
		return $caption.length === 0 ? null : $caption;
	};

	/**
	 * Display the entry
	 *
	 * @param {jQuery} $entry the entry to display
	 * @param {int} x the x position where the entry must be positioned
	 * @param y the y position where the entry must be positioned
	 * @param imgWidth the image width
	 * @param imgHeight the image height
	 * @param rowHeight the row height of the row that owns the entry
	 */
	JustifiedGallery.prototype.displayEntry = function($entry, x, y, imgWidth, imgHeight, rowHeight) {
		$entry.width(imgWidth);
		$entry.height(rowHeight);
		$entry.css('top', y);
		$entry.css('left', x);

		var $image = this.imgFromEntry($entry);
		if ($image !== null) {
			$image.css('width', imgWidth);
			$image.css('height', imgHeight);
			$image.css('margin-left', -imgWidth / 2);
			$image.css('margin-top', -imgHeight / 2);

			// Image reloading for an high quality of thumbnails
			var imageSrc = $image.attr('src');
			var newImageSrc = this.newSrc(imageSrc, imgWidth, imgHeight, $image[0]);

			$image.one('error', function() {
				$image.attr('src', $image.data('jg.originalSrc')); //revert to the original thumbnail, we got it.
			});

			var loadNewImage = function() {
				if (imageSrc !== newImageSrc) { //load the new image after the fadeIn
					$image.attr('src', newImageSrc);
				}
			};

			if ($entry.data('jg.loaded') === 'skipped') {
				this.onImageEvent(imageSrc, $.proxy(function() {
					this.showImg($entry, loadNewImage);
					$entry.data('jg.loaded', true);
				}, this));
			} else {
				this.showImg($entry, loadNewImage);
			}

		} else {
			this.showImg($entry);
		}

		this.displayEntryCaption($entry);
	};

	/**
	 * Display the entry caption. If the caption element doesn't exists, it creates the caption using the 'alt'
	 * or the 'title' attributes.
	 *
	 * @param {jQuery} $entry the entry to process
	 */
	JustifiedGallery.prototype.displayEntryCaption = function($entry) {
		var $image = this.imgFromEntry($entry);
		if ($image !== null && this.settings.captions) {
			var $imgCaption = this.captionFromEntry($entry);

			// Create it if it doesn't exists
			if ($imgCaption === null) {
				var caption = $image.attr('alt');
				if (!this.isValidCaption(caption)) caption = $entry.attr('title');
				if (this.isValidCaption(caption)) { // Create only we found something
					$imgCaption = $('<div class="caption">' + caption + '</div>');
					$entry.append($imgCaption);
					$entry.data('jg.createdCaption', true);
				}
			}

			// Create events (we check again the $imgCaption because it can be still inexistent)
			if ($imgCaption !== null) {
				if (!this.settings.cssAnimation) $imgCaption.stop().fadeTo(0, this.settings.captionSettings.nonVisibleOpacity);
				this.addCaptionEventsHandlers($entry);
			}
		} else {
			this.removeCaptionEventsHandlers($entry);
		}
	};

	/**
	 * Validates the caption
	 *
	 * @param caption The caption that should be validated
	 * @return {boolean} Validation result
	 */
	JustifiedGallery.prototype.isValidCaption = function(caption) {
		return (typeof caption !== 'undefined' && caption.length > 0);
	};

	/**
	 * The callback for the event 'mouseenter'. It assumes that the event currentTarget is an entry.
	 * It shows the caption using jQuery (or using CSS if it is configured so)
	 *
	 * @param {Event} eventObject the event object
	 */
	JustifiedGallery.prototype.onEntryMouseEnterForCaption = function(eventObject) {
		var $caption = this.captionFromEntry($(eventObject.currentTarget));
		if (this.settings.cssAnimation) {
			$caption.addClass('caption-visible').removeClass('caption-hidden');
		} else {
			$caption.stop().fadeTo(this.settings.captionSettings.animationDuration,
				this.settings.captionSettings.visibleOpacity);
		}
	};

	/**
	 * The callback for the event 'mouseleave'. It assumes that the event currentTarget is an entry.
	 * It hides the caption using jQuery (or using CSS if it is configured so)
	 *
	 * @param {Event} eventObject the event object
	 */
	JustifiedGallery.prototype.onEntryMouseLeaveForCaption = function(eventObject) {
		var $caption = this.captionFromEntry($(eventObject.currentTarget));
		if (this.settings.cssAnimation) {
			$caption.removeClass('caption-visible').removeClass('caption-hidden');
		} else {
			$caption.stop().fadeTo(this.settings.captionSettings.animationDuration,
				this.settings.captionSettings.nonVisibleOpacity);
		}
	};

	/**
	 * Add the handlers of the entry for the caption
	 *
	 * @param $entry the entry to modify
	 */
	JustifiedGallery.prototype.addCaptionEventsHandlers = function($entry) {
		var captionMouseEvents = $entry.data('jg.captionMouseEvents');
		if (typeof captionMouseEvents === 'undefined') {
			captionMouseEvents = {
				mouseenter: $.proxy(this.onEntryMouseEnterForCaption, this),
				mouseleave: $.proxy(this.onEntryMouseLeaveForCaption, this)
			};
			$entry.on('mouseenter', undefined, undefined, captionMouseEvents.mouseenter);
			$entry.on('mouseleave', undefined, undefined, captionMouseEvents.mouseleave);
			$entry.data('jg.captionMouseEvents', captionMouseEvents);
		}
	};

	/**
	 * Remove the handlers of the entry for the caption
	 *
	 * @param $entry the entry to modify
	 */
	JustifiedGallery.prototype.removeCaptionEventsHandlers = function($entry) {
		var captionMouseEvents = $entry.data('jg.captionMouseEvents');
		if (typeof captionMouseEvents !== 'undefined') {
			$entry.off('mouseenter', undefined, captionMouseEvents.mouseenter);
			$entry.off('mouseleave', undefined, captionMouseEvents.mouseleave);
			$entry.removeData('jg.captionMouseEvents');
		}
	};

	/**
	 * Justify the building row, preparing it to
	 *
	 * @param isLastRow
	 * @returns a boolean to know if the row has been justified or not
	 */
	JustifiedGallery.prototype.prepareBuildingRow = function(isLastRow) {
		var i, $entry, imgAspectRatio, newImgW, newImgH, justify = true;
		var minHeight = 0;
		var availableWidth = this.galleryWidth - 2 * this.border - (
			(this.buildingRow.entriesBuff.length - 1) * this.settings.margins);
		var rowHeight = availableWidth / this.buildingRow.aspectRatio;
		var defaultRowHeight = this.settings.rowHeight;
		var justifiable = this.buildingRow.width / availableWidth > this.settings.justifyThreshold;

		//Skip the last row if we can't justify it and the lastRow == 'hide'
		if (isLastRow && this.settings.lastRow === 'hide' && !justifiable) {
			for (i = 0; i < this.buildingRow.entriesBuff.length; i++) {
				$entry = this.buildingRow.entriesBuff[i];
				if (this.settings.cssAnimation)
					$entry.removeClass('entry-visible');
				else {
					$entry.stop().fadeTo(0, 0.1);
					$entry.find('> img, > a > img').fadeTo(0, 0);
				}
			}
			return -1;
		}

		// With lastRow = nojustify, justify if is justificable (the images will not become too big)
		if (isLastRow && !justifiable && this.settings.lastRow !== 'justify' && this.settings.lastRow !== 'hide') {
			justify = false;

			if (this.rows > 0) {
				defaultRowHeight = (this.offY - this.border - this.settings.margins * this.rows) / this.rows;
				justify = defaultRowHeight * this.buildingRow.aspectRatio / availableWidth > this.settings.justifyThreshold;
			}
		}

		for (i = 0; i < this.buildingRow.entriesBuff.length; i++) {
			$entry = this.buildingRow.entriesBuff[i];
			imgAspectRatio = $entry.data('jg.width') / $entry.data('jg.height');

			if (justify) {
				newImgW = (i === this.buildingRow.entriesBuff.length - 1) ? availableWidth : rowHeight * imgAspectRatio;
				newImgH = rowHeight;
			} else {
				newImgW = defaultRowHeight * imgAspectRatio;
				newImgH = defaultRowHeight;
			}

			availableWidth -= Math.round(newImgW);
			$entry.data('jg.jwidth', Math.round(newImgW));
			$entry.data('jg.jheight', Math.ceil(newImgH));
			if (i === 0 || minHeight > newImgH) minHeight = newImgH;
		}

		this.buildingRow.height = minHeight;
		return justify;
	};

	/**
	 * Clear the building row data to be used for a new row
	 */
	JustifiedGallery.prototype.clearBuildingRow = function() {
		this.buildingRow.entriesBuff = [];
		this.buildingRow.aspectRatio = 0;
		this.buildingRow.width = 0;
	};

	/**
	 * Flush a row: justify it, modify the gallery height accordingly to the row height
	 *
	 * @param isLastRow
	 */
	JustifiedGallery.prototype.flushRow = function(isLastRow) {
		var settings = this.settings;
		var $entry, buildingRowRes, offX = this.border,
			i;

		buildingRowRes = this.prepareBuildingRow(isLastRow);
		if (isLastRow && settings.lastRow === 'hide' && buildingRowRes === -1) {
			this.clearBuildingRow();
			return;
		}

		if (this.maxRowHeight) {
			if (this.maxRowHeight.isPercentage && this.maxRowHeight.value * settings.rowHeight < this.buildingRow.height) {
				this.buildingRow.height = this.maxRowHeight.value * settings.rowHeight;
			} else if (this.maxRowHeight.value >= settings.rowHeight && this.maxRowHeight.value < this.buildingRow.height) {
				this.buildingRow.height = this.maxRowHeight.value;
			}
		}

		//Align last (unjustified) row
		if (settings.lastRow === 'center' || settings.lastRow === 'right') {
			var availableWidth = this.galleryWidth - 2 * this.border - (this.buildingRow.entriesBuff.length - 1) * settings.margins;

			for (i = 0; i < this.buildingRow.entriesBuff.length; i++) {
				$entry = this.buildingRow.entriesBuff[i];
				availableWidth -= $entry.data('jg.jwidth');
			}

			if (settings.lastRow === 'center')
				offX += availableWidth / 2;
			else if (settings.lastRow === 'right')
				offX += availableWidth;
		}

		for (i = 0; i < this.buildingRow.entriesBuff.length; i++) {
			$entry = this.buildingRow.entriesBuff[i];
			this.displayEntry($entry, offX, this.offY, $entry.data('jg.jwidth'), $entry.data('jg.jheight'), this.buildingRow.height);
			offX += $entry.data('jg.jwidth') + settings.margins;
		}

		//Gallery Height
		this.galleryHeightToSet = this.offY + this.buildingRow.height + this.border;
		this.$gallery.height(this.galleryHeightToSet + this.getSpinnerHeight());

		if (!isLastRow || (this.buildingRow.height <= settings.rowHeight && buildingRowRes)) {
			//Ready for a new row
			this.offY += this.buildingRow.height + settings.margins;
			this.rows += 1;
			this.clearBuildingRow();
			this.$gallery.trigger('jg.rowflush');
		}
	};

	/**
	 * Checks the width of the gallery container, to know if a new justification is needed
	 */
	var scrollBarOn = false;
	JustifiedGallery.prototype.checkWidth = function() {
		this.checkWidthIntervalId = setInterval($.proxy(function() {
			var galleryWidth = parseFloat(this.$gallery.width());
			if (hasScrollBar() === scrollBarOn) {
				if (Math.abs(galleryWidth - this.galleryWidth) > this.settings.refreshSensitivity) {
					this.galleryWidth = galleryWidth;
					this.rewind();

					// Restart to analyze
					this.startImgAnalyzer(true);
				}
			} else {
				scrollBarOn = hasScrollBar();
				this.galleryWidth = galleryWidth;
			}
		}, this), this.settings.refreshTime);
	};

	/**
	 * @returns {boolean} a boolean saying if the spinner is active or not
	 */
	JustifiedGallery.prototype.isSpinnerActive = function() {
		return this.spinner.intervalId !== null;
	};

	/**
	 * @returns {int} the spinner height
	 */
	JustifiedGallery.prototype.getSpinnerHeight = function() {
		return this.spinner.$el.innerHeight();
	};

	/**
	 * Stops the spinner animation and modify the gallery height to exclude the spinner
	 */
	JustifiedGallery.prototype.stopLoadingSpinnerAnimation = function() {
		clearInterval(this.spinner.intervalId);
		this.spinner.intervalId = null;
		this.$gallery.height(this.$gallery.height() - this.getSpinnerHeight());
		this.spinner.$el.detach();
	};

	/**
	 * Starts the spinner animation
	 */
	JustifiedGallery.prototype.startLoadingSpinnerAnimation = function() {
		var spinnerContext = this.spinner;
		var $spinnerPoints = spinnerContext.$el.find('span');
		clearInterval(spinnerContext.intervalId);
		this.$gallery.append(spinnerContext.$el);
		this.$gallery.height(this.offY + this.buildingRow.height + this.getSpinnerHeight());
		spinnerContext.intervalId = setInterval(function() {
			if (spinnerContext.phase < $spinnerPoints.length) {
				$spinnerPoints.eq(spinnerContext.phase).fadeTo(spinnerContext.timeSlot, 1);
			} else {
				$spinnerPoints.eq(spinnerContext.phase - $spinnerPoints.length).fadeTo(spinnerContext.timeSlot, 0);
			}
			spinnerContext.phase = (spinnerContext.phase + 1) % ($spinnerPoints.length * 2);
		}, spinnerContext.timeSlot);
	};

	/**
	 * Rewind the image analysis to start from the first entry.
	 */
	JustifiedGallery.prototype.rewind = function() {
		this.lastFetchedEntry = null;
		this.lastAnalyzedIndex = -1;
		this.offY = this.border;
		this.rows = 0;
		this.clearBuildingRow();
	};

	/**
	 * Update the entries searching it from the justified gallery HTML element
	 *
	 * @param norewind if norewind only the new entries will be changed (i.e. randomized, sorted or filtered)
	 * @returns {boolean} true if some entries has been founded
	 */
	JustifiedGallery.prototype.updateEntries = function(norewind) {
		var newEntries;

		if (norewind && this.lastFetchedEntry != null) {
			newEntries = $(this.lastFetchedEntry).nextAll(this.settings.selector).toArray();
		} else {
			this.entries = [];
			newEntries = this.$gallery.children(this.settings.selector).toArray();
		}

		if (newEntries.length > 0) {

			// Sort or randomize
			if ($.isFunction(this.settings.sort)) {
				newEntries = this.sortArray(newEntries);
			} else if (this.settings.randomize) {
				newEntries = this.shuffleArray(newEntries);
			}
			this.lastFetchedEntry = newEntries[newEntries.length - 1];

			// Filter
			if (this.settings.filter) {
				newEntries = this.filterArray(newEntries);
			} else {
				this.resetFilters(newEntries);
			}

		}

		this.entries = this.entries.concat(newEntries);
		return true;
	};

	/**
	 * Apply the entries order to the DOM, iterating the entries and appending the images
	 *
	 * @param entries the entries that has been modified and that must be re-ordered in the DOM
	 */
	JustifiedGallery.prototype.insertToGallery = function(entries) {
		var that = this;
		$.each(entries, function() {
			$(this).appendTo(that.$gallery);
		});
	};

	/**
	 * Shuffle the array using the Fisher-Yates shuffle algorithm
	 *
	 * @param a the array to shuffle
	 * @return the shuffled array
	 */
	JustifiedGallery.prototype.shuffleArray = function(a) {
		var i, j, temp;
		for (i = a.length - 1; i > 0; i--) {
			j = Math.floor(Math.random() * (i + 1));
			temp = a[i];
			a[i] = a[j];
			a[j] = temp;
		}
		this.insertToGallery(a);
		return a;
	};

	/**
	 * Sort the array using settings.comparator as comparator
	 *
	 * @param a the array to sort (it is sorted)
	 * @return the sorted array
	 */
	JustifiedGallery.prototype.sortArray = function(a) {
		a.sort(this.settings.sort);
		this.insertToGallery(a);
		return a;
	};

	/**
	 * Reset the filters removing the 'jg-filtered' class from all the entries
	 *
	 * @param a the array to reset
	 */
	JustifiedGallery.prototype.resetFilters = function(a) {
		for (var i = 0; i < a.length; i++) $(a[i]).removeClass('jg-filtered');
	};

	/**
	 * Filter the entries considering theirs classes (if a string has been passed) or using a function for filtering.
	 *
	 * @param a the array to filter
	 * @return the filtered array
	 */
	JustifiedGallery.prototype.filterArray = function(a) {
		var settings = this.settings;
		if ($.type(settings.filter) === 'string') {
			// Filter only keeping the entries passed in the string
			return a.filter(function(el) {
				var $el = $(el);
				if ($el.is(settings.filter)) {
					$el.removeClass('jg-filtered');
					return true;
				} else {
					$el.addClass('jg-filtered').removeClass('jg-visible');
					return false;
				}
			});
		} else if ($.isFunction(settings.filter)) {
			// Filter using the passed function
			var filteredArr = a.filter(settings.filter);
			for (var i = 0; i < a.length; i++) {
				if (filteredArr.indexOf(a[i]) == -1) {
					$(a[i]).addClass('jg-filtered').removeClass('jg-visible');
				} else {
					$(a[i]).removeClass('jg-filtered');
				}
			}
			return filteredArr;
		}
	};

	/**
	 * Destroy the Justified Gallery instance.
	 *
	 * It clears all the css properties added in the style attributes. We doesn't backup the original
	 * values for those css attributes, because it costs (performance) and because in general one
	 * shouldn't use the style attribute for an uniform set of images (where we suppose the use of
	 * classes). Creating a backup is also difficult because JG could be called multiple times and
	 * with different style attributes.
	 */
	JustifiedGallery.prototype.destroy = function() {
		clearInterval(this.checkWidthIntervalId);

		$.each(this.entries, $.proxy(function(_, entry) {
			var $entry = $(entry);

			// Reset entry style
			$entry.css('width', '');
			$entry.css('height', '');
			$entry.css('top', '');
			$entry.css('left', '');
			$entry.data('jg.loaded', undefined);
			$entry.removeClass('jg-entry');

			// Reset image style
			var $img = this.imgFromEntry($entry);
			$img.css('width', '');
			$img.css('height', '');
			$img.css('margin-left', '');
			$img.css('margin-top', '');
			$img.attr('src', $img.data('jg.originalSrc'));
			$img.data('jg.originalSrc', undefined);

			// Remove caption
			this.removeCaptionEventsHandlers($entry);
			var $caption = this.captionFromEntry($entry);
			if ($entry.data('jg.createdCaption')) {
				// remove also the caption element (if created by jg)
				$entry.data('jg.createdCaption', undefined);
				if ($caption !== null) $caption.remove();
			} else {
				if ($caption !== null) $caption.fadeTo(0, 1);
			}

		}, this));

		this.$gallery.css('height', '');
		this.$gallery.removeClass('justified-gallery');
		this.$gallery.data('jg.controller', undefined);
	};

	/**
	 * Analyze the images and builds the rows. It returns if it found an image that is not loaded.
	 *
	 * @param isForResize if the image analyzer is called for resizing or not, to call a different callback at the end
	 */
	JustifiedGallery.prototype.analyzeImages = function(isForResize) {
		for (var i = this.lastAnalyzedIndex + 1; i < this.entries.length; i++) {
			var $entry = $(this.entries[i]);
			if ($entry.data('jg.loaded') === true || $entry.data('jg.loaded') === 'skipped') {
				var availableWidth = this.galleryWidth - 2 * this.border - (
					(this.buildingRow.entriesBuff.length - 1) * this.settings.margins);
				var imgAspectRatio = $entry.data('jg.width') / $entry.data('jg.height');
				if (availableWidth / (this.buildingRow.aspectRatio + imgAspectRatio) < this.settings.rowHeight) {
					this.flushRow(false);
					if (++this.yield.flushed >= this.yield.every) {
						this.startImgAnalyzer(isForResize);
						return;
					}
				}

				this.buildingRow.entriesBuff.push($entry);
				this.buildingRow.aspectRatio += imgAspectRatio;
				this.buildingRow.width += imgAspectRatio * this.settings.rowHeight;
				this.lastAnalyzedIndex = i;

			} else if ($entry.data('jg.loaded') !== 'error') {
				return;
			}
		}

		// Last row flush (the row is not full)
		if (this.buildingRow.entriesBuff.length > 0) this.flushRow(true);

		if (this.isSpinnerActive()) {
			this.stopLoadingSpinnerAnimation();
		}

		/* Stop, if there is, the timeout to start the analyzeImages.
		 This is because an image can be set loaded, and the timeout can be set,
		 but this image can be analyzed yet.
		 */
		this.stopImgAnalyzerStarter();

		//On complete callback
		this.$gallery.trigger(isForResize ? 'jg.resize' : 'jg.complete');
		this.$gallery.height(this.galleryHeightToSet);
	};

	/**
	 * Stops any ImgAnalyzer starter (that has an assigned timeout)
	 */
	JustifiedGallery.prototype.stopImgAnalyzerStarter = function() {
		this.yield.flushed = 0;
		if (this.imgAnalyzerTimeout !== null) clearTimeout(this.imgAnalyzerTimeout);
	};

	/**
	 * Starts the image analyzer. It is not immediately called to let the browser to update the view
	 *
	 * @param isForResize specifies if the image analyzer must be called for resizing or not
	 */
	JustifiedGallery.prototype.startImgAnalyzer = function(isForResize) {
		var that = this;
		this.stopImgAnalyzerStarter();
		this.imgAnalyzerTimeout = setTimeout(function() {
			that.analyzeImages(isForResize);
		}, 0.001); // we can't start it immediately due to a IE different behaviour
	};

	/**
	 * Checks if the image is loaded or not using another image object. We cannot use the 'complete' image property,
	 * because some browsers, with a 404 set complete = true.
	 *
	 * @param imageSrc the image src to load
	 * @param onLoad callback that is called when the image has been loaded
	 * @param onError callback that is called in case of an error
	 */
	JustifiedGallery.prototype.onImageEvent = function(imageSrc, onLoad, onError) {
		if (!onLoad && !onError) return;

		var memImage = new Image();
		var $memImage = $(memImage);
		if (onLoad) {
			$memImage.one('load', function() {
				$memImage.off('load error');
				onLoad(memImage);
			});
		}
		if (onError) {
			$memImage.one('error', function() {
				$memImage.off('load error');
				onError(memImage);
			});
		}
		memImage.src = imageSrc;
	};

	/**
	 * Init of Justified Gallery controlled
	 * It analyzes all the entries starting theirs loading and calling the image analyzer (that works with loaded images)
	 */
	JustifiedGallery.prototype.init = function() {
		var imagesToLoad = false,
			skippedImages = false,
			that = this;
		$.each(this.entries, function(index, entry) {
			var $entry = $(entry);
			var $image = that.imgFromEntry($entry);

			$entry.addClass('jg-entry');

			if ($entry.data('jg.loaded') !== true && $entry.data('jg.loaded') !== 'skipped') {

				// Link Rel global overwrite
				if (that.settings.rel !== null) $entry.attr('rel', that.settings.rel);

				// Link Target global overwrite
				if (that.settings.target !== null) $entry.attr('target', that.settings.target);

				if ($image !== null) {

					// Image src
					var imageSrc = that.extractImgSrcFromImage($image);
					$image.attr('src', imageSrc);

					/* If we have the height and the width, we don't wait that the image is loaded, but we start directly
					 * with the justification */
					if (that.settings.waitThumbnailsLoad === false) {
						var width = parseFloat($image.attr('width'));
						var height = parseFloat($image.attr('height'));
						if (!isNaN(width) && !isNaN(height)) {
							$entry.data('jg.width', width);
							$entry.data('jg.height', height);
							$entry.data('jg.loaded', 'skipped');
							skippedImages = true;
							that.startImgAnalyzer(false);
							return true; // continue
						}
					}

					$entry.data('jg.loaded', false);
					imagesToLoad = true;

					// Spinner start
					if (!that.isSpinnerActive()) that.startLoadingSpinnerAnimation();

					that.onImageEvent(imageSrc, function(loadImg) { // image loaded
						$entry.data('jg.width', loadImg.width);
						$entry.data('jg.height', loadImg.height);
						$entry.data('jg.loaded', true);
						that.startImgAnalyzer(false);
					}, function() { // image load error
						$entry.data('jg.loaded', 'error');
						that.startImgAnalyzer(false);
					});

				} else {
					$entry.data('jg.loaded', true);
					$entry.data('jg.width', $entry.width() | parseFloat($entry.css('width')) | 1);
					$entry.data('jg.height', $entry.height() | parseFloat($entry.css('height')) | 1);
				}

			}

		});

		if (!imagesToLoad && !skippedImages) this.startImgAnalyzer(false);
		this.checkWidth();
	};

	/**
	 * Checks that it is a valid number. If a string is passed it is converted to a number
	 *
	 * @param settingContainer the object that contains the setting (to allow the conversion)
	 * @param settingName the setting name
	 */
	JustifiedGallery.prototype.checkOrConvertNumber = function(settingContainer, settingName) {
		if ($.type(settingContainer[settingName]) === 'string') {
			settingContainer[settingName] = parseFloat(settingContainer[settingName]);
		}

		if ($.type(settingContainer[settingName]) === 'number') {
			if (isNaN(settingContainer[settingName])) throw 'invalid number for ' + settingName;
		} else {
			throw settingName + ' must be a number';
		}
	};

	/**
	 * Checks the sizeRangeSuffixes and, if necessary, converts
	 * its keys from string (e.g. old settings with 'lt100') to int.
	 */
	JustifiedGallery.prototype.checkSizeRangesSuffixes = function() {
		if ($.type(this.settings.sizeRangeSuffixes) !== 'object') {
			throw 'sizeRangeSuffixes must be defined and must be an object';
		}

		var suffixRanges = [];
		for (var rangeIdx in this.settings.sizeRangeSuffixes) {
			if (this.settings.sizeRangeSuffixes.hasOwnProperty(rangeIdx)) suffixRanges.push(rangeIdx);
		}

		var newSizeRngSuffixes = {
			0: ''
		};
		for (var i = 0; i < suffixRanges.length; i++) {
			if ($.type(suffixRanges[i]) === 'string') {
				try {
					var numIdx = parseInt(suffixRanges[i].replace(/^[a-z]+/, ''), 10);
					newSizeRngSuffixes[numIdx] = this.settings.sizeRangeSuffixes[suffixRanges[i]];
				} catch (e) {
					throw 'sizeRangeSuffixes keys must contains correct numbers (' + e + ')';
				}
			} else {
				newSizeRngSuffixes[suffixRanges[i]] = this.settings.sizeRangeSuffixes[suffixRanges[i]];
			}
		}

		this.settings.sizeRangeSuffixes = newSizeRngSuffixes;
	};

	/**
	 * check and convert the maxRowHeight setting
	 */
	JustifiedGallery.prototype.retrieveMaxRowHeight = function() {
		var newMaxRowHeight = {};

		if ($.type(this.settings.maxRowHeight) === 'string') {
			if (this.settings.maxRowHeight.match(/^[0-9]+%$/)) {
				newMaxRowHeight.value = parseFloat(this.settings.maxRowHeight.match(/^([0-9]+)%$/)[1]) / 100;
				newMaxRowHeight.isPercentage = false;
			} else {
				newMaxRowHeight.value = parseFloat(this.settings.maxRowHeight);
				newMaxRowHeight.isPercentage = true;
			}
		} else if ($.type(this.settings.maxRowHeight) === 'number') {
			newMaxRowHeight.value = this.settings.maxRowHeight;
			newMaxRowHeight.isPercentage = false;
		} else if (this.settings.maxRowHeight === false ||
			this.settings.maxRowHeight === null ||
			typeof this.settings.maxRowHeight == 'undefined') {
			return null;
		} else {
			throw 'maxRowHeight must be a number or a percentage';
		}

		// check if the converted value is not a number
		if (isNaN(newMaxRowHeight.value)) throw 'invalid number for maxRowHeight';

		// check values
		if (newMaxRowHeight.isPercentage) {
			if (newMaxRowHeight.value < 100) newMaxRowHeight.value = 100;
		}

		return newMaxRowHeight;
	};

	/**
	 * Checks the settings
	 */
	JustifiedGallery.prototype.checkSettings = function() {
		this.checkSizeRangesSuffixes();

		this.checkOrConvertNumber(this.settings, 'rowHeight');
		this.checkOrConvertNumber(this.settings, 'margins');
		this.checkOrConvertNumber(this.settings, 'border');

		var lastRowModes = [
			'justify',
			'nojustify',
			'left',
			'center',
			'right',
			'hide'
		];
		if (lastRowModes.indexOf(this.settings.lastRow) === -1) {
			throw 'lastRow must be one of: ' + lastRowModes.join(', ');
		}

		this.checkOrConvertNumber(this.settings, 'justifyThreshold');
		if (this.settings.justifyThreshold < 0 || this.settings.justifyThreshold > 1) {
			throw 'justifyThreshold must be in the interval [0,1]';
		}
		if ($.type(this.settings.cssAnimation) !== 'boolean') {
			throw 'cssAnimation must be a boolean';
		}

		if ($.type(this.settings.captions) !== 'boolean') throw 'captions must be a boolean';
		this.checkOrConvertNumber(this.settings.captionSettings, 'animationDuration');

		this.checkOrConvertNumber(this.settings.captionSettings, 'visibleOpacity');
		if (this.settings.captionSettings.visibleOpacity < 0 ||
			this.settings.captionSettings.visibleOpacity > 1) {
			throw 'captionSettings.visibleOpacity must be in the interval [0, 1]';
		}

		this.checkOrConvertNumber(this.settings.captionSettings, 'nonVisibleOpacity');
		if (this.settings.captionSettings.nonVisibleOpacity < 0 ||
			this.settings.captionSettings.nonVisibleOpacity > 1) {
			throw 'captionSettings.nonVisibleOpacity must be in the interval [0, 1]';
		}

		this.checkOrConvertNumber(this.settings, 'imagesAnimationDuration');
		this.checkOrConvertNumber(this.settings, 'refreshTime');
		this.checkOrConvertNumber(this.settings, 'refreshSensitivity');
		if ($.type(this.settings.randomize) !== 'boolean') throw 'randomize must be a boolean';
		if ($.type(this.settings.selector) !== 'string') throw 'selector must be a string';

		if (this.settings.sort !== false && !$.isFunction(this.settings.sort)) {
			throw 'sort must be false or a comparison function';
		}

		if (this.settings.filter !== false && !$.isFunction(this.settings.filter) &&
			$.type(this.settings.filter) !== 'string') {
			throw 'filter must be false, a string or a filter function';
		}
	};

	/**
	 * It brings all the indexes from the sizeRangeSuffixes and it orders them. They are then sorted and returned.
	 * @returns {Array} sorted suffix ranges
	 */
	JustifiedGallery.prototype.retrieveSuffixRanges = function() {
		var suffixRanges = [];
		for (var rangeIdx in this.settings.sizeRangeSuffixes) {
			if (this.settings.sizeRangeSuffixes.hasOwnProperty(rangeIdx)) suffixRanges.push(parseInt(rangeIdx, 10));
		}
		suffixRanges.sort(function(a, b) {
			return a > b ? 1 : a < b ? -1 : 0;
		});
		return suffixRanges;
	};

	/**
	 * Update the existing settings only changing some of them
	 *
	 * @param newSettings the new settings (or a subgroup of them)
	 */
	JustifiedGallery.prototype.updateSettings = function(newSettings) {
		// In this case Justified Gallery has been called again changing only some options
		this.settings = $.extend({}, this.settings, newSettings);
		this.checkSettings();

		// As reported in the settings: negative value = same as margins, 0 = disabled
		this.border = this.settings.border >= 0 ? this.settings.border : this.settings.margins;

		this.maxRowHeight = this.retrieveMaxRowHeight();
		this.suffixRanges = this.retrieveSuffixRanges();
	};

	/**
	 * Justified Gallery plugin for jQuery
	 *
	 * Events
	 *  - jg.complete : called when all the gallery has been created
	 *  - jg.resize : called when the gallery has been resized
	 *  - jg.rowflush : when a new row appears
	 *
	 * @param arg the action (or the settings) passed when the plugin is called
	 * @returns {*} the object itself
	 */
	$.fn.justifiedGallery = function(arg) {
		return this.each(function(index, gallery) {

			var $gallery = $(gallery);
			$gallery.addClass('justified-gallery');

			var controller = $gallery.data('jg.controller');
			if (typeof controller === 'undefined') {
				// Create controller and assign it to the object data
				if (typeof arg !== 'undefined' && arg !== null && $.type(arg) !== 'object') {
					if (arg === 'destroy') return; // Just a call to an unexisting object
					throw 'The argument must be an object';
				}
				controller = new JustifiedGallery($gallery, $.extend({}, $.fn.justifiedGallery.defaults, arg));
				$gallery.data('jg.controller', controller);
			} else if (arg === 'norewind') {
				// In this case we don't rewind: we analyze only the latest images (e.g. to complete the last unfinished row
				// ... left to be more readable
			} else if (arg === 'destroy') {
				controller.destroy();
				return;
			} else {
				// In this case Justified Gallery has been called again changing only some options
				controller.updateSettings(arg);
				controller.rewind();
			}

			// Update the entries list
			if (!controller.updateEntries(arg === 'norewind')) return;

			// Init justified gallery
			controller.init();

		});
	};

	// Default options
	$.fn.justifiedGallery.defaults = {
		sizeRangeSuffixes: {},
		/* e.g. Flickr configuration
		       {
		         100: '_t',  // used when longest is less than 100px
		         240: '_m',  // used when longest is between 101px and 240px
		         320: '_n',  // ...
		         500: '',
		         640: '_z',
		         1024: '_b'  // used as else case because it is the last
		       }
		   */
		thumbnailPath: undefined,
		/* If defined, sizeRangeSuffixes is not used, and this function is used to determine the
		   path relative to a specific thumbnail size. The function should accept respectively three arguments:
		   current path, width and height */
		rowHeight: 120,
		maxRowHeight: false, // false or negative value to deactivate. Positive number to express the value in pixels,
		// A string '[0-9]+%' to express in percentage (e.g. 300% means that the row height
		// can't exceed 3 * rowHeight)
		margins: 1,
		border: -1, // negative value = same as margins, 0 = disabled, any other value to set the border

		lastRow: 'nojustify', // … which is the same as 'left', or can be 'justify', 'center', 'right' or 'hide'

		justifyThreshold: 0.90,
		/* if row width / available space > 0.90 it will be always justified
		 * (i.e. lastRow setting is not considered) */
		waitThumbnailsLoad: true,
		captions: true,
		cssAnimation: true,
		imagesAnimationDuration: 500, // ignored with css animations
		captionSettings: { // ignored with css animations
			animationDuration: 500,
			visibleOpacity: 0.7,
			nonVisibleOpacity: 0.0
		},
		rel: null, // rewrite the rel of each analyzed links
		target: null, // rewrite the target of all links
		extension: /\.[^.\\/]+$/, // regexp to capture the extension of an image
		refreshTime: 200, // time interval (in ms) to check if the page changes its width
		refreshSensitivity: 0, // change in width allowed (in px) without re-building the gallery
		randomize: false,
		sort: false,
		/*
		     - false: to do not sort
		     - function: to sort them using the function as comparator (see Array.prototype.sort())
		   */
		filter: false,
		/*
		     - false, null or undefined: for a disabled filter
		     - a string: an entry is kept if entry.is(filter string) returns true
		                 see jQuery's .is() function for further information
		     - a function: invoked with arguments (entry, index, array). Return true to keep the entry, false otherwise.
		                   It follows the specifications of the Array.prototype.filter() function of JavaScript.
		   */
		selector: 'a, div:not(.spinner)' // The selector that is used to know what are the entries of the gallery
	};

}(jQuery));



/*!
 * Masonry PACKAGED v4.2.0
 * Cascading grid layout library
 * http://masonry.desandro.com
 * MIT License
 * by David DeSandro
 */
/**
 * Bridget makes jQuery widgets
 * v2.0.1
 * MIT license
 */
/* jshint browser: true, strict: true, undef: true, unused: true */
(function(window, factory) {
	// universal module definition
	/*jshint strict: false */
	/* globals define, module, require */
	if (typeof define == 'function' && define.amd) {
		// AMD
		define('jquery-bridget/jquery-bridget', ['jquery'], function(jQuery) {
			return factory(window, jQuery);
		});
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS
		module.exports = factory(
			window,
			require('jquery')
		);
	} else {
		// browser global
		window.jQueryBridget = factory(
			window,
			window.jQuery
		);
	}

}(window, function factory(window, jQuery) {
	'use strict';

	// ----- utils ----- //

	var arraySlice = Array.prototype.slice;

	// helper function for logging errors
	// $.error breaks jQuery chaining
	var console = window.console;
	var logError = typeof console == 'undefined' ? function() {} :
		function(message) {
			console.error(message);
		};

	// ----- jQueryBridget ----- //

	function jQueryBridget(namespace, PluginClass, $) {
		$ = $ || jQuery || window.jQuery;
		if (!$) {
			return;
		}

		// add option method -> $().plugin('option', {...})
		if (!PluginClass.prototype.option) {
			// option setter
			PluginClass.prototype.option = function(opts) {
				// bail out if not an object
				if (!$.isPlainObject(opts)) {
					return;
				}
				this.options = $.extend(true, this.options, opts);
			};
		}

		// make jQuery plugin
		$.fn[namespace] = function(arg0 /*, arg1 */ ) {
			if (typeof arg0 == 'string') {
				// method call $().plugin( 'methodName', { options } )
				// shift arguments by 1
				var args = arraySlice.call(arguments, 1);
				return methodCall(this, arg0, args);
			}
			// just $().plugin({ options })
			plainCall(this, arg0);
			return this;
		};

		// $().plugin('methodName')
		function methodCall($elems, methodName, args) {
			var returnValue;
			var pluginMethodStr = '$().' + namespace + '("' + methodName + '")';

			$elems.each(function(i, elem) {
				// get instance
				var instance = $.data(elem, namespace);
				if (!instance) {
					logError(namespace + ' not initialized. Cannot call methods, i.e. ' +
						pluginMethodStr);
					return;
				}

				var method = instance[methodName];
				if (!method || methodName.charAt(0) == '_') {
					logError(pluginMethodStr + ' is not a valid method');
					return;
				}

				// apply method, get return value
				var value = method.apply(instance, args);
				// set return value if value is returned, use only first value
				returnValue = returnValue === undefined ? value : returnValue;
			});

			return returnValue !== undefined ? returnValue : $elems;
		}

		function plainCall($elems, options) {
			$elems.each(function(i, elem) {
				var instance = $.data(elem, namespace);
				if (instance) {
					// set options & init
					instance.option(options);
					instance._init();
				} else {
					// initialize new instance
					instance = new PluginClass(elem, options);
					$.data(elem, namespace, instance);
				}
			});
		}

		updateJQuery($);

	}

	// ----- updateJQuery ----- //

	// set $.bridget for v1 backwards compatibility
	function updateJQuery($) {
		if (!$ || ($ && $.bridget)) {
			return;
		}
		$.bridget = jQueryBridget;
	}

	updateJQuery(jQuery || window.jQuery);

	// -----  ----- //

	return jQueryBridget;

}));

/**
 * EvEmitter v1.0.3
 * Lil' event emitter
 * MIT License
 */

/* jshint unused: true, undef: true, strict: true */

(function(global, factory) {
	// universal module definition
	/* jshint strict: false */
	/* globals define, module, window */
	if (typeof define == 'function' && define.amd) {
		// AMD - RequireJS
		define('ev-emitter/ev-emitter', factory);
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS - Browserify, Webpack
		module.exports = factory();
	} else {
		// Browser globals
		global.EvEmitter = factory();
	}

}(typeof window != 'undefined' ? window : this, function() {



	function EvEmitter() {}

	var proto = EvEmitter.prototype;

	proto.on = function(eventName, listener) {
		if (!eventName || !listener) {
			return;
		}
		// set events hash
		var events = this._events = this._events || {};
		// set listeners array
		var listeners = events[eventName] = events[eventName] || [];
		// only add once
		if (listeners.indexOf(listener) == -1) {
			listeners.push(listener);
		}

		return this;
	};

	proto.once = function(eventName, listener) {
		if (!eventName || !listener) {
			return;
		}
		// add event
		this.on(eventName, listener);
		// set once flag
		// set onceEvents hash
		var onceEvents = this._onceEvents = this._onceEvents || {};
		// set onceListeners object
		var onceListeners = onceEvents[eventName] = onceEvents[eventName] || {};
		// set flag
		onceListeners[listener] = true;

		return this;
	};

	proto.off = function(eventName, listener) {
		var listeners = this._events && this._events[eventName];
		if (!listeners || !listeners.length) {
			return;
		}
		var index = listeners.indexOf(listener);
		if (index != -1) {
			listeners.splice(index, 1);
		}

		return this;
	};

	proto.emitEvent = function(eventName, args) {
		var listeners = this._events && this._events[eventName];
		if (!listeners || !listeners.length) {
			return;
		}
		var i = 0;
		var listener = listeners[i];
		args = args || [];
		// once stuff
		var onceListeners = this._onceEvents && this._onceEvents[eventName];

		while (listener) {
			var isOnce = onceListeners && onceListeners[listener];
			if (isOnce) {
				// remove listener
				// remove before trigger to prevent recursion
				this.off(eventName, listener);
				// unset once flag
				delete onceListeners[listener];
			}
			// trigger listener
			listener.apply(this, args);
			// get next listener
			i += isOnce ? 0 : 1;
			listener = listeners[i];
		}

		return this;
	};

	return EvEmitter;

}));

/*!
 * getSize v2.0.2
 * measure size of elements
 * MIT license
 */

/*jshint browser: true, strict: true, undef: true, unused: true */
/*global define: false, module: false, console: false */

(function(window, factory) {
	'use strict';

	if (typeof define == 'function' && define.amd) {
		// AMD
		define('get-size/get-size', [], function() {
			return factory();
		});
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS
		module.exports = factory();
	} else {
		// browser global
		window.getSize = factory();
	}

})(window, function factory() {
	'use strict';

	// -------------------------- helpers -------------------------- //

	// get a number from a string, not a percentage
	function getStyleSize(value) {
		var num = parseFloat(value);
		// not a percent like '100%', and a number
		var isValid = value.indexOf('%') == -1 && !isNaN(num);
		return isValid && num;
	}

	function noop() {}

	var logError = typeof console == 'undefined' ? noop :
		function(message) {
			console.error(message);
		};

	// -------------------------- measurements -------------------------- //

	var measurements = [
		'paddingLeft',
		'paddingRight',
		'paddingTop',
		'paddingBottom',
		'marginLeft',
		'marginRight',
		'marginTop',
		'marginBottom',
		'borderLeftWidth',
		'borderRightWidth',
		'borderTopWidth',
		'borderBottomWidth'
	];

	var measurementsLength = measurements.length;

	function getZeroSize() {
		var size = {
			width: 0,
			height: 0,
			innerWidth: 0,
			innerHeight: 0,
			outerWidth: 0,
			outerHeight: 0
		};
		for (var i = 0; i < measurementsLength; i++) {
			var measurement = measurements[i];
			size[measurement] = 0;
		}
		return size;
	}

	// -------------------------- getStyle -------------------------- //

	/**
	 * getStyle, get style of element, check for Firefox bug
	 * https://bugzilla.mozilla.org/show_bug.cgi?id=548397
	 */
	function getStyle(elem) {
		var style = getComputedStyle(elem);
		if (!style) {
			logError('Style returned ' + style +
				'. Are you running this code in a hidden iframe on Firefox? ' +
				'See http://bit.ly/getsizebug1');
		}
		return style;
	}

	// -------------------------- setup -------------------------- //

	var isSetup = false;

	var isBoxSizeOuter;

	/**
	 * setup
	 * check isBoxSizerOuter
	 * do on first getSize() rather than on page load for Firefox bug
	 */
	function setup() {
		// setup once
		if (isSetup) {
			return;
		}
		isSetup = true;

		// -------------------------- box sizing -------------------------- //

		/**
		 * WebKit measures the outer-width on style.width on border-box elems
		 * IE & Firefox<29 measures the inner-width
		 */
		var div = document.createElement('div');
		div.style.width = '200px';
		div.style.padding = '1px 2px 3px 4px';
		div.style.borderStyle = 'solid';
		div.style.borderWidth = '1px 2px 3px 4px';
		div.style.boxSizing = 'border-box';

		var body = document.body || document.documentElement;
		body.appendChild(div);
		var style = getStyle(div);

		getSize.isBoxSizeOuter = isBoxSizeOuter = getStyleSize(style.width) == 200;
		body.removeChild(div);

	}

	// -------------------------- getSize -------------------------- //

	function getSize(elem) {
		setup();

		// use querySeletor if elem is string
		if (typeof elem == 'string') {
			elem = document.querySelector(elem);
		}

		// do not proceed on non-objects
		if (!elem || typeof elem != 'object' || !elem.nodeType) {
			return;
		}

		var style = getStyle(elem);

		// if hidden, everything is 0
		if (style.display == 'none') {
			return getZeroSize();
		}

		var size = {};
		size.width = elem.offsetWidth;
		size.height = elem.offsetHeight;

		var isBorderBox = size.isBorderBox = style.boxSizing == 'border-box';

		// get all measurements
		for (var i = 0; i < measurementsLength; i++) {
			var measurement = measurements[i];
			var value = style[measurement];
			var num = parseFloat(value);
			// any 'auto', 'medium' value will be 0
			size[measurement] = !isNaN(num) ? num : 0;
		}

		var paddingWidth = size.paddingLeft + size.paddingRight;
		var paddingHeight = size.paddingTop + size.paddingBottom;
		var marginWidth = size.marginLeft + size.marginRight;
		var marginHeight = size.marginTop + size.marginBottom;
		var borderWidth = size.borderLeftWidth + size.borderRightWidth;
		var borderHeight = size.borderTopWidth + size.borderBottomWidth;

		var isBorderBoxSizeOuter = isBorderBox && isBoxSizeOuter;

		// overwrite width and height if we can get it from style
		var styleWidth = getStyleSize(style.width);
		if (styleWidth !== false) {
			size.width = styleWidth +
				// add padding and border unless it's already including it
				(isBorderBoxSizeOuter ? 0 : paddingWidth + borderWidth);
		}

		var styleHeight = getStyleSize(style.height);
		if (styleHeight !== false) {
			size.height = styleHeight +
				// add padding and border unless it's already including it
				(isBorderBoxSizeOuter ? 0 : paddingHeight + borderHeight);
		}

		size.innerWidth = size.width - (paddingWidth + borderWidth);
		size.innerHeight = size.height - (paddingHeight + borderHeight);

		size.outerWidth = size.width + marginWidth;
		size.outerHeight = size.height + marginHeight;

		return size;
	}

	return getSize;

});

/**
 * matchesSelector v2.0.2
 * matchesSelector( element, '.selector' )
 * MIT license
 */

/*jshint browser: true, strict: true, undef: true, unused: true */

(function(window, factory) {
	/*global define: false, module: false */
	'use strict';
	// universal module definition
	if (typeof define == 'function' && define.amd) {
		// AMD
		define('desandro-matches-selector/matches-selector', factory);
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS
		module.exports = factory();
	} else {
		// browser global
		window.matchesSelector = factory();
	}

}(window, function factory() {
	'use strict';

	var matchesMethod = (function() {
		var ElemProto = window.Element.prototype;
		// check for the standard method name first
		if (ElemProto.matches) {
			return 'matches';
		}
		// check un-prefixed
		if (ElemProto.matchesSelector) {
			return 'matchesSelector';
		}
		// check vendor prefixes
		var prefixes = ['webkit', 'moz', 'ms', 'o'];

		for (var i = 0; i < prefixes.length; i++) {
			var prefix = prefixes[i];
			var method = prefix + 'MatchesSelector';
			if (ElemProto[method]) {
				return method;
			}
		}
	})();

	return function matchesSelector(elem, selector) {
		return elem[matchesMethod](selector);
	};

}));

/**
 * Fizzy UI utils v2.0.4
 * MIT license
 */

/*jshint browser: true, undef: true, unused: true, strict: true */

(function(window, factory) {
	// universal module definition
	/*jshint strict: false */
	/*globals define, module, require */

	if (typeof define == 'function' && define.amd) {
		// AMD
		define('fizzy-ui-utils/utils', [
			'desandro-matches-selector/matches-selector'
		], function(matchesSelector) {
			return factory(window, matchesSelector);
		});
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS
		module.exports = factory(
			window,
			require('desandro-matches-selector')
		);
	} else {
		// browser global
		window.fizzyUIUtils = factory(
			window,
			window.matchesSelector
		);
	}

}(window, function factory(window, matchesSelector) {



	var utils = {};

	// ----- extend ----- //

	// extends objects
	utils.extend = function(a, b) {
		for (var prop in b) {
			a[prop] = b[prop];
		}
		return a;
	};

	// ----- modulo ----- //

	utils.modulo = function(num, div) {
		return ((num % div) + div) % div;
	};

	// ----- makeArray ----- //

	// turn element or nodeList into an array
	utils.makeArray = function(obj) {
		var ary = [];
		if (Array.isArray(obj)) {
			// use object if already an array
			ary = obj;
		} else if (obj && typeof obj == 'object' &&
			typeof obj.length == 'number') {
			// convert nodeList to array
			for (var i = 0; i < obj.length; i++) {
				ary.push(obj[i]);
			}
		} else {
			// array of single index
			ary.push(obj);
		}
		return ary;
	};

	// ----- removeFrom ----- //

	utils.removeFrom = function(ary, obj) {
		var index = ary.indexOf(obj);
		if (index != -1) {
			ary.splice(index, 1);
		}
	};

	// ----- getParent ----- //

	utils.getParent = function(elem, selector) {
		while (elem != document.body) {
			elem = elem.parentNode;
			if (matchesSelector(elem, selector)) {
				return elem;
			}
		}
	};

	// ----- getQueryElement ----- //

	// use element as selector string
	utils.getQueryElement = function(elem) {
		if (typeof elem == 'string') {
			return document.querySelector(elem);
		}
		return elem;
	};

	// ----- handleEvent ----- //

	// enable .ontype to trigger from .addEventListener( elem, 'type' )
	utils.handleEvent = function(event) {
		var method = 'on' + event.type;
		if (this[method]) {
			this[method](event);
		}
	};

	// ----- filterFindElements ----- //

	utils.filterFindElements = function(elems, selector) {
		// make array of elems
		elems = utils.makeArray(elems);
		var ffElems = [];

		elems.forEach(function(elem) {
			// check that elem is an actual element
			if (!(elem instanceof HTMLElement)) {
				return;
			}
			// add elem if no selector
			if (!selector) {
				ffElems.push(elem);
				return;
			}
			// filter & find items if we have a selector
			// filter
			if (matchesSelector(elem, selector)) {
				ffElems.push(elem);
			}
			// find children
			var childElems = elem.querySelectorAll(selector);
			// concat childElems to filterFound array
			for (var i = 0; i < childElems.length; i++) {
				ffElems.push(childElems[i]);
			}
		});

		return ffElems;
	};

	// ----- debounceMethod ----- //

	utils.debounceMethod = function(_class, methodName, threshold) {
		// original method
		var method = _class.prototype[methodName];
		var timeoutName = methodName + 'Timeout';

		_class.prototype[methodName] = function() {
			var timeout = this[timeoutName];
			if (timeout) {
				clearTimeout(timeout);
			}
			var args = arguments;

			var _this = this;
			this[timeoutName] = setTimeout(function() {
				method.apply(_this, args);
				delete _this[timeoutName];
			}, threshold || 100);
		};
	};

	// ----- docReady ----- //

	utils.docReady = function(callback) {
		var readyState = document.readyState;
		if (readyState == 'complete' || readyState == 'interactive') {
			// do async to allow for other scripts to run. metafizzy/flickity#441
			setTimeout(callback);
		} else {
			document.addEventListener('DOMContentLoaded', callback);
		}
	};

	// ----- htmlInit ----- //

	// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
	utils.toDashed = function(str) {
		return str.replace(/(.)([A-Z])/g, function(match, $1, $2) {
			return $1 + '-' + $2;
		}).toLowerCase();
	};

	var console = window.console;
	/**
	 * allow user to initialize classes via [data-namespace] or .js-namespace class
	 * htmlInit( Widget, 'widgetName' )
	 * options are parsed from data-namespace-options
	 */
	utils.htmlInit = function(WidgetClass, namespace) {
		utils.docReady(function() {
			var dashedNamespace = utils.toDashed(namespace);
			var dataAttr = 'data-' + dashedNamespace;
			var dataAttrElems = document.querySelectorAll('[' + dataAttr + ']');
			var jsDashElems = document.querySelectorAll('.js-' + dashedNamespace);
			var elems = utils.makeArray(dataAttrElems)
				.concat(utils.makeArray(jsDashElems));
			var dataOptionsAttr = dataAttr + '-options';
			var jQuery = window.jQuery;

			elems.forEach(function(elem) {
				var attr = elem.getAttribute(dataAttr) ||
					elem.getAttribute(dataOptionsAttr);
				var options;
				try {
					options = attr && JSON.parse(attr);
				} catch (error) {
					// log error, do not initialize
					if (console) {
						console.error('Error parsing ' + dataAttr + ' on ' + elem.className +
							': ' + error);
					}
					return;
				}
				// initialize
				var instance = new WidgetClass(elem, options);
				// make available via $().data('namespace')
				if (jQuery) {
					jQuery.data(elem, namespace, instance);
				}
			});

		});
	};

	// -----  ----- //

	return utils;

}));

/**
 * Outlayer Item
 */

(function(window, factory) {
	// universal module definition
	/* jshint strict: false */
	/* globals define, module, require */
	if (typeof define == 'function' && define.amd) {
		// AMD - RequireJS
		define('outlayer/item', [
				'ev-emitter/ev-emitter',
				'get-size/get-size'
			],
			factory
		);
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS - Browserify, Webpack
		module.exports = factory(
			require('ev-emitter'),
			require('get-size')
		);
	} else {
		// browser global
		window.Outlayer = {};
		window.Outlayer.Item = factory(
			window.EvEmitter,
			window.getSize
		);
	}

}(window, function factory(EvEmitter, getSize) {
	'use strict';

	// ----- helpers ----- //

	function isEmptyObj(obj) {
		for (var prop in obj) {
			return false;
		}
		prop = null;
		return true;
	}

	// -------------------------- CSS3 support -------------------------- //


	var docElemStyle = document.documentElement.style;

	var transitionProperty = typeof docElemStyle.transition == 'string' ?
		'transition' : 'WebkitTransition';
	var transformProperty = typeof docElemStyle.transform == 'string' ?
		'transform' : 'WebkitTransform';

	var transitionEndEvent = {
		WebkitTransition: 'webkitTransitionEnd',
		transition: 'transitionend'
	}[transitionProperty];

	// cache all vendor properties that could have vendor prefix
	var vendorProperties = {
		transform: transformProperty,
		transition: transitionProperty,
		transitionDuration: transitionProperty + 'Duration',
		transitionProperty: transitionProperty + 'Property',
		transitionDelay: transitionProperty + 'Delay'
	};

	// -------------------------- Item -------------------------- //

	function Item(element, layout) {
		if (!element) {
			return;
		}

		this.element = element;
		// parent layout class, i.e. Masonry, Isotope, or Packery
		this.layout = layout;
		this.position = {
			x: 0,
			y: 0
		};

		this._create();
	}

	// inherit EvEmitter
	var proto = Item.prototype = Object.create(EvEmitter.prototype);
	proto.constructor = Item;

	proto._create = function() {
		// transition objects
		this._transn = {
			ingProperties: {},
			clean: {},
			onEnd: {}
		};

		this.css({
			position: 'absolute'
		});
	};

	// trigger specified handler for event type
	proto.handleEvent = function(event) {
		var method = 'on' + event.type;
		if (this[method]) {
			this[method](event);
		}
	};

	proto.getSize = function() {
		this.size = getSize(this.element);
	};

	/**
	 * apply CSS styles to element
	 * @param {Object} style
	 */
	proto.css = function(style) {
		var elemStyle = this.element.style;

		for (var prop in style) {
			// use vendor property if available
			var supportedProp = vendorProperties[prop] || prop;
			elemStyle[supportedProp] = style[prop];
		}
	};

	// measure position, and sets it
	proto.getPosition = function() {
		var style = getComputedStyle(this.element);
		var isOriginLeft = this.layout._getOption('originLeft');
		var isOriginTop = this.layout._getOption('originTop');
		var xValue = style[isOriginLeft ? 'left' : 'right'];
		var yValue = style[isOriginTop ? 'top' : 'bottom'];
		// convert percent to pixels
		var layoutSize = this.layout.size;
		var x = xValue.indexOf('%') != -1 ?
			(parseFloat(xValue) / 100) * layoutSize.width : parseInt(xValue, 10);
		var y = yValue.indexOf('%') != -1 ?
			(parseFloat(yValue) / 100) * layoutSize.height : parseInt(yValue, 10);

		// clean up 'auto' or other non-integer values
		x = isNaN(x) ? 0 : x;
		y = isNaN(y) ? 0 : y;
		// remove padding from measurement
		x -= isOriginLeft ? layoutSize.paddingLeft : layoutSize.paddingRight;
		y -= isOriginTop ? layoutSize.paddingTop : layoutSize.paddingBottom;

		this.position.x = x;
		this.position.y = y;
	};

	// set settled position, apply padding
	proto.layoutPosition = function() {
		var layoutSize = this.layout.size;
		var style = {};
		var isOriginLeft = this.layout._getOption('originLeft');
		var isOriginTop = this.layout._getOption('originTop');

		// x
		var xPadding = isOriginLeft ? 'paddingLeft' : 'paddingRight';
		var xProperty = isOriginLeft ? 'left' : 'right';
		var xResetProperty = isOriginLeft ? 'right' : 'left';

		var x = this.position.x + layoutSize[xPadding];
		// set in percentage or pixels
		style[xProperty] = this.getXValue(x);
		// reset other property
		style[xResetProperty] = '';

		// y
		var yPadding = isOriginTop ? 'paddingTop' : 'paddingBottom';
		var yProperty = isOriginTop ? 'top' : 'bottom';
		var yResetProperty = isOriginTop ? 'bottom' : 'top';

		var y = this.position.y + layoutSize[yPadding];
		// set in percentage or pixels
		style[yProperty] = this.getYValue(y);
		// reset other property
		style[yResetProperty] = '';

		this.css(style);
		this.emitEvent('layout', [this]);
	};

	proto.getXValue = function(x) {
		var isHorizontal = this.layout._getOption('horizontal');
		return this.layout.options.percentPosition && !isHorizontal ?
			((x / this.layout.size.width) * 100) + '%' : x + 'px';
	};

	proto.getYValue = function(y) {
		var isHorizontal = this.layout._getOption('horizontal');
		return this.layout.options.percentPosition && isHorizontal ?
			((y / this.layout.size.height) * 100) + '%' : y + 'px';
	};

	proto._transitionTo = function(x, y) {
		this.getPosition();
		// get current x & y from top/left
		var curX = this.position.x;
		var curY = this.position.y;

		var compareX = parseInt(x, 10);
		var compareY = parseInt(y, 10);
		var didNotMove = compareX === this.position.x && compareY === this.position.y;

		// save end position
		this.setPosition(x, y);

		// if did not move and not transitioning, just go to layout
		if (didNotMove && !this.isTransitioning) {
			this.layoutPosition();
			return;
		}

		var transX = x - curX;
		var transY = y - curY;
		var transitionStyle = {};
		transitionStyle.transform = this.getTranslate(transX, transY);

		this.transition({
			to: transitionStyle,
			onTransitionEnd: {
				transform: this.layoutPosition
			},
			isCleaning: true
		});
	};

	proto.getTranslate = function(x, y) {
		// flip cooridinates if origin on right or bottom
		var isOriginLeft = this.layout._getOption('originLeft');
		var isOriginTop = this.layout._getOption('originTop');
		x = isOriginLeft ? x : -x;
		y = isOriginTop ? y : -y;
		return 'translate3d(' + x + 'px, ' + y + 'px, 0)';
	};

	// non transition + transform support
	proto.goTo = function(x, y) {
		this.setPosition(x, y);
		this.layoutPosition();
	};

	proto.moveTo = proto._transitionTo;

	proto.setPosition = function(x, y) {
		this.position.x = parseInt(x, 10);
		this.position.y = parseInt(y, 10);
	};

	// ----- transition ----- //

	/**
	 * @param {Object} style - CSS
	 * @param {Function} onTransitionEnd
	 */

	// non transition, just trigger callback
	proto._nonTransition = function(args) {
		this.css(args.to);
		if (args.isCleaning) {
			this._removeStyles(args.to);
		}
		for (var prop in args.onTransitionEnd) {
			args.onTransitionEnd[prop].call(this);
		}
	};

	/**
	 * proper transition
	 * @param {Object} args - arguments
	 *   @param {Object} to - style to transition to
	 *   @param {Object} from - style to start transition from
	 *   @param {Boolean} isCleaning - removes transition styles after transition
	 *   @param {Function} onTransitionEnd - callback
	 */
	proto.transition = function(args) {
		// redirect to nonTransition if no transition duration
		if (!parseFloat(this.layout.options.transitionDuration)) {
			this._nonTransition(args);
			return;
		}

		var _transition = this._transn;
		// keep track of onTransitionEnd callback by css property
		for (var prop in args.onTransitionEnd) {
			_transition.onEnd[prop] = args.onTransitionEnd[prop];
		}
		// keep track of properties that are transitioning
		for (prop in args.to) {
			_transition.ingProperties[prop] = true;
			// keep track of properties to clean up when transition is done
			if (args.isCleaning) {
				_transition.clean[prop] = true;
			}
		}

		// set from styles
		if (args.from) {
			this.css(args.from);
			// force redraw. http://blog.alexmaccaw.com/css-transitions
			var h = this.element.offsetHeight;
			// hack for JSHint to hush about unused var
			h = null;
		}
		// enable transition
		this.enableTransition(args.to);
		// set styles that are transitioning
		this.css(args.to);

		this.isTransitioning = true;

	};

	// dash before all cap letters, including first for
	// WebkitTransform => -webkit-transform
	function toDashedAll(str) {
		return str.replace(/([A-Z])/g, function($1) {
			return '-' + $1.toLowerCase();
		});
	}

	var transitionProps = 'opacity,' + toDashedAll(transformProperty);

	proto.enableTransition = function( /* style */ ) {
		// HACK changing transitionProperty during a transition
		// will cause transition to jump
		if (this.isTransitioning) {
			return;
		}

		// make `transition: foo, bar, baz` from style object
		// HACK un-comment this when enableTransition can work
		// while a transition is happening
		// var transitionValues = [];
		// for ( var prop in style ) {
		//   // dash-ify camelCased properties like WebkitTransition
		//   prop = vendorProperties[ prop ] || prop;
		//   transitionValues.push( toDashedAll( prop ) );
		// }
		// munge number to millisecond, to match stagger
		var duration = this.layout.options.transitionDuration;
		duration = typeof duration == 'number' ? duration + 'ms' : duration;
		// enable transition styles
		this.css({
			transitionProperty: transitionProps,
			transitionDuration: duration,
			transitionDelay: this.staggerDelay || 0
		});
		// listen for transition end event
		this.element.addEventListener(transitionEndEvent, this, false);
	};

	// ----- events ----- //

	proto.onwebkitTransitionEnd = function(event) {
		this.ontransitionend(event);
	};

	proto.onotransitionend = function(event) {
		this.ontransitionend(event);
	};

	// properties that I munge to make my life easier
	var dashedVendorProperties = {
		'-webkit-transform': 'transform'
	};

	proto.ontransitionend = function(event) {
		// disregard bubbled events from children
		if (event.target !== this.element) {
			return;
		}
		var _transition = this._transn;
		// get property name of transitioned property, convert to prefix-free
		var propertyName = dashedVendorProperties[event.propertyName] || event.propertyName;

		// remove property that has completed transitioning
		delete _transition.ingProperties[propertyName];
		// check if any properties are still transitioning
		if (isEmptyObj(_transition.ingProperties)) {
			// all properties have completed transitioning
			this.disableTransition();
		}
		// clean style
		if (propertyName in _transition.clean) {
			// clean up style
			this.element.style[event.propertyName] = '';
			delete _transition.clean[propertyName];
		}
		// trigger onTransitionEnd callback
		if (propertyName in _transition.onEnd) {
			var onTransitionEnd = _transition.onEnd[propertyName];
			onTransitionEnd.call(this);
			delete _transition.onEnd[propertyName];
		}

		this.emitEvent('transitionEnd', [this]);
	};

	proto.disableTransition = function() {
		this.removeTransitionStyles();
		this.element.removeEventListener(transitionEndEvent, this, false);
		this.isTransitioning = false;
	};

	/**
	 * removes style property from element
	 * @param {Object} style
	 **/
	proto._removeStyles = function(style) {
		// clean up transition styles
		var cleanStyle = {};
		for (var prop in style) {
			cleanStyle[prop] = '';
		}
		this.css(cleanStyle);
	};

	var cleanTransitionStyle = {
		transitionProperty: '',
		transitionDuration: '',
		transitionDelay: ''
	};

	proto.removeTransitionStyles = function() {
		// remove transition
		this.css(cleanTransitionStyle);
	};

	// ----- stagger ----- //

	proto.stagger = function(delay) {
		delay = isNaN(delay) ? 0 : delay;
		this.staggerDelay = delay + 'ms';
	};

	// ----- show/hide/remove ----- //

	// remove element from DOM
	proto.removeElem = function() {
		this.element.parentNode.removeChild(this.element);
		// remove display: none
		this.css({
			display: ''
		});
		this.emitEvent('remove', [this]);
	};

	proto.remove = function() {
		// just remove element if no transition support or no transition
		if (!transitionProperty || !parseFloat(this.layout.options.transitionDuration)) {
			this.removeElem();
			return;
		}

		// start transition
		this.once('transitionEnd', function() {
			this.removeElem();
		});
		this.hide();
	};

	proto.reveal = function() {
		delete this.isHidden;
		// remove display: none
		this.css({
			display: ''
		});

		var options = this.layout.options;

		var onTransitionEnd = {};
		var transitionEndProperty = this.getHideRevealTransitionEndProperty('visibleStyle');
		onTransitionEnd[transitionEndProperty] = this.onRevealTransitionEnd;

		this.transition({
			from: options.hiddenStyle,
			to: options.visibleStyle,
			isCleaning: true,
			onTransitionEnd: onTransitionEnd
		});
	};

	proto.onRevealTransitionEnd = function() {
		// check if still visible
		// during transition, item may have been hidden
		if (!this.isHidden) {
			this.emitEvent('reveal');
		}
	};

	/**
	 * get style property use for hide/reveal transition end
	 * @param {String} styleProperty - hiddenStyle/visibleStyle
	 * @returns {String}
	 */
	proto.getHideRevealTransitionEndProperty = function(styleProperty) {
		var optionStyle = this.layout.options[styleProperty];
		// use opacity
		if (optionStyle.opacity) {
			return 'opacity';
		}
		// get first property
		for (var prop in optionStyle) {
			return prop;
		}
	};

	proto.hide = function() {
		// set flag
		this.isHidden = true;
		// remove display: none
		this.css({
			display: ''
		});

		var options = this.layout.options;

		var onTransitionEnd = {};
		var transitionEndProperty = this.getHideRevealTransitionEndProperty('hiddenStyle');
		onTransitionEnd[transitionEndProperty] = this.onHideTransitionEnd;

		this.transition({
			from: options.visibleStyle,
			to: options.hiddenStyle,
			// keep hidden stuff hidden
			isCleaning: true,
			onTransitionEnd: onTransitionEnd
		});
	};

	proto.onHideTransitionEnd = function() {
		// check if still hidden
		// during transition, item may have been un-hidden
		if (this.isHidden) {
			this.css({
				display: 'none'
			});
			this.emitEvent('hide');
		}
	};

	proto.destroy = function() {
		this.css({
			position: '',
			left: '',
			right: '',
			top: '',
			bottom: '',
			transition: '',
			transform: ''
		});
	};

	return Item;

}));

/*!
 * Outlayer v2.1.0
 * the brains and guts of a layout library
 * MIT license
 */

(function(window, factory) {
	'use strict';
	// universal module definition
	/* jshint strict: false */
	/* globals define, module, require */
	if (typeof define == 'function' && define.amd) {
		// AMD - RequireJS
		define('outlayer/outlayer', [
				'ev-emitter/ev-emitter',
				'get-size/get-size',
				'fizzy-ui-utils/utils',
				'./item'
			],
			function(EvEmitter, getSize, utils, Item) {
				return factory(window, EvEmitter, getSize, utils, Item);
			}
		);
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS - Browserify, Webpack
		module.exports = factory(
			window,
			require('ev-emitter'),
			require('get-size'),
			require('fizzy-ui-utils'),
			require('./item')
		);
	} else {
		// browser global
		window.Outlayer = factory(
			window,
			window.EvEmitter,
			window.getSize,
			window.fizzyUIUtils,
			window.Outlayer.Item
		);
	}

}(window, function factory(window, EvEmitter, getSize, utils, Item) {
	'use strict';

	// ----- vars ----- //

	var console = window.console;
	var jQuery = window.jQuery;
	var noop = function() {};

	// -------------------------- Outlayer -------------------------- //

	// globally unique identifiers
	var GUID = 0;
	// internal store of all Outlayer intances
	var instances = {};


	/**
	 * @param {Element, String} element
	 * @param {Object} options
	 * @constructor
	 */
	function Outlayer(element, options) {
		var queryElement = utils.getQueryElement(element);
		if (!queryElement) {
			if (console) {
				console.error('Bad element for ' + this.constructor.namespace +
					': ' + (queryElement || element));
			}
			return;
		}
		this.element = queryElement;
		// add jQuery
		if (jQuery) {
			this.$element = jQuery(this.element);
		}

		// options
		this.options = utils.extend({}, this.constructor.defaults);
		this.option(options);

		// add id for Outlayer.getFromElement
		var id = ++GUID;
		this.element.outlayerGUID = id; // expando
		instances[id] = this; // associate via id

		// kick it off
		this._create();

		var isInitLayout = this._getOption('initLayout');
		if (isInitLayout) {
			this.layout();
		}
	}

	// settings are for internal use only
	Outlayer.namespace = 'outlayer';
	Outlayer.Item = Item;

	// default options
	Outlayer.defaults = {
		containerStyle: {
			position: 'relative'
		},
		initLayout: true,
		originLeft: true,
		originTop: true,
		resize: true,
		resizeContainer: true,
		// item options
		transitionDuration: '0.4s',
		hiddenStyle: {
			opacity: 0,
			transform: 'scale(0.001)'
		},
		visibleStyle: {
			opacity: 1,
			transform: 'scale(1)'
		}
	};

	var proto = Outlayer.prototype;
	// inherit EvEmitter
	utils.extend(proto, EvEmitter.prototype);

	/**
	 * set options
	 * @param {Object} opts
	 */
	proto.option = function(opts) {
		utils.extend(this.options, opts);
	};

	/**
	 * get backwards compatible option value, check old name
	 */
	proto._getOption = function(option) {
		var oldOption = this.constructor.compatOptions[option];
		return oldOption && this.options[oldOption] !== undefined ?
			this.options[oldOption] : this.options[option];
	};

	Outlayer.compatOptions = {
		// currentName: oldName
		initLayout: 'isInitLayout',
		horizontal: 'isHorizontal',
		layoutInstant: 'isLayoutInstant',
		originLeft: 'isOriginLeft',
		originTop: 'isOriginTop',
		resize: 'isResizeBound',
		resizeContainer: 'isResizingContainer'
	};

	proto._create = function() {
		// get items from children
		this.reloadItems();
		// elements that affect layout, but are not laid out
		this.stamps = [];
		this.stamp(this.options.stamp);
		// set container style
		utils.extend(this.element.style, this.options.containerStyle);

		// bind resize method
		var canBindResize = this._getOption('resize');
		if (canBindResize) {
			this.bindResize();
		}
	};

	// goes through all children again and gets bricks in proper order
	proto.reloadItems = function() {
		// collection of item elements
		this.items = this._itemize(this.element.children);
	};


	/**
	 * turn elements into Outlayer.Items to be used in layout
	 * @param {Array or NodeList or HTMLElement} elems
	 * @returns {Array} items - collection of new Outlayer Items
	 */
	proto._itemize = function(elems) {

		var itemElems = this._filterFindItemElements(elems);
		var Item = this.constructor.Item;

		// create new Outlayer Items for collection
		var items = [];
		for (var i = 0; i < itemElems.length; i++) {
			var elem = itemElems[i];
			var item = new Item(elem, this);
			items.push(item);
		}

		return items;
	};

	/**
	 * get item elements to be used in layout
	 * @param {Array or NodeList or HTMLElement} elems
	 * @returns {Array} items - item elements
	 */
	proto._filterFindItemElements = function(elems) {
		return utils.filterFindElements(elems, this.options.itemSelector);
	};

	/**
	 * getter method for getting item elements
	 * @returns {Array} elems - collection of item elements
	 */
	proto.getItemElements = function() {
		return this.items.map(function(item) {
			return item.element;
		});
	};

	// ----- init & layout ----- //

	/**
	 * lays out all items
	 */
	proto.layout = function() {
		this._resetLayout();
		this._manageStamps();

		// don't animate first layout
		var layoutInstant = this._getOption('layoutInstant');
		var isInstant = layoutInstant !== undefined ?
			layoutInstant : !this._isLayoutInited;
		this.layoutItems(this.items, isInstant);

		// flag for initalized
		this._isLayoutInited = true;
	};

	// _init is alias for layout
	proto._init = proto.layout;

	/**
	 * logic before any new layout
	 */
	proto._resetLayout = function() {
		this.getSize();
	};


	proto.getSize = function() {
		this.size = getSize(this.element);
	};

	/**
	 * get measurement from option, for columnWidth, rowHeight, gutter
	 * if option is String -> get element from selector string, & get size of element
	 * if option is Element -> get size of element
	 * else use option as a number
	 *
	 * @param {String} measurement
	 * @param {String} size - width or height
	 * @private
	 */
	proto._getMeasurement = function(measurement, size) {
		var option = this.options[measurement];
		var elem;
		if (!option) {
			// default to 0
			this[measurement] = 0;
		} else {
			// use option as an element
			if (typeof option == 'string') {
				elem = this.element.querySelector(option);
			} else if (option instanceof HTMLElement) {
				elem = option;
			}
			// use size of element, if element
			this[measurement] = elem ? getSize(elem)[size] : option;
		}
	};

	/**
	 * layout a collection of item elements
	 * @api public
	 */
	proto.layoutItems = function(items, isInstant) {
		items = this._getItemsForLayout(items);

		this._layoutItems(items, isInstant);

		this._postLayout();
	};

	/**
	 * get the items to be laid out
	 * you may want to skip over some items
	 * @param {Array} items
	 * @returns {Array} items
	 */
	proto._getItemsForLayout = function(items) {
		return items.filter(function(item) {
			return !item.isIgnored;
		});
	};

	/**
	 * layout items
	 * @param {Array} items
	 * @param {Boolean} isInstant
	 */
	proto._layoutItems = function(items, isInstant) {
		this._emitCompleteOnItems('layout', items);

		if (!items || !items.length) {
			// no items, emit event with empty array
			return;
		}

		var queue = [];

		items.forEach(function(item) {
			// get x/y object from method
			var position = this._getItemLayoutPosition(item);
			// enqueue
			position.item = item;
			position.isInstant = isInstant || item.isLayoutInstant;
			queue.push(position);
		}, this);

		this._processLayoutQueue(queue);
	};

	/**
	 * get item layout position
	 * @param {Outlayer.Item} item
	 * @returns {Object} x and y position
	 */
	proto._getItemLayoutPosition = function( /* item */ ) {
		return {
			x: 0,
			y: 0
		};
	};

	/**
	 * iterate over array and position each item
	 * Reason being - separating this logic prevents 'layout invalidation'
	 * thx @paul_irish
	 * @param {Array} queue
	 */
	proto._processLayoutQueue = function(queue) {
		this.updateStagger();
		queue.forEach(function(obj, i) {
			this._positionItem(obj.item, obj.x, obj.y, obj.isInstant, i);
		}, this);
	};

	// set stagger from option in milliseconds number
	proto.updateStagger = function() {
		var stagger = this.options.stagger;
		if (stagger === null || stagger === undefined) {
			this.stagger = 0;
			return;
		}
		this.stagger = getMilliseconds(stagger);
		return this.stagger;
	};

	/**
	 * Sets position of item in DOM
	 * @param {Outlayer.Item} item
	 * @param {Number} x - horizontal position
	 * @param {Number} y - vertical position
	 * @param {Boolean} isInstant - disables transitions
	 */
	proto._positionItem = function(item, x, y, isInstant, i) {
		if (isInstant) {
			// if not transition, just set CSS
			item.goTo(x, y);
		} else {
			item.stagger(i * this.stagger);
			item.moveTo(x, y);
		}
	};

	/**
	 * Any logic you want to do after each layout,
	 * i.e. size the container
	 */
	proto._postLayout = function() {
		this.resizeContainer();
	};

	proto.resizeContainer = function() {
		var isResizingContainer = this._getOption('resizeContainer');
		if (!isResizingContainer) {
			return;
		}
		var size = this._getContainerSize();
		if (size) {
			this._setContainerMeasure(size.width, true);
			this._setContainerMeasure(size.height, false);
		}
	};

	/**
	 * Sets width or height of container if returned
	 * @returns {Object} size
	 *   @param {Number} width
	 *   @param {Number} height
	 */
	proto._getContainerSize = noop;

	/**
	 * @param {Number} measure - size of width or height
	 * @param {Boolean} isWidth
	 */
	proto._setContainerMeasure = function(measure, isWidth) {
		if (measure === undefined) {
			return;
		}

		var elemSize = this.size;
		// add padding and border width if border box
		if (elemSize.isBorderBox) {
			measure += isWidth ? elemSize.paddingLeft + elemSize.paddingRight +
				elemSize.borderLeftWidth + elemSize.borderRightWidth :
				elemSize.paddingBottom + elemSize.paddingTop +
				elemSize.borderTopWidth + elemSize.borderBottomWidth;
		}

		measure = Math.max(measure, 0);
		this.element.style[isWidth ? 'width' : 'height'] = measure + 'px';
	};

	/**
	 * emit eventComplete on a collection of items events
	 * @param {String} eventName
	 * @param {Array} items - Outlayer.Items
	 */
	proto._emitCompleteOnItems = function(eventName, items) {
		var _this = this;

		function onComplete() {
			_this.dispatchEvent(eventName + 'Complete', null, [items]);
		}

		var count = items.length;
		if (!items || !count) {
			onComplete();
			return;
		}

		var doneCount = 0;

		function tick() {
			doneCount++;
			if (doneCount == count) {
				onComplete();
			}
		}

		// bind callback
		items.forEach(function(item) {
			item.once(eventName, tick);
		});
	};

	/**
	 * emits events via EvEmitter and jQuery events
	 * @param {String} type - name of event
	 * @param {Event} event - original event
	 * @param {Array} args - extra arguments
	 */
	proto.dispatchEvent = function(type, event, args) {
		// add original event to arguments
		var emitArgs = event ? [event].concat(args) : args;
		this.emitEvent(type, emitArgs);

		if (jQuery) {
			// set this.$element
			this.$element = this.$element || jQuery(this.element);
			if (event) {
				// create jQuery event
				var $event = jQuery.Event(event);
				$event.type = type;
				this.$element.trigger($event, args);
			} else {
				// just trigger with type if no event available
				this.$element.trigger(type, args);
			}
		}
	};

	// -------------------------- ignore & stamps -------------------------- //


	/**
	 * keep item in collection, but do not lay it out
	 * ignored items do not get skipped in layout
	 * @param {Element} elem
	 */
	proto.ignore = function(elem) {
		var item = this.getItem(elem);
		if (item) {
			item.isIgnored = true;
		}
	};

	/**
	 * return item to layout collection
	 * @param {Element} elem
	 */
	proto.unignore = function(elem) {
		var item = this.getItem(elem);
		if (item) {
			delete item.isIgnored;
		}
	};

	/**
	 * adds elements to stamps
	 * @param {NodeList, Array, Element, or String} elems
	 */
	proto.stamp = function(elems) {
		elems = this._find(elems);
		if (!elems) {
			return;
		}

		this.stamps = this.stamps.concat(elems);
		// ignore
		elems.forEach(this.ignore, this);
	};

	/**
	 * removes elements to stamps
	 * @param {NodeList, Array, or Element} elems
	 */
	proto.unstamp = function(elems) {
		elems = this._find(elems);
		if (!elems) {
			return;
		}

		elems.forEach(function(elem) {
			// filter out removed stamp elements
			utils.removeFrom(this.stamps, elem);
			this.unignore(elem);
		}, this);
	};

	/**
	 * finds child elements
	 * @param {NodeList, Array, Element, or String} elems
	 * @returns {Array} elems
	 */
	proto._find = function(elems) {
		if (!elems) {
			return;
		}
		// if string, use argument as selector string
		if (typeof elems == 'string') {
			elems = this.element.querySelectorAll(elems);
		}
		elems = utils.makeArray(elems);
		return elems;
	};

	proto._manageStamps = function() {
		if (!this.stamps || !this.stamps.length) {
			return;
		}

		this._getBoundingRect();

		this.stamps.forEach(this._manageStamp, this);
	};

	// update boundingLeft / Top
	proto._getBoundingRect = function() {
		// get bounding rect for container element
		var boundingRect = this.element.getBoundingClientRect();
		var size = this.size;
		this._boundingRect = {
			left: boundingRect.left + size.paddingLeft + size.borderLeftWidth,
			top: boundingRect.top + size.paddingTop + size.borderTopWidth,
			right: boundingRect.right - (size.paddingRight + size.borderRightWidth),
			bottom: boundingRect.bottom - (size.paddingBottom + size.borderBottomWidth)
		};
	};

	/**
	 * @param {Element} stamp
	 **/
	proto._manageStamp = noop;

	/**
	 * get x/y position of element relative to container element
	 * @param {Element} elem
	 * @returns {Object} offset - has left, top, right, bottom
	 */
	proto._getElementOffset = function(elem) {
		var boundingRect = elem.getBoundingClientRect();
		var thisRect = this._boundingRect;
		var size = getSize(elem);
		var offset = {
			left: boundingRect.left - thisRect.left - size.marginLeft,
			top: boundingRect.top - thisRect.top - size.marginTop,
			right: thisRect.right - boundingRect.right - size.marginRight,
			bottom: thisRect.bottom - boundingRect.bottom - size.marginBottom
		};
		return offset;
	};

	// -------------------------- resize -------------------------- //

	// enable event handlers for listeners
	// i.e. resize -> onresize
	proto.handleEvent = utils.handleEvent;

	/**
	 * Bind layout to window resizing
	 */
	proto.bindResize = function() {
		window.addEventListener('resize', this);
		this.isResizeBound = true;
	};

	/**
	 * Unbind layout to window resizing
	 */
	proto.unbindResize = function() {
		window.removeEventListener('resize', this);
		this.isResizeBound = false;
	};

	proto.onresize = function() {
		this.resize();
	};

	utils.debounceMethod(Outlayer, 'onresize', 100);

	proto.resize = function() {
		// don't trigger if size did not change
		// or if resize was unbound. See #9
		if (!this.isResizeBound || !this.needsResizeLayout()) {
			return;
		}

		this.layout();
	};

	/**
	 * check if layout is needed post layout
	 * @returns Boolean
	 */
	proto.needsResizeLayout = function() {
		var size = getSize(this.element);
		// check that this.size and size are there
		// IE8 triggers resize on body size change, so they might not be
		var hasSizes = this.size && size;
		return hasSizes && size.innerWidth !== this.size.innerWidth;
	};

	// -------------------------- methods -------------------------- //

	/**
	 * add items to Outlayer instance
	 * @param {Array or NodeList or Element} elems
	 * @returns {Array} items - Outlayer.Items
	 **/
	proto.addItems = function(elems) {
		var items = this._itemize(elems);
		// add items to collection
		if (items.length) {
			this.items = this.items.concat(items);
		}
		return items;
	};

	/**
	 * Layout newly-appended item elements
	 * @param {Array or NodeList or Element} elems
	 */
	proto.appended = function(elems) {
		var items = this.addItems(elems);
		if (!items.length) {
			return;
		}
		// layout and reveal just the new items
		this.layoutItems(items, true);
		this.reveal(items);
	};

	/**
	 * Layout prepended elements
	 * @param {Array or NodeList or Element} elems
	 */
	proto.prepended = function(elems) {
		var items = this._itemize(elems);
		if (!items.length) {
			return;
		}
		// add items to beginning of collection
		var previousItems = this.items.slice(0);
		this.items = items.concat(previousItems);
		// start new layout
		this._resetLayout();
		this._manageStamps();
		// layout new stuff without transition
		this.layoutItems(items, true);
		this.reveal(items);
		// layout previous items
		this.layoutItems(previousItems);
	};

	/**
	 * reveal a collection of items
	 * @param {Array of Outlayer.Items} items
	 */
	proto.reveal = function(items) {
		this._emitCompleteOnItems('reveal', items);
		if (!items || !items.length) {
			return;
		}
		var stagger = this.updateStagger();
		items.forEach(function(item, i) {
			item.stagger(i * stagger);
			item.reveal();
		});
	};

	/**
	 * hide a collection of items
	 * @param {Array of Outlayer.Items} items
	 */
	proto.hide = function(items) {
		this._emitCompleteOnItems('hide', items);
		if (!items || !items.length) {
			return;
		}
		var stagger = this.updateStagger();
		items.forEach(function(item, i) {
			item.stagger(i * stagger);
			item.hide();
		});
	};

	/**
	 * reveal item elements
	 * @param {Array}, {Element}, {NodeList} items
	 */
	proto.revealItemElements = function(elems) {
		var items = this.getItems(elems);
		this.reveal(items);
	};

	/**
	 * hide item elements
	 * @param {Array}, {Element}, {NodeList} items
	 */
	proto.hideItemElements = function(elems) {
		var items = this.getItems(elems);
		this.hide(items);
	};

	/**
	 * get Outlayer.Item, given an Element
	 * @param {Element} elem
	 * @param {Function} callback
	 * @returns {Outlayer.Item} item
	 */
	proto.getItem = function(elem) {
		// loop through items to get the one that matches
		for (var i = 0; i < this.items.length; i++) {
			var item = this.items[i];
			if (item.element == elem) {
				// return item
				return item;
			}
		}
	};

	/**
	 * get collection of Outlayer.Items, given Elements
	 * @param {Array} elems
	 * @returns {Array} items - Outlayer.Items
	 */
	proto.getItems = function(elems) {
		elems = utils.makeArray(elems);
		var items = [];
		elems.forEach(function(elem) {
			var item = this.getItem(elem);
			if (item) {
				items.push(item);
			}
		}, this);

		return items;
	};

	/**
	 * remove element(s) from instance and DOM
	 * @param {Array or NodeList or Element} elems
	 */
	proto.remove = function(elems) {
		var removeItems = this.getItems(elems);

		this._emitCompleteOnItems('remove', removeItems);

		// bail if no items to remove
		if (!removeItems || !removeItems.length) {
			return;
		}

		removeItems.forEach(function(item) {
			item.remove();
			// remove item from collection
			utils.removeFrom(this.items, item);
		}, this);
	};

	// ----- destroy ----- //

	// remove and disable Outlayer instance
	proto.destroy = function() {
		// clean up dynamic styles
		var style = this.element.style;
		style.height = '';
		style.position = '';
		style.width = '';
		// destroy items
		this.items.forEach(function(item) {
			item.destroy();
		});

		this.unbindResize();

		var id = this.element.outlayerGUID;
		delete instances[id]; // remove reference to instance by id
		delete this.element.outlayerGUID;
		// remove data for jQuery
		if (jQuery) {
			jQuery.removeData(this.element, this.constructor.namespace);
		}

	};

	// -------------------------- data -------------------------- //

	/**
	 * get Outlayer instance from element
	 * @param {Element} elem
	 * @returns {Outlayer}
	 */
	Outlayer.data = function(elem) {
		elem = utils.getQueryElement(elem);
		var id = elem && elem.outlayerGUID;
		return id && instances[id];
	};


	// -------------------------- create Outlayer class -------------------------- //

	/**
	 * create a layout class
	 * @param {String} namespace
	 */
	Outlayer.create = function(namespace, options) {
		// sub-class Outlayer
		var Layout = subclass(Outlayer);
		// apply new options and compatOptions
		Layout.defaults = utils.extend({}, Outlayer.defaults);
		utils.extend(Layout.defaults, options);
		Layout.compatOptions = utils.extend({}, Outlayer.compatOptions);

		Layout.namespace = namespace;

		Layout.data = Outlayer.data;

		// sub-class Item
		Layout.Item = subclass(Item);

		// -------------------------- declarative -------------------------- //

		utils.htmlInit(Layout, namespace);

		// -------------------------- jQuery bridge -------------------------- //

		// make into jQuery plugin
		if (jQuery && jQuery.bridget) {
			jQuery.bridget(namespace, Layout);
		}

		return Layout;
	};

	function subclass(Parent) {
		function SubClass() {
			Parent.apply(this, arguments);
		}

		SubClass.prototype = Object.create(Parent.prototype);
		SubClass.prototype.constructor = SubClass;

		return SubClass;
	}

	// ----- helpers ----- //

	// how many milliseconds are in each unit
	var msUnits = {
		ms: 1,
		s: 1000
	};

	// munge time-like parameter into millisecond number
	// '0.4s' -> 40
	function getMilliseconds(time) {
		if (typeof time == 'number') {
			return time;
		}
		var matches = time.match(/(^\d*\.?\d*)(\w*)/);
		var num = matches && matches[1];
		var unit = matches && matches[2];
		if (!num.length) {
			return 0;
		}
		num = parseFloat(num);
		var mult = msUnits[unit] || 1;
		return num * mult;
	}

	// ----- fin ----- //

	// back in global
	Outlayer.Item = Item;

	return Outlayer;

}));

/*!
 * Masonry v4.2.0
 * Cascading grid layout library
 * http://masonry.desandro.com
 * MIT License
 * by David DeSandro
 */

(function(window, factory) {
	// universal module definition
	/* jshint strict: false */
	/*globals define, module, require */
	if (typeof define == 'function' && define.amd) {
		// AMD
		define([
				'outlayer/outlayer',
				'get-size/get-size'
			],
			factory);
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS
		module.exports = factory(
			require('outlayer'),
			require('get-size')
		);
	} else {
		// browser global
		window.Masonry = factory(
			window.Outlayer,
			window.getSize
		);
	}

}(window, function factory(Outlayer, getSize) {



	// -------------------------- masonryDefinition -------------------------- //

	// create an Outlayer layout class
	var Masonry = Outlayer.create('masonry');
	// isFitWidth -> fitWidth
	Masonry.compatOptions.fitWidth = 'isFitWidth';

	var proto = Masonry.prototype;

	proto._resetLayout = function() {
		this.getSize();
		this._getMeasurement('columnWidth', 'outerWidth');
		this._getMeasurement('gutter', 'outerWidth');
		this.measureColumns();

		// reset column Y
		this.colYs = [];
		for (var i = 0; i < this.cols; i++) {
			this.colYs.push(0);
		}

		this.maxY = 0;
		this.horizontalColIndex = 0;
	};

	proto.measureColumns = function() {
		this.getContainerWidth();
		// if columnWidth is 0, default to outerWidth of first item
		if (!this.columnWidth) {
			var firstItem = this.items[0];
			var firstItemElem = firstItem && firstItem.element;
			// columnWidth fall back to item of first element
			this.columnWidth = firstItemElem && getSize(firstItemElem).outerWidth ||
				// if first elem has no width, default to size of container
				this.containerWidth;
		}

		var columnWidth = this.columnWidth += this.gutter;

		// calculate columns
		var containerWidth = this.containerWidth + this.gutter;
		var cols = containerWidth / columnWidth;
		// fix rounding errors, typically with gutters
		var excess = columnWidth - containerWidth % columnWidth;
		// if overshoot is less than a pixel, round up, otherwise floor it
		var mathMethod = excess && excess < 1 ? 'round' : 'floor';
		cols = Math[mathMethod](cols);
		this.cols = Math.max(cols, 1);
	};

	proto.getContainerWidth = function() {
		// container is parent if fit width
		var isFitWidth = this._getOption('fitWidth');
		var container = isFitWidth ? this.element.parentNode : this.element;
		// check that this.size and size are there
		// IE8 triggers resize on body size change, so they might not be
		var size = getSize(container);
		this.containerWidth = size && size.innerWidth;
	};

	proto._getItemLayoutPosition = function(item) {
		item.getSize();
		// how many columns does this brick span
		var remainder = item.size.outerWidth % this.columnWidth;
		var mathMethod = remainder && remainder < 1 ? 'round' : 'ceil';
		// round if off by 1 pixel, otherwise use ceil
		var colSpan = Math[mathMethod](item.size.outerWidth / this.columnWidth);
		colSpan = Math.min(colSpan, this.cols);
		// use horizontal or top column position
		var colPosMethod = this.options.horizontalOrder ?
			'_getHorizontalColPosition' : '_getTopColPosition';
		var colPosition = this[colPosMethod](colSpan, item);
		// position the brick
		var position = {
			x: this.columnWidth * colPosition.col,
			y: colPosition.y
		};
		// apply setHeight to necessary columns
		var setHeight = colPosition.y + item.size.outerHeight;
		var setMax = colSpan + colPosition.col;
		for (var i = colPosition.col; i < setMax; i++) {
			this.colYs[i] = setHeight;
		}

		return position;
	};

	proto._getTopColPosition = function(colSpan) {
		var colGroup = this._getTopColGroup(colSpan);
		// get the minimum Y value from the columns
		var minimumY = Math.min.apply(Math, colGroup);

		return {
			col: colGroup.indexOf(minimumY),
			y: minimumY,
		};
	};

	/**
	 * @param {Number} colSpan - number of columns the element spans
	 * @returns {Array} colGroup
	 */
	proto._getTopColGroup = function(colSpan) {
		if (colSpan < 2) {
			// if brick spans only one column, use all the column Ys
			return this.colYs;
		}

		var colGroup = [];
		// how many different places could this brick fit horizontally
		var groupCount = this.cols + 1 - colSpan;
		// for each group potential horizontal position
		for (var i = 0; i < groupCount; i++) {
			colGroup[i] = this._getColGroupY(i, colSpan);
		}
		return colGroup;
	};

	proto._getColGroupY = function(col, colSpan) {
		if (colSpan < 2) {
			return this.colYs[col];
		}
		// make an array of colY values for that one group
		var groupColYs = this.colYs.slice(col, col + colSpan);
		// and get the max value of the array
		return Math.max.apply(Math, groupColYs);
	};

	// get column position based on horizontal index. #873
	proto._getHorizontalColPosition = function(colSpan, item) {
		var col = this.horizontalColIndex % this.cols;
		var isOver = colSpan > 1 && col + colSpan > this.cols;
		// shift to next row if item can't fit on current row
		col = isOver ? 0 : col;
		// don't let zero-size items take up space
		var hasSize = item.size.outerWidth && item.size.outerHeight;
		this.horizontalColIndex = hasSize ? col + colSpan : this.horizontalColIndex;

		return {
			col: col,
			y: this._getColGroupY(col, colSpan),
		};
	};

	proto._manageStamp = function(stamp) {
		var stampSize = getSize(stamp);
		var offset = this._getElementOffset(stamp);
		// get the columns that this stamp affects
		var isOriginLeft = this._getOption('originLeft');
		var firstX = isOriginLeft ? offset.left : offset.right;
		var lastX = firstX + stampSize.outerWidth;
		var firstCol = Math.floor(firstX / this.columnWidth);
		firstCol = Math.max(0, firstCol);
		var lastCol = Math.floor(lastX / this.columnWidth);
		// lastCol should not go over if multiple of columnWidth #425
		lastCol -= lastX % this.columnWidth ? 0 : 1;
		lastCol = Math.min(this.cols - 1, lastCol);
		// set colYs to bottom of the stamp

		var isOriginTop = this._getOption('originTop');
		var stampMaxY = (isOriginTop ? offset.top : offset.bottom) +
			stampSize.outerHeight;
		for (var i = firstCol; i <= lastCol; i++) {
			this.colYs[i] = Math.max(stampMaxY, this.colYs[i]);
		}
	};

	proto._getContainerSize = function() {
		this.maxY = Math.max.apply(Math, this.colYs);
		var size = {
			height: this.maxY
		};

		if (this._getOption('fitWidth')) {
			size.width = this._getContainerFitWidth();
		}

		return size;
	};

	proto._getContainerFitWidth = function() {
		var unusedCols = 0;
		// count unused columns
		var i = this.cols;
		while (--i) {
			if (this.colYs[i] !== 0) {
				break;
			}
			unusedCols++;
		}
		// fit container to columns that have been used
		return (this.cols - unusedCols) * this.columnWidth - this.gutter;
	};

	proto.needsResizeLayout = function() {
		var previousWidth = this.containerWidth;
		this.getContainerWidth();
		return previousWidth != this.containerWidth;
	};

	return Masonry;

}));




/*!
 * imagesLoaded PACKAGED v4.1.3
 * JavaScript is all like "You images are done yet or what?"
 * MIT License
 */
/**
 * EvEmitter v1.1.0
 * Lil' event emitter
 * MIT License
 */
/* jshint unused: true, undef: true, strict: true */
(function(global, factory) {
	// universal module definition
	/* jshint strict: false */
	/* globals define, module, window */
	if (typeof define == 'function' && define.amd) {
		// AMD - RequireJS
		define('ev-emitter/ev-emitter', factory);
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS - Browserify, Webpack
		module.exports = factory();
	} else {
		// Browser globals
		global.EvEmitter = factory();
	}

}(typeof window != 'undefined' ? window : this, function() {



	function EvEmitter() {}

	var proto = EvEmitter.prototype;

	proto.on = function(eventName, listener) {
		if (!eventName || !listener) {
			return;
		}
		// set events hash
		var events = this._events = this._events || {};
		// set listeners array
		var listeners = events[eventName] = events[eventName] || [];
		// only add once
		if (listeners.indexOf(listener) == -1) {
			listeners.push(listener);
		}

		return this;
	};

	proto.once = function(eventName, listener) {
		if (!eventName || !listener) {
			return;
		}
		// add event
		this.on(eventName, listener);
		// set once flag
		// set onceEvents hash
		var onceEvents = this._onceEvents = this._onceEvents || {};
		// set onceListeners object
		var onceListeners = onceEvents[eventName] = onceEvents[eventName] || {};
		// set flag
		onceListeners[listener] = true;

		return this;
	};

	proto.off = function(eventName, listener) {
		var listeners = this._events && this._events[eventName];
		if (!listeners || !listeners.length) {
			return;
		}
		var index = listeners.indexOf(listener);
		if (index != -1) {
			listeners.splice(index, 1);
		}

		return this;
	};

	proto.emitEvent = function(eventName, args) {
		var listeners = this._events && this._events[eventName];
		if (!listeners || !listeners.length) {
			return;
		}
		var i = 0;
		var listener = listeners[i];
		args = args || [];
		// once stuff
		var onceListeners = this._onceEvents && this._onceEvents[eventName];

		while (listener) {
			var isOnce = onceListeners && onceListeners[listener];
			if (isOnce) {
				// remove listener
				// remove before trigger to prevent recursion
				this.off(eventName, listener);
				// unset once flag
				delete onceListeners[listener];
			}
			// trigger listener
			listener.apply(this, args);
			// get next listener
			i += isOnce ? 0 : 1;
			listener = listeners[i];
		}

		return this;
	};

	proto.allOff =
		proto.removeAllListeners = function() {
			delete this._events;
			delete this._onceEvents;
		};

	return EvEmitter;

}));

/*!
 * imagesLoaded v4.1.3
 * JavaScript is all like "You images are done yet or what?"
 * MIT License
 */

(function(window, factory) {
	'use strict';
	// universal module definition

	/*global define: false, module: false, require: false */

	if (typeof define == 'function' && define.amd) {
		// AMD
		define([
			'ev-emitter/ev-emitter'
		], function(EvEmitter) {
			return factory(window, EvEmitter);
		});
	} else if (typeof module == 'object' && module.exports) {
		// CommonJS
		module.exports = factory(
			window,
			require('ev-emitter')
		);
	} else {
		// browser global
		window.imagesLoaded = factory(
			window,
			window.EvEmitter
		);
	}

})(typeof window !== 'undefined' ? window : this,

	// --------------------------  factory -------------------------- //

	function factory(window, EvEmitter) {



		var $ = window.jQuery;
		var console = window.console;

		// -------------------------- helpers -------------------------- //

		// extend objects
		function extend(a, b) {
			for (var prop in b) {
				a[prop] = b[prop];
			}
			return a;
		}

		// turn element or nodeList into an array
		function makeArray(obj) {
			var ary = [];
			if (Array.isArray(obj)) {
				// use object if already an array
				ary = obj;
			} else if (typeof obj.length == 'number') {
				// convert nodeList to array
				for (var i = 0; i < obj.length; i++) {
					ary.push(obj[i]);
				}
			} else {
				// array of single index
				ary.push(obj);
			}
			return ary;
		}

		// -------------------------- imagesLoaded -------------------------- //

		/**
		 * @param {Array, Element, NodeList, String} elem
		 * @param {Object or Function} options - if function, use as callback
		 * @param {Function} onAlways - callback function
		 */
		function ImagesLoaded(elem, options, onAlways) {
			// coerce ImagesLoaded() without new, to be new ImagesLoaded()
			if (!(this instanceof ImagesLoaded)) {
				return new ImagesLoaded(elem, options, onAlways);
			}
			// use elem as selector string
			if (typeof elem == 'string') {
				elem = document.querySelectorAll(elem);
			}

			this.elements = makeArray(elem);
			this.options = extend({}, this.options);

			if (typeof options == 'function') {
				onAlways = options;
			} else {
				extend(this.options, options);
			}

			if (onAlways) {
				this.on('always', onAlways);
			}

			this.getImages();

			if ($) {
				// add jQuery Deferred object
				this.jqDeferred = new $.Deferred();
			}

			// HACK check async to allow time to bind listeners
			setTimeout(function() {
				this.check();
			}.bind(this));
		}

		ImagesLoaded.prototype = Object.create(EvEmitter.prototype);

		ImagesLoaded.prototype.options = {};

		ImagesLoaded.prototype.getImages = function() {
			this.images = [];

			// filter & find items if we have an item selector
			this.elements.forEach(this.addElementImages, this);
		};

		/**
		 * @param {Node} element
		 */
		ImagesLoaded.prototype.addElementImages = function(elem) {
			// filter siblings
			if (elem.nodeName == 'IMG') {
				this.addImage(elem);
			}
			// get background image on element
			if (this.options.background === true) {
				this.addElementBackgroundImages(elem);
			}

			// find children
			// no non-element nodes, #143
			var nodeType = elem.nodeType;
			if (!nodeType || !elementNodeTypes[nodeType]) {
				return;
			}
			var childImgs = elem.querySelectorAll('img');
			// concat childElems to filterFound array
			for (var i = 0; i < childImgs.length; i++) {
				var img = childImgs[i];
				this.addImage(img);
			}

			// get child background images
			if (typeof this.options.background == 'string') {
				var children = elem.querySelectorAll(this.options.background);
				for (i = 0; i < children.length; i++) {
					var child = children[i];
					this.addElementBackgroundImages(child);
				}
			}
		};

		var elementNodeTypes = {
			1: true,
			9: true,
			11: true
		};

		ImagesLoaded.prototype.addElementBackgroundImages = function(elem) {
			var style = getComputedStyle(elem);
			if (!style) {
				// Firefox returns null if in a hidden iframe https://bugzil.la/548397
				return;
			}
			// get url inside url("...")
			var reURL = /url\((['"])?(.*?)\1\)/gi;
			var matches = reURL.exec(style.backgroundImage);
			while (matches !== null) {
				var url = matches && matches[2];
				if (url) {
					this.addBackground(url, elem);
				}
				matches = reURL.exec(style.backgroundImage);
			}
		};

		/**
		 * @param {Image} img
		 */
		ImagesLoaded.prototype.addImage = function(img) {
			var loadingImage = new LoadingImage(img);
			this.images.push(loadingImage);
		};

		ImagesLoaded.prototype.addBackground = function(url, elem) {
			var background = new Background(url, elem);
			this.images.push(background);
		};

		ImagesLoaded.prototype.check = function() {
			var _this = this;
			this.progressedCount = 0;
			this.hasAnyBroken = false;
			// complete if no images
			if (!this.images.length) {
				this.complete();
				return;
			}

			function onProgress(image, elem, message) {
				// HACK - Chrome triggers event before object properties have changed. #83
				setTimeout(function() {
					_this.progress(image, elem, message);
				});
			}

			this.images.forEach(function(loadingImage) {
				loadingImage.once('progress', onProgress);
				loadingImage.check();
			});
		};

		ImagesLoaded.prototype.progress = function(image, elem, message) {
			this.progressedCount++;
			this.hasAnyBroken = this.hasAnyBroken || !image.isLoaded;
			// progress event
			this.emitEvent('progress', [this, image, elem]);
			if (this.jqDeferred && this.jqDeferred.notify) {
				this.jqDeferred.notify(this, image);
			}
			// check if completed
			if (this.progressedCount == this.images.length) {
				this.complete();
			}

			if (this.options.debug && console) {
				console.log('progress: ' + message, image, elem);
			}
		};

		ImagesLoaded.prototype.complete = function() {
			var eventName = this.hasAnyBroken ? 'fail' : 'done';
			this.isComplete = true;
			this.emitEvent(eventName, [this]);
			this.emitEvent('always', [this]);
			if (this.jqDeferred) {
				var jqMethod = this.hasAnyBroken ? 'reject' : 'resolve';
				this.jqDeferred[jqMethod](this);
			}
		};

		// --------------------------  -------------------------- //

		function LoadingImage(img) {
			this.img = img;
		}

		LoadingImage.prototype = Object.create(EvEmitter.prototype);

		LoadingImage.prototype.check = function() {
			// If complete is true and browser supports natural sizes,
			// try to check for image status manually.
			var isComplete = this.getIsImageComplete();
			if (isComplete) {
				// report based on naturalWidth
				this.confirm(this.img.naturalWidth !== 0, 'naturalWidth');
				return;
			}

			// If none of the checks above matched, simulate loading on detached element.
			this.proxyImage = new Image();
			this.proxyImage.addEventListener('load', this);
			this.proxyImage.addEventListener('error', this);
			// bind to image as well for Firefox. #191
			this.img.addEventListener('load', this);
			this.img.addEventListener('error', this);
			this.proxyImage.src = this.img.src;
		};

		LoadingImage.prototype.getIsImageComplete = function() {
			return this.img.complete && this.img.naturalWidth !== undefined;
		};

		LoadingImage.prototype.confirm = function(isLoaded, message) {
			this.isLoaded = isLoaded;
			this.emitEvent('progress', [this, this.img, message]);
		};

		// ----- events ----- //

		// trigger specified handler for event type
		LoadingImage.prototype.handleEvent = function(event) {
			var method = 'on' + event.type;
			if (this[method]) {
				this[method](event);
			}
		};

		LoadingImage.prototype.onload = function() {
			this.confirm(true, 'onload');
			this.unbindEvents();
		};

		LoadingImage.prototype.onerror = function() {
			this.confirm(false, 'onerror');
			this.unbindEvents();
		};

		LoadingImage.prototype.unbindEvents = function() {
			this.proxyImage.removeEventListener('load', this);
			this.proxyImage.removeEventListener('error', this);
			this.img.removeEventListener('load', this);
			this.img.removeEventListener('error', this);
		};

		// -------------------------- Background -------------------------- //

		function Background(url, element) {
			this.url = url;
			this.element = element;
			this.img = new Image();
		}

		// inherit LoadingImage prototype
		Background.prototype = Object.create(LoadingImage.prototype);

		Background.prototype.check = function() {
			this.img.addEventListener('load', this);
			this.img.addEventListener('error', this);
			this.img.src = this.url;
			// check if image is already complete
			var isComplete = this.getIsImageComplete();
			if (isComplete) {
				this.confirm(this.img.naturalWidth !== 0, 'naturalWidth');
				this.unbindEvents();
			}
		};

		Background.prototype.unbindEvents = function() {
			this.img.removeEventListener('load', this);
			this.img.removeEventListener('error', this);
		};

		Background.prototype.confirm = function(isLoaded, message) {
			this.isLoaded = isLoaded;
			this.emitEvent('progress', [this, this.element, message]);
		};

		// -------------------------- jQuery -------------------------- //

		ImagesLoaded.makeJQueryPlugin = function(jQuery) {
			jQuery = jQuery || window.jQuery;
			if (!jQuery) {
				return;
			}
			// set local variable
			$ = jQuery;
			// $().imagesLoaded()
			$.fn.imagesLoaded = function(options, callback) {
				var instance = new ImagesLoaded(this, options, callback);
				return instance.jqDeferred.promise($(this));
			};
		};
		// try making plugin
		ImagesLoaded.makeJQueryPlugin();

		// --------------------------  -------------------------- //

		return ImagesLoaded;

	});




/**
 *     __  ___ ____ ______ __  __ ________  __ _____  __     ____ ____   ______ ____ 
 *    /  |/  //  _// ____// / / //_  __/\ \/ // ___/ / /    /  _// __ \ / ____// __ \
 *   / /|_/ / / / / / __ / /_/ /  / /    \  / \__ \ / /     / / / / / // __/  / /_/ /
 *  / /  / /_/ / / /_/ // __  /  / /     / / ___/ // /___ _/ / / /_/ // /___ / _, _/
 * /_/  /_//___/ \____//_/ /_/  /_/     /_/ /____//_____//___//_____//_____//_/ |_|
 *
 * mightySlider - Mighty Responsive Slider
 * http://mightyslider.com
 *
 * @version:  3.0.0
 * @released: August 3, 2017
 *
 * @author:   Hemn Chawroka
 *            http://iprodev.com/
 *
 */

/*!
 * elementSpy 1.0.0 - 22nd May 2015
 *
 * Licensed under the MIT license.
 * http://opensource.org/licenses/MIT
 */

;(function ($, w, undefined) {
	'use strict';

	// Plugin names
	var pluginName = 'elementspy',
		pluginClass = 'elementSpy',
		namespace  = pluginName;

	$[pluginClass] = function(context, callback, options) {
		// Optional arguments delay
		if (typeof callback !== 'function') {
			options = callback;
			callback = 0;
		}

		// Private variables
		var self     = this;
		var $context = $(context);
		var defaults = $.extend({}, $.fn[pluginName].defaults, options);
		var spies    = {};
		var lastId   = 0;
		var pos      = {
			top: $context.scrollTop(),
			left: $context.scrollLeft(),
			width: $context.innerWidth(),
			height: $context.innerHeight(),
			offset: $context.offset() || {
				top: 0,
				left: 0
			}
		};

		/**
		 * Add new element(s) to spies list.
		 *
		 * @param {Node}     element
		 * @param {Function} callback
		 * @param {Object}   options
		 *
		 * @return {Object} Spy object with basic control methods.
		 */
		self.add = function (element, callback, options) {
			// Optional arguments logic
			if ($.isPlainObject(callback)) {
				options = callback;
				callback = 0;
			}

			$(element).each(function (i, el) {
				var spyId = getId(el) || 's' + lastId++;

				// Add new element to spying list
				spies[spyId] = $.extend({
					id: spyId,
					el:  el,
					$el: $(el),
					callback: callback
				}, defaults, options);

				// Load the element data
				load(spyId);
			});
		};

		/**
		 * (Re)Load spy object's dimensions.
		 *
		 * @param  {Mixed} element
		 *
		 * @return {Void}
		 */
		function load(element) {
			var spy = getSpy(element);
			if (!spy) {
				return;
			}

			var start = spy.$el.offset()[spy.horizontal ? 'left' : 'top'] - pos.offset[spy.horizontal ? 'left' : 'top'];
			var size  = spy.$el[spy.horizontal ? 'outerWidth' : 'outerHeight']();

			// Add new element to spying list
			$.extend(spy, {
				start: start,
				elSize: size,
				end: start + size
			});

			// Check the element for its state
			check(spy);
		}

		/**
		 * Reload element's dimensions.
		 *
		 * @param  {Node} element
		 *
		 * @return {Void}
		 */
		self.reload = function (element) {
			$(element).each(function (i, el) {
				var spyId = getId(el);
				if (spyId) {
					load(spyId);
				}
			});
		};

		/**
		 * Remove element(s) from spying list.
		 *
		 * @param  {Node} element
		 *
		 * @return {Void}
		 */
		self.remove = function (element) {
			$(element).each(function (i, el) {
				var spyId = getId(el);
				if (spyId) {
					delete spies[spyId];
				}
			});
		};

		/**
		 * Check element state, and trigger callback on change.
		 *
		 * @param  {Mixed} element Can be element node, spy ID, or spy object. Omit to check all elements.
		 *
		 * @return {Void}
		 */
		function check(element) {
			if (element === undefined) {
				$.each(spies, check);
				return;
			}

			// Check whether the element/ID exist in spying list.
			var spy = getSpy(element);
			if (!spy) {
				return;
			}

			// Variables necessary for determination.
			var viewSize     = pos[spy.horizontal ? 'width' : 'height'];
			var triggerSize  = parseRatio(spy.size, viewSize);
			var triggerStart = pos[spy.horizontal ? 'left' : 'top'] + parseRatio(spy.offset, viewSize, -triggerSize);
			var triggerEnd   = triggerStart + triggerSize;
			var newState;

			// Calculate element state in relation to trigger area.
			if (spy.contain) {
				if (triggerStart <= spy.start && triggerEnd >= spy.end) {
					newState = 'inside';
				} else if (triggerStart + triggerSize / 2 > spy.start + spy.elSize / 2) {
					newState = spy.horizontal ? 'left' : 'up';
				} else {
					newState = spy.horizontal ? 'right' : 'down';
				}
			} else {
				if (
					triggerStart > spy.start && triggerStart < spy.end ||
					triggerEnd > spy.start && triggerEnd < spy.end ||
					triggerStart <= spy.start && triggerEnd >= spy.start ||
					triggerStart <= spy.end && triggerEnd >= spy.end
				) {
					newState = 'inside';
				} else if (triggerStart > spy.end) {
					newState = spy.horizontal ? 'left' : 'up';
				} else {
					newState = spy.horizontal ? 'right' : 'down';
				}
			}

			// Trigger callbacks on change.
			if (spy.state !== newState) {
				spy.state = newState;
				if (typeof callback === 'function') {
					callback.call(spy.el, newState === 'inside', newState);
				}
				if (typeof spy.callback === 'function') {
					spy.callback.call(spy.el, newState === 'inside', newState);
				}
			}
		}

		/**
		 * Check whether the element is already spied on, and return the spy ID.
		 *
		 * @param  {Node}  element
		 *
		 * @return {Mixed} Spy ID string, or false.
		 */
		function getId(element) {
			// Return when ID has been passed.
			if (spies.hasOwnProperty(element)) {
				return element;
			}

			// Return ID when spy object has been passed.
			if ($.isPlainObject(element) && spies.hasOwnProperty(element.id)) {
				return element.id;
			}

			// Ensure the element is a single Node
			element = $(element)[0];

			// Check for existence and return the ID.
			var is = false;
			$.each(spies, function (id, spy) {
				if (spy.el === element) {
					is = id;
				}
			});
			return is;
		}

		/**
		 * Return spy object of an element.
		 *
		 * @param  {Node}  element
		 *
		 * @return {Object} Spy ID string, or false.
		 */
		function getSpy(element) {
			var spyId = getId(element);
			return spyId ? spies[spyId] : false;
		}

		/**
		 * Destroy Espy instance.
		 *
		 * @return {Void}
		 */
		self.destroy = function () {
			$context.off('.' + namespace);
			spies = {};
			self = undefined;
		};

		// Register scroll handler
		$context.on('scroll.' + namespace, throttle(defaults.delay, function () {
			pos.top  = $context.scrollTop();
			pos.left = $context.scrollLeft();
			check();
		}));

		// Register resize handler
		$context.on('resize.' + namespace, throttle(defaults.delay, function () {
			pos.width  = $context.innerWidth();
			pos.height = $context.innerHeight();
			check();
		}));
	};

	/**
	 * Parse string like -200% and return the final dimension.
	 *
	 * @param  {Mixed}   value  Integer, or percent string.
	 * @param  {Integer} total  Total value representing 100%.
	 * @param  {Integer} offset Optional offset for negative numbers.
	 *
	 * @return {Integer}
	 */
	function parseRatio(value, total, offset) {
		var matches = (value+'').match(/^(-?[0-9]+)(%)?$/);
		if (!matches) {
			return false;
		}
		var num = parseInt(matches[1], 10);
		if (matches[2]) {
			num = total / 100 * num;
		}
		return num < 0 ? total + num + (offset || 0) : num;
	}

	/**
	 * Create a throttled version of a callback function.
	 *
	 * Copied & pasted with slight adjustments from
	 * https://github.com/cowboy/jquery-throttle-debounce/
	 *
	 * @param  {Integer}  delay
	 * @param  {Function} callback
	 *
	 * @return {Function}
	 */
	function throttle(delay, callback) {
		var timeoutId;
		var lastExec = 0;

		// The `wrapper` function encapsulates all of the throttling functionality
		// and when executed will limit the rate at which `callback` is executed.
		function wrapper() {
			/*jshint validthis:true */
			var that = this;
			var elapsed = +new Date() - lastExec;
			var args = arguments;

			function clear() {
				if (timeoutId) {
					timeoutId = clearTimeout(timeoutId);
				}
			}

			function exec() {
				lastExec = +new Date();
				callback.apply(that, args);
				clear();
			}

			clear();

			if (elapsed > delay) {
				exec();
			} else {
				timeoutId = setTimeout(exec, delay - elapsed);
			}
		}

		// Set the guid of `wrapper` function to the same of original callback, so it can be
		// removed in jQuery 1.4+ .unbind or .off by using the original callback as a reference.
		if ($.guid) {
			wrapper.guid = callback.guid = callback.guid || $.guid++;
		}

		// Return the wrapper function.
		return wrapper;
	}

	// Extend jQuery
	$.fn[pluginName] = function (callback, options) {
		var method, methodArgs;
		var context = options && options.context || w;
		var espy = $.data(context, namespace) || $.data(context, namespace, new $[pluginClass](context));

		// Attributes logic
		if (typeof callback === 'string') {
			method = options === false || options === 'destroy' ? 'remove' : options;
			methodArgs = Array.prototype.slice.call(arguments, 1);
			options = {};
		}

		// Apply to all elements
		return this.each(function (i, element) {
			if (!method) {
				// Adding element to spy on
				espy.add(element, callback, options);
			} else {
				// Call plugin method
				if (typeof espy[method] === 'function') {
					espy[method].apply(espy, methodArgs);
				}
			}
		});
	};

	// Default options
	$.fn[pluginName].defaults = {
		delay:      100,    // Events throttling delay in milliseconds.
		context:    window, // Scrolling context.
		horizontal: 0,      // Enable for horizontal scrolling.
		offset:     0,      // Target area offset from start (top in vert., left in hor.).
		size:       '100%', // Target area size (height in vert., width in hor.).
		contain:    0       // Trigger as entered only when element is completely within the target area.
	};
}(jQuery, window));


/**
 * mightySlider - Mighty Responsive Slider
 * http://mightyslider.com
 */
(function ($, window, undefined) {
	'use strict';

	// Create a new object, that prototypally inherits from the Error constructor
	function msError(message, error) {
		this.name = 'mightySlider';
		this.message = message || 'Default Message';
		this.stack = error.stack;
		this.lineNumber = error.lineNumber;
		this.columnNumber = error.columnNumber;
		this.fileName = error.fileName;
	}
	msError.prototype = Object.create(Error.prototype);
	msError.prototype.constructor = msError;

	/**
	 * References.
	 */
	var ArrayProto  = Array.prototype,
		ObjProto    = Object.prototype,
		StringProto = String.prototype,
		replace     = 'replace',
		width       = 'width',
		height      = 'height',
		length      = 'length';

	 /*!
	 * mightySlider Components 1.0.0 - 22nd May 2015
	 * http://iprodev.com/
	 *
	 * Licensed under the MIT license.
	 * http://opensource.org/licenses/MIT
	 */
	var _ = {};

	/**
	 * Return the type of `val`. Type assertions aka less-broken `typeof`.
	 *
	 * @param {Mixed} val
	 * @return {String}
	 * @api public
	 */

	function type(val) {
		switch (toString.call(val)) {
			case '[object Date]':
				return 'date';
			case '[object RegExp]':
				return 'regexp';
			case '[object Arguments]':
				return 'arguments';
			case '[object Array]':
				return 'array';
			case '[object Boolean]':
				return 'boolean';
			case '[object Error]':
				return 'error';
		}

		if (val === null) return 'null';
		if (val === undefined) return 'undefined';
		if (val !== val) return 'nan';
		if (val && val.nodeType === 1) return 'element';

		val = val.valueOf ? val.valueOf() : Object.prototype.valueOf.apply(val)

		return typeof val;
	};

	// Check to see if an object is a plain object (created using "{}" or "new Object").
	function isObject(object) {
		return type(object) === 'object';
	};

	// Determine whether the argument is an array.
	var isArray = Array.isArray || function (array) {
		return type(array) === 'array';
	};

	// Create quick reference variables for speed access to core prototypes.
	var push = ArrayProto.push,
		indexOf = function(searchElement, fromIndex) {
			if (this == null) {
				throw new msError('"this" is null or not defined', new Error());
			}

			if (isArray(this)) {
				return ArrayProto.indexOf.call(this, searchElement, fromIndex);
			}
			else {
				return StringProto.indexOf.call(this, searchElement, fromIndex);
			}
		},
		slice = ArrayProto.slice,
		splice = ArrayProto.splice,
		filter = ArrayProto.filter,
		toString = ObjProto.toString,
		hasOwnProperty = ObjProto.hasOwnProperty;

	(function () {
		/**
		 * Check whether value is a window object.
		 *
		 * Uses duck typing to determine window. Without IE8 all we need is:
		 *
		 *   var type = Object.prototype.toString.call(val);
		 *   return type === '[object global]' || type === '[object Window]' || type === '[object DOMWindow]';
		 *
		 * @param  {Mixed} val
		 * @return {Boolean}
		 */
		function isWindow(val) {
			/* jshint eqeqeq:false */
			var doc, docWin;
			return !!(
				val
				&& typeof val === 'object'
				&& typeof val.window === 'object'
				&& val.window == val
				&& val.setTimeout
				&& val.alert
				&& (doc = val.document)
				&& typeof doc === 'object'
				&& (docWin = doc.defaultView || doc.parentWindow)
				&& typeof docWin === 'object'
				&& docWin == val
			);
		};
		_.isWindow = isWindow;

		/**
		 * Determines whether an array includes a certain element, returning true or false as appropriate.
		 *
		 * @param  {Mixed} searchElement
		 * @param  {Array} array
		 * @return {Boolean}
		 */
		function inArray(elem, arr, i) {
			return arr == null ? -1 : indexOf.call( arr, elem, i );
		};
		_.inArray = inArray;

		// Returns element's position object relative to document, window, or other elements.
		(function () {
			/**
			 * Poor man's shallow object extend;
			 *
			 * @param  {Object} a
			 * @param  {Object} b
			 * @return {Object}
			 */
			function extend(a, b) {
				for (var k in b) a[k] = b[k];
				return a;
			}

			/**
			 * Returns element's position object with `left`, `top`, `bottom`, `right`,
			 * `width`, and `height` properties indicating the position and dimensions
			 * of element on a page, or relative to other element.
			 *
			 * @param {Element} element
			 * @param {Element} [relativeTo] Defaults to `document.documentElement`.
			 *
			 * @return {Object|null}
			 */
			_.position = function(element, relativeTo) {
				var isWin = isWindow(element);
				var doc = isWin ? element.document : element.ownerDocument || element;
				var docEl = doc.documentElement;
				var win = isWindow(relativeTo) ? relativeTo : doc.defaultView || window;

				// normalize arguments
				if (element === doc) element = docEl;
				relativeTo = !relativeTo || relativeTo === doc ? docEl : relativeTo;

				var winTop = (win.pageYOffset || docEl.scrollTop) - docEl.clientTop;
				var winLeft = (win.pageXOffset || docEl.scrollLeft) - docEl.clientLeft;
				var box = { top: 0, left: 0 };

				if (isWin) {
					box[width] = box.right = win.innerWidth || docEl.clientWidth;
					box[height] = box.bottom = win.innerHeight || docEl.clientHeight;
				} else if (element === docEl) {
					// we need to do  this manually because docEl.getBoundingClientRect
					// is inconsistent in <IE11
					box.top = -winTop;
					box.left = -winLeft;
					box[width] = Math.max(docEl.clientWidth, docEl.scrollWidth);
					box[height] = Math.max(docEl.clientHeight, docEl.scrollHeight);
					box.right = box.width - winLeft;
					box.bottom = box[height] - winTop;
				} else if (docEl.contains(element) && element.getBoundingClientRect) {
					// new object needed because DOMRect properties are read-only
					box = extend({}, element.getBoundingClientRect());
					// width & height don't exist in <IE9
					box[width] = box.right - box.left;
					box[height] = box.bottom - box.top;
				} else {
					return null;
				}

				// current box is already relative to window
				if (relativeTo === win) return box;

				// add window offsets, making the box relative to documentElement
				box.top += winTop;
				box.left += winLeft;
				box.right += winLeft;
				box.bottom += winTop;

				// current box is already relative to documentElement
				if (relativeTo === docEl) return box;

				// subtract position of other element
				var relBox = position(relativeTo);
				box.left -= relBox.left;
				box.right -= relBox.left;
				box.top -= relBox.top;
				box.bottom -= relBox.top;

				return box;
			}
		}());


		// Array / object / string iteration utility.
		(function () {
			/**
			 * Iterate string chars.
			 *
			 * @param {String} obj
			 * @param {Function} fn
			 * @param {Object} ctx
			 * @api private
			 */

			function string(obj, fn, ctx) {
				for (var i = 0, len = obj[length]; i < len; ++i) {
					fn.call(ctx, obj.charAt(i), i);
				}
			}

			/**
			 * Iterate object keys.
			 *
			 * @param {Object} obj
			 * @param {Function} fn
			 * @param {Object} ctx
			 * @api private
			 */

			function object(obj, keys, fn, ctx) {
				for (var i = 0, len = keys[length]; i < len; ++i) {
					fn.call(ctx, keys[i], obj[keys[i]]);
				}
			}

			/**
			 * Iterate array-ish.
			 *
			 * @param {Array|Object} obj
			 * @param {Function} fn
			 * @param {Object} ctx
			 * @api private
			 */

			function array(obj, fn, ctx) {
				for (var i = 0, len = obj[length]; i < len; ++i) {
					fn.call(ctx, obj[i], i);
				}
			}

			/**
			 * Iterate the given `obj` and invoke `fn(val, i)`
			 * in optional context `ctx`.
			 *
			 * @param {String|Array|Object} obj
			 * @param {Function} fn
			 * @param {Object} [ctx]
			 * @api public
			 */

			_.each = function(obj, fn, ctx) {
				ctx = ctx || this;
				switch (type(obj)) {
					case 'array':
						return array(obj, fn, ctx);
					case 'object':
						if ('number' == type(obj[length])) return array(obj, fn, ctx);
						return object(obj, Object.keys(obj), fn, ctx);
					case 'string':
						return string(obj, fn, ctx);
				}
			};
		}());

		// Browser detect
		(function () {
			function uaMatch( ua ) {
				ua = ua.toLowerCase();

				var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
					/(webkit)[ \/]([\w.]+)/.exec( ua ) ||
					/(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
					/(msie) ([\w.]+)/.exec( ua ) ||
					indexOf.call(ua, "compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
					[];

				return {
					browser: match[ 1 ] || "",
					version: match[ 2 ] || "0"
				};
			}

			var matched = uaMatch( navigator.userAgent );
			var browser = {};

			if ( matched.browser ) {
				browser[ matched.browser ] = true;
				browser.version = matched.version;
			}

			// Chrome is Webkit, but Webkit is also Safari.
			if ( browser.chrome ) {
				browser.webkit = true;
			}
			else if ( browser.webkit ) {
				browser.safari = true;
			}

			_.browser = browser;
		}());

		/**
		 * A JavaScript equivalent of PHP’s basename.
		 *
		 * @param {String} path
		 * @param {String} suffix
		 *
		 * @return {String}
		 */
		function basename(path, suffix) {
			var b = path[replace](/^.*[\/\\]/g, '');

			if (type(suffix) === 'string' && b.substr(b[length] - suffix[length]) === suffix) {
				b = b.substr(0, b[length] - suffix[length]);
			}

			return b;
		};
		_.baseName = basename;

		/**
		 * A JavaScript equivalent of PHP’s parse_url.
		 *
		 * @param {String} url           The URL to parse.
		 * @param {String} component     Specify one of URL_SCHEME, URL_HOST, URL_PORT, URL_USER, URL_PASS, URL_PATH, URL_QUERY or URL_FRAGMENT to retrieve just a specific URL component as a string.
		 *
		 * @return {Mixed}
		 */
		function parse_url(url, component) {
			var query, key = ['source', 'scheme', 'authority', 'userInfo', 'user', 'pass', 'host', 'port',
				'relative', 'path', 'directory', 'file', 'query', 'fragment'],
				mode = 'php',
				parser = {
					php: /^(?:([^:\/?#]+):)?(?:\/\/()(?:(?:()(?:([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?))?()(?:(()(?:(?:[^?#\/]*\/)*)()(?:[^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
					strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
					loose: /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/\/?)?((?:(([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/ // Added one optional slash to post-scheme to catch file:/// (should restrict this)
				};

			var m = parser[mode].exec(url),
				uri = {},
				i = 14;
				while (i--) {
					if (m[i]) {
						uri[key[i]] = m[i];
					}
				}

			if (component) {
				return uri[component[replace]('URL_', '').toLowerCase()];
			}
			if (mode !== 'php') {
				var name = 'queryKey';
				parser = /(?:^|&)([^&=]*)=?([^&]*)/g;
				uri[name] = {};
				query = uri[key[12]] || '';
				query[replace](parser, function ($0, $1, $2) {
					if ($1) {uri[name][$1] = $2;}
				});
			}
			uri.source = null;
			return uri;
		};
		_.parseURL = parse_url;

		/**
		 * Get file extension.
		 *
		 * @param {String} URL
		 *
		 * @return {String}
		 */
		_.getExtension = function(URL){
			var parsedURL = parse_url(URL),
				filename = basename(URL);

			if (parsedURL.query) {
				filename = filename[replace]("?" + parsedURL.query, "");
			}

			// Return extension
			return filename.substr((~-filename.lastIndexOf(".") >>> 0) + 2);;
		};

		// Gets the absolute URI.
		(function () {
			var removeDotSegments = function (input) {
				var output = [];
				input[replace](/^(\.\.?(\/|$))+/, '')
					 .replace(/\/(\.(\/|$))+/g, '/')
					 .replace(/\/\.\.$/, '/../')
					 .replace(/\/?[^\/]*/g, function (p) {
					if (p === '/..') {
						output.pop();
					} else {
						push.call(output, p);
					}
				});
				return output.join('')[replace](/^\//, input.charAt(0) === '/' ? '/' : '');
			}

			var URIComponents = function (url) {
				var m = String(url)[replace](/^\s+|\s+$/g, '').match(/^([^:\/?#]+:)?(\/\/(?:[^:@]*(?::[^:@]*)?@)?(([^:\/?#]*)(?::(\d*))?))?([^?#]*)(\?[^#]*)?(#[\s\S]*)?/);
				// authority = '//' + user + ':' + pass '@' + hostname + ':' port
				return (m ? {
					href     : m[0] || '',
					protocol : m[1] || '',
					authority: m[2] || '',
					host     : m[3] || '',
					hostname : m[4] || '',
					port     : m[5] || '',
					pathname : m[6] || '',
					search   : m[7] || '',
					hash     : m[8] || ''
				} : null);
			}

			/**
			 * Gets the absolute URI.
			 *
			 * @param {String} href     The relative URL.
			 * @param {String} base     The base URL.
			 *
			 * @return {String}         The absolute URL.
			 */
			_.absolutizeURI = function (href, base) {// RFC 3986
				href = URIComponents(href || '');
				base = URIComponents(base || window.location.href);

				return !href || !base ? null : (href.protocol || base.protocol) +
					(href.protocol || href.authority ? href.authority : base.authority) +
					removeDotSegments(href.protocol || href.authority || href.pathname.charAt(0) === '/' ? href.pathname : (href.pathname ? ((base.authority && !base.pathname ? '/' : '') + base.pathname.slice(0, base.pathname.lastIndexOf('/') + 1) + href.pathname) : base.pathname)) +
					(href.protocol || href.authority || href.pathname ? href.search : (href.search || base.search)) +
					href.hash;
			};
		}());

		// A JavaScript equivalent of PHP’s uniqid.
		(function () {
			var formatSeed = function (seed, reqWidth) {
				seed = parseInt(seed, 10).toString(16); // to hex str
				if (reqWidth < seed[length]) { // so long we split
					return slice.call(seed, seed[length] - reqWidth);
				}
				if (reqWidth > seed[length]) { // so short we pad
					return Array(1 + (reqWidth - seed[length])).join('0') + seed;
				}
				return seed;
			};

			/**
			 * A JavaScript equivalent of PHP’s uniqid.
			 *
			 * @param {String}  prefix
			 * @param {Boolean} more_entropy
			 *
			 * @return {String}
			 */
			_.uniqID = function (prefix, more_entropy) {
				if (type(prefix) === 'undefined') {
					prefix = "";
				}

				var retId;

				// BEGIN REDUNDANT
				var php_js = {};

				// END REDUNDANT
				if (!php_js.uniqidSeed) { // init seed with big random int
					php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
				}
				php_js.uniqidSeed++;

				retId = prefix; // start with prefix, add current milliseconds hex string
				retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
				retId += formatSeed(php_js.uniqidSeed, 5); // add seed hex string
				if (more_entropy) {
					// for more entropy we add a float lower to 10
					retId += (Math.random() * 10).toFixed(8).toString();
				}

				return retId;
			}
		}());
	}());

	var namespace = 'mightySlider',
		minnamespace  = 'mS',
		mightySliderInstances = [],
		videoRegularExpressions = [
			{
				reg:    /youtu\.be\//i,
				split:  '/',
				index:  3,
				iframe: 1,
				url:    "https://www.youtube.com/embed/{id}?autoplay=1&fs=1&rel=0&enablejsapi=1&wmode=opaque"
			},
			{
				reg:    /youtube\.com\/watch/i,
				split:  '=',
				index:  1,
				iframe: 1,
				url:    "https://www.youtube.com/embed/{id}?autoplay=1&fs=1&rel=0&enablejsapi=1&wmode=opaque"
			},
			{
				reg:    /vimeo\.com\//i,
				split:  '/',
				index:  3,
				iframe: 1,
				url:    "https://player.vimeo.com/video/{id}?hd=1&autoplay=1&show_title=1&show_byline=1&show_portrait=0&color=&fullscreen=1&api=1"
			},
			{
				reg:   /metacafe\.com\/watch/i,
				split: '/',
				index: 4,
				url:   "http://www.metacafe.com/fplayer/{id}/.swf?playerVars=autoPlay=yes"
			},
			{
				reg:   /dailymotion\.com\/video/i,
				split: '/',
				index: 4,
				url:   "http://www.dailymotion.com/swf/video/{id}?additionalInfos=0&autoStart=1"
			},
			{
				reg:   /gametrailers\.com/i,
				split: '/',
				index: 5,
				url:   "http://www.gametrailers.com/remote_wrap.php?mid={id}"
			},
			{
				reg:   /collegehumor\.com\/video\//i,
				split: 'video/',
				index: 1,
				url:   "http://www.collegehumor.com/moogaloop/moogaloop.jukebox.swf?autostart=true&fullscreen=1&use_node_id=true&clip_id={id}"
			},
			{
				reg:   /collegehumor\.com\/video:/i,
				split: 'video:',
				index: 1,
				url:   "http://www.collegehumor.com/moogaloop/moogaloop.swf?autoplay=true&fullscreen=1&clip_id={id}"
			},
			{
				reg:   /ustream\.tv/i,
				split: '/',
				index: 4,
				url:   "http://www.ustream.tv/flash/video/{id}?loc=%2F&autoplay=true&vid={id}&disabledComment=true&beginPercent=0.5331&endPercent=0.6292&locale=en_US"
			},
			{
				reg:   /twitvid\.com/i,
				split: '/',
				index: 3,
				url:   "http://www.twitvid.com/player/{id}"
			},
			{
				reg:   /vine\.co\/v\//i,
				split: '/',
				index: 4,
				url:   "https://vine.co/v/{id}/embed/simple"
			},
			{
				reg:   /v\.wordpress\.com/i,
				split: '/',
				index: 3,
				url:   "http://s0.videopress.com/player.swf?guid={id}&v=1.01"
			},
			{
				reg:   /google\.com\/videoplay/i,
				split: '=',
				index: 1,
				url:   "http://video.google.com/googleplayer.swf?autoplay=1&hl=en&docId={id}"
			},
			{
				reg:   /vzaar\.com\/videos/i,
				split: '/',
				index: 4,
				url:   "http://view.vzaar.com/{id}.flashplayer?autoplay=true&border=none"
			}
		],
		JSONReader = '//api.mightyslider.com/getjson.php',
		photoRegularExpressions = [
			{
				reg:     /vimeo\.com\//i,
				oembed:  'https://vimeo.com/api/oembed.json?url={URL}',
				inJSON:  'thumbnail_url'
			},
			{
				reg:     /youtube\.com\/watch/i,
				oembed:  'https://www.youtube.com/oembed?url={URL}&format=json',
				inJSON:  'thumbnail_url',
				replace: {
					from: 'hqdefault.jpg',
					to:   'maxresdefault.jpg'
				}
			},
			{
				reg:    /dailymotion\.com\/video/i,
				oembed: 'http://www.dailymotion.com/services/oembed?format=json&url={URL}',
				inJSON: 'url'
			},
			{
				reg:    /vine\.co\/v\//i,
				oembed: 'https://vine.co/oembed.json?url={URL}',
				inJSON: 'thumbnail_url'
			},
			{
				reg:     /500px\.com\/photo\/([0-9]+)/i,
				oembed:  'https://500px.com/oembed?format=json&url={URL}',
				inJSON:  'thumbnail_url',
				replace: {
					from: '3.jpg',
					to:   '5.jpg'
				}
			},
			{
				reg:    /flickr\.com\/photos\/([^\/]+)\/([0-9]+)/i,
				oembed: 'https://www.flickr.com/services/oembed?url={URL}&format=json',
				inJSON: 'url'
			},
			{
				reg:    /instagram\.com\/p\//i,
				oembed: 'http://api.instagram.com/oembed?url={URL}',
				inJSON: 'url'
			},
			{
				reg:    /deviantart\.com\/p\//i,
				oembed: 'http://backend.deviantart.com/oembed?url={URL}',
				inJSON: 'url'
			}
		],
		videoTypes = {
			'avi' : 'video/msvideo',
			'mov' : 'video/quicktime',
			'mpg' : 'video/mpeg',
			'mpeg': 'video/mpeg',
			'mp4' : 'video/mp4',
			'webm': 'video/webm',
			'ogv' : 'video/ogg',
			'3gp' : 'video/3gpp',
			'm4v' : 'video/x-m4v'
		},
		extensions = {
			flash: 'swf',
			image: 'bmp gif jpeg jpg png tiff tif jfif jpe',
			video: 'avi mov mpg mpeg mp4 webm ogv 3gp m4v'
		},
		interactiveElements = ['INPUT', 'SELECT', 'BUTTON', 'TEXTAREA'],
		time,

		// HTML5 video tag default attributes
		videoDefaultAttributes = {
			width: '100%',
			height: '100%',
			preload: 'preload',
			autoplay: 'autoplay',
			controls: 'controls'
		},

		// iframe tag default attributes
		iframeDefaultAttributes = {
			width: '100%',
			height: '100%',
			frameborder: 0,
			webkitAllowFullScreen: true,
			mozallowfullscreen: true,
			allowFullScreen: true
		},

		// embed tag default attributes
		embedDefaultAttributes = {
			width: '100%',
			height: '100%',
			bgcolor: '#000000',
			quality: 'high',
			play: true,
			loop: true,
			menu: true,
			wmode: 'transparent',
			scale: 'showall',
			allowScriptAccess: 'always',
			allowFullScreen: true,
			fullscreen: 'yes'
		},

		// Global DOM elements
		$win = $(window),
		$doc = $(document),

		// Events
		clickEvent = 'msclick.' + namespace,
		mouseDownEvent = 'touchstart.' + namespace + ' mousedown.' + namespace,
		wheelEvent = (document.implementation.hasFeature('Event.wheel', '3.0') ? 'wheel.' : 'mousewheel.') + namespace,
		dragInitEvents = 'touchstart.' + namespace + ' mousedown.' + namespace,
		dragMouseEvents = 'mousemove.' + namespace + ' mouseup.' + namespace,
		dragTouchEvents = 'touchmove.' + namespace + ' touchend.' + namespace,
		hoverEvent = 'mouseenter.' + namespace + ' mouseleave.' + namespace,

		// Local WindowAnimationTiming interface
		requestAnimationFrame = window.requestAnimationFrame,
		cancelAnimationFrame = window.cancelAnimationFrame || window.cancelRequestAnimationFrame,

		// Support indicators
		transform, gpuAcceleration, visibilityEvent, visibilityHidden,
		supportTouch  = !!('ontouchstart' in window) && (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)),
		orientation = typeof window.orientation !== 'undefined' ? window.orientation : ($win[height]() > $win[width]() ? 0 : 90),
		orientationSupport = !!window.DeviceOrientationEvent,
		isRetina = window.devicePixelRatio && window.devicePixelRatio >= 1.5,
		_now = Date.now || function () {return new Date().getTime();},

		// Speed access to frequently called functions
		_each = _.each,
		_position = _.position,
		tweenLite = window.GreenSockGlobals && window.GreenSockGlobals.TweenLite;

	// Keep track of last fired global wheel event
	var lastWheel = 0;
	$doc.on(wheelEvent, function (event) {
		var mSEvent = event.originalEvent[namespace];
		var time = _now();
		// Update last wheel time, but only when event didn't originate
		// in mightySlider frame, or the origin was less than scrollHijack time ago
		if (!mSEvent || mSEvent.options.scrolling.hijack < time - lastWheel) lastWheel = time;
	});

	// Spy the user viewport to just active the sliders in the viewport
	var windowSpy = new jQuery.elementSpy(window, function (entered) {
		if (!mightySliderInstances[length]) {
			return;
		}

		var frame = this;
		var instance;

		_each(mightySliderInstances, function(ins) {
			if (ins.frame === frame) {
				instance = ins;
			}
		});

		if (!instance) {
			return;
		}

		// Unfreeze entered slider
		if (entered) {
			instance.unFreeze();
		}
		// Freeze leaved slider
		else {
			instance.freeze();
		}
	});

	/**
	 * mightySlider.
	 *
	 * @class
	 *
	 * @param {Element} frame       DOM element of mightySlider container.
	 * @param {Object}  options     Object with options.
	 * @param {Object}  callbackMap Callbacks map.
	 */
	function mightySlider(frame, options, callbackMap) {
		var self = this;

		// Merge options deeply
		var o = $.extend(true, {}, mightySlider.defaults, options),

			// Frame
			$frame = $(frame),
			$parent = $(frame).parent(),
			$slideElement = $frame.children().eq(0),
			frameInlineOptions = getInlineOptions($frame),
			autoScale = o.autoScale && ( frameInlineOptions[height] && { width: frameInlineOptions[width], height: frameInlineOptions[height] } || { width: $parent[width](), height: $parent[height]() }) || null,
			frameSize = 0,
			frameRatio = 1,
			slideElementSize = 0,
			pos = {
				current: 0,
				start: 0,
				center: 0,
				end: 0,
				destination: 0
			},

			// Slides
			$slides = 0,
			items = [],
			rel = {
				activeSlide: -1,
				firstSlide: 0,
				centerSlide: 0,
				lastSlide: 0,
				activePage: 0
			},

			// Navigation
			basicNav = o.navigation.navigationType === 'basic',
			forceCenteredNav = o.navigation.navigationType === 'forceCentered',
			centeredNav = o.navigation.navigationType === 'centered' || forceCenteredNav,
			navigationType = (basicNav || centeredNav || forceCenteredNav),

			// Scrollbar
			$scrollbar = $(o.scrollBar.scrollBarSource).eq(0),
			$handle = $scrollbar.children().eq(0),
			scrollbarSize = 0,
			handleSize = 0,
			hPos = {
				start: 0,
				end: 0,
				current: 0
			},

			// Pagesbar
			$pagesBar = o.pages.pagesBar && $(o.pages.pagesBar) || {},
			$pages = 0,
			pages = [],

			// Thumbnails bar
			$thumbnailsBar = o.thumbnails.thumbnailsBar && $(o.thumbnails.thumbnailsBar) || {},
			$thumbnails = 0,
			thumbnails = [],
			thumbnailNav = null,
			thumbnailNavOptions = {},

			// Scrolling and Dragging
			$scrollSource = o.scrolling.scrollSource && $(o.scrolling.scrollSource) || $frame,
			$dragSource = o.dragging.dragSource && $(o.dragging.dragSource) || $frame,
			dragging = {
				released: 1
			},

			// Buttons
			$forwardButton = $(o.buttons.forward),
			$backwardButton = $(o.buttons.backward),
			$prevButton = $(o.buttons.prev),
			$nextButton = $(o.buttons.next),
			$prevPageButton = $(o.buttons.prevPage),
			$nextPageButton = $(o.buttons.nextPage),
			$fullScreenButton = $(o.buttons.fullScreen),

			// Layers
			parallax = {},
			parallaxTo = {},
			captionParallax = {},
			captionID = 0,
			captionHistory = [],
			captionRendered = -1,
			scrollParallaxCaptions = [],
			scrollParallaxSlide = null,
			parallaxTween,
			scalers = [],

			// Miscellaneous
			inserted = 0,
			hashLock = 0,
			callbacks = {},
			last = {},
			animation = {},
			move = {},
			scrolling = {
				last: 0,
				delta: 0,
				resetTime: 200
			},
			renderID = 0,
			historyID = 0,
			cycleID = 0,
			cycleLastTime = 0,
			continuousID = 0,
			resizeID = 0,
			freezeID = 0,
			mediaEnabled = null,
			uniqId = _.uniqID(namespace),
			fxEasing = $.easing[o.easing] || $.easing['swing'],
			i, l,
			
			// Events
			resizeEvent = 'resize.' + uniqId + ' orientationchange.' + uniqId,
			hashChangeEvent = 'hashchange.' + uniqId,
			keyDownEvent = 'keydown.' + uniqId,
			mouseEnterEvent = 'mouseenter.' + uniqId,
			mouseLeaveEvent = 'mouseleave.' + uniqId,
			mouseMoveEvent = 'mousemove.' + uniqId,
			deviceOrientationEvent = 'deviceorientation.' + uniqId,
			visibilityChangeEvent = visibilityEvent + '.' + uniqId,
			tmpArray = [];

		// Expose properties
		self.initialized = 0,
		self.options = o,
		self.frame = $frame[0],
		self.slideElement = $slideElement[0],
		self.slides = items,
		self.position = pos,
		self.relative = rel,
		self.pages = pages,
		self.thumbnails = thumbnails,
		self.handlePosition = hPos,
		self.isFullScreen = 0,
		self.isPaused = 0,
		self.isFreezed = 0,
		self.isLocked = 0,
		self.progressElapsed = 0,
		self.uniqId = uniqId;

		/**
		 * (Re)Loading function.
		 *
		 * Populate arrays, set sizes, bind events, ...
		 * @param {Boolean} [isInit] Whether load is called from within self.init().
		 *
		 * @return {Object}
		 */
		function load(isInit) {
			// Local variables
			var lastSlidesCount = 0,
				lastPagesCount = pages[length],
				matchMedia = 0,
				slidesLength = 0;

			// Auto scale slider if options.autoScale is enabled
			if (o.autoScale) {
				scaleSlider();
			}

			last = {};

			// Save old position
			pos.old = $.extend({}, pos),

			// Reset global variables
			frameSize = $frame[o.navigation.horizontal ? width : height](),
			scrollbarSize = $scrollbar[o.navigation.horizontal ? width : height](),
			slideElementSize = $slideElement[o.navigation.horizontal ? 'outerWidth' : 'outerHeight'](),
			pages[length] = 0,

			// Set position limits & relatives
			pos.start = 0,
			pos.end = Math.max(slideElementSize - frameSize, 0);

			// Sizes & offsets for slide based navigations
			if (navigationType) {
				// Save the number of current slides
				lastSlidesCount = items[length];

				// Reset navigationType related variables
				$slides = $slideElement.children(o.navigation.slideSelector);
				items[length] = 0;

				// Needed variables
				var paddingStart = getPixel($slideElement, o.navigation.horizontal ? 'paddingLeft' : 'paddingTop'),
					paddingEnd = getPixel($slideElement, o.navigation.horizontal ? 'paddingRight' : 'paddingBottom'),
					borderBox = $($slides).css('boxSizing') === 'border-box',
					areFloated = $slides.css('float') !== 'none',
					ignoredMargin = 0,
					translateSize = 0,
					lastSlideIndex = $slides[length] - 1,
					lastSlide;

				// Reset slideElementSize
				slideElementSize = 0;

				if (o.watchCSS) {
					// Resize slideElement to fit all slides
					$slideElement[0].style[o.navigation.horizontal ? width : height] = frameSize + 'px';
				}

				var $slide, slideOptions, slideType, property, slideMarginStart, slideMarginEnd, slideSizeFull, slideSize, singleSpaced, slide, $otherCaptions;

				// Iterate through slides
				_each($slides, function(element, i){
					// Slide
					$slide = $(element),
					slideOptions = getInlineOptions($slide),
					slideType = getSlideType(slideOptions),
					property = o.watchCSS ? null : (slideOptions.size || o.navigation.slideSize),
					slideMarginStart = getPixel($slide, o.navigation.horizontal ? 'marginLeft' : 'marginTop'),
					slideMarginEnd = getPixel($slide, o.navigation.horizontal ? 'marginRight' : 'marginBottom'),
					slideSize = getSlideSize(element, property),
					slideSizeFull = slideSize + slideMarginStart + slideMarginEnd,
					singleSpaced = !slideMarginStart || !slideMarginEnd,
					slide = {};

					slide.element = element,
					slide.options = slideOptions,
					slide.type = slideType,
					slide.captions = [];

					if (o.deeplinking.linkID) {
						slide.ID = slideOptions.ID && rawurlencode(slideOptions.ID) || i;
					}

					slide.size = singleSpaced ? slideSize : slideSizeFull;
					slide.half = slide.size / 2;
					slide.start = slideElementSize + (singleSpaced ? slideMarginStart : 0);
					slide.center = slide.start - Math.round(frameSize / 2 - slide.size / 2);
					slide.end = slide.start - frameSize + slide.size;

					$otherCaptions = $slide.find('.' + namespace + 'Internally .' + minnamespace + 'Caption');

					// Add captions to slide object
					_each($slide.find('.' + minnamespace + 'Caption').add('[data-slide="' + i + '"] .' + minnamespace + 'Caption', $parent), function(caption, index){
						if ($otherCaptions.index(caption) != -1) {
							return true;
						}

						var $caption = $(caption),
							captionOptions = getInlineOptions($caption),
							captionAnimation = getCaptionKeyFrames($caption),
							captionAnimationOut = getCaptionKeyFrames($caption, true),
							captionStyles = $caption.data(minnamespace + 'styles'),
							captionData = {};

						captionData.element = caption;
						captionData.options = captionOptions;
						captionData.type = getSlideType(captionOptions);

						// Remove the empty keyframes
						if (captionAnimation[length]) {
							captionData.animation = filter.call(captionAnimation, function(value){
								return value && (value.style || value.delay);
							});
						}
						// Remove the empty keyframes
						if (captionAnimationOut[length]) {
							captionData.animationOut = filter.call(captionAnimationOut, function(value){
								return value && (value.style || value.delay);
							});
						}

						// Set isParallax value to slide if any captions has parallaxLevel options
						if (!slide.isParallax && captionOptions.parallaxLevel) {
							slide.isParallax = 1;
						}

						// Set hasCaptionMediaEnabled value to slide if any captions has media options
						if (!slide.hasCaptionMediaEnabled && (captionOptions.cover || captionOptions.video || captionOptions.source)) {
							slide.hasCaptionMediaEnabled = 1;
						}

						push.call(slide.captions, captionData);
					});

					// Normalize slide size for responsive purpose
					if(property) {
						$slide[0].style[o.navigation.horizontal ? width : height] = slideSize + 'px';
					}

					if (o.watchCSS && o.navigation.horizontal) {
						$slide[0].style['position'] = 'absolute';
						$slide[0].style['top'] = '0px';
						//$slide[0].style[transform] = 'translateX(' + translateSize + 'px)';
						$slide[0].style['left'] = translateSize + 'px';
						translateSize += slideSizeFull;
					}

					// Account for slideElementSize padding
					if (!i) {
						slideElementSize += paddingStart;
					}

					// Increment slideElement size for size of the active element
					slideElementSize += slideSizeFull;

					// Try to account for vertical margin collapsing in vertical mode
					// It's not bulletproof, but should work in 99% of cases
					if (!o.navigation.horizontal && !areFloated) {
						// Subtract smaller margin, but only when top margin is not 0, and this is not the first element
						if (slideMarginEnd && slideMarginStart && i > 0) {
							slideElementSize -= Math.min(slideMarginStart, slideMarginEnd);
						}
					}

					// Things to be done on last slide
					if (i === lastSlideIndex) {
						slide.end += paddingEnd;
						slideElementSize += paddingEnd;
						ignoredMargin = singleSpaced ? slideMarginEnd : 0;
					}

					// If is necessary to use matchMedia
					if ($.isArray(slideOptions.cover)) {
						matchMedia = 1;
					}

					// Add id to the slide element if deeplinking linkID & scrollTo is available
					if (o.deeplinking.linkID && o.deeplinking.scrollTo) {
						element.id = o.deeplinking.linkID + o.deeplinking.separator + slide.ID;
					}

					// Add slide object to slides array
					push.call(items, slide);
					lastSlide = slide;
				});

				if (!o.watchCSS) {
					// Resize slideElement to fit all slides
					$slideElement[0].style[o.navigation.horizontal ? width : height] = (borderBox ? slideElementSize : slideElementSize - paddingStart - paddingEnd) + 'px';
				}

				// Adjust internal slideElement size for last margin
				slideElementSize -= ignoredMargin;

				slidesLength = items[length];

				// Set limits
				if (slidesLength) {
					pos.start =  items[0][forceCenteredNav ? 'center' : 'start'];
					pos.end = forceCenteredNav ? lastSlide.center : frameSize < slideElementSize ? lastSlide.end : pos.start;
				} else {
					pos.start = pos.end = 0;
				}
			}

			// Calculate slideElement center position
			pos.center = Math.round(pos.end / 2 + pos.start / 2);

			// Update relative positions
			updateRelatives();

			// Scrollbar
			if ($handle[0] && scrollbarSize > 0) {
				// Stretch scrollbar handle to represent the visible area
				if (o.scrollBar.dynamicHandle) {
					handleSize = pos.start === pos.end ? scrollbarSize : Math.round(scrollbarSize * frameSize / slideElementSize);
					handleSize = within(handleSize, o.scrollBar.minHandleSize, scrollbarSize);
					$handle[0].style[o.navigation.horizontal ? width : height] = handleSize + 'px';
				} else {
					handleSize = $handle[o.navigation.horizontal ? 'outerWidth' : 'outerHeight']();
				}

				hPos.end = scrollbarSize - handleSize;

				if (!renderID) {
					syncScrollbar();
				}
			}

			// Pages
			if (frameSize > 0) {
				var tempPagePos = pos.start,
					pagesHtml = '';

				// Populate pages array
				if (navigationType) {
					for (var i = 0, slide; i < slidesLength; i++) {
						slide = items[i];

						if (forceCenteredNav) {
							push.call(pages, slide.center);
						} else if (slide.start + slide.size > tempPagePos && tempPagePos <= pos.end) {
							tempPagePos = slide.start;
							push.call(pages, tempPagePos);
							tempPagePos += frameSize;
							if (tempPagePos > pos.end && tempPagePos < pos.end + frameSize) {
								push.call(pages, pos.end);
							}
						}
					}
				} else {
					while (tempPagePos - frameSize < pos.end) {
						push.call(pages, tempPagePos);
						tempPagePos += frameSize;
					}
				}

				// Pages bar
				var pagesLength = pages[length];
				if ($pagesBar[0] && lastPagesCount !== pagesLength) {
					for (var i = 0; i < pagesLength; i++) {
						pagesHtml += o.pages.pageBuilder.call(self, i);
					}
					$pages = $pagesBar.html(pagesHtml).children();
					$pages.eq(rel.activePage).addClass(o.classes.activeClass);
				}
			}

			// Thumbnails
			if (slidesLength > 0 && (!self.initialized || (self.initialized && inserted))) {
				syncThumbnailsbar();
			}

			// Extend relative variables object with some useful info
			rel.slideElementSize = slideElementSize;
			rel.frameSize = frameSize;
			rel.scrollbarSize = scrollbarSize;
			rel.handleSize = handleSize;

			if (isInit && o.startRandom) {
				o.startAt = Math.floor(Math.random() * items[length]);
			}

			// Activate requested position
			if (navigationType) {
				if (isInit && o.startAt != null) {
					activate(o.startAt);
					self[centeredNav ? 'toCenter' : 'toStart'](o.startAt, 1);
				}
				// Fix possible overflowing
				var activeSlide = items[rel.activeSlide];
				slideTo(centeredNav && activeSlide ? activeSlide.center : within(pos.destination, pos.start, pos.end), 1);
			} else {
				if (isInit) {
					if (o.startAt != null) slideTo(o.startAt, 1);
				} else {
					// Fix possible overflowing
					slideTo(within(pos.destination, pos.start, pos.end), 1);
				}
			}

			// Set slides cover & icons
			if(!self.initialized || (resizeID && matchMedia) || (self.initialized && inserted)) {
				setSlidesCovers();
				if(!resizeID) {
					setSlidesIcons();
				}
			}

			if (o.autoResize) {
				resizeFrame(within(rel.activeSlide, 0, items[length]), 1);
			}

			// Reposition slides contents
			if(self.initialized) {
				repositionCovers();
			}

			// Synchronize states
			updateButtonsState();
			syncPagesbar();

			// Trigger :load event
			trigger('load');

			return self;
		}
		self.reload = load;

		/**
		 * Animate to a position.
		 *
		 * @param {Int}  newPos    New position.
		 * @param {Bool} immediate Reposition immediately without an animation.
		 * @param {Bool} dontAlign Do not align slides, use the raw position passed in first argument.
		 *
		 * @return {Void}
		 */
		function slideTo(newPos, immediate, dontAlign) {
			// Align slides
			if (navigationType && dragging.released && !dontAlign) {
				var tempRel = getRelatives(newPos);

				if (o.navigation.freeScroll) {
					if (forceCenteredNav && o.navigation.activateMiddle) {
						activate(tempRel.centerSlide);
					}
				} 
				else {
					var isNotBordering = newPos > pos.start && newPos < pos.end;

					if (centeredNav) {
						if (isNotBordering) {
							newPos = items[tempRel.centerSlide].center;
						}
						if (forceCenteredNav && o.navigation.activateMiddle) {
							activate(tempRel.centerSlide);
						}
					} else if (isNotBordering) {
						newPos = items[tempRel.firstSlide].start;
					}
				}
			}

			// Handle overflowing position limits
			if (dragging.init && dragging.slideElement && o.dragging.elasticBounds) {
				if (newPos > pos.end) {
					newPos = pos.end + (newPos - pos.end) / 6;
				} else if (newPos < pos.start) {
					newPos = pos.start + (newPos - pos.start) / 6;
				}
			} else {
				newPos = within(newPos, pos.start, pos.end);
			}

			// Update the animation object
			animation.start = _now();
			animation.time = 0;
			animation.from = pos.current;
			animation.to = newPos;
			animation.delta = newPos - pos.current;
			animation.tweesing = dragging.tweese || dragging.init && !dragging.slideElement;
			animation.immediate = !animation.tweesing && (immediate || dragging.init && dragging.slideElement || !o.speed);

			// Reset dragging tweesing request
			dragging.tweese = 0;

			// Start animation rendering
			if (newPos !== pos.destination) {
				pos.destination = newPos;
				// Trigger :change event
				trigger('change');
				if (!renderID) {
					render();
				}
			}

			// Reset next cycle timeout
			resetCycle();

			// Synchronize states
			updateRelatives();
			updateButtonsState();
			syncPagesbar();
		}

		/**
		 * Render animation frame.
		 *
		 * @return {Void}
		 */
		function render() {
			// If first render call, wait for next animationFrame
			if (!renderID) {
				renderID = requestAnimationFrame(render);
				if (dragging.released) {
					// Trigger :moveStart event
					trigger('moveStart');
				}
				return;
			}

			// If immediate repositioning is requested, don't animate.
			if (animation.immediate) {
				pos.current = animation.to;
			}
			// Use tweesing for animations without known end point
			else if (animation.tweesing) {
				animation.tweeseDelta = animation.to - pos.current;
				// Fuck Zeno's paradox
				if (Math.abs(animation.tweeseDelta) < 0.1) {
					pos.current = animation.to;
				} else {
					pos.current += animation.tweeseDelta * (dragging.released ? o.dragging.swingSpeed : o.dragging.syncSpeed);
				}
			}
			// Use tweening for basic animations with known end point
			else {
				animation.time = Math.min(_now() - animation.start, o.speed);
				pos.current = animation.from + animation.delta * fxEasing(animation.time/o.speed, animation.time, 0, 1, o.speed);
			}

			// If there is nothing more to render break the rendering loop, otherwise request new animation frame.
			if (animation.to === pos.current) {
				pos.current = animation.to;
				dragging.tweese = renderID = 0;
			} else {
				renderID = requestAnimationFrame(render);
			}

			// Trigger :move event
			trigger('move');

			// Update slideElement position
			if (transform) {
				$slideElement[0].style[transform] = gpuAcceleration + (o.navigation.horizontal ? 'translateX' : 'translateY') + '(' + (-pos.current) + 'px)';
			} else {
				$slideElement[0].style[o.navigation.horizontal ? 'left' : 'top'] = -Math.round(pos.current) + 'px';
			}

			// When animation reached the end, and dragging is not active, trigger moveEnd
			if (!renderID && dragging.released) {
				// Set slides covers
				setSlidesCovers();

				// Trigger :moveEnd event
				trigger('moveEnd');
			}

			syncScrollbar();
		}

		/**
		 * Synchronizes scrollbar with the SLIDEELEMENT.
		 *
		 * @return {Void}
		 */
		function syncScrollbar() {
			if ($handle[length]) {
				hPos.current = pos.start === pos.end ? 0 : (((dragging.init && !dragging.slideElement) ? pos.destination : pos.current) - pos.start) / (pos.end - pos.start) * hPos.end;
				hPos.current = within(Math.round(hPos.current), hPos.start, hPos.end);
				if (last.hPos !== hPos.current) {
					last.hPos = hPos.current;
					if (transform) {
						$handle[0].style[transform] = gpuAcceleration + (o.navigation.horizontal ? 'translateX' : 'translateY') + '(' + hPos.current + 'px)';
					} else {
						$handle[0].style[o.navigation.horizontal ? 'left' : 'top'] = hPos.current + 'px';
					}
				}
			}
		}

		/**
		 * Synchronizes pagesbar with slideElement.
		 *
		 * @return {Void}
		 */
		function syncPagesbar() {
			if ($pages[0] && last.page !== rel.activePage) {
				last.page = rel.activePage;
				$pages.removeClass(o.classes.activeClass).eq(rel.activePage).addClass(o.classes.activeClass);
				// Trigger :activePage event
				trigger('activePage', last.page);
			}
		}

		/**
		 * Synchronizes thumbnailsbar.
		 *
		 * @return {Void}
		 */
		function syncThumbnailsbar() {
			var thumbnailsHtml = '';

			// Populate thumbnails array
			for (var i = 0, len = items[length], slide, thumbnail; i < len; i++) {
				slide = items[i],
				thumbnail = slide.options.thumbnail || slide.options.cover || 1;

				push.call(thumbnails, thumbnail);
				if ($thumbnailsBar[0] && thumbnail) {
					thumbnailsHtml += o.thumbnails.thumbnailBuilder.call(self, i, thumbnail);
				}
			}

			// Thumbnails bar
			if ($thumbnailsBar[0]) {
				$thumbnails = $thumbnailsBar.html(thumbnailsHtml).children();

				if (o.thumbnails.thumbnailNav) {
					if (thumbnailNav) {
						thumbnailNav.destroy();
					}
					else {
						$.extend(true, thumbnailNavOptions, {
							moveBy: o.moveBy,
							speed: type(o.thumbnails.speed) !== 'undefined' ? o.thumbnails.speed : o.speed,
							easing: o.easing,
							startAt: o.startAt,
							watchCSS: o.thumbnails.watchCSS,

							// Navigation options
							navigation: {
								horizontal: o.thumbnails.horizontal,
								navigationType: o.thumbnails.thumbnailNav,
								slideSize: o.thumbnails.thumbnailSize,
								activateOn: o.thumbnails.activateOn
							},

							// Scrolling options
							scrolling: {
								scrollBy: o.thumbnails.scrollBy
							},

							// Dragging options
							dragging: {
								mouseDragging: o.thumbnails.mouseDragging,
								touchDragging: o.thumbnails.touchDragging,
								swingSpeed: o.dragging.swingSpeed,
								elasticBounds: o.dragging.elasticBounds
							}
						});
						
						thumbnailNav = new mightySlider($thumbnailsBar.parent(), thumbnailNavOptions, {
							moveStart: function(name) {
								this.isLocked = self.isLocked;
							},
							active: function(name, index) {
								if (index != rel.activeSlide) {
									self.activate(index);
								}
							}
						});
					}

					// Preload thumbnails then initialize thumbnails slider
					if (o.thumbnails.preloadThumbnails) {
						preloadimages(thumbnails).done(function() {
							thumbnailNav.init();
							setTimeout(function() {
								thumbnailNav.reload();
							});
						});
					}
					else {
						thumbnailNav.init();
						setTimeout(function() {
							thumbnailNav.reload();
						});
					}
				}
			}
		}

		/**
		 * Scale slider
		 *
		 * @return {Void}
		 */
		function scaleSlider() {
			var parentSize = $parent[width](),
				ratio = parentSize / autoScale[width];

			// Remember frame ratio
			frameRatio = ratio;

			$frame[height](autoScale[height] * ratio);
		}

		/**
		 * Returns the position object.
		 *
		 * @param {Mixed} slide
		 *
		 * @return {Object}
		 */
		self.getPosition = function (slide) {
			if (navigationType) {
				var index = getIndex(slide);
				return index !== -1 ? items[index] : false;
			} else {
				var $slide = $slideElement.find(slide).eq(0);

				if ($slide[0]) {
					var offset = o.navigation.horizontal ? $slide.offset().left - $slideElement.offset().left : $slide.offset().top - $slideElement.offset().top;
					var size = $slide[o.navigation.horizontal ? 'outerWidth' : 'outerHeight']();

					return {
						start: offset,
						center: offset - frameSize / 2 + size / 2,
						end: offset - frameSize + size,
						size: size
					};
				} else {
					return false;
				}
			}
		};

		/**
		 * Continuous move in a specified direction.
		 *
		 * @param  {Bool} forward True for forward movement, otherwise it'll go backwards.
		 * @param  {Int}  speed   Movement speed in pixels per frame. Overrides options.moveBy value.
		 *
		 * @return {Void}
		 */
		self.moveBy = function (speed) {
			move.speed = speed;
			// If already initiated, or there is nowhere to move, abort
			if (dragging.init || !move.speed || pos.current === (move.speed > 0 ? pos.end : pos.start)) {
				return;
			}
			// Initiate move object
			move.lastTime = _now();
			move.startPos = pos.current;
			// Set dragging as initiated
			continuousInit('button');
			dragging.init = 1;
			// Start movement
			// Trigger :moveStart event
			trigger('moveStart');
			cancelAnimationFrame(continuousID);
			moveLoop();
		};

		/**
		 * Continuous movement loop.
		 *
		 * @return {Void}
		 */
		function moveLoop() {
			// If there is nowhere to move anymore, stop
			if (!move.speed || pos.current === (move.speed > 0 ? pos.end : pos.start)) {
				self.stop();
			}
			// Request new move loop if it hasn't been stopped
			continuousID = dragging.init ? requestAnimationFrame(moveLoop) : 0;
			// Update move object
			move.now = _now();
			move.pos = pos.current + (move.now - move.lastTime) / 1000 * move.speed;
			// Slide
			slideTo(dragging.init ? move.pos : Math.round(move.pos));
			// Normally, this is triggered in render(), but if there
			// is nothing to render, we have to do it manually here.
			if (!dragging.init && pos.current === pos.destination) {
				// Trigger :moveEnd event
				trigger('moveEnd');
			}
			// Update times for future iteration
			move.lastTime = move.now;
		}

		/**
		 * Stops continuous movement.
		 *
		 * @return {Object}
		 */
		self.stop = function () {
			if (dragging.source === 'button') {
				dragging.init = 0;
				dragging.released = 1;
			}

			return self;
		};

		/**
		 * Activate previous slide.
		 *
		 * @param {Bool}  immediate Whether to reposition immediately in smart navigation.
		 *
		 * @return {Object}
		 */
		self.prev = function (immediate) {
			self.activate(rel.activeSlide - 1, immediate);

			return self;
		};

		/**
		 * Activate next slide.
		 *
		 * @param {Bool}  immediate Whether to reposition immediately in smart navigation.
		 *
		 * @return {Object}
		 */
		self.next = function (immediate) {
			self.activate(rel.activeSlide + 1, immediate);

			return self;
		};

		/**
		 * Activate previous page.
		 *
		 * @param {Bool}  immediate Whether to reposition immediately in smart navigation.
		 *
		 * @return {Object}
		 */
		self.prevPage = function (immediate) {
			self.activatePage(rel.activePage - 1, immediate);

			return self;
		};

		/**
		 * Activate next page.
		 *
		 * @param {Bool}  immediate Whether to reposition immediately in smart navigation.
		 *
		 * @return {Object}
		 */
		self.nextPage = function (immediate) {
			self.activatePage(rel.activePage + 1, immediate);

			return self;
		};

		/**
		 * Slide slideElement by amount of pixels.
		 *
		 * @param {Int}  delta     Difference in position. Positive means forward, negative means backward.
		 * @param {Bool} immediate Reposition immediately without an animation.
		 *
		 * @return {Void}
		 */
		self.slideBy = function (delta, immediate) {
			if (!delta) {
				return;
			}
			if (navigationType) {
				self[centeredNav ? 'toCenter' : 'toStart'](
					within((centeredNav ? rel.centerSlide : rel.firstSlide) + o.scrolling.scrollBy * delta, 0, items[length])
				);
			} else {
				slideTo(pos.destination + delta, immediate);
			}
		};

		/**
		 * Animate slideElement to a specific position.
		 *
		 * @param {Int}  position       New position.
		 * @param {Bool} immediate Reposition immediately without an animation.
		 *
		 * @return {Object}
		 */
		self.slideTo = function (position, immediate) {
			slideTo(position, immediate);

			return self;
		};

		/**
		 * Core method for handling `toLocation` methods.
		 *
		 * @param  {String} location
		 * @param  {Mixed}  slide
		 * @param  {Bool}   immediate
		 *
		 * @return {Void}
		 */
		function to(location, slide, immediate) {
			// Optional arguments logic
			if (type(slide) === 'boolean') {
				immediate = slide;
				slide = undefined;
			}

			if (slide === undefined) {
				slideTo(pos[location], immediate);
			}
			else {
				// You can't align slides to sides of the frame
				// when centered navigation type is enabled
				if (centeredNav && location !== 'center') {
					return;
				}

				var slideObj = self.getPosition(slide);
				if (slideObj) {
					slideTo(slideObj[location], immediate, !centeredNav);
				}
			}
		}

		/**
		 * Animate element or the whole slideElement to the start of the frame.
		 *
		 * @param {Mixed} slide      Slide DOM element, or index starting at 0. Omitting will animate slideElement.
		 * @param {Bool}  immediate Reposition immediately without an animation.
		 *
		 * @return {Object}
		 */
		self.toStart = function (slide, immediate) {
			to('start', slide, immediate);

			return self;
		};

		/**
		 * Animate element or the whole slideElement to the end of the frame.
		 *
		 * @param {Mixed} slide      Slide DOM element, or index starting at 0. Omitting will animate slideElement.
		 * @param {Bool}  immediate Reposition immediately without an animation.
		 *
		 * @return {Object}
		 */
		self.toEnd = function (slide, immediate) {
			to('end', slide, immediate);

			return self;
		};

		/**
		 * Animate element or the whole slideElement to the center of the frame.
		 *
		 * @param {Mixed} slide      Slide DOM element, or index starting at 0. Omitting will animate slideElement.
		 * @param {Bool}  immediate Reposition immediately without an animation.
		 *
		 * @return {Object}
		 */
		self.toCenter = function (slide, immediate) {
			to('center', slide, immediate);

			return self;
		};

		/**
		 * Get the index of an slide in slideElement.
		 *
		 * @param {Mixed} slide     Slide DOM element.
		 *
		 * @return {Int}  Slide     index, or -1 if not found.
		 */
		function getIndex(slide) {
			if (type(slide) !== 'undefined') {
				if(is_numeric(slide)) {
					if (slide >= 0 && slide < items[length]) {
						return slide;
					}
					else if (o.navigation.loop) {
						if (slide < 0) {
							return items[length] - 2 - slide;
						}
						else if (slide >= items[length]) {
							return slide - items[length];
						}
					}
				}
				else {
					return $slides.index(slide);
				}
			}

			return -1;
		}
		// Expose getIndex without lowering the compressibility of it,
		// as it is used quite often throughout mightySlider.
		self.getIndex = getIndex;

		/**
		 * Get index of an slide in slideElement based on a variety of input types.
		 *
		 * @param  {Mixed} slide   DOM element, positive or negative integer.
		 *
		 * @return {Int}   Slide   index, or -1 if not found.
		 */
		function getRelativeIndex(slide) {
			return getIndex(is_numeric(slide) && slide < 0 ? slide + items[length] : slide);
		}

		/**
		 * Activates an slide.
		 *
		 * @param  {Mixed} slide       Slide DOM element, or index starting at 0.
		 *
		 * @return {Mixed} Activated   slide index or false on fail.
		 */
		function activate(slide) {
			var index = getIndex(slide),
				lastActive = rel.activeSlide;

			if (!navigationType || index < 0 || self.isLocked) {
				return false;
			}

			// Update classes, last active index, and trigger active event only when there
			// has been a change. Otherwise just return the current active index.
			if (last.active !== index) {
				var slideData = items[index],
					captions = slideData.captions;

				scrollParallaxCaptions = [];
				scrollParallaxSlide = null;

				// Reset cycling progress time elapsed
				if (!resizeID) {
					self.progressElapsed = 0;
				}

				// Prevent cycling loop
				if (!o.cycling.loop && index >= items[length] - 1) {
					self.pause();
				}

				// Update classes
				$slides.eq(rel.activeSlide).removeClass(o.classes.activeClass);
				$slides.eq(index).addClass(o.classes.activeClass);

				// If captions in active slide are parallax
				if (items[lastActive] && items[lastActive].isParallax) {
					$parent.off('.' + uniqId);
					$win.off(deviceOrientationEvent);
				}

				if (slideData.isParallax) {
					// Find alowed parallax captions
					parallax.parallaxCaptions = filter.call(captions, function (e, i, arr) {
						return !!e.options.parallaxLevel;
					});

					if (!supportTouch) {
						// Add :mouseenter event to the $parent
						$parent.on(mouseEnterEvent, function (event) {
							parallax.source = 'mouse';

							// Local variables
							var target = $parent[0],
								offset = getOffset(event.originalEvent, target),
								rect = target.getBoundingClientRect(),
								widthHalf = rect[width] / 2,
								heightHalf = rect[height] / 2;

							// Add :mousemove event to the $parent
							$parent.off(mouseLeaveEvent).on(mouseMoveEvent, function (e) {
								// Calculate the X & Y differences from started axises
								offset = getOffset(e.originalEvent, target);
								parallaxTo.X = offset.x - widthHalf,
								parallaxTo.Y = offset.y - heightHalf;

								// Handle parallax effect for captions
								parallaxCaptions();
							}).one(mouseLeaveEvent, function () {
								$parent.off(mouseMoveEvent);

								// Normalize parallax effect for captions
								if (o.parallax.revert) {
									parallaxTo.X = 0,
									parallaxTo.Y = 0;

									revertParallax();
								}
							});
						}).trigger(mouseEnterEvent);
					}
					else if (orientationSupport) {
						$win.on(deviceOrientationEvent, function(e) {
							var event = e.originalEvent;

							// Validate event properties.
							if (type(event) !== 'undefined' && event.beta !== null && event.gamma !== null) {
								parallax.source = 'orientation';

								// Extract Rotation
								switch (orientation) {
									case 0:
									parallaxTo.X = event.gamma,
									parallaxTo.Y = event.beta;
									break;

									case 180:
									parallaxTo.X = -event.gamma,
									parallaxTo.Y = -event.beta;
									break;

									case -90:
									parallaxTo.X = -event.beta,
									parallaxTo.Y = event.gamma;
									break;

									case 90:
									parallaxTo.X = event.beta,
									parallaxTo.Y = -event.gamma;
									break;
								}

								parallaxTo.X = parallaxTo.X * 12,
								parallaxTo.Y = parallaxTo.Y * 12;

								// Handle parallax effect for captions
								parallaxCaptions();
							}
						});
					}
				}
				else {
					parallax = {};
				}

				// Clear previous slide captions
				if (!resizeID) {
					clearCaptions(last.active);
				}

				last.active = rel.activeSlide = index;

				updateButtonsState();

				// Remove previous media content
				if (!resizeID && mediaEnabled) {
					removeContent();
				}

				// Clear caption timing if available
				if (captionID) {
					clearTimeout(captionID);
				}

				// Render captions in the current active slide
				if (captions[length] && !resizeID) {
					// Show loader
					var loader = showLoader($slides.eq(index));

					$.when(loadSlide(index)).then(function() {
						captionID = setTimeout(function () {
							clearTimeout(captionID);
							renderCaptions(index);
						}, lastActive < 0 ? 0 : o.speed + 20);

						// Hide loader
						hideLoader(loader);
					});
				}
				else {
					captionRendered = -1;
				}

				// Change Hashtag
				if (o.deeplinking.linkID && !resizeID && !hashLock && self.initialized) {
					changeHashtag(index);
				}

				// Resize the FRAME based on slide size
				if (o.autoResize) {
					resizeFrame(index);
				}

				// Find scaler elements
				scalers = $slides.get(index).getElementsByClassName(minnamespace + 'Scaler');
				scalersHandler($frame, scalers);

				// Trigger :active event
				trigger('active', index);
			}

			return index;
		}

		/**
		 * Activates an slide and helps with further navigation when options.navigation.smart is enabled.
		 *
		 * @param {Mixed} slide      Slide DOM element, or index starting at 0.
		 * @param {Bool}  immediate  Whether to reposition immediately in smart navigation.
		 *
		 * @return {Object}
		 */
		self.activate = function (slide, immediate) {
			var index = activate(slide);

			// Smart navigation
			if (o.navigation.smart && index !== false) {
				// When centeredNav is enabled, center the element.
				// Otherwise, determine where to position the element based on its current position.
				// If the element is currently on the far end side of the frame, assume that user is
				// moving forward and animate it to the start of the visible frame, and vice versa.
				if (centeredNav) {
					self.toCenter(index, immediate);
				}
				else if (index >= rel.lastSlide) {
					self.toStart(index, immediate);
				}
				else if (index <= rel.firstSlide) {
					self.toEnd(index, immediate);
				}
				else {
					resetCycle();
				}
			}

			return self;
		};

		/**
		 * Activates a page.
		 *
		 * @param {Int}  index     Page index, starting from 0.
		 * @param {Bool} immediate Whether to reposition immediately without animation.
		 *
		 * @return {Object}
		 */
		self.activatePage = function (index, immediate) {
			if (self.isLocked) {
				return self;
			}

			if (is_numeric(index)) {
				// Reset cycling progress time elapsed
				if (!resizeID) {
					self.progressElapsed = 0;
				}

				// Prevent cycling loop
				if (!o.cycling.loop && index >= pages[length] - 1) {
					self.pause();
				}

				if (o.navigation.loop) {
					if (index < 0) {
						index = pages[length] - 2 - index;
					}
					else if (index >= pages[length]) {
						index = index - pages[length];
					}
				}

				slideTo(pages[within(index, 0, pages[length] - 1)], immediate);
			}

			return self;
		};

		/**
		 * Return relative positions of slides based on their visibility within FRAME.
		 *
		 * @param {Int} slideElementPos Position of slideElement.
		 *
		 * @return {Void}
		 */
		function getRelatives(slideElementPos) {
			slideElementPos = within(is_numeric(slideElementPos) ? slideElementPos : pos.destination, pos.start, pos.end);

			var relatives = {},
				centerOffset = forceCenteredNav ? 0 : frameSize / 2;

			// Determine active page
			for (var p = 0, pl = pages[length]; p < pl; p++) {
				if (slideElementPos >= pos.end || p === pages[length] - 1) {
					relatives.activePage = pages[length] - 1;
					break;
				}

				if (slideElementPos <= pages[p] + centerOffset) {
					relatives.activePage = p;
					break;
				}
			}

			// Relative slide indexes
			if (navigationType) {
				var first = false,
					last = false,
					center = false;

				// From start
				for (var i = 0, il = items[length]; i < il; i++) {
					// First slide
					if (first === false && slideElementPos <= items[i].start + items[i].half) {
						first = i;
					}

					// Center slide
					if (center === false && slideElementPos <= items[i].center + items[i].half) {
						center = i;
					}

					// Last slide
					if (i === il - 1 || slideElementPos <= items[i].end + items[i].half) {
						last = i;
						break;
					}
				}

				// Safe assignment, just to be sure the false won't be returned
				relatives.firstSlide = is_numeric(first) ? first : 0;
				relatives.centerSlide = is_numeric(center) ? center : relatives.firstSlide;
				relatives.lastSlide = is_numeric(last) ? last : relatives.centerSlide;
			}

			return relatives;
		}

		/**
		 * Update object with relative positions.
		 *
		 * @param {Int} newPos
		 *
		 * @return {Void}
		 */
		function updateRelatives(newPos) {
			$.extend(rel, getRelatives(newPos));
		}

		/**
		 * Disable navigation buttons when needed.
		 *
		 * Adds disabledClass, and when the button is <button> or <input>, activates :disabled state.
		 *
		 * @return {Void}
		 */
		function updateButtonsState() {
			var isStart = pos.destination <= pos.start,
				isEnd = pos.destination >= pos.end,
				slideElementPosState = isStart ? 1 : (isEnd ? 2 : 3);

			// Update paging buttons only if there has been a change in slideElement position
			if (last.slideElementPosState !== slideElementPosState) {
				last.slideElementPosState = slideElementPosState;

				if (!o.navigation.loop) {
					$prevPageButton.prop('disabled', isStart)[isStart ? 'addClass' : 'removeClass'](o.classes.disabledClass);
					$nextPageButton.prop('disabled', isEnd)[isEnd ? 'addClass' : 'removeClass'](o.classes.disabledClass);
				}
				$backwardButton.prop('disabled', isStart)[isStart ? 'addClass' : 'removeClass'](o.classes.disabledClass);
				$forwardButton.prop('disabled', isEnd)[isEnd ? 'addClass' : 'removeClass'](o.classes.disabledClass);
			}

			// Forward & Backward buttons need a separate state caching because we cannot "property disable"
			// them while they are being used, as disabled buttons stop emitting mouse events.
			if (last.fwdbwdState !== slideElementPosState && dragging.released) {
				last.fwdbwdState = slideElementPosState;

				$backwardButton.prop('disabled', isStart);
				$forwardButton.prop('disabled', isEnd);
			}

			// Slide navigation
			if (navigationType && !o.navigation.loop) {
				var isFirst = rel.activeSlide === 0,
					isLast = rel.activeSlide >= items[length] - 1,
					slidesButtonState = isFirst ? 1 : isLast ? 2 : 3;

				if (last.slidesButtonState !== slidesButtonState) {
					last.slidesButtonState = slidesButtonState;

					$prevButton[isFirst ? 'addClass' : 'removeClass'](o.classes.disabledClass).prop('disabled', isFirst);
					$nextButton[isLast ? 'addClass' : 'removeClass'](o.classes.disabledClass).prop('disabled', isLast);
				}
			}
		}

		/**
		 * Resume cycling.
		 *
		 * @param {Int} priority Resume pause with priority lower or equal than this. Used internally for pauseOnHover.
		 *
		 * @return {Object}
		 */
		self.resume = function (priority) {
			if (!o.cycling.cycleBy || !o.cycling.pauseTime || o.cycling.cycleBy === 'slides' && !items[0] || priority < self.isPaused) {
				return self;
			}

			self.isPaused = 0;

			if (cycleID) {
				cycleID = cancelAnimationFrame(cycleID);
			}
			else {
				// Add paused class
				$parent.removeClass(o.classes.isPaused);

				// Trigger :resume event
				trigger('resume');
			}

			var timeOut = items[rel.activeSlide] && items[rel.activeSlide].options.pauseTime || o.cycling.pauseTime,
				cyclingActivate = function () {
					switch (o.cycling.cycleBy) {
						case 'slides':
							self.activate(rel.activeSlide >= items[length] - 1 ? 0 : rel.activeSlide + 1);
							break;

						case 'pages':
							self.activatePage(rel.activePage >= pages[length] - 1 ? 0 : rel.activePage + 1);
							break;
					}
				},
				timestamp,
				requestHandler = function () {
					timestamp = _now();

					// Calculate progress elapsed time
					self.progressElapsed += timestamp - (cycleLastTime || _now()),
					cycleLastTime = timestamp;

					// Trigger :progress event
					trigger('progress', self.progressElapsed / timeOut);

					if (self.progressElapsed >= timeOut) {
						// Activate slides/pages by cycling
						cyclingActivate();

						requestHandler = null;
					}
					else {
						// Call next frame
						cycleID = requestAnimationFrame(requestHandler);
					}
				};

			// Call first frame
			cycleID = requestAnimationFrame(requestHandler);

			return self;
		};

		/**
		 * Pause cycling.
		 *
		 * @param {Int} priority Pause priority. 100 is default. Used internally for pauseOnHover.
		 *
		 * @return {Object}
		 */
		self.pause = function (priority) {
			if (priority < self.isPaused) {
				return self;
			}

			self.isPaused = priority || 100;

			if (cycleID) {
				cycleID = cancelAnimationFrame(cycleID);
				cycleLastTime = 0;

				// Add paused class
				$parent.addClass(o.classes.isPaused);

				// Trigger :pause event
				trigger('pause');
			}

			return self;
		};

		/**
		 * Toggle cycling.
		 *
		 * @return {Object}
		 */
		self.toggleCycling = function () {
			self[cycleID ? 'pause' : 'resume']();

			return self;
		};

		/**
		 * Enter fullscreen.
		 *
		 * @return {Object}
		 */
		self.enterFullScreen = function () {
			if (!self.isFullScreen) {
				$parent.addClass(o.classes.isInFullScreen);

				if (screenfull.enabled) {
					screenfull.request($parent[0]);
				}
				else {
					$win.triggerHandler('resize');
				}
				self.isFullScreen = 1;

				// Trigger :enterFullScreen event
				trigger('enterFullScreen');
			}

			return self;
		};

		/**
		 * Exit from fullscreen.
		 *
		 * @return {Object}
		 */
		self.exitFullScreen = function () {
			if (self.isFullScreen) {
				$parent.removeClass(o.classes.isInFullScreen);

				if (screenfull.enabled) {
					screenfull.exit($parent[0]);
				}
				else {
					$win.triggerHandler('resize');
				}
				self.isFullScreen = 0;

				// Trigger :exitFullScreen event
				trigger('exitFullScreen');
			}

			return self;
		};

		/**
		 * Toggle fullscreen.
		 *
		 * @return {Object}
		 */
		self.toggleFullScreen = function () {
			self[self.isFullScreen ? 'exitFullScreen' : 'enterFullScreen']();

			return self;
		};

		/**
		 * Updates a signle or multiple option values.
		 *
		 * @param {Mixed} name  Name of the option that should be updated, or object that will extend the options.
		 * @param {Mixed} value New option value.
		 *
		 * @return {Object}
		 */
		self.set = function (name, value) {
			if (isObject(name)) {
				$.extend(true, o, name);
			}
			else if (hasOwnProperty.call(o, name)) {
				o[name] = value;
			}

			// Set thumbnails options if thumbnail navigation is available
			if (thumbnailNav) {
				$.extend(true, thumbnailNavOptions, {
					moveBy: o.moveBy,
					speed: type(o.thumbnails.speed) !== 'undefined' ? o.thumbnails.speed : o.speed,
					easing: o.easing,
					startAt: o.startAt,

					// Navigation options
					navigation: {
						horizontal: o.thumbnails.horizontal,
						navigationType: o.thumbnails.thumbnailNav,
						slideSize: o.thumbnails.thumbnailSize,
						activateOn: o.thumbnails.activateOn
					},

					// Scrolling options
					scrolling: {
						scrollBy: o.thumbnails.scrollBy
					},

					// Dragging options
					dragging: {
						mouseDragging: o.thumbnails.mouseDragging,
						touchDragging: o.thumbnails.touchDragging,
						swingSpeed: o.dragging.swingSpeed,
						elasticBounds: o.dragging.elasticBounds
					}
				});

				thumbnailNav.set(thumbnailNavOptions);
			}

			// Reload
			load();

			return self;
		};

		/**
		 * Add one or multiple slides to the slideElement end, or a specified position index.
		 *
		 * @param {Mixed} element Node element, or HTML string.
		 * @param {Int}   index   Index of a new slide position. By default slide is appended at the end.
		 *
		 * @return {Object}
		 */
		self.add = function (element, index) {
			var $element = $(element);

			if (navigationType) {
				// Insert the element(s)
				if (type(index) === 'undefined' || !items[0] || index >= items[length]) {
					$element.appendTo($slideElement);
				}
				else if (items[length]) {
					$element.insertBefore(items[index].element);
				}

				$element.addClass(minnamespace + 'Slide');

				// Adjust the activeSlide index
				if (index <= rel.activeSlide) {
					last.active = rel.activeSlide += $element[length];
				}
			} else {
				$slideElement.append($element);
			}

			// Mark as inserted for load new slide content
			inserted = 1;

			// Reload
			load();

			// Unmark inserted
			inserted = 0;

			return self;
		};

		/**
		 * Remove an slide from slideElement.
		 *
		 * @param {Mixed} element Slide index, or DOM element.
		 * @param {Int}   index   Index of a new slide position. By default slide is appended at the end.
		 *
		 * @return {Object}
		 */
		self.remove = function (element) {
			if (navigationType) {
				var index = getRelativeIndex(element);

				if (index > -1) {
					// Remove the element
					$slides.eq(index).remove();

					// If the current slide is being removed, activate new one after reload
					var reactivate = index === rel.activeSlide && !(forceCenteredNav && o.navigation.activateMiddle);

					// Adjust the activeSlide index
					if (index < rel.activeSlide || rel.activeSlide >= items[length] - 1) {
						last.active = --rel.activeSlide;
					}

					// Reload
					load();

					// Activate new slide at the removed position if the current active got removed
					if (reactivate) {
						self.activate(rel.activeSlide);
					}
				}
			} else {
				$(element).remove();
				load();
			}

			return self;
		};

		/**
		 * Helps re-arranging slides.
		 *
		 * @param  {Mixed} slide     Slide DOM element, or index starting at 0. Use negative numbers to select slides from the end.
		 * @param  {Mixed} position Slide insertion anchor. Accepts same input types as slide argument.
		 * @param  {Bool}  after    Insert after instead of before the anchor.
		 *
		 * @return {Void}
		 */
		function move(slide, position, after) {
			slide = getRelativeIndex(slide);
			position = getRelativeIndex(position);

			// Move only if there is an actual change requested
			if (slide > -1 && position > -1 && slide !== position && (!after || position !== slide - 1) && (after || position !== slide + 1)) {
				$slides.eq(slide)[after ? 'insertAfter' : 'insertBefore'](items[position].element);

				var shiftStart = slide < position ? slide : (after ? position : position - 1),
					shiftEnd = slide > position ? slide : (after ? position + 1 : position),
					shiftsUp = slide > position;

				// Update activeSlide index
				if (slide === rel.activeSlide) {
					last.active = rel.activeSlide = after ? (shiftsUp ? position + 1 : position) : (shiftsUp ? position : position - 1);
				}
				else if (rel.activeSlide > shiftStart && rel.activeSlide < shiftEnd) {
					last.active = rel.activeSlide += shiftsUp ? 1 : -1;
				}

				// Reload
				load();
			}
		}

		/**
		 * Move slide after the target anchor.
		 *
		 * @param  {Mixed} slide     Slide to be moved. Can be DOM element or slide index.
		 * @param  {Mixed} position Target position anchor. Can be DOM element or slide index.
		 *
		 * @return {Object}
		 */
		self.moveAfter = function (slide, position) {
			move(slide, position, 1);

			return self;
		};

		/**
		 * Move slide before the target anchor.
		 *
		 * @param  {Mixed} slide     Slide to be moved. Can be DOM element or slide index.
		 * @param  {Mixed} position Target position anchor. Can be DOM element or slide index.
		 *
		 * @return {Object}
		 */
		self.moveBefore = function (slide, position) {
			move(slide, position);

			return self;
		};

		/**
		 * Registers callbacks to be executed only once.
		 *
		 * @param  {Mixed} name  Event name, or callbacks map.
		 * @param  {Mixed} fn    Callback, or an array of callback functions.
		 *
		 * @return {Object}
		 */
		self.one = function (name, fn) {
			function proxy() {
				fn.apply(self, arguments);
				self.off(name, proxy);
			}
			self.on(name, proxy);

			return self;
		};

		/**
		 * Registers callbacks.
		 *
		 * @param  {Mixed} name  Event name, or callbacks map.
		 * @param  {Mixed} fn    Callback, or an array of callback functions.
		 *
		 * @return {Object}
		 */
		self.on = function (name, fn) {
			// Callbacks map
			if (type(name) === 'object') {
				for (var key in name) {
					if (hasOwnProperty.call(name, key)) {
						self.on(key, name[key]);
					}
				}
			// Callback
			}
			else if (type(fn) === 'function') {
				var names = name.split(' ');
				for (var n = 0, nl = names[length]; n < nl; n++) {
					callbacks[names[n]] = callbacks[names[n]] || [];
					if (callbackIndex(names[n], fn) === -1) {
						push.call(callbacks[names[n]], fn);
					}
				}
			// Callbacks array
			}
			else if (type(fn) === 'array') {
				for (var f = 0, fl = fn[length]; f < fl; f++) {
					self.on(name, fn[f]);
				}
			}

			return self;
		};

		/**
		 * Remove one or all callbacks.
		 *
		 * @param  {String} name Event name.
		 * @param  {Mixed}  fn   Callback, or an array of callback functions. Omit to remove all callbacks.
		 *
		 * @return {Object}
		 */
		self.off = function (name, fn) {
			if (fn instanceof Array) {
				for (var f = 0, fl = fn[length]; f < fl; f++) {
					self.off(name, fn[f]);
				}
			}
			else {
				var names = name.split(' ');
				for (var n = 0, nl = names[length]; n < nl; n++) {
					callbacks[names[n]] = callbacks[names[n]] || [];
					if (type(fn) === 'undefined') {
						callbacks[names[n]][length] = 0;
					}
					else {
						var index = callbackIndex(names[n], fn);
						if (index !== -1) {
							splice.call(callbacks[names[n]], index, 1);
						}
					}
				}
			}

			return self;
		};

		/**
		 * Returns callback array index.
		 *
		 * @param  {String}   name Event name.
		 * @param  {Function} fn   Function
		 *
		 * @return {Int} Callback array index, or -1 if isn't registered.
		 */
		function callbackIndex(name, fn) {
			for (var i = 0, l = callbacks[name][length]; i < l; i++) {
				if (callbacks[name][i] === fn) {
					return i;
				}
			}
			return -1;
		}

		/**
		 * Reset next cycle timeout.
		 *
		 * @return {Void}
		 */
		function resetCycle() {
			if (dragging.released && !self.isPaused) {
				self.resume();
			}
		}

		/**
		 * Calculate SLIDEELEMENT representation of handle position.
		 *
		 * @param  {Int} handlePos
		 *
		 * @return {Int}
		 */
		function handleToSlideElement(handlePos) {
			return Math.round(within(handlePos, hPos.start, hPos.end) / hPos.end * (pos.end - pos.start)) + pos.start;
		}

		/**
		 * Keeps track of a dragging delta history.
		 *
		 * @return {Void}
		 */
		function draggingHistoryTick() {
			// Looking at this, I know what you're thinking :) But as we need only 4 history states, doing it this way
			// as opposed to a proper loop is ~25 bytes smaller (when minified with GCC), a lot faster, and doesn't
			// generate garbage. The loop version would create 2 new variables on every tick. Unexaptable!
			dragging.history[0] = dragging.history[1];
			dragging.history[1] = dragging.history[2];
			dragging.history[2] = dragging.history[3];
			dragging.history[3] = dragging.delta;
		}

		/**
		 * Initialize continuous movement.
		 *
		 * @return {Void}
		 */
		function continuousInit(source) {
			dragging.released = 0;
			dragging.source = source;
			dragging.slideElement = source === 'slideElement';
		}

		/**
		 * Dragging initiator.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function dragInit(event) {
			var isTouch = event.type === 'touchstart';

			// Ignore when already in progress, or interactive element in non-touch navivagion
			if (dragging.init || mediaEnabled || !isTouch && isInteractive(event.target)) {
				return;
			}

			var source = event.data.source,
				isSlideElement = source === 'slideElement';

			// Handle dragging conditions
			if (source === 'handle' && (!o.scrollBar.dragHandle || hPos.start === hPos.end)) {
				return;
			}

			// slideElement dragging conditions
			if (isSlideElement && !(isTouch ? o.dragging.touchDragging : o.dragging.mouseDragging && event.which < 2)) {
				return;
			}

			// Reset dragging object
			continuousInit(source);

			// Properties used in dragHandler
			dragging.init = 0;
			dragging.$source = $(event.target);
			dragging.touch = isTouch;
			dragging.pointer = isTouch ? event.originalEvent.touches[0] : event;
			dragging.initX = dragging.pointer.pageX;
			dragging.initY = dragging.pointer.pageY;
			dragging.initPos = isSlideElement ? pos.current : hPos.current;
			dragging.initPage = rel.activePage;
			dragging.start = _now();
			dragging.time = 0;
			dragging.path = 0;
			dragging.delta = 0;
			dragging.locked = 0;
			dragging.history = [0, 0, 0, 0];
			dragging.pathToLock = isSlideElement ? isTouch ? $win[width]() / window.outerWidth * 10 : 10 : 0;

			// Bind dragging events
			$doc.on(isTouch ? dragTouchEvents : dragMouseEvents, dragHandler);

			// Pause ongoing cycle
			self.pause(1);

			// Add dragging class
			(isSlideElement ? $slideElement : $handle).addClass(o.classes.draggedClass);

			// Trigger :moveStart event
			trigger('moveStart');

			// Keep track of a dragging path history. This is later used in the
			// dragging release swing calculation when dragging slideElement.
			if (isSlideElement) {
				historyID = setInterval(draggingHistoryTick, 10);
			}
		}

		/**
		 * Handler for dragging scrollbar handle or SLIDEELEMENT.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function dragHandler(event) {
			dragging.released = event.type === 'mouseup' || event.type === 'touchend';
			dragging.pointer = dragging.touch ? event.originalEvent[dragging.released ? 'changedTouches' : 'touches'][0] : event;
			dragging.pathX = dragging.pointer.pageX - dragging.initX;
			dragging.pathY = dragging.pointer.pageY - dragging.initY;
			dragging.path = Math.sqrt(Math.pow(dragging.pathX, 2) + Math.pow(dragging.pathY, 2));
			dragging.delta = o.navigation.horizontal ? dragging.pathX : dragging.pathY;

			if (!dragging.released && dragging.path < 1) return;

			if (!dragging.init) {
				if (o.navigation.horizontal ? Math.abs(dragging.pathX) > Math.abs(dragging.pathY) : Math.abs(dragging.pathX) < Math.abs(dragging.pathY)) {
					dragging.init = 1;
				} else {
					return dragEnd();
				}
			}

			stopDefault(event);

			// Disable click on a source element, as it is unwelcome when dragging
			if (!dragging.locked && dragging.path > dragging.pathToLock && dragging.slideElement) {
				dragging.locked = 1;
				dragging.$source.on('click', disableOneEvent);
			}

			// Cancel dragging on release
			if (dragging.released) {
				dragEnd();

				// Adjust path with a swing on mouse release
				if (o.dragging.releaseSwing && dragging.slideElement) {
					dragging.swing = (dragging.delta - dragging.history[0]) * o.dragging.swingSync;
					dragging.delta += dragging.swing;
					dragging.tweese = Math.abs(dragging.swing) > 10;
				}
			}

			slideTo(dragging.slideElement ? (dragging.tweese && o.dragging.onePage ? pages[within(dragging.delta < 0 ? dragging.initPage + 1 : dragging.initPage - 1, 0, pages[length] - 1)] : Math.round(dragging.initPos - dragging.delta)) : handleToSlideElement(dragging.initPos + dragging.delta));
		}

		/**
		 * Stops dragging and cleans up after it.
		 *
		 * @return {Void}
		 */
		function dragEnd() {
			clearInterval(historyID);
			dragging.released = true;
			$doc.off(dragging.touch ? dragTouchEvents : dragMouseEvents, dragHandler);
			(dragging.slideElement ? $slideElement : $handle).removeClass(o.classes.draggedClass);

			// Make sure that disableOneEvent is not active in next tick.
			setTimeout(function () {
				dragging.$source.off('click', disableOneEvent);
			});

			// Normally, this is triggered in render(), but if there
			// is nothing to render, we have to do it manually here.
			if (pos.current === pos.destination && dragging.init) {
				trigger('moveEnd');
			}

			// Resume ongoing cycle
			self.resume(1);

			dragging.init = 0;
		}

		/**
		 * Check whether element is interactive.
		 *
		 * @return {Boolean}
		 */
		function isInteractive(element) {
			return ~_.inArray(element.nodeName, interactiveElements) || $(element).is(o.dragging.interactive);
		}

		/**
		 * Continuous movement cleanup on mouseup.
		 *
		 * @return {Void}
		 */
		function movementReleaseHandler() {
			self.stop();
			$doc.off('mouseup.' + namespace, movementReleaseHandler);
		}

		/**
		 * Buttons navigation handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function buttonsHandler(event) {
			stopDefault(event);

			switch (this) {
				case $forwardButton[0]:
				case $backwardButton[0]:
					self.moveBy($forwardButton.is(this) ? o.moveBy : -o.moveBy);
					$doc.on('mouseup.' + namespace, movementReleaseHandler);
					break;

				case $prevButton[0]:
					self.prev();
					break;

				case $nextButton[0]:
					self.next();
					break;

				case $prevPageButton[0]:
					self.prevPage();
					break;

				case $nextPageButton[0]:
					self.nextPage();
					break;

				case $fullScreenButton[0]:
					self.toggleFullScreen();
					break;
			}
		}

		/**
		 * Mouse wheel delta normalization.
		 *
		 * @param  {Event} event
		 *
		 * @return {Int}
		 */
		function normalizeWheelDelta(event) {
			// wheelDelta needed only for IE8-
			scrolling.curDelta = ((o.navigation.horizontal ? event.deltaY || event.deltaX : event.deltaY) || -event.wheelDelta);
			scrolling.curDelta /= event.deltaMode === 1 ? 3 : 100;
			if (!navigationType) {
				return scrolling.curDelta;
			}
			time = _now();
			if (scrolling.last < time - scrolling.resetTime) {
				scrolling.delta = 0;
			}
			scrolling.last = time;
			scrolling.delta += scrolling.curDelta;
			if (Math.abs(scrolling.delta) < 1) {
				scrolling.finalDelta = 0;
			} else {
				scrolling.finalDelta = Math.round(scrolling.delta / 1);
				scrolling.delta %= 1;
			}
			return scrolling.finalDelta;
		}

		/**
		 * Mouse scrolling handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function scrollHandler(event) {
			if (self.isLocked) {
				return self;
			}

			// Mark event as originating in a mightySlider instance
			event.originalEvent[namespace] = self;
			// Don't hijack global scrolling
			var time = _now();
			if (lastWheel + o.scrolling.hijack > time) {
				lastWheel = time;
				return;
			}

			// Ignore if there is no scrolling to be done
			if (!o.scrolling.scrollBy || o.scrolling.scrollBy == 0 || pos.start === pos.end) {
				return;
			}
			stopDefault(event, 1);
			self.slideBy(o.scrolling.scrollBy * normalizeWheelDelta(event.originalEvent));
		}

		/**
		 * Scrollbar click handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function scrollbarHandler(event) {
			// Only clicks on scroll bar. Ignore the handle.
			if (o.scrollBar.clickBar && event.target === $scrollbar[0]) {
				stopDefault(event);
				// Calculate new handle position and sync SLIDEELEMENT to it
				slideTo(handleToSlideElement((o.navigation.horizontal ? event.pageX - $scrollbar.offset().left : event.pageY - $scrollbar.offset().top) - handleSize / 2));
			}
		}

		/**
		 * Keyboard input handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function keyboardHandler(event) {
			if (!o.navigation.keyboardNavBy) {
				return;
			}

			switch (event.which) {
				// Left or Up
				case o.navigation.horizontal ? 37 : 38:
					stopDefault(event);
					self[o.navigation.keyboardNavBy === 'pages' ? 'prevPage' : 'prev']();
					break;

				// Right or Down
				case o.navigation.horizontal ? 39 : 40:
					stopDefault(event);
					self[o.navigation.keyboardNavBy === 'pages' ? 'nextPage' : 'next']();
					break;
			}
		}

		/**
		 * Slides icons click handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function iconsHandler(event) {
			var $this = $(this);

			if ($this.hasClass(minnamespace + 'Close')) {
				// Remove media content
				removeContent();
			}
			else {
				// Insert media content
				insertContent($this.parent()[0]);
			}

			dragEnd();

			return false;
		}

		/**
		 * Window resize handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function winResizeHandler() {
			if (resizeID) {
				resizeID = clearTimeout(resizeID);
			}

			// Trigger :beforeResize event
			trigger('beforeResize');

			resizeID = setTimeout(function () {
				self.reload();
				scalersHandler($frame, scalers);

				if (type(window.orientation) !== 'undefined') {
					orientation = window.orientation;
				}
				else {
					orientation = $win[height]() > $win[width]() ? 0 : 90;
				}

				// Trigger :resize event
				trigger('resize');
				resizeID = clearTimeout(resizeID);
			}, 100);
		}

		/**
		 * Page visibility change handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function visibilityChangeHandler() {
			// Check for: is visibility state hidden?
			var isHidden = visibilityHidden();

			if (isHidden) {
				// Freeze the slider
				self.freeze();
			}
			else {
				// Unfreeze the slider
				self.unFreeze();
			}
		}

		/**
		 * Window fullscreen change handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function winfullScreenHandler() {
			if (!screenfull.isFullscreen) {
				self.exitFullScreen();
			}
		}

		/**
		 * Click on slide activation handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function activateHandler(event) {
			/*jshint validthis:true */
			// Ignore clicks on interactive elements.
			if (isInteractive(this)) {
				event.stopPropagation();
				return;
			}

			// Accept only events from direct slideElement children.
			if (this.parentNode === $slideElement[0]) {
				self.activate(this);
			}
		}

		/**
		 * Click on page button handler.
		 *
		 * @param {Event} event
		 *
		 * @return {Void}
		 */
		function activatePageHandler() {
			/*jshint validthis:true */
			// Accept only events from direct pages bar children.
			if (this.parentNode === $pagesBar[0]) {
				self.activatePage($pages.index(this));
			}
		}

		/**
		 * Pause on hover handler.
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		function pauseOnHoverHandler(event) {
			if (o.cycling.pauseOnHover) {
				self[event.type === 'mouseenter' ? 'pause' : 'resume'](2);
			}
		}

		/**
		 * Trigger callbacks for event.
		 *
		 * @param  {...} arguments
		 *
		 * @return {Void}
		 */
		function trigger() {
			var args = arguments,
				name = args[0];

			if (callbacks[name]) {
				l = callbacks[name][length];
				// Callbacks will be stored and executed from a temporary array to not
				// break the execution queue when one of the callbacks unbinds itself.
				tmpArray[length] = 0;
				for (i = 0; i < l; i++) {
					push.call(tmpArray, callbacks[name][i]);
				}
				// Execute the callbacks
				for (i = 0; i < l; i++) {
					tmpArray[i].apply(self, args);
				}
			}
		}

		/**
		 * Get slide size in pixels.
		 *
		 * @param {Object}   slide    Slide DOM element.
		 * @param {Mixed}    property
		 *
		 * @return {Int}
		 */
		function getSlideSize(slide, property) {
			var result;

			if (property) {
				result = !is_numeric(property) && indexOf.call(property, '%') !== -1 ? percentToValue(property[replace]('%', ''), frameSize) : property;
			}
			else {
				var rect = slide.getBoundingClientRect();
				result = slide[o.navigation.horizontal ? 'offsetWidth' : 'offsetHeight'];
				//result = o.navigation.horizontal ? (rect[width] || rect.right - rect.left) : (rect[height] || rect.bottom - rect.top);
			}

			return parseFloat(result);
		}

		/**
		 * Load slide contents.
		 *
		 * @param  {Mixed} slide       Slide DOM element, or index starting at 0.
		 *
		 * @return {Void}
		 */
		function loadSlide(slide) {
			var deferred = $.Deferred(),
				index = getIndex(slide),
				slideData = items[index],
				element = slideData.element,
				slideLoaded = element.hasAttribute(minnamespace + 'slideloaded');

			// Trigger :beforeSlideLoad event
			trigger('beforeSlideLoad', index);

			// If slide loaded before then prevent pre-loading and trigger :slideLoaded
			if (slideLoaded) {
				// Trigger :slideLoaded event
				trigger('slideLoaded', index);
				deferred.resolve(index);

				return deferred;
			}

			var $slide = $(element),
			loaderFunc = function() {
				// Find all images urls in element and its children
				var images = findAllImages(element),
					len = images[length];

				// If slide has no images for pre-load then prevent pre-loading and trigger :slideLoaded
				if (len <= 0) {
					// set slideLoaded to the slide to remember that this slide has been preloaded before
					element.setAttribute(minnamespace + 'slideloaded', '1');

					// Trigger :slideLoaded event
					trigger('slideLoaded', index);
					deferred.resolve(index);

					return false;
				}

				preloadimages(images).done(function() {
					// set slideLoaded to the slide to remember that this slide has been preloaded before
					element.setAttribute(minnamespace + 'slideloaded', '1');

					// Trigger :slideLoaded event
					trigger('slideLoaded', index);
					deferred.resolve(index);
				});
			};

			if (slideData.hasCaptionMediaEnabled) {
				// Find media inserted captions
				var mediaCaptions = filter.call(slideData.captions, function (e, i, arr) {
					return (e.options.cover || e.options.video || e.options.source);
				}),
				inserted = mediaCaptions[length];

				for (var i = 0, len = mediaCaptions[length], caption, captionElement, $layerContainer, cover, icon, coverURL, isVideo, parsed; i < len; i++) {
					caption = mediaCaptions[i],
					captionElement = caption.element,
					$layerContainer = $('<div class="' + minnamespace + 'LayerContainer"></div>'),
					cover = caption.options.cover,

					// Detect caption icon
					icon = caption.type,

					// Set layer cover image URL
					coverURL = cover || parsePhotoURL(caption.options.video) && caption.options.video,
					isVideo = isObject(coverURL) || getTypeByExtension(coverURL) == 'video',
					parsed = parsePhotoURL(coverURL);
						
					$layerContainer.prependTo(captionElement);

					// If cover needed to be parsed
					if (parsed) {
						// Parse OEmbed URL via AJAX
						doAjax(parsed.oembed, function (data) {
							if (data) {
								// Set cover URL
								coverURL = data[parsed.inJSON];

								// If replace is needed
								if (parsed[replace]) {
									coverURL = coverURL[replace](parsed[replace].from, parsed[replace].to);
								}

								// Set cover image
								setCover({
									caption: caption,
									cover: coverURL,
									slideEl: $slide,
									insertEl: $layerContainer,
									callback: function() {
										inserted--;

										if (inserted <= len) {
											loaderFunc();
										}
									}
								});
							}
						});
					}
					else {
						// Set cover image
						setCover({
							caption: caption,
							cover: coverURL,
							isVideo: isVideo,
							slideEl: $slide,
							insertEl: $layerContainer,
							callback: function() {
								inserted--;

								if (inserted <= len) {
									loaderFunc();
								}
							}
						});
					}

					// Set layer icon if slide type is not image
					if (icon !== 'image') {
						var $icon = createSlideIcon($layerContainer, icon);

						// Layer icon click event
						if (icon !== 'link') {
							$icon.on(clickEvent, iconsHandler);
						}
					}
				}
			}
			else {
				loaderFunc();
			}

			return deferred;
		}

		/**
		 * Get slides between a rane.
		 *
		 * @param {Number}   start
		 * @param {Number}   end
		 *
		 * @return {Array}
		 */
		function slidesInRange(start, end) {
			var slides = [];

			for (var i = 0, len = items[length], slide, slideStart, slideEnd; i < len; i++) {
				slide = items[i],
				slideStart = slide.start,
				slideEnd = slideStart + slide.size;

				if ((slideStart >= start && slideEnd <= end) || (slideEnd >= start && slideStart <= start) || (slideStart <= end && slideEnd >= end)) {
					push.call(slides, slide);
				}
			}
			
			return slides;
		}

		/**
		 * Insert cover image.
		 *
		 * @param {Object}   obj
		 *
		 * @return {Void}
		 */
		function setCover(obj) {
			// Remove last inserted cover
			$('> .' + minnamespace + 'Cover, > .' + minnamespace + 'LayerCover', obj.insertEl).remove();

			if (!obj.cover) {
				return false;
			}

			if (isObject(obj.cover) && obj.cover.poster && supportTouch) {
				obj.isVideo = 0,
				obj.cover = obj.cover.poster;
			}
			
			if (obj.isVideo && !supportTouch) {
				// Show loader
				var loader = showLoader(obj.slideEl);

				// Trigger :beforeCoverLoad event
				if (obj.slide) {
					trigger('beforeCoverLoad', obj.index);
				}

				var innerTags = [];

				if (isObject(obj.cover)) {
					// delete poster property from cover object for inner tags
					if (obj.cover.poster) {
						obj.cover.poster = null;
					}

					_each(obj.cover, function(key, value) {
						// Set sources to the video element
						push.call(innerTags, {
							name: 'source',
							type: videoTypes[key],
							src: value
						});
					});
				}
				else {
					var videoURL = obj.cover,
						extension = _.getExtension(videoURL);

					// Normalize extension
					extension = (isObject(extension)) ? null : extension.toLowerCase();

					innerTags = [
						{
							name: 'source',
							type: videoTypes[extension],
							src: videoURL
						}
					];
				}

				// Generate video element and cover holder
				var $videoEl = $(createElement('video', { autoplay: 'autoplay', muted: 'muted', loop: 'loop', controls: false }, innerTags)).addClass(minnamespace + 'CoverImage').hide(),
					$cover = $('<div class="' + minnamespace + 'Cover"></div>').append($videoEl);

				// Insert the cover into slide
				obj.insertEl.prepend($cover);

				// Trigger :coverInserted event
				trigger('coverInserted', $cover[0], obj.index);
				
				$videoEl.one('loadedmetadata', function() {
					var videoEl = $videoEl[0];

					// Store cover natural width and height
					$videoEl.show().data({ naturalWidth: videoEl.videoWidth, naturalHeight: videoEl.videoHeight });

					// Reposition slides covers
					repositionCovers(obj.slide);

					// Hide loader
					hideLoader(loader);

					// Trigger :coverLoaded event
					trigger('coverLoaded', obj.index);
				});
			}
			else {
				// Show loader
				var loader = showLoader(obj.slideEl),
					objOptions = obj[obj.slide ? 'slide' : 'caption'].options,
					viewport = (objOptions.viewport || o.viewport).toLowerCase(),
					bgSize;

				switch(viewport) {
					default:
					case 'fill':
						bgSize = 'cover';
						break;
					case 'fit':
						bgSize = 'contain';
						break;
					case 'stretch':
						bgSize = '100% 100%';
						break;
					case 'center':
						bgSize = 'auto';
						break;
				}

				// Trigger :beforeCoverLoad event
				if (obj.slide) {
					trigger('beforeCoverLoad', obj.index);
				}

				// Preload the cover
				preloadimages(obj.cover).done(function(img) {
					// Trigger :coverLoaded event
					if (obj.slide) {
						trigger('coverLoaded', obj.index);
					}

					var $cover = $('<div class="' + (minnamespace + ((obj.slide) ? 'Cover' : 'LayerCover')) + '" style="background-image: url(\'' + obj.cover + '\'); background-size: ' + bgSize + ';"></div>'),
					$image = $('img', $cover);

					// Hide loader
					hideLoader(loader);

					// Store cover natural width and height
					$image.data({ naturalWidth: img[0][width], naturalHeight: img[0][height] });

					// Insert the cover into slide
					obj.insertEl.prepend($cover);

					// Trigger callback
					if (obj.callback) {
						obj.callback.call(this, $image);
					}

					// Trigger :coverInserted event
					if (obj.slide) {
						trigger('coverInserted', $cover[0], obj.index);
					}
				});
			}
		}


		/**
		 * Set slides covers.
		 *
		 * @return {Void}
		 */
		function setSlidesCovers() {
			var start, end;

			switch (o.preloadMode) {
				// Select all slides
				case 'all':
					start = 0,
					end = slideElementSize;
					break;

				// Select nearby slides
				case 'nearby':
					start = within(pos.current - frameSize, pos.start, pos.end),
					end = within(pos.current + (frameSize * 2) - 5, pos.start, pos.end + (frameSize * 2));
					break;

				// Select instant slide
				case 'instant':
					start = within(pos.current + 5 , pos.start, pos.end),
					end = within(pos.current + frameSize - 5, pos.start, pos.end + frameSize);
					break;
			}

			var slides = slidesInRange(start, end),
				retinaRegex = new RegExp('@2x', 'gi');

			var eachHandler = function (slide, i) {
					if (slide.type === 'content') {
						return true;
					}

					var slideEl = slide.element,
						$slide = $(slideEl),
						processed = slideEl.hasAttribute(minnamespace + 'processed'),
						lastCover = slideEl.getAttribute(minnamespace + 'lastcover');

					if (processed && !resizeID) {
						return true;
					}

					var cover = slide.options.cover;

					// If the cover has rules then find right cover image
					if ($.isArray(cover)) {
						for (var i = 0, len = cover[length], element; i < len; i++) {
							element = cover[i];

							// if it's retina
							if (element[1] && element[1].match(retinaRegex) && isRetina) {
								cover = element[0];
								break;
							}

							// if the rule matched
							if (element[1] && window.matchMedia(element[1]).matches) {
								cover = element[0];
								break;
							}
						}

						// If there is no cover image for rules then automatically
						if ($.isArray(cover)) {
							cover = cover[cover[length] - 1][0];
						}
					}

					var coverURL = cover || parsePhotoURL(slide.options.video) && slide.options.video,
						isVideo = isObject(coverURL) || getTypeByExtension(coverURL) == 'video',
						parsed = parsePhotoURL(coverURL),
						coverUN = isObject(coverURL) ? rawurlencode(JSON.stringify(coverURL)) : coverURL;

					if (lastCover === coverUN) {
						return true;
					}

					// If cover needed to be parsed
					if (parsed) {
						// Show loader
						var loader = showLoader($slide);

						// Parse OEmbed URL via AJAX
						doAjax(parsed.oembed, function (data) {
							// Hide loader
							hideLoader(loader);

							if (data) {
								// Set cover URL
								coverURL = data[parsed.inJSON];

								// If replace is needed
								if (parsed[replace]) {
									coverURL = coverURL[replace](parsed[replace].from, parsed[replace].to);
								}

								// Set cover image
								setCover({
									cover: coverURL,
									slide: slide,
									slideEl: $slide,
									insertEl: $slide,
									index: getIndex(slideEl)
								});
							}
						});
					}
					else {
						// Set cover image
						setCover({
							cover: coverURL,
							isVideo: isVideo,
							slide: slide,
							slideEl: $slide,
							insertEl: $slide,
							index: getIndex(slideEl)
						});
					}

					slideEl.setAttribute(minnamespace + 'processed', '1');
					slideEl.setAttribute(minnamespace + 'lastcover', coverUN);
				};

			_each(slides, eachHandler);
		}

		/**
		 * Set slides icons.
		 *
		 * @return {Void}
		 */
		function setSlidesIcons() {
			for (var i = 0, len = items[length], slide, $slide, icon, $icon; i < len; i++) {
				slide = items[i];

				if (slide.type === 'content') {
					continue;
				}

				$slide = $(slide.element),
				icon = slide.options.icon || slide.type;

				if ($('.' + minnamespace + ucfirst(icon), $slide)[0]) {
					continue;
				}

				// Set slide icon if slide type is not content and image
				if (icon !== 'content' && icon !== 'image') {
					$icon = createSlideIcon($slide, icon);

					// Slides icons click event
					if (icon !== 'link') {
						$icon.on(clickEvent, iconsHandler);
					}
				}
			}
		}

		/**
		 * Create slide icon.
		 *
		 * @param {Object}   $slide    jQuery object with element.
		 * @param {String}   icon
		 *
		 * @return {Object}    jQuery object with element.
		 */
		function createSlideIcon($slide, icon) {
			var iconName = minnamespace + ucfirst(icon);

			// Return blank if icon is exists
			if ($('.' + iconName, $slide)[length]) {
				return;
			}

			var $icon = $('<a class="' + minnamespace + 'Icon ' + iconName + '" ondragstart="return false;"></a>');

			if (icon === 'link') {
				var index = getIndex($slide),
					slide = items[index],
					href = slide.options.link.url && _.absolutizeURI(slide.options.link.url) || window.location.href,
					target = slide.options.link.target || null,
					attributes = $.extend(true, { 'href': href, 'target': target }, slide.options.link);

					if (attributes.url) {
						attributes.url = null;
					}

				$icon[$.fn.attr ? 'attr' : 'prop'](attributes);
			}

			// Append icon into $slide
			$slide.append($icon);

			return $icon;
		}

		/**
		 * Insert media content.
		 *
		 * @param {DOM}    element    Dom element.
		 *
		 * @return {Void}
		 */
		function insertContent(element) {
			var index = getIndex(element);

			// Remove previous media content
			if (mediaEnabled) {
				removeContent();
			}

			var $container = $(element);

			if (index !== -1) {
				// Reset and get slide data
				var object = items[index];
			}
			else {
				var $caption = $container.parent(),
					options = getInlineOptions($caption),
					object = {
						type: getSlideType(options),
						options: options
					};

				$caption.addClass(minnamespace + 'Media');
			}

			$container.children().hide();

			// Generate media content
			var mediaContent = generateContent({ type: object.type, options: object.options }),
				closeButton = $('<a class="' + minnamespace + 'Icon ' + minnamespace + 'Close"></a>');

			// Insert mediaContent and closeButton
			$container.prepend(mediaContent).prepend(closeButton);

			// Bind closeButton handler
			closeButton.on(clickEvent, iconsHandler);

			if (index !== -1) {
				$parent.addClass(minnamespace + 'Media');

				// Clear captions
				clearCaptions(rel.activeSlide);
			}

			// Pause cycling
			self.pause(3);

			mediaEnabled = mediaContent;
		}

		/**
		 * Remove media content.
		 *
		 * @return {Void}
		 */
		function removeContent() {
			var $container = mediaEnabled.parent();

			// Remove media content from DOM
			mediaEnabled.remove();
			mediaEnabled = null;
			$('.' + minnamespace + 'Close', $container).off(clickEvent).remove();

			if ($container.hasClass(minnamespace + 'LayerContainer')) {
				$container.parent().removeClass(minnamespace + 'Media');
			}
			else {
				$parent.removeClass(minnamespace + 'Media');
			}

			// Show childs
			$container.children().show();

			// Reset cycling
			if (o.cycling.loop || !o.cycling.loop && index !== items[length] - 1) {
				self.isPaused = 0;
				resetCycle();
			}

			// Render captions
			if (!captionID) {
				renderCaptions(rel.activeSlide);
			}
		}

		/**
		 * Generate slide media content.
		 *
		 * @param {Mixed}     obj      Slide object
		 *
		 * @return {Object}            jQuery DOM element
		 */
		function generateContent(obj) {
			// Get type
			var type = obj.type,
				options = obj.options,
				URL = options.mp4 || options.video || options.source,
				$content;

			// Trigger :beforeGenerateMedia event
			trigger('beforeGenerateMedia');

			switch (type) {
				case 'video':
					var extension = _.getExtension(URL),
						videoFrame = options.videoFrame,
						mp4 = options.mp4,
						webm = options.webm,
						ogv = options.ogv,
						localVideo = mp4 || webm || ogv || 0,
						parsedVideo = parseVideoURL(URL);

					// Normalize extension
					extension = (extension) ? extension.toLowerCase() : null;

					// Check video URL, is video file?
					if ((/^(avi|mov|mpg|mpeg|mp4|webm|ogv|3gp|m4v)$/i).test(extension) || videoFrame || mp4 || webm || ogv) {
						// Use videoFrame if available
						if (videoFrame || (localVideo && o.videoFrame)) {
							var source = videoFrame || o.videoFrame,
							mediaFiles = [];

							// Add MP4 Video to mediaFiles
							if (mp4) {
								push.call(mediaFiles, {
									type: videoTypes['mp4'],
									src: _.absolutizeURI(mp4)
								});
							}

							// Add WebM Video to mediaFiles
							if (webm) {
								push.call(mediaFiles, {
									type: videoTypes['webm'],
									src: _.absolutizeURI(webm)
								});
							}

							// Add OGV Video to mediaFiles
							if (ogv) {
								push.call(mediaFiles, {
									type: videoTypes['ogv'],
									src: _.absolutizeURI(ogv)
								});
							}

							if (mediaFiles[length] > 0) {
								source += (_.parseURL(source, 'QUERY') ? '&' : '?') + minnamespace.toLowerCase() + 'videos=' + rawurlencode(JSON.stringify(mediaFiles));

								// Set cover image to the video frame
								if (options.cover) {
									source += '&' + minnamespace.toLowerCase() + 'cover=' + rawurlencode(_.absolutizeURI(options.cover));
								}
							}

							$content = $(createElement('iframe', { src: source, scrolling: 'no' }));
						}

						// Check that HTML5 can play this type of video file
						else if (canPlayType(videoTypes[extension]) || (mp4 && canPlayType(videoTypes['mp4'])) || (webm && canPlayType(videoTypes['webm'])) || (ogv && canPlayType(videoTypes['ogv']))) {
							var innerTags = [
								{
									name: 'source',
									type: mp4 && videoTypes['mp4'] || videoTypes[extension],
									src: URL
								}
							];

							// Add WebM Video to HTML5 video tag
							if (webm) {
								push.call(innerTags, {
									name: 'source',
									type: videoTypes['webm'],
									src: webm
								});
							}

							// Add ogv Video to HTML5 video tag
							if (ogv) {
								push.call(innerTags, {
									name: 'source',
									type: videoTypes['ogv'],
									src: ogv
								});
							}

							// Add HTML5 Video other inner tags
							if (options.HTML5Video) {
								_each(options.HTML5Video, function(key, value) {
									push.call(innerTags, $.extend({}, {
										name: key
									}, value));
								});
							}

							$content = $(createElement('video', {}, innerTags));
						}

						// Warn user that video is not supported
						else {
							throw new msError("Video not supported!", new Error());
						}
					}
					// Check video URL, is video from social video sharing?
					else if (parsedVideo) {
						$content = $(createElement(parsedVideo.type, { src: parsedVideo.source, scrolling: 'no' }));
					}
					// Warn user that video is not supported
					else {
						throw new msError("Video not supported!", new Error());
					}
					break;

				case 'iframe':
					$content = $(createElement('iframe', { src: URL }));
					break;

				case 'flash':
					$content = $(createElement('embed', { src: URL, flashvars: options.flashvars || null }));
					break;
			}

			// Trigger :mediaGenerated event
			trigger('mediaGenerated', $content[0]);

			return $content;
		}

		/**
		 * Reposition slides covers.
		 *
		 * @param {Object}     slide    Slide data object.
		 *
		 * @return {Void}
		 */
		function repositionCovers(slide) {
			var newSlides = (slide) ? [slide] : items;

			for (var i = 0, len = newSlides[length], slide, $slide, $cover, viewport, coverData, slideWidth, slideHeight, nWidth, nHeight, marginLeft, marginTop, newDimensions; i < len; i++) {
				slide = newSlides[i];

				if (!slide.options.cover || slide.type === 'content' || !(isObject(slide.options.cover) || (type(slide.options.cover) == 'string' && getTypeByExtension(slide.options.cover) == 'video'))) {
					continue;
				}

				$slide = $(slide.element),
				$cover = $slide.find('.' + minnamespace + 'CoverImage');

				if (!$cover[0]) {
					continue;
				}

				viewport = (slide.options.viewport || o.viewport).toLowerCase(),
				coverData = $cover.data(),
				slideWidth = $slide[width](),
				slideHeight = $slide[height](),
				nWidth = slideWidth,
				nHeight = slideHeight,
				marginLeft = 0,
				marginTop = 0;

				if (viewport === 'fit') {
					newDimensions = calculateDimensions(nWidth, nHeight, coverData.naturalWidth, coverData.naturalHeight);

					nWidth = newDimensions[width],
					nHeight = newDimensions[height];
				}
				else if (viewport === 'fill') {
					nHeight = (nWidth / coverData.naturalWidth) * coverData.naturalHeight;

					if (nHeight < slideHeight) {
						nWidth = (slideHeight / coverData.naturalHeight) * coverData.naturalWidth,
						nHeight = slideHeight;
					}
				}
				else if (viewport === 'center') {
					newDimensions = calculateDimensions(nWidth, nHeight, coverData.naturalWidth, coverData.naturalHeight, 1);

					nWidth = coverData.naturalWidth,
					nHeight = coverData.naturalHeight;
				}

				marginTop = ((slideHeight > nHeight) ? slideHeight - nHeight : -(nHeight - slideHeight)) / 2,
				marginLeft = ((slideWidth > nWidth) ? slideWidth - nWidth : -(nWidth - slideWidth)) / 2;

				$cover.css({ width: nWidth, height: nHeight, marginTop: marginTop, marginLeft: marginLeft });
			}
		}

		/**
		 * Resize frame equal to slide size.
		 *
		 * @param  {Mixed}   slide        Slide DOM element, or index starting at 0.
		 * @param  {Bool}    immediate    Resize immediately without an animation.
		 *
		 * @return {Void}
		 */
		function resizeFrame(slide, immediate) {
			var index = getIndex(slide),
				rect = items[index].element.getBoundingClientRect(),
				slideSize = rect[height],
				speed = immediate ? 0 : o.speed,
				properties = {};

			properties[height] = slideSize;
			if (typeof TweenMax === 'undefined') {
				$frame.stop().animate(properties, speed, o.easing, function(){
					// Trigger :resize event
					trigger('resize');
				});
			}
			else {
				if (o.easing && o.easing !== 'swing') {
					properties.easing = o.easing;
				}
				properties.onComplete = function(){
					// Trigger :resize event
					trigger('resize');
				};
				tweenLite.to($frame[0], speed/1000, properties);
			}
		}

		/**
		 * Normalize slider global elements.
		 *
		 * @return {Void}
		 */
		function normalizeElements() {
			// Normalizing $thumbnailsBar if thumbnails available in commands options but thumbnails bar DOM element is not available
			if (o.commands.thumbnails && !$thumbnailsBar[0]) {
				// Create $thumbnailsBar DOM element
				$thumbnailsBar = $('<ul></ul>');

				// Append thumbnails into $parent
				$parent.append($('<div class="' + minnamespace + 'Thumbnails"></div>').html($thumbnailsBar));
			}

			// Normalizing $pagesBar if pages available in commands options but pages bar DOM element is not available
			if (o.commands.pages && !$pagesBar[0]) {
				// Create $pagesBar DOM element
				$pagesBar = $('<ul class="' + minnamespace + 'Pages"></ul>');

				// Append pages into $parent
				$parent.append($pagesBar);
			}

			// Normalizing $nextPageButton if buttons available in commands options but $nextPageButton DOM element is not available
			if (o.commands.buttons && navigationType && !$nextPageButton[0]) {
				// Create $nextPageButton DOM element
				$nextPageButton = $('<a class="' + minnamespace + 'Buttons ' + minnamespace + 'Next"></a>');

				// Append $nextPageButton into $parent
				$parent.prepend($nextPageButton);
			}

			// Normalizing $prevPageButton if buttons available in commands options but $prevPageButton DOM element is not available
			if (o.commands.buttons && navigationType && !$prevPageButton[0]) {
				// Create $prevPageButton DOM element
				$prevPageButton = $('<a class="' + minnamespace + 'Buttons ' + minnamespace + 'Prev"></a>');

				// Append $prevPageButton into $parent
				$parent.prepend($prevPageButton);
			}

			// Normalizing $forwardButton if buttons available in commands options but $forwardButton DOM element is not available
			if (o.commands.buttons && !navigationType && !$forwardButton[0]) {
				// Create $forwardButton DOM element
				$forwardButton = $('<a class="' + minnamespace + 'Buttons ' + minnamespace + 'Next"></a>');

				// Append $forwardButton into $parent
				$parent.prepend($forwardButton);
			}

			// Normalizing $backwardButton if buttons available in commands options but $backwardButton DOM element is not available
			if (o.commands.buttons && !navigationType && !$backwardButton[0]) {
				// Create $backwardButton DOM element
				$backwardButton = $('<a class="' + minnamespace + 'Buttons ' + minnamespace + 'Prev"></a>');

				// Append $backwardButton into $parent
				$parent.prepend($backwardButton);
			}
		}

		/**
		 * Render captions.
		 *
		 * @param {Object}     slide       Slide DOM element, or index starting at 0.
		 *
		 * @return {Void}
		 */
		function renderCaptions(slide) {
			if (typeof TimelineMax === 'undefined') {
				console && console.warn('Animated layers needs TimelineMax function. Please include the "tweenmax.js" into your page.');
				return;
			}

			var index = getIndex(slide),
				slide = items[index],
				captions = slide.captions;

			if (index === captionRendered) {
				return;
			}

			if (captionHistory[index]) {
				var timeline;

				for (var i = 0, len = captionHistory[index][length], timeline; i < len; i++) {
					timeline = captionHistory[index][i];

					if (!self.isFreezed && timeline) {
						timeline.timeScale(1).play(0);
					}
				}
			} else {
				captionHistory[index] = [];
				_each(captions, function(caption, i) {
					var $caption = $(caption.element),
						options = caption.options,
						captionStyles = undefined,
						animations = (caption.animation && caption.animation[length]) && caption.animation;

					// Show caption & set necessary caption styles
					var css = { 'position': 'absolute' };

					// Save styles
					if (caption.animationOut && caption.animationOut[length]) {
						captionStyles = new StyleRestorer(caption.element);
						captionStyles.save.apply(captionStyles, ['opacity', 'webkitTransform', 'transform', 'webkitTransformOrigin', 'transformOrigin', 'left', 'top', width, height, 'fill', 'stroke', 'stroke-width', 'stroke-dash-offset']);
					}

					$caption.show().css(css);

					// Add animation frames to timeline
					if (animations) {
						var timeline, splitText;

						if (!captionHistory[index][i]) {
							// Generate timeline
							timeline = new TimelineMax({
								caption: caption,
								styles: captionStyles,
								paused: true,
								onComplete: function(){
									// Handle the repeat
									if (options.loop) {
										this.seek(getRepeatDuration(caption));
									}
								}
							});

							_each(animations, function(keyframe) {
								var duration = keyframe.speed ? keyframe.speed / 1000 : 0,
									delay = keyframe.delay ? keyframe.delay / 1000 : 0,
									ease = type(keyframe.easing) === 'string' ? window.GreenSockGlobals.com.greensock.easing.Ease.map[keyframe.easing || 'swing'] : keyframe.easing,
									mode = keyframe.mode || 'to',
									position = keyframe.position,
									style = keyframe.style || {},
									scrambleText = style.scrambleText,
									staggerText = keyframe.staggerText && $.extend({ type: 'chars', delay: 0.01 }, keyframe.staggerText) || null,
									cssStyle = !!scrambleText ? { delay: delay, ease: ease } : { delay: delay, ease: ease, force3D:true };

								// Extend and normalize styles
								$.extend(cssStyle, style);

								if (staggerText) {
									if (!splitText) {
										splitText = new SplitText(caption.element, { type: 'chars, words, lines', charsClass: 'mSChars', wordsClass: 'mSWords', linesClass: 'mSLines' });
									}

									if (position) {
										timeline['stagger' + ucfirst(mode)](splitText[staggerText.type], duration, cssStyle, staggerText.delay, position);
									}
									else{
										timeline['stagger' + ucfirst(mode)](splitText[staggerText.type], duration, cssStyle, staggerText.delay);
									}

									// Export the split text instance
									timeline.vars.splitText = splitText;
								}
								else {
									timeline[mode](caption.element, duration, cssStyle);
								}
							});

							// Cache the timeline to the history
							captionHistory[index][i] = timeline;
						}
						else {
							timeline = captionHistory[index];
						}

						// Play the 
						if (!self.isFreezed) {
							timeline.timeScale(1).play();
						}
					}
				});
			}

			// Remember the slide index that rendered layers
			captionRendered = index;
		}

		/**
		 * Clear captions.
		 *
		 * @param {Mixed} slide       Slide DOM element, or index starting at 0.
		 *
		 * @return {Void}
		 */
		function clearCaptions(slide) {
			var index = getIndex(slide);

			if (index !== captionRendered || index < 0) {
				return;
			}

			if (items[index] && items[index].captions[length]) {
				self.one('moveEnd', function() {
					if (rel.activeSlide === index) {
						return;
					}

					var slide = items[index];

					// Pause timelines
					_each(captionHistory[index], function(timeline) {
						if (timeline) {
							var vars = timeline.vars,
								caption = vars.caption,
								captionStyles = vars.styles,
								animationOut = caption.animationOut,
								reverseLayers = o.reverseLayers || slide.options.reverseLayers;

							if (reverseLayers) {
								timeline.timeScale(timeline.time() / (reverseLayers / 1000)).reverse();
							}
							else if(animationOut && animationOut[length]) {
								var keyframe = animationOut[0],
									duration = keyframe.speed ? keyframe.speed / 1000 : 0,
									delay = keyframe.delay ? keyframe.delay / 1000 : 0,
									ease = window.GreenSockGlobals.com.greensock.easing.Ease.map[keyframe.easing || 'swing'],
									style = keyframe.style || {},
									scrambleText = style.scrambleText,
									staggerText = keyframe.staggerText && $.extend({ type: 'chars', delay: 0.01 }, keyframe.staggerText) || null,
									cssStyle = !!scrambleText ? { delay: delay, ease: ease } : { delay: delay, ease: ease, force3D:true },
									onComplete;


								// Extend and normalize styles
								$.extend(cssStyle, style);

								// Pause the timeline
								timeline.pause();

								if (captionStyles) {
									onComplete = function() {
										captionStyles.restore();
										timeline.pause(0, true);
									};
								}
								else {
									onComplete = function() {
										timeline.pause(0, true);
									};
								}

								cssStyle.onComplete = onComplete;

								if (staggerText && vars.splitText) {
									TweenMax['staggerTo'](vars.splitText[staggerText.type], duration, cssStyle, staggerText.delay);
								}
								else {
									TweenMax.to(caption.element, duration, cssStyle);
								}
							}
							else {
								timeline.pause(0, true);
							}
						}
					});
				});
			}
		}

		/**
		 * Get repeat duration.
		 *
		 * @param {Object}     caption
		 * @param {Object}     timeline
		 *
		 * @return {Void}
		 */
		function getRepeatDuration(caption) {
			var options = caption.options,
				startAt = options.startAtOnRepeat || 0;

			if (is_numeric(startAt)) {
				var keyframe, duration, delay, time = 0;
				for (var i = 0, len = caption.animation[length]; i < len; i++) {
					keyframe = caption.animation[i];
					duration = keyframe.speed ? keyframe.speed / 1000 : 0;
					delay = keyframe.delay ? keyframe.delay / 1000 : 0;

					if (i === startAt) {
						if (options.dontDelayOnRepeat) {
							time += delay;
						}

						return time;
					}

					time += duration + delay;
				}
			}
			else {
				return hmsToSeconds(startAt);
			}
		}

		/**
		 * Handle parallax effect tick
		 *
		 * @return {Void}
		 */
		function parallaxTick() {
			if (!parallax.parallaxCaptions) {
				this.kill();
				return;
			}

			// Parallax options
			var parallaxOptions = o.parallax;
			var len = parallax.parallaxCaptions[length];
			var X = parallaxTo.X, Y = parallaxTo.Y;
			var caption, transformString, level, parallaxAxises;

			// Loop the parallax compatible captions
			for(var i = 0; i < len; i++) {
				transformString = gpuAcceleration;
				caption = parallax.parallaxCaptions[i];
				// Parallax effect level
				level = caption.options.parallaxLevel;
				// Alowed parallax effect axises
				parallaxAxises = caption.options.parallaxAxises || parallaxOptions;

				// Calculate X parallax axis
				if (parallaxAxises.x) {
					transformString += 'translateX(' + ((parallaxOptions.invertX ? -X : X) / 100 * level) + 'px) ';
				}

				// Calculate Y parallax axis
				if (parallaxAxises.y) {
					transformString += 'translateY(' + ((parallaxOptions.invertY ? -Y : Y) / 100 * level) + 'px) ';
				}

				// Calculate Z parallax axis
				if (parallaxAxises.z && gpuAcceleration) {
					var x = ((parallaxOptions.invertZ ? -X : X) / 100 * level),
						y = ((parallaxOptions.invertZ ? -Y : Y) / 100 * level);

					transformString += 'rotateX(' + (-y / 1.5) + 'deg) rotateY(' + (x / 3) + 'deg)';
				}

				caption.element.style[transform] = transformString;
			}
		}

		/**
		 * Handle parallax effect for captions
		 *
		 * @return {Void}
		 */
		function parallaxCaptions() {
			// Parallax options
			var parallaxOptions = o.parallax;

			var parallaxPos = {
				X: parallaxTo.X,
				Y: parallaxTo.Y,
				useFrames: false,
				ease: parallaxOptions.frictionEasing,
				onUpdate: parallaxTick
			};
			
			parallaxTo.X = 0;
			parallaxTo.Y = 0;

			parallaxTween = tweenLite.to(parallaxTo, parallaxOptions.frictionDuration && parallaxOptions.frictionDuration / 1000 || 0, parallaxPos);
		}

		/**
		 * Revert parallax effect for captions
		 *
		 * @return {Void}
		 */
		function revertParallax() {
			// Parallax options
			var parallaxOptions = o.parallax;
			var revertDuration = o.parallax.revertDuration;
			var parallaxCaptions = parallax.parallaxCaptions;
			var parallaxCaptionsLength = parallaxCaptions[length];

			var caption, transformString, captionEl, parallaxAxises, level, X, Y,
				parallaxPos = {
				X: parallaxTo.X,
				Y: parallaxTo.Y,
				useFrames: false,
				ease: parallaxOptions.revertEasing,
				onUpdate: parallaxTick
			};

			parallaxTween = tweenLite.to(parallaxTo, revertDuration && revertDuration/1000 || 0, parallaxPos);
		}

		/**
		 * Change Hashtag.
		 *
		 * @param {Number}  index
		 *
		 * @return {Void}
		 */
		function changeHashtag(index) {
			var slide = items[index];

			hashLock = 1;
			window.location.hash = o.deeplinking.linkID + o.deeplinking.separator + slide.ID;
			hashLock = 0;
		}

		/**
		 * Get slide by ID.
		 *
		 * @param {String}     ID
		 *
		 * @return {Void}
		 */
		function getSlideById(ID) {
			var index = -1;

			for (var i = 0, len = items[length]; i < len; i++) {
				if (ID == items[i].ID) {
					index = i;
					break;
				}
			}

			if (index === -1) {
				for (var i = 0, len = items[length], id; i < len; i++) {
					id = items[i].ID;

					if (type(id) === 'string' && ID && ID.indexOf(id) === 0) {
						index = i;
						break;
					}
				}
			}

			return index;
		}

		/**
		 * Handle Hashtag.
		 *
		 * @param {Event}     event
		 *
		 * @return {Void}
		 */
		function hashtagHandler(event) {
			var hash = window.location.hash[replace]("#", ""),
				split = hash.split(o.deeplinking.separator);

			if (hashLock || !o.deeplinking.linkID) {
				return;
			}


			if (event) {
				hashLock = 1;
			}

			if (split[0] === o.deeplinking.linkID) {
				var index = getSlideById(split[1]);

				if (index === -1 && typeof split[1] === 'undefined') {
					index = 0;
				}

				self.activate(index);
				if (thumbnailNav) {
					thumbnailNav.activate(index);
				}
			}
			else if (event && hash[length] === 0) {
				self.activate(o.startAt);
			}

			if (event) {
				hashLock = 0;
			}
		}

		/**
		 * Freeze the slider layers & cycling
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		self.freeze = function () {
			if (freezeID === 0) {
				var index = rel.activeSlide;

				$parent.addClass(o.classes.isInFreeze);

				// Pause cycling
				if (cycleID) {
					cycleID = cancelAnimationFrame(cycleID);
					cycleLastTime = 0;
				}

				if (navigationType && captionHistory[index] && captionHistory[index][length]) {
					_each(captionHistory[index], function(timeline) {
						timeline && timeline.pause();
					});
				}

				// Trigger :freeze event
				trigger('freeze');

				self.isFreezed = 1;
			}

			if (freezeID >= 0) {
				freezeID++;
			}
		};

		/**
		 * Unfreeze the slider layers & cycling
		 *
		 * @param  {Event} event
		 *
		 * @return {Void}
		 */
		self.unFreeze = function () {
			if (freezeID > 0) {
				freezeID--;
			}

			if (freezeID <= 0) {
				var index = rel.activeSlide;

				$parent.removeClass(o.classes.isInFreeze);

				// Reset cycling
				if (o.cycling.loop || !o.cycling.loop && index !== items[length] - 1) {
					resetCycle();
				}

				if (navigationType && captionHistory[index] && captionHistory[index][length]) {
					_each(captionHistory[index], function(timeline) {
						timeline && timeline.resume();
					});
				}

				// Trigger :unfreeze event
				trigger('unfreeze');

				self.isFreezed = 0;
			}
		};

		/**
		 * Destroys instance and everything it created.
		 *
		 * @return {Object}
		 */
		self.destroy = function () {
			// Unbind all events
			var $unbinds = $scrollSource
				.add($handle)
				.add($scrollbar)
				.add($pagesBar)
				.add($forwardButton)
				.add($backwardButton)
				.add($prevButton)
				.add($nextButton)
				.add($prevPageButton)
				.add($nextPageButton)
				.add($fullScreenButton)
				.add($('.' + minnamespace + 'Icon', $frame));

			$unbinds.off('.' + namespace);

			$doc.add($win).off('.' + uniqId);

			// Remove classes
			$prevButton
				.add($nextButton)
				.add($prevPageButton)
				.add($nextPageButton)
				.removeClass(o.classes.disabledClass);

			if ($slides[0]) {
				$slides.removeAttr('style').removeClass(minnamespace + 'Slide').eq(rel.activeSlide).removeClass(o.classes.activeClass);

				// Remove slides covers and icons
				$('.' + minnamespace + 'Cover, .' + minnamespace + 'Icon', $slides).remove();
			}

			// Remove pages
			if ($pagesBar[0]) {
				$pagesBar.empty();
			}

			// Remove thumbnails
			if ($thumbnailsBar[0]) {
				$thumbnailsBar.empty();
			}

			var removeEls = [];

			if (!o.buttons.forward && $forwardButton[0]) {
				push.call(removeEls, $forwardButton[0]);
			}
			if (!o.buttons.backward && $backwardButton[0]) {
				push.call(removeEls, $backwardButton[0]);
			}
			if (!o.buttons.prev && $prevButton[0]) {
				push.call(removeEls, $prevButton[0]);
			}
			if (!o.buttons.next && $nextButton[0]) {
				push.call(removeEls, $nextButton[0]);
			}
			if (!o.buttons.prevPage && $prevPageButton[0]) {
				push.call(removeEls, $prevPageButton[0]);
			}
			if (!o.buttons.nextPage && $nextPageButton[0]) {
				push.call(removeEls, $nextPageButton[0]);
			}
			if (!o.buttons.fullScreen && $fullScreenButton[0]) {
				push.call(removeEls, $fullScreenButton[0]);
			}

			if (!o.pages.pagesBar && $pagesBar[0]) {
				push.call(removeEls, $pagesBar[0]);
			}
			else if($pagesBar[0]) {
				$pagesBar.empty();
			}

			if (!o.thumbnails.thumbnailsBar && $thumbnailsBar[0]) {
				push.call(removeEls, $thumbnailsBar[0]);
			}
			else if($thumbnailsBar[0]) {
				$thumbnailsBar.empty();
			}

			// Remove mightySlider created elements
			$(removeEls).remove();

			// Unbind events from frame
			$frame.off('.' + namespace);
			// Remove classes from parent
			$parent.removeClass([o.classes.horizontalClass, o.classes.verticalClass, o.classes.isTouchClass, o.classes.isRetinaClass, o.classes.isPaused, o.classes.isInFullScreen, o.classes.isInFreeze, namespace].join(' '));
			// Reset slideElement and handle positions
			$slideElement.add($handle).css(transform || (o.navigation.horizontal ? 'left' : 'top'), transform ? 'none' : 0).removeClass(minnamespace + 'SlideElement ' + minnamespace + 'ScrollbarHandle');
			// Remove the instance from element data storage
			$.removeData(frame, namespace);
			// Remove the classes from FRAME and scrollbar elements
			$frame.add($scrollbar).removeClass(minnamespace + 'Frame ' + minnamespace + 'MouseDraggable ' + minnamespace + 'TouchDraggable ' + minnamespace + 'Scrollbar');

			// Clean up collections
			items[length] = pages[length] = 0;
			last = {};

			// Reset initialized status and return the instance
			self.initialized = 0;

			// Trigger :destroy event
			trigger('destroy');

			// Remove the frame from the windowSpy
			windowSpy.remove(frame);

			// Remove this instance from instances
			_each(mightySliderInstances, function(instance, i){
				if (type(instance) != 'undefined' && instance.uniqId === self.uniqId) {
					 splice.call(mightySliderInstances, i, 1);
				}
			});

			return self;
		};

		/**
		 * Initialize.
		 *
		 * @return {Object}
		 */
		self.init = function () {
			if (self.initialized) {
				return;
			}

			syncThumbnailsbar();

			// Register callbacks map
			self.on(callbackMap);

			// Set required styles to elements
			var $movables = $slideElement.add($handle);
			$frame.css('overflow', 'hidden').addClass(minnamespace + 'Frame');
			if (!transform && $frame.css('position') === 'static') {
				$frame.css('position', 'relative');
			}
			if (transform) {
				if (gpuAcceleration) {
					$movables.css(transform, gpuAcceleration);
				}
			}
			else {
				if ($scrollbar.css('position') === 'static') {
					$scrollbar.css('position', 'relative');
				}
				$movables.css({ position: 'absolute' });
			}

			if (o.dragging.mouseDragging && !supportTouch) {
				$frame.addClass(minnamespace + 'MouseDraggable');
			}
			if (o.dragging.touchDragging && supportTouch) {
				$frame.addClass(minnamespace + 'TouchDraggable');
			}

			// Add horizontal/vertical and mightySlider class
			$parent.addClass(o.navigation.horizontal ? o.classes.horizontalClass : o.classes.verticalClass).addClass(namespace);

			$slideElement.addClass(minnamespace + 'SlideElement');
			$scrollbar.addClass(minnamespace + 'Scrollbar');
			$handle.addClass(minnamespace + 'ScrollbarHandle');

			// Add isTouch class
			if (supportTouch) {
				$parent.addClass(o.classes.isTouchClass);
			}

			// Add isRetina class
			if (isRetina) {
				$parent.addClass(o.classes.isRetinaClass);
			}

			// Normalize slider global elements
			normalizeElements();

			// Load
			load(true);

			// Handle Hashtag
			if (!!o.deeplinking.linkID) {
				hashtagHandler();
			}

			// Activate thumbnail for requested position
			if (thumbnailNav) {
				self.on('active', function(name, index) {
					thumbnailNav.activate(index);
				});
			}

			if (navigationType) {
				// Add '.mSSlide' class to $slides
				$slides.addClass(minnamespace + 'Slide');
			}

			// Navigation buttons
			if ($forwardButton[0]) {
				$forwardButton.on(mouseDownEvent, buttonsHandler);
			}
			if ($backwardButton[0]) {
				$backwardButton.on(mouseDownEvent, buttonsHandler);
			}
			if ($prevButton[0]) {
				$prevButton.on(clickEvent, buttonsHandler);
			}
			if ($nextButton[0]) {
				$nextButton.on(clickEvent, buttonsHandler);
			}
			if ($prevPageButton[0]) {
				$prevPageButton.on(clickEvent, buttonsHandler);
			}
			if ($nextPageButton[0]) {
				$nextPageButton.on(clickEvent, buttonsHandler);
			}
			if ($fullScreenButton[0]) {
				$fullScreenButton.on(clickEvent, buttonsHandler);
			}

			// Scrolling navigation
			$scrollSource.on(wheelEvent, scrollHandler);

			// Clicking on scrollbar navigation
			if ($scrollbar[0]) {
				$scrollbar.on(clickEvent, scrollbarHandler);
			}

			// Click on slides navigation
			if (navigationType && o.navigation.activateOn) {
				$frame.on(o.navigation.activateOn[replace](/click/ig, 'msclick') + '.' + namespace, '*:not(' + minnamespace + 'Pages):not(' + minnamespace + 'Buttons):not(' + minnamespace + 'Icon)', activateHandler);
			}

			// Pages navigation
			if ($pagesBar[0] && o.pages.activateOn) {
				$pagesBar.on(o.pages.activateOn[replace](/click/ig, 'msclick') + '.' + namespace, '*', activatePageHandler);
			}

			// Dragging navigation
			$dragSource.on(dragInitEvents, { source: 'slideElement' }, dragInit);

			// Scrollbar dragging navigation
			if ($handle[0]) {
				$handle.on(dragInitEvents, { source: 'handle' }, dragInit);
			}

			// Keyboard navigation and Page Visibility Change Handler
			$doc.on(keyDownEvent, keyboardHandler)
			.on(visibilityChangeEvent, visibilityChangeHandler);

			// Window resize, fullscreen and hashchange events
			$win.on(resizeEvent, winResizeHandler).on(hashChangeEvent, hashtagHandler);

			if (screenfull.enabled) {
				$win.on(screenfull.raw.fullscreenchange + '.' + uniqId, winfullScreenHandler);
			}

			// Pause on hover
			$frame.on(hoverEvent, pauseOnHoverHandler);
			// Reset native FRAME element scroll
			$frame.on('scroll.' + namespace, resetScroll);

			// Disable dragging on frame element
			$frame.on('dragstart', disableDragging);

			// Initiate automatic cycling
			if (o.cycling.cycleBy) {
				self[o.cycling.startPaused ? 'pause' : 'resume']();
			}

			// Mark instance as initialized
			self.initialized = 1;

			// Trigger :initialize event
			trigger('initialize');

			// Add instance to all mightySlider instances
			push.call(mightySliderInstances, self);

			// Add the frame to the windowSpy
			windowSpy.add(frame);

			// Return instance
			return self;
		};
	}


	/**
	 * Get slide type.
	 *
	 * @param {Object}   options
	 *
	 * @return {String}
	 */
	function getSlideType(options) {
		var type = 'content',
		cover = options.cover,
		source = options.source,
		video = options.mp4 || options.webm || options.ogv || options.video;

		if (options.type) {
			return options.type;
		}
		else if (parseVideoURL(source)) {
			return 'video';
		}

		if (cover) {
			type = 'image';
		}
		if (source) {
			type = 'iframe';
		}
		if (video) {
			type = 'video';
		}
		if (options.link) {
			type = 'link';
		}
		
		return type;
	}

	/**
	 * Get element inline options.
	 *
	 * @param {Object}   $element    jQuery object with element.
	 *
	 * @return {Object}
	 */
	function getInlineOptions($element) {
		var data = $element.data(namespace.toLowerCase()),
			json;

		try {
			json = data && eval("({" + data + "})");
		}
		catch (e) {
			console && console.error(namespace + ':', 'Following element has wrong syntax for "data-mightyslider" attribute:', $element[0]);
		}

		return json || {};
	}

	/**
	 * Get caption keyframes.
	 *
	 * @param {Object}   $caption    jQuery object with element.
	 *
	 * @return {Object}
	 */
	function getCaptionKeyFrames($caption, out) {
		var name = minnamespace.toLowerCase() + (out ? 'animation-out' : 'animation'),
			data = $caption.data(name),
			json;

		try {
			json = data && (isObject(data) ? [data] : eval("([" + data + "])"));
		}
		catch (e) {
			console && console.error(namespace + ':', 'Following element has wrong syntax for "data-' + name + '" attribute:', $element[0]);
		}

		return json || {};
	}

	/**
	 * Get caption default styles.
	 *
	 * @param {Object}   $caption    jQuery object with element.
	 *
	 * @return {Object}
	 */
	function getCaptionStyles($caption) {
		var styles = {};

		for (var i = 0, len = captionResponsiveStyles[length], property, pixel; i < len; i++) {
			property = captionResponsiveStyles[i],
			pixel = getPixel($caption, property);

			if (pixel) {
				styles[property] = pixel;
			}
		}

		return styles;
	}

	/**
	 * Normalize styles.
	 *
	 * @param {Object}   styles
	 * @param {Object}   properties
	 * @param {Number}   ratio
	 *
	 * @return {Object}
	 */
	function normalizeStyles(styles, properties, ratio) {
		var newStyles = {};

		_each(styles, function(property, value) {
			if (indexOf.call(properties, property) === -1) {
				return true;
			}
			var pixel = value * ratio;
			newStyles[property] = pixel;
		});

		return newStyles;
	}

	/**
	 * Event preventDefault & stopPropagation helper.
	 *
	 * @param {Event} event     Event object.
	 * @param {Bool}  noBubbles Cancel event bubbling.
	 *
	 * @return {Void}
	 */
	function stopDefault(event, noBubbles) {
		event.preventDefault();
		if (noBubbles) {
			event.stopPropagation();
		}
	}

	/**
	 * Disables an event it was triggered on and unbinds itself.
	 *
	 * @param  {Event} event
	 *
	 * @return {Void}
	 */
	function disableOneEvent(event) {
		/*jshint validthis:true */
		stopDefault(event, 1);
		$(this).off(event.type, disableOneEvent);
	}

	/**
	 * Resets native element scroll values to 0.
	 *
	 * @return {Void}
	 */
	function resetScroll() {
		/*jshint validthis:true */
		this.scrollLeft = 0;
		this.scrollTop = 0;
	}

	/**
	 * Disable dragging function.
	 *
	 * @return {Void}
	 */
	function disableDragging() {
		return false;
	}

	/**
	 * A JavaScript equivalent of PHP’s is_numeric.
	 *
	 * @param {Mixed} value
	 *
	 * @return {Boolean}
	 */
	function is_numeric(value) {
		return (type(value) === 'number' || type(value) === 'string') && value !== '' && !isNaN(value);
	}

	/**
	 * Parse style to pixels.
	 *
	 * @param {Object}   $element   jQuery object with element
	 * @param {String}   property   CSS property to get the pixels from
	 *
	 * @return {Int}
	 */
	function getPixel($element, property) {
		return parseInt($element.css(property), 10) || 0;
	}

	/**
	 * Make sure that number is within the limits.
	 *
	 * @param {Number} number
	 * @param {Number} min
	 * @param {Number} max
	 *
	 * @return {Number}
	 */
	function within(number, min, max) {
		return number < min ? min : number > max ? max : number;
	}

	/**
	 * Return value from percent of a number.
	 *
	 * @param {Number} percent
	 * @param {Number} total
	 *
	 * @return {Number}
	 */
	function percentToValue(percent, total) {
		return parseFloat((total / 100) * percent);
	}

	/**
	 * Saves element styles for later restoration.
	 *
	 * Example:
	 *   var styles = new StyleRestorer(frame);
	 *   styles.save('position');
	 *   element.style.position = 'absolute';
	 *   styles.restore(); // restores to state before the assignment above
	 *
	 * @param {Element} element
	 */
	function StyleRestorer(element) {
		var self = {};
		self.style = {};
		self.save = function () {
			if (!element || !element.nodeType) return;
			for (var i = 0; i < arguments[length]; i++) {
				self.style[arguments[i]] = element.style[arguments[i]];
			}
			return self;
		};
		self.restore = function () {
			if (!element || !element.nodeType) return;
			for (var prop in self.style) {
				if (self.style.hasOwnProperty(prop)) element.style[prop] = self.style[prop];
			}
			return self;
		};
		return self;
	}

	/**
	 * Show slide loader.
	 *
	 * @param {Object}   $slide    jQuery object with element.
	 *
	 * @return {Object} jQuery DOM element
	 */
	function showLoader($slide) {
		var $loader = $('<div class="' + minnamespace + 'Icon ' + minnamespace + 'Loader"></div>'),
			loaderExists = $('.' + minnamespace + 'Loader', $slide);

		if (!loaderExists[0]) {
			$slide.prepend($loader);
		} else {
			$loader = loaderExists;
		}

		// Set instances number for loader icon
		var instancesAttr = $loader[0].getAttribute(minnamespace + 'instances'),
			instances = instancesAttr && parseInt(instancesAttr) || 0;

		// Set last show loader instance
		instances++;
		$loader[0].setAttribute(minnamespace + 'instances', instances);

		return $loader;
	}

	/**
	 * Hide slide loader.
	 *
	 * @param {Object}   $loader    jQuery object with element.
	 *
	 * @return {Void}
	 */
	function hideLoader($loader) {
		var instancesAttr = $loader[0].getAttribute(minnamespace + 'instances'),
			instances = instancesAttr && parseInt(instancesAttr) || 1;

		// Set last hide loader instance
		instances--;
		$loader[0].setAttribute(minnamespace + 'instances', instances);

		if (instances <= 0) {
			return $loader.remove();
		}
	}

	/**
	 * Calculate new dimensions from old dimensions.
	 *
	 * @param {Number}   width_new
	 * @param {Number}   height_new
	 * @param {Number}   width_old
	 * @param {Number}   height_old
	 * @param {Number}   factor
	 *
	 * @return {Object}
	 */
	function calculateDimensions(width_new, height_new, width_old, height_old, factor) {
		if (!factor) {
			if (!width_new) {
				factor = height_new / height_old;
			}
			else if (!height_new) {
				factor = width_new / width_old;
			}
			else {
				factor = Math.min( width_new / width_old, height_new / height_old );
			}
		}

		return {
			width: Math.round( width_old * factor ),
			height: Math.round( height_old * factor ),
			ratio:factor
		};
	}

	/**
	 * Parse video url
	 *
	 * @param {String}   url
	 *
	 * @return {Object}
	 */
	function parseVideoURL(url) {
		var result = null;

		for (var i = 0, len = videoRegularExpressions[length], object, split; i < len; i++) {
			object = videoRegularExpressions[i];

			// Test url if can be parsed
			if (object.reg.test(url)) {
				split = url.split(object.split);
				result = {
					source: object.url[replace](/\{id\}/g, split[object.index]),
					type: object.iframe && 'iframe' || 'flash'
				};

				break;
			}
		}

		return result;
	}

	/**
	 * Parse photo url
	 *
	 * @param {String}   url
	 *
	 * @return {Object}
	 */
	function parsePhotoURL(url) {
		var result = null;

		for (var i = 0, len = photoRegularExpressions[length], object; i < len; i++) {
			object = photoRegularExpressions[i];

			// Test url if can be parsed
			if (object.reg.test(url)) {
				result = $.extend(true, {}, object, {});
				result.oembed = _.absolutizeURI(object.oembed[replace](/\{URL\}/g, url), url);

				break;
			}
		}

		return result;
	}

	/**
	 * Create DOM element
	 *
	 * @param {String}   type
	 * @param {Object}   params
	 * @param {Object}   innerTags
	 *
	 * @return {Object}  DOM element
	 */
	function createElement(type, params, innerTags) {
		var el;

		params = params || {};
		innerTags = innerTags || {};

		switch (type) {
			case 'video':
				// Create video DOM element
				el = document.createElement( "video" );

				// Set default video attributes
				params = $.extend(true, videoDefaultAttributes, params);
				break;
			case 'iframe':
				// Create iframe DOM element
				el = document.createElement( "iframe" );

				// Set default iframe attributes
				params = $.extend(true, iframeDefaultAttributes, params);
				break;
			case 'flash':
				// Create embed DOM element
				el = document.createElement( "embed" );

				// Set default embed attributes
				params = $.extend(true, embedDefaultAttributes, params);
				break;
			default :
				el = document.createElement( type );
				break;
		}

		// Insert element attributes
		insertTag(el, params);

		// Insert innerTags
		_each(innerTags, function(attributes, i) {
			if (!attributes.name) {
				return true;
			}
			// Insert tags into el
			var newEl = document.createElement( attributes.name );

			attributes.name = null;

			// Insert element attributes
			insertTag(newEl, attributes);
			
			// Append inner tags into el
			el.appendChild(newEl);
		});

		return el;
	}

	/**
	 * Insert attributes to DOM elements
	 *
	 * @param {Object}   el                 HTML DOM element
	 * @param {String}   attributes
	 *
	 * @return {Void}
	 */
	function insertTag(el, attributes) {
		_each(attributes, function(key, value) {
			if (!is_numeric(value) && !value) {
				return true;
			}

			// Insert attribute into el
			insertAttribute(el, key, value);
		});
	}

	/**
	 * Insert an attribute into DOM element
	 *
	 * @param {Object}   el                 HTML DOM element
	 * @param {String}   attributeName
	 * @param {Mixed}    value
	 *
	 * @return {Void}
	 */
	function insertAttribute(el, attributeName, value) {
		var nodeValue = (isObject(value)) ? (function(){
				var query = "",
					i = 0;

				_each(value, function(k, v) {
					if (i!==0) {
						query += "&";
					}
					query += k + "=" + rawurlencode(v);
					i++;
				});
			return query;
		}()) : value;
		el.setAttribute(attributeName, nodeValue);
	}

	/**
	 * Preload images with callback.
	 *
	 * @param {Array} arr
	 *
	 * @return {Object}
	 */
	function preloadimages(arr) {
		var newImages = [], loadedImages = 0,
			postAction = function(){};


		arr = (!isArray(arr)) ? [arr] : arr;

		function imageLoadPost(){
			loadedImages++;
			if (loadedImages === arr[length]) {
				// call postAction and pass in newImages array as parameter
				postAction(newImages);
			}
		}

		function handler() {
			imageLoadPost();
		}

		for (var i=0; i < arr[length]; i++) {
			newImages[i] = new Image();
			newImages[i].onload = handler;
			newImages[i].onerror = handler;
			newImages[i].src = arr[i];
		}

		// return blank object with done() method
		return {
			done: function(f) {
				// remember user defined callback functions to be called when images load
				postAction = f || postAction;
			}
		};
	}

	/**
	 * Remove unwanted chars from background
	 *
	 * @param {String}  url
	 *
	 * @return {String}
	 */
	function stripUrl(url) {
		url = url[replace](/url\(\"/g, "");
		url = url[replace](/url\(/g, "");
		url = url[replace](/\"\)/g, "");
		url = url[replace](/\)/g, "");

		return url;
	};

	/**
	 * Find all images in a container with callback.
	 *
	 * @param {Object}  element  DOM element
	 *
	 * @return {Array}
	 */
	function findAllImages(element) {
		var url = "",
			$elements = $('*:not(script, style, .' + minnamespace + 'Cover, .' + minnamespace + 'CoverImage, .' + minnamespace + 'LayerCover, .' + minnamespace + 'LayerCoverImage, .' + minnamespace + 'Loader)', element),
			foundUrls = [];

		var obj, urls,
			eachHandler = function (el) {
				obj = $(el);

				if (el.nodeName.toLowerCase() === "img" && el.hasAttribute("src")) {
					//if is img and has src
					url = obj.prop("src");
				} else if (obj.css("background-image") !== "none") {
					//if object has background image
					url = obj.css("background-image");
				}

				//skip if gradient
				if (indexOf.call(url, "gradient") === -1) {
					//remove unwanted chars
					url = stripUrl(url);

					//split urls
					urls = url.split(", ");

					for (var i = 0, len = urls[length]; i < len; i++) {
						if ((urls[i][length] > 0 && !urls[i].match(/^(data:)/i)) && (indexOf.call(foundUrls, urls[i]) === -1)) {

							//add image to found list
							push.call(foundUrls, urls[i]);
						}
					}
				}
			};

		_each($elements, eachHandler);

		return foundUrls;
	}

	/**
	 * Check HTML5 video element can play given type.
	 *
	 * @param {String} type
	 *
	 * @return {String}
	 */
	function canPlayType(type) {
		var el = document.createElement( "video" );
		return !!(el.canPlayType && el.canPlayType(type)[replace](/no/, ''));
	}

	/**
	 * Do the ajax requests with callback.
	 *
	 * @param {String}   url
	 * @param {Function} callback
	 *
	 * @return {Void}
	 */
	function doAjax(url, callback) {
		var docMode = document.documentMode || _.browser.version,
			ieLT10 = _.browser.msie && docMode < 10,
			data = { url: url },
			xhr = $.ajax({
				url: JSONReader,
				data: data,
				dataType: ieLT10 ? 'jsonp' : 'json',
				cache: !ieLT10
			});

		xhr.success(function(data){
			if (data.status === 200)
				callback(data.data);
			else
				callback(false);
		}).error(function(){
			callback(false);
		});

		// IE's that are lower than 10 cannot proccess json urls so we need to use jsonp
		// but because of the 'use strict' mode it's will be an error and also 'use strict'
		// mode in not supported by IE's that are lower than 10 :|
		if (ieLT10) {
			mightySliderCallback = function(data) {
				if (data.status === 200)
					callback(data.data);
				else
					callback(false);
			};
		}
	}

	/**
	 * A JavaScript equivalent of PHP’s rawurlencode.
	 *
	 * @param {String} str
	 *
	 * @return {String}
	 */
	function rawurlencode(str) {
		str = (str + '').toString();

		// Tilde should be allowed unescaped in future versions of PHP (as reflected below), but if you want to reflect current
		// PHP behavior, you would need to add ".replace(/~/g, '%7E');" to the following.
		return encodeURIComponent(str)[replace](/!/g, '%21')[replace](/'/g, '%27')[replace](/\(/g, '%28')
		[replace](/\)/g, '%29')[replace](/\*/g, '%2A');
	}

	/**
	 * A JavaScript equivalent of PHP’s ucfirst.
	 *
	 * @param {String} str
	 *
	 * @return {String}
	 */
	function ucfirst(str) {
		str += '';
		var f = str.charAt(0).toUpperCase();
		return f + str.substr(1);
	}


	/**
	 * Get type via extension.
	 *
	 * @param {String} URL
	 *
	 * @return {String}
	 */
	function getTypeByExtension(URL){
		if (!URL) {
			return false;
		}

		var ext = _.getExtension(URL),
			type;

		if (!ext) {
			return false;
		}

		ext = ext.toLowerCase();
		
		if(indexOf.call(extensions.image, ext) !== -1) type = 'image';
		else if(indexOf.call(extensions.flash, ext) !== -1) type = 'flash';
		else if(indexOf.call(extensions.video, ext) !== -1) type = 'video';
		else type = 'iframe';
		
		return type;
	}

	/**
	 * Cross browser & normalize mouse event offsetX/offsetY.
	 *
	 * @param {Object}  event
	 * @param {DOM}     target
	 *
	 * @return {Object}
	 */
	function getOffset(event, target) {
		var e = event || window.event || { clientX: 0, clientY: 0 },
			el = target || e.target || e.srcElement,
			borderLeftWidth = parseInt(target.style['borderLeftWidth'], 10) || 0,
			borderTopWidth = parseInt(target.style['borderLeftWidth'], 10) || 0,
			rect = el.getBoundingClientRect(),
			offsetX = e.clientX - borderLeftWidth - rect.left,
			offsetY = e.clientY - borderTopWidth - rect.top;

		return { x: offsetX, y: offsetY };
	}

	/**
	 * Convert HH:MM:SS string to seconds.
	 *
	 * @param {String}  str
	 *
	 * @return {Number}
	 */
	function hmsToSeconds(str) {
		var p = str.split(':'),
		s = 0, m = 1;

		while (p[length] > 0) {
			s += m * parseFloat(p.pop(), 10);
			m *= 60;
		}

		return s;
	}

	/**
	 * Slides contents scale handler.
	 *
	 * @param {Object}  $frame
	 * @param {Object}  scalers
	 *
	 * @return {Void}
	 */
	function scalersHandler($frame, scalers) {
		if (typeof TweenMax === 'undefined' || scalers[length] < 1) {
			if (scalers[length] > 0) {
				console && console.warn('Scalers needs TweenMax function. Please include the "tweenmax.js" into your page.');
			}
			return;
		}

		var viewport = { width: getPixel($frame, width), height: getPixel($frame, height) };
		_each(scalers, function(el) {
			var $this = $(el),
				offset = { width: el.getAttribute(width) || getPixel($this, width), height: el.getAttribute(height) || getPixel($this, height) },
				dims = calculateDimensions(viewport[width], viewport[height], offset[width], offset[height]);

			TweenMax.set(el, { scale: dims.ratio >= 1 ? 1 : dims.ratio });
		});
	}

	/**
	 * A JavaScript equivalent of PHP’s version_compare.
	 *
	 * @param {String} v1
	 * @param {String} v2
	 * @param {String} operator
	 *
	 * @return {Boolean}
	 */
	function version_compare(v1, v2, operator) {
		// Important: compare must be initialized at 0.
		var i = 0,
		x = 0,
		compare = 0,
		// vm maps textual PHP versions to negatives so they're less than 0.
		// PHP currently defines these as CASE-SENSITIVE. It is important to
		// leave these as negatives so that they can come before numerical versions
		// and as if no letters were there to begin with.
		// (1alpha is < 1 and < 1.1 but > 1dev1)
		// If a non-numerical value can't be mapped to this table, it receives
		// -7 as its value.
		vm = {
			'dev': -6,
			'alpha': -5,
			'a': -5,
			'beta': -4,
			'b': -4,
			'RC': -3,
			'rc': -3,
			'#': -2,
			'p': 1,
			'pl': 1
		},
		// This function will be called to prepare each version argument.
		// It replaces every _, -, and + with a dot.
		// It surrounds any nonsequence of numbers/dots with dots.
		// It replaces sequences of dots with a single dot.
		//    version_compare('4..0', '4.0') == 0
		// Important: A string of 0 length needs to be converted into a value
		// even less than an unexisting value in vm (-7), hence [-8].
		// It's also important to not strip spaces because of this.
		//   version_compare('', ' ') == 1
		prepVersion = function (v) {
			v = ('' + v)[replace](/[_\-+]/g, '.');
			v = v[replace](/([^.\d]+)/g, '.$1.')[replace](/\.{2,}/g, '.');
			return (!v[length] ? [-8] : v.split('.'));
		},
		// This converts a version component to a number.
		// Empty component becomes 0.
		// Non-numerical component becomes a negative number.
		// Numerical component becomes itself as an integer.
		numVersion = function (v) {
			return !v ? 0 : (isNaN(v) ? vm[v] || -7 : parseInt(v, 10));
		};
		v1 = prepVersion(v1);
		v2 = prepVersion(v2);
		x = Math.max(v1[length], v2[length]);
		for (i = 0; i < x; i++) {
			if (v1[i] === v2[i]) {
				continue;
			}
			v1[i] = numVersion(v1[i]);
			v2[i] = numVersion(v2[i]);
			if (v1[i] < v2[i]) {
				compare = -1;
				break;
			}
			else if (v1[i] > v2[i]) {
				compare = 1;
				break;
			}
		}
		if (!operator) {
			return compare;
		}

		// "No operator" seems to be treated as "<."
		// Any other values seem to make the function return null.
		switch (operator) {
			case '>':
			return (compare > 0);
			case '>=':
			return (compare >= 0);
			case '<=':
			return (compare <= 0);
			case '==':
			return (compare === 0);
			case '!=':
			return (compare !== 0);
			case '<':
			return (compare < 0);
			default:
			return null;
		}
	}

	// Local WindowAnimationTiming interface polyfill
	(function (w) {
		/**
		* Fallback implementation.
		*/
		var prev = _now();
		function fallback(fn) {
			var curr = _now();
			var ms = Math.max(0, 16 - (curr - prev));
			var req = setTimeout(fn, ms);
			prev = curr;
			return req;
		}

		/**
		* Cancel.
		*/
		var cancel = w.cancelAnimationFrame
			|| w.webkitCancelAnimationFrame
			|| w.clearTimeout;

		requestAnimationFrame = w.requestAnimationFrame
			|| w.webkitRequestAnimationFrame
			|| fallback;

		cancelAnimationFrame = function(id){
			cancel.call(w, id);
		};
	}(window));

	// Feature detects
	(function () {
		var prefixes = ['', 'webkit', 'moz', 'ms', 'o'];
		var el = document.createElement('div');

		function testProp(prop) {
			for (var p = 0, pl = prefixes[length]; p < pl; p++) {
				var prefixedProp = prefixes[p] ? prefixes[p] + prop.charAt(0).toUpperCase() + prop.slice(1) : prop;
				if (el.style[prefixedProp] != null) {
					return prefixedProp;
				}
			}
		}

		// Global support indicators
		transform = testProp('transform');
		gpuAcceleration = testProp('perspective') ? 'translateZ(0) ' : '';

		// Hardware acceleration for mozilla
		if (_.browser.mozilla && gpuAcceleration) {
			gpuAcceleration += 'rotate(0.0001deg) ';
		}
	}());

	// PageVisibility API detects
	(function () {
		var prefixes = ['o', 'ms', 'moz', 'webkit', ''], property, prefix;

		while ((prefix = prefixes.pop()) != undefined) {
			property = (prefix[length] ? prefix + 'H': 'h') + 'idden';
			if (type(document[property]) === 'boolean') {
				visibilityEvent = prefix + 'visibilitychange';
				break;
			}
		}

		visibilityHidden = function() {
			return document[property]; 
		};
	}());
	
	/**
	 * matchMedia() polyfill - Test a CSS media type/query in JS.
	 * @Authors & @Copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight.
	 * @license: Dual MIT/BSD license
	 */
	window.matchMedia || (window.matchMedia = function () {
		// For browsers that support matchMedium api such as IE 9 and webkit
		var styleMedia = (window.styleMedia || window.media);

		// For those that don't support matchMedium
		// For those that don't support matchMedium
		if (!styleMedia) {
			var style = document.createElement('style'),
				script = document.getElementsByTagName('script')[0],
				info = null;

			style.type = 'text/css';
			style.id = 'matchmediajs-test';

			script.parentNode.insertBefore(style, script);

			// 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers
			info = ('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;

			styleMedia = {
				matchMedium: function (media) {
					var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';

					// 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers
					if (style.styleSheet) {
						style.styleSheet.cssText = text;
					} else {
						style.textContent = text;
					}

					// Test if media query is true or false
					return info[width] === '1px';
				}
			};
		}

		return function (media) {
			return {
				matches: styleMedia.matchMedium(media || 'all'),
				media: media || 'all'
			};
		};
	}());


	/*
		Customized jQuery hashchange event v1.3
		https://github.com/cowboy/jquery-hashchange
		Copyright (c) 2010 "Cowboy" Ben Alman
		Dual licensed under the MIT and GPL licenses.
	*/
	(function () {
		var str_hashchange = "hashchange", doc = document, fake_onhashchange, special = $.event.special, doc_mode = doc.documentMode, supports_onhashchange = "on" + str_hashchange in window && (doc_mode === undefined || doc_mode > 7);
		function get_fragment(url) {
			url = url || location.href;
			return "#" + url[replace](/^[^#]*#?(.*)$/, "$1");
		}
		$.fn[str_hashchange] = function(fn) {
			return fn ? this.bind(str_hashchange, fn) : this.trigger(str_hashchange);
		};
		$.fn[str_hashchange].delay = 50;
		special[str_hashchange] = $.extend(special[str_hashchange], {setup:function() {
			if(supports_onhashchange) {
				return false;
			}
			$(fake_onhashchange.start);
		}, teardown:function() {
			if(supports_onhashchange) {
				return false;
			}
			$(fake_onhashchange.stop);
		}});
		fake_onhashchange = function() {
			var self = {}, timeout_id, last_hash = get_fragment(), fn_retval = function(val) {
				return val;
			}, history_set = fn_retval, history_get = fn_retval;
			self.start = function() {
				timeout_id || poll();
			};
			self.stop = function() {
				timeout_id && clearTimeout(timeout_id);
				timeout_id = undefined;
			};
			function poll() {
				var hash = get_fragment(), history_hash = history_get(last_hash);
				if(hash !== last_hash) {
					history_set(last_hash = hash, history_hash);
					$(window).trigger(str_hashchange);
				}else {
					if(history_hash !== last_hash) {
						location.href = location.href[replace](/#.*/, "") + history_hash;
					}
				}
				timeout_id = setTimeout(poll, $.fn[str_hashchange].delay);
			}
			(_.browser.msie) && !supports_onhashchange && function() {
				var iframe, iframe_src;
				self.start = function() {
					if(!iframe) {
						iframe_src = $.fn[str_hashchange].src;
						iframe_src = iframe_src && iframe_src + get_fragment();
						iframe = $('<iframe tabindex="-1" title="empty"/>').hide().one("load", function() {
							iframe_src || history_set(get_fragment());
							poll();
						}).attr("src", iframe_src || "javascript:0").insertAfter("body")[0].contentWindow;
						doc.onpropertychange = function() {
							try {
								if(event.propertyName === "title") {
									iframe.document.title = doc.title;
								}
							}catch(e) {}
						};
					}
				};
				self.stop = fn_retval;
				history_get = function() {
					return get_fragment(iframe.location.href);
				};
				history_set = function(hash, history_hash) {
					var iframe_doc = iframe.document, domain = $.fn[str_hashchange].domain;
					if(hash !== history_hash) {
						iframe_doc.title = doc.title;
						iframe_doc.open();
						domain && iframe_doc.write('<script>document.domain="' + domain + '"\x3c/script>');
						iframe_doc.close();
						iframe.location.hash = hash;
					}
				};
			}();
			return self;
		}();
	}());

	// Expose class globally
	window.mightySlider = mightySlider;

	mightySlider.author  		= 'iProDev (Hemn Chawroka). (www.iprodev.com)';
	mightySlider.version 		= '3.0.0';
	mightySlider.releaseDate 	= 'August 3, 2017';
	mightySlider.isPremium 		= true;

	// Begin the plugin
	$.fn[namespace] = function(options, callbackMap) {
		if (version_compare($.fn.jquery, '1.7', '>=')) {
			var method, methodArgs;

			// Attributes logic
			if (!isObject(options)) {
				if (type(options) === 'string' || options === false) {
					method = options === false ? 'destroy' : options;
					methodArgs = slice.call(arguments, 1);
				}
				options = {};
			}

			// Apply to all elements
			return this.each(function (i, element) {
				// Call with prevention against multiple instantiations
				var plugin = $.data(element, namespace);

				if (!plugin && !method) {
					// Create a new object if it doesn't exist yet
					plugin = $.data(element, namespace, new mightySlider(element, options, callbackMap).init());
				}
				else if (plugin && method) {
					// Call method
					if (plugin[method]) {
						plugin[method].apply(plugin, methodArgs);
					}
				}
			});
		}
		else {
			throw new msError("The jQuery version that was loaded is too old. mightySlider requires jQuery 1.7+", new Error());
		}
	};

	// Default options
	mightySlider.defaults = {
		// Mixed options
		moveBy:             300,        // Speed in pixels per second used by forward and backward buttons.
		speed:              300,        // Animations speed in milliseconds. 0 to disable animations.
		easing:             'swing',    // Easing for duration based (tweening) animations.
		startAt:            0,          // Starting offset in slides.
		startRandom:        false,      // Starting offset in slides randomly, where: true = random, false = disable.
		viewport:           'fill',     // Sets the resizing method used to fit cover image within the viewport. Can be: 'center', 'fit', 'fill', 'stretch'.
		autoScale:          false,      // Automatically updates slider height based on base width.
		autoResize:         false,      // Auto resize the slider when active slide is bigger than slider FRAME.
		videoFrame:         null,       // The URL of the video frame to play videos with your custom player.
		preloadMode:        'nearby',   // Preloading mode for slides covers. Can be: 'all', 'nearby', 'instant'.
		reverseLayers:      0,          // Enable reverse the animation layers speed when the slide changed. where: 0 = disable
		watchCSS:           0,          // Slides sizing based on their default CSS dimensions.

		// Navigation
		navigation: {
			horizontal:      true,            // Switch to horizontal mode.
			navigationType:  'forceCentered', // Slide navigation type. Can be: 'basic', 'centered', 'forceCentered'.
			slideSelector:   null,            // Select only slides that match this selector.
			smart:           true,            // Repositions the activated slide to help with further navigation.
			activateOn:      null,            // Activate an slide on this event. Can be: 'click', 'mouseenter', ...
			activateMiddle:  true,            // Always activate the slide in the middle of the FRAME. forceCentered only.
			slideSize:       0,               // Sets the slides size. Can be: Fixed(500) or Percent('100%') number.
			keyboardNavBy:   null,            // Enable keyboard navigation by 'slides' or 'pages'.
			loop:            false,           // Enable loop for when you are at the start or end of the SLIDEELEMENT.
			freeScroll:      false            // Enables slider to be freely scrolled.
		},

		// Deep-Linking
		deeplinking: {
			linkID:     null,  // Sets the deeplinking id.
			scrollTo:   false, // Enable scroll to slider when link changed.
			separator:  '/'    // Separator between linkID and slide ID.
		},

		// Scrolling
		scrolling: {
			scrollSource: null, // Selector or DOM element for catching the mouse wheel scrolling. Default is FRAME.
			scrollBy:     0,    // Slides to move per one mouse scroll. 0 to disable scrolling.
			hijack:       300   // Milliseconds since last wheel event after which it is acceptable to hijack global scroll.
		},

		// Dragging
		dragging: {
			dragSource:    null,  // Selector or DOM element for catching dragging events. Default is FRAME.
			mouseDragging: true,  // Enable navigation by dragging the SLIDEELEMENT with mouse cursor.
			touchDragging: true,  // Enable navigation by dragging the SLIDEELEMENT with touch events.
			releaseSwing:  true,  // Ease out on dragging swing release.
			swingSync:     7.5,   // Swing synchronization.
			swingSpeed:    0.1,   // Swing synchronization speed, where: 1 = instant, 0 = infinite.
			elasticBounds: true,  // Stretch SLIDEELEMENT position limits when dragging past FRAME boundaries.
			syncSpeed:     0.5,   // SLIDEELEMENT synchronization speed, where: 1 = instant, 0 = infinite.
			onePage:       false, // Enable one page move per drag, where: true = enable, false = disable.
			interactive:   null   // Selector for special interactive elements.
		},

		// Scrollbar
		scrollBar: {
			scrollBarSource:   null, // Selector or DOM element for scrollbar container.
			dragHandle:        true, // Whether the scrollbar handle should be draggable.
			dynamicHandle:     true, // Scrollbar handle represents the ratio between hidden and visible content.
			minHandleSize:     50,   // Minimal height or width (depends on mightySlider direction) of a handle in pixels.
			clickBar:          true  // Enable navigation by clicking on scrollbar.
		},

		// Pages
		pages: {
			pagesBar:       null, // Selector or DOM element for pages bar container.
			activateOn:     null, // Event used to activate page. Can be: click, mouseenter, ...
			pageBuilder:          // Page item generator.
				function (index) {
					return '<li>' + (index + 1) + '</li>';
				}
		},

		// Thumbnails
		thumbnails: {
			thumbnailsBar:       null,    // Selector or DOM element for thumbnails bar container.
			horizontal:          true,    // Switch to horizontal mode.
			watchCSS:            0,       // Thumbnails sizing based on their default CSS dimensions.
			preloadThumbnails:   true,    // Enable preload thumbnails images.
			thumbnailNav:        'basic', // Thumbnail navigation type. Can be: 'basic', 'centered', 'forceCentered'.
			activateOn:          'click', // Event used to activate thumbnail. Can be: click, mouseenter, ...
			scrollBy:            1,       // Thumbnails to move per one mouse scroll. 0 to disable scrolling.
			mouseDragging:       true,    // Enable navigation by dragging the thumbnailsBar with mouse cursor.
			touchDragging:       true,    // Enable navigation by dragging the thumbnailsBar with touch events.
			thumbnailSize:       0,       // Set thumbnails size. Can be: 500 and '100%'.
			thumbnailBuilder:             // Thumbnail item generator.
				function (index, thumbnail) {
					return '<li><img src="' + thumbnail + '" /></li>';
				}
		},

		// Commands
		commands: {
			thumbnails:     false, // Enable thumbnails navigation.
			pages:          false, // Enable pages navigation.
			buttons:        false  // Enable navigation buttons.
		},

		// Navigation buttons
		buttons: {
			forward:    null, // Selector or DOM element for "forward movement" button.
			backward:   null, // Selector or DOM element for "backward movement" button.
			prev:       null, // Selector or DOM element for "previous slide" button.
			next:       null, // Selector or DOM element for "next slide" button.
			prevPage:   null, // Selector or DOM element for "previous page" button.
			nextPage:   null, // Selector or DOM element for "next page" button.
			fullScreen: null  // Selector or DOM element for "fullscreen" button.
		},

		// Automated cycling
		cycling: {
			cycleBy:       null,   // Enable automatic cycling by 'slides' or 'pages'.
			pauseTime:     5000,   // Delay between cycles in milliseconds.
			loop:          true,   // Repeat cycling when last slide/page is activated.
			pauseOnHover:  false,  // Pause cycling when mouse hovers over the FRAME.
			startPaused:   false   // Whether to start in paused sate.
		},

		// Parallax
		parallax: {
			x:                true,          // Move in X axis parallax layers. where: true = enable, false = disable.
			y:                true,          // Move in Y axis parallax layers. where: true = enable, false = disable.
			z:                false,         // Move in Z axis parallax layers. where: true = enable, false = disable.
			invertX:          true,          // Invert X axis movements. where: true = enable, false = disable.
			invertY:          true,          // Invert Y axis movements. where: true = enable, false = disable.
			invertZ:          false,         // Invert Z axis movements. where: true = enable, false = disable.
			revert:           true,          // Whether the layers should revert to theirs start position when mouse leaved the slider. where: true = enable, false = disable.
			revertDuration:   1500,          // The duration of the revert animation, in milliseconds.
			revertEasing:     'easeOutExpo', // Easing for revert duration based (tweening) animations.
			frictionDuration: 1500,          // The duration of the friction the layers experience. 0 to disable friction.
			frictionEasing:   'easeOutExpo'  // Easing for friction duration based (tweening) animations.
		},

		// Classes
		classes: {
			isTouchClass:        'isTouch',        // Class for when device has touch ability.
			isRetinaClass:       'isRetina',       // Class for when device has retina display.
			draggedClass:        'dragged',        // Class for dragged SLIDEELEMENT.
			activeClass:         'active',         // Class for active slides and pages.
			disabledClass:       'disabled',       // Class for disabled navigation elements.
			verticalClass:       'vertical',       // Class for vertical sliding mode.
			horizontalClass:     'horizontal',     // Class for horizontal sliding mode.
			showedLayersClass:   'showed',         // Class for showed layers.
			isPaused:            'isPaused',       // Class for when slider is paused.
			isInFullScreen:      'isInFullScreen', // Class for when slider is in fullscreen.
			isInFreeze:          'isInFreeze'      // Class for when slider is in freeze mode.
		}
	};

	// Defining easeOutExpo jQuery easing
	jQuery.easing['easeOutExpo'] = function (x, t, b, c, d) {
		return (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;
	};

	var imagePreloader = function (images) {
		var self = this;
		var loadedCount = 0;

		var imagesLength = images[length];

		var preload = function(image) {
			var img = new Image();

			img.onload = function () {
				progress({
					isLoaded: true,
					img: img
				});
			};
			img.onerror = function () {
				progress({
					isLoaded: false,
					img: img
				});
			};
			img.src = image;
		};

		var progress = function(image) {
			loadedCount++;

			if (loadedCount >= imagesLength) {
				self.done.call(self);
			}
			else {
				preload(images[loadedCount]);
			}
		};
	};

})(jQuery, this);

/*!
 * screenfull
 * v2.0.0 - 2014-12-22
 * (c) Sindre Sorhus; MIT License
 */
(function() {
	'use strict';

	var isCommonjs = typeof module !== 'undefined' && module.exports;
	var keyboardAllowed = typeof Element !== 'undefined' && 'ALLOW_KEYBOARD_INPUT' in Element;

	var fn = (function() {
		var val;
		var valLength;

		var fnMap = [
			[
				'requestFullscreen',
				'exitFullscreen',
				'fullscreenElement',
				'fullscreenEnabled',
				'fullscreenchange',
				'fullscreenerror'
			],
			// new WebKit
			[
				'webkitRequestFullscreen',
				'webkitExitFullscreen',
				'webkitFullscreenElement',
				'webkitFullscreenEnabled',
				'webkitfullscreenchange',
				'webkitfullscreenerror'

			],
			// old WebKit (Safari 5.1)
			[
				'webkitRequestFullScreen',
				'webkitCancelFullScreen',
				'webkitCurrentFullScreenElement',
				'webkitCancelFullScreen',
				'webkitfullscreenchange',
				'webkitfullscreenerror'

			],
			[
				'mozRequestFullScreen',
				'mozCancelFullScreen',
				'mozFullScreenElement',
				'mozFullScreenEnabled',
				'mozfullscreenchange',
				'mozfullscreenerror'
			],
			[
				'msRequestFullscreen',
				'msExitFullscreen',
				'msFullscreenElement',
				'msFullscreenEnabled',
				'MSFullscreenChange',
				'MSFullscreenError'
			]
		];

		var i = 0;
		var l = fnMap.length;
		var ret = {};

		for (; i < l; i++) {
			val = fnMap[i];
			if (val && val[1] in document) {
				for (i = 0, valLength = val.length; i < valLength; i++) {
					ret[fnMap[0][i]] = val[i];
				}
				return ret;
			}
		}

		return false;
	})();

	var screenfull = {
		request: function(elem) {
			var request = fn.requestFullscreen;

			elem = elem || document.documentElement;

			// Work around Safari 5.1 bug: reports support for
			// keyboard in fullscreen even though it doesn't.
			// Browser sniffing, since the alternative with
			// setTimeout is even worse.
			if (/5\.1[\.\d]* Safari/.test(navigator.userAgent)) {
				elem[request]();
			} else {
				elem[request](keyboardAllowed && Element.ALLOW_KEYBOARD_INPUT);
			}
		},
		exit: function() {
			document[fn.exitFullscreen]();
		},
		toggle: function(elem) {
			if (this.isFullscreen) {
				this.exit();
			} else {
				this.request(elem);
			}
		},
		raw: fn
	};

	if (!fn) {
		if (isCommonjs) {
			module.exports = false;
		} else {
			window.screenfull = false;
		}

		return;
	}

	Object.defineProperties(screenfull, {
		isFullscreen: {
			get: function() {
				return !!document[fn.fullscreenElement];
			}
		},
		element: {
			enumerable: true,
			get: function() {
				return document[fn.fullscreenElement];
			}
		},
		enabled: {
			enumerable: true,
			get: function() {
				// Coerce to boolean in case of old WebKit
				return !!document[fn.fullscreenEnabled];
			}
		}
	});

	if (isCommonjs) {
		module.exports = screenfull;
	} else {
		window.screenfull = screenfull;
	}
})();



/**
 * isMobile.js v0.3.6
 *
 * A simple library to detect Apple phones and tablets,
 * Android phones and tablets, other mobile devices (like blackberry, mini-opera and windows phone),
 * and any kind of seven inch device, via user agent sniffing.
 *
 * @author: Kai Mallea (kmallea@gmail.com)
 *
 * @license: http://creativecommons.org/publicdomain/zero/1.0/
 */
(function(global) {

	var apple_phone = /iPhone/i,
		apple_ipod = /iPod/i,
		apple_tablet = /iPad/i,
		android_phone = /(?=.*\bAndroid\b)(?=.*\bMobile\b)/i, // Match 'Android' AND 'Mobile'
		android_tablet = /Android/i,
		windows_phone = /IEMobile/i,
		windows_tablet = /(?=.*\bWindows\b)(?=.*\bARM\b)/i, // Match 'Windows' AND 'ARM'
		other_blackberry = /BlackBerry/i,
		other_blackberry_10 = /BB10/i,
		other_opera = /Opera Mini/i,
		other_firefox = /(?=.*\bFirefox\b)(?=.*\bMobile\b)/i, // Match 'Firefox' AND 'Mobile'
		seven_inch = new RegExp(
			'(?:' + // Non-capturing group

			'Nexus 7' + // Nexus 7

			'|' + // OR

			'BNTV250' + // B&N Nook Tablet 7 inch

			'|' + // OR

			'Kindle Fire' + // Kindle Fire

			'|' + // OR

			'Silk' + // Kindle Fire, Silk Accelerated

			'|' + // OR

			'GT-P1000' + // Galaxy Tab 7 inch

			')', // End non-capturing group

			'i'); // Case-insensitive matching

	var match = function(regex, userAgent) {
		return regex.test(userAgent);
	};

	var IsMobileClass = function(userAgent) {
		var ua = userAgent || navigator.userAgent;

		this.apple = {
			phone: match(apple_phone, ua),
			ipod: match(apple_ipod, ua),
			tablet: match(apple_tablet, ua),
			device: match(apple_phone, ua) || match(apple_ipod, ua) || match(apple_tablet, ua)
		};
		this.android = {
			phone: match(android_phone, ua),
			tablet: !match(android_phone, ua) && match(android_tablet, ua),
			device: match(android_phone, ua) || match(android_tablet, ua)
		};
		this.windows = {
			phone: match(windows_phone, ua),
			tablet: match(windows_tablet, ua),
			device: match(windows_phone, ua) || match(windows_tablet, ua)
		};
		this.other = {
			blackberry: match(other_blackberry, ua),
			blackberry10: match(other_blackberry_10, ua),
			opera: match(other_opera, ua),
			firefox: match(other_firefox, ua),
			device: match(other_blackberry, ua) || match(other_blackberry_10, ua) || match(other_opera, ua) || match(other_firefox, ua)
		};
		this.seven_inch = match(seven_inch, ua);
		this.any = this.apple.device || this.android.device || this.windows.device || this.other.device || this.seven_inch;
		// excludes 'other' devices and ipods, targeting touchscreen phones
		this.phone = this.apple.phone || this.android.phone || this.windows.phone;
		// excludes 7 inch devices, classifying as phone or tablet is left to the user
		this.tablet = this.apple.tablet || this.android.tablet || this.windows.tablet;

		if (typeof window === 'undefined') {
			return this;
		}
	};

	var instantiate = function() {
		var IM = new IsMobileClass();
		IM.Class = IsMobileClass;
		return IM;
	};

	if (typeof module != 'undefined' && module.exports && typeof window === 'undefined') {
		//node
		module.exports = IsMobileClass;
	} else if (typeof module != 'undefined' && module.exports && typeof window !== 'undefined') {
		//browserify
		module.exports = instantiate();
	} else if (typeof define === 'function' && define.amd) {
		//AMD
		define('isMobile', [], global.isMobile = instantiate());
	} else {
		global.isMobile = instantiate();
	}

})(this);

(function($, specialEventName) {
	'use strict';

	/**
	 * Native event names for creating custom one.
	 *
	 * @type {Object}
	 */
	var nativeEvent = Object.create(null);
	/**
	 * Get current time.
	 *
	 * @return {Number}
	 */
	var getTime = function() {
		return new Date().getTime();
	};

	var threshold = 10;

	nativeEvent.original = 'click';
/*
	if ('onmspointerdown' in document) {
		nativeEvent.start = 'MSPointerDown';
		nativeEvent.end = 'MSPointerUp';
	} else if ('ontouchstart' in document) {
		nativeEvent.start = 'touchstart';
		nativeEvent.end = 'touchend';
	} else {
		nativeEvent.start = 'mousedown';
		nativeEvent.end = 'mouseup';
	}
*/
	nativeEvent.start = 'touchstart MSPointerDown mousedown';
	nativeEvent.end = 'touchend MSPointerUp mouseup';

	$.event.special[specialEventName] = {
		setup: function(data, namespaces, eventHandle) {
			var $element = $(this);
			var eventData = {};

			$element
			// Remove all handlers that were set for an original event.
				.off(nativeEvent.original)
				// Prevent default actions.
				.on(nativeEvent.original, false)
				// Split original event by two different and collect an information
				// on every phase.
				.on(nativeEvent.start + ' ' + nativeEvent.end, function(event) {
					// Handle the event system of touchscreen devices.
					eventData.event = event.originalEvent.changedTouches ? event.originalEvent.changedTouches[0] : event;
				})
				.on(nativeEvent.start, function(event) {
					// Stop execution if an event is simulated.
					if (event.which && event.which !== 1) {
						return;
					}

					eventData.target = event.target;
					eventData.pageX = eventData.event.pageX;
					eventData.pageY = eventData.event.pageY;
					eventData.time = getTime();
				})
				.on(nativeEvent.end, function(event) {
					// Compare properties from two phases.
					if (
						// The target should be the same.
						eventData.target === event.target &&
						// Time between first and last phases should be less than 750 ms.
						getTime() - eventData.time < 750 &&
						// Coordinates, when event ends, should be the same as they were
						// on start.
						(
							Math.abs(eventData.pageX - eventData.event.pageX) < threshold &&
							Math.abs(eventData.pageY - eventData.event.pageY) < threshold
						)
					) {
						event.type = specialEventName;
						event.pageX = eventData.event.pageX;
						event.pageY = eventData.event.pageY;

						eventHandle.call(this, event);

						// If an event wasn't prevented then execute original actions.
						if (!event.isDefaultPrevented()) {
							$element
							// Remove prevention of default actions.
								.off(nativeEvent.original)
								// Bring the action.
								.trigger(nativeEvent.original);
						}
					}
				});
		},

		remove: function() {
			$(this).off(nativeEvent.start + ' ' + nativeEvent.end);
		}
	};

	$.fn[specialEventName] = function(fn) {
		return this[fn ? 'on' : 'trigger'](specialEventName, fn);
	};
})(jQuery, 'msclick');





/*!
 * VERSION: 1.17.0
 * DATE: 2015-05-27
 * UPDATES AND DOCS AT: http://greensock.com
 * 
 * Includes all of the following: TweenLite, TweenMax, TimelineLite, TimelineMax, EasePack, CSSPlugin, RoundPropsPlugin, BezierPlugin, AttrPlugin, DirectionalRotationPlugin
 *
 * @license Copyright (c) 2008-2015, GreenSock. All rights reserved.
 * This work is subject to the terms at http://greensock.com/standard-license or for
 * Club GreenSock members, the software agreement that was issued with your membership.
 * 
 * @author: Jack Doyle, jack@greensock.com
 **/
var _gsScope="undefined"!=typeof module&&module.exports&&"undefined"!=typeof global?global:this||window;(_gsScope._gsQueue||(_gsScope._gsQueue=[])).push(function(){"use strict";_gsScope._gsDefine("TweenMax",["core.Animation","core.SimpleTimeline","TweenLite"],function(t,e,i){var s=function(t){var e,i=[],s=t.length;for(e=0;e!==s;i.push(t[e++]));return i},r=function(t,e,s){i.call(this,t,e,s),this._cycle=0,this._yoyo=this.vars.yoyo===!0,this._repeat=this.vars.repeat||0,this._repeatDelay=this.vars.repeatDelay||0,this._dirty=!0,this.render=r.prototype.render},n=1e-10,a=i._internals,o=a.isSelector,h=a.isArray,l=r.prototype=i.to({},.1,{}),_=[];r.version="1.17.0",l.constructor=r,l.kill()._gc=!1,r.killTweensOf=r.killDelayedCallsTo=i.killTweensOf,r.getTweensOf=i.getTweensOf,r.lagSmoothing=i.lagSmoothing,r.ticker=i.ticker,r.render=i.render,l.invalidate=function(){return this._yoyo=this.vars.yoyo===!0,this._repeat=this.vars.repeat||0,this._repeatDelay=this.vars.repeatDelay||0,this._uncache(!0),i.prototype.invalidate.call(this)},l.updateTo=function(t,e){var s,r=this.ratio,n=this.vars.immediateRender||t.immediateRender;e&&this._startTime<this._timeline._time&&(this._startTime=this._timeline._time,this._uncache(!1),this._gc?this._enabled(!0,!1):this._timeline.insert(this,this._startTime-this._delay));for(s in t)this.vars[s]=t[s];if(this._initted||n)if(e)this._initted=!1,n&&this.render(0,!0,!0);else if(this._gc&&this._enabled(!0,!1),this._notifyPluginsOfEnabled&&this._firstPT&&i._onPluginEvent("_onDisable",this),this._time/this._duration>.998){var a=this._time;this.render(0,!0,!1),this._initted=!1,this.render(a,!0,!1)}else if(this._time>0||n){this._initted=!1,this._init();for(var o,h=1/(1-r),l=this._firstPT;l;)o=l.s+l.c,l.c*=h,l.s=o-l.c,l=l._next}return this},l.render=function(t,e,i){this._initted||0===this._duration&&this.vars.repeat&&this.invalidate();var s,r,o,h,l,_,u,c,f=this._dirty?this.totalDuration():this._totalDuration,p=this._time,m=this._totalTime,d=this._cycle,g=this._duration,v=this._rawPrevTime;if(t>=f?(this._totalTime=f,this._cycle=this._repeat,this._yoyo&&0!==(1&this._cycle)?(this._time=0,this.ratio=this._ease._calcEnd?this._ease.getRatio(0):0):(this._time=g,this.ratio=this._ease._calcEnd?this._ease.getRatio(1):1),this._reversed||(s=!0,r="onComplete",i=i||this._timeline.autoRemoveChildren),0===g&&(this._initted||!this.vars.lazy||i)&&(this._startTime===this._timeline._duration&&(t=0),(0===t||0>v||v===n)&&v!==t&&(i=!0,v>n&&(r="onReverseComplete")),this._rawPrevTime=c=!e||t||v===t?t:n)):1e-7>t?(this._totalTime=this._time=this._cycle=0,this.ratio=this._ease._calcEnd?this._ease.getRatio(0):0,(0!==m||0===g&&v>0)&&(r="onReverseComplete",s=this._reversed),0>t&&(this._active=!1,0===g&&(this._initted||!this.vars.lazy||i)&&(v>=0&&(i=!0),this._rawPrevTime=c=!e||t||v===t?t:n)),this._initted||(i=!0)):(this._totalTime=this._time=t,0!==this._repeat&&(h=g+this._repeatDelay,this._cycle=this._totalTime/h>>0,0!==this._cycle&&this._cycle===this._totalTime/h&&this._cycle--,this._time=this._totalTime-this._cycle*h,this._yoyo&&0!==(1&this._cycle)&&(this._time=g-this._time),this._time>g?this._time=g:0>this._time&&(this._time=0)),this._easeType?(l=this._time/g,_=this._easeType,u=this._easePower,(1===_||3===_&&l>=.5)&&(l=1-l),3===_&&(l*=2),1===u?l*=l:2===u?l*=l*l:3===u?l*=l*l*l:4===u&&(l*=l*l*l*l),this.ratio=1===_?1-l:2===_?l:.5>this._time/g?l/2:1-l/2):this.ratio=this._ease.getRatio(this._time/g)),p===this._time&&!i&&d===this._cycle)return m!==this._totalTime&&this._onUpdate&&(e||this._callback("onUpdate")),void 0;if(!this._initted){if(this._init(),!this._initted||this._gc)return;if(!i&&this._firstPT&&(this.vars.lazy!==!1&&this._duration||this.vars.lazy&&!this._duration))return this._time=p,this._totalTime=m,this._rawPrevTime=v,this._cycle=d,a.lazyTweens.push(this),this._lazy=[t,e],void 0;this._time&&!s?this.ratio=this._ease.getRatio(this._time/g):s&&this._ease._calcEnd&&(this.ratio=this._ease.getRatio(0===this._time?0:1))}for(this._lazy!==!1&&(this._lazy=!1),this._active||!this._paused&&this._time!==p&&t>=0&&(this._active=!0),0===m&&(2===this._initted&&t>0&&this._init(),this._startAt&&(t>=0?this._startAt.render(t,e,i):r||(r="_dummyGS")),this.vars.onStart&&(0!==this._totalTime||0===g)&&(e||this._callback("onStart"))),o=this._firstPT;o;)o.f?o.t[o.p](o.c*this.ratio+o.s):o.t[o.p]=o.c*this.ratio+o.s,o=o._next;this._onUpdate&&(0>t&&this._startAt&&this._startTime&&this._startAt.render(t,e,i),e||(this._totalTime!==m||s)&&this._callback("onUpdate")),this._cycle!==d&&(e||this._gc||this.vars.onRepeat&&this._callback("onRepeat")),r&&(!this._gc||i)&&(0>t&&this._startAt&&!this._onUpdate&&this._startTime&&this._startAt.render(t,e,i),s&&(this._timeline.autoRemoveChildren&&this._enabled(!1,!1),this._active=!1),!e&&this.vars[r]&&this._callback(r),0===g&&this._rawPrevTime===n&&c!==n&&(this._rawPrevTime=0))},r.to=function(t,e,i){return new r(t,e,i)},r.from=function(t,e,i){return i.runBackwards=!0,i.immediateRender=0!=i.immediateRender,new r(t,e,i)},r.fromTo=function(t,e,i,s){return s.startAt=i,s.immediateRender=0!=s.immediateRender&&0!=i.immediateRender,new r(t,e,s)},r.staggerTo=r.allTo=function(t,e,n,a,l,u,c){a=a||0;var f,p,m,d,g=n.delay||0,v=[],y=function(){n.onComplete&&n.onComplete.apply(n.onCompleteScope||this,arguments),l.apply(c||n.callbackScope||this,u||_)};for(h(t)||("string"==typeof t&&(t=i.selector(t)||t),o(t)&&(t=s(t))),t=t||[],0>a&&(t=s(t),t.reverse(),a*=-1),f=t.length-1,m=0;f>=m;m++){p={};for(d in n)p[d]=n[d];p.delay=g,m===f&&l&&(p.onComplete=y),v[m]=new r(t[m],e,p),g+=a}return v},r.staggerFrom=r.allFrom=function(t,e,i,s,n,a,o){return i.runBackwards=!0,i.immediateRender=0!=i.immediateRender,r.staggerTo(t,e,i,s,n,a,o)},r.staggerFromTo=r.allFromTo=function(t,e,i,s,n,a,o,h){return s.startAt=i,s.immediateRender=0!=s.immediateRender&&0!=i.immediateRender,r.staggerTo(t,e,s,n,a,o,h)},r.delayedCall=function(t,e,i,s,n){return new r(e,0,{delay:t,onComplete:e,onCompleteParams:i,callbackScope:s,onReverseComplete:e,onReverseCompleteParams:i,immediateRender:!1,useFrames:n,overwrite:0})},r.set=function(t,e){return new r(t,0,e)},r.isTweening=function(t){return i.getTweensOf(t,!0).length>0};var u=function(t,e){for(var s=[],r=0,n=t._first;n;)n instanceof i?s[r++]=n:(e&&(s[r++]=n),s=s.concat(u(n,e)),r=s.length),n=n._next;return s},c=r.getAllTweens=function(e){return u(t._rootTimeline,e).concat(u(t._rootFramesTimeline,e))};r.killAll=function(t,i,s,r){null==i&&(i=!0),null==s&&(s=!0);var n,a,o,h=c(0!=r),l=h.length,_=i&&s&&r;for(o=0;l>o;o++)a=h[o],(_||a instanceof e||(n=a.target===a.vars.onComplete)&&s||i&&!n)&&(t?a.totalTime(a._reversed?0:a.totalDuration()):a._enabled(!1,!1))},r.killChildTweensOf=function(t,e){if(null!=t){var n,l,_,u,c,f=a.tweenLookup;if("string"==typeof t&&(t=i.selector(t)||t),o(t)&&(t=s(t)),h(t))for(u=t.length;--u>-1;)r.killChildTweensOf(t[u],e);else{n=[];for(_ in f)for(l=f[_].target.parentNode;l;)l===t&&(n=n.concat(f[_].tweens)),l=l.parentNode;for(c=n.length,u=0;c>u;u++)e&&n[u].totalTime(n[u].totalDuration()),n[u]._enabled(!1,!1)}}};var f=function(t,i,s,r){i=i!==!1,s=s!==!1,r=r!==!1;for(var n,a,o=c(r),h=i&&s&&r,l=o.length;--l>-1;)a=o[l],(h||a instanceof e||(n=a.target===a.vars.onComplete)&&s||i&&!n)&&a.paused(t)};return r.pauseAll=function(t,e,i){f(!0,t,e,i)},r.resumeAll=function(t,e,i){f(!1,t,e,i)},r.globalTimeScale=function(e){var s=t._rootTimeline,r=i.ticker.time;return arguments.length?(e=e||n,s._startTime=r-(r-s._startTime)*s._timeScale/e,s=t._rootFramesTimeline,r=i.ticker.frame,s._startTime=r-(r-s._startTime)*s._timeScale/e,s._timeScale=t._rootTimeline._timeScale=e,e):s._timeScale},l.progress=function(t){return arguments.length?this.totalTime(this.duration()*(this._yoyo&&0!==(1&this._cycle)?1-t:t)+this._cycle*(this._duration+this._repeatDelay),!1):this._time/this.duration()},l.totalProgress=function(t){return arguments.length?this.totalTime(this.totalDuration()*t,!1):this._totalTime/this.totalDuration()},l.time=function(t,e){return arguments.length?(this._dirty&&this.totalDuration(),t>this._duration&&(t=this._duration),this._yoyo&&0!==(1&this._cycle)?t=this._duration-t+this._cycle*(this._duration+this._repeatDelay):0!==this._repeat&&(t+=this._cycle*(this._duration+this._repeatDelay)),this.totalTime(t,e)):this._time},l.duration=function(e){return arguments.length?t.prototype.duration.call(this,e):this._duration},l.totalDuration=function(t){return arguments.length?-1===this._repeat?this:this.duration((t-this._repeat*this._repeatDelay)/(this._repeat+1)):(this._dirty&&(this._totalDuration=-1===this._repeat?999999999999:this._duration*(this._repeat+1)+this._repeatDelay*this._repeat,this._dirty=!1),this._totalDuration)},l.repeat=function(t){return arguments.length?(this._repeat=t,this._uncache(!0)):this._repeat},l.repeatDelay=function(t){return arguments.length?(this._repeatDelay=t,this._uncache(!0)):this._repeatDelay},l.yoyo=function(t){return arguments.length?(this._yoyo=t,this):this._yoyo},r},!0),_gsScope._gsDefine("TimelineLite",["core.Animation","core.SimpleTimeline","TweenLite"],function(t,e,i){var s=function(t){e.call(this,t),this._labels={},this.autoRemoveChildren=this.vars.autoRemoveChildren===!0,this.smoothChildTiming=this.vars.smoothChildTiming===!0,this._sortChildren=!0,this._onUpdate=this.vars.onUpdate;var i,s,r=this.vars;for(s in r)i=r[s],h(i)&&-1!==i.join("").indexOf("{self}")&&(r[s]=this._swapSelfInParams(i));h(r.tweens)&&this.add(r.tweens,0,r.align,r.stagger)},r=1e-10,n=i._internals,a=s._internals={},o=n.isSelector,h=n.isArray,l=n.lazyTweens,_=n.lazyRender,u=[],c=_gsScope._gsDefine.globals,f=function(t){var e,i={};for(e in t)i[e]=t[e];return i},p=a.pauseCallback=function(t,e,i,s){var n,a=t._timeline,o=a._totalTime,h=t._startTime,l=0>t._rawPrevTime||0===t._rawPrevTime&&a._reversed,_=l?0:r,c=l?r:0;if(e||!this._forcingPlayhead){for(a.pause(h),n=t._prev;n&&n._startTime===h;)n._rawPrevTime=c,n=n._prev;for(n=t._next;n&&n._startTime===h;)n._rawPrevTime=_,n=n._next;e&&e.apply(s||a.vars.callbackScope||a,i||u),(this._forcingPlayhead||!a._paused)&&a.seek(o)}},m=function(t){var e,i=[],s=t.length;for(e=0;e!==s;i.push(t[e++]));return i},d=s.prototype=new e;return s.version="1.17.0",d.constructor=s,d.kill()._gc=d._forcingPlayhead=!1,d.to=function(t,e,s,r){var n=s.repeat&&c.TweenMax||i;return e?this.add(new n(t,e,s),r):this.set(t,s,r)},d.from=function(t,e,s,r){return this.add((s.repeat&&c.TweenMax||i).from(t,e,s),r)},d.fromTo=function(t,e,s,r,n){var a=r.repeat&&c.TweenMax||i;return e?this.add(a.fromTo(t,e,s,r),n):this.set(t,r,n)},d.staggerTo=function(t,e,r,n,a,h,l,_){var u,c=new s({onComplete:h,onCompleteParams:l,callbackScope:_,smoothChildTiming:this.smoothChildTiming});for("string"==typeof t&&(t=i.selector(t)||t),t=t||[],o(t)&&(t=m(t)),n=n||0,0>n&&(t=m(t),t.reverse(),n*=-1),u=0;t.length>u;u++)r.startAt&&(r.startAt=f(r.startAt)),c.to(t[u],e,f(r),u*n);return this.add(c,a)},d.staggerFrom=function(t,e,i,s,r,n,a,o){return i.immediateRender=0!=i.immediateRender,i.runBackwards=!0,this.staggerTo(t,e,i,s,r,n,a,o)},d.staggerFromTo=function(t,e,i,s,r,n,a,o,h){return s.startAt=i,s.immediateRender=0!=s.immediateRender&&0!=i.immediateRender,this.staggerTo(t,e,s,r,n,a,o,h)},d.call=function(t,e,s,r){return this.add(i.delayedCall(0,t,e,s),r)},d.set=function(t,e,s){return s=this._parseTimeOrLabel(s,0,!0),null==e.immediateRender&&(e.immediateRender=s===this._time&&!this._paused),this.add(new i(t,0,e),s)},s.exportRoot=function(t,e){t=t||{},null==t.smoothChildTiming&&(t.smoothChildTiming=!0);var r,n,a=new s(t),o=a._timeline;for(null==e&&(e=!0),o._remove(a,!0),a._startTime=0,a._rawPrevTime=a._time=a._totalTime=o._time,r=o._first;r;)n=r._next,e&&r instanceof i&&r.target===r.vars.onComplete||a.add(r,r._startTime-r._delay),r=n;return o.add(a,0),a},d.add=function(r,n,a,o){var l,_,u,c,f,p;if("number"!=typeof n&&(n=this._parseTimeOrLabel(n,0,!0,r)),!(r instanceof t)){if(r instanceof Array||r&&r.push&&h(r)){for(a=a||"normal",o=o||0,l=n,_=r.length,u=0;_>u;u++)h(c=r[u])&&(c=new s({tweens:c})),this.add(c,l),"string"!=typeof c&&"function"!=typeof c&&("sequence"===a?l=c._startTime+c.totalDuration()/c._timeScale:"start"===a&&(c._startTime-=c.delay())),l+=o;return this._uncache(!0)}if("string"==typeof r)return this.addLabel(r,n);if("function"!=typeof r)throw"Cannot add "+r+" into the timeline; it is not a tween, timeline, function, or string.";r=i.delayedCall(0,r)}if(e.prototype.add.call(this,r,n),(this._gc||this._time===this._duration)&&!this._paused&&this._duration<this.duration())for(f=this,p=f.rawTime()>r._startTime;f._timeline;)p&&f._timeline.smoothChildTiming?f.totalTime(f._totalTime,!0):f._gc&&f._enabled(!0,!1),f=f._timeline;return this},d.remove=function(e){if(e instanceof t)return this._remove(e,!1);if(e instanceof Array||e&&e.push&&h(e)){for(var i=e.length;--i>-1;)this.remove(e[i]);return this}return"string"==typeof e?this.removeLabel(e):this.kill(null,e)},d._remove=function(t,i){e.prototype._remove.call(this,t,i);var s=this._last;return s?this._time>s._startTime+s._totalDuration/s._timeScale&&(this._time=this.duration(),this._totalTime=this._totalDuration):this._time=this._totalTime=this._duration=this._totalDuration=0,this},d.append=function(t,e){return this.add(t,this._parseTimeOrLabel(null,e,!0,t))},d.insert=d.insertMultiple=function(t,e,i,s){return this.add(t,e||0,i,s)},d.appendMultiple=function(t,e,i,s){return this.add(t,this._parseTimeOrLabel(null,e,!0,t),i,s)},d.addLabel=function(t,e){return this._labels[t]=this._parseTimeOrLabel(e),this},d.addPause=function(t,e,s,r){var n=i.delayedCall(0,p,["{self}",e,s,r],this);return n.data="isPause",this.add(n,t)},d.removeLabel=function(t){return delete this._labels[t],this},d.getLabelTime=function(t){return null!=this._labels[t]?this._labels[t]:-1},d._parseTimeOrLabel=function(e,i,s,r){var n;if(r instanceof t&&r.timeline===this)this.remove(r);else if(r&&(r instanceof Array||r.push&&h(r)))for(n=r.length;--n>-1;)r[n]instanceof t&&r[n].timeline===this&&this.remove(r[n]);if("string"==typeof i)return this._parseTimeOrLabel(i,s&&"number"==typeof e&&null==this._labels[i]?e-this.duration():0,s);if(i=i||0,"string"!=typeof e||!isNaN(e)&&null==this._labels[e])null==e&&(e=this.duration());else{if(n=e.indexOf("="),-1===n)return null==this._labels[e]?s?this._labels[e]=this.duration()+i:i:this._labels[e]+i;i=parseInt(e.charAt(n-1)+"1",10)*Number(e.substr(n+1)),e=n>1?this._parseTimeOrLabel(e.substr(0,n-1),0,s):this.duration()}return Number(e)+i},d.seek=function(t,e){return this.totalTime("number"==typeof t?t:this._parseTimeOrLabel(t),e!==!1)},d.stop=function(){return this.paused(!0)},d.gotoAndPlay=function(t,e){return this.play(t,e)},d.gotoAndStop=function(t,e){return this.pause(t,e)},d.render=function(t,e,i){this._gc&&this._enabled(!0,!1);var s,n,a,o,h,u=this._dirty?this.totalDuration():this._totalDuration,c=this._time,f=this._startTime,p=this._timeScale,m=this._paused;if(t>=u)this._totalTime=this._time=u,this._reversed||this._hasPausedChild()||(n=!0,o="onComplete",h=!!this._timeline.autoRemoveChildren,0===this._duration&&(0===t||0>this._rawPrevTime||this._rawPrevTime===r)&&this._rawPrevTime!==t&&this._first&&(h=!0,this._rawPrevTime>r&&(o="onReverseComplete"))),this._rawPrevTime=this._duration||!e||t||this._rawPrevTime===t?t:r,t=u+1e-4;else if(1e-7>t)if(this._totalTime=this._time=0,(0!==c||0===this._duration&&this._rawPrevTime!==r&&(this._rawPrevTime>0||0>t&&this._rawPrevTime>=0))&&(o="onReverseComplete",n=this._reversed),0>t)this._active=!1,this._timeline.autoRemoveChildren&&this._reversed?(h=n=!0,o="onReverseComplete"):this._rawPrevTime>=0&&this._first&&(h=!0),this._rawPrevTime=t;else{if(this._rawPrevTime=this._duration||!e||t||this._rawPrevTime===t?t:r,0===t&&n)for(s=this._first;s&&0===s._startTime;)s._duration||(n=!1),s=s._next;t=0,this._initted||(h=!0)}else this._totalTime=this._time=this._rawPrevTime=t;if(this._time!==c&&this._first||i||h){if(this._initted||(this._initted=!0),this._active||!this._paused&&this._time!==c&&t>0&&(this._active=!0),0===c&&this.vars.onStart&&0!==this._time&&(e||this._callback("onStart")),this._time>=c)for(s=this._first;s&&(a=s._next,!this._paused||m);)(s._active||s._startTime<=this._time&&!s._paused&&!s._gc)&&(s._reversed?s.render((s._dirty?s.totalDuration():s._totalDuration)-(t-s._startTime)*s._timeScale,e,i):s.render((t-s._startTime)*s._timeScale,e,i)),s=a;else for(s=this._last;s&&(a=s._prev,!this._paused||m);)(s._active||c>=s._startTime&&!s._paused&&!s._gc)&&(s._reversed?s.render((s._dirty?s.totalDuration():s._totalDuration)-(t-s._startTime)*s._timeScale,e,i):s.render((t-s._startTime)*s._timeScale,e,i)),s=a;this._onUpdate&&(e||(l.length&&_(),this._callback("onUpdate"))),o&&(this._gc||(f===this._startTime||p!==this._timeScale)&&(0===this._time||u>=this.totalDuration())&&(n&&(l.length&&_(),this._timeline.autoRemoveChildren&&this._enabled(!1,!1),this._active=!1),!e&&this.vars[o]&&this._callback(o)))}},d._hasPausedChild=function(){for(var t=this._first;t;){if(t._paused||t instanceof s&&t._hasPausedChild())return!0;t=t._next}return!1},d.getChildren=function(t,e,s,r){r=r||-9999999999;for(var n=[],a=this._first,o=0;a;)r>a._startTime||(a instanceof i?e!==!1&&(n[o++]=a):(s!==!1&&(n[o++]=a),t!==!1&&(n=n.concat(a.getChildren(!0,e,s)),o=n.length))),a=a._next;return n},d.getTweensOf=function(t,e){var s,r,n=this._gc,a=[],o=0;for(n&&this._enabled(!0,!0),s=i.getTweensOf(t),r=s.length;--r>-1;)(s[r].timeline===this||e&&this._contains(s[r]))&&(a[o++]=s[r]);return n&&this._enabled(!1,!0),a},d.recent=function(){return this._recent},d._contains=function(t){for(var e=t.timeline;e;){if(e===this)return!0;e=e.timeline}return!1},d.shiftChildren=function(t,e,i){i=i||0;for(var s,r=this._first,n=this._labels;r;)r._startTime>=i&&(r._startTime+=t),r=r._next;if(e)for(s in n)n[s]>=i&&(n[s]+=t);return this._uncache(!0)},d._kill=function(t,e){if(!t&&!e)return this._enabled(!1,!1);for(var i=e?this.getTweensOf(e):this.getChildren(!0,!0,!1),s=i.length,r=!1;--s>-1;)i[s]._kill(t,e)&&(r=!0);return r},d.clear=function(t){var e=this.getChildren(!1,!0,!0),i=e.length;for(this._time=this._totalTime=0;--i>-1;)e[i]._enabled(!1,!1);return t!==!1&&(this._labels={}),this._uncache(!0)},d.invalidate=function(){for(var e=this._first;e;)e.invalidate(),e=e._next;return t.prototype.invalidate.call(this)},d._enabled=function(t,i){if(t===this._gc)for(var s=this._first;s;)s._enabled(t,!0),s=s._next;return e.prototype._enabled.call(this,t,i)},d.totalTime=function(){this._forcingPlayhead=!0;var e=t.prototype.totalTime.apply(this,arguments);return this._forcingPlayhead=!1,e},d.duration=function(t){return arguments.length?(0!==this.duration()&&0!==t&&this.timeScale(this._duration/t),this):(this._dirty&&this.totalDuration(),this._duration)},d.totalDuration=function(t){if(!arguments.length){if(this._dirty){for(var e,i,s=0,r=this._last,n=999999999999;r;)e=r._prev,r._dirty&&r.totalDuration(),r._startTime>n&&this._sortChildren&&!r._paused?this.add(r,r._startTime-r._delay):n=r._startTime,0>r._startTime&&!r._paused&&(s-=r._startTime,this._timeline.smoothChildTiming&&(this._startTime+=r._startTime/this._timeScale),this.shiftChildren(-r._startTime,!1,-9999999999),n=0),i=r._startTime+r._totalDuration/r._timeScale,i>s&&(s=i),r=e;this._duration=this._totalDuration=s,this._dirty=!1}return this._totalDuration}return 0!==this.totalDuration()&&0!==t&&this.timeScale(this._totalDuration/t),this},d.paused=function(e){if(!e)for(var i=this._first,s=this._time;i;)i._startTime===s&&"isPause"===i.data&&(i._rawPrevTime=0),i=i._next;return t.prototype.paused.apply(this,arguments)},d.usesFrames=function(){for(var e=this._timeline;e._timeline;)e=e._timeline;return e===t._rootFramesTimeline},d.rawTime=function(){return this._paused?this._totalTime:(this._timeline.rawTime()-this._startTime)*this._timeScale},s},!0),_gsScope._gsDefine("TimelineMax",["TimelineLite","TweenLite","easing.Ease"],function(t,e,i){var s=function(e){t.call(this,e),this._repeat=this.vars.repeat||0,this._repeatDelay=this.vars.repeatDelay||0,this._cycle=0,this._yoyo=this.vars.yoyo===!0,this._dirty=!0},r=1e-10,n=e._internals,a=n.lazyTweens,o=n.lazyRender,h=new i(null,null,1,0),l=s.prototype=new t;return l.constructor=s,l.kill()._gc=!1,s.version="1.17.0",l.invalidate=function(){return this._yoyo=this.vars.yoyo===!0,this._repeat=this.vars.repeat||0,this._repeatDelay=this.vars.repeatDelay||0,this._uncache(!0),t.prototype.invalidate.call(this)},l.addCallback=function(t,i,s,r){return this.add(e.delayedCall(0,t,s,r),i)},l.removeCallback=function(t,e){if(t)if(null==e)this._kill(null,t);else for(var i=this.getTweensOf(t,!1),s=i.length,r=this._parseTimeOrLabel(e);--s>-1;)i[s]._startTime===r&&i[s]._enabled(!1,!1);return this},l.removePause=function(e){return this.removeCallback(t._internals.pauseCallback,e)},l.tweenTo=function(t,i){i=i||{};var s,r,n,a={ease:h,useFrames:this.usesFrames(),immediateRender:!1};for(r in i)a[r]=i[r];return a.time=this._parseTimeOrLabel(t),s=Math.abs(Number(a.time)-this._time)/this._timeScale||.001,n=new e(this,s,a),a.onStart=function(){n.target.paused(!0),n.vars.time!==n.target.time()&&s===n.duration()&&n.duration(Math.abs(n.vars.time-n.target.time())/n.target._timeScale),i.onStart&&n._callback("onStart")},n},l.tweenFromTo=function(t,e,i){i=i||{},t=this._parseTimeOrLabel(t),i.startAt={onComplete:this.seek,onCompleteParams:[t],callbackScope:this},i.immediateRender=i.immediateRender!==!1;var s=this.tweenTo(e,i);return s.duration(Math.abs(s.vars.time-t)/this._timeScale||.001)},l.render=function(t,e,i){this._gc&&this._enabled(!0,!1);var s,n,h,l,_,u,c=this._dirty?this.totalDuration():this._totalDuration,f=this._duration,p=this._time,m=this._totalTime,d=this._startTime,g=this._timeScale,v=this._rawPrevTime,y=this._paused,T=this._cycle;if(t>=c)this._locked||(this._totalTime=c,this._cycle=this._repeat),this._reversed||this._hasPausedChild()||(n=!0,l="onComplete",_=!!this._timeline.autoRemoveChildren,0===this._duration&&(0===t||0>v||v===r)&&v!==t&&this._first&&(_=!0,v>r&&(l="onReverseComplete"))),this._rawPrevTime=this._duration||!e||t||this._rawPrevTime===t?t:r,this._yoyo&&0!==(1&this._cycle)?this._time=t=0:(this._time=f,t=f+1e-4);else if(1e-7>t)if(this._locked||(this._totalTime=this._cycle=0),this._time=0,(0!==p||0===f&&v!==r&&(v>0||0>t&&v>=0)&&!this._locked)&&(l="onReverseComplete",n=this._reversed),0>t)this._active=!1,this._timeline.autoRemoveChildren&&this._reversed?(_=n=!0,l="onReverseComplete"):v>=0&&this._first&&(_=!0),this._rawPrevTime=t;else{if(this._rawPrevTime=f||!e||t||this._rawPrevTime===t?t:r,0===t&&n)for(s=this._first;s&&0===s._startTime;)s._duration||(n=!1),s=s._next;t=0,this._initted||(_=!0)}else 0===f&&0>v&&(_=!0),this._time=this._rawPrevTime=t,this._locked||(this._totalTime=t,0!==this._repeat&&(u=f+this._repeatDelay,this._cycle=this._totalTime/u>>0,0!==this._cycle&&this._cycle===this._totalTime/u&&this._cycle--,this._time=this._totalTime-this._cycle*u,this._yoyo&&0!==(1&this._cycle)&&(this._time=f-this._time),this._time>f?(this._time=f,t=f+1e-4):0>this._time?this._time=t=0:t=this._time));if(this._cycle!==T&&!this._locked){var x=this._yoyo&&0!==(1&T),w=x===(this._yoyo&&0!==(1&this._cycle)),b=this._totalTime,P=this._cycle,k=this._rawPrevTime,S=this._time;if(this._totalTime=T*f,T>this._cycle?x=!x:this._totalTime+=f,this._time=p,this._rawPrevTime=0===f?v-1e-4:v,this._cycle=T,this._locked=!0,p=x?0:f,this.render(p,e,0===f),e||this._gc||this.vars.onRepeat&&this._callback("onRepeat"),w&&(p=x?f+1e-4:-1e-4,this.render(p,!0,!1)),this._locked=!1,this._paused&&!y)return;this._time=S,this._totalTime=b,this._cycle=P,this._rawPrevTime=k}if(!(this._time!==p&&this._first||i||_))return m!==this._totalTime&&this._onUpdate&&(e||this._callback("onUpdate")),void 0;if(this._initted||(this._initted=!0),this._active||!this._paused&&this._totalTime!==m&&t>0&&(this._active=!0),0===m&&this.vars.onStart&&0!==this._totalTime&&(e||this._callback("onStart")),this._time>=p)for(s=this._first;s&&(h=s._next,!this._paused||y);)(s._active||s._startTime<=this._time&&!s._paused&&!s._gc)&&(s._reversed?s.render((s._dirty?s.totalDuration():s._totalDuration)-(t-s._startTime)*s._timeScale,e,i):s.render((t-s._startTime)*s._timeScale,e,i)),s=h;else for(s=this._last;s&&(h=s._prev,!this._paused||y);)(s._active||p>=s._startTime&&!s._paused&&!s._gc)&&(s._reversed?s.render((s._dirty?s.totalDuration():s._totalDuration)-(t-s._startTime)*s._timeScale,e,i):s.render((t-s._startTime)*s._timeScale,e,i)),s=h;this._onUpdate&&(e||(a.length&&o(),this._callback("onUpdate"))),l&&(this._locked||this._gc||(d===this._startTime||g!==this._timeScale)&&(0===this._time||c>=this.totalDuration())&&(n&&(a.length&&o(),this._timeline.autoRemoveChildren&&this._enabled(!1,!1),this._active=!1),!e&&this.vars[l]&&this._callback(l)))},l.getActive=function(t,e,i){null==t&&(t=!0),null==e&&(e=!0),null==i&&(i=!1);var s,r,n=[],a=this.getChildren(t,e,i),o=0,h=a.length;for(s=0;h>s;s++)r=a[s],r.isActive()&&(n[o++]=r);return n},l.getLabelAfter=function(t){t||0!==t&&(t=this._time);var e,i=this.getLabelsArray(),s=i.length;for(e=0;s>e;e++)if(i[e].time>t)return i[e].name;return null},l.getLabelBefore=function(t){null==t&&(t=this._time);for(var e=this.getLabelsArray(),i=e.length;--i>-1;)if(t>e[i].time)return e[i].name;return null},l.getLabelsArray=function(){var t,e=[],i=0;for(t in this._labels)e[i++]={time:this._labels[t],name:t};return e.sort(function(t,e){return t.time-e.time}),e},l.progress=function(t,e){return arguments.length?this.totalTime(this.duration()*(this._yoyo&&0!==(1&this._cycle)?1-t:t)+this._cycle*(this._duration+this._repeatDelay),e):this._time/this.duration()},l.totalProgress=function(t,e){return arguments.length?this.totalTime(this.totalDuration()*t,e):this._totalTime/this.totalDuration()},l.totalDuration=function(e){return arguments.length?-1===this._repeat?this:this.duration((e-this._repeat*this._repeatDelay)/(this._repeat+1)):(this._dirty&&(t.prototype.totalDuration.call(this),this._totalDuration=-1===this._repeat?999999999999:this._duration*(this._repeat+1)+this._repeatDelay*this._repeat),this._totalDuration)},l.time=function(t,e){return arguments.length?(this._dirty&&this.totalDuration(),t>this._duration&&(t=this._duration),this._yoyo&&0!==(1&this._cycle)?t=this._duration-t+this._cycle*(this._duration+this._repeatDelay):0!==this._repeat&&(t+=this._cycle*(this._duration+this._repeatDelay)),this.totalTime(t,e)):this._time},l.repeat=function(t){return arguments.length?(this._repeat=t,this._uncache(!0)):this._repeat},l.repeatDelay=function(t){return arguments.length?(this._repeatDelay=t,this._uncache(!0)):this._repeatDelay},l.yoyo=function(t){return arguments.length?(this._yoyo=t,this):this._yoyo},l.currentLabel=function(t){return arguments.length?this.seek(t,!0):this.getLabelBefore(this._time+1e-8)},s},!0),function(){var t=180/Math.PI,e=[],i=[],s=[],r={},n=_gsScope._gsDefine.globals,a=function(t,e,i,s){this.a=t,this.b=e,this.c=i,this.d=s,this.da=s-t,this.ca=i-t,this.ba=e-t},o=",x,y,z,left,top,right,bottom,marginTop,marginLeft,marginRight,marginBottom,paddingLeft,paddingTop,paddingRight,paddingBottom,backgroundPosition,backgroundPosition_y,",h=function(t,e,i,s){var r={a:t},n={},a={},o={c:s},h=(t+e)/2,l=(e+i)/2,_=(i+s)/2,u=(h+l)/2,c=(l+_)/2,f=(c-u)/8;return r.b=h+(t-h)/4,n.b=u+f,r.c=n.a=(r.b+n.b)/2,n.c=a.a=(u+c)/2,a.b=c-f,o.b=_+(s-_)/4,a.c=o.a=(a.b+o.b)/2,[r,n,a,o]},l=function(t,r,n,a,o){var l,_,u,c,f,p,m,d,g,v,y,T,x,w=t.length-1,b=0,P=t[0].a;for(l=0;w>l;l++)f=t[b],_=f.a,u=f.d,c=t[b+1].d,o?(y=e[l],T=i[l],x=.25*(T+y)*r/(a?.5:s[l]||.5),p=u-(u-_)*(a?.5*r:0!==y?x/y:0),m=u+(c-u)*(a?.5*r:0!==T?x/T:0),d=u-(p+((m-p)*(3*y/(y+T)+.5)/4||0))):(p=u-.5*(u-_)*r,m=u+.5*(c-u)*r,d=u-(p+m)/2),p+=d,m+=d,f.c=g=p,f.b=0!==l?P:P=f.a+.6*(f.c-f.a),f.da=u-_,f.ca=g-_,f.ba=P-_,n?(v=h(_,P,g,u),t.splice(b,1,v[0],v[1],v[2],v[3]),b+=4):b++,P=m;f=t[b],f.b=P,f.c=P+.4*(f.d-P),f.da=f.d-f.a,f.ca=f.c-f.a,f.ba=P-f.a,n&&(v=h(f.a,P,f.c,f.d),t.splice(b,1,v[0],v[1],v[2],v[3]))},_=function(t,s,r,n){var o,h,l,_,u,c,f=[];if(n)for(t=[n].concat(t),h=t.length;--h>-1;)"string"==typeof(c=t[h][s])&&"="===c.charAt(1)&&(t[h][s]=n[s]+Number(c.charAt(0)+c.substr(2)));if(o=t.length-2,0>o)return f[0]=new a(t[0][s],0,0,t[-1>o?0:1][s]),f;for(h=0;o>h;h++)l=t[h][s],_=t[h+1][s],f[h]=new a(l,0,0,_),r&&(u=t[h+2][s],e[h]=(e[h]||0)+(_-l)*(_-l),i[h]=(i[h]||0)+(u-_)*(u-_));return f[h]=new a(t[h][s],0,0,t[h+1][s]),f},u=function(t,n,a,h,u,c){var f,p,m,d,g,v,y,T,x={},w=[],b=c||t[0];u="string"==typeof u?","+u+",":o,null==n&&(n=1);for(p in t[0])w.push(p);if(t.length>1){for(T=t[t.length-1],y=!0,f=w.length;--f>-1;)if(p=w[f],Math.abs(b[p]-T[p])>.05){y=!1;break}y&&(t=t.concat(),c&&t.unshift(c),t.push(t[1]),c=t[t.length-3])}for(e.length=i.length=s.length=0,f=w.length;--f>-1;)p=w[f],r[p]=-1!==u.indexOf(","+p+","),x[p]=_(t,p,r[p],c);for(f=e.length;--f>-1;)e[f]=Math.sqrt(e[f]),i[f]=Math.sqrt(i[f]);if(!h){for(f=w.length;--f>-1;)if(r[p])for(m=x[w[f]],v=m.length-1,d=0;v>d;d++)g=m[d+1].da/i[d]+m[d].da/e[d],s[d]=(s[d]||0)+g*g;for(f=s.length;--f>-1;)s[f]=Math.sqrt(s[f])}for(f=w.length,d=a?4:1;--f>-1;)p=w[f],m=x[p],l(m,n,a,h,r[p]),y&&(m.splice(0,d),m.splice(m.length-d,d));return x},c=function(t,e,i){e=e||"soft";var s,r,n,o,h,l,_,u,c,f,p,m={},d="cubic"===e?3:2,g="soft"===e,v=[];if(g&&i&&(t=[i].concat(t)),null==t||d+1>t.length)throw"invalid Bezier data";for(c in t[0])v.push(c);for(l=v.length;--l>-1;){for(c=v[l],m[c]=h=[],f=0,u=t.length,_=0;u>_;_++)s=null==i?t[_][c]:"string"==typeof(p=t[_][c])&&"="===p.charAt(1)?i[c]+Number(p.charAt(0)+p.substr(2)):Number(p),g&&_>1&&u-1>_&&(h[f++]=(s+h[f-2])/2),h[f++]=s;for(u=f-d+1,f=0,_=0;u>_;_+=d)s=h[_],r=h[_+1],n=h[_+2],o=2===d?0:h[_+3],h[f++]=p=3===d?new a(s,r,n,o):new a(s,(2*r+s)/3,(2*r+n)/3,n);h.length=f}return m},f=function(t,e,i){for(var s,r,n,a,o,h,l,_,u,c,f,p=1/i,m=t.length;--m>-1;)for(c=t[m],n=c.a,a=c.d-n,o=c.c-n,h=c.b-n,s=r=0,_=1;i>=_;_++)l=p*_,u=1-l,s=r-(r=(l*l*a+3*u*(l*o+u*h))*l),f=m*i+_-1,e[f]=(e[f]||0)+s*s},p=function(t,e){e=e>>0||6;var i,s,r,n,a=[],o=[],h=0,l=0,_=e-1,u=[],c=[];for(i in t)f(t[i],a,e);for(r=a.length,s=0;r>s;s++)h+=Math.sqrt(a[s]),n=s%e,c[n]=h,n===_&&(l+=h,n=s/e>>0,u[n]=c,o[n]=l,h=0,c=[]);return{length:l,lengths:o,segments:u}},m=_gsScope._gsDefine.plugin({propName:"bezier",priority:-1,version:"1.3.4",API:2,global:!0,init:function(t,e,i){this._target=t,e instanceof Array&&(e={values:e}),this._func={},this._round={},this._props=[],this._timeRes=null==e.timeResolution?6:parseInt(e.timeResolution,10);var s,r,n,a,o,h=e.values||[],l={},_=h[0],f=e.autoRotate||i.vars.orientToBezier;this._autoRotate=f?f instanceof Array?f:[["x","y","rotation",f===!0?0:Number(f)||0]]:null;for(s in _)this._props.push(s);for(n=this._props.length;--n>-1;)s=this._props[n],this._overwriteProps.push(s),r=this._func[s]="function"==typeof t[s],l[s]=r?t[s.indexOf("set")||"function"!=typeof t["get"+s.substr(3)]?s:"get"+s.substr(3)]():parseFloat(t[s]),o||l[s]!==h[0][s]&&(o=l);if(this._beziers="cubic"!==e.type&&"quadratic"!==e.type&&"soft"!==e.type?u(h,isNaN(e.curviness)?1:e.curviness,!1,"thruBasic"===e.type,e.correlate,o):c(h,e.type,l),this._segCount=this._beziers[s].length,this._timeRes){var m=p(this._beziers,this._timeRes);this._length=m.length,this._lengths=m.lengths,this._segments=m.segments,this._l1=this._li=this._s1=this._si=0,this._l2=this._lengths[0],this._curSeg=this._segments[0],this._s2=this._curSeg[0],this._prec=1/this._curSeg.length}if(f=this._autoRotate)for(this._initialRotations=[],f[0]instanceof Array||(this._autoRotate=f=[f]),n=f.length;--n>-1;){for(a=0;3>a;a++)s=f[n][a],this._func[s]="function"==typeof t[s]?t[s.indexOf("set")||"function"!=typeof t["get"+s.substr(3)]?s:"get"+s.substr(3)]:!1;s=f[n][2],this._initialRotations[n]=this._func[s]?this._func[s].call(this._target):this._target[s]}return this._startRatio=i.vars.runBackwards?1:0,!0},set:function(e){var i,s,r,n,a,o,h,l,_,u,c=this._segCount,f=this._func,p=this._target,m=e!==this._startRatio;if(this._timeRes){if(_=this._lengths,u=this._curSeg,e*=this._length,r=this._li,e>this._l2&&c-1>r){for(l=c-1;l>r&&e>=(this._l2=_[++r]););this._l1=_[r-1],this._li=r,this._curSeg=u=this._segments[r],this._s2=u[this._s1=this._si=0]}else if(this._l1>e&&r>0){for(;r>0&&(this._l1=_[--r])>=e;);0===r&&this._l1>e?this._l1=0:r++,this._l2=_[r],this._li=r,this._curSeg=u=this._segments[r],this._s1=u[(this._si=u.length-1)-1]||0,this._s2=u[this._si]
}if(i=r,e-=this._l1,r=this._si,e>this._s2&&u.length-1>r){for(l=u.length-1;l>r&&e>=(this._s2=u[++r]););this._s1=u[r-1],this._si=r}else if(this._s1>e&&r>0){for(;r>0&&(this._s1=u[--r])>=e;);0===r&&this._s1>e?this._s1=0:r++,this._s2=u[r],this._si=r}o=(r+(e-this._s1)/(this._s2-this._s1))*this._prec}else i=0>e?0:e>=1?c-1:c*e>>0,o=(e-i*(1/c))*c;for(s=1-o,r=this._props.length;--r>-1;)n=this._props[r],a=this._beziers[n][i],h=(o*o*a.da+3*s*(o*a.ca+s*a.ba))*o+a.a,this._round[n]&&(h=Math.round(h)),f[n]?p[n](h):p[n]=h;if(this._autoRotate){var d,g,v,y,T,x,w,b=this._autoRotate;for(r=b.length;--r>-1;)n=b[r][2],x=b[r][3]||0,w=b[r][4]===!0?1:t,a=this._beziers[b[r][0]],d=this._beziers[b[r][1]],a&&d&&(a=a[i],d=d[i],g=a.a+(a.b-a.a)*o,y=a.b+(a.c-a.b)*o,g+=(y-g)*o,y+=(a.c+(a.d-a.c)*o-y)*o,v=d.a+(d.b-d.a)*o,T=d.b+(d.c-d.b)*o,v+=(T-v)*o,T+=(d.c+(d.d-d.c)*o-T)*o,h=m?Math.atan2(T-v,y-g)*w+x:this._initialRotations[r],f[n]?p[n](h):p[n]=h)}}}),d=m.prototype;m.bezierThrough=u,m.cubicToQuadratic=h,m._autoCSS=!0,m.quadraticToCubic=function(t,e,i){return new a(t,(2*e+t)/3,(2*e+i)/3,i)},m._cssRegister=function(){var t=n.CSSPlugin;if(t){var e=t._internals,i=e._parseToProxy,s=e._setPluginRatio,r=e.CSSPropTween;e._registerComplexSpecialProp("bezier",{parser:function(t,e,n,a,o,h){e instanceof Array&&(e={values:e}),h=new m;var l,_,u,c=e.values,f=c.length-1,p=[],d={};if(0>f)return o;for(l=0;f>=l;l++)u=i(t,c[l],a,o,h,f!==l),p[l]=u.end;for(_ in e)d[_]=e[_];return d.values=p,o=new r(t,"bezier",0,0,u.pt,2),o.data=u,o.plugin=h,o.setRatio=s,0===d.autoRotate&&(d.autoRotate=!0),!d.autoRotate||d.autoRotate instanceof Array||(l=d.autoRotate===!0?0:Number(d.autoRotate),d.autoRotate=null!=u.end.left?[["left","top","rotation",l,!1]]:null!=u.end.x?[["x","y","rotation",l,!1]]:!1),d.autoRotate&&(a._transform||a._enableTransforms(!1),u.autoRotate=a._target._gsTransform),h._onInitTween(u.proxy,d,a._tween),o}})}},d._roundProps=function(t,e){for(var i=this._overwriteProps,s=i.length;--s>-1;)(t[i[s]]||t.bezier||t.bezierThrough)&&(this._round[i[s]]=e)},d._kill=function(t){var e,i,s=this._props;for(e in this._beziers)if(e in t)for(delete this._beziers[e],delete this._func[e],i=s.length;--i>-1;)s[i]===e&&s.splice(i,1);return this._super._kill.call(this,t)}}(),_gsScope._gsDefine("plugins.CSSPlugin",["plugins.TweenPlugin","TweenLite"],function(t,e){var i,s,r,n,a=function(){t.call(this,"css"),this._overwriteProps.length=0,this.setRatio=a.prototype.setRatio},o=_gsScope._gsDefine.globals,h={},l=a.prototype=new t("css");l.constructor=a,a.version="1.17.0",a.API=2,a.defaultTransformPerspective=0,a.defaultSkewType="compensated",a.defaultSmoothOrigin=!0,l="px",a.suffixMap={top:l,right:l,bottom:l,left:l,width:l,height:l,fontSize:l,padding:l,margin:l,perspective:l,lineHeight:""};var _,u,c,f,p,m,d=/(?:\d|\-\d|\.\d|\-\.\d)+/g,g=/(?:\d|\-\d|\.\d|\-\.\d|\+=\d|\-=\d|\+=.\d|\-=\.\d)+/g,v=/(?:\+=|\-=|\-|\b)[\d\-\.]+[a-zA-Z0-9]*(?:%|\b)/gi,y=/(?![+-]?\d*\.?\d+|[+-]|e[+-]\d+)[^0-9]/g,T=/(?:\d|\-|\+|=|#|\.)*/g,x=/opacity *= *([^)]*)/i,w=/opacity:([^;]*)/i,b=/alpha\(opacity *=.+?\)/i,P=/^(rgb|hsl)/,k=/([A-Z])/g,S=/-([a-z])/gi,R=/(^(?:url\(\"|url\())|(?:(\"\))$|\)$)/gi,O=function(t,e){return e.toUpperCase()},A=/(?:Left|Right|Width)/i,C=/(M11|M12|M21|M22)=[\d\-\.e]+/gi,D=/progid\:DXImageTransform\.Microsoft\.Matrix\(.+?\)/i,M=/,(?=[^\)]*(?:\(|$))/gi,z=Math.PI/180,I=180/Math.PI,F={},N=document,E=function(t){return N.createElementNS?N.createElementNS("http://www.w3.org/1999/xhtml",t):N.createElement(t)},L=E("div"),X=E("img"),B=a._internals={_specialProps:h},Y=navigator.userAgent,j=function(){var t=Y.indexOf("Android"),e=E("a");return c=-1!==Y.indexOf("Safari")&&-1===Y.indexOf("Chrome")&&(-1===t||Number(Y.substr(t+8,1))>3),p=c&&6>Number(Y.substr(Y.indexOf("Version/")+8,1)),f=-1!==Y.indexOf("Firefox"),(/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(Y)||/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(Y))&&(m=parseFloat(RegExp.$1)),e?(e.style.cssText="top:1px;opacity:.55;",/^0.55/.test(e.style.opacity)):!1}(),U=function(t){return x.test("string"==typeof t?t:(t.currentStyle?t.currentStyle.filter:t.style.filter)||"")?parseFloat(RegExp.$1)/100:1},q=function(t){window.console&&console.log(t)},V="",G="",W=function(t,e){e=e||L;var i,s,r=e.style;if(void 0!==r[t])return t;for(t=t.charAt(0).toUpperCase()+t.substr(1),i=["O","Moz","ms","Ms","Webkit"],s=5;--s>-1&&void 0===r[i[s]+t];);return s>=0?(G=3===s?"ms":i[s],V="-"+G.toLowerCase()+"-",G+t):null},Z=N.defaultView?N.defaultView.getComputedStyle:function(){},Q=a.getStyle=function(t,e,i,s,r){var n;return j||"opacity"!==e?(!s&&t.style[e]?n=t.style[e]:(i=i||Z(t))?n=i[e]||i.getPropertyValue(e)||i.getPropertyValue(e.replace(k,"-$1").toLowerCase()):t.currentStyle&&(n=t.currentStyle[e]),null==r||n&&"none"!==n&&"auto"!==n&&"auto auto"!==n?n:r):U(t)},$=B.convertToPixels=function(t,i,s,r,n){if("px"===r||!r)return s;if("auto"===r||!s)return 0;var o,h,l,_=A.test(i),u=t,c=L.style,f=0>s;if(f&&(s=-s),"%"===r&&-1!==i.indexOf("border"))o=s/100*(_?t.clientWidth:t.clientHeight);else{if(c.cssText="border:0 solid red;position:"+Q(t,"position")+";line-height:0;","%"!==r&&u.appendChild)c[_?"borderLeftWidth":"borderTopWidth"]=s+r;else{if(u=t.parentNode||N.body,h=u._gsCache,l=e.ticker.frame,h&&_&&h.time===l)return h.width*s/100;c[_?"width":"height"]=s+r}u.appendChild(L),o=parseFloat(L[_?"offsetWidth":"offsetHeight"]),u.removeChild(L),_&&"%"===r&&a.cacheWidths!==!1&&(h=u._gsCache=u._gsCache||{},h.time=l,h.width=100*(o/s)),0!==o||n||(o=$(t,i,s,r,!0))}return f?-o:o},H=B.calculateOffset=function(t,e,i){if("absolute"!==Q(t,"position",i))return 0;var s="left"===e?"Left":"Top",r=Q(t,"margin"+s,i);return t["offset"+s]-($(t,e,parseFloat(r),r.replace(T,""))||0)},K=function(t,e){var i,s,r,n={};if(e=e||Z(t,null))if(i=e.length)for(;--i>-1;)r=e[i],(-1===r.indexOf("-transform")||Pe===r)&&(n[r.replace(S,O)]=e.getPropertyValue(r));else for(i in e)(-1===i.indexOf("Transform")||be===i)&&(n[i]=e[i]);else if(e=t.currentStyle||t.style)for(i in e)"string"==typeof i&&void 0===n[i]&&(n[i.replace(S,O)]=e[i]);return j||(n.opacity=U(t)),s=Ne(t,e,!1),n.rotation=s.rotation,n.skewX=s.skewX,n.scaleX=s.scaleX,n.scaleY=s.scaleY,n.x=s.x,n.y=s.y,Se&&(n.z=s.z,n.rotationX=s.rotationX,n.rotationY=s.rotationY,n.scaleZ=s.scaleZ),n.filters&&delete n.filters,n},J=function(t,e,i,s,r){var n,a,o,h={},l=t.style;for(a in i)"cssText"!==a&&"length"!==a&&isNaN(a)&&(e[a]!==(n=i[a])||r&&r[a])&&-1===a.indexOf("Origin")&&("number"==typeof n||"string"==typeof n)&&(h[a]="auto"!==n||"left"!==a&&"top"!==a?""!==n&&"auto"!==n&&"none"!==n||"string"!=typeof e[a]||""===e[a].replace(y,"")?n:0:H(t,a),void 0!==l[a]&&(o=new fe(l,a,l[a],o)));if(s)for(a in s)"className"!==a&&(h[a]=s[a]);return{difs:h,firstMPT:o}},te={width:["Left","Right"],height:["Top","Bottom"]},ee=["marginLeft","marginRight","marginTop","marginBottom"],ie=function(t,e,i){var s=parseFloat("width"===e?t.offsetWidth:t.offsetHeight),r=te[e],n=r.length;for(i=i||Z(t,null);--n>-1;)s-=parseFloat(Q(t,"padding"+r[n],i,!0))||0,s-=parseFloat(Q(t,"border"+r[n]+"Width",i,!0))||0;return s},se=function(t,e){(null==t||""===t||"auto"===t||"auto auto"===t)&&(t="0 0");var i=t.split(" "),s=-1!==t.indexOf("left")?"0%":-1!==t.indexOf("right")?"100%":i[0],r=-1!==t.indexOf("top")?"0%":-1!==t.indexOf("bottom")?"100%":i[1];return null==r?r="center"===s?"50%":"0":"center"===r&&(r="50%"),("center"===s||isNaN(parseFloat(s))&&-1===(s+"").indexOf("="))&&(s="50%"),t=s+" "+r+(i.length>2?" "+i[2]:""),e&&(e.oxp=-1!==s.indexOf("%"),e.oyp=-1!==r.indexOf("%"),e.oxr="="===s.charAt(1),e.oyr="="===r.charAt(1),e.ox=parseFloat(s.replace(y,"")),e.oy=parseFloat(r.replace(y,"")),e.v=t),e||t},re=function(t,e){return"string"==typeof t&&"="===t.charAt(1)?parseInt(t.charAt(0)+"1",10)*parseFloat(t.substr(2)):parseFloat(t)-parseFloat(e)},ne=function(t,e){return null==t?e:"string"==typeof t&&"="===t.charAt(1)?parseInt(t.charAt(0)+"1",10)*parseFloat(t.substr(2))+e:parseFloat(t)},ae=function(t,e,i,s){var r,n,a,o,h,l=1e-6;return null==t?o=e:"number"==typeof t?o=t:(r=360,n=t.split("_"),h="="===t.charAt(1),a=(h?parseInt(t.charAt(0)+"1",10)*parseFloat(n[0].substr(2)):parseFloat(n[0]))*(-1===t.indexOf("rad")?1:I)-(h?0:e),n.length&&(s&&(s[i]=e+a),-1!==t.indexOf("short")&&(a%=r,a!==a%(r/2)&&(a=0>a?a+r:a-r)),-1!==t.indexOf("_cw")&&0>a?a=(a+9999999999*r)%r-(0|a/r)*r:-1!==t.indexOf("ccw")&&a>0&&(a=(a-9999999999*r)%r-(0|a/r)*r)),o=e+a),l>o&&o>-l&&(o=0),o},oe={aqua:[0,255,255],lime:[0,255,0],silver:[192,192,192],black:[0,0,0],maroon:[128,0,0],teal:[0,128,128],blue:[0,0,255],navy:[0,0,128],white:[255,255,255],fuchsia:[255,0,255],olive:[128,128,0],yellow:[255,255,0],orange:[255,165,0],gray:[128,128,128],purple:[128,0,128],green:[0,128,0],red:[255,0,0],pink:[255,192,203],cyan:[0,255,255],transparent:[255,255,255,0]},he=function(t,e,i){return t=0>t?t+1:t>1?t-1:t,0|255*(1>6*t?e+6*(i-e)*t:.5>t?i:2>3*t?e+6*(i-e)*(2/3-t):e)+.5},le=a.parseColor=function(t){var e,i,s,r,n,a;return t&&""!==t?"number"==typeof t?[t>>16,255&t>>8,255&t]:(","===t.charAt(t.length-1)&&(t=t.substr(0,t.length-1)),oe[t]?oe[t]:"#"===t.charAt(0)?(4===t.length&&(e=t.charAt(1),i=t.charAt(2),s=t.charAt(3),t="#"+e+e+i+i+s+s),t=parseInt(t.substr(1),16),[t>>16,255&t>>8,255&t]):"hsl"===t.substr(0,3)?(t=t.match(d),r=Number(t[0])%360/360,n=Number(t[1])/100,a=Number(t[2])/100,i=.5>=a?a*(n+1):a+n-a*n,e=2*a-i,t.length>3&&(t[3]=Number(t[3])),t[0]=he(r+1/3,e,i),t[1]=he(r,e,i),t[2]=he(r-1/3,e,i),t):(t=t.match(d)||oe.transparent,t[0]=Number(t[0]),t[1]=Number(t[1]),t[2]=Number(t[2]),t.length>3&&(t[3]=Number(t[3])),t)):oe.black},_e="(?:\\b(?:(?:rgb|rgba|hsl|hsla)\\(.+?\\))|\\B#.+?\\b";for(l in oe)_e+="|"+l+"\\b";_e=RegExp(_e+")","gi");var ue=function(t,e,i,s){if(null==t)return function(t){return t};var r,n=e?(t.match(_e)||[""])[0]:"",a=t.split(n).join("").match(v)||[],o=t.substr(0,t.indexOf(a[0])),h=")"===t.charAt(t.length-1)?")":"",l=-1!==t.indexOf(" ")?" ":",",_=a.length,u=_>0?a[0].replace(d,""):"";return _?r=e?function(t){var e,c,f,p;if("number"==typeof t)t+=u;else if(s&&M.test(t)){for(p=t.replace(M,"|").split("|"),f=0;p.length>f;f++)p[f]=r(p[f]);return p.join(",")}if(e=(t.match(_e)||[n])[0],c=t.split(e).join("").match(v)||[],f=c.length,_>f--)for(;_>++f;)c[f]=i?c[0|(f-1)/2]:a[f];return o+c.join(l)+l+e+h+(-1!==t.indexOf("inset")?" inset":"")}:function(t){var e,n,c;if("number"==typeof t)t+=u;else if(s&&M.test(t)){for(n=t.replace(M,"|").split("|"),c=0;n.length>c;c++)n[c]=r(n[c]);return n.join(",")}if(e=t.match(v)||[],c=e.length,_>c--)for(;_>++c;)e[c]=i?e[0|(c-1)/2]:a[c];return o+e.join(l)+h}:function(t){return t}},ce=function(t){return t=t.split(","),function(e,i,s,r,n,a,o){var h,l=(i+"").split(" ");for(o={},h=0;4>h;h++)o[t[h]]=l[h]=l[h]||l[(h-1)/2>>0];return r.parse(e,o,n,a)}},fe=(B._setPluginRatio=function(t){this.plugin.setRatio(t);for(var e,i,s,r,n=this.data,a=n.proxy,o=n.firstMPT,h=1e-6;o;)e=a[o.v],o.r?e=Math.round(e):h>e&&e>-h&&(e=0),o.t[o.p]=e,o=o._next;if(n.autoRotate&&(n.autoRotate.rotation=a.rotation),1===t)for(o=n.firstMPT;o;){if(i=o.t,i.type){if(1===i.type){for(r=i.xs0+i.s+i.xs1,s=1;i.l>s;s++)r+=i["xn"+s]+i["xs"+(s+1)];i.e=r}}else i.e=i.s+i.xs0;o=o._next}},function(t,e,i,s,r){this.t=t,this.p=e,this.v=i,this.r=r,s&&(s._prev=this,this._next=s)}),pe=(B._parseToProxy=function(t,e,i,s,r,n){var a,o,h,l,_,u=s,c={},f={},p=i._transform,m=F;for(i._transform=null,F=e,s=_=i.parse(t,e,s,r),F=m,n&&(i._transform=p,u&&(u._prev=null,u._prev&&(u._prev._next=null)));s&&s!==u;){if(1>=s.type&&(o=s.p,f[o]=s.s+s.c,c[o]=s.s,n||(l=new fe(s,"s",o,l,s.r),s.c=0),1===s.type))for(a=s.l;--a>0;)h="xn"+a,o=s.p+"_"+h,f[o]=s.data[h],c[o]=s[h],n||(l=new fe(s,h,o,l,s.rxp[h]));s=s._next}return{proxy:c,end:f,firstMPT:l,pt:_}},B.CSSPropTween=function(t,e,s,r,a,o,h,l,_,u,c){this.t=t,this.p=e,this.s=s,this.c=r,this.n=h||e,t instanceof pe||n.push(this.n),this.r=l,this.type=o||0,_&&(this.pr=_,i=!0),this.b=void 0===u?s:u,this.e=void 0===c?s+r:c,a&&(this._next=a,a._prev=this)}),me=function(t,e,i,s,r,n){var a=new pe(t,e,i,s-i,r,-1,n);return a.b=i,a.e=a.xs0=s,a},de=a.parseComplex=function(t,e,i,s,r,n,a,o,h,l){i=i||n||"",a=new pe(t,e,0,0,a,l?2:1,null,!1,o,i,s),s+="";var u,c,f,p,m,v,y,T,x,w,b,k,S=i.split(", ").join(",").split(" "),R=s.split(", ").join(",").split(" "),O=S.length,A=_!==!1;for((-1!==s.indexOf(",")||-1!==i.indexOf(","))&&(S=S.join(" ").replace(M,", ").split(" "),R=R.join(" ").replace(M,", ").split(" "),O=S.length),O!==R.length&&(S=(n||"").split(" "),O=S.length),a.plugin=h,a.setRatio=l,u=0;O>u;u++)if(p=S[u],m=R[u],T=parseFloat(p),T||0===T)a.appendXtra("",T,re(m,T),m.replace(g,""),A&&-1!==m.indexOf("px"),!0);else if(r&&("#"===p.charAt(0)||oe[p]||P.test(p)))k=","===m.charAt(m.length-1)?"),":")",p=le(p),m=le(m),x=p.length+m.length>6,x&&!j&&0===m[3]?(a["xs"+a.l]+=a.l?" transparent":"transparent",a.e=a.e.split(R[u]).join("transparent")):(j||(x=!1),a.appendXtra(x?"rgba(":"rgb(",p[0],m[0]-p[0],",",!0,!0).appendXtra("",p[1],m[1]-p[1],",",!0).appendXtra("",p[2],m[2]-p[2],x?",":k,!0),x&&(p=4>p.length?1:p[3],a.appendXtra("",p,(4>m.length?1:m[3])-p,k,!1)));else if(v=p.match(d)){if(y=m.match(g),!y||y.length!==v.length)return a;for(f=0,c=0;v.length>c;c++)b=v[c],w=p.indexOf(b,f),a.appendXtra(p.substr(f,w-f),Number(b),re(y[c],b),"",A&&"px"===p.substr(w+b.length,2),0===c),f=w+b.length;a["xs"+a.l]+=p.substr(f)}else a["xs"+a.l]+=a.l?" "+p:p;if(-1!==s.indexOf("=")&&a.data){for(k=a.xs0+a.data.s,u=1;a.l>u;u++)k+=a["xs"+u]+a.data["xn"+u];a.e=k+a["xs"+u]}return a.l||(a.type=-1,a.xs0=a.e),a.xfirst||a},ge=9;for(l=pe.prototype,l.l=l.pr=0;--ge>0;)l["xn"+ge]=0,l["xs"+ge]="";l.xs0="",l._next=l._prev=l.xfirst=l.data=l.plugin=l.setRatio=l.rxp=null,l.appendXtra=function(t,e,i,s,r,n){var a=this,o=a.l;return a["xs"+o]+=n&&o?" "+t:t||"",i||0===o||a.plugin?(a.l++,a.type=a.setRatio?2:1,a["xs"+a.l]=s||"",o>0?(a.data["xn"+o]=e+i,a.rxp["xn"+o]=r,a["xn"+o]=e,a.plugin||(a.xfirst=new pe(a,"xn"+o,e,i,a.xfirst||a,0,a.n,r,a.pr),a.xfirst.xs0=0),a):(a.data={s:e+i},a.rxp={},a.s=e,a.c=i,a.r=r,a)):(a["xs"+o]+=e+(s||""),a)};var ve=function(t,e){e=e||{},this.p=e.prefix?W(t)||t:t,h[t]=h[this.p]=this,this.format=e.formatter||ue(e.defaultValue,e.color,e.collapsible,e.multi),e.parser&&(this.parse=e.parser),this.clrs=e.color,this.multi=e.multi,this.keyword=e.keyword,this.dflt=e.defaultValue,this.pr=e.priority||0},ye=B._registerComplexSpecialProp=function(t,e,i){"object"!=typeof e&&(e={parser:i});var s,r,n=t.split(","),a=e.defaultValue;for(i=i||[a],s=0;n.length>s;s++)e.prefix=0===s&&e.prefix,e.defaultValue=i[s]||a,r=new ve(n[s],e)},Te=function(t){if(!h[t]){var e=t.charAt(0).toUpperCase()+t.substr(1)+"Plugin";ye(t,{parser:function(t,i,s,r,n,a,l){var _=o.com.greensock.plugins[e];return _?(_._cssRegister(),h[s].parse(t,i,s,r,n,a,l)):(q("Error: "+e+" js file not loaded."),n)}})}};l=ve.prototype,l.parseComplex=function(t,e,i,s,r,n){var a,o,h,l,_,u,c=this.keyword;if(this.multi&&(M.test(i)||M.test(e)?(o=e.replace(M,"|").split("|"),h=i.replace(M,"|").split("|")):c&&(o=[e],h=[i])),h){for(l=h.length>o.length?h.length:o.length,a=0;l>a;a++)e=o[a]=o[a]||this.dflt,i=h[a]=h[a]||this.dflt,c&&(_=e.indexOf(c),u=i.indexOf(c),_!==u&&(-1===u?o[a]=o[a].split(c).join(""):-1===_&&(o[a]+=" "+c)));e=o.join(", "),i=h.join(", ")}return de(t,this.p,e,i,this.clrs,this.dflt,s,this.pr,r,n)},l.parse=function(t,e,i,s,n,a){return this.parseComplex(t.style,this.format(Q(t,this.p,r,!1,this.dflt)),this.format(e),n,a)},a.registerSpecialProp=function(t,e,i){ye(t,{parser:function(t,s,r,n,a,o){var h=new pe(t,r,0,0,a,2,r,!1,i);return h.plugin=o,h.setRatio=e(t,s,n._tween,r),h},priority:i})},a.useSVGTransformAttr=c||f;var xe,we="scaleX,scaleY,scaleZ,x,y,z,skewX,skewY,rotation,rotationX,rotationY,perspective,xPercent,yPercent".split(","),be=W("transform"),Pe=V+"transform",ke=W("transformOrigin"),Se=null!==W("perspective"),Re=B.Transform=function(){this.perspective=parseFloat(a.defaultTransformPerspective)||0,this.force3D=a.defaultForce3D!==!1&&Se?a.defaultForce3D||"auto":!1},Oe=window.SVGElement,Ae=function(t,e,i){var s,r=N.createElementNS("http://www.w3.org/2000/svg",t),n=/([a-z])([A-Z])/g;for(s in i)r.setAttributeNS(null,s.replace(n,"$1-$2").toLowerCase(),i[s]);return e.appendChild(r),r},Ce=N.documentElement,De=function(){var t,e,i,s=m||/Android/i.test(Y)&&!window.chrome;return N.createElementNS&&!s&&(t=Ae("svg",Ce),e=Ae("rect",t,{width:100,height:50,x:100}),i=e.getBoundingClientRect().width,e.style[ke]="50% 50%",e.style[be]="scaleX(0.5)",s=i===e.getBoundingClientRect().width&&!(f&&Se),Ce.removeChild(t)),s}(),Me=function(t,e,i,s,r){var n,o,h,l,_,u,c,f,p,m,d,g,v,y,T=t._gsTransform,x=Fe(t,!0);T&&(v=T.xOrigin,y=T.yOrigin),(!s||2>(n=s.split(" ")).length)&&(c=t.getBBox(),e=se(e).split(" "),n=[(-1!==e[0].indexOf("%")?parseFloat(e[0])/100*c.width:parseFloat(e[0]))+c.x,(-1!==e[1].indexOf("%")?parseFloat(e[1])/100*c.height:parseFloat(e[1]))+c.y]),i.xOrigin=l=parseFloat(n[0]),i.yOrigin=_=parseFloat(n[1]),s&&x!==Ie&&(u=x[0],c=x[1],f=x[2],p=x[3],m=x[4],d=x[5],g=u*p-c*f,o=l*(p/g)+_*(-f/g)+(f*d-p*m)/g,h=l*(-c/g)+_*(u/g)-(u*d-c*m)/g,l=i.xOrigin=n[0]=o,_=i.yOrigin=n[1]=h),T&&(r||r!==!1&&a.defaultSmoothOrigin!==!1?(o=l-v,h=_-y,T.xOffset+=o*x[0]+h*x[2]-o,T.yOffset+=o*x[1]+h*x[3]-h):T.xOffset=T.yOffset=0),t.setAttribute("data-svg-origin",n.join(" "))},ze=function(t){return!!(Oe&&"function"==typeof t.getBBox&&t.getCTM&&(!t.parentNode||t.parentNode.getBBox&&t.parentNode.getCTM))},Ie=[1,0,0,1,0,0],Fe=function(t,e){var i,s,r,n,a,o=t._gsTransform||new Re,h=1e5;if(be?s=Q(t,Pe,null,!0):t.currentStyle&&(s=t.currentStyle.filter.match(C),s=s&&4===s.length?[s[0].substr(4),Number(s[2].substr(4)),Number(s[1].substr(4)),s[3].substr(4),o.x||0,o.y||0].join(","):""),i=!s||"none"===s||"matrix(1, 0, 0, 1, 0, 0)"===s,(o.svg||t.getBBox&&ze(t))&&(i&&-1!==(t.style[be]+"").indexOf("matrix")&&(s=t.style[be],i=0),r=t.getAttribute("transform"),i&&r&&(-1!==r.indexOf("matrix")?(s=r,i=0):-1!==r.indexOf("translate")&&(s="matrix(1,0,0,1,"+r.match(/(?:\-|\b)[\d\-\.e]+\b/gi).join(",")+")",i=0))),i)return Ie;for(r=(s||"").match(/(?:\-|\b)[\d\-\.e]+\b/gi)||[],ge=r.length;--ge>-1;)n=Number(r[ge]),r[ge]=(a=n-(n|=0))?(0|a*h+(0>a?-.5:.5))/h+n:n;return e&&r.length>6?[r[0],r[1],r[4],r[5],r[12],r[13]]:r},Ne=B.getTransform=function(t,i,s,n){if(t._gsTransform&&s&&!n)return t._gsTransform;var o,h,l,_,u,c,f=s?t._gsTransform||new Re:new Re,p=0>f.scaleX,m=2e-5,d=1e5,g=Se?parseFloat(Q(t,ke,i,!1,"0 0 0").split(" ")[2])||f.zOrigin||0:0,v=parseFloat(a.defaultTransformPerspective)||0;if(f.svg=!(!t.getBBox||!ze(t)),f.svg&&(Me(t,Q(t,ke,r,!1,"50% 50%")+"",f,t.getAttribute("data-svg-origin")),xe=a.useSVGTransformAttr||De),o=Fe(t),o!==Ie){if(16===o.length){var y,T,x,w,b,P=o[0],k=o[1],S=o[2],R=o[3],O=o[4],A=o[5],C=o[6],D=o[7],M=o[8],z=o[9],F=o[10],N=o[12],E=o[13],L=o[14],X=o[11],B=Math.atan2(C,F);f.zOrigin&&(L=-f.zOrigin,N=M*L-o[12],E=z*L-o[13],L=F*L+f.zOrigin-o[14]),f.rotationX=B*I,B&&(w=Math.cos(-B),b=Math.sin(-B),y=O*w+M*b,T=A*w+z*b,x=C*w+F*b,M=O*-b+M*w,z=A*-b+z*w,F=C*-b+F*w,X=D*-b+X*w,O=y,A=T,C=x),B=Math.atan2(M,F),f.rotationY=B*I,B&&(w=Math.cos(-B),b=Math.sin(-B),y=P*w-M*b,T=k*w-z*b,x=S*w-F*b,z=k*b+z*w,F=S*b+F*w,X=R*b+X*w,P=y,k=T,S=x),B=Math.atan2(k,P),f.rotation=B*I,B&&(w=Math.cos(-B),b=Math.sin(-B),P=P*w+O*b,T=k*w+A*b,A=k*-b+A*w,C=S*-b+C*w,k=T),f.rotationX&&Math.abs(f.rotationX)+Math.abs(f.rotation)>359.9&&(f.rotationX=f.rotation=0,f.rotationY+=180),f.scaleX=(0|Math.sqrt(P*P+k*k)*d+.5)/d,f.scaleY=(0|Math.sqrt(A*A+z*z)*d+.5)/d,f.scaleZ=(0|Math.sqrt(C*C+F*F)*d+.5)/d,f.skewX=0,f.perspective=X?1/(0>X?-X:X):0,f.x=N,f.y=E,f.z=L,f.svg&&(f.x-=f.xOrigin-(f.xOrigin*P-f.yOrigin*O),f.y-=f.yOrigin-(f.yOrigin*k-f.xOrigin*A))}else if(!(Se&&!n&&o.length&&f.x===o[4]&&f.y===o[5]&&(f.rotationX||f.rotationY)||void 0!==f.x&&"none"===Q(t,"display",i))){var Y=o.length>=6,j=Y?o[0]:1,U=o[1]||0,q=o[2]||0,V=Y?o[3]:1;f.x=o[4]||0,f.y=o[5]||0,l=Math.sqrt(j*j+U*U),_=Math.sqrt(V*V+q*q),u=j||U?Math.atan2(U,j)*I:f.rotation||0,c=q||V?Math.atan2(q,V)*I+u:f.skewX||0,Math.abs(c)>90&&270>Math.abs(c)&&(p?(l*=-1,c+=0>=u?180:-180,u+=0>=u?180:-180):(_*=-1,c+=0>=c?180:-180)),f.scaleX=l,f.scaleY=_,f.rotation=u,f.skewX=c,Se&&(f.rotationX=f.rotationY=f.z=0,f.perspective=v,f.scaleZ=1),f.svg&&(f.x-=f.xOrigin-(f.xOrigin*j+f.yOrigin*q),f.y-=f.yOrigin-(f.xOrigin*U+f.yOrigin*V))}f.zOrigin=g;for(h in f)m>f[h]&&f[h]>-m&&(f[h]=0)}return s&&(t._gsTransform=f,f.svg&&(xe&&t.style[be]?e.delayedCall(.001,function(){Be(t.style,be)}):!xe&&t.getAttribute("transform")&&e.delayedCall(.001,function(){t.removeAttribute("transform")}))),f},Ee=function(t){var e,i,s=this.data,r=-s.rotation*z,n=r+s.skewX*z,a=1e5,o=(0|Math.cos(r)*s.scaleX*a)/a,h=(0|Math.sin(r)*s.scaleX*a)/a,l=(0|Math.sin(n)*-s.scaleY*a)/a,_=(0|Math.cos(n)*s.scaleY*a)/a,u=this.t.style,c=this.t.currentStyle;if(c){i=h,h=-l,l=-i,e=c.filter,u.filter="";var f,p,d=this.t.offsetWidth,g=this.t.offsetHeight,v="absolute"!==c.position,y="progid:DXImageTransform.Microsoft.Matrix(M11="+o+", M12="+h+", M21="+l+", M22="+_,w=s.x+d*s.xPercent/100,b=s.y+g*s.yPercent/100;if(null!=s.ox&&(f=(s.oxp?.01*d*s.ox:s.ox)-d/2,p=(s.oyp?.01*g*s.oy:s.oy)-g/2,w+=f-(f*o+p*h),b+=p-(f*l+p*_)),v?(f=d/2,p=g/2,y+=", Dx="+(f-(f*o+p*h)+w)+", Dy="+(p-(f*l+p*_)+b)+")"):y+=", sizingMethod='auto expand')",u.filter=-1!==e.indexOf("DXImageTransform.Microsoft.Matrix(")?e.replace(D,y):y+" "+e,(0===t||1===t)&&1===o&&0===h&&0===l&&1===_&&(v&&-1===y.indexOf("Dx=0, Dy=0")||x.test(e)&&100!==parseFloat(RegExp.$1)||-1===e.indexOf("gradient("&&e.indexOf("Alpha"))&&u.removeAttribute("filter")),!v){var P,k,S,R=8>m?1:-1;for(f=s.ieOffsetX||0,p=s.ieOffsetY||0,s.ieOffsetX=Math.round((d-((0>o?-o:o)*d+(0>h?-h:h)*g))/2+w),s.ieOffsetY=Math.round((g-((0>_?-_:_)*g+(0>l?-l:l)*d))/2+b),ge=0;4>ge;ge++)k=ee[ge],P=c[k],i=-1!==P.indexOf("px")?parseFloat(P):$(this.t,k,parseFloat(P),P.replace(T,""))||0,S=i!==s[k]?2>ge?-s.ieOffsetX:-s.ieOffsetY:2>ge?f-s.ieOffsetX:p-s.ieOffsetY,u[k]=(s[k]=Math.round(i-S*(0===ge||2===ge?1:R)))+"px"}}},Le=B.set3DTransformRatio=B.setTransformRatio=function(t){var e,i,s,r,n,a,o,h,l,_,u,c,p,m,d,g,v,y,T,x,w,b,P,k=this.data,S=this.t.style,R=k.rotation,O=k.rotationX,A=k.rotationY,C=k.scaleX,D=k.scaleY,M=k.scaleZ,I=k.x,F=k.y,N=k.z,E=k.svg,L=k.perspective,X=k.force3D;if(!(((1!==t&&0!==t||"auto"!==X||this.tween._totalTime!==this.tween._totalDuration&&this.tween._totalTime)&&X||N||L||A||O)&&(!xe||!E)&&Se))return R||k.skewX||E?(R*=z,b=k.skewX*z,P=1e5,e=Math.cos(R)*C,r=Math.sin(R)*C,i=Math.sin(R-b)*-D,n=Math.cos(R-b)*D,b&&"simple"===k.skewType&&(v=Math.tan(b),v=Math.sqrt(1+v*v),i*=v,n*=v,k.skewY&&(e*=v,r*=v)),E&&(I+=k.xOrigin-(k.xOrigin*e+k.yOrigin*i)+k.xOffset,F+=k.yOrigin-(k.xOrigin*r+k.yOrigin*n)+k.yOffset,xe&&(k.xPercent||k.yPercent)&&(m=this.t.getBBox(),I+=.01*k.xPercent*m.width,F+=.01*k.yPercent*m.height),m=1e-6,m>I&&I>-m&&(I=0),m>F&&F>-m&&(F=0)),T=(0|e*P)/P+","+(0|r*P)/P+","+(0|i*P)/P+","+(0|n*P)/P+","+I+","+F+")",E&&xe?this.t.setAttribute("transform","matrix("+T):S[be]=(k.xPercent||k.yPercent?"translate("+k.xPercent+"%,"+k.yPercent+"%) matrix(":"matrix(")+T):S[be]=(k.xPercent||k.yPercent?"translate("+k.xPercent+"%,"+k.yPercent+"%) matrix(":"matrix(")+C+",0,0,"+D+","+I+","+F+")",void 0;if(f&&(m=1e-4,m>C&&C>-m&&(C=M=2e-5),m>D&&D>-m&&(D=M=2e-5),!L||k.z||k.rotationX||k.rotationY||(L=0)),R||k.skewX)R*=z,d=e=Math.cos(R),g=r=Math.sin(R),k.skewX&&(R-=k.skewX*z,d=Math.cos(R),g=Math.sin(R),"simple"===k.skewType&&(v=Math.tan(k.skewX*z),v=Math.sqrt(1+v*v),d*=v,g*=v,k.skewY&&(e*=v,r*=v))),i=-g,n=d;else{if(!(A||O||1!==M||L||E))return S[be]=(k.xPercent||k.yPercent?"translate("+k.xPercent+"%,"+k.yPercent+"%) translate3d(":"translate3d(")+I+"px,"+F+"px,"+N+"px)"+(1!==C||1!==D?" scale("+C+","+D+")":""),void 0;e=n=1,i=r=0}l=1,s=a=o=h=_=u=0,c=L?-1/L:0,p=k.zOrigin,m=1e-6,x=",",w="0",R=A*z,R&&(d=Math.cos(R),g=Math.sin(R),o=-g,_=c*-g,s=e*g,a=r*g,l=d,c*=d,e*=d,r*=d),R=O*z,R&&(d=Math.cos(R),g=Math.sin(R),v=i*d+s*g,y=n*d+a*g,h=l*g,u=c*g,s=i*-g+s*d,a=n*-g+a*d,l*=d,c*=d,i=v,n=y),1!==M&&(s*=M,a*=M,l*=M,c*=M),1!==D&&(i*=D,n*=D,h*=D,u*=D),1!==C&&(e*=C,r*=C,o*=C,_*=C),(p||E)&&(p&&(I+=s*-p,F+=a*-p,N+=l*-p+p),E&&(I+=k.xOrigin-(k.xOrigin*e+k.yOrigin*i)+k.xOffset,F+=k.yOrigin-(k.xOrigin*r+k.yOrigin*n)+k.yOffset),m>I&&I>-m&&(I=w),m>F&&F>-m&&(F=w),m>N&&N>-m&&(N=0)),T=k.xPercent||k.yPercent?"translate("+k.xPercent+"%,"+k.yPercent+"%) matrix3d(":"matrix3d(",T+=(m>e&&e>-m?w:e)+x+(m>r&&r>-m?w:r)+x+(m>o&&o>-m?w:o),T+=x+(m>_&&_>-m?w:_)+x+(m>i&&i>-m?w:i)+x+(m>n&&n>-m?w:n),O||A?(T+=x+(m>h&&h>-m?w:h)+x+(m>u&&u>-m?w:u)+x+(m>s&&s>-m?w:s),T+=x+(m>a&&a>-m?w:a)+x+(m>l&&l>-m?w:l)+x+(m>c&&c>-m?w:c)+x):T+=",0,0,0,0,1,0,",T+=I+x+F+x+N+x+(L?1+-N/L:1)+")",S[be]=T};l=Re.prototype,l.x=l.y=l.z=l.skewX=l.skewY=l.rotation=l.rotationX=l.rotationY=l.zOrigin=l.xPercent=l.yPercent=l.xOffset=l.yOffset=0,l.scaleX=l.scaleY=l.scaleZ=1,ye("transform,scale,scaleX,scaleY,scaleZ,x,y,z,rotation,rotationX,rotationY,rotationZ,skewX,skewY,shortRotation,shortRotationX,shortRotationY,shortRotationZ,transformOrigin,svgOrigin,transformPerspective,directionalRotation,parseTransform,force3D,skewType,xPercent,yPercent,smoothOrigin",{parser:function(t,e,i,s,n,o,h){if(s._lastParsedTransform===h)return n;s._lastParsedTransform=h;var l,_,u,c,f,p,m,d,g,v=t._gsTransform,y=s._transform=Ne(t,r,!0,h.parseTransform),T=t.style,x=1e-6,w=we.length,b=h,P={},k="transformOrigin";if("string"==typeof b.transform&&be)u=L.style,u[be]=b.transform,u.display="block",u.position="absolute",N.body.appendChild(L),l=Ne(L,null,!1),N.body.removeChild(L),null!=b.xPercent&&(l.xPercent=ne(b.xPercent,y.xPercent)),null!=b.yPercent&&(l.yPercent=ne(b.yPercent,y.yPercent));else if("object"==typeof b){if(l={scaleX:ne(null!=b.scaleX?b.scaleX:b.scale,y.scaleX),scaleY:ne(null!=b.scaleY?b.scaleY:b.scale,y.scaleY),scaleZ:ne(b.scaleZ,y.scaleZ),x:ne(b.x,y.x),y:ne(b.y,y.y),z:ne(b.z,y.z),xPercent:ne(b.xPercent,y.xPercent),yPercent:ne(b.yPercent,y.yPercent),perspective:ne(b.transformPerspective,y.perspective)},m=b.directionalRotation,null!=m)if("object"==typeof m)for(u in m)b[u]=m[u];else b.rotation=m;"string"==typeof b.x&&-1!==b.x.indexOf("%")&&(l.x=0,l.xPercent=ne(b.x,y.xPercent)),"string"==typeof b.y&&-1!==b.y.indexOf("%")&&(l.y=0,l.yPercent=ne(b.y,y.yPercent)),l.rotation=ae("rotation"in b?b.rotation:"shortRotation"in b?b.shortRotation+"_short":"rotationZ"in b?b.rotationZ:y.rotation,y.rotation,"rotation",P),Se&&(l.rotationX=ae("rotationX"in b?b.rotationX:"shortRotationX"in b?b.shortRotationX+"_short":y.rotationX||0,y.rotationX,"rotationX",P),l.rotationY=ae("rotationY"in b?b.rotationY:"shortRotationY"in b?b.shortRotationY+"_short":y.rotationY||0,y.rotationY,"rotationY",P)),l.skewX=null==b.skewX?y.skewX:ae(b.skewX,y.skewX),l.skewY=null==b.skewY?y.skewY:ae(b.skewY,y.skewY),(_=l.skewY-y.skewY)&&(l.skewX+=_,l.rotation+=_)}for(Se&&null!=b.force3D&&(y.force3D=b.force3D,p=!0),y.skewType=b.skewType||y.skewType||a.defaultSkewType,f=y.force3D||y.z||y.rotationX||y.rotationY||l.z||l.rotationX||l.rotationY||l.perspective,f||null==b.scale||(l.scaleZ=1);--w>-1;)i=we[w],c=l[i]-y[i],(c>x||-x>c||null!=b[i]||null!=F[i])&&(p=!0,n=new pe(y,i,y[i],c,n),i in P&&(n.e=P[i]),n.xs0=0,n.plugin=o,s._overwriteProps.push(n.n));return c=b.transformOrigin,y.svg&&(c||b.svgOrigin)&&(d=y.xOffset,g=y.yOffset,Me(t,se(c),l,b.svgOrigin,b.smoothOrigin),n=me(y,"xOrigin",(v?y:l).xOrigin,l.xOrigin,n,k),n=me(y,"yOrigin",(v?y:l).yOrigin,l.yOrigin,n,k),(d!==y.xOffset||g!==y.yOffset)&&(n=me(y,"xOffset",v?d:y.xOffset,y.xOffset,n,k),n=me(y,"yOffset",v?g:y.yOffset,y.yOffset,n,k)),c=xe?null:"0px 0px"),(c||Se&&f&&y.zOrigin)&&(be?(p=!0,i=ke,c=(c||Q(t,i,r,!1,"50% 50%"))+"",n=new pe(T,i,0,0,n,-1,k),n.b=T[i],n.plugin=o,Se?(u=y.zOrigin,c=c.split(" "),y.zOrigin=(c.length>2&&(0===u||"0px"!==c[2])?parseFloat(c[2]):u)||0,n.xs0=n.e=c[0]+" "+(c[1]||"50%")+" 0px",n=new pe(y,"zOrigin",0,0,n,-1,n.n),n.b=u,n.xs0=n.e=y.zOrigin):n.xs0=n.e=c):se(c+"",y)),p&&(s._transformType=y.svg&&xe||!f&&3!==this._transformType?2:3),n},prefix:!0}),ye("boxShadow",{defaultValue:"0px 0px 0px 0px #999",prefix:!0,color:!0,multi:!0,keyword:"inset"}),ye("borderRadius",{defaultValue:"0px",parser:function(t,e,i,n,a){e=this.format(e);var o,h,l,_,u,c,f,p,m,d,g,v,y,T,x,w,b=["borderTopLeftRadius","borderTopRightRadius","borderBottomRightRadius","borderBottomLeftRadius"],P=t.style;for(m=parseFloat(t.offsetWidth),d=parseFloat(t.offsetHeight),o=e.split(" "),h=0;b.length>h;h++)this.p.indexOf("border")&&(b[h]=W(b[h])),u=_=Q(t,b[h],r,!1,"0px"),-1!==u.indexOf(" ")&&(_=u.split(" "),u=_[0],_=_[1]),c=l=o[h],f=parseFloat(u),v=u.substr((f+"").length),y="="===c.charAt(1),y?(p=parseInt(c.charAt(0)+"1",10),c=c.substr(2),p*=parseFloat(c),g=c.substr((p+"").length-(0>p?1:0))||""):(p=parseFloat(c),g=c.substr((p+"").length)),""===g&&(g=s[i]||v),g!==v&&(T=$(t,"borderLeft",f,v),x=$(t,"borderTop",f,v),"%"===g?(u=100*(T/m)+"%",_=100*(x/d)+"%"):"em"===g?(w=$(t,"borderLeft",1,"em"),u=T/w+"em",_=x/w+"em"):(u=T+"px",_=x+"px"),y&&(c=parseFloat(u)+p+g,l=parseFloat(_)+p+g)),a=de(P,b[h],u+" "+_,c+" "+l,!1,"0px",a);return a},prefix:!0,formatter:ue("0px 0px 0px 0px",!1,!0)}),ye("backgroundPosition",{defaultValue:"0 0",parser:function(t,e,i,s,n,a){var o,h,l,_,u,c,f="background-position",p=r||Z(t,null),d=this.format((p?m?p.getPropertyValue(f+"-x")+" "+p.getPropertyValue(f+"-y"):p.getPropertyValue(f):t.currentStyle.backgroundPositionX+" "+t.currentStyle.backgroundPositionY)||"0 0"),g=this.format(e);if(-1!==d.indexOf("%")!=(-1!==g.indexOf("%"))&&(c=Q(t,"backgroundImage").replace(R,""),c&&"none"!==c)){for(o=d.split(" "),h=g.split(" "),X.setAttribute("src",c),l=2;--l>-1;)d=o[l],_=-1!==d.indexOf("%"),_!==(-1!==h[l].indexOf("%"))&&(u=0===l?t.offsetWidth-X.width:t.offsetHeight-X.height,o[l]=_?parseFloat(d)/100*u+"px":100*(parseFloat(d)/u)+"%");d=o.join(" ")}return this.parseComplex(t.style,d,g,n,a)},formatter:se}),ye("backgroundSize",{defaultValue:"0 0",formatter:se}),ye("perspective",{defaultValue:"0px",prefix:!0}),ye("perspectiveOrigin",{defaultValue:"50% 50%",prefix:!0}),ye("transformStyle",{prefix:!0}),ye("backfaceVisibility",{prefix:!0}),ye("userSelect",{prefix:!0}),ye("margin",{parser:ce("marginTop,marginRight,marginBottom,marginLeft")}),ye("padding",{parser:ce("paddingTop,paddingRight,paddingBottom,paddingLeft")}),ye("clip",{defaultValue:"rect(0px,0px,0px,0px)",parser:function(t,e,i,s,n,a){var o,h,l;return 9>m?(h=t.currentStyle,l=8>m?" ":",",o="rect("+h.clipTop+l+h.clipRight+l+h.clipBottom+l+h.clipLeft+")",e=this.format(e).split(",").join(l)):(o=this.format(Q(t,this.p,r,!1,this.dflt)),e=this.format(e)),this.parseComplex(t.style,o,e,n,a)}}),ye("textShadow",{defaultValue:"0px 0px 0px #999",color:!0,multi:!0}),ye("autoRound,strictUnits",{parser:function(t,e,i,s,r){return r}}),ye("border",{defaultValue:"0px solid #000",parser:function(t,e,i,s,n,a){return this.parseComplex(t.style,this.format(Q(t,"borderTopWidth",r,!1,"0px")+" "+Q(t,"borderTopStyle",r,!1,"solid")+" "+Q(t,"borderTopColor",r,!1,"#000")),this.format(e),n,a)},color:!0,formatter:function(t){var e=t.split(" ");return e[0]+" "+(e[1]||"solid")+" "+(t.match(_e)||["#000"])[0]}}),ye("borderWidth",{parser:ce("borderTopWidth,borderRightWidth,borderBottomWidth,borderLeftWidth")}),ye("float,cssFloat,styleFloat",{parser:function(t,e,i,s,r){var n=t.style,a="cssFloat"in n?"cssFloat":"styleFloat";return new pe(n,a,0,0,r,-1,i,!1,0,n[a],e)}});var Xe=function(t){var e,i=this.t,s=i.filter||Q(this.data,"filter")||"",r=0|this.s+this.c*t;100===r&&(-1===s.indexOf("atrix(")&&-1===s.indexOf("radient(")&&-1===s.indexOf("oader(")?(i.removeAttribute("filter"),e=!Q(this.data,"filter")):(i.filter=s.replace(b,""),e=!0)),e||(this.xn1&&(i.filter=s=s||"alpha(opacity="+r+")"),-1===s.indexOf("pacity")?0===r&&this.xn1||(i.filter=s+" alpha(opacity="+r+")"):i.filter=s.replace(x,"opacity="+r))};ye("opacity,alpha,autoAlpha",{defaultValue:"1",parser:function(t,e,i,s,n,a){var o=parseFloat(Q(t,"opacity",r,!1,"1")),h=t.style,l="autoAlpha"===i;return"string"==typeof e&&"="===e.charAt(1)&&(e=("-"===e.charAt(0)?-1:1)*parseFloat(e.substr(2))+o),l&&1===o&&"hidden"===Q(t,"visibility",r)&&0!==e&&(o=0),j?n=new pe(h,"opacity",o,e-o,n):(n=new pe(h,"opacity",100*o,100*(e-o),n),n.xn1=l?1:0,h.zoom=1,n.type=2,n.b="alpha(opacity="+n.s+")",n.e="alpha(opacity="+(n.s+n.c)+")",n.data=t,n.plugin=a,n.setRatio=Xe),l&&(n=new pe(h,"visibility",0,0,n,-1,null,!1,0,0!==o?"inherit":"hidden",0===e?"hidden":"inherit"),n.xs0="inherit",s._overwriteProps.push(n.n),s._overwriteProps.push(i)),n
}});var Be=function(t,e){e&&(t.removeProperty?(("ms"===e.substr(0,2)||"webkit"===e.substr(0,6))&&(e="-"+e),t.removeProperty(e.replace(k,"-$1").toLowerCase())):t.removeAttribute(e))},Ye=function(t){if(this.t._gsClassPT=this,1===t||0===t){this.t.setAttribute("class",0===t?this.b:this.e);for(var e=this.data,i=this.t.style;e;)e.v?i[e.p]=e.v:Be(i,e.p),e=e._next;1===t&&this.t._gsClassPT===this&&(this.t._gsClassPT=null)}else this.t.getAttribute("class")!==this.e&&this.t.setAttribute("class",this.e)};ye("className",{parser:function(t,e,s,n,a,o,h){var l,_,u,c,f,p=t.getAttribute("class")||"",m=t.style.cssText;if(a=n._classNamePT=new pe(t,s,0,0,a,2),a.setRatio=Ye,a.pr=-11,i=!0,a.b=p,_=K(t,r),u=t._gsClassPT){for(c={},f=u.data;f;)c[f.p]=1,f=f._next;u.setRatio(1)}return t._gsClassPT=a,a.e="="!==e.charAt(1)?e:p.replace(RegExp("\\s*\\b"+e.substr(2)+"\\b"),"")+("+"===e.charAt(0)?" "+e.substr(2):""),t.setAttribute("class",a.e),l=J(t,_,K(t),h,c),t.setAttribute("class",p),a.data=l.firstMPT,t.style.cssText=m,a=a.xfirst=n.parse(t,l.difs,a,o)}});var je=function(t){if((1===t||0===t)&&this.data._totalTime===this.data._totalDuration&&"isFromStart"!==this.data.data){var e,i,s,r,n,a=this.t.style,o=h.transform.parse;if("all"===this.e)a.cssText="",r=!0;else for(e=this.e.split(" ").join("").split(","),s=e.length;--s>-1;)i=e[s],h[i]&&(h[i].parse===o?r=!0:i="transformOrigin"===i?ke:h[i].p),Be(a,i);r&&(Be(a,be),n=this.t._gsTransform,n&&(n.svg&&this.t.removeAttribute("data-svg-origin"),delete this.t._gsTransform))}};for(ye("clearProps",{parser:function(t,e,s,r,n){return n=new pe(t,s,0,0,n,2),n.setRatio=je,n.e=e,n.pr=-10,n.data=r._tween,i=!0,n}}),l="bezier,throwProps,physicsProps,physics2D".split(","),ge=l.length;ge--;)Te(l[ge]);l=a.prototype,l._firstPT=l._lastParsedTransform=l._transform=null,l._onInitTween=function(t,e,o){if(!t.nodeType)return!1;this._target=t,this._tween=o,this._vars=e,_=e.autoRound,i=!1,s=e.suffixMap||a.suffixMap,r=Z(t,""),n=this._overwriteProps;var l,f,m,d,g,v,y,T,x,b=t.style;if(u&&""===b.zIndex&&(l=Q(t,"zIndex",r),("auto"===l||""===l)&&this._addLazySet(b,"zIndex",0)),"string"==typeof e&&(d=b.cssText,l=K(t,r),b.cssText=d+";"+e,l=J(t,l,K(t)).difs,!j&&w.test(e)&&(l.opacity=parseFloat(RegExp.$1)),e=l,b.cssText=d),this._firstPT=f=e.className?h.className.parse(t,e.className,"className",this,null,null,e):this.parse(t,e,null),this._transformType){for(x=3===this._transformType,be?c&&(u=!0,""===b.zIndex&&(y=Q(t,"zIndex",r),("auto"===y||""===y)&&this._addLazySet(b,"zIndex",0)),p&&this._addLazySet(b,"WebkitBackfaceVisibility",this._vars.WebkitBackfaceVisibility||(x?"visible":"hidden"))):b.zoom=1,m=f;m&&m._next;)m=m._next;T=new pe(t,"transform",0,0,null,2),this._linkCSSP(T,null,m),T.setRatio=be?Le:Ee,T.data=this._transform||Ne(t,r,!0),T.tween=o,T.pr=-1,n.pop()}if(i){for(;f;){for(v=f._next,m=d;m&&m.pr>f.pr;)m=m._next;(f._prev=m?m._prev:g)?f._prev._next=f:d=f,(f._next=m)?m._prev=f:g=f,f=v}this._firstPT=d}return!0},l.parse=function(t,e,i,n){var a,o,l,u,c,f,p,m,d,g,v=t.style;for(a in e)f=e[a],o=h[a],o?i=o.parse(t,f,a,this,i,n,e):(c=Q(t,a,r)+"",d="string"==typeof f,"color"===a||"fill"===a||"stroke"===a||-1!==a.indexOf("Color")||d&&P.test(f)?(d||(f=le(f),f=(f.length>3?"rgba(":"rgb(")+f.join(",")+")"),i=de(v,a,c,f,!0,"transparent",i,0,n)):!d||-1===f.indexOf(" ")&&-1===f.indexOf(",")?(l=parseFloat(c),p=l||0===l?c.substr((l+"").length):"",(""===c||"auto"===c)&&("width"===a||"height"===a?(l=ie(t,a,r),p="px"):"left"===a||"top"===a?(l=H(t,a,r),p="px"):(l="opacity"!==a?0:1,p="")),g=d&&"="===f.charAt(1),g?(u=parseInt(f.charAt(0)+"1",10),f=f.substr(2),u*=parseFloat(f),m=f.replace(T,"")):(u=parseFloat(f),m=d?f.replace(T,""):""),""===m&&(m=a in s?s[a]:p),f=u||0===u?(g?u+l:u)+m:e[a],p!==m&&""!==m&&(u||0===u)&&l&&(l=$(t,a,l,p),"%"===m?(l/=$(t,a,100,"%")/100,e.strictUnits!==!0&&(c=l+"%")):"em"===m?l/=$(t,a,1,"em"):"px"!==m&&(u=$(t,a,u,m),m="px"),g&&(u||0===u)&&(f=u+l+m)),g&&(u+=l),!l&&0!==l||!u&&0!==u?void 0!==v[a]&&(f||"NaN"!=f+""&&null!=f)?(i=new pe(v,a,u||l||0,0,i,-1,a,!1,0,c,f),i.xs0="none"!==f||"display"!==a&&-1===a.indexOf("Style")?f:c):q("invalid "+a+" tween value: "+e[a]):(i=new pe(v,a,l,u-l,i,0,a,_!==!1&&("px"===m||"zIndex"===a),0,c,f),i.xs0=m)):i=de(v,a,c,f,!0,null,i,0,n)),n&&i&&!i.plugin&&(i.plugin=n);return i},l.setRatio=function(t){var e,i,s,r=this._firstPT,n=1e-6;if(1!==t||this._tween._time!==this._tween._duration&&0!==this._tween._time)if(t||this._tween._time!==this._tween._duration&&0!==this._tween._time||this._tween._rawPrevTime===-1e-6)for(;r;){if(e=r.c*t+r.s,r.r?e=Math.round(e):n>e&&e>-n&&(e=0),r.type)if(1===r.type)if(s=r.l,2===s)r.t[r.p]=r.xs0+e+r.xs1+r.xn1+r.xs2;else if(3===s)r.t[r.p]=r.xs0+e+r.xs1+r.xn1+r.xs2+r.xn2+r.xs3;else if(4===s)r.t[r.p]=r.xs0+e+r.xs1+r.xn1+r.xs2+r.xn2+r.xs3+r.xn3+r.xs4;else if(5===s)r.t[r.p]=r.xs0+e+r.xs1+r.xn1+r.xs2+r.xn2+r.xs3+r.xn3+r.xs4+r.xn4+r.xs5;else{for(i=r.xs0+e+r.xs1,s=1;r.l>s;s++)i+=r["xn"+s]+r["xs"+(s+1)];r.t[r.p]=i}else-1===r.type?r.t[r.p]=r.xs0:r.setRatio&&r.setRatio(t);else r.t[r.p]=e+r.xs0;r=r._next}else for(;r;)2!==r.type?r.t[r.p]=r.b:r.setRatio(t),r=r._next;else for(;r;){if(2!==r.type)if(r.r&&-1!==r.type)if(e=Math.round(r.s+r.c),r.type){if(1===r.type){for(s=r.l,i=r.xs0+e+r.xs1,s=1;r.l>s;s++)i+=r["xn"+s]+r["xs"+(s+1)];r.t[r.p]=i}}else r.t[r.p]=e+r.xs0;else r.t[r.p]=r.e;else r.setRatio(t);r=r._next}},l._enableTransforms=function(t){this._transform=this._transform||Ne(this._target,r,!0),this._transformType=this._transform.svg&&xe||!t&&3!==this._transformType?2:3};var Ue=function(){this.t[this.p]=this.e,this.data._linkCSSP(this,this._next,null,!0)};l._addLazySet=function(t,e,i){var s=this._firstPT=new pe(t,e,0,0,this._firstPT,2);s.e=i,s.setRatio=Ue,s.data=this},l._linkCSSP=function(t,e,i,s){return t&&(e&&(e._prev=t),t._next&&(t._next._prev=t._prev),t._prev?t._prev._next=t._next:this._firstPT===t&&(this._firstPT=t._next,s=!0),i?i._next=t:s||null!==this._firstPT||(this._firstPT=t),t._next=e,t._prev=i),t},l._kill=function(e){var i,s,r,n=e;if(e.autoAlpha||e.alpha){n={};for(s in e)n[s]=e[s];n.opacity=1,n.autoAlpha&&(n.visibility=1)}return e.className&&(i=this._classNamePT)&&(r=i.xfirst,r&&r._prev?this._linkCSSP(r._prev,i._next,r._prev._prev):r===this._firstPT&&(this._firstPT=i._next),i._next&&this._linkCSSP(i._next,i._next._next,r._prev),this._classNamePT=null),t.prototype._kill.call(this,n)};var qe=function(t,e,i){var s,r,n,a;if(t.slice)for(r=t.length;--r>-1;)qe(t[r],e,i);else for(s=t.childNodes,r=s.length;--r>-1;)n=s[r],a=n.type,n.style&&(e.push(K(n)),i&&i.push(n)),1!==a&&9!==a&&11!==a||!n.childNodes.length||qe(n,e,i)};return a.cascadeTo=function(t,i,s){var r,n,a,o,h=e.to(t,i,s),l=[h],_=[],u=[],c=[],f=e._internals.reservedProps;for(t=h._targets||h.target,qe(t,_,c),h.render(i,!0,!0),qe(t,u),h.render(0,!0,!0),h._enabled(!0),r=c.length;--r>-1;)if(n=J(c[r],_[r],u[r]),n.firstMPT){n=n.difs;for(a in s)f[a]&&(n[a]=s[a]);o={};for(a in n)o[a]=_[r][a];l.push(e.fromTo(c[r],i,o,n))}return l},t.activate([a]),a},!0),function(){var t=_gsScope._gsDefine.plugin({propName:"roundProps",priority:-1,API:2,init:function(t,e,i){return this._tween=i,!0}}),e=t.prototype;e._onInitAllProps=function(){for(var t,e,i,s=this._tween,r=s.vars.roundProps instanceof Array?s.vars.roundProps:s.vars.roundProps.split(","),n=r.length,a={},o=s._propLookup.roundProps;--n>-1;)a[r[n]]=1;for(n=r.length;--n>-1;)for(t=r[n],e=s._firstPT;e;)i=e._next,e.pg?e.t._roundProps(a,!0):e.n===t&&(this._add(e.t,t,e.s,e.c),i&&(i._prev=e._prev),e._prev?e._prev._next=i:s._firstPT===e&&(s._firstPT=i),e._next=e._prev=null,s._propLookup[t]=o),e=i;return!1},e._add=function(t,e,i,s){this._addTween(t,e,i,i+s,e,!0),this._overwriteProps.push(e)}}(),function(){var t=/(?:\d|\-|\+|=|#|\.)*/g,e=/[A-Za-z%]/g;_gsScope._gsDefine.plugin({propName:"attr",API:2,version:"0.4.0",init:function(i,s){var r,n,a,o,h;if("function"!=typeof i.setAttribute)return!1;this._target=i,this._proxy={},this._start={},this._end={},this._suffix={};for(r in s)this._start[r]=this._proxy[r]=n=i.getAttribute(r)+"",this._end[r]=a=s[r]+"",this._suffix[r]=o=e.test(a)?a.replace(t,""):e.test(n)?n.replace(t,""):"",o&&(h=a.indexOf(o),-1!==h&&(a=a.substr(0,h))),this._addTween(this._proxy,r,parseFloat(n),a,r)||(this._suffix[r]=""),"="===a.charAt(1)&&(this._end[r]=this._firstPT.s+this._firstPT.c+o),this._overwriteProps.push(r);return!0},set:function(t){this._super.setRatio.call(this,t);for(var e,i=this._overwriteProps,s=i.length,r=1===t?this._end:t?this._proxy:this._start,n=r===this._proxy;--s>-1;)e=i[s],this._target.setAttribute(e,r[e]+(n?this._suffix[e]:""))}})}(),_gsScope._gsDefine.plugin({propName:"directionalRotation",version:"0.2.1",API:2,init:function(t,e){"object"!=typeof e&&(e={rotation:e}),this.finals={};var i,s,r,n,a,o,h=e.useRadians===!0?2*Math.PI:360,l=1e-6;for(i in e)"useRadians"!==i&&(o=(e[i]+"").split("_"),s=o[0],r=parseFloat("function"!=typeof t[i]?t[i]:t[i.indexOf("set")||"function"!=typeof t["get"+i.substr(3)]?i:"get"+i.substr(3)]()),n=this.finals[i]="string"==typeof s&&"="===s.charAt(1)?r+parseInt(s.charAt(0)+"1",10)*Number(s.substr(2)):Number(s)||0,a=n-r,o.length&&(s=o.join("_"),-1!==s.indexOf("short")&&(a%=h,a!==a%(h/2)&&(a=0>a?a+h:a-h)),-1!==s.indexOf("_cw")&&0>a?a=(a+9999999999*h)%h-(0|a/h)*h:-1!==s.indexOf("ccw")&&a>0&&(a=(a-9999999999*h)%h-(0|a/h)*h)),(a>l||-l>a)&&(this._addTween(t,i,r,r+a,i),this._overwriteProps.push(i)));return!0},set:function(t){var e;if(1!==t)this._super.setRatio.call(this,t);else for(e=this._firstPT;e;)e.f?e.t[e.p](this.finals[e.p]):e.t[e.p]=this.finals[e.p],e=e._next}})._autoCSS=!0,_gsScope._gsDefine("easing.Back",["easing.Ease"],function(t){var e,i,s,r=_gsScope.GreenSockGlobals||_gsScope,n=r.com.greensock,a=2*Math.PI,o=Math.PI/2,h=n._class,l=function(e,i){var s=h("easing."+e,function(){},!0),r=s.prototype=new t;return r.constructor=s,r.getRatio=i,s},_=t.register||function(){},u=function(t,e,i,s){var r=h("easing."+t,{easeOut:new e,easeIn:new i,easeInOut:new s},!0);return _(r,t),r},c=function(t,e,i){this.t=t,this.v=e,i&&(this.next=i,i.prev=this,this.c=i.v-e,this.gap=i.t-t)},f=function(e,i){var s=h("easing."+e,function(t){this._p1=t||0===t?t:1.70158,this._p2=1.525*this._p1},!0),r=s.prototype=new t;return r.constructor=s,r.getRatio=i,r.config=function(t){return new s(t)},s},p=u("Back",f("BackOut",function(t){return(t-=1)*t*((this._p1+1)*t+this._p1)+1}),f("BackIn",function(t){return t*t*((this._p1+1)*t-this._p1)}),f("BackInOut",function(t){return 1>(t*=2)?.5*t*t*((this._p2+1)*t-this._p2):.5*((t-=2)*t*((this._p2+1)*t+this._p2)+2)})),m=h("easing.SlowMo",function(t,e,i){e=e||0===e?e:.7,null==t?t=.7:t>1&&(t=1),this._p=1!==t?e:0,this._p1=(1-t)/2,this._p2=t,this._p3=this._p1+this._p2,this._calcEnd=i===!0},!0),d=m.prototype=new t;return d.constructor=m,d.getRatio=function(t){var e=t+(.5-t)*this._p;return this._p1>t?this._calcEnd?1-(t=1-t/this._p1)*t:e-(t=1-t/this._p1)*t*t*t*e:t>this._p3?this._calcEnd?1-(t=(t-this._p3)/this._p1)*t:e+(t-e)*(t=(t-this._p3)/this._p1)*t*t*t:this._calcEnd?1:e},m.ease=new m(.7,.7),d.config=m.config=function(t,e,i){return new m(t,e,i)},e=h("easing.SteppedEase",function(t){t=t||1,this._p1=1/t,this._p2=t+1},!0),d=e.prototype=new t,d.constructor=e,d.getRatio=function(t){return 0>t?t=0:t>=1&&(t=.999999999),(this._p2*t>>0)*this._p1},d.config=e.config=function(t){return new e(t)},i=h("easing.RoughEase",function(e){e=e||{};for(var i,s,r,n,a,o,h=e.taper||"none",l=[],_=0,u=0|(e.points||20),f=u,p=e.randomize!==!1,m=e.clamp===!0,d=e.template instanceof t?e.template:null,g="number"==typeof e.strength?.4*e.strength:.4;--f>-1;)i=p?Math.random():1/u*f,s=d?d.getRatio(i):i,"none"===h?r=g:"out"===h?(n=1-i,r=n*n*g):"in"===h?r=i*i*g:.5>i?(n=2*i,r=.5*n*n*g):(n=2*(1-i),r=.5*n*n*g),p?s+=Math.random()*r-.5*r:f%2?s+=.5*r:s-=.5*r,m&&(s>1?s=1:0>s&&(s=0)),l[_++]={x:i,y:s};for(l.sort(function(t,e){return t.x-e.x}),o=new c(1,1,null),f=u;--f>-1;)a=l[f],o=new c(a.x,a.y,o);this._prev=new c(0,0,0!==o.t?o:o.next)},!0),d=i.prototype=new t,d.constructor=i,d.getRatio=function(t){var e=this._prev;if(t>e.t){for(;e.next&&t>=e.t;)e=e.next;e=e.prev}else for(;e.prev&&e.t>=t;)e=e.prev;return this._prev=e,e.v+(t-e.t)/e.gap*e.c},d.config=function(t){return new i(t)},i.ease=new i,u("Bounce",l("BounceOut",function(t){return 1/2.75>t?7.5625*t*t:2/2.75>t?7.5625*(t-=1.5/2.75)*t+.75:2.5/2.75>t?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375}),l("BounceIn",function(t){return 1/2.75>(t=1-t)?1-7.5625*t*t:2/2.75>t?1-(7.5625*(t-=1.5/2.75)*t+.75):2.5/2.75>t?1-(7.5625*(t-=2.25/2.75)*t+.9375):1-(7.5625*(t-=2.625/2.75)*t+.984375)}),l("BounceInOut",function(t){var e=.5>t;return t=e?1-2*t:2*t-1,t=1/2.75>t?7.5625*t*t:2/2.75>t?7.5625*(t-=1.5/2.75)*t+.75:2.5/2.75>t?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375,e?.5*(1-t):.5*t+.5})),u("Circ",l("CircOut",function(t){return Math.sqrt(1-(t-=1)*t)}),l("CircIn",function(t){return-(Math.sqrt(1-t*t)-1)}),l("CircInOut",function(t){return 1>(t*=2)?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)})),s=function(e,i,s){var r=h("easing."+e,function(t,e){this._p1=t>=1?t:1,this._p2=(e||s)/(1>t?t:1),this._p3=this._p2/a*(Math.asin(1/this._p1)||0),this._p2=a/this._p2},!0),n=r.prototype=new t;return n.constructor=r,n.getRatio=i,n.config=function(t,e){return new r(t,e)},r},u("Elastic",s("ElasticOut",function(t){return this._p1*Math.pow(2,-10*t)*Math.sin((t-this._p3)*this._p2)+1},.3),s("ElasticIn",function(t){return-(this._p1*Math.pow(2,10*(t-=1))*Math.sin((t-this._p3)*this._p2))},.3),s("ElasticInOut",function(t){return 1>(t*=2)?-.5*this._p1*Math.pow(2,10*(t-=1))*Math.sin((t-this._p3)*this._p2):.5*this._p1*Math.pow(2,-10*(t-=1))*Math.sin((t-this._p3)*this._p2)+1},.45)),u("Expo",l("ExpoOut",function(t){return 1-Math.pow(2,-10*t)}),l("ExpoIn",function(t){return Math.pow(2,10*(t-1))-.001}),l("ExpoInOut",function(t){return 1>(t*=2)?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*(t-1)))})),u("Sine",l("SineOut",function(t){return Math.sin(t*o)}),l("SineIn",function(t){return-Math.cos(t*o)+1}),l("SineInOut",function(t){return-.5*(Math.cos(Math.PI*t)-1)})),h("easing.EaseLookup",{find:function(e){return t.map[e]}},!0),_(r.SlowMo,"SlowMo","ease,"),_(i,"RoughEase","ease,"),_(e,"SteppedEase","ease,"),p},!0)}),_gsScope._gsDefine&&_gsScope._gsQueue.pop()(),function(t,e){"use strict";var i=t.GreenSockGlobals=t.GreenSockGlobals||t;if(!i.TweenLite){var s,r,n,a,o,h=function(t){var e,s=t.split("."),r=i;for(e=0;s.length>e;e++)r[s[e]]=r=r[s[e]]||{};return r},l=h("com.greensock"),_=1e-10,u=function(t){var e,i=[],s=t.length;for(e=0;e!==s;i.push(t[e++]));return i},c=function(){},f=function(){var t=Object.prototype.toString,e=t.call([]);return function(i){return null!=i&&(i instanceof Array||"object"==typeof i&&!!i.push&&t.call(i)===e)}}(),p={},m=function(s,r,n,a){this.sc=p[s]?p[s].sc:[],p[s]=this,this.gsClass=null,this.func=n;var o=[];this.check=function(l){for(var _,u,c,f,d=r.length,g=d;--d>-1;)(_=p[r[d]]||new m(r[d],[])).gsClass?(o[d]=_.gsClass,g--):l&&_.sc.push(this);if(0===g&&n)for(u=("com.greensock."+s).split("."),c=u.pop(),f=h(u.join("."))[c]=this.gsClass=n.apply(n,o),a&&(i[c]=f,"function"==typeof define&&define.amd?define((t.GreenSockAMDPath?t.GreenSockAMDPath+"/":"")+s.split(".").pop(),[],function(){return f}):s===e&&"undefined"!=typeof module&&module.exports&&(module.exports=f)),d=0;this.sc.length>d;d++)this.sc[d].check()},this.check(!0)},d=t._gsDefine=function(t,e,i,s){return new m(t,e,i,s)},g=l._class=function(t,e,i){return e=e||function(){},d(t,[],function(){return e},i),e};d.globals=i;var v=[0,0,1,1],y=[],T=g("easing.Ease",function(t,e,i,s){this._func=t,this._type=i||0,this._power=s||0,this._params=e?v.concat(e):v},!0),x=T.map={},w=T.register=function(t,e,i,s){for(var r,n,a,o,h=e.split(","),_=h.length,u=(i||"easeIn,easeOut,easeInOut").split(",");--_>-1;)for(n=h[_],r=s?g("easing."+n,null,!0):l.easing[n]||{},a=u.length;--a>-1;)o=u[a],x[n+"."+o]=x[o+n]=r[o]=t.getRatio?t:t[o]||new t};for(n=T.prototype,n._calcEnd=!1,n.getRatio=function(t){if(this._func)return this._params[0]=t,this._func.apply(null,this._params);var e=this._type,i=this._power,s=1===e?1-t:2===e?t:.5>t?2*t:2*(1-t);return 1===i?s*=s:2===i?s*=s*s:3===i?s*=s*s*s:4===i&&(s*=s*s*s*s),1===e?1-s:2===e?s:.5>t?s/2:1-s/2},s=["Linear","Quad","Cubic","Quart","Quint,Strong"],r=s.length;--r>-1;)n=s[r]+",Power"+r,w(new T(null,null,1,r),n,"easeOut",!0),w(new T(null,null,2,r),n,"easeIn"+(0===r?",easeNone":"")),w(new T(null,null,3,r),n,"easeInOut");x.linear=l.easing.Linear.easeIn,x.swing=l.easing.Quad.easeInOut;var b=g("events.EventDispatcher",function(t){this._listeners={},this._eventTarget=t||this});n=b.prototype,n.addEventListener=function(t,e,i,s,r){r=r||0;var n,h,l=this._listeners[t],_=0;for(null==l&&(this._listeners[t]=l=[]),h=l.length;--h>-1;)n=l[h],n.c===e&&n.s===i?l.splice(h,1):0===_&&r>n.pr&&(_=h+1);l.splice(_,0,{c:e,s:i,up:s,pr:r}),this!==a||o||a.wake()},n.removeEventListener=function(t,e){var i,s=this._listeners[t];if(s)for(i=s.length;--i>-1;)if(s[i].c===e)return s.splice(i,1),void 0},n.dispatchEvent=function(t){var e,i,s,r=this._listeners[t];if(r)for(e=r.length,i=this._eventTarget;--e>-1;)s=r[e],s&&(s.up?s.c.call(s.s||i,{type:t,target:i}):s.c.call(s.s||i))};var P=t.requestAnimationFrame,k=t.cancelAnimationFrame,S=Date.now||function(){return(new Date).getTime()},R=S();for(s=["ms","moz","webkit","o"],r=s.length;--r>-1&&!P;)P=t[s[r]+"RequestAnimationFrame"],k=t[s[r]+"CancelAnimationFrame"]||t[s[r]+"CancelRequestAnimationFrame"];g("Ticker",function(t,e){var i,s,r,n,h,l=this,u=S(),f=e!==!1&&P,p=500,m=33,d="tick",g=function(t){var e,a,o=S()-R;o>p&&(u+=o-m),R+=o,l.time=(R-u)/1e3,e=l.time-h,(!i||e>0||t===!0)&&(l.frame++,h+=e+(e>=n?.004:n-e),a=!0),t!==!0&&(r=s(g)),a&&l.dispatchEvent(d)};b.call(l),l.time=l.frame=0,l.tick=function(){g(!0)},l.lagSmoothing=function(t,e){p=t||1/_,m=Math.min(e,p,0)},l.sleep=function(){null!=r&&(f&&k?k(r):clearTimeout(r),s=c,r=null,l===a&&(o=!1))},l.wake=function(){null!==r?l.sleep():l.frame>10&&(R=S()-p+5),s=0===i?c:f&&P?P:function(t){return setTimeout(t,0|1e3*(h-l.time)+1)},l===a&&(o=!0),g(2)},l.fps=function(t){return arguments.length?(i=t,n=1/(i||60),h=this.time+n,l.wake(),void 0):i},l.useRAF=function(t){return arguments.length?(l.sleep(),f=t,l.fps(i),void 0):f},l.fps(t),setTimeout(function(){f&&5>l.frame&&l.useRAF(!1)},1500)}),n=l.Ticker.prototype=new l.events.EventDispatcher,n.constructor=l.Ticker;var O=g("core.Animation",function(t,e){if(this.vars=e=e||{},this._duration=this._totalDuration=t||0,this._delay=Number(e.delay)||0,this._timeScale=1,this._active=e.immediateRender===!0,this.data=e.data,this._reversed=e.reversed===!0,U){o||a.wake();var i=this.vars.useFrames?j:U;i.add(this,i._time),this.vars.paused&&this.paused(!0)}});a=O.ticker=new l.Ticker,n=O.prototype,n._dirty=n._gc=n._initted=n._paused=!1,n._totalTime=n._time=0,n._rawPrevTime=-1,n._next=n._last=n._onUpdate=n._timeline=n.timeline=null,n._paused=!1;var A=function(){o&&S()-R>2e3&&a.wake(),setTimeout(A,2e3)};A(),n.play=function(t,e){return null!=t&&this.seek(t,e),this.reversed(!1).paused(!1)},n.pause=function(t,e){return null!=t&&this.seek(t,e),this.paused(!0)},n.resume=function(t,e){return null!=t&&this.seek(t,e),this.paused(!1)},n.seek=function(t,e){return this.totalTime(Number(t),e!==!1)},n.restart=function(t,e){return this.reversed(!1).paused(!1).totalTime(t?-this._delay:0,e!==!1,!0)},n.reverse=function(t,e){return null!=t&&this.seek(t||this.totalDuration(),e),this.reversed(!0).paused(!1)},n.render=function(){},n.invalidate=function(){return this._time=this._totalTime=0,this._initted=this._gc=!1,this._rawPrevTime=-1,(this._gc||!this.timeline)&&this._enabled(!0),this},n.isActive=function(){var t,e=this._timeline,i=this._startTime;return!e||!this._gc&&!this._paused&&e.isActive()&&(t=e.rawTime())>=i&&i+this.totalDuration()/this._timeScale>t},n._enabled=function(t,e){return o||a.wake(),this._gc=!t,this._active=this.isActive(),e!==!0&&(t&&!this.timeline?this._timeline.add(this,this._startTime-this._delay):!t&&this.timeline&&this._timeline._remove(this,!0)),!1},n._kill=function(){return this._enabled(!1,!1)},n.kill=function(t,e){return this._kill(t,e),this},n._uncache=function(t){for(var e=t?this:this.timeline;e;)e._dirty=!0,e=e.timeline;return this},n._swapSelfInParams=function(t){for(var e=t.length,i=t.concat();--e>-1;)"{self}"===t[e]&&(i[e]=this);return i},n._callback=function(t){var e=this.vars;e[t].apply(e[t+"Scope"]||e.callbackScope||this,e[t+"Params"]||y)},n.eventCallback=function(t,e,i,s){if("on"===(t||"").substr(0,2)){var r=this.vars;if(1===arguments.length)return r[t];null==e?delete r[t]:(r[t]=e,r[t+"Params"]=f(i)&&-1!==i.join("").indexOf("{self}")?this._swapSelfInParams(i):i,r[t+"Scope"]=s),"onUpdate"===t&&(this._onUpdate=e)}return this},n.delay=function(t){return arguments.length?(this._timeline.smoothChildTiming&&this.startTime(this._startTime+t-this._delay),this._delay=t,this):this._delay},n.duration=function(t){return arguments.length?(this._duration=this._totalDuration=t,this._uncache(!0),this._timeline.smoothChildTiming&&this._time>0&&this._time<this._duration&&0!==t&&this.totalTime(this._totalTime*(t/this._duration),!0),this):(this._dirty=!1,this._duration)},n.totalDuration=function(t){return this._dirty=!1,arguments.length?this.duration(t):this._totalDuration},n.time=function(t,e){return arguments.length?(this._dirty&&this.totalDuration(),this.totalTime(t>this._duration?this._duration:t,e)):this._time},n.totalTime=function(t,e,i){if(o||a.wake(),!arguments.length)return this._totalTime;if(this._timeline){if(0>t&&!i&&(t+=this.totalDuration()),this._timeline.smoothChildTiming){this._dirty&&this.totalDuration();var s=this._totalDuration,r=this._timeline;if(t>s&&!i&&(t=s),this._startTime=(this._paused?this._pauseTime:r._time)-(this._reversed?s-t:t)/this._timeScale,r._dirty||this._uncache(!1),r._timeline)for(;r._timeline;)r._timeline._time!==(r._startTime+r._totalTime)/r._timeScale&&r.totalTime(r._totalTime,!0),r=r._timeline}this._gc&&this._enabled(!0,!1),(this._totalTime!==t||0===this._duration)&&(this.render(t,e,!1),I.length&&V())}return this},n.progress=n.totalProgress=function(t,e){return arguments.length?this.totalTime(this.duration()*t,e):this._time/this.duration()},n.startTime=function(t){return arguments.length?(t!==this._startTime&&(this._startTime=t,this.timeline&&this.timeline._sortChildren&&this.timeline.add(this,t-this._delay)),this):this._startTime},n.endTime=function(t){return this._startTime+(0!=t?this.totalDuration():this.duration())/this._timeScale},n.timeScale=function(t){if(!arguments.length)return this._timeScale;if(t=t||_,this._timeline&&this._timeline.smoothChildTiming){var e=this._pauseTime,i=e||0===e?e:this._timeline.totalTime();this._startTime=i-(i-this._startTime)*this._timeScale/t}return this._timeScale=t,this._uncache(!1)},n.reversed=function(t){return arguments.length?(t!=this._reversed&&(this._reversed=t,this.totalTime(this._timeline&&!this._timeline.smoothChildTiming?this.totalDuration()-this._totalTime:this._totalTime,!0)),this):this._reversed},n.paused=function(t){if(!arguments.length)return this._paused;var e,i,s=this._timeline;return t!=this._paused&&s&&(o||t||a.wake(),e=s.rawTime(),i=e-this._pauseTime,!t&&s.smoothChildTiming&&(this._startTime+=i,this._uncache(!1)),this._pauseTime=t?e:null,this._paused=t,this._active=this.isActive(),!t&&0!==i&&this._initted&&this.duration()&&this.render(s.smoothChildTiming?this._totalTime:(e-this._startTime)/this._timeScale,!0,!0)),this._gc&&!t&&this._enabled(!0,!1),this};var C=g("core.SimpleTimeline",function(t){O.call(this,0,t),this.autoRemoveChildren=this.smoothChildTiming=!0});n=C.prototype=new O,n.constructor=C,n.kill()._gc=!1,n._first=n._last=n._recent=null,n._sortChildren=!1,n.add=n.insert=function(t,e){var i,s;if(t._startTime=Number(e||0)+t._delay,t._paused&&this!==t._timeline&&(t._pauseTime=t._startTime+(this.rawTime()-t._startTime)/t._timeScale),t.timeline&&t.timeline._remove(t,!0),t.timeline=t._timeline=this,t._gc&&t._enabled(!0,!0),i=this._last,this._sortChildren)for(s=t._startTime;i&&i._startTime>s;)i=i._prev;return i?(t._next=i._next,i._next=t):(t._next=this._first,this._first=t),t._next?t._next._prev=t:this._last=t,t._prev=i,this._recent=t,this._timeline&&this._uncache(!0),this},n._remove=function(t,e){return t.timeline===this&&(e||t._enabled(!1,!0),t._prev?t._prev._next=t._next:this._first===t&&(this._first=t._next),t._next?t._next._prev=t._prev:this._last===t&&(this._last=t._prev),t._next=t._prev=t.timeline=null,t===this._recent&&(this._recent=this._last),this._timeline&&this._uncache(!0)),this},n.render=function(t,e,i){var s,r=this._first;for(this._totalTime=this._time=this._rawPrevTime=t;r;)s=r._next,(r._active||t>=r._startTime&&!r._paused)&&(r._reversed?r.render((r._dirty?r.totalDuration():r._totalDuration)-(t-r._startTime)*r._timeScale,e,i):r.render((t-r._startTime)*r._timeScale,e,i)),r=s},n.rawTime=function(){return o||a.wake(),this._totalTime};var D=g("TweenLite",function(e,i,s){if(O.call(this,i,s),this.render=D.prototype.render,null==e)throw"Cannot tween a null target.";this.target=e="string"!=typeof e?e:D.selector(e)||e;var r,n,a,o=e.jquery||e.length&&e!==t&&e[0]&&(e[0]===t||e[0].nodeType&&e[0].style&&!e.nodeType),h=this.vars.overwrite;if(this._overwrite=h=null==h?Y[D.defaultOverwrite]:"number"==typeof h?h>>0:Y[h],(o||e instanceof Array||e.push&&f(e))&&"number"!=typeof e[0])for(this._targets=a=u(e),this._propLookup=[],this._siblings=[],r=0;a.length>r;r++)n=a[r],n?"string"!=typeof n?n.length&&n!==t&&n[0]&&(n[0]===t||n[0].nodeType&&n[0].style&&!n.nodeType)?(a.splice(r--,1),this._targets=a=a.concat(u(n))):(this._siblings[r]=G(n,this,!1),1===h&&this._siblings[r].length>1&&Z(n,this,null,1,this._siblings[r])):(n=a[r--]=D.selector(n),"string"==typeof n&&a.splice(r+1,1)):a.splice(r--,1);else this._propLookup={},this._siblings=G(e,this,!1),1===h&&this._siblings.length>1&&Z(e,this,null,1,this._siblings);(this.vars.immediateRender||0===i&&0===this._delay&&this.vars.immediateRender!==!1)&&(this._time=-_,this.render(-this._delay))},!0),M=function(e){return e&&e.length&&e!==t&&e[0]&&(e[0]===t||e[0].nodeType&&e[0].style&&!e.nodeType)},z=function(t,e){var i,s={};for(i in t)B[i]||i in e&&"transform"!==i&&"x"!==i&&"y"!==i&&"width"!==i&&"height"!==i&&"className"!==i&&"border"!==i||!(!E[i]||E[i]&&E[i]._autoCSS)||(s[i]=t[i],delete t[i]);t.css=s};n=D.prototype=new O,n.constructor=D,n.kill()._gc=!1,n.ratio=0,n._firstPT=n._targets=n._overwrittenProps=n._startAt=null,n._notifyPluginsOfEnabled=n._lazy=!1,D.version="1.17.0",D.defaultEase=n._ease=new T(null,null,1,1),D.defaultOverwrite="auto",D.ticker=a,D.autoSleep=120,D.lagSmoothing=function(t,e){a.lagSmoothing(t,e)},D.selector=t.$||t.jQuery||function(e){var i=t.$||t.jQuery;return i?(D.selector=i,i(e)):"undefined"==typeof document?e:document.querySelectorAll?document.querySelectorAll(e):document.getElementById("#"===e.charAt(0)?e.substr(1):e)};var I=[],F={},N=D._internals={isArray:f,isSelector:M,lazyTweens:I},E=D._plugins={},L=N.tweenLookup={},X=0,B=N.reservedProps={ease:1,delay:1,overwrite:1,onComplete:1,onCompleteParams:1,onCompleteScope:1,useFrames:1,runBackwards:1,startAt:1,onUpdate:1,onUpdateParams:1,onUpdateScope:1,onStart:1,onStartParams:1,onStartScope:1,onReverseComplete:1,onReverseCompleteParams:1,onReverseCompleteScope:1,onRepeat:1,onRepeatParams:1,onRepeatScope:1,easeParams:1,yoyo:1,immediateRender:1,repeat:1,repeatDelay:1,data:1,paused:1,reversed:1,autoCSS:1,lazy:1,onOverwrite:1,callbackScope:1},Y={none:0,all:1,auto:2,concurrent:3,allOnStart:4,preexisting:5,"true":1,"false":0},j=O._rootFramesTimeline=new C,U=O._rootTimeline=new C,q=30,V=N.lazyRender=function(){var t,e=I.length;for(F={};--e>-1;)t=I[e],t&&t._lazy!==!1&&(t.render(t._lazy[0],t._lazy[1],!0),t._lazy=!1);I.length=0};U._startTime=a.time,j._startTime=a.frame,U._active=j._active=!0,setTimeout(V,1),O._updateRoot=D.render=function(){var t,e,i;if(I.length&&V(),U.render((a.time-U._startTime)*U._timeScale,!1,!1),j.render((a.frame-j._startTime)*j._timeScale,!1,!1),I.length&&V(),a.frame>=q){q=a.frame+(parseInt(D.autoSleep,10)||120);for(i in L){for(e=L[i].tweens,t=e.length;--t>-1;)e[t]._gc&&e.splice(t,1);0===e.length&&delete L[i]}if(i=U._first,(!i||i._paused)&&D.autoSleep&&!j._first&&1===a._listeners.tick.length){for(;i&&i._paused;)i=i._next;i||a.sleep()}}},a.addEventListener("tick",O._updateRoot);var G=function(t,e,i){var s,r,n=t._gsTweenID;if(L[n||(t._gsTweenID=n="t"+X++)]||(L[n]={target:t,tweens:[]}),e&&(s=L[n].tweens,s[r=s.length]=e,i))for(;--r>-1;)s[r]===e&&s.splice(r,1);return L[n].tweens},W=function(t,e,i,s){var r,n,a=t.vars.onOverwrite;return a&&(r=a(t,e,i,s)),a=D.onOverwrite,a&&(n=a(t,e,i,s)),r!==!1&&n!==!1},Z=function(t,e,i,s,r){var n,a,o,h;if(1===s||s>=4){for(h=r.length,n=0;h>n;n++)if((o=r[n])!==e)o._gc||o._kill(null,t,e)&&(a=!0);else if(5===s)break;return a}var l,u=e._startTime+_,c=[],f=0,p=0===e._duration;for(n=r.length;--n>-1;)(o=r[n])===e||o._gc||o._paused||(o._timeline!==e._timeline?(l=l||Q(e,0,p),0===Q(o,l,p)&&(c[f++]=o)):u>=o._startTime&&o._startTime+o.totalDuration()/o._timeScale>u&&((p||!o._initted)&&2e-10>=u-o._startTime||(c[f++]=o)));for(n=f;--n>-1;)if(o=c[n],2===s&&o._kill(i,t,e)&&(a=!0),2!==s||!o._firstPT&&o._initted){if(2!==s&&!W(o,e))continue;o._enabled(!1,!1)&&(a=!0)}return a},Q=function(t,e,i){for(var s=t._timeline,r=s._timeScale,n=t._startTime;s._timeline;){if(n+=s._startTime,r*=s._timeScale,s._paused)return-100;s=s._timeline}return n/=r,n>e?n-e:i&&n===e||!t._initted&&2*_>n-e?_:(n+=t.totalDuration()/t._timeScale/r)>e+_?0:n-e-_};n._init=function(){var t,e,i,s,r,n=this.vars,a=this._overwrittenProps,o=this._duration,h=!!n.immediateRender,l=n.ease;if(n.startAt){this._startAt&&(this._startAt.render(-1,!0),this._startAt.kill()),r={};for(s in n.startAt)r[s]=n.startAt[s];if(r.overwrite=!1,r.immediateRender=!0,r.lazy=h&&n.lazy!==!1,r.startAt=r.delay=null,this._startAt=D.to(this.target,0,r),h)if(this._time>0)this._startAt=null;else if(0!==o)return}else if(n.runBackwards&&0!==o)if(this._startAt)this._startAt.render(-1,!0),this._startAt.kill(),this._startAt=null;else{0!==this._time&&(h=!1),i={};for(s in n)B[s]&&"autoCSS"!==s||(i[s]=n[s]);if(i.overwrite=0,i.data="isFromStart",i.lazy=h&&n.lazy!==!1,i.immediateRender=h,this._startAt=D.to(this.target,0,i),h){if(0===this._time)return}else this._startAt._init(),this._startAt._enabled(!1),this.vars.immediateRender&&(this._startAt=null)}if(this._ease=l=l?l instanceof T?l:"function"==typeof l?new T(l,n.easeParams):x[l]||D.defaultEase:D.defaultEase,n.easeParams instanceof Array&&l.config&&(this._ease=l.config.apply(l,n.easeParams)),this._easeType=this._ease._type,this._easePower=this._ease._power,this._firstPT=null,this._targets)for(t=this._targets.length;--t>-1;)this._initProps(this._targets[t],this._propLookup[t]={},this._siblings[t],a?a[t]:null)&&(e=!0);else e=this._initProps(this.target,this._propLookup,this._siblings,a);if(e&&D._onPluginEvent("_onInitAllProps",this),a&&(this._firstPT||"function"!=typeof this.target&&this._enabled(!1,!1)),n.runBackwards)for(i=this._firstPT;i;)i.s+=i.c,i.c=-i.c,i=i._next;this._onUpdate=n.onUpdate,this._initted=!0},n._initProps=function(e,i,s,r){var n,a,o,h,l,_;if(null==e)return!1;F[e._gsTweenID]&&V(),this.vars.css||e.style&&e!==t&&e.nodeType&&E.css&&this.vars.autoCSS!==!1&&z(this.vars,e);for(n in this.vars){if(_=this.vars[n],B[n])_&&(_ instanceof Array||_.push&&f(_))&&-1!==_.join("").indexOf("{self}")&&(this.vars[n]=_=this._swapSelfInParams(_,this));else if(E[n]&&(h=new E[n])._onInitTween(e,this.vars[n],this)){for(this._firstPT=l={_next:this._firstPT,t:h,p:"setRatio",s:0,c:1,f:!0,n:n,pg:!0,pr:h._priority},a=h._overwriteProps.length;--a>-1;)i[h._overwriteProps[a]]=this._firstPT;(h._priority||h._onInitAllProps)&&(o=!0),(h._onDisable||h._onEnable)&&(this._notifyPluginsOfEnabled=!0)}else this._firstPT=i[n]=l={_next:this._firstPT,t:e,p:n,f:"function"==typeof e[n],n:n,pg:!1,pr:0},l.s=l.f?e[n.indexOf("set")||"function"!=typeof e["get"+n.substr(3)]?n:"get"+n.substr(3)]():parseFloat(e[n]),l.c="string"==typeof _&&"="===_.charAt(1)?parseInt(_.charAt(0)+"1",10)*Number(_.substr(2)):Number(_)-l.s||0;l&&l._next&&(l._next._prev=l)}return r&&this._kill(r,e)?this._initProps(e,i,s,r):this._overwrite>1&&this._firstPT&&s.length>1&&Z(e,this,i,this._overwrite,s)?(this._kill(i,e),this._initProps(e,i,s,r)):(this._firstPT&&(this.vars.lazy!==!1&&this._duration||this.vars.lazy&&!this._duration)&&(F[e._gsTweenID]=!0),o)
},n.render=function(t,e,i){var s,r,n,a,o=this._time,h=this._duration,l=this._rawPrevTime;if(t>=h)this._totalTime=this._time=h,this.ratio=this._ease._calcEnd?this._ease.getRatio(1):1,this._reversed||(s=!0,r="onComplete",i=i||this._timeline.autoRemoveChildren),0===h&&(this._initted||!this.vars.lazy||i)&&(this._startTime===this._timeline._duration&&(t=0),(0===t||0>l||l===_&&"isPause"!==this.data)&&l!==t&&(i=!0,l>_&&(r="onReverseComplete")),this._rawPrevTime=a=!e||t||l===t?t:_);else if(1e-7>t)this._totalTime=this._time=0,this.ratio=this._ease._calcEnd?this._ease.getRatio(0):0,(0!==o||0===h&&l>0)&&(r="onReverseComplete",s=this._reversed),0>t&&(this._active=!1,0===h&&(this._initted||!this.vars.lazy||i)&&(l>=0&&(l!==_||"isPause"!==this.data)&&(i=!0),this._rawPrevTime=a=!e||t||l===t?t:_)),this._initted||(i=!0);else if(this._totalTime=this._time=t,this._easeType){var u=t/h,c=this._easeType,f=this._easePower;(1===c||3===c&&u>=.5)&&(u=1-u),3===c&&(u*=2),1===f?u*=u:2===f?u*=u*u:3===f?u*=u*u*u:4===f&&(u*=u*u*u*u),this.ratio=1===c?1-u:2===c?u:.5>t/h?u/2:1-u/2}else this.ratio=this._ease.getRatio(t/h);if(this._time!==o||i){if(!this._initted){if(this._init(),!this._initted||this._gc)return;if(!i&&this._firstPT&&(this.vars.lazy!==!1&&this._duration||this.vars.lazy&&!this._duration))return this._time=this._totalTime=o,this._rawPrevTime=l,I.push(this),this._lazy=[t,e],void 0;this._time&&!s?this.ratio=this._ease.getRatio(this._time/h):s&&this._ease._calcEnd&&(this.ratio=this._ease.getRatio(0===this._time?0:1))}for(this._lazy!==!1&&(this._lazy=!1),this._active||!this._paused&&this._time!==o&&t>=0&&(this._active=!0),0===o&&(this._startAt&&(t>=0?this._startAt.render(t,e,i):r||(r="_dummyGS")),this.vars.onStart&&(0!==this._time||0===h)&&(e||this._callback("onStart"))),n=this._firstPT;n;)n.f?n.t[n.p](n.c*this.ratio+n.s):n.t[n.p]=n.c*this.ratio+n.s,n=n._next;this._onUpdate&&(0>t&&this._startAt&&t!==-1e-4&&this._startAt.render(t,e,i),e||(this._time!==o||s)&&this._callback("onUpdate")),r&&(!this._gc||i)&&(0>t&&this._startAt&&!this._onUpdate&&t!==-1e-4&&this._startAt.render(t,e,i),s&&(this._timeline.autoRemoveChildren&&this._enabled(!1,!1),this._active=!1),!e&&this.vars[r]&&this._callback(r),0===h&&this._rawPrevTime===_&&a!==_&&(this._rawPrevTime=0))}},n._kill=function(t,e,i){if("all"===t&&(t=null),null==t&&(null==e||e===this.target))return this._lazy=!1,this._enabled(!1,!1);e="string"!=typeof e?e||this._targets||this.target:D.selector(e)||e;var s,r,n,a,o,h,l,_,u,c=i&&this._time&&i._startTime===this._startTime&&this._timeline===i._timeline;if((f(e)||M(e))&&"number"!=typeof e[0])for(s=e.length;--s>-1;)this._kill(t,e[s],i)&&(h=!0);else{if(this._targets){for(s=this._targets.length;--s>-1;)if(e===this._targets[s]){o=this._propLookup[s]||{},this._overwrittenProps=this._overwrittenProps||[],r=this._overwrittenProps[s]=t?this._overwrittenProps[s]||{}:"all";break}}else{if(e!==this.target)return!1;o=this._propLookup,r=this._overwrittenProps=t?this._overwrittenProps||{}:"all"}if(o){if(l=t||o,_=t!==r&&"all"!==r&&t!==o&&("object"!=typeof t||!t._tempKill),i&&(D.onOverwrite||this.vars.onOverwrite)){for(n in l)o[n]&&(u||(u=[]),u.push(n));if((u||!t)&&!W(this,i,e,u))return!1}for(n in l)(a=o[n])&&(c&&(a.f?a.t[a.p](a.s):a.t[a.p]=a.s,h=!0),a.pg&&a.t._kill(l)&&(h=!0),a.pg&&0!==a.t._overwriteProps.length||(a._prev?a._prev._next=a._next:a===this._firstPT&&(this._firstPT=a._next),a._next&&(a._next._prev=a._prev),a._next=a._prev=null),delete o[n]),_&&(r[n]=1);!this._firstPT&&this._initted&&this._enabled(!1,!1)}}return h},n.invalidate=function(){return this._notifyPluginsOfEnabled&&D._onPluginEvent("_onDisable",this),this._firstPT=this._overwrittenProps=this._startAt=this._onUpdate=null,this._notifyPluginsOfEnabled=this._active=this._lazy=!1,this._propLookup=this._targets?{}:[],O.prototype.invalidate.call(this),this.vars.immediateRender&&(this._time=-_,this.render(-this._delay)),this},n._enabled=function(t,e){if(o||a.wake(),t&&this._gc){var i,s=this._targets;if(s)for(i=s.length;--i>-1;)this._siblings[i]=G(s[i],this,!0);else this._siblings=G(this.target,this,!0)}return O.prototype._enabled.call(this,t,e),this._notifyPluginsOfEnabled&&this._firstPT?D._onPluginEvent(t?"_onEnable":"_onDisable",this):!1},D.to=function(t,e,i){return new D(t,e,i)},D.from=function(t,e,i){return i.runBackwards=!0,i.immediateRender=0!=i.immediateRender,new D(t,e,i)},D.fromTo=function(t,e,i,s){return s.startAt=i,s.immediateRender=0!=s.immediateRender&&0!=i.immediateRender,new D(t,e,s)},D.delayedCall=function(t,e,i,s,r){return new D(e,0,{delay:t,onComplete:e,onCompleteParams:i,callbackScope:s,onReverseComplete:e,onReverseCompleteParams:i,immediateRender:!1,lazy:!1,useFrames:r,overwrite:0})},D.set=function(t,e){return new D(t,0,e)},D.getTweensOf=function(t,e){if(null==t)return[];t="string"!=typeof t?t:D.selector(t)||t;var i,s,r,n;if((f(t)||M(t))&&"number"!=typeof t[0]){for(i=t.length,s=[];--i>-1;)s=s.concat(D.getTweensOf(t[i],e));for(i=s.length;--i>-1;)for(n=s[i],r=i;--r>-1;)n===s[r]&&s.splice(i,1)}else for(s=G(t).concat(),i=s.length;--i>-1;)(s[i]._gc||e&&!s[i].isActive())&&s.splice(i,1);return s},D.killTweensOf=D.killDelayedCallsTo=function(t,e,i){"object"==typeof e&&(i=e,e=!1);for(var s=D.getTweensOf(t,e),r=s.length;--r>-1;)s[r]._kill(i,t)};var $=g("plugins.TweenPlugin",function(t,e){this._overwriteProps=(t||"").split(","),this._propName=this._overwriteProps[0],this._priority=e||0,this._super=$.prototype},!0);if(n=$.prototype,$.version="1.10.1",$.API=2,n._firstPT=null,n._addTween=function(t,e,i,s,r,n){var a,o;return null!=s&&(a="number"==typeof s||"="!==s.charAt(1)?Number(s)-Number(i):parseInt(s.charAt(0)+"1",10)*Number(s.substr(2)))?(this._firstPT=o={_next:this._firstPT,t:t,p:e,s:i,c:a,f:"function"==typeof t[e],n:r||e,r:n},o._next&&(o._next._prev=o),o):void 0},n.setRatio=function(t){for(var e,i=this._firstPT,s=1e-6;i;)e=i.c*t+i.s,i.r?e=Math.round(e):s>e&&e>-s&&(e=0),i.f?i.t[i.p](e):i.t[i.p]=e,i=i._next},n._kill=function(t){var e,i=this._overwriteProps,s=this._firstPT;if(null!=t[this._propName])this._overwriteProps=[];else for(e=i.length;--e>-1;)null!=t[i[e]]&&i.splice(e,1);for(;s;)null!=t[s.n]&&(s._next&&(s._next._prev=s._prev),s._prev?(s._prev._next=s._next,s._prev=null):this._firstPT===s&&(this._firstPT=s._next)),s=s._next;return!1},n._roundProps=function(t,e){for(var i=this._firstPT;i;)(t[this._propName]||null!=i.n&&t[i.n.split(this._propName+"_").join("")])&&(i.r=e),i=i._next},D._onPluginEvent=function(t,e){var i,s,r,n,a,o=e._firstPT;if("_onInitAllProps"===t){for(;o;){for(a=o._next,s=r;s&&s.pr>o.pr;)s=s._next;(o._prev=s?s._prev:n)?o._prev._next=o:r=o,(o._next=s)?s._prev=o:n=o,o=a}o=e._firstPT=r}for(;o;)o.pg&&"function"==typeof o.t[t]&&o.t[t]()&&(i=!0),o=o._next;return i},$.activate=function(t){for(var e=t.length;--e>-1;)t[e].API===$.API&&(E[(new t[e])._propName]=t[e]);return!0},d.plugin=function(t){if(!(t&&t.propName&&t.init&&t.API))throw"illegal plugin definition.";var e,i=t.propName,s=t.priority||0,r=t.overwriteProps,n={init:"_onInitTween",set:"setRatio",kill:"_kill",round:"_roundProps",initAll:"_onInitAllProps"},a=g("plugins."+i.charAt(0).toUpperCase()+i.substr(1)+"Plugin",function(){$.call(this,i,s),this._overwriteProps=r||[]},t.global===!0),o=a.prototype=new $(i);o.constructor=a,a.API=t.API;for(e in n)"function"==typeof t[e]&&(o[n[e]]=t[e]);return a.version=t.version,$.activate([a]),a},s=t._gsQueue){for(r=0;s.length>r;r++)s[r]();for(n in p)p[n].func||t.console.log("GSAP encountered missing dependency: com.greensock."+n)}o=!1}}("undefined"!=typeof module&&module.exports&&"undefined"!=typeof global?global:this||window,"TweenMax");



/*!
 * VERSION: beta 0.6.3
 * DATE: 2014-12-31
 * UPDATES AND DOCS AT: http://www.greensock.com
 *
 * @license Copyright (c) 2008-2015, GreenSock. All rights reserved.
 * This work is subject to the terms at http://greensock.com/standard-license or for
 * Club GreenSock members, the software agreement that was issued with your membership.
 * 
 * @author: Jack Doyle, jack@greensock.com
 */
var _gsScope="undefined"!=typeof module&&module.exports&&"undefined"!=typeof global?global:this||window;(_gsScope._gsQueue||(_gsScope._gsQueue=[])).push(function(){"use strict";_gsScope._gsDefine("plugins.CSSRulePlugin",["plugins.TweenPlugin","TweenLite","plugins.CSSPlugin"],function(t,e,i){var r=function(){t.call(this,"cssRule"),this._overwriteProps.length=0},s=window.document,n=i.prototype.setRatio,a=r.prototype=new i;return a._propName="cssRule",a.constructor=r,r.version="0.6.3",r.API=2,r.getRule=function(t){var e,i,r,n,a=s.all?"rules":"cssRules",o=s.styleSheets,l=o.length,h=":"===t.charAt(0);for(t=(h?"":",")+t.toLowerCase()+",",h&&(n=[]);--l>-1;){try{if(i=o[l][a],!i)continue;e=i.length}catch(u){console.log(u);continue}for(;--e>-1;)if(r=i[e],r.selectorText&&-1!==(","+r.selectorText.split("::").join(":").toLowerCase()+",").indexOf(t)){if(!h)return r.style;n.push(r.style)}}return n},a._onInitTween=function(t,e,r){if(void 0===t.cssText)return!1;var n=t._gsProxy=t._gsProxy||s.createElement("div");return this._ss=t,this._proxy=n.style,n.style.cssText=t.cssText,i.prototype._onInitTween.call(this,n,e,r),!0},a.setRatio=function(t){n.call(this,t),this._ss.cssText=this._proxy.cssText},t.activate([r]),r},!0)}),_gsScope._gsDefine&&_gsScope._gsQueue.pop()();



/*!
 * VERSION: beta 1.3.0
 * DATE: 2015-02-06
 * UPDATES AND DOCS AT: http://greensock.com
 *
 * @license Copyright (c) 2008-2015, GreenSock. All rights reserved.
 * This work is subject to the terms at http://greensock.com/standard-license or for
 * Club GreenSock members, the software agreement that was issued with your membership.
 * 
 * @author: Jack Doyle, jack@greensock.com
 **/
var _gsScope="undefined"!=typeof module&&module.exports&&"undefined"!=typeof global?global:this||window;(_gsScope._gsQueue||(_gsScope._gsQueue=[])).push(function(){"use strict";var t=/(\d|\.)+/g,e={aqua:[0,255,255],lime:[0,255,0],silver:[192,192,192],black:[0,0,0],maroon:[128,0,0],teal:[0,128,128],blue:[0,0,255],navy:[0,0,128],white:[255,255,255],fuchsia:[255,0,255],olive:[128,128,0],yellow:[255,255,0],orange:[255,165,0],gray:[128,128,128],purple:[128,0,128],green:[0,128,0],red:[255,0,0],pink:[255,192,203],cyan:[0,255,255],transparent:[255,255,255,0]},i=function(t,e,i){return t=0>t?t+1:t>1?t-1:t,0|255*(1>6*t?e+6*(i-e)*t:.5>t?i:2>3*t?e+6*(i-e)*(2/3-t):e)+.5},r=function(r){if(""===r||null==r||"none"===r)return e.transparent;if(e[r])return e[r];if("number"==typeof r)return[r>>16,255&r>>8,255&r];if("#"===r.charAt(0))return 4===r.length&&(r="#"+r.charAt(1)+r.charAt(1)+r.charAt(2)+r.charAt(2)+r.charAt(3)+r.charAt(3)),r=parseInt(r.substr(1),16),[r>>16,255&r>>8,255&r];if("hsl"===r.substr(0,3)){r=r.match(t);var s=Number(r[0])%360/360,n=Number(r[1])/100,a=Number(r[2])/100,o=.5>=a?a*(n+1):a+n-a*n,l=2*a-o;return r.length>3&&(r[3]=Number(r[3])),r[0]=i(s+1/3,l,o),r[1]=i(s,l,o),r[2]=i(s-1/3,l,o),r}return r.match(t)||e.transparent};_gsScope._gsDefine.plugin({propName:"colorProps",version:"1.3.0",priority:-1,API:2,init:function(t,e){this._target=t;var i,s,n,a;this.numFormat="number"===e.format;for(i in e)"format"!==i&&(n=r(e[i]),this._firstPT=a={_next:this._firstPT,p:i,f:"function"==typeof t[i],n:i,r:!1},s=r(a.f?t[i.indexOf("set")||"function"!=typeof t["get"+i.substr(3)]?i:"get"+i.substr(3)]():t[i]),a.s=Number(s[0]),a.c=Number(n[0])-a.s,a.gs=Number(s[1]),a.gc=Number(n[1])-a.gs,a.bs=Number(s[2]),a.bc=Number(n[2])-a.bs,(a.rgba=s.length>3||n.length>3)&&(a.as=4>s.length?1:Number(s[3]),a.ac=(4>n.length?1:Number(n[3]))-a.as),a._next&&(a._next._prev=a));return!0},set:function(t){for(var e,i=this._firstPT;i;)e=this.numFormat?i.s+t*i.c<<16|i.gs+t*i.gc<<8|i.bs+t*i.bc:(i.rgba?"rgba(":"rgb(")+(i.s+t*i.c>>0)+", "+(i.gs+t*i.gc>>0)+", "+(i.bs+t*i.bc>>0)+(i.rgba?", "+(i.as+t*i.ac):"")+")",i.f?this._target[i.p](e):this._target[i.p]=e,i=i._next}})}),_gsScope._gsDefine&&_gsScope._gsQueue.pop()();



/*!
 * VERSION: 0.5.1
 * DATE: 2014-07-17
 * UPDATES AND DOCS AT: http://www.greensock.com
 *
 * @license Copyright (c) 2008-2015, GreenSock. All rights reserved.
 * This work is subject to the terms at http://greensock.com/standard-license or for
 * Club GreenSock members, the software agreement that was issued with your membership.
 * 
 * @author: Jack Doyle, jack@greensock.com
 */
var _gsScope="undefined"!=typeof module&&module.exports&&"undefined"!=typeof global?global:this||window;(_gsScope._gsQueue||(_gsScope._gsQueue=[])).push(function(){"use strict";var t=function(e){var i=e.nodeType,r="";if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)r+=t(e)}else if(3===i||4===i)return e.nodeValue;return r},e=_gsScope._gsDefine.plugin({propName:"text",API:2,version:"0.5.1",init:function(e,i,r){var s,n;if(!("innerHTML"in e))return!1;if(this._target=e,"object"!=typeof i&&(i={value:i}),void 0===i.value)return this._text=this._original=[""],!0;for(this._delimiter=i.delimiter||"",this._original=t(e).replace(/\s+/g," ").split(this._delimiter),this._text=i.value.replace(/\s+/g," ").split(this._delimiter),this._runBackwards=r.vars.runBackwards===!0,this._runBackwards&&(s=this._original,this._original=this._text,this._text=s),"string"==typeof i.newClass&&(this._newClass=i.newClass,this._hasClass=!0),"string"==typeof i.oldClass&&(this._oldClass=i.oldClass,this._hasClass=!0),s=this._original.length-this._text.length,n=0>s?this._original:this._text,this._fillChar=i.fillChar||(i.padSpace?"&nbsp;":""),0>s&&(s=-s);--s>-1;)n.push(this._fillChar);return!0},set:function(t){t>1?t=1:0>t&&(t=0),this._runBackwards&&(t=1-t);var e,i,r,s=this._text.length,n=0|t*s+.5;this._hasClass?(e=this._newClass&&0!==n,i=this._oldClass&&n!==s,r=(e?"<span class='"+this._newClass+"'>":"")+this._text.slice(0,n).join(this._delimiter)+(e?"</span>":"")+(i?"<span class='"+this._oldClass+"'>":"")+this._delimiter+this._original.slice(n).join(this._delimiter)+(i?"</span>":"")):r=this._text.slice(0,n).join(this._delimiter)+this._delimiter+this._original.slice(n).join(this._delimiter),this._target.innerHTML="&nbsp;"===this._fillChar&&-1!==r.indexOf("  ")?r.split("  ").join("&nbsp;&nbsp;"):r}}),i=e.prototype;i._newClass=i._oldClass=i._delimiter=""}),_gsScope._gsDefine&&_gsScope._gsQueue.pop()();



/*!
 * VERSION: 0.2.1
 * DATE: 2013-04-01
 * JavaScript
 * UPDATES AND DOCS AT: http://www.greensock.com
 *
 * @license Copyright (c) 2008-2013, GreenSock. All rights reserved.
 * ScrambleTextPlugin is a Club GreenSock membership benefit; You must have a valid membership to use
 * this code without violating the terms of use. Visit http://www.greensock.com/club/ to sign up or get more details.
 * This work is subject to the software agreement that was issued with your membership.
 *
 * @author: Jack Doyle, jack@greensock.com
 **/
(window._gsQueue||(window._gsQueue=[])).push(function(){"use strict";var a=function(b){var c=b.nodeType,d="";if(1===c|| 9===c|| 11===c){if("string"==typeof b.textContent)return b.textContent;for(b=b.firstChild;b;b=b.nextSibling)d+=a(b)}else if(3===c|| 4===c)return b.nodeValue;return d},b=function(a,b){for(var c=b.length,d="";--a>-1;)d+=b[0 | Math.random()* c];return d},c=function(a){this.chars=a.split(""),this.sets=[],this.length=50;var c;for(c=0;20>c;c++)this.sets[c]=b(80,this.chars);this.grow=function(a){for(c=0;20>c;c++)this.sets[c]+=b(a-this.length,this.chars);this.length=a}},d="ABCDEFGHIJKLMNOPQRSTUVWXYZ",e=d.toLowerCase(),f={upperCase:new c(d),lowerCase:new c(e),upperAndLowerCase:new c(d+e)},g=window._gsDefine.plugin({propName:"scrambleText",API:2,overwriteProps:["scrambleText","text"],init:function(b,d,e){if(!("innerHTML" in b))return!1;this._target=b,"object" !=typeof d &&(d={text:d});var l,m,n,o;return this._delimiter=l=d.delimiter|| "",this._original=a(b).replace(/\s+/g," ").split("&nbsp;").join("").split(l),this._text=(d.text|| d.value|| "").replace(/\s+/g," ").split(l),this._hasClass=!1,"string"==typeof d.newClass &&(this._newClass=d.newClass,this._hasClass=!0),"string"==typeof d.oldClass &&(this._oldClass=d.oldClass,this._hasClass=!0),m=this._text.length-this._original.length,this._length=this._original.join(l).length,this._lengthDif=this._text.join(l).length-this._length,this._fillChar=d.fillChar|| d.chars&&-1 !==d.chars.indexOf(" ")? "&nbsp;" :"",this._charSet=o=f[d.chars|| "upperCase"]|| new c(d.chars),this._speed=.016 /(d.speed|| 1),this._prevScrambleTime=0,this._setIndex=0 | 20 * Math.random(),n=this._length+Math.max(this._lengthDif,0),n>o.length&&o.grow(n),this._chars=o.sets[this._setIndex],this._revealDelay=d.revealDelay|| 0,this._tweenLength=d.tweenLength !==!1,this._tween=e},set:function(a){var f,g,h,i,j,k,b=this._text.length,c=this._delimiter,d=this._tween._time,e=d-this._prevScrambleTime;this._revealDelay &&(this._tween.vars.runBackwards &&(d=this._tween._duration-d),a=0===d ? 0 :this._revealDelay>d ? 1e-6 :d===this._tween._duration ? 1 :this._tween._ease.getRatio((d-this._revealDelay)/(this._tween._duration-this._revealDelay))),0>a ? a=0 :a>1 &&(a=1),f=0 | a * b+.5,g=this._text.slice(0,f).join(c),h=this._original.slice(f).join(c),a &&((e>this._speed|| -this._speed>e)&&(this._setIndex=(this._setIndex+(0 | 19 * Math.random()))% 20,this._chars=this._charSet.sets[this._setIndex],this._prevScrambleTime+=e),h=this._chars.substr(g.length,0 | this._length+(this._tweenLength ? 1 -(a=1-a)* a * a * a :1)* this._lengthDif-g.length+.5)),this._hasClass ?(i=this._newClass&&0 !==f,j=this._oldClass&&f !==b,k=(i ? "<span class='"+this._newClass+"'>" :"")+g+(i ? "</span>" :"")+(j ? "<span class='"+this._oldClass+"'>" :"")+c+h+(j ? "</span>" :"")):k=g+c+h,this._target.innerHTML="&nbsp;"===this._fillChar&&-1 !==k.indexOf("  ")? k.split("  ").join("&nbsp;&nbsp;"):k}}),h=g.prototype;h._newClass=h._oldClass="";for(h in f)f[h.toLowerCase()]=f[h],f[h.toUpperCase()]=f[h]}),window._gsDefine&&window._gsQueue.pop()();


/*!
 * VERSION: beta 0.3.3
 * DATE: 2015-03-24
 * UPDATES AND DOCS AT: http://greensock.com
 *
 * This is a special version that is only to be used on certain sites like codepen.io. It will redirect to a page on GreenSock.com if you try using it on a different domain. Please sign up for Club GreenSock to get the fully-functional version at http://greensock.com/club/
 *
 * @license Copyright (c) 2008-2015, GreenSock. All rights reserved.
 * SplitText is a Club GreenSock membership benefit; You must have a valid membership to use
 * this code without violating the terms of use. Visit http://greensock.com/club/ to sign up or get more details.
 * For licensing details, see http://greensock.com/licensing/
 *
 * @author: Jack Doyle, jack@greensock.com
 */
var _gsScope="undefined"!=typeof module&&module.exports&&"undefined"!=typeof global?global:this||window;!function(a){"use strict";var b=a.GreenSockGlobals||a,c=function(a){var e,c=a.split("."),d=b;for(e=0;e<c.length;e++)d[c[e]]=d=d[c[e]]||{};return d},d=c("com.greensock.utils"),e=function(a){var b=a.nodeType,c="";if(1===b||9===b||11===b){if("string"==typeof a.textContent)return a.textContent;for(a=a.firstChild;a;a=a.nextSibling)c+=e(a)}else if(3===b||4===b)return a.nodeValue;return c},f=document,g=f.defaultView?f.defaultView.getComputedStyle:function(){},h=/([A-Z])/g,i=function(a,b,c,d){var e;return(c=c||g(a,null))?(a=c.getPropertyValue(b.replace(h,"-$1").toLowerCase()),e=a||c.length?a:c[b]):a.currentStyle&&(c=a.currentStyle,e=c[b]),d?e:parseInt(e,10)||0},j=function(a){return a.length&&a[0]&&(a[0].nodeType&&a[0].style&&!a.nodeType||a[0].length&&a[0][0])?!0:!1},k=function(a){var d,e,f,b=[],c=a.length;for(d=0;c>d;d++)if(e=a[d],j(e))for(f=e.length,f=0;f<e.length;f++)b.push(e[f]);else b.push(e);return b},l=")eefec303079ad17405c",m=/(?:<br>|<br\/>|<br \/>)/gi,n=f.all&&!f.addEventListener,o="<div style='position:relative;display:inline-block;"+(n?"*display:inline;*zoom:1;'":"'"),p=function(a){a=a||"";var b=-1!==a.indexOf("++"),c=1;return b&&(a=a.split("++").join("")),function(){return o+(a?" class='"+a+(b?c++:"")+"'>":">")}},q="",r="SplitText",s=String.fromCharCode(103,114,101,101,110,115,111,99,107,46,99,111,109),t=String.fromCharCode(47,114,101,113,117,105,114,101,115,45,109,101,109,98,101,114,115,104,105,112,47),v=d.SplitText=b.SplitText=function(b,c){if("string"==typeof b&&(b=v.selector(b)),!b)throw"cannot split a null element.";return(this.elements=j(b)?k(b):[b],this.chars=[],this.words=[],this.lines=[],this._originals=[],this.vars=c||{},this.split(c),void 0)},w=function(a,b,c){var d=a.nodeType;if(1===d||9===d||11===d)for(a=a.firstChild;a;a=a.nextSibling)w(a,b,c);else(3===d||4===d)&&(a.nodeValue=a.nodeValue.split(b).join(c))},x=function(a,b){for(var c=b.length;--c>-1;)a.push(b[c])},y=function(a,b,c,d,h){m.test(a.innerHTML)&&(a.innerHTML=a.innerHTML.replace(m,l));var P,Q,R,S,T,U,V,W,X,Y,Z,$,_,ab,j=e(a),k=b.type||b.split||"chars,words,lines",n=-1!==k.indexOf("lines")?[]:null,o=-1!==k.indexOf("words"),q=-1!==k.indexOf("chars"),r="absolute"===b.position||b.absolute===!0,s=r?"&#173; ":" ",t=-999,u=g(a),v=i(a,"paddingLeft",u),y=i(a,"borderBottomWidth",u)+i(a,"borderTopWidth",u),z=i(a,"borderLeftWidth",u)+i(a,"borderRightWidth",u),A=i(a,"paddingTop",u)+i(a,"paddingBottom",u),B=i(a,"paddingLeft",u)+i(a,"paddingRight",u),C=i(a,"textAlign",u,!0),D=a.clientHeight,E=a.clientWidth,F="</div>",G=p(b.wordsClass),H=p(b.charsClass),I=-1!==(b.linesClass||"").indexOf("++"),J=b.linesClass,K=-1!==j.indexOf("<"),L=!0,M=[],N=[],O=[];for(I&&(J=J.split("++").join("")),K&&(j=j.split("<").join("{{LT}}")),P=j.length,S=G(),T=0;P>T;T++)if(V=j.charAt(T),")"===V&&j.substr(T,20)===l)S+=(L?F:"")+"<BR/>",L=!1,T!==P-20&&j.substr(T+20,20)!==l&&(S+=" "+G(),L=!0),T+=19;else if(" "===V&&" "!==j.charAt(T-1)&&T!==P-1&&j.substr(T-20,20)!==l){for(S+=L?F:"",L=!1;" "===j.charAt(T+1);)S+=s,T++;(")"!==j.charAt(T+1)||j.substr(T+1,20)!==l)&&(S+=s+G(),L=!0)}else S+=q&&" "!==V?H()+V+"</div>":V;for(a.innerHTML=S+(L?F:""),K&&w(a,"{{LT}}","<"),U=a.getElementsByTagName("*"),P=U.length,W=[],T=0;P>T;T++)W[T]=U[T];if(n||r)for(T=0;P>T;T++)X=W[T],R=X.parentNode===a,(R||r||q&&!o)&&(Y=X.offsetTop,n&&R&&Y!==t&&"BR"!==X.nodeName&&(Q=[],n.push(Q),t=Y),r&&(X._x=X.offsetLeft,X._y=Y,X._w=X.offsetWidth,X._h=X.offsetHeight),n&&(o!==R&&q||(Q.push(X),X._x-=v),R&&T&&(W[T-1]._wordEnd=!0),"BR"===X.nodeName&&X.nextSibling&&"BR"===X.nextSibling.nodeName&&n.push([])));for(T=0;P>T;T++)X=W[T],R=X.parentNode===a,"BR"!==X.nodeName?(r&&($=X.style,o||R||(X._x+=X.parentNode._x,X._y+=X.parentNode._y),$.left=X._x+"px",$.top=X._y+"px",$.position="absolute",$.display="block",$.width=X._w+1+"px",$.height=X._h+"px"),o?R&&""!==X.innerHTML?N.push(X):q&&M.push(X):R?(a.removeChild(X),W.splice(T--,1),P--):!R&&q&&(Y=!n&&!r&&X.nextSibling,a.appendChild(X),Y||a.appendChild(f.createTextNode(" ")),M.push(X))):n||r?(a.removeChild(X),W.splice(T--,1),P--):o||a.appendChild(X);if(n){for(r&&(Z=f.createElement("div"),a.appendChild(Z),_=Z.offsetWidth+"px",Y=Z.offsetParent===a?0:a.offsetLeft,a.removeChild(Z)),$=a.style.cssText,a.style.cssText="display:none;";a.firstChild;)a.removeChild(a.firstChild);for(ab=!r||!o&&!q,T=0;T<n.length;T++){for(Q=n[T],Z=f.createElement("div"),Z.style.cssText="display:block;text-align:"+C+";position:"+(r?"absolute;":"relative;"),J&&(Z.className=J+(I?T+1:"")),O.push(Z),P=Q.length,U=0;P>U;U++)"BR"!==Q[U].nodeName&&(X=Q[U],Z.appendChild(X),ab&&(X._wordEnd||o)&&Z.appendChild(f.createTextNode(" ")),r&&(0===U&&(Z.style.top=X._y+"px",Z.style.left=v+Y+"px"),X.style.top="0px",Y&&(X.style.left=X._x-Y+"px")));0===P&&(Z.innerHTML="&nbsp;"),o||q||(Z.innerHTML=e(Z).split(String.fromCharCode(160)).join(" ")),r&&(Z.style.width=_,Z.style.height=X._h+"px"),a.appendChild(Z)}a.style.cssText=$}r&&(D>a.clientHeight&&(a.style.height=D-A+"px",a.clientHeight<D&&(a.style.height=D+y+"px")),E>a.clientWidth&&(a.style.width=E-B+"px",a.clientWidth<E&&(a.style.width=E+z+"px"))),x(c,M),x(d,N),x(h,O)},z=v.prototype;z.split=function(a){this.isSplit&&this.revert(),this.vars=a||this.vars,this._originals.length=this.chars.length=this.words.length=this.lines.length=0;for(var b=this.elements.length;--b>-1;)this._originals[b]=this.elements[b].innerHTML,y(this.elements[b],this.vars,this.chars,this.words,this.lines);return this.chars.reverse(),this.words.reverse(),this.lines.reverse(),this.isSplit=!0,this},z.revert=function(){if(!this._originals)throw"revert() call wasn't scoped properly.";for(var a=this._originals.length;--a>-1;)this.elements[a].innerHTML=this._originals[a];return this.chars=[],this.words=[],this.lines=[],this.isSplit=!1,this},v.selector=a.$||a.jQuery||function(b){var c=a.$||a.jQuery;return c?(v.selector=c,c(b)):"undefined"==typeof document?b:document.querySelectorAll?document.querySelectorAll(b):document.getElementById("#"===b.charAt(0)?b.substr(1):b)},v.version="0.3.3"}(_gsScope),function(a){"use strict";var b=function(){return(_gsScope.GreenSockGlobals||_gsScope)[a]};"function"==typeof define&&define.amd?define(["TweenLite"],b):"undefined"!=typeof module&&module.exports&&(module.exports=b())}("SplitText");




/**
 * Animate.css mightySlider Extension
 * http://mightyslider.com/add-on/animate-css/
 * 
 * @version:  1.0.0
 * @released: February 4, 2016
 * 
 * @author:   Hemn Chawroka
 *            http://iprodev.com/
 * 
 */
(function ($, window, undefined) {
	'use strict';

	// Create a new object, that prototypally inherits from the Error constructor
	function MyError(message, error) {
		this.name = 'mightySlider Animate.css';
		this.message = message || 'Default Message';
		this.stack = error.stack;
		this.lineNumber = error.lineNumber;
		this.columnNumber = error.columnNumber;
		this.fileName = error.fileName;
	}
	MyError.prototype = Object.create(Error.prototype);
	MyError.prototype.constructor = MyError;

	// Return false and warn if mightySlider is not included
	if (typeof mightySlider === 'undefined') {
		throw new MyError('Animate.css needs mightySlider! Please include mightySlider script into your page.', new Error());
	}

	// Begin the plugin
	mightySlider.animateCSS = function(instance, options) {
		// Prevent run & warn if there is no valid mightySlider instance API
		if (typeof instance !== 'object' || !mightySlider.isPremium) {
			throw new MyError('There is no valid mightySlider instance API!', new Error());
		}

		// Default settings. Play carefully.
		options = jQuery.extend({}, mightySlider.animateCSS.defaults, options);

		options.animateSpeed = instance.options.speed;

		// Global slider's DOM elements and variables
		var $parent = $(instance.frame).parent(),
			lastIndex = 0,
			changeIndex = 0,
			mSOptions = {
				speed: 0,
				navigation: {
					navigationType:  'forceCentered',
					smart:           true,
					activateMiddle:  true,
					slideSize:       '100%'
				}
			};

		$parent.addClass('mightySliderAnimate');

		instance.on('move', function() {
				changeIndex++;
		});
		instance.on('moveEnd', function(name) {
			var index = this.relative.activeSlide;
			if (this.slides.length > 1 && lastIndex !== index && changeIndex === 1 && (options.animateOut || options.animateIn)) {
				swapAnimation.call(instance, options, lastIndex);
			}

			lastIndex = index;
			changeIndex = 0;
		});

		lastIndex = instance.relative.activeSlide;

		// Set the required options & reload the mightySlider
		instance.set(mSOptions);
	};

	function clearAnimation(e, animationClass, options) {
		$(e.target).css( { '-webkit-animation-duration': '', 'animation-duration': '', 'left': e.target.left, 'top': e.target.top } )
			.removeClass('ms-animated ms-animated-out ms-animated-in ' + options.animateEasing)
			.removeClass(animationClass);

		this.isLocked = 0;
	};

	function swapAnimation(options, lastIndex) {
		var self = this,
			previous = self.slides[lastIndex <= 0 ? 0 : lastIndex],
			next = self.slides[self.relative.activeSlide],
			$prevSlide = $(previous.element),
			$nextSlide = $(next.element),
			incoming = next.options.animateIn || options.animateIn,
			outgoing = previous.options.animateOut || options.animateOut,
			isHorizontal = self.options.navigation.horizontal,
			css = {}, position;

		self.isLocked = 1;

		if ($.isArray(outgoing)) {
			outgoing = outgoing[Math.floor(Math.random() * outgoing.length)];
		}
		if ($.isArray(incoming)) {
			incoming = incoming[Math.floor(Math.random() * incoming.length)];
		}

		if (outgoing) {
			outgoing = 'wgextra' + outgoing.charAt(0).toUpperCase() + outgoing.slice(1);

			if (incoming) {
				$prevSlide.removeClass(incoming + ' ms-animated-in');
			}
			position = next.start - previous.start;
			$prevSlide[0].top = $prevSlide[0].style.top;
			$prevSlide[0].left = $prevSlide[0].style.left;
			css[isHorizontal ? 'left' : 'top'] = (position + parseFloat($prevSlide[0].style[isHorizontal ? 'left' : 'top'] || 0)) + 'px';
			$prevSlide
				.css( { '-webkit-animation-duration': '', 'animation-duration': '', 'left': '', 'top': '' } )
				.css( css )
				.removeClass('ms-animated ms-animated-out ' + options.animateEasing + ' ' + outgoing)
				.addClass('ms-animated ms-animated-out ' + options.animateEasing)
				.addClass(outgoing)
				.css( { '-webkit-animation-duration': options.animateSpeed + 'ms', 'animation-duration': options.animateSpeed + 'ms' } )
				.one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(e){
					clearAnimation.call(self, e, outgoing, options);
				});
		}

		if (incoming) {
			incoming = 'wgextra' + incoming.charAt(0).toUpperCase() + incoming.slice(1);

			if (outgoing) {
				$nextSlide.removeClass(outgoing + ' ms-animated-out');
			}
			$nextSlide[0].top = $nextSlide[0].style.top;
			$nextSlide[0].left = $nextSlide[0].style.left;
			$nextSlide
				.css( { '-webkit-animation-duration': '', 'animation-duration': '' } )
				.removeClass('ms-animated ms-animated-in ' + options.animateEasing + ' ' + incoming)
				.addClass('ms-animated ms-animated-in ' + options.animateEasing)
				.addClass(incoming)
				.css( { '-webkit-animation-duration': options.animateSpeed + 'ms', 'animation-duration': options.animateSpeed + 'ms' } )
				.one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(e){
					clearAnimation.call(self, e, incoming, options);
				});
		}
	}

	// Default options
	mightySlider.animateCSS.defaults = {
		animateEasing: 'ease',
		animateIn: '',
		animateOut: 'fadeOut'
	};

})(jQuery, this);




/**
 * mightySlider "Ken Burns" extension
 * https://www.mightyslider.com/
 * 
 * @version:  1.0.0
 * 
 * @author:   Hemn Chawroka
 *            https://www.iprodev.com/
 * 
 */
;(function ($, w, undefined) {
	'use strict';

	// Create a new object, that prototypally inherits from the Error constructor
	function MyError(message, error) {
		this.name = 'mightySlider Ken Burns';
		this.message = message || 'Default Message';
		this.stack = error.stack;
		this.lineNumber = error.lineNumber;
		this.columnNumber = error.columnNumber;
		this.fileName = error.fileName;
	}
	MyError.prototype = Object.create(Error.prototype);
	MyError.prototype.constructor = MyError;

	// Return false and warn if mightySlider is not included
	if (typeof mightySlider === 'undefined') {
		throw new MyError('Ken Burns needs mightySlider! Please include mightySlider script into your page.', new Error());
	}

	// Shorthads
	var namespace = 'kenBurns',
		mSOptions = {
			navigation: {
				smart:           true,
				activateMiddle:  true
			}
		};

	mightySlider[namespace] = function(mSAPI, options) {
		// Prevent run & warn if there is no valid mightySlider instance API
		if (typeof mSAPI !== 'object' || !mightySlider.isPremium) {
			throw new MyError('There is no valid mightySlider instance API!', new Error());
		}

		// Default settings. Play carefully.
		options = jQuery.extend({}, mightySlider[namespace].defaults, options);

		var self = this;

		// Set the required options & reload the mightySlider
		mSAPI.set(mSOptions);

		// References
		var $parent = $(mSAPI.frame).parent(),
			transitions = ['In', 'Out'],
			origins = ['TopLeft', 'TopCenter', 'TopRight', 'MiddleLeft', 'MiddleCenter', 'MiddleRight', 'BottomLeft', 'BottomCenter', 'BottomRight'],
			allPossibilities = namespace + transitions.concat(origins).join(' ' + namespace),
			transitionsLength, originsLength, index, slide,$slideElement, $cover,
			slideOptions, kenburnsClasses;

		$parent.addClass('mightySliderKenBurns');

		// Add active event
		var activeFunction = function(eventName) {
			var self = this;

			index = self.relative.activeSlide;
			slide = self.slides[index];
			slideOptions = slide.options;

			transitions = options.transitions;
			origins = options.origins;
			transitionsLength = transitions.length - 1;
			originsLength = origins.length - 1;

			if (options.allSlides || slideOptions.kenBurns) {
				if (typeof slideOptions.kenBurns != 'undefined' && !slideOptions.kenBurns)
					return;

				$slideElement = $(slide.element);
				$cover = $slideElement.find('.wgextra-thumb img');

				if (!$cover[0])
					return;

				// Check for when slide has its own transition option
				if (typeof slideOptions.kenBurns === 'object' && slideOptions.kenBurns.transitions) {
					transitions = slideOptions.kenBurns.transitions,
					transitionsLength = transitions.length - 1;
				}
				// Check for when slide has its own origin option
				if (typeof slideOptions.kenBurns === 'object' && slideOptions.kenBurns.origins) {
					origins = slideOptions.kenBurns.origins,
					originsLength = origins.length - 1;
				}

				// Reset Ken Burns classes array
				kenburnsClasses = [];
				// Push Ken Burns Transition and Origin classes
				kenburnsClasses.push(namespace + transitions[random(0, transitionsLength)]);
				kenburnsClasses.push(namespace + origins[random(0, originsLength)]);

				// Push reverse class
				if ((typeof slideOptions.kenBurns === 'object' && slideOptions.kenBurns.reverse) || options.reverse)
					kenburnsClasses.push(namespace + 'Reverse');

				// Remove all Ken Burns generated classes from slide element
				$slideElement.removeClass(allPossibilities);

				setTimeout(function() {
					// Add Ken Burns classes to slide element
					$slideElement.addClass(kenburnsClasses.join(' '));
				});

				// Reset Ken Burns duration
				$cover
				.css( { '-webkit-animation-duration': '', 'animation-duration': '' } )
				.css( { '-webkit-animation-duration': options.duration + 'ms', 'animation-duration': options.duration + 'ms' } );
			}
		};

		// Attach :active and :initialize events
		mSAPI.on('active initialize', activeFunction);

		// Attach :destroy event once
		mSAPI.one('destroy', function(){
			// Deattach :active and :initialize events
			mSAPI.off('active initialize', activeFunction);
		});

	};

	function random(min, max) {
		return Math.floor(Math.random() * (max - min + 1) + min);
	}

	// Default options
	mightySlider[namespace].defaults = {
		allSlides  : true,          // Enable Ken Burns for all available slides.
		duration   : 10000,         // Ken Burns transition effect duration.
		transitions: ['In', 'Out'], // Ken Burns transitions mode. Possible values are: ['In'], ['Out'] and ['In', 'Out']
		origins    : ['TopLeft',    // Ken Burns transformations origins.
					  'TopCenter',
					  'TopRight',
					  'MiddleLeft',
					  'MiddleCenter',
					  'MiddleRight',
					  'BottomLeft',
					  'BottomCenter',
					  'BottomRight'
					 ],
		reverse    : false           // Reverse Ken Burns transition mode for when the transition has ended.
	};
}(jQuery, this));




/**
 * mightySlider "Time Loader" addon
 * http://mightyslider.com/
 * 
 * @version:  1.0.0
 * @released: February 10, 2016
 * 
 * @author:   Hemn Chawroka
 *            http://iprodev.com/
 * 
 */
;(function ($, w, undefined) {
	'use strict';

	// Create a new object, that prototypally inherits from the Error constructor
	function MyError(message, error) {
		this.name = 'Time Loader';
		this.message = message || 'Default Message';
		this.stack = error.stack;
		this.lineNumber = error.lineNumber;
		this.columnNumber = error.columnNumber;
		this.fileName = error.fileName;
	}
	MyError.prototype = Object.create(Error.prototype);
	MyError.prototype.constructor = MyError;

	// Return false and warn if mightySlider is not included
	if (typeof mightySlider === 'undefined') {
		throw new MyError('Time loader needs mightySlider! Please include mightySlider script into your page.', new Error());
	}

	// Shorthads
	var abs = Math.abs;
	var PI = Math.PI;
	var namespace = 'timeLoader';

	/**
	 * Render the donut on a canvas object
	 */
	var donutRenderer = function(ctx, radius, color, lineWidth, trackSpace, percent, isBg) {
		percent = Math.min(Math.max(-1, percent || 0), 1);
		var isNegative = percent <= 0 ? true : false;

		ctx.beginPath();
		ctx.arc(0, 0, radius, 0, PI * 2 * percent, isNegative);

		ctx.strokeStyle = color;
		if (!isBg) {
			ctx.lineWidth = lineWidth - (trackSpace * 2);
		} else {
			ctx.lineWidth = lineWidth;
		}

		ctx.stroke();
	};

	/**
	 * Render the pie on a canvas object
	 */
	var pieRenderer = function(ctx, radius, color, lineWidth, trackSpace, percent, isBg) {
		percent = Math.min(Math.max(-1, percent || 0), 1);
		var isNegative = percent <= 0 ? true : false;

		if (!isBg) {
			radius = radius - trackSpace;
		}

		ctx.beginPath();
		ctx.moveTo(0, 0);
		ctx.arc(0, 0, radius, 0, PI * 2 * percent, isNegative);

		ctx.fillStyle = color;
		ctx.fill();
	};

	var canvasRenderer = function(el, options) {
		var self = this;
		var cachedBackground;
		var canvas = el;

		if (typeof(G_vmlCanvasManager) !== 'undefined') {
			G_vmlCanvasManager.initElement(canvas);
		}

		var ctx = canvas.getContext('2d');

		// Expose
		self.ctx = ctx;
		self.canvas = canvas;

		canvas.width = canvas.height = options.size;

		// canvas on retina devices
		var scaleBy = window.devicePixelRatio;
		canvas.style.width = canvas.style.height = [options.size, 'px'].join('');
		canvas.width = canvas.height = options.size * scaleBy;
		ctx.scale(scaleBy, scaleBy);

		// move 0,0 coordinates to the center
		ctx.translate(options.size / 2, options.size / 2);

		// rotate canvas -90deg
		ctx.rotate((-1 / 2 + options.rotate / 180) * PI);

		var radius = (options.size - options.lineWidth) / 2;
		if (options.scaleColor && options.scaleLength) {
			radius = radius - options.scaleLength - 2; // 2 is the distance between scale and bar
		}
		radius = abs(radius);

		if (options.mode.toLowerCase() === 'donut')
			var drawCircle = donutRenderer;
		else
			var drawCircle = pieRenderer;

		/**
		 * Draw the scale of the chart
		 */
		var drawScale = function() {
			var offset;
			var length;

			ctx.lineWidth = 1;
			ctx.fillStyle = options.scaleColor;

			ctx.save();
			for (var i = 24; i > 0; --i) {
				if (i % 6 === 0) {
					length = options.scaleLength;
					offset = 0;
				} else {
					length = options.scaleLength * 0.6;
					offset = options.scaleLength - length;
				}
				ctx.fillRect(-options.size / 2 + offset, 0, length, 1);
				ctx.rotate(PI / 12);
			}
			ctx.restore();
		};

		/**
		 * Draw the background of the plugin including the scale and the track
		 */
		var drawBackground = function() {
			if (options.scaleColor) drawScale();
			if (options.trackColor) drawCircle(ctx, radius, options.trackColor, options.lineWidth, options.trackSpace, 1, 1);
		};

		/**
		 * Clear the complete canvas
		 */
		self.clear = function() {
			ctx.clearRect(options.size / -2, options.size / -2, options.size, options.size);
		};

		/**
		 * Draw the complete loader
		 * @param {number} percent Percent shown by the loader between -100 and 100
		 */
		self.draw = function(percent) {
			// do we need to render a background
			if (!!options.scaleColor || !!options.trackColor) {
				// getImageData and putImageData are supported
				if (ctx.getImageData && ctx.putImageData) {
					if (!cachedBackground) {
						drawBackground();
						cachedBackground = ctx.getImageData(0, 0, options.size * scaleBy, options.size * scaleBy);
					} else {
						ctx.putImageData(cachedBackground, 0, 0);
					}
				} else {
					self.clear();
					drawBackground();
				}
			} else {
				self.clear();
			}

			ctx.lineCap = options.lineCap;

			// if barcolor is a function execute it and pass the percent as a value
			var color;
			if (typeof(options.barColor) === 'function') {
				color = options.barColor.call(self, percent);
			} else {
				color = options.barColor;
			}

			// draw bar
			drawCircle(ctx, radius, color, options.lineWidth, options.trackSpace, percent);
		};
	};

	mightySlider[namespace] = function(mSAPI, opts) {
		// Prevent run & warn if there is no valid mightySlider instance API
		if (typeof mSAPI !== 'object' || !mightySlider.isPremium) {
			throw new MyError('There is no valid mightySlider instance API!', new Error());
		}

		var renderer;

		// References
		var frame = mSAPI.frame;

		// merge user options into default options
		var options = $.extend({}, mightySlider[namespace].defaults, opts);
		var currentValue = options.reverse ? 1 : 0;

		var elements = [],
			firstChild = frame.firstChild,
			el, txtEl;

		// Creating canvas element
		el = document.createElement('canvas');
		// Add class to the element
		el.className = 'timeLoader';
		// Prepend the canvas element to the FRAME
		frame.insertBefore( el, firstChild );

		elements.push(el);

		if (options.txtColor) {
			txtEl = document.createElement('div');
			txtEl.className = 'timeLoaderTxt';
			// Prepend the canvas element to the FRAME
			frame.insertBefore( txtEl, firstChild );

			txtEl.style.pointerEvents = 'none';
			txtEl.style.lineHeight = options.size + 'px';
			txtEl.style.textAlign = 'center';
			txtEl.style.fontSize = options.fontSize;
			txtEl.style.fontWeight = options.fontWeight;
			txtEl.style.color = options.txtColor;
			txtEl.style.width = txtEl.style.height = options.size + 'px';

			elements.push(txtEl);
		}

		var offset = options.offset;
		var position = options.position.toLowerCase();
		var transform = '';
		var top = 'auto';
		var bottom = 'auto';
		var left = 'auto';
		var right = 'auto';

		if (position.indexOf('top') !== -1) {
			top = offset + 'px';
		}
		else if (position.indexOf('middle') !== -1) {
			transform += 'translateY(-50%) ';
			top = '50%';
		}
		else if (position.indexOf('bottom') !== -1) {
			bottom = offset + 'px';
		}
		if (position.indexOf('left') !== -1) {
			left = offset + 'px';
		}
		else if (position.indexOf('center') !== -1) {
			transform += 'translateX(-50%) ';
			left = '50%';
		}
		else if (position.indexOf('right') !== -1) {
			right = offset + 'px';
		}

		for (var i = 0, len = elements.length, element; i < len; i++) {
			element = elements[i];

			element.style.position = 'absolute';
			element.style.zIndex = '1000';
			element.style.cursor = 'pointer';
			element.style.top = top;
			element.style.bottom = bottom;
			element.style.left = left;
			element.style.right = right;
			element.style[(element.style.WebkitTransform !== undefined) ? 'WebkitTransform' : 'transform'] = transform;
		}

		el.addEventListener('click', function(){
			mSAPI.toggleCycling();
		}, false);

		/**
		 * Update the value of the chart
		 * @param  {number} newValue Number between 0 and 100
		 * @return {object}          Instance of the plugin for method chaining
		 */
		var update = function(newValue) {
			newValue = parseFloat(newValue);
			if(options.reverse) {
				newValue = 1 - newValue;
			}
			renderer.draw(newValue);

			if (txtEl) {
				var rounded = Math.round(newValue * 100),
					txt;

				if (typeof(options.txtTemp) === 'function') {
					txt = options.txtTemp.call(mSAPI, rounded);
				} else {
					txt = options.txtTemp.replace(/{d}/g, (rounded < 10 ? '0' : '') + rounded);
				}

				txtEl.textContent = txt;
			}

			currentValue = newValue;
		};

		/**
		 * Initialize the plugin by creating the options object and initialize rendering
		 */
		var init = function() {
			// create renderer
			renderer = new canvasRenderer(el, options);

			// initial update
			update(currentValue);
		};

		init();

		function progressHandler(eventName, progressed) {
			update(progressed);
		}

		// Register 'progress' event in mighySlider
		mSAPI.on('progress', progressHandler);

		function activeHandler(eventName) {
			if (mSAPI.isPaused) {
				update(0);
			}
		}

		// Register 'active' event in mighySlider
		mSAPI.on('active', activeHandler);

		mSAPI.one('destroy', function() {
			// Register events from mighySlider
			mSAPI.off('progress', progressHandler);
			mSAPI.off('active', activeHandler);

			for (var i = 0, len = elements.length, element; i < len; i++) {
				frame.removeChild(elements[i]);
			}

			el = null;
			txtEl = null;
			el = null;
		});
	};

	var head = document.head || document.getElementsByTagName('head')[0] || document.documentElement,
		css = '.mSMedia canvas.timeLoader { display: none !important; }';

	var styleElement = document.createElement('style');
	styleElement.type = 'text/css';
	if (styleElement.styleSheet){
		styleElement.styleSheet.cssText = css;
	} else {
		styleElement.appendChild(document.createTextNode(css));
	}

	head.appendChild(styleElement);

	// Default options
	mightySlider[namespace].defaults = {
		mode:        'pie',       // Time Loader rendering mode. Possible values are: 'pie' and 'donut'
		barColor:    '#ef1e25',   // The color of the curcular bar. You can either pass a valid css color string, or a function that takes the current percentage as a value and returns a valid css color string.
		trackColor:  '#f9f9f9',   // The color of the track, or false to disable rendering.
		scaleColor:  '#dfe0e0',   // The color of the scale lines, false to disable rendering.
		scaleLength: 5,           // Length of the scale lines (reduces the radius of the loader).
		txtColor:    false,       // The color of the counter text, false to disable rendering.
		lineCap:     'round',     // Defines how the ending of the bar line looks like. Possible values are: 'butt', 'round' and 'square'.
		lineWidth:   3,           // Width of the loader line in px.
		trackSpace:  0,           // The space of the track.
		size:        50,          // Size of the loader in px. It will always be a square.
		rotate:      0,           // Rotation of the complete loader in degrees.
		position:    'top right', // Position of the loader.
		offset:      10,          // Offset of the loader.
		txtTemp:     '{d}%',      // Loader counter text template.
		fontSize:    '13px',      // Loader counter font size.
		fontWeight:  'normal',    // Loader counter font weight.
		reverse:     false        // Reverse the time loader rendering.
	};
}(jQuery, this));




// Tilt
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

(function (factory) {
	if (typeof define === 'function' && define.amd) {
		// AMD. Register as an anonymous module.
		define(['jquery'], factory);
	} else if ((typeof module === 'undefined' ? 'undefined' : _typeof(module)) === 'object' && module.exports) {
		// Node/CommonJS
		module.exports = function (root, jQuery) {
			if (jQuery === undefined) {
				// require('jQuery') returns a factory that requires window to
				// build a jQuery instance, we normalize how we use modules
				// that require this pattern but the window provided is a noop
				// if it's defined (how jquery works)
				if (typeof window !== 'undefined') {
					jQuery = require('jquery');
				} else {
					jQuery = require('jquery')(root);
				}
			}
			factory(jQuery);
			return jQuery;
		};
	} else {
		// Browser globals
		factory(jQuery);
	}
})(function ($) {
	$.fn.WGExtraTilt = function (options) {

		/**
		 * RequestAnimationFrame
		 */
		var requestTick = function requestTick() {
			if (this.ticking) return;
			requestAnimationFrame(updateTransforms.bind(this));
			this.ticking = true;
		};

		/**
		 * Bind mouse movement evens on instance
		 */
		var bindEvents = function bindEvents() {
			var _this = this;

			$(_this).on('mousemove', mouseMove);
			$(_this).on('mouseenter', mouseEnter);
			if (_this.settings.reset) $(_this).on('mouseleave', mouseLeave);
			if (_this.settings.glare) $(window).on('resize', updateGlareSize.bind(_this));
		};

		/**
		 * Set transition only on mouse leave and mouse enter so it doesn't influence mouse move transforms
		 */
		var setTransition = function setTransition() {
			var _this2 = this;

			if (_this2.timeout !== undefined)
				clearTimeout(_this2.timeout);
			$(_this2).css({ 'transition': _this2.settings.speed + 'ms ' + _this2.settings.easing });
			if (_this2.settings.glare)
				_this2.glareElement.css({ 'transition': 'opacity ' + _this2.settings.speed + 'ms ' + _this2.settings.easing });
			_this2.timeout = setTimeout(function () {
				$(_this2).css({ 'transition': '' });
				if (_this2.settings.glare) _this2.glareElement.css({ 'transition': '' });
			}, _this2.settings.speed);
		};

		/**
		 * When user mouse enters tilt element
		 */
		var mouseEnter = function mouseEnter(event) {
			var _this = this;

			_this.ticking = false;
			$(_this).css({ 'will-change': 'transform' });
			setTransition.call(_this);

			// Trigger change event
			$(_this).trigger("tilt.mouseEnter");
		};

		/**
		 * Return the x,y position of the mouse on the tilt element
		 * @returns {{x: *, y: *}}
		 */
		var getMousePositions = function getMousePositions(event) {
			if (typeof event === "undefined") {
				var $this = $(this);
				event = {
					pageX: $this.offset().left + $this.outerWidth() / 2,
					pageY: $this.offset().top + $this.outerHeight() / 2
				};
			}
			return { x: event.pageX, y: event.pageY };
		};

		/**
		 * When user mouse moves over the tilt element
		 */
		var mouseMove = function mouseMove(event) {
			this.mousePositions = getMousePositions(event);
			requestTick.call(this);
		};

		/**
		 * When user mouse leaves tilt element
		 */
		var mouseLeave = function mouseLeave() {
			setTransition.call(this);
			this.reset = true;
			requestTick.call(this);

			// Trigger change event
			$(this).trigger("tilt.mouseLeave");
		};

		/**
		 * Get tilt values
		 *
		 * @returns {{x: tilt value, y: tilt value}}
		 */
		var getValues = function getValues() {
			var self = this;
			var $self = $(self);
			var width = $self.outerWidth();
			var height = $self.outerHeight();
			var left = $self.offset().left;
			var top = $self.offset().top;
			var percentageX = (self.mousePositions.x - left) / width;
			var percentageY = (self.mousePositions.y - top) / height;
			// x or y position inside instance / width of instance = percentage of position inside instance * the max tilt value
			var tiltX = (self.settings.maxTilt / 2 - percentageX * self.settings.maxTilt).toFixed(2);
			var tiltY = (percentageY * self.settings.maxTilt - self.settings.maxTilt / 2).toFixed(2);
			// angle
			var angle = Math.atan2(self.mousePositions.x - (left + width / 2), -(self.mousePositions.y - (top + height / 2))) * (180 / Math.PI);
			// Return x & y tilt values
			return { tiltX: tiltX, tiltY: tiltY, 'percentageX': percentageX * 100, 'percentageY': percentageY * 100, angle: angle };
		};

		/**
		 * Update tilt transforms on mousemove
		 */
		var updateTransforms = function updateTransforms() {
			var self = this;
			var $self = $(this);

			self.transforms = getValues.call(self);

			if (self.reset) {
				self.reset = false;
				$self.css('transform', 'perspective(' + self.settings.perspective + 'px) rotateX(0deg) rotateY(0deg)');

				// Rotate glare if enabled
				if (self.settings.glare) {
					self.glareElement.css('transform', 'rotate(180deg) translate(-50%, -50%)');
					self.glareElement.css('opacity', '0');
				}

				return;
			} else {
				$self.css('transform', 'perspective(' + self.settings.perspective + 'px) rotateX(' + (self.settings.axis === 'x' ? 0 : self.transforms.tiltY) + 'deg) rotateY(' + (self.settings.axis === 'y' ? 0 : self.transforms.tiltX) + 'deg) scale3d(' + self.settings.scale + ',' + self.settings.scale + ',' + self.settings.scale + ')');

				// Rotate glare if enabled
				if (self.settings.glare) {
					self.glareElement.css('transform', 'rotate(' + self.transforms.angle + 'deg) translate(-50%, -50%)');
					self.glareElement.css('opacity', '' + self.transforms.percentageY * self.settings.maxGlare / 100);
				}
			}

			// Trigger change event
			$self.trigger("change", [self.transforms]);

			self.ticking = false;
		};

		/**
		 * Prepare elements
		 */
		var prepareGlare = function prepareGlare() {
			var self = this;
			var $this = $(self);
			var glarePrerender = self.settings.glarePrerender;

			// If option pre-render is enabled we assume all html/css is present for an optimal glare effect.
			if (!glarePrerender) {
				var glareHTML = '<div class="js-tilt-glare"><div class="js-tilt-glare-inner"></div></div>';

				// Create glare element
				self.settings.glareHolder.append(glareHTML);
			}

			// Store glare selector if glare is enabled
			self.glareElementWrapper = $this.find(".js-tilt-glare");
			self.glareElement = $this.find(".js-tilt-glare-inner");

			// Remember? We assume all css is already set, so just return
			if (glarePrerender) return;

			// Abstracted re-usable glare styles
			var stretch = {
				'position': 'absolute',
				'top': '0',
				'left': '0',
				'width': '100%',
				'height': '100%'
			};

			// Style glare wrapper
			self.glareElementWrapper.css(stretch).css({
				'overflow': 'hidden',
				'pointer-events': 'none'
			});

			// Style glare element
			self.glareElement.css({
				'position': 'absolute',
				'top': '50%',
				'left': '50%',
				'background-image': 'linear-gradient(0deg, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%)',
				'width': '' + $this.outerWidth() * 2,
				'height': '' + $this.outerWidth() * 2,
				'transform': 'rotate(180deg) translate(-50%, -50%)',
				'transform-origin': '0% 0%',
				'opacity': '0'
			});
		};

		/**
		 * Update glare on resize
		 */
		var updateGlareSize = function updateGlareSize() {
			this.glareElement.css({
				'width': '' + $(this).outerWidth() * 2,
				'height': '' + $(this).outerWidth() * 2
			});
		};

		/**
		 * Public methods
		 */
		$.fn.WGExtraTilt.destroy = function () {
			$(this).each(function () {
				this.settings.glareHolder.find('.js-tilt-glare').remove();
				$(this).css({ 'will-change': '', 'transform': '' });
				$(this).off('mousemove mouseenter mouseleave');
			});
		};

		$.fn.WGExtraTilt.getValues = function () {
			var results = [];
			$(this).each(function () {
				this.mousePositions = getMousePositions.call(this);
				results.push(getValues.call(this));
			});
			return results;
		};

		$.fn.WGExtraTilt.reset = function () {
			$(this).each(function () {
				var _this3 = this;

				if(_this3.ticking) {
					_this3.mousePositions = getMousePositions.call(_this3);
					_this3.settings = $(_this3).data('settings');

					mouseLeave.call(_this3);
					setTimeout(function () {
						_this3.reset = false;
					}, _this3.settings.transition);
				}
			});
		};

		/**
		 * Loop every instance
		 */
		return this.each(function () {
			var _this4 = this;
			var $this = $(_this4);

			/**
			 * Default settings merged with user settings
			 * Can be set trough data attributes or as parameter.
			 * @type {*}
			 */
			_this4.settings = $.extend({
				maxTilt: $this.is('[data-tilt-max]') ? $this.data('tilt-max') : 20,
				perspective: $this.is('[data-tilt-perspective]') ? $this.data('tilt-perspective') : 300,
				easing: $this.is('[data-tilt-easing]') ? $this.data('tilt-easing') : 'cubic-bezier(.03,.98,.52,.99)',
				scale: $this.is('[data-tilt-scale]') ? $this.data('tilt-scale') : '1',
				speed: $this.is('[data-tilt-speed]') ? $this.data('tilt-speed') : '400',
				transition: $this.is('[data-tilt-transition]') ? $this.data('tilt-transition') : true,
				axis: $this.is('[data-tilt-axis]') ? $this.data('tilt-axis') : null,
				reset: $this.is('[data-tilt-reset]') ? $this.data('tilt-reset') : true,
				glare: $this.is('[data-tilt-glare]') ? $this.data('tilt-glare') : false,
				maxGlare: $this.is('[data-tilt-maxglare]') ? $this.data('tilt-maxglare') : 1,
				glareHolder: $this.is('[data-tilt-glareholder]') ? $this.data('tilt-glareholder') : null
			}, options);

			_this4.init = function () {
				// Store settings
				$this.data('settings', _this4.settings);

				if (_this4.settings.glareHolder)
					_this4.settings.glareHolder = $this.find(_this4.settings.glareHolder);
				else
					_this4.settings.glareHolder = $this;

				// Prepare element
				if (_this4.settings.glare)
					prepareGlare.call(_this4);

				// Bind events
				bindEvents.call(_this4);
			};

			// Init
			_this4.init();
		});
	};

	return true;
});



/**
 * Visible State Change for DOM Elements
 * https://iprodev.github.io/jquery.visibilityState/
 *
 * Copyright (c) 2017 iProDev
 * Licensed under the MIT license.
 */
(function ($) {
	var namespace = 'visibilityState',
		visibleEvent = 'visible',
		hiddenEvent = 'hidden',
		elements = [],
		length = 0,
		l = 0,
		exist, item, isVisibile, timeID;

	/*
	
		Function
	
		Function (  )
	
		Return Type:
		Void
	
		Description:
		Checks elements visibility status and call the events and callbacks.

	*/
	var checkVisibility = function () {
		if (length === 0)
			return;

		l = length;

		while(l--) {
			item = elements[l];
			isVisibile = item.$element.is(':visible');

			if (isVisibile !== item.isVisibile) {
				if (item.event) {
					if (item.event === visibleEvent && isVisibile)
						item.$element.triggerHandler(visibleEvent);
					else if (item.event === hiddenEvent && !isVisibile)
						item.$element.triggerHandler(hiddenEvent);
				}
				else
					item.fn.call(item.$element[0], isVisibile);
			}

			elements[l].isVisibile = isVisibile;
		}
	};

	/*
	
		Function
	
		Function ( $element: jQuery DOM Object, fn: Function, event: String )
	
		Return Type:
		Boolean
	
		Description:
		Add element to visibility elements check list.

	*/
	var addElement = function ($element, fn, event) {
		if (checkElement($element, fn, event) === false) {
			// Push element to visibility elements check list
			elements.push({
				$element: $element,
				fn: fn,
				isVisibile: null,
				event: event
			});

			// Calculate the length
			length = elements.length;

			// Refresh the interval timer
			clearInterval(timeID);
			timeID = setInterval(checkVisibility, 100);

			return true;
		}

		return false;
	};

	/*
	
		Function
	
		Function ( $element: jQuery DOM Object, fn: Function, event: String )
	
		Return Type:
		Boolean
	
		Description:
		Remove element from visibility elements check list.

	*/
	var removeElement = function ($element, fn, event) {
		var index = checkElement($element, fn, event);

		if (index !== false) {
			// Remove element from visibility elements check list
			elements.splice(index, 1);

			// Calculate the length
			length = elements.length;

			return true;
		}

		return index;
	};

	/*
	
		Function
	
		Function ( $element: jQuery DOM Object, fn: Function, event: String )
	
		Return Type:
		Boolean|Integer
	
		Description:
		Check is element exists in visibility elements check list.

	*/
	var checkElement = function ($element, fn, event) {
		exist = false;
		l = length;

		while(l--) {
			item = elements[l];
			if ($element[0] === item.$element[0] && fn === item.fn && event === item.event) {
				exist = l;
				break;
			}
		}

		return exist;
	};

	// Begin the plugin
	$.fn[namespace] = function (fn) {
		return this.each(function () {
			addElement($(this), fn);
		});
	};

	// Begin the visible special event
	$.event.special[visibleEvent] = {
		add: function(handleObj) {
			var elem = this;

			addElement($(this), handleObj.handler, visibleEvent);
		},

		remove: function(handleObj) {
			removeElement($(this), handleObj.handler, visibleEvent);
		}
	};

	// Begin the visible special event
	$.event.special[hiddenEvent] = {
		add: function(handleObj) {
			addElement($(this), handleObj.handler, hiddenEvent);
		},

		remove: function(handleObj) {
			removeElement($(this), handleObj.handler, hiddenEvent);
		}
	};
})(jQuery);




/**
 * http://animejs.com
 * JavaScript animation engine
 * @version v2.0.2
 * @author Julian Garnier
 * @copyright ©2017 Julian Garnier
 * Released under the MIT license
 **/
var $jscomp$this=this;
(function(v,p){"function"===typeof define&&define.amd?define([],p):"object"===typeof module&&module.exports?module.exports=p():v.anime=p()})(this,function(){function v(a){if(!g.col(a))try{return document.querySelectorAll(a)}catch(b){}}function p(a){return a.reduce(function(a,d){return a.concat(g.arr(d)?p(d):d)},[])}function w(a){if(g.arr(a))return a;g.str(a)&&(a=v(a)||a);return a instanceof NodeList||a instanceof HTMLCollection?[].slice.call(a):[a]}function F(a,b){return a.some(function(a){return a===b})}
function A(a){var b={},d;for(d in a)b[d]=a[d];return b}function G(a,b){var d=A(a),c;for(c in a)d[c]=b.hasOwnProperty(c)?b[c]:a[c];return d}function B(a,b){var d=A(a),c;for(c in b)d[c]=g.und(a[c])?b[c]:a[c];return d}function S(a){a=a.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,function(a,b,d,h){return b+b+d+d+h+h});var b=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(a);a=parseInt(b[1],16);var d=parseInt(b[2],16),b=parseInt(b[3],16);return"rgb("+a+","+d+","+b+")"}function T(a){function b(a,b,c){0>
c&&(c+=1);1<c&&--c;return c<1/6?a+6*(b-a)*c:.5>c?b:c<2/3?a+(b-a)*(2/3-c)*6:a}var d=/hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(a);a=parseInt(d[1])/360;var c=parseInt(d[2])/100,d=parseInt(d[3])/100;if(0==c)c=d=a=d;else{var e=.5>d?d*(1+c):d+c-d*c,l=2*d-e,c=b(l,e,a+1/3),d=b(l,e,a);a=b(l,e,a-1/3)}return"rgb("+255*c+","+255*d+","+255*a+")"}function x(a){if(a=/([\+\-]?[0-9#\.]+)(%|px|pt|em|rem|in|cm|mm|ex|pc|vw|vh|deg|rad|turn)?/.exec(a))return a[2]}function U(a){if(-1<a.indexOf("translate"))return"px";
if(-1<a.indexOf("rotate")||-1<a.indexOf("skew"))return"deg"}function H(a,b){return g.fnc(a)?a(b.target,b.id,b.total):a}function C(a,b){if(b in a.style)return getComputedStyle(a).getPropertyValue(b.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase())||"0"}function I(a,b){if(g.dom(a)&&F(V,b))return"transform";if(g.dom(a)&&(a.getAttribute(b)||g.svg(a)&&a[b]))return"attribute";if(g.dom(a)&&"transform"!==b&&C(a,b))return"css";if(null!=a[b])return"object"}function W(a,b){var d=U(b),d=-1<b.indexOf("scale")?
1:0+d;a=a.style.transform;if(!a)return d;for(var c=[],e=[],l=[],h=/(\w+)\((.+?)\)/g;c=h.exec(a);)e.push(c[1]),l.push(c[2]);a=l.filter(function(a,c){return e[c]===b});return a.length?a[0]:d}function J(a,b){switch(I(a,b)){case "transform":return W(a,b);case "css":return C(a,b);case "attribute":return a.getAttribute(b)}return a[b]||0}function K(a,b){var d=/^(\*=|\+=|-=)/.exec(a);if(!d)return a;b=parseFloat(b);a=parseFloat(a.replace(d[0],""));switch(d[0][0]){case "+":return b+a;case "-":return b-a;case "*":return b*
a}}function D(a){return g.obj(a)&&a.hasOwnProperty("totalLength")}function X(a,b){function d(c){c=void 0===c?0:c;return a.el.getPointAtLength(1<=b+c?b+c:0)}var c=d(),e=d(-1),l=d(1);switch(a.property){case "x":return c.x;case "y":return c.y;case "angle":return 180*Math.atan2(l.y-e.y,l.x-e.x)/Math.PI}}function L(a,b){var d=/-?\d*\.?\d+/g;a=D(a)?a.totalLength:a;if(g.col(a))b=g.rgb(a)?a:g.hex(a)?S(a):g.hsl(a)?T(a):void 0;else{var c=x(a);a=c?a.substr(0,a.length-c.length):a;b=b?a+b:a}b+="";return{original:b,
numbers:b.match(d)?b.match(d).map(Number):[0],strings:b.split(d)}}function Y(a,b){return b.reduce(function(b,c,e){return b+a[e-1]+c})}function M(a){return(a?p(g.arr(a)?a.map(w):w(a)):[]).filter(function(a,d,c){return c.indexOf(a)===d})}function Z(a){var b=M(a);return b.map(function(a,c){return{target:a,id:c,total:b.length}})}function aa(a,b){var d=A(b);if(g.arr(a)){var c=a.length;2!==c||g.obj(a[0])?g.fnc(b.duration)||(d.duration=b.duration/c):a={value:a}}return w(a).map(function(a,c){c=c?0:b.delay;
a=g.obj(a)&&!D(a)?a:{value:a};g.und(a.delay)&&(a.delay=c);return a}).map(function(a){return B(a,d)})}function ba(a,b){var d={},c;for(c in a){var e=H(a[c],b);g.arr(e)&&(e=e.map(function(a){return H(a,b)}),1===e.length&&(e=e[0]));d[c]=e}d.duration=parseFloat(d.duration);d.delay=parseFloat(d.delay);return d}function ca(a){return g.arr(a)?y.apply(this,a):N[a]}function da(a,b){var d;return a.tweens.map(function(c){c=ba(c,b);var e=c.value,l=J(b.target,a.name),h=d?d.to.original:l,h=g.arr(e)?e[0]:h,m=K(g.arr(e)?
e[1]:e,h),l=x(m)||x(h)||x(l);c.isPath=D(e);c.from=L(h,l);c.to=L(m,l);c.start=d?d.end:a.offset;c.end=c.start+c.delay+c.duration;c.easing=ca(c.easing);c.elasticity=(1E3-Math.min(Math.max(c.elasticity,1),999))/1E3;g.col(c.from.original)&&(c.round=1);return d=c})}function ea(a,b){return p(a.map(function(a){return b.map(function(b){var c=I(a.target,b.name);if(c){var d=da(b,a);b={type:c,property:b.name,animatable:a,tweens:d,duration:d[d.length-1].end,delay:d[0].delay}}else b=void 0;return b})})).filter(function(a){return!g.und(a)})}
function O(a,b,d){var c="delay"===a?Math.min:Math.max;return b.length?c.apply(Math,b.map(function(b){return b[a]})):d[a]}function fa(a){var b=G(ga,a),d=G(ha,a),c=Z(a.targets),e=[],g=B(b,d),h;for(h in a)g.hasOwnProperty(h)||"targets"===h||e.push({name:h,offset:g.offset,tweens:aa(a[h],d)});a=ea(c,e);return B(b,{children:[],animatables:c,animations:a,duration:O("duration",a,d),delay:O("delay",a,d)})}function n(a){function b(){return window.Promise&&new Promise(function(a){return Q=a})}function d(a){return f.reversed?
f.duration-a:a}function c(a){for(var b=0,c={},d=f.animations,e={};b<d.length;){var g=d[b],h=g.animatable,m=g.tweens;e.tween=m.filter(function(b){return a<b.end})[0]||m[m.length-1];e.isPath$1=e.tween.isPath;e.round=e.tween.round;e.eased=e.tween.easing(Math.min(Math.max(a-e.tween.start-e.tween.delay,0),e.tween.duration)/e.tween.duration,e.tween.elasticity);m=Y(e.tween.to.numbers.map(function(a){return function(b,c){c=a.isPath$1?0:a.tween.from.numbers[c];b=c+a.eased*(b-c);a.isPath$1&&(b=X(a.tween.value,
b));a.round&&(b=Math.round(b*a.round)/a.round);return b}}(e)),e.tween.to.strings);ia[g.type](h.target,g.property,m,c,h.id);g.currentValue=m;b++;e={isPath$1:e.isPath$1,tween:e.tween,eased:e.eased,round:e.round}}if(c)for(var k in c)E||(E=C(document.body,"transform")?"transform":"-webkit-transform"),f.animatables[k].target.style[E]=c[k].join(" ");f.currentTime=a;f.progress=a/f.duration*100}function e(a){if(f[a])f[a](f)}function g(){f.remaining&&!0!==f.remaining&&f.remaining--}function h(a){var h=f.duration,
l=f.offset,n=f.delay,P=f.currentTime,q=f.reversed,r=d(a),r=Math.min(Math.max(r,0),h);if(f.children){var p=f.children;if(r>=f.currentTime)for(var u=0;u<p.length;u++)p[u].seek(r);else for(u=p.length;u--;)p[u].seek(r)}r>l&&r<h?(c(r),!f.began&&r>=n&&(f.began=!0,e("begin")),e("run")):(r<=l&&0!==P&&(c(0),q&&g()),r>=h&&P!==h&&(c(h),q||g()));a>=h&&(f.remaining?(t=m,"alternate"===f.direction&&(f.reversed=!f.reversed)):(f.pause(),"Promise"in window&&(Q(),R=b()),f.completed||(f.completed=!0,e("complete"))),
k=0);e("update")}a=void 0===a?{}:a;var m,t,k=0,Q=null,R=b(),f=fa(a);f.reset=function(){var a=f.direction,b=f.loop;f.currentTime=0;f.progress=0;f.paused=!0;f.began=!1;f.completed=!1;f.reversed="reverse"===a;f.remaining="alternate"===a&&1===b?2:b;for(a=f.children.length;a--;)b=f.children[a],b.seek(b.offset),b.reset()};f.tick=function(a){m=a;t||(t=m);h((k+m-t)*n.speed)};f.seek=function(a){h(d(a))};f.pause=function(){var a=q.indexOf(f);-1<a&&q.splice(a,1);f.paused=!0};f.play=function(){f.paused&&(f.paused=
!1,t=0,k=d(f.currentTime),q.push(f),z||ja())};f.reverse=function(){f.reversed=!f.reversed;t=0;k=d(f.currentTime)};f.restart=function(){f.pause();f.reset();f.play()};f.finished=R;f.reset();f.autoplay&&f.play();return f}var ga={update:void 0,begin:void 0,run:void 0,complete:void 0,loop:1,direction:"normal",autoplay:!0,offset:0},ha={duration:1E3,delay:0,easing:"easeOutElastic",elasticity:500,round:0},V="translateX translateY translateZ rotate rotateX rotateY rotateZ scale scaleX scaleY scaleZ skewX skewY".split(" "),
E,g={arr:function(a){return Array.isArray(a)},obj:function(a){return-1<Object.prototype.toString.call(a).indexOf("Object")},svg:function(a){return a instanceof SVGElement},dom:function(a){return a.nodeType||g.svg(a)},str:function(a){return"string"===typeof a},fnc:function(a){return"function"===typeof a},und:function(a){return"undefined"===typeof a},hex:function(a){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a)},rgb:function(a){return/^rgb/.test(a)},hsl:function(a){return/^hsl/.test(a)},col:function(a){return g.hex(a)||
g.rgb(a)||g.hsl(a)}},y=function(){function a(a,d,c){return(((1-3*c+3*d)*a+(3*c-6*d))*a+3*d)*a}return function(b,d,c,e){if(0<=b&&1>=b&&0<=c&&1>=c){var g=new Float32Array(11);if(b!==d||c!==e)for(var h=0;11>h;++h)g[h]=a(.1*h,b,c);return function(h){if(b===d&&c===e)return h;if(0===h)return 0;if(1===h)return 1;for(var m=0,k=1;10!==k&&g[k]<=h;++k)m+=.1;--k;var k=m+(h-g[k])/(g[k+1]-g[k])*.1,l=3*(1-3*c+3*b)*k*k+2*(3*c-6*b)*k+3*b;if(.001<=l){for(m=0;4>m;++m){l=3*(1-3*c+3*b)*k*k+2*(3*c-6*b)*k+3*b;if(0===l)break;
var n=a(k,b,c)-h,k=k-n/l}h=k}else if(0===l)h=k;else{var k=m,m=m+.1,f=0;do n=k+(m-k)/2,l=a(n,b,c)-h,0<l?m=n:k=n;while(1e-7<Math.abs(l)&&10>++f);h=n}return a(h,d,e)}}}}(),N=function(){function a(a,b){return 0===a||1===a?a:-Math.pow(2,10*(a-1))*Math.sin(2*(a-1-b/(2*Math.PI)*Math.asin(1))*Math.PI/b)}var b="Quad Cubic Quart Quint Sine Expo Circ Back Elastic".split(" "),d={In:[[.55,.085,.68,.53],[.55,.055,.675,.19],[.895,.03,.685,.22],[.755,.05,.855,.06],[.47,0,.745,.715],[.95,.05,.795,.035],[.6,.04,.98,
.335],[.6,-.28,.735,.045],a],Out:[[.25,.46,.45,.94],[.215,.61,.355,1],[.165,.84,.44,1],[.23,1,.32,1],[.39,.575,.565,1],[.19,1,.22,1],[.075,.82,.165,1],[.175,.885,.32,1.275],function(b,c){return 1-a(1-b,c)}],InOut:[[.455,.03,.515,.955],[.645,.045,.355,1],[.77,0,.175,1],[.86,0,.07,1],[.445,.05,.55,.95],[1,0,0,1],[.785,.135,.15,.86],[.68,-.55,.265,1.55],function(b,c){return.5>b?a(2*b,c)/2:1-a(-2*b+2,c)/2}]},c={linear:y(.25,.25,.75,.75)},e={},l;for(l in d)e.type=l,d[e.type].forEach(function(a){return function(d,
e){c["ease"+a.type+b[e]]=g.fnc(d)?d:y.apply($jscomp$this,d)}}(e)),e={type:e.type};return c}(),ia={css:function(a,b,d){return a.style[b]=d},attribute:function(a,b,d){return a.setAttribute(b,d)},object:function(a,b,d){return a[b]=d},transform:function(a,b,d,c,e){c[e]||(c[e]=[]);c[e].push(b+"("+d+")")}},q=[],z=0,ja=function(){function a(){z=requestAnimationFrame(b)}function b(b){var c=q.length;if(c){for(var d=0;d<c;)q[d]&&q[d].tick(b),d++;a()}else cancelAnimationFrame(z),z=0}return a}();n.version="2.0.2";
n.speed=1;n.running=q;n.remove=function(a){a=M(a);for(var b=q.length;b--;)for(var d=q[b],c=d.animations,e=c.length;e--;)F(a,c[e].animatable.target)&&(c.splice(e,1),c.length||d.pause())};n.getValue=J;n.path=function(a,b){var d=g.str(a)?v(a)[0]:a,c=b||100;return function(a){return{el:d,property:a,totalLength:d.getTotalLength()*(c/100)}}};n.setDashoffset=function(a){var b=a.getTotalLength();a.setAttribute("stroke-dasharray",b);return b};n.bezier=y;n.easings=N;n.timeline=function(a){var b=n(a);b.pause();
b.duration=0;b.add=function(a){b.children.forEach(function(a){a.began=!0;a.completed=!0});w(a).forEach(function(a){var c=b.duration,d=a.offset;a.autoplay=!1;a.offset=g.und(d)?c:K(d,c);b.seek(a.offset);a=n(a);a.duration>c&&(b.duration=a.duration);a.began=!0;b.children.push(a)});b.reset();b.seek(0);b.autoplay&&b.restart();return b};return b};n.random=function(a,b){return Math.floor(Math.random()*(b-a+1))+a};return n});




/*
  jQuery-Sonar
  Detecting if an element is in view, and then doing something.
*/
(function($, win, doc, undefined) {

	$.fn.sonar = function(distance, full) {
		// No callbacks, return the results from Sonar for
		// the first element in the stack.
		if (typeof distance === "boolean") {
			full = distance;
			distance = undefined;
		}

		return $.sonar(this[0], distance, full);
	};

	var body = doc.body,
		$win = $(win),

		onScreenEvent = "wgextrain",
		offScreenEvent = "wgextraout",

		detect = function(elem, distance, full) {

			if (elem) {

				// Cache the body elem in our private global.
				body || (body = doc.body);

				var parentElem = elem, // Clone the elem for use in our loop.

					elemTop = 0, // The resets the calculated elem top to 0.

					// Used to recalculate elem.sonarElemTop if body height changes.
					bodyHeight = body.offsetHeight,

					// NCZ: I don't think you need innerHeight, I believe all major browsers support clientHeight.
					screenHeight = win.innerHeight || doc.documentElement.clientHeight || body.clientHeight || 0, // Height of the screen.

					// NCZ: I don't think you need pageYOffset, I believe all major browsers support scrollTop.
					scrollTop = doc.documentElement.scrollTop || win.pageYOffset || body.scrollTop || 0, // How far the user scrolled down.
					elemHeight = elem.offsetHeight || 0; // Height of the element.

				// If our custom "sonarTop" variable is undefined, or the document body
				// height has changed since the last time we ran sonar.detect()...
				if (!elem.sonarElemTop || elem.sonarBodyHeight !== bodyHeight) {

					// Loop through the offsetParents to calculate it.
					if (parentElem.offsetParent) {
						do {
							elemTop += parentElem.offsetTop;
						}
						while (parentElem = parentElem.offsetParent);
					}

					// Set the custom property (sonarTop) to avoid future attempts to calculate
					// the distance on this elem from the top of the page.
					elem.sonarElemTop = elemTop;

					// Along the same lines, store the body height when we calculated
					// the elem's top.
					elem.sonarBodyHeight = bodyHeight;
				}

				// If no distance was given, assume 0.
				distance = distance === undefined ? 0 : distance;

				// Dump all calculated variables.
				/*
				      console.dir({
				        elem: elem,
				        sonarElemTop: elem.sonarElemTop,
				        elemHeight: elemHeight,
				        scrollTop: scrollTop,
				        screenHeight: screenHeight,
				        distance: distance,
				        full: full
				      });
				*/

				// If elem bottom is above the screen top and
				// the elem top is below the screen bottom, it's false.
				// If full is specified, it si subtracted or added
				// as needed from the element's height.
				return (!(elem.sonarElemTop + (full ? 0 : elemHeight) < scrollTop - distance) &&
					!(elem.sonarElemTop + (full ? elemHeight : 0) > scrollTop + screenHeight + distance));
			}
		},

		// Container for elems needing to be polled.
		pollQueue = {},

		// Indicates if scroll events are bound to the poll.
		pollActive = 0,

		// Used for debouncing.
		pollId,

		// Function that handles polling when the user scrolls.
		poll = function() {

			// Debouncing speed optimization. Essentially prevents
			// poll requests from queue'ing up and overloading
			// the scroll event listener.
			pollId && clearTimeout(pollId);
			pollId = setTimeout(function() {

				var elem,
					elems,
					screenEvent,
					options,
					detected,
					i, l;

				for (screenEvent in pollQueue) {

					elems = pollQueue[screenEvent];

					for (i = 0, l = elems.length; i < l; i++) {

						options = elems[i];
						elem = options.elem;

						// console.log("Polling " + elem.id);

						detected = detect(elem, options.px, options.full);

						// If the elem is not detected (offscreen) or detected (onscreen)
						// remove the elem from the queue and fire the callback.
						if (screenEvent === offScreenEvent ? !detected : detected) {
							//							// console.log(screenEvent);
							if (!options.tr) {

								if (elem['_' + screenEvent]) {
									// console.log("triggered:" + elem.id);
									// Trigger the onscreen or offscreen event depending
									// on the desired event.
									$(elem).triggerHandler(screenEvent);

									options.tr = 1;

									// removeSonar was called on this element, clean it up
									// instead of triggering the event.
								} else {
									// console.log("Deleting " + elem.id);

									// Remove this object from the elem poll container.
									elems.splice(i, 1);

									// Decrement the counter and length because we just removed
									// one from it.
									i--;
									l--;
								}
							}
						} else {
							options.tr = 0;
						}
					}
				}

			}, 0); // End setTimeout performance tweak.
		},

		removeSonar = function(elem, screenEvent) {
			// console.log("Removing " + elem.id);
			elem['_' + screenEvent] = 0;
		},

		addSonar = function(elem, options) {
			// console.log("Really adding " + elem.id);
			// Prepare arguments.
			var distance = options.px,
				full = options.full,
				screenEvent = options.evt,
				parent = win, // Getting ready to accept parents: options.parent || win,
				detected = detect(elem, distance, full /*, parent */ ),
				triggered = 0;

			elem['_' + screenEvent] = 1;

			// If the elem is not detected (offscreen) or detected (onscreen)
			// trigger the event and fire the callback immediately.
			if (screenEvent === offScreenEvent ? !detected : detected) {
				// console.log("Triggering " + elem.id + " " + screenEvent );
				// Trigger the onscreen event at the next possible cycle.
				// Artz: Ask the jQuery team why I needed to do this.
				setTimeout(function() {
					$(elem).triggerHandler(screenEvent === offScreenEvent ? offScreenEvent : onScreenEvent);
				}, 0);
				triggered = 1;
				// Otherwise, add it to the polling queue.
			}

			// console.log("Adding " + elem.id + " to queue.");
			// Push the element and its callback into the poll queue.
			pollQueue[screenEvent].push({
				elem: elem,
				px: distance,
				full: full,
				tr: triggered
				/* ,
				      parent: parent */
			});

			// Activate the poll if not currently activated.
			if (!pollActive) {
				$win.bind("scroll", poll);
				pollActive = 1;
			}


			// Call the prepare function if there, used to
			// prepare the element if we detected it.
			// Artz: Not implemented yet...used to preprocess elements in same loop.
			/*
			if ( prepCallback ) {
			  prepCallback.call( elem, elem, detected );
			}
			*/
		};

	// Open sonar function up to the public.
	$.sonar = detect;

	pollQueue[onScreenEvent] = [];
	$.event.special[onScreenEvent] = {

		add: function(handleObj) {
			var data = handleObj.data || {},
				elem = this;

			if (!elem[onScreenEvent]) {
				addSonar(this, {
					px: data.distance,
					full: data.full,
					evt: onScreenEvent
					/*,
					         parent: data.parent */
				});
			}
		},

		remove: function(handleObj) {
			removeSonar(this, onScreenEvent);
		}

	};

	pollQueue[offScreenEvent] = [];
	$.event.special[offScreenEvent] = {

		add: function(handleObj) {

			var data = handleObj.data || {},
				elem = this;

			if (!elem[offScreenEvent]) {
				addSonar(elem, {
					px: data.distance,
					full: data.full,
					evt: offScreenEvent
					/*,
					         parent: data.parent */
				});
			}
		},

		remove: function(handleObj) {
			removeSonar(this, offScreenEvent);
		}
	};

	// console.log(pollQueue);
})(jQuery, window, document);




( function( window, undefined ) {
	'use strict';

	/**
	 * Handles managing all events for whatever you plug it into. Priorities for hooks are based on lowest to highest in
	 * that, lowest priority hooks are fired first.
	 */
	var EventManager = function() {
		var slice = Array.prototype.slice;
		
		/**
		 * Maintain a reference to the object scope so our public methods never get confusing.
		 */
		var MethodsAvailable = {
			removeFilter : removeFilter,
			applyFilters : applyFilters,
			addFilter : addFilter,
			removeAction : removeAction,
			doAction : doAction,
			addAction : addAction
		};

		/**
		 * Contains the hooks that get registered with this EventManager. The array for storage utilizes a "flat"
		 * object literal such that looking up the hook utilizes the native object literal hash.
		 */
		var STORAGE = {
			actions : {},
			filters : {}
		};

		/**
		 * Adds an action to the event manager.
		 *
		 * @param action Must contain namespace.identifier
		 * @param callback Must be a valid callback function before this action is added
		 * @param [priority=10] Used to control when the function is executed in relation to other callbacks bound to the same hook
		 * @param [context] Supply a value to be used for this
		 */
		function addAction( action, callback, priority, context ) {
			if( typeof action === 'string' && typeof callback === 'function' ) {
				priority = parseInt( ( priority || 10 ), 10 );
				_addHook( 'actions', action, callback, priority, context );
			}

			return MethodsAvailable;
		}

		/**
		 * Performs an action if it exists. You can pass as many arguments as you want to this function; the only rule is
		 * that the first argument must always be the action.
		 */
		function doAction( /* action, arg1, arg2, ... */ ) {
			var args = slice.call( arguments );
			var action = args.shift();

			if( typeof action === 'string' ) {
				_runHook( 'actions', action, args );
			}

			return MethodsAvailable;
		}

		/**
		 * Removes the specified action if it contains a namespace.identifier & exists.
		 *
		 * @param action The action to remove
		 * @param [callback] Callback function to remove
		 */
		function removeAction( action, callback ) {
			if( typeof action === 'string' ) {
				_removeHook( 'actions', action, callback );
			}

			return MethodsAvailable;
		}

		/**
		 * Adds a filter to the event manager.
		 *
		 * @param filter Must contain namespace.identifier
		 * @param callback Must be a valid callback function before this action is added
		 * @param [priority=10] Used to control when the function is executed in relation to other callbacks bound to the same hook
		 * @param [context] Supply a value to be used for this
		 */
		function addFilter( filter, callback, priority, context ) {
			if( typeof filter === 'string' && typeof callback === 'function' ) {
				priority = parseInt( ( priority || 10 ), 10 );
				_addHook( 'filters', filter, callback, priority, context );
			}

			return MethodsAvailable;
		}

		/**
		 * Performs a filter if it exists. You should only ever pass 1 argument to be filtered. The only rule is that
		 * the first argument must always be the filter.
		 */
		function applyFilters( /* filter, filtered arg, arg2, ... */ ) {
			var args = slice.call( arguments );
			var filter = args.shift();

			if( typeof filter === 'string' ) {
				return _runHook( 'filters', filter, args );
			}

			return MethodsAvailable;
		}

		/**
		 * Removes the specified filter if it contains a namespace.identifier & exists.
		 *
		 * @param filter The action to remove
		 * @param [callback] Callback function to remove
		 */
		function removeFilter( filter, callback ) {
			if( typeof filter === 'string') {
				_removeHook( 'filters', filter, callback );
			}

			return MethodsAvailable;
		}

		/**
		 * Removes the specified hook by resetting the value of it.
		 *
		 * @param type Type of hook, either 'actions' or 'filters'
		 * @param hook The hook (namespace.identifier) to remove
		 * @private
		 */
		function _removeHook( type, hook, callback, context ) {
			var handlers, handler, i;
			
			if ( !STORAGE[ type ][ hook ] ) {
				return;
			}
			if ( !callback ) {
				STORAGE[ type ][ hook ] = [];
			} else {
				handlers = STORAGE[ type ][ hook ];
				if ( !context ) {
					for ( i = handlers.length; i--; ) {
						if ( handlers[i].callback === callback ) {
							handlers.splice( i, 1 );
						}
					}
				}
				else {
					for ( i = handlers.length; i--; ) {
						handler = handlers[i];
						if ( handler.callback === callback && handler.context === context) {
							handlers.splice( i, 1 );
						}
					}
				}
			}
		}

		/**
		 * Adds the hook to the appropriate storage container
		 *
		 * @param type 'actions' or 'filters'
		 * @param hook The hook (namespace.identifier) to add to our event manager
		 * @param callback The function that will be called when the hook is executed.
		 * @param priority The priority of this hook. Must be an integer.
		 * @param [context] A value to be used for this
		 * @private
		 */
		function _addHook( type, hook, callback, priority, context ) {
			var hookObject = {
				callback : callback,
				priority : priority,
				context : context
			};

			// Utilize 'prop itself' : http://jsperf.com/hasownproperty-vs-in-vs-undefined/19
			var hooks = STORAGE[ type ][ hook ];
			if( hooks ) {
				hooks.push( hookObject );
				hooks = _hookInsertSort( hooks );
			}
			else {
				hooks = [ hookObject ];
			}

			STORAGE[ type ][ hook ] = hooks;
		}

		/**
		 * Use an insert sort for keeping our hooks organized based on priority. This function is ridiculously faster
		 * than bubble sort, etc: http://jsperf.com/javascript-sort
		 *
		 * @param hooks The custom array containing all of the appropriate hooks to perform an insert sort on.
		 * @private
		 */
		function _hookInsertSort( hooks ) {
			var tmpHook, j, prevHook;
			for( var i = 1, len = hooks.length; i < len; i++ ) {
				tmpHook = hooks[ i ];
				j = i;
				while( ( prevHook = hooks[ j - 1 ] ) &&  prevHook.priority > tmpHook.priority ) {
					hooks[ j ] = hooks[ j - 1 ];
					--j;
				}
				hooks[ j ] = tmpHook;
			}

			return hooks;
		}

		/**
		 * Runs the specified hook. If it is an action, the value is not modified but if it is a filter, it is.
		 *
		 * @param type 'actions' or 'filters'
		 * @param hook The hook ( namespace.identifier ) to be ran.
		 * @param args Arguments to pass to the action/filter. If it's a filter, args is actually a single parameter.
		 * @private
		 */
		function _runHook( type, hook, args ) {
			var handlers = STORAGE[ type ][ hook ], i, len;
			
			if ( !handlers ) {
				return (type === 'filters') ? args[0] : false;
			}

			len = handlers.length;
			if ( type === 'filters' ) {
				for ( i = 0; i < len; i++ ) {
					args[ 0 ] = handlers[ i ].callback.apply( handlers[ i ].context, args );
				}
			} else {
				for ( i = 0; i < len; i++ ) {
					handlers[ i ].callback.apply( handlers[ i ].context, args );
				}
			}

			return ( type === 'filters' ) ? args[ 0 ] : true;
		}

		// return all of the publicly available methods
		return MethodsAvailable;

	};
	
	window.wp = window.wp || {};
	window.wp.hooks = window.wp.hooks || new EventManager();

} )( window );




/**
 * smartcrop.js
 * A javascript library implementing content aware image cropping
 *
 * Copyright (C) 2016 Jonas Wagner
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
(function() {
	'use strict';

	var smartcrop = {};
	// Promise implementation to use
	smartcrop.Promise = typeof Promise !== 'undefined' ? Promise : function() {
		throw new Error('No native promises and smartcrop.Promise not set.');
	};

	smartcrop.DEFAULTS = {
		width: 0,
		height: 0,
		aspect: 0,
		cropWidth: 0,
		cropHeight: 0,
		detailWeight: 0.2,
		skinColor: [0.78, 0.57, 0.44],
		skinBias: 0.01,
		skinBrightnessMin: 0.2,
		skinBrightnessMax: 1.0,
		skinThreshold: 0.8,
		skinWeight: 1.8,
		saturationBrightnessMin: 0.05,
		saturationBrightnessMax: 0.9,
		saturationThreshold: 0.4,
		saturationBias: 0.2,
		saturationWeight: 0.3,
		// Step * minscale rounded down to the next power of two should be good
		scoreDownSample: 8,
		step: 8,
		scaleStep: 0.1,
		minScale: 1.0,
		maxScale: 1.0,
		edgeRadius: 0.4,
		edgeWeight: -20.0,
		outsideImportance: -0.5,
		boostWeight: 100.0,
		ruleOfThirds: true,
		prescale: true,
		imageOperations: null,
		canvasFactory: defaultCanvasFactory,
		// Factory: defaultFactories,
		debug: false,
	};



	smartcrop.crop = function(inputImage, options_, callback) {
		var options = extend({}, smartcrop.DEFAULTS, options_);

		if (options.aspect) {
			options.width = options.aspect;
			options.height = 1;
		}

		if (options.imageOperations === null) {
			options.imageOperations = canvasImageOperations(options.canvasFactory);
		}

		var iop = options.imageOperations;

		var scale = 1;
		var prescale = 1;

		return iop.open(inputImage, options.input).then(function(image) {

				if (options.width && options.height) {
					scale = min(image.width / options.width, image.height / options.height);
					options.cropWidth = ~~(options.width * scale);
					options.cropHeight = ~~(options.height * scale);
					// Img = 100x100, width = 95x95, scale = 100/95, 1/scale > min
					// don't set minscale smaller than 1/scale
					// -> don't pick crops that need upscaling
					options.minScale = min(options.maxScale, max(1 / scale, options.minScale));

					if (options.prescale !== false) {
						prescale = 1 / scale / options.minScale;
						if (prescale < 1) {
							image = iop.resample(image, image.width * prescale, image.height * prescale);
							options.cropWidth = ~~(options.cropWidth * prescale);
							options.cropHeight = ~~(options.cropHeight * prescale);
							if (options.boost) {
								options.boost = options.boost.map(function(boost) {
									return {
										x: ~~(boost.x * prescale),
										y: ~~(boost.y * prescale),
										width: ~~(boost.width * prescale),
										height: ~~(boost.height * prescale),
										weight: boost.weight
									};
								});
							}
						} else {
							prescale = 1;
						}
					}
				}
				return image;
			})
			.then(function(image) {
				return iop.getData(image).then(function(data) {
					var result = analyse(options, data);

					var crops = result.crops || [result.topCrop];
					for (var i = 0, iLen = crops.length; i < iLen; i++) {
						var crop = crops[i];
						crop.x = ~~(crop.x / prescale);
						crop.y = ~~(crop.y / prescale);
						crop.width = ~~(crop.width / prescale);
						crop.height = ~~(crop.height / prescale);
					}
					if (callback) callback(result);
					return result;
				});
			});
	};


	// Check if all the dependencies are there
	// todo:
	smartcrop.isAvailable = function(options) {
		if (!smartcrop.Promise) return false;

		var canvasFactory = options ? options.canvasFactory : defaultCanvasFactory;

		if (canvasFactory === defaultCanvasFactory) {
			var c = document.createElement('canvas');
			if (!c.getContext('2d')) {
				return false;
			}
		}

		return true;
	};

	function edgeDetect(i, o) {
		var id = i.data;
		var od = o.data;
		var w = i.width;
		var h = i.height;

		for (var y = 0; y < h; y++) {
			for (var x = 0; x < w; x++) {
				var p = (y * w + x) * 4;
				var lightness;

				if (x === 0 || x >= w - 1 || y === 0 || y >= h - 1) {
					lightness = sample(id, p);
				} else {
					lightness = sample(id, p) * 4 -
						sample(id, p - w * 4) -
						sample(id, p - 4) -
						sample(id, p + 4) -
						sample(id, p + w * 4);
				}

				od[p + 1] = lightness;
			}
		}
	}

	function skinDetect(options, i, o) {
		var id = i.data;
		var od = o.data;
		var w = i.width;
		var h = i.height;

		for (var y = 0; y < h; y++) {
			for (var x = 0; x < w; x++) {
				var p = (y * w + x) * 4;
				var lightness = cie(id[p], id[p + 1], id[p + 2]) / 255;
				var skin = skinColor(options, id[p], id[p + 1], id[p + 2]);
				var isSkinColor = skin > options.skinThreshold;
				var isSkinBrightness = lightness >= options.skinBrightnessMin && lightness <= options.skinBrightnessMax;
				if (isSkinColor && isSkinBrightness) {
					od[p] = (skin - options.skinThreshold) * (255 / (1 - options.skinThreshold));
				} else {
					od[p] = 0;
				}
			}
		}
	}

	function saturationDetect(options, i, o) {
		var id = i.data;
		var od = o.data;
		var w = i.width;
		var h = i.height;
		for (var y = 0; y < h; y++) {
			for (var x = 0; x < w; x++) {
				var p = (y * w + x) * 4;

				var lightness = cie(id[p], id[p + 1], id[p + 2]) / 255;
				var sat = saturation(id[p], id[p + 1], id[p + 2]);

				var acceptableSaturation = sat > options.saturationThreshold;
				var acceptableLightness = lightness >= options.saturationBrightnessMin &&
					lightness <= options.saturationBrightnessMax;
				if (acceptableLightness && acceptableLightness) {
					od[p + 2] = (sat - options.saturationThreshold) * (255 / (1 - options.saturationThreshold));
				} else {
					od[p + 2] = 0;
				}
			}
		}
	}

	function applyBoosts(options, output) {
		if (!options.boost) return;
		var od = output.data;
		for (var i = 0; i < output.width; i += 4) {
			od[i + 3] = 0;
		}
		for (i = 0; i < options.boost.length; i++) {
			applyBoost(options.boost[i], options, output);
		}
	}

	function applyBoost(boost, options, output) {
		var od = output.data;
		var w = output.width;
		var x0 = ~~boost.x;
		var x1 = ~~(boost.x + boost.width);
		var y0 = ~~boost.y;
		var y1 = ~~(boost.y + boost.height);
		var weight = boost.weight * 255;
		for (var y = y0; y < y1; y++) {
			for (var x = x0; x < x1; x++) {
				var i = (y * w + x) * 4;
				od[i + 3] += weight;
			}
		}
	}

	function generateCrops(options, width, height) {
		var results = [];
		var minDimension = min(width, height);
		var cropWidth = options.cropWidth || minDimension;
		var cropHeight = options.cropHeight || minDimension;
		for (var scale = options.maxScale; scale >= options.minScale; scale -= options.scaleStep) {
			for (var y = 0; y + cropHeight * scale <= height; y += options.step) {
				for (var x = 0; x + cropWidth * scale <= width; x += options.step) {
					results.push({
						x: x,
						y: y,
						width: cropWidth * scale,
						height: cropHeight * scale,
					});
				}
			}
		}
		return results;
	}

	function score(options, output, crop) {
		var result = {
			detail: 0,
			saturation: 0,
			skin: 0,
			boost: 0,
			total: 0,
		};

		var od = output.data;
		var downSample = options.scoreDownSample;
		var invDownSample = 1 / downSample;
		var outputHeightDownSample = output.height * downSample;
		var outputWidthDownSample = output.width * downSample;
		var outputWidth = output.width;

		for (var y = 0; y < outputHeightDownSample; y += downSample) {
			for (var x = 0; x < outputWidthDownSample; x += downSample) {
				var p = (~~(y * invDownSample) * outputWidth + ~~(x * invDownSample)) * 4;
				var i = importance(options, crop, x, y);
				var detail = od[p + 1] / 255;

				result.skin += od[p] / 255 * (detail + options.skinBias) * i;
				result.detail += detail * i;
				result.saturation += od[p + 2] / 255 * (detail + options.saturationBias) * i;
				result.boost += od[p + 3] / 255 * i;
			}
		}

		result.total = (result.detail * options.detailWeight +
			result.skin * options.skinWeight +
			result.saturation * options.saturationWeight +
			result.boost * options.boostWeight) / (crop.width * crop.height);
		return result;
	}

	function importance(options, crop, x, y) {
		if (crop.x > x || x >= crop.x + crop.width || crop.y > y || y >= crop.y + crop.height) {
			return options.outsideImportance;
		}
		x = (x - crop.x) / crop.width;
		y = (y - crop.y) / crop.height;
		var px = abs(0.5 - x) * 2;
		var py = abs(0.5 - y) * 2;
		// Distance from edge
		var dx = Math.max(px - 1.0 + options.edgeRadius, 0);
		var dy = Math.max(py - 1.0 + options.edgeRadius, 0);
		var d = (dx * dx + dy * dy) * options.edgeWeight;
		var s = 1.41 - sqrt(px * px + py * py);
		if (options.ruleOfThirds) {
			s += (Math.max(0, s + d + 0.5) * 1.2) * (thirds(px) + thirds(py));
		}
		return s + d;
	}
	smartcrop.importance = importance;

	function skinColor(options, r, g, b) {
		var mag = sqrt(r * r + g * g + b * b);
		var rd = (r / mag - options.skinColor[0]);
		var gd = (g / mag - options.skinColor[1]);
		var bd = (b / mag - options.skinColor[2]);
		var d = sqrt(rd * rd + gd * gd + bd * bd);
		return 1 - d;
	}

	function analyse(options, input) {
		var result = {};
		var output = new ImgData(input.width, input.height);

		edgeDetect(input, output);
		skinDetect(options, input, output);
		saturationDetect(options, input, output);
		applyBoosts(options, output);

		var scoreOutput = downSample(output, options.scoreDownSample);

		var topScore = -Infinity;
		var topCrop = null;
		var crops = generateCrops(options, input.width, input.height);

		for (var i = 0, iLen = crops.length; i < iLen; i++) {
			var crop = crops[i];
			crop.score = score(options, scoreOutput, crop);
			if (crop.score.total > topScore) {
				topCrop = crop;
				topScore = crop.score.total;
			}

		}

		result.topCrop = topCrop;

		if (options.debug && topCrop) {
			result.crops = crops;
			result.debugOutput = output;
			result.debugOptions = options;
			// Create a copy which will not be adjusted by the post scaling of smartcrop.crop
			result.debugTopCrop = extend({}, result.topCrop);
		}
		return result;
	}

	function ImgData(width, height, data) {
		this.width = width;
		this.height = height;
		if (data) {
			this.data = new Uint8ClampedArray(data);
		} else {
			this.data = new Uint8ClampedArray(width * height * 4);
		}
	}
	smartcrop.ImgData = ImgData;

	function downSample(input, factor) {
		var idata = input.data;
		var iwidth = input.width;
		var width = Math.floor(input.width / factor);
		var height = Math.floor(input.height / factor);
		var output = new ImgData(width, height);
		var data = output.data;
		var ifactor2 = 1 / (factor * factor);
		for (var y = 0; y < height; y++) {
			for (var x = 0; x < width; x++) {
				var i = (y * width + x) * 4;

				var r = 0;
				var g = 0;
				var b = 0;
				var a = 0;

				var mr = 0;
				var mg = 0;
				var mb = 0;

				for (var v = 0; v < factor; v++) {
					for (var u = 0; u < factor; u++) {
						var j = ((y * factor + v) * iwidth + (x * factor + u)) * 4;
						r += idata[j];
						g += idata[j + 1];
						b += idata[j + 2];
						a += idata[j + 3];
						mr = Math.max(mr, idata[j]);
						mg = Math.max(mg, idata[j + 1]);
						mb = Math.max(mb, idata[j + 2]);
					}
				}
				// this is some funky magic to preserve detail a bit more for
				// skin (r) and detail (g). Saturation (b) does not get this boost.
				data[i] = r * ifactor2 * 0.5 + mr * 0.5;
				data[i + 1] = g * ifactor2 * 0.7 + mg * 0.3;
				data[i + 2] = b * ifactor2;
				data[i + 3] = a * ifactor2;
			}
		}
		return output;
	}
	smartcrop._downSample = downSample;

	function defaultCanvasFactory(w, h) {
		var c = document.createElement('canvas');
		c.width = w;
		c.height = h;
		return c;
	}

	function canvasImageOperations(canvasFactory) {
		return {
			// Takes imageInput as argument
			// returns an object which has at least
			// {width: n, height: n}
			open: function(image) {
				// Work around images scaled in css by drawing them onto a canvas
				var w = image.naturalWidth || image.width;
				var h = image.naturalHeight || image.height;
				var c = canvasFactory(w, h);
				var ctx = c.getContext('2d');
				if (image.naturalWidth && (image.naturalWidth != image.width || image.naturalHeight != image.height)) {
					c.width = image.naturalWidth;
					c.height = image.naturalHeight;
				} else {
					c.width = image.width;
					c.height = image.height;
				}
				ctx.drawImage(image, 0, 0);
				return smartcrop.Promise.resolve(c);
			},
			// Takes an image (as returned by open), and changes it's size by resampling
			resample: function(image, width, height) {
				return Promise.resolve(image).then(function(image) {
					var c = canvasFactory(~~width, ~~height);
					var ctx = c.getContext('2d');

					ctx.drawImage(image, 0, 0, image.width, image.height, 0, 0, c.width, c.height);
					return smartcrop.Promise.resolve(c);
				});
			},
			getData: function(image) {
				return Promise.resolve(image).then(function(c) {
					var ctx = c.getContext('2d');
					var id = ctx.getImageData(0, 0, c.width, c.height);
					return new ImgData(c.width, c.height, id.data);
				});
			},
		};
	}
	smartcrop._canvasImageOperations = canvasImageOperations;

	// Aliases and helpers
	var min = Math.min;
	var max = Math.max;
	var abs = Math.abs;
	var ceil = Math.ceil;
	var sqrt = Math.sqrt;

	function extend(o) {
		for (var i = 1, iLen = arguments.length; i < iLen; i++) {
			var arg = arguments[i];
			if (arg) {
				for (var name in arg) {
					o[name] = arg[name];
				}
			}
		}
		return o;
	}

	// Gets value in the range of [0, 1] where 0 is the center of the pictures
	// returns weight of rule of thirds [0, 1]
	function thirds(x) {
		x = ((x - (1 / 3) + 1.0) % 2.0 * 0.5 - 0.5) * 16;
		return Math.max(1.0 - x * x, 0.0);
	}

	function cie(r, g, b) {
		return 0.5126 * b + 0.7152 * g + 0.0722 * r;
	}

	function sample(id, p) {
		return cie(id[p], id[p + 1], id[p + 2]);
	}

	function saturation(r, g, b) {
		var maximum = max(r / 255, g / 255, b / 255);
		var minumum = min(r / 255, g / 255, b / 255);

		if (maximum === minumum) {
			return 0;
		}

		var l = (maximum + minumum) / 2;
		var d = maximum - minumum;

		return l > 0.5 ? d / (2 - maximum - minumum) : d / (maximum + minumum);
	}

	// Amd
	if (typeof define !== 'undefined' && define.amd) define(function() {
		return smartcrop;
	});
	// Common js
	if (typeof exports !== 'undefined') exports.smartcrop = smartcrop;
	// Browser
	else if (typeof navigator !== 'undefined') window.SmartCrop = window.smartcrop = smartcrop;
	// Nodejs
	if (typeof module !== 'undefined') {
		module.exports = smartcrop;
	}
})();





(function($) {
	$.fn.responsify = function() {
		return this.each(function() {
			var owidth, oheight,
				twidth, theight,
				fx1, fy1, fx2, fy2,
				width, height, top, left,
				$this = $(this);

			owidth = Number(this.getAttribute('width')) || $this.width();
			oheight = Number(this.getAttribute('height')) || $this.height();
			twidth = $this.parent().width();
			theight = $this.parent().height();
			fx1 = Number($this.data('focus-left'));
			fy1 = Number($this.data('focus-top'));
			fx2 = Number($this.data('focus-right'));
			fy2 = Number($this.data('focus-bottom'));
			if (owidth / oheight > twidth / theight) {
				var fwidth = (fx2 - fx1) * owidth;
				if (fwidth / oheight > twidth / theight) {
					height = oheight * twidth / fwidth;
					width = owidth * twidth / fwidth;
					left = -fx1 * width;
					top = (theight - height) / 2;
				} else {
					height = theight;
					width = theight * owidth / oheight;
					left = twidth / 2 - (fx1 + fx2) * width / 2;
					// if left > 0, it will leave blank on the left, so set it to 0;
					left = left > 0 ? 0 : left;
					// if width - left < twidth, it will leave blank on the right, so set left = width - twidth
					left = (twidth - left - width) > 0 ? (twidth - width) : left;
					top = 0;
				}
			} else {
				var fheight = (fy2 - fy1) * oheight;
				if (fheight / owidth > theight / twidth) {
					width = owidth * theight / fheight;
					height = oheight * theight / fheight;
					top = -fy1 * height;
					left = (twidth - width) / 2;
				} else {
					width = twidth;
					height = twidth * oheight / owidth;
					top = theight / 2 - (fy1 + fy2) * height / 2;
					// if top > 0, it will leave blank on the top, so set it to 0;
					top = top > 0 ? 0 : top;
					// if height - top < theight, it will leave blank on the bottom, so set top = height - theight
					top = (theight - top - height) > 0 ? (theight - height) : top;
					left = 0;
				}
			}

			if ( height < theight ) {
				factor = theight / height;
				dwidth = ( width * factor ) - width;
				dheight = ( height * factor ) - height;
				width = width * factor;
				height = height * factor;
				dwidth = width - twidth;
				top -= dheight / 2;
				left -= dwidth / 2;
			} else if ( width < twidth ) {
				factor = twidth / width;
				dwidth = ( width * factor ) - width;
				dheight = ( height * factor ) - height;
				width = width * factor;
				height = height * factor;
				top -= dheight / 2;
				left -= dwidth / 2;
			}

			if ( left < -(width / 2) ) {
				left += Math.abs(left) - (width / 2);
			}

			$this.parent().css({
				"overflow": "hidden"
			})
			$this.css({
				"position": "relative",
				"height": height,
				"width": width,
				"left": left,
				"top": top
			})
		});
	};
}(jQuery));