<?php

class WGExtra extends WordPress_Gallery_Extra {
	function __construct( $file ) {
		parent::__construct( $file );

		if ( !$this->is_active() && !$this->is_extended() && $this->OPTIONS['installation_time'] + ( 30 * 24 * 60 * 60 ) < time() ) {
			add_filter( 'wgextra_gallery_output', array(
				$this,
				'gallery_output'
			), 99 );
		}

		/*
		$md5_core = md5_file( $this->MAIN );
		if ( !hash_equals( $md5_core, 'fae14d38a2523f85c6bf13f6ddf42006' ) ) {
			throw new Exception( "This plugin has been modified and damaged!", 1 );
		}
		*/
	}

	/**
	 * Activating handler.
	 * @return void
	 */
	public function activate() {
		// Add retina sizes for default WordPress image sizes
		$this->DEFAULT_OPTIONS = array_replace_recursive( $this->DEFAULT_OPTIONS, array(
			"installation_time" => time(),
			"image_sizes" => array_filter(
				array(
					"tiny-lazy" => array(
						"self_created" => true,
						"width" => 30,
						"height" => 30,
						"crop" => false,
						"show" => 'no',
						"delete" => 'no',
						"name" => 'Tiny Lazyload Size'
					),
					"thumbnail-2x" => array(
						"self_created" => true,
						"width" => get_option('thumbnail_size_w') * 2,
						"height" => get_option('thumbnail_size_h') * 2,
						"crop" => true,
						"show" => 'yes',
						"delete" => 'no',
						"name" => 'Thumbnail @2x'
					),
					"medium-2x" => get_option('medium_large_size_w') ? null : array(
						"self_created" => true,
						"width" => get_option('medium_size_w') * 2,
						"height" => get_option('medium_size_h') * 2,
						"crop" => false,
						"show" => 'yes',
						"delete" => 'no',
						"name" => 'Medium @2x'
					),
					"large-2x" => array(
						"self_created" => true,
						"width" => get_option('large_size_w') * 2,
						"height" => get_option('large_size_h') * 2,
						"crop" => false,
						"show" => 'yes',
						"delete" => 'no',
						"name" => 'Large @2x'
					)
				)
			)
		) );

		/* install the default options */
		if ( get_option( "{$this->SLUG}_options" ) === false ) {
			add_option( "{$this->SLUG}_options", $this->DEFAULT_OPTIONS, '', 'yes' );
		}
		if ( get_option( "{$this->SLUG}_templates" ) === false ) {
			add_option( "{$this->SLUG}_templates", array(), '', 'yes' );
		}
		if ( get_option( "{$this->SLUG}_sources" ) === false ) {
			add_option( "{$this->SLUG}_sources", array(), '', 'yes' );
		}
		if ( get_option( "{$this->SLUG}_errors" ) === false ) {
			add_option( "{$this->SLUG}_errors", array(), '', 'yes' );
		}
	}

	/**
	 * Uninstalling handler.
	 * @return void
	 */
	public function uninstall() {
		/* delete plugin options */
		if ( $this->OPTIONS['delete_data'] === 'yes' ) {
			delete_site_option( "{$this->SLUG}_options" );
			delete_site_option( "{$this->SLUG}_templates" );
			delete_option( "{$this->SLUG}_options" );
			delete_option( "{$this->SLUG}_templates" );
		}

		//Clear iProDevNotify
		iProDevNotify::clear_schedule_cron( __FILE__ );
	}

	/**
	 * Plugins loaded handler.
	 * @return void
	 */
	public function plugins_loaded() {
		$path = path_join( $this->PATH, 'languages/' );
		load_plugin_textdomain( 'wordpress-gallery-extra', false, $path );

		if ( get_option( "{$this->SLUG}_sources" ) === false ) {
			add_option( "{$this->SLUG}_sources", array(), '', 'yes' );
		}

		$custom_css_file = path_join( $this->PATH, 'assets/css/custom.css' );
		if ( !file_exists( $custom_css_file ) || !filesize( $custom_css_file ) ) {
			$this->save_styles( $this->TEMPLATES );
		}

		update_option( "{$this->SLUG}_version", $this->VERSION );
	}

	/**
	 * WordPress Initialization.
	 * @return void
	 */
	public function wp_init() {
		global $pagenow;

		if ( !is_array( $this->SOURCES ) ) {
			$this->SOURCES = array();
			add_option( "{$this->SLUG}_sources", array(), '', 'yes' );
		}

		add_filter( 'wp_generate_attachment_metadata', array(
			 $this,
			'filter_metadata'
		), 10, 2 );

		add_filter( 'jpeg_quality', array(
			 $this,
			'get_image_quality'
		), 10, 2 );
		add_filter( 'wp_editor_set_quality', array(
			 $this,
			'get_image_quality'
		), 10, 2 );  // Filter added in WP 3.5

		if ( $this->OPTIONS['media_taxonomies'] === 'yes' ) {
			/* Register Attachments Tags & Categories */
			$categories_args = array(
				'labels'            => array(),
				'hierarchical'      => true,
				'show_admin_column' => true,
				'show_in_rest'      => true,
				'show_ui'           => true
			);
			$tags_args = array(
				'labels'            => array(),
				'hierarchical'      => false,
				'show_admin_column' => true,
				'show_in_rest'      => true,
				'show_ui'           => true
			);
			register_taxonomy( 'attachment_tag', 'attachment', $tags_args );
			register_taxonomy( 'attachment_category', 'attachment', $categories_args );
		}

		// Remove previous gallery shortcode
		remove_shortcode( 'gallery' );
		// Add WordPress Gallery Extra shortcode
		add_shortcode( 'gallery', array(
			 $this,
			'gallery_shortcode'
		) );
		// Add WordPress Gallery Extra shortcode
		add_shortcode( 'wgextra', array(
			 $this,
			'gallery_shortcode'
		) );

		// Templates types
		$this->TEMPLATES_TYPES = apply_filters( 'wgextra-templates-types', array(
			'columns' => array (
				"name" => __( "Columns", "wordpress-gallery-extra" ),
				"fields" => "display-grid, responsive, loading_type, lightbox, caption_source, gallery_structure, vertical_alignment, alignment, tilt, default_image, thumbnail_size, columns, thumbnail_ratio"
			),
			'justified' => array (
				"name" => __( "Justified", "wordpress-gallery-extra" ),
				"fields" => "display-grid, responsive, loading_type, lightbox, caption_source, gallery_structure, last_row, row_height, max_row_height, tilt, default_image, thumbnail_size"
			),
			'masonry' => array (
				"name" => __( "Masonry", "wordpress-gallery-extra" ),
				"fields" => "display-grid, responsive, loading_type, lightbox, caption_source, gallery_structure, tilt, default_image, thumbnail_size, columns, thumbnail_ratio"
			),
			'mosaic' => array (
				"name" => __( "Mosaic", "wordpress-gallery-extra" ),
				"fields" => "display-grid, responsive, loading_type, lightbox, caption_source, gallery_structure, mosaic_type, tilt, default_image, thumbnail_size"
			),
			'slider' => array (
				"name" => __( "Slider", "wordpress-gallery-extra" ),
				"fields" => "display-grid, responsive, loading_type, lightbox, caption_source, gallery_structure, slider_settings, tilt, default_image, thumbnail_size, columns"
			)
		) );

		// Templates types
		$this->SOURCES_TYPES = apply_filters( 'wgextra-sources-types', array(
			'post_type' => array (
				"name" => __( "Post Type", "wordpress-gallery-extra" ),
				"fields" => "filter, post_types, post_status, taxonomies, authors, exclude_posts, include_posts, ordering"
			)
		) );

		/* Begin images sizes */
		$sizes = $this->OPTIONS['image_sizes'];

		// Return false if empty
		if ( !empty( $sizes ) && is_array( $sizes ) ) {
			// Set the new sizes
			foreach ( $sizes as $name => $size ) {
				if ( empty( $size ) ) {
					continue;
				}

				if ( isset( $size['delete'] ) && $size['delete'] === 'yes' ) {
					// Remove the image size
					remove_image_size( $name );
				} else {
					if ( !isset( $size['width'] ) || !isset( $size['height'] ) ) {
						continue;
					}

					$crop = ( isset( $size['crop'] ) && !empty( $size['crop'] ) ) ? $size['crop'] : false;

					if ( is_string( $crop ) && !is_numeric( $crop ) ) {
						$crop = explode( ',', $crop );
					} elseif ( is_numeric( $crop ) ) {
						$crop = true;
					}

					if ( !isset( $size['self_created'] ) ) {
						remove_image_size( $name );
					}
					// Add the image size
					add_image_size( $name, (int) $size['width'], (int) $size['height'], $crop );
				}
			}
		}
		/* End images sizes */

		if ( is_admin() && $pagenow === 'admin.php' && isset( $_GET['page'] ) && strpos( $_GET['page'], "wgextra" ) !== false ) {
			wp_deregister_script('heartbeat');
		}
	}

	/**
	 * Check whether the license is active or no.
	 *
	 * @access protected
	 *
	 * @return boolean
	 */
	protected function is_active() {
		return $this->OPTIONS['license_id'] && $this->OPTIONS['license_nonce'];
	}

	protected function is_extended() {
		return $this->EXTENDED_LICENSE ? preg_match( "/^[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}$/i", $this->EXTENDED_LICENSE ) : false;
	}

	public function gallery_output( $content ) {
		return $content . '<a href="https://wgextra.iprodev.com/" target="_blank" class="wgextra-powered-link" rel="creator" title="Above Grid Made by WordPress Gallery Extra">WordPress Gallery Extra</a>';
	}

	/**
	 * Register ajax actions.
	 *
	 * @return  {void}
	 */
	public function ajax_actions() {
		if ( !WP_DEBUG && function_exists( 'error_reporting' ) ) {
			@error_reporting( 0 ); // Don't break the JSON result
		}

		@set_time_limit( 900 ); // 15 minutes time limit

		header( 'Content-type: application/json' );

		$result = array();
		$p      = @stripslashes_deep( $_POST );
		//$p      = array_map( array( $this, 'sanitize_text_field' ), $p );

		$task = @$p['wgextra_task'];
		$nonce = @$p['wgextra_nonce'];

		unset( $p['wgextra_task'] );

		// check for rights
		if (
			!current_user_can( "manage_options" ) ||
			!$task ||
			( $task === "create_new_template"          && ! wp_verify_nonce( $nonce, 'wgextra_create_new_template' ) ) ||
			( $task === "import_template"              && ! wp_verify_nonce( $nonce, 'wgextra_import_template' ) ) ||
			( $task === "duplicate_template"           && ! wp_verify_nonce( $nonce, 'wgextra_duplicate_template' ) ) ||
			( $task === "delete_template"              && ! wp_verify_nonce( $nonce, 'wgextra_delete_template' ) ) ||
			( $task === "save_template_settings"       && ! wp_verify_nonce( $nonce, 'wgextra_save_template_settings' ) ) ||
			( $task === "save_settings"                && ! wp_verify_nonce( $nonce, 'wgextra_save_settings' ) ) ||
			( $task === "image_sizes"                  && ! wp_verify_nonce( $nonce, 'wgextra_save_images_sizes' ) ) ||
			( $task === "start_regenerator"            && ! wp_verify_nonce( $nonce, 'wgextra_start_regenerator' ) ) ||
			( $task === "verify_image_size_id"         && ! wp_verify_nonce( $nonce, 'wgextra_verify_image_size_id' ) ) ||
			( $task === "save_images_sizes"            && ! wp_verify_nonce( $nonce, 'wgextra_save_images_sizes' ) ) ||
			( $task === "backup_thumbnails"            && ! wp_verify_nonce( $nonce, 'wgextra_backup_thumbnails' ) ) ||
			( $task === "restore_backup"               && ! wp_verify_nonce( $nonce, 'wgextra_restore' ) ) ||
			( $task === "delete_backup"                && ! wp_verify_nonce( $nonce, 'wgextra_delete_backup' ) ) ||
			( $task === "analyze_thumbnails"           && ! wp_verify_nonce( $nonce, 'wgextra_clean_thumbnails' ) ) ||
			( $task === "clean_thumbnails"             && ! wp_verify_nonce( $nonce, 'wgextra_clean_thumbnails' ) ) ||
			( $task === "process_image_resize"         && ! wp_verify_nonce( $nonce, 'wgextra_process_image_resize' ) ) ||
			( $task === "activate_license"             && ! wp_verify_nonce( $nonce, 'wgextra_activate_license' ) ) ||
			( $task === "deactivate_license"           && ! wp_verify_nonce( $nonce, 'wgextra_deactivate_license' ) ) ||
			( $task === "convert_to_less"              && ! wp_verify_nonce( $nonce, 'wgextra_general' ) ) ||
			( $task === "check_iprodev_server_contact" && ! wp_verify_nonce( $nonce, 'wgextra_check_iprodev_server_contact' ) )
		) {
			$result = array(
				'status' => 403,
				'message' => __( 'You are not allowed to change WordPress Gallery Extra settings.', 'wordpress-gallery-extra' ) 
			);
		} else {
			$message = '';
			$error   = array();

			if ( $task === "create_new_template" ) {
				$name   = trim( $p['name'] );
				$result = array(
					'status' => 200
				);

				if ( strlen( $name ) > 3 ) {
					$templates = $this->TEMPLATES;
					$uid       = get_current_user_id();
					$user_info = get_userdata( $uid );

					$template       = array_merge( $this->DEFAULT_TEMPLATE_OPTIONS, array( "name" => $name, "uid" => $uid, "lastEdit" => time() ) );
					$templates[]    = $template;
					$templates_keys = array_keys( $templates );
					$id             = end( $templates_keys );

					update_option( "{$this->SLUG}_templates", $templates );
					$this->save_styles( $templates );

					$result['id']          = $id;
					$result['name']        = $name;
					$result['last_modify'] = __( "Now", 'wordpress-gallery-extra' );
					$result['user']        = $user_info->display_name;
					$result['template']    = $this->TEMPLATES_TYPES[$template['template']]['name'];
				} else {
					$result['status']  = 400;
					$result['message'] = __( "Your template name must be at least 3 characters.", 'wordpress-gallery-extra' );
				}
			}

			else if ( $task === "import_template" ) {
				$tid    = trim( $p['id'] );
				$result = array(
					'status' => 200
				);

				if ( strlen( $tid ) > 1 ) {
					$options = $this->OPTIONS;
					$license_id = $options['license_id'];
					$license_nonce = $options['license_nonce'];
					$version = $this->VERSION;

					$response = wp_remote_get( "https://wgextra.iprodev.com/templates/import.php?id=$tid&version=$version&license_id=$license_id&license_nonce=$license_nonce&site=" . urlencode( site_url() ) );

					if ( is_wp_error( $response ) ) {
						$result = array(
							'status' => 400,
							'message' => $response->get_error_message()
						);
					} else {
						$data = json_decode( wp_remote_retrieve_body( $response ), true );
						if ( $data['status'] != 200 ) {
							$result = array(
								'status' => $data['status'],
								'message' => $data['message']
							);
						} else {
							$template  = $data['template']['data'];
							$templates = $this->TEMPLATES;
							$time      = time();
							$uid       = get_current_user_id();
							$user_info = get_userdata( $uid );

							$templates[]    = array_merge( $this->DEFAULT_TEMPLATE_OPTIONS, $template, array( "name" => $data['template']['name'], "uid" => $uid, "lastEdit" => $time ) );
							$templates_keys = array_keys( $templates );
							$id             = end( $templates_keys );

							update_option( "{$this->SLUG}_templates", $templates );
							$this->save_styles( $templates );

							$result['id']          = $id;
							$result['name']        = $data['template']['name'];
							$result['last_modify'] = __( "Now", 'wordpress-gallery-extra' );
							$result['user']        = $user_info->display_name;
							$result['template']    = $this->TEMPLATES_TYPES[$template['template']]['name'];
						}
					}
				} else {
					$result['status']  = 400;
					$result['message'] = __( "Please choose an valid template to import.", 'wordpress-gallery-extra' );
				}
			}

			else if ( $task === "duplicate_template" ) {
				$id     = $p['id'];
				$result = array(
					'status' => 200
				);

				$templates = $this->TEMPLATES;

				if ( !isset( $templates[$id] ) ) {
					wp_send_json( array(
						"status" => 404,
						"message" => __( "Intended template is not exists.", 'wordpress-gallery-extra' )
					) );
				}

				$template  = $templates[$id];
				$time      = time();
				$uid       = get_current_user_id();
				$user_info = get_userdata( $uid );

				$templates[]    = array_merge( $template, array( "uid" => $uid, "lastEdit" => $time ) );
				$templates_keys = array_keys( $templates );
				$dId            = end( $templates_keys );

				update_option( "{$this->SLUG}_templates", $templates );
				$this->save_styles( $templates );

				$result['id']          = $dId;
				$result['name']        = $template['name'];
				$result['user']        = $user_info->display_name;
				$result['last_modify'] = __( "Now", 'wordpress-gallery-extra' );
				$result['template']    = $this->TEMPLATES_TYPES[$template['template']]['name'];
			}

			else if ( $task === "delete_template" ) {
				$id     = $p['id'];
				$result = array(
					'status' => 200
				);

				$templates = $this->TEMPLATES;

				if ( !isset( $templates[$id] ) ) {
					wp_send_json( array(
						"status" => 404,
						"message" => __( "Intended template is not exists.", 'wordpress-gallery-extra' )
					) );
				}

				unset( $templates[$id] );

				update_option( "{$this->SLUG}_templates", $templates );
				$this->save_styles( $templates );
			}

			else if ( $task === "save_template_settings" ) {
				$id        = $p['id'];
				$templates = $this->TEMPLATES;

				if ( !isset( $templates[$id] ) ) {
					wp_send_json( array(
						"status" => 404,
						"message" => __( "Intended template is not exists.", 'wordpress-gallery-extra' )
					) );
				}

				//$options = array_replace_recursive( $this->DEFAULT_TEMPLATE_OPTIONS, $this->array_whitelist_filter( $templates[$id], array( "uid" ) ) );
				$options = $this->DEFAULT_TEMPLATE_OPTIONS;
				$options['uid'] = $templates[$id]['uid'];

				if ( isset( $p['wgextra_name'] ) && strlen( trim( $p['wgextra_name'] ) ) > 3 ) {
					$options['name'] = trim( $p['wgextra_name'] );
				} else {
					$error[] = "<li>" . __( "Your template name must be at least 3 characters.", 'wordpress-gallery-extra' ) . "</li>";
				}

				if ( isset( $p['wgextra_template'] ) ) {
					$options['template'] = $p['wgextra_template'];
				}
				if ( isset( $p['wgextra_structure_type'] ) ) {
					$options['structure_type'] = $p['wgextra_structure_type'];
				}
				if ( isset( $p['wgextra_structure_custom'] ) ) {
					$options['structure_custom'] = $p['wgextra_structure_custom'];
				}
				if ( isset( $p['wgextra_loading_type'] ) ) {
					$options['loading_type'] = $p['wgextra_loading_type'];
				}
				if ( isset( $p['wgextra_use_lowres_image'] ) ) {
					$options['use_lowres_image'] = $p['wgextra_use_lowres_image'];
				}

				if ( isset( $p['wgextra_loading_grid_animation'] ) ) {
					$options['loading_grid_animation'] = $p['wgextra_loading_grid_animation'];
				}

				if ( isset( $p['wgextra_lightbox_type'] ) ) {
					$options['lightbox_type'] = $p['wgextra_lightbox_type'];

					if ( $options['lightbox_type'] === 'magnific' ) {
						$options['lightbox_magnific']['animation']    = $p['wgextra_lightbox_magnific_animation'];
						$options['lightbox_magnific']['vertical_fit'] = ( isset( $p['wgextra_lightbox_magnific_vertical_fit'] ) )  ? "yes" : "no";
						$options['lightbox_magnific']['preload']      = ( isset( $p['wgextra_lightbox_magnific_preload'] ) )       ? "yes" : "no";
						$options['lightbox_magnific']['deeplink']     = ( isset( $p['wgextra_lightbox_magnific_deeplink'] ) )      ? "yes" : "no";
					} else if ( $options['lightbox_type'] === 'photoswipe' ) {
						$options['lightbox_photoswipe']['skin']          = $p['wgextra_lightbox_photoswipe_skin'];
						$options['lightbox_photoswipe']['loop']          = ( isset( $p['wgextra_lightbox_photoswipe_loop'] ) )          ? "yes" : "no";
						$options['lightbox_photoswipe']['deeplink']      = ( isset( $p['wgextra_lightbox_photoswipe_deeplink'] ) )      ? "yes" : "no";
						$options['lightbox_photoswipe']['share_buttons'] = ( isset( $p['wgextra_lightbox_photoswipe_share_buttons'] ) ) ? "yes" : "no";
						$options['lightbox_photoswipe']['download']      = ( isset( $p['wgextra_lightbox_photoswipe_download'] ) )      ? "yes" : "no";
					} else if ( $options['lightbox_type'] === 'fancybox' ) {
						$options['lightbox_fancybox']['animation']  = $p['wgextra_lightbox_fancybox_animation'];
						$options['lightbox_fancybox']['transition'] = $p['wgextra_lightbox_fancybox_transition'];
						$options['lightbox_fancybox']['deeplink']   = ( isset( $p['wgextra_lightbox_fancybox_deeplink'] ) )   ? "yes" : "no";
						$options['lightbox_fancybox']['loop']       = ( isset( $p['wgextra_lightbox_fancybox_loop'] ) )       ? "yes" : "no";
						$options['lightbox_fancybox']['download']   = ( isset( $p['wgextra_lightbox_fancybox_download'] ) )   ? "yes" : "no";
						$options['lightbox_fancybox']['preload']    = ( isset( $p['wgextra_lightbox_fancybox_preload'] ) )    ? "yes" : "no";
					} else if ( $options['lightbox_type'] === 'ilightbox' ) {
						$options['lightbox_ilightbox']['skin']            = $p['wgextra_lightbox_ilightbox_skin'];
						$options['lightbox_ilightbox']['direction']       = $p['wgextra_lightbox_ilightbox_direction'];
						$options['lightbox_ilightbox']['overlay_opacity'] = $p['wgextra_lightbox_ilightbox_overlay_opacity'];
						$options['lightbox_ilightbox']['deeplink']        = ( isset( $p['wgextra_lightbox_ilightbox_deeplink'] ) )      ? "yes" : "no";
						$options['lightbox_ilightbox']['carousel_mode']   = ( isset( $p['wgextra_lightbox_ilightbox_carousel_mode'] ) ) ? "yes" : "no";
						$options['lightbox_ilightbox']['loop']            = ( isset( $p['wgextra_lightbox_ilightbox_loop'] ) )          ? "yes" : "no";
						$options['lightbox_ilightbox']['share_buttons']   = ( isset( $p['wgextra_lightbox_ilightbox_share_buttons'] ) ) ? "yes" : "no";
						$options['lightbox_ilightbox']['thumbnails']      = ( isset( $p['wgextra_lightbox_ilightbox_thumbnails'] ) )    ? "yes" : "no";
					} else if ( $options['lightbox_type'] === 'custom' && isset( $p['wgextra_lightbox'] ) ) {
						$options['lightbox'] = $p['wgextra_lightbox'];
					}
				}

				if ( isset( $p['wgextra_caption_source'] ) ) {
					$options['caption_source'] = $p['wgextra_caption_source'];
				}
				if ( isset( $p['wgextra_custom_caption'] ) ) {
					$options['caption_custom'] = $p['wgextra_custom_caption'];
				}
				if ( isset( $p['wgextra_custom_class'] ) ) {
					$options['custom_class'] = trim( $p['wgextra_custom_class'] );
				}
				if ( isset( $p['wgextra_link_to'] ) ) {
					$options['link']['to'] = $p['wgextra_link_to'];
					$options['link']['target'] = $p['wgextra_link_target'];
					$options['link']['url'] = trim( $p['wgextra_link_url'] );
				}

				/* Slider Settings */
				if ( $options['template'] === 'slider' && ( $this->is_active() || $this->is_extended() ) ) {
					$options['slider_settings']['sizing_method'] = $p['wgextra_slider_settings_sizing_method'];
					$options['slider_settings']['slides_sizing_method'] = $p['wgextra_slider_settings_slides_sizing_method'];
					$options['slider_settings']['mode'] = $p['wgextra_slider_settings_mode'];
					$options['slider_settings']['type'] = $p['wgextra_slider_settings_type'];
					$options['slider_settings']['easing'] = $p['wgextra_slider_settings_easing'];
					$options['slider_settings']['keyboard_navigation'] = $p['wgextra_slider_settings_keyboard_navigation'];
					$options['slider_settings']['cycle_by'] = $p['wgextra_slider_settings_cycle_by'];
					if( isset( $p['wgextra_slider_settings_animation_out'] ) ) {
						$options['slider_settings']['animation_out'] = $p['wgextra_slider_settings_animation_out'];
					}
					if( isset( $p['wgextra_slider_settings_animation_in'] ) ) {
						$options['slider_settings']['animation_in'] = $p['wgextra_slider_settings_animation_in'];
					}
					$options['slider_settings']['kenburns_mode'] = $p['wgextra_slider_settings_kenburns_mode'];

					$options['slider_settings']['auto_scale'] = ( isset( $p['wgextra_slider_settings_auto_scale'] ) ) ? "yes" : "no";
					$options['slider_settings']['start_random'] = ( isset( $p['wgextra_slider_settings_start_random'] ) ) ? "yes" : "no";
					$options['slider_settings']['free_scroll'] = ( isset( $p['wgextra_slider_settings_free_scroll'] ) ) ? "yes" : "no";
					$options['slider_settings']['loop'] = ( isset( $p['wgextra_slider_settings_loop'] ) ) ? "yes" : "no";
					$options['slider_settings']['scrollbar'] = ( isset( $p['wgextra_slider_settings_scrollbar'] ) ) ? "yes" : "no";
					$options['slider_settings']['arrows'] = ( isset( $p['wgextra_slider_settings_arrows'] ) ) ? "yes" : "no";
					$options['slider_settings']['bullets'] = ( isset( $p['wgextra_slider_settings_bullets'] ) ) ? "yes" : "no";
					$options['slider_settings']['thumbnails'] = ( isset( $p['wgextra_slider_settings_thumbnails'] ) ) ? "yes" : "no";
					$options['slider_settings']['repeat_cycling'] = ( isset( $p['wgextra_slider_settings_repeat_cycling'] ) ) ? "yes" : "no";
					$options['slider_settings']['pause_on_hover'] = ( isset( $p['wgextra_slider_settings_pause_on_hover'] ) ) ? "yes" : "no";
					$options['slider_settings']['start_paused'] = ( isset( $p['wgextra_slider_settings_start_paused'] ) ) ? "yes" : "no";
					$options['slider_settings']['mouse_dragging'] = ( isset( $p['wgextra_slider_settings_mouse_dragging'] ) ) ? "yes" : "no";
					$options['slider_settings']['touch_dragging'] = ( isset( $p['wgextra_slider_settings_touch_dragging'] ) ) ? "yes" : "no";
					$options['slider_settings']['release_swing'] = ( isset( $p['wgextra_slider_settings_release_swing'] ) ) ? "yes" : "no";
					$options['slider_settings']['elastic_bounds'] = ( isset( $p['wgextra_slider_settings_elastic_bounds'] ) ) ? "yes" : "no";
					$options['slider_settings']['one_page_drag'] = ( isset( $p['wgextra_slider_settings_one_page_drag'] ) ) ? "yes" : "no";
					$options['slider_settings']['scrollbar_drag_handle'] = ( isset( $p['wgextra_slider_settings_scrollbar_drag_handle'] ) ) ? "yes" : "no";
					$options['slider_settings']['scrollbar_dynamic_handle'] = ( isset( $p['wgextra_slider_settings_scrollbar_dynamic_handle'] ) ) ? "yes" : "no";
					$options['slider_settings']['scrollbar_clickable'] = ( isset( $p['wgextra_slider_settings_scrollbar_clickable'] ) ) ? "yes" : "no";
					$options['slider_settings']['kenburns_reverse'] = ( isset( $p['wgextra_slider_settings_kenburns_reverse'] ) ) ? "yes" : "no";

					/* Check value from "Slider Settings - Width" option */
					if ( $options['slider_settings']['auto_scale'] === 'yes' || $options['slider_settings']['sizing_method'] === 'boxed' ) {
						if ( !is_numeric( $p['wgextra_slider_settings_width'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Width", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['width'] = floatval( $p['wgextra_slider_settings_width'] );
						}
					}
					/* Check value from "Slider Settings - Height" option */
					if ( $options['slider_settings']['auto_scale'] === 'yes' || in_array( $options['slider_settings']['sizing_method'], array( 'boxed', 'fullwidth' ) ) ) {
						if ( !is_numeric( $p['wgextra_slider_settings_height'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Height", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['height'] = floatval( $p['wgextra_slider_settings_height'] );
						}
					}
					/* Check value from "Slider Settings - Start At" option */
					if ( isset( $p['wgextra_slider_settings_start_at'] ) && $p['wgextra_slider_settings_start_at'] !== "" ) {
						if ( !is_numeric( $p['wgextra_slider_settings_start_at'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Start At", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['start_at'] = floatval( $p['wgextra_slider_settings_start_at'] );
						}
					}
					/* Check value from "Slider Settings - Speed" option */
					if ( isset( $p['wgextra_slider_settings_speed'] ) && $p['wgextra_slider_settings_speed'] !== "" ) {
						if ( !is_numeric( $p['wgextra_slider_settings_speed'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Speed", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['speed'] = floatval( $p['wgextra_slider_settings_speed'] );
						}
					}
					/* Check value from "Slider Settings - Scrolling" option */
					if ( isset( $p['wgextra_slider_settings_scrolling'] ) && $p['wgextra_slider_settings_scrolling'] !== "" ) {
						if ( !is_numeric( $p['wgextra_slider_settings_scrolling'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Scrolling", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['scrolling'] = floatval( $p['wgextra_slider_settings_scrolling'] );
						}
					}
					/* Check value from "Slider Settings - Pause Time" option */
					if ( isset( $p['wgextra_slider_settings_pause_time'] ) && $p['wgextra_slider_settings_pause_time'] !== "" ) {
						if ( !is_numeric( $p['wgextra_slider_settings_pause_time'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Pause Time", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['pause_time'] = floatval( $p['wgextra_slider_settings_pause_time'] );
						}
					}
					/* Check value from "Slider Settings - Minimum handle size" option */
					if ( isset( $p['wgextra_slider_settings_scrollbar_min_handle_size'] ) ) {
						if ( !is_numeric( $p['wgextra_slider_settings_scrollbar_min_handle_size'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Minimum handle size", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['scrollbar_min_handle_size'] = floatval( $p['wgextra_slider_settings_scrollbar_min_handle_size'] );
						}
					}
					/* Check value from "Slider Settings - Kenburns Effect - Duration" option */
					if ( isset( $p['wgextra_slider_settings_kenburns_duration'] ) && $p['wgextra_slider_settings_kenburns_duration'] !== "" ) {
						if ( !is_numeric( $p['wgextra_slider_settings_kenburns_duration'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Slider Settings", 'wordpress-gallery-extra' ) . " - " . __( "Kenburns Effect", 'wordpress-gallery-extra' ) . " - " . __( "Duration", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['slider_settings']['kenburns_duration'] = floatval( $p['wgextra_slider_settings_kenburns_duration'] );
						}
					}
				}

				if ( isset( $p['wgextra_tilt_effect'] ) && ( $this->is_active() || $this->is_extended() ) ) {
					$options['tilt_effect'] = $p['wgextra_tilt_effect'];

					if ( $p['wgextra_tilt_effect'] === 'yes' ) {
						$options['tilt_options']['mode'] = $p['wgextra_tilt_options_mode'];
						$options['tilt_options']['axis'] = $p['wgextra_tilt_options_axis'];
						$options['tilt_options']['reset'] = isset( $p['wgextra_tilt_options_reset'] ) ? 'yes' : 'no';

						/* Check values from "Tilt Effect - Max Tilt" option */
						if ( !is_numeric( $p['wgextra_tilt_options_maxtilt'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tilt Effect", 'wordpress-gallery-extra' ) . " - " . __( "Max Tilt", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['tilt_options']['maxtilt'] = floatval( $p['wgextra_tilt_options_maxtilt'] );
						}

						/* Check values from "Tilt Effect - Speed" option */
						if ( !is_numeric( $p['wgextra_tilt_options_speed'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tilt Effect", 'wordpress-gallery-extra' ) . " - " . __( "Speed", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['tilt_options']['speed'] = floatval( $p['wgextra_tilt_options_speed'] );
						}

						/* Check values from "Tilt Effect - Scale" option */
						if ( !is_numeric( $p['wgextra_tilt_options_scale'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tilt Effect", 'wordpress-gallery-extra' ) . " - " . __( "Scale", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['tilt_options']['scale'] = floatval( $p['wgextra_tilt_options_scale'] );
						}

						/* Check values from "Tilt Effect - Glare" option */
						if ( !is_numeric( $p['wgextra_tilt_options_glare'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tilt Effect", 'wordpress-gallery-extra' ) . " - " . __( "Glare", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['tilt_options']['glare'] = floatval( $p['wgextra_tilt_options_glare'] );
						}

						/* Check values from "Tilt Effect - Perspective" option */
						if ( !is_numeric( $p['wgextra_tilt_options_perspective'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tilt Effect", 'wordpress-gallery-extra' ) . " - " . __( "Perspective", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['tilt_options']['perspective'] = floatval( $p['wgextra_tilt_options_perspective'] );
						}
					}
				}


				/* Source */
				if ( isset( $p['wgextra_source'] ) ) {
					$options['source']['source'] = $p['wgextra_source'];
				}
				/* Check value from "Item Number" option */
				if ( isset( $p['wgextra_item_number'] ) ) {
					if ( !is_numeric( $p['wgextra_item_number'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Item Number", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['source']['item_number'] = floatval( $p['wgextra_item_number'] );
					}
				}

				$options['source']['post_types']  = ( isset( $p['wgextra_post_types'] ) )  ? (array) $p['wgextra_post_types']  : array();
				$options['source']['post_status'] = ( isset( $p['wgextra_post_status'] ) ) ? (array) $p['wgextra_post_status'] : array();
				$options['source']['taxonomies']  = ( isset( $p['wgextra_taxonomies'] ) )  ? (array) $p['wgextra_taxonomies']  : array();
				$options['source']['authors']     = ( isset( $p['wgextra_authors'] ) )     ? (array) $p['wgextra_authors']     : array();

				if ( isset( $p['wgextra_taxonomies_relation'] ) )
					$options['source']['taxonomies_relation'] = $p['wgextra_taxonomies_relation'];

				if ( isset( $p['wgextra_authors_relation'] ) )
					$options['source']['authors_relation'] = $p['wgextra_authors_relation'];

				if ( isset( $p['wgextra_exclude_posts'] ) )
					$options['source']['exclude_posts'] = $p['wgextra_exclude_posts'];

				if ( isset( $p['wgextra_include_posts'] ) )
					$options['source']['include_posts'] = $p['wgextra_include_posts'];

				if ( isset( $p['wgextra_ordering_order'] ) )
					$options['source']['ordering']['order'] = $p['wgextra_ordering_order'];

				if ( isset( $p['wgextra_ordering_order_by'] ) )
					$options['source']['ordering']['order_by'] = $p['wgextra_ordering_order_by'];

				if ( isset( $p['wgextra_ordering_order_by_fallback'] ) )
					$options['source']['ordering']['order_by_fallback'] = $p['wgextra_ordering_order_by_fallback'];

				if ( isset( $p['wgextra_ordering_meta_key'] ) )
					$options['source']['ordering']['meta_key'] = $p['wgextra_ordering_meta_key'];


				/* Display */
				if ( isset( $p['wgextra_default_image'] ) ) {
					$options['default_image'] = $p['wgextra_default_image'];
				}
				if ( isset( $p['wgextra_thumbnail_size'] ) ) {
					$options['thumbnail_size'] = $p['wgextra_thumbnail_size'];
				}
				if ( isset( $p['wgextra_last_row'] ) ) {
					$options['last_row'] = $p['wgextra_last_row'];
				}
				if ( isset( $p['wgextra_alignment'] ) ) {
					$options['alignment'] = $p['wgextra_alignment'];
				}
				if ( isset( $p['wgextra_vertical_alignment'] ) ) {
					$options['vertical_alignment'] = $p['wgextra_vertical_alignment'];
				}
				if ( isset( $p['wgextra_mosaic_type'] ) ) {
					$options['mosaic_type'] = $p['wgextra_mosaic_type'];
				}
				if ( isset( $p['wgextra_thumbnail_ratio'] ) ) {
					$options['thumbnail_ratio']['type'] = $p['wgextra_thumbnail_ratio'];
				}
				if ( isset( $p['wgextra_thumbnail_ratio_size'] ) ) {
					$options['thumbnail_ratio']['size'] = (array) array_map( 'floatval', $p['wgextra_thumbnail_ratio_size'] );
				}
				$options['thumbnail_ratio']['force'] = ( isset( $p['wgextra_thumbnail_ratio_force'] ) ) ? "yes" : "no";
				$options['detect_focus_point']       = ( isset( $p['wgextra_detect_focus_point'] ) )    ? "yes" : "no";
				if ( isset( $p['wgextra_grouped_items_mode'] ) ) {
					$options['grouped_items']['mode'] = $p['wgextra_grouped_items_mode'];
					if ( $options['grouped_items']['mode'] === 'slider' ) {
						$options['grouped_items']['template'] = $p['wgextra_grouped_items_template'];
					}
				}

				/* Check value from "Columns" option */
				if ( isset( $p['wgextra_columns'] ) ) {
					if ( !is_numeric( $p['wgextra_columns'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Columns", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['columns'] = floatval( $p['wgextra_columns'] );
					}
				}

				/* Check value from "Row Height" option */
				if ( isset( $p['wgextra_row_height'] ) ) {
					if ( !is_numeric( $p['wgextra_row_height'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['row_height'] = floatval( $p['wgextra_row_height'] );
					}
				}

				/* Check value from "Max Row Height" option */
				if ( isset( $p['wgextra_max_row_height'] ) ) {
					if ( !is_numeric( $p['wgextra_max_row_height'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Max Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['max_row_height'] = floatval( $p['wgextra_max_row_height'] ) . $p['wgextra_max_row_height_unit'];
					}
				}

				/* Check value from "Desktop - Browser Width" option */
				if ( isset( $p['wgextra_responsive_desktop_size'] ) ) {
					if ( !is_numeric( $p['wgextra_responsive_desktop_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Desktop", 'wordpress-gallery-extra' ) . " - " . __( "Browser Width", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['desktop']['size'] = floatval( $p['wgextra_responsive_desktop_size'] );
					}
				}

				if ( in_array( $p['wgextra_template'], array( "columns", "masonry", "slider" ) ) ) {
					/* Check value from "Laptop Large - Columns" option */
					if ( isset( $p['wgextra_responsive_laptop_large_columns'] ) ) {
						if ( !empty( $p['wgextra_responsive_laptop_large_columns'] ) && !is_numeric( $p['wgextra_responsive_laptop_large_columns'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop Large", 'wordpress-gallery-extra' ) . " - " . __( "Columns", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['laptop_large']['columns'] = is_numeric( $p['wgextra_responsive_laptop_large_columns'] ) ? floatval( $p['wgextra_responsive_laptop_large_columns'] ) : '';
						}
					}

					/* Check value from "Laptop - Columns" option */
					if ( isset( $p['wgextra_responsive_laptop_columns'] ) ) {
						if ( !empty( $p['wgextra_responsive_laptop_columns'] ) && !is_numeric( $p['wgextra_responsive_laptop_columns'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop", 'wordpress-gallery-extra' ) . " - " . __( "Columns", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['laptop']['columns'] = is_numeric( $p['wgextra_responsive_laptop_columns'] ) ? floatval( $p['wgextra_responsive_laptop_columns'] ) : '';
						}
					}

					/* Check value from "Tablet - Columns" option */
					if ( isset( $p['wgextra_responsive_tablet_columns'] ) ) {
						if ( !empty( $p['wgextra_responsive_tablet_columns'] ) && !is_numeric( $p['wgextra_responsive_tablet_columns'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet", 'wordpress-gallery-extra' ) . " - " . __( "Columns", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['tablet']['columns'] = is_numeric( $p['wgextra_responsive_tablet_columns'] ) ? floatval( $p['wgextra_responsive_tablet_columns'] ) : '';
						}
					}

					/* Check value from "Tablet Small - Columns" option */
					if ( isset( $p['wgextra_responsive_tablet_small_columns'] ) ) {
						if ( !empty( $p['wgextra_responsive_tablet_small_columns'] ) && !is_numeric( $p['wgextra_responsive_tablet_small_columns'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet Small", 'wordpress-gallery-extra' ) . " - " . __( "Columns", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['tablet_small']['columns'] = is_numeric( $p['wgextra_responsive_tablet_small_columns'] ) ? floatval( $p['wgextra_responsive_tablet_small_columns'] ) : '';
						}
					}

					/* Check value from "Mobile - Columns" option */
					if ( isset( $p['wgextra_responsive_mobile_columns'] ) ) {
						if ( !empty( $p['wgextra_responsive_mobile_columns'] ) && !is_numeric( $p['wgextra_responsive_mobile_columns'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Mobile", 'wordpress-gallery-extra' ) . " - " . __( "Columns", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['mobile']['columns'] = is_numeric( $p['wgextra_responsive_mobile_columns'] ) ? floatval( $p['wgextra_responsive_mobile_columns'] ) : '';
						}
					}
				} else if ( $p['wgextra_template'] === 'justified' ) {
					/* Check value from "Laptop Large - Row Height" option */
					if ( isset( $p['wgextra_responsive_laptop_large_row_height'] ) ) {
						if ( !empty( $p['wgextra_responsive_laptop_large_row_height'] ) && !is_numeric( $p['wgextra_responsive_laptop_large_row_height'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop Large", 'wordpress-gallery-extra' ) . " - " . __( "Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['laptop_large']['row_height'] = is_numeric( $p['wgextra_responsive_laptop_large_row_height'] ) ? floatval( $p['wgextra_responsive_laptop_large_row_height'] ) : '';
						}
					}

					/* Check value from "Laptop - Row Height" option */
					if ( isset( $p['wgextra_responsive_laptop_row_height'] ) ) {
						if ( !empty( $p['wgextra_responsive_laptop_row_height'] ) && !is_numeric( $p['wgextra_responsive_laptop_row_height'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop", 'wordpress-gallery-extra' ) . " - " . __( "Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['laptop']['row_height'] = is_numeric( $p['wgextra_responsive_laptop_row_height'] ) ? floatval( $p['wgextra_responsive_laptop_row_height'] ) : '';
						}
					}

					/* Check value from "Tablet - Row Height" option */
					if ( isset( $p['wgextra_responsive_tablet_row_height'] ) ) {
						if ( !empty( $p['wgextra_responsive_tablet_row_height'] ) && !is_numeric( $p['wgextra_responsive_tablet_row_height'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet", 'wordpress-gallery-extra' ) . " - " . __( "Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['tablet']['row_height'] = is_numeric( $p['wgextra_responsive_tablet_row_height'] ) ? floatval( $p['wgextra_responsive_tablet_row_height'] ) : '';
						}
					}

					/* Check value from "Tablet Small - Row Height" option */
					if ( isset( $p['wgextra_responsive_tablet_small_row_height'] ) ) {
						if ( !empty( $p['wgextra_responsive_tablet_small_row_height'] ) && !is_numeric( $p['wgextra_responsive_tablet_small_row_height'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet Small", 'wordpress-gallery-extra' ) . " - " . __( "Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['tablet_small']['row_height'] = is_numeric( $p['wgextra_responsive_tablet_small_row_height'] ) ? floatval( $p['wgextra_responsive_tablet_small_row_height'] ) : '';
						}
					}

					/* Check value from "Mobile - Row Height" option */
					if ( isset( $p['wgextra_responsive_mobile_row_height'] ) ) {
						if ( !empty( $p['wgextra_responsive_mobile_row_height'] ) && !is_numeric( $p['wgextra_responsive_mobile_row_height'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Mobile", 'wordpress-gallery-extra' ) . " - " . __( "Row Height", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['responsive']['mobile']['row_height'] = is_numeric( $p['wgextra_responsive_mobile_row_height'] ) ? floatval( $p['wgextra_responsive_mobile_row_height'] ) : '';
						}
					}
				}

				/* Check value from "Laptop Large - Browser Width" option */
				if ( isset( $p['wgextra_responsive_laptop_large_size'] ) ) {
					if ( !is_numeric( $p['wgextra_responsive_laptop_large_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop Large", 'wordpress-gallery-extra' ) . " - " . __( "Browser Width", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['laptop_large']['size'] = floatval( $p['wgextra_responsive_laptop_large_size'] );
					}
				}
				/* Check value from "Laptop Large - Spacing" option */
				if ( isset( $p['wgextra_responsive_laptop_large_spacing'] ) ) {
					if ( !empty( $p['wgextra_responsive_laptop_large_spacing'] ) && !is_numeric( $p['wgextra_responsive_laptop_large_spacing'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop Large", 'wordpress-gallery-extra' ) . " - " . __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['laptop_large']['spacing'] = is_numeric( $p['wgextra_responsive_laptop_large_spacing'] ) ? floatval( $p['wgextra_responsive_laptop_large_spacing'] ) : '';
					}
				}
				/* Check value from "Laptop Large - Icon Size" option */
				if ( isset( $p['wgextra_responsive_laptop_large_icon_size'] ) ) {
					if ( !empty( $p['wgextra_responsive_laptop_large_icon_size'] ) && !is_numeric( $p['wgextra_responsive_laptop_large_icon_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop Large", 'wordpress-gallery-extra' ) . " - " . __( "Icon Size", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['laptop_large']['icon_size'] = is_numeric( $p['wgextra_responsive_laptop_large_icon_size'] ) ? floatval( $p['wgextra_responsive_laptop_large_icon_size'] ) : '';
					}
				}

				/* Check value from "Laptop - Browser Width" option */
				if ( isset( $p['wgextra_responsive_laptop_size'] ) ) {
					if ( !is_numeric( $p['wgextra_responsive_laptop_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop", 'wordpress-gallery-extra' ) . " - " . __( "Browser Width", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['laptop']['size'] = floatval( $p['wgextra_responsive_laptop_size'] );
					}
				}
				/* Check value from "Laptop - Spacing" option */
				if ( isset( $p['wgextra_responsive_laptop_spacing'] ) ) {
					if ( !empty( $p['wgextra_responsive_laptop_spacing'] ) && !is_numeric( $p['wgextra_responsive_laptop_spacing'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop", 'wordpress-gallery-extra' ) . " - " . __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['laptop']['spacing'] = is_numeric( $p['wgextra_responsive_laptop_spacing'] ) ? floatval( $p['wgextra_responsive_laptop_spacing'] ) : '';
					}
				}
				/* Check value from "Laptop - Icon Size" option */
				if ( isset( $p['wgextra_responsive_laptop_icon_size'] ) ) {
					if ( !empty( $p['wgextra_responsive_laptop_icon_size'] ) && !is_numeric( $p['wgextra_responsive_laptop_icon_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Laptop", 'wordpress-gallery-extra' ) . " - " . __( "Icon Size", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['laptop']['icon_size'] = is_numeric( $p['wgextra_responsive_laptop_icon_size'] ) ? floatval( $p['wgextra_responsive_laptop_icon_size'] ) : '';
					}
				}

				/* Check value from "Tablet - Browser Width" option */
				if ( isset( $p['wgextra_responsive_tablet_size'] ) ) {
					if ( !is_numeric( $p['wgextra_responsive_tablet_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet", 'wordpress-gallery-extra' ) . " - " . __( "Browser Width", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['tablet']['size'] = floatval( $p['wgextra_responsive_tablet_size'] );
					}
				}
				/* Check value from "Tablet - Spacing" option */
				if ( isset( $p['wgextra_responsive_tablet_spacing'] ) ) {
					if ( !empty( $p['wgextra_responsive_tablet_spacing'] ) && !is_numeric( $p['wgextra_responsive_tablet_spacing'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet", 'wordpress-gallery-extra' ) . " - " . __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['tablet']['spacing'] = is_numeric( $p['wgextra_responsive_tablet_spacing'] ) ? floatval( $p['wgextra_responsive_tablet_spacing'] ) : '';
					}
				}
				/* Check value from "Tablet - Icon Size" option */
				if ( isset( $p['wgextra_responsive_tablet_icon_size'] ) ) {
					if ( !empty( $p['wgextra_responsive_tablet_icon_size'] ) && !is_numeric( $p['wgextra_responsive_tablet_icon_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet", 'wordpress-gallery-extra' ) . " - " . __( "Icon Size", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['tablet']['icon_size'] = is_numeric( $p['wgextra_responsive_tablet_icon_size'] ) ? floatval( $p['wgextra_responsive_tablet_icon_size'] ) : '';
					}
				}

				/* Check value from "Tablet Small - Browser Width" option */
				if ( isset( $p['wgextra_responsive_tablet_small_size'] ) ) {
					if ( !is_numeric( $p['wgextra_responsive_tablet_small_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet Small", 'wordpress-gallery-extra' ) . " - " . __( "Browser Width", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['tablet_small']['size'] = floatval( $p['wgextra_responsive_tablet_small_size'] );
					}
				}
				/* Check value from "Tablet Small - Spacing" option */
				if ( isset( $p['wgextra_responsive_tablet_small_spacing'] ) ) {
					if ( !empty( $p['wgextra_responsive_tablet_small_spacing'] ) && !is_numeric( $p['wgextra_responsive_tablet_small_spacing'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet Small", 'wordpress-gallery-extra' ) . " - " . __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['tablet_small']['spacing'] = is_numeric( $p['wgextra_responsive_tablet_small_spacing'] ) ? floatval( $p['wgextra_responsive_tablet_small_spacing'] ) : '';
					}
				}
				/* Check value from "Tablet Small - Icon Size" option */
				if ( isset( $p['wgextra_responsive_tablet_small_icon_size'] ) ) {
					if ( !empty( $p['wgextra_responsive_tablet_small_icon_size'] ) && !is_numeric( $p['wgextra_responsive_tablet_small_icon_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Tablet Small", 'wordpress-gallery-extra' ) . " - " . __( "Icon Size", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['tablet_small']['icon_size'] = is_numeric( $p['wgextra_responsive_tablet_small_icon_size'] ) ? floatval( $p['wgextra_responsive_tablet_small_icon_size'] ) : '';
					}
				}

				/* Check value from "Mobile - Spacing" option */
				if ( isset( $p['wgextra_responsive_mobile_spacing'] ) ) {
					if ( !empty( $p['wgextra_responsive_mobile_spacing'] ) && !is_numeric( $p['wgextra_responsive_mobile_spacing'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Mobile", 'wordpress-gallery-extra' ) . " - " . __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['mobile']['spacing'] = is_numeric( $p['wgextra_responsive_mobile_spacing'] ) ? floatval( $p['wgextra_responsive_mobile_spacing'] ) : '';
					}
				}
				/* Check value from "Mobile - Icon Size" option */
				if ( isset( $p['wgextra_responsive_mobile_icon_size'] ) ) {
					if ( !empty( $p['wgextra_responsive_mobile_icon_size'] ) && !is_numeric( $p['wgextra_responsive_mobile_icon_size'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Mobile", 'wordpress-gallery-extra' ) . " - " . __( "Icon Size", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['responsive']['mobile']['icon_size'] = is_numeric( $p['wgextra_responsive_mobile_icon_size'] ) ? floatval( $p['wgextra_responsive_mobile_icon_size'] ) : '';
					}
				}



				/* Styles */
				if ( isset( $p['wgextra_style'] ) ) {
					$options['styles']['defined'] = $p['wgextra_style'];
				}

				if ( isset( $p['wgextra_style_thumbnail_effect'] ) ) {
					$options['styles']['thumbnail_effect']['effect'] = $p['wgextra_style_thumbnail_effect'];
					$options['styles']['thumbnail_effect']['transition']['easing'] = $p['wgextra_style_thumbnail_effect_transition_easing'];

					/* Check value from "Thumbnail Effect Speed" option */
					if ( isset( $p['wgextra_style_thumbnail_effect_transition_speed'] ) ) {
						if ( !is_numeric( $p['wgextra_style_thumbnail_effect_transition_speed'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Thumbnail Effect", 'wordpress-gallery-extra' ) . " - " . __( "Speed", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['thumbnail_effect']['transition']['speed'] = floatval( $p['wgextra_style_thumbnail_effect_transition_speed'] );
						}
					}
					/* Check value from "Thumbnail Effect Delay" option */
					if ( isset( $p['wgextra_style_thumbnail_effect_transition_delay'] ) ) {
						if ( !is_numeric( $p['wgextra_style_thumbnail_effect_transition_delay'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Thumbnail Effect", 'wordpress-gallery-extra' ) . " - " . __( "Delay", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['thumbnail_effect']['transition']['delay'] = floatval( $p['wgextra_style_thumbnail_effect_transition_delay'] );
						}
					}
				}

				$options['styles']['has_border']      = isset( $p['wgextra_style_border'] )          ? 'yes' : 'no';
				$options['styles']['has_shadow']      = isset( $p['wgextra_style_shadow'] )          ? 'yes' : 'no';
				$options['styles']['has_icon']        = isset( $p['wgextra_style_icon'] )            ? 'yes' : 'no';
				$options['styles']['has_caption']     = isset( $p['wgextra_style_caption'] )         ? 'yes' : 'no';
				$options['styles']['has_overlay']     = isset( $p['wgextra_style_overlay'] )         ? 'yes' : 'no';
				$options['styles']['use_placeholder'] = isset( $p['wgextra_style_use_placeholder'] ) ? 'yes' : 'no';

				if ( isset( $p['wgextra_style_embed_google_fonts'] ) ) {
					$options['styles']['embed_google_fonts'] = $p['wgextra_style_embed_google_fonts'];
				}

				if ( isset( $p['wgextra_style_custom_css'] ) ) {
					$options['styles']['custom_css'] = $p['wgextra_style_custom_css'];
				}

				// Border style
				if ( $options['styles']['has_border'] === 'yes' ) {
					/* Check value from "Border Radius" option */
					if ( isset( $p['wgextra_style_border_radius'] ) ) {
						if ( !is_numeric( $p['wgextra_style_border_radius'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Border Radius", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['border']['radius'] = floatval( $p['wgextra_style_border_radius'] );
						}
					}
					/* Check value from "Border Weight" option */
					if ( isset( $p['wgextra_style_border_weight'] ) ) {
						if ( !is_numeric( $p['wgextra_style_border_weight'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Border Weight", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['border']['weight'] = floatval( $p['wgextra_style_border_weight'] );
						}
					}
					if ( isset( $p['wgextra_style_border_style'] ) ) {
						$options['styles']['border']['style'] = $p['wgextra_style_border_style'];
					}
					if ( isset( $p['wgextra_style_border_color'] ) ) {
						$options['styles']['border']['color'] = $p['wgextra_style_border_color'];
					}
				}

				// Shadow style
				if ( $options['styles']['has_shadow'] === 'yes' ) {
					/* Check value from "Shadow X-offset" option */
					if ( isset( $p['wgextra_style_shadow_x'] ) ) {
						if ( !is_numeric( $p['wgextra_style_shadow_x'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Shadow X-offset", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['shadow']['x'] = floatval( $p['wgextra_style_shadow_x'] );
						}
					}
					/* Check value from "Shadow Y-offset" option */
					if ( isset( $p['wgextra_style_shadow_y'] ) ) {
						if ( !is_numeric( $p['wgextra_style_shadow_y'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Shadow Y-offset", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['shadow']['y'] = floatval( $p['wgextra_style_shadow_y'] );
						}
					}
					/* Check value from "Shadow Blur" option */
					if ( isset( $p['wgextra_style_shadow_blur'] ) ) {
						if ( !is_numeric( $p['wgextra_style_shadow_blur'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Shadow Blur", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['shadow']['blur'] = floatval( $p['wgextra_style_shadow_blur'] );
						}
					}
					/* Check value from "Shadow Spread" option */
					if ( isset( $p['wgextra_style_shadow_spread'] ) ) {
						if ( !is_numeric( $p['wgextra_style_shadow_spread'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Shadow Spread", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['shadow']['spread'] = floatval( $p['wgextra_style_shadow_spread'] );
						}
					}
					if ( isset( $p['wgextra_style_shadow_color'] ) ) {
						$options['styles']['shadow']['color'] = $p['wgextra_style_shadow_color'];
					}
					$options['styles']['shadow']['inset'] = ( isset( $p['wgextra_style_shadow_inset'] ) )  ? "yes" : "no";
				}

				// Placeholder style
				if ( $options['styles']['use_placeholder'] === 'yes' ) {
					$options['styles']['placeholder']['overlay']        = ( isset( $p['wgextra_style_placeholder_overlay'] ) )         ? "yes" : "no";
					$options['styles']['placeholder']['readable_caption'] = ( isset( $p['wgextra_style_placeholder_readable_caption'] ) )  ? "yes" : "no";
					$options['styles']['placeholder']['background']     = ( isset( $p['wgextra_style_placeholder_background'] ) )      ? "yes" : "no";
				}

				/* Check value from "Spacing" option */
				if ( isset( $p['wgextra_style_margin'] ) ) {
					if ( !is_numeric( $p['wgextra_style_margin'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['styles']['margin'] = floatval( $p['wgextra_style_margin'] );
					}
				}

				// Hover type styles
				if ( $options['styles']['has_icon'] === 'yes' ) {
					if ( isset( $p['wgextra_style_icon_icon'] ) ) {
						$options['styles']['icon']['icon'] = $p['wgextra_style_icon_icon'];
					}
					if ( isset( $p['wgextra_style_icon_visibility'] ) ) {
						$options['styles']['icon']['visibility'] = $p['wgextra_style_icon_visibility'];
					}
					if ( isset( $p['wgextra_style_icon_color'] ) ) {
						$options['styles']['icon']['color'] = $p['wgextra_style_icon_color'];
					}
					if ( isset( $p['wgextra_style_icon_transition_easing'] ) ) {
						$options['styles']['icon']['transition']['easing'] = $p['wgextra_style_icon_transition_easing'];
					}
					/* Check value from "Icon Size" option */
					if ( isset( $p['wgextra_style_icon_size'] ) ) {
						if ( !is_numeric( $p['wgextra_style_icon_size'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Icon", 'wordpress-gallery-extra' ) . " - " . __( "Size", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['icon']['size'] = floatval( $p['wgextra_style_icon_size'] );
						}
					}
					/* Check value from "Icon Speed" option */
					if ( isset( $p['wgextra_style_icon_transition_speed'] ) ) {
						if ( !is_numeric( $p['wgextra_style_icon_transition_speed'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Icon", 'wordpress-gallery-extra' ) . " - " . __( "Speed", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['icon']['transition']['speed'] = floatval( $p['wgextra_style_icon_transition_speed'] );
						}
					}
					/* Check value from "Icon Delay" option */
					if ( isset( $p['wgextra_style_icon_transition_delay'] ) ) {
						if ( !is_numeric( $p['wgextra_style_icon_transition_delay'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Icon", 'wordpress-gallery-extra' ) . " - " . __( "Delay", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['icon']['transition']['delay'] = floatval( $p['wgextra_style_icon_transition_delay'] );
						}
					}
				}

				if ( $options['styles']['has_caption'] === 'yes' ) {
					$options['styles']['caption']['inset'] = isset( $p['wgextra_style_caption_inset'] ) ? 'yes' : 'no';

					if ( isset( $p['wgextra_style_caption_color'] ) ) {
						$options['styles']['caption']['color'] = $p['wgextra_style_caption_color'];
					}
					if ( isset( $p['wgextra_style_caption_position'] ) ) {
						$options['styles']['caption']['position'] = $p['wgextra_style_caption_position'];
					}
					if ( isset( $p['wgextra_style_caption_visibility'] ) ) {
						$options['styles']['caption']['visibility'] = $p['wgextra_style_caption_visibility'];
					}
					if ( isset( $p['wgextra_style_caption_transition_easing'] ) ) {
						$options['styles']['caption']['transition']['easing'] = $p['wgextra_style_caption_transition_easing'];
					}
					if ( isset( $p['wgextra_style_caption_background'] ) ) {
						$options['styles']['caption']['background']['type'] = $p['wgextra_style_caption_background'];
					}

					if ( $options['styles']['caption']['background']['type'] === 'solid' ) {
						if ( isset( $p['wgextra_style_caption_background_solid_color'] ) ) {
							$options['styles']['caption']['background']['solid']['color'] = $p['wgextra_style_caption_background_solid_color'];
						}
					} else if ( $options['styles']['caption']['background']['type'] === 'gradient' ) {
						if ( isset( $p['wgextra_style_caption_background_gradient_start_color'] ) ) {
							$options['styles']['caption']['background']['gradient']['start_color'] = $p['wgextra_style_caption_background_gradient_start_color'];
						}
						if ( isset( $p['wgextra_style_caption_background_gradient_stop_color'] ) ) {
							$options['styles']['caption']['background']['gradient']['stop_color'] = $p['wgextra_style_caption_background_gradient_stop_color'];
						}
						if ( isset( $p['wgextra_style_caption_background_gradient_orientation'] ) ) {
							$options['styles']['caption']['background']['gradient']['orientation'] = $p['wgextra_style_caption_background_gradient_orientation'];
						}
					}

					/* Check value from "Caption Speed" option */
					if ( isset( $p['wgextra_style_caption_transition_speed'] ) ) {
						if ( !is_numeric( $p['wgextra_style_caption_transition_speed'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Caption", 'wordpress-gallery-extra' ) . " - " . __( "Speed", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['caption']['transition']['speed'] = floatval( $p['wgextra_style_caption_transition_speed'] );
						}
					}
					/* Check value from "Caption Delay" option */
					if ( isset( $p['wgextra_style_caption_transition_delay'] ) ) {
						if ( !is_numeric( $p['wgextra_style_caption_transition_delay'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Caption", 'wordpress-gallery-extra' ) . " - " . __( "Delay", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['caption']['transition']['delay'] = floatval( $p['wgextra_style_caption_transition_delay'] );
						}
					}
				}

				// Handle overlay styles
				if ( $options['styles']['has_overlay'] === 'yes' ) {
					if ( isset( $p['wgextra_style_overlay_visibility'] ) ) {
						$options['styles']['overlay']['visibility'] = $p['wgextra_style_overlay_visibility'];
					}
					if ( isset( $p['wgextra_style_overlay_background'] ) ) {
						$options['styles']['overlay']['background']['type'] = $p['wgextra_style_overlay_background'];
					}
					if ( isset( $p['wgextra_style_overlay_transition_easing'] ) ) {
						$options['styles']['overlay']['transition']['easing'] = $p['wgextra_style_overlay_transition_easing'];
					}

					if ( $options['styles']['overlay']['background']['type'] === 'solid' ) {
						if ( isset( $p['wgextra_style_overlay_background_solid_color'] ) ) {
							$options['styles']['overlay']['background']['solid']['color'] = $p['wgextra_style_overlay_background_solid_color'];
						}
					} else if ( $options['styles']['overlay']['background']['type'] === 'gradient' ) {
						if ( isset( $p['wgextra_style_overlay_background_gradient_start_color'] ) ) {
							$options['styles']['overlay']['background']['gradient']['start_color'] = $p['wgextra_style_overlay_background_gradient_start_color'];
						}
						if ( isset( $p['wgextra_style_overlay_background_gradient_stop_color'] ) ) {
							$options['styles']['overlay']['background']['gradient']['stop_color'] = $p['wgextra_style_overlay_background_gradient_stop_color'];
						}
						if ( isset( $p['wgextra_style_overlay_background_gradient_orientation'] ) ) {
							$options['styles']['overlay']['background']['gradient']['orientation'] = $p['wgextra_style_overlay_background_gradient_orientation'];
						}
					}
					/* Check value from "Overlay Speed" option */
					if ( isset( $p['wgextra_style_overlay_transition_speed'] ) ) {
						if ( !is_numeric( $p['wgextra_style_overlay_transition_speed'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Overlay", 'wordpress-gallery-extra' ) . " - " . __( "Speed", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['overlay']['transition']['speed'] = floatval( $p['wgextra_style_overlay_transition_speed'] );
						}
					}
					/* Check value from "Overlay Delay" option */
					if ( isset( $p['wgextra_style_overlay_transition_delay'] ) ) {
						if ( !is_numeric( $p['wgextra_style_overlay_transition_delay'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Overlay", 'wordpress-gallery-extra' ) . " - " . __( "Delay", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['overlay']['transition']['delay'] = floatval( $p['wgextra_style_overlay_transition_delay'] );
						}
					}
				}

				// Handle slider styles
				if ( $options['template'] === 'slider' && ( $this->is_active() || $this->is_extended() ) ) {
					$options['styles']['slider']['arrows']['skin']                = $p['wgextra_style_slider_arrows_skin'];
					$options['styles']['slider']['scrollbar']['skin']             = $p['wgextra_style_slider_scrollbar_skin'];
					$options['styles']['slider']['thumbnails']['skin']            = $p['wgextra_style_slider_thumbnails_skin'];
					$options['styles']['slider']['thumbnails']['position']        = $p['wgextra_style_slider_thumbnails_position'];
					$options['styles']['slider']['bullets']['skin']               = $p['wgextra_style_slider_bullets_skin'];
					$options['styles']['slider']['time_loader']['skin']           = $p['wgextra_style_slider_time_loader_skin'];
					$options['styles']['slider']['time_loader']['appearance']     = $p['wgextra_style_slider_time_loader_appearance'];
					$options['styles']['slider']['time_loader']['position']       = $p['wgextra_style_slider_time_loader_position'];
					$options['styles']['slider']['time_loader']['line_cap']       = $p['wgextra_style_slider_time_loader_line_cap'];
					$options['styles']['slider']['time_loader']['reverse']        = $p['wgextra_style_slider_time_loader_reverse'];
					$options['styles']['slider']['time_loader']['counter']        = $p['wgextra_style_slider_time_loader_counter'];

					$options['styles']['slider']['arrows']['hide']                = isset( $p['wgextra_style_slider_arrows_hide'] )                 ? 'yes' : 'no';
					$options['styles']['slider']['scrollbar']['hide']             = isset( $p['wgextra_style_slider_scrollbar_hide'] )             ? 'yes' : 'no';
					$options['styles']['slider']['scrollbar']['inside']           = isset( $p['wgextra_style_slider_scrollbar_inside'] )           ? 'yes' : 'no';
					$options['styles']['slider']['thumbnails']['hide']            = isset( $p['wgextra_style_slider_thumbnails_hide'] )            ? 'yes' : 'no';
					$options['styles']['slider']['thumbnails']['inside']          = isset( $p['wgextra_style_slider_thumbnails_inside'] )          ? 'yes' : 'no';
					$options['styles']['slider']['bullets']['hide']               = isset( $p['wgextra_style_slider_bullets_hide'] )               ? 'yes' : 'no';
					$options['styles']['slider']['bullets']['inside']             = isset( $p['wgextra_style_slider_bullets_inside'] )             ? 'yes' : 'no';
					$options['styles']['slider']['time_loader']['hide']           = isset( $p['wgextra_style_slider_time_loader_hide'] )           ? 'yes' : 'no';
					$options['styles']['slider']['time_loader']['toggle_cycling'] = isset( $p['wgextra_style_slider_time_loader_toggle_cycling'] ) ? 'yes' : 'no';

					/* Check value from "Buttons styles - Hide under this window width" option */
					if ( isset( $p['wgextra_style_slider_arrows_under'] ) && !empty( $p['wgextra_style_slider_arrows_under'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_arrows_under'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Buttons styles", 'wordpress-gallery-extra' ) . " - " . __( "Hide under this window width", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['arrows']['under'] = floatval( $p['wgextra_style_slider_arrows_under'] );
							$options['styles']['slider']['arrows']['under_unit'] = $p['wgextra_style_slider_arrows_under_unit'];
						}
					}

					/* Check value from "Scrollbar styles - Hide under this window width" option */
					if ( isset( $p['wgextra_style_slider_scrollbar_under'] ) && !empty( $p['wgextra_style_slider_scrollbar_under'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_scrollbar_under'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Scrollbar styles", 'wordpress-gallery-extra' ) . " - " . __( "Hide under this window width", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['scrollbar']['under'] = floatval( $p['wgextra_style_slider_scrollbar_under'] );
							$options['styles']['slider']['scrollbar']['under_unit'] = $p['wgextra_style_slider_scrollbar_under_unit'];
						}
					}

					/* Check value from "Thumbnails styles - Hide under this window width" option */
					if ( isset( $p['wgextra_style_slider_thumbnails_under'] ) && !empty( $p['wgextra_style_slider_thumbnails_under'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_thumbnails_under'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Thumbnails styles", 'wordpress-gallery-extra' ) . " - " . __( "Hide under this window width", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['thumbnails']['under'] = floatval( $p['wgextra_style_slider_thumbnails_under'] );
							$options['styles']['slider']['thumbnails']['under_unit'] = $p['wgextra_style_slider_thumbnails_under_unit'];
						}
					}

					/* Check value from "Thumbnails styles - Spacing" option */
					if ( isset( $p['wgextra_style_slider_thumbnails_spacing'] ) && !empty( $p['wgextra_style_slider_thumbnails_spacing'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_thumbnails_spacing'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Thumbnails styles", 'wordpress-gallery-extra' ) . " - " . __( "Spacing", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['thumbnails']['spacing'] = floatval( $p['wgextra_style_slider_thumbnails_spacing'] );
							$options['styles']['slider']['thumbnails']['spacing_unit'] = $p['wgextra_style_slider_thumbnails_spacing_unit'];
						}
					}

					/* Check value from "Thumbnails styles - Size" option */
					if ( isset( $p['wgextra_style_slider_thumbnails_size'] ) && !empty( $p['wgextra_style_slider_thumbnails_size'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_thumbnails_size'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Thumbnails styles", 'wordpress-gallery-extra' ) . " - " . __( "Size", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['thumbnails']['size'] = floatval( $p['wgextra_style_slider_thumbnails_size'] );
							$options['styles']['slider']['thumbnails']['size_unit'] = $p['wgextra_style_slider_thumbnails_size_unit'];
						}
					}

					/* Check value from "Bullets styles - Hide under this window width" option */
					if ( isset( $p['wgextra_style_slider_bullets_under'] ) && !empty( $p['wgextra_style_slider_bullets_under'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_bullets_under'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Bullets styles", 'wordpress-gallery-extra' ) . " - " . __( "Hide under this window width", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['bullets']['under'] = floatval( $p['wgextra_style_slider_bullets_under'] );
							$options['styles']['slider']['bullets']['under_unit'] = $p['wgextra_style_slider_bullets_under_unit'];
						}
					}

					/* Check value from "Time Loader styles - Hide under this window width" option */
					if ( isset( $p['wgextra_style_slider_time_loader_under'] ) && !empty( $p['wgextra_style_slider_time_loader_under'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_under'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Bullets styles", 'wordpress-gallery-extra' ) . " - " . __( "Hide under this window width", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['under'] = floatval( $p['wgextra_style_slider_time_loader_under'] );
							$options['styles']['slider']['time_loader']['under_unit'] = $p['wgextra_style_slider_time_loader_under_unit'];
						}
					}

					/* Check value from "Scrollbar styles - Scrollbar size" option */
					if ( isset( $p['wgextra_style_slider_scrollbar_size'] ) && !empty( $p['wgextra_style_slider_scrollbar_size'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_scrollbar_size'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Scrollbar styles", 'wordpress-gallery-extra' ) . " - " . __( "Scrollbar size", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['scrollbar']['size'] = floatval( $p['wgextra_style_slider_scrollbar_size'] );
							$options['styles']['slider']['scrollbar']['size_unit'] = $p['wgextra_style_slider_scrollbar_size_unit'];
						}
					}


					if ( isset( $p['wgextra_style_slider_scrollbar_track_color'] ) ) {
						$options['styles']['slider']['scrollbar']['track_color']['type'] = $p['wgextra_style_slider_scrollbar_track_color'];
					}
					if ( $options['styles']['slider']['scrollbar']['track_color']['type'] === 'solid' ) {
						if ( isset( $p['wgextra_style_slider_scrollbar_track_color_solid_color'] ) ) {
							$options['styles']['slider']['scrollbar']['track_color']['solid']['color'] = $p['wgextra_style_slider_scrollbar_track_color_solid_color'];
						}
					} else if ( $options['styles']['slider']['scrollbar']['track_color']['type'] === 'gradient' ) {
						if ( isset( $p['wgextra_style_slider_scrollbar_track_color_gradient_start_color'] ) ) {
							$options['styles']['slider']['scrollbar']['track_color']['gradient']['start_color'] = $p['wgextra_style_slider_scrollbar_track_color_gradient_start_color'];
						}
						if ( isset( $p['wgextra_style_slider_scrollbar_track_color_gradient_stop_color'] ) ) {
							$options['styles']['slider']['scrollbar']['track_color']['gradient']['stop_color'] = $p['wgextra_style_slider_scrollbar_track_color_gradient_stop_color'];
						}
						if ( isset( $p['wgextra_style_slider_scrollbar_track_color_gradient_orientation'] ) ) {
							$options['styles']['slider']['scrollbar']['track_color']['gradient']['orientation'] = $p['wgextra_style_slider_scrollbar_track_color_gradient_orientation'];
						}
					}

					if ( isset( $p['wgextra_style_slider_scrollbar_handle_color'] ) ) {
						$options['styles']['slider']['scrollbar']['handle_color']['type'] = $p['wgextra_style_slider_scrollbar_handle_color'];
					}
					if ( $options['styles']['slider']['scrollbar']['handle_color']['type'] === 'solid' ) {
						if ( isset( $p['wgextra_style_slider_scrollbar_handle_color_solid_color'] ) ) {
							$options['styles']['slider']['scrollbar']['handle_color']['solid']['color'] = $p['wgextra_style_slider_scrollbar_handle_color_solid_color'];
						}
					} else if ( $options['styles']['slider']['scrollbar']['handle_color']['type'] === 'gradient' ) {
						if ( isset( $p['wgextra_style_slider_scrollbar_handle_color_gradient_start_color'] ) ) {
							$options['styles']['slider']['scrollbar']['handle_color']['gradient']['start_color'] = $p['wgextra_style_slider_scrollbar_handle_color_gradient_start_color'];
						}
						if ( isset( $p['wgextra_style_slider_scrollbar_handle_color_gradient_stop_color'] ) ) {
							$options['styles']['slider']['scrollbar']['handle_color']['gradient']['stop_color'] = $p['wgextra_style_slider_scrollbar_handle_color_gradient_stop_color'];
						}
						if ( isset( $p['wgextra_style_slider_scrollbar_handle_color_gradient_orientation'] ) ) {
							$options['styles']['slider']['scrollbar']['handle_color']['gradient']['orientation'] = $p['wgextra_style_slider_scrollbar_handle_color_gradient_orientation'];
						}
					}


					/* Check color from "Bullets styles - Bullets color" option */
					if ( isset( $p['wgextra_style_slider_bullets_color'] ) ) {
						if ( empty( $p['wgextra_style_slider_bullets_color'] ) ) {
							$options['styles']['slider']['bullets']['color'] = '';
						} else {
							if ( $this->is_valid_color( $p['wgextra_style_slider_bullets_color'] ) ) {
								$options['styles']['slider']['bullets']['color'] = $p['wgextra_style_slider_bullets_color'];
							} else {
								$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Bullets styles", 'wordpress-gallery-extra' ) . " - " . __( "Bullets color", 'wordpress-gallery-extra' ) ) . "</li>";
							}
						}
					}


					/* Check value from "Time Loader styles - Stroke size" option */
					if ( isset( $p['wgextra_style_slider_time_loader_stroke_size'] ) && !empty( $p['wgextra_style_slider_time_loader_stroke_size'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_stroke_size'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Stroke size", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['stroke_size'] = floatval( $p['wgextra_style_slider_time_loader_stroke_size'] );
						}
					}
					/* Check value from "Time Loader styles - Circle diameter" option */
					if ( isset( $p['wgextra_style_slider_time_loader_circle_diameter'] ) && !empty( $p['wgextra_style_slider_time_loader_circle_diameter'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_circle_diameter'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Circle diameter", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['circle_diameter'] = floatval( $p['wgextra_style_slider_time_loader_circle_diameter'] );
						}
					}
					/* Check value from "Time Loader styles - Scale length" option */
					if ( isset( $p['wgextra_style_slider_time_loader_scale_length'] ) && !empty( $p['wgextra_style_slider_time_loader_scale_length'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_scale_length'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Scale length", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['scale_length'] = floatval( $p['wgextra_style_slider_time_loader_scale_length'] );
						}
					}
					/* Check value from "Time Loader styles - Rotation" option */
					if ( isset( $p['wgextra_style_slider_time_loader_rotate'] ) && !empty( $p['wgextra_style_slider_time_loader_rotate'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_rotate'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Rotation", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['rotate'] = floatval( $p['wgextra_style_slider_time_loader_rotate'] );
						}
					}
					/* Check value from "Time Loader styles - Track space" option */
					if ( isset( $p['wgextra_style_slider_time_loader_track_space'] ) && !empty( $p['wgextra_style_slider_time_loader_track_space'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_track_space'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Track space", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['track_space'] = floatval( $p['wgextra_style_slider_time_loader_track_space'] );
						}
					}
					/* Check value from "Time Loader styles - Offset" option */
					if ( isset( $p['wgextra_style_slider_time_loader_offset'] ) && !empty( $p['wgextra_style_slider_time_loader_offset'] ) ) {
						if ( !is_numeric( $p['wgextra_style_slider_time_loader_offset'] ) ) {
							$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Offset", 'wordpress-gallery-extra' ) ) . "</li>";
						} else {
							$options['styles']['slider']['time_loader']['offset'] = floatval( $p['wgextra_style_slider_time_loader_offset'] );
						}
					}

					/* Check color from "Time Loader styles - Loader color" option */
					if ( isset( $p['wgextra_style_slider_time_loader_loader_color'] ) ) {
						$options['styles']['slider']['time_loader']['loader_color']['type'] = $p['wgextra_style_slider_time_loader_loader_color'];
					}
					if ( $options['styles']['slider']['time_loader']['loader_color']['type'] === 'solid' ) {
						if ( isset( $p['wgextra_style_slider_time_loader_loader_color_solid_color'] ) && $this->is_valid_color( $p['wgextra_style_slider_time_loader_loader_color_solid_color'] ) ) {
							$options['styles']['slider']['time_loader']['loader_color']['solid']['color'] = $p['wgextra_style_slider_time_loader_loader_color_solid_color'];
						} else {
							$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Loader color", 'wordpress-gallery-extra' ) ) . "</li>";
						}
					} else if ( $options['styles']['slider']['time_loader']['loader_color']['type'] === 'gradient' ) {
						if ( isset( $p['wgextra_style_slider_time_loader_loader_color_gradient_start_color'] ) && $this->is_valid_color( $p['wgextra_style_slider_time_loader_loader_color_gradient_start_color'] ) ) {
							$options['styles']['slider']['time_loader']['loader_color']['gradient']['start_color'] = $p['wgextra_style_slider_time_loader_loader_color_gradient_start_color'];
						} else {
							$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Loader color", 'wordpress-gallery-extra' ) . " - " . __( "Start Color", 'wordpress-gallery-extra' ) ) . "</li>";
						}
						if ( isset( $p['wgextra_style_slider_time_loader_loader_color_gradient_stop_color'] ) && $this->is_valid_color( $p['wgextra_style_slider_time_loader_loader_color_gradient_stop_color'] ) ) {
							$options['styles']['slider']['time_loader']['loader_color']['gradient']['stop_color'] = $p['wgextra_style_slider_time_loader_loader_color_gradient_stop_color'];
						} else {
							$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Loader color", 'wordpress-gallery-extra' ) . " - " . __( "Stop Color", 'wordpress-gallery-extra' ) ) . "</li>";
						}
						if ( isset( $p['wgextra_style_slider_time_loader_loader_color_gradient_orientation'] ) ) {
							$options['styles']['slider']['time_loader']['loader_color']['gradient']['orientation'] = $p['wgextra_style_slider_time_loader_loader_color_gradient_orientation'];
						}
					}

					/* Check color from "Time Loader styles - Track color" option */
					if ( isset( $p['wgextra_style_slider_time_loader_track_color'] ) ) {
						if ( empty( $p['wgextra_style_slider_time_loader_track_color'] ) ) {
							$options['styles']['slider']['time_loader']['track_color'] = '';
						} else {
							if ( $this->is_valid_color( $p['wgextra_style_slider_time_loader_track_color'] ) ) {
								$options['styles']['slider']['time_loader']['track_color'] = $p['wgextra_style_slider_time_loader_track_color'];
							} else {
								$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Track color", 'wordpress-gallery-extra' ) ) . "</li>";
							}
						}
					}
					/* Check color from "Time Loader styles - Scale color" option */
					if ( isset( $p['wgextra_style_slider_time_loader_scale_color'] ) ) {
						if ( empty( $p['wgextra_style_slider_time_loader_scale_color'] ) ) {
							$options['styles']['slider']['time_loader']['scale_color'] = '';
						} else {
							if ( $this->is_valid_color( $p['wgextra_style_slider_time_loader_scale_color'] ) ) {
								$options['styles']['slider']['time_loader']['scale_color'] = $p['wgextra_style_slider_time_loader_scale_color'];
							} else {
								$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Scale color", 'wordpress-gallery-extra' ) ) . "</li>";
							}
						}
					}
					/* Check color from "Time Loader styles - Counter color" option */
					if ( isset( $p['wgextra_style_slider_time_loader_counter_color'] ) ) {
						if ( empty( $p['wgextra_style_slider_time_loader_counter_color'] ) ) {
							$options['styles']['slider']['time_loader']['counter_color'] = '';
						} else {
							if ( $this->is_valid_color( $p['wgextra_style_slider_time_loader_counter_color'] ) ) {
								$options['styles']['slider']['time_loader']['counter_color'] = $p['wgextra_style_slider_time_loader_counter_color'];
							} else {
								$error[] = "<li>" . sprintf( __( "Please enter a valid color in the '%s' field.", 'wordpress-gallery-extra' ), __( "Time Loader styles", 'wordpress-gallery-extra' ) . " - " . __( "Counter color", 'wordpress-gallery-extra' ) ) . "</li>";
							}
						}
					}
				}

				$options = apply_filters( 'wgextra_edit_template_settings', $options, $id, $p );
				$error = apply_filters( 'wgextra_edit_template_settings_errors', $error, $options, $id, $p );

				/* Update settings in the database */
				if ( empty( $error ) ) {
					$options['lastEdit'] = time();
					$templates[$id] = $options;

					update_option( "{$this->SLUG}_templates", $templates );
					$this->save_styles( $templates );
					$message = __( "Settings saved.", 'wordpress-gallery-extra' );
				} else {
					$message = __( "Settings are not saved.", 'wordpress-gallery-extra' );
				}

				$result = array(
					'status' => empty( $error ) ? 200 : 403,
					'error' => $error,
					'message' => $message 
				);
			}

			else if ( $task === "save_settings" ) {
				$options = $this->OPTIONS;

				$options['default_template']  = $p['wgextra_default_template'];
				$options['load_library']      = ( isset( $p['wgextra_load_library'] ) )      ? "yes" : "no";
				$options['debounce_resize']   = ( isset( $p['wgextra_debounce_resize'] ) )   ? "yes" : "no";
				$options['media_taxonomies']  = ( isset( $p['wgextra_media_taxonomies'] ) )  ? "yes" : "no";
				$options['grab_placeholder']  = ( isset( $p['wgextra_grab_placeholder'] ) )  ? "yes" : "no";
				$options['import_from_xmp']   = ( isset( $p['wgextra_import_from_xmp'] ) )   ? "yes" : "no";
				$options['focus_point']       = ( isset( $p['wgextra_focus_point'] ) )       ? "yes" : "no";
				$options['audio_player_type'] = $p['wgextra_audio_player_type'];
				$options['crash_report']      = ( isset( $p['wgextra_crash_report'] ) )      ? "yes" : "no";
				$options['delete_data']       = ( isset( $p['wgextra_delete_data'] ) )       ? "yes" : "no";

				/* Check value from "Items per page" option */
				if ( isset( $p['wgextra_items_per_page'] ) ) {
					if ( !is_numeric( $p['wgextra_items_per_page'] ) || ( is_numeric( $p['wgextra_items_per_page'] ) && $p['wgextra_items_per_page'] < 5 ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Items per page", 'wordpress-gallery-extra' ) ) . "</li>";
					} else {
						$options['items_per_page'] = floatval( $p['wgextra_items_per_page'] );
					}
				}

				$options = apply_filters( 'wgextra_edit_settings', $options, $p );

				/* Update settings in the database */
				if ( empty( $error ) ) {
					update_option( "{$this->SLUG}_options", $options );
					$message = __( "Settings saved.", 'wordpress-gallery-extra' );
				} else {
					$message = __( "Settings are not saved.", 'wordpress-gallery-extra' );
				}

				$result = array(
					'status' => empty( $error ) ? 200 : 403,
					'error' => $error,
					'message' => $message 
				);
			}

			else if ( $task === "verify_image_size_id" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$id = sanitize_title( trim( $p['id'] ) );
				$result = array(
					'status' => 200
				);

				if ( preg_match("/^[a-z-]+[a-z0-9-\s]*$/i", $id) ) {
					if ( !in_array( $id, get_intermediate_image_sizes() ) ) {
						$options = $this->OPTIONS;
						$result['id'] = $id;
						$result['width'] = 400;
						$result['height'] = 400;
						$options['image_sizes'][$id] = array(
							'self_created' => true,
							'width' => $result['width'],
							'height' => $result['height'],
							'crop' => '0',
							'show' => 'yes',
							'delete' => 'no'
						);
						update_option( "{$this->SLUG}_options", $options );
					} else {
						$result['status']  = 400;
						$result['message'] = __( "Your image size registration ID has been reserved before, please try another ID.", 'wordpress-gallery-extra' );
					}
				} else {
					$result['status']  = 400;
					$result['message'] = __( "Your image size registration ID is not valid.", 'wordpress-gallery-extra' );
				}
			}

			else if ( $task === "save_images_sizes" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$result = array(
					'status' => 200,
					'message' => __( "Changes saved.", 'wordpress-gallery-extra' )
				);

				$options     = $this->OPTIONS;
				$image_sizes = $options['image_sizes'];
				$post_sizes  = $p['image_size'];

				foreach ( $post_sizes as $size => $size_data ) {
					/* Check value from "Name" option */
					if ( !isset( $size_data['name'] ) || isset( $size_data['name'] ) && empty( $size_data['name'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Name", 'wordpress-gallery-extra' ) ) . "</li>";
					}
					/* Check value from "Max Width" option */
					if ( !isset( $size_data['width'] ) || !is_numeric( $size_data['width'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), $size_data['name'] . " " . __( "Max Width", 'wordpress-gallery-extra' ) ) . "</li>";
					}
					/* Check value from "Max Height" option */
					if ( !isset( $size_data['height'] ) || !is_numeric( $size_data['height'] ) ) {
						$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), $size_data['name'] . " " . __( "Max Height", 'wordpress-gallery-extra' ) ) . "</li>";
					}
				}

				/* Check value from "Image Quality" option */
				if ( !isset( $p['wgextra_image_quality'] ) || !is_numeric( $p['wgextra_image_quality'] ) || $p['wgextra_image_quality'] > 100 || $p['wgextra_image_quality'] < 0 ) {
					$error[] = "<li>" . sprintf( __( "Please enter a valid value in the '%s' field.", 'wordpress-gallery-extra' ), __( "Image Quality", 'wordpress-gallery-extra' ) ) . "</li>";
				}

				if ( !empty( $error ) ) {
					wp_send_json( array(
						"status" => 400,
						"error" => $error,
						"message" => __( "Changes are not saved.", 'wordpress-gallery-extra' )
					) );
				}

				// Save options
				foreach ( $post_sizes as $size => $size_data ) {
					if ( in_array( $size, array( 'thumbnail', 'medium', 'large' ) ) ) {
						update_option( $size . '_size_w', (int) $size_data['width'] );
						update_option( $size . '_size_h', (int) $size_data['height'] );
						if ( $size === 'thumbnail' ) {
							update_option( $size . '_crop', (int) isset( $size_data['crop'] ) );
						}
					}
					else {
						if ( !isset( $image_sizes[$size] ) ) {
							$image_sizes[$size] = array();
						}

						$image_sizes[$size] = array_merge( $image_sizes[$size], array(
							"name" => (string) $size_data['name'],
							"width" => (int) $size_data['width'],
							"height" => (int) $size_data['height'],
							"crop" => (string) $size_data['crop'],
							"show" => isset( $size_data['show'] ) ? 'yes' : 'no',
							"delete" => isset( $size_data['delete'] ) ? 'yes' : 'no'
						) );

						if ( isset( $image_sizes[$size]['self_created'] ) && $image_sizes[$size]['delete'] === 'yes' ) {
							unset( $image_sizes[$size] );
						}
					}
				}

				$result['image_sizes'] = $image_sizes;

				$options['image_quality'] = (int) $p['wgextra_image_quality'];
				$options['image_sizes']   = $image_sizes;
				update_option( "{$this->SLUG}_options", $options );
			}

			else if ( $task === "backup_thumbnails" ) {
				$time_start = microtime(true);
				// Create backup
				if ( $output = $this->backup() ) {
					$time_end       = microtime(true);
					$execution_time = round( $time_end - $time_start, 2 );
					$result         = array(
						'status' => 200,
						'time' => __( "Now", 'wordpress-gallery-extra' ),
						'output' => $output,
						'message' => sprintf( __( "Your thumbnails backup has been processed in %s seconds.", 'wordpress-gallery-extra' ), $execution_time )
					);
				} else {
					$result = array(
						'status' => 400,
						'message' => __( "Request failed, please try again.", 'wordpress-gallery-extra' )
					);
				}
			}

			else if ( $task === "restore_backup" ) {
				$time_start = microtime(true);
				// Restore backup
				if ( $this->restore() ) {
					$time_end       = microtime(true);
					$execution_time = round( $time_end - $time_start, 2 );
					$result         = array(
						'status' => 200,
						'message' => sprintf( __( "Your thumbnails has been restored in %s seconds.", 'wordpress-gallery-extra' ), $execution_time )
					);
				} else {
					$result = array(
						'status' => 400,
						'message' => __( "Request failed, please try again.", 'wordpress-gallery-extra' )
					);
				}
			}

			else if ( $task === "delete_backup" ) {
				// Delete backups
				if ( $this->delete_backups() ) {
					$result = array(
						'status' => 200
					);
				} else {
					$result = array(
						'status' => 400,
						'message' => __( "Request failed, please try again.", 'wordpress-gallery-extra' )
					);
				}
			}

			else if ( $task === "analyze_thumbnails" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$analyze_options  = array();

				if ( isset( $p['after_date'] ) && !empty( $p['after_date'] ) ) {
					$after_date = explode( '/', $p['after_date'] );
					if ( !@checkdate( $after_date[0], $after_date[1], $after_date[2] ) ) {
						wp_send_json( array(
							"status" => 400,
							"message" => sprintf( __( "Please enter a valid date in the '%s' field.", 'wordpress-gallery-extra' ), __( "After Date", 'wordpress-gallery-extra' ) )
						) );
					}
					$analyze_options['after_date'] = array(
						"year" => $after_date[2],
						"month" => $after_date[0],
						"day" => $after_date[1]
					);
				} elseif ( isset( $p['before_date'] ) && !empty( $p['before_date'] ) ) {
					$before_date = explode( '/', $p['before_date'] );
					if ( !@checkdate( $before_date[0], $before_date[1], $before_date[2] ) ) {
						wp_send_json( array(
							"status" => 400,
							"message" => sprintf( __( "Please enter a valid date in the '%s' field.", 'wordpress-gallery-extra' ), __( "Before Date", 'wordpress-gallery-extra' ) )
						) );
					}
					$analyze_options['before_date'] = array(
						"year" => $before_date[2],
						"month" => $before_date[0],
						"day" => $before_date[1]
					);
				}

				// Analyze Thumbnails
				if ( $output = $this->analyze( $analyze_options ) ) {
					$result = array(
						'status' => 200,
						'output' => $output,
						'original_files' => sprintf( __( "%d files (%s)", 'wordpress-gallery-extra' ), count( $output['original'] ), $this->human_filesize( $output['originals_file_size'] ) ),
						'thumbnail_files' => sprintf( __( "%d files (%s)", 'wordpress-gallery-extra' ), count( $output['thumbnails'] ), $this->human_filesize( $output['thumbnails_file_size'] ) ),
						'total_file_size' => $this->human_filesize( $output['total_file_size'] )
					);
				} else {
					$result = array(
						'status' => 400,
						'message' => __( "Request failed, please try again.", 'wordpress-gallery-extra' )
					);
				}
			}

			else if ( $task === "clean_thumbnails" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$time_start = microtime( true );
				$result = array(
					'status' => 200
				);

				$clean_options  = array();

				if ( isset( $p['after_date'] ) && !empty( $p['after_date'] ) ) {
					$after_date = explode( '/', $p['after_date'] );
					if ( !@checkdate( $after_date[0], $after_date[1], $after_date[2] ) ) {
						wp_send_json( array(
							"status" => 400,
							"message" => sprintf( __( "Please enter a valid date in the '%s' field.", 'wordpress-gallery-extra' ), __( "After Date", 'wordpress-gallery-extra' ) )
						) );
					}
					$clean_options['after_date'] = array(
						"year" => $after_date[2],
						"month" => $after_date[0],
						"day" => $after_date[1]
					);
				} elseif ( isset( $p['before_date'] ) && !empty( $p['before_date'] ) ) {
					$before_date = explode( '/', $p['before_date'] );
					if ( !@checkdate( $before_date[0], $before_date[1], $before_date[2] ) ) {
						wp_send_json( array(
							"status" => 400,
							"message" => sprintf( __( "Please enter a valid date in the '%s' field.", 'wordpress-gallery-extra' ), __( "Before Date", 'wordpress-gallery-extra' ) )
						) );
					}
					$clean_options['before_date'] = array(
						"year" => $before_date[2],
						"month" => $before_date[0],
						"day" => $before_date[1]
					);
				}

				// Clean Thumbnails
				$this->clean_thumbnails( $clean_options );

				$time_end       = microtime( true );
				$execution_time = round( $time_end - $time_start, 2 );
				$analyze        = $this->analyze( $clean_options );

				$result['message']         = sprintf( __( "Your thumbnails has been cleaned in %s seconds.", 'wordpress-gallery-extra' ), $execution_time );
				$result['original_files']  = sprintf( __( "%d files (%s)", 'wordpress-gallery-extra' ), count( $analyze['original'] ), $this->human_filesize( $analyze['originals_file_size'] ) );
				$result['thumbnail_files'] = sprintf( __( "%d files (%s)", 'wordpress-gallery-extra' ), count( $analyze['thumbnails'] ), $this->human_filesize( $analyze['thumbnails_file_size'] ) );
				$result['total_file_size'] = $this->human_filesize( $analyze['total_file_size'] );
			}

			else if ( $task === "start_regenerator" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$result = array(
					'status' => 200
				);

				$list_options = array();

				if ( isset( $p['wgextra_post_types'] ) ) {
					$list_options['post_types'] = $p['wgextra_post_types'];
				}

				$list = $this->get_images_list( $list_options );

				if ( empty( $list ) ) {
					$error[] = "<li>" . __( "There is no images available with your criteria to rebuild.", 'wordpress-gallery-extra' ) . "</li>";
				}

				if ( empty( $error ) ) {
					$result['message'] = __( "Regenerator started.", 'wordpress-gallery-extra' );
					$result['list']    = $list;
					$result['sizes']   = $p['wgextra_thumbnails'];
				} else {
					$result['status']  = 400;
					$result['message'] = __( "Regenerator not started.", 'wordpress-gallery-extra' );
					$result['error']   = $error;
				}
			}

			else if ( $task === "process_image_resize" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$result = array(
					'status' => 200
				);

				$id         = (int) $p['id'];
				$thumbnails = isset( $p['thumbnails'] ) ? $p['thumbnails'] : null;
				$image      = get_post( $id );
				$time_start = microtime( true );

				if ( ! $image || 'attachment' != $image->post_type || 'image/' != substr( $image->post_mime_type, 0, 6 ) ) {
					$result['status'] = 400;
					$result['message'] = sprintf( __( 'Failed resize: %s is an invalid image ID.', 'wordpress-gallery-extra' ), esc_html( $id ) );
					wp_send_json( $result );
				}

				$fullsizepath = get_attached_file( $image->ID );

				if ( false === $fullsizepath || ! file_exists( $fullsizepath ) )
					$this->die_json_error_msg( $image->ID, sprintf( __( 'The originally uploaded image file cannot be found at %s', 'wordpress-gallery-extra' ), '<code>' . esc_html( $fullsizepath ) . '</code>' ) );

				$metadata = self::wp_generate_attachment_metadata( $image->ID, $fullsizepath, $thumbnails );

				if ( is_wp_error( $metadata ) )
					$this->die_json_error_msg( $image->ID, $metadata->get_error_message() );
				if ( empty( $metadata ) )
					$this->die_json_error_msg( $image->ID, __( 'Unknown failure reason.', 'wordpress-gallery-extra' ) );

				// If this fails, then it just means that nothing was changed (old value == new value)
				wp_update_attachment_metadata( $image->ID, $metadata );

				$time_end       = microtime( true );
				$execution_time = round( $time_end - $time_start, 2 );

				$result['message'] = sprintf( __( '"%s" (ID %s) was successfully resized in %s seconds.', 'wordpress-gallery-extra' ), esc_html( get_the_title( $image->ID ) ), $image->ID, $execution_time );
			}

			else if ( $task === "activate_license" ) {
				$options = $this->OPTIONS;
				$license_id = $p['license_id'];
				$license_nonce = $p['license_nonce'];

				$response = json_decode( wp_remote_retrieve_body( wp_remote_get( "https://verify.iprodev.com/check.php?license_id=" . $license_id . "&license_nonce=" . $license_nonce . "&site=" . urlencode( site_url() ) ) ), true );

				if ( $response['status'] == 200 ) {
					$options['license_id'] = $license_id;
					$options['license_nonce'] = $license_nonce;
					update_option( "{$this->SLUG}_options", $options );

					$result = array(
						'status' => 200
					);
				} else {
					$result = array(
						'status' => $response['status'],
						'message' => $response['status'] == 402 ? __( 'Your license support period has been expired, please renew it.', 'wordpress-gallery-extra' ) : __( 'License is not valid.', 'wordpress-gallery-extra' )
					);
				}
			}

			else if ( $task === "deactivate_license" ) {
				$options = $this->OPTIONS;

				$response = wp_remote_get( "https://verify.iprodev.com/deactivate.php?license_id=" . $options['license_id'] . "&license_nonce=" . $options['license_nonce'] . "&site=" . urlencode( site_url() ) );
				$options['license_id'] = "";
				$options['license_nonce'] = "";
				update_option( "{$this->SLUG}_options", $options );

				$result = array(
					'status' => 200
				);
			}

			else if ( $task === "convert_to_less" ) {
				if ( !$this->is_active() && !$this->is_extended() ) {
					wp_send_json( array(
						"status" => 403,
						"message" => __( "Please activate WordPress Gallery Extra plugin to enable this feature.", 'wordpress-gallery-extra' )
					) );
				}

				$css = $p['css'];

				$response = wp_remote_post(
					"https://leafo.net/lessphp/lessify/go.php",
					array(
						'sslverify'  => false,
						'timeout'    => 60,
						'user-agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36',
						'body'       => array( 'css' => $css )
					)
				);

				if ( is_wp_error( $response ) ) {
					$result = array(
						'status' => $response->get_error_code(),
						'message' => $response->get_error_message()
					);
				} else {
					$result = array(
						'status' => 200,
						'less' => wp_remote_retrieve_body( $response )
					);
				}
			}

			else if ( $task === "check_iprodev_server_contact" ) {
				$response = wp_remote_get(
					"https://wgextra.iprodev.com/",
					array(
						'sslverify'  => false,
						'timeout'    => 10
					)
				);

				$result = array(
					'status' => wp_remote_retrieve_response_code( $response )
				);

				if ( is_wp_error( $response ) ) {
					$result['message'] = $response->get_error_message();
				}
			}

			else if ( $task === "dismiss_notify" ) {
				$notify = get_option( "{$this->SLUG}_notify" );

				$notify['dismissed'] = true;
				update_option( "{$this->SLUG}_notify", $notify );

				$result = array(
					'status' => 200
				);
			}

			else
				$result = array(
					'status' => 400,
					'message' => __( "Bad Request", 'wordpress-gallery-extra' ) 
				);
		}

		wp_send_json( $result );
	}
}

?>
