<?php
	$wge_page = "templates";
	$templates = $this->TEMPLATES;

	if ( !isset( $_GET['id'] ) ) {
		$templates_num = count( $templates );

		// Sort templates
		krsort( $templates );

		$per_page = $this->OPTIONS['items_per_page'];
		$total_pages = ceil( $templates_num / $per_page );
		$current_page = intval( isset( $_GET['p'] ) ? ( ( $_GET['p'] > $total_pages || $_GET['p'] < 1 ) ? 1 : $_GET['p'] ) : 1 );
		$pages_templates = array_chunk( $templates, $per_page, true );
		$page_templates = $pages_templates[$current_page - 1];
		$urlPattern = 'admin.php?page=wgextra&p=(:num)';

		$paginator = new JasonGrimes\Paginator( $templates_num, $per_page, $current_page, $urlPattern );
		$paginator->setMaxPagesToShow( 4 );

		$pagename = __( 'Templates', 'wordpress-gallery-extra' );

		$box_title_elements = array(
			array(
				"tag" => "div",
				"attributes" => array(
					"class" => array("controlgroup", "templates", "wge-float-right"),
				),
				"nodes" => array(
					array(
						"tag" => "button",
						"attributes" => array(
							"id" => "wgextra_import_template",
							"class" => array("ui-button", "grey"),
						),
						"nodes" => array(
							array(
								"tag" => "span",
								"attributes" => array(
									"class" => array("dashicons", "dashicons-migrate"),
								)
							),
							__( "Import Template", 'wordpress-gallery-extra' )
						)
					),
					array(
						"tag" => "button",
						"attributes" => array(
							"id" => "wgextra_new_template",
							"class" => array("ui-button", "grey"),
						),
						"nodes" => array(
							array(
								"tag" => "span",
								"attributes" => array(
									"class" => array("dashicons", "dashicons-plus-alt"),
								)
							),
							__( "New Template", 'wordpress-gallery-extra' )
						)
					)
				)
			)
		);

		if ( $paginator->getNumPages() > 1 ) {
			$pagination = array(
				"tag" => "ul",
				"attributes" => array(
					"class" => array("pagination"),
				),
				"nodes" => array()
			);

			if ( $paginator->getPrevUrl() ) {
				$pagination['nodes'][] = array(
					"tag" => "li",
					"attributes" => array(
						"class" => array("prev"),
					),
					"nodes" => array(
						array(
							"tag" => "a",
							"attributes" => array(
								"href" => $paginator->getPrevUrl()
							),
							"nodes" => array(
								__( "Previous", 'wordpress-gallery-extra' )
							)
						)
					)
				);
			}

			foreach ( $paginator->getPages() as $page ) {
				if ( $page['url'] ) {
					$pagination['nodes'][] = array(
						"tag" => "li",
						"attributes" => array(
							"class" => $page['isCurrent'] ? array("active") : array(),
						),
						"nodes" => array(
							array(
								"tag" => "a",
								"attributes" => array(
									"href" => $page['url']
								),
								"nodes" => array(
									(string) $page['num']
								)
							)
						)
					);
				}
				else {
					$pagination['nodes'][] = array(
						"tag" => "li",
						"attributes" => array(
							"class" => array("disabled")
						),
						"nodes" => array(
							array(
								"tag" => "span",
								"attributes" => array(),
								"nodes" => array(
									(string) $page['num']
								)
							)
						)
					);
				}
			}

			if ( $paginator->getNextUrl() ) {
				$pagination['nodes'][] = array(
					"tag" => "li",
					"attributes" => array(
						"class" => array("next"),
					),
					"nodes" => array(
						array(
							"tag" => "a",
							"attributes" => array(
								"href" => $paginator->getNextUrl()
							),
							"nodes" => array(
								__( "Next", 'wordpress-gallery-extra' )
							)
						)
					)
				);
			}

			array_unshift( $box_title_elements, $pagination );
		}

		include_once 'header.php';
?>
				<div class="inside">
					<p class="wge-float-left"><?php _e( "Extend your WordPress native gallery with creating nice gallery templates.", 'wordpress-gallery-extra' ); ?></p>

					<div class="clear"></div>

					<p id="empty_templates"<?php if ( !empty( $templates ) ) echo " style='display: none;'"; ?>><?php _e( "No template exists, please create one.", 'wordpress-gallery-extra' ); ?></p>

					<table class="form-table"<?php if ( empty( $templates ) ) echo " style='display: none;'"; ?>>
<?php

				foreach ( $page_templates as $id => $template ) {
					$name = $template['name'];
					$user_info = get_userdata( $template['uid'] );
?>
						<tr>
							<th><?php echo $name; ?></th>
							<td>
								<div class="inside-table">
									<table class="form-table middle">
										<thead>
											<tr>
												<th><label><?php _e( "ID", 'wordpress-gallery-extra' ); ?></label></th>
												<th><label><?php _e( "Author", 'wordpress-gallery-extra' ); ?></label></th>
												<th><label><?php _e( "Type", 'wordpress-gallery-extra' ); ?></label></th>
												<th><label><?php _e( "Last Modify", 'wordpress-gallery-extra' ); ?></label></th>
												<th><label><?php _e( "Actions", 'wordpress-gallery-extra' ); ?></label></th>
											</tr>
										</thead>
										<tbody>
											<tr>
												<td>
													<?php echo $id; ?>
												</td>
												<td>
													<?php echo $user_info->display_name; ?>
												</td>
												<td>
<?php
					echo $this->TEMPLATES_TYPES[$template['template']]['name'];
?>
												</td>
												<td>
													<?php printf( __( "%s ago", 'wordpress-gallery-extra' ), human_time_diff( $template['lastEdit'] ) ); ?>
												</td>
												<td nowrap>
													<a href="<?php echo admin_url( 'admin.php?page=wgextra' ); ?>&id=<?php echo $id; ?>" class="ui-button green"><span class="dashicons dashicons-edit"></span><?php _e( "Edit", 'wordpress-gallery-extra' ); ?></a>
													<a rel="duplicate_template" identifier="<?php echo $id; ?>" class="ui-button grey"><span class="dashicons dashicons-admin-page"></span><?php _e( "Duplicate", 'wordpress-gallery-extra' ); ?></a>
													<a rel="delete_template" identifier="<?php echo $id; ?>" class="ui-button red"><span class="dashicons dashicons-trash"></span><?php _e( "Delete", 'wordpress-gallery-extra' ); ?></a>
												</td>
											</tr>
										</tbody>
									</table>
								</div>
							</td>
						</tr>
<?php
				}
?>
					</table>
				</div><!-- end of inside -->
				<script id="new_template_row" type="text/template">
<tr>
	<th><%= name %></th>
	<td>
		<div class="inside-table">
			<table class="form-table middle">
				<thead>
					<tr>
						<th><label><?php _e( "ID", 'wordpress-gallery-extra' ); ?></label></th>
						<th><label><?php _e( "Author", 'wordpress-gallery-extra' ); ?></label></th>
						<th><label><?php _e( "Type", 'wordpress-gallery-extra' ); ?></label></th>
						<th><label><?php _e( "Last Modify", 'wordpress-gallery-extra' ); ?></label></th>
						<th><label><?php _e( "Actions", 'wordpress-gallery-extra' ); ?></label></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>
							<%= id %>
						</td>
						<td>
							<%= user %>
						</td>
						<td>
							<%= template %>
						</td>
						<td>
							<%= last_modify %>
						</td>
						<td nowrap>
							<a href="<?php echo admin_url( 'admin.php?page=wgextra' ); ?>&id=<%= id %>" class="ui-button green"><span class="dashicons dashicons-edit"></span><?php _e( "Edit", 'wordpress-gallery-extra' ); ?></a>
							<a rel="duplicate_template" identifier="<%= id %>" class="ui-button grey"><span class="dashicons dashicons-admin-page"></span><?php _e( "Duplicate", 'wordpress-gallery-extra' ); ?></a>
							<a rel="delete_template" identifier="<%= id %>" class="ui-button red"><span class="dashicons dashicons-trash"></span><?php _e( "Delete", 'wordpress-gallery-extra' ); ?></a>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</td>
</tr>
				</script>
				<script id="show_templates" type="text/template">
					<div id="wgextra_show_templates" title="<%= title %>">
						<div class="top-columns">
							<div class="search_field_column">
								<input type="search" placeholder="<?php esc_attr_e( "Type to Search...", 'wordpress-gallery-extra' ); ?>" />
							</div>
							<div class="template_type_column">
								<select id="template_type">
									<option value=""><?php _e( "All", 'wordpress-gallery-extra' ); ?></option>
									<option value=".columns"><?php _e( "Columns", 'wordpress-gallery-extra' ); ?></option>
									<option value=".justified"><?php _e( "Justified", 'wordpress-gallery-extra' ); ?></option>
									<option value=".masonry"><?php _e( "Masonry", 'wordpress-gallery-extra' ); ?></option>
									<option value=".mosaic"><?php _e( "Mosaic", 'wordpress-gallery-extra' ); ?></option>
									<option value=".slider"><?php _e( "Slider", 'wordpress-gallery-extra' ); ?></option>
								</select>
							</div>
						</div>
						<div class="scroller">
							<% if (Object.keys(templates).length) { %>
							<div id="importable-templates">
								<% _.each(templates, function(template, id){ %>
								<div class="template <%= template.types.join(' ') %>" data-date="<%= template.date %>" data-name="<%= template.name %>">
									<div class="template-inner">
										<img src="<%= template.screenshot.medium_large.url %>" srcset="<%= template.screenshot.medium_large.url %> <%= template.screenshot.medium_large.width %>w, <%= template.screenshot.full.url %> <%= template.screenshot.full.width %>w" sizes="(max-width: <%= template.screenshot.medium_large.width %>px) 100vw, <%= template.screenshot.medium_large.width %>px">
										<a class="template-action preview" href="<%= template.url %>" target="_blank" rel="noreferrer noopener"><?php _e( "Preview", 'wordpress-gallery-extra' ); ?></a>
										<a class="template-action import" rel="<%= id %>"><?php _e( "Import", 'wordpress-gallery-extra' ); ?></a>
									</div>
									<div class="template-name"><%= template.name %></div>
								</div>
								<% }); %>
							</div>
							<% } else { %>
							<p class="empty_templates"><?php _e( "No template exists, please create one.", 'wordpress-gallery-extra' ); ?></p>
							<% } %>
						</div>
					</div>
				</script>
			<?php
			}
			else {
				$id = $_GET['id'];
				$template = $templates[$id];
				$default_options = $this->DEFAULT_TEMPLATE_OPTIONS;
				$options = array_replace_recursive( $default_options, $template );
				$tabs = array(
					"wgextra-settings" => __( 'Settings', 'wordpress-gallery-extra' ),
					"wgextra-source" => __( 'Source', 'wordpress-gallery-extra' ),
					"wgextra-display" => __( 'Display', 'wordpress-gallery-extra' ),
					"wgextra-styling" => __( 'Styling', 'wordpress-gallery-extra' )
				);
				$box_title_elements = array(
					array(
						"tag" => "button",
						"attributes" => array(
							"type" => "submit",
							"class" => array("submit-button", "blue"),
							"data-style" => "expand-left"
						),
						"nodes" => array(
							__( "Save Changes", 'wordpress-gallery-extra' )
						)
					)
				);
				include_once 'header.php';

				$target_options = apply_filters( 'wgextra_attachment_field_custom_target_options', array(
					'_self'     => __( 'Open on the same page (_self)', 'wordpress-gallery-extra' ),
					'_blank'    => __( 'Open on new page (_blank)', 'wordpress-gallery-extra' ),
					'_parent'   => __( 'Open in parent frame (_parent)', 'wordpress-gallery-extra' ),
					'_top'      => __( 'Open in main frame (_top)', 'wordpress-gallery-extra' ),
					'_lightbox' => __( 'Open in LightBox (_lightbox)', 'wordpress-gallery-extra' ),
					'_video'    => __( 'Open Video in LightBox (_video)', 'wordpress-gallery-extra' ),
					'_audio'    => __( 'Open Audio in LightBox (_audio)', 'wordpress-gallery-extra' )
				) );
				$ordering_order_by_options = apply_filters( 'wgextra_source_ordering_order_by', array(
					'' => __( "None", 'wordpress-gallery-extra' ),
					'ID' => __( "ID", 'wordpress-gallery-extra' ),
					'author' => __( "Author", 'wordpress-gallery-extra' ),
					'title' => __( "Title", 'wordpress-gallery-extra' ),
					'date' => __( "Date", 'wordpress-gallery-extra' ),
					'name' => __( "Post slug", 'wordpress-gallery-extra' ),
					'modified' => __( "Last modified date", 'wordpress-gallery-extra' ),
					'parent' => __( "Post parent id", 'wordpress-gallery-extra' ),
					'rand' => __( "Random", 'wordpress-gallery-extra' ),
					'comment_count' => __( "Number of comments", 'wordpress-gallery-extra' ),
					'menu_order' => __( "Page Order (Menu Order)", 'wordpress-gallery-extra' ),
					'meta_value' => __( "Meta Value", 'wordpress-gallery-extra' ),
					'meta_value_num' => __( "Numeric Meta Value", 'wordpress-gallery-extra' ),
					'post__in' => __( "Preserve post ID order", 'wordpress-gallery-extra' )
				) );

				$preset_styles = apply_filters( 'wgextra_preset_styles', array(
					array(
						"style" => "border: 3px solid #FFF; box-shadow: 0 11px 15px -8px rgba(0, 0, 0, 0.3);",
						"form_data" => array(
							"wgextra_style_border" => true,
							"wgextra_style_shadow" => true,
							"wgextra_style_border_radius" => 0,
							"wgextra_style_border_weight" => 3,
							"wgextra_style_border_style" => "solid",
							"wgextra_style_border_color" => "rgba(255, 255, 255, 1)",
							"wgextra_style_shadow_x" => 0,
							"wgextra_style_shadow_y" => 11,
							"wgextra_style_shadow_blur" => 15,
							"wgextra_style_shadow_spread" => -8,
							"wgextra_style_shadow_color" => "rgba(0, 0, 0, 0.3)",
							"wgextra_style_shadow_inset" => false,
							"wgextra_style_margin" => 15,
							"wgextra_style_icon" => true,
							"wgextra_style_icon_icon" => "eye",
							"wgextra_style_icon_color" => "rgba(153, 153, 153, 1)",
							"wgextra_style_overlay" => true,
							"wgextra_style_overlay_background" => "solid",
							"wgextra_style_overlay_background_solid_color" => "rgba(255, 255, 255, 0.7)"
						)
					),
					array(
						"style" => "border: 6px solid #000; box-shadow: 0 14px 5px -9px rgba(0, 0, 0, 0.7);",
						"form_data" => array(
							"wgextra_style_border" => true,
							"wgextra_style_shadow" => true,
							"wgextra_style_border_radius" => 0,
							"wgextra_style_border_weight" => 6,
							"wgextra_style_border_style" => "solid",
							"wgextra_style_border_color" => "rgba(0, 0, 0, 1)",
							"wgextra_style_shadow_x" => 0,
							"wgextra_style_shadow_y" => 14,
							"wgextra_style_shadow_blur" => 5,
							"wgextra_style_shadow_spread" => -9,
							"wgextra_style_shadow_color" => "rgba(0, 0, 0, 0.7)",
							"wgextra_style_shadow_inset" => false,
							"wgextra_style_margin" => 15,
							"wgextra_style_icon" => true,
							"wgextra_style_icon_icon" => "magnifier-3",
							"wgextra_style_icon_color" => "rgba(255, 255, 255, 1)",
							"wgextra_style_overlay" => true,
							"wgextra_style_overlay_background" => "solid",
							"wgextra_style_overlay_background_solid_color" => "rgba(0, 0, 0, 0.7)"
						)
					),
					array(
						"style" => "box-shadow: 0 0 55px rgba(0, 0, 0, .2); filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\"); filter: gray; filter: grayscale(100%); -webkit-filter: grayscale(100%); border-radius: 7px;",
						"form_data" => array(
							"wgextra_style_border" => true,
							"wgextra_style_shadow" => true,
							"wgextra_style_border_radius" => 7,
							"wgextra_style_border_weight" => 0,
							"wgextra_style_border_style" => "solid",
							"wgextra_style_border_color" => "rgba(0, 0, 0, 1)",
							"wgextra_style_shadow_x" => 0,
							"wgextra_style_shadow_y" => 0,
							"wgextra_style_shadow_blur" => 55,
							"wgextra_style_shadow_spread" => 0,
							"wgextra_style_shadow_color" => "rgba(0, 0, 0, 0.2)",
							"wgextra_style_shadow_inset" => false,
							"wgextra_style_margin" => 110,
							"wgextra_style_thumbnail_effect" => "colorize"
						)
					),
					array(
						"style" => "border: 10px solid #fff; box-shadow: 0 1px 2px rgba(0, 0, 0, 0.15);",
						"form_data" => array(
							"wgextra_style_border" => true,
							"wgextra_style_shadow" => true,
							"wgextra_style_border_radius" => 0,
							"wgextra_style_border_weight" => 10,
							"wgextra_style_border_style" => "solid",
							"wgextra_style_border_color" => "rgba(255, 255, 255, 1)",
							"wgextra_style_shadow_x" => 0,
							"wgextra_style_shadow_y" => 1,
							"wgextra_style_shadow_blur" => 2,
							"wgextra_style_shadow_spread" => 0,
							"wgextra_style_shadow_color" => "rgba(0, 0, 0, 0.15)",
							"wgextra_style_shadow_inset" => false,
							"wgextra_style_margin" => 20
						)
					)
				) );

				$css3_easings = apply_filters( 'wgextra_style_css3_easings', array(
					"" => __( "None", 'wordpress-gallery-extra' ),
					"linear" => "linear",
					"ease" => "ease",
					"ease-in" => "ease-in",
					"ease-out" => "ease-out",
					"ease-in-out" => "ease-in-out"
				) );
				$jquery_easings = apply_filters( 'wgextra_style_jquery_easings', array(
					__( "Normal", 'wordpress-gallery-extra' ) => array(
						"linear" => "linear",
						"swing" => "swing"
					),
					"Quad" => array(
						"easeInQuad" => "easeInQuad",
						"easeOutQuad" => "easeOutQuad",
						"easeInOutQuad" => "easeInOutQuad"
					),
					"Cubic" => array(
						"easeInCubic" => "easeInCubic",
						"easeOutCubic" => "easeOutCubic",
						"easeInOutCubic" => "easeInOutCubic"
					),
					"Quart" => array(
						"easeInQuart" => "easeInQuart",
						"easeOutQuart" => "easeOutQuart",
						"easeInOutQuart" => "easeInOutQuart"
					),
					"Quint" => array(
						"easeInQuint" => "easeInQuint",
						"easeOutQuint" => "easeOutQuint",
						"easeInOutQuint" => "easeInOutQuint"
					),
					"Sine" => array(
						"easeInSine" => "easeInSine",
						"easeOutSine" => "easeOutSine",
						"easeInOutSine" => "easeInOutSine"
					),
					"Expo" => array(
						"easeInExpo" => "easeInExpo",
						"easeOutExpo" => "easeOutExpo",
						"easeInOutExpo" => "easeInOutExpo"
					),
					"Circ" => array(
						"easeInCirc" => "easeInCirc",
						"easeOutCirc" => "easeOutCirc",
						"easeInOutCirc" => "easeInOutCirc"
					),
					"Elastic" => array(
						"easeInElastic" => "easeInElastic",
						"easeOutElastic" => "easeOutElastic",
						"easeInOutElastic" => "easeInOutElastic"
					),
					"Back" => array(
						"easeInBack" => "easeInBack",
						"easeOutBack" => "easeOutBack",
						"easeInOutBack" => "easeInOutBack"
					),
					"Bounce" => array(
						"easeInBounce" => "easeInBounce",
						"easeOutBounce" => "easeOutBounce",
						"easeInOutBounce" => "easeInOutBounce"
					)
				) );
				$animate_css_effects = array(
					__( "Attention Seekers", 'wordpress-gallery-extra' ) => array(
						"bounce" => __( "Bounce", 'wordpress-gallery-extra' ),
						"flash" => __( "Flash", 'wordpress-gallery-extra' ),
						"pulse" => __( "Pulse", 'wordpress-gallery-extra' ),
						"rubber-band" => __( "Rubber Band", 'wordpress-gallery-extra' ),
						"shake" => __( "Shake", 'wordpress-gallery-extra' ),
						"head-shake" => __( "Head Shake", 'wordpress-gallery-extra' ),
						"swing" => __( "Swing", 'wordpress-gallery-extra' ),
						"tada" => __( "Tada", 'wordpress-gallery-extra' ),
						"wobble" => __( "Wobble", 'wordpress-gallery-extra' ),
						"jello" => __( "Jello", 'wordpress-gallery-extra' )
					),
					__( "Bouncing Entrances", 'wordpress-gallery-extra' ) => array(
						"bounce-in" => __( "Bounce In", 'wordpress-gallery-extra' ),
						"bounce-in-down" => __( "Bounce In Down", 'wordpress-gallery-extra' ),
						"bounce-in-up" => __( "Bounce In Up", 'wordpress-gallery-extra' ),
						"bounce-in-left" => __( "Bounce In Left", 'wordpress-gallery-extra' ),
						"bounce-in-right" => __( "Bounce In Right", 'wordpress-gallery-extra' )
					),
					__( "Bouncing Exits", 'wordpress-gallery-extra' ) => array(
						"bounce-out" => __( "Bounce Out", 'wordpress-gallery-extra' ),
						"bounce-out-down" => __( "Bounce Out Down", 'wordpress-gallery-extra' ),
						"bounce-out-up" => __( "Bounce Out Up", 'wordpress-gallery-extra' ),
						"bounce-out-left" => __( "Bounce Out Left", 'wordpress-gallery-extra' ),
						"bounce-out-right" => __( "Bounce Out Right", 'wordpress-gallery-extra' )
					),
					__( "Fading Entrances", 'wordpress-gallery-extra' ) => array(
						"fade-in" => __( "Fade In", 'wordpress-gallery-extra' ),
						"fade-in-down" => __( "Fade In Down", 'wordpress-gallery-extra' ),
						"fade-in-down-big" => __( "Fade In Down Big", 'wordpress-gallery-extra' ),
						"fade-in-up" => __( "Fade In Up", 'wordpress-gallery-extra' ),
						"fade-in-up-big" => __( "Fade In Up Big", 'wordpress-gallery-extra' ),
						"fade-in-left" => __( "Fade In Left", 'wordpress-gallery-extra' ),
						"fade-in-left-big" => __( "Fade In Left Big", 'wordpress-gallery-extra' ),
						"fade-in-right" => __( "Fade In Right", 'wordpress-gallery-extra' ),
						"fade-in-right-big" => __( "Fade In Right Big", 'wordpress-gallery-extra' )
					),
					__( "Fading Exits", 'wordpress-gallery-extra' ) => array(
						"fade-out" => __( "Fade Out", 'wordpress-gallery-extra' ),
						"fade-out-down" => __( "Fade Out Down", 'wordpress-gallery-extra' ),
						"fade-out-down-big" => __( "Fade Out Down Big", 'wordpress-gallery-extra' ),
						"fade-out-up" => __( "Fade Out Up", 'wordpress-gallery-extra' ),
						"fade-out-up-big" => __( "Fade Out Up Big", 'wordpress-gallery-extra' ),
						"fade-out-left" => __( "Fade Out Left", 'wordpress-gallery-extra' ),
						"fade-out-left-big" => __( "Fade Out Left Big", 'wordpress-gallery-extra' ),
						"fade-out-right" => __( "Fade Out Right", 'wordpress-gallery-extra' ),
						"fade-out-right-big" => __( "Fade Out Right Big", 'wordpress-gallery-extra' )
					),
					__( "Flippers", 'wordpress-gallery-extra' ) => array(
						"flip" => __( "Flip", 'wordpress-gallery-extra' ),
						"flip-in-x" => __( "Flip In X", 'wordpress-gallery-extra' ),
						"flip-in-y" => __( "Flip In Y", 'wordpress-gallery-extra' ),
						"flip-out-x" => __( "Flip Out X", 'wordpress-gallery-extra' ),
						"flip-out-y" => __( "Flip Out Y", 'wordpress-gallery-extra' )
					),
					__( "Lightspeed", 'wordpress-gallery-extra' ) => array(
						"light-speed-in" => __( "Light Speed In", 'wordpress-gallery-extra' ),
						"light-speed-out" => __( "Light Speed Out", 'wordpress-gallery-extra' )
					),
					__( "Rotating Entrances", 'wordpress-gallery-extra' ) => array(
						"rotate-in" => __( "Rotate In", 'wordpress-gallery-extra' ),
						"rotate-in-down-left" => __( "Rotate In Down Left", 'wordpress-gallery-extra' ),
						"rotate-in-down-right" => __( "Rotate In Down Right", 'wordpress-gallery-extra' ),
						"rotate-in-up-left" => __( "Rotate In Up Left", 'wordpress-gallery-extra' ),
						"rotate-in-up-right" => __( "Rotate In Up Right", 'wordpress-gallery-extra' )
					),
					__( "Rotating Exits", 'wordpress-gallery-extra' ) => array(
						"rotate-out" => __( "Rotate Out", 'wordpress-gallery-extra' ),
						"rotate-out-down-left" => __( "Rotate Out Down Left", 'wordpress-gallery-extra' ),
						"rotate-out-down-right" => __( "Rotate Out Down Right", 'wordpress-gallery-extra' ),
						"rotate-out-up-left" => __( "Rotate Out Up Left", 'wordpress-gallery-extra' ),
						"rotate-out-up-right" => __( "Rotate Out Up Right", 'wordpress-gallery-extra' )
					),
					__( "Sliding Entrances", 'wordpress-gallery-extra' ) => array(
						"slide-in-up" => __( "Slide In Up", 'wordpress-gallery-extra' ),
						"slide-in-down" => __( "Slide In Down", 'wordpress-gallery-extra' ),
						"slide-in-left" => __( "Slide In Left", 'wordpress-gallery-extra' ),
						"slide-in-right" => __( "Slide In Right", 'wordpress-gallery-extra' )
					),
					__( "Sliding Exits", 'wordpress-gallery-extra' ) => array(
						"slide-out-up" => __( "Slide Out Up", 'wordpress-gallery-extra' ),
						"slide-out-down" => __( "Slide Out Down", 'wordpress-gallery-extra' ),
						"slide-out-left" => __( "Slide Out Left", 'wordpress-gallery-extra' ),
						"slide-out-right" => __( "Slide Out Right", 'wordpress-gallery-extra' )
					),
					__( "Zoom Entrances", 'wordpress-gallery-extra' ) => array(
						"zoom-in" => __( "Zoom In", 'wordpress-gallery-extra' ),
						"zoom-in-up" => __( "Zoom In Up", 'wordpress-gallery-extra' ),
						"zoom-in-down" => __( "Zoom In Down", 'wordpress-gallery-extra' ),
						"zoom-in-left" => __( "Zoom In Left", 'wordpress-gallery-extra' ),
						"zoom-in-right" => __( "Zoom In Right", 'wordpress-gallery-extra' )
					),
					__( "Zoom Exits", 'wordpress-gallery-extra' ) => array(
						"zoom-out" => __( "Zoom Out", 'wordpress-gallery-extra' ),
						"zoom-out-up" => __( "Zoom Out Up", 'wordpress-gallery-extra' ),
						"zoom-out-down" => __( "Zoom Out Down", 'wordpress-gallery-extra' ),
						"zoom-out-left" => __( "Zoom Out Left", 'wordpress-gallery-extra' ),
						"zoom-out-right" => __( "Zoom Out Right", 'wordpress-gallery-extra' )
					),
					__( "Specials", 'wordpress-gallery-extra' ) => array(
						"hinge" => __( "Hinge", 'wordpress-gallery-extra' ),
						"jack-in-the-box" => __( "Jack In The Box", 'wordpress-gallery-extra' ),
						"rollIn" => __( "Roll In", 'wordpress-gallery-extra' ),
						"rollOut" => __( "Roll Out", 'wordpress-gallery-extra' )
					)
				);
				$icon_visibilities = apply_filters(
					'wgextra_style_icon_visibilities',
					array_merge(
						array(
							"visible" => __( "Always Visible", 'wordpress-gallery-extra' )
						),
						$animate_css_effects
					)
				);
				$caption_visibilities = apply_filters(
					'wgextra_style_caption_visibilities',
					array_merge(
						array(
							"visible" => __( "Always Visible", 'wordpress-gallery-extra' )
						),
						$animate_css_effects
					)
				);
				$overlay_visibilities = apply_filters(
					'wgextra_style_overlay_visibilities',
					array_merge(
						array(
							"visible" => __( "Always Visible", 'wordpress-gallery-extra' )
						),
						$animate_css_effects
					)
				);
				$thumbnail_effects = apply_filters(
					'wgextra_style_thumbnail_effects',
					array(
						"none" => __( "None", 'wordpress-gallery-extra' ),
						__( "Zooming", 'wordpress-gallery-extra' ) => array(
							"zoom-in" => __( "Zoom In", 'wordpress-gallery-extra' ),
							"zoom-out" => __( "Zoom Out", 'wordpress-gallery-extra' )
						),
						__( "Coloring", 'wordpress-gallery-extra' ) => array(
							"colorize" => __( "Colorize", 'wordpress-gallery-extra' ),
							"grayscale" => __( "Grayscale", 'wordpress-gallery-extra' ),
							"cold" => __( "Cold", 'wordpress-gallery-extra' ),
							"warm" => __( "Warm", 'wordpress-gallery-extra' ),
							"more-colorful" => __( "More Colorful", 'wordpress-gallery-extra' ),
							"glow" => __( "Glow", 'wordpress-gallery-extra' )
						),
						__( "Bluring", 'wordpress-gallery-extra' ) => array(
							"blur-in" => __( "Blur In", 'wordpress-gallery-extra' ),
							"blur-out" => __( "Blur Out", 'wordpress-gallery-extra' )
						),
						__( "Sliding", 'wordpress-gallery-extra' ) => array(
							"slide-up" => __( "Slide Up", 'wordpress-gallery-extra' ),
							"slide-down" => __( "Slide Down", 'wordpress-gallery-extra' ),
							"slide-left" => __( "Slide Left", 'wordpress-gallery-extra' ),
							"slide-right" => __( "Slide Right", 'wordpress-gallery-extra' )
						),
						__( "Moving", 'wordpress-gallery-extra' ) => array(
							"move-up" => __( "Move Up", 'wordpress-gallery-extra' ),
							"move-down" => __( "Move Down", 'wordpress-gallery-extra' ),
							"move-left" => __( "Move Left", 'wordpress-gallery-extra' ),
							"move-right" => __( "Move Right", 'wordpress-gallery-extra' )
						)
					)
				);
				$slider_arrows_skins = apply_filters(
					'wgextra_style_slider_arrows_skins',
					array(
						"default" => __( "Default", 'wordpress-gallery-extra' ),
						"slide" => __( "Slide", 'wordpress-gallery-extra' ),
						"image-bar" => __( "Image Bar", 'wordpress-gallery-extra' ),
						"circle-pop" => __( "Circle Pop", 'wordpress-gallery-extra' ),
						"round-slide" => __( "Round Slide", 'wordpress-gallery-extra' ),
						"split" => __( "Split", 'wordpress-gallery-extra' ),
						"reveal" => __( "Reveal", 'wordpress-gallery-extra' ),
						"thumb-flip" => __( "Thumb Flip", 'wordpress-gallery-extra' ),
						"thumb-double-flip" => __( "Thumb Double Flip", 'wordpress-gallery-extra' ),
						"circle-slide" => __( "Circle Slide", 'wordpress-gallery-extra' ),
						"grow-pop" => __( "Grow Pop", 'wordpress-gallery-extra' ),
						"diamond" => __( "Diamond", 'wordpress-gallery-extra' ),
						"fill-slide" => __( "Fill Slide", 'wordpress-gallery-extra' ),
						"fill-path" => __( "Fill Path", 'wordpress-gallery-extra' )
					)
				);
				$slider_scrollbar_skins = apply_filters(
					'wgextra_style_slider_scrollbar_skins',
					array(
						"default" => __( "Default", 'wordpress-gallery-extra' ),
						"scale-up" => __( "Scale Up", 'wordpress-gallery-extra' ),
						"white-light" => __( "White Light", 'wordpress-gallery-extra' ),
						"silver" => __( "Silver", 'wordpress-gallery-extra' ),
						"slim-bar" => __( "Slim Bar", 'wordpress-gallery-extra' )
					)
				);
				$slider_thumbnails_skins = apply_filters(
					'wgextra_style_slider_thumbnails_skins',
					array(
						"default" => __( "Default", 'wordpress-gallery-extra' ),
						"coverflow" => __( "Coverflow", 'wordpress-gallery-extra' ),
						"small" => __( "Small", 'wordpress-gallery-extra' ),
						"circle" => __( "Circle", 'wordpress-gallery-extra' ),
						"featured-dark" => __( "Featured Dark", 'wordpress-gallery-extra' ),
						"featured-light" => __( "Featured Light", 'wordpress-gallery-extra' ),
					)
				);
				$slider_bullets_skins = apply_filters(
					'wgextra_style_slider_bullets_skins',
					array(
						"default" => __( "Default", 'wordpress-gallery-extra' ),
						"fill-up" => __( "Fill Up", 'wordpress-gallery-extra' ),
						"scale-up" => __( "Scale Up", 'wordpress-gallery-extra' ),
						"stroke" => __( "Stroke", 'wordpress-gallery-extra' ),
						"fill-in" => __( "Fill In", 'wordpress-gallery-extra' ),
						"grow-up" => __( "Grow Up", 'wordpress-gallery-extra' ),
						"dot-stroke" => __( "Dot Stroke", 'wordpress-gallery-extra' ),
						"draw-circle" => __( "Draw Circle", 'wordpress-gallery-extra' ),
						"worm" => __( "Worm", 'wordpress-gallery-extra' ),
						"worm-stroke" => __( "Worm Stroke", 'wordpress-gallery-extra' ),
					)
				);
				$slider_time_loader_skins = apply_filters(
					'wgextra_style_slider_time_loader_skins',
					array(
						"default" => __( "Default", 'wordpress-gallery-extra' ),
						"pie-1" => __( "Pie Loader 1", 'wordpress-gallery-extra' ),
						"pie-2" => __( "Pie Loader 2", 'wordpress-gallery-extra' ),
						"pie-3" => __( "Pie Loader 3", 'wordpress-gallery-extra' ),
						"donut-1" => __( "Donut Loader 1", 'wordpress-gallery-extra' ),
						"donut-2" => __( "Donut Loader 2", 'wordpress-gallery-extra' ),
						"donut-3" => __( "Donut Loader 3", 'wordpress-gallery-extra' ),
					)
				);

				$icons_json = file_get_contents( plugin_dir_path( $this->MAIN ) . "assets/css/icons.json" );
				$icons = json_decode( $icons_json, true );
?>
				<form class="warn-about-change" id="wgextra_template_form" method="post" action="">
					<input type="hidden" name="wgextra_task" value="save_template_settings">
					<input type="hidden" name="wgextra_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wgextra_save_template_settings' ) ); ?>">
					<input type="hidden" name="id" value="<?php echo $id; ?>">
					<div class="inside ui-tabs-panel" id="wgextra-settings">
						<p><?php _e( "Personalize your gallery template with the following settings.", 'wordpress-gallery-extra' ); ?></p>
						<table class="form-table">
							<tr>
								<th><label for="wgextra_name"><?php _e( "Name", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<input type="text" id="wgextra_name" name="wgextra_name" value="<?php echo esc_attr( $options['name'] ); ?>" /><br>
									<p class="description"><?php _e( "Enter the name of the current template. The template name must be unique in order to prevent any conflict.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr>
								<th><label for="wgextra_template"><?php _e( "Gallery Type", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<select id="wgextra_template" name="wgextra_template">
<?php
				foreach ( $this->TEMPLATES_TYPES as $key => $value ) {
?>
										<option value="<?php echo esc_attr( $key ); ?>"<?php selected( $options['template'], $key ); ?>><?php echo $value['name']; ?></option>
<?php
				}
?>
									</select><br />
									<p class="description"><?php _e( "The gallery type that will be used when the gallery is output to the frontend.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr class="field" rel="gallery_structure">
								<th><label><?php _e( 'Gallery Structure', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<div class="switch-field">
										<label for="wgextra_structure_type-auto"><?php _e( "Auto", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_structure_type" id="wgextra_structure_type-auto" value="auto"<?php checked( $options['structure_type'], 'auto' ); ?> />
										<label for="wgextra_structure_type-manual"><?php _e( "Manual", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_structure_type" id="wgextra_structure_type-manual" value="manual"<?php checked( $options['structure_type'], 'manual' ); ?> />
									</div>
									<p class="description"><?php _e( "By using this feature you can control the entire gallery's skeleton structure.", 'wordpress-gallery-extra' ); ?></p>
									<p class="description"><strong><?php _e( "Note:", 'wordpress-gallery-extra' ); ?></strong> <?php _e( "Don't change it to manual until you know what to do!", 'wordpress-gallery-extra' ); ?></p>
									<div id="custom_gallery_structure">
										<br/>
										<textarea class="twig" rows="1" id='wgextra_structure_custom' name='wgextra_structure_custom' placeholder='<?php esc_attr_e( 'Your custom gallery structure goes here...', 'wordpress-gallery-extra' ); ?>'><?php echo esc_textarea( $options['structure_custom'] ); ?></textarea>
										<p class="description"><?php printf( __( "You can use <a target='_blank' href='%s'>Twig Template Engine</a> as structure.", 'wordpress-gallery-extra' ), 'https://twig.symfony.com/' ); ?></p>
									</div>
<?php } ?>
								</td>
							</tr>
							<tr class="field" rel="loading_type">
								<th><label><?php _e( 'Loading Type', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<div class="switch-field">
										<label for="wgextra_loading_type-none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_loading_type" id="wgextra_loading_type-none" value="none"<?php checked( $options['loading_type'], 'none' ); ?> />
										<label for="wgextra_loading_type-lazyload"<?php if( !$this->is_active() && !$this->is_extended() ) { ?> title="<?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?>"<?php } else { ?> title="<?php _e( "Delays loading of images in long grids. Images outside of viewport are not loaded until user scrolls to them.", 'wordpress-gallery-extra' ); ?>"<?php } ?>><?php _e( "Lazy Load", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_loading_type" id="wgextra_loading_type-lazyload" value="lazyload"<?php checked( $options['loading_type'], 'lazyload' ); ?><?php if( !$this->is_active() && !$this->is_extended() ) { ?> disabled="disabled"<?php } ?> />
										<label for="wgextra_loading_type-indicator" title="<?php _e( "An animated loading animation indicator is shown before the thumbnails have loaded.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Loading Indicator", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_loading_type" id="wgextra_loading_type-indicator" value="indicator"<?php checked( $options['loading_type'], 'indicator' ); ?> />
									</div>
									<p class="description"><?php _e( "Thumbnails loading type in the grid.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr class="field" rel="use_lowres_image">
								<th><label><?php _e( 'Use Low-res preview image', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<div class="switch-field">
										<label for="wgextra_use_lowres_image-yes"><?php _e( "Yes", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_use_lowres_image" id="wgextra_use_lowres_image-yes" value="yes"<?php checked( $options['use_lowres_image'], 'yes' ); ?> />
										<label for="wgextra_use_lowres_image-no"><?php _e( "No", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_use_lowres_image" id="wgextra_use_lowres_image-no" value="no"<?php checked( $options['use_lowres_image'], 'no' ); ?> />
									</div>
									<p class="description"><?php printf( __( "Shows a low resolution preview image before the real image loads. Images uploaded before this plugin is activated need that have their image sizes regenerated for the feature to work. This can be done using <a target='_blank' href='%s'>Thumbnails Regenerator</a>.", 'wordpress-gallery-extra' ), admin_url( 'admin.php?page=wgextra_images_sizes#thumbnails_regenerator' ) ); ?></p>
<?php } ?>
								</td>
							</tr>
							<tr class="field" rel="loading_grid_animation">
								<th><label><?php _e( 'Grid Loading Animation', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<select id="wgextra_loading_grid_animation" name="wgextra_loading_grid_animation">
										<option value=""><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
										<option value="hapi"<?php selected( $options['loading_grid_animation'], 'hapi' ); ?>><?php _e( "Hapi", 'wordpress-gallery-extra' ); ?></option>
										<option value="amun"<?php selected( $options['loading_grid_animation'], 'amun' ); ?>><?php _e( "Amun", 'wordpress-gallery-extra' ); ?></option>
										<option value="kuk"<?php selected( $options['loading_grid_animation'], 'kuk' ); ?>><?php _e( "Kuk", 'wordpress-gallery-extra' ); ?></option>
										<option value="isis"<?php selected( $options['loading_grid_animation'], 'isis' ); ?>><?php _e( "Isis", 'wordpress-gallery-extra' ); ?></option>
										<option value="montu"<?php selected( $options['loading_grid_animation'], 'montu' ); ?>><?php _e( "Montu", 'wordpress-gallery-extra' ); ?></option>
										<option value="osiris"<?php selected( $options['loading_grid_animation'], 'osiris' ); ?>><?php _e( "Osiris", 'wordpress-gallery-extra' ); ?></option>
										<option value="satet"<?php selected( $options['loading_grid_animation'], 'satet' ); ?>><?php _e( "Satet", 'wordpress-gallery-extra' ); ?></option>
										<option value="atum"<?php selected( $options['loading_grid_animation'], 'atum' ); ?>><?php _e( "Atum", 'wordpress-gallery-extra' ); ?></option>
										<option value="ra"<?php selected( $options['loading_grid_animation'], 'ra' ); ?>><?php _e( "Ra", 'wordpress-gallery-extra' ); ?></option>
										<option value="sobek"<?php selected( $options['loading_grid_animation'], 'sobek' ); ?>><?php _e( "Sobek", 'wordpress-gallery-extra' ); ?></option>
										<option value="ptah"<?php selected( $options['loading_grid_animation'], 'ptah' ); ?>><?php _e( "Ptah", 'wordpress-gallery-extra' ); ?></option>
										<option value="bes"<?php selected( $options['loading_grid_animation'], 'bes' ); ?>><?php _e( "Bes", 'wordpress-gallery-extra' ); ?></option>
										<option value="seker"<?php selected( $options['loading_grid_animation'], 'seker' ); ?>><?php _e( "Seker", 'wordpress-gallery-extra' ); ?></option>
										<option value="nut"<?php selected( $options['loading_grid_animation'], 'nut' ); ?>><?php _e( "Nut", 'wordpress-gallery-extra' ); ?></option>
										<option value="shu"<?php selected( $options['loading_grid_animation'], 'shu' ); ?>><?php _e( "Shu", 'wordpress-gallery-extra' ); ?></option>
										<option value="apis"<?php selected( $options['loading_grid_animation'], 'apis' ); ?>><?php _e( "Apis", 'wordpress-gallery-extra' ); ?></option>
									</select><br />
									<p class="description"><?php _e( "Add loading animations to grid items.", 'wordpress-gallery-extra' ); ?></p>
<?php } ?>
								</td>
							</tr>
							<tr class="field" rel="lightbox">
								<th><label><?php _e( 'Lightbox Type', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<div class="switch-field">
										<label for="wgextra_lightbox_type-none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_lightbox_type" id="wgextra_lightbox_type-none" value="none"<?php checked( $options['lightbox_type'], 'none' ); ?> />
										<label for="wgextra_lightbox_type-magnific"><?php _e( "Magnific Popup", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_lightbox_type" id="wgextra_lightbox_type-magnific" value="magnific"<?php checked( $options['lightbox_type'], 'magnific' ); ?> />
										<label for="wgextra_lightbox_type-photoswipe"<?php if( !$this->is_active() && !$this->is_extended() ) { ?> title="<?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?>"<?php } ?>><?php _e( "PhotoSwipe", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_lightbox_type" id="wgextra_lightbox_type-photoswipe" value="photoswipe"<?php checked( $options['lightbox_type'], 'photoswipe' ); ?><?php if( !$this->is_active() && !$this->is_extended() ) { ?> disabled="disabled"<?php } ?> />
										<label for="wgextra_lightbox_type-fancybox"<?php if( !$this->is_active() && !$this->is_extended() ) { ?> title="<?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?>"<?php } ?>><?php _e( "FancyBox", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_lightbox_type" id="wgextra_lightbox_type-fancybox" value="fancybox"<?php checked( $options['lightbox_type'], 'fancybox' ); ?><?php if( !$this->is_active() && !$this->is_extended() ) { ?> disabled="disabled"<?php } ?> />
										<label for="wgextra_lightbox_type-ilightbox"<?php if( !class_exists( "iLightBox" ) ) { ?> title="<?php esc_attr_e( 'Please download and activate iLightBox plugin to enable this feature.', 'wordpress-gallery-extra' ); ?>"<?php } ?>><?php _e( "iLightBox", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_lightbox_type" id="wgextra_lightbox_type-ilightbox" value="ilightbox"<?php checked( $options['lightbox_type'], 'ilightbox' ); ?><?php if( !class_exists( "iLightBox" ) ) { ?> disabled="disabled"<?php } ?> />
										<label for="wgextra_lightbox_type-custom"<?php if( !$this->is_active() && !$this->is_extended() ) { ?> title="<?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?>"<?php } ?>><?php _e( "Custom", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_lightbox_type" id="wgextra_lightbox_type-custom" value="custom"<?php checked( $options['lightbox_type'], 'custom' ); ?><?php if( !$this->is_active() && !$this->is_extended() ) { ?> disabled="disabled"<?php } ?> />
									</div>
									<p class="description"><?php _e( 'Choose the default LightBox to be used.', 'wordpress-gallery-extra' ); ?> <?php printf( __( '<a target="_blank" rel="noreferrer noopener" href="%s">Download and activate iLightBox</a> which works flawlessly with WordPress Gallery Extra.', 'wordpress-gallery-extra' ), esc_url( "http://goo.gl/DlaJq" ) ); ?></p>
									<div class="inside-table" id="magnific-popup-settings">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_lightbox_magnific_animation" title="<?php esc_attr_e( "Popup opening & closing animation type.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Animation", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_magnific_vertical_fit" title="<?php esc_attr_e( "Fits image in area vertically.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Vertical Fit", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_magnific_preload" title="<?php esc_attr_e( "Wait for images to load before displaying?", 'wordpress-gallery-extra' ); ?>"><?php _e( "Preload", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_magnific_deeplink" title="<?php esc_attr_e( "Enabling the hash linking images.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Deeplinking", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select name="wgextra_lightbox_magnific_animation" id="wgextra_lightbox_magnific_animation">
															<option value="mfp-none"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-none' ); ?>><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-fade"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-fade' ); ?>><?php _e( "Fade", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-zoom-in"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-zoom-in' ); ?>><?php _e( "Zoom In Out", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-newspaper"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-newspaper' ); ?>><?php _e( "Newspaper", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-move-horizontal"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-move-horizontal' ); ?>><?php _e( "Move Horizontal", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-move-vertical"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-move-vertical' ); ?>><?php _e( "Move Vertical", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-3d-unfold"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-3d-unfold' ); ?>><?php _e( "3d Unfold", 'wordpress-gallery-extra' ); ?></option>
															<option value="mfp-zoom-out"<?php selected( $options['lightbox_magnific']['animation'], 'mfp-zoom-out' ); ?>><?php _e( "Zoom Out In", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_magnific_vertical_fit" class="onoffswitch-checkbox" id="wgextra_lightbox_magnific_vertical_fit"<?php checked( $options['lightbox_magnific']['vertical_fit'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_magnific_vertical_fit">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_magnific_preload" class="onoffswitch-checkbox" id="wgextra_lightbox_magnific_preload"<?php checked( $options['lightbox_magnific']['preload'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_magnific_preload">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_magnific_deeplink" class="onoffswitch-checkbox" id="wgextra_lightbox_magnific_deeplink"<?php checked( $options['lightbox_magnific']['deeplink'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_magnific_deeplink">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
									<div class="inside-table" id="photoswipe-settings">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_lightbox_photoswipe_skin"><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_photoswipe_loop" title="<?php esc_attr_e( "Loop slides when using swipe gesture.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Loop", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_photoswipe_deeplink" title="<?php esc_attr_e( "Enabling the hash linking images.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Deeplinking", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_photoswipe_share_buttons"><?php _e( "Share Buttons", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_photoswipe_download" title="<?php esc_attr_e( "Make images available for download.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Download Image", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select name="wgextra_lightbox_photoswipe_skin" id="wgextra_lightbox_photoswipe_skin">
															<option value="black"><?php _e( "Black", 'wordpress-gallery-extra' ); ?></option>
															<option value="white"<?php selected( $options['lightbox_photoswipe']['skin'], 'white' ); ?>><?php _e( "White", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_photoswipe_loop" class="onoffswitch-checkbox" id="wgextra_lightbox_photoswipe_loop"<?php checked( $options['lightbox_photoswipe']['loop'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_photoswipe_loop">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_photoswipe_deeplink" class="onoffswitch-checkbox" id="wgextra_lightbox_photoswipe_deeplink"<?php checked( $options['lightbox_photoswipe']['deeplink'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_photoswipe_deeplink">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_photoswipe_share_buttons" class="onoffswitch-checkbox" id="wgextra_lightbox_photoswipe_share_buttons"<?php checked( $options['lightbox_photoswipe']['share_buttons'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_photoswipe_share_buttons">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_photoswipe_download" class="onoffswitch-checkbox" id="wgextra_lightbox_photoswipe_download"<?php checked( $options['lightbox_photoswipe']['download'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_photoswipe_download">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
									<div class="inside-table" id="fancybox-settings">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_lightbox_fancybox_animation" title="<?php esc_attr_e( "Open/close animation effect type.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Animation Effect", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_fancybox_transition" title="<?php esc_attr_e( "Transition effect between slides.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Transition Effect", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_fancybox_loop" title="<?php esc_attr_e( "Enable infinite gallery navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Loop", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select name="wgextra_lightbox_fancybox_animation" id="wgextra_lightbox_fancybox_animation">
															<option value=""><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
															<option value="fade"<?php selected( $options['lightbox_fancybox']['animation'], 'fade' ); ?>><?php _e( "Fade", 'wordpress-gallery-extra' ); ?></option>
															<option value="zoom"<?php selected( $options['lightbox_fancybox']['animation'], 'zoom' ); ?>><?php _e( "Zoom", 'wordpress-gallery-extra' ); ?></option>
															<option value="zoom-in-out"<?php selected( $options['lightbox_fancybox']['animation'], 'zoom-in-out' ); ?>><?php _e( "Zoom in out", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<select name="wgextra_lightbox_fancybox_transition" id="wgextra_lightbox_fancybox_transition">
															<option value=""><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
															<option value="fade"<?php selected( $options['lightbox_fancybox']['transition'], 'fade' ); ?>><?php _e( "Fade", 'wordpress-gallery-extra' ); ?></option>
															<option value="slide"<?php selected( $options['lightbox_fancybox']['transition'], 'slide' ); ?>><?php _e( "Slide", 'wordpress-gallery-extra' ); ?></option>
															<option value="circular"<?php selected( $options['lightbox_fancybox']['transition'], 'circular' ); ?>><?php _e( "Circular", 'wordpress-gallery-extra' ); ?></option>
															<option value="tube"<?php selected( $options['lightbox_fancybox']['transition'], 'tube' ); ?>><?php _e( "Tube", 'wordpress-gallery-extra' ); ?></option>
															<option value="zoom-in-out"<?php selected( $options['lightbox_fancybox']['transition'], 'zoom-in-out' ); ?>><?php _e( "Zoom in out", 'wordpress-gallery-extra' ); ?></option>
															<option value="rotate"<?php selected( $options['lightbox_fancybox']['transition'], 'rotate' ); ?>><?php _e( "Rotate", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_fancybox_loop" class="onoffswitch-checkbox" id="wgextra_lightbox_fancybox_loop"<?php checked( $options['lightbox_fancybox']['loop'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_fancybox_loop">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_lightbox_fancybox_deeplink" title="<?php esc_attr_e( "Enabling the hash linking images.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Deeplinking", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_fancybox_download" title="<?php esc_attr_e( "Make images available for download.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Download Image", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_fancybox_preload" title="<?php esc_attr_e( "Wait for images to load before displaying?", 'wordpress-gallery-extra' ); ?>"><?php _e( "Preload", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_fancybox_deeplink" class="onoffswitch-checkbox" id="wgextra_lightbox_fancybox_deeplink"<?php checked( $options['lightbox_fancybox']['deeplink'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_fancybox_deeplink">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_fancybox_download" class="onoffswitch-checkbox" id="wgextra_lightbox_fancybox_download"<?php checked( $options['lightbox_fancybox']['download'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_fancybox_download">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_fancybox_preload" class="onoffswitch-checkbox" id="wgextra_lightbox_fancybox_preload"<?php checked( $options['lightbox_fancybox']['preload'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_fancybox_preload">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
									<div class="inside-table" id="ilightbox-settings">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_lightbox_ilightbox_skin"><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_ilightbox_direction" title="<?php esc_attr_e( "Sets direction for switching windows.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Direction", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_ilightbox_loop" title="<?php esc_attr_e( "Enable infinite lightbox navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Loop", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_ilightbox_carousel_mode" title="<?php esc_attr_e( "Enable carousel style lightbox navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Carousel Mode", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select name="wgextra_lightbox_ilightbox_skin" id="wgextra_lightbox_ilightbox_skin">
															<option value="flat-dark"<?php selected( $options['lightbox_ilightbox']['skin'], 'flat-dark' ); ?>><?php _e( "Flat Dark", 'wordpress-gallery-extra' ); ?></option>
															<option value="dark"<?php selected( $options['lightbox_ilightbox']['skin'], 'dark' ); ?>><?php _e( "Dark", 'wordpress-gallery-extra' ); ?></option>
															<option value="light"<?php selected( $options['lightbox_ilightbox']['skin'], 'light' ); ?>><?php _e( "Light", 'wordpress-gallery-extra' ); ?></option>
															<option value="smooth"<?php selected( $options['lightbox_ilightbox']['skin'], 'smooth' ); ?>><?php _e( "Smooth", 'wordpress-gallery-extra' ); ?></option>
															<option value="metro-black"<?php selected( $options['lightbox_ilightbox']['skin'], 'metro-black' ); ?>><?php _e( "Metro Black", 'wordpress-gallery-extra' ); ?></option>
															<option value="metro-white"<?php selected( $options['lightbox_ilightbox']['skin'], 'metro-white' ); ?>><?php _e( "Metro White", 'wordpress-gallery-extra' ); ?></option>
															<option value="mac"<?php selected( $options['lightbox_ilightbox']['skin'], 'mac' ); ?>><?php _e( "Mac", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<select name="wgextra_lightbox_ilightbox_direction" id="wgextra_lightbox_ilightbox_direction">
															<option value="horizontal"<?php selected( $options['lightbox_ilightbox']['direction'], 'horizontal' ); ?>><?php _e( "Horizontal", 'wordpress-gallery-extra' ); ?></option>
															<option value="vertical"<?php selected( $options['lightbox_ilightbox']['direction'], 'vertical' ); ?>><?php _e( "Vertical", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_ilightbox_loop" class="onoffswitch-checkbox" id="wgextra_lightbox_ilightbox_loop"<?php checked( $options['lightbox_ilightbox']['loop'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_ilightbox_loop">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_ilightbox_carousel_mode" class="onoffswitch-checkbox" id="wgextra_lightbox_ilightbox_carousel_mode"<?php checked( $options['lightbox_ilightbox']['carousel_mode'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_ilightbox_carousel_mode">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_lightbox_ilightbox_deeplink" title="<?php esc_attr_e( "Enabling the hash linking images.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Deeplinking", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_ilightbox_share_buttons" title="<?php esc_attr_e( "Display social buttons?", 'wordpress-gallery-extra' ); ?>"><?php _e( "Share Buttons", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_ilightbox_thumbnails" title="<?php esc_attr_e( "Show thumbnails navigation?", 'wordpress-gallery-extra' ); ?>"><?php _e( "Thumbnails", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_lightbox_ilightbox_overlay_opacity" title="<?php esc_attr_e( "Sets the opacity of the dimmed background of the page.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Overlay Opacity", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_ilightbox_deeplink" class="onoffswitch-checkbox" id="wgextra_lightbox_ilightbox_deeplink"<?php checked( $options['lightbox_ilightbox']['deeplink'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_ilightbox_deeplink">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_ilightbox_share_buttons" class="onoffswitch-checkbox" id="wgextra_lightbox_ilightbox_share_buttons"<?php checked( $options['lightbox_ilightbox']['share_buttons'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_ilightbox_share_buttons">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_lightbox_ilightbox_thumbnails" class="onoffswitch-checkbox" id="wgextra_lightbox_ilightbox_thumbnails"<?php checked( $options['lightbox_ilightbox']['thumbnails'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_lightbox_ilightbox_thumbnails">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<input rel='number' data-options='min:0, max:1, step: 0.01' id='wgextra_lightbox_ilightbox_overlay_opacity' name='wgextra_lightbox_ilightbox_overlay_opacity' value='<?php echo esc_attr( $options['lightbox_ilightbox']['overlay_opacity'] ); ?>' />
													</td>
												</tr>
											</tbody>
										</table>
									</div>
									<div id="custom_lightbox">
										<br/>
										<textarea class="javascript" rows="1" id='wgextra_lightbox' name='wgextra_lightbox' placeholder='$(SELECTOR).iLightBox();'><?php echo esc_textarea( $options['lightbox'] ); ?></textarea>
										<p class="description"><?php _e( 'Use your own lightbox function.', 'wordpress-gallery-extra' ); ?></p>
									</div>
								</td>
							</tr>
							<tr class="field" rel="caption_source">
								<th><label><?php _e( 'Caption Source', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<div class="switch-field">
										<label for="wgextra_caption_source-1"><?php _e( "Title", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_caption_source" id="wgextra_caption_source-1" value="title"<?php checked( $options['caption_source'], 'title' ); ?> />
										<label for="wgextra_caption_source-2"><?php _e( "Caption", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_caption_source" id="wgextra_caption_source-2" value="caption"<?php checked( $options['caption_source'], 'caption' ); ?> />
										<label for="wgextra_caption_source-3"><?php _e( "Alt Text", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_caption_source" id="wgextra_caption_source-3" value="alt"<?php checked( $options['caption_source'], 'alt' ); ?> />
										<label for="wgextra_caption_source-4"><?php _e( "Description", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_caption_source" id="wgextra_caption_source-4" value="description"<?php checked( $options['caption_source'], 'description' ); ?> />
										<label for="wgextra_caption_source-5"<?php if( !$this->is_active() && !$this->is_extended() ) { ?> title="<?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?>"<?php } ?>><?php _e( "Custom", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_caption_source" id="wgextra_caption_source-5" value="custom"<?php checked( $options['caption_source'], 'custom' ); ?><?php if( !$this->is_active() && !$this->is_extended() ) { ?> disabled="disabled"<?php } ?> />
									</div>
									<p class="description"><?php _e( "Pull captions from either the attachment Title, Caption, Alt Text or Description.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr class="field" rel="caption_custom">
								<th><label for="wgextra_custom_caption"><?php _e( 'Caption Custom Content', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<textarea class="twig" rows="1" id='wgextra_custom_caption' name='wgextra_custom_caption' placeholder='{{caption}}'><?php echo esc_textarea( $options['caption_custom'] ); ?></textarea>
									<p class="description"><?php _e( 'Use your own custom caption content.', 'wordpress-gallery-extra' ); ?> <?php printf( __( "You can use <a target='_blank' href='%s'>Twig Template Engine</a> as structure.", 'wordpress-gallery-extra' ), 'https://twig.symfony.com/' ); ?></p>
								</td>
							</tr>
							<tr class="field" rel="slider_settings">
								<th><label><?php _e( 'Slider Settings', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<div class="inside-table">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_sizing_method" title="<?php esc_attr_e( "With this you can make slider <code>Full-screen</code> or <code>Full-width</code> even if it does not supported in your theme, it also supports <code>Boxed</code> layouts.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Slider sizing method", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_slides_sizing_method" title="<?php esc_attr_e( "Decide how to sizing slides.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Slides sizing method", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_width" title="<?php esc_attr_e( "Sets the base slider width in pixels. Required when you want to use boxed layout and auto scale option.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Width", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_height" title="<?php esc_attr_e( "Sets the base slider width in height. Required when you want to use boxed and full-width layouts and auto scale option.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Height", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select id="wgextra_slider_settings_sizing_method" name="wgextra_slider_settings_sizing_method">
															<option value="boxed"<?php selected( $options['slider_settings']['sizing_method'], 'boxed' ); ?>><?php _e( "Boxed layout", 'wordpress-gallery-extra' ); ?></option>
															<option value="fullwidth"<?php selected( $options['slider_settings']['sizing_method'], 'fullwidth' ); ?>><?php _e( "Full-width", 'wordpress-gallery-extra' ); ?></option>
															<option value="fullscreen"<?php selected( $options['slider_settings']['sizing_method'], 'fullscreen' ); ?>><?php _e( "Full-screen", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<select id="wgextra_slider_settings_slides_sizing_method" name="wgextra_slider_settings_slides_sizing_method">
															<option value="unequal_columns"<?php selected( $options['slider_settings']['slides_sizing_method'], 'unequal_columns' ); ?>><?php _e( "Unequal Columns", 'wordpress-gallery-extra' ); ?></option>
															<option value="equal_columns"<?php selected( $options['slider_settings']['slides_sizing_method'], 'equal_columns' ); ?>><?php _e( "Equal Columns", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<input rel='number' data-options='min:0' id='wgextra_slider_settings_width' name='wgextra_slider_settings_width' value='<?php echo esc_attr( $options['slider_settings']['width'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['width'] ); ?>' />
													</td>
													<td>
														<input rel='number' data-options='min:0' id='wgextra_slider_settings_height' name='wgextra_slider_settings_height' value='<?php echo esc_attr( $options['slider_settings']['height'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['height'] ); ?>' />
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_slider_settings_auto_scale" title="<?php esc_attr_e( "Automatically updates slider height based on slider width.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Auto Scale", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_start_at" title="<?php esc_attr_e( "Starting offset in slides.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Start At", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_start_random" title="<?php esc_attr_e( "Starting offset in slides randomly.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Start Random", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_auto_scale" class="onoffswitch-checkbox" id="wgextra_slider_settings_auto_scale"<?php checked( $options['slider_settings']['auto_scale'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_auto_scale">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<input rel='number' data-options='min:0' id='wgextra_slider_settings_start_at' name='wgextra_slider_settings_start_at' value='<?php echo esc_attr( $options['slider_settings']['start_at'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['start_at'] ); ?>' />
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_start_random" class="onoffswitch-checkbox" id="wgextra_slider_settings_start_random"<?php checked( $options['slider_settings']['start_random'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_start_random">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>

										<hr>
										<h4 class="wge-text-center wge-dark-gray"><?php _e( "Navigation", 'wordpress-gallery-extra' ); ?></h4>
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_mode" title="<?php esc_attr_e( "Switches between horizontal and vertical sliding mode.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Navigation Mode", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_type" title="<code><?php esc_attr_e( "Basic", 'wordpress-gallery-extra' ); ?></code>: <?php esc_attr_e( 'Slides snap to frame edges.', 'wordpress-gallery-extra' ); ?><br><br>
																																 <code><?php esc_attr_e( "Centered", 'wordpress-gallery-extra' ); ?></code>: <?php esc_attr_e( 'Activated slide, or slide that happens to be in the middle are positioned to the center of a visible frame when possible. &quot;When possible&quot; means that the first or last slides wont detach from the frame edges, thus they will remain at the start or end of the visible frame.', 'wordpress-gallery-extra' ); ?><br><br>
																																 <code><?php esc_attr_e( "Force Centered", 'wordpress-gallery-extra' ); ?></code>: <?php esc_attr_e( 'Same as centered, without the &quot;when possible&quot; part. All slides, even first and last ones can be positioned to the center of the frame when they are activated, or just moved there.', 'wordpress-gallery-extra' ); ?>"><?php _e( "Navigation Type", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_free_scroll" title="<?php esc_attr_e( "Enables slider to be freely scrolled.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Free Scroll", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_loop" title="<?php esc_attr_e( "Enable loop for when you are at the start or end of the slider.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Loop", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select id="wgextra_slider_settings_mode" name="wgextra_slider_settings_mode">
															<option value="horizontal"<?php selected( $options['slider_settings']['mode'], 'horizontal' ); ?>><?php _e( "Horizontal", 'wordpress-gallery-extra' ); ?></option>
															<option value="vertical"<?php selected( $options['slider_settings']['mode'], 'vertical' ); ?>><?php _e( "Vertical", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<select id="wgextra_slider_settings_type" name="wgextra_slider_settings_type">
															<option value="basic"<?php selected( $options['slider_settings']['type'], 'basic' ); ?>><?php _e( "Basic", 'wordpress-gallery-extra' ); ?></option>
															<option value="centered"<?php selected( $options['slider_settings']['type'], 'centered' ); ?>><?php _e( "Centered", 'wordpress-gallery-extra' ); ?></option>
															<option value="forceCentered"<?php selected( $options['slider_settings']['type'], 'forceCentered' ); ?>><?php _e( "Force Centered", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_free_scroll" class="onoffswitch-checkbox" id="wgextra_slider_settings_free_scroll"<?php checked( $options['slider_settings']['free_scroll'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_free_scroll">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_loop" class="onoffswitch-checkbox" id="wgextra_slider_settings_loop"<?php checked( $options['slider_settings']['loop'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_loop">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_slider_settings_scrollbar" title="<?php esc_attr_e( "Enable scrollbar navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Scrollbar", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_buttons" title="<?php esc_attr_e( "Enable navigation buttons.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Buttons", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_bullets" title="<?php esc_attr_e( "Enable bullets navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Bullets", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_thumbnails" title="<?php esc_attr_e( "Enable thumbnails navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Thumbnails", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_scrollbar" class="onoffswitch-checkbox" id="wgextra_slider_settings_scrollbar"<?php checked( $options['slider_settings']['scrollbar'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_scrollbar">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_arrows" class="onoffswitch-checkbox" id="wgextra_slider_settings_arrows"<?php checked( $options['slider_settings']['arrows'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_arrows">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_bullets" class="onoffswitch-checkbox" id="wgextra_slider_settings_bullets"<?php checked( $options['slider_settings']['bullets'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_bullets">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_thumbnails" class="onoffswitch-checkbox" id="wgextra_slider_settings_thumbnails"<?php checked( $options['slider_settings']['thumbnails'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_thumbnails">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_slider_settings_speed" title="<?php esc_attr_e( "Slide/Page change animations speed in milliseconds. 0 to disable animations.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Speed", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_easing" title="<?php esc_attr_e( "Specify the rate of transition over time.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Easing", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_scrolling" title="<?php esc_attr_e( "Slides to move per one mouse scroll. 0 to disable scrolling.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Scrolling", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_keyboard_navigation" title="<?php esc_attr_e( "Enable keyboard navigation.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Keyboard Navigation", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_slider_settings_speed' name='wgextra_slider_settings_speed' value='<?php echo esc_attr( $options['slider_settings']['speed'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['speed'] ); ?>' />
													</td>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $jquery_easings,
																'selected' => $options['slider_settings']['easing'],
																'id' => 'wgextra_slider_settings_easing',
																'name' => 'wgextra_slider_settings_easing'
															) );
														?>
													</td>
													<td>
														<input rel='number' data-options='min: 0' id='wgextra_slider_settings_scrolling' name='wgextra_slider_settings_scrolling' value='<?php echo esc_attr( $options['slider_settings']['scrolling'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['scrolling'] ); ?>' />
													</td>
													<td>
														<select name="wgextra_slider_settings_keyboard_navigation" id="wgextra_slider_settings_keyboard_navigation">
															<option value=""><?php _e( "Disabled", 'wordpress-gallery-extra' ); ?></option>
															<option value="slides"<?php selected( $options['slider_settings']['keyboard_navigation'], 'slides' ); ?>><?php _e( "by slides", 'wordpress-gallery-extra' ); ?></option>
															<option value="pages"<?php selected( $options['slider_settings']['keyboard_navigation'], 'pages' ); ?>><?php _e( "by pages", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
												</tr>
											</tbody>
										</table>

										<hr>
										<h4 class="wge-text-center wge-dark-gray"><?php _e( "Automated cycling navigation options", 'wordpress-gallery-extra' ); ?></h4>
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_cycle_by" title="<?php esc_attr_e( "Enable automatic cycling by 'slides' or 'pages'.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Cycling", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_pause_time" title="<?php esc_attr_e( "Delay between cycles in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Pause Time", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_repeat_cycling" title="<?php esc_attr_e( "Repeat cycling when last slide/page is activated.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Repeat Cycling", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_pause_on_hover" title="<?php esc_attr_e( "Pause cycling when mouse hovers over the slider.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Pause on Hover", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_start_paused" title="<?php esc_attr_e( "When cycling is enabled, this will start the slider in paused mode.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Start Paused", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select id="wgextra_slider_settings_cycle_by" name="wgextra_slider_settings_cycle_by">
															<option value=""><?php _e( "Disabled", 'wordpress-gallery-extra' ); ?></option>
															<option value="slides"<?php selected( $options['slider_settings']['cycle_by'], 'slides' ); ?>><?php _e( "by slides", 'wordpress-gallery-extra' ); ?></option>
															<option value="pages"<?php selected( $options['slider_settings']['cycle_by'], 'pages' ); ?>><?php _e( "by pages", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_slider_settings_pause_time' name='wgextra_slider_settings_pause_time' value='<?php echo esc_attr( $options['slider_settings']['pause_time'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['pause_time'] ); ?>' />
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_repeat_cycling" class="onoffswitch-checkbox" id="wgextra_slider_settings_repeat_cycling"<?php checked( $options['slider_settings']['repeat_cycling'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_repeat_cycling">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_pause_on_hover" class="onoffswitch-checkbox" id="wgextra_slider_settings_pause_on_hover"<?php checked( $options['slider_settings']['pause_on_hover'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_pause_on_hover">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_start_paused" class="onoffswitch-checkbox" id="wgextra_slider_settings_start_paused"<?php checked( $options['slider_settings']['start_paused'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_start_paused">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
										<hr>
										<h4 class="wge-text-center wge-dark-gray"><?php _e( "Mouse and touch dragging options", 'wordpress-gallery-extra' ); ?></h4>
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_mouse_dragging" title="<?php esc_attr_e( "Enable navigation by dragging with mouse cursor.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Mouse Dragging", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_touch_dragging" title="<?php esc_attr_e( "Enable navigation by dragging with touch.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Touch Dragging", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_release_swing" title="<?php esc_attr_e( "Ease out on dragging swing release.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Release Swing", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_elastic_bounds" title="<?php esc_attr_e( "Stretch slider position limits when dragging past frame boundaries.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Elastic Bounds", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_one_page_drag" title="<?php esc_attr_e( "Enable one page move per drag.", 'wordpress-gallery-extra' ); ?>"><?php _e( "One Page", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_mouse_dragging" class="onoffswitch-checkbox" id="wgextra_slider_settings_mouse_dragging"<?php checked( $options['slider_settings']['mouse_dragging'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_mouse_dragging">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_touch_dragging" class="onoffswitch-checkbox" id="wgextra_slider_settings_touch_dragging"<?php checked( $options['slider_settings']['touch_dragging'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_touch_dragging">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_release_swing" class="onoffswitch-checkbox" id="wgextra_slider_settings_release_swing"<?php checked( $options['slider_settings']['release_swing'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_release_swing">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_elastic_bounds" class="onoffswitch-checkbox" id="wgextra_slider_settings_elastic_bounds"<?php checked( $options['slider_settings']['elastic_bounds'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_elastic_bounds">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_one_page_drag" class="onoffswitch-checkbox" id="wgextra_slider_settings_one_page_drag"<?php checked( $options['slider_settings']['one_page_drag'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_one_page_drag">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
										<hr>
										<h4 class="wge-text-center wge-dark-gray"><?php _e( "Scrollbar options", 'wordpress-gallery-extra' ); ?></h4>
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_scrollbar_drag_handle" title="<?php esc_attr_e( "Whether the scrollbar handle should be draggable.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Drag handle", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_scrollbar_dynamic_handle" title="<?php esc_attr_e( "Scrollbar handle represents the ratio between hidden and visible content.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Dynamic handle", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_scrollbar_clickable" title="<?php esc_attr_e( "Enable navigation by clicking on scrollbar.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Clickable", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_scrollbar_min_handle_size" title="<?php esc_attr_e( "Minimal height or width (depends on slider direction) of a handle in pixels.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Minimum handle size", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_scrollbar_drag_handle" class="onoffswitch-checkbox" id="wgextra_slider_settings_scrollbar_drag_handle"<?php checked( $options['slider_settings']['scrollbar_drag_handle'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_scrollbar_drag_handle">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_scrollbar_dynamic_handle" class="onoffswitch-checkbox" id="wgextra_slider_settings_scrollbar_dynamic_handle"<?php checked( $options['slider_settings']['scrollbar_dynamic_handle'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_scrollbar_dynamic_handle">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_scrollbar_clickable" class="onoffswitch-checkbox" id="wgextra_slider_settings_scrollbar_clickable"<?php checked( $options['slider_settings']['scrollbar_clickable'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_scrollbar_clickable">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_slider_settings_scrollbar_min_handle_size' name='wgextra_slider_settings_scrollbar_min_handle_size' value='<?php echo esc_attr( $options['slider_settings']['scrollbar_min_handle_size'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['pause_time'] ); ?>' />
													</td>
												</tr>
											</tbody>
										</table>
										<hr>
										<h4 class="wge-text-center wge-dark-gray"><?php _e( "Transitions Effect", 'wordpress-gallery-extra' ); ?></h4>
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_animation_out" title="<?php esc_attr_e( "Animation effect for going out slide.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Animation Out", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_animation_in" title="<?php esc_attr_e( "Animation effect for upcoming slide.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Animation In", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select name="wgextra_slider_settings_animation_out[]" id="wgextra_slider_settings_animation_out" multiple>
															<option value="flash"<?php selected( in_array( 'flash', $options['slider_settings']['animation_out'] ) ); ?>>Flash</option>
															<option value="shake"<?php selected( in_array( 'shake', $options['slider_settings']['animation_out'] ) ); ?>>Shake</option>
															<option value="headShake"<?php selected( in_array( 'headShake', $options['slider_settings']['animation_out'] ) ); ?>>Head Shake</option>
															<option value="bounceOut"<?php selected( in_array( 'bounceOut', $options['slider_settings']['animation_out'] ) ); ?>>Bounce Out</option>
															<option value="bounceOutDown"<?php selected( in_array( 'bounceOutDown', $options['slider_settings']['animation_out'] ) ); ?>>Bounce Out Down</option>
															<option value="bounceOutLeft"<?php selected( in_array( 'bounceOutLeft', $options['slider_settings']['animation_out'] ) ); ?>>Bounce Out Left</option>
															<option value="bounceOutRight"<?php selected( in_array( 'bounceOutRight', $options['slider_settings']['animation_out'] ) ); ?>>Bounce Out Right</option>
															<option value="bounceOutUp"<?php selected( in_array( 'bounceOutUp', $options['slider_settings']['animation_out'] ) ); ?>>Bounce Out Up</option>
															<option value="fadeOut"<?php selected( in_array( 'fadeOut', $options['slider_settings']['animation_out'] ) ); ?>>Fade Out</option>
															<option value="fadeOutDown"<?php selected( in_array( 'fadeOutDown', $options['slider_settings']['animation_out'] ) ); ?>>Fade Out Down</option>
															<option value="fadeOutLeft"<?php selected( in_array( 'fadeOutLeft', $options['slider_settings']['animation_out'] ) ); ?>>Fade Out Left</option>
															<option value="fadeOutRight"<?php selected( in_array( 'fadeOutRight', $options['slider_settings']['animation_out'] ) ); ?>>Fade Out Right</option>
															<option value="fadeOutUp"<?php selected( in_array( 'fadeOutUp', $options['slider_settings']['animation_out'] ) ); ?>>Fade Out Up</option>
															<option value="flipOutX"<?php selected( in_array( 'flipOutX', $options['slider_settings']['animation_out'] ) ); ?>>Flip Out X</option>
															<option value="flipOutY"<?php selected( in_array( 'flipOutY', $options['slider_settings']['animation_out'] ) ); ?>>Flip Out Y</option>
															<option value="lightSpeedOut"<?php selected( in_array( 'lightSpeedOut', $options['slider_settings']['animation_out'] ) ); ?>>Light Speed Out</option>
															<option value="rotateOut"<?php selected( in_array( 'rotateOut', $options['slider_settings']['animation_out'] ) ); ?>>Rotate Out</option>
															<option value="rotateOutDownLeft"<?php selected( in_array( 'rotateOutDownLeft', $options['slider_settings']['animation_out'] ) ); ?>>Rotate Out Down Left</option>
															<option value="rotateOutDownRight"<?php selected( in_array( 'rotateOutDownRight', $options['slider_settings']['animation_out'] ) ); ?>>Rotate Out Down Right</option>
															<option value="rotateOutUpLeft"<?php selected( in_array( 'rotateOutUpLeft', $options['slider_settings']['animation_out'] ) ); ?>>Rotate Out Up Left</option>
															<option value="rotateOutUpRight"<?php selected( in_array( 'rotateOutUpRight', $options['slider_settings']['animation_out'] ) ); ?>>Rotate Out Up Right</option>
															<option value="slideOutUp"<?php selected( in_array( 'slideOutUp', $options['slider_settings']['animation_out'] ) ); ?>>Slide Out Up</option>
															<option value="slideOutDown"<?php selected( in_array( 'slideOutDown', $options['slider_settings']['animation_out'] ) ); ?>>Slide Out Down</option>
															<option value="slideOutLeft"<?php selected( in_array( 'slideOutLeft', $options['slider_settings']['animation_out'] ) ); ?>>Slide Out Left</option>
															<option value="slideOutRight"<?php selected( in_array( 'slideOutRight', $options['slider_settings']['animation_out'] ) ); ?>>Slide Out Right</option>
															<option value="zoomOut"<?php selected( in_array( 'zoomOut', $options['slider_settings']['animation_out'] ) ); ?>>Zoom Out </option>
															<option value="zoomOutDown"<?php selected( in_array( 'zoomOutDown', $options['slider_settings']['animation_out'] ) ); ?>>Zoom Out Down</option>
															<option value="zoomOutLeft"<?php selected( in_array( 'zoomOutLeft', $options['slider_settings']['animation_out'] ) ); ?>>Zoom Out Left</option>
															<option value="zoomOutRight"<?php selected( in_array( 'zoomOutRight', $options['slider_settings']['animation_out'] ) ); ?>>Zoom Out Right</option>
															<option value="zoomOutUp"<?php selected( in_array( 'zoomOutUp', $options['slider_settings']['animation_out'] ) ); ?>>Zoom Out Up</option>
															<option value="hinge"<?php selected( in_array( 'hinge', $options['slider_settings']['animation_out'] ) ); ?>>Hinge</option>
															<option value="rollOut"<?php selected( in_array( 'rollOut', $options['slider_settings']['animation_out'] ) ); ?>>Roll Out</option>
														</select>
													</td>
													<td>
														<select name="wgextra_slider_settings_animation_in[]" id="wgextra_slider_settings_animation_in" multiple>
															<option value="bounce"<?php selected( in_array( 'bounce', $options['slider_settings']['animation_in'] ) ); ?>>Bounce</option>
															<option value="flash"<?php selected( in_array( 'flash', $options['slider_settings']['animation_in'] ) ); ?>>Flash</option>
															<option value="pulse"<?php selected( in_array( 'pulse', $options['slider_settings']['animation_in'] ) ); ?>>Pulse</option>
															<option value="rubberBand"<?php selected( in_array( 'rubberBand', $options['slider_settings']['animation_in'] ) ); ?>>Rubber Band</option>
															<option value="shake"<?php selected( in_array( 'shake', $options['slider_settings']['animation_in'] ) ); ?>>Shake</option>
															<option value="headShake"<?php selected( in_array( 'headShake', $options['slider_settings']['animation_in'] ) ); ?>>Head Shake</option>
															<option value="swing"<?php selected( in_array( 'swing', $options['slider_settings']['animation_in'] ) ); ?>>Swing</option>
															<option value="tada"<?php selected( in_array( 'tada', $options['slider_settings']['animation_in'] ) ); ?>>Tada</option>
															<option value="wobble"<?php selected( in_array( 'wobble', $options['slider_settings']['animation_in'] ) ); ?>>Wobble</option>
															<option value="jello"<?php selected( in_array( 'jello', $options['slider_settings']['animation_in'] ) ); ?>>Jello</option>
															<option value="bounceIn"<?php selected( in_array( 'bounceIn', $options['slider_settings']['animation_in'] ) ); ?>>Bounce In</option>
															<option value="bounceInDown"<?php selected( in_array( 'bounceInDown', $options['slider_settings']['animation_in'] ) ); ?>>Bounce In Down</option>
															<option value="bounceInLeft"<?php selected( in_array( 'bounceInLeft', $options['slider_settings']['animation_in'] ) ); ?>>Bounce In Left</option>
															<option value="bounceInRight"<?php selected( in_array( 'bounceInRight', $options['slider_settings']['animation_in'] ) ); ?>>Bounce In Right</option>
															<option value="bounceInUp"<?php selected( in_array( 'bounceInUp', $options['slider_settings']['animation_in'] ) ); ?>>Bounce In Up</option>
															<option value="fadeIn"<?php selected( in_array( 'fadeIn', $options['slider_settings']['animation_in'] ) ); ?>>Fade In</option>
															<option value="fadeInDown"<?php selected( in_array( 'fadeInDown', $options['slider_settings']['animation_in'] ) ); ?>>Fade In Down</option>
															<option value="fadeInLeft"<?php selected( in_array( 'fadeInLeft', $options['slider_settings']['animation_in'] ) ); ?>>Fade In Left</option>
															<option value="fadeInRight"<?php selected( in_array( 'fadeInRight', $options['slider_settings']['animation_in'] ) ); ?>>Fade In Right</option>
															<option value="fadeInUp"<?php selected( in_array( 'fadeInUp', $options['slider_settings']['animation_in'] ) ); ?>>Fade In Up</option>
															<option value="flip"<?php selected( in_array( 'flip', $options['slider_settings']['animation_in'] ) ); ?>>Flip</option>
															<option value="flipInX"<?php selected( in_array( 'flipInX', $options['slider_settings']['animation_in'] ) ); ?>>Flip In X</option>
															<option value="flipInY"<?php selected( in_array( 'flipInY', $options['slider_settings']['animation_in'] ) ); ?>>Flip In Y</option>
															<option value="lightSpeedIn"<?php selected( in_array( 'lightSpeedIn', $options['slider_settings']['animation_in'] ) ); ?>>Light Speed In</option>
															<option value="rotateIn"<?php selected( in_array( 'rotateIn', $options['slider_settings']['animation_in'] ) ); ?>>Rotate In</option>
															<option value="rotateInDownLeft"<?php selected( in_array( 'rotateInDownLeft', $options['slider_settings']['animation_in'] ) ); ?>>RotateIn Down Left</option>
															<option value="rotateInDownRight"<?php selected( in_array( 'rotateInDownRight', $options['slider_settings']['animation_in'] ) ); ?>>RotateIn Down Right</option>
															<option value="rotateInUpLeft"<?php selected( in_array( 'rotateInUpLeft', $options['slider_settings']['animation_in'] ) ); ?>>RotateIn Up Left</option>
															<option value="rotateInUpRight"<?php selected( in_array( 'rotateInUpRight', $options['slider_settings']['animation_in'] ) ); ?>>RotateIn Up Right</option>
															<option value="slideInUp"<?php selected( in_array( 'slideInUp', $options['slider_settings']['animation_in'] ) ); ?>>Slide In Up</option>
															<option value="slideInDown"<?php selected( in_array( 'slideInDown', $options['slider_settings']['animation_in'] ) ); ?>>Slide In Down</option>
															<option value="slideInLeft"<?php selected( in_array( 'slideInLeft', $options['slider_settings']['animation_in'] ) ); ?>>Slide In Left</option>
															<option value="slideInRight"<?php selected( in_array( 'slideInRight', $options['slider_settings']['animation_in'] ) ); ?>>Slide In Right</option>
															<option value="zoomIn"<?php selected( in_array( 'zoomIn', $options['slider_settings']['animation_in'] ) ); ?>>Zoom In </option>
															<option value="zoomInDown"<?php selected( in_array( 'zoomInDown', $options['slider_settings']['animation_in'] ) ); ?>>Zoom In Down</option>
															<option value="zoomInLeft"<?php selected( in_array( 'zoomInLeft', $options['slider_settings']['animation_in'] ) ); ?>>Zoom In Left</option>
															<option value="zoomInRight"<?php selected( in_array( 'zoomInRight', $options['slider_settings']['animation_in'] ) ); ?>>Zoom In Right</option>
															<option value="zoomInUp"<?php selected( in_array( 'zoomInUp', $options['slider_settings']['animation_in'] ) ); ?>>Zoom In Up</option>
															<option value="rollIn"<?php selected( in_array( 'rollIn', $options['slider_settings']['animation_in'] ) ); ?>>Roll In</option>
															<option value="jackInTheBox"<?php selected( in_array( 'jackInTheBox', $options['slider_settings']['animation_in'] ) ); ?>>Jack In The Box</option>
														</select>
													</td>
												</tr>
											</tbody>
										</table>
										<hr>
										<h4 class="wge-text-center wge-dark-gray"><?php _e( "Kenburns Effect", 'wordpress-gallery-extra' ); ?></h4>
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_slider_settings_kenburns_mode" title="<?php esc_attr_e( "Ken Burns transitions mode.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Transition Mode", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_kenburns_reverse" title="<?php esc_attr_e( "Reverse Ken Burns transition mode for when the transition has ended.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Reverse", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_slider_settings_kenburns_duration" title="<?php esc_attr_e( "Ken Burns transition effect duration in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Duration", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select id="wgextra_slider_settings_kenburns_mode" name="wgextra_slider_settings_kenburns_mode">
															<option value=""><?php _e( "Disabled", 'wordpress-gallery-extra' ); ?></option>
															<option value="In"<?php selected( $options['slider_settings']['kenburns_mode'], 'In' ); ?>><?php _e( "In", 'wordpress-gallery-extra' ); ?></option>
															<option value="Out"<?php selected( $options['slider_settings']['kenburns_mode'], 'Out' ); ?>><?php _e( "Out", 'wordpress-gallery-extra' ); ?></option>
															<option value="both"<?php selected( $options['slider_settings']['kenburns_mode'], 'both' ); ?>><?php _e( "In & Out", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_slider_settings_kenburns_reverse" class="onoffswitch-checkbox" id="wgextra_slider_settings_kenburns_reverse"<?php checked( $options['slider_settings']['kenburns_reverse'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_slider_settings_kenburns_reverse">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_slider_settings_kenburns_duration' name='wgextra_slider_settings_kenburns_duration' value='<?php echo esc_attr( $options['slider_settings']['kenburns_duration'] ); ?>' placeholder='<?php echo esc_attr( $default_options['slider_settings']['kenburns_duration'] ); ?>' />
													</td>
												</tr>
											</tbody>
										</table>
									</div>
<?php } ?>
								</td>
							</tr>
							<tr class="field" rel="tilt">
								<th><label><?php _e( 'Tilt Effect', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<div class="switch-field">
										<label for="wgextra_tilt_effect-yes"><?php _e( "Yes", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_tilt_effect" id="wgextra_tilt_effect-yes" value="yes"<?php checked( $options['tilt_effect'], 'yes' ); ?> />
										<label for="wgextra_tilt_effect-no"><?php _e( "No", 'wordpress-gallery-extra' ); ?></label>
										<input type="radio" name="wgextra_tilt_effect" id="wgextra_tilt_effect-no" value="no"<?php checked( $options['tilt_effect'], 'no' ); ?> />
									</div><br />
									<p class="description"><?php _e( "Add parallax tilt effect to items.", 'wordpress-gallery-extra' ); ?></p>
									<div class="inside-table">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label title="<?php esc_attr_e( "What element should be tilted.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Mode", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_tilt_options_maxtilt" title="<?php esc_attr_e( "Max tilt gets.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Max Tilt", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_tilt_options_speed" title="<?php esc_attr_e( "Speed of the enter/exit transition in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Speed", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_tilt_options_scale" title="<?php esc_attr_e( "Scale on hover. 2 = 200%, 1.5 = 150%, etc...", 'wordpress-gallery-extra' ); ?>"><?php _e( "Scale", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<div class="switch-field">
															<label for="wgextra_tilt_options_mode-item"><?php _e( "Item", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_tilt_options_mode" id="wgextra_tilt_options_mode-item" value="item"<?php checked( $options['tilt_options']['mode'], 'item' ); ?> />
															<label for="wgextra_tilt_options_mode-thumb"><?php _e( "Thumbnail", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_tilt_options_mode" id="wgextra_tilt_options_mode-thumb" value="thumb"<?php checked( $options['tilt_options']['mode'], 'thumb' ); ?> />
														</div>
													</td>
													<td>
														<input rel='number' data-options='min:5' id='wgextra_tilt_options_maxtilt' name='wgextra_tilt_options_maxtilt' value='<?php echo esc_attr( $options['tilt_options']['maxtilt'] ); ?>' />
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_tilt_options_speed' name='wgextra_tilt_options_speed' value='<?php echo esc_attr( $options['tilt_options']['speed'] ); ?>' />
													</td>
													<td>
														<input rel='number' data-options='min:0.2, max:3, step: 0.05' id='wgextra_tilt_options_scale' name='wgextra_tilt_options_scale' value='<?php echo esc_attr( $options['tilt_options']['scale'] ); ?>' />
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_tilt_options_glare" title="<?php esc_attr_e( "Max glare opacity.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Glare", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_tilt_options_perspective" title="<?php esc_attr_e( "Transform perspective, the lower the more extreme the tilt gets.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Perspective", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_tilt_options_reset" title="<?php esc_attr_e( "Turning On this option will reset the tilt effect when the user mouse leaves the item.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Reset", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label title="<?php esc_attr_e( "What axis should be enabled.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Axis", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<input rel='number' data-options='min:0, max:1, step: 0.01' id='wgextra_tilt_options_glare' name='wgextra_tilt_options_glare' value='<?php echo esc_attr( $options['tilt_options']['glare'] ); ?>' />
													</td>
													<td>
														<input rel='number' data-options='min:100, max:2000, step: 100' id='wgextra_tilt_options_perspective' name='wgextra_tilt_options_perspective' value='<?php echo esc_attr( $options['tilt_options']['perspective'] ); ?>' />
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_tilt_options_reset" class="onoffswitch-checkbox" id="wgextra_tilt_options_reset"<?php checked( $options['tilt_options']['reset'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_tilt_options_reset">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="switch-field">
															<label for="wgextra_tilt_options_axis-x"><?php _e( "X", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_tilt_options_axis" id="wgextra_tilt_options_axis-x" value="y"<?php checked( $options['tilt_options']['axis'], 'y' ); ?> />
															<label for="wgextra_tilt_options_axis-y"><?php _e( "Y", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_tilt_options_axis" id="wgextra_tilt_options_axis-y" value="x"<?php checked( $options['tilt_options']['axis'], 'x' ); ?> />
															<label for="wgextra_tilt_options_axis-both"><?php _e( "Both", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_tilt_options_axis" id="wgextra_tilt_options_axis-both" value="both"<?php checked( $options['tilt_options']['axis'], 'both' ); ?> />
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
<?php } ?>
								</td>
							</tr>
							<tr>
								<th><label><?php _e( 'Link', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<div class="inside-table">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_link_to" title="<?php esc_attr_e( "Controls where the thumbnails must link to.", 'wordpress-gallery-extra' ); ?>"><?php _e( "To", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_link_target" title="<?php esc_attr_e( "Set a custom target for link.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Target", 'wordpress-gallery-extra' ); ?></label></th>
													<th class="wgextra_link_url"><label for="wgextra_link_url" title="<?php esc_attr_e( "Point thumbnails to a custom URL.", 'wordpress-gallery-extra' ); ?>"><?php _e( "URL", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<select id="wgextra_link_to" name="wgextra_link_to">
															<option value="none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
															<option value="page"<?php selected( $options['link']['to'], 'page' ); ?>><?php _e( "Page URL", 'wordpress-gallery-extra' ); ?></option>
															<option value="file"<?php selected( $options['link']['to'], 'file' ); ?>><?php _e( "Media File", 'wordpress-gallery-extra' ); ?></option>
															<option value="custom"<?php selected( $options['link']['to'], 'custom' ); ?>><?php _e( "Custom URL", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $target_options,
																'selected' => $options['link']['target'],
																'id' => 'wgextra_link_target',
																'name' => 'wgextra_link_target'
															) );
														?>
													</td>
													<td class="wgextra_link_url">
														<input type="text" id='wgextra_link_url' name='wgextra_link_url' value='<?php echo esc_attr( $options['link']['url'] ); ?>' />
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr>
								<th><label for="wgextra_custom_class"><?php _e( 'Custom CSS class', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<input type="text" id="wgextra_custom_class" name="wgextra_custom_class" value="<?php echo esc_attr( $options['custom_class'] ); ?>" placeholder="custom-class  another-custom-class" />
									<p class="description"><?php _e( "CSS classes separated by space. Usefull to add custom css to the grid.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'settings', 'default' );
?>
						</table>
<?php
	$this->do_settings_sections( $wge_page, 'settings' );
?>
					</div><!-- end of inside -->

					<div class="inside ui-tabs-panel" id="wgextra-source">
						<p><?php _e( "Personalize your grid source with the following settings.", 'wordpress-gallery-extra' ); ?></p>
						<table class="form-table">
							<tr>
								<th><label for="wgextra_source"><?php _e( "Source", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="select-field source-types">
<?php
				foreach ( $this->SOURCES_TYPES as $key => $value ) {
?>
										<label for="wgextra_source-<?php echo $key; ?>" class="<?php echo $key; ?>"><i></i><span><?php echo $value['name']; ?></span></label>
										<input type="radio" name="wgextra_source" id="wgextra_source-<?php echo $key; ?>" value="<?php echo $key; ?>"<?php checked( $options['source']['source'], $key ); ?> />
<?php
				}
?>
									</div>
									<p class="description"><?php _e( "Select the type of content to display inside the grid.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr>
								<th><label for="wgextra_item_number"><?php _e( 'Item Number', 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<input rel='number' data-options='min:-1' id='wgextra_item_number' name='wgextra_item_number' value='<?php echo esc_attr( $options['source']['item_number'] ); ?>' />
									<p class="description"><?php _e( "Enter the number of items to load inside the grid.", 'wordpress-gallery-extra' ); ?></p>
									<div class="description">
										<strong><?php _e( "Note:", 'wordpress-gallery-extra' ); ?></strong>
										<ol>
											<li><?php _e( "-1 allows to load all items (only for Post Type)", 'wordpress-gallery-extra' ); ?></li>
											<li><?php printf( __( "0 corresponds to the default number of <a target='_blank' href='%s'>post per page</a>.", 'wordpress-gallery-extra' ), admin_url( 'options-reading.php' ) ); ?></li>
										</ol>
									</div>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'source', 'default' );
?>
						</table>

						<div class="field" rel="filter">
							<hr>
							<h3 class="wge-margin-bottom-none"><?php _e( "Filter Items", 'wordpress-gallery-extra' ); ?></h3>
							<p><?php _e( "Filter your grid source with the following options.", 'wordpress-gallery-extra' ); ?></p>

							<table class="form-table">
								<tr class="field" rel="post_types">
									<th scope="row"><label for="wgextra_post_types"><?php _e( "Post Type(s)", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<?php
											$this->create_dropdown( array(
												'options' => self::get_public_post_types(),
												'selected' => $options['source']['post_types'],
												'id' => 'wgextra_post_types',
												'name' => 'wgextra_post_types',
												'multiple' => true
											) );
										?>
										<p class="description"><?php _e( "Select one or several post type to display inside the current grid.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="post_status">
									<th scope="row"><label for="wgextra_post_status"><?php _e( "Post Status", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<?php
											$this->create_dropdown( array(
												'options' => array(
													'any' => __( 'Any', 'wordpress-gallery-extra' ),
													'publish' => __( 'Publish', 'wordpress-gallery-extra' ),
													'pending' => __( 'Pending', 'wordpress-gallery-extra' ),
													'draft' => __( 'Draft', 'wordpress-gallery-extra' ),
													'auto-draft' => __( 'Auto Draft', 'wordpress-gallery-extra' ),
													'future' => __( 'Future', 'wordpress-gallery-extra' ),
													'private' => __( 'Private', 'wordpress-gallery-extra' ),
													'inherit' => __( 'Inherit', 'wordpress-gallery-extra' ),
													'trash' => __( 'Trash', 'wordpress-gallery-extra' )
												),
												'selected' => $options['source']['post_status'],
												'id' => 'wgextra_post_status',
												'name' => 'wgextra_post_status',
												'multiple' => true
											) );
										?>
										<p class="description"><?php _e( "Show posts associated with certain status.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="taxonomies">
									<th scope="row"><label for="wgextra_taxonomies"><?php _e( "Categories/Taxonomies", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<div class="inside-table">
											<table class="form-table">
												<tbody>
													<tr>
														<th><label for="wgextra_taxonomies" title="<?php esc_attr_e( "Select taxonomy term(s) from the current post type(s).", 'wordpress-gallery-extra' ); ?>"><?php _e( "Terms", 'wordpress-gallery-extra' ); ?></label></th>
														<th><label for="wgextra_taxonomies_relation" title="<?php esc_attr_e( "The logical relationship between each taxonomy term when there is more than one.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Relation", 'wordpress-gallery-extra' ); ?></label></th>
													</tr>
													<tr>
														<td>
															<?php
																$this->create_dropdown( array(
																	'options' => array(),
																	'selected' => $options['source']['taxonomies'],
																	'id' => 'wgextra_taxonomies',
																	'name' => 'wgextra_taxonomies',
																	'multiple' => true
																) );
															?>
														</td>
														<td>
															<select name="wgextra_taxonomies_relation" id="wgextra_taxonomies_relation">
																<option value="OR"<?php selected( $options['source']['taxonomies_relation'], 'OR' ); ?>><?php _e( "Or", 'wordpress-gallery-extra' ); ?></option>
																<option value="AND"<?php selected( $options['source']['taxonomies_relation'], 'AND' ); ?>><?php _e( "And", 'wordpress-gallery-extra' ); ?></option>
															</select>
														</td>
													</tr>
												</tbody>
											</table>
										</div>
									</td>
								</tr>
								<tr class="field" rel="authors">
									<th scope="row"><label for="wgextra_authors"><?php _e( "Author(s)", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<div class="inside-table">
											<table class="form-table">
												<tbody>
													<tr>
														<th><label for="wgextra_authors"><?php _e( "Terms", 'wordpress-gallery-extra' ); ?></label></th>
														<th><label for="wgextra_authors_relation" title="<?php esc_attr_e( "Include or Exclude Posts Belonging to selected Author(s)", 'wordpress-gallery-extra' ); ?>"><?php _e( "Relation", 'wordpress-gallery-extra' ); ?></label></th>
													</tr>
													<tr>
														<td>
															<?php
																$this->create_dropdown( array(
																	'options' => self::get_all_authors(),
																	'selected' => $options['source']['authors'],
																	'id' => 'wgextra_authors',
																	'name' => 'wgextra_authors',
																	'multiple' => true
																) );
															?>
															<p class="description"><?php _e( "Select author(s) from the current post type(s).", 'wordpress-gallery-extra' ); ?></p>
															<div class="description">
																<strong><?php _e( "Note:", 'wordpress-gallery-extra' ); ?></strong>
																<ol>
																	<li><?php _e( "If no author selected then all authors will be displayed", 'wordpress-gallery-extra' ); ?></li>
																</ol>
															</div>
														</td>
														<td>
															<select name="wgextra_authors_relation" id="wgextra_authors_relation">
																<option value="in"<?php selected( $options['source']['authors_relation'], 'in' ); ?>><?php _e( "Include", 'wordpress-gallery-extra' ); ?></option>
																<option value="not_in"<?php selected( $options['source']['authors_relation'], 'not_in' ); ?>><?php _e( "Exclude", 'wordpress-gallery-extra' ); ?></option>
															</select>
														</td>
													</tr>
												</tbody>
											</table>
										</div>
									</td>
								</tr>
								<tr class="field" rel="exclude_posts">
									<th scope="row"><label for="wgextra_exclude_posts"><?php _e( "Exclude Post(s)", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<input type="text" id="wgextra_exclude_posts" name="wgextra_exclude_posts" value="<?php echo esc_attr( $options['source']['exclude_posts'] ); ?>" /><br>
										<p class="description"><?php _e( "Enter post ID(s) to exclude from the current source. Add post IDs separated by a comma (e.g: 43, 7, 99, 23, 76, 2).", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="include_posts">
									<th scope="row"><label for="wgextra_include_posts"><?php _e( "Include Post(s)", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<input type="text" id="wgextra_include_posts" name="wgextra_include_posts" value="<?php echo esc_attr( $options['source']['include_posts'] ); ?>" /><br>
										<p class="description"><?php _e( "Display only the specific post(s). Add post IDs separated by a comma (e.g: 43, 7, 99, 23, 76, 2).", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="ordering">
									<th scope="row"><label><?php _e( "Ordering", 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<div class="inside-table">
											<table class="form-table">
												<tbody>
													<tr>
														<th><label for="wgextra_ordering_order" title="<?php esc_attr_e( "Designates the ascending or descending order of the retrieved posts sort", 'wordpress-gallery-extra' ); ?>"><?php _e( "Order", 'wordpress-gallery-extra' ); ?></label></th>
														<th><label for="wgextra_ordering_order_by" title="<?php esc_attr_e( "Sort retrieved posts.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Order By", 'wordpress-gallery-extra' ); ?></label></th>
														<th><label for="wgextra_ordering_order_by_fallback" title="<?php esc_attr_e( "Fallback to sort retrieved posts.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Order By Fallback", 'wordpress-gallery-extra' ); ?></label></th>
														<th class="wgextra_ordering_meta_key hidden"><label for="wgextra_ordering_meta_key" title="<?php esc_attr_e( "Enter a meta key name to order by a meta key value", 'wordpress-gallery-extra' ); ?>"><?php _e( "Meta Key", 'wordpress-gallery-extra' ); ?></label></th>
													</tr>
													<tr>
														<td>
															<select name="wgextra_ordering_order" id="wgextra_ordering_order">
																<option value="ASC"<?php selected( $options['source']['ordering']['order'], 'ASC' ); ?>><?php _e( "Ascending", 'wordpress-gallery-extra' ); ?></option>
																<option value="DESC"<?php selected( $options['source']['ordering']['order'], 'DESC' ); ?>><?php _e( "Descending", 'wordpress-gallery-extra' ); ?></option>
															</select>
														</td>
														<td>
															<?php
																$this->create_dropdown( array(
																	'options' => $ordering_order_by_options,
																	'selected' => $options['source']['ordering']['order_by'],
																	'id' => 'wgextra_ordering_order_by',
																	'name' => 'wgextra_ordering_order_by'
																) );
															?>
														</td>
														<td>
															<?php
																$this->create_dropdown( array(
																	'options' => $ordering_order_by_options,
																	'selected' => $options['source']['ordering']['order_by_fallback'],
																	'id' => 'wgextra_ordering_order_by_fallback',
																	'name' => 'wgextra_ordering_order_by_fallback'
																) );
															?>
														</td>
														<td class="wgextra_ordering_meta_key hidden">
															<input type="text" id="wgextra_ordering_meta_key" name="wgextra_ordering_meta_key" value="<?php echo esc_attr( $options['source']['ordering']['meta_key'] ); ?>" />
														</td>
													</tr>
												</tbody>
											</table>
										</div>
									</td>
								</tr>
<?php
	$this->do_settings_fields( $wge_page, 'source', 'filter' );
?>
							</table>
						</div><!-- .field[rel="filter"] -->
<?php
	$this->do_settings_sections( $wge_page, 'source' );
?>
					</div><!-- end of inside -->

					<div class="inside ui-tabs-panel" id="wgextra-display">
						<div class="field" rel="display-grid">
							<h3 class="wge-margin-bottom-none"><?php _e( "Grid Settings", 'wordpress-gallery-extra' ); ?></h3>
							<p><?php _e( "Configure grid structure and how it will be displayed.", 'wordpress-gallery-extra' ); ?></p>

							<table class="form-table">
								<tr class="field" rel="default_image">
									<th><label for="wgextra_default_image"><?php _e( 'Default Image', 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<input rel='image' id='wgextra_default_image' name='wgextra_default_image' value='<?php echo esc_attr( $options['default_image'] ); ?>' />
										<p class="description"><?php _e( "Add a default image if image is missing.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="thumbnail_size">
									<th><label for="wgextra_thumbnail_size"><?php _e( 'Thumbnail Size', 'wordpress-gallery-extra' ); ?></label></th>
									<td>
<?
	$thumbnails_sizes = $this->get_image_sizes();
	$possible_sizes_names = apply_filters( 'image_size_names_choose', array(
		'thumbnail'       => __('Thumbnail'),
		'medium'          => __('Medium'),
		'large'           => __('Large')
	) );
?>
										<select name="wgextra_thumbnail_size" id="wgextra_thumbnail_size">
<?php
	foreach ( $thumbnails_sizes as $key => $size ) {
		$size_name = isset( $possible_sizes_names[$key] ) ? $possible_sizes_names[$key] : $key;
?>
											<option value="<?php echo $key; ?>"<?php selected( $options['thumbnail_size'], $key ); ?>><?php echo $size_name; ?></option>
<?php
	}
?>
										</select>
										<p class="description"><?php _e( "Select a size for image in the grid.", 'wordpress-gallery-extra' ); ?> <?php printf( __( "You can also manage image sizes in <a target='_blank' href='%s'>Image Sizes Settings</a>.", 'wordpress-gallery-extra' ), admin_url( 'admin.php?page=wgextra_images_sizes' ) ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="thumbnail_ratio">
									<th><label><?php _e( 'Thumbnail Ratio', 'wordpress-gallery-extra' ); ?></label></th>
									<td>
										<div class="switch-field">
											<label for="wgextra_thumbnail_ratio-default"><?php _e( "Default", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_thumbnail_ratio" id="wgextra_thumbnail_ratio-default" value="default"<?php checked( $options['thumbnail_ratio']['type'], 'default' ); ?> />
											<label for="wgextra_thumbnail_ratio-manual"><?php _e( "Manual", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_thumbnail_ratio" id="wgextra_thumbnail_ratio-manual" value="manual"<?php checked( $options['thumbnail_ratio']['type'], 'manual' ); ?> />
										</div>
										<div class="clear"></div>
										<div class="inside-table">
											<table class="form-table">
												<tbody>
													<tr>
														<th><label for="wgextra_thumbnail_ratio_size" title="<?php esc_attr_e( "Correspond to the ratio between width and height (X:Y) (e.g: 4:3 or 16:9 format)", 'wordpress-gallery-extra' ); ?>"><?php _e( "Ratio", 'wordpress-gallery-extra' ); ?></label></th>
														<th><label for="wgextra_thumbnail_ratio_force" title="<?php esc_attr_e( "This option will override all thumbnail sizes set in each post/item", 'wordpress-gallery-extra' ); ?>"><?php _e( "Force Thumbnail Sizes", 'wordpress-gallery-extra' ); ?></label></th>
													</tr>
													<tr>
														<td>
															<input rel='number' id='wgextra_thumbnail_ratio_size' name='wgextra_thumbnail_ratio_size[]' value='<?php echo esc_attr( $options['thumbnail_ratio']['size'][0] ); ?>' />
															&nbsp;&nbsp;:&nbsp;&nbsp;
															<input rel='number' id='wgextra_thumbnail_ratio_size' name='wgextra_thumbnail_ratio_size[]' value='<?php echo esc_attr( $options['thumbnail_ratio']['size'][1] ); ?>' />
														</td>
														<td>
															<div class="onoffswitch">
																<input type="checkbox" name="wgextra_thumbnail_ratio_force" class="onoffswitch-checkbox" id="wgextra_thumbnail_ratio_force"<?php checked( $options['thumbnail_ratio']['force'], 'yes' ); ?>>
																<label class="onoffswitch-label" for="wgextra_thumbnail_ratio_force">
																	<div class="onoffswitch-inner">
																		<div class="onoffswitch-active">ON</div>
																		<div class="onoffswitch-inactive">OFF</div>
																	</div>
																	<div class="onoffswitch-switch"></div>
																</label>
															</div>
														</td>
													</tr>
												</tbody>
											</table>
										</div>
									</td>
								</tr>
								<tr class="field" rel="columns">
									<th><label for="wgextra_columns"><?php _e( 'Columns', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
										<input rel='range' data-options="max: 9, min: 1, type: 'circle', pips: {}, forceTip: true" id='wgextra_columns' name='wgextra_columns' value='<?php echo esc_attr( $options['columns'] ); ?>' />
										<p class="description"><?php _e( "Set the number of columns you would like to have in your gallery.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="last_row">
									<th><label><?php _e( 'Last row', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
										<div class="switch-field">
											<label for="wgextra_last_row-1"><?php _e( "Align left", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_last_row" id="wgextra_last_row-1" value="nojustify"<?php checked( $options['last_row'], 'nojustify' ); ?> />
											<label for="wgextra_last_row-2"><?php _e( "Align center", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_last_row" id="wgextra_last_row-2" value="center"<?php checked( $options['last_row'], 'center' ); ?> />
											<label for="wgextra_last_row-3"><?php _e( "Align right", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_last_row" id="wgextra_last_row-3" value="right"<?php checked( $options['last_row'], 'right' ); ?> />
											<label for="wgextra_last_row-4"><?php _e( "Justify", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_last_row" id="wgextra_last_row-4" value="justify"<?php checked( $options['last_row'], 'justify' ); ?> />
											<label for="wgextra_last_row-5"><?php _e( "Hide", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_last_row" id="wgextra_last_row-5" value="hide"<?php checked( $options['last_row'], 'hide' ); ?> />
										</div>
										<p class="description"><?php _e( "Decide how to position the last row of images. Default the last row images are aligned to the left. You can also hide the row if it can't be justified and aligned to the center or to the right.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="alignment">
									<th><label><?php _e( 'Alignment', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
										<div class="switch-field">
											<label for="wgextra_alignment-1"><?php _e( "Left", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_alignment" id="wgextra_alignment-1" value="left"<?php checked( $options['alignment'], 'left' ); ?> />
											<label for="wgextra_alignment-2"><?php _e( "Center", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_alignment" id="wgextra_alignment-2" value="center"<?php checked( $options['alignment'], 'center' ); ?> />
											<label for="wgextra_alignment-3"><?php _e( "Right", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_alignment" id="wgextra_alignment-3" value="right"<?php checked( $options['alignment'], 'right' ); ?> />
										</div>
										<p class="description"><?php _e( "The horizontal alignment of the thumbnails inside the gallery.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="vertical_alignment">
									<th><label><?php _e( 'Vertical Alignment', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
										<div class="switch-field">
											<label for="wgextra_vertical_alignment-top"><?php _e( "Top", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_vertical_alignment" id="wgextra_vertical_alignment-top" value="top"<?php checked( $options['vertical_alignment'], 'top' ); ?> />
											<label for="wgextra_vertical_alignment-middle"><?php _e( "Middle", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_vertical_alignment" id="wgextra_vertical_alignment-middle" value="middle"<?php checked( $options['vertical_alignment'], 'middle' ); ?> />
											<label for="wgextra_vertical_alignment-bottom"><?php _e( "Bottom", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_vertical_alignment" id="wgextra_vertical_alignment-bottom" value="bottom"<?php checked( $options['vertical_alignment'], 'bottom' ); ?> />
										</div>
										<p class="description"><?php _e( "The vertical alignment of the thumbnails inside the gallery.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="row_height">
									<th><label for="wgextra_row_height"><?php _e( 'Row Height', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
										<input rel='number' id='wgextra_row_height' name='wgextra_row_height' value='<?php echo esc_attr( $options['row_height'] ); ?>' />
										<p class="description"><?php _e( "The preferred height of your gallery rows in pixel.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="max_row_height">
									<th><label for="wgextra_max_row_height"><?php _e( 'Max Row Height', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
									<?php
										$max_row_height = $this->split_number( $options['max_row_height'] );
									?>
										<input rel='number' data-options='min:-1' id='wgextra_max_row_height' name='wgextra_max_row_height' value='<?php echo esc_attr( $max_row_height['number'] ); ?>' />
										<select id="wgextra_max_row_height_unit" name="wgextra_max_row_height_unit">
											<option value="">px</option>
											<option value="%"<?php selected( $max_row_height['unit'], '%' ); ?>>%</option>
										</select><br />
										<p class="description"><?php _e( "A number (e.g 200) which specifies the maximum row height in pixels. Use <code>-1px</code> to remove the limit of the maximum row height. Alternatively, use a percentage (e.g. 200% which means that the row height cannot exceed <code>2 * Row Height</code>)", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
								<tr class="field" rel="mosaic_type">
									<th><label><?php _e( 'Mosaic Type', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
										<div class="switch-field">
											<label for="wgextra_mosaic_type-auto"><?php _e( "Auto", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_mosaic_type" id="wgextra_mosaic_type-auto" value="auto"<?php checked( $options['mosaic_type'], 'auto' ); ?> />
											<label for="wgextra_mosaic_type-manual"><?php _e( "Manual", 'wordpress-gallery-extra' ); ?></label>
											<input type="radio" name="wgextra_mosaic_type" id="wgextra_mosaic_type-manual" value="manual"<?php checked( $options['mosaic_type'], 'manual' ); ?> />
										</div>
									</td>
								</tr>
								<tr>
									<th><label for="wgextra_detect_focus_point"><?php _e( 'Auto Detect Focus Point', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
										<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
										<div class="onoffswitch">
											<input type="checkbox" name="wgextra_detect_focus_point" class="onoffswitch-checkbox" id="wgextra_detect_focus_point"<?php checked( $options['detect_focus_point'], 'yes' ); ?>>
											<label class="onoffswitch-label" for="wgextra_detect_focus_point">
												<div class="onoffswitch-inner">
													<div class="onoffswitch-active">ON</div>
													<div class="onoffswitch-inactive">OFF</div>
												</div>
												<div class="onoffswitch-switch"></div>
											</label>
										</div>
										<p class="description"><?php _e( "Auto detecting focus point to find good crops for images.", 'wordpress-gallery-extra' ); ?></p>
<?php
	}
?>
									</td>
								</tr>
								<tr>
									<th><label for="wgextra_grouped_items_mode"><?php _e( 'Grouped Items', 'wordpress-gallery-extra' ); ?></label></th>
									<td colspan="3">
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
										<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
										<div class="inside-table">
											<table class="form-table">
												<tbody>
													<tr>
														<th><label for="wgextra_grouped_items_mode" title="<?php esc_attr_e( "Set how to display grouped items in grid.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Mode", 'wordpress-gallery-extra' ); ?></label></th>
														<th rel="grouped_items_template"><label for="wgextra_grouped_items_template" title="<?php esc_attr_e( "Set layout template for grouped items in grid.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Template", 'wordpress-gallery-extra' ); ?></label></th>
													</tr>
													<tr>
														<td>
															<select id="wgextra_grouped_items_mode" name="wgextra_grouped_items_mode">
																<option value=""><?php _e( 'None', 'wordpress-gallery-extra' ); ?></option>
																<option value="lightbox"<?php selected( $options['grouped_items']['mode'], 'lightbox' ); ?>><?php _e( 'Show In Lightbox', 'wordpress-gallery-extra' ); ?></option>
																<option value="slider"<?php selected( $options['grouped_items']['mode'], 'slider' ); ?>><?php _e( 'Display as Slider', 'wordpress-gallery-extra' ); ?></option>
															</select>
														</td>
														<td rel="grouped_items_template">
															<select id="wgextra_grouped_items_template" name="wgextra_grouped_items_template">
																<option value="-1"><?php _e( 'Default', 'wordpress-gallery-extra' ); ?></option>
<?php
		foreach ( $templates as $key => $temp ) {
			if ( $temp['template'] !== 'slider' || $key === $id )
				continue;
?>
																<option value="<?php echo $key; ?>"<?php selected( $options['grouped_items']['template'], $key ); ?>><?php echo $temp['name']; ?></option>
<?php
		}
?>
															</select>
														</td>
													</tr>
												</tbody>
											</table>
										</div>
<?php
	}
?>
									</td>
								</tr>
<?php
	$this->do_settings_fields( $wge_page, 'display', 'grid' );
?>
							</table>
						</div>

						<div class="field" rel="responsive">
							<hr>
							<h3 class="wge-margin-bottom-none"><?php _e( "Responsive Settings", 'wordpress-gallery-extra' ); ?></h3>
							<p><?php _e( "Settings which makes grid render well on a variety of devices and window or screen sizes.", 'wordpress-gallery-extra' ); ?></p>

<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
							<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
							<table class="form-table">
								<tr>
									<td>
										<div class="inside-table responsive-options">
											<table class="form-table">
												<thead>
													<th><label><?php _e( "Device", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Desktop", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Laptop Large", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Laptop", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Tablet", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Tablet Small", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Mobile", 'wordpress-gallery-extra' ); ?></label></th>
												</thead>
												<tbody>
													<tr>
														<th class="wge-align-middle"><label title="<?php esc_attr_e( "Each device format correspond to a minimum width in px.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Browser Width", 'wordpress-gallery-extra' ); ?></label></th>
														<td>
															<input rel='number' name='wgextra_responsive_desktop_size' value='<?php echo esc_attr( $options['responsive']['desktop']['size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_large_size' value='<?php echo esc_attr( $options['responsive']['laptop_large']['size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_size' value='<?php echo esc_attr( $options['responsive']['laptop']['size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_size' value='<?php echo esc_attr( $options['responsive']['tablet']['size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_small_size' value='<?php echo esc_attr( $options['responsive']['tablet_small']['size'] ); ?>' />
														</td>
														<td>
															<em><?php echo $options['responsive']['mobile']['size']; ?></em>
														</td>
													</tr>
													<tr class="field" rel="columns">
														<th class="wge-align-middle"><label><?php _e( "Columns", 'wordpress-gallery-extra' ); ?></label></th>
														<td class="wge-align-middle"><em><?php _e( "Inherit", 'wordpress-gallery-extra' ); ?></em></td>
														<td>
															<input rel='number' data-options="min: 1, max: 9" name='wgextra_responsive_laptop_large_columns' value='<?php echo esc_attr( $options['responsive']['laptop_large']['columns'] ); ?>' />
														</td>
														<td>
															<input rel='number' data-options="min: 1, max: 9" name='wgextra_responsive_laptop_columns' value='<?php echo esc_attr( $options['responsive']['laptop']['columns'] ); ?>' />
														</td>
														<td>
															<input rel='number' data-options="min: 1, max: 9" name='wgextra_responsive_tablet_columns' value='<?php echo esc_attr( $options['responsive']['tablet']['columns'] ); ?>' />
														</td>
														<td>
															<input rel='number' data-options="min: 1, max: 9" name='wgextra_responsive_tablet_small_columns' value='<?php echo esc_attr( $options['responsive']['tablet_small']['columns'] ); ?>' />
														</td>
														<td>
															<input rel='number' data-options="min: 1, max: 9" name='wgextra_responsive_mobile_columns' value='<?php echo esc_attr( $options['responsive']['mobile']['columns'] ); ?>' />
														</td>
													</tr>
													<tr class="field" rel="row_height">
														<th class="wge-align-middle"><label><?php _e( "Row Height", 'wordpress-gallery-extra' ); ?></label></th>
														<td class="wge-align-middle"><em><?php _e( "Inherit", 'wordpress-gallery-extra' ); ?></em></td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_large_row_height' value='<?php echo esc_attr( $options['responsive']['laptop_large']['row_height'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_row_height' value='<?php echo esc_attr( $options['responsive']['laptop']['row_height'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_row_height' value='<?php echo esc_attr( $options['responsive']['tablet']['row_height'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_small_row_height' value='<?php echo esc_attr( $options['responsive']['tablet_small']['row_height'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_mobile_row_height' value='<?php echo esc_attr( $options['responsive']['mobile']['row_height'] ); ?>' />
														</td>
													</tr>
													<tr>
														<th><label><?php _e( "Spacing", 'wordpress-gallery-extra' ); ?></label></th>
														<td class="wge-align-middle"><em><?php _e( "Inherit", 'wordpress-gallery-extra' ); ?></em></td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_large_spacing' value='<?php echo esc_attr( $options['responsive']['laptop_large']['spacing'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_spacing' value='<?php echo esc_attr( $options['responsive']['laptop']['spacing'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_spacing' value='<?php echo esc_attr( $options['responsive']['tablet']['spacing'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_small_spacing' value='<?php echo esc_attr( $options['responsive']['tablet_small']['spacing'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_mobile_spacing' value='<?php echo esc_attr( $options['responsive']['mobile']['spacing'] ); ?>' />
														</td>
													</tr>
													<tr>
														<th class="wge-align-middle"><label><?php _e( "Icon Size", 'wordpress-gallery-extra' ); ?></label></th>
														<td class="wge-align-middle"><em><?php _e( "Inherit", 'wordpress-gallery-extra' ); ?></em></td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_large_icon_size' value='<?php echo esc_attr( $options['responsive']['laptop_large']['icon_size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_laptop_icon_size' value='<?php echo esc_attr( $options['responsive']['laptop']['icon_size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_icon_size' value='<?php echo esc_attr( $options['responsive']['tablet']['icon_size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_tablet_small_icon_size' value='<?php echo esc_attr( $options['responsive']['tablet_small']['icon_size'] ); ?>' />
														</td>
														<td>
															<input rel='number' name='wgextra_responsive_mobile_icon_size' value='<?php echo esc_attr( $options['responsive']['mobile']['icon_size'] ); ?>' />
														</td>
													</tr>
												</tbody>
											</table>
										</div>
										<p class="description">* <?php _e( "Empty values will allow to inherit of previous value.", 'wordpress-gallery-extra' ); ?></p>
									</td>
								</tr>
<?php
		$this->do_settings_fields( $wge_page, 'display', 'responsive' );
?>
							</table>
<?php
	}
?>
						</div>
<?php
	$this->do_settings_sections( $wge_page, 'display' );
?>
					</div><!-- end of inside -->

					<div class="inside ui-tabs-panel" id="wgextra-styling">
						<input type="hidden" name="preset_styles" value="<?php echo esc_attr( json_encode( $preset_styles ) ); ?>">
						<p><?php _e( "Style your gallery template with the following options.", 'wordpress-gallery-extra' ); ?></p>
						<table class="form-table">
							<tr class="field" rel="placeholder">
								<th><label for="wgextra_style_use_placeholder"><?php _e( "Use Placeholder", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="onoffswitch">
										<input type="checkbox" name="wgextra_style_use_placeholder" class="onoffswitch-checkbox" id="wgextra_style_use_placeholder"<?php checked( $options['styles']['use_placeholder'], 'yes' ); ?>>
										<label class="onoffswitch-label" for="wgextra_style_use_placeholder">
											<div class="onoffswitch-inner">
												<div class="onoffswitch-active">ON</div>
												<div class="onoffswitch-inactive">OFF</div>
											</div>
											<div class="onoffswitch-switch"></div>
										</label>
									</div><br />
									<div class="inside-table">
										<table class="form-table">
											<thead>
												<tr>
													<th><label for="wgextra_style_placeholder_overlay"><?php _e( "Overlay", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_placeholder_readable_caption"><?php _e( "Readable Caption Text Color", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_placeholder_background"><?php _e( "Image Background", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_style_placeholder_overlay" class="onoffswitch-checkbox" id="wgextra_style_placeholder_overlay"<?php checked( $options['styles']['placeholder']['overlay'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_style_placeholder_overlay">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_style_placeholder_readable_caption" class="onoffswitch-checkbox" id="wgextra_style_placeholder_readable_caption"<?php checked( $options['styles']['placeholder']['readable_caption'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_style_placeholder_readable_caption">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_style_placeholder_background" class="onoffswitch-checkbox" id="wgextra_style_placeholder_background"<?php checked( $options['styles']['placeholder']['background'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_style_placeholder_background">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr>
								<th><label for="wgextra_style_embed_google_fonts"><?php _e( "Embed Google Fonts", 'wordpress-gallery-extra' ); ?></label> <sup><?php _e( "Beta", 'wordpress-gallery-extra' ); ?></sup></th>
								<td>
									<input type="text" id="wgextra_style_embed_google_fonts" name="wgextra_style_embed_google_fonts" value="<?php echo esc_attr( $options['styles']['embed_google_fonts'] ); ?>" />
									<a class="ui-button" href="https://fonts.google.com" target="_blank"><?php _e( "Generate Embed Code", 'wordpress-gallery-extra' ); ?></a>
									<br>
									<p class="description"><?php _e( "If you want to use Google fonts in your template you need to insert your customized embed code here.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'default_top' );
?>
						</table>
						<hr />
						<table class="form-table">
							<tr>
								<th><label for="wgextra_template"><?php _e( "Presets", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="select-field">
										<label for="wgextra_style-default"><img src="<?php echo plugins_url( 'assets/img/style-icon.jpg', $this->MAIN ); ?>" /></label>
										<input type="radio" name="wgextra_style" id="wgextra_style-default" value="default"<?php checked( $options['styles']['defined'], 'default' ); ?> />
<?php
				foreach ( $preset_styles as $pid => $preset ) {
?>
										<label for="wgextra_style-<?php echo $pid; ?>"><img src="<?php echo plugins_url( 'assets/img/style-icon.jpg', $this->MAIN ); ?>" style="<?php echo esc_attr( $preset['style'] ); ?>" /></label>
										<input type="radio" name="wgextra_style" id="wgextra_style-<?php echo $pid; ?>" value="<?php echo $pid; ?>"<?php checked( $options['styles']['defined'], $pid ); ?> />
<?php
				}
?>
									</div>
									<p class="description"><?php _e( "The style for each thumbnail in the gallery.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr class="field" rel="margin">
								<th><label for="wgextra_style_margin"><?php _e( 'Spacing', 'wordpress-gallery-extra' ); ?></label></th>
								<td colspan="3">
									<input rel='number' id='wgextra_style_margin' name='wgextra_style_margin' value='<?php echo esc_attr( $options['styles']['margin'] ); ?>' /><br />
									<p class="description"><?php _e( "The spacing or gap between thumbnails in the gallery.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr class="field" rel="border">
								<th><label for="wgextra_style_border"><?php _e( "Border", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="onoffswitch">
										<input type="checkbox" name="wgextra_style_border" class="onoffswitch-checkbox" id="wgextra_style_border"<?php checked( $options['styles']['has_border'], 'yes' ); ?>>
										<label class="onoffswitch-label" for="wgextra_style_border">
											<div class="onoffswitch-inner">
												<div class="onoffswitch-active">ON</div>
												<div class="onoffswitch-inactive">OFF</div>
											</div>
											<div class="onoffswitch-switch"></div>
										</label>
									</div><br />
									<div class="inside-table">
										<table class="form-table">
											<thead>
												<tr>
													<th><label for="wgextra_style_border_radius"><?php _e( "Radius", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_border_weight"><?php _e( "Weight", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_border_style"><?php _e( "Type", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_border_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td>
														<input rel='number' id='wgextra_style_border_radius' name='wgextra_style_border_radius' value='<?php echo esc_attr( $options['styles']['border']['radius'] ); ?>' />
													</td>
													<td>
														<input rel='number' id='wgextra_style_border_weight' name='wgextra_style_border_weight' value='<?php echo esc_attr( $options['styles']['border']['weight'] ); ?>' />
													</td>
													<td>
														<select id="wgextra_style_border_style" name="wgextra_style_border_style">
															<option value="none"<?php selected( $options['styles']['border']['style'], 'none' ); ?>><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
															<option value="solid"<?php selected( $options['styles']['border']['style'], 'solid' ); ?>><?php _e( "Solid", 'wordpress-gallery-extra' ); ?></option>
															<option value="dotted"<?php selected( $options['styles']['border']['style'], 'dotted' ); ?>><?php _e( "Dotted", 'wordpress-gallery-extra' ); ?></option>
															<option value="dashed"<?php selected( $options['styles']['border']['style'], 'dashed' ); ?>><?php _e( "Dashed", 'wordpress-gallery-extra' ); ?></option>
															<option value="double"<?php selected( $options['styles']['border']['style'], 'double' ); ?>><?php _e( "Double", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td>
														<input rel="colorpicker" id="wgextra_style_border_color" name="wgextra_style_border_color" value="<?php echo esc_attr( $options['styles']['border']['color'] ); ?>" />
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr class="field" rel="shadow">
								<th><label for="wgextra_style_shadow"><?php _e( "Shadow", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="onoffswitch">
										<input type="checkbox" name="wgextra_style_shadow" class="onoffswitch-checkbox" id="wgextra_style_shadow"<?php checked( $options['styles']['has_shadow'], 'yes' ); ?>>
										<label class="onoffswitch-label" for="wgextra_style_shadow">
											<div class="onoffswitch-inner">
												<div class="onoffswitch-active">ON</div>
												<div class="onoffswitch-inactive">OFF</div>
											</div>
											<div class="onoffswitch-switch"></div>
										</label>
									</div><br />
									<div class="inside-table">
										<table class="form-table">
											<thead>
												<tr>
													<th><label for="wgextra_style_shadow_x"><?php _e( "X-offset", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_shadow_y"><?php _e( "Y-offset", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_shadow_blur"><?php _e( "Blur", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_shadow_spread"><?php _e( "Spread", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_shadow_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_shadow_inset"><?php _e( "Inset", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td>
														<input rel='number' id='wgextra_style_shadow_x' name='wgextra_style_shadow_x' value='<?php echo esc_attr( $options['styles']['shadow']['x'] ); ?>' />
													</td>
													<td>
														<input rel='number' id='wgextra_style_shadow_y' name='wgextra_style_shadow_y' value='<?php echo esc_attr( $options['styles']['shadow']['y'] ); ?>' />
													</td>
													<td>
														<input rel='number' id='wgextra_style_shadow_blur' name='wgextra_style_shadow_blur' value='<?php echo esc_attr( $options['styles']['shadow']['blur'] ); ?>' />
													</td>
													<td>
														<input rel='number' id='wgextra_style_shadow_spread' name='wgextra_style_shadow_spread' value='<?php echo esc_attr( $options['styles']['shadow']['spread'] ); ?>' />
													</td>
													<td>
														<input rel="colorpicker" id="wgextra_style_shadow_color" name="wgextra_style_shadow_color" value="<?php echo esc_attr( $options['styles']['shadow']['color'] ); ?>" />
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_style_shadow_inset" class="onoffswitch-checkbox" id="wgextra_style_shadow_inset"<?php checked( $options['styles']['shadow']['inset'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_style_shadow_inset">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr class="field" rel="icon">
								<th><label for="wgextra_style_icon"><?php _e( "Icon", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="onoffswitch">
										<input type="checkbox" name="wgextra_style_icon" class="onoffswitch-checkbox" id="wgextra_style_icon"<?php checked( $options['styles']['has_icon'], 'yes' ); ?>>
										<label class="onoffswitch-label" for="wgextra_style_icon">
											<div class="onoffswitch-inner">
												<div class="onoffswitch-active">ON</div>
												<div class="onoffswitch-inactive">OFF</div>
											</div>
											<div class="onoffswitch-switch"></div>
										</label>
									</div><br />
									<div class="inside-table">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label title="<?php esc_attr_e( "Choose which icon is shown for your thumbnails.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Icon", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_icon_size"><?php _e( "Size", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_icon_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_icon_visibility"><?php _e( "Visiblity", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td rowspan="4">
														<div class="select-field icons">
															<label for="wgextra_style_icon_icon-none"><i>&nbsp;&nbsp;&nbsp;&nbsp;</i></label>
															<input type="radio" name="wgextra_style_icon_icon" id="wgextra_style_icon_icon-none" value=""<?php checked( $options['styles']['icon']['icon'], '' ); ?> />
<?php
				$icons = isset( $icons['icons'] ) ? $icons['icons'] : array();
				$i = 0;
				foreach ( $icons as $icon ) {
					$id = $icon['properties']['name'];
?>
															<label for="wgextra_style_icon_icon-<?php echo $i; ?>"><i class="wgextra-icon wgextra-icon-<?php echo $id; ?>"></i></label>
										<input type="radio" name="wgextra_style_icon_icon" id="wgextra_style_icon_icon-<?php echo $i; ?>" value="<?php echo $id; ?>"<?php checked( $options['styles']['icon']['icon'], $id ); ?> />
<?php
					$i++;
				}
?>
														</div>
													</td>
													<td height="40">
														<input rel='number' id='wgextra_style_icon_size' name='wgextra_style_icon_size' value="<?php echo esc_attr( $options['styles']['icon']['size'] ); ?>" />
													</td>
													<td height="40">
														<input rel="colorpicker" id="wgextra_style_icon_color" name="wgextra_style_icon_color" value="<?php echo esc_attr( $options['styles']['icon']['color'] ); ?>" />
													</td>
													<td height="40">
														<?php
															$this->create_dropdown( array(
																'options' => $icon_visibilities,
																'selected' => $options['styles']['icon']['visibility'],
																'id' => 'wgextra_style_icon_visibility',
																'name' => 'wgextra_style_icon_visibility'
															) );
														?>
													</td>
												</tr>
												<tr>
													<td colspan="3"></td>
												</tr>
												<tr>
													<th class="wge-align-bottom" height="21"><label for="wgextra_style_icon_transition_speed" title="<?php esc_attr_e( "Speed of the enter/exit transition in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Speed", 'wordpress-gallery-extra' ); ?></label></th>
													<th class="wge-align-bottom" height="21"><label for="wgextra_style_icon_transition_delay" title="<?php esc_attr_e( "Defines how long to wait and the transition actually begins.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Delay", 'wordpress-gallery-extra' ); ?></label></th>
													<th class="wge-align-bottom" height="21"><label for="wgextra_style_icon_transition_easing" title="<?php esc_attr_e( "Specify the rate of transition over time.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Easing", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td class="wge-align-bottom" height="40">
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_icon_transition_speed' name='wgextra_style_icon_transition_speed' value="<?php echo esc_attr( $options['styles']['icon']['transition']['speed'] ); ?>" />
													</td>
													<td class="wge-align-bottom" height="40">
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_icon_transition_delay' name='wgextra_style_icon_transition_delay' value="<?php echo esc_attr( $options['styles']['icon']['transition']['delay'] ); ?>" />
													</td>
													<td class="wge-align-bottom" height="40">
														<?php
															$this->create_dropdown( array(
																'options' => $css3_easings,
																'selected' => $options['styles']['icon']['transition']['easing'],
																'id' => 'wgextra_style_icon_transition_easing',
																'name' => 'wgextra_style_icon_transition_easing'
															) );
														?>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr class="field" rel="caption">
								<th><label for="wgextra_style_caption"><?php _e( "Caption", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="onoffswitch">
										<input type="checkbox" name="wgextra_style_caption" class="onoffswitch-checkbox" id="wgextra_style_caption"<?php checked( $options['styles']['has_caption'], 'yes' ); ?>>
										<label class="onoffswitch-label" for="wgextra_style_caption">
											<div class="onoffswitch-inner">
												<div class="onoffswitch-active">ON</div>
												<div class="onoffswitch-inactive">OFF</div>
											</div>
											<div class="onoffswitch-switch"></div>
										</label>
									</div><br />
									<div class="inside-table">
										<table class="form-table">
											<tbody>
												<tr>
													<th><label for="wgextra_style_caption_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_caption_position" title="<?php esc_attr_e( "Where the captions are displayed in relation to the thumbnail.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Position", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label><?php _e( "Background", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_caption_inset" title="<?php esc_attr_e( "Insert the caption into thumbnail holder?", 'wordpress-gallery-extra' ); ?>"><?php _e( "Inset", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<input rel="colorpicker" id="wgextra_style_caption_color" name="wgextra_style_caption_color" value="<?php echo esc_attr( $options['styles']['caption']['color'] ); ?>" />
													</td>
													<td>
														<select id="wgextra_style_caption_position" name="wgextra_style_caption_position">
															<option value="none"<?php selected( $options['styles']['caption']['position'], 'none' ); ?>><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
															<option value="top-left"<?php selected( $options['styles']['caption']['position'], 'top-left' ); ?>><?php _e( "Top Left", 'wordpress-gallery-extra' ); ?></option>
															<option value="top-center"<?php selected( $options['styles']['caption']['position'], 'top-center' ); ?>><?php _e( "Top Center", 'wordpress-gallery-extra' ); ?></option>
															<option value="top-right"<?php selected( $options['styles']['caption']['position'], 'top-right' ); ?>><?php _e( "Top Right", 'wordpress-gallery-extra' ); ?></option>
															<option value="middle-left"<?php selected( $options['styles']['caption']['position'], 'middle-left' ); ?>><?php _e( "Middle Left", 'wordpress-gallery-extra' ); ?></option>
															<option value="middle-center"<?php selected( $options['styles']['caption']['position'], 'middle-center' ); ?>><?php _e( "Middle Center", 'wordpress-gallery-extra' ); ?></option>
															<option value="middle-right"<?php selected( $options['styles']['caption']['position'], 'middle-right' ); ?>><?php _e( "Middle Right", 'wordpress-gallery-extra' ); ?></option>
															<option value="bottom-left"<?php selected( $options['styles']['caption']['position'], 'bottom-left' ); ?>><?php _e( "Bottom Left", 'wordpress-gallery-extra' ); ?></option>
															<option value="bottom-center"<?php selected( $options['styles']['caption']['position'], 'bottom-center' ); ?>><?php _e( "Bottom Center", 'wordpress-gallery-extra' ); ?></option>
															<option value="bottom-right"<?php selected( $options['styles']['caption']['position'], 'bottom-right' ); ?>><?php _e( "Bottom Right", 'wordpress-gallery-extra' ); ?></option>
														</select>
													</td>
													<td id="wgextra_style_caption_background">
														<div class="switch-field">
															<label for="wgextra_style_caption_background-solid"><?php _e( "Solid", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_style_caption_background" id="wgextra_style_caption_background-solid" value="solid"<?php checked( $options['styles']['caption']['background']['type'], 'solid' ); ?> />
															<label for="wgextra_style_caption_background-gradient"><?php _e( "Gradient", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_style_caption_background" id="wgextra_style_caption_background-gradient" value="gradient"<?php checked( $options['styles']['caption']['background']['type'], 'gradient' ); ?> />
															<label for="wgextra_style_caption_background-none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_style_caption_background" id="wgextra_style_caption_background-none" value="none"<?php checked( $options['styles']['caption']['background']['type'], 'none' ); ?> />
														</div>
														<div class="clear"></div>
														<div class="inside-table" id="wgextra_style_caption_background_solid">
															<table class="form-table">
																<thead>
																	<tr>
																		<th><label for="wgextra_style_caption_background_solid_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
																	</tr>
																</thead>
																<tbody>
																	<tr>
																		<td>
																			<input rel="colorpicker" id="wgextra_style_caption_background_solid_color" name="wgextra_style_caption_background_solid_color" value="<?php echo esc_attr( $options['styles']['caption']['background']['solid']['color'] ); ?>" />
																		</td>
																	</tr>
																</tbody>
															</table>
														</div>
														<div class="inside-table" id="wgextra_style_caption_background_gradient">
															<table class="form-table">
																<thead>
																	<tr>
																		<th><label for="wgextra_style_caption_background_gradient_start_color"><?php _e( "Start Color", 'wordpress-gallery-extra' ); ?></label></th>
																		<th><label for="wgextra_style_caption_background_gradient_stop_color"><?php _e( "Stop Color", 'wordpress-gallery-extra' ); ?></label></th>
																		<th><label for="wgextra_style_caption_background_gradient_orientation"><?php _e( "Orientation", 'wordpress-gallery-extra' ); ?></label></th>
																	</tr>
																</thead>
																<tbody>
																	<tr>
																		<td>
																			<input rel="colorpicker" id="wgextra_style_caption_background_gradient_start_color" name="wgextra_style_caption_background_gradient_start_color" value="<?php echo esc_attr( $options['styles']['caption']['background']['gradient']['start_color'] ); ?>" />
																		</td>
																		<td>
																			<input rel="colorpicker" id="wgextra_style_caption_background_gradient_stop_color" name="wgextra_style_caption_background_gradient_stop_color" value="<?php echo esc_attr( $options['styles']['caption']['background']['gradient']['stop_color'] ); ?>" />
																		</td>
																		<td>
																			<select id="wgextra_style_caption_background_gradient_orientation" name="wgextra_style_caption_background_gradient_orientation">
																				<option value="vertical"<?php selected( $options['styles']['caption']['background']['gradient']['orientation'], 'vertical' ); ?>><?php _e( "Vertical", 'wordpress-gallery-extra' ); ?></option>
																				<option value="horizontal"<?php selected( $options['styles']['caption']['background']['gradient']['orientation'], 'horizontal' ); ?>><?php _e( "Horizontal", 'wordpress-gallery-extra' ); ?></option>
																				<option value="radial"<?php selected( $options['styles']['caption']['background']['gradient']['orientation'], 'radial' ); ?>><?php _e( "Radial", 'wordpress-gallery-extra' ); ?></option>
																				<option value="diagonal_45"<?php selected( $options['styles']['caption']['background']['gradient']['orientation'], 'diagonal_45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> 45&#xB0;</option>
																				<option value="diagonal_n45"<?php selected( $options['styles']['caption']['background']['gradient']['orientation'], 'diagonal_n45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> -45&#xB0;</option>
																			</select>
																		</td>
																	</tr>
																</tbody>
															</table>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="wgextra_style_caption_inset" class="onoffswitch-checkbox" id="wgextra_style_caption_inset"<?php checked( $options['styles']['caption']['inset'], 'yes' ); ?>>
															<label class="onoffswitch-label" for="wgextra_style_caption_inset">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
												</tr>
												<tr>
													<td colspan="4">&nbsp;</td>
												</tr>
												<tr>
													<th><label for="wgextra_style_caption_visibility"><?php _e( "Visiblity", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_caption_transition_speed" title="<?php esc_attr_e( "Speed of the enter/exit transition in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Speed", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_caption_transition_delay" title="<?php esc_attr_e( "Defines how long to wait and the transition actually begins.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Delay", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_caption_transition_easing" title="<?php esc_attr_e( "Specify the rate of transition over time.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Easing", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
												<tr>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $caption_visibilities,
																'selected' => $options['styles']['caption']['visibility'],
																'id' => 'wgextra_style_caption_visibility',
																'name' => 'wgextra_style_caption_visibility'
															) );
														?>
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_caption_transition_speed' name='wgextra_style_caption_transition_speed' value="<?php echo esc_attr( $options['styles']['caption']['transition']['speed'] ); ?>" />
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_caption_transition_delay' name='wgextra_style_caption_transition_delay' value="<?php echo esc_attr( $options['styles']['caption']['transition']['delay'] ); ?>" />
													</td>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $css3_easings,
																'selected' => $options['styles']['caption']['transition']['easing'],
																'id' => 'wgextra_style_caption_transition_easing',
																'name' => 'wgextra_style_caption_transition_easing'
															) );
														?>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr class="field" rel="overlay">
								<th><label for="wgextra_style_overlay"><?php _e( "Overlay", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="onoffswitch">
										<input type="checkbox" name="wgextra_style_overlay" class="onoffswitch-checkbox" id="wgextra_style_overlay"<?php checked( $options['styles']['has_overlay'], 'yes' ); ?>>
										<label class="onoffswitch-label" for="wgextra_style_overlay">
											<div class="onoffswitch-inner">
												<div class="onoffswitch-active">ON</div>
												<div class="onoffswitch-inactive">OFF</div>
											</div>
											<div class="onoffswitch-switch"></div>
										</label>
									</div><br />
									<div class="inside-table">
										<table class="form-table">
											<thead>
												<tr>
													<th><label><?php _e( "Background", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_overlay_visibility" title="<?php esc_attr_e( "Hover visibility type for overlays.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Visiblity", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_overlay_transition_speed" title="<?php esc_attr_e( "Speed of the enter/exit transition in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Speed", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_overlay_transition_delay" title="<?php esc_attr_e( "Defines how long to wait and the transition actually begins.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Delay", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_overlay_transition_easing" title="<?php esc_attr_e( "Specify the rate of transition over time.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Easing", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td id="wgextra_style_overlay_background">
														<div class="switch-field">
															<label for="wgextra_style_overlay_background-solid"><?php _e( "Solid", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_style_overlay_background" id="wgextra_style_overlay_background-solid" value="solid"<?php checked( $options['styles']['overlay']['background']['type'], 'solid' ); ?> />
															<label for="wgextra_style_overlay_background-gradient"><?php _e( "Gradient", 'wordpress-gallery-extra' ); ?></label>
															<input type="radio" name="wgextra_style_overlay_background" id="wgextra_style_overlay_background-gradient" value="gradient"<?php checked( $options['styles']['overlay']['background']['type'], 'gradient' ); ?> />
														</div>
														<div class="clear"></div>
														<div class="inside-table" id="wgextra_style_overlay_background_solid">
															<table class="form-table">
																<thead>
																	<tr>
																		<th><label for="wgextra_style_overlay_background_solid_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
																	</tr>
																</thead>
																<tbody>
																	<tr>
																		<td>
																			<input rel="colorpicker" id="wgextra_style_overlay_background_solid_color" name="wgextra_style_overlay_background_solid_color" value="<?php echo esc_attr( $options['styles']['overlay']['background']['solid']['color'] ); ?>" />
																		</td>
																	</tr>
																</tbody>
															</table>
														</div>
														<div class="inside-table" id="wgextra_style_overlay_background_gradient">
															<table class="form-table">
																<thead>
																	<tr>
																		<th><label for="wgextra_style_overlay_background_gradient_start_color"><?php _e( "Start Color", 'wordpress-gallery-extra' ); ?></label></th>
																		<th><label for="wgextra_style_overlay_background_gradient_stop_color"><?php _e( "Stop Color", 'wordpress-gallery-extra' ); ?></label></th>
																		<th><label for="wgextra_style_overlay_background_gradient_orientation"><?php _e( "Orientation", 'wordpress-gallery-extra' ); ?></label></th>
																	</tr>
																</thead>
																<tbody>
																	<tr>
																		<td>
																			<input rel="colorpicker" id="wgextra_style_overlay_background_gradient_start_color" name="wgextra_style_overlay_background_gradient_start_color" name="wgextra_style_overlay_background_gradient_start_color" value="<?php echo esc_attr( $options['styles']['overlay']['background']['gradient']['start_color'] ); ?>" />
																		</td>
																		<td>
																			<input rel="colorpicker" id="wgextra_style_overlay_background_gradient_stop_color" name="wgextra_style_overlay_background_gradient_stop_color" value="<?php echo esc_attr( $options['styles']['overlay']['background']['gradient']['stop_color'] ); ?>" />
																		</td>
																		<td>
																			<select id="wgextra_style_overlay_background_gradient_orientation" name="wgextra_style_overlay_background_gradient_orientation">
																				<option value="vertical"<?php selected( $options['styles']['overlay']['background']['gradient']['orientation'], 'vertical' ); ?>><?php _e( "Vertical", 'wordpress-gallery-extra' ); ?></option>
																				<option value="horizontal"<?php selected( $options['styles']['overlay']['background']['gradient']['orientation'], 'horizontal' ); ?>><?php _e( "Horizontal", 'wordpress-gallery-extra' ); ?></option>
																				<option value="radial"<?php selected( $options['styles']['overlay']['background']['gradient']['orientation'], 'radial' ); ?>><?php _e( "Radial", 'wordpress-gallery-extra' ); ?></option>
																				<option value="diagonal_45"<?php selected( $options['styles']['overlay']['background']['gradient']['orientation'], 'diagonal_45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> 45&#xB0;</option>
																				<option value="diagonal_n45"<?php selected( $options['styles']['overlay']['background']['gradient']['orientation'], 'diagonal_n45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> -45&#xB0;</option>
																			</select>
																		</td>
																	</tr>
																</tbody>
															</table>
														</div>
													</td>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $overlay_visibilities,
																'selected' => $options['styles']['overlay']['visibility'],
																'id' => 'wgextra_style_overlay_visibility',
																'name' => 'wgextra_style_overlay_visibility'
															) );
														?>
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_overlay_transition_speed' name='wgextra_style_overlay_transition_speed' value="<?php echo esc_attr( $options['styles']['overlay']['transition']['speed'] ); ?>" />
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_overlay_transition_delay' name='wgextra_style_overlay_transition_delay' value="<?php echo esc_attr( $options['styles']['overlay']['transition']['delay'] ); ?>" />
													</td>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $css3_easings,
																'selected' => $options['styles']['overlay']['transition']['easing'],
																'id' => 'wgextra_style_overlay_transition_easing',
																'name' => 'wgextra_style_overlay_transition_easing'
															) );
														?>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
							<tr class="field" rel="thumb_effect">
								<th><label for="wgextra_style_thumbnail_effect"><?php _e( "Thumbnail Effect", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<div class="inside-table">
										<table class="form-table">
											<thead>
												<tr>
													<th><label for="wgextra_style_thumbnail_effect" title="<?php esc_attr_e( "The type of hover effect the thumbnails will use.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Effect", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_thumbnail_effect_transition_speed" title="<?php esc_attr_e( "Speed of the enter/exit transition in milliseconds.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Speed", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_thumbnail_effect_transition_delay" title="<?php esc_attr_e( "Defines how long to wait and the transition actually begins.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Delay", 'wordpress-gallery-extra' ); ?></label></th>
													<th><label for="wgextra_style_thumbnail_effect_transition_easing" title="<?php esc_attr_e( "Specify the rate of transition over time.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Easing", 'wordpress-gallery-extra' ); ?></label></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $thumbnail_effects,
																'selected' => $options['styles']['thumbnail_effect']['effect'],
																'id' => 'wgextra_style_thumbnail_effect',
																'name' => 'wgextra_style_thumbnail_effect'
															) );
														?>
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_thumbnail_effect_transition_speed' name='wgextra_style_thumbnail_effect_transition_speed' value="<?php echo esc_attr( $options['styles']['thumbnail_effect']['transition']['speed'] ); ?>" />
													</td>
													<td>
														<input rel='number' data-options='min:0, step:50' id='wgextra_style_thumbnail_effect_transition_delay' name='wgextra_style_thumbnail_effect_transition_delay' value="<?php echo esc_attr( $options['styles']['thumbnail_effect']['transition']['delay'] ); ?>" />
													</td>
													<td>
														<?php
															$this->create_dropdown( array(
																'options' => $css3_easings,
																'selected' => $options['styles']['thumbnail_effect']['transition']['easing'],
																'id' => 'wgextra_style_thumbnail_effect_transition_easing',
																'name' => 'wgextra_style_thumbnail_effect_transition_easing'
															) );
														?>
													</td>
												</tr>
											</tbody>
										</table>
									</div>
<?php } ?>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'default' );
?>
						</table>

						<div id="slider-styles">
							<hr />

							<h3 class="wge-margin-none"><?php _e( "Slider Styles", 'wordpress-gallery-extra' ); ?></h3>
							<p><?php _e( "Change slider structure and navigations styles with the following options.", 'wordpress-gallery-extra' ); ?></p>

							<div class="clear"></div>

<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
								<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
							<fieldset>
								<legend><?php _e( "Arrows styles", 'wordpress-gallery-extra' ); ?></legend>
								<table class="form-table">
									<tr>
										<th class="no-wrap wge-quarter-width wge-text-right"><label><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
										<td colspan="3">
											<?php
												$this->create_dropdown( array(
													'options' => $slider_arrows_skins,
													'selected' => $options['styles']['slider']['arrows']['skin'],
													'id' => 'wgextra_style_slider_arrows_skin',
													'name' => 'wgextra_style_slider_arrows_skin'
												) );
											?>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_arrows_hide"><?php _e( "Hide when mouse leaves slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_arrows_hide" class="onoffswitch-checkbox" id="wgextra_style_slider_arrows_hide"<?php checked( $options['styles']['slider']['arrows']['hide'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_arrows_hide">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_arrows_under"><?php _e( "Hide under this window width", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_arrows_under' name='wgextra_style_slider_arrows_under' value='<?php echo esc_attr( $options['styles']['slider']['arrows']['under'] ); ?>' />
											<select id="wgextra_style_slider_arrows_under_unit" name="wgextra_style_slider_arrows_under_unit">
												<option value="px"<?php selected( $options['styles']['slider']['arrows']['under_unit'], 'px' ); ?>>px</option>
												<option value="em"<?php selected( $options['styles']['slider']['arrows']['under_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['arrows']['under_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['arrows']['under_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>
									</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'slider-arrows' );
?>
								</table>
							</fieldset>

							<fieldset>
								<legend><?php _e( "Scrollbar styles", 'wordpress-gallery-extra' ); ?></legend>
								<table class="form-table">
									<tr>
										<th class="no-wrap wge-text-right"><label for="wgextra_style_slider_scrollbar_skin"><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
										<td colspan="3">
											<?php
												$this->create_dropdown( array(
													'options' => $slider_scrollbar_skins,
													'selected' => $options['styles']['slider']['scrollbar']['skin'],
													'id' => 'wgextra_style_slider_scrollbar_skin',
													'name' => 'wgextra_style_slider_scrollbar_skin'
												) );
											?>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_scrollbar_hide"><?php _e( "Hide when mouse leaves slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_scrollbar_hide" class="onoffswitch-checkbox" id="wgextra_style_slider_scrollbar_hide"<?php checked( $options['styles']['slider']['scrollbar']['hide'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_scrollbar_hide">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_scrollbar_inside"><?php _e( "Insert scrollbar inside slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_scrollbar_inside" class="onoffswitch-checkbox" id="wgextra_style_slider_scrollbar_inside"<?php checked( $options['styles']['slider']['scrollbar']['inside'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_scrollbar_inside">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_scrollbar_under"><?php _e( "Hide under this window width", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_scrollbar_under' name='wgextra_style_slider_scrollbar_under' value='<?php echo esc_attr( $options['styles']['slider']['scrollbar']['under'] ); ?>' />
											<select id="wgextra_style_slider_scrollbar_under_unit" name="wgextra_style_slider_scrollbar_under_unit">
												<option value="px"<?php selected( $options['styles']['slider']['scrollbar']['under_unit'], 'px' ); ?>>px</option>
												<option value="em"<?php selected( $options['styles']['slider']['scrollbar']['under_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['scrollbar']['under_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['scrollbar']['under_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_scrollbar_size"><?php _e( "Scrollbar size", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_scrollbar_size' name='wgextra_style_slider_scrollbar_size' value='<?php echo esc_attr( $options['styles']['slider']['scrollbar']['size'] ); ?>' />
											<select id="wgextra_style_slider_scrollbar_size_unit" name="wgextra_style_slider_scrollbar_size_unit">
												<option value="px"<?php selected( $options['styles']['slider']['scrollbar']['size_unit'], 'px' ); ?>>px</option>
												<option value="%"<?php selected( $options['styles']['slider']['scrollbar']['size_unit'], '%' ); ?>>%</option>
												<option value="em"<?php selected( $options['styles']['slider']['scrollbar']['size_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['scrollbar']['size_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['scrollbar']['size_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-quarter-width wge-text-right"><label><?php _e( "Scrollbar track color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-quarter-width" id="wgextra_style_slider_scrollbar_track_color">
											<div class="switch-field">
												<label for="wgextra_style_slider_scrollbar_track_color-solid"><?php _e( "Solid", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_scrollbar_track_color" id="wgextra_style_slider_scrollbar_track_color-solid" value="solid"<?php checked( $options['styles']['slider']['scrollbar']['track_color']['type'], 'solid' ); ?> />
												<label for="wgextra_style_slider_scrollbar_track_color-gradient"><?php _e( "Gradient", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_scrollbar_track_color" id="wgextra_style_slider_scrollbar_track_color-gradient" value="gradient"<?php checked( $options['styles']['slider']['scrollbar']['track_color']['type'], 'gradient' ); ?> />
												<label for="wgextra_style_slider_scrollbar_track_color-none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_scrollbar_track_color" id="wgextra_style_slider_scrollbar_track_color-none" value="none"<?php checked( $options['styles']['slider']['scrollbar']['track_color']['type'], 'none' ); ?> />
											</div>
											<div class="clear"></div>
											<div class="inside-table" id="wgextra_style_slider_scrollbar_track_color_solid">
												<table class="form-table">
													<thead>
														<tr>
															<th><label for="wgextra_style_slider_scrollbar_track_color_solid_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_scrollbar_track_color_solid_color" name="wgextra_style_slider_scrollbar_track_color_solid_color" value="<?php echo esc_attr( $options['styles']['slider']['scrollbar']['track_color']['solid']['color'] ); ?>" />
															</td>
														</tr>
													</tbody>
												</table>
											</div>
											<div class="inside-table" id="wgextra_style_slider_scrollbar_track_color_gradient">
												<table class="form-table">
													<thead>
														<tr>
															<th><label for="wgextra_style_slider_scrollbar_track_color_gradient_start_color"><?php _e( "Start Color", 'wordpress-gallery-extra' ); ?></label></th>
															<th><label for="wgextra_style_slider_scrollbar_track_color_gradient_stop_color"><?php _e( "Stop Color", 'wordpress-gallery-extra' ); ?></label></th>
															<th><label for="wgextra_style_slider_scrollbar_track_color_gradient_orientation"><?php _e( "Orientation", 'wordpress-gallery-extra' ); ?></label></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_scrollbar_track_color_gradient_start_color" name="wgextra_style_slider_scrollbar_track_color_gradient_start_color" value="<?php echo esc_attr( $options['styles']['slider']['scrollbar']['track_color']['gradient']['start_color'] ); ?>" />
															</td>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_scrollbar_track_color_gradient_stop_color" name="wgextra_style_slider_scrollbar_track_color_gradient_stop_color" value="<?php echo esc_attr( $options['styles']['slider']['scrollbar']['track_color']['gradient']['stop_color'] ); ?>" />
															</td>
															<td>
																<select id="wgextra_style_slider_scrollbar_track_color_gradient_orientation" name="wgextra_style_slider_scrollbar_track_color_gradient_orientation">
																	<option value="vertical"<?php selected( $options['styles']['slider']['scrollbar']['track_color']['gradient']['orientation'], 'vertical' ); ?>><?php _e( "Vertical", 'wordpress-gallery-extra' ); ?></option>
																	<option value="horizontal"<?php selected( $options['styles']['slider']['scrollbar']['track_color']['gradient']['orientation'], 'horizontal' ); ?>><?php _e( "Horizontal", 'wordpress-gallery-extra' ); ?></option>
																	<option value="radial"<?php selected( $options['styles']['slider']['scrollbar']['track_color']['gradient']['orientation'], 'radial' ); ?>><?php _e( "Radial", 'wordpress-gallery-extra' ); ?></option>
																	<option value="diagonal_45"<?php selected( $options['styles']['slider']['scrollbar']['track_color']['gradient']['orientation'], 'diagonal_45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> 45&#xB0;</option>
																	<option value="diagonal_n45"<?php selected( $options['styles']['slider']['scrollbar']['track_color']['gradient']['orientation'], 'diagonal_n45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> -45&#xB0;</option>
																</select>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</td>

										<th class="no-wrap wge-quarter-width wge-text-right"><label><?php _e( "Scrollbar handle color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-quarter-width" id="wgextra_style_slider_scrollbar_handle_color">
											<div class="switch-field">
												<label for="wgextra_style_slider_scrollbar_handle_color-solid"><?php _e( "Solid", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_scrollbar_handle_color" id="wgextra_style_slider_scrollbar_handle_color-solid" value="solid"<?php checked( $options['styles']['slider']['scrollbar']['handle_color']['type'], 'solid' ); ?> />
												<label for="wgextra_style_slider_scrollbar_handle_color-gradient"><?php _e( "Gradient", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_scrollbar_handle_color" id="wgextra_style_slider_scrollbar_handle_color-gradient" value="gradient"<?php checked( $options['styles']['slider']['scrollbar']['handle_color']['type'], 'gradient' ); ?> />
												<label for="wgextra_style_slider_scrollbar_handle_color-none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_scrollbar_handle_color" id="wgextra_style_slider_scrollbar_handle_color-none" value="none"<?php checked( $options['styles']['slider']['scrollbar']['handle_color']['type'], 'none' ); ?> />
											</div>
											<div class="clear"></div>
											<div class="inside-table" id="wgextra_style_slider_scrollbar_handle_color_solid">
												<table class="form-table">
													<thead>
														<tr>
															<th><label for="wgextra_style_slider_scrollbar_handle_color_solid_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_scrollbar_handle_color_solid_color" name="wgextra_style_slider_scrollbar_handle_color_solid_color" value="<?php echo esc_attr( $options['styles']['slider']['scrollbar']['handle_color']['solid']['color'] ); ?>" />
															</td>
														</tr>
													</tbody>
												</table>
											</div>
											<div class="inside-table" id="wgextra_style_slider_scrollbar_handle_color_gradient">
												<table class="form-table">
													<thead>
														<tr>
															<th><label for="wgextra_style_slider_scrollbar_handle_color_gradient_start_color"><?php _e( "Start Color", 'wordpress-gallery-extra' ); ?></label></th>
															<th><label for="wgextra_style_slider_scrollbar_handle_color_gradient_stop_color"><?php _e( "Stop Color", 'wordpress-gallery-extra' ); ?></label></th>
															<th><label for="wgextra_style_slider_scrollbar_handle_color_gradient_orientation"><?php _e( "Orientation", 'wordpress-gallery-extra' ); ?></label></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_scrollbar_handle_color_gradient_start_color" name="wgextra_style_slider_scrollbar_handle_color_gradient_start_color" value="<?php echo esc_attr( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['start_color'] ); ?>" />
															</td>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_scrollbar_handle_color_gradient_stop_color" name="wgextra_style_slider_scrollbar_handle_color_gradient_stop_color" value="<?php echo esc_attr( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['stop_color'] ); ?>" />
															</td>
															<td>
																<select id="wgextra_style_slider_scrollbar_handle_color_gradient_orientation" name="wgextra_style_slider_scrollbar_handle_color_gradient_orientation">
																	<option value="vertical"<?php selected( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['orientation'], 'vertical' ); ?>><?php _e( "Vertical", 'wordpress-gallery-extra' ); ?></option>
																	<option value="horizontal"<?php selected( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['orientation'], 'horizontal' ); ?>><?php _e( "Horizontal", 'wordpress-gallery-extra' ); ?></option>
																	<option value="radial"<?php selected( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['orientation'], 'radial' ); ?>><?php _e( "Radial", 'wordpress-gallery-extra' ); ?></option>
																	<option value="diagonal_45"<?php selected( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['orientation'], 'diagonal_45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> 45&#xB0;</option>
																	<option value="diagonal_n45"<?php selected( $options['styles']['slider']['scrollbar']['handle_color']['gradient']['orientation'], 'diagonal_n45' ); ?>><?php _e( "Diagonal", 'wordpress-gallery-extra' ); ?> -45&#xB0;</option>
																</select>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</td>
									</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'slider-scrollbar' );
?>
								</table>
							</fieldset>

							<fieldset>
								<legend><?php _e( "Thumbnails styles", 'wordpress-gallery-extra' ); ?></legend>
								<table class="form-table">
									<tr>
										<th class="no-wrap wge-text-right"><label><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
										<td colspan="3">
											<?php
												$this->create_dropdown( array(
													'options' => $slider_thumbnails_skins,
													'selected' => $options['styles']['slider']['thumbnails']['skin'],
													'id' => 'wgextra_style_slider_thumbnails_skin',
													'name' => 'wgextra_style_slider_thumbnails_skin'
												) );
											?>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_thumbnails_hide"><?php _e( "Hide when mouse leaves slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_thumbnails_hide" class="onoffswitch-checkbox" id="wgextra_style_slider_thumbnails_hide"<?php checked( $options['styles']['slider']['thumbnails']['hide'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_thumbnails_hide">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_thumbnails_inside"><?php _e( "Insert thumbnails inside slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_thumbnails_inside" class="onoffswitch-checkbox" id="wgextra_style_slider_thumbnails_inside"<?php checked( $options['styles']['slider']['thumbnails']['inside'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_thumbnails_inside">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_thumbnails_under"><?php _e( "Hide under this window width", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_thumbnails_under' name='wgextra_style_slider_thumbnails_under' value='<?php echo esc_attr( $options['styles']['slider']['thumbnails']['under'] ); ?>' />
											<select id="wgextra_style_slider_thumbnails_under_unit" name="wgextra_style_slider_thumbnails_under_unit">
												<option value="px"<?php selected( $options['styles']['slider']['thumbnails']['under_unit'], 'px' ); ?>>px</option>
												<option value="em"<?php selected( $options['styles']['slider']['thumbnails']['under_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['thumbnails']['under_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['thumbnails']['under_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_thumbnails_spacing"><?php _e( "Spacing", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_thumbnails_spacing' name='wgextra_style_slider_thumbnails_spacing' value='<?php echo esc_attr( $options['styles']['slider']['thumbnails']['spacing'] ); ?>' />
											<select id="wgextra_style_slider_thumbnails_spacing_unit" name="wgextra_style_slider_thumbnails_spacing_unit">
												<option value="px"<?php selected( $options['styles']['slider']['thumbnails']['spacing_unit'], 'px' ); ?>>px</option>
												<option value="%"<?php selected( $options['styles']['slider']['thumbnails']['spacing_unit'], '%' ); ?>>%</option>
												<option value="em"<?php selected( $options['styles']['slider']['thumbnails']['spacing_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['thumbnails']['spacing_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['thumbnails']['spacing_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_thumbnails_position"><?php _e( "Position", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<select id="wgextra_style_slider_thumbnails_position" name="wgextra_style_slider_thumbnails_position">
												<option value="top"<?php selected( $options['styles']['slider']['thumbnails']['position'], 'top' ); ?>><?php _e( "Top", 'wordpress-gallery-extra' ); ?></option>
												<option value="left"<?php selected( $options['styles']['slider']['thumbnails']['position'], 'left' ); ?>><?php _e( "Left", 'wordpress-gallery-extra' ); ?></option>
												<option value="right"<?php selected( $options['styles']['slider']['thumbnails']['position'], 'right' ); ?>><?php _e( "Right", 'wordpress-gallery-extra' ); ?></option>
												<option value="bottom"<?php selected( $options['styles']['slider']['thumbnails']['position'], 'bottom' ); ?>><?php _e( "Bottom", 'wordpress-gallery-extra' ); ?></option>
											</select>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_thumbnails_size"><?php _e( "Size", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_thumbnails_size' name='wgextra_style_slider_thumbnails_size' value='<?php echo esc_attr( $options['styles']['slider']['thumbnails']['size'] ); ?>' />
											<select id="wgextra_style_slider_thumbnails_size_unit" name="wgextra_style_slider_thumbnails_size_unit">
												<option value="px"<?php selected( $options['styles']['slider']['thumbnails']['size_unit'], 'px' ); ?>>px</option>
												<option value="%"<?php selected( $options['styles']['slider']['thumbnails']['size_unit'], '%' ); ?>>%</option>
												<option value="em"<?php selected( $options['styles']['slider']['thumbnails']['size_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['thumbnails']['size_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['thumbnails']['size_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>
									</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'slider-thumbnails' );
?>
								</table>
							</fieldset>

							<fieldset>
								<legend><?php _e( "Bullets styles", 'wordpress-gallery-extra' ); ?></legend>
								<table class="form-table">
									<tr>
										<th class="no-wrap wge-text-right"><label><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
										<td colspan="3">
											<?php
												$this->create_dropdown( array(
													'options' => $slider_bullets_skins,
													'selected' => $options['styles']['slider']['bullets']['skin'],
													'id' => 'wgextra_style_slider_bullets_skin',
													'name' => 'wgextra_style_slider_bullets_skin'
												) );
											?>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_bullets_hide"><?php _e( "Hide when mouse leaves slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_bullets_hide" class="onoffswitch-checkbox" id="wgextra_style_slider_bullets_hide"<?php checked( $options['styles']['slider']['bullets']['hide'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_bullets_hide">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_bullets_inside"><?php _e( "Insert bullets inside slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_bullets_inside" class="onoffswitch-checkbox" id="wgextra_style_slider_bullets_inside"<?php checked( $options['styles']['slider']['bullets']['inside'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_bullets_inside">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_bullets_under"><?php _e( "Hide under this window width", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_bullets_under' name='wgextra_style_slider_bullets_under' value='<?php echo esc_attr( $options['styles']['slider']['bullets']['under'] ); ?>' />
											<select id="wgextra_style_slider_bullets_under_unit" name="wgextra_style_slider_bullets_under_unit">
												<option value="px"<?php selected( $options['styles']['slider']['bullets']['under_unit'], 'px' ); ?>>px</option>
												<option value="em"<?php selected( $options['styles']['slider']['bullets']['under_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['bullets']['under_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['bullets']['under_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_bullets_color"><?php _e( "Bullets color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel="colorpicker" id="wgextra_style_slider_bullets_color" name="wgextra_style_slider_bullets_color" value="<?php echo esc_attr( $options['styles']['slider']['bullets']['color'] ); ?>" />
										</td>
									</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'slider-bullets' );
?>
								</table>
							</fieldset>

							<fieldset>
								<legend><?php _e( "Time Loader styles", 'wordpress-gallery-extra' ); ?></legend>
								<table class="form-table">
									<tr>
										<th class="no-wrap wge-text-right"><label><?php _e( "Skin", 'wordpress-gallery-extra' ); ?></label></th>
										<td colspan="3">
											<?php
												$this->create_dropdown( array(
													'options' => $slider_time_loader_skins,
													'selected' => $options['styles']['slider']['time_loader']['skin'],
													'id' => 'wgextra_style_slider_time_loader_skin',
													'name' => 'wgextra_style_slider_time_loader_skin'
												) );
											?>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_hide"><?php _e( "Hide when mouse leaves slider", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_time_loader_hide" class="onoffswitch-checkbox" id="wgextra_style_slider_time_loader_hide"<?php checked( $options['styles']['slider']['time_loader']['hide'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_time_loader_hide">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_under"><?php _e( "Hide under this window width", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_under' name='wgextra_style_slider_time_loader_under' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['under'] ); ?>' />
											<select id="wgextra_style_slider_time_loader_under_unit" name="wgextra_style_slider_time_loader_under_unit">
												<option value="px"<?php selected( $options['styles']['slider']['time_loader']['under_unit'], 'px' ); ?>>px</option>
												<option value="em"<?php selected( $options['styles']['slider']['time_loader']['under_unit'], 'em' ); ?>>em</option>
												<option value="rem"<?php selected( $options['styles']['slider']['time_loader']['under_unit'], 'rem' ); ?>>rem</option>
												<option value="mm"<?php selected( $options['styles']['slider']['time_loader']['under_unit'], 'mm' ); ?>>mm</option>
											</select>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_appearance"><?php _e( "Appearance", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<select id="wgextra_style_slider_time_loader_appearance" name="wgextra_style_slider_time_loader_appearance">
												<option value="none"<?php selected( $options['styles']['slider']['time_loader']['appearance'], 'none' ); ?>><?php _e( "None", 'wordpress-gallery-extra' ); ?></option>
												<option value="line"<?php selected( $options['styles']['slider']['time_loader']['appearance'], 'line' ); ?>><?php _e( "Line", 'wordpress-gallery-extra' ); ?></option>
												<option value="pie"<?php selected( $options['styles']['slider']['time_loader']['appearance'], 'pie' ); ?>><?php _e( "Pie", 'wordpress-gallery-extra' ); ?></option>
												<option value="donut"<?php selected( $options['styles']['slider']['time_loader']['appearance'], 'donut' ); ?>><?php _e( "Donut", 'wordpress-gallery-extra' ); ?></option>
											</select>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_position"><?php _e( "Position", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<select id="wgextra_style_slider_time_loader_position" name="wgextra_style_slider_time_loader_position">
												<option value=""><?php _e( "Default", 'wordpress-gallery-extra' ); ?></option>
												<option value="top-left"<?php selected( $options['styles']['slider']['time_loader']['position'], 'top-left' ); ?>><?php _e( "Top Left", 'wordpress-gallery-extra' ); ?></option>
												<option value="top-center"<?php selected( $options['styles']['slider']['time_loader']['position'], 'top-center' ); ?>><?php _e( "Top Center", 'wordpress-gallery-extra' ); ?></option>
												<option value="top-right"<?php selected( $options['styles']['slider']['time_loader']['position'], 'top-right' ); ?>><?php _e( "Top Right", 'wordpress-gallery-extra' ); ?></option>
												<option value="middle-left"<?php selected( $options['styles']['slider']['time_loader']['position'], 'middle-left' ); ?>><?php _e( "Middle Left", 'wordpress-gallery-extra' ); ?></option>
												<option value="middle-center"<?php selected( $options['styles']['slider']['time_loader']['position'], 'middle-center' ); ?>><?php _e( "Middle Center", 'wordpress-gallery-extra' ); ?></option>
												<option value="middle-right"<?php selected( $options['styles']['slider']['time_loader']['position'], 'middle-right' ); ?>><?php _e( "Middle Right", 'wordpress-gallery-extra' ); ?></option>
												<option value="bottom-left"<?php selected( $options['styles']['slider']['time_loader']['position'], 'bottom-left' ); ?>><?php _e( "Bottom Left", 'wordpress-gallery-extra' ); ?></option>
												<option value="bottom-center"<?php selected( $options['styles']['slider']['time_loader']['position'], 'bottom-center' ); ?>><?php _e( "Bottom Center", 'wordpress-gallery-extra' ); ?></option>
												<option value="bottom-right"<?php selected( $options['styles']['slider']['time_loader']['position'], 'bottom-right' ); ?>><?php _e( "Bottom Right", 'wordpress-gallery-extra' ); ?></option>
											</select>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_stroke_size" title="<?php esc_attr_e( "Size of the loader line in px.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Stroke size", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_stroke_size' name='wgextra_style_slider_time_loader_stroke_size' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['stroke_size'] ); ?>' />
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_circle_diameter" title="<?php esc_attr_e( "Diameter length of the circle loader in px.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Circle diameter", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_circle_diameter' name='wgextra_style_slider_time_loader_circle_diameter' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['circle_diameter'] ); ?>' />
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_scale_length" title="<?php esc_attr_e( "Length of the scale lines (reduces the diameter length of the circle loader).", 'wordpress-gallery-extra' ); ?>"><?php _e( "Scale length", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_scale_length' name='wgextra_style_slider_time_loader_scale_length' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['scale_length'] ); ?>' />
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_rotate" title="<?php esc_attr_e( "Rotation of the circle loader in degrees.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Rotation", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_rotate' name='wgextra_style_slider_time_loader_rotate' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['rotate'] ); ?>' />
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_track_space" title="<?php esc_attr_e( "The space of the track.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Track space", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_track_space' name='wgextra_style_slider_time_loader_track_space' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['track_space'] ); ?>' />
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_offset" title="<?php esc_attr_e( "Time Loader offset from slider edge.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Offset", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel='number' data-options='min:0' id='wgextra_style_slider_time_loader_offset' name='wgextra_style_slider_time_loader_offset' value='<?php echo esc_attr( $options['styles']['slider']['time_loader']['offset'] ); ?>' />
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_counter" title="<?php esc_attr_e( "Enable loader counter.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Loader counter", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="switch-field">
												<label for="wgextra_style_slider_time_loader_counter-default"><?php _e( "Default", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_counter" id="wgextra_style_slider_time_loader_counter-default" value="default"<?php checked( $options['styles']['slider']['time_loader']['counter'], 'default' ); ?> />
												<label for="wgextra_style_slider_time_loader_counter-yes"><?php _e( "Yes", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_counter" id="wgextra_style_slider_time_loader_counter-yes" value="yes"<?php checked( $options['styles']['slider']['time_loader']['counter'], 'yes' ); ?> />
												<label for="wgextra_style_slider_time_loader_counter-no"><?php _e( "No", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_counter" id="wgextra_style_slider_time_loader_counter-no" value="no"<?php checked( $options['styles']['slider']['time_loader']['counter'], 'no' ); ?> />
											</div>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_line_cap" title="<?php esc_attr_e( "Defines how the ending of the bar line looks like.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Line Cap", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<select id="wgextra_style_slider_time_loader_line_cap" name="wgextra_style_slider_time_loader_line_cap">
												<option value=""><?php _e( "Default", 'wordpress-gallery-extra' ); ?></option>
												<option value="butt"<?php selected( $options['styles']['slider']['time_loader']['line_cap'], 'butt' ); ?>>butt</option>
												<option value="round"<?php selected( $options['styles']['slider']['time_loader']['line_cap'], 'round' ); ?>>round</option>
												<option value="square"<?php selected( $options['styles']['slider']['time_loader']['line_cap'], 'square' ); ?>>square</option>
											</select>
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-top wge-quarter-width wge-text-right"><label><?php _e( "Loader color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-quarter-width" id="wgextra_style_slider_time_loader_loader_color">
											<div class="switch-field">
												<label for="wgextra_style_slider_time_loader_loader_color-solid"><?php _e( "Solid", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_loader_color" id="wgextra_style_slider_time_loader_loader_color-solid" value="solid"<?php checked( $options['styles']['slider']['time_loader']['loader_color']['type'], 'solid' ); ?> />
												<label for="wgextra_style_slider_time_loader_loader_color-gradient"><?php _e( "Gradient", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_loader_color" id="wgextra_style_slider_time_loader_loader_color-gradient" value="gradient"<?php checked( $options['styles']['slider']['time_loader']['loader_color']['type'], 'gradient' ); ?> />
												<label for="wgextra_style_slider_time_loader_loader_color-none"><?php _e( "None", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_loader_color" id="wgextra_style_slider_time_loader_loader_color-none" value="none"<?php checked( $options['styles']['slider']['time_loader']['loader_color']['type'], 'none' ); ?> />
											</div>
											<div class="clear"></div>
											<div class="inside-table" id="wgextra_style_slider_time_loader_loader_color_solid">
												<table class="form-table">
													<thead>
														<tr>
															<th><label for="wgextra_style_slider_time_loader_loader_color_solid_color"><?php _e( "Color", 'wordpress-gallery-extra' ); ?></label></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_time_loader_loader_color_solid_color" name="wgextra_style_slider_time_loader_loader_color_solid_color" value="<?php echo esc_attr( $options['styles']['slider']['time_loader']['loader_color']['solid']['color'] ); ?>" />
															</td>
														</tr>
													</tbody>
												</table>
											</div>
											<div class="inside-table" id="wgextra_style_slider_time_loader_loader_color_gradient">
												<table class="form-table">
													<thead>
														<tr>
															<th><label for="wgextra_style_slider_time_loader_loader_color_gradient_start_color"><?php _e( "Start Color", 'wordpress-gallery-extra' ); ?></label></th>
															<th><label for="wgextra_style_slider_time_loader_loader_color_gradient_stop_color"><?php _e( "Stop Color", 'wordpress-gallery-extra' ); ?></label></th>
															<th><label for="wgextra_style_slider_time_loader_loader_color_gradient_orientation"><?php _e( "Orientation", 'wordpress-gallery-extra' ); ?></label></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_time_loader_loader_color_gradient_start_color" name="wgextra_style_slider_time_loader_loader_color_gradient_start_color" value="<?php echo esc_attr( $options['styles']['slider']['time_loader']['loader_color']['gradient']['start_color'] ); ?>" />
															</td>
															<td>
																<input rel="colorpicker" id="wgextra_style_slider_time_loader_loader_color_gradient_stop_color" name="wgextra_style_slider_time_loader_loader_color_gradient_stop_color" value="<?php echo esc_attr( $options['styles']['slider']['time_loader']['loader_color']['gradient']['stop_color'] ); ?>" />
															</td>
															<td>
																<select id="wgextra_style_slider_time_loader_loader_color_gradient_orientation" name="wgextra_style_slider_time_loader_loader_color_gradient_orientation">
																	<option value="linear"<?php selected( $options['styles']['slider']['time_loader']['loader_color']['gradient']['orientation'], 'linear' ); ?>><?php _e( "Linear", 'wordpress-gallery-extra' ); ?></option>
																	<option value="radial"<?php selected( $options['styles']['slider']['time_loader']['loader_color']['gradient']['orientation'], 'radial' ); ?>><?php _e( "Radial", 'wordpress-gallery-extra' ); ?></option>
																</select>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</td>

										<th class="no-wrap wge-align-top wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_track_color"><?php _e( "Track color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-top wge-quarter-width">
											<input rel="colorpicker" id="wgextra_style_slider_time_loader_track_color" name="wgextra_style_slider_time_loader_track_color" value="<?php echo esc_attr( $options['styles']['slider']['time_loader']['track_color'] ); ?>" />
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_scale_color" title="<?php esc_attr_e( "Color of the scale lines.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Scale color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel="colorpicker" id="wgextra_style_slider_time_loader_scale_color" name="wgextra_style_slider_time_loader_scale_color" value="<?php echo esc_attr( $options['styles']['slider']['time_loader']['scale_color'] ); ?>" />
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_counter_color" title="<?php esc_attr_e( "Color of the counter text.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Counter color", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<input rel="colorpicker" id="wgextra_style_slider_time_loader_counter_color" name="wgextra_style_slider_time_loader_counter_color" value="<?php echo esc_attr( $options['styles']['slider']['time_loader']['counter_color'] ); ?>" />
										</td>
									</tr>
									<tr>
										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_reverse" title="<?php esc_attr_e( "Reverse the time loader rendering.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Reverse", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="switch-field">
												<label for="wgextra_style_slider_time_loader_reverse-default"><?php _e( "Default", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_reverse" id="wgextra_style_slider_time_loader_reverse-default" value="default"<?php checked( $options['styles']['slider']['time_loader']['reverse'], 'default' ); ?> />
												<label for="wgextra_style_slider_time_loader_reverse-yes"><?php _e( "Yes", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_reverse" id="wgextra_style_slider_time_loader_reverse-yes" value="yes"<?php checked( $options['styles']['slider']['time_loader']['reverse'], 'yes' ); ?> />
												<label for="wgextra_style_slider_time_loader_reverse-no"><?php _e( "No", 'wordpress-gallery-extra' ); ?></label>
												<input type="radio" name="wgextra_style_slider_time_loader_reverse" id="wgextra_style_slider_time_loader_reverse-no" value="no"<?php checked( $options['styles']['slider']['time_loader']['reverse'], 'no' ); ?> />
											</div>
										</td>

										<th class="no-wrap wge-align-middle wge-quarter-width wge-text-right"><label for="wgextra_style_slider_time_loader_toggle_cycling" title="<?php esc_attr_e( "Pause or resume the slider cycling by click.", 'wordpress-gallery-extra' ); ?>"><?php _e( "Toggle cycling", 'wordpress-gallery-extra' ); ?></label></th>
										<td class="no-wrap wge-align-middle wge-quarter-width">
											<div class="onoffswitch">
												<input type="checkbox" name="wgextra_style_slider_time_loader_toggle_cycling" class="onoffswitch-checkbox" id="wgextra_style_slider_time_loader_toggle_cycling"<?php checked( $options['styles']['slider']['time_loader']['toggle_cycling'], 'yes' ); ?>>
												<label class="onoffswitch-label" for="wgextra_style_slider_time_loader_toggle_cycling">
													<div class="onoffswitch-inner">
														<div class="onoffswitch-active">ON</div>
														<div class="onoffswitch-inactive">OFF</div>
													</div>
													<div class="onoffswitch-switch"></div>
												</label>
											</div>
										</td>
									</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'slider-time-loader' );
?>
								</table>
							</fieldset>
<?php } ?>
						</div>
<?php
	$this->do_settings_sections( $wge_page, 'styling' );
?>

						<hr />

						<table class="form-table">
							<tr>
								<th><label for="wgextra_style_custom_css"><?php _e( "Custom CSS", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
<?php if( !$this->is_active() && !$this->is_extended() ) { ?>
									<div class="license-notify"><?php esc_attr_e( 'Please activate WordPress Gallery Extra license to enable this feature.', 'wordpress-gallery-extra' ); ?></div>
<?php } else { ?>
									<p class="description"><?php _e( "Available CSS Selectors (click to add):", 'wordpress-gallery-extra' ); ?></p>
									<div class="controlgroup small">
										<a class="ui-button add-css-selector" rel="gallery"><?php _e( "Gallery", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="item"><?php _e( "Item", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="thumb"><?php _e( "Thumbnail Container", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="thumb-image"><?php _e( "Thumbnail Image", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="icon"><?php _e( "Icon", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="inner-caption"><?php _e( "Inner Caption", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="outer-caption"><?php _e( "Outer Caption", 'wordpress-gallery-extra' ); ?></a>
										<a class="ui-button add-css-selector" rel="thumb-overlay"><?php _e( "Overlay", 'wordpress-gallery-extra' ); ?></a>
									</div>
									<div class="controlgroup small wge-float-right">
										<a class="ui-button" id="css-to-less"><?php _e( "Convert to LESS", 'wordpress-gallery-extra' ); ?></a>
									</div>
									<textarea class="css" name="wgextra_style_custom_css" id="wgextra_style_custom_css" rows="3" placeholder="<?php esc_attr_e( 'Custom CSS styles goes here...', 'wordpress-gallery-extra' ); ?>"><?php echo esc_textarea( $options['styles']['custom_css'] ); ?></textarea>
									<p class="description"><?php _e( "Allows you to add your own styles or override the default styles. LESS-CSS is alowed.", 'wordpress-gallery-extra' ); ?></p>
<?php } ?>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'styling', 'custom-css' );
?>
						</table>
					</div><!-- end of inside -->
				</form>
<?php
			}

			include_once "footer.php";
?>
