<?php
/**
 * Attach handlers for AJAX actions
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Guten_Ajax_Handlers' ) ) {

	/**
	 * Define Jet_Guten_Ajax_Handlers class
	 */
	class Jet_Guten_Ajax_Handlers {

		/**
		 * Constructor for the class
		 */
		function __construct() {

			$actions = array(
				'get_available_image_sizes' => 'get_available_image_sizes',
				'get_raw_svg'               => 'get_raw_svg',
			);

			foreach ( $actions as $action => $callback ) {
				add_action( 'wp_ajax_jet_guten_' . $action, array( $this, $callback ) );
			}
		}

		/**
		 * Ajax callback to ger raw SVG code by img ID
		 *
		 * @return void
		 */
		public function get_raw_svg() {

			$image_id = ! empty( $_GET['image_id'] ) ? absint( $_GET['image_id'] ) : false;

			if ( ! $image_id ) {
				wp_send_json( array(
					'body' => __( 'Please select SVG Image', 'jet-guten' ),
				) );
			}

			$plugin = Jet_Guten_Plugin::get_instance();

			wp_send_json( array(
				'body' => $plugin->svg_manager->get_svg_by_id( $image_id ),
			) );

		}

		/**
		 * [get_available_image_sizes description]
		 *
		 * @return void
		 */
		public function get_available_image_sizes() {

			if ( ! current_user_can( 'edit_posts' ) ) {
				return;
			}

			if ( ! isset( $_POST['image_id'] ) ) {
				return;
			}

			$image_id       = intval( $_POST['image_id'] );
			$image_metadata = wp_get_attachment_metadata( $image_id );
			$uploads        = wp_get_upload_dir();
			$path_parts     = pathinfo( $image_metadata['file'] );
			$image_dir_path = trailingslashit( $uploads['baseurl'] ) . trailingslashit( $path_parts['dirname'] );

			$result = array();

			foreach ( $image_metadata['sizes'] as $key => $size ) {
				$result[] = ( object ) array(
					'value' => $image_dir_path . $size['file'],
					'label' => ucwords( trim( str_replace( array( '-', '_' ), array( ' ', ' ' ), $key ) ) )
				);
			}

			array_unshift($result, ( object ) array(
				'value' => $image_dir_path . $path_parts['basename'],
				'label' => esc_html__( 'Full', 'jet-guten' )
			) );

			wp_send_json( $result );

		}

	}

}
