<?php
/**
 * Class description
 *
 * @package   package_name
 * @author    Cherry Team
 * @license   GPL-2.0+
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Guten_Plugin' ) ) {

	/**
	 * Define Jet_Guten_Plugin class
	 */
	class Jet_Guten_Plugin {

		/**
		 * A reference to an instance of this class.
		 *
		 * @since 1.0.0
		 * @var   object
		 */
		private static $instance = null;

		public $ajax_handlers = null;
		public $svg_manager   = null;

		/**
		 * Constructor for the class
		 */
		function __construct() {

			$this->includes();

			$this->ajax_handlers = new Jet_Guten_Ajax_Handlers();
			$this->svg_manager   = new Jet_Guten_SVG_Manager();

			$this->register_blocks();
			$this->admin_init();

		}

		public function register_blocks() {

			if ( ! function_exists( 'register_block_type' ) ) {
				return;
			}

			// Public Scripts.
			wp_register_script(
				'juxtapose',
				JET_GUTEN_URL . 'assets/lib/juxtapose/juxtapose.min.js',
				array(),
				JET_GUTEN_VERSION,
				true
			);

			wp_register_script(
				'jet-guten-blocks',
				JET_GUTEN_URL . 'assets/js/public.js',
				array( 'juxtapose' ),
				JET_GUTEN_VERSION,
				true
			);

			// Public Styles.
			wp_register_style(
				'juxtapose',
				JET_GUTEN_URL . 'assets/lib/juxtapose/juxtapose.css',
				array(),
				JET_GUTEN_VERSION
			);

			wp_register_style(
				'jet-guten-blocks',
				JET_GUTEN_URL . 'assets/css/style.css',
				array( 'juxtapose' ),
				JET_GUTEN_VERSION
			);

			// Editor Scripts.
			wp_register_script(
				'jet-guten-blocks-editor',
				JET_GUTEN_URL . 'assets/js/admin.js',
				array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ),
				JET_GUTEN_VERSION
			);

			wp_localize_script( 'jet-guten-blocks-editor', 'JetGutenSettings', array(
				'imgPlaceholder'    => JET_GUTEN_URL . 'assets/img/placeholder.png',
				'placeholderHeight' => 450,
			) );

			// Editor Styles.
			wp_register_style(
				'juxtapose',
				JET_GUTEN_URL . 'assets/lib/juxtapose/juxtapose.css',
				array(),
				JET_GUTEN_VERSION
			);

			wp_register_style(
				'jet-elements-font',
				JET_GUTEN_URL . 'assets/lib/jetelements-font/css/jetelements.css',
				array( 'wp-edit-blocks' ),
				JET_GUTEN_VERSION
			);

			wp_register_style(
				'jet-guten-blocks-editor',
				JET_GUTEN_URL . 'assets/css/editor.css',
				array( 'wp-edit-blocks', 'juxtapose', 'jet-elements-font' ),
				JET_GUTEN_VERSION
			);

			$blocks = array(
				'pricing-table',
				'animated-box',
				'banner',
				'circle-progress',
				'countdown-timer',
				'image-comparison',
				'inline-svg',
				'map',
				'progress-bar',
			);

			foreach ( $blocks as $block) {
				register_block_type( 'jet-guten/' . $block, array(
					'editor_script' => 'jet-guten-blocks-editor',
					'editor_style'  => 'jet-guten-blocks-editor',
					'script'        => 'jet-guten-blocks',
					'style'         => 'jet-guten-blocks',
				) );
			}

		}

		/**
		 * Include required files
		 *
		 * @return void
		 */
		public function includes() {
			require_once JET_GUTEN_PATH . 'includes/svg-manager.php';
			require_once JET_GUTEN_PATH . 'includes/ajax-handlers.php';
		}

		/**
		 * Initializtions for admin-only parts
		 *
		 * @return void
		 */
		public function admin_init() {

			if ( ! is_admin() ) {
				return;
			}

			require JET_GUTEN_PATH . 'includes/updater/plugin-update.php';

			new Jet_Guten_Plugin_Update( array(
				'version' => JET_GUTEN_VERSION,
				'slug'    => 'jet-guten',
			) );

		}

		/**
		 * Returns the instance.
		 *
		 * @since  1.0.0
		 * @return object
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
			return self::$instance;
		}
	}

}
