<?php
/**
 * SVG management class
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Guten_SVG_Manager' ) ) {

	/**
	 * Define Jet_Guten_SVG_Manager class
	 */
	class Jet_Guten_SVG_Manager {

		/**
		 * Constructor for the class
		 */
		function __construct() {
			add_filter( 'upload_mimes', array( $this, 'allow_svg' ) );
			add_action( 'admin_head', array( $this, 'fix_svg_thumb_display' ) );
		}

		/**
		 * Allow SVG images uploading
		 *
		 * @return array
		 */
		public function allow_svg( $mimes ) {
			$mimes['svg'] = 'image/svg+xml';
			return $mimes;
		}

		/**
		 * Fix thumbnails display
		 *
		 * @return void
		 */
		public function fix_svg_thumb_display() {
			?>
			<style type="text/css">
				td.media-icon img[src$=".svg"], img[src$=".svg"].attachment-post-thumbnail {
					width: 100% !important;
					height: auto !important;
				}
			</style>
			<?php

		}

		/**
		 * Get raw SVG code by image ID
		 *
		 * @param  int $img_id Image ID
		 * @return string
		 */
		public function get_svg_by_id( $img_id ) {

			$file = get_attached_file( $img_id );
			$mime = get_post_mime_type( $img_id );

			if ( 'image/svg+xml' !== $mime ) {
				return __( 'This is not a SVG image', 'jet-guten' );
			}

			$svg = file_get_contents( $file );

			return $svg;

		}

	}

}
