import JetIcon from "components/jet-icon";
import ImageSlector from "components/image-slector";

const className = 'jet-guten-animated-box';

const {
	registerBlockType,
} = wp.blocks;

const {
	__
} = wp.i18n;

const {
	Dashicon,
	Toolbar,
	PanelBody,
	RangeControl,
	SelectControl,
	FontSizePicker,
	RadioControl
} = wp.components;

const {
	BlockControls,
	InspectorControls,
	AlignmentToolbar,
	RichText,
	ColorPalette,
	PanelColorSettings,
	URLInput
} = wp.editor;

const EFFECTS = [{
		value: "effect-1",
		label: __("Flip Vertical")
	},
	{
		value: "effect-2",
		label: __("Flip Horizontal")
	},
	{
		value: "effect-3",
		label: __("Fall Up")
	},
	{
		value: "effect-4",
		label: __("Fall Right")
	},
	{
		value: "effect-5",
		label: __("Slide Down")
	},
	{
		value: "effect-6",
		label: __("Slide Right")
	},
	{
		value: "effect-7",
		label: __("Flip Vertical 3D")
	},
	{
		value: "effect-8",
		label: __("Flip Horizontal 3D")
	}
];

const FONT_SIZES = [{
		name: 'small',
		shortName: 'S',
		size: 14,
	},
	{
		name: 'regular',
		shortName: 'M',
		size: 16,
	},
	{
		name: 'large',
		shortName: 'L',
		size: 36,
	},
	{
		name: 'larger',
		shortName: 'XL',
		size: 48,
	},
];

let imageSizeName;

registerBlockType("jet-guten/animated-box", {
	title: __("Animated Box"),
	icon: <JetIcon icon="animated-box" />,
	category: "layout",
	attributes: {
		effect: {
			type: "string",
			default: "effect-1"
		},
		height: {
			type: 'number',
			default: 250
		},
		panelBorderRadius: {
			type: 'number',
			default: 0,
		},
		side: {
			type: 'string',
			default: 'front'
		},
		contentAlign: {
			type: 'string',
			default: 'center',
		},
		link: {
			type: "string",
			source: "attribute",
			selector: `a.${className}__link`,
			attribute: "href"
		},

		frontPanelColor: {
			type: "string"
		},
		frontPanelImage: {
			type: "object",
			default: {
				id: null,
				url: ''
			},
		},
		frontPanelBorderWidth: {
			type: 'number',
			default: 0,
		},
		frontPanelBorderColor: {
			type: "string",
			default: '#000'
		},
		frontTitle: {
			type: "string",
			source: "html",
			selector: `.${className}__front .${className}__title`
		},
		frontTitleNodeName: {
			type: 'string',
			default: 'H2',
		},
		frontTitleFontSize: {
			type: 'number',
		},
		frontTitleColor: {
			type: "string"
		},
		frontText: {
			type: "string",
			source: "html",
			selector: `.${className}__front .${className}__text`
		},
		frontTextFontSize: {
			type: 'number',
		},
		frontTextColor: {
			type: "string"
		},

		backPanelColor: {
			type: "string"
		},
		backPanelImage: {
			type: "object",
			default: {
				id: null,
				url: ''
			},
		},
		backPanelBorderWidth: {
			type: 'number',
			default: 0,
		},
		backPanelBorderColor: {
			type: "string",
			default: '#000'
		},
		backTitle: {
			type: "string",
			source: "html",
			selector: `.${className}__back .${className}__title`
		},
		backTitleNodeName: {
			type: 'string',
			default: 'H2',
		},
		backTitleFontSize: {
			type: 'number',
		},
		backTitleColor: {
			type: "string"
		},
		backText: {
			type: "string",
			source: "html",
			selector: `.${className}__back .${className}__text`
		},
		backTextFontSize: {
			type: 'number',
		},
		backTextColor: {
			type: "string"
		}

	},
	edit: props => {
		const { setAttributes, isSelected } = props;
		const {
			effect,
			height,
			panelBorderRadius,
			side,
			contentAlign,
			link,

			frontPanelColor,
			frontPanelImage,
			frontPanelBorderColor,
			frontPanelBorderWidth,
			frontTitle,
			frontTitleNodeName,
			frontTitleFontSize,
			frontTitleColor,
			frontText,
			frontTextColor,
			frontTextFontSize,

			backPanelColor,
			backPanelImage,
			backPanelBorderColor,
			backPanelBorderWidth,
			backTitle,
			backTitleNodeName,
			backTitleFontSize,
			backTitleColor,
			backText,
			backTextColor,
			backTextFontSize
		} = props.attributes;

		if (!isSelected) {
			setAttributes({ side: 'front' });
		}

		return [
			<BlockControls>
				<AlignmentToolbar
					value={ contentAlign }
					onChange={ ( newContentAlign ) => {
						setAttributes( { contentAlign: newContentAlign } );
					} }
				/>
				<Toolbar>
					<RadioControl
						className="jet-guten-radio"
						selected={ side }
						options={ [
							{ label: 'Front', value: 'front' },
							{ label: 'Back', value: 'back' },
						] }
						onChange={ newSide => {
							setAttributes({ side: newSide });
						} }
					/>
				</Toolbar>
			</BlockControls>,
			<InspectorControls key={"inspector"}>
				<PanelBody
					title={__("General Settings")}
				>
					<SelectControl
						label={ __( 'Animation Effect' ) }
						value={effect}
						options={EFFECTS.map(({ value, label }) => ({
							value: value,
							label: label
						}))}
						onChange={newEffect => {
							setAttributes({ effect: newEffect });
						}}
					/>
					<RangeControl
						label={__("Height")}
						value={height}
						onChange={newHeight =>
							setAttributes({
								height: newHeight
							})
						}
						min={100}
						max={1000}
						step={1}
					/>
					<RangeControl
						label={__("Border Radius")}
						value={panelBorderRadius}
						onChange={newPanelBorderRadius =>
							setAttributes({
								panelBorderRadius: newPanelBorderRadius
							})
						}
						min={0}
						max={100}
						step={1}
					/>
				</PanelBody>
				<PanelBody
					title={__("Front Settings")}
					initialOpen={false}
				>
					<PanelBody
						title={ __( 'Front Title Settings' ) }
						initialOpen={false}
					>
						<p>{ __( 'Heading Tag' ) }</p>
						<Toolbar
							controls={ '123456'.split( '' ).map( ( level ) => ( {
								icon: 'heading',
								isActive: 'H' + level === frontTitleNodeName,
								onClick: () => setAttributes( { frontTitleNodeName: 'H' + level } ),
								subscript: level,
							} ) ) }
						/>
						<p>{ __( 'Size' ) }</p>
						<FontSizePicker
							fontSizes={ FONT_SIZES }
							value={ frontTitleFontSize }
							onChange={newFrontTitleFontSize =>
								setAttributes({ frontTitleFontSize: newFrontTitleFontSize })
							}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: frontTitleColor,
									onChange: function( colorValue ) {
										setAttributes({
											frontTitleColor: colorValue
										})
									},
									label: __( 'Title Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelBody
						title={ __( 'Front Description Settings' ) }
						initialOpen={false}
					>
						<p>{ __( 'Size' ) }</p>
						<FontSizePicker
							fontSizes={ FONT_SIZES }
							value={ frontTextFontSize }
							onChange={newFrontTextFontSize =>
								setAttributes({ frontTextFontSize: newFrontTextFontSize })
							}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: frontTextColor,
									onChange: function( colorValue ) {
										setAttributes({
											frontTextColor: colorValue
										})
									},
									label: __( 'Description Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelColorSettings
						title={__("Front Panel Color")}
						colorSettings={ [
							{
								value: frontPanelColor,
								onChange: function( colorValue ) {
									setAttributes({
										frontPanelColor: colorValue
									})
								},
								label: __( 'Panel Color' ),
							},
						] }
					>
					</PanelColorSettings>
					<PanelBody
						title={ __( 'Front Panel Border' ) }
						initialOpen={false}
					>
						<RangeControl
							label={__("Border Width")}
							value={frontPanelBorderWidth}
							onChange={newFrontPanelBorderWidth =>
								setAttributes({
									frontPanelBorderWidth: newFrontPanelBorderWidth
								})
							}
							min={0}
							max={25}
							step={1}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: frontPanelBorderColor,
									onChange: function( colorValue ) {
										setAttributes({
											frontPanelBorderColor: colorValue
										})
									},
									label: __( 'Border Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelBody
						title={__("Front Panel Image")}
						initialOpen={false}
					>
						<ImageSlector
							image={frontPanelImage}
							onChangeImage={newFrontPanelImage => {
								setAttributes({
									frontPanelImage: Object.assign({}, newFrontPanelImage)
								})
							} }
						/>
					</PanelBody>
				</PanelBody>

				<PanelBody
					title={__("Back Settings")}
					initialOpen={false}
				>
					<PanelBody
						title={ __( 'Back Title Settings' ) }
						initialOpen={false}
					>
						<p>{ __( 'Heading Tag' ) }</p>
						<Toolbar
							controls={ '123456'.split( '' ).map( ( level ) => ( {
								icon: 'heading',
								isActive: 'H' + level === backTitleNodeName,
								onClick: () => setAttributes( { backTitleNodeName: 'H' + level } ),
								subscript: level,
							} ) ) }
						/>
						<p>{ __( 'Size' ) }</p>
						<FontSizePicker
							fontSizes={ FONT_SIZES }
							value={ backTitleFontSize }
							onChange={newBackTitleFontSize =>
								setAttributes({ backTitleFontSize: newBackTitleFontSize })
							}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: backTitleColor,
									onChange: function( colorValue ) {
										setAttributes({
											backTitleColor: colorValue
										})
									},
									label: __( 'Title Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelBody
						title={ __( 'Back Description Settings' ) }
						initialOpen={false}
					>
						<p>{ __( 'Size' ) }</p>
						<FontSizePicker
							fontSizes={ FONT_SIZES }
							value={ backTextFontSize }
							onChange={newBackTextFontSize =>
								setAttributes({ backTextFontSize: newBackTextFontSize })
							}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: backTextColor,
									onChange: function( colorValue ) {
										setAttributes({
											backTextColor: colorValue
										})
									},
									label: __( 'Description Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelColorSettings
						title={__("Back Panel Color")}
						colorSettings={ [
							{
								value: backPanelColor,
								onChange: function( colorValue ) {
									setAttributes({
										backPanelColor: colorValue
									})
								},
								label: __( 'Panel Color' ),
							},
						] }
					>
					</PanelColorSettings>
					<PanelBody
						title={ __( 'Back Panel Border' ) }
						initialOpen={false}
					>
						<RangeControl
							label={__("Border Width")}
							value={backPanelBorderWidth}
							onChange={newBackPanelBorderWidth =>
								setAttributes({
									backPanelBorderWidth: newBackPanelBorderWidth
								})
							}
							min={0}
							max={25}
							step={1}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: backPanelBorderColor,
									onChange: function( colorValue ) {
										setAttributes({
											backPanelBorderColor: colorValue
										})
									},
									label: __( 'Border Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelBody
						title={__("Back Panel Image")}
						initialOpen={false}
					>
						<ImageSlector
							image={backPanelImage}
							onChangeImage={newBackPanelImage => {
								setAttributes({
									backPanelImage: Object.assign({}, newBackPanelImage)
								})
							} }
						/>
					</PanelBody>
				</PanelBody>
			</InspectorControls>,
			<div className={`${className} jet-box-${effect}` + ( side === 'back' ? ' flipped' : '')}
				style={{
					height: height + 'px'
				}}
			>
				<div className={`${className}__front`}
					style={{
						borderRadius: panelBorderRadius + 'px',
						border: `${frontPanelBorderWidth}px solid ${frontPanelBorderColor}`
					}}
				>
					<div className={`${className}__overlay`}
						style={{
							backgroundColor: frontPanelColor
						}}
					>
						{ frontPanelImage.url && (
							<img className={`${className}__overlay__img`} src={frontPanelImage.url} />
						)}
					</div>
					<div className={`${className}__content`}>
						<RichText
							tagName={ frontTitleNodeName.toLowerCase() }
							className={`${className}__title`}
							placeholder={__("Write box title…")}
							isSelected={false}
							value={frontTitle}
							onChange={newFrontTitle =>
								setAttributes({
									frontTitle: newFrontTitle
								})
							}
							style={{
								color: frontTitleColor,
								fontSize: frontTitleFontSize ? frontTitleFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
						<RichText
							tagName="div"
							className={`${className}__text`}
							placeholder={ __( 'Write box text…' ) }
							isSelected={false}
							value={ frontText }
							onChange={ ( newFrontText ) => {
								setAttributes( {
									frontText: newFrontText,
								} );
							} }
							style={{
								color: frontTextColor,
								fontSize: frontTextFontSize ? frontTextFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
					</div>
				</div>
				<div className={`${className}__back`}
					style={{
						borderRadius: panelBorderRadius + 'px',
						border: `${backPanelBorderWidth}px solid ${backPanelBorderColor}`
					}}
				>
					<div className={`${className}__overlay`}
						style={{
							backgroundColor: backPanelColor
						}}
					>
						{ backPanelImage.url && (
							<img className={`${className}__overlay__img`} src={backPanelImage.url} />
						)}
					</div>
					<div className={`${className}__content`}>
						<RichText
							tagName={ backTitleNodeName.toLowerCase() }
							className={`${className}__title`}
							placeholder={__("Write box title…")}
							isSelected={false}
							value={backTitle}
							onChange={newBackTitle =>
								setAttributes({
									backTitle: newBackTitle
								})
							}
							style={{
								color: backTitleColor,
								fontSize: backTitleFontSize ? backTitleFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
						<RichText
							tagName="div"
							className={`${className}__text`}
							placeholder={ __( 'Write box text…' ) }
							isSelected={false}
							value={ backText }
							onChange={ ( newBackText ) => {
								setAttributes( {
									backText: newBackText,
								} );
							} }
							style={{
								color: backTextColor,
								fontSize: backTextFontSize ? backTextFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
					</div>
				</div>
			</div>,
			isSelected && (
				<form
					className="jet-guten-editor__inline-link"
					onSubmit={event => event.preventDefault()}
				>
					<Dashicon
						className="jet-guten-editor__inline-link__icon"
						icon="admin-links"
					/>
					<URLInput
						autoFocus={false}
						value={link}
						onChange={newLink => setAttributes({ link: newLink })}
					/>
				</form>
			)
		]
	},
	save: props => {
		const {
			attributes: {
				effect,
				height,
				panelBorderRadius,
				contentAlign,
				link,

				frontPanelColor,
				frontPanelImage,
				frontPanelBorderColor,
				frontPanelBorderWidth,
				frontTitle,
				frontTitleNodeName,
				frontTitleFontSize,
				frontTitleColor,
				frontText,
				frontTextColor,
				frontTextFontSize,

				backPanelColor,
				backPanelImage,
				backPanelBorderColor,
				backPanelBorderWidth,
				backTitle,
				backTitleNodeName,
				backTitleFontSize,
				backTitleColor,
				backText,
				backTextColor,
				backTextFontSize
			}
		} = props;

		return (
			<div className={`${className} jet-box-${effect}`}
				style={{
					height: height + 'px'
				}}
			>
				{link && (
					<a
						className={`${className}__link`}
						href={link}
					></a>
				)}
				<div className={`${className}__front`}
					style={{
						borderRadius: panelBorderRadius + 'px',
						border: `${frontPanelBorderWidth}px solid ${frontPanelBorderColor}`
					}}
				>
					<div className={`${className}__overlay`}
						style={{
							backgroundColor: frontPanelColor
						}}
					>
						{ frontPanelImage.url && (
							<img className={`${className}__overlay__img`} src={frontPanelImage.url} />
						)}
					</div>
					<div className={`${className}__content`}>
						<RichText.Content
							tagName={ frontTitleNodeName.toLowerCase() }
							className={`${className}__title`}
							value={frontTitle}
							style={{
								color: frontTitleColor,
								fontSize: frontTitleFontSize ? frontTitleFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
						<RichText.Content
							tagName="div"
							className={`${className}__text`}
							value={ frontText }
							style={{
								color: frontTextColor,
								fontSize: frontTextFontSize ? frontTextFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
					</div>
				</div>
				<div className={`${className}__back`}
					style={{
						borderRadius: panelBorderRadius + 'px',
						border: `${backPanelBorderWidth}px solid ${backPanelBorderColor}`
					}}
				>
					<div className={`${className}__overlay`}
						style={{
							backgroundColor: backPanelColor
						}}
					>
						{ backPanelImage.url && (
							<img className={`${className}__overlay__img`} src={backPanelImage.url} />
						)}
					</div>
					<div className={`${className}__content`}>
						<RichText.Content
							tagName={ backTitleNodeName.toLowerCase() }
							className={`${className}__title`}
							value={backTitle}
							style={{
								color: backTitleColor,
								fontSize: backTitleFontSize ? backTitleFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
						<RichText.Content
							tagName="div"
							className={`${className}__text`}
							value={ backText }
							style={{
								color: backTextColor,
								fontSize: backTextFontSize ? backTextFontSize + 'px' : undefined,
								textAlign: contentAlign
							}}
						/>
					</div>
				</div>
			</div>
		);
	}
});