import JetIcon from "components/jet-icon";

const { __ } = wp.i18n;
const {
	registerBlockType
} = wp.blocks;
const {
	InspectorControls,
	ColorPalette,
	RichText,
	Editable
} = wp.editor;
const {
	PanelColor,
	SelectControl,
	PanelBody,
	RangeControl,
	TextareaControl
} = wp.components;

class JetAnimatedWords extends wp.element.Component {

	componentDidMount() {
		const {
			blockID
		} = this.props;

		this.animated = new JetGutenAnimatedText( jQuery( '#' + blockID ) );
		this.animated.init();
	}

	/* componentDidUpdate( prevProps, prevState ) {

		const {
			blockID
		} = this.props;

		if ( this.animated ) {
			this.animated.destroy();
		}

		let animated = new JetGutenAnimatedText( jQuery( '#' + blockID ) );
		animated.init();
		this.animated = animated;

	} */

	componentDidUpdate( prevProps, prevState ) {
		if (prevProps.words !== this.props.words) {
			this.animated.destroy();
			this.animated.init();
		}
	}

	render() {
		const {
			words,
			splitType
		} = this.props;

		let parsedWords = words.split( /\,[\s]?/ );
		parsedWords = parsedWords.map( function( word ) {
			if ( 'symbols' === splitType ) {
				return word.split( '' );
			} else {
				return [ word ];
			}

		} );

		let isFirst = true;

		return <div className="animated-text__content">{ parsedWords.map( function( word, i ) {

			let classes = [ 'animated-text__content-item' ];
			let wordKey = 'word-' + i;

			if ( isFirst ) {
				classes.push( 'active visible' );
			}

			isFirst = false;

			return <div key={ wordKey } className={ classes.join( ' ' ) }>
				{ word.map( function( symbol, j ) {
					let key = 'symbol-' + i + j;
					console.log(symbol);
					return <span key={ key }>{ symbol }</span>;
				}) }
			</div>;
		}) }</div>;
	}
}

registerBlockType( 'jet-guten/animated-text', {
	title: __( 'Animated Text' ),
	icon: <JetIcon icon="animated-text" />,
	category: 'layout',
	attributes: {
		textBefore: {
			type: 'array',
			source: 'children',
			selector: '.animated-text__before',
			default: __( 'Let us' )
		},
		textAfter: {
			type: 'array',
			source: 'children',
			selector: '.animated-text__after',
			default: __( 'your text' )
		},
		toAnimate: {
			type: 'string',
			source: 'attribute',
			attribute: 'data-content',
			selector: 'div[data-content]',
			default: __( 'Create, Animate' )
		},
		splitType: {
			type: 'string',
			default: 'symbols',
		}
	},
	edit: props => {

		const focusedEditable = props.focus ? props.focus.editable || 'title' : null;
		const attributes = props.attributes;
		const splitTypeOptions = [
			{
				value: 'symbols',
				label: __( 'Symbols' ),
			},
			{
				value: 'words',
				label: __( 'Words' ),
			}
		];

		return [
			props.isSelected && (
					<InspectorControls
						key={ 'inspector' }
					>
						<PanelBody title={ __( 'General Settings' ) }>
							<TextareaControl
								label="Text to animate"
								value={ attributes.toAnimate }
								help="Enter comma separated words to animate"
								onChange={ ( value ) => props.setAttributes( { toAnimate: value } ) }
							/>
							<SelectControl
								label={ __( 'Split Type' ) }
								value={ attributes.splitType }
								options={ splitTypeOptions }
								onChange={ ( value ) => props.setAttributes( { splitType: value } ) }
							/>
						</PanelBody>
					</InspectorControls>
			),
			<div
				className={ props.className }
				id={ 'animated_text_' + props.clientId }
				data-content={ attributes.progressLayout }
			>
				<div className="animated-text">
					<div className="animated-text__before">
						<RichText
							placeholder={ __( 'Text before...' ) }
							value={ attributes.textBefore }
							onChange={ ( value ) => props.setAttributes( { textBefore: value } ) }
						/>
					</div>
					<JetAnimatedWords
						words={ attributes.toAnimate }
						splitType={ attributes.splitType }
						blockID={ 'animated_text_' + props.clientId }
					/>
					<div className="animated-text__after">
						<RichText
							placeholder={ __( 'Text after...' ) }
							value={ attributes.textAfter }
							onChange={ ( value ) => props.setAttributes( { textAfter: value } ) }
						/>
					</div>
				</div>
			</div>
		];
	},
	save: props => {

		const {
			className,
			attributes
		} = props;
		const currentLayout = attributes.progressLayout;

		let statusBarStyles;
		let wrapperStyles;
		let titleStyles;
		let valueStyles;

		if ( 'layout-6' === currentLayout ) {
			statusBarStyles = {
				height: attributes.progressValue + '%',
				background: attributes.progressColor,
			}
		} else {
			statusBarStyles = {
				width: attributes.progressValue + '%',
				background: attributes.progressColor,
			}
		}

		wrapperStyles = {
			height: attributes.barHeight + 'px',
			background: attributes.barColor,
		}

		if ( 'layout-6' === currentLayout ) {
			wrapperStyles.width = attributes.barWidth + 'px';
		}

		titleStyles = {
			color: attributes.titleColor,
		}

		valueStyles = {
			color: attributes.valueColor,
		}

		return (
			<div
				className={ props.className }
				data-value={ attributes.progressValue }
				data-layout={ attributes.progressLayout }
			>
				<div className={ [ 'progress-bar', 'progress-bar--' + attributes.progressLayout ].join(' ') }>
					<div className="progress-bar__inner">

						{ ( 'layout-1' === currentLayout || 'layout-3' === currentLayout || 'layout-4' === currentLayout ) &&
							<div className="progress-bar__title" style={ titleStyles }>
								{ attributes.title }
							</div>
						}

						{ 'layout-2' === currentLayout &&
							<div className="progress-bar__percent" style={ valueStyles }>
								<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
								<span className="progress-bar__percent-suffix">&#37;</span>
							</div>
						}

						<div className="progress-bar__wrapper" style={ wrapperStyles }>
							{ 'layout-6' === currentLayout &&
								<div className="progress-bar__percent" style={ valueStyles }>
									<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
									<span className="progress-bar__percent-suffix">&#37;</span>
								</div>
							}
							<div
								className="progress-bar__status-bar"
								style={ statusBarStyles }
							>
								{ 'layout-1' === currentLayout &&
									<div className="progress-bar__percent" style={ valueStyles }>
										<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
										<span className="progress-bar__percent-suffix">&#37;</span>
									</div>
								}
							</div>
							{ 'layout-4' === currentLayout &&
								<div className="progress-bar__percent" style={ valueStyles }>
									<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
									<span className="progress-bar__percent-suffix">&#37;</span>
								</div>
							}
							{ 'layout-5' === currentLayout &&
								<div className="jet-progress-bar__status">
									<div className="progress-bar__title" style={ titleStyles }>
										{ attributes.title }
									</div>
									<div className="progress-bar__percent" style={ valueStyles }>
										<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
										<span className="progress-bar__percent-suffix">&#37;</span>
									</div>
								</div>
							}
						</div>

						{ ( 'layout-2' === currentLayout || 'layout-6' === currentLayout ) &&
							<div className="progress-bar__title" style={ titleStyles }>
								{ attributes.title }
							</div>
						}

						{ 'layout-3' === currentLayout &&
							<div className="progress-bar__percent" style={ valueStyles }>
								<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
								<span className="progress-bar__percent-suffix">&#37;</span>
							</div>
						}

					</div>
				</div>
			</div>
		);
	}
} );
