import JetIcon from "components/jet-icon";
import {
	getTimeRemaining
} from "utils/timeDate";

const className = 'jet-guten-countdown-timer';

const {
	registerBlockType,
} = wp.blocks;

const {
	__
} = wp.i18n;

const {
	PanelBody,
	Dropdown,
	DateTimePicker,
	FontSizePicker,
	CheckboxControl,
	RangeControl
} = wp.components;

const {
	InspectorControls,
	PanelColorSettings,
	ColorPalette
} = wp.editor;

const FONT_SIZES = [
	{
		name: 'small',
		shortName: 'S',
		size: 14,
	},
	{
		name: 'regular',
		shortName: 'M',
		size: 16,
	},
	{
		name: 'large',
		shortName: 'L',
		size: 36,
	},
	{
		name: 'larger',
		shortName: 'XL',
		size: 48,
	},
];

registerBlockType("jet-guten/countdown-timer", {
	title: __("Countdown Timer"),
	icon: <JetIcon icon="timer" />,
	category: "layout",
	attributes: {
		endDate: {
			type: "string"
		},
		panelSize: {
			type: 'number',
			default: 80,
		},
		separator: {
			type: 'boolean',
			default: true,
		},
		valueColor: {
			type: "string"
		},
		valueFontSize: {
			type: 'number',
		},
		labels: {
			type: 'boolean',
			default: true,
		},
		labelColor: {
			type: "string"
		},
		labelFontSize: {
			type: 'number',
		},
		panelBGColor: {
			type: "string"
		},
		panelBorderRadius: {
			type: 'number',
			default: 0,
		},
		panelBorderWidth: {
			type: 'number',
			default: 0,
		},
		panelBorderColor: {
			type: "string",
			default: '#000'
		},
	},
	edit: props => {
		const { setAttributes, isSelected } = props;
		const {
			endDate,
			panelSize,
			separator,
			valueColor,
			valueFontSize,
			labels,
			labelColor,
			labelFontSize,
			panelBGColor,
			panelBorderRadius,
			panelBorderWidth,
			panelBorderColor
		} = props.attributes;

		let parsedEndDate = getTimeRemaining(endDate);

		return [
			isSelected && (
				<InspectorControls key={"inspector"}>
					<PanelBody
						title={__("General Settings")}
					>
						<RangeControl
							label={__("Size")}
							value={panelSize}
							onChange={newPanelSize =>
								setAttributes({
									panelSize: newPanelSize
								})
							}
							min={50}
							max={200}
							step={1}
						/>
						<CheckboxControl
							label={__( 'Shwo Separator' )}
							checked={separator}
							onChange={newSeparator => {
								setAttributes({ separator: newSeparator });
							}}
						/>
					</PanelBody>
					<PanelBody
						title={__("Value Settings")}
						initialOpen={false}
					>
						<p>{ __( 'Size' ) }</p>
						<FontSizePicker
							fontSizes={ FONT_SIZES }
							value={ valueFontSize }
							onChange={newValueFontSize =>
								setAttributes({ valueFontSize: newValueFontSize })
							}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: valueColor,
									onChange: function( colorValue ) {
										setAttributes({
											valueColor: colorValue
										})
									},
									label: __( 'Value Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelBody
						title={__("Label Settings")}
						initialOpen={false}
					>
						<CheckboxControl
							label={__( 'Shwo labels' )}
							checked={labels}
							onChange={newLabels => {
								setAttributes({ labels: newLabels });
							}}
						/>
						<p>{ __( 'Size' ) }</p>
						<FontSizePicker
							fontSizes={FONT_SIZES}
							value={labelFontSize}
							onChange={newLabelFontSize =>
								setAttributes({ labelFontSize: newLabelFontSize })
							}
						/>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: labelColor,
									onChange: function( colorValue ) {
										setAttributes({
											labelColor: colorValue
										})
									},
									label: __( 'Label Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
					<PanelBody
						title={__("Panel Settings")}
						initialOpen={false}
					>
						<PanelColorSettings
							title={__("Color")}
							colorSettings={ [
								{
									value: panelBGColor,
									onChange: function( colorValue ) {
										setAttributes({
											panelBGColor: colorValue
										})
									},
									label: __( 'Panel Color' ),
								},
							] }
						>
						</PanelColorSettings>
						<RangeControl
							label={__("Border Radius")}
							value={panelBorderRadius}
							onChange={newPanelBorderRadius =>
								setAttributes({
									panelBorderRadius: newPanelBorderRadius
								})
							}
							min={0}
							max={50}
							step={1}
						/>
						<RangeControl
							label={__("Border Width")}
							value={panelBorderWidth}
							onChange={newPanelBorderWidth =>
								setAttributes({
									panelBorderWidth: newPanelBorderWidth
								})
							}
							min={0}
							max={25}
							step={1}
						/>
						<PanelColorSettings
							title={__("Border Color")}
							colorSettings={ [
								{
									value: panelBorderColor,
									onChange: function( colorValue ) {
										setAttributes({
											panelBorderColor: colorValue
										})
									},
									label: __( 'Border Color' ),
								},
							] }
						>
						</PanelColorSettings>
					</PanelBody>
				</InspectorControls>
			),
			<Dropdown
				renderToggle={ ({onToggle}) => (
					<div
						className={className}
						onClick={onToggle}
					>
						<div
							className={`${className}__days`}
							style={{
								width: panelSize + 'px',
								height: panelSize + 'px',
								borderRadius: panelBorderRadius + '%',
								border: `${panelBorderWidth}px solid ${panelBorderColor}`,
								backgroundColor: panelBGColor
							}}
						>
							<div
								className={`${className}__value`}
								style={{
									color: valueColor,
									fontSize: valueFontSize ? valueFontSize + 'px' : undefined
								}}
							>{parsedEndDate.days}</div>
							{labels && ( <div
								className={`${className}__label`}
								style={{
									color: labelColor,
									fontSize: labelFontSize ? labelFontSize + 'px' : undefined
								}}
							>{__("Days")}</div> )}
						</div>
						{separator && ( <div className={`${className}__separator`}>:</div> )}
						<div
							className={`${className}__hours`}
							style={{
								width: panelSize + 'px',
								height: panelSize + 'px',
								borderRadius: panelBorderRadius + '%',
								border: `${panelBorderWidth}px solid ${panelBorderColor}`,
								backgroundColor: panelBGColor
							}}
						>
							<div
								className={`${className}__value`}
								style={{
									color: valueColor,
									fontSize: valueFontSize ? valueFontSize + 'px' : undefined
								}}
							>{parsedEndDate.hours}</div>
							{labels && ( <div
								className={`${className}__label`}
								style={{
									color: labelColor,
									fontSize: labelFontSize ? labelFontSize + 'px' : undefined
								}}
							>{__("Hours")}</div> )}
						</div>
						{separator && ( <div className={`${className}__separator`}>:</div> )}
						<div
							className={`${className}__minutes`}
							style={{
								width: panelSize + 'px',
								height: panelSize + 'px',
								borderRadius: panelBorderRadius + '%',
								border: `${panelBorderWidth}px solid ${panelBorderColor}`,
								backgroundColor: panelBGColor
							}}
						>
							<div
								className={`${className}__value`}
								style={{
									color: valueColor,
									fontSize: valueFontSize ? valueFontSize + 'px' : undefined
								}}
							>{parsedEndDate.minutes}</div>
							{labels && ( <div
								className={`${className}__label`}
								style={{
									color: labelColor,
									fontSize: labelFontSize ? labelFontSize + 'px' : undefined
								}}
							>{__("Minutes")}</div> )}
						</div>
						{separator && ( <div className={`${className}__separator`}>:</div> )}
						<div
							className={`${className}__seconds`}
							style={{
								width: panelSize + 'px',
								height: panelSize + 'px',
								borderRadius: panelBorderRadius + '%',
								border: `${panelBorderWidth}px solid ${panelBorderColor}`,
								backgroundColor: panelBGColor
							}}
						>
							<div
								className={`${className}__value`}
								style={{
									color: valueColor,
									fontSize: valueFontSize ? valueFontSize + 'px' : undefined
								}}
							>{parsedEndDate.seconds}</div>
							{labels && ( <div
								className={`${className}__label`}
								style={{
									color: labelColor,
									fontSize: labelFontSize ? labelFontSize + 'px' : undefined
								}}
							>{__("Seconds")}</div> )}
						</div>
					</div>
				) }
				renderContent={ () =>
					<div class="jet-guten-date-time-picker-wrapper">
						<DateTimePicker
							key="date-time-picker"
							currentDate={ endDate }
							onChange={ newEndDate =>
								setAttributes( {
									endDate: newEndDate
								} )
							}
						/>
					</div>
				}
			/>
		];
	},
	save: props => {
		const {
			attributes: {
				endDate,
				panelSize,
				separator,
				valueColor,
				valueFontSize,
				labels,
				labelColor,
				labelFontSize,
				panelBGColor,
				panelBorderRadius,
				panelBorderWidth,
				panelBorderColor
			}
		} = props;

		return (
			<div
				className={className}
				data-end-date={endDate}
			>
				<div
					className={`${className}__days`}
					style={{
						width: panelSize + 'px',
						height: panelSize + 'px',
						borderRadius: panelBorderRadius + '%',
						border: `${panelBorderWidth}px solid ${panelBorderColor}`,
						backgroundColor: panelBGColor
					}}
				>
					<div
						className={`${className}__value`}
						style={{
							color: valueColor,
							fontSize: valueFontSize ? valueFontSize + 'px' : undefined
						}}
					>0</div>
					{labels && (
						<div
							className={`${className}__label`}
							style={{
								color: labelColor,
								fontSize: labelFontSize ? labelFontSize + 'px' : undefined
							}}
						>{__("Days")}</div>
					)}
				</div>
				{separator && ( <div className={`${className}__separator`}>:</div> )}
				<div
					className={`${className}__hours`}
					style={{
						width: panelSize + 'px',
						height: panelSize + 'px',
						borderRadius: panelBorderRadius + '%',
						border: `${panelBorderWidth}px solid ${panelBorderColor}`,
						backgroundColor: panelBGColor
					}}
				>
					<div
						className={`${className}__value`}
						style={{
							color: valueColor,
							fontSize: valueFontSize ? valueFontSize + 'px' : undefined
						}}
					>0</div>
					{labels && (
						<div
							className={`${className}__label`}
							style={{
								color: labelColor,
								fontSize: labelFontSize ? labelFontSize + 'px' : undefined
							}}
						>{__("Hours")}</div>
					)}
				</div>
				{separator && ( <div className={`${className}__separator`}>:</div> )}
				<div
					className={`${className}__minutes`}
					style={{
						width: panelSize + 'px',
						height: panelSize + 'px',
						borderRadius: panelBorderRadius + '%',
						border: `${panelBorderWidth}px solid ${panelBorderColor}`,
						backgroundColor: panelBGColor
					}}
				>
					<div
						className={`${className}__value`}
						style={{
							color: valueColor,
							fontSize: valueFontSize ? valueFontSize + 'px' : undefined
						}}
					>0</div>
					{labels && (
						<div
							className={`${className}__label`}
							style={{
								color: labelColor,
								fontSize: labelFontSize ? labelFontSize + 'px' : undefined
							}}
						>{__("Minutes")}</div>
					)}
				</div>
				{separator && ( <div className={`${className}__separator`}>:</div> )}
				<div
					className={`${className}__seconds`}
					style={{
						width: panelSize + 'px',
						height: panelSize + 'px',
						borderRadius: panelBorderRadius + '%',
						border: `${panelBorderWidth}px solid ${panelBorderColor}`,
						backgroundColor: panelBGColor
					}}
				>
					<div
						className={`${className}__value`}
						style={{
							color: valueColor,
							fontSize: valueFontSize ? valueFontSize + 'px' : undefined
						}}
					>0</div>
					{labels && (
						<div
							className={`${className}__label`}
							style={{
								color: labelColor,
								fontSize: labelFontSize ? labelFontSize + 'px' : undefined
							}}
						>{__("Seconds")}</div>
					)}
				</div>
			</div>
		);
	}
});