import JetIcon from "components/jet-icon";

const { __ } = wp.i18n;
const {
	registerBlockType
} = wp.blocks;
const {
	InspectorControls,
	ColorPalette,
	RichText,
	Editable,
	MediaUpload,
} = wp.editor;
const {
	PanelColor,
	SelectControl,
	IconButton,
	PanelBody,
	RangeControl,
	FontSizePicker,
	TextControl,
} = wp.components;

const FONT_SIZES = [{
		name: 'small',
		shortName: 'S',
		size: 14,
	},
	{
		name: 'regular',
		shortName: 'M',
		size: 16,
	},
	{
		name: 'large',
		shortName: 'L',
		size: 36,
	},
	{
		name: 'larger',
		shortName: 'XL',
		size: 48,
	},
];

registerBlockType( 'jet-guten/image-comparison', {
	title: __( 'Image Comparison' ),
	icon: <JetIcon icon="image-comparison" />,
	category: 'layout',
	attributes: {
		imageBeforeId: {
			type: 'string',
		},
		imageBeforeUrl: {
			type: 'string',
			default: JetGutenSettings.imgPlaceholder,
		},
		imageAfterId: {
			type: 'string',
		},
		imageAfterUrl: {
			type: 'string',
			default: JetGutenSettings.imgPlaceholder,
		},
		imgHeight: {
			type: 'string',
			default: JetGutenSettings.placeholderHeight,
		},
		labelBefore: {
			type: 'string',
			default: __( 'Before' ),
		},
		labelAfter: {
			type: 'string',
			default: __( 'After' ),
		},
		startPosition: {
			type: 'number',
			default: 50,
		},
		controlsColor: {
			type: 'string',
		},
		borderWidth: {
			type: 'number',
			default: 0,
		},
		borderColor: {
			type: 'string',
		},
		labelsBg: {
			type: 'string',
		},
		labelsColor: {
			type: 'string',
		},
		labelsOpacity: {
			type: 'number',
			default: 100,
		}
	},
	edit: props => {

		const focusedEditable = props.focus ? props.focus.editable || 'title' : null;
		const attributes = props.attributes;

		let labelsStyle = {
			color: attributes.labelsColor,
			backgroundColor: attributes.labelsBg,
			opacity: ( attributes.labelsOpacity / 100 ),
		}

		return [
			props.isSelected && (
					<InspectorControls
						key={ 'inspector' }
					>
						<PanelBody title={ __( 'General Settings' ) }>
							<h4>{ __("Image Before") }</h4>
							<TextControl
								label={ __( 'Label before' ) }
								value={ attributes.labelBefore }
								onChange={ ( value ) => props.setAttributes( { labelBefore: value } ) }
							/>
							{ attributes.imageBeforeUrl &&
								<img src={ attributes.imageBeforeUrl } width="100%" height="auto" />
							}
							<MediaUpload
								onSelect={ media => {
										props.setAttributes( {
											imageBeforeId: media.id,
											imageBeforeUrl: media.url,
										} );
									}
								}
								type="image"
								value={ attributes.imageBeforeId }
								render={({ open }) => (
									<IconButton
										label={ __( "Select Image Before" ) }
										icon="edit"
										onClick={ open }
									>{ __("Select Image Before") }</IconButton>
								)}
							/>
							<h4>{ __( "Image After" ) }</h4>
							<TextControl
								label={ __( 'Label after' ) }
								value={ attributes.labelAfter }
								onChange={ ( value ) => props.setAttributes( { labelAfter: value } ) }
							/>
							{ attributes.imageAfterUrl &&
								<img src={ attributes.imageAfterUrl } width="100%" height="auto" />
							}
							<MediaUpload
								onSelect={ media => {
										props.setAttributes( {
											imageAfterId: media.id,
											imageAfterUrl: media.url,
										} );
									}
								}
								type="image"
								value={ attributes.imageAfterId }
								render={({ open }) => (
									<IconButton
										label={ __( "Select Image After" ) }
										icon="edit"
										onClick={ open }
									>{ __("Select Image After") }</IconButton>
								)}
							/>
							<RangeControl
								label={ __( 'Start Position' ) }
								value={ attributes.startPosition }
								min='0'
								max='100'
								onChange={ ( value ) => props.setAttributes( { startPosition: value } ) }
							/>
						</PanelBody>
						<PanelBody title={ __( 'Style Settings' ) } initialOpen={ false }>
							<h4>{ __( 'Controls Color' ) }</h4>
							<ColorPalette
								value={ attributes.controlsColor }
								onChange={ ( value ) => props.setAttributes( { controlsColor: value } ) }
							/>
							<h4>{ __( 'Border' ) }</h4>
							<RangeControl
								label={ __( 'Border Width' ) }
								value={ attributes.borderWidth }
								min='0'
								max='20'
								onChange={ ( value ) => props.setAttributes( { borderWidth: value } ) }
							/>
							<ColorPalette
								value={ attributes.borderColor }
								onChange={ ( value ) => props.setAttributes( { borderColor: value } ) }
							/>
							<h4>{ __( 'Labels' ) }</h4>
							<p>{ __( 'Labels Color' ) }</p>
							<ColorPalette
								value={ attributes.labelsColor }
								onChange={ ( value ) => props.setAttributes( { labelsColor: value } ) }
							/>
							<p>{ __( 'Labels Background' ) }</p>
							<ColorPalette
								value={ attributes.labelsBg }
								onChange={ ( value ) => props.setAttributes( { labelsBg: value } ) }
							/>
							<RangeControl
								label={ __( 'Labels Opacity' ) }
								value={ attributes.labelsOpacity }
								min='0'
								max='100'
								onChange={ ( value ) => props.setAttributes( { labelsOpacity: value } ) }
							/>
						</PanelBody>
					</InspectorControls>
			),
			<div
				className={ props.className }
			>
				<div
					className="image-comparison juxtapose"
					style={ {
						border: attributes.borderWidth ? attributes.borderWidth + 'px solid ' + attributes.borderColor : false,
					} }
				>
					<div
						className="jx-slider"
						style={{
							height: attributes.imgHeight + 'px',
							width: '100%',
						}}
					>
						<div
							className="jx-handle transition"
							style={ {
								left: attributes.startPosition + '%'
							} }
						>
							<div
								className="jx-arrow jx-left"
								style={ {
									color: attributes.controlsColor,
								} }
							></div>
							<div
								className="jx-control"
								style={ {
									backgroundColor: attributes.controlsColor,
								} }
							>
								<div
									className="jx-controller"
									tabIndex="0"
									role="slider"
									aria-valuenow="50"
									aria-valuemin="0"
									aria-valuemax="100"
									style={ {
										backgroundColor: attributes.controlsColor,
									} }
								></div>
							</div>
							<div
								className="jx-arrow jx-right"
								style={ {
									color: attributes.controlsColor,
								} }
							></div>
						</div>
						<div
							className="jx-image jx-left transition"
							style={ {
								width: attributes.startPosition + '%'
							} }
						>
							<img
								src={ attributes.imageBeforeUrl }
								alt=""
							/>
							<div
								className="jx-label"
								tabIndex="0"
								style={ labelsStyle }
							>
								{ attributes.labelBefore }
							</div>
						</div>
						<div
							className="jx-image jx-right transition"
							style={ {
								width: ( 100 - attributes.startPosition ) + '%'
							} }
						>
							<img
								src={ attributes.imageAfterUrl }
								alt=""
							/>
							<div
								className="jx-label"
								tabIndex="0"
								style={ labelsStyle }
							>
								{ attributes.labelAfter }
							</div>
						</div>
					</div>
				</div>
			</div>
		];
	},
	save: props => {

		const {
			className,
			attributes
		} = props;

		let publicStyles = {
			controls: attributes.controlsColor,
			labels: {
				color: attributes.labelsColor,
				backgroundColor: attributes.labelsBg,
				opacity: ( attributes.labelsOpacity / 100 ),
			}
		}

		return (
			<div
				className={ className }
			>
				<div
					className="image-comparison juxtapose"
					style={ {
						border: attributes.borderWidth ? attributes.borderWidth + 'px solid ' + attributes.borderColor : false,
					} }
					data-styles={ JSON.stringify( publicStyles ) }
					data-startingposition={ attributes.startPosition + '%' }
					data-showlabels="true"
					data-showcredits="false"
					data-animate="true"
				>
					<img
						src={ attributes.imageBeforeUrl }
						data-label={ attributes.labelBefore }
					/>
					<img
						src={ attributes.imageAfterUrl }
						data-label={ attributes.labelBefore }
					/>
				</div>
			</div>
		);
	}
} );
