import JetIcon from "components/jet-icon";
import SVGInline from "components/inline-svg";
import getRawSvgByID from "utils/rawSVG";

const { __ } = wp.i18n;
const {
	registerBlockType
} = wp.blocks;
const {
	InspectorControls,
	ColorPalette,
	RichText,
	Editable,
	MediaUpload,
} = wp.editor;
const {
	PanelColor,
	IconButton,
	SelectControl,
	PanelBody,
	RangeControl,
	CheckboxControl,
} = wp.components;

registerBlockType( 'jet-guten/inline-svg', {
	title: __( 'Inline SVG' ),
	icon: <JetIcon icon="inline-svg" />,
	category: 'layout',
	attributes: {
		image: {
			type: 'string',
		},
		imageUrl: {
			type: 'string',
		},
		rawSvg: {
			type: 'string',
		},
		fillColor: {
			type: 'string',
		},
		imgWidth: {
			type: 'string',
		},
		imgHeight: {
			type: 'string',
		},
		keepOriginalColors: {
			type: 'boolean',
			default: true,
		}
	},
	edit: props => {

		const attributes = props.attributes;

		let cleanup = [];

		if ( ! attributes.keepOriginalColors ) {
			cleanup.push( 'fill' );
		}

		return [
			props.isSelected && (
					<InspectorControls
						key={ 'inspector' }
					>
						<PanelBody title={ __( 'General' ) }>
							{ attributes.imageUrl &&
								<img src={ attributes.imageUrl } width="100%" height="auto" />
							}
							<MediaUpload
								onSelect={ media => {
										getRawSvgByID( media.id, svg => {
											props.setAttributes( {
												rawSvg: svg.body,
												image: media.id,
												imageUrl: media.url,
											} );
										} );
									}
								}
								type="image"
								value={attributes.image}
								render={({ open }) => (
									<IconButton
										label={ __( "Edit image" ) }
										icon="edit"
										onClick={ open }
									>{ __("Select Image") }</IconButton>
								)}
							/>
						</PanelBody>
						<PanelBody title={ __( 'Style Settings' ) }>
							<RangeControl
								label={ __( 'Image Width (px)' ) }
								value={ attributes.imgWidth }
								min='1'
								max='600'
								onChange={ ( value ) => props.setAttributes( { imgWidth: value } ) }
							/>
							<RangeControl
								label={ __( 'Image Height (px)' ) }
								value={ attributes.imgHeight }
								min='1'
								max='600'
								onChange={ ( value ) => props.setAttributes( { imgHeight: value } ) }
							/>
							<CheckboxControl
								heading={ __( 'Colors' ) }
								label={ __( 'Keep original colors' ) }
								checked={ attributes.keepOriginalColors }
								onChange={ ( value ) => {
									props.setAttributes( { keepOriginalColors: value } )
								} }
							/>
							{ ! attributes.keepOriginalColors &&
								<div>
									<p>{ __( 'Fill Color' ) }</p>
									<ColorPalette
										value={ attributes.fillColor }
										onChange={ ( value ) => props.setAttributes( { fillColor: value } ) }
									/>
								</div>
							}
						</PanelBody>
					</InspectorControls>
			),
			<div
				className={ props.className }
				data-img={ attributes.image }
			>
				{ attributes.rawSvg &&
					<SVGInline
						svg={ attributes.rawSvg }
						cleanup={cleanup}
						fill={ attributes.fillColor }
						width={ attributes.imgWidth }
						height={ attributes.imgHeight }
					/>
				}
				{ ! attributes.rawSvg &&
					<div className="svg-not-selected">{ __( 'Pease select a SVG image in control panel' ) }</div>
				}
			</div>
		];
	},
	save: props => {

		const {
			attributes
		} = props;

		let cleanup = [];

		if ( ! attributes.keepOriginalColors ) {
			cleanup.push( 'fill' );
		}

		return (
			<div
				className={ props.className }
				data-img={ attributes.image }
			>
				{ attributes.rawSvg &&
					<SVGInline
						svg={ attributes.rawSvg }
						cleanup={cleanup}
						fill={ attributes.fillColor }
						width={ attributes.imgWidth }
						height={ attributes.imgHeight }
					/>
				}
				{ ! attributes.rawSvg &&
					<div className="svg-not-selected">{ __( 'Pease select a SVG image in control panel' ) }</div>
				}
			</div>
		);
	}
} );
