import JetIcon from "components/jet-icon";

const className = 'jet-guten-map';

const {
	registerBlockType,
} = wp.blocks;

const {
	__
} = wp.i18n;

const {
	PanelBody,
	TextControl,
	RangeControl,
	SelectControl
} = wp.components;

const {
	InspectorControls,
} = wp.editor;

const MAPTYPES = [
	{
		value: "map",
		label: __("Map")
	},
	{
		value: "satellite",
		label: __("Satellite")
	}
];

registerBlockType("jet-guten/map", {
	title: __("Map"),
	icon: <JetIcon icon="map" />,
	category: "layout",
	attributes: {
		address: {
			type: "string",
			default: "Big Ban, London, United Kingdom",
		},
		type: {
			type: "string",
			default: 'map',
		},
		zoom: {
			type: "number",
			default: 12,
		},
		height: {
			type: "number",
			default: 250,
		}
	},
	edit: props => {
		const { setAttributes, isSelected } = props;
		const {
			address,
			type,
			zoom,
			height,
		} = props.attributes;

		const mapType = type === 'satellite' ? 'k':'';
		const srcUrl = 'https://maps.google.com/maps?q=' + encodeURIComponent(address) + '&t=' + mapType + '&z=' + zoom + '&iwloc=&output=embed';

		return [
			isSelected && (
				<InspectorControls key={"inspector"}>
					<PanelBody
						title={__("General Settings")}
					>
						<TextControl
							type="text"
							label={__("Address")}
							value={address}
							onChange={newAddress =>
								setAttributes({
									address: newAddress
								})
							}
						/>
						<SelectControl
							value={type}
							options={MAPTYPES.map(({ value, label }) => ({
								value: value,
								label: label
							}))}
							onChange={newType => {
								setAttributes({ type: newType });
							}}
						/>
						<TextControl
							type="number"
							label={__("Zoom Level")}
							value={zoom}
							onChange={newZoom =>
								setAttributes({
									zoom: newZoom
								})
							}
						/>
						<RangeControl
								label={__("Height")}
								value={height}
								onChange={newHeight => {
									setAttributes({
										height: newHeight
									})
								} }
								min={100}
								max={1000}
								step={1}
							/>
					</PanelBody>
				</InspectorControls>
			),
			<div class={className}>
				<iframe height={height} src={srcUrl} frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>
				<div className={`${className}__overlay`}></div>
			</div>
		];
	},
	save: props => {
		const {
			attributes: {
				address,
				type,
				zoom,
				height,
			}
		} = props;

		const mapType = type === 'satellite' ? 'k':'';
		const srcUrl = 'https://maps.google.com/maps?q=' + encodeURIComponent(address) + '&t=' + mapType + '&z=' + zoom + '&iwloc=&output=embed';

		return (
			<div class={className}>
				<iframe height={height} src={srcUrl} frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>
				<div className={`${className}__overlay`}></div>
			</div>
		);
	}
});