import JetIcon from "components/jet-icon";

const { __ } = wp.i18n;
const {
	registerBlockType
} = wp.blocks;
const {
	InspectorControls,
	ColorPalette,
	RichText,
	Editable,
	MediaUpload,
	URLInput
} = wp.editor;
const {
	Button,
	Dashicon,
	IconButton,
	PanelColor,
	SelectControl,
	PanelBody,
	RangeControl,
	CheckboxControl,
	TextControl,
	FontSizePicker,
} = wp.components;

const FONT_SIZES = [{
		name: 'small',
		shortName: 'S',
		size: 14,
	},
	{
		name: 'regular',
		shortName: 'M',
		size: 16,
	},
	{
		name: 'large',
		shortName: 'L',
		size: 36,
	},
	{
		name: 'larger',
		shortName: 'XL',
		size: 48,
	},
];

const ALIGNMENTS = [
	{
		value: 'flex-start',
		label: __( 'Top' ),
	},
	{
		value: 'center',
		label: __( 'Middle' ),
	},
	{
		value: 'flex-end',
		label: __( 'Bottom' ),
	},
];

registerBlockType( 'jet-guten/pricing-table', {
	title: __( 'Pricing Table' ),
	icon: <JetIcon icon="pricing-table" />,
	category: 'layout',
	attributes: {
		title: {
			type: 'array',
			source: 'children',
			selector: '.pricing-table__title',
			default: __( 'Main Title' )
		},
		subTitle: {
			type: 'array',
			source: 'children',
			selector: '.pricing-table__subtitle',
			default: __( 'Subitle' )
		},
		prefix: {
			type: 'array',
			source: 'children',
			selector: '.pricing-table__price-prefix',
			default: __( '$' )
		},
		price: {
			type: 'array',
			source: 'children',
			selector: '.pricing-table__price-val',
			default: __( '99' )
		},
		suffix: {
			type: 'array',
			source: 'children',
			selector: '.pricing-table__price-suffix',
			default: __( '/per month' )
		},
		features: {
			type: 'array',
			source: 'children',
			selector: 'ul.pricing-table__features',
		},
		btnText: {
			type: 'array',
			source: 'children',
			selector: '.pricing-table__btn-inner',
			default: __( 'Add to cart' )
		},
		btnUrl: {
			type: 'string',
			source: 'attribute',
			attribute: 'href',
			selector: '.pricing-table__btn',
		},
		priceStyle: {
			type: 'string',
			source: 'attribute',
			attribute: 'data-style',
			selector: 'div[data-style]',
			default: 'style-1'
		},
		titleColor: {
			type: 'string',
		},
		subtitleColor: {
			type: 'string',
		},
		headingGapBefore: {
			type: 'string',
		},
		headingGapAfter: {
			type: 'string',
		},
		headingBg: {
			type: 'string',
		},
		pricePrefixColor: {
			type: 'string',
		},
		prefixFontSize: {
			type: 'string',
		},
		prefixAlignment: {
			type: 'string',
			default: 'center',
		},
		priceColor: {
			type: 'string',
		},
		priceFontSize: {
			type: 'string',
		},
		priceAlignment: {
			type: 'string',
			default: 'center',
		},
		priceSuffixColor: {
			type: 'string',
		},
		suffixFontSize: {
			type: 'string',
		},
		suffixAlignment: {
			type: 'string',
			default: 'center',
		},
		priceGapBefore: {
			type: 'string',
		},
		priceGapAfter: {
			type: 'string',
		},
		priceBg: {
			type: 'string',
		},
		isFeatured: {
			type: 'boolean',
			default: false,
		},
		featuredLabel: {
			type: 'string',
			default: __( 'Featured' ),
		},
		featuredBgColor: {
			type: 'string',
		},
		featuredColor: {
			type: 'string',
		},
		labelStyle: {
			type: 'string',
			default: 'diagonal',
		},
		tableBg: {
			type: 'string',
		},
		tableColor: {
			type: 'string',
		},
		buttonColor: {
			type: 'string',
		},
		buttonBg: {
			type: 'string',
		},
		bordersColor: {
			type: 'string',
		},
	},
	edit: props => {

		const focusedEditable = props.focus ? props.focus.editable || 'title' : null;
		const attributes = props.attributes;
		const styles = [
			{
				value: 'style-1',
				label: __( 'Style 1' ),
			},
			{
				value: 'style-2',
				label: __( 'Style 2' ),
			},
			{
				value: 'style-3',
				label: __( 'Style 3' ),
			},
		]

		const onChangeTitle = value => {
			props.setAttributes( { title: value } );
		};

		const onChangeSubTitle = value => {
			props.setAttributes( { subTitle: value } );
		};

		const onChangePrefix = value => {
			props.setAttributes( { prefix: value } );
		};

		const onChangePrice = value => {
			props.setAttributes( { price: value } );
		};

		const onChangeSuffix = value => {
			props.setAttributes( { suffix: value } );
		};

		const onChangeFeatures = value => {
			props.setAttributes( { features: value } );
		};

		const onChangeBtnText = value => {
			props.setAttributes( { btnText: value } );
		};

		const onChangeBtnUrl = value => {
			props.setAttributes( { btnUrl: value } );
		};

		const onChangeStyle = value => {
			props.setAttributes( { priceStyle: value } );
		};

		return [
			props.isSelected && (
					<InspectorControls
						key={ 'inspector' }
					>
						<PanelBody title={ __( 'Settings' ) }>
							<SelectControl
								label={ __( 'Style' ) }
								value={ attributes.priceStyle }
								options={ styles }
								onChange={ onChangeStyle }
							/>
							<CheckboxControl
								heading={ __( 'Featured Label' ) }
								label={ __( 'Is featured' ) }
								checked={ attributes.isFeatured }
								onChange={ ( value ) => {
									props.setAttributes( { isFeatured: value } )
								} }
							/>
							{ attributes.isFeatured &&
								<div>
									<TextControl
										label={ __( 'Label text' ) }
										value={ attributes.featuredLabel }
										onChange={ ( value ) => props.setAttributes( { featuredLabel: value } ) }
									/>
									<SelectControl
										label={ __( 'Label Style' ) }
										value={ attributes.labelStyle }
										options={ [
											{
												value: 'diagonal',
												label: __( 'Diagonal Ribbon' ),
											},
											{
												value: 'vertical',
												label: __( 'Vertical Ribbon' ),
											}
										] }
										onChange={ ( value ) => props.setAttributes( { labelStyle: value } ) }
									/>
									<p>{ __( 'Label background' ) }</p>
									<ColorPalette
										value={ attributes.featuredBgColor }
										onChange={ ( value ) => props.setAttributes( { featuredBgColor: value } ) }
									/>
									<p>{ __( 'Label color' ) }</p>
									<ColorPalette
										value={ attributes.featuredColor }
										onChange={ ( value ) => props.setAttributes( { featuredColor: value } ) }
									/>
								</div>
							}
						</PanelBody>
						<PanelBody title={ __( 'General' ) } initialOpen={ false }>
							<p>{ __( 'Table Text Color' ) }</p>
							<ColorPalette
								value={ attributes.tableColor }
								onChange={ ( value ) => props.setAttributes( { tableColor: value } ) }
							/>
							<p>{ __( 'Table Background' ) }</p>
							<ColorPalette
								value={ attributes.tableBg }
								onChange={ ( value ) => props.setAttributes( { tableBg: value } ) }
							/>
							<p>{ __( 'Button Text Color' ) }</p>
							<ColorPalette
								value={ attributes.buttonColor }
								onChange={ ( value ) => props.setAttributes( { buttonColor: value } ) }
							/>
							<p>{ __( 'Button Background' ) }</p>
							<ColorPalette
								value={ attributes.buttonBg }
								onChange={ ( value ) => props.setAttributes( { buttonBg: value } ) }
							/>
							<p>{ __( 'Borders Color' ) }</p>
							<ColorPalette
								value={ attributes.bordersColor }
								onChange={ ( value ) => props.setAttributes( { bordersColor: value } ) }
							/>
						</PanelBody>
						<PanelBody title={ __( 'Heading' ) } initialOpen={ false }>
							<RangeControl
								label={ __( 'Gap Before Content' ) }
								value={ attributes.headingGapBefore }
								min='0'
								max='100'
								onChange={ ( value ) => props.setAttributes( { headingGapBefore: value } ) }
							/>
							<RangeControl
								label={ __( 'Gap After Content' ) }
								value={ attributes.headingGapAfter }
								min='0'
								max='100'
								onChange={ ( value ) => props.setAttributes( { headingGapAfter: value } ) }
							/>
							<p>{ __( 'Title Color' ) }</p>
							<ColorPalette
								value={ attributes.titleColor }
								onChange={ ( value ) => props.setAttributes( { titleColor: value } ) }
							/>
							<p>{ __( 'Subtitle Color' ) }</p>
							<ColorPalette
								value={ attributes.subtitleColor }
								onChange={ ( value ) => props.setAttributes( { subtitleColor: value } ) }
							/>
							<p>{ __( 'Heading Background' ) }</p>
							<ColorPalette
								value={ attributes.headingBg }
								onChange={ ( value ) => props.setAttributes( { headingBg: value } ) }
							/>
						</PanelBody>

						<PanelBody title={ __( 'Price' ) } initialOpen={ false }>
							<RangeControl
								label={ __( 'Gap Before Content' ) }
								value={ attributes.priceGapBefore }
								min='0'
								max='100'
								onChange={ ( value ) => props.setAttributes( { priceGapBefore: value } ) }
							/>
							<RangeControl
								label={ __( 'Gap After Content' ) }
								value={ attributes.priceGapAfter }
								min='0'
								max='100'
								onChange={ ( value ) => props.setAttributes( { priceGapAfter: value } ) }
							/>
							<h4>{ __( 'Price Prefix' ) }</h4>
							<TextControl
								label={ __( 'Prefix' ) }
								value={ attributes.prefix }
								onChange={ ( value ) => props.setAttributes( { prefix: value } ) }
							/>
							<p>{ __( 'Prefix Color' ) }</p>
							<ColorPalette
								value={ attributes.pricePrefixColor }
								onChange={ ( value ) => props.setAttributes( { pricePrefixColor: value } ) }
							/>
							<p>{ __( 'Prefix Size' ) }</p>
							<FontSizePicker
								fontSizes={ FONT_SIZES }
								value={ attributes.prefixFontSize }
								onChange={ fontSizeValue =>
									props.setAttributes({ prefixFontSize: fontSizeValue })
								}
							/>
							<SelectControl
								label={ __( 'Prefix Alignment' ) }
								value={ attributes.prefixAlignment }
								options={ ALIGNMENTS }
								onChange={ ( value ) => props.setAttributes( { prefixAlignment: value } ) }
							/>
							<h4>{ __( 'Price Value' ) }</h4>
							<TextControl
								label={ __( 'Price' ) }
								value={ attributes.price }
								onChange={ ( value ) => props.setAttributes( { price: value } ) }
							/>
							<p>{ __( 'Price Color' ) }</p>
							<ColorPalette
								value={ attributes.priceColor }
								onChange={ ( value ) => props.setAttributes( { priceColor: value } ) }
							/>
							<p>{ __( 'Price Size' ) }</p>
							<FontSizePicker
								fontSizes={ FONT_SIZES }
								value={ attributes.priceFontSize }
								onChange={ fontSizeValue =>
									props.setAttributes({ priceFontSize: fontSizeValue })
								}
							/>
							<SelectControl
								label={ __( 'Price Alignment' ) }
								value={ attributes.priceAlignment }
								options={ ALIGNMENTS }
								onChange={ ( value ) => props.setAttributes( { priceAlignment: value } ) }
							/>
							<h4>{ __( 'Price Suffix' ) }</h4>
							<TextControl
								label={ __( 'Suffix' ) }
								value={ attributes.suffix }
								onChange={ ( value ) => props.setAttributes( { suffix: value } ) }
							/>
							<p>{ __( 'Suffix Color' ) }</p>
							<ColorPalette
								value={ attributes.priceSuffixColor }
								onChange={ ( value ) => props.setAttributes( { priceSuffixColor: value } ) }
							/>
							<p>{ __( 'Suffix Size' ) }</p>
							<FontSizePicker
								fontSizes={ FONT_SIZES }
								value={ attributes.suffixFontSize }
								onChange={ fontSizeValue =>
									props.setAttributes({ suffixFontSize: fontSizeValue })
								}
							/>
							<SelectControl
								label={ __( 'Suffix Alignment' ) }
								value={ attributes.suffixAlignment }
								options={ ALIGNMENTS }
								onChange={ ( value ) => props.setAttributes( { suffixAlignment: value } ) }
							/>
							<hr />
							<p>{ __( 'Price Background' ) }</p>
							<ColorPalette
								value={ attributes.priceBg }
								onChange={ ( value ) => props.setAttributes( { priceBg: value } ) }
							/>
						</PanelBody>

					</InspectorControls>
			),
			<div className={ props.className } data-style={ attributes.priceStyle }>
				<div
					className={ [ 'pricing-table', 'pricing-' + attributes.priceStyle ].join(' ') }
					style={ {
						backgroundColor: attributes.tableBg ? attributes.tableBg : false,
						color: attributes.tableColor ? attributes.tableColor : false,
						borderColor: attributes.bordersColor ? attributes.bordersColor : false,
					} }
				>
					<div
						className="pricing-table__heading"
						style={ {
							paddingTop: attributes.headingGapBefore + 'px',
							paddingBottom: attributes.headingGapAfter + 'px',
							backgroundColor: attributes.headingBg
						} }
					>
						{ attributes.isFeatured &&
							<span
								className={
									[ "pricing-table__featured-label", 'label-' + attributes.labelStyle ].join( " " )
								}
								style={ {
									background: attributes.featuredBgColor,
									color: attributes.featuredColor
								} }
							>
								{ attributes.featuredLabel }
								<span
									className="pricing-table__featured-label-corner"
									style={ {
										color: attributes.featuredBgColor,
									} }
								></span>
							</span>
						}
						<RichText
							className="pricing-table__title"
							tagName="h3"
							placeholder={ __( 'Write title…' ) }
							value={ attributes.title }
							onChange={ onChangeTitle }
							focus={ focusedEditable === 'title' }
							style={ {
								color: attributes.titleColor
							} }
						/>
						<RichText
							className="pricing-table__subtitle"
							tagName="div"
							placeholder={ __( 'Write subtitle…' ) }
							value={ attributes.subTitle }
							onChange={ onChangeSubTitle }
							focus={ focusedEditable === 'subTitle' }
							style={ {
								color: attributes.subtitleColor
							} }
						/>
					</div>
					<div className="pricing-table__price" style={ {
						paddingTop: attributes.priceGapBefore + 'px',
						paddingBottom: attributes.priceGapAfter + 'px',
						backgroundColor: attributes.priceBg
					} }>
						<span
							className="pricing-table__price-prefix"
							style={ {
								color: attributes.pricePrefixColor,
								fontSize: attributes.prefixFontSize ? attributes.prefixFontSize + 'px' : false,
								alignSelf: attributes.prefixAlignment,
							} }
						>
							{ attributes.prefix }
						</span>
						<span
							className="pricing-table__price-val"
							style={ {
								color: attributes.priceColor,
								fontSize: attributes.priceFontSize ? attributes.priceFontSize + 'px' : false,
								alignSelf: attributes.priceAlignment,
							} }
						>
							{ attributes.price }
						</span>
						<span
							className="pricing-table__price-suffix"
							style={ {
								color: attributes.priceSuffixColor,
								fontSize: attributes.suffixFontSize ? attributes.suffixFontSize + 'px' : false,
								alignSelf: attributes.suffixAlignment,
							} }
						>
							{ attributes.suffix }
						</span>
					</div>
					<RichText
						tagName="ul"
						className="pricing-table__features"
						multiline="li"
						placeholder={ __( 'Write a list of features…' ) }
						value={ attributes.features }
						onChange={ onChangeFeatures }
						focus={ focusedEditable === 'features' }
						style={ {
							borderColor: attributes.bordersColor ? attributes.bordersColor : false,
						} }
					/>
					<div className="pricing-table__actions">
						<a
							className="pricing-table__btn"
							href="{ attributes.btnUrl }"
							style={ {
								backgroundColor: attributes.buttonBg,
							} }
						>
							<RichText
								tagName="span"
								className="pricing-table__btn-inner"
								placeholder={ __( 'Button text…' ) }
								value={ attributes.btnText }
								onChange={ onChangeBtnText }
								focus={ focusedEditable === 'btnText' }
								style={ {
									color: attributes.buttonColor,
								} }
							/>
						</a>
						{ props.isSelected && (
							<URLInput
								value={ attributes.btnUrl }
								onChange={ onChangeBtnUrl }
							/>
						) }
					</div>
				</div>
			</div>
		];
	},
	save: props => {
		const {
			className,
			attributes: {
				title,
				titleColor,
				subTitle,
				subtitleColor,
				headingBg,
				headingGapBefore,
				headingGapAfter,
				prefix,
				prefixFontSize,
				prefixAlignment,
				pricePrefixColor,
				price,
				priceColor,
				priceAlignment,
				priceFontSize,
				suffix,
				suffixFontSize,
				suffixAlignment,
				priceSuffixColor,
				priceBg,
				priceGapBefore,
				priceGapAfter,
				features,
				btnText,
				btnUrl,
				priceStyle,
				featuredBgColor,
				featuredColor,
				featuredLabel,
				isFeatured,
				labelStyle,
				tableBg,
				tableColor,
				buttonColor,
				buttonBg,
				bordersColor,
			}
		} = props;
		return (
			<div className={ className } data-style={ priceStyle }>
				<div
					className={ [ 'pricing-table', 'pricing-' + priceStyle ].join(' ') }
					style={ {
						backgroundColor: tableBg ? tableBg : false,
						color: tableColor ? tableColor : false,
						borderColor: bordersColor ? bordersColor : false,
					} }
				>
					<div className="pricing-table__heading" style={ {
						paddingTop: headingGapBefore + 'px',
						paddingBottom: headingGapAfter + 'px',
						backgroundColor: headingBg
					} }>
						{ isFeatured &&
							<span
								className={
									[ "pricing-table__featured-label", 'label-' + labelStyle ].join( " " )
								}
								style={ {
									background: featuredBgColor,
									color: featuredColor
								} }
							>
								{ featuredLabel }
								<span
									className="pricing-table__featured-label-corner"
									style={ {
										color: featuredBgColor,
									} }
								></span>
							</span>
						}
						<h3 className="pricing-table__title" style={ {
								color: titleColor
							} } >
							{ title }
						</h3>
						<div className="pricing-table__subtitle" style={ {
								color: subtitleColor
							} }>
							{ subTitle }
						</div>
					</div>
					<div className="pricing-table__price" style={ {
						paddingTop: priceGapBefore + 'px',
						paddingBottom: priceGapAfter + 'px',
						backgroundColor: priceBg
					} }>
						<span className="pricing-table__price-prefix" style={ {
								color: pricePrefixColor,
								fontSize: prefixFontSize ? prefixFontSize + 'px' : false,
								alignSelf: prefixAlignment,
							} } >
							{ prefix }
						</span>
						<span className="pricing-table__price-val" style={ {
								color: priceColor,
								fontSize: priceFontSize ? priceFontSize + 'px' : false,
								alignSelf: priceAlignment,
							} } >
							{ price }
						</span>
						<span className="pricing-table__price-suffix" style={ {
								color: priceSuffixColor,
								fontSize: suffixFontSize ? suffixFontSize + 'px' : false,
								alignSelf: suffixAlignment,
							} } >
							{ suffix }
						</span>
					</div>
					<ul
						className="pricing-table__features"
						style={ {
							borderColor: bordersColor ? bordersColor : false,
						} }
					>
						{ features }
					</ul>
					<div className="pricing-table__actions">
						<a
							className="pricing-table__btn"
							href={ btnUrl }
							style={ {
								backgroundColor: buttonBg,
							} }
						>
							<span
								className="pricing-table__btn-inner"
								style={ { color: buttonColor } }
							>
								{ btnText }
							</span>
						</a>
					</div>
				</div>
			</div>
		);
	}
} );
