import JetIcon from "components/jet-icon";

const { __ } = wp.i18n;
const {
	registerBlockType
} = wp.blocks;
const {
	InspectorControls,
	ColorPalette,
	RichText,
	Editable
} = wp.editor;
const {
	PanelColor,
	SelectControl,
	PanelBody,
	RangeControl,
	FontSizePicker,
} = wp.components;

const FONT_SIZES = [{
		name: 'small',
		shortName: 'S',
		size: 14,
	},
	{
		name: 'regular',
		shortName: 'M',
		size: 16,
	},
	{
		name: 'large',
		shortName: 'L',
		size: 36,
	},
	{
		name: 'larger',
		shortName: 'XL',
		size: 48,
	},
];

registerBlockType( 'jet-guten/progress-bar', {
	title: __( 'Progress Bar' ),
	icon: <JetIcon icon="progress-bar" />,
	category: 'layout',
	attributes: {
		title: {
			type: 'array',
			source: 'children',
			selector: '.progress-bar__title',
			default: __( 'Title' )
		},
		progressValue: {
			type: 'string',
			source: 'attribute',
			attribute: 'data-value',
			selector: 'div[data-value]',
			default: 50
		},
		progressLayout: {
			type: 'string',
			source: 'attribute',
			attribute: 'data-layout',
			selector: 'div[data-layout]',
			default: 'layout-1'
		},
		titleColor: {
			type: 'string',
		},
		titleFontSize: {
			type: 'number',
		},
		valueColor: {
			type: 'string',
		},
		valueFontSize: {
			type: 'number',
		},
		progressColor: {
			type: 'string',
		},
		barColor: {
			type: 'string',
		},
		barWidth: {
			type: 'number',
		},
		barHeight: {
			type: 'number',
			default: 30,
		},
	},
	edit: props => {

		const focusedEditable = props.focus ? props.focus.editable || 'title' : null;
		const attributes = props.attributes;
		const currentLayout = attributes.progressLayout;
		const layouts = [
			{
				value: 'layout-1',
				label: 'Layout 1',
			},
			{
				value: 'layout-2',
				label: 'Layout 2',
			},
			{
				value: 'layout-3',
				label: 'Layout 3',
			},
			{
				value: 'layout-4',
				label: 'Layout 4',
			},
			{
				value: 'layout-5',
				label: 'Layout 5',
			},
			{
				value: 'layout-6',
				label: 'Layout 6',
			},
		];

		let statusBarStyles;
		let wrapperStyles;
		let titleStyles;
		let valueStyles;

		if ( 'layout-6' === currentLayout ) {
			statusBarStyles = {
				height: attributes.progressValue + '%',
				background: attributes.progressColor,
			}
		} else {
			statusBarStyles = {
				width: attributes.progressValue + '%',
				background: attributes.progressColor,
			}
		}

		wrapperStyles = {
			height: attributes.barHeight + 'px',
			background: attributes.barColor,
		}

		if ( 'layout-6' === currentLayout ) {
			wrapperStyles.width = attributes.barWidth + 'px';
		}

		titleStyles = {
			color: attributes.titleColor,
		}

		if ( attributes.titleFontSize ) {
			titleStyles.fontSize = attributes.titleFontSize + 'px';
		}

		valueStyles = {
			color: attributes.valueColor,
		}

		if ( attributes.valueFontSize ) {
			valueStyles.fontSize = attributes.valueFontSize + 'px';
		}

		return [
			props.isSelected && (
					<InspectorControls
						key={ 'inspector' }
					>
						<PanelBody title={ __( 'General Settings' ) }>
							<RangeControl
								label={ __( 'Progress Value (%)' ) }
								value={ attributes.progressValue }
								min='1'
								max='100'
								onChange={ ( value ) => props.setAttributes( { progressValue: value } ) }
							/>
							<SelectControl
								label={ __( 'Style' ) }
								value={ attributes.progressLayout }
								options={ layouts }
								onChange={ ( value ) => props.setAttributes( { progressLayout: value } ) }
							/>
						</PanelBody>
						<PanelBody title={ __( 'Sizing Settings' ) }>
								<RangeControl
									label={ __( 'Progress Bar Height (px)' ) }
									value={ attributes.barHeight }
									min='1'
									max='600'
									onChange={ ( value ) => props.setAttributes( { barHeight: value } ) }
								/>
								{ 'layout-6' === currentLayout &&
									<RangeControl
										label={ __( 'Progress Bar Width (px)' ) }
										value={ attributes.barWidth }
										min='10'
										max='300'
										onChange={ ( value ) => props.setAttributes( { barWidth: value } ) }
									/>
								}
						</PanelBody>
						<PanelBody title={ __( 'Style Settings' ) } initialOpen={ false }>
							<h4>{ __( 'Title' ) }</h4>
							<p>{ __( 'Size' ) }</p>
							<FontSizePicker
								fontSizes={ FONT_SIZES }
								value={ attributes.titleFontSize }
								onChange={ fontSizeValue =>
									props.setAttributes({ titleFontSize: fontSizeValue })
								}
							/>
							<p>{ __( 'Color' ) }</p>
							<ColorPalette
								value={ attributes.titleColor }
								onChange={ ( value ) => props.setAttributes( { titleColor: value } ) }
							/>
							<hr/>
							<h4>{ __( 'Value' ) }</h4>
							<FontSizePicker
								fontSizes={ FONT_SIZES }
								value={ attributes.valueFontSize }
								onChange={ fontSizeValue =>
									props.setAttributes({ valueFontSize: fontSizeValue })
								}
							/>
							<p>{ __( 'Color' ) }</p>
							<ColorPalette
								value={ attributes.valueColor }
								onChange={ ( value ) => props.setAttributes( { valueColor: value } ) }
							/>
							<hr/>
							<h4>{ __( 'Progress Bar' ) }</h4>
							<p>{ __( 'Progress Status Color' ) }</p>
							<ColorPalette
								value={ attributes.progressColor }
								onChange={ ( value ) => props.setAttributes( { progressColor: value } ) }
							/>
							<p>{ __( 'Progress Bar Color' ) }</p>
							<ColorPalette
								value={ attributes.barColor }
								onChange={ ( value ) => props.setAttributes( { barColor: value } ) }
							/>

						</PanelBody>
					</InspectorControls>
			),
			<div
				className={ props.className }
				data-value={ attributes.progressValue }
				data-layout={ attributes.progressLayout }
			>
				<div className={ [ 'progress-bar', 'progress-bar--' + attributes.progressLayout ].join(' ') }>
					<div className="progress-bar__inner">

						{ ( 'layout-1' === currentLayout || 'layout-3' === currentLayout || 'layout-4' === currentLayout ) &&
							<div className="progress-bar__title" style={ titleStyles }>
								<RichText
									placeholder={ __( 'Write title…' ) }
									value={ attributes.title }
									onChange={ ( value ) => props.setAttributes( { title: value } ) }
									focus={ focusedEditable === 'title' }
								/>
							</div>
						}

						{ 'layout-2' === currentLayout &&
							<div className="progress-bar__percent" style={ valueStyles }>
								<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
								<span className="progress-bar__percent-suffix">&#37;</span>
							</div>
						}

						<div className="progress-bar__wrapper" style={ wrapperStyles }>
							{ 'layout-6' === currentLayout &&
								<div className="progress-bar__percent" style={ valueStyles }>
									<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
									<span className="progress-bar__percent-suffix">&#37;</span>
								</div>
							}
							<div
								className="progress-bar__status-bar"
								style={ statusBarStyles }
							>
								{ 'layout-1' === currentLayout &&
									<div className="progress-bar__percent" style={ valueStyles }>
										<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
										<span className="progress-bar__percent-suffix">&#37;</span>
									</div>
								}
							</div>
							{ 'layout-4' === currentLayout &&
								<div className="progress-bar__percent" style={ valueStyles }>
									<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
									<span className="progress-bar__percent-suffix">&#37;</span>
								</div>
							}
							{ 'layout-5' === currentLayout &&
								<div className="jet-progress-bar__status">
									<div className="progress-bar__title" style={ titleStyles }>
										<RichText
											placeholder={ __( 'Write title…' ) }
											value={ attributes.title }
											onChange={ ( value ) => props.setAttributes( { title: value } ) }
											focus={ focusedEditable === 'title' }
										/>
									</div>
									<div className="progress-bar__percent" style={ valueStyles }>
										<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
										<span className="progress-bar__percent-suffix">&#37;</span>
									</div>
								</div>
							}
						</div>

						{ ( 'layout-2' === currentLayout || 'layout-6' === currentLayout ) &&
							<div className="progress-bar__title" style={ titleStyles }>
								<RichText
									placeholder={ __( 'Write title…' ) }
									value={ attributes.title }
									onChange={ ( value ) => props.setAttributes( { title: value } ) }
									focus={ focusedEditable === 'title' }
								/>
							</div>
						}

						{ 'layout-3' === currentLayout &&
							<div className="progress-bar__percent" style={ valueStyles }>
								<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
								<span className="progress-bar__percent-suffix">&#37;</span>
							</div>
						}

					</div>
				</div>
			</div>
		];
	},
	save: props => {

		const {
			className,
			attributes
		} = props;
		const currentLayout = attributes.progressLayout;

		let statusBarStyles;
		let wrapperStyles;
		let titleStyles;
		let valueStyles;

		if ( 'layout-6' === currentLayout ) {
			statusBarStyles = {
				height: attributes.progressValue + '%',
				background: attributes.progressColor,
			}
		} else {
			statusBarStyles = {
				width: attributes.progressValue + '%',
				background: attributes.progressColor,
			}
		}

		wrapperStyles = {
			height: attributes.barHeight + 'px',
			background: attributes.barColor,
		}

		if ( 'layout-6' === currentLayout ) {
			wrapperStyles.width = attributes.barWidth + 'px';
		}

		titleStyles = {
			color: attributes.titleColor,
		}

		if ( attributes.titleFontSize ) {
			titleStyles.fontSize = attributes.titleFontSize + 'px';
		}

		valueStyles = {
			color: attributes.valueColor,
		}

		if ( attributes.valueFontSize ) {
			valueStyles.fontSize = attributes.valueFontSize + 'px';
		}

		return (
			<div
				className={ props.className }
				data-value={ attributes.progressValue }
				data-layout={ attributes.progressLayout }
			>
				<div className={ [ 'progress-bar', 'progress-bar--' + attributes.progressLayout ].join(' ') }>
					<div className="progress-bar__inner">

						{ ( 'layout-1' === currentLayout || 'layout-3' === currentLayout || 'layout-4' === currentLayout ) &&
							<div className="progress-bar__title" style={ titleStyles }>
								{ attributes.title }
							</div>
						}

						{ 'layout-2' === currentLayout &&
							<div className="progress-bar__percent" style={ valueStyles }>
								<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
								<span className="progress-bar__percent-suffix">&#37;</span>
							</div>
						}

						<div className="progress-bar__wrapper" style={ wrapperStyles }>
							{ 'layout-6' === currentLayout &&
								<div className="progress-bar__percent" style={ valueStyles }>
									<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
									<span className="progress-bar__percent-suffix">&#37;</span>
								</div>
							}
							<div
								className="progress-bar__status-bar"
								style={ statusBarStyles }
							>
								{ 'layout-1' === currentLayout &&
									<div className="progress-bar__percent" style={ valueStyles }>
										<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
										<span className="progress-bar__percent-suffix">&#37;</span>
									</div>
								}
							</div>
							{ 'layout-4' === currentLayout &&
								<div className="progress-bar__percent" style={ valueStyles }>
									<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
									<span className="progress-bar__percent-suffix">&#37;</span>
								</div>
							}
							{ 'layout-5' === currentLayout &&
								<div className="jet-progress-bar__status">
									<div className="progress-bar__title" style={ titleStyles }>
										{ attributes.title }
									</div>
									<div className="progress-bar__percent" style={ valueStyles }>
										<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
										<span className="progress-bar__percent-suffix">&#37;</span>
									</div>
								</div>
							}
						</div>

						{ ( 'layout-2' === currentLayout || 'layout-6' === currentLayout ) &&
							<div className="progress-bar__title" style={ titleStyles }>
								{ attributes.title }
							</div>
						}

						{ 'layout-3' === currentLayout &&
							<div className="progress-bar__percent" style={ valueStyles }>
								<span className="progress-bar__percent-value">{ attributes.progressValue }</span>
								<span className="progress-bar__percent-suffix">&#37;</span>
							</div>
						}

					</div>
				</div>
			</div>
		);
	}
} );
