export default class CountdownTimer extends wp.element.Component {
	constructor(){
		super();
		
		this.state = {
			timeRemaining: {
				days: 0,
				hours: 0,
				minutes: 0,
				seconds: 0,
				countdownOver: true
			},
		};
		this.timeout = null;
	}

	getTimeRemaining(endTime) {
		let timeRemaining = new Date(endTime) - new Date(),
			seconds = Math.floor( ( timeRemaining / 1000 ) % 60 ),
			minutes = Math.floor( ( timeRemaining / 1000 / 60 ) % 60 ),
			hours = Math.floor( ( timeRemaining / ( 1000 * 60 * 60 ) ) % 24 ),
			days = Math.floor( timeRemaining / ( 1000 * 60 * 60 * 24 ) ),
			countdownOver = false;

		if ( days < 0 || hours < 0 || minutes < 0 ) {
			countdownOver = true;
		}

		return {
			days,
			hours,
			minutes,
			seconds,
			countdownOver
		};
	}

	updateClock(endDate) {
		clearTimeout( this.timeout );
		this.timeout = setTimeout( () => {
			let timeRemaining = this.getTimeRemaining(endDate);
			this.setState( {
				timeRemaining: timeRemaining,
			} );
		}, 1000 );
	}

	render() {
		const { endDate } = this.props;

		this.updateClock(endDate);

		return (
			<div>
				<div>{this.state.timeRemaining.days}</div>
				<div>{this.state.timeRemaining.hours}</div>
				<div>{this.state.timeRemaining.minutes}</div>
				<div>{this.state.timeRemaining.seconds}</div>
			</div>
		);
	}
}